#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
/*
 * ExcludeCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/Schemas.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

// Exclude the given servers and localities
															#line 39 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
// This generated class is to be used only via excludeServersAndLocalities()
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
template <class ExcludeServersAndLocalitiesActor>
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class ExcludeServersAndLocalitiesActorState {
															#line 45 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	ExcludeServersAndLocalitiesActorState(Reference<IDatabase> const& db,std::vector<AddressExclusion> const& servers,std::unordered_set<std::string> const& localities,bool const& failed,bool const& force) 
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		 : db(db),
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   servers(servers),
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   localities(localities),
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   failed(failed),
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   force(force),
															#line 42 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 62 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this));

	}
	~ExcludeServersAndLocalitiesActorState() 
	{
		fdb_probe_actor_destroy("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 43 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			;
															#line 77 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExcludeServersAndLocalitiesActorState();
		static_cast<ExcludeServersAndLocalitiesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 44 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 45 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 109 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		try {
															#line 47 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (force && servers.size())
															#line 113 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			{
															#line 48 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				tr->set(failed ? fdb_cli::failedForceOptionSpecialKey : fdb_cli::excludedForceOptionSpecialKey, ValueRef());
															#line 117 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			}
															#line 50 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			for( const auto& s : servers ) {
															#line 51 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				Key addr = failed ? fdb_cli::failedServersSpecialKeyRange.begin.withSuffix(s.toString()) : fdb_cli::excludedServersSpecialKeyRange.begin.withSuffix(s.toString());
															#line 53 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				tr->set(addr, ValueRef());
															#line 125 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			}
															#line 55 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (force && localities.size())
															#line 129 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			{
															#line 56 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				tr->set(failed ? fdb_cli::failedLocalityForceOptionSpecialKey : fdb_cli::excludedLocalityForceOptionSpecialKey, ValueRef());
															#line 133 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			}
															#line 59 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			for( const auto& l : localities ) {
															#line 60 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				Key addr = failed ? fdb_cli::failedLocalitySpecialKeyRange.begin.withSuffix(l) : fdb_cli::excludedLocalitySpecialKeyRange.begin.withSuffix(l);
															#line 62 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				tr->set(addr, ValueRef());
															#line 141 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			}
															#line 64 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			StrictFuture<Void> __when_expr_0 = safeThreadFutureToFuture(tr->commit());
															#line 64 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (static_cast<ExcludeServersAndLocalitiesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 147 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ExcludeServersAndLocalitiesActor*>(this)->actor_wait_state = 1;
															#line 64 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExcludeServersAndLocalitiesActor, 0, Void >*>(static_cast<ExcludeServersAndLocalitiesActor*>(this)));
															#line 152 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 67 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			err = Error(e);
															#line 68 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 176 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			{
															#line 69 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				StrictFuture<std::string> __when_expr_1 = fdb_cli::getSpecialKeysFailureErrorMessage(tr);
															#line 69 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				if (static_cast<ExcludeServersAndLocalitiesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 182 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
				static_cast<ExcludeServersAndLocalitiesActor*>(this)->actor_wait_state = 2;
															#line 69 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExcludeServersAndLocalitiesActor, 1, std::string >*>(static_cast<ExcludeServersAndLocalitiesActor*>(this)));
															#line 187 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 65 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!static_cast<ExcludeServersAndLocalitiesActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ExcludeServersAndLocalitiesActorState(); static_cast<ExcludeServersAndLocalitiesActor*>(this)->destroy(); return 0; }
															#line 207 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		new (&static_cast<ExcludeServersAndLocalitiesActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ExcludeServersAndLocalitiesActorState();
		static_cast<ExcludeServersAndLocalitiesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 65 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!static_cast<ExcludeServersAndLocalitiesActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ExcludeServersAndLocalitiesActorState(); static_cast<ExcludeServersAndLocalitiesActor*>(this)->destroy(); return 0; }
															#line 219 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		new (&static_cast<ExcludeServersAndLocalitiesActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ExcludeServersAndLocalitiesActorState();
		static_cast<ExcludeServersAndLocalitiesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExcludeServersAndLocalitiesActor*>(this)->actor_wait_state > 0) static_cast<ExcludeServersAndLocalitiesActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeServersAndLocalitiesActor*>(this)->ActorCallback< ExcludeServersAndLocalitiesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeServersAndLocalitiesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeServersAndLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExcludeServersAndLocalitiesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeServersAndLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExcludeServersAndLocalitiesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeServersAndLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 82 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		TraceEvent(SevWarn, "ExcludeServersAndLocalitiesError").error(err);
															#line 83 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(err));
															#line 83 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (static_cast<ExcludeServersAndLocalitiesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 310 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ExcludeServersAndLocalitiesActor*>(this)->actor_wait_state = 3;
															#line 83 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExcludeServersAndLocalitiesActor, 2, Void >*>(static_cast<ExcludeServersAndLocalitiesActor*>(this)));
															#line 315 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string const& errorMsgStr,int loopDepth) 
	{
															#line 71 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		auto pos = errorMsgStr.find_last_of("\n", errorMsgStr.size() - 2);
															#line 72 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		auto last_line = errorMsgStr.substr(pos + 1);
															#line 74 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		fprintf(stderr, "%s\n%s\n", errorMsgStr.substr(0, pos).c_str(), last_line.find("free space") != std::string::npos ? "Type `exclude FORCE <ADDRESS...>' to exclude without checking free space." : "Type `exclude FORCE failed <ADDRESS...>' to exclude without performing safety checks.");
															#line 80 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!static_cast<ExcludeServersAndLocalitiesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ExcludeServersAndLocalitiesActorState(); static_cast<ExcludeServersAndLocalitiesActor*>(this)->destroy(); return 0; }
															#line 330 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		new (&static_cast<ExcludeServersAndLocalitiesActor*>(this)->SAV< bool >::value()) bool(false);
		this->~ExcludeServersAndLocalitiesActorState();
		static_cast<ExcludeServersAndLocalitiesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string && errorMsgStr,int loopDepth) 
	{
															#line 71 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		auto pos = errorMsgStr.find_last_of("\n", errorMsgStr.size() - 2);
															#line 72 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		auto last_line = errorMsgStr.substr(pos + 1);
															#line 74 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		fprintf(stderr, "%s\n%s\n", errorMsgStr.substr(0, pos).c_str(), last_line.find("free space") != std::string::npos ? "Type `exclude FORCE <ADDRESS...>' to exclude without checking free space." : "Type `exclude FORCE failed <ADDRESS...>' to exclude without performing safety checks.");
															#line 80 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!static_cast<ExcludeServersAndLocalitiesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ExcludeServersAndLocalitiesActorState(); static_cast<ExcludeServersAndLocalitiesActor*>(this)->destroy(); return 0; }
															#line 348 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		new (&static_cast<ExcludeServersAndLocalitiesActor*>(this)->SAV< bool >::value()) bool(false);
		this->~ExcludeServersAndLocalitiesActorState();
		static_cast<ExcludeServersAndLocalitiesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string const& errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(errorMsgStr, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string && errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(errorMsgStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExcludeServersAndLocalitiesActor*>(this)->actor_wait_state > 0) static_cast<ExcludeServersAndLocalitiesActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeServersAndLocalitiesActor*>(this)->ActorCallback< ExcludeServersAndLocalitiesActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeServersAndLocalitiesActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeServersAndLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExcludeServersAndLocalitiesActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeServersAndLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExcludeServersAndLocalitiesActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeServersAndLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ExcludeServersAndLocalitiesActor*>(this)->actor_wait_state > 0) static_cast<ExcludeServersAndLocalitiesActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeServersAndLocalitiesActor*>(this)->ActorCallback< ExcludeServersAndLocalitiesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeServersAndLocalitiesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeServersAndLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ExcludeServersAndLocalitiesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeServersAndLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ExcludeServersAndLocalitiesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeServersAndLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::vector<AddressExclusion> servers;
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::unordered_set<std::string> localities;
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	bool failed;
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	bool force;
															#line 42 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 67 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Error err;
															#line 532 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
};
// This generated class is to be used only via excludeServersAndLocalities()
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class ExcludeServersAndLocalitiesActor final : public Actor<bool>, public ActorCallback< ExcludeServersAndLocalitiesActor, 0, Void >, public ActorCallback< ExcludeServersAndLocalitiesActor, 1, std::string >, public ActorCallback< ExcludeServersAndLocalitiesActor, 2, Void >, public FastAllocated<ExcludeServersAndLocalitiesActor>, public ExcludeServersAndLocalitiesActorState<ExcludeServersAndLocalitiesActor> {
															#line 537 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
	using FastAllocated<ExcludeServersAndLocalitiesActor>::operator new;
	using FastAllocated<ExcludeServersAndLocalitiesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5442764108704248576UL, 4453666433806855168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExcludeServersAndLocalitiesActor, 0, Void >;
friend struct ActorCallback< ExcludeServersAndLocalitiesActor, 1, std::string >;
friend struct ActorCallback< ExcludeServersAndLocalitiesActor, 2, Void >;
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	ExcludeServersAndLocalitiesActor(Reference<IDatabase> const& db,std::vector<AddressExclusion> const& servers,std::unordered_set<std::string> const& localities,bool const& failed,bool const& force) 
															#line 556 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		 : Actor<bool>(),
		   ExcludeServersAndLocalitiesActorState<ExcludeServersAndLocalitiesActor>(db, servers, localities, failed, force),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4550738853021697280UL, 9508866287304984576UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeServersAndLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("excludeServersAndLocalities");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("excludeServersAndLocalities", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExcludeServersAndLocalitiesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExcludeServersAndLocalitiesActor, 1, std::string >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ExcludeServersAndLocalitiesActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
[[nodiscard]] Future<bool> excludeServersAndLocalities( Reference<IDatabase> const& db, std::vector<AddressExclusion> const& servers, std::unordered_set<std::string> const& localities, bool const& failed, bool const& force ) {
															#line 37 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	return Future<bool>(new ExcludeServersAndLocalitiesActor(db, servers, localities, failed, force));
															#line 590 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
}

#line 87 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"

															#line 595 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
// This generated class is to be used only via getExcludedServers()
															#line 88 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
template <class GetExcludedServersActor>
															#line 88 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class GetExcludedServersActorState {
															#line 601 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
															#line 88 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	GetExcludedServersActorState(Reference<IDatabase> const& db) 
															#line 88 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
															#line 88 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		 : db(db),
															#line 89 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 610 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("getExcludedServers", reinterpret_cast<unsigned long>(this));

	}
	~GetExcludedServersActorState() 
	{
		fdb_probe_actor_destroy("getExcludedServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 90 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			;
															#line 625 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetExcludedServersActorState();
		static_cast<GetExcludedServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 92 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			resultFuture = tr->getRange(fdb_cli::excludedServersSpecialKeyRange, CLIENT_KNOBS->TOO_MANY);
															#line 94 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = safeThreadFutureToFuture(resultFuture);
															#line 94 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (static_cast<GetExcludedServersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 660 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetExcludedServersActor*>(this)->actor_wait_state = 1;
															#line 94 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetExcludedServersActor, 0, RangeResult >*>(static_cast<GetExcludedServersActor*>(this)));
															#line 665 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 104 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			TraceEvent(SevWarn, "GetExcludedServersError").error(e);
															#line 105 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 105 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (static_cast<GetExcludedServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 691 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetExcludedServersActor*>(this)->actor_wait_state = 2;
															#line 105 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetExcludedServersActor, 1, Void >*>(static_cast<GetExcludedServersActor*>(this)));
															#line 696 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 95 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		ASSERT(!r.more && r.size() < CLIENT_KNOBS->TOO_MANY);
															#line 97 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		std::vector<std::string> exclusions;
															#line 98 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& i : r ) {
															#line 99 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			auto addr = i.key.removePrefix(fdb_cli::excludedServersSpecialKeyRange.begin).toString();
															#line 100 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			exclusions.push_back(addr);
															#line 719 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 102 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!static_cast<GetExcludedServersActor*>(this)->SAV<std::vector<std::string>>::futures) { (void)(exclusions); this->~GetExcludedServersActorState(); static_cast<GetExcludedServersActor*>(this)->destroy(); return 0; }
															#line 723 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		new (&static_cast<GetExcludedServersActor*>(this)->SAV< std::vector<std::string> >::value()) std::vector<std::string>(exclusions);
		this->~GetExcludedServersActorState();
		static_cast<GetExcludedServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __r,int loopDepth) 
	{
															#line 94 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		r = __r;
															#line 735 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __r,int loopDepth) 
	{
		r = std::move(__r);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetExcludedServersActor*>(this)->actor_wait_state > 0) static_cast<GetExcludedServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetExcludedServersActor*>(this)->ActorCallback< GetExcludedServersActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetExcludedServersActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getExcludedServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExcludedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExcludedServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetExcludedServersActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getExcludedServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExcludedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExcludedServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetExcludedServersActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getExcludedServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExcludedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExcludedServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetExcludedServersActor*>(this)->actor_wait_state > 0) static_cast<GetExcludedServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetExcludedServersActor*>(this)->ActorCallback< GetExcludedServersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetExcludedServersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getExcludedServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExcludedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExcludedServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetExcludedServersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getExcludedServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExcludedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExcludedServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetExcludedServersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getExcludedServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExcludedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExcludedServers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 88 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 89 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 92 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	ThreadFuture<RangeResult> resultFuture;
															#line 94 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	RangeResult r;
															#line 905 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
};
// This generated class is to be used only via getExcludedServers()
															#line 88 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class GetExcludedServersActor final : public Actor<std::vector<std::string>>, public ActorCallback< GetExcludedServersActor, 0, RangeResult >, public ActorCallback< GetExcludedServersActor, 1, Void >, public FastAllocated<GetExcludedServersActor>, public GetExcludedServersActorState<GetExcludedServersActor> {
															#line 910 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
	using FastAllocated<GetExcludedServersActor>::operator new;
	using FastAllocated<GetExcludedServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12527454122057192192UL, 17151195706172537856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetExcludedServersActor, 0, RangeResult >;
friend struct ActorCallback< GetExcludedServersActor, 1, Void >;
															#line 88 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	GetExcludedServersActor(Reference<IDatabase> const& db) 
															#line 928 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		 : Actor<std::vector<std::string>>(),
		   GetExcludedServersActorState<GetExcludedServersActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getExcludedServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4955736637218838784UL, 3317911351871765760UL);
		ActorExecutionContextHelper __helper(static_cast<GetExcludedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getExcludedServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getExcludedServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetExcludedServersActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetExcludedServersActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 88 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
[[nodiscard]] Future<std::vector<std::string>> getExcludedServers( Reference<IDatabase> const& db ) {
															#line 88 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	return Future<std::vector<std::string>>(new GetExcludedServersActor(db));
															#line 961 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
}

#line 109 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"

// Get the list of excluded localities by reading the keys.
															#line 967 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
// This generated class is to be used only via getExcludedLocalities()
															#line 111 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
template <class GetExcludedLocalitiesActor>
															#line 111 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class GetExcludedLocalitiesActorState {
															#line 973 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
															#line 111 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	GetExcludedLocalitiesActorState(Reference<IDatabase> const& db) 
															#line 111 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
															#line 111 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		 : db(db),
															#line 112 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 982 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("getExcludedLocalities", reinterpret_cast<unsigned long>(this));

	}
	~GetExcludedLocalitiesActorState() 
	{
		fdb_probe_actor_destroy("getExcludedLocalities", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 113 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			;
															#line 997 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetExcludedLocalitiesActorState();
		static_cast<GetExcludedLocalitiesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 115 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			resultFuture = tr->getRange(fdb_cli::excludedLocalitySpecialKeyRange, CLIENT_KNOBS->TOO_MANY);
															#line 117 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = safeThreadFutureToFuture(resultFuture);
															#line 117 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (static_cast<GetExcludedLocalitiesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1032 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetExcludedLocalitiesActor*>(this)->actor_wait_state = 1;
															#line 117 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetExcludedLocalitiesActor, 0, RangeResult >*>(static_cast<GetExcludedLocalitiesActor*>(this)));
															#line 1037 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 127 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 127 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (static_cast<GetExcludedLocalitiesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1061 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetExcludedLocalitiesActor*>(this)->actor_wait_state = 2;
															#line 127 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetExcludedLocalitiesActor, 1, Void >*>(static_cast<GetExcludedLocalitiesActor*>(this)));
															#line 1066 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 118 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		ASSERT(!r.more && r.size() < CLIENT_KNOBS->TOO_MANY);
															#line 120 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		std::vector<std::string> excludedLocalities;
															#line 121 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& i : r ) {
															#line 122 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			auto locality = i.key.removePrefix(fdb_cli::excludedLocalitySpecialKeyRange.begin).toString();
															#line 123 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			excludedLocalities.push_back(locality);
															#line 1089 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 125 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!static_cast<GetExcludedLocalitiesActor*>(this)->SAV<std::vector<std::string>>::futures) { (void)(excludedLocalities); this->~GetExcludedLocalitiesActorState(); static_cast<GetExcludedLocalitiesActor*>(this)->destroy(); return 0; }
															#line 1093 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		new (&static_cast<GetExcludedLocalitiesActor*>(this)->SAV< std::vector<std::string> >::value()) std::vector<std::string>(excludedLocalities);
		this->~GetExcludedLocalitiesActorState();
		static_cast<GetExcludedLocalitiesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __r,int loopDepth) 
	{
															#line 117 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		r = __r;
															#line 1105 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __r,int loopDepth) 
	{
		r = std::move(__r);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetExcludedLocalitiesActor*>(this)->actor_wait_state > 0) static_cast<GetExcludedLocalitiesActor*>(this)->actor_wait_state = 0;
		static_cast<GetExcludedLocalitiesActor*>(this)->ActorCallback< GetExcludedLocalitiesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetExcludedLocalitiesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getExcludedLocalities", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExcludedLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExcludedLocalities", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetExcludedLocalitiesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getExcludedLocalities", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExcludedLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExcludedLocalities", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetExcludedLocalitiesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getExcludedLocalities", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExcludedLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExcludedLocalities", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetExcludedLocalitiesActor*>(this)->actor_wait_state > 0) static_cast<GetExcludedLocalitiesActor*>(this)->actor_wait_state = 0;
		static_cast<GetExcludedLocalitiesActor*>(this)->ActorCallback< GetExcludedLocalitiesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetExcludedLocalitiesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getExcludedLocalities", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExcludedLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExcludedLocalities", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetExcludedLocalitiesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getExcludedLocalities", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExcludedLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExcludedLocalities", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetExcludedLocalitiesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getExcludedLocalities", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExcludedLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExcludedLocalities", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 111 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 112 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 115 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	ThreadFuture<RangeResult> resultFuture;
															#line 117 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	RangeResult r;
															#line 1275 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
};
// This generated class is to be used only via getExcludedLocalities()
															#line 111 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class GetExcludedLocalitiesActor final : public Actor<std::vector<std::string>>, public ActorCallback< GetExcludedLocalitiesActor, 0, RangeResult >, public ActorCallback< GetExcludedLocalitiesActor, 1, Void >, public FastAllocated<GetExcludedLocalitiesActor>, public GetExcludedLocalitiesActorState<GetExcludedLocalitiesActor> {
															#line 1280 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
	using FastAllocated<GetExcludedLocalitiesActor>::operator new;
	using FastAllocated<GetExcludedLocalitiesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13525972994661658112UL, 1670991036534879232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetExcludedLocalitiesActor, 0, RangeResult >;
friend struct ActorCallback< GetExcludedLocalitiesActor, 1, Void >;
															#line 111 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	GetExcludedLocalitiesActor(Reference<IDatabase> const& db) 
															#line 1298 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		 : Actor<std::vector<std::string>>(),
		   GetExcludedLocalitiesActorState<GetExcludedLocalitiesActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getExcludedLocalities", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4273477543744856320UL, 14057996097040040192UL);
		ActorExecutionContextHelper __helper(static_cast<GetExcludedLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getExcludedLocalities");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getExcludedLocalities", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetExcludedLocalitiesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetExcludedLocalitiesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 111 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
[[nodiscard]] Future<std::vector<std::string>> getExcludedLocalities( Reference<IDatabase> const& db ) {
															#line 111 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	return Future<std::vector<std::string>>(new GetExcludedLocalitiesActor(db));
															#line 1331 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
}

#line 131 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"

															#line 1336 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
// This generated class is to be used only via getFailedServers()
															#line 132 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
template <class GetFailedServersActor>
															#line 132 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class GetFailedServersActorState {
															#line 1342 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
															#line 132 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	GetFailedServersActorState(Reference<IDatabase> const& db) 
															#line 132 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
															#line 132 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		 : db(db),
															#line 133 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 1351 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("getFailedServers", reinterpret_cast<unsigned long>(this));

	}
	~GetFailedServersActorState() 
	{
		fdb_probe_actor_destroy("getFailedServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 134 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			;
															#line 1366 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetFailedServersActorState();
		static_cast<GetFailedServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			resultFuture = tr->getRange(fdb_cli::failedServersSpecialKeyRange, CLIENT_KNOBS->TOO_MANY);
															#line 138 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = safeThreadFutureToFuture(resultFuture);
															#line 138 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (static_cast<GetFailedServersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1401 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetFailedServersActor*>(this)->actor_wait_state = 1;
															#line 138 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetFailedServersActor, 0, RangeResult >*>(static_cast<GetFailedServersActor*>(this)));
															#line 1406 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 148 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 148 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (static_cast<GetFailedServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1430 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetFailedServersActor*>(this)->actor_wait_state = 2;
															#line 148 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetFailedServersActor, 1, Void >*>(static_cast<GetFailedServersActor*>(this)));
															#line 1435 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 139 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		ASSERT(!r.more && r.size() < CLIENT_KNOBS->TOO_MANY);
															#line 141 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		std::vector<std::string> exclusions;
															#line 142 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& i : r ) {
															#line 143 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			auto addr = i.key.removePrefix(fdb_cli::failedServersSpecialKeyRange.begin).toString();
															#line 144 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			exclusions.push_back(addr);
															#line 1458 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 146 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!static_cast<GetFailedServersActor*>(this)->SAV<std::vector<std::string>>::futures) { (void)(exclusions); this->~GetFailedServersActorState(); static_cast<GetFailedServersActor*>(this)->destroy(); return 0; }
															#line 1462 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		new (&static_cast<GetFailedServersActor*>(this)->SAV< std::vector<std::string> >::value()) std::vector<std::string>(exclusions);
		this->~GetFailedServersActorState();
		static_cast<GetFailedServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __r,int loopDepth) 
	{
															#line 138 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		r = __r;
															#line 1474 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __r,int loopDepth) 
	{
		r = std::move(__r);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetFailedServersActor*>(this)->actor_wait_state > 0) static_cast<GetFailedServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetFailedServersActor*>(this)->ActorCallback< GetFailedServersActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetFailedServersActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getFailedServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetFailedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFailedServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetFailedServersActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getFailedServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetFailedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFailedServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetFailedServersActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getFailedServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetFailedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFailedServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetFailedServersActor*>(this)->actor_wait_state > 0) static_cast<GetFailedServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetFailedServersActor*>(this)->ActorCallback< GetFailedServersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetFailedServersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getFailedServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetFailedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFailedServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetFailedServersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getFailedServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetFailedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFailedServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetFailedServersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getFailedServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetFailedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFailedServers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 132 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 133 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 136 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	ThreadFuture<RangeResult> resultFuture;
															#line 138 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	RangeResult r;
															#line 1644 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
};
// This generated class is to be used only via getFailedServers()
															#line 132 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class GetFailedServersActor final : public Actor<std::vector<std::string>>, public ActorCallback< GetFailedServersActor, 0, RangeResult >, public ActorCallback< GetFailedServersActor, 1, Void >, public FastAllocated<GetFailedServersActor>, public GetFailedServersActorState<GetFailedServersActor> {
															#line 1649 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
	using FastAllocated<GetFailedServersActor>::operator new;
	using FastAllocated<GetFailedServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14851992592021102848UL, 5515859601130570496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetFailedServersActor, 0, RangeResult >;
friend struct ActorCallback< GetFailedServersActor, 1, Void >;
															#line 132 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	GetFailedServersActor(Reference<IDatabase> const& db) 
															#line 1667 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		 : Actor<std::vector<std::string>>(),
		   GetFailedServersActorState<GetFailedServersActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getFailedServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3627330052239129600UL, 15517499292827624960UL);
		ActorExecutionContextHelper __helper(static_cast<GetFailedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getFailedServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getFailedServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetFailedServersActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetFailedServersActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 132 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
[[nodiscard]] Future<std::vector<std::string>> getFailedServers( Reference<IDatabase> const& db ) {
															#line 132 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	return Future<std::vector<std::string>>(new GetFailedServersActor(db));
															#line 1700 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
}

#line 152 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"

// Get the list of failed localities by reading the keys.
															#line 1706 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
// This generated class is to be used only via getFailedLocalities()
															#line 154 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
template <class GetFailedLocalitiesActor>
															#line 154 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class GetFailedLocalitiesActorState {
															#line 1712 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
															#line 154 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	GetFailedLocalitiesActorState(Reference<IDatabase> const& db) 
															#line 154 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
															#line 154 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		 : db(db),
															#line 155 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 1721 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("getFailedLocalities", reinterpret_cast<unsigned long>(this));

	}
	~GetFailedLocalitiesActorState() 
	{
		fdb_probe_actor_destroy("getFailedLocalities", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 156 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			;
															#line 1736 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetFailedLocalitiesActorState();
		static_cast<GetFailedLocalitiesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 158 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			resultFuture = tr->getRange(fdb_cli::failedLocalitySpecialKeyRange, CLIENT_KNOBS->TOO_MANY);
															#line 160 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = safeThreadFutureToFuture(resultFuture);
															#line 160 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (static_cast<GetFailedLocalitiesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1771 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetFailedLocalitiesActor*>(this)->actor_wait_state = 1;
															#line 160 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetFailedLocalitiesActor, 0, RangeResult >*>(static_cast<GetFailedLocalitiesActor*>(this)));
															#line 1776 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 170 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			TraceEvent(SevWarn, "GetExcludedLocalitiesError").error(e);
															#line 171 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 171 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (static_cast<GetFailedLocalitiesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1802 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetFailedLocalitiesActor*>(this)->actor_wait_state = 2;
															#line 171 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetFailedLocalitiesActor, 1, Void >*>(static_cast<GetFailedLocalitiesActor*>(this)));
															#line 1807 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 161 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		ASSERT(!r.more && r.size() < CLIENT_KNOBS->TOO_MANY);
															#line 163 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		std::vector<std::string> excludedLocalities;
															#line 164 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& i : r ) {
															#line 165 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			auto locality = i.key.removePrefix(fdb_cli::failedLocalitySpecialKeyRange.begin).toString();
															#line 166 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			excludedLocalities.push_back(locality);
															#line 1830 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 168 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!static_cast<GetFailedLocalitiesActor*>(this)->SAV<std::vector<std::string>>::futures) { (void)(excludedLocalities); this->~GetFailedLocalitiesActorState(); static_cast<GetFailedLocalitiesActor*>(this)->destroy(); return 0; }
															#line 1834 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		new (&static_cast<GetFailedLocalitiesActor*>(this)->SAV< std::vector<std::string> >::value()) std::vector<std::string>(excludedLocalities);
		this->~GetFailedLocalitiesActorState();
		static_cast<GetFailedLocalitiesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __r,int loopDepth) 
	{
															#line 160 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		r = __r;
															#line 1846 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __r,int loopDepth) 
	{
		r = std::move(__r);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetFailedLocalitiesActor*>(this)->actor_wait_state > 0) static_cast<GetFailedLocalitiesActor*>(this)->actor_wait_state = 0;
		static_cast<GetFailedLocalitiesActor*>(this)->ActorCallback< GetFailedLocalitiesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetFailedLocalitiesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getFailedLocalities", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetFailedLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFailedLocalities", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetFailedLocalitiesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getFailedLocalities", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetFailedLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFailedLocalities", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetFailedLocalitiesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getFailedLocalities", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetFailedLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFailedLocalities", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetFailedLocalitiesActor*>(this)->actor_wait_state > 0) static_cast<GetFailedLocalitiesActor*>(this)->actor_wait_state = 0;
		static_cast<GetFailedLocalitiesActor*>(this)->ActorCallback< GetFailedLocalitiesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetFailedLocalitiesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getFailedLocalities", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetFailedLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFailedLocalities", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetFailedLocalitiesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getFailedLocalities", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetFailedLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFailedLocalities", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetFailedLocalitiesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getFailedLocalities", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetFailedLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFailedLocalities", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 154 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 155 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 158 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	ThreadFuture<RangeResult> resultFuture;
															#line 160 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	RangeResult r;
															#line 2016 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
};
// This generated class is to be used only via getFailedLocalities()
															#line 154 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class GetFailedLocalitiesActor final : public Actor<std::vector<std::string>>, public ActorCallback< GetFailedLocalitiesActor, 0, RangeResult >, public ActorCallback< GetFailedLocalitiesActor, 1, Void >, public FastAllocated<GetFailedLocalitiesActor>, public GetFailedLocalitiesActorState<GetFailedLocalitiesActor> {
															#line 2021 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
	using FastAllocated<GetFailedLocalitiesActor>::operator new;
	using FastAllocated<GetFailedLocalitiesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3238115619509969664UL, 14231686897241456128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetFailedLocalitiesActor, 0, RangeResult >;
friend struct ActorCallback< GetFailedLocalitiesActor, 1, Void >;
															#line 154 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	GetFailedLocalitiesActor(Reference<IDatabase> const& db) 
															#line 2039 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		 : Actor<std::vector<std::string>>(),
		   GetFailedLocalitiesActorState<GetFailedLocalitiesActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getFailedLocalities", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2550902935293693184UL, 3888130237263260416UL);
		ActorExecutionContextHelper __helper(static_cast<GetFailedLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getFailedLocalities");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getFailedLocalities", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetFailedLocalitiesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetFailedLocalitiesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 154 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
[[nodiscard]] Future<std::vector<std::string>> getFailedLocalities( Reference<IDatabase> const& db ) {
															#line 154 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	return Future<std::vector<std::string>>(new GetFailedLocalitiesActor(db));
															#line 2072 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
}

#line 175 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"

															#line 2077 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
// This generated class is to be used only via getInProgressExclusion()
															#line 176 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
template <class GetInProgressExclusionActor>
															#line 176 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class GetInProgressExclusionActorState {
															#line 2083 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
															#line 176 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	GetInProgressExclusionActorState(Reference<ITransaction> const& tr) 
															#line 176 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
															#line 176 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		 : tr(tr)
															#line 2090 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("getInProgressExclusion", reinterpret_cast<unsigned long>(this));

	}
	~GetInProgressExclusionActorState() 
	{
		fdb_probe_actor_destroy("getInProgressExclusion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 177 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			ThreadFuture<RangeResult> resultFuture = tr->getRange(fdb_cli::exclusionInProgressSpecialKeyRange, CLIENT_KNOBS->TOO_MANY);
															#line 179 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = safeThreadFutureToFuture(resultFuture);
															#line 179 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (static_cast<GetInProgressExclusionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2109 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetInProgressExclusionActor*>(this)->actor_wait_state = 1;
															#line 179 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetInProgressExclusionActor, 0, RangeResult >*>(static_cast<GetInProgressExclusionActor*>(this)));
															#line 2114 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetInProgressExclusionActorState();
		static_cast<GetInProgressExclusionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& result,int loopDepth) 
	{
															#line 180 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		ASSERT(!result.more && result.size() < CLIENT_KNOBS->TOO_MANY);
															#line 181 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		std::set<NetworkAddress> inProgressExclusion;
															#line 182 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& addr : result ) {
															#line 183 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			inProgressExclusion.insert( NetworkAddress::parse(addr.key.removePrefix(fdb_cli::exclusionInProgressSpecialKeyRange.begin).toString()));
															#line 2143 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 186 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!static_cast<GetInProgressExclusionActor*>(this)->SAV<std::set<NetworkAddress>>::futures) { (void)(inProgressExclusion); this->~GetInProgressExclusionActorState(); static_cast<GetInProgressExclusionActor*>(this)->destroy(); return 0; }
															#line 2147 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		new (&static_cast<GetInProgressExclusionActor*>(this)->SAV< std::set<NetworkAddress> >::value()) std::set<NetworkAddress>(inProgressExclusion);
		this->~GetInProgressExclusionActorState();
		static_cast<GetInProgressExclusionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && result,int loopDepth) 
	{
															#line 180 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		ASSERT(!result.more && result.size() < CLIENT_KNOBS->TOO_MANY);
															#line 181 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		std::set<NetworkAddress> inProgressExclusion;
															#line 182 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& addr : result ) {
															#line 183 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			inProgressExclusion.insert( NetworkAddress::parse(addr.key.removePrefix(fdb_cli::exclusionInProgressSpecialKeyRange.begin).toString()));
															#line 2165 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 186 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!static_cast<GetInProgressExclusionActor*>(this)->SAV<std::set<NetworkAddress>>::futures) { (void)(inProgressExclusion); this->~GetInProgressExclusionActorState(); static_cast<GetInProgressExclusionActor*>(this)->destroy(); return 0; }
															#line 2169 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		new (&static_cast<GetInProgressExclusionActor*>(this)->SAV< std::set<NetworkAddress> >::value()) std::set<NetworkAddress>(inProgressExclusion);
		this->~GetInProgressExclusionActorState();
		static_cast<GetInProgressExclusionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetInProgressExclusionActor*>(this)->actor_wait_state > 0) static_cast<GetInProgressExclusionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInProgressExclusionActor*>(this)->ActorCallback< GetInProgressExclusionActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetInProgressExclusionActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getInProgressExclusion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInProgressExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInProgressExclusion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetInProgressExclusionActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getInProgressExclusion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInProgressExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInProgressExclusion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetInProgressExclusionActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getInProgressExclusion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInProgressExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInProgressExclusion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 176 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 2254 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
};
// This generated class is to be used only via getInProgressExclusion()
															#line 176 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class GetInProgressExclusionActor final : public Actor<std::set<NetworkAddress>>, public ActorCallback< GetInProgressExclusionActor, 0, RangeResult >, public FastAllocated<GetInProgressExclusionActor>, public GetInProgressExclusionActorState<GetInProgressExclusionActor> {
															#line 2259 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
	using FastAllocated<GetInProgressExclusionActor>::operator new;
	using FastAllocated<GetInProgressExclusionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1754550700172800256UL, 8583337651746790912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::set<NetworkAddress>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetInProgressExclusionActor, 0, RangeResult >;
															#line 176 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	GetInProgressExclusionActor(Reference<ITransaction> const& tr) 
															#line 2276 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		 : Actor<std::set<NetworkAddress>>(),
		   GetInProgressExclusionActorState<GetInProgressExclusionActor>(tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getInProgressExclusion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1591254333694148352UL, 17369914885832344064UL);
		ActorExecutionContextHelper __helper(static_cast<GetInProgressExclusionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getInProgressExclusion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getInProgressExclusion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetInProgressExclusionActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 176 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
[[nodiscard]] Future<std::set<NetworkAddress>> getInProgressExclusion( Reference<ITransaction> const& tr ) {
															#line 176 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	return Future<std::set<NetworkAddress>>(new GetInProgressExclusionActor(tr));
															#line 2308 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
}

#line 188 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"

															#line 2313 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
// This generated class is to be used only via checkForExcludingServers()
															#line 189 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
template <class CheckForExcludingServersActor>
															#line 189 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class CheckForExcludingServersActorState {
															#line 2319 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
															#line 189 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	CheckForExcludingServersActorState(Reference<IDatabase> const& db,std::set<AddressExclusion> const& exclusions,bool const& waitForAllExcluded) 
															#line 189 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
															#line 189 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		 : db(db),
															#line 189 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   exclusions(exclusions),
															#line 189 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   waitForAllExcluded(waitForAllExcluded),
															#line 192 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   inProgressExclusion(),
															#line 193 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 2334 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("checkForExcludingServers", reinterpret_cast<unsigned long>(this));

	}
	~CheckForExcludingServersActorState() 
	{
		fdb_probe_actor_destroy("checkForExcludingServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 194 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 195 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 196 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			;
															#line 2353 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckForExcludingServersActorState();
		static_cast<CheckForExcludingServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 234 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!static_cast<CheckForExcludingServersActor*>(this)->SAV<std::set<NetworkAddress>>::futures) { (void)(inProgressExclusion); this->~CheckForExcludingServersActorState(); static_cast<CheckForExcludingServersActor*>(this)->destroy(); return 0; }
															#line 2376 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		new (&static_cast<CheckForExcludingServersActor*>(this)->SAV< std::set<NetworkAddress> >::value()) std::set<NetworkAddress>(std::move(inProgressExclusion)); // state_var_RVO
		this->~CheckForExcludingServersActorState();
		static_cast<CheckForExcludingServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 197 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		inProgressExclusion.clear();
															#line 2395 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		try {
															#line 199 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			StrictFuture<std::set<NetworkAddress>> __when_expr_0 = getInProgressExclusion(tr);
															#line 199 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (static_cast<CheckForExcludingServersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2401 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckForExcludingServersActor*>(this)->actor_wait_state = 1;
															#line 199 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckForExcludingServersActor, 0, std::set<NetworkAddress> >*>(static_cast<CheckForExcludingServersActor*>(this)));
															#line 2406 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 230 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			TraceEvent(SevWarn, "CheckForExcludingServersError").error(e);
															#line 231 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 231 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (static_cast<CheckForExcludingServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2445 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckForExcludingServersActor*>(this)->actor_wait_state = 3;
															#line 231 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckForExcludingServersActor, 2, Void >*>(static_cast<CheckForExcludingServersActor*>(this)));
															#line 2450 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::set<NetworkAddress> const& result,int loopDepth) 
	{
															#line 200 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (result.empty())
															#line 2465 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
															#line 201 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (!static_cast<CheckForExcludingServersActor*>(this)->SAV<std::set<NetworkAddress>>::futures) { (void)(inProgressExclusion); this->~CheckForExcludingServersActorState(); static_cast<CheckForExcludingServersActor*>(this)->destroy(); return 0; }
															#line 2469 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			new (&static_cast<CheckForExcludingServersActor*>(this)->SAV< std::set<NetworkAddress> >::value()) std::set<NetworkAddress>(std::move(inProgressExclusion)); // state_var_RVO
			this->~CheckForExcludingServersActorState();
			static_cast<CheckForExcludingServersActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 202 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		inProgressExclusion = result;
															#line 205 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		bool allExcluded = true;
															#line 206 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& inProgressAddr : inProgressExclusion ) {
															#line 207 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (!allExcluded)
															#line 2483 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			{
				break;
			}
															#line 211 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			for( const auto& exclusion : exclusions ) {
															#line 213 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				if (exclusion.excludes(inProgressAddr))
															#line 2491 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				{
															#line 214 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
					allExcluded = false;
															#line 2495 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
					break;
				}
			}
		}
															#line 220 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (allExcluded)
															#line 2502 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
															#line 221 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			inProgressExclusion.clear();
															#line 222 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (!static_cast<CheckForExcludingServersActor*>(this)->SAV<std::set<NetworkAddress>>::futures) { (void)(inProgressExclusion); this->~CheckForExcludingServersActorState(); static_cast<CheckForExcludingServersActor*>(this)->destroy(); return 0; }
															#line 2508 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			new (&static_cast<CheckForExcludingServersActor*>(this)->SAV< std::set<NetworkAddress> >::value()) std::set<NetworkAddress>(std::move(inProgressExclusion)); // state_var_RVO
			this->~CheckForExcludingServersActorState();
			static_cast<CheckForExcludingServersActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 225 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!waitForAllExcluded)
															#line 2516 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 228 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(1.0);
															#line 228 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (static_cast<CheckForExcludingServersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2524 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckForExcludingServersActor*>(this)->actor_wait_state = 2;
															#line 228 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckForExcludingServersActor, 1, Void >*>(static_cast<CheckForExcludingServersActor*>(this)));
															#line 2529 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::set<NetworkAddress> && result,int loopDepth) 
	{
															#line 200 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (result.empty())
															#line 2538 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
															#line 201 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (!static_cast<CheckForExcludingServersActor*>(this)->SAV<std::set<NetworkAddress>>::futures) { (void)(inProgressExclusion); this->~CheckForExcludingServersActorState(); static_cast<CheckForExcludingServersActor*>(this)->destroy(); return 0; }
															#line 2542 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			new (&static_cast<CheckForExcludingServersActor*>(this)->SAV< std::set<NetworkAddress> >::value()) std::set<NetworkAddress>(std::move(inProgressExclusion)); // state_var_RVO
			this->~CheckForExcludingServersActorState();
			static_cast<CheckForExcludingServersActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 202 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		inProgressExclusion = result;
															#line 205 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		bool allExcluded = true;
															#line 206 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& inProgressAddr : inProgressExclusion ) {
															#line 207 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (!allExcluded)
															#line 2556 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			{
				break;
			}
															#line 211 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			for( const auto& exclusion : exclusions ) {
															#line 213 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				if (exclusion.excludes(inProgressAddr))
															#line 2564 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				{
															#line 214 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
					allExcluded = false;
															#line 2568 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
					break;
				}
			}
		}
															#line 220 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (allExcluded)
															#line 2575 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
															#line 221 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			inProgressExclusion.clear();
															#line 222 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (!static_cast<CheckForExcludingServersActor*>(this)->SAV<std::set<NetworkAddress>>::futures) { (void)(inProgressExclusion); this->~CheckForExcludingServersActorState(); static_cast<CheckForExcludingServersActor*>(this)->destroy(); return 0; }
															#line 2581 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			new (&static_cast<CheckForExcludingServersActor*>(this)->SAV< std::set<NetworkAddress> >::value()) std::set<NetworkAddress>(std::move(inProgressExclusion)); // state_var_RVO
			this->~CheckForExcludingServersActorState();
			static_cast<CheckForExcludingServersActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 225 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!waitForAllExcluded)
															#line 2589 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 228 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(1.0);
															#line 228 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (static_cast<CheckForExcludingServersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2597 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckForExcludingServersActor*>(this)->actor_wait_state = 2;
															#line 228 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckForExcludingServersActor, 1, Void >*>(static_cast<CheckForExcludingServersActor*>(this)));
															#line 2602 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::set<NetworkAddress> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::set<NetworkAddress> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckForExcludingServersActor*>(this)->actor_wait_state > 0) static_cast<CheckForExcludingServersActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExcludingServersActor*>(this)->ActorCallback< CheckForExcludingServersActor, 0, std::set<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExcludingServersActor, 0, std::set<NetworkAddress> >*,std::set<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExcludingServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckForExcludingServersActor, 0, std::set<NetworkAddress> >*,std::set<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExcludingServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckForExcludingServersActor, 0, std::set<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExcludingServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckForExcludingServersActor*>(this)->actor_wait_state > 0) static_cast<CheckForExcludingServersActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExcludingServersActor*>(this)->ActorCallback< CheckForExcludingServersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExcludingServersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExcludingServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckForExcludingServersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExcludingServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckForExcludingServersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExcludingServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckForExcludingServersActor*>(this)->actor_wait_state > 0) static_cast<CheckForExcludingServersActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExcludingServersActor*>(this)->ActorCallback< CheckForExcludingServersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExcludingServersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExcludingServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckForExcludingServersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExcludingServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckForExcludingServersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExcludingServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExcludingServers", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 189 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 189 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::set<AddressExclusion> exclusions;
															#line 189 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	bool waitForAllExcluded;
															#line 192 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::set<NetworkAddress> inProgressExclusion;
															#line 193 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 2879 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
};
// This generated class is to be used only via checkForExcludingServers()
															#line 189 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class CheckForExcludingServersActor final : public Actor<std::set<NetworkAddress>>, public ActorCallback< CheckForExcludingServersActor, 0, std::set<NetworkAddress> >, public ActorCallback< CheckForExcludingServersActor, 1, Void >, public ActorCallback< CheckForExcludingServersActor, 2, Void >, public FastAllocated<CheckForExcludingServersActor>, public CheckForExcludingServersActorState<CheckForExcludingServersActor> {
															#line 2884 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
	using FastAllocated<CheckForExcludingServersActor>::operator new;
	using FastAllocated<CheckForExcludingServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17630110806338344192UL, 9316935760809797888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::set<NetworkAddress>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckForExcludingServersActor, 0, std::set<NetworkAddress> >;
friend struct ActorCallback< CheckForExcludingServersActor, 1, Void >;
friend struct ActorCallback< CheckForExcludingServersActor, 2, Void >;
															#line 189 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	CheckForExcludingServersActor(Reference<IDatabase> const& db,std::set<AddressExclusion> const& exclusions,bool const& waitForAllExcluded) 
															#line 2903 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		 : Actor<std::set<NetworkAddress>>(),
		   CheckForExcludingServersActorState<CheckForExcludingServersActor>(db, exclusions, waitForAllExcluded),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkForExcludingServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6376532781582041856UL, 15345192279576478720UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExcludingServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkForExcludingServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkForExcludingServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckForExcludingServersActor, 0, std::set<NetworkAddress> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckForExcludingServersActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckForExcludingServersActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 189 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
[[nodiscard]] Future<std::set<NetworkAddress>> checkForExcludingServers( Reference<IDatabase> const& db, std::set<AddressExclusion> const& exclusions, bool const& waitForAllExcluded ) {
															#line 189 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	return Future<std::set<NetworkAddress>>(new CheckForExcludingServersActor(db, exclusions, waitForAllExcluded));
															#line 2937 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
}

#line 236 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"

															#line 2942 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
// This generated class is to be used only via checkForCoordinators()
															#line 237 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
template <class CheckForCoordinatorsActor>
															#line 237 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class CheckForCoordinatorsActorState {
															#line 2948 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
															#line 237 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	CheckForCoordinatorsActorState(Reference<IDatabase> const& db,std::set<AddressExclusion> const& exclusions) 
															#line 237 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
															#line 237 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		 : db(db),
															#line 237 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   exclusions(exclusions),
															#line 239 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   foundCoordinator(false),
															#line 240 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   coordinatorList(),
															#line 241 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 2963 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("checkForCoordinators", reinterpret_cast<unsigned long>(this));

	}
	~CheckForCoordinatorsActorState() 
	{
		fdb_probe_actor_destroy("checkForCoordinators", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 242 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			;
															#line 2978 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckForCoordinatorsActorState();
		static_cast<CheckForCoordinatorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 256 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& c : coordinatorList ) {
															#line 257 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (exclusions.find(AddressExclusion(c.ip, c.port)) != exclusions.end() || exclusions.find(AddressExclusion(c.ip)) != exclusions.end())
															#line 3003 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			{
															#line 259 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				fprintf(stderr, "WARNING: %s is a coordinator!\n", c.toString().c_str());
															#line 260 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				foundCoordinator = true;
															#line 3009 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			}
		}
															#line 263 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (foundCoordinator)
															#line 3014 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
															#line 264 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			printf("Type `help coordinators' for information on how to change the\n" "cluster's coordination servers before removing them.\n");
															#line 3018 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 266 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!static_cast<CheckForCoordinatorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckForCoordinatorsActorState(); static_cast<CheckForCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 3022 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		new (&static_cast<CheckForCoordinatorsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckForCoordinatorsActorState();
		static_cast<CheckForCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 245 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			coordinatorsF = tr->get(fdb_cli::coordinatorsProcessSpecialKey);
															#line 246 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = safeThreadFutureToFuture(coordinatorsF);
															#line 246 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (static_cast<CheckForCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3046 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckForCoordinatorsActor*>(this)->actor_wait_state = 1;
															#line 246 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckForCoordinatorsActor, 0, Optional<Value> >*>(static_cast<CheckForCoordinatorsActor*>(this)));
															#line 3051 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 251 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			TraceEvent(SevWarn, "CheckForCoordinatorsError").error(e);
															#line 252 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 252 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (static_cast<CheckForCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3090 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckForCoordinatorsActor*>(this)->actor_wait_state = 2;
															#line 252 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckForCoordinatorsActor, 1, Void >*>(static_cast<CheckForCoordinatorsActor*>(this)));
															#line 3095 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& coordinators,int loopDepth) 
	{
															#line 247 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		ASSERT(coordinators.present());
															#line 248 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		coordinatorList = NetworkAddress::parseList(coordinators.get().toString());
															#line 3112 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && coordinators,int loopDepth) 
	{
															#line 247 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		ASSERT(coordinators.present());
															#line 248 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		coordinatorList = NetworkAddress::parseList(coordinators.get().toString());
															#line 3123 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& coordinators,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(coordinators, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && coordinators,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(coordinators), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckForCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<CheckForCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForCoordinatorsActor*>(this)->ActorCallback< CheckForCoordinatorsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkForCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckForCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkForCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckForCoordinatorsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckForCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<CheckForCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForCoordinatorsActor*>(this)->ActorCallback< CheckForCoordinatorsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForCoordinatorsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkForCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckForCoordinatorsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkForCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckForCoordinatorsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkForCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 237 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 237 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::set<AddressExclusion> exclusions;
															#line 239 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	bool foundCoordinator;
															#line 240 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::vector<NetworkAddress> coordinatorList;
															#line 241 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 245 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	ThreadFuture<Optional<Value>> coordinatorsF;
															#line 3302 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
};
// This generated class is to be used only via checkForCoordinators()
															#line 237 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class CheckForCoordinatorsActor final : public Actor<Void>, public ActorCallback< CheckForCoordinatorsActor, 0, Optional<Value> >, public ActorCallback< CheckForCoordinatorsActor, 1, Void >, public FastAllocated<CheckForCoordinatorsActor>, public CheckForCoordinatorsActorState<CheckForCoordinatorsActor> {
															#line 3307 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
	using FastAllocated<CheckForCoordinatorsActor>::operator new;
	using FastAllocated<CheckForCoordinatorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10374958101458323200UL, 5101701819729733120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckForCoordinatorsActor, 0, Optional<Value> >;
friend struct ActorCallback< CheckForCoordinatorsActor, 1, Void >;
															#line 237 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	CheckForCoordinatorsActor(Reference<IDatabase> const& db,std::set<AddressExclusion> const& exclusions) 
															#line 3325 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		 : Actor<Void>(),
		   CheckForCoordinatorsActorState<CheckForCoordinatorsActor>(db, exclusions),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkForCoordinators", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8515482316296620288UL, 6279626877458825216UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkForCoordinators");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkForCoordinators", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckForCoordinatorsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckForCoordinatorsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 237 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
[[nodiscard]] Future<Void> checkForCoordinators( Reference<IDatabase> const& db, std::set<AddressExclusion> const& exclusions ) {
															#line 237 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	return Future<Void>(new CheckForCoordinatorsActor(db, exclusions));
															#line 3358 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
}

#line 268 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"

} // namespace

namespace fdb_cli {

const KeyRangeRef excludedServersSpecialKeyRange("\xff\xff/management/excluded/"_sr,
                                                 "\xff\xff/management/excluded0"_sr);
const KeyRangeRef failedServersSpecialKeyRange("\xff\xff/management/failed/"_sr, "\xff\xff/management/failed0"_sr);
const KeyRangeRef excludedLocalitySpecialKeyRange("\xff\xff/management/excluded_locality/"_sr,
                                                  "\xff\xff/management/excluded_locality0"_sr);
const KeyRangeRef failedLocalitySpecialKeyRange("\xff\xff/management/failed_locality/"_sr,
                                                "\xff\xff/management/failed_locality0"_sr);
const KeyRef excludedForceOptionSpecialKey = "\xff\xff/management/options/excluded/force"_sr;
const KeyRef failedForceOptionSpecialKey = "\xff\xff/management/options/failed/force"_sr;
const KeyRef excludedLocalityForceOptionSpecialKey = "\xff\xff/management/options/excluded_locality/force"_sr;
const KeyRef failedLocalityForceOptionSpecialKey = "\xff\xff/management/options/failed_locality/force"_sr;
const KeyRangeRef exclusionInProgressSpecialKeyRange("\xff\xff/management/in_progress_exclusion/"_sr,
                                                     "\xff\xff/management/in_progress_exclusion0"_sr);

															#line 3381 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
// This generated class is to be used only via excludeCommandActor()
															#line 287 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
template <class ExcludeCommandActorActor>
															#line 287 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class ExcludeCommandActorActorState {
															#line 3387 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
															#line 287 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	ExcludeCommandActorActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens,Future<Void> const& warn) 
															#line 287 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
															#line 287 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		 : db(db),
															#line 287 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   tokens(tokens),
															#line 287 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		   warn(warn)
															#line 3398 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("excludeCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~ExcludeCommandActorActorState() 
	{
		fdb_probe_actor_destroy("excludeCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 288 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (tokens.size() <= 1)
															#line 3413 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			{
															#line 289 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				StrictFuture<std::vector<std::string>> __when_expr_0 = getExcludedServers(db);
															#line 289 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3419 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 1;
															#line 289 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExcludeCommandActorActor, 0, std::vector<std::string> >*>(static_cast<ExcludeCommandActorActor*>(this)));
															#line 3424 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 338 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				exclusionSet = std::set<AddressExclusion>();
															#line 339 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				exclusionAddresses = std::vector<AddressExclusion>();
															#line 340 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				exclusionLocalities = std::unordered_set<std::string>();
															#line 341 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				noMatchLocalities = std::vector<std::string>();
															#line 342 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				force = false;
															#line 343 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				waitForAllExcluded = true;
															#line 344 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				markFailed = false;
															#line 345 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				workers = std::vector<ProcessData>();
															#line 346 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				server_interfaces = std::map<std::string, StorageServerInterface>();
															#line 347 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				future_workers = fdb_cli::getWorkers(db, &workers);
															#line 348 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				future_server_interfaces = fdb_cli::getStorageServerInterfaces(db, &server_interfaces);
															#line 349 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				StrictFuture<Void> __when_expr_5 = success(future_workers) && success(future_server_interfaces);
															#line 349 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3455 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1when2(__when_expr_5.get(), loopDepth); };
				static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 6;
															#line 349 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ExcludeCommandActorActor, 5, Void >*>(static_cast<ExcludeCommandActorActor*>(this)));
															#line 3460 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExcludeCommandActorActorState();
		static_cast<ExcludeCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 290 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		StrictFuture<std::vector<std::string>> __when_expr_1 = getExcludedLocalities(db);
															#line 290 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3486 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 2;
															#line 290 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExcludeCommandActorActor, 1, std::vector<std::string> >*>(static_cast<ExcludeCommandActorActor*>(this)));
															#line 3491 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<std::string> const& __excludedAddresses,int loopDepth) 
	{
															#line 289 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		excludedAddresses = __excludedAddresses;
															#line 3500 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::string> && __excludedAddresses,int loopDepth) 
	{
		excludedAddresses = std::move(__excludedAddresses);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeCommandActorActor*>(this)->ActorCallback< ExcludeCommandActorActor, 0, std::vector<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 0, std::vector<std::string> >*,std::vector<std::string> const& value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 0, std::vector<std::string> >*,std::vector<std::string> && value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExcludeCommandActorActor, 0, std::vector<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 291 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		StrictFuture<std::vector<std::string>> __when_expr_2 = getFailedServers(db);
															#line 291 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3581 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 3;
															#line 291 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExcludeCommandActorActor, 2, std::vector<std::string> >*>(static_cast<ExcludeCommandActorActor*>(this)));
															#line 3586 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<std::string> const& __excludedLocalities,int loopDepth) 
	{
															#line 290 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		excludedLocalities = __excludedLocalities;
															#line 3595 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<std::string> && __excludedLocalities,int loopDepth) 
	{
		excludedLocalities = std::move(__excludedLocalities);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeCommandActorActor*>(this)->ActorCallback< ExcludeCommandActorActor, 1, std::vector<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 1, std::vector<std::string> >*,std::vector<std::string> const& value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 1, std::vector<std::string> >*,std::vector<std::string> && value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExcludeCommandActorActor, 1, std::vector<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 292 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		StrictFuture<std::vector<std::string>> __when_expr_3 = getFailedLocalities(db);
															#line 292 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3676 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 4;
															#line 292 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ExcludeCommandActorActor, 3, std::vector<std::string> >*>(static_cast<ExcludeCommandActorActor*>(this)));
															#line 3681 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(std::vector<std::string> const& __failedAddresses,int loopDepth) 
	{
															#line 291 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		failedAddresses = __failedAddresses;
															#line 3690 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(std::vector<std::string> && __failedAddresses,int loopDepth) 
	{
		failedAddresses = std::move(__failedAddresses);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeCommandActorActor*>(this)->ActorCallback< ExcludeCommandActorActor, 2, std::vector<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 2, std::vector<std::string> >*,std::vector<std::string> const& value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 2, std::vector<std::string> >*,std::vector<std::string> && value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ExcludeCommandActorActor, 2, std::vector<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 294 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!excludedAddresses.size() && !excludedLocalities.size() && !failedAddresses.size() && !failedLocalities.size())
															#line 3769 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
															#line 296 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			printf("There are currently no servers or localities excluded from the database.\n" "To learn how to exclude a server, type `help exclude'.\n");
															#line 298 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (!static_cast<ExcludeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ExcludeCommandActorActorState(); static_cast<ExcludeCommandActorActor*>(this)->destroy(); return 0; }
															#line 3775 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			new (&static_cast<ExcludeCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
			this->~ExcludeCommandActorActorState();
			static_cast<ExcludeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 301 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		printf("There are currently %zu servers or localities being excluded from the database:\n", excludedAddresses.size() + excludedLocalities.size());
															#line 303 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& e : excludedAddresses ) {
															#line 304 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			printf("  %s\n", e.c_str());
															#line 3787 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 305 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& e : excludedLocalities ) {
															#line 306 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			printf("  %s\n", e.c_str());
															#line 3793 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 308 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (excludedAddresses.size() || excludedLocalities.size())
															#line 3797 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
															#line 309 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			printf("To find out whether it is safe to remove one or more of these\n" "servers from the cluster, type `exclude <addresses>'.\n" "To return one of these servers to the cluster, type `include <addresses>'.\n");
															#line 3801 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 314 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		printf("\n");
															#line 316 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		printf("There are currently %zu servers or localities marked as failed in the database:\n", failedAddresses.size() + failedLocalities.size());
															#line 318 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& f : failedAddresses ) {
															#line 319 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			printf("  %s\n", f.c_str());
															#line 3811 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 320 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& f : failedLocalities ) {
															#line 321 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			printf("  %s\n", f.c_str());
															#line 3817 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 323 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (failedAddresses.size() || failedLocalities.size())
															#line 3821 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
															#line 324 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			printf("To return one of these servers to the cluster, type `include failed <addresses>'.\n");
															#line 3825 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 327 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		printf("\n");
															#line 329 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		Reference<ITransaction> tr = db->createTransaction();
															#line 330 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		StrictFuture<std::set<NetworkAddress>> __when_expr_4 = getInProgressExclusion(tr);
															#line 330 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3835 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 5;
															#line 330 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ExcludeCommandActorActor, 4, std::set<NetworkAddress> >*>(static_cast<ExcludeCommandActorActor*>(this)));
															#line 3840 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<std::string> const& __failedLocalities,int loopDepth) 
	{
															#line 292 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		failedLocalities = __failedLocalities;
															#line 3849 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<std::string> && __failedLocalities,int loopDepth) 
	{
		failedLocalities = std::move(__failedLocalities);
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeCommandActorActor*>(this)->ActorCallback< ExcludeCommandActorActor, 3, std::vector<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 3, std::vector<std::string> >*,std::vector<std::string> const& value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 3, std::vector<std::string> >*,std::vector<std::string> && value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ExcludeCommandActorActor, 3, std::vector<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(std::set<NetworkAddress> const& inProgressExclusion,int loopDepth) 
	{
															#line 331 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		printf("There are currently %zu processes for which exclusion is in progress:\n", inProgressExclusion.size());
															#line 332 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& addr : inProgressExclusion ) {
															#line 333 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			printf("%s\n", addr.toString().c_str());
															#line 3932 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 336 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!static_cast<ExcludeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ExcludeCommandActorActorState(); static_cast<ExcludeCommandActorActor*>(this)->destroy(); return 0; }
															#line 3936 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		new (&static_cast<ExcludeCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ExcludeCommandActorActorState();
		static_cast<ExcludeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(std::set<NetworkAddress> && inProgressExclusion,int loopDepth) 
	{
															#line 331 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		printf("There are currently %zu processes for which exclusion is in progress:\n", inProgressExclusion.size());
															#line 332 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& addr : inProgressExclusion ) {
															#line 333 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			printf("%s\n", addr.toString().c_str());
															#line 3952 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 336 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!static_cast<ExcludeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ExcludeCommandActorActorState(); static_cast<ExcludeCommandActorActor*>(this)->destroy(); return 0; }
															#line 3956 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		new (&static_cast<ExcludeCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ExcludeCommandActorActorState();
		static_cast<ExcludeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(std::set<NetworkAddress> const& inProgressExclusion,int loopDepth) 
	{
		loopDepth = a_body1cont6(inProgressExclusion, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(std::set<NetworkAddress> && inProgressExclusion,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(inProgressExclusion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeCommandActorActor*>(this)->ActorCallback< ExcludeCommandActorActor, 4, std::set<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 4, std::set<NetworkAddress> >*,std::set<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 4, std::set<NetworkAddress> >*,std::set<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ExcludeCommandActorActor, 4, std::set<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont16(Void const& _,int loopDepth) 
	{
															#line 351 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for(auto t = tokens.begin() + 1;t != tokens.end();++t) {
															#line 352 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (*t == "FORCE"_sr)
															#line 4045 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			{
															#line 353 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				force = true;
															#line 4049 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			}
			else
			{
															#line 354 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				if (*t == "no_wait"_sr)
															#line 4055 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				{
															#line 355 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
					waitForAllExcluded = false;
															#line 4059 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				}
				else
				{
															#line 356 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
					if (*t == "failed"_sr)
															#line 4065 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
					{
															#line 357 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
						markFailed = true;
															#line 4069 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
					}
					else
					{
															#line 358 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
						if (t->startsWith(LocalityData::ExcludeLocalityPrefix) && t->toString().find(':') != std::string::npos)
															#line 4075 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
						{
															#line 360 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							exclusionLocalities.insert(t->toString());
															#line 361 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							auto localityAddresses = getAddressesByLocality(workers, t->toString());
															#line 362 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							auto localityServerAddresses = getServerAddressesByLocality(server_interfaces, t->toString());
															#line 363 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							if (localityAddresses.empty() && localityServerAddresses.empty())
															#line 4085 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
							{
															#line 364 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
								noMatchLocalities.push_back(t->toString());
															#line 4089 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
								continue;
							}
															#line 368 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							if (!localityAddresses.empty())
															#line 4094 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
							{
															#line 369 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
								exclusionSet.insert(localityAddresses.begin(), localityAddresses.end());
															#line 4098 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
							}
															#line 372 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							if (!localityServerAddresses.empty())
															#line 4102 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
							{
															#line 373 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
								exclusionSet.insert(localityServerAddresses.begin(), localityServerAddresses.end());
															#line 4106 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
							}
						}
						else
						{
															#line 376 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							auto a = AddressExclusion::parse(*t);
															#line 377 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							if (!a.isValid())
															#line 4115 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
							{
															#line 378 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
								fprintf(stderr, "ERROR: '%s' is neither a valid network endpoint address nor a locality\n", t->toString().c_str());
															#line 381 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
								if (t->toString().find(":tls") != std::string::npos)
															#line 4121 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
								{
															#line 382 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
									printf("        Do not include the `:tls' suffix when naming a process\n");
															#line 4125 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
								}
															#line 383 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
								if (!static_cast<ExcludeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ExcludeCommandActorActorState(); static_cast<ExcludeCommandActorActor*>(this)->destroy(); return 0; }
															#line 4129 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
								new (&static_cast<ExcludeCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
								this->~ExcludeCommandActorActorState();
								static_cast<ExcludeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
															#line 385 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							exclusionSet.insert(a);
															#line 386 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							exclusionAddresses.push_back(a);
															#line 4139 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
						}
					}
				}
			}
		}
															#line 392 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (exclusionAddresses.empty() && exclusionLocalities.empty())
															#line 4147 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
															#line 393 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			fprintf(stderr, "ERROR: At least one valid network endpoint address or a locality must be provided\n");
															#line 394 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (!static_cast<ExcludeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ExcludeCommandActorActorState(); static_cast<ExcludeCommandActorActor*>(this)->destroy(); return 0; }
															#line 4153 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			new (&static_cast<ExcludeCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ExcludeCommandActorActorState();
			static_cast<ExcludeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 397 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		StrictFuture<bool> __when_expr_6 = excludeServersAndLocalities(db, exclusionAddresses, exclusionLocalities, markFailed, force);
															#line 397 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4163 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont16when1(__when_expr_6.get(), loopDepth); };
		static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 7;
															#line 397 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ExcludeCommandActorActor, 6, bool >*>(static_cast<ExcludeCommandActorActor*>(this)));
															#line 4168 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16(Void && _,int loopDepth) 
	{
															#line 351 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for(auto t = tokens.begin() + 1;t != tokens.end();++t) {
															#line 352 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (*t == "FORCE"_sr)
															#line 4179 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			{
															#line 353 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				force = true;
															#line 4183 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			}
			else
			{
															#line 354 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				if (*t == "no_wait"_sr)
															#line 4189 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				{
															#line 355 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
					waitForAllExcluded = false;
															#line 4193 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				}
				else
				{
															#line 356 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
					if (*t == "failed"_sr)
															#line 4199 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
					{
															#line 357 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
						markFailed = true;
															#line 4203 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
					}
					else
					{
															#line 358 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
						if (t->startsWith(LocalityData::ExcludeLocalityPrefix) && t->toString().find(':') != std::string::npos)
															#line 4209 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
						{
															#line 360 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							exclusionLocalities.insert(t->toString());
															#line 361 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							auto localityAddresses = getAddressesByLocality(workers, t->toString());
															#line 362 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							auto localityServerAddresses = getServerAddressesByLocality(server_interfaces, t->toString());
															#line 363 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							if (localityAddresses.empty() && localityServerAddresses.empty())
															#line 4219 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
							{
															#line 364 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
								noMatchLocalities.push_back(t->toString());
															#line 4223 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
								continue;
							}
															#line 368 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							if (!localityAddresses.empty())
															#line 4228 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
							{
															#line 369 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
								exclusionSet.insert(localityAddresses.begin(), localityAddresses.end());
															#line 4232 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
							}
															#line 372 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							if (!localityServerAddresses.empty())
															#line 4236 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
							{
															#line 373 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
								exclusionSet.insert(localityServerAddresses.begin(), localityServerAddresses.end());
															#line 4240 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
							}
						}
						else
						{
															#line 376 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							auto a = AddressExclusion::parse(*t);
															#line 377 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							if (!a.isValid())
															#line 4249 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
							{
															#line 378 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
								fprintf(stderr, "ERROR: '%s' is neither a valid network endpoint address nor a locality\n", t->toString().c_str());
															#line 381 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
								if (t->toString().find(":tls") != std::string::npos)
															#line 4255 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
								{
															#line 382 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
									printf("        Do not include the `:tls' suffix when naming a process\n");
															#line 4259 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
								}
															#line 383 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
								if (!static_cast<ExcludeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ExcludeCommandActorActorState(); static_cast<ExcludeCommandActorActor*>(this)->destroy(); return 0; }
															#line 4263 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
								new (&static_cast<ExcludeCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
								this->~ExcludeCommandActorActorState();
								static_cast<ExcludeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
															#line 385 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							exclusionSet.insert(a);
															#line 386 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
							exclusionAddresses.push_back(a);
															#line 4273 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
						}
					}
				}
			}
		}
															#line 392 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (exclusionAddresses.empty() && exclusionLocalities.empty())
															#line 4281 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
															#line 393 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			fprintf(stderr, "ERROR: At least one valid network endpoint address or a locality must be provided\n");
															#line 394 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (!static_cast<ExcludeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ExcludeCommandActorActorState(); static_cast<ExcludeCommandActorActor*>(this)->destroy(); return 0; }
															#line 4287 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			new (&static_cast<ExcludeCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ExcludeCommandActorActorState();
			static_cast<ExcludeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 397 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		StrictFuture<bool> __when_expr_6 = excludeServersAndLocalities(db, exclusionAddresses, exclusionLocalities, markFailed, force);
															#line 397 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4297 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont16when1(__when_expr_6.get(), loopDepth); };
		static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 7;
															#line 397 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ExcludeCommandActorActor, 6, bool >*>(static_cast<ExcludeCommandActorActor*>(this)));
															#line 4302 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeCommandActorActor*>(this)->ActorCallback< ExcludeCommandActorActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ExcludeCommandActorActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont16cont1(bool const& res,int loopDepth) 
	{
															#line 398 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!res)
															#line 4386 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
															#line 399 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (!static_cast<ExcludeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ExcludeCommandActorActorState(); static_cast<ExcludeCommandActorActor*>(this)->destroy(); return 0; }
															#line 4390 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			new (&static_cast<ExcludeCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ExcludeCommandActorActorState();
			static_cast<ExcludeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 401 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (waitForAllExcluded)
															#line 4398 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
															#line 402 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			printf("Waiting for state to be removed from all excluded servers. This may take a while.\n");
															#line 403 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			printf("(Interrupting this wait with CTRL+C will not cancel the data movement.)\n");
															#line 4404 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 406 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (warn.isValid())
															#line 4408 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
															#line 407 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			warn.cancel();
															#line 4412 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 409 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		StrictFuture<std::set<NetworkAddress>> __when_expr_7 = checkForExcludingServers(db, exclusionSet, waitForAllExcluded);
															#line 409 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4418 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont16cont1when1(__when_expr_7.get(), loopDepth); };
		static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 8;
															#line 409 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ExcludeCommandActorActor, 7, std::set<NetworkAddress> >*>(static_cast<ExcludeCommandActorActor*>(this)));
															#line 4423 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16cont1(bool && res,int loopDepth) 
	{
															#line 398 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!res)
															#line 4432 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
															#line 399 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (!static_cast<ExcludeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ExcludeCommandActorActorState(); static_cast<ExcludeCommandActorActor*>(this)->destroy(); return 0; }
															#line 4436 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			new (&static_cast<ExcludeCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ExcludeCommandActorActorState();
			static_cast<ExcludeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 401 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (waitForAllExcluded)
															#line 4444 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
															#line 402 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			printf("Waiting for state to be removed from all excluded servers. This may take a while.\n");
															#line 403 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			printf("(Interrupting this wait with CTRL+C will not cancel the data movement.)\n");
															#line 4450 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 406 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (warn.isValid())
															#line 4454 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		{
															#line 407 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			warn.cancel();
															#line 4458 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 409 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		StrictFuture<std::set<NetworkAddress>> __when_expr_7 = checkForExcludingServers(db, exclusionSet, waitForAllExcluded);
															#line 409 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4464 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont16cont1when1(__when_expr_7.get(), loopDepth); };
		static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 8;
															#line 409 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ExcludeCommandActorActor, 7, std::set<NetworkAddress> >*>(static_cast<ExcludeCommandActorActor*>(this)));
															#line 4469 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16when1(bool const& res,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont16when1(bool && res,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeCommandActorActor*>(this)->ActorCallback< ExcludeCommandActorActor, 6, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 6, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont16when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 6, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont16when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ExcludeCommandActorActor, 6, bool >*,Error err) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont16cont17(int loopDepth) 
	{
															#line 411 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		std::map<IPAddress, std::set<uint16_t>> workerPorts;
															#line 412 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( auto addr : workers ) {
															#line 413 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			workerPorts[addr.address.ip].insert(addr.address.port);
															#line 4557 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 416 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		std::set<AddressExclusion> absentExclusions;
															#line 417 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& addr : exclusionSet ) {
															#line 418 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			auto worker = workerPorts.find(addr.ip);
															#line 419 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (worker == workerPorts.end())
															#line 4567 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			{
															#line 420 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				absentExclusions.insert(addr);
															#line 4571 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			}
			else
			{
															#line 421 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				if (addr.port > 0 && worker->second.count(addr.port) == 0)
															#line 4577 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				{
															#line 422 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
					absentExclusions.insert(addr);
															#line 4581 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				}
			}
		}
															#line 425 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& exclusion : exclusionSet ) {
															#line 426 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			if (absentExclusions.find(exclusion) != absentExclusions.end())
															#line 4589 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
			{
															#line 427 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				if (exclusion.port == 0)
															#line 4593 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				{
															#line 428 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
					fprintf(stderr, "  %s(Whole machine)  ---- WARNING: Missing from cluster!Be sure that you excluded the " "correct machines before removing them from the cluster!\n", exclusion.ip.toString().c_str());
															#line 4597 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				}
				else
				{
															#line 433 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
					fprintf(stderr, "  %s  ---- WARNING: Missing from cluster! Be sure that you excluded the correct processes " "before removing them from the cluster!\n", exclusion.toString().c_str());
															#line 4603 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				}
			}
			else
			{
															#line 438 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
				if (std::any_of(notExcludedServers.begin(), notExcludedServers.end(), [&](const NetworkAddress& a) { return addressExcluded({ exclusion }, a); }))
															#line 4610 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
				{
															#line 441 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
					if (exclusion.port == 0)
															#line 4614 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
					{
															#line 442 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
						fprintf(stderr, "  %s(Whole machine)  ---- WARNING: Exclusion in progress! It is not safe to remove this " "machine from the cluster\n", exclusion.ip.toString().c_str());
															#line 4618 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
					}
					else
					{
															#line 447 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
						fprintf(stderr, "  %s  ---- WARNING: Exclusion in progress! It is not safe to remove this process from the " "cluster\n", exclusion.toString().c_str());
															#line 4624 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
					}
				}
				else
				{
															#line 453 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
					if (exclusion.port == 0)
															#line 4631 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
					{
															#line 454 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
						printf("  %s(Whole machine)  ---- Successfully excluded. It is now safe to remove this machine " "from the cluster.\n", exclusion.ip.toString().c_str());
															#line 4635 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
					}
					else
					{
															#line 458 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
						printf( "  %s  ---- Successfully excluded. It is now safe to remove this process from the cluster.\n", exclusion.toString().c_str());
															#line 4641 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
					}
				}
			}
		}
															#line 465 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		for( const auto& locality : noMatchLocalities ) {
															#line 466 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
			fprintf( stderr, "  %s  ---- WARNING: Currently no servers found with this locality match! Be sure that you excluded " "the correct locality.\n", locality.c_str());
															#line 4650 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		}
															#line 473 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		StrictFuture<Void> __when_expr_8 = checkForCoordinators(db, exclusionSet);
															#line 473 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4656 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont16cont17when1(__when_expr_8.get(), loopDepth); };
		static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 9;
															#line 473 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ExcludeCommandActorActor, 8, Void >*>(static_cast<ExcludeCommandActorActor*>(this)));
															#line 4661 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16cont1when1(std::set<NetworkAddress> const& __notExcludedServers,int loopDepth) 
	{
															#line 409 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		notExcludedServers = __notExcludedServers;
															#line 4670 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		loopDepth = a_body1cont16cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont1when1(std::set<NetworkAddress> && __notExcludedServers,int loopDepth) 
	{
		notExcludedServers = std::move(__notExcludedServers);
		loopDepth = a_body1cont16cont17(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeCommandActorActor*>(this)->ActorCallback< ExcludeCommandActorActor, 7, std::set<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 7, std::set<NetworkAddress> >*,std::set<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont16cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 7, std::set<NetworkAddress> >*,std::set<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont16cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ExcludeCommandActorActor, 7, std::set<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont16cont17cont1(Void const& _,int loopDepth) 
	{
															#line 474 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!static_cast<ExcludeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ExcludeCommandActorActorState(); static_cast<ExcludeCommandActorActor*>(this)->destroy(); return 0; }
															#line 4749 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		new (&static_cast<ExcludeCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ExcludeCommandActorActorState();
		static_cast<ExcludeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont16cont17cont1(Void && _,int loopDepth) 
	{
															#line 474 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
		if (!static_cast<ExcludeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ExcludeCommandActorActorState(); static_cast<ExcludeCommandActorActor*>(this)->destroy(); return 0; }
															#line 4761 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		new (&static_cast<ExcludeCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ExcludeCommandActorActorState();
		static_cast<ExcludeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont16cont17when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont17cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont17when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont17cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ExcludeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeCommandActorActor*>(this)->ActorCallback< ExcludeCommandActorActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont16cont17when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ExcludeCommandActorActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont16cont17when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ExcludeCommandActorActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 287 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 287 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 287 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Future<Void> warn;
															#line 289 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::vector<std::string> excludedAddresses;
															#line 290 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::vector<std::string> excludedLocalities;
															#line 291 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::vector<std::string> failedAddresses;
															#line 292 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::vector<std::string> failedLocalities;
															#line 338 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::set<AddressExclusion> exclusionSet;
															#line 339 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::vector<AddressExclusion> exclusionAddresses;
															#line 340 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::unordered_set<std::string> exclusionLocalities;
															#line 341 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::vector<std::string> noMatchLocalities;
															#line 342 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	bool force;
															#line 343 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	bool waitForAllExcluded;
															#line 344 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	bool markFailed;
															#line 345 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::vector<ProcessData> workers;
															#line 346 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::map<std::string, StorageServerInterface> server_interfaces;
															#line 347 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Future<bool> future_workers;
															#line 348 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	Future<Void> future_server_interfaces;
															#line 409 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	std::set<NetworkAddress> notExcludedServers;
															#line 4882 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
};
// This generated class is to be used only via excludeCommandActor()
															#line 287 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
class ExcludeCommandActorActor final : public Actor<bool>, public ActorCallback< ExcludeCommandActorActor, 0, std::vector<std::string> >, public ActorCallback< ExcludeCommandActorActor, 1, std::vector<std::string> >, public ActorCallback< ExcludeCommandActorActor, 2, std::vector<std::string> >, public ActorCallback< ExcludeCommandActorActor, 3, std::vector<std::string> >, public ActorCallback< ExcludeCommandActorActor, 4, std::set<NetworkAddress> >, public ActorCallback< ExcludeCommandActorActor, 5, Void >, public ActorCallback< ExcludeCommandActorActor, 6, bool >, public ActorCallback< ExcludeCommandActorActor, 7, std::set<NetworkAddress> >, public ActorCallback< ExcludeCommandActorActor, 8, Void >, public FastAllocated<ExcludeCommandActorActor>, public ExcludeCommandActorActorState<ExcludeCommandActorActor> {
															#line 4887 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
public:
	using FastAllocated<ExcludeCommandActorActor>::operator new;
	using FastAllocated<ExcludeCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11277608586064407296UL, 16119287381911165952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExcludeCommandActorActor, 0, std::vector<std::string> >;
friend struct ActorCallback< ExcludeCommandActorActor, 1, std::vector<std::string> >;
friend struct ActorCallback< ExcludeCommandActorActor, 2, std::vector<std::string> >;
friend struct ActorCallback< ExcludeCommandActorActor, 3, std::vector<std::string> >;
friend struct ActorCallback< ExcludeCommandActorActor, 4, std::set<NetworkAddress> >;
friend struct ActorCallback< ExcludeCommandActorActor, 5, Void >;
friend struct ActorCallback< ExcludeCommandActorActor, 6, bool >;
friend struct ActorCallback< ExcludeCommandActorActor, 7, std::set<NetworkAddress> >;
friend struct ActorCallback< ExcludeCommandActorActor, 8, Void >;
															#line 287 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	ExcludeCommandActorActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens,Future<Void> const& warn) 
															#line 4912 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
		 : Actor<bool>(),
		   ExcludeCommandActorActorState<ExcludeCommandActorActor>(db, tokens, warn),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("excludeCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(831139412205782784UL, 17969070764474479616UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("excludeCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("excludeCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExcludeCommandActorActor, 0, std::vector<std::string> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExcludeCommandActorActor, 1, std::vector<std::string> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ExcludeCommandActorActor, 2, std::vector<std::string> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ExcludeCommandActorActor, 3, std::vector<std::string> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ExcludeCommandActorActor, 4, std::set<NetworkAddress> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ExcludeCommandActorActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ExcludeCommandActorActor, 6, bool >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ExcludeCommandActorActor, 7, std::set<NetworkAddress> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ExcludeCommandActorActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 287 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
[[nodiscard]] Future<bool> excludeCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens, Future<Void> const& warn ) {
															#line 287 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"
	return Future<bool>(new ExcludeCommandActorActor(db, tokens, warn));
															#line 4952 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/build_output/fdbcli/ExcludeCommand.actor.g.cpp"
}

#line 477 "/codebuild/output/src2230694009/src/github.com/apple/foundationdb/fdbcli/ExcludeCommand.actor.cpp"

CommandFactory excludeFactory(
    "exclude",
    CommandHelp(
        "exclude [FORCE] [failed] [no_wait] [<ADDRESS...>] [locality_dcid:<excludedcid>]\n"
        "        [locality_zoneid:<excludezoneid>] [locality_machineid:<excludemachineid>]\n"
        "        [locality_processid:<excludeprocessid>] [locality_<KEY>:<localtyvalue>]",
        "exclude servers from the database by IP address or locality",
        "If no addresses or localities are specified, lists the set of excluded addresses and localities in addition "
        "to addresses for which exclusion is in progress.\n"
        "\n"
        "For each IP address or IP:port pair in <ADDRESS...> and/or each locality attribute (like dcid, "
        "zoneid, machineid, processid), adds the address/locality to the set of exclusions and waits until all "
        "database state has been safely moved away from affected servers.\n"
        "\n"
        "If 'FORCE' is set, the command does not perform safety checks before excluding.\n"
        "\n"
        "If 'no_wait' is set, the command returns immediately without checking if the exclusions have completed "
        "successfully.\n"
        "\n"
        "If 'failed' is set, the cluster will immediately forget all data associated with the excluded processes. "
        "Doing so can be helpful if the process is not expected to recover, as it will allow the cluster to delete "
        "state that would be needed to catch the failed process up. Re-including a process excluded with 'failed' will "
        "result in it joining as an empty process.\n"
        "\n"
        "If a cluster has failed storage servers that result in all replicas of some data being permanently gone, "
        "'exclude failed' can be used to clean up the affected key ranges by restoring them to empty.\n"
        "\n"
        "WARNING: use of 'exclude failed' can result in data loss. If an excluded server contains the last replica of "
        "some data, then using the 'failed' option will permanently remove that data from the cluster."));
} // namespace fdb_cli
