/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.FDB;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

abstract class NativeObjectWrapper
implements AutoCloseable {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    protected final Lock pointerReadLock = this.rwl.readLock();
    private boolean closed = false;
    private long cPtr;

    NativeObjectWrapper(long l) {
        this.cPtr = l;
        if (this.cPtr == 0L) {
            this.closed = true;
        }
    }

    public boolean isClosed() {
        assert (this.rwl.getReadHoldCount() > 0);
        return this.closed;
    }

    public void checkUnclosed(String string) {
        try {
            if (FDB.instance().warnOnUnclosed && !this.closed) {
                System.err.println(string + " not closed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        this.rwl.writeLock().lock();
        long l = 0L;
        try {
            if (this.closed) {
                return;
            }
            l = this.cPtr;
            this.cPtr = 0L;
            this.closed = true;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        this.closeInternal(l);
    }

    protected long getPtr() {
        assert (this.rwl.getReadHoldCount() > 0);
        if (this.closed) {
            throw new IllegalStateException("Cannot access closed object");
        }
        return this.cPtr;
    }

    protected abstract void closeInternal(long var1);
}

