#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
/*
 * pubsub.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cinttypes>
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/pubsub.h"
#include "flow/actorcompiler.h" // This must be the last #include.

Value uInt64ToValue(uint64_t v) {
	return StringRef(format("%016llx", v));
}
uint64_t valueToUInt64(const StringRef& v) {
	uint64_t x = 0;
	sscanf(v.toString().c_str(), "%" SCNx64, &x);
	return x;
}

Key keyForInbox(uint64_t inbox) {
	return StringRef(format("i/%016llx", inbox));
}
Key keyForInboxSubscription(uint64_t inbox, uint64_t feed) {
	return StringRef(format("i/%016llx/subs/%016llx", inbox, feed));
}
Key keyForInboxSubscriptionCount(uint64_t inbox) {
	return StringRef(format("i/%016llx/subsCnt", inbox));
}
Key keyForInboxStalePrefix(uint64_t inbox) {
	return StringRef(format("i/%016llx/stale/", inbox));
}
Key keyForInboxStaleFeed(uint64_t inbox, uint64_t feed) {
	return StringRef(format("i/%016llx/stale/%016llx", inbox, feed));
}
Key keyForInboxCacheByIDPrefix(uint64_t inbox) {
	return StringRef(format("i/%016llx/cid/", inbox));
}
Key keyForInboxCacheByID(uint64_t inbox, uint64_t messageId) {
	return StringRef(format("i/%016llx/cid/%016llx", inbox, messageId));
}
Key keyForInboxCacheByFeedPrefix(uint64_t inbox) {
	return StringRef(format("i/%016llx/cf/", inbox));
}
Key keyForInboxCacheByFeed(uint64_t inbox, uint64_t feed) {
	return StringRef(format("i/%016llx/cf/%016llx", inbox, feed));
}

Key keyForFeed(uint64_t feed) {
	return StringRef(format("f/%016llx", feed));
}
Key keyForFeedSubscriber(uint64_t feed, uint64_t inbox) {
	return StringRef(format("f/%016llx/subs/%016llx", feed, inbox));
}
Key keyForFeedSubscriberCount(uint64_t feed) {
	return StringRef(format("f/%016llx/subscCnt", feed));
}
Key keyForFeedMessage(uint64_t feed, uint64_t message) {
	return StringRef(format("f/%016llx/m/%016llx", feed, message));
}
Key keyForFeedMessagePrefix(uint64_t feed) {
	return StringRef(format("f/%016llx/m/", feed));
}
Key keyForFeedMessageCount(uint64_t feed) {
	return StringRef(format("f/%016llx/messCount", feed));
}
// the following should go at some point: change over to range query of count 1 from feed message list
Key keyForFeedLatestMessage(uint64_t feed) {
	return StringRef(format("f/%016llx/latestMessID", feed));
}
Key keyForFeedWatcherPrefix(uint64_t feed) {
	return StringRef(format("f/%016llx/watchers/", feed));
}
Key keyForFeedWatcher(uint64_t feed, uint64_t inbox) {
	return StringRef(format("f/%016llx/watchers/%016llx", feed, inbox));
}

Standalone<StringRef> messagePrefix("m/"_sr);

Key keyForMessage(uint64_t message) {
	return StringRef(format("m/%016llx", message));
}

Key keyForDisptchEntry(uint64_t message) {
	return StringRef(format("d/%016llx", message));
}

PubSub::PubSub(Database _cx) : cx(_cx) {}

															#line 106 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via _createFeed()
															#line 104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
template <class _createFeedActor>
															#line 104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class _createFeedActorState {
															#line 113 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
															#line 104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	_createFeedActorState(Database const& cx,Standalone<StringRef> const& metadata) 
															#line 104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
															#line 104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		 : cx(cx),
															#line 104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   metadata(metadata),
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   id(deterministicRandom()->randomUniqueID().first())
															#line 124 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_createFeed", reinterpret_cast<unsigned long>(this));

	}
	~_createFeedActorState() 
	{
		fdb_probe_actor_destroy("_createFeed", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 106 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			TraceEvent("PubSubCreateFeed").detail("Feed", id);
															#line 107 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			tr = Transaction(cx);
															#line 108 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			;
															#line 143 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_createFeedActorState();
		static_cast<_createFeedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 125 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!static_cast<_createFeedActor*>(this)->SAV<uint64_t>::futures) { (void)(id); this->~_createFeedActorState(); static_cast<_createFeedActor*>(this)->destroy(); return 0; }
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		new (&static_cast<_createFeedActor*>(this)->SAV< uint64_t >::value()) uint64_t(std::move(id)); // state_var_RVO
		this->~_createFeedActorState();
		static_cast<_createFeedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(keyForFeed(id));
															#line 110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_createFeedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 188 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_createFeedActor*>(this)->actor_wait_state = 1;
															#line 110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _createFeedActor, 0, Optional<Value> >*>(static_cast<_createFeedActor*>(this)));
															#line 193 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 122 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 122 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_createFeedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 230 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_createFeedActor*>(this)->actor_wait_state = 4;
															#line 122 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _createFeedActor, 3, Void >*>(static_cast<_createFeedActor*>(this)));
															#line 235 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		;
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __val,int loopDepth) 
	{
															#line 110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		val = __val;
															#line 259 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __val,int loopDepth) 
	{
		val = std::move(__val);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_createFeedActor*>(this)->actor_wait_state > 0) static_cast<_createFeedActor*>(this)->actor_wait_state = 0;
		static_cast<_createFeedActor*>(this)->ActorCallback< _createFeedActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _createFeedActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_createFeed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createFeed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _createFeedActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_createFeed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createFeed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _createFeedActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_createFeed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createFeed", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 116 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForFeed(id), metadata);
															#line 117 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForFeedSubscriberCount(id), uInt64ToValue(0));
															#line 118 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForFeedMessageCount(id), uInt64ToValue(0));
															#line 119 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 119 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_createFeedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 346 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<_createFeedActor*>(this)->actor_wait_state = 3;
															#line 119 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _createFeedActor, 2, Void >*>(static_cast<_createFeedActor*>(this)));
															#line 351 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!(val.present()))
															#line 367 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 112 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		id = id + deterministicRandom()->randomInt(1, 100);
															#line 113 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(keyForFeed(id));
															#line 113 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_createFeedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 377 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_createFeedActor*>(this)->actor_wait_state = 2;
															#line 113 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _createFeedActor, 1, Optional<Value> >*>(static_cast<_createFeedActor*>(this)));
															#line 382 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Optional<Value> const& v,int loopDepth) 
	{
															#line 114 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		val = v;
															#line 404 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Optional<Value> && v,int loopDepth) 
	{
															#line 114 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		val = v;
															#line 413 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_createFeedActor*>(this)->actor_wait_state > 0) static_cast<_createFeedActor*>(this)->actor_wait_state = 0;
		static_cast<_createFeedActor*>(this)->ActorCallback< _createFeedActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _createFeedActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_createFeed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createFeed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _createFeedActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_createFeed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createFeed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _createFeedActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_createFeed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createFeed", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_createFeedActor*>(this)->actor_wait_state > 0) static_cast<_createFeedActor*>(this)->actor_wait_state = 0;
		static_cast<_createFeedActor*>(this)->ActorCallback< _createFeedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _createFeedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_createFeed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createFeed", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _createFeedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_createFeed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createFeed", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _createFeedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_createFeed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createFeed", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_createFeedActor*>(this)->actor_wait_state > 0) static_cast<_createFeedActor*>(this)->actor_wait_state = 0;
		static_cast<_createFeedActor*>(this)->ActorCallback< _createFeedActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _createFeedActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_createFeed", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createFeed", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _createFeedActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_createFeed", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createFeed", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _createFeedActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_createFeed", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createFeed", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Database cx;
															#line 104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Standalone<StringRef> metadata;
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	uint64_t id;
															#line 107 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Transaction tr;
															#line 110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Optional<Value> val;
															#line 677 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _createFeed()
															#line 104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class _createFeedActor final : public Actor<uint64_t>, public ActorCallback< _createFeedActor, 0, Optional<Value> >, public ActorCallback< _createFeedActor, 1, Optional<Value> >, public ActorCallback< _createFeedActor, 2, Void >, public ActorCallback< _createFeedActor, 3, Void >, public FastAllocated<_createFeedActor>, public _createFeedActorState<_createFeedActor> {
															#line 682 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
	using FastAllocated<_createFeedActor>::operator new;
	using FastAllocated<_createFeedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3752297045998251264UL, 14865446582939559680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<uint64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _createFeedActor, 0, Optional<Value> >;
friend struct ActorCallback< _createFeedActor, 1, Optional<Value> >;
friend struct ActorCallback< _createFeedActor, 2, Void >;
friend struct ActorCallback< _createFeedActor, 3, Void >;
															#line 104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	_createFeedActor(Database const& cx,Standalone<StringRef> const& metadata) 
															#line 702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		 : Actor<uint64_t>(),
		   _createFeedActorState<_createFeedActor>(cx, metadata),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_createFeed", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16990199444056751872UL, 6234206637423839488UL);
		ActorExecutionContextHelper __helper(static_cast<_createFeedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_createFeed");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_createFeed", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _createFeedActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _createFeedActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _createFeedActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _createFeedActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
[[nodiscard]] Future<uint64_t> _createFeed( Database const& cx, Standalone<StringRef> const& metadata ) {
															#line 104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	return Future<uint64_t>(new _createFeedActor(cx, metadata));
															#line 738 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
}

#line 127 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"

Future<uint64_t> PubSub::createFeed(Standalone<StringRef> metadata) {
	return _createFeed(cx, metadata);
}

															#line 747 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via _createInbox()
															#line 132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
template <class _createInboxActor>
															#line 132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class _createInboxActorState {
															#line 754 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
															#line 132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	_createInboxActorState(Database const& cx,Standalone<StringRef> const& metadata) 
															#line 132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
															#line 132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		 : cx(cx),
															#line 132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   metadata(metadata),
															#line 133 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   id(deterministicRandom()->randomUniqueID().first())
															#line 765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_createInbox", reinterpret_cast<unsigned long>(this));

	}
	~_createInboxActorState() 
	{
		fdb_probe_actor_destroy("_createInbox", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 134 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			TraceEvent("PubSubCreateInbox").detail("Inbox", id);
															#line 135 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			tr = Transaction(cx);
															#line 136 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			;
															#line 784 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_createInboxActorState();
		static_cast<_createInboxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 152 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!static_cast<_createInboxActor*>(this)->SAV<uint64_t>::futures) { (void)(id); this->~_createInboxActorState(); static_cast<_createInboxActor*>(this)->destroy(); return 0; }
															#line 807 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		new (&static_cast<_createInboxActor*>(this)->SAV< uint64_t >::value()) uint64_t(std::move(id)); // state_var_RVO
		this->~_createInboxActorState();
		static_cast<_createInboxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 138 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(keyForInbox(id));
															#line 138 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_createInboxActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 829 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_createInboxActor*>(this)->actor_wait_state = 1;
															#line 138 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _createInboxActor, 0, Optional<Value> >*>(static_cast<_createInboxActor*>(this)));
															#line 834 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 149 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 149 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_createInboxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 871 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_createInboxActor*>(this)->actor_wait_state = 4;
															#line 149 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _createInboxActor, 3, Void >*>(static_cast<_createInboxActor*>(this)));
															#line 876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 139 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		;
															#line 891 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __val,int loopDepth) 
	{
															#line 138 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		val = __val;
															#line 900 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __val,int loopDepth) 
	{
		val = std::move(__val);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_createInboxActor*>(this)->actor_wait_state > 0) static_cast<_createInboxActor*>(this)->actor_wait_state = 0;
		static_cast<_createInboxActor*>(this)->ActorCallback< _createInboxActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _createInboxActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_createInbox", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createInboxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createInbox", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _createInboxActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_createInbox", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createInboxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createInbox", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _createInboxActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_createInbox", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createInboxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createInbox", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 144 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForInbox(id), metadata);
															#line 145 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForInboxSubscriptionCount(id), uInt64ToValue(0));
															#line 146 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 146 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_createInboxActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 985 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<_createInboxActor*>(this)->actor_wait_state = 3;
															#line 146 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _createInboxActor, 2, Void >*>(static_cast<_createInboxActor*>(this)));
															#line 990 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 139 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!(val.present()))
															#line 1006 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 140 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		id += deterministicRandom()->randomInt(1, 100);
															#line 141 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(keyForFeed(id));
															#line 141 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_createInboxActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1016 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_createInboxActor*>(this)->actor_wait_state = 2;
															#line 141 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _createInboxActor, 1, Optional<Value> >*>(static_cast<_createInboxActor*>(this)));
															#line 1021 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Optional<Value> const& v,int loopDepth) 
	{
															#line 142 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		val = v;
															#line 1043 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Optional<Value> && v,int loopDepth) 
	{
															#line 142 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		val = v;
															#line 1052 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_createInboxActor*>(this)->actor_wait_state > 0) static_cast<_createInboxActor*>(this)->actor_wait_state = 0;
		static_cast<_createInboxActor*>(this)->ActorCallback< _createInboxActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _createInboxActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_createInbox", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createInboxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createInbox", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _createInboxActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_createInbox", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createInboxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createInbox", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _createInboxActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_createInbox", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createInboxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createInbox", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_createInboxActor*>(this)->actor_wait_state > 0) static_cast<_createInboxActor*>(this)->actor_wait_state = 0;
		static_cast<_createInboxActor*>(this)->ActorCallback< _createInboxActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _createInboxActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_createInbox", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createInboxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createInbox", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _createInboxActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_createInbox", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createInboxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createInbox", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _createInboxActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_createInbox", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createInboxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createInbox", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_createInboxActor*>(this)->actor_wait_state > 0) static_cast<_createInboxActor*>(this)->actor_wait_state = 0;
		static_cast<_createInboxActor*>(this)->ActorCallback< _createInboxActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _createInboxActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_createInbox", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createInboxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createInbox", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _createInboxActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_createInbox", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createInboxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createInbox", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _createInboxActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_createInbox", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createInboxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createInbox", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Database cx;
															#line 132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Standalone<StringRef> metadata;
															#line 133 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	uint64_t id;
															#line 135 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Transaction tr;
															#line 138 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Optional<Value> val;
															#line 1316 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _createInbox()
															#line 132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class _createInboxActor final : public Actor<uint64_t>, public ActorCallback< _createInboxActor, 0, Optional<Value> >, public ActorCallback< _createInboxActor, 1, Optional<Value> >, public ActorCallback< _createInboxActor, 2, Void >, public ActorCallback< _createInboxActor, 3, Void >, public FastAllocated<_createInboxActor>, public _createInboxActorState<_createInboxActor> {
															#line 1321 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
	using FastAllocated<_createInboxActor>::operator new;
	using FastAllocated<_createInboxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5736829543163700736UL, 9228330847096837632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<uint64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _createInboxActor, 0, Optional<Value> >;
friend struct ActorCallback< _createInboxActor, 1, Optional<Value> >;
friend struct ActorCallback< _createInboxActor, 2, Void >;
friend struct ActorCallback< _createInboxActor, 3, Void >;
															#line 132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	_createInboxActor(Database const& cx,Standalone<StringRef> const& metadata) 
															#line 1341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		 : Actor<uint64_t>(),
		   _createInboxActorState<_createInboxActor>(cx, metadata),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_createInbox", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5823255244431491072UL, 10584709554367975680UL);
		ActorExecutionContextHelper __helper(static_cast<_createInboxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_createInbox");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_createInbox", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _createInboxActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _createInboxActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _createInboxActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _createInboxActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
[[nodiscard]] Future<uint64_t> _createInbox( Database const& cx, Standalone<StringRef> const& metadata ) {
															#line 132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	return Future<uint64_t>(new _createInboxActor(cx, metadata));
															#line 1377 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
}

#line 154 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"

Future<uint64_t> PubSub::createInbox(Standalone<StringRef> metadata) {
	return _createInbox(cx, metadata);
}

															#line 1386 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via _createSubscription()
															#line 159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
template <class _createSubscriptionActor>
															#line 159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class _createSubscriptionActorState {
															#line 1393 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
															#line 159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	_createSubscriptionActorState(Database const& cx,uint64_t const& feed,uint64_t const& inbox) 
															#line 159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
															#line 159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		 : cx(cx),
															#line 159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   feed(feed),
															#line 159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   inbox(inbox),
															#line 160 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   tr(cx)
															#line 1406 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_createSubscription", reinterpret_cast<unsigned long>(this));

	}
	~_createSubscriptionActorState() 
	{
		fdb_probe_actor_destroy("_createSubscription", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 161 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			TraceEvent("PubSubCreateSubscription").detail("Feed", feed).detail("Inbox", inbox);
															#line 162 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			;
															#line 1423 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_createSubscriptionActorState();
		static_cast<_createSubscriptionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 199 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!static_cast<_createSubscriptionActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_createSubscriptionActorState(); static_cast<_createSubscriptionActor*>(this)->destroy(); return 0; }
															#line 1446 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		new (&static_cast<_createSubscriptionActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_createSubscriptionActorState();
		static_cast<_createSubscriptionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 164 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(keyForInboxSubscription(inbox, feed));
															#line 164 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1468 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 1;
															#line 164 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _createSubscriptionActor, 0, Optional<Value> >*>(static_cast<_createSubscriptionActor*>(this)));
															#line 1473 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 196 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<Void> __when_expr_6 = tr.onError(e);
															#line 196 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1510 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 7;
															#line 196 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _createSubscriptionActor, 6, Void >*>(static_cast<_createSubscriptionActor*>(this)));
															#line 1515 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& subscription,int loopDepth) 
	{
															#line 165 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (subscription.present())
															#line 1530 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 167 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (!static_cast<_createSubscriptionActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_createSubscriptionActorState(); static_cast<_createSubscriptionActor*>(this)->destroy(); return 0; }
															#line 1534 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			new (&static_cast<_createSubscriptionActor*>(this)->SAV< bool >::value()) bool(true);
			this->~_createSubscriptionActorState();
			static_cast<_createSubscriptionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 169 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(keyForInbox(inbox));
															#line 169 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1544 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 2;
															#line 169 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _createSubscriptionActor, 1, Optional<Value> >*>(static_cast<_createSubscriptionActor*>(this)));
															#line 1549 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && subscription,int loopDepth) 
	{
															#line 165 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (subscription.present())
															#line 1558 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 167 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (!static_cast<_createSubscriptionActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_createSubscriptionActorState(); static_cast<_createSubscriptionActor*>(this)->destroy(); return 0; }
															#line 1562 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			new (&static_cast<_createSubscriptionActor*>(this)->SAV< bool >::value()) bool(true);
			this->~_createSubscriptionActorState();
			static_cast<_createSubscriptionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 169 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(keyForInbox(inbox));
															#line 169 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1572 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 2;
															#line 169 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _createSubscriptionActor, 1, Optional<Value> >*>(static_cast<_createSubscriptionActor*>(this)));
															#line 1577 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& subscription,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(subscription, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && subscription,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(subscription), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state > 0) static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 0;
		static_cast<_createSubscriptionActor*>(this)->ActorCallback< _createSubscriptionActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _createSubscriptionActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _createSubscriptionActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _createSubscriptionActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Value> const& inboxVal,int loopDepth) 
	{
															#line 170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!inboxVal.present())
															#line 1661 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 171 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (!static_cast<_createSubscriptionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_createSubscriptionActorState(); static_cast<_createSubscriptionActor*>(this)->destroy(); return 0; }
															#line 1665 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			new (&static_cast<_createSubscriptionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~_createSubscriptionActorState();
			static_cast<_createSubscriptionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 173 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(keyForFeed(feed));
															#line 173 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1675 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 3;
															#line 173 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _createSubscriptionActor, 2, Optional<Value> >*>(static_cast<_createSubscriptionActor*>(this)));
															#line 1680 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && inboxVal,int loopDepth) 
	{
															#line 170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!inboxVal.present())
															#line 1689 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 171 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (!static_cast<_createSubscriptionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_createSubscriptionActorState(); static_cast<_createSubscriptionActor*>(this)->destroy(); return 0; }
															#line 1693 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			new (&static_cast<_createSubscriptionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~_createSubscriptionActorState();
			static_cast<_createSubscriptionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 173 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(keyForFeed(feed));
															#line 173 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1703 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 3;
															#line 173 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _createSubscriptionActor, 2, Optional<Value> >*>(static_cast<_createSubscriptionActor*>(this)));
															#line 1708 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& inboxVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(inboxVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && inboxVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(inboxVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state > 0) static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 0;
		static_cast<_createSubscriptionActor*>(this)->ActorCallback< _createSubscriptionActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _createSubscriptionActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _createSubscriptionActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _createSubscriptionActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Optional<Value> const& feedVal,int loopDepth) 
	{
															#line 174 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!feedVal.present())
															#line 1792 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 175 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (!static_cast<_createSubscriptionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_createSubscriptionActorState(); static_cast<_createSubscriptionActor*>(this)->destroy(); return 0; }
															#line 1796 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			new (&static_cast<_createSubscriptionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~_createSubscriptionActorState();
			static_cast<_createSubscriptionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = tr.get(keyForInboxSubscriptionCount(inbox));
															#line 179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1806 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 4;
															#line 179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _createSubscriptionActor, 3, Optional<Value> >*>(static_cast<_createSubscriptionActor*>(this)));
															#line 1811 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Optional<Value> && feedVal,int loopDepth) 
	{
															#line 174 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!feedVal.present())
															#line 1820 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 175 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (!static_cast<_createSubscriptionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_createSubscriptionActorState(); static_cast<_createSubscriptionActor*>(this)->destroy(); return 0; }
															#line 1824 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			new (&static_cast<_createSubscriptionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~_createSubscriptionActorState();
			static_cast<_createSubscriptionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = tr.get(keyForInboxSubscriptionCount(inbox));
															#line 179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1834 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 4;
															#line 179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _createSubscriptionActor, 3, Optional<Value> >*>(static_cast<_createSubscriptionActor*>(this)));
															#line 1839 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Optional<Value> const& feedVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(feedVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Optional<Value> && feedVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(feedVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state > 0) static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 0;
		static_cast<_createSubscriptionActor*>(this)->ActorCallback< _createSubscriptionActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _createSubscriptionActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _createSubscriptionActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _createSubscriptionActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(Optional<Value> const& subscriptionCountVal,int loopDepth) 
	{
															#line 180 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		uint64_t subscriptionCount = valueToUInt64(subscriptionCountVal.get());
															#line 181 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForInboxSubscription(inbox, feed), StringRef());
															#line 182 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForInboxSubscriptionCount(inbox), uInt64ToValue(subscriptionCount + 1));
															#line 185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_4 = tr.get(keyForFeedSubscriberCount(feed));
															#line 185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1931 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 5;
															#line 185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _createSubscriptionActor, 4, Optional<Value> >*>(static_cast<_createSubscriptionActor*>(this)));
															#line 1936 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Optional<Value> && subscriptionCountVal,int loopDepth) 
	{
															#line 180 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		uint64_t subscriptionCount = valueToUInt64(subscriptionCountVal.get());
															#line 181 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForInboxSubscription(inbox, feed), StringRef());
															#line 182 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForInboxSubscriptionCount(inbox), uInt64ToValue(subscriptionCount + 1));
															#line 185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_4 = tr.get(keyForFeedSubscriberCount(feed));
															#line 185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1953 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 5;
															#line 185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _createSubscriptionActor, 4, Optional<Value> >*>(static_cast<_createSubscriptionActor*>(this)));
															#line 1958 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Optional<Value> const& subscriptionCountVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(subscriptionCountVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Optional<Value> && subscriptionCountVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(subscriptionCountVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state > 0) static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 0;
		static_cast<_createSubscriptionActor*>(this)->ActorCallback< _createSubscriptionActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _createSubscriptionActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _createSubscriptionActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _createSubscriptionActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont9(Optional<Value> const& subscriberCountVal,int loopDepth) 
	{
															#line 186 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		uint64_t subscriberCount = valueToUInt64(subscriberCountVal.get());
															#line 187 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForFeedSubscriber(feed, inbox), StringRef());
															#line 188 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForFeedSubscriberCount(inbox), uInt64ToValue(subscriberCount + 1));
															#line 191 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForFeedWatcher(feed, inbox), StringRef());
															#line 193 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 193 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2052 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 6;
															#line 193 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _createSubscriptionActor, 5, Void >*>(static_cast<_createSubscriptionActor*>(this)));
															#line 2057 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9(Optional<Value> && subscriberCountVal,int loopDepth) 
	{
															#line 186 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		uint64_t subscriberCount = valueToUInt64(subscriberCountVal.get());
															#line 187 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForFeedSubscriber(feed, inbox), StringRef());
															#line 188 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForFeedSubscriberCount(inbox), uInt64ToValue(subscriberCount + 1));
															#line 191 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForFeedWatcher(feed, inbox), StringRef());
															#line 193 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 193 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2076 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 6;
															#line 193 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _createSubscriptionActor, 5, Void >*>(static_cast<_createSubscriptionActor*>(this)));
															#line 2081 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Optional<Value> const& subscriberCountVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(subscriberCountVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Optional<Value> && subscriberCountVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(subscriberCountVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state > 0) static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 0;
		static_cast<_createSubscriptionActor*>(this)->ActorCallback< _createSubscriptionActor, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _createSubscriptionActor, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _createSubscriptionActor, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _createSubscriptionActor, 4, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state > 0) static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 0;
		static_cast<_createSubscriptionActor*>(this)->ActorCallback< _createSubscriptionActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _createSubscriptionActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _createSubscriptionActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _createSubscriptionActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_createSubscriptionActor*>(this)->actor_wait_state > 0) static_cast<_createSubscriptionActor*>(this)->actor_wait_state = 0;
		static_cast<_createSubscriptionActor*>(this)->ActorCallback< _createSubscriptionActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _createSubscriptionActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _createSubscriptionActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _createSubscriptionActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Database cx;
															#line 159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	uint64_t feed;
															#line 159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	uint64_t inbox;
															#line 160 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Transaction tr;
															#line 2343 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _createSubscription()
															#line 159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class _createSubscriptionActor final : public Actor<bool>, public ActorCallback< _createSubscriptionActor, 0, Optional<Value> >, public ActorCallback< _createSubscriptionActor, 1, Optional<Value> >, public ActorCallback< _createSubscriptionActor, 2, Optional<Value> >, public ActorCallback< _createSubscriptionActor, 3, Optional<Value> >, public ActorCallback< _createSubscriptionActor, 4, Optional<Value> >, public ActorCallback< _createSubscriptionActor, 5, Void >, public ActorCallback< _createSubscriptionActor, 6, Void >, public FastAllocated<_createSubscriptionActor>, public _createSubscriptionActorState<_createSubscriptionActor> {
															#line 2348 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
	using FastAllocated<_createSubscriptionActor>::operator new;
	using FastAllocated<_createSubscriptionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13263637372518730752UL, 13472236635424993024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _createSubscriptionActor, 0, Optional<Value> >;
friend struct ActorCallback< _createSubscriptionActor, 1, Optional<Value> >;
friend struct ActorCallback< _createSubscriptionActor, 2, Optional<Value> >;
friend struct ActorCallback< _createSubscriptionActor, 3, Optional<Value> >;
friend struct ActorCallback< _createSubscriptionActor, 4, Optional<Value> >;
friend struct ActorCallback< _createSubscriptionActor, 5, Void >;
friend struct ActorCallback< _createSubscriptionActor, 6, Void >;
															#line 159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	_createSubscriptionActor(Database const& cx,uint64_t const& feed,uint64_t const& inbox) 
															#line 2371 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   _createSubscriptionActorState<_createSubscriptionActor>(cx, feed, inbox),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_createSubscription", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14946455591201745408UL, 8538846946703944448UL);
		ActorExecutionContextHelper __helper(static_cast<_createSubscriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_createSubscription");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_createSubscription", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _createSubscriptionActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _createSubscriptionActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _createSubscriptionActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _createSubscriptionActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _createSubscriptionActor, 4, Optional<Value> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _createSubscriptionActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _createSubscriptionActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
[[nodiscard]] Future<bool> _createSubscription( Database const& cx, uint64_t const& feed, uint64_t const& inbox ) {
															#line 159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	return Future<bool>(new _createSubscriptionActor(cx, feed, inbox));
															#line 2410 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
}

#line 201 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"

Future<bool> PubSub::createSubscription(uint64_t feed, uint64_t inbox) {
	return _createSubscription(cx, feed, inbox);
}

// Since we are not relying on "read-your-own-writes", we need to keep track of
//  the highest-numbered inbox that we've cleared from the watchers list and
//  make sure that further requests start after this inbox.
															#line 2422 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateFeedWatchers()
															#line 209 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
template <class UpdateFeedWatchersActor>
															#line 209 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class UpdateFeedWatchersActorState {
															#line 2429 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
															#line 209 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	UpdateFeedWatchersActorState(Transaction* const& tr,uint64_t const& feed) 
															#line 209 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
															#line 209 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		 : tr(tr),
															#line 209 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   feed(feed),
															#line 210 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   watcherPrefix(keyForFeedWatcherPrefix(feed)),
															#line 211 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   highestInbox(),
															#line 212 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   first(true)
															#line 2444 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateFeedWatchers", reinterpret_cast<unsigned long>(this));

	}
	~UpdateFeedWatchersActorState() 
	{
		fdb_probe_actor_destroy("updateFeedWatchers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 213 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			;
															#line 2459 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateFeedWatchersActorState();
		static_cast<UpdateFeedWatchersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = (*tr).getRange(firstGreaterOrEqual(keyForFeedWatcher(feed, first ? 0 : highestInbox + 1)), firstGreaterOrEqual(keyForFeedWatcher(feed, UINT64_MAX)), 100);
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<UpdateFeedWatchersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2491 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<UpdateFeedWatchersActor*>(this)->actor_wait_state = 1;
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateFeedWatchersActor, 0, RangeResult >*>(static_cast<UpdateFeedWatchersActor*>(this)));
															#line 2496 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 219 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!watchingInboxes.size())
															#line 2505 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 221 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (!static_cast<UpdateFeedWatchersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateFeedWatchersActorState(); static_cast<UpdateFeedWatchersActor*>(this)->destroy(); return 0; }
															#line 2509 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			new (&static_cast<UpdateFeedWatchersActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~UpdateFeedWatchersActorState();
			static_cast<UpdateFeedWatchersActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 222 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		first = false;
															#line 223 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		idx = 0;
															#line 224 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		for(;idx < watchingInboxes.size();idx++) {
															#line 225 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			KeyRef key = watchingInboxes[idx].key;
															#line 226 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StringRef inboxStr = key.removePrefix(watcherPrefix);
															#line 227 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			uint64_t inbox = valueToUInt64(inboxStr);
															#line 229 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			(*tr).set(keyForInboxStaleFeed(inbox, feed), StringRef());
															#line 231 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			(*tr).clear(key);
															#line 232 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			highestInbox = inbox;
															#line 2533 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		}
															#line 234 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (watchingInboxes.size() < 100)
															#line 2537 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 236 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (!static_cast<UpdateFeedWatchersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateFeedWatchersActorState(); static_cast<UpdateFeedWatchersActor*>(this)->destroy(); return 0; }
															#line 2541 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			new (&static_cast<UpdateFeedWatchersActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~UpdateFeedWatchersActorState();
			static_cast<UpdateFeedWatchersActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __watchingInboxes,int loopDepth) 
	{
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		watchingInboxes = __watchingInboxes;
															#line 2555 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __watchingInboxes,int loopDepth) 
	{
		watchingInboxes = std::move(__watchingInboxes);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateFeedWatchersActor*>(this)->actor_wait_state > 0) static_cast<UpdateFeedWatchersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateFeedWatchersActor*>(this)->ActorCallback< UpdateFeedWatchersActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateFeedWatchersActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("updateFeedWatchers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateFeedWatchersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateFeedWatchers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateFeedWatchersActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("updateFeedWatchers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateFeedWatchersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateFeedWatchers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateFeedWatchersActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("updateFeedWatchers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateFeedWatchersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateFeedWatchers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 209 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Transaction* tr;
															#line 209 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	uint64_t feed;
															#line 210 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	StringRef watcherPrefix;
															#line 211 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	uint64_t highestInbox;
															#line 212 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	bool first;
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	RangeResult watchingInboxes;
															#line 223 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	int idx;
															#line 2644 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateFeedWatchers()
															#line 209 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class UpdateFeedWatchersActor final : public Actor<Void>, public ActorCallback< UpdateFeedWatchersActor, 0, RangeResult >, public FastAllocated<UpdateFeedWatchersActor>, public UpdateFeedWatchersActorState<UpdateFeedWatchersActor> {
															#line 2649 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateFeedWatchersActor>::operator new;
	using FastAllocated<UpdateFeedWatchersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8884169786949374976UL, 7338859224238000384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateFeedWatchersActor, 0, RangeResult >;
															#line 209 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	UpdateFeedWatchersActor(Transaction* const& tr,uint64_t const& feed) 
															#line 2666 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateFeedWatchersActorState<UpdateFeedWatchersActor>(tr, feed),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateFeedWatchers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7893564901889070080UL, 3228056567618544640UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateFeedWatchersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateFeedWatchers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateFeedWatchers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateFeedWatchersActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 209 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
[[nodiscard]] Future<Void> updateFeedWatchers( Transaction* const& tr, uint64_t const& feed ) {
															#line 209 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	return Future<Void>(new UpdateFeedWatchersActor(tr, feed));
															#line 2699 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
}

#line 239 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"

/*
 * Posts a message to a feed.  This updates the list of stale feeds to all watchers.
 * Return: a per-feed (non-global) message ID.
 *
 * This needs many additions to make it "real"
 * SOMEDAY: create better global message table to enforce cross-feed ordering.
 * SOMEDAY: create a global "dispatching" list for feeds that have yet to fully update inboxes.
 *        Move feed in and remove watchers in one transaction, possibly
 * SOMEDAY: create a global list of the most-subscribed-to feeds that all inbox reads check
 */
															#line 2714 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via _postMessage()
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
template <class _postMessageActor>
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class _postMessageActorState {
															#line 2721 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	_postMessageActorState(Database const& cx,uint64_t const& feed,Standalone<StringRef> const& data) 
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		 : cx(cx),
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   feed(feed),
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   data(data),
															#line 251 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   tr(cx),
															#line 252 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   messageId(UINT64_MAX - (uint64_t)now())
															#line 2736 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_postMessage", reinterpret_cast<unsigned long>(this));

	}
	~_postMessageActorState() 
	{
		fdb_probe_actor_destroy("_postMessage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 253 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			TraceEvent("PubSubPost").detail("Feed", feed).detail("Message", messageId);
															#line 254 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			;
															#line 2753 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_postMessageActorState();
		static_cast<_postMessageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 281 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr = Transaction(cx);
															#line 282 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		;
															#line 2778 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 256 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(keyForFeed(feed));
															#line 256 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_postMessageActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2797 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_postMessageActor*>(this)->actor_wait_state = 1;
															#line 256 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _postMessageActor, 0, Optional<Value> >*>(static_cast<_postMessageActor*>(this)));
															#line 2802 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_postMessageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2839 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_postMessageActor*>(this)->actor_wait_state = 4;
															#line 278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _postMessageActor, 3, Void >*>(static_cast<_postMessageActor*>(this)));
															#line 2844 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& feedValue,int loopDepth) 
	{
															#line 257 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!feedValue.present())
															#line 2859 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 259 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (!static_cast<_postMessageActor*>(this)->SAV<uint64_t>::futures) { (void)(uint64_t(0)); this->~_postMessageActorState(); static_cast<_postMessageActor*>(this)->destroy(); return 0; }
															#line 2863 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			new (&static_cast<_postMessageActor*>(this)->SAV< uint64_t >::value()) uint64_t(uint64_t(0));
			this->~_postMessageActorState();
			static_cast<_postMessageActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 263 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(firstGreaterOrEqual(keyForMessage(0)), firstGreaterOrEqual(keyForMessage(UINT64_MAX)), 1);
															#line 263 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_postMessageActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2873 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_postMessageActor*>(this)->actor_wait_state = 2;
															#line 263 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _postMessageActor, 1, RangeResult >*>(static_cast<_postMessageActor*>(this)));
															#line 2878 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && feedValue,int loopDepth) 
	{
															#line 257 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!feedValue.present())
															#line 2887 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 259 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (!static_cast<_postMessageActor*>(this)->SAV<uint64_t>::futures) { (void)(uint64_t(0)); this->~_postMessageActorState(); static_cast<_postMessageActor*>(this)->destroy(); return 0; }
															#line 2891 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			new (&static_cast<_postMessageActor*>(this)->SAV< uint64_t >::value()) uint64_t(uint64_t(0));
			this->~_postMessageActorState();
			static_cast<_postMessageActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 263 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(firstGreaterOrEqual(keyForMessage(0)), firstGreaterOrEqual(keyForMessage(UINT64_MAX)), 1);
															#line 263 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_postMessageActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2901 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_postMessageActor*>(this)->actor_wait_state = 2;
															#line 263 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _postMessageActor, 1, RangeResult >*>(static_cast<_postMessageActor*>(this)));
															#line 2906 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& feedValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(feedValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && feedValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(feedValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_postMessageActor*>(this)->actor_wait_state > 0) static_cast<_postMessageActor*>(this)->actor_wait_state = 0;
		static_cast<_postMessageActor*>(this)->ActorCallback< _postMessageActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _postMessageActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _postMessageActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _postMessageActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 265 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!latestMessage.size())
															#line 2990 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 266 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			messageId = UINT64_MAX - 1;
															#line 2994 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		}
		else
		{
															#line 268 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StringRef messageStr = latestMessage[0].key.removePrefix(messagePrefix);
															#line 269 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			messageId = valueToUInt64(messageStr) - 1;
															#line 3002 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		}
															#line 272 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForMessage(messageId), StringRef());
															#line 273 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForDisptchEntry(messageId), StringRef());
															#line 275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_postMessageActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3012 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<_postMessageActor*>(this)->actor_wait_state = 3;
															#line 275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _postMessageActor, 2, Void >*>(static_cast<_postMessageActor*>(this)));
															#line 3017 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& __latestMessage,int loopDepth) 
	{
															#line 263 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		latestMessage = __latestMessage;
															#line 3026 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && __latestMessage,int loopDepth) 
	{
		latestMessage = std::move(__latestMessage);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_postMessageActor*>(this)->actor_wait_state > 0) static_cast<_postMessageActor*>(this)->actor_wait_state = 0;
		static_cast<_postMessageActor*>(this)->ActorCallback< _postMessageActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _postMessageActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _postMessageActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _postMessageActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_postMessageActor*>(this)->actor_wait_state > 0) static_cast<_postMessageActor*>(this)->actor_wait_state = 0;
		static_cast<_postMessageActor*>(this)->ActorCallback< _postMessageActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _postMessageActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _postMessageActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _postMessageActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_postMessageActor*>(this)->actor_wait_state > 0) static_cast<_postMessageActor*>(this)->actor_wait_state = 0;
		static_cast<_postMessageActor*>(this)->ActorCallback< _postMessageActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _postMessageActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _postMessageActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _postMessageActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 308 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!static_cast<_postMessageActor*>(this)->SAV<uint64_t>::futures) { (void)(messageId); this->~_postMessageActorState(); static_cast<_postMessageActor*>(this)->destroy(); return 0; }
															#line 3279 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		new (&static_cast<_postMessageActor*>(this)->SAV< uint64_t >::value()) uint64_t(std::move(messageId)); // state_var_RVO
		this->~_postMessageActorState();
		static_cast<_postMessageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 285 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			tr.set(keyForFeedLatestMessage(feed), uInt64ToValue(messageId));
															#line 288 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			tr.set(keyForFeedMessage(feed, messageId), StringRef());
															#line 291 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_4 = tr.get(keyForFeedMessageCount(feed));
															#line 291 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_postMessageActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3305 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_postMessageActor*>(this)->actor_wait_state = 5;
															#line 291 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _postMessageActor, 4, Optional<Value> >*>(static_cast<_postMessageActor*>(this)));
															#line 3310 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 305 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr.onError(e);
															#line 305 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_postMessageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3347 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<_postMessageActor*>(this)->actor_wait_state = 8;
															#line 305 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _postMessageActor, 7, Void >*>(static_cast<_postMessageActor*>(this)));
															#line 3352 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Value> const& cntValue,int loopDepth) 
	{
															#line 292 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		uint64_t messageCount(valueToUInt64(cntValue.get()) + 1);
															#line 293 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForFeedMessageCount(feed), uInt64ToValue(messageCount));
															#line 296 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Void> __when_expr_5 = updateFeedWatchers(&tr, feed);
															#line 296 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_postMessageActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3373 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<_postMessageActor*>(this)->actor_wait_state = 6;
															#line 296 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _postMessageActor, 5, Void >*>(static_cast<_postMessageActor*>(this)));
															#line 3378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Value> && cntValue,int loopDepth) 
	{
															#line 292 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		uint64_t messageCount(valueToUInt64(cntValue.get()) + 1);
															#line 293 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForFeedMessageCount(feed), uInt64ToValue(messageCount));
															#line 296 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Void> __when_expr_5 = updateFeedWatchers(&tr, feed);
															#line 296 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_postMessageActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3393 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<_postMessageActor*>(this)->actor_wait_state = 6;
															#line 296 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _postMessageActor, 5, Void >*>(static_cast<_postMessageActor*>(this)));
															#line 3398 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> const& cntValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(cntValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> && cntValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(cntValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_postMessageActor*>(this)->actor_wait_state > 0) static_cast<_postMessageActor*>(this)->actor_wait_state = 0;
		static_cast<_postMessageActor*>(this)->ActorCallback< _postMessageActor, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _postMessageActor, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _postMessageActor, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _postMessageActor, 4, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForMessage(messageId), data);
															#line 300 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.clear(keyForDisptchEntry(messageId));
															#line 302 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Void> __when_expr_6 = tr.commit();
															#line 302 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_postMessageActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3488 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<_postMessageActor*>(this)->actor_wait_state = 7;
															#line 302 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _postMessageActor, 6, Void >*>(static_cast<_postMessageActor*>(this)));
															#line 3493 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForMessage(messageId), data);
															#line 300 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.clear(keyForDisptchEntry(messageId));
															#line 302 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Void> __when_expr_6 = tr.commit();
															#line 302 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_postMessageActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3508 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<_postMessageActor*>(this)->actor_wait_state = 7;
															#line 302 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _postMessageActor, 6, Void >*>(static_cast<_postMessageActor*>(this)));
															#line 3513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_postMessageActor*>(this)->actor_wait_state > 0) static_cast<_postMessageActor*>(this)->actor_wait_state = 0;
		static_cast<_postMessageActor*>(this)->ActorCallback< _postMessageActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _postMessageActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _postMessageActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _postMessageActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_postMessageActor*>(this)->actor_wait_state > 0) static_cast<_postMessageActor*>(this)->actor_wait_state = 0;
		static_cast<_postMessageActor*>(this)->ActorCallback< _postMessageActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _postMessageActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _postMessageActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _postMessageActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_postMessageActor*>(this)->actor_wait_state > 0) static_cast<_postMessageActor*>(this)->actor_wait_state = 0;
		static_cast<_postMessageActor*>(this)->ActorCallback< _postMessageActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _postMessageActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _postMessageActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _postMessageActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Database cx;
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	uint64_t feed;
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Standalone<StringRef> data;
															#line 251 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Transaction tr;
															#line 252 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	uint64_t messageId;
															#line 263 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	RangeResult latestMessage;
															#line 3779 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _postMessage()
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class _postMessageActor final : public Actor<uint64_t>, public ActorCallback< _postMessageActor, 0, Optional<Value> >, public ActorCallback< _postMessageActor, 1, RangeResult >, public ActorCallback< _postMessageActor, 2, Void >, public ActorCallback< _postMessageActor, 3, Void >, public ActorCallback< _postMessageActor, 4, Optional<Value> >, public ActorCallback< _postMessageActor, 5, Void >, public ActorCallback< _postMessageActor, 6, Void >, public ActorCallback< _postMessageActor, 7, Void >, public FastAllocated<_postMessageActor>, public _postMessageActorState<_postMessageActor> {
															#line 3784 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
	using FastAllocated<_postMessageActor>::operator new;
	using FastAllocated<_postMessageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3707388422450639104UL, 10138074367626468864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<uint64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _postMessageActor, 0, Optional<Value> >;
friend struct ActorCallback< _postMessageActor, 1, RangeResult >;
friend struct ActorCallback< _postMessageActor, 2, Void >;
friend struct ActorCallback< _postMessageActor, 3, Void >;
friend struct ActorCallback< _postMessageActor, 4, Optional<Value> >;
friend struct ActorCallback< _postMessageActor, 5, Void >;
friend struct ActorCallback< _postMessageActor, 6, Void >;
friend struct ActorCallback< _postMessageActor, 7, Void >;
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	_postMessageActor(Database const& cx,uint64_t const& feed,Standalone<StringRef> const& data) 
															#line 3808 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		 : Actor<uint64_t>(),
		   _postMessageActorState<_postMessageActor>(cx, feed, data),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_postMessage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6169036144616424960UL, 3568273048941160448UL);
		ActorExecutionContextHelper __helper(static_cast<_postMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_postMessage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_postMessage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _postMessageActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _postMessageActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _postMessageActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _postMessageActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _postMessageActor, 4, Optional<Value> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _postMessageActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _postMessageActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _postMessageActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
[[nodiscard]] Future<uint64_t> _postMessage( Database const& cx, uint64_t const& feed, Standalone<StringRef> const& data ) {
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	return Future<uint64_t>(new _postMessageActor(cx, feed, data));
															#line 3848 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
}

#line 310 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"

Future<uint64_t> PubSub::postMessage(uint64_t feed, Standalone<StringRef> data) {
	return _postMessage(cx, feed, data);
}

															#line 3857 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via singlePassInboxCacheUpdate()
															#line 315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
template <class SinglePassInboxCacheUpdateActor>
															#line 315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class SinglePassInboxCacheUpdateActorState {
															#line 3864 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
															#line 315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	SinglePassInboxCacheUpdateActorState(Database const& cx,uint64_t const& inbox,int const& swath) 
															#line 315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
															#line 315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		 : cx(cx),
															#line 315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   inbox(inbox),
															#line 315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   swath(swath),
															#line 316 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   tr(cx)
															#line 3877 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this));

	}
	~SinglePassInboxCacheUpdateActorState() 
	{
		fdb_probe_actor_destroy("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 317 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			;
															#line 3892 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SinglePassInboxCacheUpdateActorState();
		static_cast<SinglePassInboxCacheUpdateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 320 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(firstGreaterOrEqual(keyForInboxStaleFeed(inbox, 0)), firstGreaterOrEqual(keyForInboxStaleFeed(inbox, UINT64_MAX)), swath);
															#line 320 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3925 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state = 1;
															#line 320 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SinglePassInboxCacheUpdateActor, 0, RangeResult >*>(static_cast<SinglePassInboxCacheUpdateActor*>(this)));
															#line 3930 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 362 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 362 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3954 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state = 5;
															#line 362 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SinglePassInboxCacheUpdateActor, 4, Void >*>(static_cast<SinglePassInboxCacheUpdateActor*>(this)));
															#line 3959 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 325 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!staleFeeds.size())
															#line 3974 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 327 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (!static_cast<SinglePassInboxCacheUpdateActor*>(this)->SAV<int>::futures) { (void)(0); this->~SinglePassInboxCacheUpdateActorState(); static_cast<SinglePassInboxCacheUpdateActor*>(this)->destroy(); return 0; }
															#line 3978 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			new (&static_cast<SinglePassInboxCacheUpdateActor*>(this)->SAV< int >::value()) int(0);
			this->~SinglePassInboxCacheUpdateActorState();
			static_cast<SinglePassInboxCacheUpdateActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 328 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		stalePrefix = keyForInboxStalePrefix(inbox);
															#line 329 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		idx = 0;
															#line 330 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		;
															#line 3990 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __staleFeeds,int loopDepth) 
	{
															#line 320 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		staleFeeds = __staleFeeds;
															#line 3999 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __staleFeeds,int loopDepth) 
	{
		staleFeeds = std::move(__staleFeeds);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state > 0) static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state = 0;
		static_cast<SinglePassInboxCacheUpdateActor*>(this)->ActorCallback< SinglePassInboxCacheUpdateActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SinglePassInboxCacheUpdateActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SinglePassInboxCacheUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SinglePassInboxCacheUpdateActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SinglePassInboxCacheUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SinglePassInboxCacheUpdateActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SinglePassInboxCacheUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 359 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 359 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4080 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state = 4;
															#line 359 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SinglePassInboxCacheUpdateActor, 3, Void >*>(static_cast<SinglePassInboxCacheUpdateActor*>(this)));
															#line 4085 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 330 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!(idx < staleFeeds.size()))
															#line 4101 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 331 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StringRef feedStr = staleFeeds[idx].key.removePrefix(stalePrefix);
															#line 333 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		feed = valueToUInt64(feedStr);
															#line 336 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(keyForFeedLatestMessage(feed));
															#line 336 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4113 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state = 2;
															#line 336 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SinglePassInboxCacheUpdateActor, 1, Optional<Value> >*>(static_cast<SinglePassInboxCacheUpdateActor*>(this)));
															#line 4118 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Optional<Value> const& v,int loopDepth) 
	{
															#line 337 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		latestMessageValue = v.get();
															#line 341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(keyForInboxCacheByFeed(inbox, feed));
															#line 341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4144 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state = 3;
															#line 341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SinglePassInboxCacheUpdateActor, 2, Optional<Value> >*>(static_cast<SinglePassInboxCacheUpdateActor*>(this)));
															#line 4149 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Optional<Value> && v,int loopDepth) 
	{
															#line 337 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		latestMessageValue = v.get();
															#line 341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(keyForInboxCacheByFeed(inbox, feed));
															#line 341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4162 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state = 3;
															#line 341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SinglePassInboxCacheUpdateActor, 2, Optional<Value> >*>(static_cast<SinglePassInboxCacheUpdateActor*>(this)));
															#line 4167 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state > 0) static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state = 0;
		static_cast<SinglePassInboxCacheUpdateActor*>(this)->ActorCallback< SinglePassInboxCacheUpdateActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< SinglePassInboxCacheUpdateActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SinglePassInboxCacheUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SinglePassInboxCacheUpdateActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SinglePassInboxCacheUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SinglePassInboxCacheUpdateActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SinglePassInboxCacheUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2loopBody1cont3(Optional<Value> const& lastCachedValue,int loopDepth) 
	{
															#line 342 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (lastCachedValue.present())
															#line 4251 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 343 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			uint64_t lastCachedId = valueToUInt64(lastCachedValue.get());
															#line 346 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			tr.clear(keyForInboxCacheByID(inbox, lastCachedId));
															#line 4257 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		}
															#line 350 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForInboxCacheByID(inbox, valueToUInt64(latestMessageValue)), uInt64ToValue(feed));
															#line 353 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForInboxCacheByFeed(inbox, feed), latestMessageValue);
															#line 354 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.clear(staleFeeds[idx].key);
															#line 356 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForFeedWatcher(feed, inbox), StringRef());
															#line 330 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		idx++;
															#line 4269 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(Optional<Value> && lastCachedValue,int loopDepth) 
	{
															#line 342 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (lastCachedValue.present())
															#line 4278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 343 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			uint64_t lastCachedId = valueToUInt64(lastCachedValue.get());
															#line 346 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			tr.clear(keyForInboxCacheByID(inbox, lastCachedId));
															#line 4284 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		}
															#line 350 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForInboxCacheByID(inbox, valueToUInt64(latestMessageValue)), uInt64ToValue(feed));
															#line 353 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForInboxCacheByFeed(inbox, feed), latestMessageValue);
															#line 354 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.clear(staleFeeds[idx].key);
															#line 356 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr.set(keyForFeedWatcher(feed, inbox), StringRef());
															#line 330 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		idx++;
															#line 4296 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1when1(Optional<Value> const& lastCachedValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(lastCachedValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1when1(Optional<Value> && lastCachedValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(std::move(lastCachedValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state > 0) static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state = 0;
		static_cast<SinglePassInboxCacheUpdateActor*>(this)->ActorCallback< SinglePassInboxCacheUpdateActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< SinglePassInboxCacheUpdateActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SinglePassInboxCacheUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SinglePassInboxCacheUpdateActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SinglePassInboxCacheUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SinglePassInboxCacheUpdateActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SinglePassInboxCacheUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 360 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!static_cast<SinglePassInboxCacheUpdateActor*>(this)->SAV<int>::futures) { (void)(staleFeeds.size()); this->~SinglePassInboxCacheUpdateActorState(); static_cast<SinglePassInboxCacheUpdateActor*>(this)->destroy(); return 0; }
															#line 4380 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		new (&static_cast<SinglePassInboxCacheUpdateActor*>(this)->SAV< int >::value()) int(staleFeeds.size());
		this->~SinglePassInboxCacheUpdateActorState();
		static_cast<SinglePassInboxCacheUpdateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 360 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!static_cast<SinglePassInboxCacheUpdateActor*>(this)->SAV<int>::futures) { (void)(staleFeeds.size()); this->~SinglePassInboxCacheUpdateActorState(); static_cast<SinglePassInboxCacheUpdateActor*>(this)->destroy(); return 0; }
															#line 4392 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		new (&static_cast<SinglePassInboxCacheUpdateActor*>(this)->SAV< int >::value()) int(staleFeeds.size());
		this->~SinglePassInboxCacheUpdateActorState();
		static_cast<SinglePassInboxCacheUpdateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state > 0) static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state = 0;
		static_cast<SinglePassInboxCacheUpdateActor*>(this)->ActorCallback< SinglePassInboxCacheUpdateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SinglePassInboxCacheUpdateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SinglePassInboxCacheUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SinglePassInboxCacheUpdateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SinglePassInboxCacheUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SinglePassInboxCacheUpdateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SinglePassInboxCacheUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state > 0) static_cast<SinglePassInboxCacheUpdateActor*>(this)->actor_wait_state = 0;
		static_cast<SinglePassInboxCacheUpdateActor*>(this)->ActorCallback< SinglePassInboxCacheUpdateActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SinglePassInboxCacheUpdateActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SinglePassInboxCacheUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< SinglePassInboxCacheUpdateActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SinglePassInboxCacheUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< SinglePassInboxCacheUpdateActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SinglePassInboxCacheUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Database cx;
															#line 315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	uint64_t inbox;
															#line 315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	int swath;
															#line 316 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Transaction tr;
															#line 320 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	RangeResult staleFeeds;
															#line 328 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	StringRef stalePrefix;
															#line 329 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	int idx;
															#line 333 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	uint64_t feed;
															#line 337 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Value latestMessageValue;
															#line 4580 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
};
// This generated class is to be used only via singlePassInboxCacheUpdate()
															#line 315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class SinglePassInboxCacheUpdateActor final : public Actor<int>, public ActorCallback< SinglePassInboxCacheUpdateActor, 0, RangeResult >, public ActorCallback< SinglePassInboxCacheUpdateActor, 1, Optional<Value> >, public ActorCallback< SinglePassInboxCacheUpdateActor, 2, Optional<Value> >, public ActorCallback< SinglePassInboxCacheUpdateActor, 3, Void >, public ActorCallback< SinglePassInboxCacheUpdateActor, 4, Void >, public FastAllocated<SinglePassInboxCacheUpdateActor>, public SinglePassInboxCacheUpdateActorState<SinglePassInboxCacheUpdateActor> {
															#line 4585 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
	using FastAllocated<SinglePassInboxCacheUpdateActor>::operator new;
	using FastAllocated<SinglePassInboxCacheUpdateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10612830124405469952UL, 1728548253620823296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SinglePassInboxCacheUpdateActor, 0, RangeResult >;
friend struct ActorCallback< SinglePassInboxCacheUpdateActor, 1, Optional<Value> >;
friend struct ActorCallback< SinglePassInboxCacheUpdateActor, 2, Optional<Value> >;
friend struct ActorCallback< SinglePassInboxCacheUpdateActor, 3, Void >;
friend struct ActorCallback< SinglePassInboxCacheUpdateActor, 4, Void >;
															#line 315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	SinglePassInboxCacheUpdateActor(Database const& cx,uint64_t const& inbox,int const& swath) 
															#line 4606 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		 : Actor<int>(),
		   SinglePassInboxCacheUpdateActorState<SinglePassInboxCacheUpdateActor>(cx, inbox, swath),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1802936468576045312UL, 61376507429246208UL);
		ActorExecutionContextHelper __helper(static_cast<SinglePassInboxCacheUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("singlePassInboxCacheUpdate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("singlePassInboxCacheUpdate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SinglePassInboxCacheUpdateActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SinglePassInboxCacheUpdateActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SinglePassInboxCacheUpdateActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SinglePassInboxCacheUpdateActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< SinglePassInboxCacheUpdateActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
[[nodiscard]] Future<int> singlePassInboxCacheUpdate( Database const& cx, uint64_t const& inbox, int const& swath ) {
															#line 315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	return Future<int>(new SinglePassInboxCacheUpdateActor(cx, inbox, swath));
															#line 4643 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
}

#line 366 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"

// SOMEDAY: evaluate if this could lead to painful loop if there's one frequent feed.
															#line 4649 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateInboxCache()
															#line 368 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
template <class UpdateInboxCacheActor>
															#line 368 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class UpdateInboxCacheActorState {
															#line 4656 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
															#line 368 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	UpdateInboxCacheActorState(Database const& cx,uint64_t const& inbox) 
															#line 368 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
															#line 368 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		 : cx(cx),
															#line 368 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   inbox(inbox),
															#line 369 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   swath(100),
															#line 370 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   updatedEntries(swath)
															#line 4669 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateInboxCache", reinterpret_cast<unsigned long>(this));

	}
	~UpdateInboxCacheActorState() 
	{
		fdb_probe_actor_destroy("updateInboxCache", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 371 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			;
															#line 4684 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateInboxCacheActorState();
		static_cast<UpdateInboxCacheActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 375 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!static_cast<UpdateInboxCacheActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateInboxCacheActorState(); static_cast<UpdateInboxCacheActor*>(this)->destroy(); return 0; }
															#line 4707 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		new (&static_cast<UpdateInboxCacheActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateInboxCacheActorState();
		static_cast<UpdateInboxCacheActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 371 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!(updatedEntries >= swath))
															#line 4726 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 372 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<int> __when_expr_0 = singlePassInboxCacheUpdate(cx, inbox, swath);
															#line 372 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<UpdateInboxCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4734 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<UpdateInboxCacheActor*>(this)->actor_wait_state = 1;
															#line 372 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateInboxCacheActor, 0, int >*>(static_cast<UpdateInboxCacheActor*>(this)));
															#line 4739 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int const& retVal,int loopDepth) 
	{
															#line 373 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		updatedEntries = retVal;
															#line 4761 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int && retVal,int loopDepth) 
	{
															#line 373 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		updatedEntries = retVal;
															#line 4770 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(int const& retVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(retVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int && retVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(retVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateInboxCacheActor*>(this)->actor_wait_state > 0) static_cast<UpdateInboxCacheActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateInboxCacheActor*>(this)->ActorCallback< UpdateInboxCacheActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateInboxCacheActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("updateInboxCache", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateInboxCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateInboxCache", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateInboxCacheActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("updateInboxCache", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateInboxCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateInboxCache", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateInboxCacheActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("updateInboxCache", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateInboxCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateInboxCache", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 368 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Database cx;
															#line 368 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	uint64_t inbox;
															#line 369 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	int swath;
															#line 370 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	int updatedEntries;
															#line 4858 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateInboxCache()
															#line 368 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class UpdateInboxCacheActor final : public Actor<Void>, public ActorCallback< UpdateInboxCacheActor, 0, int >, public FastAllocated<UpdateInboxCacheActor>, public UpdateInboxCacheActorState<UpdateInboxCacheActor> {
															#line 4863 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateInboxCacheActor>::operator new;
	using FastAllocated<UpdateInboxCacheActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14270168986986976256UL, 2139912876539140352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateInboxCacheActor, 0, int >;
															#line 368 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	UpdateInboxCacheActor(Database const& cx,uint64_t const& inbox) 
															#line 4880 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateInboxCacheActorState<UpdateInboxCacheActor>(cx, inbox),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateInboxCache", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9459408626597969920UL, 16867857213853868288UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateInboxCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateInboxCache");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateInboxCache", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateInboxCacheActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 368 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
[[nodiscard]] Future<Void> updateInboxCache( Database const& cx, uint64_t const& inbox ) {
															#line 368 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	return Future<Void>(new UpdateInboxCacheActor(cx, inbox));
															#line 4913 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
}

#line 377 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"

															#line 4918 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getFeedLatestAtOrAfter()
															#line 378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
template <class GetFeedLatestAtOrAfterActor>
															#line 378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class GetFeedLatestAtOrAfterActorState {
															#line 4925 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
															#line 378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	GetFeedLatestAtOrAfterActorState(Transaction* const& tr,Feed const& feed,MessageId const& position) 
															#line 378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
															#line 378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		 : tr(tr),
															#line 378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   feed(feed),
															#line 378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   position(position)
															#line 4936 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getFeedLatestAtOrAfter", reinterpret_cast<unsigned long>(this));

	}
	~GetFeedLatestAtOrAfterActorState() 
	{
		fdb_probe_actor_destroy("getFeedLatestAtOrAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 379 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = (*tr).getRange(firstGreaterOrEqual(keyForFeedMessage(feed, position)), firstGreaterOrEqual(keyForFeedMessage(feed, UINT64_MAX)), 1);
															#line 379 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<GetFeedLatestAtOrAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4953 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetFeedLatestAtOrAfterActor*>(this)->actor_wait_state = 1;
															#line 379 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetFeedLatestAtOrAfterActor, 0, RangeResult >*>(static_cast<GetFeedLatestAtOrAfterActor*>(this)));
															#line 4958 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetFeedLatestAtOrAfterActorState();
		static_cast<GetFeedLatestAtOrAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 382 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!lastMessageRange.size())
															#line 4981 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 383 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (!static_cast<GetFeedLatestAtOrAfterActor*>(this)->SAV<MessageId>::futures) { (void)(uint64_t(0)); this->~GetFeedLatestAtOrAfterActorState(); static_cast<GetFeedLatestAtOrAfterActor*>(this)->destroy(); return 0; }
															#line 4985 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			new (&static_cast<GetFeedLatestAtOrAfterActor*>(this)->SAV< MessageId >::value()) MessageId(uint64_t(0));
			this->~GetFeedLatestAtOrAfterActorState();
			static_cast<GetFeedLatestAtOrAfterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 384 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		KeyValueRef m = lastMessageRange[0];
															#line 385 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StringRef prefix = keyForFeedMessagePrefix(feed);
															#line 386 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StringRef mIdStr = m.key.removePrefix(prefix);
															#line 387 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!static_cast<GetFeedLatestAtOrAfterActor*>(this)->SAV<MessageId>::futures) { (void)(valueToUInt64(mIdStr)); this->~GetFeedLatestAtOrAfterActorState(); static_cast<GetFeedLatestAtOrAfterActor*>(this)->destroy(); return 0; }
															#line 4999 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		new (&static_cast<GetFeedLatestAtOrAfterActor*>(this)->SAV< MessageId >::value()) MessageId(valueToUInt64(mIdStr));
		this->~GetFeedLatestAtOrAfterActorState();
		static_cast<GetFeedLatestAtOrAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& __lastMessageRange,int loopDepth) 
	{
															#line 379 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		lastMessageRange = __lastMessageRange;
															#line 5011 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && __lastMessageRange,int loopDepth) 
	{
		lastMessageRange = std::move(__lastMessageRange);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetFeedLatestAtOrAfterActor*>(this)->actor_wait_state > 0) static_cast<GetFeedLatestAtOrAfterActor*>(this)->actor_wait_state = 0;
		static_cast<GetFeedLatestAtOrAfterActor*>(this)->ActorCallback< GetFeedLatestAtOrAfterActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetFeedLatestAtOrAfterActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getFeedLatestAtOrAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetFeedLatestAtOrAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFeedLatestAtOrAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetFeedLatestAtOrAfterActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getFeedLatestAtOrAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetFeedLatestAtOrAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFeedLatestAtOrAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetFeedLatestAtOrAfterActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getFeedLatestAtOrAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetFeedLatestAtOrAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFeedLatestAtOrAfter", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Transaction* tr;
															#line 378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Feed feed;
															#line 378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	MessageId position;
															#line 379 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	RangeResult lastMessageRange;
															#line 5094 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getFeedLatestAtOrAfter()
															#line 378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class GetFeedLatestAtOrAfterActor final : public Actor<MessageId>, public ActorCallback< GetFeedLatestAtOrAfterActor, 0, RangeResult >, public FastAllocated<GetFeedLatestAtOrAfterActor>, public GetFeedLatestAtOrAfterActorState<GetFeedLatestAtOrAfterActor> {
															#line 5099 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetFeedLatestAtOrAfterActor>::operator new;
	using FastAllocated<GetFeedLatestAtOrAfterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15723322523785403904UL, 6826575394634837248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<MessageId>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetFeedLatestAtOrAfterActor, 0, RangeResult >;
															#line 378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	GetFeedLatestAtOrAfterActor(Transaction* const& tr,Feed const& feed,MessageId const& position) 
															#line 5116 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		 : Actor<MessageId>(),
		   GetFeedLatestAtOrAfterActorState<GetFeedLatestAtOrAfterActor>(tr, feed, position),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getFeedLatestAtOrAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12290664780750759424UL, 2067969010155614720UL);
		ActorExecutionContextHelper __helper(static_cast<GetFeedLatestAtOrAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getFeedLatestAtOrAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getFeedLatestAtOrAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetFeedLatestAtOrAfterActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
[[nodiscard]] Future<MessageId> getFeedLatestAtOrAfter( Transaction* const& tr, Feed const& feed, MessageId const& position ) {
															#line 378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	return Future<MessageId>(new GetFeedLatestAtOrAfterActor(tr, feed, position));
															#line 5149 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
}

#line 389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"

															#line 5154 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getMessage()
															#line 390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
template <class GetMessageActor>
															#line 390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class GetMessageActorState {
															#line 5161 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
															#line 390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	GetMessageActorState(Transaction* const& tr,Feed const& feed,MessageId const& id) 
															#line 390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
															#line 390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		 : tr(tr),
															#line 390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   feed(feed),
															#line 390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   id(id),
															#line 391 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   m()
															#line 5174 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getMessage", reinterpret_cast<unsigned long>(this));

	}
	~GetMessageActorState() 
	{
		fdb_probe_actor_destroy("getMessage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 392 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			m.originatorFeed = feed;
															#line 393 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			m.messageId = id;
															#line 394 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(keyForMessage(id));
															#line 394 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<GetMessageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5195 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetMessageActor*>(this)->actor_wait_state = 1;
															#line 394 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetMessageActor, 0, Optional<Value> >*>(static_cast<GetMessageActor*>(this)));
															#line 5200 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetMessageActorState();
		static_cast<GetMessageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& data,int loopDepth) 
	{
															#line 395 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		m.data = data.get();
															#line 396 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!static_cast<GetMessageActor*>(this)->SAV<Message>::futures) { (void)(m); this->~GetMessageActorState(); static_cast<GetMessageActor*>(this)->destroy(); return 0; }
															#line 5225 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		new (&static_cast<GetMessageActor*>(this)->SAV< Message >::value()) Message(std::move(m)); // state_var_RVO
		this->~GetMessageActorState();
		static_cast<GetMessageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && data,int loopDepth) 
	{
															#line 395 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		m.data = data.get();
															#line 396 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!static_cast<GetMessageActor*>(this)->SAV<Message>::futures) { (void)(m); this->~GetMessageActorState(); static_cast<GetMessageActor*>(this)->destroy(); return 0; }
															#line 5239 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		new (&static_cast<GetMessageActor*>(this)->SAV< Message >::value()) Message(std::move(m)); // state_var_RVO
		this->~GetMessageActorState();
		static_cast<GetMessageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& data,int loopDepth) 
	{
		loopDepth = a_body1cont1(data, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && data,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(data), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetMessageActor*>(this)->actor_wait_state > 0) static_cast<GetMessageActor*>(this)->actor_wait_state = 0;
		static_cast<GetMessageActor*>(this)->ActorCallback< GetMessageActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetMessageActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getMessage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMessage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetMessageActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getMessage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMessage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetMessageActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getMessage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMessage", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Transaction* tr;
															#line 390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Feed feed;
															#line 390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	MessageId id;
															#line 391 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Message m;
															#line 5330 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getMessage()
															#line 390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class GetMessageActor final : public Actor<Message>, public ActorCallback< GetMessageActor, 0, Optional<Value> >, public FastAllocated<GetMessageActor>, public GetMessageActorState<GetMessageActor> {
															#line 5335 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetMessageActor>::operator new;
	using FastAllocated<GetMessageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4261103688711883264UL, 14174939972884890368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Message>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetMessageActor, 0, Optional<Value> >;
															#line 390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	GetMessageActor(Transaction* const& tr,Feed const& feed,MessageId const& id) 
															#line 5352 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		 : Actor<Message>(),
		   GetMessageActorState<GetMessageActor>(tr, feed, id),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getMessage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13191091973893237248UL, 10294551487283101696UL);
		ActorExecutionContextHelper __helper(static_cast<GetMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getMessage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getMessage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetMessageActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
[[nodiscard]] Future<Message> getMessage( Transaction* const& tr, Feed const& feed, MessageId const& id ) {
															#line 390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	return Future<Message>(new GetMessageActor(tr, feed, id));
															#line 5385 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
}

#line 398 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"

															#line 5390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
[[nodiscard]] Future<std::vector<Message>> _listInboxMessages( Database const& cx, uint64_t const& inbox, int const& count, uint64_t const& cursor );

#line 400 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"

// inboxes with MANY fast feeds may be punished by the following checks
// SOMEDAY: add a check on global lists (or on dispatching list)
															#line 5397 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via _listInboxMessages()
															#line 403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
template <class _listInboxMessagesActor>
															#line 403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class _listInboxMessagesActorState {
															#line 5404 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
															#line 403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	_listInboxMessagesActorState(Database const& cx,uint64_t const& inbox,int const& count,uint64_t const& cursor) 
															#line 403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
															#line 403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		 : cx(cx),
															#line 403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   inbox(inbox),
															#line 403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   count(count),
															#line 403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   cursor(cursor)
															#line 5417 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_listInboxMessages", reinterpret_cast<unsigned long>(this));

	}
	~_listInboxMessagesActorState() 
	{
		fdb_probe_actor_destroy("_listInboxMessages", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 404 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			TraceEvent("PubSubListInbox").detail("Inbox", inbox).detail("Count", count).detail("Cursor", cursor);
															#line 405 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<Void> __when_expr_0 = updateInboxCache(cx, inbox);
															#line 405 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5436 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 1;
															#line 405 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _listInboxMessagesActor, 0, Void >*>(static_cast<_listInboxMessagesActor*>(this)));
															#line 5441 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_listInboxMessagesActorState();
		static_cast<_listInboxMessagesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 406 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		perIdPrefix = keyForInboxCacheByIDPrefix(inbox);
															#line 407 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		;
															#line 5466 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 406 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		perIdPrefix = keyForInboxCacheByIDPrefix(inbox);
															#line 407 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		;
															#line 5477 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state > 0) static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<_listInboxMessagesActor*>(this)->ActorCallback< _listInboxMessagesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _listInboxMessagesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 408 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		tr = Transaction(cx);
															#line 409 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		messages = std::vector<Message>();
															#line 410 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		feedLatest = std::map<MessageId, Feed>();
															#line 5572 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		try {
															#line 413 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(keyForInboxSubscriptionCount(inbox));
															#line 413 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5578 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 2;
															#line 413 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _listInboxMessagesActor, 1, Optional<Value> >*>(static_cast<_listInboxMessagesActor*>(this)));
															#line 5583 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 472 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<Void> __when_expr_8 = tr.onError(e);
															#line 472 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5607 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
			static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 9;
															#line 472 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _listInboxMessagesActor, 8, Void >*>(static_cast<_listInboxMessagesActor*>(this)));
															#line 5612 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Value> const& cntValue,int loopDepth) 
	{
															#line 414 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		uint64_t subscriptions = valueToUInt64(cntValue.get());
															#line 415 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = tr.getRange(firstGreaterOrEqual(keyForInboxCacheByID(inbox, 0)), firstGreaterOrEqual(keyForInboxCacheByID(inbox, UINT64_MAX)), subscriptions);
															#line 415 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5631 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 3;
															#line 415 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _listInboxMessagesActor, 2, RangeResult >*>(static_cast<_listInboxMessagesActor*>(this)));
															#line 5636 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Value> && cntValue,int loopDepth) 
	{
															#line 414 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		uint64_t subscriptions = valueToUInt64(cntValue.get());
															#line 415 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = tr.getRange(firstGreaterOrEqual(keyForInboxCacheByID(inbox, 0)), firstGreaterOrEqual(keyForInboxCacheByID(inbox, UINT64_MAX)), subscriptions);
															#line 415 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5649 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 3;
															#line 415 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _listInboxMessagesActor, 2, RangeResult >*>(static_cast<_listInboxMessagesActor*>(this)));
															#line 5654 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> const& cntValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(cntValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> && cntValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(cntValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state > 0) static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<_listInboxMessagesActor*>(this)->ActorCallback< _listInboxMessagesActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _listInboxMessagesActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 418 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!feeds.size())
															#line 5738 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 419 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (!static_cast<_listInboxMessagesActor*>(this)->SAV<std::vector<Message>>::futures) { (void)(messages); this->~_listInboxMessagesActorState(); static_cast<_listInboxMessagesActor*>(this)->destroy(); return 0; }
															#line 5742 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			new (&static_cast<_listInboxMessagesActor*>(this)->SAV< std::vector<Message> >::value()) std::vector<Message>(std::move(messages)); // state_var_RVO
			this->~_listInboxMessagesActorState();
			static_cast<_listInboxMessagesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 422 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		idx = 0;
															#line 423 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		;
															#line 5752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(RangeResult const& __feeds,int loopDepth) 
	{
															#line 415 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		feeds = __feeds;
															#line 5761 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(RangeResult && __feeds,int loopDepth) 
	{
		feeds = std::move(__feeds);
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state > 0) static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<_listInboxMessagesActor*>(this)->ActorCallback< _listInboxMessagesActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _listInboxMessagesActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
															#line 440 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!feedLatest.size())
															#line 5840 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 441 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (!static_cast<_listInboxMessagesActor*>(this)->SAV<std::vector<Message>>::futures) { (void)(messages); this->~_listInboxMessagesActorState(); static_cast<_listInboxMessagesActor*>(this)->destroy(); return 0; }
															#line 5844 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			new (&static_cast<_listInboxMessagesActor*>(this)->SAV< std::vector<Message> >::value()) std::vector<Message>(std::move(messages)); // state_var_RVO
			this->~_listInboxMessagesActorState();
			static_cast<_listInboxMessagesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 444 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		earliestMessage = feedLatest.begin()->first;
															#line 445 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = tr.getRange(firstGreaterOrEqual(keyForDisptchEntry(earliestMessage)), firstGreaterOrEqual(keyForDisptchEntry(UINT64_MAX)), 1);
															#line 445 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5856 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 5;
															#line 445 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _listInboxMessagesActor, 4, RangeResult >*>(static_cast<_listInboxMessagesActor*>(this)));
															#line 5861 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 423 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!(idx < feeds.size()))
															#line 5877 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 424 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StringRef mIdStr = feeds[idx].key.removePrefix(perIdPrefix);
															#line 425 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		MessageId messageId = valueToUInt64(mIdStr);
															#line 426 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		feed = valueToUInt64(feeds[idx].value);
															#line 428 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (messageId >= cursor)
															#line 5889 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 430 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			feedLatest.emplace(messageId, feed);
															#line 5893 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopBody1cont3loopBody1cont1(loopDepth);
		}
		else
		{
															#line 433 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<MessageId> __when_expr_3 = getFeedLatestAtOrAfter(&tr, feed, cursor);
															#line 433 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5902 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 4;
															#line 433 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _listInboxMessagesActor, 3, MessageId >*>(static_cast<_listInboxMessagesActor*>(this)));
															#line 5907 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1(int loopDepth) 
	{
															#line 423 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		idx++;
															#line 5930 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4(MessageId const& mId,int loopDepth) 
	{
															#line 434 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (mId)
															#line 5939 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 435 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			feedLatest.emplace(mId, feed);
															#line 5943 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4(MessageId && mId,int loopDepth) 
	{
															#line 434 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (mId)
															#line 5953 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 435 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			feedLatest.emplace(mId, feed);
															#line 5957 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1when1(MessageId const& mId,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont4(mId, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1when1(MessageId && mId,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont4(std::move(mId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state > 0) static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<_listInboxMessagesActor*>(this)->ActorCallback< _listInboxMessagesActor, 3, MessageId >::remove();

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 3, MessageId >*,MessageId const& value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 3, MessageId >*,MessageId && value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _listInboxMessagesActor, 3, MessageId >*,Error err) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont6(RangeResult const& dispatching,int loopDepth) 
	{
															#line 450 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (dispatching.size())
															#line 6042 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 451 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<std::vector<Message>> __when_expr_5 = _listInboxMessages(cx, inbox, count, earliestMessage);
															#line 451 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6048 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
			static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 6;
															#line 451 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _listInboxMessagesActor, 5, std::vector<Message> >*>(static_cast<_listInboxMessagesActor*>(this)));
															#line 6053 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(RangeResult && dispatching,int loopDepth) 
	{
															#line 450 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (dispatching.size())
															#line 6067 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 451 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<std::vector<Message>> __when_expr_5 = _listInboxMessages(cx, inbox, count, earliestMessage);
															#line 451 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6073 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
			static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 6;
															#line 451 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _listInboxMessagesActor, 5, std::vector<Message> >*>(static_cast<_listInboxMessagesActor*>(this)));
															#line 6078 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(RangeResult const& dispatching,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(dispatching, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(RangeResult && dispatching,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(dispatching), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state > 0) static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<_listInboxMessagesActor*>(this)->ActorCallback< _listInboxMessagesActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _listInboxMessagesActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont8(int loopDepth) 
	{
															#line 455 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		;
															#line 6167 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont8loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(std::vector<Message> const& r,int loopDepth) 
	{
															#line 452 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!static_cast<_listInboxMessagesActor*>(this)->SAV<std::vector<Message>>::futures) { (void)(r); this->~_listInboxMessagesActorState(); static_cast<_listInboxMessagesActor*>(this)->destroy(); return 0; }
															#line 6176 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		new (&static_cast<_listInboxMessagesActor*>(this)->SAV< std::vector<Message> >::value()) std::vector<Message>(r);
		this->~_listInboxMessagesActorState();
		static_cast<_listInboxMessagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(std::vector<Message> && r,int loopDepth) 
	{
															#line 452 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!static_cast<_listInboxMessagesActor*>(this)->SAV<std::vector<Message>>::futures) { (void)(r); this->~_listInboxMessagesActorState(); static_cast<_listInboxMessagesActor*>(this)->destroy(); return 0; }
															#line 6188 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		new (&static_cast<_listInboxMessagesActor*>(this)->SAV< std::vector<Message> >::value()) std::vector<Message>(r);
		this->~_listInboxMessagesActorState();
		static_cast<_listInboxMessagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(std::vector<Message> const& r,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(r, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(std::vector<Message> && r,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state > 0) static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<_listInboxMessagesActor*>(this)->ActorCallback< _listInboxMessagesActor, 5, std::vector<Message> >::remove();

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 5, std::vector<Message> >*,std::vector<Message> const& value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 5, std::vector<Message> >*,std::vector<Message> && value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _listInboxMessagesActor, 5, std::vector<Message> >*,Error err) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont11(int loopDepth) 
	{
															#line 470 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!static_cast<_listInboxMessagesActor*>(this)->SAV<std::vector<Message>>::futures) { (void)(messages); this->~_listInboxMessagesActorState(); static_cast<_listInboxMessagesActor*>(this)->destroy(); return 0; }
															#line 6275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		new (&static_cast<_listInboxMessagesActor*>(this)->SAV< std::vector<Message> >::value()) std::vector<Message>(std::move(messages)); // state_var_RVO
		this->~_listInboxMessagesActorState();
		static_cast<_listInboxMessagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont8loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8loopBody1(int loopDepth) 
	{
															#line 455 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!(messages.size() < count && feedLatest.size() > 0))
															#line 6294 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1cont8break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 456 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		std::map<MessageId, Feed>::iterator latest = feedLatest.begin();
															#line 457 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		id = latest->first;
															#line 458 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		f = latest->second;
															#line 459 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		feedLatest.erase(latest);
															#line 461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Message> __when_expr_6 = getMessage(&tr, f, id);
															#line 461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6310 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont8loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 7;
															#line 461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _listInboxMessagesActor, 6, Message >*>(static_cast<_listInboxMessagesActor*>(this)));
															#line 6315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8loopBody1cont1(Message const& m,int loopDepth) 
	{
															#line 462 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		messages.push_back(m);
															#line 464 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<MessageId> __when_expr_7 = getFeedLatestAtOrAfter(&tr, f, id + 1);
															#line 464 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont8loopBody1cont1when1(__when_expr_7.get(), loopDepth); };
		static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 8;
															#line 464 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _listInboxMessagesActor, 7, MessageId >*>(static_cast<_listInboxMessagesActor*>(this)));
															#line 6346 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8loopBody1cont1(Message && m,int loopDepth) 
	{
															#line 462 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		messages.push_back(m);
															#line 464 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<MessageId> __when_expr_7 = getFeedLatestAtOrAfter(&tr, f, id + 1);
															#line 464 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6359 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont8loopBody1cont1when1(__when_expr_7.get(), loopDepth); };
		static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 8;
															#line 464 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _listInboxMessagesActor, 7, MessageId >*>(static_cast<_listInboxMessagesActor*>(this)));
															#line 6364 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8loopBody1when1(Message const& m,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8loopBody1cont1(m, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8loopBody1when1(Message && m,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8loopBody1cont1(std::move(m), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state > 0) static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<_listInboxMessagesActor*>(this)->ActorCallback< _listInboxMessagesActor, 6, Message >::remove();

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 6, Message >*,Message const& value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont8loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 6, Message >*,Message && value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont8loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _listInboxMessagesActor, 6, Message >*,Error err) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1cont8loopBody1cont3(MessageId const& nextMessage,int loopDepth) 
	{
															#line 465 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (nextMessage)
															#line 6448 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 466 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			feedLatest.emplace(nextMessage, f);
															#line 6452 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1cont1loopBody1cont8loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8loopBody1cont3(MessageId && nextMessage,int loopDepth) 
	{
															#line 465 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (nextMessage)
															#line 6462 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 466 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			feedLatest.emplace(nextMessage, f);
															#line 6466 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1cont1loopBody1cont8loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8loopBody1cont1when1(MessageId const& nextMessage,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8loopBody1cont3(nextMessage, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8loopBody1cont1when1(MessageId && nextMessage,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8loopBody1cont3(std::move(nextMessage), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state > 0) static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<_listInboxMessagesActor*>(this)->ActorCallback< _listInboxMessagesActor, 7, MessageId >::remove();

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 7, MessageId >*,MessageId const& value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont8loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 7, MessageId >*,MessageId && value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont8loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _listInboxMessagesActor, 7, MessageId >*,Error err) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_listInboxMessagesActor*>(this)->actor_wait_state > 0) static_cast<_listInboxMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<_listInboxMessagesActor*>(this)->ActorCallback< _listInboxMessagesActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _listInboxMessagesActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _listInboxMessagesActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Database cx;
															#line 403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	uint64_t inbox;
															#line 403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	int count;
															#line 403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	uint64_t cursor;
															#line 406 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	StringRef perIdPrefix;
															#line 408 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Transaction tr;
															#line 409 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	std::vector<Message> messages;
															#line 410 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	std::map<MessageId, Feed> feedLatest;
															#line 415 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	RangeResult feeds;
															#line 422 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	int idx;
															#line 426 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Feed feed;
															#line 444 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	MessageId earliestMessage;
															#line 457 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	MessageId id;
															#line 458 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Feed f;
															#line 6662 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _listInboxMessages()
															#line 403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class _listInboxMessagesActor final : public Actor<std::vector<Message>>, public ActorCallback< _listInboxMessagesActor, 0, Void >, public ActorCallback< _listInboxMessagesActor, 1, Optional<Value> >, public ActorCallback< _listInboxMessagesActor, 2, RangeResult >, public ActorCallback< _listInboxMessagesActor, 3, MessageId >, public ActorCallback< _listInboxMessagesActor, 4, RangeResult >, public ActorCallback< _listInboxMessagesActor, 5, std::vector<Message> >, public ActorCallback< _listInboxMessagesActor, 6, Message >, public ActorCallback< _listInboxMessagesActor, 7, MessageId >, public ActorCallback< _listInboxMessagesActor, 8, Void >, public FastAllocated<_listInboxMessagesActor>, public _listInboxMessagesActorState<_listInboxMessagesActor> {
															#line 6667 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
	using FastAllocated<_listInboxMessagesActor>::operator new;
	using FastAllocated<_listInboxMessagesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17214017188222238208UL, 10361912993711566336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<Message>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _listInboxMessagesActor, 0, Void >;
friend struct ActorCallback< _listInboxMessagesActor, 1, Optional<Value> >;
friend struct ActorCallback< _listInboxMessagesActor, 2, RangeResult >;
friend struct ActorCallback< _listInboxMessagesActor, 3, MessageId >;
friend struct ActorCallback< _listInboxMessagesActor, 4, RangeResult >;
friend struct ActorCallback< _listInboxMessagesActor, 5, std::vector<Message> >;
friend struct ActorCallback< _listInboxMessagesActor, 6, Message >;
friend struct ActorCallback< _listInboxMessagesActor, 7, MessageId >;
friend struct ActorCallback< _listInboxMessagesActor, 8, Void >;
															#line 403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	_listInboxMessagesActor(Database const& cx,uint64_t const& inbox,int const& count,uint64_t const& cursor) 
															#line 6692 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		 : Actor<std::vector<Message>>(),
		   _listInboxMessagesActorState<_listInboxMessagesActor>(cx, inbox, count, cursor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_listInboxMessages", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4930932384693687808UL, 4052175101143469056UL);
		ActorExecutionContextHelper __helper(static_cast<_listInboxMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_listInboxMessages");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_listInboxMessages", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _listInboxMessagesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _listInboxMessagesActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _listInboxMessagesActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _listInboxMessagesActor, 3, MessageId >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _listInboxMessagesActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _listInboxMessagesActor, 5, std::vector<Message> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _listInboxMessagesActor, 6, Message >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _listInboxMessagesActor, 7, MessageId >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _listInboxMessagesActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
[[nodiscard]] Future<std::vector<Message>> _listInboxMessages( Database const& cx, uint64_t const& inbox, int const& count, uint64_t const& cursor ) {
															#line 403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	return Future<std::vector<Message>>(new _listInboxMessagesActor(cx, inbox, count, cursor));
															#line 6733 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
}

#line 476 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"

Future<std::vector<Message>> PubSub::listInboxMessages(uint64_t inbox, int count, uint64_t cursor) {
	return _listInboxMessages(cx, inbox, count, cursor);
}

															#line 6742 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via _listFeedMessages()
															#line 481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
template <class _listFeedMessagesActor>
															#line 481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class _listFeedMessagesActorState {
															#line 6749 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
															#line 481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	_listFeedMessagesActorState(Database const& cx,Feed const& feed,int const& count,uint64_t const& cursor) 
															#line 481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
															#line 481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		 : cx(cx),
															#line 481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   feed(feed),
															#line 481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   count(count),
															#line 481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   cursor(cursor),
															#line 482 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   messages(),
															#line 483 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		   tr(cx)
															#line 6766 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_listFeedMessages", reinterpret_cast<unsigned long>(this));

	}
	~_listFeedMessagesActorState() 
	{
		fdb_probe_actor_destroy("_listFeedMessages", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 484 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			TraceEvent("PubSubListFeed").detail("Feed", feed).detail("Count", count).detail("Cursor", cursor);
															#line 485 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			;
															#line 6783 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_listFeedMessagesActorState();
		static_cast<_listFeedMessagesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 487 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(firstGreaterOrEqual(keyForFeedMessage(feed, cursor)), firstGreaterOrEqual(keyForFeedMessage(feed, UINT64_MAX)), count);
															#line 487 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_listFeedMessagesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6816 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_listFeedMessagesActor*>(this)->actor_wait_state = 1;
															#line 487 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _listFeedMessagesActor, 0, RangeResult >*>(static_cast<_listFeedMessagesActor*>(this)));
															#line 6821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 502 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 502 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (static_cast<_listFeedMessagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6845 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_listFeedMessagesActor*>(this)->actor_wait_state = 3;
															#line 502 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _listFeedMessagesActor, 2, Void >*>(static_cast<_listFeedMessagesActor*>(this)));
															#line 6850 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 490 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!messageIds.size())
															#line 6865 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
															#line 491 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
			if (!static_cast<_listFeedMessagesActor*>(this)->SAV<std::vector<Message>>::futures) { (void)(messages); this->~_listFeedMessagesActorState(); static_cast<_listFeedMessagesActor*>(this)->destroy(); return 0; }
															#line 6869 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
			new (&static_cast<_listFeedMessagesActor*>(this)->SAV< std::vector<Message> >::value()) std::vector<Message>(std::move(messages)); // state_var_RVO
			this->~_listFeedMessagesActorState();
			static_cast<_listFeedMessagesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 493 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		idx = 0;
															#line 494 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		;
															#line 6879 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __messageIds,int loopDepth) 
	{
															#line 487 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		messageIds = __messageIds;
															#line 6888 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __messageIds,int loopDepth) 
	{
		messageIds = std::move(__messageIds);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_listFeedMessagesActor*>(this)->actor_wait_state > 0) static_cast<_listFeedMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<_listFeedMessagesActor*>(this)->ActorCallback< _listFeedMessagesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _listFeedMessagesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_listFeedMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listFeedMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listFeedMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _listFeedMessagesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_listFeedMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listFeedMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listFeedMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _listFeedMessagesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_listFeedMessages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_listFeedMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listFeedMessages", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 500 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!static_cast<_listFeedMessagesActor*>(this)->SAV<std::vector<Message>>::futures) { (void)(messages); this->~_listFeedMessagesActorState(); static_cast<_listFeedMessagesActor*>(this)->destroy(); return 0; }
															#line 6967 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		new (&static_cast<_listFeedMessagesActor*>(this)->SAV< std::vector<Message> >::value()) std::vector<Message>(std::move(messages)); // state_var_RVO
		this->~_listFeedMessagesActorState();
		static_cast<_listFeedMessagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 494 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (!(idx < messageIds.size()))
															#line 6986 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 495 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StringRef mIdStr = messageIds[idx].key.removePrefix(keyForFeedMessagePrefix(feed));
															#line 496 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		MessageId messageId = valueToUInt64(mIdStr);
															#line 497 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		StrictFuture<Message> __when_expr_1 = getMessage(&tr, feed, messageId);
															#line 497 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		if (static_cast<_listFeedMessagesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6998 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_listFeedMessagesActor*>(this)->actor_wait_state = 2;
															#line 497 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _listFeedMessagesActor, 1, Message >*>(static_cast<_listFeedMessagesActor*>(this)));
															#line 7003 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Message const& m,int loopDepth) 
	{
															#line 498 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		messages.push_back(m);
															#line 494 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		idx++;
															#line 7027 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Message && m,int loopDepth) 
	{
															#line 498 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		messages.push_back(m);
															#line 494 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
		idx++;
															#line 7038 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Message const& m,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(m, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Message && m,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(m), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_listFeedMessagesActor*>(this)->actor_wait_state > 0) static_cast<_listFeedMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<_listFeedMessagesActor*>(this)->ActorCallback< _listFeedMessagesActor, 1, Message >::remove();

	}
	void a_callback_fire(ActorCallback< _listFeedMessagesActor, 1, Message >*,Message const& value) 
	{
		fdb_probe_actor_enter("_listFeedMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listFeedMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listFeedMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _listFeedMessagesActor, 1, Message >*,Message && value) 
	{
		fdb_probe_actor_enter("_listFeedMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listFeedMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listFeedMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _listFeedMessagesActor, 1, Message >*,Error err) 
	{
		fdb_probe_actor_enter("_listFeedMessages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_listFeedMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listFeedMessages", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_listFeedMessagesActor*>(this)->actor_wait_state > 0) static_cast<_listFeedMessagesActor*>(this)->actor_wait_state = 0;
		static_cast<_listFeedMessagesActor*>(this)->ActorCallback< _listFeedMessagesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _listFeedMessagesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_listFeedMessages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listFeedMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listFeedMessages", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _listFeedMessagesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_listFeedMessages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_listFeedMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listFeedMessages", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _listFeedMessagesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_listFeedMessages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_listFeedMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_listFeedMessages", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Database cx;
															#line 481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Feed feed;
															#line 481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	int count;
															#line 481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	uint64_t cursor;
															#line 482 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	std::vector<Message> messages;
															#line 483 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	Transaction tr;
															#line 487 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	RangeResult messageIds;
															#line 493 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	int idx;
															#line 7221 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _listFeedMessages()
															#line 481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
class _listFeedMessagesActor final : public Actor<std::vector<Message>>, public ActorCallback< _listFeedMessagesActor, 0, RangeResult >, public ActorCallback< _listFeedMessagesActor, 1, Message >, public ActorCallback< _listFeedMessagesActor, 2, Void >, public FastAllocated<_listFeedMessagesActor>, public _listFeedMessagesActorState<_listFeedMessagesActor> {
															#line 7226 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
public:
	using FastAllocated<_listFeedMessagesActor>::operator new;
	using FastAllocated<_listFeedMessagesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17931319588322140672UL, 12407542998547174400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<Message>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _listFeedMessagesActor, 0, RangeResult >;
friend struct ActorCallback< _listFeedMessagesActor, 1, Message >;
friend struct ActorCallback< _listFeedMessagesActor, 2, Void >;
															#line 481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	_listFeedMessagesActor(Database const& cx,Feed const& feed,int const& count,uint64_t const& cursor) 
															#line 7245 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
		 : Actor<std::vector<Message>>(),
		   _listFeedMessagesActorState<_listFeedMessagesActor>(cx, feed, count, cursor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_listFeedMessages", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(893818948278114048UL, 4035012386746406912UL);
		ActorExecutionContextHelper __helper(static_cast<_listFeedMessagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_listFeedMessages");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_listFeedMessages", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _listFeedMessagesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _listFeedMessagesActor, 1, Message >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _listFeedMessagesActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
[[nodiscard]] Future<std::vector<Message>> _listFeedMessages( Database const& cx, Feed const& feed, int const& count, uint64_t const& cursor ) {
															#line 481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"
	return Future<std::vector<Message>>(new _listFeedMessagesActor(cx, feed, count, cursor));
															#line 7280 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/pubsub.actor.g.cpp.py_gen"
}

#line 506 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/pubsub.actor.cpp"

Future<std::vector<Message>> PubSub::listFeedMessages(Feed feed, int count, uint64_t cursor) {
	return _listFeedMessages(cx, feed, count, cursor);
}
