#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
/*
 * RemoteIKeyValueStore.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "flow/ActorCollection.h"
#include "flow/Error.h"
#include "flow/Platform.h"
#include "flow/Trace.h"
#include "fdbrpc/FlowProcess.actor.h"
#include "fdbrpc/fdbrpc.h"
#include "fdbclient/FDBTypes.h"
#include "fdbserver/FDBExecHelper.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/RemoteIKeyValueStore.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

StringRef KeyValueStoreProcess::_name = "KeyValueStoreProcess"_sr;

// A guard for guaranteed killing of machine after runIKVS returns
struct AfterReturn {
	IKeyValueStore* kvStore;
	UID id;
	AfterReturn() : kvStore(nullptr) {}
	AfterReturn(IKeyValueStore* store, UID& uid) : kvStore(store), id(uid) {}
	~AfterReturn() {
		TraceEvent(SevDebug, "RemoteKVStoreAfterReturn")
		    .detail("Valid", kvStore != nullptr ? "True" : "False")
		    .detail("UID", id)
		    .log();
		if (kvStore != nullptr) {
			kvStore->close();
		}
	}
	// called when we already explicitly closed the kv store
	void invalidate() { kvStore = nullptr; }
};

															#line 59 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via sendCommitReply()
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
template <class SendCommitReplyActor>
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
class SendCommitReplyActorState {
															#line 66 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
public:
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	SendCommitReplyActorState(IKVSCommitRequest const& commitReq,IKeyValueStore* const& kvStore,Future<Void> const& onClosed) 
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		 : commitReq(commitReq),
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		   kvStore(kvStore),
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		   onClosed(onClosed)
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("sendCommitReply", reinterpret_cast<unsigned long>(this));

	}
	~SendCommitReplyActorState() 
	{
		fdb_probe_actor_destroy("sendCommitReply", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 60 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
				StrictFuture<Void> __when_expr_0 = onClosed;
															#line 59 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 63 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
				StrictFuture<Void> __when_expr_1 = kvStore->commit(commitReq.sequential);
															#line 97 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<SendCommitReplyActor*>(this)->actor_wait_state = 1;
															#line 60 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SendCommitReplyActor, 0, Void >*>(static_cast<SendCommitReplyActor*>(this)));
															#line 63 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SendCommitReplyActor, 1, Void >*>(static_cast<SendCommitReplyActor*>(this)));
															#line 104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<SendCommitReplyActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 69 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			TraceEvent(SevDebug, "RemoteKVSCommitReplyError").errorUnsuppressed(e);
															#line 70 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			commitReq.reply.sendError(e.code() == error_code_actor_cancelled ? remote_kvs_cancelled() : e);
															#line 141 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
															#line 61 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		commitReq.reply.sendError(remote_kvs_cancelled());
															#line 162 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
															#line 61 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		commitReq.reply.sendError(remote_kvs_cancelled());
															#line 171 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 64 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		StorageBytes storageBytes = kvStore->getStorageBytes();
															#line 65 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		commitReq.reply.send(IKVSCommitReply(storageBytes));
															#line 182 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 64 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		StorageBytes storageBytes = kvStore->getStorageBytes();
															#line 65 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		commitReq.reply.send(IKVSCommitReply(storageBytes));
															#line 193 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SendCommitReplyActor*>(this)->actor_wait_state > 0) static_cast<SendCommitReplyActor*>(this)->actor_wait_state = 0;
		static_cast<SendCommitReplyActor*>(this)->ActorCallback< SendCommitReplyActor, 0, Void >::remove();
		static_cast<SendCommitReplyActor*>(this)->ActorCallback< SendCommitReplyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendCommitReplyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendCommitReply", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendCommitReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendCommitReply", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SendCommitReplyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendCommitReply", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendCommitReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendCommitReply", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SendCommitReplyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendCommitReply", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendCommitReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendCommitReply", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SendCommitReplyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendCommitReply", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendCommitReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendCommitReply", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SendCommitReplyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendCommitReply", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendCommitReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendCommitReply", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SendCommitReplyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendCommitReply", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendCommitReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendCommitReply", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		delete static_cast<SendCommitReplyActor*>(this);
															#line 336 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		return 0;

		return loopDepth;
	}
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	IKVSCommitRequest commitReq;
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	IKeyValueStore* kvStore;
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	Future<Void> onClosed;
															#line 347 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
};
// This generated class is to be used only via sendCommitReply()
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
class SendCommitReplyActor final : public Actor<void>, public ActorCallback< SendCommitReplyActor, 0, Void >, public ActorCallback< SendCommitReplyActor, 1, Void >, public FastAllocated<SendCommitReplyActor>, public SendCommitReplyActorState<SendCommitReplyActor> {
															#line 352 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
public:
	using FastAllocated<SendCommitReplyActor>::operator new;
	using FastAllocated<SendCommitReplyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5468370990227772160UL, 519267564641404160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< SendCommitReplyActor, 0, Void >;
friend struct ActorCallback< SendCommitReplyActor, 1, Void >;
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	SendCommitReplyActor(IKVSCommitRequest const& commitReq,IKeyValueStore* const& kvStore,Future<Void> const& onClosed) 
															#line 370 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		 : Actor<void>(),
		   SendCommitReplyActorState<SendCommitReplyActor>(commitReq, kvStore, onClosed),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sendCommitReply", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4018949157325710592UL, 8811257009627996160UL);
		ActorExecutionContextHelper __helper(static_cast<SendCommitReplyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sendCommitReply");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sendCommitReply", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
void sendCommitReply( IKVSCommitRequest const& commitReq, IKeyValueStore* const& kvStore, Future<Void> const& onClosed ) {
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	new SendCommitReplyActor(commitReq, kvStore, onClosed);
															#line 394 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
}

#line 73 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"

															#line 399 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via cancellableForwardPromise()
															#line 74 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
template <class T, class CancellableForwardPromiseActor>
															#line 74 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
class CancellableForwardPromiseActorState {
															#line 406 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
public:
															#line 74 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	CancellableForwardPromiseActorState(ReplyPromise<T> const& output,Future<T> const& input) 
															#line 74 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
															#line 74 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		 : output(output),
															#line 74 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		   input(input)
															#line 415 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("cancellableForwardPromise", reinterpret_cast<unsigned long>(this));

	}
	~CancellableForwardPromiseActorState() 
	{
		fdb_probe_actor_destroy("cancellableForwardPromise", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
				StrictFuture<T> __when_expr_0 = input;
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
				if (static_cast<CancellableForwardPromiseActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 433 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CancellableForwardPromiseActor*>(this)->actor_wait_state = 1;
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CancellableForwardPromiseActor, 0, T >*>(static_cast<CancellableForwardPromiseActor*>(this)));
															#line 438 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CancellableForwardPromiseActorState();
		static_cast<CancellableForwardPromiseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 83 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		if (!static_cast<CancellableForwardPromiseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CancellableForwardPromiseActorState(); static_cast<CancellableForwardPromiseActor*>(this)->destroy(); return 0; }
															#line 467 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		new (&static_cast<CancellableForwardPromiseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CancellableForwardPromiseActorState();
		static_cast<CancellableForwardPromiseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 80 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			TraceEvent(SevDebug, "CancellableForwardPromiseError").errorUnsuppressed(e).backtrace();
															#line 81 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			output.sendError(e.code() == error_code_actor_cancelled ? remote_kvs_cancelled() : e);
															#line 482 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& value,int loopDepth) 
	{
															#line 78 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		output.send(value);
															#line 497 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(T && value,int loopDepth) 
	{
															#line 78 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		output.send(value);
															#line 506 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(T const& value,int loopDepth) 
	{
		loopDepth = a_body1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && value,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CancellableForwardPromiseActor*>(this)->actor_wait_state > 0) static_cast<CancellableForwardPromiseActor*>(this)->actor_wait_state = 0;
		static_cast<CancellableForwardPromiseActor*>(this)->ActorCallback< CancellableForwardPromiseActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< CancellableForwardPromiseActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("cancellableForwardPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancellableForwardPromiseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancellableForwardPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CancellableForwardPromiseActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("cancellableForwardPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancellableForwardPromiseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancellableForwardPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CancellableForwardPromiseActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("cancellableForwardPromise", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancellableForwardPromiseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancellableForwardPromise", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 74 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	ReplyPromise<T> output;
															#line 74 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	Future<T> input;
															#line 603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
};
// This generated class is to be used only via cancellableForwardPromise()
															#line 74 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
template <class T>
															#line 74 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
class CancellableForwardPromiseActor final : public Actor<Void>, public ActorCallback< CancellableForwardPromiseActor<T>, 0, T >, public FastAllocated<CancellableForwardPromiseActor<T>>, public CancellableForwardPromiseActorState<T, CancellableForwardPromiseActor<T>> {
															#line 610 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
public:
	using FastAllocated<CancellableForwardPromiseActor<T>>::operator new;
	using FastAllocated<CancellableForwardPromiseActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18417503988557432064UL, 17358437012642664960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CancellableForwardPromiseActor<T>, 0, T >;
															#line 74 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	CancellableForwardPromiseActor(ReplyPromise<T> const& output,Future<T> const& input) 
															#line 627 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CancellableForwardPromiseActorState<T, CancellableForwardPromiseActor<T>>(output, input),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cancellableForwardPromise", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14178162345132479488UL, 17111392524434186240UL);
		ActorExecutionContextHelper __helper(static_cast<CancellableForwardPromiseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cancellableForwardPromise");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cancellableForwardPromise", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CancellableForwardPromiseActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 74 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
template <class T>
															#line 74 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
[[nodiscard]] Future<Void> cancellableForwardPromise( ReplyPromise<T> const& output, Future<T> const& input ) {
															#line 74 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	return Future<Void>(new CancellableForwardPromiseActor<T>(output, input));
															#line 662 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
}

#line 85 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"

															#line 667 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via runIKVS()
															#line 86 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
template <class RunIKVSActor>
															#line 86 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
class RunIKVSActorState {
															#line 674 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
public:
															#line 86 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	RunIKVSActorState(OpenKVStoreRequest const& openReq,IKVSInterface const& ikvsInterface) 
															#line 86 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
															#line 86 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		 : openReq(openReq),
															#line 86 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		   ikvsInterface(ikvsInterface),
															#line 87 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		   kvStore(openKVStore(openReq.storeType, openReq.filename, openReq.logID, openReq.memoryLimit, openReq.checkChecksums, openReq.checkIntegrity)),
															#line 93 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		   kvsId(ikvsInterface.id()),
															#line 94 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		   actors(false),
															#line 95 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		   guard(kvStore, kvsId),
															#line 96 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		   onClosed()
															#line 693 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runIKVS", reinterpret_cast<unsigned long>(this));

	}
	~RunIKVSActorState() 
	{
		fdb_probe_actor_destroy("runIKVS", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 97 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			TraceEvent(SevDebug, "RemoteKVStoreInitializing").detail("UID", kvsId);
															#line 98 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			StrictFuture<Void> __when_expr_0 = kvStore->init();
															#line 98 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			if (static_cast<RunIKVSActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 712 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunIKVSActor*>(this)->actor_wait_state = 1;
															#line 98 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunIKVSActor, 0, Void >*>(static_cast<RunIKVSActor*>(this)));
															#line 717 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunIKVSActorState();
		static_cast<RunIKVSActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		openReq.reply.send(ikvsInterface);
															#line 100 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		TraceEvent(SevInfo, "RemoteKVStoreInitialized").detail("IKVSInterfaceUID", kvsId);
															#line 102 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		;
															#line 744 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		openReq.reply.send(ikvsInterface);
															#line 100 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		TraceEvent(SevInfo, "RemoteKVStoreInitialized").detail("IKVSInterfaceUID", kvsId);
															#line 102 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		;
															#line 757 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunIKVSActor*>(this)->actor_wait_state > 0) static_cast<RunIKVSActor*>(this)->actor_wait_state = 0;
		static_cast<RunIKVSActor*>(this)->ActorCallback< RunIKVSActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunIKVSActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunIKVSActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunIKVSActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			auto __when_expr_1 = ikvsInterface.getValue.getFuture();
															#line 849 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_1), FutureStream<IKVSGetValueRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<IKVSGetValueRequest>>::value, "invalid type");
															#line 104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			if (static_cast<RunIKVSActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 853 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.pop(), loopDepth); };
															#line 108 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			auto __when_expr_2 = ikvsInterface.set.getFuture();
															#line 857 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_2), FutureStream<IKVSSetRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<IKVSSetRequest>>::value, "invalid type");
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1when2(__when_expr_2.pop(), loopDepth); };
															#line 111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			auto __when_expr_3 = ikvsInterface.clear.getFuture();
															#line 862 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_3), FutureStream<IKVSClearRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<IKVSClearRequest>>::value, "invalid type");
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1when3(__when_expr_3.pop(), loopDepth); };
															#line 114 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			auto __when_expr_4 = ikvsInterface.commit.getFuture();
															#line 867 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_4), FutureStream<IKVSCommitRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<IKVSCommitRequest>>::value, "invalid type");
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1when4(__when_expr_4.pop(), loopDepth); };
															#line 117 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			auto __when_expr_5 = ikvsInterface.readValuePrefix.getFuture();
															#line 872 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_5), FutureStream<IKVSReadValuePrefixRequest>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<IKVSReadValuePrefixRequest>>::value, "invalid type");
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1when5(__when_expr_5.pop(), loopDepth); };
															#line 122 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			auto __when_expr_6 = ikvsInterface.readRange.getFuture();
															#line 877 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_6), FutureStream<IKVSReadRangeRequest>>::value || std::is_same<decltype(__when_expr_6), ThreadFutureStream<IKVSReadRangeRequest>>::value, "invalid type");
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1when6(__when_expr_6.pop(), loopDepth); };
															#line 131 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			auto __when_expr_7 = ikvsInterface.getStorageBytes.getFuture();
															#line 882 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_7), FutureStream<IKVSGetStorageByteRequest>>::value || std::is_same<decltype(__when_expr_7), ThreadFutureStream<IKVSGetStorageByteRequest>>::value, "invalid type");
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1when7(__when_expr_7.pop(), loopDepth); };
															#line 135 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			auto __when_expr_8 = ikvsInterface.getError.getFuture();
															#line 887 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_8), FutureStream<IKVSGetErrorRequest>>::value || std::is_same<decltype(__when_expr_8), ThreadFutureStream<IKVSGetErrorRequest>>::value, "invalid type");
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1when8(__when_expr_8.pop(), loopDepth); };
															#line 138 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			auto __when_expr_9 = ikvsInterface.onClosed.getFuture();
															#line 892 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_9), FutureStream<IKVSOnClosedRequest>>::value || std::is_same<decltype(__when_expr_9), ThreadFutureStream<IKVSOnClosedRequest>>::value, "invalid type");
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont1loopBody1when9(__when_expr_9.pop(), loopDepth); };
															#line 142 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			auto __when_expr_10 = ikvsInterface.dispose.getFuture();
															#line 897 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_10), FutureStream<IKVSDisposeRequest>>::value || std::is_same<decltype(__when_expr_10), ThreadFutureStream<IKVSDisposeRequest>>::value, "invalid type");
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1loopBody1when10(__when_expr_10.pop(), loopDepth); };
															#line 149 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			auto __when_expr_11 = ikvsInterface.close.getFuture();
															#line 902 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_11), FutureStream<IKVSCloseRequest>>::value || std::is_same<decltype(__when_expr_11), ThreadFutureStream<IKVSCloseRequest>>::value, "invalid type");
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1loopBody1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont1loopBody1when11(__when_expr_11.pop(), loopDepth); };
			static_cast<RunIKVSActor*>(this)->actor_wait_state = 2;
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< RunIKVSActor, 1, IKVSGetValueRequest >*>(static_cast<RunIKVSActor*>(this)));
															#line 108 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< RunIKVSActor, 2, IKVSSetRequest >*>(static_cast<RunIKVSActor*>(this)));
															#line 111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< RunIKVSActor, 3, IKVSClearRequest >*>(static_cast<RunIKVSActor*>(this)));
															#line 114 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< RunIKVSActor, 4, IKVSCommitRequest >*>(static_cast<RunIKVSActor*>(this)));
															#line 117 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< RunIKVSActor, 5, IKVSReadValuePrefixRequest >*>(static_cast<RunIKVSActor*>(this)));
															#line 122 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorSingleCallback< RunIKVSActor, 6, IKVSReadRangeRequest >*>(static_cast<RunIKVSActor*>(this)));
															#line 131 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorSingleCallback< RunIKVSActor, 7, IKVSGetStorageByteRequest >*>(static_cast<RunIKVSActor*>(this)));
															#line 135 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorSingleCallback< RunIKVSActor, 8, IKVSGetErrorRequest >*>(static_cast<RunIKVSActor*>(this)));
															#line 138 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorSingleCallback< RunIKVSActor, 9, IKVSOnClosedRequest >*>(static_cast<RunIKVSActor*>(this)));
															#line 142 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorSingleCallback< RunIKVSActor, 10, IKVSDisposeRequest >*>(static_cast<RunIKVSActor*>(this)));
															#line 149 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorSingleCallback< RunIKVSActor, 11, IKVSCloseRequest >*>(static_cast<RunIKVSActor*>(this)));
															#line 928 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 950 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			{
															#line 159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
				TraceEvent(SevInfo, "RemoteKVStoreCancelled").detail("UID", kvsId).backtrace();
															#line 160 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
				onClosed.send(Void());
															#line 161 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
				if (!static_cast<RunIKVSActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunIKVSActorState(); static_cast<RunIKVSActor*>(this)->destroy(); return 0; }
															#line 958 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
				new (&static_cast<RunIKVSActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RunIKVSActorState();
				static_cast<RunIKVSActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 163 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
				TraceEvent(SevError, "RemoteKVStoreError").error(e).detail("UID", kvsId).backtrace();
															#line 164 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 970 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(IKVSGetValueRequest const& getReq,int loopDepth) 
	{
															#line 106 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		actors.add(cancellableForwardPromise(getReq.reply, kvStore->readValue(getReq.key, getReq.options)));
															#line 991 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(IKVSGetValueRequest && getReq,int loopDepth) 
	{
															#line 106 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		actors.add(cancellableForwardPromise(getReq.reply, kvStore->readValue(getReq.key, getReq.options)));
															#line 1000 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(IKVSSetRequest const& req,int loopDepth) 
	{
															#line 109 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		kvStore->set(req.keyValue);
															#line 1009 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(IKVSSetRequest && req,int loopDepth) 
	{
															#line 109 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		kvStore->set(req.keyValue);
															#line 1018 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(IKVSClearRequest const& req,int loopDepth) 
	{
															#line 112 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		kvStore->clear(req.range);
															#line 1027 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(IKVSClearRequest && req,int loopDepth) 
	{
															#line 112 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		kvStore->clear(req.range);
															#line 1036 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when4(IKVSCommitRequest const& commitReq,int loopDepth) 
	{
															#line 115 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		sendCommitReply(commitReq, kvStore, onClosed.getFuture());
															#line 1045 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when4(IKVSCommitRequest && commitReq,int loopDepth) 
	{
															#line 115 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		sendCommitReply(commitReq, kvStore, onClosed.getFuture());
															#line 1054 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when5(IKVSReadValuePrefixRequest const& readPrefixReq,int loopDepth) 
	{
															#line 118 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		actors.add(cancellableForwardPromise( readPrefixReq.reply, kvStore->readValuePrefix(readPrefixReq.key, readPrefixReq.maxLength, readPrefixReq.options)));
															#line 1063 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when5(IKVSReadValuePrefixRequest && readPrefixReq,int loopDepth) 
	{
															#line 118 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		actors.add(cancellableForwardPromise( readPrefixReq.reply, kvStore->readValuePrefix(readPrefixReq.key, readPrefixReq.maxLength, readPrefixReq.options)));
															#line 1072 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when6(IKVSReadRangeRequest const& readRangeReq,int loopDepth) 
	{
															#line 123 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		actors.add(cancellableForwardPromise( readRangeReq.reply, fmap([](const RangeResult& result) { return IKVSReadRangeReply(result); }, kvStore->readRange(readRangeReq.keys, readRangeReq.rowLimit, readRangeReq.byteLimit, readRangeReq.options))));
															#line 1081 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when6(IKVSReadRangeRequest && readRangeReq,int loopDepth) 
	{
															#line 123 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		actors.add(cancellableForwardPromise( readRangeReq.reply, fmap([](const RangeResult& result) { return IKVSReadRangeReply(result); }, kvStore->readRange(readRangeReq.keys, readRangeReq.rowLimit, readRangeReq.byteLimit, readRangeReq.options))));
															#line 1090 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when7(IKVSGetStorageByteRequest const& req,int loopDepth) 
	{
															#line 132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		StorageBytes storageBytes = kvStore->getStorageBytes();
															#line 133 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		req.reply.send(storageBytes);
															#line 1101 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when7(IKVSGetStorageByteRequest && req,int loopDepth) 
	{
															#line 132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		StorageBytes storageBytes = kvStore->getStorageBytes();
															#line 133 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		req.reply.send(storageBytes);
															#line 1112 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when8(IKVSGetErrorRequest const& getFutureReq,int loopDepth) 
	{
															#line 136 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		actors.add(cancellableForwardPromise(getFutureReq.reply, kvStore->getError()));
															#line 1121 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when8(IKVSGetErrorRequest && getFutureReq,int loopDepth) 
	{
															#line 136 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		actors.add(cancellableForwardPromise(getFutureReq.reply, kvStore->getError()));
															#line 1130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when9(IKVSOnClosedRequest const& onClosedReq,int loopDepth) 
	{
															#line 140 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		forwardPromise(onClosedReq.reply, kvStore->onClosed());
															#line 1139 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when9(IKVSOnClosedRequest && onClosedReq,int loopDepth) 
	{
															#line 140 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		forwardPromise(onClosedReq.reply, kvStore->onClosed());
															#line 1148 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when10(IKVSDisposeRequest const& disposeReq,int loopDepth) 
	{
															#line 143 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		TraceEvent(SevDebug, "RemoteIKVSDisposeReceivedRequest").detail("UID", kvsId);
															#line 144 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		kvStore->dispose();
															#line 145 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		guard.invalidate();
															#line 146 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		onClosed.send(Void());
															#line 147 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		if (!static_cast<RunIKVSActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunIKVSActorState(); static_cast<RunIKVSActor*>(this)->destroy(); return 0; }
															#line 1165 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		new (&static_cast<RunIKVSActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunIKVSActorState();
		static_cast<RunIKVSActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when10(IKVSDisposeRequest && disposeReq,int loopDepth) 
	{
															#line 143 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		TraceEvent(SevDebug, "RemoteIKVSDisposeReceivedRequest").detail("UID", kvsId);
															#line 144 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		kvStore->dispose();
															#line 145 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		guard.invalidate();
															#line 146 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		onClosed.send(Void());
															#line 147 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		if (!static_cast<RunIKVSActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunIKVSActorState(); static_cast<RunIKVSActor*>(this)->destroy(); return 0; }
															#line 1185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		new (&static_cast<RunIKVSActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunIKVSActorState();
		static_cast<RunIKVSActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when11(IKVSCloseRequest const& closeReq,int loopDepth) 
	{
															#line 150 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		TraceEvent(SevDebug, "RemoteIKVSCloseReceivedRequest").detail("UID", kvsId);
															#line 151 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		kvStore->close();
															#line 152 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		guard.invalidate();
															#line 153 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		onClosed.send(Void());
															#line 154 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		if (!static_cast<RunIKVSActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunIKVSActorState(); static_cast<RunIKVSActor*>(this)->destroy(); return 0; }
															#line 1205 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		new (&static_cast<RunIKVSActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunIKVSActorState();
		static_cast<RunIKVSActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when11(IKVSCloseRequest && closeReq,int loopDepth) 
	{
															#line 150 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		TraceEvent(SevDebug, "RemoteIKVSCloseReceivedRequest").detail("UID", kvsId);
															#line 151 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		kvStore->close();
															#line 152 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		guard.invalidate();
															#line 153 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		onClosed.send(Void());
															#line 154 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		if (!static_cast<RunIKVSActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunIKVSActorState(); static_cast<RunIKVSActor*>(this)->destroy(); return 0; }
															#line 1225 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		new (&static_cast<RunIKVSActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunIKVSActorState();
		static_cast<RunIKVSActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunIKVSActor*>(this)->actor_wait_state > 0) static_cast<RunIKVSActor*>(this)->actor_wait_state = 0;
		static_cast<RunIKVSActor*>(this)->ActorSingleCallback< RunIKVSActor, 1, IKVSGetValueRequest >::remove();
		static_cast<RunIKVSActor*>(this)->ActorSingleCallback< RunIKVSActor, 2, IKVSSetRequest >::remove();
		static_cast<RunIKVSActor*>(this)->ActorSingleCallback< RunIKVSActor, 3, IKVSClearRequest >::remove();
		static_cast<RunIKVSActor*>(this)->ActorSingleCallback< RunIKVSActor, 4, IKVSCommitRequest >::remove();
		static_cast<RunIKVSActor*>(this)->ActorSingleCallback< RunIKVSActor, 5, IKVSReadValuePrefixRequest >::remove();
		static_cast<RunIKVSActor*>(this)->ActorSingleCallback< RunIKVSActor, 6, IKVSReadRangeRequest >::remove();
		static_cast<RunIKVSActor*>(this)->ActorSingleCallback< RunIKVSActor, 7, IKVSGetStorageByteRequest >::remove();
		static_cast<RunIKVSActor*>(this)->ActorSingleCallback< RunIKVSActor, 8, IKVSGetErrorRequest >::remove();
		static_cast<RunIKVSActor*>(this)->ActorSingleCallback< RunIKVSActor, 9, IKVSOnClosedRequest >::remove();
		static_cast<RunIKVSActor*>(this)->ActorSingleCallback< RunIKVSActor, 10, IKVSDisposeRequest >::remove();
		static_cast<RunIKVSActor*>(this)->ActorSingleCallback< RunIKVSActor, 11, IKVSCloseRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 1, IKVSGetValueRequest >*,IKVSGetValueRequest const& value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 1, IKVSGetValueRequest >*,IKVSGetValueRequest && value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< RunIKVSActor, 1, IKVSGetValueRequest >*,Error err) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 2, IKVSSetRequest >*,IKVSSetRequest const& value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 2, IKVSSetRequest >*,IKVSSetRequest && value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< RunIKVSActor, 2, IKVSSetRequest >*,Error err) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 3, IKVSClearRequest >*,IKVSClearRequest const& value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 3, IKVSClearRequest >*,IKVSClearRequest && value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< RunIKVSActor, 3, IKVSClearRequest >*,Error err) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 4, IKVSCommitRequest >*,IKVSCommitRequest const& value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 4, IKVSCommitRequest >*,IKVSCommitRequest && value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< RunIKVSActor, 4, IKVSCommitRequest >*,Error err) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 5, IKVSReadValuePrefixRequest >*,IKVSReadValuePrefixRequest const& value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 5, IKVSReadValuePrefixRequest >*,IKVSReadValuePrefixRequest && value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< RunIKVSActor, 5, IKVSReadValuePrefixRequest >*,Error err) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 6, IKVSReadRangeRequest >*,IKVSReadRangeRequest const& value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 6, IKVSReadRangeRequest >*,IKVSReadRangeRequest && value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorSingleCallback< RunIKVSActor, 6, IKVSReadRangeRequest >*,Error err) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 7, IKVSGetStorageByteRequest >*,IKVSGetStorageByteRequest const& value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 7, IKVSGetStorageByteRequest >*,IKVSGetStorageByteRequest && value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorSingleCallback< RunIKVSActor, 7, IKVSGetStorageByteRequest >*,Error err) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 8, IKVSGetErrorRequest >*,IKVSGetErrorRequest const& value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 8, IKVSGetErrorRequest >*,IKVSGetErrorRequest && value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorSingleCallback< RunIKVSActor, 8, IKVSGetErrorRequest >*,Error err) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 9, IKVSOnClosedRequest >*,IKVSOnClosedRequest const& value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when9(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 9, IKVSOnClosedRequest >*,IKVSOnClosedRequest && value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorSingleCallback< RunIKVSActor, 9, IKVSOnClosedRequest >*,Error err) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 10, IKVSDisposeRequest >*,IKVSDisposeRequest const& value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when10(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 10, IKVSDisposeRequest >*,IKVSDisposeRequest && value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when10(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorSingleCallback< RunIKVSActor, 10, IKVSDisposeRequest >*,Error err) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 11, IKVSCloseRequest >*,IKVSCloseRequest const& value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when11(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorSingleCallback< RunIKVSActor, 11, IKVSCloseRequest >*,IKVSCloseRequest && value) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when11(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorSingleCallback< RunIKVSActor, 11, IKVSCloseRequest >*,Error err) 
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 86 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	OpenKVStoreRequest openReq;
															#line 86 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	IKVSInterface ikvsInterface;
															#line 87 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	IKeyValueStore* kvStore;
															#line 93 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	UID kvsId;
															#line 94 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	ActorCollection actors;
															#line 95 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	AfterReturn guard;
															#line 96 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	Promise<Void> onClosed;
															#line 1903 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runIKVS()
															#line 86 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
class RunIKVSActor final : public Actor<Void>, public ActorCallback< RunIKVSActor, 0, Void >, public ActorSingleCallback< RunIKVSActor, 1, IKVSGetValueRequest >, public ActorSingleCallback< RunIKVSActor, 2, IKVSSetRequest >, public ActorSingleCallback< RunIKVSActor, 3, IKVSClearRequest >, public ActorSingleCallback< RunIKVSActor, 4, IKVSCommitRequest >, public ActorSingleCallback< RunIKVSActor, 5, IKVSReadValuePrefixRequest >, public ActorSingleCallback< RunIKVSActor, 6, IKVSReadRangeRequest >, public ActorSingleCallback< RunIKVSActor, 7, IKVSGetStorageByteRequest >, public ActorSingleCallback< RunIKVSActor, 8, IKVSGetErrorRequest >, public ActorSingleCallback< RunIKVSActor, 9, IKVSOnClosedRequest >, public ActorSingleCallback< RunIKVSActor, 10, IKVSDisposeRequest >, public ActorSingleCallback< RunIKVSActor, 11, IKVSCloseRequest >, public FastAllocated<RunIKVSActor>, public RunIKVSActorState<RunIKVSActor> {
															#line 1908 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunIKVSActor>::operator new;
	using FastAllocated<RunIKVSActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14260205191425460224UL, 14241933384135818240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunIKVSActor, 0, Void >;
friend struct ActorSingleCallback< RunIKVSActor, 1, IKVSGetValueRequest >;
friend struct ActorSingleCallback< RunIKVSActor, 2, IKVSSetRequest >;
friend struct ActorSingleCallback< RunIKVSActor, 3, IKVSClearRequest >;
friend struct ActorSingleCallback< RunIKVSActor, 4, IKVSCommitRequest >;
friend struct ActorSingleCallback< RunIKVSActor, 5, IKVSReadValuePrefixRequest >;
friend struct ActorSingleCallback< RunIKVSActor, 6, IKVSReadRangeRequest >;
friend struct ActorSingleCallback< RunIKVSActor, 7, IKVSGetStorageByteRequest >;
friend struct ActorSingleCallback< RunIKVSActor, 8, IKVSGetErrorRequest >;
friend struct ActorSingleCallback< RunIKVSActor, 9, IKVSOnClosedRequest >;
friend struct ActorSingleCallback< RunIKVSActor, 10, IKVSDisposeRequest >;
friend struct ActorSingleCallback< RunIKVSActor, 11, IKVSCloseRequest >;
															#line 86 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	RunIKVSActor(OpenKVStoreRequest const& openReq,IKVSInterface const& ikvsInterface) 
															#line 1936 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RunIKVSActorState<RunIKVSActor>(openReq, ikvsInterface),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runIKVS", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7428424660835887616UL, 15533406105398116352UL);
		ActorExecutionContextHelper __helper(static_cast<RunIKVSActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runIKVS");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runIKVS", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunIKVSActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< RunIKVSActor, 1, IKVSGetValueRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 86 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
[[nodiscard]] Future<Void> runIKVS( OpenKVStoreRequest const& openReq, IKVSInterface const& ikvsInterface ) {
															#line 86 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	return Future<Void>(new RunIKVSActor(openReq, ikvsInterface));
															#line 1970 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
}

#line 169 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"

															#line 1975 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via flowProcessRunner()
															#line 170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
template <class FlowProcessRunnerActor>
															#line 170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
class FlowProcessRunnerActorState {
															#line 1982 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
public:
															#line 170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	FlowProcessRunnerActorState(RemoteIKeyValueStore* const& self,Promise<Void> const& ready) 
															#line 170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
															#line 170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		 : self(self),
															#line 170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		   ready(ready),
															#line 171 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		   processInterface(),
															#line 172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		   process()
															#line 1995 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowProcessRunner", reinterpret_cast<unsigned long>(this));

	}
	~FlowProcessRunnerActorState() 
	{
		fdb_probe_actor_destroy("flowProcessRunner", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 174 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			auto path = abspath(getExecPath());
															#line 175 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			auto endpoint = processInterface.registerProcess.getEndpoint();
															#line 176 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			auto address = endpoint.addresses.address.toString();
															#line 177 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			auto token = endpoint.token;
															#line 180 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			std::string flowProcessAddr = g_network->getLocalAddress().ip.toString().append(":0");
															#line 181 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			std::vector<std::string> args = { "bin/fdbserver", "-r", "flowprocess", "-C", SERVER_KNOBS->CONN_FILE, "--logdir", SERVER_KNOBS->LOG_DIRECTORY, "--trace-format", getTraceFormatExtension(), "-p", flowProcessAddr, "--process-name", KeyValueStoreProcess::_name.toString(), "--process-endpoint", format("%s,%lu,%lu", address.c_str(), token.first(), token.second()) };
															#line 198 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			process = spawnProcess(path, args, -1.0, false, 0.01 , self);
															#line 200 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			auto __when_expr_0 = processInterface.registerProcess.getFuture();
															#line 2024 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<FlowProcessRegistrationRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<FlowProcessRegistrationRequest>>::value, "invalid type");
															#line 199 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			if (static_cast<FlowProcessRunnerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2028 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
															#line 204 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			StrictFuture<int> __when_expr_1 = process;
															#line 2032 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<FlowProcessRunnerActor*>(this)->actor_wait_state = 1;
															#line 200 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< FlowProcessRunnerActor, 0, FlowProcessRegistrationRequest >*>(static_cast<FlowProcessRunnerActor*>(this)));
															#line 204 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowProcessRunnerActor, 1, int >*>(static_cast<FlowProcessRunnerActor*>(this)));
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowProcessRunnerActorState();
		static_cast<FlowProcessRunnerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 211 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		StrictFuture<int> __when_expr_2 = process;
															#line 211 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		if (static_cast<FlowProcessRunnerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2064 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowProcessRunnerActor*>(this)->actor_wait_state = 2;
															#line 211 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowProcessRunnerActor, 2, int >*>(static_cast<FlowProcessRunnerActor*>(this)));
															#line 2069 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(FlowProcessRegistrationRequest const& req,int loopDepth) 
	{
															#line 201 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		self->consumeInterface(req.flowProcessInterface);
															#line 202 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		ready.send(Void());
															#line 2080 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(FlowProcessRegistrationRequest && req,int loopDepth) 
	{
															#line 201 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		self->consumeInterface(req.flowProcessInterface);
															#line 202 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		ready.send(Void());
															#line 2091 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(int const& res,int loopDepth) 
	{
															#line 207 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		ASSERT(res);
															#line 208 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		if (!static_cast<FlowProcessRunnerActor*>(this)->SAV<int>::futures) { (void)(res); this->~FlowProcessRunnerActorState(); static_cast<FlowProcessRunnerActor*>(this)->destroy(); return 0; }
															#line 2102 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		new (&static_cast<FlowProcessRunnerActor*>(this)->SAV< int >::value()) int(res);
		this->~FlowProcessRunnerActorState();
		static_cast<FlowProcessRunnerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(int && res,int loopDepth) 
	{
															#line 207 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		ASSERT(res);
															#line 208 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		if (!static_cast<FlowProcessRunnerActor*>(this)->SAV<int>::futures) { (void)(res); this->~FlowProcessRunnerActorState(); static_cast<FlowProcessRunnerActor*>(this)->destroy(); return 0; }
															#line 2116 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		new (&static_cast<FlowProcessRunnerActor*>(this)->SAV< int >::value()) int(res);
		this->~FlowProcessRunnerActorState();
		static_cast<FlowProcessRunnerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowProcessRunnerActor*>(this)->actor_wait_state > 0) static_cast<FlowProcessRunnerActor*>(this)->actor_wait_state = 0;
		static_cast<FlowProcessRunnerActor*>(this)->ActorSingleCallback< FlowProcessRunnerActor, 0, FlowProcessRegistrationRequest >::remove();
		static_cast<FlowProcessRunnerActor*>(this)->ActorCallback< FlowProcessRunnerActor, 1, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowProcessRunnerActor, 0, FlowProcessRegistrationRequest >*,FlowProcessRegistrationRequest const& value) 
	{
		fdb_probe_actor_enter("flowProcessRunner", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowProcessRunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowProcessRunner", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< FlowProcessRunnerActor, 0, FlowProcessRegistrationRequest >*,FlowProcessRegistrationRequest && value) 
	{
		fdb_probe_actor_enter("flowProcessRunner", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowProcessRunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowProcessRunner", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< FlowProcessRunnerActor, 0, FlowProcessRegistrationRequest >*,Error err) 
	{
		fdb_probe_actor_enter("flowProcessRunner", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowProcessRunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowProcessRunner", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowProcessRunnerActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowProcessRunner", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowProcessRunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowProcessRunner", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowProcessRunnerActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowProcessRunner", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowProcessRunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowProcessRunner", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowProcessRunnerActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowProcessRunner", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowProcessRunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowProcessRunner", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int const& res,int loopDepth) 
	{
															#line 212 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		if (!static_cast<FlowProcessRunnerActor*>(this)->SAV<int>::futures) { (void)(res); this->~FlowProcessRunnerActorState(); static_cast<FlowProcessRunnerActor*>(this)->destroy(); return 0; }
															#line 2249 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		new (&static_cast<FlowProcessRunnerActor*>(this)->SAV< int >::value()) int(res);
		this->~FlowProcessRunnerActorState();
		static_cast<FlowProcessRunnerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int && res,int loopDepth) 
	{
															#line 212 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		if (!static_cast<FlowProcessRunnerActor*>(this)->SAV<int>::futures) { (void)(res); this->~FlowProcessRunnerActorState(); static_cast<FlowProcessRunnerActor*>(this)->destroy(); return 0; }
															#line 2261 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		new (&static_cast<FlowProcessRunnerActor*>(this)->SAV< int >::value()) int(res);
		this->~FlowProcessRunnerActorState();
		static_cast<FlowProcessRunnerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int const& res,int loopDepth) 
	{
		loopDepth = a_body1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && res,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowProcessRunnerActor*>(this)->actor_wait_state > 0) static_cast<FlowProcessRunnerActor*>(this)->actor_wait_state = 0;
		static_cast<FlowProcessRunnerActor*>(this)->ActorCallback< FlowProcessRunnerActor, 2, int >::remove();

	}
	void a_callback_fire(ActorCallback< FlowProcessRunnerActor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("flowProcessRunner", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowProcessRunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowProcessRunner", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowProcessRunnerActor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("flowProcessRunner", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowProcessRunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowProcessRunner", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowProcessRunnerActor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("flowProcessRunner", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowProcessRunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowProcessRunner", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	RemoteIKeyValueStore* self;
															#line 170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	Promise<Void> ready;
															#line 171 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	FlowProcessInterface processInterface;
															#line 172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	Future<int> process;
															#line 2352 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowProcessRunner()
															#line 170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
class FlowProcessRunnerActor final : public Actor<int>, public ActorSingleCallback< FlowProcessRunnerActor, 0, FlowProcessRegistrationRequest >, public ActorCallback< FlowProcessRunnerActor, 1, int >, public ActorCallback< FlowProcessRunnerActor, 2, int >, public FastAllocated<FlowProcessRunnerActor>, public FlowProcessRunnerActorState<FlowProcessRunnerActor> {
															#line 2357 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowProcessRunnerActor>::operator new;
	using FastAllocated<FlowProcessRunnerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14378887188162832128UL, 16095394014378601216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< FlowProcessRunnerActor, 0, FlowProcessRegistrationRequest >;
friend struct ActorCallback< FlowProcessRunnerActor, 1, int >;
friend struct ActorCallback< FlowProcessRunnerActor, 2, int >;
															#line 170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	FlowProcessRunnerActor(RemoteIKeyValueStore* const& self,Promise<Void> const& ready) 
															#line 2376 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		 : Actor<int>(),
		   FlowProcessRunnerActorState<FlowProcessRunnerActor>(self, ready),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowProcessRunner", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3867423986070682368UL, 2440192850160505856UL);
		ActorExecutionContextHelper __helper(static_cast<FlowProcessRunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowProcessRunner");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowProcessRunner", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< FlowProcessRunnerActor, 0, FlowProcessRegistrationRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowProcessRunnerActor, 2, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
[[nodiscard]] static Future<int> flowProcessRunner( RemoteIKeyValueStore* const& self, Promise<Void> const& ready ) {
															#line 170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	return Future<int>(new FlowProcessRunnerActor(self, ready));
															#line 2410 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
}

#line 214 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"

															#line 2415 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via initializeRemoteKVStore()
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
template <class InitializeRemoteKVStoreActor>
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
class InitializeRemoteKVStoreActorState {
															#line 2422 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
public:
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	InitializeRemoteKVStoreActorState(RemoteIKeyValueStore* const& self,OpenKVStoreRequest const& openKVSReq) 
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		 : self(self),
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		   openKVSReq(openKVSReq)
															#line 2431 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("initializeRemoteKVStore", reinterpret_cast<unsigned long>(this));

	}
	~InitializeRemoteKVStoreActorState() 
	{
		fdb_probe_actor_destroy("initializeRemoteKVStore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 216 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			TraceEvent(SevInfo, "WaitingOnFlowProcess").detail("StoreType", openKVSReq.storeType).log();
															#line 217 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			Promise<Void> ready;
															#line 218 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			self->returnCode = flowProcessRunner(self, ready);
															#line 219 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			StrictFuture<Void> __when_expr_0 = ready.getFuture();
															#line 219 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			if (static_cast<InitializeRemoteKVStoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2454 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<InitializeRemoteKVStoreActor*>(this)->actor_wait_state = 1;
															#line 219 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InitializeRemoteKVStoreActor, 0, Void >*>(static_cast<InitializeRemoteKVStoreActor*>(this)));
															#line 2459 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InitializeRemoteKVStoreActorState();
		static_cast<InitializeRemoteKVStoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 220 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		StrictFuture<IKVSInterface> __when_expr_1 = self->kvsProcess.openKVStore.getReply(openKVSReq);
															#line 220 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		if (static_cast<InitializeRemoteKVStoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2484 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<InitializeRemoteKVStoreActor*>(this)->actor_wait_state = 2;
															#line 220 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InitializeRemoteKVStoreActor, 1, IKVSInterface >*>(static_cast<InitializeRemoteKVStoreActor*>(this)));
															#line 2489 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 220 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		StrictFuture<IKVSInterface> __when_expr_1 = self->kvsProcess.openKVStore.getReply(openKVSReq);
															#line 220 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		if (static_cast<InitializeRemoteKVStoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2500 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<InitializeRemoteKVStoreActor*>(this)->actor_wait_state = 2;
															#line 220 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InitializeRemoteKVStoreActor, 1, IKVSInterface >*>(static_cast<InitializeRemoteKVStoreActor*>(this)));
															#line 2505 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InitializeRemoteKVStoreActor*>(this)->actor_wait_state > 0) static_cast<InitializeRemoteKVStoreActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeRemoteKVStoreActor*>(this)->ActorCallback< InitializeRemoteKVStoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeRemoteKVStoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initializeRemoteKVStore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeRemoteKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeRemoteKVStore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InitializeRemoteKVStoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initializeRemoteKVStore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeRemoteKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeRemoteKVStore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InitializeRemoteKVStoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initializeRemoteKVStore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeRemoteKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeRemoteKVStore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(IKVSInterface const& ikvsInterface,int loopDepth) 
	{
															#line 221 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		TraceEvent(SevInfo, "IKVSInterfaceReceived").detail("UID", ikvsInterface.id());
															#line 222 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		self->interf = ikvsInterface;
															#line 223 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		self->interf.storeType = openKVSReq.storeType;
															#line 224 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		if (!static_cast<InitializeRemoteKVStoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeRemoteKVStoreActorState(); static_cast<InitializeRemoteKVStoreActor*>(this)->destroy(); return 0; }
															#line 2595 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		new (&static_cast<InitializeRemoteKVStoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeRemoteKVStoreActorState();
		static_cast<InitializeRemoteKVStoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(IKVSInterface && ikvsInterface,int loopDepth) 
	{
															#line 221 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		TraceEvent(SevInfo, "IKVSInterfaceReceived").detail("UID", ikvsInterface.id());
															#line 222 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		self->interf = ikvsInterface;
															#line 223 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		self->interf.storeType = openKVSReq.storeType;
															#line 224 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
		if (!static_cast<InitializeRemoteKVStoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeRemoteKVStoreActorState(); static_cast<InitializeRemoteKVStoreActor*>(this)->destroy(); return 0; }
															#line 2613 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		new (&static_cast<InitializeRemoteKVStoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeRemoteKVStoreActorState();
		static_cast<InitializeRemoteKVStoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(IKVSInterface const& ikvsInterface,int loopDepth) 
	{
		loopDepth = a_body1cont2(ikvsInterface, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(IKVSInterface && ikvsInterface,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(ikvsInterface), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<InitializeRemoteKVStoreActor*>(this)->actor_wait_state > 0) static_cast<InitializeRemoteKVStoreActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeRemoteKVStoreActor*>(this)->ActorCallback< InitializeRemoteKVStoreActor, 1, IKVSInterface >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeRemoteKVStoreActor, 1, IKVSInterface >*,IKVSInterface const& value) 
	{
		fdb_probe_actor_enter("initializeRemoteKVStore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeRemoteKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeRemoteKVStore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< InitializeRemoteKVStoreActor, 1, IKVSInterface >*,IKVSInterface && value) 
	{
		fdb_probe_actor_enter("initializeRemoteKVStore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeRemoteKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeRemoteKVStore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< InitializeRemoteKVStoreActor, 1, IKVSInterface >*,Error err) 
	{
		fdb_probe_actor_enter("initializeRemoteKVStore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeRemoteKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeRemoteKVStore", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	RemoteIKeyValueStore* self;
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	OpenKVStoreRequest openKVSReq;
															#line 2700 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
};
// This generated class is to be used only via initializeRemoteKVStore()
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
class InitializeRemoteKVStoreActor final : public Actor<Void>, public ActorCallback< InitializeRemoteKVStoreActor, 0, Void >, public ActorCallback< InitializeRemoteKVStoreActor, 1, IKVSInterface >, public FastAllocated<InitializeRemoteKVStoreActor>, public InitializeRemoteKVStoreActorState<InitializeRemoteKVStoreActor> {
															#line 2705 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
public:
	using FastAllocated<InitializeRemoteKVStoreActor>::operator new;
	using FastAllocated<InitializeRemoteKVStoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11593622518380320512UL, 12955605328247850496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InitializeRemoteKVStoreActor, 0, Void >;
friend struct ActorCallback< InitializeRemoteKVStoreActor, 1, IKVSInterface >;
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	InitializeRemoteKVStoreActor(RemoteIKeyValueStore* const& self,OpenKVStoreRequest const& openKVSReq) 
															#line 2723 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   InitializeRemoteKVStoreActorState<InitializeRemoteKVStoreActor>(self, openKVSReq),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("initializeRemoteKVStore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13849479446456446208UL, 5578578056755840256UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeRemoteKVStoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("initializeRemoteKVStore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("initializeRemoteKVStore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InitializeRemoteKVStoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< InitializeRemoteKVStoreActor, 1, IKVSInterface >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
[[nodiscard]] static Future<Void> initializeRemoteKVStore( RemoteIKeyValueStore* const& self, OpenKVStoreRequest const& openKVSReq ) {
															#line 215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"
	return Future<Void>(new InitializeRemoteKVStoreActor(self, openKVSReq));
															#line 2757 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbserver/RemoteIKeyValueStore.actor.g.cpp.py_gen"
}

#line 226 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbserver/RemoteIKeyValueStore.actor.cpp"

IKeyValueStore* openRemoteKVStore(KeyValueStoreType storeType,
                                  std::string const& filename,
                                  UID logID,
                                  int64_t memoryLimit,
                                  bool checkChecksums,
                                  bool checkIntegrity) {
	RemoteIKeyValueStore* self = new RemoteIKeyValueStore();
	self->initialized = initializeRemoteKVStore(
	    self, OpenKVStoreRequest(storeType, filename, logID, memoryLimit, checkChecksums, checkIntegrity));
	return self;
}

Future<Void> runFlowProcess(std::string const& name, Endpoint endpoint) {
	TraceEvent(SevInfo, "RunFlowProcessStart").log();
	FlowProcess* self = IProcessFactory::create(name.c_str());
	self->registerEndpoint(endpoint);
	RequestStream<FlowProcessRegistrationRequest> registerProcess(endpoint);
	FlowProcessRegistrationRequest req;
	req.flowProcessInterface = self->serializedInterface();
	registerProcess.send(req);
	TraceEvent(SevDebug, "FlowProcessInitFinished").log();
	return self->run();
}
