#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
/*
 * FileBackupAgent.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/DatabaseConfiguration.h"
#include "fdbrpc/simulator.h"
#include "flow/EncryptUtils.h"
#include "flow/FastRef.h"
#include "flow/flow.h"
#include "fmt/format.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BackupContainerFileSystem.h"
#include "fdbclient/BlobCipher.h"
#include "fdbclient/BulkDumping.h"
#include "fdbclient/BulkLoading.h"
#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/GetEncryptCipherKeys.h"
#include "fdbclient/JsonBuilder.h"
#include "fdbclient/JSONDoc.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/KeyRangeMap.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/PartitionedLogIterator.h"
#include "fdbclient/RestoreInterface.h"
#include "fdbclient/Status.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/TaskBucket.h"
#include "flow/network.h"
#include "flow/Trace.h"

#include <cinttypes>
#include <cstdint>
#include <ctime>
#include <climits>
#include "flow/IAsyncFile.h"
#include "flow/genericactors.actor.h"
#include "flow/Hash3.h"
#include "flow/xxhash.h"

#include <memory>
#include <numeric>
#include <boost/algorithm/string/split.hpp>
#include <boost/algorithm/string/classification.hpp>
#include <algorithm>
#include <unordered_map>
#include <utility>

#include "flow/actorcompiler.h" // This must be the last #include.

// Counters to verify BulkDump/BulkLoad were actually used (for test assertions)
std::atomic<int> g_bulkDumpTaskCompleteCount(0);
std::atomic<int> g_bulkLoadRestoreTaskCompleteCount(0);

// Helper function to monitor BulkDump job completion
// Returns true if job completed successfully, false if timed out
															#line 79 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorBulkDumpJobCompletion()
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class MonitorBulkDumpJobCompletionActor>
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class MonitorBulkDumpJobCompletionActorState {
															#line 86 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	MonitorBulkDumpJobCompletionActorState(Database const& cx,UID const& jobId,double const& timeoutDuration,double const& pollInterval) 
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : cx(cx),
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   jobId(jobId),
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   timeoutDuration(timeoutDuration),
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   pollInterval(pollInterval),
															#line 78 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   timeoutStart(now()),
															#line 79 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(cx)
															#line 103 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this));

	}
	~MonitorBulkDumpJobCompletionActorState() 
	{
		fdb_probe_actor_destroy("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 81 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			;
															#line 118 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorBulkDumpJobCompletionActorState();
		static_cast<MonitorBulkDumpJobCompletionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 83 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Optional<BulkDumpState>> __when_expr_0 = getSubmittedBulkDumpJob(&tr);
															#line 83 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 151 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state = 1;
															#line 83 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorBulkDumpJobCompletionActor, 0, Optional<BulkDumpState> >*>(static_cast<MonitorBulkDumpJobCompletionActor*>(this)));
															#line 156 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 97 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 97 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 180 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state = 3;
															#line 97 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorBulkDumpJobCompletionActor, 2, Void >*>(static_cast<MonitorBulkDumpJobCompletionActor*>(this)));
															#line 185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<BulkDumpState> const& currentJob,int loopDepth) 
	{
															#line 84 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool stillRunning = currentJob.present() && currentJob.get().getJobId() == jobId;
															#line 86 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!stillRunning)
															#line 202 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 87 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<MonitorBulkDumpJobCompletionActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MonitorBulkDumpJobCompletionActorState(); static_cast<MonitorBulkDumpJobCompletionActor*>(this)->destroy(); return 0; }
															#line 206 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBulkDumpJobCompletionActor*>(this)->SAV< bool >::value()) bool(true);
			this->~MonitorBulkDumpJobCompletionActorState();
			static_cast<MonitorBulkDumpJobCompletionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 90 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (now() - timeoutStart > timeoutDuration)
															#line 214 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 91 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<MonitorBulkDumpJobCompletionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MonitorBulkDumpJobCompletionActorState(); static_cast<MonitorBulkDumpJobCompletionActor*>(this)->destroy(); return 0; }
															#line 218 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBulkDumpJobCompletionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~MonitorBulkDumpJobCompletionActorState();
			static_cast<MonitorBulkDumpJobCompletionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 94 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(pollInterval);
															#line 94 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 228 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state = 2;
															#line 94 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >*>(static_cast<MonitorBulkDumpJobCompletionActor*>(this)));
															#line 233 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<BulkDumpState> && currentJob,int loopDepth) 
	{
															#line 84 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool stillRunning = currentJob.present() && currentJob.get().getJobId() == jobId;
															#line 86 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!stillRunning)
															#line 244 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 87 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<MonitorBulkDumpJobCompletionActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MonitorBulkDumpJobCompletionActorState(); static_cast<MonitorBulkDumpJobCompletionActor*>(this)->destroy(); return 0; }
															#line 248 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBulkDumpJobCompletionActor*>(this)->SAV< bool >::value()) bool(true);
			this->~MonitorBulkDumpJobCompletionActorState();
			static_cast<MonitorBulkDumpJobCompletionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 90 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (now() - timeoutStart > timeoutDuration)
															#line 256 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 91 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<MonitorBulkDumpJobCompletionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MonitorBulkDumpJobCompletionActorState(); static_cast<MonitorBulkDumpJobCompletionActor*>(this)->destroy(); return 0; }
															#line 260 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBulkDumpJobCompletionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~MonitorBulkDumpJobCompletionActorState();
			static_cast<MonitorBulkDumpJobCompletionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 94 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(pollInterval);
															#line 94 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 270 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state = 2;
															#line 94 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >*>(static_cast<MonitorBulkDumpJobCompletionActor*>(this)));
															#line 275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkDumpState> const& currentJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(currentJob, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkDumpState> && currentJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(currentJob), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state > 0) static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBulkDumpJobCompletionActor*>(this)->ActorCallback< MonitorBulkDumpJobCompletionActor, 0, Optional<BulkDumpState> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBulkDumpJobCompletionActor, 0, Optional<BulkDumpState> >*,Optional<BulkDumpState> const& value) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorBulkDumpJobCompletionActor, 0, Optional<BulkDumpState> >*,Optional<BulkDumpState> && value) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorBulkDumpJobCompletionActor, 0, Optional<BulkDumpState> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 95 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr.reset();
															#line 359 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 95 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr.reset();
															#line 368 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state > 0) static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBulkDumpJobCompletionActor*>(this)->ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state > 0) static_cast<MonitorBulkDumpJobCompletionActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBulkDumpJobCompletionActor*>(this)->ActorCallback< MonitorBulkDumpJobCompletionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBulkDumpJobCompletionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorBulkDumpJobCompletionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorBulkDumpJobCompletionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID jobId;
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	double timeoutDuration;
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	double pollInterval;
															#line 78 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	double timeoutStart;
															#line 79 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Transaction tr;
															#line 560 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorBulkDumpJobCompletion()
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class MonitorBulkDumpJobCompletionActor final : public Actor<bool>, public ActorCallback< MonitorBulkDumpJobCompletionActor, 0, Optional<BulkDumpState> >, public ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >, public ActorCallback< MonitorBulkDumpJobCompletionActor, 2, Void >, public FastAllocated<MonitorBulkDumpJobCompletionActor>, public MonitorBulkDumpJobCompletionActorState<MonitorBulkDumpJobCompletionActor> {
															#line 565 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorBulkDumpJobCompletionActor>::operator new;
	using FastAllocated<MonitorBulkDumpJobCompletionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4338010279949521664UL, 2679852547176238848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorBulkDumpJobCompletionActor, 0, Optional<BulkDumpState> >;
friend struct ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >;
friend struct ActorCallback< MonitorBulkDumpJobCompletionActor, 2, Void >;
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	MonitorBulkDumpJobCompletionActor(Database const& cx,UID const& jobId,double const& timeoutDuration,double const& pollInterval) 
															#line 584 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   MonitorBulkDumpJobCompletionActorState<MonitorBulkDumpJobCompletionActor>(cx, jobId, timeoutDuration, pollInterval),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5529935736705965568UL, 14592322826510778880UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkDumpJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorBulkDumpJobCompletion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorBulkDumpJobCompletion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorBulkDumpJobCompletionActor, 0, Optional<BulkDumpState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorBulkDumpJobCompletionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorBulkDumpJobCompletionActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<bool> monitorBulkDumpJobCompletion( Database const& cx, UID const& jobId, double const& timeoutDuration, double const& pollInterval ) {
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<bool>(new MonitorBulkDumpJobCompletionActor(cx, jobId, timeoutDuration, pollInterval));
															#line 619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 101 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Helper function to monitor BulkLoad job completion
// Returns true if job completed successfully, false if timed out
// lockAware must be true when DB is locked (e.g., during restore)
															#line 627 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorBulkLoadJobCompletion()
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class MonitorBulkLoadJobCompletionActor>
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class MonitorBulkLoadJobCompletionActorState {
															#line 634 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	MonitorBulkLoadJobCompletionActorState(Database const& cx,UID const& jobId,double const& timeoutDuration,double const& pollInterval,bool const& lockAware) 
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : cx(cx),
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   jobId(jobId),
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   timeoutDuration(timeoutDuration),
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   pollInterval(pollInterval),
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   lockAware(lockAware),
															#line 110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   timeoutStart(now())
															#line 651 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this));

	}
	~MonitorBulkLoadJobCompletionActorState() 
	{
		fdb_probe_actor_destroy("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 112 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			;
															#line 666 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorBulkLoadJobCompletionActorState();
		static_cast<MonitorBulkLoadJobCompletionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 113 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Optional<BulkLoadJobState>> __when_expr_0 = getRunningBulkLoadJob(cx, lockAware);
															#line 113 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 698 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state = 1;
															#line 113 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorBulkLoadJobCompletionActor, 0, Optional<BulkLoadJobState> >*>(static_cast<MonitorBulkLoadJobCompletionActor*>(this)));
															#line 703 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<BulkLoadJobState> const& currentJob,int loopDepth) 
	{
															#line 114 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool stillRunning = currentJob.present() && currentJob.get().getJobId() == jobId;
															#line 116 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!stillRunning)
															#line 714 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 117 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<MonitorBulkLoadJobCompletionActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MonitorBulkLoadJobCompletionActorState(); static_cast<MonitorBulkLoadJobCompletionActor*>(this)->destroy(); return 0; }
															#line 718 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBulkLoadJobCompletionActor*>(this)->SAV< bool >::value()) bool(true);
			this->~MonitorBulkLoadJobCompletionActorState();
			static_cast<MonitorBulkLoadJobCompletionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 120 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (now() - timeoutStart > timeoutDuration)
															#line 726 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 121 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<MonitorBulkLoadJobCompletionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MonitorBulkLoadJobCompletionActorState(); static_cast<MonitorBulkLoadJobCompletionActor*>(this)->destroy(); return 0; }
															#line 730 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBulkLoadJobCompletionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~MonitorBulkLoadJobCompletionActorState();
			static_cast<MonitorBulkLoadJobCompletionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 124 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(pollInterval);
															#line 124 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 740 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state = 2;
															#line 124 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >*>(static_cast<MonitorBulkLoadJobCompletionActor*>(this)));
															#line 745 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<BulkLoadJobState> && currentJob,int loopDepth) 
	{
															#line 114 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool stillRunning = currentJob.present() && currentJob.get().getJobId() == jobId;
															#line 116 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!stillRunning)
															#line 756 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 117 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<MonitorBulkLoadJobCompletionActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MonitorBulkLoadJobCompletionActorState(); static_cast<MonitorBulkLoadJobCompletionActor*>(this)->destroy(); return 0; }
															#line 760 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBulkLoadJobCompletionActor*>(this)->SAV< bool >::value()) bool(true);
			this->~MonitorBulkLoadJobCompletionActorState();
			static_cast<MonitorBulkLoadJobCompletionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 120 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (now() - timeoutStart > timeoutDuration)
															#line 768 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 121 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<MonitorBulkLoadJobCompletionActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MonitorBulkLoadJobCompletionActorState(); static_cast<MonitorBulkLoadJobCompletionActor*>(this)->destroy(); return 0; }
															#line 772 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<MonitorBulkLoadJobCompletionActor*>(this)->SAV< bool >::value()) bool(false);
			this->~MonitorBulkLoadJobCompletionActorState();
			static_cast<MonitorBulkLoadJobCompletionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 124 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(pollInterval);
															#line 124 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 782 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state = 2;
															#line 124 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >*>(static_cast<MonitorBulkLoadJobCompletionActor*>(this)));
															#line 787 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkLoadJobState> const& currentJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(currentJob, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkLoadJobState> && currentJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(currentJob), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state > 0) static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBulkLoadJobCompletionActor*>(this)->ActorCallback< MonitorBulkLoadJobCompletionActor, 0, Optional<BulkLoadJobState> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBulkLoadJobCompletionActor, 0, Optional<BulkLoadJobState> >*,Optional<BulkLoadJobState> const& value) 
	{
		fdb_probe_actor_enter("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkLoadJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorBulkLoadJobCompletionActor, 0, Optional<BulkLoadJobState> >*,Optional<BulkLoadJobState> && value) 
	{
		fdb_probe_actor_enter("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkLoadJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorBulkLoadJobCompletionActor, 0, Optional<BulkLoadJobState> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkLoadJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state > 0) static_cast<MonitorBulkLoadJobCompletionActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBulkLoadJobCompletionActor*>(this)->ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkLoadJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkLoadJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkLoadJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID jobId;
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	double timeoutDuration;
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	double pollInterval;
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool lockAware;
															#line 110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	double timeoutStart;
															#line 966 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorBulkLoadJobCompletion()
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class MonitorBulkLoadJobCompletionActor final : public Actor<bool>, public ActorCallback< MonitorBulkLoadJobCompletionActor, 0, Optional<BulkLoadJobState> >, public ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >, public FastAllocated<MonitorBulkLoadJobCompletionActor>, public MonitorBulkLoadJobCompletionActorState<MonitorBulkLoadJobCompletionActor> {
															#line 971 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorBulkLoadJobCompletionActor>::operator new;
	using FastAllocated<MonitorBulkLoadJobCompletionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14802319670781605376UL, 4815453648745167360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorBulkLoadJobCompletionActor, 0, Optional<BulkLoadJobState> >;
friend struct ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >;
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	MonitorBulkLoadJobCompletionActor(Database const& cx,UID const& jobId,double const& timeoutDuration,double const& pollInterval,bool const& lockAware) 
															#line 989 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   MonitorBulkLoadJobCompletionActorState<MonitorBulkLoadJobCompletionActor>(cx, jobId, timeoutDuration, pollInterval, lockAware),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1112861618613399552UL, 14147132304920947712UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBulkLoadJobCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorBulkLoadJobCompletion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorBulkLoadJobCompletion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorBulkLoadJobCompletionActor, 0, Optional<BulkLoadJobState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorBulkLoadJobCompletionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<bool> monitorBulkLoadJobCompletion( Database const& cx, UID const& jobId, double const& timeoutDuration, double const& pollInterval, bool const& lockAware ) {
															#line 105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<bool>(new MonitorBulkLoadJobCompletionActor(cx, jobId, timeoutDuration, pollInterval, lockAware));
															#line 1023 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 127 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Verify that a complete BulkDump dataset exists for BulkLoad restore
// Returns true if dataset is complete, false if incomplete
															#line 1030 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via verifyBulkDumpDatasetCompleteness()
															#line 130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class VerifyBulkDumpDatasetCompletenessActor>
															#line 130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class VerifyBulkDumpDatasetCompletenessActorState {
															#line 1037 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	VerifyBulkDumpDatasetCompletenessActorState(Reference<IBackupContainer> const& bc,std::string const& bulkDumpJobId) 
															#line 130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : bc(bc),
															#line 130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   bulkDumpJobId(bulkDumpJobId)
															#line 1046 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this));

	}
	~VerifyBulkDumpDatasetCompletenessActorState() 
	{
		fdb_probe_actor_destroy("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (bulkDumpJobId.empty())
															#line 1062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				{
															#line 133 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					TraceEvent(SevWarn, "BulkLoadVerifyDatasetEmptyJobId");
															#line 134 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					if (!static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV<bool>::futures) { (void)(false); this->~VerifyBulkDumpDatasetCompletenessActorState(); static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->destroy(); return 0; }
															#line 1068 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					new (&static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV< bool >::value()) bool(false);
					this->~VerifyBulkDumpDatasetCompletenessActorState();
					static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 138 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				jobManifestPath = "bulkdump_data/job-manifest.txt";
															#line 139 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				jobManifestFile = Reference<IAsyncFile>();
															#line 1078 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				try {
															#line 142 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					StrictFuture<Reference<IAsyncFile>> __when_expr_0 = bc->readFile(jobManifestPath);
															#line 142 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					if (static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->actor_wait_state < 0) return a_body1Catch3(actor_cancelled(), loopDepth);
															#line 1084 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch3(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->actor_wait_state = 1;
															#line 142 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 0, Reference<IAsyncFile> >*>(static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)));
															#line 1089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1Catch3(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch3(unknown_error(), loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VerifyBulkDumpDatasetCompletenessActorState();
		static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 174 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "BulkLoadVerifyDatasetError").error(e).detail("BulkDumpJobId", bulkDumpJobId);
															#line 175 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV<bool>::futures) { (void)(false); this->~VerifyBulkDumpDatasetCompletenessActorState(); static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->destroy(); return 0; }
															#line 1127 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV< bool >::value()) bool(false);
			this->~VerifyBulkDumpDatasetCompletenessActorState();
			static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 155 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = jobManifestFile->size();
															#line 155 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1147 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->actor_wait_state = 2;
															#line 155 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 1, int64_t >*>(static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)));
															#line 1152 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch3(const Error& e,int loopDepth=0) 
	{
		try {
															#line 145 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (e.code() == error_code_file_not_found)
															#line 1162 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 146 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarn, "BulkLoadVerifyDatasetJobManifestNotFound") .detail("JobManifestPath", jobManifestPath) .detail("BulkDumpJobId", bulkDumpJobId);
															#line 149 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV<bool>::futures) { (void)(false); this->~VerifyBulkDumpDatasetCompletenessActorState(); static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->destroy(); return 0; }
															#line 1168 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV< bool >::value()) bool(false);
				this->~VerifyBulkDumpDatasetCompletenessActorState();
				static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 151 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch2(e, loopDepth);
															#line 1176 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Reference<IAsyncFile> const& _jobManifestFile,int loopDepth) 
	{
															#line 143 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		jobManifestFile = _jobManifestFile;
															#line 1190 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Reference<IAsyncFile> && _jobManifestFile,int loopDepth) 
	{
															#line 143 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		jobManifestFile = _jobManifestFile;
															#line 1199 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& _jobManifestFile,int loopDepth) 
	{
		loopDepth = a_body1cont4(_jobManifestFile, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && _jobManifestFile,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_jobManifestFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->actor_wait_state > 0) static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch3(error, 0);
		} catch (...) {
			a_body1Catch3(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch3(error, 0);
		} catch (...) {
			a_body1Catch3(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch3(err, 0);
		}
		catch (Error& error) {
			a_body1Catch3(error, 0);
		} catch (...) {
			a_body1Catch3(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
															#line 156 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (manifestSize == 0)
															#line 1296 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 157 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "BulkLoadVerifyDatasetJobManifestEmpty") .detail("JobManifestPath", jobManifestPath) .detail("BulkDumpJobId", bulkDumpJobId);
															#line 160 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV<bool>::futures) { (void)(false); this->~VerifyBulkDumpDatasetCompletenessActorState(); static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->destroy(); return 0; }
															#line 1302 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV< bool >::value()) bool(false);
			this->~VerifyBulkDumpDatasetCompletenessActorState();
			static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 163 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("BulkLoadVerifyDatasetJobManifestFound") .detail("JobManifestPath", jobManifestPath) .detail("BulkDumpJobId", bulkDumpJobId) .detail("ManifestSize", manifestSize);
															#line 171 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV<bool>::futures) { (void)(true); this->~VerifyBulkDumpDatasetCompletenessActorState(); static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->destroy(); return 0; }
															#line 1312 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->SAV< bool >::value()) bool(true);
		this->~VerifyBulkDumpDatasetCompletenessActorState();
		static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(int64_t const& __manifestSize,int loopDepth) 
	{
															#line 155 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		manifestSize = __manifestSize;
															#line 1324 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t && __manifestSize,int loopDepth) 
	{
		manifestSize = std::move(__manifestSize);
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->actor_wait_state > 0) static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string bulkDumpJobId;
															#line 138 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string jobManifestPath;
															#line 139 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> jobManifestFile;
															#line 155 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t manifestSize;
															#line 1409 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via verifyBulkDumpDatasetCompleteness()
															#line 130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class VerifyBulkDumpDatasetCompletenessActor final : public Actor<bool>, public ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 0, Reference<IAsyncFile> >, public ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 1, int64_t >, public FastAllocated<VerifyBulkDumpDatasetCompletenessActor>, public VerifyBulkDumpDatasetCompletenessActorState<VerifyBulkDumpDatasetCompletenessActor> {
															#line 1414 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<VerifyBulkDumpDatasetCompletenessActor>::operator new;
	using FastAllocated<VerifyBulkDumpDatasetCompletenessActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9930258761454456064UL, 9224692298666521600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 1, int64_t >;
															#line 130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	VerifyBulkDumpDatasetCompletenessActor(Reference<IBackupContainer> const& bc,std::string const& bulkDumpJobId) 
															#line 1432 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   VerifyBulkDumpDatasetCompletenessActorState<VerifyBulkDumpDatasetCompletenessActor>(bc, bulkDumpJobId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2860798591858006272UL, 6889877595501473280UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyBulkDumpDatasetCompletenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("verifyBulkDumpDatasetCompleteness");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("verifyBulkDumpDatasetCompleteness", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< VerifyBulkDumpDatasetCompletenessActor, 1, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<bool> verifyBulkDumpDatasetCompleteness( Reference<IBackupContainer> const& bc, std::string const& bulkDumpJobId ) {
															#line 130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<bool>(new VerifyBulkDumpDatasetCompletenessActor(bc, bulkDumpJobId));
															#line 1466 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 178 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Note: BulkLoad configuration validation (shard_encode_location_metadata, enable_read_lock_on_range)
// is performed by the BulkLoad system on the server side. Client-side validation is not possible
// because SERVER_KNOBS are not accessible from fdbclient.

Optional<std::string> fileBackupAgentProxy = Optional<std::string>();

#define SevFRTestInfo SevVerbose
// #define SevFRTestInfo SevInfo

static std::string boolToYesOrNo(bool val) {
	return val ? std::string("Yes") : std::string("No");
}

static std::string versionToString(Optional<Version> version) {
	if (version.present())
		return std::to_string(version.get());
	else
		return "N/A";
}

static std::string timeStampToString(Optional<int64_t> epochs) {
	if (!epochs.present())
		return "N/A";
	return BackupAgentBase::formatTime(epochs.get());
}

static Future<Optional<int64_t>> getTimestampFromVersion(Optional<Version> ver,
                                                         Reference<ReadYourWritesTransaction> tr) {
	if (!ver.present())
		return Optional<int64_t>();

	return timeKeeperEpochsFromVersion(ver.get(), tr);
}

// Time format :
// <= 59 seconds
// <= 59.99 minutes
// <= 23.99 hours
// N.NN days
std::string secondsToTimeFormat(int64_t seconds) {
	if (seconds >= 86400)
		return format("%.2f day(s)", seconds / 86400.0);
	else if (seconds >= 3600)
		return format("%.2f hour(s)", seconds / 3600.0);
	else if (seconds >= 60)
		return format("%.2f minute(s)", seconds / 60.0);
	else
		return format("%lld second(s)", seconds);
}

const Key FileBackupAgent::keyLastRestorable = "last_restorable"_sr;

// For convenience
typedef FileBackupAgent::ERestoreState ERestoreState;

StringRef FileBackupAgent::restoreStateText(ERestoreState id) {
	switch (id) {
	case ERestoreState::UNINITIALIZED:
		return "uninitialized"_sr;
	case ERestoreState::QUEUED:
		return "queued"_sr;
	case ERestoreState::STARTING:
		return "starting"_sr;
	case ERestoreState::RUNNING:
		return "running"_sr;
	case ERestoreState::COMPLETED:
		return "completed"_sr;
	case ERestoreState::ABORTED:
		return "aborted"_sr;
	default:
		return "Unknown"_sr;
	}
}

Key FileBackupAgent::getPauseKey() {
	FileBackupAgent backupAgent;
	return backupAgent.taskBucket->getPauseKey();
}

															#line 1550 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getAll_impl()
															#line 258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class TagUidMap_GetAll_implActor>
															#line 258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TagUidMap_GetAll_implActorState {
															#line 1556 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TagUidMap_GetAll_implActorState(TagUidMap* const& tagsMap,Reference<ReadYourWritesTransaction> const& tr,Snapshot const& snapshot) 
															#line 258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tagsMap(tagsMap),
															#line 258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   snapshot(snapshot),
															#line 261 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   prefix(tagsMap->prefix)
															#line 1569 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAll_impl", reinterpret_cast<unsigned long>(this));

	}
	~TagUidMap_GetAll_implActorState() 
	{
		fdb_probe_actor_destroy("getAll_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 262 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<TagMap::RangeResultType> __when_expr_0 = tagsMap->getRange(tr, std::string(), {}, 1e6, snapshot);
															#line 262 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<TagUidMap_GetAll_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1586 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagUidMap_GetAll_implActor*>(this)->actor_wait_state = 1;
															#line 262 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*>(static_cast<TagUidMap_GetAll_implActor*>(this)));
															#line 1591 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagUidMap_GetAll_implActorState();
		static_cast<TagUidMap_GetAll_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TagMap::RangeResultType const& tagPairs,int loopDepth) 
	{
															#line 263 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<KeyBackedTag> results;
															#line 264 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& p : tagPairs.results ) {
															#line 265 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results.push_back(KeyBackedTag(p.first, prefix));
															#line 1618 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 266 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TagUidMap_GetAll_implActor*>(this)->SAV<std::vector<KeyBackedTag>>::futures) { (void)(results); this->~TagUidMap_GetAll_implActorState(); static_cast<TagUidMap_GetAll_implActor*>(this)->destroy(); return 0; }
															#line 1622 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<TagUidMap_GetAll_implActor*>(this)->SAV< std::vector<KeyBackedTag> >::value()) std::vector<KeyBackedTag>(results);
		this->~TagUidMap_GetAll_implActorState();
		static_cast<TagUidMap_GetAll_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(TagMap::RangeResultType && tagPairs,int loopDepth) 
	{
															#line 263 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<KeyBackedTag> results;
															#line 264 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& p : tagPairs.results ) {
															#line 265 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results.push_back(KeyBackedTag(p.first, prefix));
															#line 1638 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 266 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TagUidMap_GetAll_implActor*>(this)->SAV<std::vector<KeyBackedTag>>::futures) { (void)(results); this->~TagUidMap_GetAll_implActorState(); static_cast<TagUidMap_GetAll_implActor*>(this)->destroy(); return 0; }
															#line 1642 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<TagUidMap_GetAll_implActor*>(this)->SAV< std::vector<KeyBackedTag> >::value()) std::vector<KeyBackedTag>(results);
		this->~TagUidMap_GetAll_implActorState();
		static_cast<TagUidMap_GetAll_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TagMap::RangeResultType const& tagPairs,int loopDepth) 
	{
		loopDepth = a_body1cont1(tagPairs, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TagMap::RangeResultType && tagPairs,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tagPairs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagUidMap_GetAll_implActor*>(this)->actor_wait_state > 0) static_cast<TagUidMap_GetAll_implActor*>(this)->actor_wait_state = 0;
		static_cast<TagUidMap_GetAll_implActor*>(this)->ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*,TagMap::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("getAll_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagUidMap_GetAll_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*,TagMap::RangeResultType && value) 
	{
		fdb_probe_actor_enter("getAll_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagUidMap_GetAll_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("getAll_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagUidMap_GetAll_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TagUidMap* tagsMap;
															#line 258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Snapshot snapshot;
															#line 261 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key prefix;
															#line 1733 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAll_impl()
															#line 258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TagUidMap_GetAll_implActor final : public Actor<std::vector<KeyBackedTag>>, public ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >, public FastAllocated<TagUidMap_GetAll_implActor>, public TagUidMap_GetAll_implActorState<TagUidMap_GetAll_implActor> {
															#line 1738 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<TagUidMap_GetAll_implActor>::operator new;
	using FastAllocated<TagUidMap_GetAll_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8319324936356729088UL, 17957497254669447168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyBackedTag>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >;
															#line 258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TagUidMap_GetAll_implActor(TagUidMap* const& tagsMap,Reference<ReadYourWritesTransaction> const& tr,Snapshot const& snapshot) 
															#line 1755 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<std::vector<KeyBackedTag>>(),
		   TagUidMap_GetAll_implActorState<TagUidMap_GetAll_implActor>(tagsMap, tr, snapshot),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAll_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4531936230553832704UL, 10523325084301780224UL);
		ActorExecutionContextHelper __helper(static_cast<TagUidMap_GetAll_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAll_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAll_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*)0, actor_cancelled()); break;
		}

	}
};
															#line 258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<std::vector<KeyBackedTag>> TagUidMap::getAll_impl( TagUidMap* const& tagsMap, Reference<ReadYourWritesTransaction> const& tr, Snapshot const& snapshot ) {
															#line 258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<std::vector<KeyBackedTag>>(new TagUidMap_GetAll_implActor(tagsMap, tr, snapshot));
															#line 1787 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 268 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

KeyBackedTag::KeyBackedTag(std::string tagName, StringRef tagMapPrefix)
  : KeyBackedProperty<UidAndAbortedFlagT>(TagUidMap(tagMapPrefix).getProperty(tagName)), tagName(tagName),
    tagMapPrefix(tagMapPrefix) {}

// Lists all backups and find if any partitioned backup is running.
															#line 1797 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via anyPartitionedBackupRunning()
															#line 274 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AnyPartitionedBackupRunningActor>
															#line 274 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AnyPartitionedBackupRunningActorState {
															#line 1804 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 274 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AnyPartitionedBackupRunningActorState(Reference<ReadYourWritesTransaction> const& tr) 
															#line 274 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 274 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr)
															#line 1811 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this));

	}
	~AnyPartitionedBackupRunningActorState() 
	{
		fdb_probe_actor_destroy("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 276 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 277 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<std::vector<KeyBackedTag>> __when_expr_0 = getAllBackupTags(tr);
															#line 277 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1832 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 1;
															#line 277 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*>(static_cast<AnyPartitionedBackupRunningActor*>(this)));
															#line 1837 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AnyPartitionedBackupRunningActorState();
		static_cast<AnyPartitionedBackupRunningActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<KeyBackedTag> const& tags,int loopDepth) 
	{
															#line 279 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		futures = std::vector<Future<Optional<UidAndAbortedFlagT>>>();
															#line 280 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const auto& tag : tags ) {
															#line 281 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			futures.push_back(tag.get(tr));
															#line 1864 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 284 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(futures);
															#line 284 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1870 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 2;
															#line 284 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*>(static_cast<AnyPartitionedBackupRunningActor*>(this)));
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<KeyBackedTag> && tags,int loopDepth) 
	{
															#line 279 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		futures = std::vector<Future<Optional<UidAndAbortedFlagT>>>();
															#line 280 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const auto& tag : tags ) {
															#line 281 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			futures.push_back(tag.get(tr));
															#line 1888 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 284 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(futures);
															#line 284 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1894 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 2;
															#line 284 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*>(static_cast<AnyPartitionedBackupRunningActor*>(this)));
															#line 1899 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<KeyBackedTag> const& tags,int loopDepth) 
	{
		loopDepth = a_body1cont1(tags, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<KeyBackedTag> && tags,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tags), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state > 0) static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 0;
		static_cast<AnyPartitionedBackupRunningActor*>(this)->ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >::remove();

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*,std::vector<KeyBackedTag> const& value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*,std::vector<KeyBackedTag> && value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*,Error err) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 285 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i = 0;
															#line 286 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i = 0;
															#line 1985 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 285 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i = 0;
															#line 286 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i = 0;
															#line 1996 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state > 0) static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 0;
		static_cast<AnyPartitionedBackupRunningActor*>(this)->ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV<bool>::futures) { (void)(false); this->~AnyPartitionedBackupRunningActorState(); static_cast<AnyPartitionedBackupRunningActor*>(this)->destroy(); return 0; }
															#line 2080 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV< bool >::value()) bool(false);
		this->~AnyPartitionedBackupRunningActorState();
		static_cast<AnyPartitionedBackupRunningActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 286 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(i < futures.size()))
															#line 2099 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 287 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (futures[i].get().present())
															#line 2105 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 288 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			partitionedLog = Optional<bool>();
															#line 289 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			eState = EBackupState();
															#line 290 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			BackupConfig config(futures[i].get().get().first);
															#line 292 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = store(eState, config.stateEnum().getD(tr, Snapshot::False, EBackupState::STATE_NEVERRAN)) && store(partitionedLog, config.partitionedLogEnabled().get(tr));
															#line 292 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2117 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 3;
															#line 292 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*>(static_cast<AnyPartitionedBackupRunningActor*>(this)));
															#line 2122 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 286 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i++;
															#line 2149 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 294 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (FileBackupAgent::isRunnable(eState) && partitionedLog.present() && partitionedLog.get())
															#line 2158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 295 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV<bool>::futures) { (void)(true); this->~AnyPartitionedBackupRunningActorState(); static_cast<AnyPartitionedBackupRunningActor*>(this)->destroy(); return 0; }
															#line 2162 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV< bool >::value()) bool(true);
			this->~AnyPartitionedBackupRunningActorState();
			static_cast<AnyPartitionedBackupRunningActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 294 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (FileBackupAgent::isRunnable(eState) && partitionedLog.present() && partitionedLog.get())
															#line 2176 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 295 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV<bool>::futures) { (void)(true); this->~AnyPartitionedBackupRunningActorState(); static_cast<AnyPartitionedBackupRunningActor*>(this)->destroy(); return 0; }
															#line 2180 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV< bool >::value()) bool(true);
			this->~AnyPartitionedBackupRunningActorState();
			static_cast<AnyPartitionedBackupRunningActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state > 0) static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 0;
		static_cast<AnyPartitionedBackupRunningActor*>(this)->ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 274 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 279 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::vector<Future<Optional<UidAndAbortedFlagT>>> futures;
															#line 285 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int i;
															#line 288 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Optional<bool> partitionedLog;
															#line 289 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EBackupState eState;
															#line 2275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via anyPartitionedBackupRunning()
															#line 274 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AnyPartitionedBackupRunningActor final : public Actor<bool>, public ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >, public ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >, public ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >, public FastAllocated<AnyPartitionedBackupRunningActor>, public AnyPartitionedBackupRunningActorState<AnyPartitionedBackupRunningActor> {
															#line 2280 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<AnyPartitionedBackupRunningActor>::operator new;
	using FastAllocated<AnyPartitionedBackupRunningActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12480149024684068352UL, 8348577199445771264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >;
friend struct ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >;
friend struct ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >;
															#line 274 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AnyPartitionedBackupRunningActor(Reference<ReadYourWritesTransaction> const& tr) 
															#line 2299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   AnyPartitionedBackupRunningActorState<AnyPartitionedBackupRunningActor>(tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(587540076039375616UL, 15683259992114904576UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("anyPartitionedBackupRunning");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 274 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<bool> anyPartitionedBackupRunning( Reference<ReadYourWritesTransaction> const& tr ) {
															#line 274 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<bool>(new AnyPartitionedBackupRunningActor(tr));
															#line 2334 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 301 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

class RestoreConfig : public KeyBackedTaskConfig {
public:
	RestoreConfig(UID uid = UID()) : KeyBackedTaskConfig(fileRestorePrefixRange.begin, uid) {}
	RestoreConfig(Reference<Task> task) : KeyBackedTaskConfig(fileRestorePrefixRange.begin, task) {}

	KeyBackedProperty<ERestoreState> stateEnum() { return configSpace.pack(__FUNCTION__sr); }
	Future<StringRef> stateText(Reference<ReadYourWritesTransaction> tr) {
		return map(stateEnum().getD(tr),
		           [](ERestoreState s) -> StringRef { return FileBackupAgent::restoreStateText(s); });
	}
	KeyBackedProperty<Key> addPrefix() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Key> removePrefix() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> onlyApplyMutationLogs() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> inconsistentSnapshotOnly() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> unlockDBAfterRestore() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> transformPartitionedLog() { return configSpace.pack(__FUNCTION__sr); }
	// BulkLoad integration properties
	KeyBackedProperty<bool> useRangeFileRestore() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<std::string> bulkDumpJobId() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Key> bulkLoadCompleteFuture() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> bulkLoadComplete() { return configSpace.pack(__FUNCTION__sr); }
	// Original BulkLoad mode before restore enabled it - used to restore state after completion/crash
	KeyBackedProperty<int> originalBulkLoadMode() { return configSpace.pack(__FUNCTION__sr); }
	// XXX: Remove restoreRange() once it is safe to remove. It has been changed to restoreRanges
	KeyBackedProperty<KeyRange> restoreRange() { return configSpace.pack(__FUNCTION__sr); }
	// XXX: Changed to restoreRangeSet. It can be removed.
	KeyBackedProperty<std::vector<KeyRange>> restoreRanges() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedSet<KeyRange> restoreRangeSet() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Key> batchFuture() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Version> beginVersion() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Version> restoreVersion() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Version> firstConsistentVersion() { return configSpace.pack(__FUNCTION__sr); }

	KeyBackedProperty<Reference<IBackupContainer>> sourceContainer() { return configSpace.pack(__FUNCTION__sr); }
	// Get the source container as a bare URL, without creating a container instance
	KeyBackedProperty<Value> sourceContainerURL() { return configSpace.pack("sourceContainer"_sr); }

	// Total bytes written by all log and range restore tasks.
	KeyBackedBinaryValue<int64_t> bytesWritten() { return configSpace.pack(__FUNCTION__sr); }
	// File blocks that have had tasks created for them by the Dispatch task
	KeyBackedBinaryValue<int64_t> filesBlocksDispatched() { return configSpace.pack(__FUNCTION__sr); }
	// File blocks whose tasks have finished
	KeyBackedBinaryValue<int64_t> fileBlocksFinished() { return configSpace.pack(__FUNCTION__sr); }
	// Total number of files in the fileMap
	KeyBackedBinaryValue<int64_t> fileCount() { return configSpace.pack(__FUNCTION__sr); }
	// Total number of file blocks in the fileMap
	KeyBackedBinaryValue<int64_t> fileBlockCount() { return configSpace.pack(__FUNCTION__sr); }

	Future<std::vector<KeyRange>> getRestoreRangesOrDefault(Reference<ReadYourWritesTransaction> tr) {
		return getRestoreRangesOrDefault_impl(this, tr);
	}

																#line 2391 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getRestoreRangesOrDefault_impl()
															#line 354 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetRestoreRangesOrDefault_implActor>
															#line 354 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetRestoreRangesOrDefault_implActorState {
															#line 2397 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 354 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetRestoreRangesOrDefault_implActorState(RestoreConfig* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 354 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 354 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 354 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 356 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   ranges(),
															#line 357 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   batchSize(BUGGIFY ? 1 : CLIENT_KNOBS->RESTORE_RANGES_READ_BATCH),
															#line 358 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   begin(),
															#line 359 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   arena()
															#line 2414 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this));

	}
	~GetRestoreRangesOrDefault_implActorState() 
	{
		fdb_probe_actor_destroy("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 360 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			;
															#line 2429 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRestoreRangesOrDefault_implActorState();
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 372 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ranges.empty())
															#line 2452 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 373 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<std::vector<KeyRange>> __when_expr_1 = self->restoreRanges().getD(tr);
															#line 373 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2458 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 2;
															#line 373 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*>(static_cast<GetRestoreRangesOrDefault_implActor*>(this)));
															#line 2463 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 361 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<KeyBackedSet<KeyRange>::RangeResultType> __when_expr_0 = self->restoreRangeSet().getRange(tr, begin, {}, batchSize);
															#line 361 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2486 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 1;
															#line 361 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*>(static_cast<GetRestoreRangesOrDefault_implActor*>(this)));
															#line 2491 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(KeyBackedSet<KeyRange>::RangeResultType const& rangeResult,int loopDepth) 
	{
															#line 363 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges.insert(ranges.end(), rangeResult.results.begin(), rangeResult.results.end());
															#line 364 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!rangeResult.more)
															#line 2515 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 367 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ASSERT(!rangeResult.results.empty());
															#line 368 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		begin = KeyRangeRef(KeyRef(arena, ranges.back().begin), keyAfter(ranges.back().end, arena));
															#line 2523 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(KeyBackedSet<KeyRange>::RangeResultType && rangeResult,int loopDepth) 
	{
															#line 363 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges.insert(ranges.end(), rangeResult.results.begin(), rangeResult.results.end());
															#line 364 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!rangeResult.more)
															#line 2534 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 367 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ASSERT(!rangeResult.results.empty());
															#line 368 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		begin = KeyRangeRef(KeyRef(arena, ranges.back().begin), keyAfter(ranges.back().end, arena));
															#line 2542 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedSet<KeyRange>::RangeResultType const& rangeResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(rangeResult, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedSet<KeyRange>::RangeResultType && rangeResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(rangeResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*,KeyBackedSet<KeyRange>::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*,KeyBackedSet<KeyRange>::RangeResultType && value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 380 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetRestoreRangesOrDefault_implActor*>(this)->SAV<std::vector<KeyRange>>::futures) { (void)(ranges); this->~GetRestoreRangesOrDefault_implActorState(); static_cast<GetRestoreRangesOrDefault_implActor*>(this)->destroy(); return 0; }
															#line 2626 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetRestoreRangesOrDefault_implActor*>(this)->SAV< std::vector<KeyRange> >::value()) std::vector<KeyRange>(std::move(ranges)); // state_var_RVO
		this->~GetRestoreRangesOrDefault_implActorState();
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(std::vector<KeyRange> const& _ranges,int loopDepth) 
	{
															#line 374 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges = _ranges;
															#line 375 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ranges.empty())
															#line 2640 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 376 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<KeyRange> __when_expr_2 = self->restoreRange().getD(tr);
															#line 376 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2646 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 3;
															#line 376 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*>(static_cast<GetRestoreRangesOrDefault_implActor*>(this)));
															#line 2651 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(std::vector<KeyRange> && _ranges,int loopDepth) 
	{
															#line 374 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges = _ranges;
															#line 375 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ranges.empty())
															#line 2667 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 376 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<KeyRange> __when_expr_2 = self->restoreRange().getD(tr);
															#line 376 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2673 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 3;
															#line 376 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*>(static_cast<GetRestoreRangesOrDefault_implActor*>(this)));
															#line 2678 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<KeyRange> const& _ranges,int loopDepth) 
	{
		loopDepth = a_body1cont3(_ranges, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<KeyRange> && _ranges,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_ranges), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*,std::vector<KeyRange> const& value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*,std::vector<KeyRange> && value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(KeyRange const& range,int loopDepth) 
	{
															#line 377 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges.push_back(range);
															#line 2773 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(KeyRange && range,int loopDepth) 
	{
															#line 377 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges.push_back(range);
															#line 2782 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(KeyRange const& range,int loopDepth) 
	{
		loopDepth = a_body1cont5(range, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(KeyRange && range,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*,KeyRange const& value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*,KeyRange && value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 354 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig* self;
															#line 354 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 356 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::vector<KeyRange> ranges;
															#line 357 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int batchSize;
															#line 358 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Optional<KeyRange> begin;
															#line 359 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Arena arena;
															#line 2874 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getRestoreRangesOrDefault_impl()
															#line 354 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetRestoreRangesOrDefault_implActor final : public Actor<std::vector<KeyRange>>, public ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >, public ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >, public ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >, public FastAllocated<GetRestoreRangesOrDefault_implActor>, public GetRestoreRangesOrDefault_implActorState<GetRestoreRangesOrDefault_implActor> {
															#line 2879 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetRestoreRangesOrDefault_implActor>::operator new;
	using FastAllocated<GetRestoreRangesOrDefault_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18175745715301023744UL, 343874121743679488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyRange>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >;
friend struct ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >;
friend struct ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >;
															#line 354 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetRestoreRangesOrDefault_implActor(RestoreConfig* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 2898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<std::vector<KeyRange>>(),
		   GetRestoreRangesOrDefault_implActorState<GetRestoreRangesOrDefault_implActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7781314247607341824UL, 4200768842030992896UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRestoreRangesOrDefault_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*)0, actor_cancelled()); break;
		}

	}
};
															#line 354 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<std::vector<KeyRange>> getRestoreRangesOrDefault_impl( RestoreConfig* const& self, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 354 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<std::vector<KeyRange>>(new GetRestoreRangesOrDefault_implActor(self, tr));
															#line 2932 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 382 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// Describes a file to load blocks from during restore.  Ordered by version and then fileName to enable
	// incrementally advancing through the map, saving the version and path of the next starting point.
	struct RestoreFile {
		Version version; // this is beginVersion, not endVersion
		std::string fileName;
		bool isRange{ false }; // false for log file
		int64_t blockSize{ 0 };
		int64_t fileSize{ 0 };
		Version endVersion{ ::invalidVersion }; // not meaningful for range files
		int64_t tagId = -1; // only meaningful to log files, Log router tag. Non-negative for new backup format.
		int64_t totalTags = -1; // only meaningful to log files, Total number of log router tags.

		Tuple pack() const {
			return Tuple::makeTuple(
			    version, fileName, (int64_t)isRange, fileSize, blockSize, endVersion, tagId, totalTags);
		}
		static RestoreFile unpack(Tuple const& t) {
			RestoreFile r;
			int i = 0;
			r.version = t.getInt(i++);
			r.fileName = t.getString(i++).toString();
			r.isRange = t.getInt(i++) != 0;
			r.fileSize = t.getInt(i++);
			r.blockSize = t.getInt(i++);
			r.endVersion = t.getInt(i++);
			r.tagId = t.getInt(i++);
			r.totalTags = t.getInt(i++);
			return r;
		}
	};

	typedef KeyBackedSet<RestoreFile> FileSetT;
	FileSetT fileSet() { return configSpace.pack(__FUNCTION__sr); }

	FileSetT logFileSet() { return configSpace.pack(__FUNCTION__sr); }
	FileSetT rangeFileSet() { return configSpace.pack(__FUNCTION__sr); }

	Future<bool> isRunnable(Reference<ReadYourWritesTransaction> tr) {
		return map(stateEnum().getD(tr), [](ERestoreState s) -> bool {
			return s != ERestoreState::ABORTED && s != ERestoreState::COMPLETED && s != ERestoreState::UNINITIALIZED;
		});
	}

	Future<Void> logError(Database cx, Error e, std::string const& details, void* taskInstance = nullptr) {
		if (!uid.isValid()) {
			TraceEvent(SevError, "FileRestoreErrorNoUID").error(e).detail("Description", details);
			return Void();
		}
		TraceEvent t(SevWarn, "FileRestoreError");
		t.error(e)
		    .detail("RestoreUID", uid)
		    .detail("Description", details)
		    .detail("TaskInstance", (uint64_t)taskInstance);
		// key_not_found could happen
		if (e.code() == error_code_key_not_found)
			t.backtrace();

		return updateErrorInfo(cx, e, details);
	}

	Key mutationLogPrefix() { return uidPrefixKey(applyLogKeys.begin, uid); }

	Key applyMutationsMapPrefix() { return uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid); }

																#line 3001 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getApplyVersionLag_impl()
															#line 447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetApplyVersionLag_implActor>
															#line 447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetApplyVersionLag_implActorState {
															#line 3007 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetApplyVersionLag_implActorState(Reference<ReadYourWritesTransaction> const& tr,UID const& uid) 
															#line 447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   uid(uid),
															#line 448 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   beginVal(tr->get(uidPrefixKey(applyMutationsBeginRange.begin, uid), Snapshot::True)),
															#line 450 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   endVal(tr->get(uidPrefixKey(applyMutationsEndRange.begin, uid), Snapshot::True))
															#line 3020 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this));

	}
	~GetApplyVersionLag_implActorState() 
	{
		fdb_probe_actor_destroy("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 451 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(beginVal) && success(endVal);
															#line 451 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetApplyVersionLag_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3037 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetApplyVersionLag_implActor*>(this)->actor_wait_state = 1;
															#line 451 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetApplyVersionLag_implActor, 0, Void >*>(static_cast<GetApplyVersionLag_implActor*>(this)));
															#line 3042 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetApplyVersionLag_implActorState();
		static_cast<GetApplyVersionLag_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 453 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!beginVal.get().present() || !endVal.get().present())
															#line 3065 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 454 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~GetApplyVersionLag_implActorState(); static_cast<GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 3069 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~GetApplyVersionLag_implActorState();
			static_cast<GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 456 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Version beginVersion = BinaryReader::fromStringRef<Version>(beginVal.get().get(), Unversioned());
															#line 457 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Version endVersion = BinaryReader::fromStringRef<Version>(endVal.get().get(), Unversioned());
															#line 458 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(endVersion - beginVersion); this->~GetApplyVersionLag_implActorState(); static_cast<GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 3081 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(endVersion - beginVersion);
		this->~GetApplyVersionLag_implActorState();
		static_cast<GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 453 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!beginVal.get().present() || !endVal.get().present())
															#line 3093 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 454 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~GetApplyVersionLag_implActorState(); static_cast<GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 3097 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~GetApplyVersionLag_implActorState();
			static_cast<GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 456 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Version beginVersion = BinaryReader::fromStringRef<Version>(beginVal.get().get(), Unversioned());
															#line 457 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Version endVersion = BinaryReader::fromStringRef<Version>(endVal.get().get(), Unversioned());
															#line 458 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(endVersion - beginVersion); this->~GetApplyVersionLag_implActorState(); static_cast<GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 3109 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(endVersion - beginVersion);
		this->~GetApplyVersionLag_implActorState();
		static_cast<GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetApplyVersionLag_implActor*>(this)->actor_wait_state > 0) static_cast<GetApplyVersionLag_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetApplyVersionLag_implActor*>(this)->ActorCallback< GetApplyVersionLag_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetApplyVersionLag_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetApplyVersionLag_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetApplyVersionLag_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID uid;
															#line 448 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Optional<Value>> beginVal;
															#line 450 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Optional<Value>> endVal;
															#line 3200 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getApplyVersionLag_impl()
															#line 447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetApplyVersionLag_implActor final : public Actor<int64_t>, public ActorCallback< GetApplyVersionLag_implActor, 0, Void >, public FastAllocated<GetApplyVersionLag_implActor>, public GetApplyVersionLag_implActorState<GetApplyVersionLag_implActor> {
															#line 3205 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetApplyVersionLag_implActor>::operator new;
	using FastAllocated<GetApplyVersionLag_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13884472402752150016UL, 5679228525477935616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetApplyVersionLag_implActor, 0, Void >;
															#line 447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetApplyVersionLag_implActor(Reference<ReadYourWritesTransaction> const& tr,UID const& uid) 
															#line 3222 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<int64_t>(),
		   GetApplyVersionLag_implActorState<GetApplyVersionLag_implActor>(tr, uid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9614200584100791808UL, 10485171078912906496UL);
		ActorExecutionContextHelper __helper(static_cast<GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getApplyVersionLag_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetApplyVersionLag_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<int64_t> getApplyVersionLag_impl( Reference<ReadYourWritesTransaction> const& tr, UID const& uid ) {
															#line 447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<int64_t>(new GetApplyVersionLag_implActor(tr, uid));
															#line 3254 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 460 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<int64_t> getApplyVersionLag(Reference<ReadYourWritesTransaction> tr) {
		return getApplyVersionLag_impl(tr, uid);
	}

	void initApplyMutations(Reference<ReadYourWritesTransaction> tr,
	                        Key addPrefix,
	                        Key removePrefix,
	                        OnlyApplyMutationLogs onlyApplyMutationLogs) {
		// Set these because they have to match the applyMutations values.
		this->addPrefix().set(tr, addPrefix);
		this->removePrefix().set(tr, removePrefix);

		clearApplyMutationsKeys(tr);

		// Initialize add/remove prefix, range version map count and set the map's start key to InvalidVersion
		tr->set(uidPrefixKey(applyMutationsAddPrefixRange.begin, uid), addPrefix);
		tr->set(uidPrefixKey(applyMutationsRemovePrefixRange.begin, uid), removePrefix);

		int64_t startCount = 0;
		tr->set(uidPrefixKey(applyMutationsKeyVersionCountRange.begin, uid), StringRef((uint8_t*)&startCount, 8));
		Key mapStart = uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid);
		tr->set(mapStart, BinaryWriter::toValue<Version>(invalidVersion, Unversioned()));
	}

	void clearApplyMutationsKeys(Reference<ReadYourWritesTransaction> tr) {
		tr->setOption(FDBTransactionOptions::COMMIT_ON_FIRST_PROXY);

		// Clear add/remove prefix keys
		tr->clear(uidPrefixKey(applyMutationsAddPrefixRange.begin, uid));
		tr->clear(uidPrefixKey(applyMutationsRemovePrefixRange.begin, uid));

		// Clear range version map and count key
		tr->clear(uidPrefixKey(applyMutationsKeyVersionCountRange.begin, uid));
		Key mapStart = uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid);
		tr->clear(KeyRangeRef(mapStart, strinc(mapStart)));

		// Clear any loaded mutations that have not yet been applied
		Key mutationPrefix = mutationLogPrefix();
		tr->clear(KeyRangeRef(mutationPrefix, strinc(mutationPrefix)));

		// Clear end and begin versions (intentionally in this order)
		tr->clear(uidPrefixKey(applyMutationsEndRange.begin, uid));
		tr->clear(uidPrefixKey(applyMutationsBeginRange.begin, uid));
	}

	void setApplyBeginVersion(Reference<ReadYourWritesTransaction> tr, Version ver) {
		tr->set(uidPrefixKey(applyMutationsBeginRange.begin, uid), BinaryWriter::toValue(ver, Unversioned()));
	}

	Future<Version> getApplyBeginVersion(Reference<ReadYourWritesTransaction> tr) {
		return map(tr->get(uidPrefixKey(applyMutationsBeginRange.begin, uid)),
		           [=](Optional<Value> const& value) -> Version {
			           return value.present() ? BinaryReader::fromStringRef<Version>(value.get(), Unversioned()) : 0;
		           });
	}

	void setApplyEndVersion(Reference<ReadYourWritesTransaction> tr, Version ver) {
		tr->set(uidPrefixKey(applyMutationsEndRange.begin, uid), BinaryWriter::toValue(ver, Unversioned()));
	}

	Future<Version> getApplyEndVersion(Reference<ReadYourWritesTransaction> tr) {
		return map(tr->get(uidPrefixKey(applyMutationsEndRange.begin, uid)),
		           [=](Optional<Value> const& value) -> Version {
			           return value.present() ? BinaryReader::fromStringRef<Version>(value.get(), Unversioned()) : 0;
		           });
	}

																#line 3326 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getCurrentVersion_impl()
															#line 528 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetCurrentVersion_implActor>
															#line 528 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetCurrentVersion_implActorState {
															#line 3332 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 528 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetCurrentVersion_implActorState(RestoreConfig* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 528 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 528 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 528 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr)
															#line 3341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this));

	}
	~GetCurrentVersion_implActorState() 
	{
		fdb_probe_actor_destroy("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 529 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<ERestoreState> __when_expr_0 = self->stateEnum().getD(tr);
															#line 529 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3358 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 1;
															#line 529 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*>(static_cast<GetCurrentVersion_implActor*>(this)));
															#line 3363 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCurrentVersion_implActorState();
		static_cast<GetCurrentVersion_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 530 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = -1;
															#line 531 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (status == ERestoreState::RUNNING)
															#line 3388 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 532 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(version, self->getApplyBeginVersion(tr));
															#line 532 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3394 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 2;
															#line 532 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetCurrentVersion_implActor, 1, Void >*>(static_cast<GetCurrentVersion_implActor*>(this)));
															#line 3399 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 533 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (status == ERestoreState::COMPLETED)
															#line 3406 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 534 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_2 = store(version, self->restoreVersion().getD(tr));
															#line 534 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3412 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
				static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 3;
															#line 534 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetCurrentVersion_implActor, 2, Void >*>(static_cast<GetCurrentVersion_implActor*>(this)));
															#line 3417 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont4(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1when1(ERestoreState const& __status,int loopDepth) 
	{
															#line 529 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		status = __status;
															#line 3432 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ERestoreState && __status,int loopDepth) 
	{
		status = std::move(__status);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state > 0) static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetCurrentVersion_implActor*>(this)->ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >::remove();

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*,ERestoreState const& value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*,ERestoreState && value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*,Error err) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 536 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetCurrentVersion_implActor*>(this)->SAV<Version>::futures) { (void)(version); this->~GetCurrentVersion_implActorState(); static_cast<GetCurrentVersion_implActor*>(this)->destroy(); return 0; }
															#line 3511 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetCurrentVersion_implActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~GetCurrentVersion_implActorState();
		static_cast<GetCurrentVersion_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state > 0) static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetCurrentVersion_implActor*>(this)->ActorCallback< GetCurrentVersion_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetCurrentVersion_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state > 0) static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetCurrentVersion_implActor*>(this)->ActorCallback< GetCurrentVersion_implActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetCurrentVersion_implActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 528 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig* self;
															#line 528 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 529 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	ERestoreState status;
															#line 530 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version version;
															#line 3707 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getCurrentVersion_impl()
															#line 528 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetCurrentVersion_implActor final : public Actor<Version>, public ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >, public ActorCallback< GetCurrentVersion_implActor, 1, Void >, public ActorCallback< GetCurrentVersion_implActor, 2, Void >, public FastAllocated<GetCurrentVersion_implActor>, public GetCurrentVersion_implActorState<GetCurrentVersion_implActor> {
															#line 3712 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetCurrentVersion_implActor>::operator new;
	using FastAllocated<GetCurrentVersion_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16853137166351475968UL, 15655049728312519936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >;
friend struct ActorCallback< GetCurrentVersion_implActor, 1, Void >;
friend struct ActorCallback< GetCurrentVersion_implActor, 2, Void >;
															#line 528 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetCurrentVersion_implActor(RestoreConfig* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 3731 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   GetCurrentVersion_implActorState<GetCurrentVersion_implActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6492461230199787776UL, 8628143503146865408UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCurrentVersion_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetCurrentVersion_implActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetCurrentVersion_implActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 528 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Version> getCurrentVersion_impl( RestoreConfig* const& self, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 528 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Version>(new GetCurrentVersion_implActor(self, tr));
															#line 3765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 538 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Version> getCurrentVersion(Reference<ReadYourWritesTransaction> tr) {
		return getCurrentVersion_impl(this, tr);
	}

																#line 3774 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<std::string> getProgress_impl( RestoreConfig const& restore, Reference<ReadYourWritesTransaction> const& tr );
template <class> friend class RestoreConfig_GetProgress_implActorState;

#line 544 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::string> getProgress(Reference<ReadYourWritesTransaction> tr) { return getProgress_impl(*this, tr); }

																#line 3781 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<std::string> getFullStatus_impl( RestoreConfig const& restore, Reference<ReadYourWritesTransaction> const& tr );
template <class> friend class RestoreConfig_GetFullStatus_implActorState;

#line 547 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::string> getFullStatus(Reference<ReadYourWritesTransaction> tr) { return getFullStatus_impl(*this, tr); }
};

typedef RestoreConfig::RestoreFile RestoreFile;

															#line 3791 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getProgress_impl()
															#line 552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class RestoreConfig_GetProgress_implActor>
															#line 552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RestoreConfig_GetProgress_implActorState {
															#line 3797 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig_GetProgress_implActorState(RestoreConfig const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : restore(restore),
															#line 552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr)
															#line 3806 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getProgress_impl", reinterpret_cast<unsigned long>(this));

	}
	~RestoreConfig_GetProgress_implActorState() 
	{
		fdb_probe_actor_destroy("getProgress_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 554 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 555 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 557 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			fileCount = restore.fileCount().getD(tr);
															#line 558 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			fileBlockCount = restore.fileBlockCount().getD(tr);
															#line 559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			fileBlocksDispatched = restore.filesBlocksDispatched().getD(tr);
															#line 560 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			fileBlocksFinished = restore.fileBlocksFinished().getD(tr);
															#line 561 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			bytesWritten = restore.bytesWritten().getD(tr);
															#line 562 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			status = restore.stateText(tr);
															#line 563 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			currentVersion = restore.getCurrentVersion(tr);
															#line 564 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			lag = restore.getApplyVersionLag(tr);
															#line 565 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			firstConsistentVersion = restore.firstConsistentVersion().getD(tr);
															#line 566 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tag = restore.tag().getD(tr);
															#line 567 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			lastError = restore.lastError().getD(tr);
															#line 570 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			uid = restore.getUid();
															#line 571 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(fileCount) && success(fileBlockCount) && success(fileBlocksDispatched) && success(fileBlocksFinished) && success(bytesWritten) && success(status) && success(currentVersion) && success(lag) && success(firstConsistentVersion) && success(tag) && success(lastError);
															#line 571 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<RestoreConfig_GetProgress_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3851 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreConfig_GetProgress_implActor*>(this)->actor_wait_state = 1;
															#line 571 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*>(static_cast<RestoreConfig_GetProgress_implActor*>(this)));
															#line 3856 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreConfig_GetProgress_implActorState();
		static_cast<RestoreConfig_GetProgress_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 575 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string errstr = "None";
															#line 576 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (lastError.get().second != 0)
															#line 3881 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 577 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			errstr = format("'%s' %" PRId64 "s ago.\n", lastError.get().first.c_str(), (tr->getReadVersion().get() - lastError.get().second) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND);
															#line 3885 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 581 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileRestoreProgress") .detail("RestoreUID", uid) .detail("Tag", tag.get()) .detail("State", status.get().toString()) .detail("FileCount", fileCount.get()) .detail("FileBlocksFinished", fileBlocksFinished.get()) .detail("FileBlocksTotal", fileBlockCount.get()) .detail("FileBlocksInProgress", fileBlocksDispatched.get() - fileBlocksFinished.get()) .detail("BytesWritten", bytesWritten.get()) .detail("CurrentVersion", currentVersion.get()) .detail("FirstConsistentVersion", firstConsistentVersion.get()) .detail("ApplyLag", lag.get()) .detail("TaskInstance", THIS_ADDR);
															#line 595 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RestoreConfig_GetProgress_implActor*>(this)->SAV<std::string>::futures) { (void)(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str())); this->~RestoreConfig_GetProgress_implActorState(); static_cast<RestoreConfig_GetProgress_implActor*>(this)->destroy(); return 0; }
															#line 3891 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<RestoreConfig_GetProgress_implActor*>(this)->SAV< std::string >::value()) std::string(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str()));
		this->~RestoreConfig_GetProgress_implActorState();
		static_cast<RestoreConfig_GetProgress_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 575 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string errstr = "None";
															#line 576 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (lastError.get().second != 0)
															#line 3905 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 577 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			errstr = format("'%s' %" PRId64 "s ago.\n", lastError.get().first.c_str(), (tr->getReadVersion().get() - lastError.get().second) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND);
															#line 3909 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 581 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileRestoreProgress") .detail("RestoreUID", uid) .detail("Tag", tag.get()) .detail("State", status.get().toString()) .detail("FileCount", fileCount.get()) .detail("FileBlocksFinished", fileBlocksFinished.get()) .detail("FileBlocksTotal", fileBlockCount.get()) .detail("FileBlocksInProgress", fileBlocksDispatched.get() - fileBlocksFinished.get()) .detail("BytesWritten", bytesWritten.get()) .detail("CurrentVersion", currentVersion.get()) .detail("FirstConsistentVersion", firstConsistentVersion.get()) .detail("ApplyLag", lag.get()) .detail("TaskInstance", THIS_ADDR);
															#line 595 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RestoreConfig_GetProgress_implActor*>(this)->SAV<std::string>::futures) { (void)(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str())); this->~RestoreConfig_GetProgress_implActorState(); static_cast<RestoreConfig_GetProgress_implActor*>(this)->destroy(); return 0; }
															#line 3915 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<RestoreConfig_GetProgress_implActor*>(this)->SAV< std::string >::value()) std::string(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str()));
		this->~RestoreConfig_GetProgress_implActorState();
		static_cast<RestoreConfig_GetProgress_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreConfig_GetProgress_implActor*>(this)->actor_wait_state > 0) static_cast<RestoreConfig_GetProgress_implActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreConfig_GetProgress_implActor*>(this)->ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig restore;
															#line 552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 557 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> fileCount;
															#line 558 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> fileBlockCount;
															#line 559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> fileBlocksDispatched;
															#line 560 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> fileBlocksFinished;
															#line 561 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> bytesWritten;
															#line 562 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<StringRef> status;
															#line 563 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Version> currentVersion;
															#line 564 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Version> lag;
															#line 565 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Version> firstConsistentVersion;
															#line 566 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::string> tag;
															#line 567 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::pair<std::string, Version>> lastError;
															#line 570 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID uid;
															#line 4026 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getProgress_impl()
															#line 552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RestoreConfig_GetProgress_implActor final : public Actor<std::string>, public ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >, public FastAllocated<RestoreConfig_GetProgress_implActor>, public RestoreConfig_GetProgress_implActorState<RestoreConfig_GetProgress_implActor> {
															#line 4031 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<RestoreConfig_GetProgress_implActor>::operator new;
	using FastAllocated<RestoreConfig_GetProgress_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10629783765153995776UL, 4931006301993622272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >;
															#line 552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig_GetProgress_implActor(RestoreConfig const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 4048 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<std::string>(),
		   RestoreConfig_GetProgress_implActorState<RestoreConfig_GetProgress_implActor>(restore, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18275805459408915200UL, 825561359449413632UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getProgress_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<std::string> RestoreConfig::getProgress_impl( RestoreConfig const& restore, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<std::string>(new RestoreConfig_GetProgress_implActor(restore, tr));
															#line 4080 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 608 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 4085 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getFullStatus_impl()
															#line 609 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class RestoreConfig_GetFullStatus_implActor>
															#line 609 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RestoreConfig_GetFullStatus_implActorState {
															#line 4091 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 609 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig_GetFullStatus_implActorState(RestoreConfig const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 609 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 609 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : restore(restore),
															#line 609 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr)
															#line 4100 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getFullStatus_impl", reinterpret_cast<unsigned long>(this));

	}
	~RestoreConfig_GetFullStatus_implActorState() 
	{
		fdb_probe_actor_destroy("getFullStatus_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 611 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 612 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 614 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ranges = restore.getRestoreRangesOrDefault(tr);
															#line 615 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			addPrefix = restore.addPrefix().getD(tr);
															#line 616 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			removePrefix = restore.removePrefix().getD(tr);
															#line 617 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			url = restore.sourceContainerURL().getD(tr);
															#line 618 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			restoreVersion = restore.restoreVersion().getD(tr);
															#line 619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			progress = restore.getProgress(tr);
															#line 620 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			restoreState = restore.stateEnum().getD(tr);
															#line 621 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			useRangeFileRestore = restore.useRangeFileRestore().get(tr);
															#line 622 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			bulkLoadComplete = restore.bulkLoadComplete().get(tr);
															#line 625 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(ranges) && success(addPrefix) && success(removePrefix) && success(url) && success(restoreVersion) && success(progress) && success(restoreState) && success(useRangeFileRestore) && success(bulkLoadComplete);
															#line 625 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4139 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->actor_wait_state = 1;
															#line 625 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*>(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)));
															#line 4144 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreConfig_GetFullStatus_implActorState();
		static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 628 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string returnStr;
															#line 629 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr = format("%s  URL: %s", progress.get().c_str(), url.get().toString().c_str());
															#line 630 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& range : ranges.get() ) {
															#line 631 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			returnStr += format("  Range: '%s'-'%s'", printable(range.begin).c_str(), printable(range.end).c_str());
															#line 4173 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 633 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr += format("  AddPrefix: '%s'  RemovePrefix: '%s'  Version: %lld", printable(addPrefix.get()).c_str(), printable(removePrefix.get()).c_str(), restoreVersion.get());
															#line 640 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool usingBulkLoad = useRangeFileRestore.get().present() && !useRangeFileRestore.get().get();
															#line 641 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string snapshotMethod = usingBulkLoad ? "bulkload" : "rangefile";
															#line 642 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr += format("  Snapshot Method: %s", snapshotMethod.c_str());
															#line 645 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ERestoreState currentState = restoreState.get();
															#line 646 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (currentState == ERestoreState::RUNNING)
															#line 4187 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 647 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			bool bulkLoadDone = bulkLoadComplete.get().present() && bulkLoadComplete.get().get();
															#line 648 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (usingBulkLoad)
															#line 4193 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 649 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::string snapshotPhase = bulkLoadDone ? "complete" : "in_progress";
															#line 650 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				returnStr += format("  Snapshot Phase: %s", snapshotPhase.c_str());
															#line 651 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::string mutationPhase = bulkLoadDone ? "in_progress" : "not_started";
															#line 652 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				returnStr += format("  Mutation Log Phase: %s", mutationPhase.c_str());
															#line 4203 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
			else
			{
															#line 654 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				returnStr += "  Snapshot Phase: in_progress  Mutation Log Phase: in_progress";
															#line 4209 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 656 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (currentState == ERestoreState::COMPLETED)
															#line 4216 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 657 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				returnStr += "  Snapshot Phase: complete  Mutation Log Phase: complete";
															#line 4220 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
		}
															#line 660 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->SAV<std::string>::futures) { (void)(returnStr); this->~RestoreConfig_GetFullStatus_implActorState(); static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->destroy(); return 0; }
															#line 4225 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->SAV< std::string >::value()) std::string(returnStr);
		this->~RestoreConfig_GetFullStatus_implActorState();
		static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 628 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string returnStr;
															#line 629 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr = format("%s  URL: %s", progress.get().c_str(), url.get().toString().c_str());
															#line 630 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& range : ranges.get() ) {
															#line 631 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			returnStr += format("  Range: '%s'-'%s'", printable(range.begin).c_str(), printable(range.end).c_str());
															#line 4243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 633 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr += format("  AddPrefix: '%s'  RemovePrefix: '%s'  Version: %lld", printable(addPrefix.get()).c_str(), printable(removePrefix.get()).c_str(), restoreVersion.get());
															#line 640 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool usingBulkLoad = useRangeFileRestore.get().present() && !useRangeFileRestore.get().get();
															#line 641 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string snapshotMethod = usingBulkLoad ? "bulkload" : "rangefile";
															#line 642 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr += format("  Snapshot Method: %s", snapshotMethod.c_str());
															#line 645 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ERestoreState currentState = restoreState.get();
															#line 646 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (currentState == ERestoreState::RUNNING)
															#line 4257 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 647 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			bool bulkLoadDone = bulkLoadComplete.get().present() && bulkLoadComplete.get().get();
															#line 648 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (usingBulkLoad)
															#line 4263 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 649 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::string snapshotPhase = bulkLoadDone ? "complete" : "in_progress";
															#line 650 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				returnStr += format("  Snapshot Phase: %s", snapshotPhase.c_str());
															#line 651 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::string mutationPhase = bulkLoadDone ? "in_progress" : "not_started";
															#line 652 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				returnStr += format("  Mutation Log Phase: %s", mutationPhase.c_str());
															#line 4273 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
			else
			{
															#line 654 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				returnStr += "  Snapshot Phase: in_progress  Mutation Log Phase: in_progress";
															#line 4279 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 656 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (currentState == ERestoreState::COMPLETED)
															#line 4286 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 657 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				returnStr += "  Snapshot Phase: complete  Mutation Log Phase: complete";
															#line 4290 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
		}
															#line 660 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->SAV<std::string>::futures) { (void)(returnStr); this->~RestoreConfig_GetFullStatus_implActorState(); static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->destroy(); return 0; }
															#line 4295 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->SAV< std::string >::value()) std::string(returnStr);
		this->~RestoreConfig_GetFullStatus_implActorState();
		static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->actor_wait_state > 0) static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 609 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig restore;
															#line 609 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 614 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::vector<KeyRange>> ranges;
															#line 615 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Key> addPrefix;
															#line 616 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Key> removePrefix;
															#line 617 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Key> url;
															#line 618 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Version> restoreVersion;
															#line 619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::string> progress;
															#line 620 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<ERestoreState> restoreState;
															#line 621 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Optional<bool>> useRangeFileRestore;
															#line 622 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Optional<bool>> bulkLoadComplete;
															#line 4400 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getFullStatus_impl()
															#line 609 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RestoreConfig_GetFullStatus_implActor final : public Actor<std::string>, public ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >, public FastAllocated<RestoreConfig_GetFullStatus_implActor>, public RestoreConfig_GetFullStatus_implActorState<RestoreConfig_GetFullStatus_implActor> {
															#line 4405 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<RestoreConfig_GetFullStatus_implActor>::operator new;
	using FastAllocated<RestoreConfig_GetFullStatus_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8197594590237961472UL, 12150893068018479616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >;
															#line 609 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig_GetFullStatus_implActor(RestoreConfig const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 4422 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<std::string>(),
		   RestoreConfig_GetFullStatus_implActorState<RestoreConfig_GetFullStatus_implActor>(restore, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1316626605627362304UL, 15365334437446535168UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getFullStatus_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 609 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<std::string> RestoreConfig::getFullStatus_impl( RestoreConfig const& restore, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 609 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<std::string>(new RestoreConfig_GetFullStatus_implActor(restore, tr));
															#line 4454 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 662 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// two buffers are alternatively serving data and reading data from file
// thus when one buffer is serving data through peek()
// the other buffer is reading data from file to provide pipelining.
class TwoBuffers : public ReferenceCounted<TwoBuffers>, NonCopyable {
public:
	class IteratorBuffer : public ReferenceCounted<IteratorBuffer> {
	public:
		std::shared_ptr<char[]> data;
		// has_value means there is data, otherwise it means there is no data being fetched or ready
		// is_valid means data is being fetched, is_ready means data is ready
		std::optional<Future<Void>> fetchingData;
		size_t size;
		int index;
		int capacity;
		IteratorBuffer(int _capacity) {
			capacity = _capacity;
			data = std::shared_ptr<char[]>(new char[capacity]());
			fetchingData.reset();
			size = 0;
		}
		bool is_valid() { return fetchingData.has_value(); }
		void reset() {
			size = 0;
			index = 0;
			fetchingData.reset();
		}
	};
	TwoBuffers(int capacity, Reference<IBackupContainer> _bc, std::vector<RestoreConfig::RestoreFile>& _files, int tag);
	// ready need to be called first before calling peek
	// because a shared_ptr cannot be wrapped by a Future
	// this method ensures the current buffer has available data
	Future<Void> ready();
																#line 4491 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> ready( Reference<TwoBuffers> const& self );
template <class> friend class TwoBuffers_ReadyActorState;

#line 696 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	// fill buffer[index] with the next block of file
	// it has side effects to change currentFileIndex and currentFilePosition
																#line 4498 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> readNextBlock( Reference<TwoBuffers> const& self, int const& index );
template <class> friend class TwoBuffers_ReadNextBlockActorState;

#line 699 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	// peek can only be called after ready is called
	// it returns the pointer to the active buffer
	std::shared_ptr<char[]> peek();

	int getFileIndex();
	void setFileIndex(int);

	bool hasNext();

	void reset();

	// discard the current buffer and swap to the next one
	void discardAndSwap();

	// try to fill the buffer[index]
	// but no-op if the buffer have valid data or it is actively being filled
	void fillBufferIfAbsent(int index);

	size_t getBufferSize();

private:
	Reference<IteratorBuffer> buffers[2]; // Two buffers for alternating
	size_t bufferCapacity; // Size of each buffer in bytes
	Reference<IBackupContainer> bc;
	std::vector<RestoreConfig::RestoreFile> files;
	int tag;

	int cur; // Index of the current active buffer (0 or 1)
	size_t currentFileIndex; // Index of the current file being read
	size_t currentFilePosition; // Current read position in the current file
};

TwoBuffers::TwoBuffers(int capacity,
                       Reference<IBackupContainer> _bc,
                       std::vector<RestoreConfig::RestoreFile>& _files,
                       int _tag)
  : currentFileIndex(0), currentFilePosition(0), cur(0), bufferCapacity(capacity), files(_files), bc(_bc), tag(_tag) {
	buffers[0] = makeReference<IteratorBuffer>(capacity);
	buffers[1] = makeReference<IteratorBuffer>(capacity);
}

bool TwoBuffers::hasNext() {
	// if it is being load (valid but not ready, what would be the size?)
	while (currentFileIndex < files.size() && currentFilePosition >= files[currentFileIndex].fileSize) {
		currentFileIndex++;
		currentFilePosition = 0;
	}

	if (buffers[0]->is_valid() || buffers[1]->is_valid()) {
		return true;
	}

	return currentFileIndex != files.size();
}

Future<Void> TwoBuffers::ready() {
	return ready(Reference<TwoBuffers>::addRef(this));
}

															#line 4562 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via ready()
															#line 758 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class TwoBuffers_ReadyActor>
															#line 758 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TwoBuffers_ReadyActorState {
															#line 4568 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 758 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TwoBuffers_ReadyActorState(Reference<TwoBuffers> const& self) 
															#line 758 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 758 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 4575 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("ready", reinterpret_cast<unsigned long>(this));

	}
	~TwoBuffers_ReadyActorState() 
	{
		fdb_probe_actor_destroy("ready", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 760 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 4590 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 761 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<TwoBuffers_ReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadyActorState(); static_cast<TwoBuffers_ReadyActor*>(this)->destroy(); return 0; }
															#line 4594 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<TwoBuffers_ReadyActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TwoBuffers_ReadyActorState();
				static_cast<TwoBuffers_ReadyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 764 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			self->fillBufferIfAbsent(self->cur);
															#line 765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->buffers[self->cur]->fetchingData.value();
															#line 765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<TwoBuffers_ReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4606 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TwoBuffers_ReadyActor*>(this)->actor_wait_state = 1;
															#line 765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TwoBuffers_ReadyActor, 0, Void >*>(static_cast<TwoBuffers_ReadyActor*>(this)));
															#line 4611 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TwoBuffers_ReadyActorState();
		static_cast<TwoBuffers_ReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 767 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->hasNext())
															#line 4634 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 768 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			self->fillBufferIfAbsent(1 - self->cur);
															#line 4638 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 770 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TwoBuffers_ReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadyActorState(); static_cast<TwoBuffers_ReadyActor*>(this)->destroy(); return 0; }
															#line 4642 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<TwoBuffers_ReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TwoBuffers_ReadyActorState();
		static_cast<TwoBuffers_ReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 767 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->hasNext())
															#line 4654 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 768 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			self->fillBufferIfAbsent(1 - self->cur);
															#line 4658 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 770 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TwoBuffers_ReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadyActorState(); static_cast<TwoBuffers_ReadyActor*>(this)->destroy(); return 0; }
															#line 4662 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<TwoBuffers_ReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TwoBuffers_ReadyActorState();
		static_cast<TwoBuffers_ReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TwoBuffers_ReadyActor*>(this)->actor_wait_state > 0) static_cast<TwoBuffers_ReadyActor*>(this)->actor_wait_state = 0;
		static_cast<TwoBuffers_ReadyActor*>(this)->ActorCallback< TwoBuffers_ReadyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TwoBuffers_ReadyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 758 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TwoBuffers> self;
															#line 4747 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via ready()
															#line 758 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TwoBuffers_ReadyActor final : public Actor<Void>, public ActorCallback< TwoBuffers_ReadyActor, 0, Void >, public FastAllocated<TwoBuffers_ReadyActor>, public TwoBuffers_ReadyActorState<TwoBuffers_ReadyActor> {
															#line 4752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<TwoBuffers_ReadyActor>::operator new;
	using FastAllocated<TwoBuffers_ReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13686423382255259648UL, 3176290615514392576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TwoBuffers_ReadyActor, 0, Void >;
															#line 758 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TwoBuffers_ReadyActor(Reference<TwoBuffers> const& self) 
															#line 4769 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TwoBuffers_ReadyActorState<TwoBuffers_ReadyActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14937009140389269760UL, 8193691466251763968UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ready");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TwoBuffers_ReadyActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 758 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> TwoBuffers::ready( Reference<TwoBuffers> const& self ) {
															#line 758 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new TwoBuffers_ReadyActor(self));
															#line 4801 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 772 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

std::shared_ptr<char[]> TwoBuffers::peek() {
	return buffers[cur]->data;
}

int TwoBuffers::getFileIndex() {
	return buffers[cur]->index;
}

void TwoBuffers::setFileIndex(int newIndex) {
	if (newIndex < 0 || newIndex >= files.size()) {
		TraceEvent(SevError, "TwoBuffersFileIndexOutOfBound")
		    .detail("FilesSize", files.size())
		    .detail("NewIndex", newIndex)
		    .log();
	}
	currentFileIndex = newIndex;
}

void TwoBuffers::discardAndSwap() {
	// invalidate cur and change cur to next
	buffers[cur]->fetchingData.reset();
	cur = 1 - cur;
}

void TwoBuffers::reset() {
	// invalidate cur and change cur to next
	buffers[0]->reset();
	buffers[1]->reset();
	cur = 0;
	currentFileIndex = 0;
	currentFilePosition = 0;
}

size_t TwoBuffers::getBufferSize() {
	return buffers[cur]->size;
}

static double testKeyToDouble(const KeyRef& p) {
	uint64_t x = 0;
	sscanf(p.toString().c_str(), "%" SCNx64, &x);
	return *(double*)&x;
}

// only one readNextBlock can be run at a single time, otherwie the same block might be loaded twice
															#line 4850 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via readNextBlock()
															#line 817 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class TwoBuffers_ReadNextBlockActor>
															#line 817 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TwoBuffers_ReadNextBlockActorState {
															#line 4856 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 817 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TwoBuffers_ReadNextBlockActorState(Reference<TwoBuffers> const& self,int const& index) 
															#line 817 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 817 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 817 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   index(index),
															#line 818 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   asyncFile()
															#line 4867 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readNextBlock", reinterpret_cast<unsigned long>(this));

	}
	~TwoBuffers_ReadNextBlockActorState() 
	{
		fdb_probe_actor_destroy("readNextBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 819 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->currentFileIndex >= self->files.size())
															#line 4882 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 820 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevError, "ReadNextBlockOutOfBound") .detail("FileIndex", self->currentFileIndex) .detail("Tag", self->tag) .detail("Position", self->currentFilePosition) .detail("FileSize", self->files[self->currentFileIndex].fileSize) .detail("FilesCount", self->files.size()) .log();
															#line 827 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<TwoBuffers_ReadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadNextBlockActorState(); static_cast<TwoBuffers_ReadNextBlockActor*>(this)->destroy(); return 0; }
															#line 4888 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<TwoBuffers_ReadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TwoBuffers_ReadNextBlockActorState();
				static_cast<TwoBuffers_ReadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 829 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = self->bc->readFile(self->files[self->currentFileIndex].fileName);
															#line 829 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 1;
															#line 829 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*>(static_cast<TwoBuffers_ReadNextBlockActor*>(this)));
															#line 4903 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TwoBuffers_ReadNextBlockActorState();
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> const& asyncFileTmp,int loopDepth) 
	{
															#line 830 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		asyncFile = asyncFileTmp;
															#line 831 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileSize = self->files[self->currentFileIndex].fileSize;
															#line 832 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		size_t remaining = fileSize - self->currentFilePosition;
															#line 833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesToRead = std::min(self->bufferCapacity, remaining);
															#line 834 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int> __when_expr_1 = asyncFile->read(static_cast<void*>(self->buffers[index]->data.get()), bytesToRead, self->currentFilePosition);
															#line 834 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4936 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 2;
															#line 834 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*>(static_cast<TwoBuffers_ReadNextBlockActor*>(this)));
															#line 4941 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> && asyncFileTmp,int loopDepth) 
	{
															#line 830 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		asyncFile = asyncFileTmp;
															#line 831 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileSize = self->files[self->currentFileIndex].fileSize;
															#line 832 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		size_t remaining = fileSize - self->currentFilePosition;
															#line 833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesToRead = std::min(self->bufferCapacity, remaining);
															#line 834 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int> __when_expr_1 = asyncFile->read(static_cast<void*>(self->buffers[index]->data.get()), bytesToRead, self->currentFilePosition);
															#line 834 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4960 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 2;
															#line 834 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*>(static_cast<TwoBuffers_ReadNextBlockActor*>(this)));
															#line 4965 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& asyncFileTmp,int loopDepth) 
	{
		loopDepth = a_body1cont1(asyncFileTmp, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && asyncFileTmp,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(asyncFileTmp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state > 0) static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 0;
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 836 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (bytesRead != bytesToRead)
															#line 5049 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 837 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 5053 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 838 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->buffers[index]->index = self->currentFileIndex;
															#line 839 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->buffers[index]->size = bytesRead;
															#line 840 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->currentFilePosition += bytesRead;
															#line 842 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TwoBuffers_ReadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadNextBlockActorState(); static_cast<TwoBuffers_ReadNextBlockActor*>(this)->destroy(); return 0; }
															#line 5063 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<TwoBuffers_ReadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TwoBuffers_ReadNextBlockActorState();
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int const& __bytesRead,int loopDepth) 
	{
															#line 834 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesRead = __bytesRead;
															#line 5075 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && __bytesRead,int loopDepth) 
	{
		bytesRead = std::move(__bytesRead);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state > 0) static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 0;
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 817 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TwoBuffers> self;
															#line 817 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int index;
															#line 818 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> asyncFile;
															#line 831 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t fileSize;
															#line 833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t bytesToRead;
															#line 834 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesRead;
															#line 5162 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readNextBlock()
															#line 817 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TwoBuffers_ReadNextBlockActor final : public Actor<Void>, public ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >, public ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >, public FastAllocated<TwoBuffers_ReadNextBlockActor>, public TwoBuffers_ReadNextBlockActorState<TwoBuffers_ReadNextBlockActor> {
															#line 5167 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<TwoBuffers_ReadNextBlockActor>::operator new;
	using FastAllocated<TwoBuffers_ReadNextBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3267569828351060736UL, 3241271155686419968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >;
															#line 817 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TwoBuffers_ReadNextBlockActor(Reference<TwoBuffers> const& self,int const& index) 
															#line 5185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TwoBuffers_ReadNextBlockActorState<TwoBuffers_ReadNextBlockActor>(self, index),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1542594355812348416UL, 14195273269523580672UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readNextBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 817 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> TwoBuffers::readNextBlock( Reference<TwoBuffers> const& self, int const& index ) {
															#line 817 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new TwoBuffers_ReadNextBlockActor(self, index));
															#line 5218 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 844 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

void TwoBuffers::fillBufferIfAbsent(int index) {
	if (buffers[index]->is_valid()) {
		// if this buffer is valid, then do not overwrite it
		return;
	}
	if (currentFileIndex == files.size()) {
		// quit if no more contents
		return;
	}
	auto self = Reference<TwoBuffers>::addRef(this);
	self->buffers[index]->fetchingData = readNextBlock(self, index);
	return;
}

bool endOfBlock(char* start, int offset) {
	const unsigned char paddingChar = '\xff';
	return (unsigned char)*(start + offset) == paddingChar;
}

class PartitionedLogIteratorSimple : public PartitionedLogIterator {
public:
	const int BATCH_READ_BLOCK_COUNT = 1;
	const int BLOCK_SIZE = CLIENT_KNOBS->BACKUP_LOGFILE_BLOCK_SIZE;
	const int mutationHeaderBytes = sizeof(int64_t) + sizeof(int32_t) + sizeof(int32_t);
	Reference<IBackupContainer> bc;
	size_t bufferCapacity;
	int tag;
	std::vector<RestoreConfig::RestoreFile> files;
	size_t bufferOffset; // Current read offset
	int bufferSize;
	int fileOffset;
	int fileIndex;
	std::shared_ptr<char[]> buffer;
	std::vector<Version> endVersions;

	PartitionedLogIteratorSimple(Reference<IBackupContainer> _bc,
	                             int _tag,
	                             std::vector<RestoreConfig::RestoreFile> _files,
	                             std::vector<Version> _endVersions);

	bool hasNext();
	Future<Void> loadNextBlock();
																#line 5265 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> loadNextBlock( Reference<PartitionedLogIteratorSimple> const& self );
template <class> friend class PartitionedLogIteratorSimple_LoadNextBlockActorState;

#line 888 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	void removeBlockHeader();

	Standalone<VectorRef<VersionedMutation>> consumeData(Version firstVersion);

	// find the next version without advanding the iterator
	Future<Version> peekNextVersion();
																#line 5276 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Version> peekNextVersion( Reference<PartitionedLogIteratorSimple> const& iterator );
template <class> friend class PartitionedLogIteratorSimple_PeekNextVersionActorState;

#line 895 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// get all the mutations of next version and advance the iterator
	// this might issue multiple consumeData() if the data of a version cross buffer boundary
	Future<Standalone<VectorRef<VersionedMutation>>> getNext();
																#line 5285 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Standalone<VectorRef<VersionedMutation>>> getNext( Reference<PartitionedLogIteratorSimple> const& iterator );
template <class> friend class PartitionedLogIteratorSimple_GetNextActorState;

#line 901 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
};

PartitionedLogIteratorSimple::PartitionedLogIteratorSimple(Reference<IBackupContainer> _bc,
                                                           int _tag,
                                                           std::vector<RestoreConfig::RestoreFile> _files,
                                                           std::vector<Version> _endVersions)
  : bc(_bc), tag(_tag), endVersions(_endVersions), files(std::move(_files)), bufferOffset(0) {
	bufferCapacity = BATCH_READ_BLOCK_COUNT * BLOCK_SIZE;
	buffer = std::shared_ptr<char[]>(new char[bufferCapacity]());
	fileOffset = 0;
	fileIndex = 0;
	bufferSize = 0;
}

// it will set fileOffset and fileIndex
bool PartitionedLogIteratorSimple::hasNext() {
	if (bufferOffset < bufferSize) {
		return true;
	}
	while (fileIndex < files.size() && fileOffset >= files[fileIndex].fileSize) {
		TraceEvent("ReachEndOfLogFiles")
		    .detail("BufferOffset", bufferOffset)
		    .detail("BufferSize", bufferSize)
		    .detail("FileOffset", fileOffset)
		    .detail("FileSize", files[fileIndex].fileSize)
		    .detail("FileName", files[fileIndex].fileName)
		    .detail("Tag", tag)
		    .detail("Index", fileIndex)
		    .log();
		fileOffset = 0;
		fileIndex++;
	}
	return fileIndex < files.size() && fileOffset < files[fileIndex].fileSize;
}

void PartitionedLogIteratorSimple::removeBlockHeader() {
	if (bufferOffset % BLOCK_SIZE == 0) {
		bufferOffset += sizeof(uint32_t);
	}
}

Standalone<VectorRef<VersionedMutation>> PartitionedLogIteratorSimple::consumeData(Version firstVersion) {
	Standalone<VectorRef<VersionedMutation>> mutations = Standalone<VectorRef<VersionedMutation>>();
	char* start = buffer.get();
	bool foundNewVersion = false;
	while (bufferOffset < bufferSize) {
		while (bufferOffset < bufferSize && !endOfBlock(start, bufferOffset)) {
			// for each block
			removeBlockHeader();

			// encoding format:
			// wr << bigEndian64(message.version.version) << bigEndian32(message.version.sub) <<
			// bigEndian32(mutation.size());
			Version version;
			std::memcpy(&version, start + bufferOffset, sizeof(Version));
			version = bigEndian64(version);
			if (version != firstVersion) {
				foundNewVersion = true;
				break; // Different version, stop here
			}

			int32_t subsequence;
			std::memcpy(&subsequence, start + bufferOffset + sizeof(Version), sizeof(int32_t));
			subsequence = bigEndian32(subsequence);

			int32_t mutationSize;
			std::memcpy(&mutationSize, start + bufferOffset + sizeof(Version) + sizeof(int32_t), sizeof(int32_t));
			mutationSize = bigEndian32(mutationSize);

			// assumption: the entire mutation is within the buffer
			size_t mutationTotalSize = mutationHeaderBytes + mutationSize;
			ASSERT(bufferOffset + mutationTotalSize <= bufferSize);

			// transform from stringref to mutationref here
			Standalone<StringRef> mutationData = makeString(mutationSize);
			std::memcpy(mutateString(mutationData), start + bufferOffset + mutationHeaderBytes, mutationSize);
			ArenaReader reader(mutationData.arena(), mutationData, AssumeVersion(g_network->protocolVersion()));
			MutationRef mutation;
			reader >> mutation;

			VersionedMutation vm;
			vm.version = version;
			vm.subsequence = subsequence;
			vm.mutation = mutation;
			mutations.push_back_deep(mutations.arena(), vm);
			// Move the bufferOffset to include this mutation
			bufferOffset += mutationTotalSize;
		}

		if (bufferOffset < bufferSize && endOfBlock(start, bufferOffset)) {
			// there are paddings
			int remain = BLOCK_SIZE - (bufferOffset % BLOCK_SIZE);
			bufferOffset += remain;
		}
		if (foundNewVersion) {
			break;
		}
	}

	return mutations;
}

Future<Void> PartitionedLogIteratorSimple::loadNextBlock() {
	return loadNextBlock(Reference<PartitionedLogIteratorSimple>::addRef(this));
}

															#line 5396 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via loadNextBlock()
															#line 1007 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorSimple_LoadNextBlockActor>
															#line 1007 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_LoadNextBlockActorState {
															#line 5402 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1007 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_LoadNextBlockActorState(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 1007 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1007 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 5409 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("loadNextBlock", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorSimple_LoadNextBlockActorState() 
	{
		fdb_probe_actor_destroy("loadNextBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1008 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->bufferOffset < self->bufferSize)
															#line 5424 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1010 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PartitionedLogIteratorSimple_LoadNextBlockActorState(); static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->destroy(); return 0; }
															#line 5428 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PartitionedLogIteratorSimple_LoadNextBlockActorState();
				static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1012 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 5436 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1013 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PartitionedLogIteratorSimple_LoadNextBlockActorState(); static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->destroy(); return 0; }
															#line 5440 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PartitionedLogIteratorSimple_LoadNextBlockActorState();
				static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1015 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			asyncFile = Reference<IAsyncFile>();
															#line 1016 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = self->bc->readFile(self->files[self->fileIndex].fileName);
															#line 1016 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5452 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 1;
															#line 1016 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*>(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)));
															#line 5457 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorSimple_LoadNextBlockActorState();
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> const& asyncFileTmp,int loopDepth) 
	{
															#line 1017 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		asyncFile = asyncFileTmp;
															#line 1018 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileSize = self->files[self->fileIndex].fileSize;
															#line 1019 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		size_t remaining = fileSize - self->fileOffset;
															#line 1020 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesToRead = std::min(self->bufferCapacity, remaining);
															#line 1021 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int> __when_expr_1 = asyncFile->read(static_cast<void*>((self->buffer.get())), bytesToRead, self->fileOffset);
															#line 1021 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5490 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 2;
															#line 1021 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*>(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)));
															#line 5495 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> && asyncFileTmp,int loopDepth) 
	{
															#line 1017 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		asyncFile = asyncFileTmp;
															#line 1018 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileSize = self->files[self->fileIndex].fileSize;
															#line 1019 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		size_t remaining = fileSize - self->fileOffset;
															#line 1020 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesToRead = std::min(self->bufferCapacity, remaining);
															#line 1021 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int> __when_expr_1 = asyncFile->read(static_cast<void*>((self->buffer.get())), bytesToRead, self->fileOffset);
															#line 1021 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5514 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 2;
															#line 1021 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*>(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)));
															#line 5519 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& asyncFileTmp,int loopDepth) 
	{
		loopDepth = a_body1cont1(asyncFileTmp, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && asyncFileTmp,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(asyncFileTmp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1023 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (bytesRead != bytesToRead)
															#line 5603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1024 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 5607 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1025 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferSize = bytesRead;
															#line 1026 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferOffset = 0;
															#line 1027 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->fileOffset += bytesRead;
															#line 1028 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PartitionedLogIteratorSimple_LoadNextBlockActorState(); static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->destroy(); return 0; }
															#line 5617 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PartitionedLogIteratorSimple_LoadNextBlockActorState();
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int const& __bytesRead,int loopDepth) 
	{
															#line 1021 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesRead = __bytesRead;
															#line 5629 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && __bytesRead,int loopDepth) 
	{
		bytesRead = std::move(__bytesRead);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1007 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorSimple> self;
															#line 1015 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> asyncFile;
															#line 1018 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t fileSize;
															#line 1020 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t bytesToRead;
															#line 1021 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesRead;
															#line 5714 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via loadNextBlock()
															#line 1007 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_LoadNextBlockActor final : public Actor<Void>, public ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >, public ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >, public FastAllocated<PartitionedLogIteratorSimple_LoadNextBlockActor>, public PartitionedLogIteratorSimple_LoadNextBlockActorState<PartitionedLogIteratorSimple_LoadNextBlockActor> {
															#line 5719 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorSimple_LoadNextBlockActor>::operator new;
	using FastAllocated<PartitionedLogIteratorSimple_LoadNextBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12672113062714780160UL, 16334271370645297408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >;
															#line 1007 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_LoadNextBlockActor(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 5737 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PartitionedLogIteratorSimple_LoadNextBlockActorState<PartitionedLogIteratorSimple_LoadNextBlockActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9541533795093038848UL, 7792905219334807296UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadNextBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1007 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> PartitionedLogIteratorSimple::loadNextBlock( Reference<PartitionedLogIteratorSimple> const& self ) {
															#line 1007 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new PartitionedLogIteratorSimple_LoadNextBlockActor(self));
															#line 5770 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1030 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

Future<Version> PartitionedLogIteratorSimple::peekNextVersion() {
	return peekNextVersion(Reference<PartitionedLogIteratorSimple>::addRef(this));
}

															#line 5779 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via peekNextVersion()
															#line 1035 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorSimple_PeekNextVersionActor>
															#line 1035 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_PeekNextVersionActorState {
															#line 5785 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1035 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_PeekNextVersionActorState(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 1035 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1035 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 5792 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("peekNextVersion", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorSimple_PeekNextVersionActorState() 
	{
		fdb_probe_actor_destroy("peekNextVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1037 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 5807 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1038 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->SAV<Version>::futures) { (void)(Version(0)); this->~PartitionedLogIteratorSimple_PeekNextVersionActorState(); static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->destroy(); return 0; }
															#line 5811 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->SAV< Version >::value()) Version(Version(0));
				this->~PartitionedLogIteratorSimple_PeekNextVersionActorState();
				static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1040 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->loadNextBlock();
															#line 1040 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state = 1;
															#line 1040 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*>(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)));
															#line 5826 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorSimple_PeekNextVersionActorState();
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1041 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1042 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = Version();
															#line 1043 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, self->buffer.get() + self->bufferOffset, sizeof(Version));
															#line 1044 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1046 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 5857 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1041 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1042 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = Version();
															#line 1043 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, self->buffer.get() + self->bufferOffset, sizeof(Version));
															#line 1044 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1046 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 5874 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1060 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~PartitionedLogIteratorSimple_PeekNextVersionActorState(); static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->destroy(); return 0; }
															#line 5958 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~PartitionedLogIteratorSimple_PeekNextVersionActorState();
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1046 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(self->fileIndex < self->endVersions.size() - 1 && version >= self->endVersions[self->fileIndex]))
															#line 5977 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1047 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("SimpleIteratorFindOverlapAndSkip") .detail("Version", version) .detail("FileIndex", self->fileIndex) .log();
															#line 1051 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferOffset = 0;
															#line 1052 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferSize = 0;
															#line 1053 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->fileOffset = 0;
															#line 1054 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->fileIndex += 1;
															#line 1055 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->loadNextBlock();
															#line 1055 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5995 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state = 2;
															#line 1055 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*>(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)));
															#line 6000 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1056 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1057 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, self->buffer.get() + self->bufferOffset, sizeof(Version));
															#line 1058 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 6026 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1056 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1057 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, self->buffer.get() + self->bufferOffset, sizeof(Version));
															#line 1058 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 6039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1035 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorSimple> self;
															#line 1042 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version version;
															#line 6123 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via peekNextVersion()
															#line 1035 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_PeekNextVersionActor final : public Actor<Version>, public ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >, public ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >, public FastAllocated<PartitionedLogIteratorSimple_PeekNextVersionActor>, public PartitionedLogIteratorSimple_PeekNextVersionActorState<PartitionedLogIteratorSimple_PeekNextVersionActor> {
															#line 6128 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorSimple_PeekNextVersionActor>::operator new;
	using FastAllocated<PartitionedLogIteratorSimple_PeekNextVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14714186113775217920UL, 9012468205219612416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >;
friend struct ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >;
															#line 1035 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_PeekNextVersionActor(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 6146 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   PartitionedLogIteratorSimple_PeekNextVersionActorState<PartitionedLogIteratorSimple_PeekNextVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3510092154139981056UL, 14174065679173900288UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("peekNextVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1035 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Version> PartitionedLogIteratorSimple::peekNextVersion( Reference<PartitionedLogIteratorSimple> const& self ) {
															#line 1035 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Version>(new PartitionedLogIteratorSimple_PeekNextVersionActor(self));
															#line 6179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 6184 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getNext()
															#line 1063 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorSimple_GetNextActor>
															#line 1063 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_GetNextActorState {
															#line 6190 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1063 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_GetNextActorState(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 1063 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1063 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1065 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   mutations()
															#line 6199 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getNext", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorSimple_GetNextActorState() 
	{
		fdb_probe_actor_destroy("getNext", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1066 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 6214 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1067 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarn, "SimpleIteratorExhausted") .detail("BufferOffset", self->bufferOffset) .detail("BufferSize", self->bufferSize) .detail("Tag", self->tag) .log();
															#line 1072 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorSimple_GetNextActorState(); static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->destroy(); return 0; }
															#line 6220 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
				this->~PartitionedLogIteratorSimple_GetNextActorState();
				static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1074 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Version> __when_expr_0 = self->peekNextVersion();
															#line 1074 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6230 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state = 1;
															#line 1074 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*>(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)));
															#line 6235 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorSimple_GetNextActorState();
		static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1075 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Standalone<VectorRef<VersionedMutation>> firstBatch = self->consumeData(firstVersion);
															#line 1076 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		mutations = firstBatch;
															#line 1080 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 6262 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version const& __firstVersion,int loopDepth) 
	{
															#line 1074 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		firstVersion = __firstVersion;
															#line 6271 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __firstVersion,int loopDepth) 
	{
		firstVersion = std::move(__firstVersion);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1095 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorSimple_GetNextActorState(); static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->destroy(); return 0; }
															#line 6350 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
		this->~PartitionedLogIteratorSimple_GetNextActorState();
		static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1080 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(self->bufferOffset >= self->bufferSize))
															#line 6369 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1083 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->hasNext())
															#line 6375 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->loadNextBlock();
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6381 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state = 2;
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*>(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)));
															#line 6386 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1087 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Standalone<VectorRef<VersionedMutation>> batch = self->consumeData(firstVersion);
															#line 1088 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const VersionedMutation& vm : batch ) {
															#line 1089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			mutations.push_back_deep(mutations.arena(), vm);
															#line 6423 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1087 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Standalone<VectorRef<VersionedMutation>> batch = self->consumeData(firstVersion);
															#line 1088 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const VersionedMutation& vm : batch ) {
															#line 1089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			mutations.push_back_deep(mutations.arena(), vm);
															#line 6437 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1063 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorSimple> self;
															#line 1065 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<VersionedMutation>> mutations;
															#line 1074 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version firstVersion;
															#line 6524 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getNext()
															#line 1063 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_GetNextActor final : public Actor<Standalone<VectorRef<VersionedMutation>>>, public ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >, public ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >, public FastAllocated<PartitionedLogIteratorSimple_GetNextActor>, public PartitionedLogIteratorSimple_GetNextActorState<PartitionedLogIteratorSimple_GetNextActor> {
															#line 6529 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorSimple_GetNextActor>::operator new;
	using FastAllocated<PartitionedLogIteratorSimple_GetNextActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17418726896049259776UL, 4715211551062859520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<VersionedMutation>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >;
friend struct ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >;
															#line 1063 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_GetNextActor(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 6547 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<VersionedMutation>>>(),
		   PartitionedLogIteratorSimple_GetNextActorState<PartitionedLogIteratorSimple_GetNextActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17700238840770020608UL, 1654640055383343616UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNext");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1063 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorSimple::getNext( Reference<PartitionedLogIteratorSimple> const& self ) {
															#line 1063 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<VersionedMutation>>>(new PartitionedLogIteratorSimple_GetNextActor(self));
															#line 6580 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1097 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorSimple::getNext() {
	return getNext(Reference<PartitionedLogIteratorSimple>::addRef(this));
}

class PartitionedLogIteratorTwoBuffers : public PartitionedLogIterator {
private:
	Reference<TwoBuffers> twobuffer;

	// consume single version data upto the end of the current batch
	// stop if seeing a different version from the parameter.
	// it has side effects to update bufferOffset after reading the data
	Future<Standalone<VectorRef<VersionedMutation>>> consumeData(Version firstVersion);
																#line 6597 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Standalone<VectorRef<VersionedMutation>>> consumeData( Reference<PartitionedLogIteratorTwoBuffers> const& self, Version const& v );
template <class> friend class PartitionedLogIteratorTwoBuffers_ConsumeDataActorState;

#line 1113 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// each block has a format of {<header>[mutations]<padding>}, need to skip the header to read mutations
	// this method check if bufferOffset is at the boundary and advance it if necessary
	void removeBlockHeader();

public:
	// read up to a fixed number of block count
	// noted that each version has to be contained within 2 blocks
	const int BATCH_READ_BLOCK_COUNT = 1;
	const int BLOCK_SIZE = CLIENT_KNOBS->BACKUP_LOGFILE_BLOCK_SIZE;
	const int mutationHeaderBytes = sizeof(int64_t) + sizeof(int32_t) + sizeof(int32_t);
	Reference<IBackupContainer> bc;
	int tag;
	std::vector<RestoreConfig::RestoreFile> files;
	std::vector<Version> endVersions;
	bool hasMoreData; // Flag indicating if more data is available
	size_t bufferOffset; // Current read offset
	// empty means no data, future is valid but not ready means being fetched
	// future is ready means it currently holds data

	PartitionedLogIteratorTwoBuffers(Reference<IBackupContainer> _bc,
	                                 int _tag,
	                                 std::vector<RestoreConfig::RestoreFile> _files,
	                                 std::vector<Version> _endVersions);

	// whether there are more contents for this tag in all files specified
	bool hasNext();

	// find the next version without advanding the iterator
	Future<Version> peekNextVersion();
																#line 6632 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Version> peekNextVersion( Reference<PartitionedLogIteratorTwoBuffers> const& iterator );
template <class> friend class PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState;

#line 1144 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// get all the mutations of next version and advance the iterator
	// this might issue multiple consumeData() if the data of a version cross buffer boundary
	Future<Standalone<VectorRef<VersionedMutation>>> getNext();
																#line 6641 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Standalone<VectorRef<VersionedMutation>>> getNext( Reference<PartitionedLogIteratorTwoBuffers> const& iterator );
template <class> friend class PartitionedLogIteratorTwoBuffers_GetNextActorState;

#line 1150 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
};

Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorTwoBuffers::consumeData(Version firstVersion) {
	return consumeData(Reference<PartitionedLogIteratorTwoBuffers>::addRef(this), firstVersion);
}

															#line 6652 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via consumeData()
															#line 1156 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorTwoBuffers_ConsumeDataActor>
															#line 1156 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_ConsumeDataActorState {
															#line 6658 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1156 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_ConsumeDataActorState(Reference<PartitionedLogIteratorTwoBuffers> const& self,Version const& firstVersion) 
															#line 1156 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1156 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1156 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   firstVersion(firstVersion),
															#line 1159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   mutations(Standalone<VectorRef<VersionedMutation>>())
															#line 6669 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("consumeData", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState() 
	{
		fdb_probe_actor_destroy("consumeData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1160 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->twobuffer->ready();
															#line 1160 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6686 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->actor_wait_state = 1;
															#line 1160 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*>(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)));
															#line 6691 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1161 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::shared_ptr<char[]> start = self->twobuffer->peek();
															#line 1162 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		int size = self->twobuffer->getBufferSize();
															#line 1163 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool foundNewVersion = false;
															#line 1164 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for(;self->bufferOffset < size;) {
															#line 1165 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			for(;self->bufferOffset < size && !endOfBlock(start.get(), self->bufferOffset);) {
															#line 1167 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->removeBlockHeader();
															#line 1172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				Version version;
															#line 1173 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1174 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				version = bigEndian64(version);
															#line 1175 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (version != firstVersion)
															#line 6732 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				{
															#line 1176 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					foundNewVersion = true;
															#line 6736 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					break;
				}
															#line 1180 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int32_t subsequence;
															#line 1181 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy(&subsequence, start.get() + self->bufferOffset + sizeof(Version), sizeof(int32_t));
															#line 1182 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				subsequence = bigEndian32(subsequence);
															#line 1184 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int32_t mutationSize;
															#line 1185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy( &mutationSize, start.get() + self->bufferOffset + sizeof(Version) + sizeof(int32_t), sizeof(int32_t));
															#line 1187 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				mutationSize = bigEndian32(mutationSize);
															#line 1190 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				size_t mutationTotalSize = self->mutationHeaderBytes + mutationSize;
															#line 1191 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ASSERT(self->bufferOffset + mutationTotalSize <= size);
															#line 1193 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				Standalone<StringRef> mutationData = makeString(mutationSize);
															#line 1194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy( mutateString(mutationData), start.get() + self->bufferOffset + self->mutationHeaderBytes, mutationSize);
															#line 1197 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ArenaReader reader(mutationData.arena(), mutationData, AssumeVersion(g_network->protocolVersion()));
															#line 1198 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				MutationRef mutation;
															#line 1199 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				reader >> mutation;
															#line 1201 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				VersionedMutation vm;
															#line 1202 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.version = version;
															#line 1203 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.subsequence = subsequence;
															#line 1204 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.mutation = mutation;
															#line 1205 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				mutations.push_back_deep(mutations.arena(), vm);
															#line 1207 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->bufferOffset += mutationTotalSize;
															#line 6777 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1210 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->bufferOffset < size && endOfBlock(start.get(), self->bufferOffset))
															#line 6781 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1212 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int remain = self->BLOCK_SIZE - (self->bufferOffset % self->BLOCK_SIZE);
															#line 1213 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->bufferOffset += remain;
															#line 6787 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (foundNewVersion)
															#line 6791 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
				break;
			}
		}
															#line 1219 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState(); static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->destroy(); return 0; }
															#line 6798 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
		this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1161 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::shared_ptr<char[]> start = self->twobuffer->peek();
															#line 1162 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		int size = self->twobuffer->getBufferSize();
															#line 1163 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool foundNewVersion = false;
															#line 1164 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for(;self->bufferOffset < size;) {
															#line 1165 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			for(;self->bufferOffset < size && !endOfBlock(start.get(), self->bufferOffset);) {
															#line 1167 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->removeBlockHeader();
															#line 1172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				Version version;
															#line 1173 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1174 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				version = bigEndian64(version);
															#line 1175 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (version != firstVersion)
															#line 6828 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				{
															#line 1176 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					foundNewVersion = true;
															#line 6832 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					break;
				}
															#line 1180 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int32_t subsequence;
															#line 1181 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy(&subsequence, start.get() + self->bufferOffset + sizeof(Version), sizeof(int32_t));
															#line 1182 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				subsequence = bigEndian32(subsequence);
															#line 1184 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int32_t mutationSize;
															#line 1185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy( &mutationSize, start.get() + self->bufferOffset + sizeof(Version) + sizeof(int32_t), sizeof(int32_t));
															#line 1187 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				mutationSize = bigEndian32(mutationSize);
															#line 1190 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				size_t mutationTotalSize = self->mutationHeaderBytes + mutationSize;
															#line 1191 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ASSERT(self->bufferOffset + mutationTotalSize <= size);
															#line 1193 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				Standalone<StringRef> mutationData = makeString(mutationSize);
															#line 1194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy( mutateString(mutationData), start.get() + self->bufferOffset + self->mutationHeaderBytes, mutationSize);
															#line 1197 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ArenaReader reader(mutationData.arena(), mutationData, AssumeVersion(g_network->protocolVersion()));
															#line 1198 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				MutationRef mutation;
															#line 1199 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				reader >> mutation;
															#line 1201 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				VersionedMutation vm;
															#line 1202 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.version = version;
															#line 1203 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.subsequence = subsequence;
															#line 1204 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.mutation = mutation;
															#line 1205 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				mutations.push_back_deep(mutations.arena(), vm);
															#line 1207 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->bufferOffset += mutationTotalSize;
															#line 6873 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1210 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->bufferOffset < size && endOfBlock(start.get(), self->bufferOffset))
															#line 6877 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1212 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int remain = self->BLOCK_SIZE - (self->bufferOffset % self->BLOCK_SIZE);
															#line 1213 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->bufferOffset += remain;
															#line 6883 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (foundNewVersion)
															#line 6887 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
				break;
			}
		}
															#line 1219 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState(); static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->destroy(); return 0; }
															#line 6894 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
		this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consumeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consumeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consumeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeData", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1156 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorTwoBuffers> self;
															#line 1156 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version firstVersion;
															#line 1159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<VersionedMutation>> mutations;
															#line 6983 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via consumeData()
															#line 1156 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_ConsumeDataActor final : public Actor<Standalone<VectorRef<VersionedMutation>>>, public ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >, public FastAllocated<PartitionedLogIteratorTwoBuffers_ConsumeDataActor>, public PartitionedLogIteratorTwoBuffers_ConsumeDataActorState<PartitionedLogIteratorTwoBuffers_ConsumeDataActor> {
															#line 6988 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorTwoBuffers_ConsumeDataActor>::operator new;
	using FastAllocated<PartitionedLogIteratorTwoBuffers_ConsumeDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12155939984780215040UL, 9491452762824229376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<VersionedMutation>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >;
															#line 1156 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_ConsumeDataActor(Reference<PartitionedLogIteratorTwoBuffers> const& self,Version const& firstVersion) 
															#line 7005 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<VersionedMutation>>>(),
		   PartitionedLogIteratorTwoBuffers_ConsumeDataActorState<PartitionedLogIteratorTwoBuffers_ConsumeDataActor>(self, firstVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consumeData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6208903078462509824UL, 13390363306797634560UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consumeData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consumeData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1156 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorTwoBuffers::consumeData( Reference<PartitionedLogIteratorTwoBuffers> const& self, Version const& firstVersion ) {
															#line 1156 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<VersionedMutation>>>(new PartitionedLogIteratorTwoBuffers_ConsumeDataActor(self, firstVersion));
															#line 7037 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1221 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

void PartitionedLogIteratorTwoBuffers::removeBlockHeader() {
	if (bufferOffset % BLOCK_SIZE == 0) {
		bufferOffset += sizeof(uint32_t);
	}
}

PartitionedLogIteratorTwoBuffers::PartitionedLogIteratorTwoBuffers(Reference<IBackupContainer> _bc,
                                                                   int _tag,
                                                                   std::vector<RestoreConfig::RestoreFile> _files,
                                                                   std::vector<Version> _endVersions)
  : bc(_bc), tag(_tag), files(std::move(_files)), endVersions(_endVersions), bufferOffset(0) {
	int bufferCapacity = BATCH_READ_BLOCK_COUNT * BLOCK_SIZE;
	twobuffer = makeReference<TwoBuffers>(bufferCapacity, _bc, files, tag);
}

bool PartitionedLogIteratorTwoBuffers::hasNext() {
	return twobuffer->hasNext();
}

Future<Version> PartitionedLogIteratorTwoBuffers::peekNextVersion() {
	return peekNextVersion(Reference<PartitionedLogIteratorTwoBuffers>::addRef(this));
}
															#line 7064 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via peekNextVersion()
															#line 1244 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>
															#line 1244 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState {
															#line 7070 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1244 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState(Reference<PartitionedLogIteratorTwoBuffers> const& self) 
															#line 1244 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1244 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1247 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   start(),
															#line 1248 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   version(),
															#line 1249 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   fileIndex()
															#line 7083 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("peekNextVersion", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState() 
	{
		fdb_probe_actor_destroy("peekNextVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 7098 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1251 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->SAV<Version>::futures) { (void)(Version(0)); this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState(); static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->destroy(); return 0; }
															#line 7102 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->SAV< Version >::value()) Version(Version(0));
				this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState();
				static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1253 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->twobuffer->ready();
															#line 1253 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7112 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state = 1;
															#line 1253 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*>(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)));
															#line 7117 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1254 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		start = self->twobuffer->peek();
															#line 1255 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1256 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1257 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileIndex = self->twobuffer->getFileIndex();
															#line 1259 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 7150 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1254 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		start = self->twobuffer->peek();
															#line 1255 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1256 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1257 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileIndex = self->twobuffer->getFileIndex();
															#line 1259 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 7169 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState(); static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->destroy(); return 0; }
															#line 7253 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1259 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(fileIndex < self->endVersions.size() - 1 && version >= self->endVersions[fileIndex]))
															#line 7272 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1260 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("RestoreLogFilesFoundOverlapAndSkip") .detail("Version", version) .detail("FileIndex", fileIndex) .log();
															#line 1265 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->twobuffer->reset();
															#line 1266 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferOffset = 0;
															#line 1267 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->twobuffer->setFileIndex(fileIndex + 1);
															#line 1268 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->twobuffer->ready();
															#line 1268 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7288 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state = 2;
															#line 1268 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*>(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)));
															#line 7293 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1269 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		start = self->twobuffer->peek();
															#line 1270 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1271 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1272 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1273 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileIndex = self->twobuffer->getFileIndex();
															#line 7323 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1269 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		start = self->twobuffer->peek();
															#line 1270 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1271 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1272 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1273 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileIndex = self->twobuffer->getFileIndex();
															#line 7340 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1244 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorTwoBuffers> self;
															#line 1247 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::shared_ptr<char[]> start;
															#line 1248 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version version;
															#line 1249 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int fileIndex;
															#line 7428 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via peekNextVersion()
															#line 1244 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_PeekNextVersionActor final : public Actor<Version>, public ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >, public ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >, public FastAllocated<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>, public PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor> {
															#line 7433 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>::operator new;
	using FastAllocated<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14714186113775217920UL, 9012468205219612416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >;
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >;
															#line 1244 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_PeekNextVersionActor(Reference<PartitionedLogIteratorTwoBuffers> const& self) 
															#line 7451 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(868233047335415808UL, 8756626667062018304UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("peekNextVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1244 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Version> PartitionedLogIteratorTwoBuffers::peekNextVersion( Reference<PartitionedLogIteratorTwoBuffers> const& self ) {
															#line 1244 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Version>(new PartitionedLogIteratorTwoBuffers_PeekNextVersionActor(self));
															#line 7484 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1277 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 7489 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getNext()
															#line 1278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorTwoBuffers_GetNextActor>
															#line 1278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_GetNextActorState {
															#line 7495 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_GetNextActorState(Reference<PartitionedLogIteratorTwoBuffers> const& self) 
															#line 1278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1280 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   mutations()
															#line 7504 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getNext", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorTwoBuffers_GetNextActorState() 
	{
		fdb_probe_actor_destroy("getNext", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1281 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 7519 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1282 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarn, "IteratorExhausted").log();
															#line 1283 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorTwoBuffers_GetNextActorState(); static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->destroy(); return 0; }
															#line 7525 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
				this->~PartitionedLogIteratorTwoBuffers_GetNextActorState();
				static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1285 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Version> __when_expr_0 = self->peekNextVersion();
															#line 1285 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7535 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 1;
															#line 1285 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 7540 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorTwoBuffers_GetNextActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1287 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedMutation>>> __when_expr_1 = self->consumeData(firstVersion);
															#line 1287 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7565 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 2;
															#line 1287 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 7570 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Version const& __firstVersion,int loopDepth) 
	{
															#line 1285 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		firstVersion = __firstVersion;
															#line 7579 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __firstVersion,int loopDepth) 
	{
		firstVersion = std::move(__firstVersion);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Standalone<VectorRef<VersionedMutation>> const& firstBatch,int loopDepth) 
	{
															#line 1288 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		mutations = firstBatch;
															#line 1291 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 7660 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Standalone<VectorRef<VersionedMutation>> && firstBatch,int loopDepth) 
	{
															#line 1288 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		mutations = firstBatch;
															#line 1291 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 7671 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<VersionedMutation>> const& firstBatch,int loopDepth) 
	{
		loopDepth = a_body1cont3(firstBatch, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<VersionedMutation>> && firstBatch,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(firstBatch), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*,Standalone<VectorRef<VersionedMutation>> const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*,Standalone<VectorRef<VersionedMutation>> && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1311 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorTwoBuffers_GetNextActorState(); static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->destroy(); return 0; }
															#line 7755 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
		this->~PartitionedLogIteratorTwoBuffers_GetNextActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 1291 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(self->bufferOffset >= self->twobuffer->getBufferSize()))
															#line 7774 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1292 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->twobuffer->discardAndSwap();
															#line 1293 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferOffset = 0;
															#line 1296 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->twobuffer->hasNext())
															#line 7784 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Version> __when_expr_2 = self->peekNextVersion();
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7790 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 3;
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 7795 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Version const& nextVersion,int loopDepth) 
	{
															#line 1300 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (nextVersion != firstVersion)
															#line 7828 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1303 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedMutation>>> __when_expr_3 = self->consumeData(firstVersion);
															#line 1303 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7836 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 4;
															#line 1303 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 7841 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Version && nextVersion,int loopDepth) 
	{
															#line 1300 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (nextVersion != firstVersion)
															#line 7850 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1303 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedMutation>>> __when_expr_3 = self->consumeData(firstVersion);
															#line 1303 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7858 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 4;
															#line 1303 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 7863 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Version const& nextVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(nextVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Version && nextVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(std::move(nextVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3loopBody1cont4(Standalone<VectorRef<VersionedMutation>> const& batch,int loopDepth) 
	{
															#line 1304 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const VersionedMutation& vm : batch ) {
															#line 1305 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			mutations.push_back_deep(mutations.arena(), vm);
															#line 7949 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont4(Standalone<VectorRef<VersionedMutation>> && batch,int loopDepth) 
	{
															#line 1304 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const VersionedMutation& vm : batch ) {
															#line 1305 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			mutations.push_back_deep(mutations.arena(), vm);
															#line 7961 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3when1(Standalone<VectorRef<VersionedMutation>> const& batch,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont4(batch, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3when1(Standalone<VectorRef<VersionedMutation>> && batch,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont4(std::move(batch), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*,Standalone<VectorRef<VersionedMutation>> const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*,Standalone<VectorRef<VersionedMutation>> && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorTwoBuffers> self;
															#line 1280 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<VersionedMutation>> mutations;
															#line 1285 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version firstVersion;
															#line 8048 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getNext()
															#line 1278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_GetNextActor final : public Actor<Standalone<VectorRef<VersionedMutation>>>, public ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >, public ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >, public ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >, public ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >, public FastAllocated<PartitionedLogIteratorTwoBuffers_GetNextActor>, public PartitionedLogIteratorTwoBuffers_GetNextActorState<PartitionedLogIteratorTwoBuffers_GetNextActor> {
															#line 8053 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorTwoBuffers_GetNextActor>::operator new;
	using FastAllocated<PartitionedLogIteratorTwoBuffers_GetNextActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17418726896049259776UL, 4715211551062859520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<VersionedMutation>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >;
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >;
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >;
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >;
															#line 1278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_GetNextActor(Reference<PartitionedLogIteratorTwoBuffers> const& self) 
															#line 8073 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<VersionedMutation>>>(),
		   PartitionedLogIteratorTwoBuffers_GetNextActorState<PartitionedLogIteratorTwoBuffers_GetNextActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10518556646101966592UL, 11765083271327665664UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNext");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorTwoBuffers::getNext( Reference<PartitionedLogIteratorTwoBuffers> const& self ) {
															#line 1278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<VersionedMutation>>>(new PartitionedLogIteratorTwoBuffers_GetNextActor(self));
															#line 8108 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1313 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorTwoBuffers::getNext() {
	return getNext(Reference<PartitionedLogIteratorTwoBuffers>::addRef(this));
}

FileBackupAgent::FileBackupAgent()
  : subspace(Subspace(fileBackupPrefixRange.begin))
    // The other subspaces have logUID -> value
    ,
    config(subspace.get(BackupAgentBase::keyConfig)), lastRestorable(subspace.get(FileBackupAgent::keyLastRestorable)),
    taskBucket(new TaskBucket(subspace.get(BackupAgentBase::keyTasks),
                              AccessSystemKeys::True,
                              PriorityBatch::False,
                              LockAware::True)),
    futureBucket(new FutureBucket(subspace.get(BackupAgentBase::keyFutures), AccessSystemKeys::True, LockAware::True)) {
}

namespace fileBackup {

// Return a block of contiguous padding bytes, growing if needed.
Value makePadding(int size) {
	static Value pad;
	if (pad.size() < size) {
		pad = makeString(size);
		memset(mutateString(pad), '\xff', pad.size());
	}

	return pad.substr(0, size);
}

struct IRangeFileWriter {
public:
	virtual Future<Void> padEnd(bool final) = 0;

	virtual Future<Void> writeKV(Key k, Value v) = 0;

	virtual Future<Void> writeKey(Key k) = 0;

	virtual Future<Void> finish() = 0;

	virtual ~IRangeFileWriter() {}
};

struct SnapshotFileBackupEncryptionKeys {
	Reference<BlobCipherKey> textCipherKey;
	Optional<Reference<BlobCipherKey>> headerCipherKey;
	StringRef ivRef;
};

// File Format handlers.
// Both Range and Log formats are designed to be readable starting at any BACKUP_RANGEFILE_BLOCK_SIZE boundary
// so they can be read in parallel.
//
// Writer instances must be kept alive while any member actors are in progress.
//
// EncryptedRangeFileWriter must be used as follows:
//   1 - writeKey(key) the queried key range begin
//   2 - writeKV(k, v) each kv pair to restore
//   3 - writeKey(key) the queried key range end
//   4 - finish()
//
// EncryptedRangeFileWriter will insert the required padding, header, and extra
// end/begin keys around the 1MB boundaries as needed.

struct EncryptedRangeFileWriter : public IRangeFileWriter {
	EncryptedRangeFileWriter(Database cx,
	                         Arena* arena,
	                         EncryptionAtRestMode encryptMode,
	                         Reference<IBackupFile> file = Reference<IBackupFile>(),
	                         int blockSize = 0)
	  : cx(cx), arena(arena), file(file), encryptMode(encryptMode), blockSize(blockSize), blockEnd(0),
	    fileVersion(BACKUP_AGENT_ENCRYPTED_SNAPSHOT_FILE_VERSION) {
		buffer = makeString(blockSize);
		wPtr = mutateString(buffer);
	}

																#line 8188 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via decryptImpl()
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class DecryptImplActor>
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecryptImplActorState {
															#line 8194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecryptImplActorState(Database const& cx,BlobCipherEncryptHeaderRef const& header,const uint8_t* const& dataP,int64_t const& dataLen,Arena* const& arena) 
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : cx(cx),
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   header(header),
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   dataP(dataP),
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   dataLen(dataLen),
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   arena(arena)
															#line 8209 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("decryptImpl", reinterpret_cast<unsigned long>(this));

	}
	~DecryptImplActorState() 
	{
		fdb_probe_actor_destroy("decryptImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1394 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			Reference<AsyncVar<ClientDBInfo> const> dbInfo = cx->clientInfo;
															#line 1395 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			headerRef = header;
															#line 1396 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<TextAndHeaderCipherKeys> __when_expr_0 = GetEncryptCipherKeys<ClientDBInfo>::getEncryptCipherKeys(dbInfo, headerRef, BlobCipherMetrics::RESTORE);
															#line 1396 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<DecryptImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8230 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DecryptImplActor*>(this)->actor_wait_state = 1;
															#line 1396 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >*>(static_cast<DecryptImplActor*>(this)));
															#line 8235 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DecryptImplActorState();
		static_cast<DecryptImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TextAndHeaderCipherKeys const& cipherKeys,int loopDepth) 
	{
															#line 1398 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		EncryptHeaderCipherDetails cipherDetails = headerRef.getCipherDetails();
															#line 1399 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		cipherDetails.textCipherDetails.validateCipherDetailsWithCipherKey(cipherKeys.cipherTextKey);
															#line 1400 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (cipherDetails.headerCipherDetails.present())
															#line 8262 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1401 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			cipherDetails.headerCipherDetails.get().validateCipherDetailsWithCipherKey(cipherKeys.cipherHeaderKey);
															#line 8266 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		DecryptBlobCipherAes256Ctr decryptor( cipherKeys.cipherTextKey, cipherKeys.cipherHeaderKey, headerRef.getIV(), BlobCipherMetrics::RESTORE);
															#line 1405 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<DecryptImplActor*>(this)->SAV<StringRef>::futures) { (void)(decryptor.decrypt(dataP, dataLen, headerRef, *arena)); this->~DecryptImplActorState(); static_cast<DecryptImplActor*>(this)->destroy(); return 0; }
															#line 8272 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<DecryptImplActor*>(this)->SAV< StringRef >::value()) StringRef(decryptor.decrypt(dataP, dataLen, headerRef, *arena));
		this->~DecryptImplActorState();
		static_cast<DecryptImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(TextAndHeaderCipherKeys && cipherKeys,int loopDepth) 
	{
															#line 1398 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		EncryptHeaderCipherDetails cipherDetails = headerRef.getCipherDetails();
															#line 1399 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		cipherDetails.textCipherDetails.validateCipherDetailsWithCipherKey(cipherKeys.cipherTextKey);
															#line 1400 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (cipherDetails.headerCipherDetails.present())
															#line 8288 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1401 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			cipherDetails.headerCipherDetails.get().validateCipherDetailsWithCipherKey(cipherKeys.cipherHeaderKey);
															#line 8292 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		DecryptBlobCipherAes256Ctr decryptor( cipherKeys.cipherTextKey, cipherKeys.cipherHeaderKey, headerRef.getIV(), BlobCipherMetrics::RESTORE);
															#line 1405 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<DecryptImplActor*>(this)->SAV<StringRef>::futures) { (void)(decryptor.decrypt(dataP, dataLen, headerRef, *arena)); this->~DecryptImplActorState(); static_cast<DecryptImplActor*>(this)->destroy(); return 0; }
															#line 8298 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<DecryptImplActor*>(this)->SAV< StringRef >::value()) StringRef(decryptor.decrypt(dataP, dataLen, headerRef, *arena));
		this->~DecryptImplActorState();
		static_cast<DecryptImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TextAndHeaderCipherKeys const& cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(cipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TextAndHeaderCipherKeys && cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DecryptImplActor*>(this)->actor_wait_state > 0) static_cast<DecryptImplActor*>(this)->actor_wait_state = 0;
		static_cast<DecryptImplActor*>(this)->ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >::remove();

	}
	void a_callback_fire(ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys const& value) 
	{
		fdb_probe_actor_enter("decryptImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecryptImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decryptImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys && value) 
	{
		fdb_probe_actor_enter("decryptImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecryptImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decryptImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >*,Error err) 
	{
		fdb_probe_actor_enter("decryptImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecryptImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decryptImpl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BlobCipherEncryptHeaderRef header;
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	const uint8_t* dataP;
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t dataLen;
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Arena* arena;
															#line 1395 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BlobCipherEncryptHeaderRef headerRef;
															#line 8393 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via decryptImpl()
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecryptImplActor final : public Actor<StringRef>, public ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >, public FastAllocated<DecryptImplActor>, public DecryptImplActorState<DecryptImplActor> {
															#line 8398 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<DecryptImplActor>::operator new;
	using FastAllocated<DecryptImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(429133704329870848UL, 11749631675347282944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<StringRef>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >;
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecryptImplActor(Database const& cx,BlobCipherEncryptHeaderRef const& header,const uint8_t* const& dataP,int64_t const& dataLen,Arena* const& arena) 
															#line 8415 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<StringRef>(),
		   DecryptImplActorState<DecryptImplActor>(cx, header, dataP, dataLen, arena),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("decryptImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4960209422272274432UL, 16507631506561169664UL);
		ActorExecutionContextHelper __helper(static_cast<DecryptImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("decryptImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("decryptImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<StringRef> decryptImpl( Database const& cx, BlobCipherEncryptHeaderRef const& header, const uint8_t* const& dataP, int64_t const& dataLen, Arena* const& arena ) {
															#line 1389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<StringRef>(new DecryptImplActor(cx, header, dataP, dataLen, arena));
															#line 8447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1407 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	static Future<StringRef> decrypt(Database cx,
	                                 BlobCipherEncryptHeaderRef header,
	                                 const uint8_t* dataP,
	                                 int64_t dataLen,
	                                 Arena* arena) {
		return decryptImpl(cx, header, dataP, dataLen, arena);
	}

																#line 8460 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via refreshKey()
															#line 1416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class RefreshKeyActor>
															#line 1416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RefreshKeyActorState {
															#line 8466 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RefreshKeyActorState(EncryptedRangeFileWriter* const& self,EncryptCipherDomainId const& domainId) 
															#line 1416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   domainId(domainId)
															#line 8475 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("refreshKey", reinterpret_cast<unsigned long>(this));

	}
	~RefreshKeyActorState() 
	{
		fdb_probe_actor_destroy("refreshKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1418 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			Reference<AsyncVar<ClientDBInfo> const> dbInfo = self->cx->clientInfo;
															#line 1419 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<TextAndHeaderCipherKeys> __when_expr_0 = GetEncryptCipherKeys<ClientDBInfo>::getLatestEncryptCipherKeysForDomain( dbInfo, domainId, BlobCipherMetrics::BACKUP);
															#line 1419 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<RefreshKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8494 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RefreshKeyActor*>(this)->actor_wait_state = 1;
															#line 1419 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >*>(static_cast<RefreshKeyActor*>(this)));
															#line 8499 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RefreshKeyActorState();
		static_cast<RefreshKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TextAndHeaderCipherKeys const& cipherKeys,int loopDepth) 
	{
															#line 1422 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RefreshKeyActor*>(this)->SAV<Reference<BlobCipherKey>>::futures) { (void)(cipherKeys.cipherTextKey); this->~RefreshKeyActorState(); static_cast<RefreshKeyActor*>(this)->destroy(); return 0; }
															#line 8522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<RefreshKeyActor*>(this)->SAV< Reference<BlobCipherKey> >::value()) Reference<BlobCipherKey>(cipherKeys.cipherTextKey);
		this->~RefreshKeyActorState();
		static_cast<RefreshKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(TextAndHeaderCipherKeys && cipherKeys,int loopDepth) 
	{
															#line 1422 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RefreshKeyActor*>(this)->SAV<Reference<BlobCipherKey>>::futures) { (void)(cipherKeys.cipherTextKey); this->~RefreshKeyActorState(); static_cast<RefreshKeyActor*>(this)->destroy(); return 0; }
															#line 8534 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<RefreshKeyActor*>(this)->SAV< Reference<BlobCipherKey> >::value()) Reference<BlobCipherKey>(cipherKeys.cipherTextKey);
		this->~RefreshKeyActorState();
		static_cast<RefreshKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TextAndHeaderCipherKeys const& cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(cipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TextAndHeaderCipherKeys && cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RefreshKeyActor*>(this)->actor_wait_state > 0) static_cast<RefreshKeyActor*>(this)->actor_wait_state = 0;
		static_cast<RefreshKeyActor*>(this)->ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >::remove();

	}
	void a_callback_fire(ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys const& value) 
	{
		fdb_probe_actor_enter("refreshKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys && value) 
	{
		fdb_probe_actor_enter("refreshKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >*,Error err) 
	{
		fdb_probe_actor_enter("refreshKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshKey", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptCipherDomainId domainId;
															#line 8621 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via refreshKey()
															#line 1416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RefreshKeyActor final : public Actor<Reference<BlobCipherKey>>, public ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >, public FastAllocated<RefreshKeyActor>, public RefreshKeyActorState<RefreshKeyActor> {
															#line 8626 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<RefreshKeyActor>::operator new;
	using FastAllocated<RefreshKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7638988829696158208UL, 8980862994537069056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<BlobCipherKey>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >;
															#line 1416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RefreshKeyActor(EncryptedRangeFileWriter* const& self,EncryptCipherDomainId const& domainId) 
															#line 8643 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Reference<BlobCipherKey>>(),
		   RefreshKeyActorState<RefreshKeyActor>(self, domainId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("refreshKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2600401531761827840UL, 1234727541164897536UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("refreshKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("refreshKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Reference<BlobCipherKey>> refreshKey( EncryptedRangeFileWriter* const& self, EncryptCipherDomainId const& domainId ) {
															#line 1416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Reference<BlobCipherKey>>(new RefreshKeyActor(self, domainId));
															#line 8675 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1424 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 8680 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via encrypt()
															#line 1425 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class EncryptActor>
															#line 1425 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class EncryptActorState {
															#line 8686 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1425 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptActorState(EncryptedRangeFileWriter* const& self) 
															#line 1425 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1425 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 8693 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("encrypt", reinterpret_cast<unsigned long>(this));

	}
	~EncryptActorState() 
	{
		fdb_probe_actor_destroy("encrypt", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1427 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(self->cipherKeys.headerCipherKey.present() && self->cipherKeys.headerCipherKey.get().isValid() && self->cipherKeys.textCipherKey.isValid());
															#line 1430 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->cipherKeys.headerCipherKey.get()->isExpired() || self->cipherKeys.headerCipherKey.get()->needsRefresh())
															#line 8710 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1432 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Reference<BlobCipherKey>> __when_expr_0 = refreshKey(self, self->cipherKeys.headerCipherKey.get()->getDomainId());
															#line 1432 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<EncryptActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8716 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<EncryptActor*>(this)->actor_wait_state = 1;
															#line 1432 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >*>(static_cast<EncryptActor*>(this)));
															#line 8721 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EncryptActorState();
		static_cast<EncryptActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1436 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->cipherKeys.textCipherKey->isExpired() || self->cipherKeys.textCipherKey->needsRefresh())
															#line 8749 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1437 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Reference<BlobCipherKey>> __when_expr_1 = refreshKey(self, self->cipherKeys.textCipherKey->getDomainId());
															#line 1437 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<EncryptActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8755 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<EncryptActor*>(this)->actor_wait_state = 2;
															#line 1437 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >*>(static_cast<EncryptActor*>(this)));
															#line 8760 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Reference<BlobCipherKey> const& cipherKey,int loopDepth) 
	{
															#line 1434 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.headerCipherKey = cipherKey;
															#line 8774 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Reference<BlobCipherKey> && cipherKey,int loopDepth) 
	{
															#line 1434 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.headerCipherKey = cipherKey;
															#line 8783 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<BlobCipherKey> const& cipherKey,int loopDepth) 
	{
		loopDepth = a_body1cont2(cipherKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<BlobCipherKey> && cipherKey,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(cipherKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EncryptActor*>(this)->actor_wait_state > 0) static_cast<EncryptActor*>(this)->actor_wait_state = 0;
		static_cast<EncryptActor*>(this)->ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >::remove();

	}
	void a_callback_fire(ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >*,Reference<BlobCipherKey> const& value) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >*,Reference<BlobCipherKey> && value) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >*,Error err) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1440 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		EncryptBlobCipherAes265Ctr encryptor( self->cipherKeys.textCipherKey, self->cipherKeys.headerCipherKey, self->cipherKeys.ivRef.begin(), AES_256_IV_LENGTH, getEncryptAuthTokenMode(EncryptAuthTokenMode::ENCRYPT_HEADER_AUTH_TOKEN_MODE_SINGLE), BlobCipherMetrics::BACKUP);
															#line 1447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		int64_t payloadSize = self->wPtr - self->dataPayloadStart;
															#line 1448 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StringRef encryptedData;
															#line 1449 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		BlobCipherEncryptHeaderRef headerRef;
															#line 1450 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		encryptedData = encryptor.encrypt(self->dataPayloadStart, payloadSize, &headerRef, *self->arena);
															#line 1451 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Standalone<StringRef> serialized = BlobCipherEncryptHeaderRef::toStringRef(headerRef);
															#line 1452 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->arena->dependsOn(serialized.arena());
															#line 1453 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ASSERT(serialized.size() == self->encryptHeader.size());
															#line 1454 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(mutateString(self->encryptHeader), serialized.begin(), self->encryptHeader.size());
															#line 1457 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(self->dataPayloadStart, encryptedData.begin(), payloadSize);
															#line 1458 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<EncryptActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EncryptActorState(); static_cast<EncryptActor*>(this)->destroy(); return 0; }
															#line 8887 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<EncryptActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~EncryptActorState();
		static_cast<EncryptActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Reference<BlobCipherKey> const& cipherKey,int loopDepth) 
	{
															#line 1438 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.textCipherKey = cipherKey;
															#line 8899 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Reference<BlobCipherKey> && cipherKey,int loopDepth) 
	{
															#line 1438 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.textCipherKey = cipherKey;
															#line 8908 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<BlobCipherKey> const& cipherKey,int loopDepth) 
	{
		loopDepth = a_body1cont5(cipherKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<BlobCipherKey> && cipherKey,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(cipherKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<EncryptActor*>(this)->actor_wait_state > 0) static_cast<EncryptActor*>(this)->actor_wait_state = 0;
		static_cast<EncryptActor*>(this)->ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >::remove();

	}
	void a_callback_fire(ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >*,Reference<BlobCipherKey> const& value) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >*,Reference<BlobCipherKey> && value) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >*,Error err) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1425 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 8990 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via encrypt()
															#line 1425 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class EncryptActor final : public Actor<Void>, public ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >, public ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >, public FastAllocated<EncryptActor>, public EncryptActorState<EncryptActor> {
															#line 8995 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<EncryptActor>::operator new;
	using FastAllocated<EncryptActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2207258634380316928UL, 5850199883007303936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >;
friend struct ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >;
															#line 1425 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptActor(EncryptedRangeFileWriter* const& self) 
															#line 9013 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   EncryptActorState<EncryptActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11460608645555408640UL, 117169993392551936UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("encrypt");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1425 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> encrypt( EncryptedRangeFileWriter* const& self ) {
															#line 1425 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new EncryptActor(self));
															#line 9046 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1460 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 9051 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via updateEncryptionKeysCtx()
															#line 1461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class UpdateEncryptionKeysCtxActor>
															#line 1461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class UpdateEncryptionKeysCtxActorState {
															#line 9057 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UpdateEncryptionKeysCtxActorState(EncryptedRangeFileWriter* const& self,KeyRef const& key) 
															#line 1461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   key(key)
															#line 9066 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this));

	}
	~UpdateEncryptionKeysCtxActorState() 
	{
		fdb_probe_actor_destroy("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1462 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<EncryptCipherDomainId> __when_expr_0 = getEncryptionDomainDetails(key, self->encryptMode);
															#line 1462 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9083 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state = 1;
															#line 1462 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >*>(static_cast<UpdateEncryptionKeysCtxActor*>(this)));
															#line 9088 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateEncryptionKeysCtxActorState();
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1463 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		dbInfo = self->cx->clientInfo;
															#line 1466 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<TextAndHeaderCipherKeys> __when_expr_1 = GetEncryptCipherKeys<ClientDBInfo>::getLatestEncryptCipherKeysForDomain( dbInfo, curDomainId, BlobCipherMetrics::BACKUP);
															#line 1466 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9115 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state = 2;
															#line 1466 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >*>(static_cast<UpdateEncryptionKeysCtxActor*>(this)));
															#line 9120 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(EncryptCipherDomainId const& __curDomainId,int loopDepth) 
	{
															#line 1462 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		curDomainId = __curDomainId;
															#line 9129 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(EncryptCipherDomainId && __curDomainId,int loopDepth) 
	{
		curDomainId = std::move(__curDomainId);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state > 0) static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >*,EncryptCipherDomainId const& value) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >*,EncryptCipherDomainId && value) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >*,Error err) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(TextAndHeaderCipherKeys const& textAndHeaderCipherKeys,int loopDepth) 
	{
															#line 1469 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.textCipherKey = textAndHeaderCipherKeys.cipherTextKey;
															#line 1470 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.headerCipherKey = textAndHeaderCipherKeys.cipherHeaderKey;
															#line 1473 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.ivRef = makeString(AES_256_IV_LENGTH, *self->arena);
															#line 1474 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		deterministicRandom()->randomBytes(mutateString(self->cipherKeys.ivRef), AES_256_IV_LENGTH);
															#line 1475 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<UpdateEncryptionKeysCtxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateEncryptionKeysCtxActorState(); static_cast<UpdateEncryptionKeysCtxActor*>(this)->destroy(); return 0; }
															#line 9216 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<UpdateEncryptionKeysCtxActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateEncryptionKeysCtxActorState();
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(TextAndHeaderCipherKeys && textAndHeaderCipherKeys,int loopDepth) 
	{
															#line 1469 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.textCipherKey = textAndHeaderCipherKeys.cipherTextKey;
															#line 1470 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.headerCipherKey = textAndHeaderCipherKeys.cipherHeaderKey;
															#line 1473 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.ivRef = makeString(AES_256_IV_LENGTH, *self->arena);
															#line 1474 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		deterministicRandom()->randomBytes(mutateString(self->cipherKeys.ivRef), AES_256_IV_LENGTH);
															#line 1475 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<UpdateEncryptionKeysCtxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateEncryptionKeysCtxActorState(); static_cast<UpdateEncryptionKeysCtxActor*>(this)->destroy(); return 0; }
															#line 9236 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<UpdateEncryptionKeysCtxActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateEncryptionKeysCtxActorState();
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(TextAndHeaderCipherKeys const& textAndHeaderCipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont2(textAndHeaderCipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(TextAndHeaderCipherKeys && textAndHeaderCipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(textAndHeaderCipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state > 0) static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys const& value) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys && value) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >*,Error err) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyRef key;
															#line 1462 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptCipherDomainId curDomainId;
															#line 1463 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<AsyncVar<ClientDBInfo> const> dbInfo;
															#line 9327 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateEncryptionKeysCtx()
															#line 1461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class UpdateEncryptionKeysCtxActor final : public Actor<Void>, public ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >, public ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >, public FastAllocated<UpdateEncryptionKeysCtxActor>, public UpdateEncryptionKeysCtxActorState<UpdateEncryptionKeysCtxActor> {
															#line 9332 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateEncryptionKeysCtxActor>::operator new;
	using FastAllocated<UpdateEncryptionKeysCtxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1969332735313159168UL, 8011063829490358784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >;
friend struct ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >;
															#line 1461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UpdateEncryptionKeysCtxActor(EncryptedRangeFileWriter* const& self,KeyRef const& key) 
															#line 9350 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateEncryptionKeysCtxActorState<UpdateEncryptionKeysCtxActor>(self, key),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2045108966394790400UL, 17453403112709583616UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateEncryptionKeysCtx");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> updateEncryptionKeysCtx( EncryptedRangeFileWriter* const& self, KeyRef const& key ) {
															#line 1461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new UpdateEncryptionKeysCtxActor(self, key));
															#line 9383 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1477 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// Returns the number of bytes that have been written to the buffer
	static int64_t currentBufferSize(EncryptedRangeFileWriter* self) { return self->wPtr - self->buffer.begin(); }

	static int64_t expectedFileSize(EncryptedRangeFileWriter* self) {
		// Return what has already been written to file plus the size of the current buffer
		// which indicates how many bytes the file will contain once the buffer is written
		return self->file->size() + currentBufferSize(self);
	}

	static void copyToBuffer(EncryptedRangeFileWriter* self, const void* src, size_t size) {
		if (size > 0) {
			std::memcpy(self->wPtr, src, size);
			self->wPtr += size;
			ASSERT(currentBufferSize(self) <= self->blockSize);
		}
	}

	static void appendStringRefWithLenToBuffer(EncryptedRangeFileWriter* self, StringRef* s) {
		// Append the string length followed by the string to the buffer
		uint32_t lenBuf = bigEndian32((uint32_t)s->size());
		copyToBuffer(self, &lenBuf, sizeof(lenBuf));
		copyToBuffer(self, s->begin(), s->size());
	}

	// TODO(gglass): this has been simplified for tenant removal.  Maybe it can be
	// simplified further.
	static Future<EncryptCipherDomainId> getEncryptionDomainDetails(KeyRef key, EncryptionAtRestMode encryptMode) {
		if (isSystemKey(key)) {
			return SYSTEM_KEYSPACE_ENCRYPT_DOMAIN_ID;
		}
		return FDB_DEFAULT_ENCRYPT_DOMAIN_ID;
	}

	// Handles the first block and internal blocks.  Ends current block if needed.
	// The final flag is used in simulation to pad the file's final block to a whole block size
																#line 9423 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via newBlock()
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class NewBlockActor>
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockActorState {
															#line 9429 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockActorState(EncryptedRangeFileWriter* const& self,int const& bytesNeeded,KeyRef const& lastKey,bool const& writeValue,bool const& final = false) 
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   bytesNeeded(bytesNeeded),
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   lastKey(lastKey),
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   writeValue(writeValue),
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   final(final)
															#line 9444 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("newBlock", reinterpret_cast<unsigned long>(this));

	}
	~NewBlockActorState() 
	{
		fdb_probe_actor_destroy("newBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1519 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int bytesLeft = self->blockEnd - expectedFileSize(self);
															#line 1520 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(bytesLeft >= 0);
															#line 1521 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (bytesLeft > 0)
															#line 9463 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				paddingFFs = makePadding(bytesLeft);
															#line 1523 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				copyToBuffer(self, paddingFFs.begin(), bytesLeft);
															#line 9469 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1526 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (expectedFileSize(self) > 0)
															#line 9473 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1528 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ASSERT(currentBufferSize(self) == self->blockSize);
															#line 1529 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = encrypt(self);
															#line 1529 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<NewBlockActor*>(this)->actor_wait_state = 1;
															#line 1529 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 0, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 9486 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewBlockActorState();
		static_cast<NewBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1536 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (final)
															#line 9514 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1537 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 1538 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<NewBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockActorState(); static_cast<NewBlockActor*>(this)->destroy(); return 0; }
															#line 9520 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<NewBlockActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~NewBlockActorState();
			static_cast<NewBlockActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1542 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->blockEnd += self->blockSize;
															#line 1545 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		copyToBuffer(self, (uint8_t*)&self->fileVersion, sizeof(self->fileVersion));
															#line 1548 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		uint32_t headerSize = 0;
															#line 1549 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		EncryptAuthTokenMode authTokenMode = getEncryptAuthTokenMode(EncryptAuthTokenMode::ENCRYPT_HEADER_AUTH_TOKEN_MODE_SINGLE);
															#line 1551 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		EncryptAuthTokenAlgo authTokenAlgo = getAuthTokenAlgoFromMode(authTokenMode);
															#line 1552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		headerSize = BlobCipherEncryptHeaderRef::getHeaderSize(CLIENT_KNOBS->ENCRYPT_HEADER_FLAGS_VERSION, getEncryptCurrentAlgoHeaderVersion(authTokenMode, authTokenAlgo), ENCRYPT_CIPHER_MODE_AES_256_CTR, authTokenMode, authTokenAlgo);
															#line 1558 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ASSERT(headerSize > 0);
															#line 1560 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		copyToBuffer(self, (uint8_t*)&headerSize, sizeof(headerSize));
															#line 1562 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->encryptHeader = StringRef(self->wPtr, headerSize);
															#line 1563 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->wPtr += headerSize;
															#line 1564 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->dataPayloadStart = self->wPtr;
															#line 1567 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->blockEnd > self->blockSize)
															#line 9550 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1568 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			appendStringRefWithLenToBuffer(self, &lastKey);
															#line 1569 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			appendStringRefWithLenToBuffer(self, &self->lastKey);
															#line 1570 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (writeValue)
															#line 9558 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1571 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				appendStringRefWithLenToBuffer(self, &self->lastValue);
															#line 9562 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
		}
															#line 1576 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (expectedFileSize(self) + bytesNeeded > self->blockEnd)
															#line 9567 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1577 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_bad_block_size(), loopDepth);
															#line 9571 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1580 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<NewBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockActorState(); static_cast<NewBlockActor*>(this)->destroy(); return 0; }
															#line 9575 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<NewBlockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewBlockActorState();
		static_cast<NewBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1530 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append(self->buffer.begin(), self->blockSize);
															#line 1530 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9589 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<NewBlockActor*>(this)->actor_wait_state = 2;
															#line 1530 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 1, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 9594 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1530 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append(self->buffer.begin(), self->blockSize);
															#line 1530 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9605 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<NewBlockActor*>(this)->actor_wait_state = 2;
															#line 1530 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 1, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 9610 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewBlockActor*>(this)->actor_wait_state > 0) static_cast<NewBlockActor*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor*>(this)->ActorCallback< NewBlockActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewBlockActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1533 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->wPtr = mutateString(self->buffer);
															#line 9694 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1533 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->wPtr = mutateString(self->buffer);
															#line 9703 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<NewBlockActor*>(this)->actor_wait_state > 0) static_cast<NewBlockActor*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor*>(this)->ActorCallback< NewBlockActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< NewBlockActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesNeeded;
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyRef lastKey;
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool writeValue;
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool final;
															#line 1522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value paddingFFs;
															#line 9795 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via newBlock()
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockActor final : public Actor<Void>, public ActorCallback< NewBlockActor, 0, Void >, public ActorCallback< NewBlockActor, 1, Void >, public FastAllocated<NewBlockActor>, public NewBlockActorState<NewBlockActor> {
															#line 9800 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<NewBlockActor>::operator new;
	using FastAllocated<NewBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15012662219323920896UL, 17280174652609166080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewBlockActor, 0, Void >;
friend struct ActorCallback< NewBlockActor, 1, Void >;
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockActor(EncryptedRangeFileWriter* const& self,int const& bytesNeeded,KeyRef const& lastKey,bool const& writeValue,bool const& final = false) 
															#line 9818 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   NewBlockActorState<NewBlockActor>(self, bytesNeeded, lastKey, writeValue, final),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11473969930622856192UL, 2275173024393763072UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewBlockActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< NewBlockActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> newBlock( EncryptedRangeFileWriter* const& self, int const& bytesNeeded, KeyRef const& lastKey, bool const& writeValue, bool const& final = false ) {
															#line 1513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new NewBlockActor(self, bytesNeeded, lastKey, writeValue, final));
															#line 9851 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1582 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> padEnd(bool final) {
		if (expectedFileSize(this) > 0) {
			return newBlock(this, 0, StringRef(), true, final);
		}
		return Void();
	}

	// Ends the current block if necessary based on bytesNeeded.
																#line 9864 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via newBlockIfNeeded()
															#line 1591 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class NewBlockIfNeededActor>
															#line 1591 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockIfNeededActorState {
															#line 9870 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1591 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockIfNeededActorState(EncryptedRangeFileWriter* const& self,int const& bytesNeeded) 
															#line 1591 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1591 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1591 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   bytesNeeded(bytesNeeded)
															#line 9879 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("newBlockIfNeeded", reinterpret_cast<unsigned long>(this));

	}
	~NewBlockIfNeededActorState() 
	{
		fdb_probe_actor_destroy("newBlockIfNeeded", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1592 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (expectedFileSize(self) + bytesNeeded > self->blockEnd)
															#line 9894 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1593 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = newBlock(self, bytesNeeded, self->lastKey, true);
															#line 1593 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<NewBlockIfNeededActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9900 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<NewBlockIfNeededActor*>(this)->actor_wait_state = 1;
															#line 1593 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewBlockIfNeededActor, 0, Void >*>(static_cast<NewBlockIfNeededActor*>(this)));
															#line 9905 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewBlockIfNeededActorState();
		static_cast<NewBlockIfNeededActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1595 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<NewBlockIfNeededActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockIfNeededActorState(); static_cast<NewBlockIfNeededActor*>(this)->destroy(); return 0; }
															#line 9933 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<NewBlockIfNeededActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewBlockIfNeededActorState();
		static_cast<NewBlockIfNeededActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewBlockIfNeededActor*>(this)->actor_wait_state > 0) static_cast<NewBlockIfNeededActor*>(this)->actor_wait_state = 0;
		static_cast<NewBlockIfNeededActor*>(this)->ActorCallback< NewBlockIfNeededActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockIfNeededActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewBlockIfNeededActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewBlockIfNeededActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1591 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1591 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesNeeded;
															#line 10032 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via newBlockIfNeeded()
															#line 1591 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockIfNeededActor final : public Actor<Void>, public ActorCallback< NewBlockIfNeededActor, 0, Void >, public FastAllocated<NewBlockIfNeededActor>, public NewBlockIfNeededActorState<NewBlockIfNeededActor> {
															#line 10037 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<NewBlockIfNeededActor>::operator new;
	using FastAllocated<NewBlockIfNeededActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6008993330763531776UL, 5863371214734219776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewBlockIfNeededActor, 0, Void >;
															#line 1591 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockIfNeededActor(EncryptedRangeFileWriter* const& self,int const& bytesNeeded) 
															#line 10054 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   NewBlockIfNeededActorState<NewBlockIfNeededActor>(self, bytesNeeded),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2008971701599870208UL, 8353149633524734464UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newBlockIfNeeded");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewBlockIfNeededActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1591 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> newBlockIfNeeded( EncryptedRangeFileWriter* const& self, int const& bytesNeeded ) {
															#line 1591 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new NewBlockIfNeededActor(self, bytesNeeded));
															#line 10086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1597 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// Start a new block if needed, then write the key and value
																#line 10092 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via writeKV_impl()
															#line 1599 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKV_implActor>
															#line 1599 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActorState {
															#line 10098 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1599 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActorState(EncryptedRangeFileWriter* const& self,Key const& k,Value const& v) 
															#line 1599 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1599 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1599 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k),
															#line 1599 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   v(v)
															#line 10109 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKV_implActorState() 
	{
		fdb_probe_actor_destroy("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1600 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->cipherKeys.headerCipherKey.present() || !self->cipherKeys.headerCipherKey.get().isValid() || !self->cipherKeys.textCipherKey.isValid())
															#line 10124 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1602 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = updateEncryptionKeysCtx(self, k);
															#line 1602 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<WriteKV_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WriteKV_implActor*>(this)->actor_wait_state = 1;
															#line 1602 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor, 0, Void >*>(static_cast<WriteKV_implActor*>(this)));
															#line 10135 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKV_implActorState();
		static_cast<WriteKV_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1604 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		toWrite = sizeof(int32_t) + k.size() + sizeof(int32_t) + v.size();
															#line 1605 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = newBlockIfNeeded(self, toWrite);
															#line 1605 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10167 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKV_implActor*>(this)->actor_wait_state = 2;
															#line 1605 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor, 1, Void >*>(static_cast<WriteKV_implActor*>(this)));
															#line 10172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor*>(this)->ActorCallback< WriteKV_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1606 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &k);
															#line 1607 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &v);
															#line 1608 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1609 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastValue = v;
															#line 1610 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActorState(); static_cast<WriteKV_implActor*>(this)->destroy(); return 0; }
															#line 10276 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKV_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActorState();
		static_cast<WriteKV_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1606 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &k);
															#line 1607 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &v);
															#line 1608 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1609 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastValue = v;
															#line 1610 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActorState(); static_cast<WriteKV_implActor*>(this)->destroy(); return 0; }
															#line 10296 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKV_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActorState();
		static_cast<WriteKV_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor*>(this)->ActorCallback< WriteKV_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1599 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1599 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 1599 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value v;
															#line 1604 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int toWrite;
															#line 10387 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeKV_impl()
															#line 1599 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor final : public Actor<Void>, public ActorCallback< WriteKV_implActor, 0, Void >, public ActorCallback< WriteKV_implActor, 1, Void >, public FastAllocated<WriteKV_implActor>, public WriteKV_implActorState<WriteKV_implActor> {
															#line 10392 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteKV_implActor>::operator new;
	using FastAllocated<WriteKV_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3776153979873436928UL, 16509826448095816448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKV_implActor, 0, Void >;
friend struct ActorCallback< WriteKV_implActor, 1, Void >;
															#line 1599 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor(EncryptedRangeFileWriter* const& self,Key const& k,Value const& v) 
															#line 10410 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteKV_implActorState<WriteKV_implActor>(self, k, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12331643623674153728UL, 17746951694630343424UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKV_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKV_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKV_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1599 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKV_impl( EncryptedRangeFileWriter* const& self, Key const& k, Value const& v ) {
															#line 1599 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKV_implActor(self, k, v));
															#line 10443 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1612 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKV(Key k, Value v) { return writeKV_impl(this, k, v); }

	// Write begin key or end key.
																#line 10451 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via writeKey_impl()
															#line 1616 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKey_implActor>
															#line 1616 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKey_implActorState {
															#line 10457 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1616 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKey_implActorState(EncryptedRangeFileWriter* const& self,Key const& k) 
															#line 1616 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1616 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1616 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k)
															#line 10466 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeKey_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKey_implActorState() 
	{
		fdb_probe_actor_destroy("writeKey_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1618 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (k.size() > 0 && (!self->cipherKeys.headerCipherKey.present() || !self->cipherKeys.headerCipherKey.get().isValid() || !self->cipherKeys.textCipherKey.isValid()))
															#line 10481 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1621 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = updateEncryptionKeysCtx(self, k);
															#line 1621 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<WriteKey_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10487 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WriteKey_implActor*>(this)->actor_wait_state = 1;
															#line 1621 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor, 0, Void >*>(static_cast<WriteKey_implActor*>(this)));
															#line 10492 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKey_implActorState();
		static_cast<WriteKey_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1625 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		int toWrite = sizeof(uint32_t) + k.size();
															#line 1626 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = newBlockIfNeeded(self, toWrite);
															#line 1626 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKey_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10524 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKey_implActor*>(this)->actor_wait_state = 2;
															#line 1626 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor, 1, Void >*>(static_cast<WriteKey_implActor*>(this)));
															#line 10529 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKey_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKey_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKey_implActor*>(this)->ActorCallback< WriteKey_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKey_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1627 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &k);
															#line 1628 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1629 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKey_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKey_implActorState(); static_cast<WriteKey_implActor*>(this)->destroy(); return 0; }
															#line 10629 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKey_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKey_implActorState();
		static_cast<WriteKey_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1627 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &k);
															#line 1628 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1629 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKey_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKey_implActorState(); static_cast<WriteKey_implActor*>(this)->destroy(); return 0; }
															#line 10645 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKey_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKey_implActorState();
		static_cast<WriteKey_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKey_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKey_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKey_implActor*>(this)->ActorCallback< WriteKey_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKey_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1616 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1616 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 10732 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeKey_impl()
															#line 1616 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKey_implActor final : public Actor<Void>, public ActorCallback< WriteKey_implActor, 0, Void >, public ActorCallback< WriteKey_implActor, 1, Void >, public FastAllocated<WriteKey_implActor>, public WriteKey_implActorState<WriteKey_implActor> {
															#line 10737 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteKey_implActor>::operator new;
	using FastAllocated<WriteKey_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15311464797527691776UL, 9254082434552742656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKey_implActor, 0, Void >;
friend struct ActorCallback< WriteKey_implActor, 1, Void >;
															#line 1616 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKey_implActor(EncryptedRangeFileWriter* const& self,Key const& k) 
															#line 10755 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteKey_implActorState<WriteKey_implActor>(self, k),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(551483992183075584UL, 8902642963360461568UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKey_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKey_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKey_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1616 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKey_impl( EncryptedRangeFileWriter* const& self, Key const& k ) {
															#line 1616 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKey_implActor(self, k));
															#line 10788 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1631 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKey(Key k) { return writeKey_impl(this, k); }

																#line 10795 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via finish_impl()
															#line 1634 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class Finish_implActor>
															#line 1634 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class Finish_implActorState {
															#line 10801 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1634 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Finish_implActorState(EncryptedRangeFileWriter* const& self) 
															#line 1634 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1634 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 10808 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("finish_impl", reinterpret_cast<unsigned long>(this));

	}
	~Finish_implActorState() 
	{
		fdb_probe_actor_destroy("finish_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1636 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (currentBufferSize(self) > 0)
															#line 10823 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1637 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = encrypt(self);
															#line 1637 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<Finish_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10829 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<Finish_implActor*>(this)->actor_wait_state = 1;
															#line 1637 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Finish_implActor, 0, Void >*>(static_cast<Finish_implActor*>(this)));
															#line 10834 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Finish_implActorState();
		static_cast<Finish_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1640 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<Finish_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Finish_implActorState(); static_cast<Finish_implActor*>(this)->destroy(); return 0; }
															#line 10862 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<Finish_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Finish_implActorState();
		static_cast<Finish_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1638 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append(self->buffer.begin(), currentBufferSize(self));
															#line 1638 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<Finish_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Finish_implActor*>(this)->actor_wait_state = 2;
															#line 1638 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Finish_implActor, 1, Void >*>(static_cast<Finish_implActor*>(this)));
															#line 10881 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1638 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append(self->buffer.begin(), currentBufferSize(self));
															#line 1638 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<Finish_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10892 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Finish_implActor*>(this)->actor_wait_state = 2;
															#line 1638 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Finish_implActor, 1, Void >*>(static_cast<Finish_implActor*>(this)));
															#line 10897 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Finish_implActor*>(this)->actor_wait_state > 0) static_cast<Finish_implActor*>(this)->actor_wait_state = 0;
		static_cast<Finish_implActor*>(this)->ActorCallback< Finish_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Finish_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Finish_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Finish_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Finish_implActor*>(this)->actor_wait_state > 0) static_cast<Finish_implActor*>(this)->actor_wait_state = 0;
		static_cast<Finish_implActor*>(this)->ActorCallback< Finish_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Finish_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Finish_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Finish_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1634 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 11066 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via finish_impl()
															#line 1634 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class Finish_implActor final : public Actor<Void>, public ActorCallback< Finish_implActor, 0, Void >, public ActorCallback< Finish_implActor, 1, Void >, public FastAllocated<Finish_implActor>, public Finish_implActorState<Finish_implActor> {
															#line 11071 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<Finish_implActor>::operator new;
	using FastAllocated<Finish_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9567476634873698048UL, 7739102956787294976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Finish_implActor, 0, Void >;
friend struct ActorCallback< Finish_implActor, 1, Void >;
															#line 1634 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Finish_implActor(EncryptedRangeFileWriter* const& self) 
															#line 11089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   Finish_implActorState<Finish_implActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6941044748667588864UL, 17414012196556178688UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("finish_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Finish_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Finish_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1634 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> finish_impl( EncryptedRangeFileWriter* const& self ) {
															#line 1634 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new Finish_implActor(self));
															#line 11122 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1642 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> finish() { return finish_impl(this); }

	Database cx;
	Arena* arena;
	EncryptionAtRestMode encryptMode;
	Reference<IBackupFile> file;
	int blockSize;

private:
	Standalone<StringRef> buffer;
	uint8_t* wPtr;
	StringRef encryptHeader;
	uint8_t* dataPayloadStart;
	int64_t blockEnd;
	uint32_t fileVersion;
	Key lastKey;
	Key lastValue;
	SnapshotFileBackupEncryptionKeys cipherKeys;
};

// File Format handlers.
// Both Range and Log formats are designed to be readable starting at any BACKUP_RANGEFILE_BLOCK_SIZE boundary
// so they can be read in parallel.
//
// Writer instances must be kept alive while any member actors are in progress.
//
// RangeFileWriter must be used as follows:
//   1 - writeKey(key) the queried key range begin
//   2 - writeKV(k, v) each kv pair to restore
//   3 - writeKey(key) the queried key range end
//	 4 - finish()
//
// RangeFileWriter will insert the required padding, header, and extra
// end/begin keys around the 1MB boundaries as needed.
//
// Example:
//   The range a-z is queries and returns c-j which covers 3 blocks.
//   The client code writes keys in this sequence:
//             a c d e f g h i j z
//
//   H = header   P = padding   a...z = keys  v = value | = block boundary
//
//   Encoded file:  H a cv dv ev P | H e ev fv gv hv P | H h hv iv jv z
//   Decoded in blocks yields:
//           Block 1: range [a, e) with kv pairs cv, dv
//           Block 2: range [e, h) with kv pairs ev, fv, gv
//           Block 3: range [h, z) with kv pairs hv, iv, jv
//
//   NOTE: All blocks except for the final block will have one last
//   value which will not be used.  This isn't actually a waste since
//   if the next KV pair wouldn't fit within the block after the value
//   then the space after the final key to the next 1MB boundary would
//   just be padding anyway.
struct RangeFileWriter : public IRangeFileWriter {
	RangeFileWriter(Reference<IBackupFile> file = Reference<IBackupFile>(), int blockSize = 0)
	  : file(file), blockSize(blockSize), blockEnd(0), fileVersion(BACKUP_AGENT_SNAPSHOT_FILE_VERSION) {}

	// Handles the first block and internal blocks.  Ends current block if needed.
	// The final flag is used in simulation to pad the file's final block to a whole block size
																#line 11186 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via newBlock()
															#line 1702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class NewBlockActor1>
															#line 1702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockActor1State {
															#line 11192 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockActor1State(RangeFileWriter* const& self,int const& bytesNeeded,bool const& final = false) 
															#line 1702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   bytesNeeded(bytesNeeded),
															#line 1702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   final(final)
															#line 11203 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("newBlock", reinterpret_cast<unsigned long>(this));

	}
	~NewBlockActor1State() 
	{
		fdb_probe_actor_destroy("newBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1704 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int bytesLeft = self->blockEnd - self->file->size();
															#line 1705 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (bytesLeft > 0)
															#line 11220 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1706 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				paddingFFs = makePadding(bytesLeft);
															#line 1707 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->file->append(paddingFFs.begin(), bytesLeft);
															#line 1707 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11228 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<NewBlockActor1*>(this)->actor_wait_state = 1;
															#line 1707 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 0, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 11233 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewBlockActor1State();
		static_cast<NewBlockActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1710 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (final)
															#line 11261 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1711 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 1712 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<NewBlockActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockActor1State(); static_cast<NewBlockActor1*>(this)->destroy(); return 0; }
															#line 11267 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<NewBlockActor1*>(this)->SAV< Void >::value()) Void(Void());
			this->~NewBlockActor1State();
			static_cast<NewBlockActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1716 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->blockEnd += self->blockSize;
															#line 1719 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append((uint8_t*)&self->fileVersion, sizeof(self->fileVersion));
															#line 1719 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11279 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<NewBlockActor1*>(this)->actor_wait_state = 2;
															#line 1719 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 1, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 11284 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state > 0) static_cast<NewBlockActor1*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor1*>(this)->ActorCallback< NewBlockActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewBlockActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1722 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->blockEnd > self->blockSize)
															#line 11380 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1723 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(self->lastKey);
															#line 1723 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11386 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<NewBlockActor1*>(this)->actor_wait_state = 3;
															#line 1723 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 2, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 11391 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1722 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->blockEnd > self->blockSize)
															#line 11405 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1723 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(self->lastKey);
															#line 1723 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11411 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<NewBlockActor1*>(this)->actor_wait_state = 3;
															#line 1723 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 2, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 11416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state > 0) static_cast<NewBlockActor1*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor1*>(this)->ActorCallback< NewBlockActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< NewBlockActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1729 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->file->size() + bytesNeeded > self->blockEnd)
															#line 11505 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1730 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_bad_block_size(), loopDepth);
															#line 11509 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1732 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<NewBlockActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockActor1State(); static_cast<NewBlockActor1*>(this)->destroy(); return 0; }
															#line 11513 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<NewBlockActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewBlockActor1State();
		static_cast<NewBlockActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1724 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->file->appendStringRefWithLen(self->lastKey);
															#line 1724 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11527 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<NewBlockActor1*>(this)->actor_wait_state = 4;
															#line 1724 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 3, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 11532 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1724 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->file->appendStringRefWithLen(self->lastKey);
															#line 1724 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11543 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<NewBlockActor1*>(this)->actor_wait_state = 4;
															#line 1724 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 3, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 11548 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state > 0) static_cast<NewBlockActor1*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor1*>(this)->ActorCallback< NewBlockActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< NewBlockActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 1725 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->file->appendStringRefWithLen(self->lastValue);
															#line 1725 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11634 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<NewBlockActor1*>(this)->actor_wait_state = 5;
															#line 1725 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 4, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 11639 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 1725 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->file->appendStringRefWithLen(self->lastValue);
															#line 1725 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11650 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<NewBlockActor1*>(this)->actor_wait_state = 5;
															#line 1725 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 4, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 11655 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state > 0) static_cast<NewBlockActor1*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor1*>(this)->ActorCallback< NewBlockActor1, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< NewBlockActor1, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state > 0) static_cast<NewBlockActor1*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor1*>(this)->ActorCallback< NewBlockActor1, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< NewBlockActor1, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RangeFileWriter* self;
															#line 1702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesNeeded;
															#line 1702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool final;
															#line 1706 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value paddingFFs;
															#line 11830 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via newBlock()
															#line 1702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockActor1 final : public Actor<Void>, public ActorCallback< NewBlockActor1, 0, Void >, public ActorCallback< NewBlockActor1, 1, Void >, public ActorCallback< NewBlockActor1, 2, Void >, public ActorCallback< NewBlockActor1, 3, Void >, public ActorCallback< NewBlockActor1, 4, Void >, public FastAllocated<NewBlockActor1>, public NewBlockActor1State<NewBlockActor1> {
															#line 11835 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<NewBlockActor1>::operator new;
	using FastAllocated<NewBlockActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15012662219323920896UL, 17280174652609166080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewBlockActor1, 0, Void >;
friend struct ActorCallback< NewBlockActor1, 1, Void >;
friend struct ActorCallback< NewBlockActor1, 2, Void >;
friend struct ActorCallback< NewBlockActor1, 3, Void >;
friend struct ActorCallback< NewBlockActor1, 4, Void >;
															#line 1702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockActor1(RangeFileWriter* const& self,int const& bytesNeeded,bool const& final = false) 
															#line 11856 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   NewBlockActor1State<NewBlockActor1>(self, bytesNeeded, final),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2007484470230468096UL, 2771688764731692544UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewBlockActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< NewBlockActor1, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< NewBlockActor1, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< NewBlockActor1, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< NewBlockActor1, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> newBlock( RangeFileWriter* const& self, int const& bytesNeeded, bool const& final = false ) {
															#line 1702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new NewBlockActor1(self, bytesNeeded, final));
															#line 11892 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1734 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// Used in simulation only to create backup file sizes which are an integer multiple of the block size
	Future<Void> padEnd(bool final) {
		ASSERT(g_network->isSimulated());
		if (file->size() > 0) {
			return newBlock(this, 0, final);
		}
		return Void();
	}

	// Ends the current block if necessary based on bytesNeeded.
	Future<Void> newBlockIfNeeded(int bytesNeeded) {
		if (file->size() + bytesNeeded > blockEnd)
			return newBlock(this, bytesNeeded);
		return Void();
	}

	// Start a new block if needed, then write the key and value
																#line 11914 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via writeKV_impl()
															#line 1752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKV_implActor1>
															#line 1752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor1State {
															#line 11920 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor1State(RangeFileWriter* const& self,Key const& k,Value const& v) 
															#line 1752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k),
															#line 1752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   v(v)
															#line 11931 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKV_implActor1State() 
	{
		fdb_probe_actor_destroy("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1753 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int toWrite = sizeof(int32_t) + k.size() + sizeof(int32_t) + v.size();
															#line 1754 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->newBlockIfNeeded(toWrite);
															#line 1754 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11950 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 1;
															#line 1754 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 0, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 11955 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKV_implActor1State();
		static_cast<WriteKV_implActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1755 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->appendStringRefWithLen(k);
															#line 1755 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11980 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 2;
															#line 1755 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 1, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 11985 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1755 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->appendStringRefWithLen(k);
															#line 1755 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11996 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 2;
															#line 1755 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 1, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 12001 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor1*>(this)->ActorCallback< WriteKV_implActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1756 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(v);
															#line 1756 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12087 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 3;
															#line 1756 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 2, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 12092 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1756 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(v);
															#line 1756 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12103 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 3;
															#line 1756 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 2, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 12108 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor1*>(this)->ActorCallback< WriteKV_implActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1757 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1758 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastValue = v;
															#line 1759 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActor1State(); static_cast<WriteKV_implActor1*>(this)->destroy(); return 0; }
															#line 12196 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKV_implActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActor1State();
		static_cast<WriteKV_implActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1757 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1758 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastValue = v;
															#line 1759 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActor1State(); static_cast<WriteKV_implActor1*>(this)->destroy(); return 0; }
															#line 12212 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKV_implActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActor1State();
		static_cast<WriteKV_implActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor1*>(this)->ActorCallback< WriteKV_implActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RangeFileWriter* self;
															#line 1752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 1752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value v;
															#line 12301 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeKV_impl()
															#line 1752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor1 final : public Actor<Void>, public ActorCallback< WriteKV_implActor1, 0, Void >, public ActorCallback< WriteKV_implActor1, 1, Void >, public ActorCallback< WriteKV_implActor1, 2, Void >, public FastAllocated<WriteKV_implActor1>, public WriteKV_implActor1State<WriteKV_implActor1> {
															#line 12306 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteKV_implActor1>::operator new;
	using FastAllocated<WriteKV_implActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3776153979873436928UL, 16509826448095816448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKV_implActor1, 0, Void >;
friend struct ActorCallback< WriteKV_implActor1, 1, Void >;
friend struct ActorCallback< WriteKV_implActor1, 2, Void >;
															#line 1752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor1(RangeFileWriter* const& self,Key const& k,Value const& v) 
															#line 12325 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteKV_implActor1State<WriteKV_implActor1>(self, k, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16217267337946238464UL, 13255526101699148288UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKV_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKV_implActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKV_implActor1, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteKV_implActor1, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKV_impl( RangeFileWriter* const& self, Key const& k, Value const& v ) {
															#line 1752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKV_implActor1(self, k, v));
															#line 12359 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1761 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKV(Key k, Value v) { return writeKV_impl(this, k, v); }

	// Write begin key or end key.
																#line 12367 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via writeKey_impl()
															#line 1765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKey_implActor1>
															#line 1765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKey_implActor1State {
															#line 12373 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKey_implActor1State(RangeFileWriter* const& self,Key const& k) 
															#line 1765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k)
															#line 12382 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeKey_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKey_implActor1State() 
	{
		fdb_probe_actor_destroy("writeKey_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1766 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int toWrite = sizeof(uint32_t) + k.size();
															#line 1767 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->newBlockIfNeeded(toWrite);
															#line 1767 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<WriteKey_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12401 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteKey_implActor1*>(this)->actor_wait_state = 1;
															#line 1767 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor1, 0, Void >*>(static_cast<WriteKey_implActor1*>(this)));
															#line 12406 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKey_implActor1State();
		static_cast<WriteKey_implActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1768 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->appendStringRefWithLen(k);
															#line 1768 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKey_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12431 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKey_implActor1*>(this)->actor_wait_state = 2;
															#line 1768 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor1, 1, Void >*>(static_cast<WriteKey_implActor1*>(this)));
															#line 12436 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1768 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->appendStringRefWithLen(k);
															#line 1768 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKey_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKey_implActor1*>(this)->actor_wait_state = 2;
															#line 1768 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor1, 1, Void >*>(static_cast<WriteKey_implActor1*>(this)));
															#line 12452 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKey_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKey_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKey_implActor1*>(this)->ActorCallback< WriteKey_implActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKey_implActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1769 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKey_implActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKey_implActor1State(); static_cast<WriteKey_implActor1*>(this)->destroy(); return 0; }
															#line 12536 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKey_implActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKey_implActor1State();
		static_cast<WriteKey_implActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1769 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKey_implActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKey_implActor1State(); static_cast<WriteKey_implActor1*>(this)->destroy(); return 0; }
															#line 12548 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKey_implActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKey_implActor1State();
		static_cast<WriteKey_implActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKey_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKey_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKey_implActor1*>(this)->ActorCallback< WriteKey_implActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKey_implActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RangeFileWriter* self;
															#line 1765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 12635 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeKey_impl()
															#line 1765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKey_implActor1 final : public Actor<Void>, public ActorCallback< WriteKey_implActor1, 0, Void >, public ActorCallback< WriteKey_implActor1, 1, Void >, public FastAllocated<WriteKey_implActor1>, public WriteKey_implActor1State<WriteKey_implActor1> {
															#line 12640 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteKey_implActor1>::operator new;
	using FastAllocated<WriteKey_implActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15311464797527691776UL, 9254082434552742656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKey_implActor1, 0, Void >;
friend struct ActorCallback< WriteKey_implActor1, 1, Void >;
															#line 1765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKey_implActor1(RangeFileWriter* const& self,Key const& k) 
															#line 12658 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteKey_implActor1State<WriteKey_implActor1>(self, k),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3399269857036320000UL, 6984076183881784832UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKey_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKey_implActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKey_implActor1, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKey_impl( RangeFileWriter* const& self, Key const& k ) {
															#line 1765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKey_implActor1(self, k));
															#line 12691 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1771 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKey(Key k) { return writeKey_impl(this, k); }

	Future<Void> finish() { return Void(); }

	Reference<IBackupFile> file;
	int blockSize;

private:
	int64_t blockEnd;
	uint32_t fileVersion;
	Key lastKey;
	Key lastValue;
};

void decodeKVPairs(StringRefReader* reader,
                   Standalone<VectorRef<KeyValueRef>>* results,
                   bool encryptedBlock,
                   EncryptionAtRestMode encryptMode,
                   Optional<int64_t> blockDomainId) {
	// Read begin key, if this fails then block was invalid.
	uint32_t kLen = reader->consumeNetworkUInt32();
	const uint8_t* k = reader->consume(kLen);
	results->push_back(results->arena(), KeyValueRef(KeyRef(k, kLen), ValueRef()));
	KeyRef prevKey = KeyRef(k, kLen);
	// Read kv pairs and end key
	while (1) {
		// Read a key.
		kLen = reader->consumeNetworkUInt32();
		k = reader->consume(kLen);

		// If eof reached or first value len byte is 0xFF then a valid block end was reached.
		if (reader->eof() || *reader->rptr == 0xFF) {
			results->push_back(results->arena(), KeyValueRef(KeyRef(k, kLen), ValueRef()));
			break;
		}

		// Read a value, which must exist or the block is invalid
		uint32_t vLen = reader->consumeNetworkUInt32();
		const uint8_t* v = reader->consume(vLen);

		results->push_back(results->arena(), KeyValueRef(KeyRef(k, kLen), ValueRef(v, vLen)));

		// If eof reached or first byte of next key len is 0xFF then a valid block end was reached.
		if (reader->eof() || *reader->rptr == 0xFF)
			break;
	}

	// Make sure any remaining bytes in the block are 0xFF
	for (auto b : reader->remainder())
		if (b != 0xFF)
			throw restore_corrupted_data_padding();
}

static Reference<IBackupContainer> getBackupContainerWithProxy(Reference<IBackupContainer> _bc) {
	Reference<IBackupContainer> bc = IBackupContainer::openContainer(_bc->getURL(), fileBackupAgentProxy, {});
	return bc;
}

Standalone<VectorRef<KeyValueRef>> decodeRangeFileBlock(const Standalone<StringRef>& buf) {
	Standalone<VectorRef<KeyValueRef>> results({}, buf.arena());
	StringRefReader reader(buf, restore_corrupted_data());

	// Read header, currently only decoding BACKUP_AGENT_SNAPSHOT_FILE_VERSION
	if (reader.consume<int32_t>() != BACKUP_AGENT_SNAPSHOT_FILE_VERSION)
		throw restore_unsupported_file_version();

	// Read begin key, if this fails then block was invalid.
	uint32_t beginKeyLen = reader.consumeNetworkUInt32();
	const uint8_t* beginKey = reader.consume(beginKeyLen);
	results.push_back(results.arena(), KeyValueRef(KeyRef(beginKey, beginKeyLen), ValueRef()));

	// Read kv pairs and end key
	while (1) {
		// If eof reached or first value len byte is 0xFF then a valid block end was reached.
		if (reader.eof() || *reader.rptr == 0xFF) {
			break;
		}

		// Read a key, which must exist or the block is invalid
		uint32_t kLen = reader.consumeNetworkUInt32();
		const uint8_t* k = reader.consume(kLen);

		// If eof reached or first value len byte is 0xFF then a valid block end was reached.
		if (reader.eof() || *reader.rptr == 0xFF) {
			// The last block in the file, will have Read End key.
			results.push_back(results.arena(), KeyValueRef(KeyRef(k, kLen), ValueRef()));
			break;
		}

		// Read a value, which must exist or the block is invalid
		uint32_t vLen = reader.consumeNetworkUInt32();
		const uint8_t* v = reader.consume(vLen);
		results.push_back(results.arena(), KeyValueRef(KeyRef(k, kLen), ValueRef(v, vLen)));
	}

	// Make sure any remaining bytes in the block are 0xFF
	for (auto b : reader.remainder())
		if (b != 0xFF)
			throw restore_corrupted_data_padding();

	return results;
}

															#line 12799 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via decodeRangeFileBlock()
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class DecodeRangeFileBlockActor>
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeRangeFileBlockActorState {
															#line 12805 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeRangeFileBlockActorState(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len,Database const& cx) 
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : file(file),
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   offset(offset),
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   len(len),
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   cx(cx),
															#line 1879 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   buf(makeString(len))
															#line 12820 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this));

	}
	~DecodeRangeFileBlockActorState() 
	{
		fdb_probe_actor_destroy("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1880 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<int> __when_expr_0 = uncancellable(holdWhile(buf, file->read(mutateString(buf), len, offset)));
															#line 1880 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12837 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 1;
															#line 1880 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 0, int >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 12842 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DecodeRangeFileBlockActorState();
		static_cast<DecodeRangeFileBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& rLen,int loopDepth) 
	{
															#line 1881 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (rLen != len)
															#line 12865 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1882 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 12869 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1884 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		simulateBlobFailure();
															#line 1886 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		results = Standalone<VectorRef<KeyValueRef>>({}, buf.arena());
															#line 1887 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		reader = StringRefReader(buf, restore_corrupted_data());
															#line 1888 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		arena = Arena();
															#line 1889 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<DatabaseConfiguration> __when_expr_1 = getDatabaseConfiguration(cx);
															#line 1889 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12883 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 2;
															#line 1889 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 12888 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int && rLen,int loopDepth) 
	{
															#line 1881 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (rLen != len)
															#line 12897 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1882 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 12901 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1884 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		simulateBlobFailure();
															#line 1886 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		results = Standalone<VectorRef<KeyValueRef>>({}, buf.arena());
															#line 1887 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		reader = StringRefReader(buf, restore_corrupted_data());
															#line 1888 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		arena = Arena();
															#line 1889 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<DatabaseConfiguration> __when_expr_1 = getDatabaseConfiguration(cx);
															#line 1889 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12915 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 2;
															#line 1889 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 12920 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(int const& rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(rLen, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(rLen), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeRangeFileBlockActor*>(this)->ActorCallback< DecodeRangeFileBlockActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DecodeRangeFileBlockActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1890 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		encryptMode = config.encryptionAtRestMode;
															#line 1891 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		blockDomainId = -1;
															#line 13006 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		try {
															#line 1896 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int32_t file_version = reader.consume<int32_t>();
															#line 1897 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(!encryptMode.isEncryptionEnabled() || file_version == BACKUP_AGENT_ENCRYPTED_SNAPSHOT_FILE_VERSION);
															#line 1898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (file_version == BACKUP_AGENT_SNAPSHOT_FILE_VERSION)
															#line 13014 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1899 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				decodeKVPairs(&reader, &results, false, encryptMode, Optional<int64_t>());
															#line 13018 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = a_body1cont5(loopDepth);
			}
			else
			{
															#line 1900 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (file_version == BACKUP_AGENT_ENCRYPTED_SNAPSHOT_FILE_VERSION)
															#line 13025 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				{
															#line 1901 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					CODE_PROBE(true, "decoding encrypted block", probe::decoration::rare);
															#line 1903 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					headerLen = reader.consume<uint32_t>();
															#line 1905 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					headerStart = reader.consume(headerLen);
															#line 1906 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					StringRef headerS = StringRef(headerStart, headerLen);
															#line 1907 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					encryptHeader = BlobCipherEncryptHeaderRef();
															#line 1909 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					encryptHeader = BlobCipherEncryptHeaderRef::fromStringRef(headerS);
															#line 1910 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					blockDomainId = encryptHeader.getCipherDetails().textCipherDetails.encryptDomainId;
															#line 1912 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					const uint8_t* dataPayloadStart = headerStart + headerLen;
															#line 1914 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					int64_t bytesRead = sizeof(int32_t) + sizeof(uint32_t) + headerLen;
															#line 1916 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					int64_t dataLen = len - bytesRead;
															#line 1917 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					StrictFuture<StringRef> __when_expr_2 = EncryptedRangeFileWriter::decrypt(cx, encryptHeader, dataPayloadStart, dataLen, &results.arena());
															#line 1917 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 13051 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
					static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 3;
															#line 1917 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 2, StringRef >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 13056 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 1922 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					return a_body1cont2Catch1(restore_unsupported_file_version(), loopDepth);
															#line 13063 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(DatabaseConfiguration const& __config,int loopDepth) 
	{
															#line 1889 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		config = __config;
															#line 13079 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(DatabaseConfiguration && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeRangeFileBlockActor*>(this)->ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1926 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (e.code() == error_code_encrypt_keys_fetch_failed || e.code() == error_code_encrypt_key_not_found)
															#line 13159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1927 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ASSERT(!isReservedEncryptDomain(blockDomainId));
															#line 1928 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarnAlways, "SnapshotRestoreEncryptKeyFetchFailed");
															#line 1929 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				CODE_PROBE(true, "Snapshot restore encrypt keys not found", probe::decoration::rare);
															#line 13167 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1931 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "FileRestoreDecodeRangeFileBlockFailed") .error(e) .detail("Filename", file->getFilename()) .detail("BlockOffset", offset) .detail("BlockLen", len) .detail("ErrorRelativeOffset", reader.rptr - buf.begin()) .detail("ErrorAbsoluteOffset", reader.rptr - buf.begin() + offset);
															#line 1938 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 13173 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1924 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<DecodeRangeFileBlockActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(results); this->~DecodeRangeFileBlockActorState(); static_cast<DecodeRangeFileBlockActor*>(this)->destroy(); return 0; }
															#line 13187 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<DecodeRangeFileBlockActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(std::move(results)); // state_var_RVO
		this->~DecodeRangeFileBlockActorState();
		static_cast<DecodeRangeFileBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(StringRef const& decryptedData,int loopDepth) 
	{
															#line 1919 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		reader = StringRefReader(decryptedData, restore_corrupted_data());
															#line 1920 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		decodeKVPairs(&reader, &results, true, encryptMode, blockDomainId);
															#line 13207 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(StringRef && decryptedData,int loopDepth) 
	{
															#line 1919 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		reader = StringRefReader(decryptedData, restore_corrupted_data());
															#line 1920 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		decodeKVPairs(&reader, &results, true, encryptMode, blockDomainId);
															#line 13218 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(StringRef const& decryptedData,int loopDepth) 
	{
		loopDepth = a_body1cont8(decryptedData, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(StringRef && decryptedData,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(decryptedData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeRangeFileBlockActor*>(this)->ActorCallback< DecodeRangeFileBlockActor, 2, StringRef >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 2, StringRef >*,StringRef const& value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 2, StringRef >*,StringRef && value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DecodeRangeFileBlockActor, 2, StringRef >*,Error err) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> file;
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t offset;
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int len;
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 1879 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<StringRef> buf;
															#line 1886 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> results;
															#line 1887 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StringRefReader reader;
															#line 1888 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Arena arena;
															#line 1889 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DatabaseConfiguration config;
															#line 1890 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptionAtRestMode encryptMode;
															#line 1891 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t blockDomainId;
															#line 1903 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	uint32_t headerLen;
															#line 1905 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	const uint8_t* headerStart;
															#line 1907 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BlobCipherEncryptHeaderRef encryptHeader;
															#line 13326 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via decodeRangeFileBlock()
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeRangeFileBlockActor final : public Actor<Standalone<VectorRef<KeyValueRef>>>, public ActorCallback< DecodeRangeFileBlockActor, 0, int >, public ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >, public ActorCallback< DecodeRangeFileBlockActor, 2, StringRef >, public FastAllocated<DecodeRangeFileBlockActor>, public DecodeRangeFileBlockActorState<DecodeRangeFileBlockActor> {
															#line 13331 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<DecodeRangeFileBlockActor>::operator new;
	using FastAllocated<DecodeRangeFileBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16774823504404892672UL, 15734623811159031808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyValueRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DecodeRangeFileBlockActor, 0, int >;
friend struct ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >;
friend struct ActorCallback< DecodeRangeFileBlockActor, 2, StringRef >;
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeRangeFileBlockActor(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len,Database const& cx) 
															#line 13350 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<KeyValueRef>>>(),
		   DecodeRangeFileBlockActorState<DecodeRangeFileBlockActor>(file, offset, len, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16131528145190661120UL, 4810314581124466176UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("decodeRangeFileBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DecodeRangeFileBlockActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DecodeRangeFileBlockActor, 2, StringRef >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<KeyValueRef>>> decodeRangeFileBlock( Reference<IAsyncFile> const& file, int64_t const& offset, int const& len, Database const& cx ) {
															#line 1875 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<KeyValueRef>>>(new DecodeRangeFileBlockActor(file, offset, len, cx));
															#line 13384 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1941 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Very simple format compared to KeyRange files.
// Header, [Key, Value]... Key len
struct LogFileWriter {
	LogFileWriter(Reference<IBackupFile> file = Reference<IBackupFile>(), int blockSize = 0)
	  : file(file), blockSize(blockSize), blockEnd(0) {}

	// Start a new block if needed, then write the key and value
																#line 13396 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via writeKV_impl()
															#line 1949 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKV_implActor2>
															#line 1949 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor2State {
															#line 13402 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1949 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor2State(LogFileWriter* const& self,Key const& k,Value const& v) 
															#line 1949 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1949 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1949 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k),
															#line 1949 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   v(v)
															#line 13413 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKV_implActor2State() 
	{
		fdb_probe_actor_destroy("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1951 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int toWrite = sizeof(int32_t) + k.size() + sizeof(int32_t) + v.size();
															#line 1952 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->file->size() + toWrite > self->blockEnd)
															#line 13430 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1954 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int bytesLeft = self->blockEnd - self->file->size();
															#line 1955 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (bytesLeft > 0)
															#line 13436 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				{
															#line 1956 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					paddingFFs = makePadding(bytesLeft);
															#line 1957 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					StrictFuture<Void> __when_expr_0 = self->file->append(paddingFFs.begin(), bytesLeft);
															#line 1957 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13444 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 1;
															#line 1957 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor2, 0, Void >*>(static_cast<WriteKV_implActor2*>(this)));
															#line 13449 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKV_implActor2State();
		static_cast<WriteKV_implActor2*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1967 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(k);
															#line 1967 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13484 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 3;
															#line 1967 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor2, 2, Void >*>(static_cast<WriteKV_implActor2*>(this)));
															#line 13489 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1961 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->blockEnd += self->blockSize;
															#line 1964 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append((uint8_t*)&BACKUP_AGENT_MLOG_VERSION, sizeof(BACKUP_AGENT_MLOG_VERSION));
															#line 1964 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13502 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 2;
															#line 1964 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor2, 1, Void >*>(static_cast<WriteKV_implActor2*>(this)));
															#line 13507 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor2*>(this)->ActorCallback< WriteKV_implActor2, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor2, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor2*>(this)->ActorCallback< WriteKV_implActor2, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor2, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1968 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->file->appendStringRefWithLen(v);
															#line 1968 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13692 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 4;
															#line 1968 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor2, 3, Void >*>(static_cast<WriteKV_implActor2*>(this)));
															#line 13697 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1968 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->file->appendStringRefWithLen(v);
															#line 1968 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13708 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 4;
															#line 1968 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor2, 3, Void >*>(static_cast<WriteKV_implActor2*>(this)));
															#line 13713 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor2*>(this)->ActorCallback< WriteKV_implActor2, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor2, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1971 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->file->size() > self->blockEnd)
															#line 13797 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1972 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_bad_block_size(), loopDepth);
															#line 13801 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1974 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActor2State(); static_cast<WriteKV_implActor2*>(this)->destroy(); return 0; }
															#line 13805 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKV_implActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActor2State();
		static_cast<WriteKV_implActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1971 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->file->size() > self->blockEnd)
															#line 13817 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1972 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_bad_block_size(), loopDepth);
															#line 13821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1974 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActor2State(); static_cast<WriteKV_implActor2*>(this)->destroy(); return 0; }
															#line 13825 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKV_implActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActor2State();
		static_cast<WriteKV_implActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor2*>(this)->ActorCallback< WriteKV_implActor2, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor2, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1949 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	LogFileWriter* self;
															#line 1949 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 1949 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value v;
															#line 1956 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value paddingFFs;
															#line 13916 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeKV_impl()
															#line 1949 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor2 final : public Actor<Void>, public ActorCallback< WriteKV_implActor2, 0, Void >, public ActorCallback< WriteKV_implActor2, 1, Void >, public ActorCallback< WriteKV_implActor2, 2, Void >, public ActorCallback< WriteKV_implActor2, 3, Void >, public FastAllocated<WriteKV_implActor2>, public WriteKV_implActor2State<WriteKV_implActor2> {
															#line 13921 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteKV_implActor2>::operator new;
	using FastAllocated<WriteKV_implActor2>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3776153979873436928UL, 16509826448095816448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKV_implActor2, 0, Void >;
friend struct ActorCallback< WriteKV_implActor2, 1, Void >;
friend struct ActorCallback< WriteKV_implActor2, 2, Void >;
friend struct ActorCallback< WriteKV_implActor2, 3, Void >;
															#line 1949 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor2(LogFileWriter* const& self,Key const& k,Value const& v) 
															#line 13941 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteKV_implActor2State<WriteKV_implActor2>(self, k, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1459114523673046528UL, 17997660117777869824UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKV_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKV_implActor2, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKV_implActor2, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteKV_implActor2, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WriteKV_implActor2, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1949 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKV_impl( LogFileWriter* const& self, Key const& k, Value const& v ) {
															#line 1949 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKV_implActor2(self, k, v));
															#line 13976 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1976 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKV(Key k, Value v) { return writeKV_impl(this, k, v); }

	Reference<IBackupFile> file;
	int blockSize;

private:
	int64_t blockEnd;
};

// input: a string of [param1, param2], [param1, param2] ..., [param1, param2]
// output: a vector of [param1, param2] after removing the length info
Standalone<VectorRef<KeyValueRef>> decodeMutationLogFileBlock(const Standalone<StringRef>& buf) {
	Standalone<VectorRef<KeyValueRef>> results({}, buf.arena());
	StringRefReader reader(buf, restore_corrupted_data());

	// Read header, currently only decoding version BACKUP_AGENT_MLOG_VERSION
	if (reader.consume<int32_t>() != BACKUP_AGENT_MLOG_VERSION)
		throw restore_unsupported_file_version();

	// Read k/v pairs.  Block ends either at end of last value exactly or with 0xFF as first key len byte.
	while (1) {
		// If eof reached or first key len bytes is 0xFF then end of block was reached.
		if (reader.eof() || *reader.rptr == 0xFF)
			break;

		// Read key and value.  If anything throws then there is a problem.
		uint32_t kLen = reader.consumeNetworkUInt32();
		const uint8_t* k = reader.consume(kLen);
		uint32_t vLen = reader.consumeNetworkUInt32();
		const uint8_t* v = reader.consume(vLen);

		results.push_back(results.arena(), KeyValueRef(KeyRef(k, kLen), ValueRef(v, vLen)));
	}

	// Make sure any remaining bytes in the block are 0xFF
	for (auto b : reader.remainder())
		if (b != 0xFF)
			throw restore_corrupted_data_padding();

	return results;
}

															#line 14023 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via decodeMutationLogFileBlock()
															#line 2019 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class DecodeMutationLogFileBlockActor>
															#line 2019 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeMutationLogFileBlockActorState {
															#line 14029 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2019 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeMutationLogFileBlockActorState(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len) 
															#line 2019 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2019 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : file(file),
															#line 2019 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   offset(offset),
															#line 2019 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   len(len),
															#line 2022 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   buf(makeString(len))
															#line 14042 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this));

	}
	~DecodeMutationLogFileBlockActorState() 
	{
		fdb_probe_actor_destroy("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2023 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<int> __when_expr_0 = file->read(mutateString(buf), len, offset);
															#line 2023 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<DecodeMutationLogFileBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14059 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DecodeMutationLogFileBlockActor*>(this)->actor_wait_state = 1;
															#line 2023 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*>(static_cast<DecodeMutationLogFileBlockActor*>(this)));
															#line 14064 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DecodeMutationLogFileBlockActorState();
		static_cast<DecodeMutationLogFileBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& rLen,int loopDepth) 
	{
															#line 2024 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (rLen != len)
															#line 14087 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2025 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 14091 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		try {
															#line 2028 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<DecodeMutationLogFileBlockActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(decodeMutationLogFileBlock(buf)); this->~DecodeMutationLogFileBlockActorState(); static_cast<DecodeMutationLogFileBlockActor*>(this)->destroy(); return 0; }
															#line 14096 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<DecodeMutationLogFileBlockActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(decodeMutationLogFileBlock(buf));
			this->~DecodeMutationLogFileBlockActorState();
			static_cast<DecodeMutationLogFileBlockActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(int && rLen,int loopDepth) 
	{
															#line 2024 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (rLen != len)
															#line 14114 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2025 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 14118 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		try {
															#line 2028 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<DecodeMutationLogFileBlockActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(decodeMutationLogFileBlock(buf)); this->~DecodeMutationLogFileBlockActorState(); static_cast<DecodeMutationLogFileBlockActor*>(this)->destroy(); return 0; }
															#line 14123 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<DecodeMutationLogFileBlockActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(decodeMutationLogFileBlock(buf));
			this->~DecodeMutationLogFileBlockActorState();
			static_cast<DecodeMutationLogFileBlockActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(int const& rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(rLen, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(rLen), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DecodeMutationLogFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeMutationLogFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeMutationLogFileBlockActor*>(this)->ActorCallback< DecodeMutationLogFileBlockActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeMutationLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeMutationLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeMutationLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2030 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "FileRestoreCorruptLogFileBlock") .error(e) .detail("Filename", file->getFilename()) .detail("BlockOffset", offset) .detail("BlockLen", len);
															#line 2035 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 14219 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2019 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> file;
															#line 2019 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t offset;
															#line 2019 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int len;
															#line 2022 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<StringRef> buf;
															#line 14237 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via decodeMutationLogFileBlock()
															#line 2019 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeMutationLogFileBlockActor final : public Actor<Standalone<VectorRef<KeyValueRef>>>, public ActorCallback< DecodeMutationLogFileBlockActor, 0, int >, public FastAllocated<DecodeMutationLogFileBlockActor>, public DecodeMutationLogFileBlockActorState<DecodeMutationLogFileBlockActor> {
															#line 14242 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<DecodeMutationLogFileBlockActor>::operator new;
	using FastAllocated<DecodeMutationLogFileBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14303485792299212544UL, 1909279179283086080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyValueRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DecodeMutationLogFileBlockActor, 0, int >;
															#line 2019 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeMutationLogFileBlockActor(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len) 
															#line 14259 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<KeyValueRef>>>(),
		   DecodeMutationLogFileBlockActorState<DecodeMutationLogFileBlockActor>(file, offset, len),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10553348071887031296UL, 14129820410599961600UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeMutationLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("decodeMutationLogFileBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2019 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<KeyValueRef>>> decodeMutationLogFileBlock( Reference<IAsyncFile> const& file, int64_t const& offset, int const& len ) {
															#line 2019 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<KeyValueRef>>>(new DecodeMutationLogFileBlockActor(file, offset, len));
															#line 14291 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2038 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 14296 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via checkTaskVersion()
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class CheckTaskVersionActor>
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class CheckTaskVersionActorState {
															#line 14302 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	CheckTaskVersionActorState(Database const& cx,Reference<Task> const& task,StringRef const& name,uint32_t const& version) 
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : cx(cx),
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   name(name),
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   version(version)
															#line 14315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkTaskVersion", reinterpret_cast<unsigned long>(this));

	}
	~CheckTaskVersionActorState() 
	{
		fdb_probe_actor_destroy("checkTaskVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2040 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			uint32_t taskVersion = task->getVersion();
															#line 2041 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (taskVersion > version)
															#line 14332 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 2042 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				err = task_invalid_version();
															#line 2044 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarn, "BA_BackupRangeTaskFuncExecute") .detail("TaskVersion", taskVersion) .detail("Name", name) .detail("Version", version);
															#line 2048 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (KeyBackedTaskConfig::TaskParams.uid().exists(task))
															#line 14340 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				{
															#line 2049 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					std::string msg = format("%s task version `%lu' is greater than supported version `%lu'", task->params[Task::reservedTaskParamKeyType].toString().c_str(), (unsigned long)taskVersion, (unsigned long)version);
															#line 2053 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					StrictFuture<Void> __when_expr_0 = BackupConfig(task).logError(cx, err, msg);
															#line 2053 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					if (static_cast<CheckTaskVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14348 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<CheckTaskVersionActor*>(this)->actor_wait_state = 1;
															#line 2053 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckTaskVersionActor, 0, Void >*>(static_cast<CheckTaskVersionActor*>(this)));
															#line 14353 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckTaskVersionActorState();
		static_cast<CheckTaskVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2059 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<CheckTaskVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckTaskVersionActorState(); static_cast<CheckTaskVersionActor*>(this)->destroy(); return 0; }
															#line 14386 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<CheckTaskVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckTaskVersionActorState();
		static_cast<CheckTaskVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2056 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 14398 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckTaskVersionActor*>(this)->actor_wait_state > 0) static_cast<CheckTaskVersionActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTaskVersionActor*>(this)->ActorCallback< CheckTaskVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTaskVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckTaskVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckTaskVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StringRef name;
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	uint32_t version;
															#line 2042 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Error err;
															#line 14499 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkTaskVersion()
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class CheckTaskVersionActor final : public Actor<Void>, public ActorCallback< CheckTaskVersionActor, 0, Void >, public FastAllocated<CheckTaskVersionActor>, public CheckTaskVersionActorState<CheckTaskVersionActor> {
															#line 14504 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckTaskVersionActor>::operator new;
	using FastAllocated<CheckTaskVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3841127117084455168UL, 18121041470268953856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckTaskVersionActor, 0, Void >;
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	CheckTaskVersionActor(Database const& cx,Reference<Task> const& task,StringRef const& name,uint32_t const& version) 
															#line 14521 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckTaskVersionActorState<CheckTaskVersionActor>(cx, task, name, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3362756845853264896UL, 17854206522136534528UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkTaskVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckTaskVersionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> checkTaskVersion( Database const& cx, Reference<Task> const& task, StringRef const& name, uint32_t const& version ) {
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new CheckTaskVersionActor(cx, task, name, version));
															#line 14553 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2061 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 14558 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via abortFiveZeroBackup()
															#line 2062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AbortFiveZeroBackupActor>
															#line 2062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AbortFiveZeroBackupActorState {
															#line 14564 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AbortFiveZeroBackupActorState(FileBackupAgent* const& backupAgent,Reference<ReadYourWritesTransaction> const& tr,std::string const& tagName) 
															#line 2062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : backupAgent(backupAgent),
															#line 2062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 2062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tagName(tagName)
															#line 14575 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this));

	}
	~AbortFiveZeroBackupActorState() 
	{
		fdb_probe_actor_destroy("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2065 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2066 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2068 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tagNames = backupAgent->subspace.get(BackupAgentBase::keyTagName);
															#line 2069 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(tagNames.pack(Key(tagName)));
															#line 2069 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14598 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 1;
															#line 2069 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*>(static_cast<AbortFiveZeroBackupActor*>(this)));
															#line 14603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AbortFiveZeroBackupActorState();
		static_cast<AbortFiveZeroBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& uidStr,int loopDepth) 
	{
															#line 2070 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!uidStr.present())
															#line 14626 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2071 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "FileBackupAbortIncompatibleBackup_TagNotFound").detail("TagName", tagName.c_str());
															#line 2072 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AbortFiveZeroBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveZeroBackupActorState(); static_cast<AbortFiveZeroBackupActor*>(this)->destroy(); return 0; }
															#line 14632 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AbortFiveZeroBackupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AbortFiveZeroBackupActorState();
			static_cast<AbortFiveZeroBackupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2074 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		uid = BinaryReader::fromStringRef<UID>(uidStr.get(), Unversioned());
															#line 2076 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		statusSpace = backupAgent->subspace.get(BackupAgentBase::keyStates).get(uid.toString());
															#line 2077 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		globalConfig = backupAgent->subspace.get(BackupAgentBase::keyConfig).get(uid.toString());
															#line 2078 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		newConfigSpace = uidPrefixKey("uid->config/"_sr.withPrefix(fileBackupPrefixRange.begin), uid);
															#line 2080 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr->get(statusSpace.pack(FileBackupAgent::keyStateStatus));
															#line 2080 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14650 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 2;
															#line 2080 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*>(static_cast<AbortFiveZeroBackupActor*>(this)));
															#line 14655 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && uidStr,int loopDepth) 
	{
															#line 2070 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!uidStr.present())
															#line 14664 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2071 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "FileBackupAbortIncompatibleBackup_TagNotFound").detail("TagName", tagName.c_str());
															#line 2072 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AbortFiveZeroBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveZeroBackupActorState(); static_cast<AbortFiveZeroBackupActor*>(this)->destroy(); return 0; }
															#line 14670 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AbortFiveZeroBackupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AbortFiveZeroBackupActorState();
			static_cast<AbortFiveZeroBackupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2074 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		uid = BinaryReader::fromStringRef<UID>(uidStr.get(), Unversioned());
															#line 2076 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		statusSpace = backupAgent->subspace.get(BackupAgentBase::keyStates).get(uid.toString());
															#line 2077 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		globalConfig = backupAgent->subspace.get(BackupAgentBase::keyConfig).get(uid.toString());
															#line 2078 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		newConfigSpace = uidPrefixKey("uid->config/"_sr.withPrefix(fileBackupPrefixRange.begin), uid);
															#line 2080 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr->get(statusSpace.pack(FileBackupAgent::keyStateStatus));
															#line 2080 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14688 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 2;
															#line 2080 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*>(static_cast<AbortFiveZeroBackupActor*>(this)));
															#line 14693 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& uidStr,int loopDepth) 
	{
		loopDepth = a_body1cont1(uidStr, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && uidStr,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(uidStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveZeroBackupActor*>(this)->ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<Value> const& statusStr,int loopDepth) 
	{
															#line 2081 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		status = !statusStr.present() ? EBackupState::STATE_NEVERRAN : BackupAgentBase::getState(statusStr.get().toString());
															#line 2084 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FileBackupAbortIncompatibleBackup") .detail("TagName", tagName.c_str()) .detail("Status", BackupAgentBase::getStateText(status));
															#line 2089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(singleKeyRange(StringRef(globalConfig.pack(FileBackupAgent::keyFolderId))));
															#line 2092 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key configPath = uidPrefixKey(logRangesRange.begin, uid);
															#line 2093 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(backupLogKeys.begin, uid);
															#line 2094 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(configPath, strinc(configPath)));
															#line 2095 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 2098 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(newConfigSpace.range());
															#line 2100 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key statusKey = StringRef(statusSpace.pack(FileBackupAgent::keyStateStatus));
															#line 2103 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (backupAgent->isRunnable(status))
															#line 14795 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->set(statusKey, StringRef(FileBackupAgent::getStateText(EBackupState::STATE_ABORTED)));
															#line 14799 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2106 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AbortFiveZeroBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveZeroBackupActorState(); static_cast<AbortFiveZeroBackupActor*>(this)->destroy(); return 0; }
															#line 14803 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AbortFiveZeroBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortFiveZeroBackupActorState();
		static_cast<AbortFiveZeroBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && statusStr,int loopDepth) 
	{
															#line 2081 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		status = !statusStr.present() ? EBackupState::STATE_NEVERRAN : BackupAgentBase::getState(statusStr.get().toString());
															#line 2084 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FileBackupAbortIncompatibleBackup") .detail("TagName", tagName.c_str()) .detail("Status", BackupAgentBase::getStateText(status));
															#line 2089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(singleKeyRange(StringRef(globalConfig.pack(FileBackupAgent::keyFolderId))));
															#line 2092 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key configPath = uidPrefixKey(logRangesRange.begin, uid);
															#line 2093 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(backupLogKeys.begin, uid);
															#line 2094 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(configPath, strinc(configPath)));
															#line 2095 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 2098 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(newConfigSpace.range());
															#line 2100 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key statusKey = StringRef(statusSpace.pack(FileBackupAgent::keyStateStatus));
															#line 2103 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (backupAgent->isRunnable(status))
															#line 14833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->set(statusKey, StringRef(FileBackupAgent::getStateText(EBackupState::STATE_ABORTED)));
															#line 14837 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2106 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AbortFiveZeroBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveZeroBackupActorState(); static_cast<AbortFiveZeroBackupActor*>(this)->destroy(); return 0; }
															#line 14841 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AbortFiveZeroBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortFiveZeroBackupActorState();
		static_cast<AbortFiveZeroBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& statusStr,int loopDepth) 
	{
		loopDepth = a_body1cont2(statusStr, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && statusStr,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(statusStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveZeroBackupActor*>(this)->ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 2062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string tagName;
															#line 2068 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Subspace tagNames;
															#line 2074 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID uid;
															#line 2076 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Subspace statusSpace;
															#line 2077 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Subspace globalConfig;
															#line 2078 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Subspace newConfigSpace;
															#line 2081 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EBackupState status;
															#line 14942 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via abortFiveZeroBackup()
															#line 2062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AbortFiveZeroBackupActor final : public Actor<Void>, public ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >, public ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >, public FastAllocated<AbortFiveZeroBackupActor>, public AbortFiveZeroBackupActorState<AbortFiveZeroBackupActor> {
															#line 14947 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<AbortFiveZeroBackupActor>::operator new;
	using FastAllocated<AbortFiveZeroBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14300453750177478656UL, 12979879701585868288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >;
friend struct ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >;
															#line 2062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AbortFiveZeroBackupActor(FileBackupAgent* const& backupAgent,Reference<ReadYourWritesTransaction> const& tr,std::string const& tagName) 
															#line 14965 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AbortFiveZeroBackupActorState<AbortFiveZeroBackupActor>(backupAgent, tr, tagName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9684559041468978176UL, 9313393515895828736UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("abortFiveZeroBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> abortFiveZeroBackup( FileBackupAgent* const& backupAgent, Reference<ReadYourWritesTransaction> const& tr, std::string const& tagName ) {
															#line 2062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new AbortFiveZeroBackupActor(backupAgent, tr, tagName));
															#line 14998 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2108 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

struct AbortFiveZeroBackupTask : TaskFuncBase {
	static StringRef name;
																#line 15005 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via _finish()
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class _finishActor>
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActorState {
															#line 15011 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2115 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   backupAgent(),
															#line 2116 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tagName(task->params[BackupAgentBase::keyConfigBackupTag].toString())
															#line 15028 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActorState() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2118 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevInfo, "FileBackupCancelOldTask") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("TagName", tagName);
															#line 2121 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = abortFiveZeroBackup(&backupAgent, tr, tagName);
															#line 2121 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15047 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor*>(this)->actor_wait_state = 1;
															#line 2121 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 0, Void >*>(static_cast<_finishActor*>(this)));
															#line 15052 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2123 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = taskBucket->finish(tr, task);
															#line 2123 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15077 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor*>(this)->actor_wait_state = 2;
															#line 2123 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 1, Void >*>(static_cast<_finishActor*>(this)));
															#line 15082 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2123 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = taskBucket->finish(tr, task);
															#line 2123 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15093 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor*>(this)->actor_wait_state = 2;
															#line 2123 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 1, Void >*>(static_cast<_finishActor*>(this)));
															#line 15098 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2124 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActorState(); static_cast<_finishActor*>(this)->destroy(); return 0; }
															#line 15182 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2124 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActorState(); static_cast<_finishActor*>(this)->destroy(); return 0; }
															#line 15194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 2115 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FileBackupAgent backupAgent;
															#line 2116 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string tagName;
															#line 15289 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _finish()
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActor final : public Actor<Void>, public ActorCallback< _finishActor, 0, Void >, public ActorCallback< _finishActor, 1, Void >, public FastAllocated<_finishActor>, public _finishActorState<_finishActor> {
															#line 15294 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<_finishActor>::operator new;
	using FastAllocated<_finishActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15065352667244231936UL, 14162519855157561600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor, 0, Void >;
friend struct ActorCallback< _finishActor, 1, Void >;
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 15312 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _finishActorState<_finishActor>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5805366160711900928UL, 534046083987129088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor(tr, taskBucket, futureBucket, task));
															#line 15345 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2126 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	StringRef getName() const override {
		TraceEvent(SevError, "FileBackupError")
		    .detail("Cause", "AbortFiveZeroBackupTaskFunc::name() should never be called");
		ASSERT(false);
		return StringRef();
	}

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Future<Void>(Void());
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};
};
StringRef AbortFiveZeroBackupTask::name = "abort_legacy_backup"_sr;
REGISTER_TASKFUNC(AbortFiveZeroBackupTask);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_diff_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_log_range);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_range);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_restorable);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_finish_full_backup);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_finished_full_backup);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_start_full_backup);

															#line 15381 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via abortFiveOneBackup()
															#line 2158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AbortFiveOneBackupActor>
															#line 2158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AbortFiveOneBackupActorState {
															#line 15387 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AbortFiveOneBackupActorState(FileBackupAgent* const& backupAgent,Reference<ReadYourWritesTransaction> const& tr,std::string const& tagName) 
															#line 2158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : backupAgent(backupAgent),
															#line 2158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 2158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tagName(tagName)
															#line 15398 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("abortFiveOneBackup", reinterpret_cast<unsigned long>(this));

	}
	~AbortFiveOneBackupActorState() 
	{
		fdb_probe_actor_destroy("abortFiveOneBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2161 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2162 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2164 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tag = makeBackupTag(tagName);
															#line 2165 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<UidAndAbortedFlagT> __when_expr_0 = tag.getOrThrow(tr, Snapshot::False, backup_unneeded());
															#line 2165 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15421 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 1;
															#line 2165 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*>(static_cast<AbortFiveOneBackupActor*>(this)));
															#line 15426 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AbortFiveOneBackupActorState();
		static_cast<AbortFiveOneBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2167 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		config = BackupConfig(current.first);
															#line 2168 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<EBackupState> __when_expr_1 = config.stateEnum().getD(tr, Snapshot::False, EBackupState::STATE_NEVERRAN);
															#line 2168 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15453 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 2;
															#line 2168 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*>(static_cast<AbortFiveOneBackupActor*>(this)));
															#line 15458 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(UidAndAbortedFlagT const& __current,int loopDepth) 
	{
															#line 2165 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		current = __current;
															#line 15467 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(UidAndAbortedFlagT && __current,int loopDepth) 
	{
		current = std::move(__current);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveOneBackupActor*>(this)->ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*,UidAndAbortedFlagT const& value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*,UidAndAbortedFlagT && value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(EBackupState const& status,int loopDepth) 
	{
															#line 2170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!backupAgent->isRunnable(status))
															#line 15546 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2171 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_unneeded(), loopDepth);
															#line 15550 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2174 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FBA_AbortFileOneBackup") .detail("TagName", tagName.c_str()) .detail("Status", BackupAgentBase::getStateText(status));
															#line 2179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tag.cancel(tr);
															#line 2179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15558 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 3;
															#line 2179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AbortFiveOneBackupActor, 2, Void >*>(static_cast<AbortFiveOneBackupActor*>(this)));
															#line 15563 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(EBackupState && status,int loopDepth) 
	{
															#line 2170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!backupAgent->isRunnable(status))
															#line 15572 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2171 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_unneeded(), loopDepth);
															#line 15576 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2174 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FBA_AbortFileOneBackup") .detail("TagName", tagName.c_str()) .detail("Status", BackupAgentBase::getStateText(status));
															#line 2179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tag.cancel(tr);
															#line 2179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15584 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 3;
															#line 2179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AbortFiveOneBackupActor, 2, Void >*>(static_cast<AbortFiveOneBackupActor*>(this)));
															#line 15589 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(EBackupState const& status,int loopDepth) 
	{
		loopDepth = a_body1cont2(status, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(EBackupState && status,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveOneBackupActor*>(this)->ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2181 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key configPath = uidPrefixKey(logRangesRange.begin, config.getUid());
															#line 2182 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(backupLogKeys.begin, config.getUid());
															#line 2184 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(configPath, strinc(configPath)));
															#line 2185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 2187 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		config.stateEnum().set(tr, EBackupState::STATE_ABORTED);
															#line 2189 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AbortFiveOneBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveOneBackupActorState(); static_cast<AbortFiveOneBackupActor*>(this)->destroy(); return 0; }
															#line 15683 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AbortFiveOneBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortFiveOneBackupActorState();
		static_cast<AbortFiveOneBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2181 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key configPath = uidPrefixKey(logRangesRange.begin, config.getUid());
															#line 2182 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(backupLogKeys.begin, config.getUid());
															#line 2184 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(configPath, strinc(configPath)));
															#line 2185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 2187 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		config.stateEnum().set(tr, EBackupState::STATE_ABORTED);
															#line 2189 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AbortFiveOneBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveOneBackupActorState(); static_cast<AbortFiveOneBackupActor*>(this)->destroy(); return 0; }
															#line 15705 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AbortFiveOneBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortFiveOneBackupActorState();
		static_cast<AbortFiveOneBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveOneBackupActor*>(this)->ActorCallback< AbortFiveOneBackupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AbortFiveOneBackupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 2158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string tagName;
															#line 2164 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyBackedTag tag;
															#line 2165 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UidAndAbortedFlagT current;
															#line 2167 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig config;
															#line 15800 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via abortFiveOneBackup()
															#line 2158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AbortFiveOneBackupActor final : public Actor<Void>, public ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >, public ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >, public ActorCallback< AbortFiveOneBackupActor, 2, Void >, public FastAllocated<AbortFiveOneBackupActor>, public AbortFiveOneBackupActorState<AbortFiveOneBackupActor> {
															#line 15805 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<AbortFiveOneBackupActor>::operator new;
	using FastAllocated<AbortFiveOneBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3686531108771451392UL, 5364292494678533376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >;
friend struct ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >;
friend struct ActorCallback< AbortFiveOneBackupActor, 2, Void >;
															#line 2158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AbortFiveOneBackupActor(FileBackupAgent* const& backupAgent,Reference<ReadYourWritesTransaction> const& tr,std::string const& tagName) 
															#line 15824 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AbortFiveOneBackupActorState<AbortFiveOneBackupActor>(backupAgent, tr, tagName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12508330983096255488UL, 5977812422500027136UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("abortFiveOneBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AbortFiveOneBackupActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> abortFiveOneBackup( FileBackupAgent* const& backupAgent, Reference<ReadYourWritesTransaction> const& tr, std::string const& tagName ) {
															#line 2158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new AbortFiveOneBackupActor(backupAgent, tr, tagName));
															#line 15858 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2191 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

struct AbortFiveOneBackupTask : TaskFuncBase {
	static StringRef name;
																#line 15865 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via _finish()
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class _finishActor1>
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActor1State {
															#line 15871 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActor1State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2198 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   backupAgent(),
															#line 2199 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   config(task)
															#line 15888 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor1State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2200 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<std::string> __when_expr_0 = config.tag().getOrThrow(tr);
															#line 2200 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15905 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor1*>(this)->actor_wait_state = 1;
															#line 2200 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 0, std::string >*>(static_cast<_finishActor1*>(this)));
															#line 15910 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2202 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FileBackupCancelFiveOneTask") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("TagName", tagName);
															#line 2205 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = abortFiveOneBackup(&backupAgent, tr, tagName);
															#line 2205 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15937 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 2;
															#line 2205 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 1, Void >*>(static_cast<_finishActor1*>(this)));
															#line 15942 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::string const& __tagName,int loopDepth) 
	{
															#line 2200 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tagName = __tagName;
															#line 15951 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::string && __tagName,int loopDepth) 
	{
		tagName = std::move(__tagName);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 0, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 0, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 0, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor1, 0, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2207 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = taskBucket->finish(tr, task);
															#line 2207 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16032 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 3;
															#line 2207 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 2, Void >*>(static_cast<_finishActor1*>(this)));
															#line 16037 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2207 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = taskBucket->finish(tr, task);
															#line 2207 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16048 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 3;
															#line 2207 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 2, Void >*>(static_cast<_finishActor1*>(this)));
															#line 16053 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2208 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor1State(); static_cast<_finishActor1*>(this)->destroy(); return 0; }
															#line 16137 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2208 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor1State(); static_cast<_finishActor1*>(this)->destroy(); return 0; }
															#line 16149 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _finishActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 2198 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FileBackupAgent backupAgent;
															#line 2199 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig config;
															#line 2200 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string tagName;
															#line 16246 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _finish()
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActor1 final : public Actor<Void>, public ActorCallback< _finishActor1, 0, std::string >, public ActorCallback< _finishActor1, 1, Void >, public ActorCallback< _finishActor1, 2, Void >, public FastAllocated<_finishActor1>, public _finishActor1State<_finishActor1> {
															#line 16251 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<_finishActor1>::operator new;
	using FastAllocated<_finishActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15065352667244231936UL, 14162519855157561600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor1, 0, std::string >;
friend struct ActorCallback< _finishActor1, 1, Void >;
friend struct ActorCallback< _finishActor1, 2, Void >;
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActor1(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 16270 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _finishActor1State<_finishActor1>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9581808447337778176UL, 9167718057927325696UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor1, 0, std::string >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor1, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _finishActor1, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor1(tr, taskBucket, futureBucket, task));
															#line 16304 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2210 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	StringRef getName() const override {
		TraceEvent(SevError, "FileBackupError")
		    .detail("Cause", "AbortFiveOneBackupTaskFunc::name() should never be called");
		ASSERT(false);
		return StringRef();
	}

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Future<Void>(Void());
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};
};
StringRef AbortFiveOneBackupTask::name = "abort_legacy_backup_5.2"_sr;
REGISTER_TASKFUNC(AbortFiveOneBackupTask);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_write_range);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_dispatch_ranges);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_write_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_erase_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_dispatch_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_finished);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_write_snapshot_manifest);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_start);

std::function<void(Reference<Task>)> NOP_SETUP_TASK_FN = [](Reference<Task> task) { /* NOP */ };
															#line 16341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via addBackupTask()
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AddBackupTaskActor>
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AddBackupTaskActorState {
															#line 16347 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AddBackupTaskActorState(StringRef const& name,uint32_t const& version,Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,TaskCompletionKey const& completionKey,BackupConfig const& config,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(),std::function<void(Reference<Task>)> const& setupTaskFn = NOP_SETUP_TASK_FN,int const& priority = 0,SetValidation const& setValidation = SetValidation::True) 
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : name(name),
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   version(version),
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   completionKey(completionKey),
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   config(config),
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   waitFor(waitFor),
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   setupTaskFn(setupTaskFn),
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   priority(priority),
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   setValidation(setValidation)
															#line 16372 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("addBackupTask", reinterpret_cast<unsigned long>(this));

	}
	~AddBackupTaskActorState() 
	{
		fdb_probe_actor_destroy("addBackupTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2253 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2254 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2256 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Key> __when_expr_0 = completionKey.get(tr, taskBucket);
															#line 2256 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16393 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 1;
															#line 2256 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 0, Key >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 16398 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddBackupTaskActorState();
		static_cast<AddBackupTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& doneKey,int loopDepth) 
	{
															#line 2257 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		task = Reference<Task>(new Task(name, version, doneKey, priority));
															#line 2261 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = config.toTask(tr, task, setValidation);
															#line 2261 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16425 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 2;
															#line 2261 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 1, Void >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 16430 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key && doneKey,int loopDepth) 
	{
															#line 2257 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		task = Reference<Task>(new Task(name, version, doneKey, priority));
															#line 2261 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = config.toTask(tr, task, setValidation);
															#line 2261 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16443 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 2;
															#line 2261 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 1, Void >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 16448 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(doneKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(doneKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state > 0) static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddBackupTaskActor*>(this)->ActorCallback< AddBackupTaskActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddBackupTaskActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2264 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		setupTaskFn(task);
															#line 2266 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!waitFor)
															#line 16534 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2267 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AddBackupTaskActor*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task)); this->~AddBackupTaskActorState(); static_cast<AddBackupTaskActor*>(this)->destroy(); return 0; }
															#line 16538 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AddBackupTaskActor*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task));
			this->~AddBackupTaskActorState();
			static_cast<AddBackupTaskActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2269 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitFor->onSetAddTask(tr, taskBucket, task);
															#line 2269 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16548 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 3;
															#line 2269 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 2, Void >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 16553 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2264 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		setupTaskFn(task);
															#line 2266 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!waitFor)
															#line 16564 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2267 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AddBackupTaskActor*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task)); this->~AddBackupTaskActorState(); static_cast<AddBackupTaskActor*>(this)->destroy(); return 0; }
															#line 16568 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AddBackupTaskActor*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task));
			this->~AddBackupTaskActorState();
			static_cast<AddBackupTaskActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2269 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitFor->onSetAddTask(tr, taskBucket, task);
															#line 2269 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16578 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 3;
															#line 2269 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 2, Void >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 16583 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state > 0) static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddBackupTaskActor*>(this)->ActorCallback< AddBackupTaskActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddBackupTaskActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2271 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AddBackupTaskActor*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddBackupTaskActorState(); static_cast<AddBackupTaskActor*>(this)->destroy(); return 0; }
															#line 16667 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AddBackupTaskActor*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddBackupTaskActorState();
		static_cast<AddBackupTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2271 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AddBackupTaskActor*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddBackupTaskActorState(); static_cast<AddBackupTaskActor*>(this)->destroy(); return 0; }
															#line 16679 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AddBackupTaskActor*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddBackupTaskActorState();
		static_cast<AddBackupTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state > 0) static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddBackupTaskActor*>(this)->ActorCallback< AddBackupTaskActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AddBackupTaskActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StringRef name;
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	uint32_t version;
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TaskCompletionKey completionKey;
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig config;
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskFuture> waitFor;
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::function<void(Reference<Task>)> setupTaskFn;
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int priority;
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	SetValidation setValidation;
															#line 2257 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 16784 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via addBackupTask()
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AddBackupTaskActor final : public Actor<Key>, public ActorCallback< AddBackupTaskActor, 0, Key >, public ActorCallback< AddBackupTaskActor, 1, Void >, public ActorCallback< AddBackupTaskActor, 2, Void >, public FastAllocated<AddBackupTaskActor>, public AddBackupTaskActorState<AddBackupTaskActor> {
															#line 16789 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<AddBackupTaskActor>::operator new;
	using FastAllocated<AddBackupTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11442901334206580480UL, 2336378714597752064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddBackupTaskActor, 0, Key >;
friend struct ActorCallback< AddBackupTaskActor, 1, Void >;
friend struct ActorCallback< AddBackupTaskActor, 2, Void >;
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AddBackupTaskActor(StringRef const& name,uint32_t const& version,Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,TaskCompletionKey const& completionKey,BackupConfig const& config,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(),std::function<void(Reference<Task>)> const& setupTaskFn = NOP_SETUP_TASK_FN,int const& priority = 0,SetValidation const& setValidation = SetValidation::True) 
															#line 16808 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Key>(),
		   AddBackupTaskActorState<AddBackupTaskActor>(name, version, tr, taskBucket, completionKey, config, waitFor, setupTaskFn, priority, setValidation),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9042814576718378240UL, 18087378901118404352UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addBackupTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddBackupTaskActor, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddBackupTaskActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AddBackupTaskActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Key> addBackupTask( StringRef const& name, uint32_t const& version, Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, TaskCompletionKey const& completionKey, BackupConfig const& config, Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(), std::function<void(Reference<Task>)> const& setupTaskFn = NOP_SETUP_TASK_FN, int const& priority = 0, SetValidation const& setValidation = SetValidation::True ) {
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Key>(new AddBackupTaskActor(name, version, tr, taskBucket, completionKey, config, waitFor, setupTaskFn, priority, setValidation));
															#line 16842 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2273 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Clears the backup ID from "backupStartedKey" to pause backup workers.
															#line 16848 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via clearBackupStartID()
															#line 2275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class ClearBackupStartIDActor>
															#line 2275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class ClearBackupStartIDActorState {
															#line 16854 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	ClearBackupStartIDActorState(Reference<ReadYourWritesTransaction> const& tr,UID const& backupUid) 
															#line 2275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   backupUid(backupUid)
															#line 16863 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clearBackupStartID", reinterpret_cast<unsigned long>(this));

	}
	~ClearBackupStartIDActorState() 
	{
		fdb_probe_actor_destroy("clearBackupStartID", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2277 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(backupStartedKey);
															#line 2277 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<ClearBackupStartIDActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16880 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearBackupStartIDActor*>(this)->actor_wait_state = 1;
															#line 2277 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*>(static_cast<ClearBackupStartIDActor*>(this)));
															#line 16885 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearBackupStartIDActorState();
		static_cast<ClearBackupStartIDActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& started,int loopDepth) 
	{
															#line 2278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<std::pair<UID, Version>> ids;
															#line 2279 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (started.present())
															#line 16910 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2280 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ids = decodeBackupStartedValue(started.get());
															#line 16914 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2282 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		auto it = std::find_if(ids.begin(), ids.end(), [=](const std::pair<UID, Version>& p) { return p.first == backupUid; });
															#line 2284 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (it != ids.end())
															#line 16920 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2285 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ids.erase(it);
															#line 16924 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2288 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ids.empty())
															#line 16928 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2289 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent("ClearBackup").detail("BackupID", backupUid);
															#line 2290 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->clear(backupStartedKey);
															#line 16934 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2292 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->set(backupStartedKey, encodeBackupStartedValue(ids));
															#line 16940 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2294 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<ClearBackupStartIDActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearBackupStartIDActorState(); static_cast<ClearBackupStartIDActor*>(this)->destroy(); return 0; }
															#line 16944 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<ClearBackupStartIDActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearBackupStartIDActorState();
		static_cast<ClearBackupStartIDActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && started,int loopDepth) 
	{
															#line 2278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<std::pair<UID, Version>> ids;
															#line 2279 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (started.present())
															#line 16958 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2280 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ids = decodeBackupStartedValue(started.get());
															#line 16962 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2282 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		auto it = std::find_if(ids.begin(), ids.end(), [=](const std::pair<UID, Version>& p) { return p.first == backupUid; });
															#line 2284 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (it != ids.end())
															#line 16968 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2285 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ids.erase(it);
															#line 16972 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2288 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ids.empty())
															#line 16976 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2289 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent("ClearBackup").detail("BackupID", backupUid);
															#line 2290 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->clear(backupStartedKey);
															#line 16982 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2292 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->set(backupStartedKey, encodeBackupStartedValue(ids));
															#line 16988 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2294 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<ClearBackupStartIDActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearBackupStartIDActorState(); static_cast<ClearBackupStartIDActor*>(this)->destroy(); return 0; }
															#line 16992 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<ClearBackupStartIDActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearBackupStartIDActorState();
		static_cast<ClearBackupStartIDActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& started,int loopDepth) 
	{
		loopDepth = a_body1cont1(started, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && started,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(started), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearBackupStartIDActor*>(this)->actor_wait_state > 0) static_cast<ClearBackupStartIDActor*>(this)->actor_wait_state = 0;
		static_cast<ClearBackupStartIDActor*>(this)->ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearBackupStartIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearBackupStartIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearBackupStartIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID backupUid;
															#line 17079 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clearBackupStartID()
															#line 2275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class ClearBackupStartIDActor final : public Actor<Void>, public ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >, public FastAllocated<ClearBackupStartIDActor>, public ClearBackupStartIDActorState<ClearBackupStartIDActor> {
															#line 17084 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClearBackupStartIDActor>::operator new;
	using FastAllocated<ClearBackupStartIDActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16796249609145201664UL, 2852701905109846528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >;
															#line 2275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	ClearBackupStartIDActor(Reference<ReadYourWritesTransaction> const& tr,UID const& backupUid) 
															#line 17101 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClearBackupStartIDActorState<ClearBackupStartIDActor>(tr, backupUid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearBackupStartID", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2638382467860152832UL, 17874567724139410688UL);
		ActorExecutionContextHelper __helper(static_cast<ClearBackupStartIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearBackupStartID");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearBackupStartID", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> clearBackupStartID( Reference<ReadYourWritesTransaction> const& tr, UID const& backupUid ) {
															#line 2275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new ClearBackupStartIDActor(tr, backupUid));
															#line 17133 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2296 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Backup and Restore taskFunc definitions will inherit from one of the following classes which
// servers to catch and log to the appropriate config any error that execute/finish didn't catch and log.
struct RestoreTaskFuncBase : TaskFuncBase {
	Future<Void> handleError(Database cx, Reference<Task> task, Error const& error) final {
		return RestoreConfig(task).logError(
		    cx,
		    error,
		    format("'%s' on '%s'", error.what(), task->params[Task::reservedTaskParamKeyType].printable().c_str()));
	}
	virtual std::string toString(Reference<Task> task) const { return ""; }
};

struct BackupTaskFuncBase : TaskFuncBase {
	Future<Void> handleError(Database cx, Reference<Task> task, Error const& error) final {
		return BackupConfig(task).logError(
		    cx,
		    error,
		    format("'%s' on '%s'", error.what(), task->params[Task::reservedTaskParamKeyType].printable().c_str()));
	}
	virtual std::string toString(Reference<Task> task) const { return ""; }
};

															#line 17160 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getBlockOfShards()
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetBlockOfShardsActor>
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetBlockOfShardsActorState {
															#line 17166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetBlockOfShardsActorState(Reference<ReadYourWritesTransaction> const& tr,Key const& beginKey,Key const& endKey,int const& limit) 
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   beginKey(beginKey),
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   endKey(endKey),
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   limit(limit)
															#line 17179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getBlockOfShards", reinterpret_cast<unsigned long>(this));

	}
	~GetBlockOfShardsActorState() 
	{
		fdb_probe_actor_destroy("getBlockOfShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2324 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2325 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2326 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results = Standalone<VectorRef<KeyRef>>();
															#line 2327 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange( KeyRangeRef(keyAfter(beginKey.withPrefix(keyServersPrefix)), endKey.withPrefix(keyServersPrefix)), limit);
															#line 2327 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17202 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state = 1;
															#line 2327 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*>(static_cast<GetBlockOfShardsActor*>(this)));
															#line 17207 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBlockOfShardsActorState();
		static_cast<GetBlockOfShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& values,int loopDepth) 
	{
															#line 2330 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& s : values ) {
															#line 2331 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			KeyRef k = s.key.removePrefix(keyServersPrefix);
															#line 2332 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results.push_back_deep(results.arena(), k);
															#line 17234 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2335 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetBlockOfShardsActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(results); this->~GetBlockOfShardsActorState(); static_cast<GetBlockOfShardsActor*>(this)->destroy(); return 0; }
															#line 17238 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetBlockOfShardsActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(std::move(results)); // state_var_RVO
		this->~GetBlockOfShardsActorState();
		static_cast<GetBlockOfShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && values,int loopDepth) 
	{
															#line 2330 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& s : values ) {
															#line 2331 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			KeyRef k = s.key.removePrefix(keyServersPrefix);
															#line 2332 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results.push_back_deep(results.arena(), k);
															#line 17254 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2335 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetBlockOfShardsActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(results); this->~GetBlockOfShardsActorState(); static_cast<GetBlockOfShardsActor*>(this)->destroy(); return 0; }
															#line 17258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetBlockOfShardsActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(std::move(results)); // state_var_RVO
		this->~GetBlockOfShardsActorState();
		static_cast<GetBlockOfShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& values,int loopDepth) 
	{
		loopDepth = a_body1cont1(values, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && values,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(values), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state > 0) static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state = 0;
		static_cast<GetBlockOfShardsActor*>(this)->ActorCallback< GetBlockOfShardsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key beginKey;
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key endKey;
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int limit;
															#line 2326 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<KeyRef>> results;
															#line 17351 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getBlockOfShards()
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetBlockOfShardsActor final : public Actor<Standalone<VectorRef<KeyRef>>>, public ActorCallback< GetBlockOfShardsActor, 0, RangeResult >, public FastAllocated<GetBlockOfShardsActor>, public GetBlockOfShardsActorState<GetBlockOfShardsActor> {
															#line 17356 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetBlockOfShardsActor>::operator new;
	using FastAllocated<GetBlockOfShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13592151982121146624UL, 12562647444002820096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBlockOfShardsActor, 0, RangeResult >;
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetBlockOfShardsActor(Reference<ReadYourWritesTransaction> const& tr,Key const& beginKey,Key const& endKey,int const& limit) 
															#line 17373 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<KeyRef>>>(),
		   GetBlockOfShardsActorState<GetBlockOfShardsActor>(tr, beginKey, endKey, limit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13286161151181671680UL, 17379547947322064896UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBlockOfShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<KeyRef>>> getBlockOfShards( Reference<ReadYourWritesTransaction> const& tr, Key const& beginKey, Key const& endKey, int const& limit ) {
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<KeyRef>>>(new GetBlockOfShardsActor(tr, beginKey, endKey, limit));
															#line 17405 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2337 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

struct BackupRangeTaskFunc : BackupTaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

	static struct {
		static TaskParam<Key> beginKey() { return __FUNCTION__sr; }
		static TaskParam<Key> endKey() { return __FUNCTION__sr; }
		static TaskParam<bool> addBackupRangeTasks() { return __FUNCTION__sr; }
	} Params;

	std::string toString(Reference<Task> task) const override {
		return format("beginKey '%s' endKey '%s' addTasks %d",
		              Params.beginKey().get(task).printable().c_str(),
		              Params.endKey().get(task).printable().c_str(),
		              Params.addBackupRangeTasks().get(task));
	}

	StringRef getName() const override { return name; };

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return _execute(cx, tb, fb, task);
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};

	// Finish (which flushes/syncs) the file, and then in a single transaction, make some range backup progress
	// durable. This means:
	//  - increment the backup config's range bytes written
	//  - update the range file map
	//  - update the task begin key
	//  - save/extend the task with the new params
	// Returns whether or not the caller should continue executing the task.
																#line 17449 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via finishRangeFile()
															#line 2377 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class FinishRangeFileActor>
															#line 2377 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class FinishRangeFileActorState {
															#line 17455 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2377 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FinishRangeFileActorState(Reference<IBackupFile> const& file,Database const& cx,Reference<Task> const& task,Reference<TaskBucket> const& taskBucket,KeyRange const& range,Version const& version) 
															#line 2377 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2377 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : file(file),
															#line 2377 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   cx(cx),
															#line 2377 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2377 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2377 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   range(range),
															#line 2377 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   version(version)
															#line 17472 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("finishRangeFile", reinterpret_cast<unsigned long>(this));

	}
	~FinishRangeFileActorState() 
	{
		fdb_probe_actor_destroy("finishRangeFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2383 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = file->finish();
															#line 2383 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17489 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 1;
															#line 2383 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 0, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 17494 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FinishRangeFileActorState();
		static_cast<FinishRangeFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2386 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (range.empty())
															#line 17517 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2387 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<FinishRangeFileActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FinishRangeFileActorState(); static_cast<FinishRangeFileActor*>(this)->destroy(); return 0; }
															#line 17521 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<FinishRangeFileActor*>(this)->SAV< bool >::value()) bool(false);
			this->~FinishRangeFileActorState();
			static_cast<FinishRangeFileActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 2390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup = BackupConfig(task);
															#line 2391 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		usedFile = false;
															#line 2395 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = task->extendMutex.take();
															#line 2395 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17537 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 2;
															#line 2395 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 1, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 17542 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2386 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (range.empty())
															#line 17551 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2387 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<FinishRangeFileActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FinishRangeFileActorState(); static_cast<FinishRangeFileActor*>(this)->destroy(); return 0; }
															#line 17555 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<FinishRangeFileActor*>(this)->SAV< bool >::value()) bool(false);
			this->~FinishRangeFileActorState();
			static_cast<FinishRangeFileActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2389 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 2390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup = BackupConfig(task);
															#line 2391 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		usedFile = false;
															#line 2395 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = task->extendMutex.take();
															#line 2395 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17571 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 2;
															#line 2395 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 1, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 17576 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2396 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		releaser = FlowLock::Releaser(task->extendMutex, 1);
															#line 2398 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 17662 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2396 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		releaser = FlowLock::Releaser(task->extendMutex, 1);
															#line 2398 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 17673 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 2430 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<FinishRangeFileActor*>(this)->SAV<bool>::futures) { (void)(usedFile); this->~FinishRangeFileActorState(); static_cast<FinishRangeFileActor*>(this)->destroy(); return 0; }
															#line 17757 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<FinishRangeFileActor*>(this)->SAV< bool >::value()) bool(std::move(usedFile)); // state_var_RVO
		this->~FinishRangeFileActorState();
		static_cast<FinishRangeFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 2400 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2401 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2405 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			Params.beginKey().set(task, range.end);
															#line 2408 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Version> __when_expr_2 = taskBucket->extendTimeout(tr, task, UpdateParams::True);
															#line 2408 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17785 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 3;
															#line 2408 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 2, Version >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 17790 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2426 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr->onError(e);
															#line 2426 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17827 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 6;
															#line 2426 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 5, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 17832 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(int loopDepth) 
	{
															#line 2411 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup.rangeBytesWritten().atomicOp(tr, file->size(), MutationRef::AddValue);
															#line 2412 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup.snapshotRangeFileCount().atomicOp(tr, 1, MutationRef::AddValue);
															#line 2415 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Optional<BackupConfig::RangeSlice>> __when_expr_3 = backup.snapshotRangeFileMap().get(tr, range.end);
															#line 2415 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17853 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 4;
															#line 2415 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 17858 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Version const& __newTimeout,int loopDepth) 
	{
															#line 2408 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		newTimeout = __newTimeout;
															#line 17867 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Version && __newTimeout,int loopDepth) 
	{
		newTimeout = std::move(__newTimeout);
		loopDepth = a_body1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont3(Optional<BackupConfig::RangeSlice> const& s,int loopDepth) 
	{
															#line 2416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!s.present() || s.get().begin >= range.begin)
															#line 17946 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2417 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			backup.snapshotRangeFileMap().set( tr, range.end, { range.begin, version, file->getFileName(), file->size() });
															#line 2419 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			usedFile = true;
															#line 17952 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2422 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr->commit();
															#line 2422 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17958 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 5;
															#line 2422 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 4, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 17963 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Optional<BackupConfig::RangeSlice> && s,int loopDepth) 
	{
															#line 2416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!s.present() || s.get().begin >= range.begin)
															#line 17972 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2417 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			backup.snapshotRangeFileMap().set( tr, range.end, { range.begin, version, file->getFileName(), file->size() });
															#line 2419 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			usedFile = true;
															#line 17978 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2422 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr->commit();
															#line 2422 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17984 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 5;
															#line 2422 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 4, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 17989 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Optional<BackupConfig::RangeSlice> const& s,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(s, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Optional<BackupConfig::RangeSlice> && s,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*,Optional<BackupConfig::RangeSlice> const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExec