#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
/*
 * BackupContainerFileSystem.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "flow/BooleanParam.h"
#ifdef BUILD_AZURE_BACKUP
#include "fdbclient/BackupContainerAzureBlobStore.h"
#endif
#include "fdbclient/BackupContainerFileSystem.h"
#include "fdbclient/BackupContainerLocalDirectory.h"
#include "fdbclient/BackupContainerS3BlobStore.h"
#include "fdbclient/JsonBuilder.h"
#include "flow/StreamCipher.h"
#include "flow/UnitTest.h"

#include <algorithm>
#include <cinttypes>

#include "flow/actorcompiler.h" // This must be the last #include.

class BackupContainerFileSystemImpl {
public:
	// TODO:  Do this more efficiently, as the range file list for a snapshot could potentially be hundreds of
	// megabytes.
																#line 45 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via readKeyspaceSnapshot()
															#line 43 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class ReadKeyspaceSnapshotActor>
															#line 43 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class ReadKeyspaceSnapshotActorState {
															#line 51 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 43 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	ReadKeyspaceSnapshotActorState(Reference<BackupContainerFileSystem> const& bc,KeyspaceSnapshotFile const& snapshot) 
															#line 43 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 43 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 43 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   snapshot(snapshot)
															#line 60 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this));

	}
	~ReadKeyspaceSnapshotActorState() 
	{
		fdb_probe_actor_destroy("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 49 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<std::vector<RangeFile>> __when_expr_0 = bc->listRangeFiles(snapshot.beginVersion, snapshot.endVersion);
															#line 49 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 1;
															#line 49 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadKeyspaceSnapshotActor, 0, std::vector<RangeFile> >*>(static_cast<ReadKeyspaceSnapshotActor*>(this)));
															#line 82 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadKeyspaceSnapshotActorState();
		static_cast<ReadKeyspaceSnapshotActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<RangeFile> const& files,int loopDepth) 
	{
															#line 50 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		rangeIndex = std::map<std::string, RangeFile>();
															#line 51 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto& f : files ) {
															#line 52 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			rangeIndex[f.fileName] = std::move(f);
															#line 109 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 56 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_1 = bc->readFile(snapshot.fileName);
															#line 56 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 115 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 2;
															#line 56 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >*>(static_cast<ReadKeyspaceSnapshotActor*>(this)));
															#line 120 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<RangeFile> && files,int loopDepth) 
	{
															#line 50 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		rangeIndex = std::map<std::string, RangeFile>();
															#line 51 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto& f : files ) {
															#line 52 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			rangeIndex[f.fileName] = std::move(f);
															#line 133 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 56 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_1 = bc->readFile(snapshot.fileName);
															#line 56 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 139 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 2;
															#line 56 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >*>(static_cast<ReadKeyspaceSnapshotActor*>(this)));
															#line 144 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<RangeFile> const& files,int loopDepth) 
	{
		loopDepth = a_body1cont1(files, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<RangeFile> && files,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(files), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state > 0) static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 0;
		static_cast<ReadKeyspaceSnapshotActor*>(this)->ActorCallback< ReadKeyspaceSnapshotActor, 0, std::vector<RangeFile> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadKeyspaceSnapshotActor, 0, std::vector<RangeFile> >*,std::vector<RangeFile> const& value) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadKeyspaceSnapshotActor, 0, std::vector<RangeFile> >*,std::vector<RangeFile> && value) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadKeyspaceSnapshotActor, 0, std::vector<RangeFile> >*,Error err) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<int64_t> __when_expr_2 = f->size();
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 230 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 3;
															#line 57 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadKeyspaceSnapshotActor, 2, int64_t >*>(static_cast<ReadKeyspaceSnapshotActor*>(this)));
															#line 235 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Reference<IAsyncFile> const& __f,int loopDepth) 
	{
															#line 56 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		f = __f;
															#line 244 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<IAsyncFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state > 0) static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 0;
		static_cast<ReadKeyspaceSnapshotActor*>(this)->ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int64_t const& size,int loopDepth) 
	{
															#line 58 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		buf = makeString(size);
															#line 59 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(f->read(mutateString(buf), buf.size(), 0));
															#line 59 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 327 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 4;
															#line 59 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >*>(static_cast<ReadKeyspaceSnapshotActor*>(this)));
															#line 332 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(int64_t && size,int loopDepth) 
	{
															#line 58 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		buf = makeString(size);
															#line 59 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(f->read(mutateString(buf), buf.size(), 0));
															#line 59 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 345 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 4;
															#line 59 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >*>(static_cast<ReadKeyspaceSnapshotActor*>(this)));
															#line 350 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(int64_t const& size,int loopDepth) 
	{
		loopDepth = a_body1cont4(size, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t && size,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(size), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state > 0) static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 0;
		static_cast<ReadKeyspaceSnapshotActor*>(this)->ActorCallback< ReadKeyspaceSnapshotActor, 2, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< ReadKeyspaceSnapshotActor, 2, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadKeyspaceSnapshotActor, 2, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadKeyspaceSnapshotActor, 2, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 60 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		json_spirit::mValue json;
															#line 61 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!json_spirit::read_string(buf.toString(), json))
															#line 436 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 62 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			fprintf(stderr, "ERROR: Failed to read data. Verify that backup and restore encryption keys match (if provided) or " "the data is corrupted.\n");
															#line 65 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_error(), loopDepth);
															#line 442 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 68 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		JSONDoc doc(json);
															#line 69 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		Version v;
															#line 70 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!doc.tryGet("beginVersion", v) || v != snapshot.beginVersion)
															#line 450 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 71 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 454 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 72 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!doc.tryGet("endVersion", v) || v != snapshot.endVersion)
															#line 458 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 73 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 462 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 75 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		json_spirit::mValue& filesArray = doc.create("files");
															#line 76 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (filesArray.type() != json_spirit::array_type)
															#line 468 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 472 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 79 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::vector<RangeFile> results;
															#line 80 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int missing = 0;
															#line 82 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto const& fileValue : filesArray.get_array() ) {
															#line 83 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (fileValue.type() != json_spirit::str_type)
															#line 482 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 84 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 486 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
															#line 87 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			auto i = rangeIndex.find(fileValue.get_str());
															#line 88 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (i == rangeIndex.end())
															#line 492 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 89 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent(SevError, "FileRestoreMissingRangeFile") .detail("URL", bc->getURL()) .detail("File", fileValue.get_str());
															#line 93 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				++missing;
															#line 498 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
															#line 97 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (missing == 0)
															#line 502 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 98 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				results.push_back(i->second);
															#line 506 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 102 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (missing > 0)
															#line 511 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 103 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevError, "FileRestoreMissingRangeFileSummary") .detail("URL", bc->getURL()) .detail("Count", missing);
															#line 107 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_missing_data(), loopDepth);
															#line 517 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::map<std::string, KeyRange> fileKeyRanges;
															#line 112 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		JSONDoc ranges = doc.subDoc("keyRanges");
															#line 113 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto i : ranges.obj() ) {
															#line 114 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			const std::string& filename = i.first;
															#line 115 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			JSONDoc fields(i.second);
															#line 116 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::string begin, end;
															#line 117 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (fields.tryGet("beginKey", begin) && fields.tryGet("endKey", end))
															#line 533 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 118 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent("ManifestFields") .detail("File", filename) .detail("Begin", printable(StringRef(begin))) .detail("End", printable(StringRef(end)));
															#line 122 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				fileKeyRanges.emplace(filename, KeyRange(KeyRangeRef(StringRef(begin), StringRef(end))));
															#line 539 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
			else
			{
															#line 124 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent("MalFormattedManifest").detail("Key", filename);
															#line 125 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 547 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 129 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<ReadKeyspaceSnapshotActor*>(this)->SAV<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>>::futures) { (void)(std::make_pair(results, fileKeyRanges)); this->~ReadKeyspaceSnapshotActorState(); static_cast<ReadKeyspaceSnapshotActor*>(this)->destroy(); return 0; }
															#line 552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<ReadKeyspaceSnapshotActor*>(this)->SAV< std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >::value()) std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>(std::make_pair(results, fileKeyRanges));
		this->~ReadKeyspaceSnapshotActorState();
		static_cast<ReadKeyspaceSnapshotActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 60 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		json_spirit::mValue json;
															#line 61 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!json_spirit::read_string(buf.toString(), json))
															#line 566 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 62 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			fprintf(stderr, "ERROR: Failed to read data. Verify that backup and restore encryption keys match (if provided) or " "the data is corrupted.\n");
															#line 65 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_error(), loopDepth);
															#line 572 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 68 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		JSONDoc doc(json);
															#line 69 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		Version v;
															#line 70 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!doc.tryGet("beginVersion", v) || v != snapshot.beginVersion)
															#line 580 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 71 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 584 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 72 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!doc.tryGet("endVersion", v) || v != snapshot.endVersion)
															#line 588 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 73 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 592 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 75 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		json_spirit::mValue& filesArray = doc.create("files");
															#line 76 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (filesArray.type() != json_spirit::array_type)
															#line 598 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 77 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 602 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 79 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::vector<RangeFile> results;
															#line 80 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int missing = 0;
															#line 82 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto const& fileValue : filesArray.get_array() ) {
															#line 83 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (fileValue.type() != json_spirit::str_type)
															#line 612 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 84 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 616 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
															#line 87 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			auto i = rangeIndex.find(fileValue.get_str());
															#line 88 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (i == rangeIndex.end())
															#line 622 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 89 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent(SevError, "FileRestoreMissingRangeFile") .detail("URL", bc->getURL()) .detail("File", fileValue.get_str());
															#line 93 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				++missing;
															#line 628 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
															#line 97 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (missing == 0)
															#line 632 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 98 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				results.push_back(i->second);
															#line 636 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 102 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (missing > 0)
															#line 641 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 103 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevError, "FileRestoreMissingRangeFileSummary") .detail("URL", bc->getURL()) .detail("Count", missing);
															#line 107 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_missing_data(), loopDepth);
															#line 647 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::map<std::string, KeyRange> fileKeyRanges;
															#line 112 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		JSONDoc ranges = doc.subDoc("keyRanges");
															#line 113 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto i : ranges.obj() ) {
															#line 114 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			const std::string& filename = i.first;
															#line 115 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			JSONDoc fields(i.second);
															#line 116 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::string begin, end;
															#line 117 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (fields.tryGet("beginKey", begin) && fields.tryGet("endKey", end))
															#line 663 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 118 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent("ManifestFields") .detail("File", filename) .detail("Begin", printable(StringRef(begin))) .detail("End", printable(StringRef(end)));
															#line 122 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				fileKeyRanges.emplace(filename, KeyRange(KeyRangeRef(StringRef(begin), StringRef(end))));
															#line 669 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
			else
			{
															#line 124 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent("MalFormattedManifest").detail("Key", filename);
															#line 125 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 677 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 129 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<ReadKeyspaceSnapshotActor*>(this)->SAV<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>>::futures) { (void)(std::make_pair(results, fileKeyRanges)); this->~ReadKeyspaceSnapshotActorState(); static_cast<ReadKeyspaceSnapshotActor*>(this)->destroy(); return 0; }
															#line 682 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<ReadKeyspaceSnapshotActor*>(this)->SAV< std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >::value()) std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>(std::make_pair(results, fileKeyRanges));
		this->~ReadKeyspaceSnapshotActorState();
		static_cast<ReadKeyspaceSnapshotActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state > 0) static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 0;
		static_cast<ReadKeyspaceSnapshotActor*>(this)->ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 43 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 43 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	KeyspaceSnapshotFile snapshot;
															#line 50 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::map<std::string, RangeFile> rangeIndex;
															#line 56 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IAsyncFile> f;
															#line 58 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Standalone<StringRef> buf;
															#line 775 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readKeyspaceSnapshot()
															#line 43 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class ReadKeyspaceSnapshotActor final : public Actor<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>>, public ActorCallback< ReadKeyspaceSnapshotActor, 0, std::vector<RangeFile> >, public ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >, public ActorCallback< ReadKeyspaceSnapshotActor, 2, int64_t >, public ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >, public FastAllocated<ReadKeyspaceSnapshotActor>, public ReadKeyspaceSnapshotActorState<ReadKeyspaceSnapshotActor> {
															#line 780 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadKeyspaceSnapshotActor>::operator new;
	using FastAllocated<ReadKeyspaceSnapshotActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18017624235996843008UL, 14856201259959721216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadKeyspaceSnapshotActor, 0, std::vector<RangeFile> >;
friend struct ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >;
friend struct ActorCallback< ReadKeyspaceSnapshotActor, 2, int64_t >;
friend struct ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >;
															#line 43 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	ReadKeyspaceSnapshotActor(Reference<BackupContainerFileSystem> const& bc,KeyspaceSnapshotFile const& snapshot) 
															#line 800 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>>(),
		   ReadKeyspaceSnapshotActorState<ReadKeyspaceSnapshotActor>(bc, snapshot),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10202581819243385856UL, 520466022394986240UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readKeyspaceSnapshot");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadKeyspaceSnapshotActor, 0, std::vector<RangeFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadKeyspaceSnapshotActor, 2, int64_t >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 43 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>> readKeyspaceSnapshot( Reference<BackupContainerFileSystem> const& bc, KeyspaceSnapshotFile const& snapshot ) {
															#line 43 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>>(new ReadKeyspaceSnapshotActor(bc, snapshot));
															#line 835 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 131 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

	// Backup log types
	static constexpr Version NON_PARTITIONED_MUTATION_LOG = 0;
	static constexpr Version PARTITIONED_MUTATION_LOG = 1;

	// Find what should be the filename of a path by finding whatever is after the last forward or backward slash, or
	// failing to find those, the whole string.
	static std::string fileNameOnly(const std::string& path) {
		// Find the last forward slash position, defaulting to 0 if not found
		int pos = path.find_last_of('/');
		if (pos == std::string::npos) {
			pos = 0;
		}
		// Find the last backward slash position after pos, and update pos if found
		int b = path.find_last_of('\\', pos);
		if (b != std::string::npos) {
			pos = b;
		}
		return path.substr(pos + 1);
	}

	static bool pathToRangeFile(RangeFile& out, const std::string& path, int64_t size) {
		std::string name = fileNameOnly(path);
		RangeFile f;
		f.fileName = path;
		f.fileSize = size;
		int len;
		if (sscanf(name.c_str(), "range,%" SCNd64 ",%*[^,],%u%n", &f.version, &f.blockSize, &len) == 2 &&
		    len == name.size()) {
			out = f;
			return true;
		}
		return false;
	}

																#line 874 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via writeKeyspaceSnapshotFile()
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class WriteKeyspaceSnapshotFileActor>
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteKeyspaceSnapshotFileActorState {
															#line 880 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteKeyspaceSnapshotFileActorState(Reference<BackupContainerFileSystem> const& bc,std::vector<std::string> const& fileNames,std::vector<std::pair<Key, Key>> const& beginEndKeys,int64_t const& totalBytes,IncludeKeyRangeMap const& includeKeyRangeMap,Optional<SnapshotMetadata> const& metadata) 
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   fileNames(fileNames),
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   beginEndKeys(beginEndKeys),
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   totalBytes(totalBytes),
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   includeKeyRangeMap(includeKeyRangeMap),
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   metadata(metadata),
															#line 172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   minVer(std::numeric_limits<Version>::max()),
															#line 173 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   maxVer(0),
															#line 174 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   rf(),
															#line 175 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   fileArray(),
															#line 176 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   isBulkDump(metadata.present() && metadata.get().isBulkDump())
															#line 907 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this));

	}
	~WriteKeyspaceSnapshotFileActorState() 
	{
		fdb_probe_actor_destroy("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 178 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (isBulkDump)
															#line 922 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 180 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				ASSERT(metadata.get().snapshotVersion != invalidVersion);
															#line 181 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				minVer = metadata.get().snapshotVersion;
															#line 182 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				maxVer = metadata.get().snapshotVersion;
															#line 930 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				loopDepth = a_body1cont1(loopDepth);
			}
			else
			{
															#line 186 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				ASSERT(!fileNames.empty() && fileNames.size() == beginEndKeys.size());
															#line 189 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				RangeForbody1Iterator0 = std::begin(fileNames);
															#line 939 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKeyspaceSnapshotFileActorState();
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 202 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		json = json_spirit::mValue();
															#line 203 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		doc = JSONDoc(json);
															#line 205 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		doc.create("files") = std::move(fileArray);
															#line 206 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		doc.create("totalBytes") = totalBytes;
															#line 207 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		doc.create("beginVersion") = minVer;
															#line 208 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		doc.create("endVersion") = maxVer;
															#line 210 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (isBulkDump)
															#line 975 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 212 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			doc.create("snapshotType") = metadata.get().snapshotType;
															#line 213 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			doc.create("bulkDumpJobId") = metadata.get().bulkDumpJobId;
															#line 214 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			doc.create("totalKeys") = metadata.get().totalKeys;
															#line 217 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			json_spirit::mArray rangesArray;
															#line 218 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			for( const auto& range : beginEndKeys ) {
															#line 219 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				json_spirit::mObject rangeObj;
															#line 220 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				rangeObj["begin"] = range.first.toString();
															#line 221 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				rangeObj["end"] = range.second.toString();
															#line 222 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				rangesArray.push_back(rangeObj);
															#line 995 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
															#line 224 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			doc.create("ranges") = rangesArray;
															#line 999 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
		else
		{
															#line 225 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (includeKeyRangeMap)
															#line 1005 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 226 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				auto ranges = doc.subDoc("keyRanges");
															#line 227 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				for(int i = 0;i < beginEndKeys.size();i++) {
															#line 228 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					auto fileDoc = ranges.subDoc(fileNames[i], false);
															#line 229 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					fileDoc.create("beginKey") = beginEndKeys[i].first.toString();
															#line 230 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					fileDoc.create("endKey") = beginEndKeys[i].second.toString();
															#line 1017 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
			}
		}
															#line 234 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 234 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1025 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 2;
															#line 234 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKeyspaceSnapshotFileActor, 1, Void >*>(static_cast<WriteKeyspaceSnapshotFileActor*>(this)));
															#line 1030 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 189 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(RangeForbody1Iterator0 != std::end(fileNames)))
															#line 1052 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 189 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		const auto& f = *RangeForbody1Iterator0;
															#line 1058 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 190 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (pathToRangeFile(rf, f, 0))
															#line 1062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 191 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				fileArray.push_back(f);
															#line 192 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (rf.version < minVer)
															#line 1068 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 193 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					minVer = rf.version;
															#line 1072 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
															#line 194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (rf.version > maxVer)
															#line 1076 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 195 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					maxVer = rf.version;
															#line 1080 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 197 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(restore_unknown_file_type(), std::max(0, loopDepth - 1));
															#line 1087 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
															#line 198 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = yield();
															#line 198 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1093 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 1;
															#line 198 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKeyspaceSnapshotFileActor, 0, Void >*>(static_cast<WriteKeyspaceSnapshotFileActor*>(this)));
															#line 1098 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 189 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++RangeForbody1Iterator0;
															#line 1121 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->ActorCallback< WriteKeyspaceSnapshotFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKeyspaceSnapshotFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 235 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		docString = json_spirit::write_string(json);
															#line 237 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IBackupFile>> __when_expr_2 = bc->writeFile(format("snapshots/snapshot,%lld,%lld,%lld", minVer, maxVer, totalBytes));
															#line 237 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1221 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 3;
															#line 237 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >*>(static_cast<WriteKeyspaceSnapshotFileActor*>(this)));
															#line 1226 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 235 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		docString = json_spirit::write_string(json);
															#line 237 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IBackupFile>> __when_expr_2 = bc->writeFile(format("snapshots/snapshot,%lld,%lld,%lld", minVer, maxVer, totalBytes));
															#line 237 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1239 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 3;
															#line 237 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >*>(static_cast<WriteKeyspaceSnapshotFileActor*>(this)));
															#line 1244 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->ActorCallback< WriteKeyspaceSnapshotFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKeyspaceSnapshotFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 239 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_3 = f->append(docString.data(), docString.size());
															#line 239 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1330 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont10when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 4;
															#line 239 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteKeyspaceSnapshotFileActor, 3, Void >*>(static_cast<WriteKeyspaceSnapshotFileActor*>(this)));
															#line 1335 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Reference<IBackupFile> const& __f,int loopDepth) 
	{
															#line 237 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		f = __f;
															#line 1344 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Reference<IBackupFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 240 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_4 = f->finish();
															#line 240 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1425 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 5;
															#line 240 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >*>(static_cast<WriteKeyspaceSnapshotFileActor*>(this)));
															#line 1430 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 240 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_4 = f->finish();
															#line 240 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1441 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 5;
															#line 240 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >*>(static_cast<WriteKeyspaceSnapshotFileActor*>(this)));
															#line 1446 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->ActorCallback< WriteKeyspaceSnapshotFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WriteKeyspaceSnapshotFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10cont2(Void const& _,int loopDepth) 
	{
															#line 242 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<WriteKeyspaceSnapshotFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKeyspaceSnapshotFileActorState(); static_cast<WriteKeyspaceSnapshotFileActor*>(this)->destroy(); return 0; }
															#line 1530 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<WriteKeyspaceSnapshotFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKeyspaceSnapshotFileActorState();
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont2(Void && _,int loopDepth) 
	{
															#line 242 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<WriteKeyspaceSnapshotFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKeyspaceSnapshotFileActorState(); static_cast<WriteKeyspaceSnapshotFileActor*>(this)->destroy(); return 0; }
															#line 1542 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<WriteKeyspaceSnapshotFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKeyspaceSnapshotFileActorState();
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<std::string> fileNames;
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<std::pair<Key, Key>> beginEndKeys;
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int64_t totalBytes;
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	IncludeKeyRangeMap includeKeyRangeMap;
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<SnapshotMetadata> metadata;
															#line 172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version minVer;
															#line 173 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version maxVer;
															#line 174 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	RangeFile rf;
															#line 175 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	json_spirit::mArray fileArray;
															#line 176 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	bool isBulkDump;
															#line 189 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	decltype(std::begin(std::declval<std::vector<std::string>>())) RangeForbody1Iterator0;
															#line 202 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	json_spirit::mValue json;
															#line 203 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	JSONDoc doc;
															#line 235 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string docString;
															#line 237 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> f;
															#line 1657 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeKeyspaceSnapshotFile()
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteKeyspaceSnapshotFileActor final : public Actor<Void>, public ActorCallback< WriteKeyspaceSnapshotFileActor, 0, Void >, public ActorCallback< WriteKeyspaceSnapshotFileActor, 1, Void >, public ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >, public ActorCallback< WriteKeyspaceSnapshotFileActor, 3, Void >, public ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >, public FastAllocated<WriteKeyspaceSnapshotFileActor>, public WriteKeyspaceSnapshotFileActorState<WriteKeyspaceSnapshotFileActor> {
															#line 1662 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteKeyspaceSnapshotFileActor>::operator new;
	using FastAllocated<WriteKeyspaceSnapshotFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13696161362013781504UL, 7000521801619716608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKeyspaceSnapshotFileActor, 0, Void >;
friend struct ActorCallback< WriteKeyspaceSnapshotFileActor, 1, Void >;
friend struct ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >;
friend struct ActorCallback< WriteKeyspaceSnapshotFileActor, 3, Void >;
friend struct ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >;
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteKeyspaceSnapshotFileActor(Reference<BackupContainerFileSystem> const& bc,std::vector<std::string> const& fileNames,std::vector<std::pair<Key, Key>> const& beginEndKeys,int64_t const& totalBytes,IncludeKeyRangeMap const& includeKeyRangeMap,Optional<SnapshotMetadata> const& metadata) 
															#line 1683 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteKeyspaceSnapshotFileActorState<WriteKeyspaceSnapshotFileActor>(bc, fileNames, beginEndKeys, totalBytes, includeKeyRangeMap, metadata),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15578544106502796800UL, 7743257832792106496UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKeyspaceSnapshotFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKeyspaceSnapshotFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKeyspaceSnapshotFileActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WriteKeyspaceSnapshotFileActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Void> writeKeyspaceSnapshotFile( Reference<BackupContainerFileSystem> const& bc, std::vector<std::string> const& fileNames, std::vector<std::pair<Key, Key>> const& beginEndKeys, int64_t const& totalBytes, IncludeKeyRangeMap const& includeKeyRangeMap, Optional<SnapshotMetadata> const& metadata ) {
															#line 166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new WriteKeyspaceSnapshotFileActor(bc, fileNames, beginEndKeys, totalBytes, includeKeyRangeMap, metadata));
															#line 1719 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 244 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

																#line 1724 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via dumpFileList()
															#line 245 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class DumpFileListActor>
															#line 245 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class DumpFileListActorState {
															#line 1730 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 245 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	DumpFileListActorState(Reference<BackupContainerFileSystem> const& bc,Version const& begin,Version const& end) 
															#line 245 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 245 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 245 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   begin(begin),
															#line 245 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   end(end),
															#line 248 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   fRanges(bc->listRangeFiles(begin, end)),
															#line 249 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   fSnapshots(bc->listKeyspaceSnapshots(begin, end)),
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   logs(),
															#line 251 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   pLogs()
															#line 1749 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("dumpFileList", reinterpret_cast<unsigned long>(this));

	}
	~DumpFileListActorState() 
	{
		fdb_probe_actor_destroy("dumpFileList", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 253 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(fRanges) && success(fSnapshots) && store(logs, bc->listLogFiles(begin, end, false)) && store(pLogs, bc->listLogFiles(begin, end, true));
															#line 253 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<DumpFileListActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1766 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DumpFileListActor*>(this)->actor_wait_state = 1;
															#line 253 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DumpFileListActor, 0, Void >*>(static_cast<DumpFileListActor*>(this)));
															#line 1771 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DumpFileListActorState();
		static_cast<DumpFileListActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 255 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs.insert(logs.end(), std::make_move_iterator(pLogs.begin()), std::make_move_iterator(pLogs.end()));
															#line 257 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<DumpFileListActor*>(this)->SAV<BackupFileList>::futures) { (void)(BackupFileList({ fRanges.get(), std::move(logs), fSnapshots.get() })); this->~DumpFileListActorState(); static_cast<DumpFileListActor*>(this)->destroy(); return 0; }
															#line 1796 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<DumpFileListActor*>(this)->SAV< BackupFileList >::value()) BackupFileList(BackupFileList({ fRanges.get(), std::move(logs), fSnapshots.get() }));
		this->~DumpFileListActorState();
		static_cast<DumpFileListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 255 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs.insert(logs.end(), std::make_move_iterator(pLogs.begin()), std::make_move_iterator(pLogs.end()));
															#line 257 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<DumpFileListActor*>(this)->SAV<BackupFileList>::futures) { (void)(BackupFileList({ fRanges.get(), std::move(logs), fSnapshots.get() })); this->~DumpFileListActorState(); static_cast<DumpFileListActor*>(this)->destroy(); return 0; }
															#line 1810 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<DumpFileListActor*>(this)->SAV< BackupFileList >::value()) BackupFileList(BackupFileList({ fRanges.get(), std::move(logs), fSnapshots.get() }));
		this->~DumpFileListActorState();
		static_cast<DumpFileListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DumpFileListActor*>(this)->actor_wait_state > 0) static_cast<DumpFileListActor*>(this)->actor_wait_state = 0;
		static_cast<DumpFileListActor*>(this)->ActorCallback< DumpFileListActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpFileListActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpFileList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpFileListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpFileList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DumpFileListActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpFileList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpFileListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpFileList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DumpFileListActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpFileList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpFileListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpFileList", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 245 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 245 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version begin;
															#line 245 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version end;
															#line 248 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Future<std::vector<RangeFile>> fRanges;
															#line 249 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Future<std::vector<KeyspaceSnapshotFile>> fSnapshots;
															#line 250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> logs;
															#line 251 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> pLogs;
															#line 1907 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via dumpFileList()
															#line 245 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class DumpFileListActor final : public Actor<BackupFileList>, public ActorCallback< DumpFileListActor, 0, Void >, public FastAllocated<DumpFileListActor>, public DumpFileListActorState<DumpFileListActor> {
															#line 1912 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<DumpFileListActor>::operator new;
	using FastAllocated<DumpFileListActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12907746697656923392UL, 1446546057809967104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<BackupFileList>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DumpFileListActor, 0, Void >;
															#line 245 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	DumpFileListActor(Reference<BackupContainerFileSystem> const& bc,Version const& begin,Version const& end) 
															#line 1929 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<BackupFileList>(),
		   DumpFileListActorState<DumpFileListActor>(bc, begin, end),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dumpFileList", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18146546089268790784UL, 16053391606809997568UL);
		ActorExecutionContextHelper __helper(static_cast<DumpFileListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dumpFileList");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dumpFileList", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DumpFileListActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 245 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<BackupFileList> dumpFileList( Reference<BackupContainerFileSystem> const& bc, Version const& begin, Version const& end ) {
															#line 245 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<BackupFileList>(new DumpFileListActor(bc, begin, end));
															#line 1961 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 259 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

	static Version resolveRelativeVersion(Optional<Version> max, Version v, const char* name, Error e) {
		if (v == invalidVersion) {
			TraceEvent(SevError, "BackupExpireInvalidVersion").detail(name, v);
			throw e;
		}
		if (v < 0) {
			if (!max.present()) {
				TraceEvent(SevError, "BackupExpireCannotResolveRelativeVersion").detail(name, v);
				throw e;
			}
			v += max.get();
		}
		return v;
	}

	// For a list of log files specified by their indices (of the same tag),
	// returns if they are continuous in the range [begin, end]. If "tags" is not
	// nullptr, then it will be populated with [begin, end] -> tags, where next
	// pair's begin <= previous pair's end + 1. On return, the last pair's end
	// version (inclusive) gives the continuous range from begin.
	static bool isContinuous(const std::vector<LogFile>& files,
	                         const std::vector<int>& indices,
	                         Version begin,
	                         Version end,
	                         std::map<std::pair<Version, Version>, int>* tags) {
		Version lastBegin = invalidVersion;
		Version lastEnd = invalidVersion;
		int lastTags = -1;

		ASSERT(tags == nullptr || tags->empty());
		for (int idx : indices) {
			const LogFile& file = files[idx];
			if (lastEnd == invalidVersion) {
				if (file.beginVersion > begin) {
					// the first version of the first file must be smaller or equal to the desired beginVersion
					return false;
				}
				if (file.endVersion > begin) {
					lastBegin = begin;
					lastTags = file.totalTags;
				} else {
					// if endVerison of file is smaller than desired beginVersion, then do not include this file
					continue;
				}
			} else if (lastEnd < file.beginVersion) {
				if (tags != nullptr) {
					tags->emplace(std::make_pair(lastBegin, lastEnd - 1), lastTags);
				}
				return false;
			}

			if (lastTags != file.totalTags) {
				if (tags != nullptr) {
					tags->emplace(std::make_pair(lastBegin, file.beginVersion - 1), lastTags);
				}
				lastBegin = file.beginVersion;
				lastTags = file.totalTags;
			}
			lastEnd = file.endVersion;
			if (lastEnd > end)
				break;
		}
		if (tags != nullptr && lastBegin != invalidVersion) {
			tags->emplace(std::make_pair(lastBegin, std::min(end, lastEnd - 1)), lastTags);
		}
		return lastBegin != invalidVersion && lastEnd > end;
	}

	// Returns the end version such that [begin, end] is continuous.
	// "logs" should be already sorted.
	static Version getPartitionedLogsContinuousEndVersion(const std::vector<LogFile>& logs, Version begin) {
		Version end = 0;

		std::map<int, std::vector<int>> tagIndices; // tagId -> indices in files
		for (int i = 0; i < logs.size(); i++) {
			ASSERT_GE(logs[i].tagId, 0);
			ASSERT_LT(logs[i].tagId, logs[i].totalTags);
			auto& indices = tagIndices[logs[i].tagId];
			// filter out if indices.back() is subset of files[i] or vice versa
			if (!indices.empty()) {
				if (logs[indices.back()].isSubset(logs[i])) {
					ASSERT_LE(logs[indices.back()].fileSize, logs[i].fileSize);
					indices.back() = i;
				} else if (!logs[i].isSubset(logs[indices.back()])) {
					indices.push_back(i);
				}
			} else {
				indices.push_back(i);
			}
			end = std::max(end, logs[i].endVersion - 1);
		}
		TraceEvent("ContinuousLogEnd").detail("Begin", begin).detail("InitVersion", end);

		// check partition 0 is continuous in [begin, end] and create a map of ranges to partitions
		std::map<std::pair<Version, Version>, int> tags; // range [start, end] -> partitions
		isContinuous(logs, tagIndices[0], begin, end, &tags);
		if (tags.empty() || end <= begin)
			return 0;
		end = std::min(end, tags.rbegin()->first.second);
		TraceEvent("ContinuousLogEnd").detail("Partition", 0).detail("EndVersion", end).detail("Begin", begin);

		// for each range in tags, check all partitions from 1 are continuous
		Version lastEnd = begin;
		for (const auto& [beginEnd, count] : tags) {
			Version tagEnd = beginEnd.second; // This range's minimum continuous partition version
			for (int i = 1; i < count; i++) {
				std::map<std::pair<Version, Version>, int> rangeTags;
				isContinuous(logs, tagIndices[i], beginEnd.first, beginEnd.second, &rangeTags);
				tagEnd = rangeTags.empty() ? 0 : std::min(tagEnd, rangeTags.rbegin()->first.second);
				TraceEvent("ContinuousLogEnd")
				    .detail("Partition", i)
				    .detail("EndVersion", tagEnd)
				    .detail("RangeBegin", beginEnd.first)
				    .detail("RangeEnd", beginEnd.second);
				if (tagEnd == 0)
					return lastEnd == begin ? 0 : lastEnd;
			}
			if (tagEnd < beginEnd.second) {
				return tagEnd;
			}
			lastEnd = beginEnd.second;
		}

		return end;
	}

	// Analyze partitioned logs and set contiguousLogEnd for "desc" if larger
	// than the "scanBegin" version.
	static void updatePartitionedLogsContinuousEnd(BackupDescription* desc,
	                                               const std::vector<LogFile>& logs,
	                                               const Version scanBegin,
	                                               const Version scanEnd) {
		if (logs.empty())
			return;

		Version snapshotBeginVersion = desc->snapshots.size() > 0 ? desc->snapshots[0].beginVersion : invalidVersion;
		Version begin = std::max(scanBegin, desc->minLogBegin.get());
		TraceEvent("ContinuousLogEnd")
		    .detail("ScanBegin", scanBegin)
		    .detail("ScanEnd", scanEnd)
		    .detail("Begin", begin)
		    .detail("ContiguousLogEnd", desc->contiguousLogEnd.get());
		for (const auto& file : logs) {
			if (file.beginVersion > begin) {
				if (scanBegin > 0)
					return;

				// scanBegin is 0
				desc->minLogBegin = file.beginVersion;
				begin = file.beginVersion;
			}

			Version ver = getPartitionedLogsContinuousEndVersion(logs, begin);
			if (ver >= desc->contiguousLogEnd.get()) {
				// contiguousLogEnd is not inclusive, so +1 here.
				desc->contiguousLogEnd.get() = ver + 1;
				TraceEvent("UpdateContinuousLogEnd").detail("Version", ver + 1);
				if (ver > snapshotBeginVersion)
					return;
			}
		}
	}

	// Computes the continuous end version for non-partitioned mutation logs up to
	// the "targetVersion". If "outLogs" is not nullptr, it will be updated with
	// continuous log files. "*end" is updated with the continuous end version.
	static void computeRestoreEndVersion(const std::vector<LogFile>& logs,
	                                     std::vector<LogFile>* outLogs,
	                                     Version* end,
	                                     Version targetVersion) {
		auto i = logs.begin();

		// Add logs to restorable logs set until continuity is broken OR we reach targetVersion
		while (i != logs.end()) {
			if (i->beginVersion > *end || i->beginVersion > targetVersion)
				break;

			// If the next link in the log chain is found, update the end
			if (i->beginVersion == *end) {
				if (outLogs != nullptr)
					outLogs->push_back(*i);
				*end = i->endVersion;
			}
			++i;
		}
	}

	// Checks if list of sorted logfiles have the logs from snapshotBeginVersion to snapshotEndversion.
	// Which means the sorted log files(have beginVersion and endVersion) should cover
	// all the versions between snapshotBegingVersion and snapshotEndversion.
	// Note: logs should be pre-sorted according to version order.
	static bool hasContinuousLogsForSnapshot(const std::vector<LogFile>& logs,
	                                         Version snapshotBeginVersion,
	                                         Version snapshotEndVersion) {
		auto it = logs.begin();

		// find the first mutation log file that covers snapshotBeginVersion
		while (it != logs.end()) {
			if (it->beginVersion <= snapshotBeginVersion && it->endVersion > snapshotBeginVersion)
				break;
			++it;
		}

		// no log find found covering snaphostBeginVersion, return false
		if (it == logs.end())
			return false;

		// If current log entry(it), covers the entire snapshot, return true
		if (it->endVersion > snapshotEndVersion)
			return true;

		// Iterate over the next logs, check if they are continuous and if
		// the log file is covering the snapshot.
		Version prevEnd = it->endVersion;
		++it;

		while (it != logs.end()) {
			if (it->beginVersion == prevEnd &&
			    it->endVersion > snapshotEndVersion) // continuous logs until snapshot is covered
				return true;
			else if (it->beginVersion != prevEnd) // not continuous logs
				return false;

			prevEnd = it->endVersion;
			++it;
		} // comes out if the logs are not found until snapshotEndVersion.

		return prevEnd > snapshotEndVersion;
	}

	// Find the continuous log end version starting from beginVersion in the
	// given list of sorted logfiles.
	// Note: logs should be pre-sorted according to version order.
	static Version findContinuousLogEnd(const std::vector<LogFile>& logs, Version beginVersion) {
		auto it = logs.begin();

		// find the first mutation log file that covers beginVersion
		while (it != logs.end()) {
			if (it->beginVersion <= beginVersion && it->endVersion > beginVersion)
				break;
			++it;
		}

		// no log find found covering beginVersion, return invalidVersion
		if (it == logs.end())
			return invalidVersion;

		// Iterate over the next logs, check if they are continuous
		Version prevEnd = it->endVersion;
		++it;

		while (it != logs.end()) {
			if (it->beginVersion != prevEnd) // not continuous logs
				return prevEnd;

			prevEnd = it->endVersion;
			++it;
		} // out of logs.

		return prevEnd;
	}

																#line 2228 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via describeBackup()
															#line 522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class DescribeBackupActor>
															#line 522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class DescribeBackupActorState {
															#line 2234 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	DescribeBackupActorState(Reference<BackupContainerFileSystem> const& bc,bool const& deepScan,Version const& logStartVersionOverride) 
															#line 522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   deepScan(deepScan),
															#line 522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   logStartVersionOverride(logStartVersionOverride),
															#line 525 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   desc()
															#line 2247 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("describeBackup", reinterpret_cast<unsigned long>(this));

	}
	~DescribeBackupActorState() 
	{
		fdb_probe_actor_destroy("describeBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 526 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.url = bc->getURL();
															#line 527 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.proxy = bc->getProxy();
															#line 529 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent("BackupContainerDescribe1") .detail("URL", bc->getURL()) .detail("LogStartVersionOverride", logStartVersionOverride) .detail("DeepScan", deepScan);
															#line 534 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<bool> __when_expr_0 = bc->exists();
															#line 534 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2270 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DescribeBackupActor*>(this)->actor_wait_state = 1;
															#line 534 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 0, bool >*>(static_cast<DescribeBackupActor*>(this)));
															#line 2275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DescribeBackupActorState();
		static_cast<DescribeBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& e,int loopDepth) 
	{
															#line 535 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!e)
															#line 2298 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 536 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "BackupContainerDoesNotExist").detail("URL", bc->getURL());
															#line 537 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(backup_does_not_exist(), loopDepth);
															#line 2304 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 543 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (logStartVersionOverride != invalidVersion && logStartVersionOverride < 0)
															#line 2308 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 544 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<BackupDescription> __when_expr_1 = bc->describeBackup(false, invalidVersion);
															#line 544 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2314 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DescribeBackupActor*>(this)->actor_wait_state = 2;
															#line 544 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 1, BackupDescription >*>(static_cast<DescribeBackupActor*>(this)));
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(bool && e,int loopDepth) 
	{
															#line 535 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!e)
															#line 2333 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 536 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "BackupContainerDoesNotExist").detail("URL", bc->getURL());
															#line 537 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(backup_does_not_exist(), loopDepth);
															#line 2339 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 543 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (logStartVersionOverride != invalidVersion && logStartVersionOverride < 0)
															#line 2343 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 544 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<BackupDescription> __when_expr_1 = bc->describeBackup(false, invalidVersion);
															#line 544 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2349 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DescribeBackupActor*>(this)->actor_wait_state = 2;
															#line 544 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 1, BackupDescription >*>(static_cast<DescribeBackupActor*>(this)));
															#line 2354 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(bool const& e,int loopDepth) 
	{
		loopDepth = a_body1cont1(e, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && e,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(e), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state > 0) static_cast<DescribeBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DescribeBackupActor*>(this)->ActorCallback< DescribeBackupActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DescribeBackupActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 550 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaLogBegin = Optional<Version>();
															#line 551 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaLogEnd = Optional<Version>();
															#line 552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaExpiredEnd = Optional<Version>();
															#line 553 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaUnreliableEnd = Optional<Version>();
															#line 554 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaLogType = Optional<Version>();
															#line 555 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		fileLevelEncryption = Optional<Version>();
															#line 557 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::vector<Future<Void>> metaReads;
															#line 558 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaReads.push_back(store(metaExpiredEnd, bc->expiredEndVersion().get()));
															#line 559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaReads.push_back(store(metaUnreliableEnd, bc->unreliableEndVersion().get()));
															#line 560 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaReads.push_back(store(metaLogType, bc->logType().get()));
															#line 561 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaReads.push_back(store(fileLevelEncryption, bc->fileLevelEncryption().get()));
															#line 564 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!deepScan)
															#line 2465 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 565 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaReads.push_back(store(metaLogBegin, bc->logBeginVersion().get()));
															#line 566 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaReads.push_back(store(metaLogEnd, bc->logEndVersion().get()));
															#line 2471 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 569 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(metaReads);
															#line 569 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2477 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DescribeBackupActor*>(this)->actor_wait_state = 3;
															#line 569 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 2, Void >*>(static_cast<DescribeBackupActor*>(this)));
															#line 2482 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(BackupDescription const& tmp,int loopDepth) 
	{
															#line 545 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logStartVersionOverride = resolveRelativeVersion( tmp.maxLogEnd, logStartVersionOverride, "LogStartVersionOverride", invalid_option_value());
															#line 2491 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(BackupDescription && tmp,int loopDepth) 
	{
															#line 545 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logStartVersionOverride = resolveRelativeVersion( tmp.maxLogEnd, logStartVersionOverride, "LogStartVersionOverride", invalid_option_value());
															#line 2500 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(BackupDescription const& tmp,int loopDepth) 
	{
		loopDepth = a_body1cont4(tmp, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(BackupDescription && tmp,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(tmp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state > 0) static_cast<DescribeBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DescribeBackupActor*>(this)->ActorCallback< DescribeBackupActor, 1, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 1, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 1, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DescribeBackupActor, 1, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 571 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent("BackupContainerDescribe2") .detail("URL", bc->getURL()) .detail("LogStartVersionOverride", logStartVersionOverride) .detail("ExpiredEndVersion", metaExpiredEnd.orDefault(invalidVersion)) .detail("UnreliableEndVersion", metaUnreliableEnd.orDefault(invalidVersion)) .detail("LogBeginVersion", metaLogBegin.orDefault(invalidVersion)) .detail("LogEndVersion", metaLogEnd.orDefault(invalidVersion)) .detail("LogType", metaLogType.orDefault(-1));
															#line 582 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (logStartVersionOverride != invalidVersion && metaUnreliableEnd.orDefault(invalidVersion) < logStartVersionOverride)
															#line 2586 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 584 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaUnreliableEnd = logStartVersionOverride;
															#line 2590 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 593 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!metaLogBegin.present() || !metaLogEnd.present() || metaLogEnd.get() <= metaLogBegin.get() || metaLogEnd.get() < metaExpiredEnd.orDefault(invalidVersion) || metaLogEnd.get() < metaUnreliableEnd.orDefault(invalidVersion))
															#line 2594 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 596 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "BackupContainerMetadataInvalid") .detail("URL", bc->getURL()) .detail("ExpiredEndVersion", metaExpiredEnd.orDefault(invalidVersion)) .detail("UnreliableEndVersion", metaUnreliableEnd.orDefault(invalidVersion)) .detail("LogBeginVersion", metaLogBegin.orDefault(invalidVersion)) .detail("LogEndVersion", metaLogEnd.orDefault(invalidVersion));
															#line 603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaLogBegin = Optional<Version>();
															#line 604 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaLogEnd = Optional<Version>();
															#line 2602 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 610 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!metaUnreliableEnd.present() || metaUnreliableEnd.get() < metaExpiredEnd.orDefault(0))
															#line 2606 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 611 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaUnreliableEnd = metaExpiredEnd;
															#line 2610 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 613 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc.unreliableEndVersion = metaUnreliableEnd;
															#line 614 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc.expiredEndVersion = metaExpiredEnd;
															#line 618 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		scanBegin = desc.unreliableEndVersion.orDefault(0);
															#line 619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		scanEnd = std::numeric_limits<Version>::max();
															#line 623 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (metaLogBegin.present() && metaLogEnd.present())
															#line 2622 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 626 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.minLogBegin = std::max(metaLogBegin.get(), desc.unreliableEndVersion.orDefault(0));
															#line 630 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.maxLogEnd = metaLogEnd.get();
															#line 631 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.contiguousLogEnd = desc.maxLogEnd;
															#line 634 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			scanBegin = desc.contiguousLogEnd.get();
															#line 2632 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 637 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs = std::vector<LogFile>();
															#line 638 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		plogs = std::vector<LogFile>();
															#line 639 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent("BackupContainerListFiles").detail("URL", bc->getURL());
															#line 641 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(logs, bc->listLogFiles(scanBegin, scanEnd, false)) && store(plogs, bc->listLogFiles(scanBegin, scanEnd, true)) && store(desc.snapshots, bc->listKeyspaceSnapshots());
															#line 641 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2644 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<DescribeBackupActor*>(this)->actor_wait_state = 4;
															#line 641 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 3, Void >*>(static_cast<DescribeBackupActor*>(this)));
															#line 2649 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 571 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent("BackupContainerDescribe2") .detail("URL", bc->getURL()) .detail("LogStartVersionOverride", logStartVersionOverride) .detail("ExpiredEndVersion", metaExpiredEnd.orDefault(invalidVersion)) .detail("UnreliableEndVersion", metaUnreliableEnd.orDefault(invalidVersion)) .detail("LogBeginVersion", metaLogBegin.orDefault(invalidVersion)) .detail("LogEndVersion", metaLogEnd.orDefault(invalidVersion)) .detail("LogType", metaLogType.orDefault(-1));
															#line 582 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (logStartVersionOverride != invalidVersion && metaUnreliableEnd.orDefault(invalidVersion) < logStartVersionOverride)
															#line 2660 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 584 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaUnreliableEnd = logStartVersionOverride;
															#line 2664 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 593 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!metaLogBegin.present() || !metaLogEnd.present() || metaLogEnd.get() <= metaLogBegin.get() || metaLogEnd.get() < metaExpiredEnd.orDefault(invalidVersion) || metaLogEnd.get() < metaUnreliableEnd.orDefault(invalidVersion))
															#line 2668 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 596 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "BackupContainerMetadataInvalid") .detail("URL", bc->getURL()) .detail("ExpiredEndVersion", metaExpiredEnd.orDefault(invalidVersion)) .detail("UnreliableEndVersion", metaUnreliableEnd.orDefault(invalidVersion)) .detail("LogBeginVersion", metaLogBegin.orDefault(invalidVersion)) .detail("LogEndVersion", metaLogEnd.orDefault(invalidVersion));
															#line 603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaLogBegin = Optional<Version>();
															#line 604 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaLogEnd = Optional<Version>();
															#line 2676 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 610 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!metaUnreliableEnd.present() || metaUnreliableEnd.get() < metaExpiredEnd.orDefault(0))
															#line 2680 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 611 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaUnreliableEnd = metaExpiredEnd;
															#line 2684 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 613 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc.unreliableEndVersion = metaUnreliableEnd;
															#line 614 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc.expiredEndVersion = metaExpiredEnd;
															#line 618 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		scanBegin = desc.unreliableEndVersion.orDefault(0);
															#line 619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		scanEnd = std::numeric_limits<Version>::max();
															#line 623 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (metaLogBegin.present() && metaLogEnd.present())
															#line 2696 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 626 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.minLogBegin = std::max(metaLogBegin.get(), desc.unreliableEndVersion.orDefault(0));
															#line 630 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.maxLogEnd = metaLogEnd.get();
															#line 631 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.contiguousLogEnd = desc.maxLogEnd;
															#line 634 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			scanBegin = desc.contiguousLogEnd.get();
															#line 2706 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 637 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs = std::vector<LogFile>();
															#line 638 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		plogs = std::vector<LogFile>();
															#line 639 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent("BackupContainerListFiles").detail("URL", bc->getURL());
															#line 641 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(logs, bc->listLogFiles(scanBegin, scanEnd, false)) && store(plogs, bc->listLogFiles(scanBegin, scanEnd, true)) && store(desc.snapshots, bc->listKeyspaceSnapshots());
															#line 641 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2718 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<DescribeBackupActor*>(this)->actor_wait_state = 4;
															#line 641 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 3, Void >*>(static_cast<DescribeBackupActor*>(this)));
															#line 2723 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state > 0) static_cast<DescribeBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DescribeBackupActor*>(this)->ActorCallback< DescribeBackupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DescribeBackupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 645 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent("BackupContainerListFiles") .detail("URL", bc->getURL()) .detail("LogFiles", logs.size()) .detail("PLogsFiles", plogs.size()) .detail("Snapshots", desc.snapshots.size());
															#line 651 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (plogs.size() > 0)
															#line 2809 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 652 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.partitioned = true;
															#line 653 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			logs.swap(plogs);
															#line 2815 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
		else
		{
															#line 655 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.partitioned = metaLogType.present() && metaLogType.get() == BackupContainerFileSystemImpl::PARTITIONED_MUTATION_LOG;
															#line 2821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 659 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (fileLevelEncryption.present() && fileLevelEncryption.get() != 0)
															#line 2825 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 660 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.fileLevelEncryption = true;
															#line 2829 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
		else
		{
															#line 662 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.fileLevelEncryption = false;
															#line 2835 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 666 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::sort(logs.begin(), logs.end());
															#line 669 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!logs.empty())
															#line 2841 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 670 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.maxLogEnd = logs.rbegin()->endVersion;
															#line 672 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!desc.contiguousLogEnd.present())
															#line 2847 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 673 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				desc.minLogBegin = logs.begin()->beginVersion;
															#line 674 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.partitioned)
															#line 2853 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 677 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.contiguousLogEnd = logs.begin()->beginVersion;
															#line 2857 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
				else
				{
															#line 679 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.contiguousLogEnd = logs.begin()->beginVersion;
															#line 2863 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
			}
															#line 683 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (desc.partitioned)
															#line 2868 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 684 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				updatePartitionedLogsContinuousEnd(&desc, logs, scanBegin, scanEnd);
															#line 2872 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
			else
			{
															#line 686 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				Version& end = desc.contiguousLogEnd.get();
															#line 687 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				computeRestoreEndVersion(logs, nullptr, &end, std::numeric_limits<Version>::max());
															#line 2880 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 693 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (logStartVersionOverride == invalidVersion)
															#line 2885 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			try {
															#line 699 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				updates = Void();
															#line 701 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.minLogBegin.present() && metaLogBegin != desc.minLogBegin)
															#line 2892 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					updates = updates && bc->logBeginVersion().set(desc.minLogBegin.get());
															#line 2896 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
															#line 705 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.contiguousLogEnd.present() && metaLogEnd != desc.contiguousLogEnd)
															#line 2900 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 706 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					updates = updates && bc->logEndVersion().set(desc.contiguousLogEnd.get());
															#line 2904 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
															#line 709 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!metaLogType.present())
															#line 2908 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 710 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					updates = updates && bc->logType().set(desc.partitioned ? BackupContainerFileSystemImpl::PARTITIONED_MUTATION_LOG : BackupContainerFileSystemImpl::NON_PARTITIONED_MUTATION_LOG);
															#line 2912 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
															#line 716 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Void> __when_expr_4 = updates;
															#line 716 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1cont8Catch1(actor_cancelled(), loopDepth);
															#line 2918 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont8Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
				static_cast<DescribeBackupActor*>(this)->actor_wait_state = 5;
															#line 716 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 4, Void >*>(static_cast<DescribeBackupActor*>(this)));
															#line 2923 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont8Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont8Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 645 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent("BackupContainerListFiles") .detail("URL", bc->getURL()) .detail("LogFiles", logs.size()) .detail("PLogsFiles", plogs.size()) .detail("Snapshots", desc.snapshots.size());
															#line 651 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (plogs.size() > 0)
															#line 2945 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 652 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.partitioned = true;
															#line 653 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			logs.swap(plogs);
															#line 2951 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
		else
		{
															#line 655 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.partitioned = metaLogType.present() && metaLogType.get() == BackupContainerFileSystemImpl::PARTITIONED_MUTATION_LOG;
															#line 2957 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 659 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (fileLevelEncryption.present() && fileLevelEncryption.get() != 0)
															#line 2961 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 660 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.fileLevelEncryption = true;
															#line 2965 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
		else
		{
															#line 662 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.fileLevelEncryption = false;
															#line 2971 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 666 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::sort(logs.begin(), logs.end());
															#line 669 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!logs.empty())
															#line 2977 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 670 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.maxLogEnd = logs.rbegin()->endVersion;
															#line 672 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!desc.contiguousLogEnd.present())
															#line 2983 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 673 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				desc.minLogBegin = logs.begin()->beginVersion;
															#line 674 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.partitioned)
															#line 2989 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 677 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.contiguousLogEnd = logs.begin()->beginVersion;
															#line 2993 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
				else
				{
															#line 679 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.contiguousLogEnd = logs.begin()->beginVersion;
															#line 2999 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
			}
															#line 683 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (desc.partitioned)
															#line 3004 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 684 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				updatePartitionedLogsContinuousEnd(&desc, logs, scanBegin, scanEnd);
															#line 3008 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
			else
			{
															#line 686 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				Version& end = desc.contiguousLogEnd.get();
															#line 687 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				computeRestoreEndVersion(logs, nullptr, &end, std::numeric_limits<Version>::max());
															#line 3016 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 693 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (logStartVersionOverride == invalidVersion)
															#line 3021 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			try {
															#line 699 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				updates = Void();
															#line 701 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.minLogBegin.present() && metaLogBegin != desc.minLogBegin)
															#line 3028 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					updates = updates && bc->logBeginVersion().set(desc.minLogBegin.get());
															#line 3032 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
															#line 705 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.contiguousLogEnd.present() && metaLogEnd != desc.contiguousLogEnd)
															#line 3036 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 706 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					updates = updates && bc->logEndVersion().set(desc.contiguousLogEnd.get());
															#line 3040 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
															#line 709 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!metaLogType.present())
															#line 3044 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 710 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					updates = updates && bc->logType().set(desc.partitioned ? BackupContainerFileSystemImpl::PARTITIONED_MUTATION_LOG : BackupContainerFileSystemImpl::NON_PARTITIONED_MUTATION_LOG);
															#line 3048 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
															#line 716 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Void> __when_expr_4 = updates;
															#line 716 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1cont8Catch1(actor_cancelled(), loopDepth);
															#line 3054 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont8Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
				static_cast<DescribeBackupActor*>(this)->actor_wait_state = 5;
															#line 716 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 4, Void >*>(static_cast<DescribeBackupActor*>(this)));
															#line 3059 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont8Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont8Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state > 0) static_cast<DescribeBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DescribeBackupActor*>(this)->ActorCallback< DescribeBackupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DescribeBackupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont13(int loopDepth) 
	{
															#line 724 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto& s : desc.snapshots ) {
															#line 726 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			s.restorable = true;
															#line 728 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (s.beginVersion != s.endVersion)
															#line 3158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 729 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!desc.minLogBegin.present() || desc.minLogBegin.get() > s.beginVersion)
															#line 3162 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 730 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					s.restorable = false;
															#line 3166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
															#line 731 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!desc.contiguousLogEnd.present() || desc.contiguousLogEnd.get() <= s.endVersion)
															#line 3170 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 732 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					s.restorable = false;
															#line 3174 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
															#line 735 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.contiguousLogEnd.present() && desc.contiguousLogEnd.get() <= s.beginVersion)
															#line 3178 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 736 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					if (desc.partitioned)
															#line 3182 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
					{
															#line 737 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
						s.restorable = isPartitionedLogsContinuous(logs, s.beginVersion, s.endVersion);
															#line 3186 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
					}
					else
					{
															#line 739 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
						s.restorable = hasContinuousLogsForSnapshot(logs, s.beginVersion, s.endVersion);
															#line 3192 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
					}
				}
			}
															#line 743 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.snapshotBytes += s.totalSize;
															#line 747 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (s.beginVersion == s.endVersion && (!desc.contiguousLogEnd.present() || (desc.contiguousLogEnd.present() && desc.contiguousLogEnd.get() >= s.beginVersion)))
															#line 3200 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 752 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!desc.minRestorableVersion.present() || s.endVersion < desc.minRestorableVersion.get())
															#line 3204 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 753 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.minRestorableVersion = s.endVersion;
															#line 3208 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
															#line 755 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!desc.maxRestorableVersion.present() || s.endVersion > desc.maxRestorableVersion.get())
															#line 3212 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 756 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.maxRestorableVersion = s.endVersion;
															#line 3216 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
			}
															#line 760 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (desc.minLogBegin.present() && s.beginVersion >= desc.minLogBegin.get() && s.endVersion < desc.contiguousLogEnd.get())
															#line 3221 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 762 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!desc.minRestorableVersion.present() || s.endVersion < desc.minRestorableVersion.get())
															#line 3225 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 763 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.minRestorableVersion = s.endVersion;
															#line 3229 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
															#line 765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!desc.maxRestorableVersion.present() || (desc.contiguousLogEnd.get() - 1) > desc.maxRestorableVersion.get())
															#line 3233 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 767 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.maxRestorableVersion = desc.contiguousLogEnd.get() - 1;
															#line 3237 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
			}
															#line 771 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (desc.contiguousLogEnd.present() && ((desc.contiguousLogEnd.get() < s.beginVersion) || (desc.contiguousLogEnd.get() == s.beginVersion && s.beginVersion != s.endVersion)) && s.restorable.get())
															#line 3242 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 777 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.minRestorableVersion.present() && desc.maxRestorableVersion.present())
															#line 3246 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 778 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					ASSERT(desc.minRestorableVersion.get() < s.beginVersion);
															#line 781 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					bool contiguousLogs = false;
															#line 782 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					if (desc.partitioned)
															#line 3254 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
					{
															#line 783 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
						contiguousLogs = isPartitionedLogsContinuous(logs, desc.minRestorableVersion.get(), s.endVersion);
															#line 3258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
					}
					else
					{
															#line 786 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
						contiguousLogs = hasContinuousLogsForSnapshot(logs, desc.minRestorableVersion.get(), s.endVersion);
															#line 3264 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
					}
															#line 789 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					if (contiguousLogs)
															#line 3268 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
					{
															#line 792 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
						desc.maxRestorableVersion = s.endVersion;
															#line 3272 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
					}
					else
					{
															#line 797 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
						desc.minRestorableVersion = s.endVersion;
															#line 3278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 802 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.minRestorableVersion = s.endVersion;
															#line 3285 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
															#line 807 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.partitioned)
															#line 3289 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 809 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.maxRestorableVersion = s.endVersion;
															#line 3293 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
				else
				{
															#line 811 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					Version maxContinuousLogEnd = findContinuousLogEnd(logs, s.endVersion);
															#line 812 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.maxRestorableVersion = (maxContinuousLogEnd == invalidVersion) ? s.endVersion : maxContinuousLogEnd - 1;
															#line 3301 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
			}
		}
															#line 818 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<DescribeBackupActor*>(this)->SAV<BackupDescription>::futures) { (void)(desc); this->~DescribeBackupActorState(); static_cast<DescribeBackupActor*>(this)->destroy(); return 0; }
															#line 3307 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<DescribeBackupActor*>(this)->SAV< BackupDescription >::value()) BackupDescription(std::move(desc)); // state_var_RVO
		this->~DescribeBackupActorState();
		static_cast<DescribeBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont24(int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont8Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 718 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3326 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 719 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 3330 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
															#line 720 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarn, "BackupContainerMetadataUpdateFailure").error(e).detail("URL", bc->getURL());
															#line 3334 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = a_body1cont24(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont25(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont25cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont25(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont25cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont25(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont25(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state > 0) static_cast<DescribeBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DescribeBackupActor*>(this)->ActorCallback< DescribeBackupActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DescribeBackupActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont25cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont24(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	bool deepScan;
															#line 522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version logStartVersionOverride;
															#line 525 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	BackupDescription desc;
															#line 550 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<Version> metaLogBegin;
															#line 551 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<Version> metaLogEnd;
															#line 552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<Version> metaExpiredEnd;
															#line 553 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<Version> metaUnreliableEnd;
															#line 554 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<Version> metaLogType;
															#line 555 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<Version> fileLevelEncryption;
															#line 618 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version scanBegin;
															#line 619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version scanEnd;
															#line 637 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> logs;
															#line 638 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> plogs;
															#line 699 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Future<Void> updates;
															#line 3475 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via describeBackup()
															#line 522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class DescribeBackupActor final : public Actor<BackupDescription>, public ActorCallback< DescribeBackupActor, 0, bool >, public ActorCallback< DescribeBackupActor, 1, BackupDescription >, public ActorCallback< DescribeBackupActor, 2, Void >, public ActorCallback< DescribeBackupActor, 3, Void >, public ActorCallback< DescribeBackupActor, 4, Void >, public FastAllocated<DescribeBackupActor>, public DescribeBackupActorState<DescribeBackupActor> {
															#line 3480 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<DescribeBackupActor>::operator new;
	using FastAllocated<DescribeBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12855596867945051648UL, 12128910607044899072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<BackupDescription>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DescribeBackupActor, 0, bool >;
friend struct ActorCallback< DescribeBackupActor, 1, BackupDescription >;
friend struct ActorCallback< DescribeBackupActor, 2, Void >;
friend struct ActorCallback< DescribeBackupActor, 3, Void >;
friend struct ActorCallback< DescribeBackupActor, 4, Void >;
															#line 522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	DescribeBackupActor(Reference<BackupContainerFileSystem> const& bc,bool const& deepScan,Version const& logStartVersionOverride) 
															#line 3501 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<BackupDescription>(),
		   DescribeBackupActorState<DescribeBackupActor>(bc, deepScan, logStartVersionOverride),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10658787011351424256UL, 7417613107694102528UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("describeBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DescribeBackupActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DescribeBackupActor, 1, BackupDescription >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DescribeBackupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DescribeBackupActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DescribeBackupActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<BackupDescription> describeBackup( Reference<BackupContainerFileSystem> const& bc, bool const& deepScan, Version const& logStartVersionOverride ) {
															#line 522 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<BackupDescription>(new DescribeBackupActor(bc, deepScan, logStartVersionOverride));
															#line 3537 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 820 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

																#line 3542 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via expireData()
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class ExpireDataActor>
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class ExpireDataActorState {
															#line 3548 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	ExpireDataActorState(Reference<BackupContainerFileSystem> const& bc,Version const& expireEndVersion,bool const& force,IBackupContainer::ExpireProgress* const& progress,Version const& restorableBeginVersion) 
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   expireEndVersion(expireEndVersion),
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   force(force),
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   progress(progress),
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   restorableBeginVersion(restorableBeginVersion)
															#line 3563 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("expireData", reinterpret_cast<unsigned long>(this));

	}
	~ExpireDataActorState() 
	{
		fdb_probe_actor_destroy("expireData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 826 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (progress != nullptr)
															#line 3578 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 827 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				progress->step = "Describing backup";
															#line 828 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				progress->total = 0;
															#line 3584 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
															#line 831 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent("BackupContainerFileSystemExpire1") .detail("URL", bc->getURL()) .detail("ExpireEndVersion", expireEndVersion) .detail("RestorableBeginVersion", restorableBeginVersion);
															#line 837 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<BackupDescription> __when_expr_0 = bc->describeBackup(false, expireEndVersion);
															#line 837 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3592 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ExpireDataActor*>(this)->actor_wait_state = 1;
															#line 837 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 0, BackupDescription >*>(static_cast<ExpireDataActor*>(this)));
															#line 3597 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExpireDataActorState();
		static_cast<ExpireDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 840 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		expireEndVersion = resolveRelativeVersion(desc.maxLogEnd, expireEndVersion, "ExpireEndVersion", invalid_option_value());
															#line 842 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		restorableBeginVersion = resolveRelativeVersion( desc.maxLogEnd, restorableBeginVersion, "RestorableBeginVersion", invalid_option_value());
															#line 846 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (restorableBeginVersion < expireEndVersion)
															#line 3624 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 847 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(backup_cannot_expire(), loopDepth);
															#line 3628 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 851 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (expireEndVersion <= desc.expiredEndVersion.orDefault(invalidVersion))
															#line 3632 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 852 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<ExpireDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ExpireDataActorState(); static_cast<ExpireDataActor*>(this)->destroy(); return 0; }
															#line 3636 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			new (&static_cast<ExpireDataActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ExpireDataActorState();
			static_cast<ExpireDataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 859 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		forceNeeded = true;
															#line 860 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( KeyspaceSnapshotFile& s : desc.snapshots ) {
															#line 861 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (s.restorable.orDefault(false) && s.beginVersion >= expireEndVersion && s.endVersion <= restorableBeginVersion)
															#line 3648 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 863 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				forceNeeded = false;
															#line 3652 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				break;
			}
		}
															#line 872 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (forceNeeded && !force)
															#line 3658 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 873 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(backup_cannot_expire(), loopDepth);
															#line 3662 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		scanBegin = desc.expiredEndVersion.orDefault(0);
															#line 878 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent("BackupContainerFileSystemExpire2") .detail("URL", bc->getURL()) .detail("ExpireEndVersion", expireEndVersion) .detail("RestorableBeginVersion", restorableBeginVersion) .detail("ScanBeginVersion", scanBegin);
															#line 884 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs = std::vector<LogFile>();
															#line 885 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		pLogs = std::vector<LogFile>();
															#line 886 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ranges = std::vector<RangeFile>();
															#line 888 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (progress != nullptr)
															#line 3676 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 889 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			progress->step = "Listing files";
															#line 3680 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 892 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(logs, bc->listLogFiles(scanBegin, expireEndVersion - 1, false)) && store(pLogs, bc->listLogFiles(scanBegin, expireEndVersion - 1, true)) && store(ranges, bc->listRangeFiles(scanBegin, expireEndVersion - 1));
															#line 892 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3686 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExpireDataActor*>(this)->actor_wait_state = 2;
															#line 892 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 1, Void >*>(static_cast<ExpireDataActor*>(this)));
															#line 3691 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(BackupDescription const& __desc,int loopDepth) 
	{
															#line 837 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc = __desc;
															#line 3700 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(BackupDescription && __desc,int loopDepth) 
	{
		desc = std::move(__desc);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireDataActor*>(this)->ActorCallback< ExpireDataActor, 0, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 0, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 0, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExpireDataActor, 0, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 895 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs.insert(logs.end(), std::make_move_iterator(pLogs.begin()), std::make_move_iterator(pLogs.end()));
															#line 898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		newLogBeginVersion = Optional<Version>();
															#line 899 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!logs.empty())
															#line 3783 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 901 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			LogFile& last = *std::max_element(logs.begin(), logs.end());
															#line 904 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (last.endVersion == expireEndVersion)
															#line 3789 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 905 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				newLogBeginVersion = expireEndVersion;
															#line 3793 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
			else
			{
															#line 909 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (last.endVersion > expireEndVersion)
															#line 3799 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 910 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					newLogBeginVersion = last.beginVersion;
															#line 913 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					last = LogFile();
															#line 915 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					expireEndVersion = newLogBeginVersion.get();
															#line 3807 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
			}
		}
															#line 921 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		toDelete = std::vector<std::string>();
															#line 924 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto const& f : logs ) {
															#line 926 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!f.fileName.empty())
															#line 3817 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 927 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				toDelete.push_back(std::move(f.fileName));
															#line 3821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 930 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs.clear();
															#line 933 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto const& f : ranges ) {
															#line 938 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (f.version < expireEndVersion)
															#line 3830 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 939 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				toDelete.push_back(std::move(f.fileName));
															#line 3834 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 942 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ranges.clear();
															#line 944 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto const& f : desc.snapshots ) {
															#line 945 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (f.endVersion < expireEndVersion)
															#line 3843 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 946 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				toDelete.push_back(std::move(f.fileName));
															#line 3847 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 948 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc = BackupDescription();
															#line 953 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (progress != nullptr)
															#line 3854 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 954 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			progress->step = "Initial metadata update";
															#line 3858 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 956 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Optional<Version>> __when_expr_2 = bc->unreliableEndVersion().get();
															#line 956 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3864 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ExpireDataActor*>(this)->actor_wait_state = 3;
															#line 956 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 2, Optional<Version> >*>(static_cast<ExpireDataActor*>(this)));
															#line 3869 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 895 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs.insert(logs.end(), std::make_move_iterator(pLogs.begin()), std::make_move_iterator(pLogs.end()));
															#line 898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		newLogBeginVersion = Optional<Version>();
															#line 899 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!logs.empty())
															#line 3882 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 901 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			LogFile& last = *std::max_element(logs.begin(), logs.end());
															#line 904 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (last.endVersion == expireEndVersion)
															#line 3888 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 905 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				newLogBeginVersion = expireEndVersion;
															#line 3892 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
			else
			{
															#line 909 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (last.endVersion > expireEndVersion)
															#line 3898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 910 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					newLogBeginVersion = last.beginVersion;
															#line 913 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					last = LogFile();
															#line 915 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					expireEndVersion = newLogBeginVersion.get();
															#line 3906 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
			}
		}
															#line 921 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		toDelete = std::vector<std::string>();
															#line 924 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto const& f : logs ) {
															#line 926 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!f.fileName.empty())
															#line 3916 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 927 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				toDelete.push_back(std::move(f.fileName));
															#line 3920 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 930 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs.clear();
															#line 933 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto const& f : ranges ) {
															#line 938 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (f.version < expireEndVersion)
															#line 3929 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 939 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				toDelete.push_back(std::move(f.fileName));
															#line 3933 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 942 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ranges.clear();
															#line 944 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto const& f : desc.snapshots ) {
															#line 945 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (f.endVersion < expireEndVersion)
															#line 3942 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 946 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				toDelete.push_back(std::move(f.fileName));
															#line 3946 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 948 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc = BackupDescription();
															#line 953 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (progress != nullptr)
															#line 3953 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 954 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			progress->step = "Initial metadata update";
															#line 3957 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 956 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Optional<Version>> __when_expr_2 = bc->unreliableEndVersion().get();
															#line 956 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3963 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ExpireDataActor*>(this)->actor_wait_state = 3;
															#line 956 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 2, Optional<Version> >*>(static_cast<ExpireDataActor*>(this)));
															#line 3968 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireDataActor*>(this)->ActorCallback< ExpireDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExpireDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont10(Optional<Version> const& metaUnreliableEnd,int loopDepth) 
	{
															#line 957 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (metaUnreliableEnd.orDefault(0) < expireEndVersion)
															#line 4052 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 958 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_3 = bc->unreliableEndVersion().set(expireEndVersion);
															#line 958 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4058 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont10when1(__when_expr_3.get(), loopDepth); };
			static_cast<ExpireDataActor*>(this)->actor_wait_state = 4;
															#line 958 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 3, Void >*>(static_cast<ExpireDataActor*>(this)));
															#line 4063 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(Optional<Version> && metaUnreliableEnd,int loopDepth) 
	{
															#line 957 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (metaUnreliableEnd.orDefault(0) < expireEndVersion)
															#line 4077 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 958 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_3 = bc->unreliableEndVersion().set(expireEndVersion);
															#line 958 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4083 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont10when1(__when_expr_3.get(), loopDepth); };
			static_cast<ExpireDataActor*>(this)->actor_wait_state = 4;
															#line 958 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 3, Void >*>(static_cast<ExpireDataActor*>(this)));
															#line 4088 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3when1(Optional<Version> const& metaUnreliableEnd,int loopDepth) 
	{
		loopDepth = a_body1cont10(metaUnreliableEnd, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Optional<Version> && metaUnreliableEnd,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(metaUnreliableEnd), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireDataActor*>(this)->ActorCallback< ExpireDataActor, 2, Optional<Version> >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 2, Optional<Version> >*,Optional<Version> const& value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 2, Optional<Version> >*,Optional<Version> && value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ExpireDataActor, 2, Optional<Version> >*,Error err) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 961 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (progress != nullptr)
															#line 4177 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 962 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			progress->step = "Deleting files";
															#line 963 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			progress->total = toDelete.size();
															#line 964 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			progress->done = 0;
															#line 4185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 969 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		deleteFutures = std::list<Future<Void>>();
															#line 971 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 4191 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireDataActor*>(this)->ActorCallback< ExpireDataActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ExpireDataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10cont3(int loopDepth) 
	{
															#line 993 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (progress != nullptr)
															#line 4287 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 994 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			progress->step = "Final metadata update";
															#line 995 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			progress->total = 0;
															#line 4293 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 999 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Optional<Version>> __when_expr_5 = bc->expiredEndVersion().get();
															#line 999 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<ExpireDataActor*>(this)->actor_wait_state = 6;
															#line 999 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 5, Optional<Version> >*>(static_cast<ExpireDataActor*>(this)));
															#line 4304 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1(int loopDepth) 
	{
															#line 971 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(!toDelete.empty() || !deleteFutures.empty()))
															#line 4320 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			return a_body1cont10cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 974 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for(;!toDelete.empty() && deleteFutures.size() < CLIENT_KNOBS->BACKUP_CONCURRENT_DELETES;) {
															#line 975 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			deleteFutures.push_back(bc->deleteFile(toDelete.back()));
															#line 976 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			toDelete.pop_back();
															#line 4330 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 982 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		targetFuturesSize = toDelete.empty() ? 0 : (CLIENT_KNOBS->BACKUP_CONCURRENT_DELETES - 1);
															#line 984 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 4336 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont10cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 984 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(deleteFutures.size() > targetFuturesSize))
															#line 4371 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			return a_body1cont10cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 985 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_4 = deleteFutures.front();
															#line 985 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4379 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1cont10cont1loopBody1loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<ExpireDataActor*>(this)->actor_wait_state = 5;
															#line 985 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 4, Void >*>(static_cast<ExpireDataActor*>(this)));
															#line 4384 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 986 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (progress != nullptr)
															#line 4406 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 987 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			++progress->done;
															#line 4410 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 989 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		deleteFutures.pop_front();
															#line 4414 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont10cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 986 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (progress != nullptr)
															#line 4423 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 987 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			++progress->done;
															#line 4427 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 989 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		deleteFutures.pop_front();
															#line 4431 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont10cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireDataActor*>(this)->ActorCallback< ExpireDataActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ExpireDataActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10cont5(Optional<Version> const& metaExpiredEnd,int loopDepth) 
	{
															#line 1000 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (metaExpiredEnd.orDefault(0) < expireEndVersion)
															#line 4515 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1001 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_6 = bc->expiredEndVersion().set(expireEndVersion);
															#line 1001 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4521 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont5when1(__when_expr_6.get(), loopDepth); };
			static_cast<ExpireDataActor*>(this)->actor_wait_state = 7;
															#line 1001 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 6, Void >*>(static_cast<ExpireDataActor*>(this)));
															#line 4526 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont5(Optional<Version> && metaExpiredEnd,int loopDepth) 
	{
															#line 1000 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (metaExpiredEnd.orDefault(0) < expireEndVersion)
															#line 4540 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1001 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_6 = bc->expiredEndVersion().set(expireEndVersion);
															#line 1001 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4546 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont5when1(__when_expr_6.get(), loopDepth); };
			static_cast<ExpireDataActor*>(this)->actor_wait_state = 7;
															#line 1001 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 6, Void >*>(static_cast<ExpireDataActor*>(this)));
															#line 4551 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont3when1(Optional<Version> const& metaExpiredEnd,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(metaExpiredEnd, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(Optional<Version> && metaExpiredEnd,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(std::move(metaExpiredEnd), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireDataActor*>(this)->ActorCallback< ExpireDataActor, 5, Optional<Version> >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 5, Optional<Version> >*,Optional<Version> const& value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 5, Optional<Version> >*,Optional<Version> && value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ExpireDataActor, 5, Optional<Version> >*,Error err) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10cont7(int loopDepth) 
	{
															#line 1004 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<ExpireDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ExpireDataActorState(); static_cast<ExpireDataActor*>(this)->destroy(); return 0; }
															#line 4640 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<ExpireDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ExpireDataActorState();
		static_cast<ExpireDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireDataActor*>(this)->ActorCallback< ExpireDataActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ExpireDataActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version expireEndVersion;
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	bool force;
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	IBackupContainer::ExpireProgress* progress;
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version restorableBeginVersion;
															#line 837 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	BackupDescription desc;
															#line 859 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	bool forceNeeded;
															#line 876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version scanBegin;
															#line 884 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> logs;
															#line 885 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> pLogs;
															#line 886 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<RangeFile> ranges;
															#line 898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<Version> newLogBeginVersion;
															#line 921 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<std::string> toDelete;
															#line 969 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::list<Future<Void>> deleteFutures;
															#line 982 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int targetFuturesSize;
															#line 4765 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via expireData()
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class ExpireDataActor final : public Actor<Void>, public ActorCallback< ExpireDataActor, 0, BackupDescription >, public ActorCallback< ExpireDataActor, 1, Void >, public ActorCallback< ExpireDataActor, 2, Optional<Version> >, public ActorCallback< ExpireDataActor, 3, Void >, public ActorCallback< ExpireDataActor, 4, Void >, public ActorCallback< ExpireDataActor, 5, Optional<Version> >, public ActorCallback< ExpireDataActor, 6, Void >, public FastAllocated<ExpireDataActor>, public ExpireDataActorState<ExpireDataActor> {
															#line 4770 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<ExpireDataActor>::operator new;
	using FastAllocated<ExpireDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3078243540603543552UL, 18149166774494021888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExpireDataActor, 0, BackupDescription >;
friend struct ActorCallback< ExpireDataActor, 1, Void >;
friend struct ActorCallback< ExpireDataActor, 2, Optional<Version> >;
friend struct ActorCallback< ExpireDataActor, 3, Void >;
friend struct ActorCallback< ExpireDataActor, 4, Void >;
friend struct ActorCallback< ExpireDataActor, 5, Optional<Version> >;
friend struct ActorCallback< ExpireDataActor, 6, Void >;
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	ExpireDataActor(Reference<BackupContainerFileSystem> const& bc,Version const& expireEndVersion,bool const& force,IBackupContainer::ExpireProgress* const& progress,Version const& restorableBeginVersion) 
															#line 4793 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ExpireDataActorState<ExpireDataActor>(bc, expireEndVersion, force, progress, restorableBeginVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8075419445270113024UL, 7939239822766582016UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("expireData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExpireDataActor, 0, BackupDescription >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExpireDataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ExpireDataActor, 2, Optional<Version> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ExpireDataActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ExpireDataActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ExpireDataActor, 5, Optional<Version> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ExpireDataActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Void> expireData( Reference<BackupContainerFileSystem> const& bc, Version const& expireEndVersion, bool const& force, IBackupContainer::ExpireProgress* const& progress, Version const& restorableBeginVersion ) {
															#line 821 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new ExpireDataActor(bc, expireEndVersion, force, progress, restorableBeginVersion));
															#line 4831 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 1006 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

	// Returns true if logs are continuous in the range [begin, end].
	// "files" should be pre-sorted according to version order.
	static bool isPartitionedLogsContinuous(const std::vector<LogFile>& files, Version begin, Version end) {
		std::map<int, std::vector<int>> tagIndices; // tagId -> indices in files
		for (int i = 0; i < files.size(); i++) {
			ASSERT(files[i].tagId >= 0 && files[i].tagId < files[i].totalTags);
			auto& indices = tagIndices[files[i].tagId];
			indices.push_back(i);
		}

		// check partition 0 is continuous and create a map of ranges to tags
		std::map<std::pair<Version, Version>, int> tags; // range [begin, end] -> tags
		if (!isContinuous(files, tagIndices[0], begin, end, &tags)) {
			TraceEvent(SevWarn, "BackupFileNotContinuous")
			    .detail("Partition", 0)
			    .detail("RangeBegin", begin)
			    .detail("RangeEnd", end);
			return false;
		}

		// for each range in tags, check all tags from 1 are continouous
		for (const auto& [beginEnd, count] : tags) {
			for (int i = 1; i < count; i++) {
				if (!isContinuous(files, tagIndices[i], beginEnd.first, std::min(beginEnd.second - 1, end), nullptr)) {
					TraceEvent(SevWarn, "BackupFileNotContinuous")
					    .detail("Partition", i)
					    .detail("RangeBegin", beginEnd.first)
					    .detail("RangeEnd", beginEnd.second);
					return false;
				}
			}
		}
		return true;
	}

	// Returns log files that are not duplicated, or subset of another log.
	// If a log file's progress is not saved, a new log file will be generated
	// with the same begin version. So we can have a file that contains a subset
	// of contents in another log file.
	// PRE-CONDITION: logs are already sorted by (tagId, beginVersion, endVersion).
	static std::vector<LogFile> filterDuplicates(const std::vector<LogFile>& logs) {
		std::vector<LogFile> filtered;
		int i = 0;
		for (int j = 1; j < logs.size(); j++) {
			if (logs[j].isSubset(logs[i])) {
				ASSERT_LE(logs[j].fileSize, logs[i].fileSize);
				continue;
			}

			if (!logs[i].isSubset(logs[j])) {
				filtered.push_back(logs[i]);
			}
			i = j;
		}
		if (i < logs.size())
			filtered.push_back(logs[i]);
		return filtered;
	}

	static Optional<RestorableFileSet> getRestoreSetFromLogs(const std::vector<LogFile>& logs,
	                                                         Version targetVersion,
	                                                         RestorableFileSet restorable) {
		Version end = logs.begin()->beginVersion;
		computeRestoreEndVersion(logs, &restorable.logs, &end, targetVersion);
		if (end >= targetVersion) {
			restorable.continuousBeginVersion = logs.begin()->beginVersion;
			restorable.continuousEndVersion = end;
			return Optional<RestorableFileSet>(restorable);
		}
		return Optional<RestorableFileSet>();
	}

	// Get a set of files that can restore the given "keyRangesFilter" to the "targetVersion".
	// If "keyRangesFilter" is empty, the file set will cover all key ranges present in the backup.
	// It's generally a good idea to specify "keyRangesFilter" to reduce the number of files for
	// restore times.
	// If "logsOnly" is true, then only log files are returned and "keyRangesFilter" is ignored,
	// because the log can contain mutations of the whole key space, unlike range files that each
	// is limited to a smaller key range.
																#line 4915 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via getRestoreSet()
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class GetRestoreSetActor>
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class GetRestoreSetActorState {
															#line 4921 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	GetRestoreSetActorState(Reference<BackupContainerFileSystem> const& bc,Version const& targetVersion,VectorRef<KeyRangeRef> const& keyRangesFilter,bool const& logsOnly = false,Version const& beginVersion = invalidVersion) 
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   targetVersion(targetVersion),
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   keyRangesFilter(keyRangesFilter),
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   logsOnly(logsOnly),
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   beginVersion(beginVersion)
															#line 4936 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getRestoreSet", reinterpret_cast<unsigned long>(this));

	}
	~GetRestoreSetActorState() 
	{
		fdb_probe_actor_destroy("getRestoreSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1091 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			for( const auto& range : keyRangesFilter ) {
															#line 1092 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent("BackupContainerGetRestoreSet").detail("RangeFilter", printable(range));
															#line 4953 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
															#line 1095 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (logsOnly)
															#line 4957 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 1096 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				restorableSet = RestorableFileSet();
															#line 1097 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				restorableSet.targetVersion = targetVersion;
															#line 1098 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				logFiles = std::vector<LogFile>();
															#line 1099 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				Version begin = beginVersion == invalidVersion ? 0 : beginVersion;
															#line 1100 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(logFiles, bc->listLogFiles(begin, targetVersion, false));
															#line 1100 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4971 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 1;
															#line 1100 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRestoreSetActor, 0, Void >*>(static_cast<GetRestoreSetActor*>(this)));
															#line 4976 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRestoreSetActorState();
		static_cast<GetRestoreSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1109 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<std::vector<KeyspaceSnapshotFile>> __when_expr_1 = bc->listKeyspaceSnapshots();
															#line 1109 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5006 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 2;
															#line 1109 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRestoreSetActor, 1, std::vector<KeyspaceSnapshotFile> >*>(static_cast<GetRestoreSetActor*>(this)));
															#line 5011 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1102 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::sort(logFiles.begin(), logFiles.end());
															#line 1103 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!logFiles.empty())
															#line 5022 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(getRestoreSetFromLogs(logFiles, targetVersion, restorableSet)); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5026 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(getRestoreSetFromLogs(logFiles, targetVersion, restorableSet));
			this->~GetRestoreSetActorState();
			static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1102 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::sort(logFiles.begin(), logFiles.end());
															#line 1103 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!logFiles.empty())
															#line 5042 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(getRestoreSetFromLogs(logFiles, targetVersion, restorableSet)); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5046 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(getRestoreSetFromLogs(logFiles, targetVersion, restorableSet));
			this->~GetRestoreSetActorState();
			static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreSetActor*>(this)->ActorCallback< GetRestoreSetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreSetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRestoreSetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRestoreSetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 1110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		i = snapshots.size() - 1;
															#line 1111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 5137 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<KeyspaceSnapshotFile> const& __snapshots,int loopDepth) 
	{
															#line 1109 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshots = __snapshots;
															#line 5146 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<KeyspaceSnapshotFile> && __snapshots,int loopDepth) 
	{
		snapshots = std::move(__snapshots);
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreSetActor*>(this)->ActorCallback< GetRestoreSetActor, 1, std::vector<KeyspaceSnapshotFile> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreSetActor, 1, std::vector<KeyspaceSnapshotFile> >*,std::vector<KeyspaceSnapshotFile> const& value) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRestoreSetActor, 1, std::vector<KeyspaceSnapshotFile> >*,std::vector<KeyspaceSnapshotFile> && value) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRestoreSetActor, 1, std::vector<KeyspaceSnapshotFile> >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1200 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(Optional<RestorableFileSet>()); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5225 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(Optional<RestorableFileSet>());
		this->~GetRestoreSetActorState();
		static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 1111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(i >= 0))
															#line 5244 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1113 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (targetVersion >= 0 && snapshots[i].beginVersion > targetVersion)
															#line 5250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			return a_body1cont6continue1(loopDepth); // continue
		}
															#line 1117 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		restorable = RestorableFileSet();
															#line 1118 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		minKeyRangeVersion = MAX_VERSION;
															#line 1119 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		maxKeyRangeVersion = -1;
															#line 1121 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>> __when_expr_2 = bc->readKeyspaceSnapshot(snapshots[i]);
															#line 1121 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5264 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 3;
															#line 1121 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRestoreSetActor, 2, std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >*>(static_cast<GetRestoreSetActor*>(this)));
															#line 5269 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6continue1(int loopDepth) 
	{
															#line 1111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		i--;
															#line 5291 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> const& results,int loopDepth) 
	{
															#line 1126 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (keyRangesFilter.empty() || results.second.empty())
															#line 5300 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1127 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			restorable.ranges = std::move(results.first);
															#line 1128 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			restorable.keyRanges = std::move(results.second);
															#line 1129 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			minKeyRangeVersion = snapshots[i].beginVersion;
															#line 1130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			maxKeyRangeVersion = snapshots[i].endVersion;
															#line 5310 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			for( const auto& rangeFile : results.first ) {
															#line 1133 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				const auto& keyRange = results.second.at(rangeFile.fileName);
															#line 1134 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (keyRange.intersects(keyRangesFilter))
															#line 5320 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 1135 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					restorable.ranges.push_back(rangeFile);
															#line 1136 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					restorable.keyRanges[rangeFile.fileName] = keyRange;
															#line 1137 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					minKeyRangeVersion = std::min(minKeyRangeVersion, rangeFile.version);
															#line 1138 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					maxKeyRangeVersion = std::max(maxKeyRangeVersion, rangeFile.version);
															#line 5330 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
			}
															#line 1142 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (restorable.ranges.empty())
															#line 5335 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 1143 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(backup_not_overlapped_with_keys_filter(), std::max(0, loopDepth - 1));
															#line 5339 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 1147 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		restorable.targetVersion = targetVersion == latestVersion ? maxKeyRangeVersion : targetVersion;
															#line 1149 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (restorable.targetVersion < maxKeyRangeVersion)
															#line 5346 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			return a_body1cont6continue1(loopDepth); // continue
		}
															#line 1153 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		restorable.snapshot = snapshots[i];
															#line 1156 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (minKeyRangeVersion == maxKeyRangeVersion && maxKeyRangeVersion == restorable.targetVersion)
															#line 5354 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1157 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			restorable.continuousBeginVersion = restorable.continuousEndVersion = invalidVersion;
															#line 1158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent("BackupContainerGetRestorableFilesWithoutLogs") .detail("KeyRangeVersion", restorable.targetVersion) .detail("NumberOfRangeFiles", restorable.ranges.size()) .detail("KeyRangesFilter", printable(keyRangesFilter));
															#line 1162 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(Optional<RestorableFileSet>(restorable)); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5362 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(Optional<RestorableFileSet>(restorable));
			this->~GetRestoreSetActorState();
			static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs = std::vector<LogFile>();
															#line 1167 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		plogs = std::vector<LogFile>();
															#line 1168 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(logs, bc->listLogFiles(minKeyRangeVersion, restorable.targetVersion, false)) && store(plogs, bc->listLogFiles(minKeyRangeVersion, restorable.targetVersion, true));
															#line 1168 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5376 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 4;
															#line 1168 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetRestoreSetActor, 3, Void >*>(static_cast<GetRestoreSetActor*>(this)));
															#line 5381 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> && results,int loopDepth) 
	{
															#line 1126 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (keyRangesFilter.empty() || results.second.empty())
															#line 5390 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1127 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			restorable.ranges = std::move(results.first);
															#line 1128 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			restorable.keyRanges = std::move(results.second);
															#line 1129 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			minKeyRangeVersion = snapshots[i].beginVersion;
															#line 1130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			maxKeyRangeVersion = snapshots[i].endVersion;
															#line 5400 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			for( const auto& rangeFile : results.first ) {
															#line 1133 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				const auto& keyRange = results.second.at(rangeFile.fileName);
															#line 1134 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (keyRange.intersects(keyRangesFilter))
															#line 5410 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 1135 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					restorable.ranges.push_back(rangeFile);
															#line 1136 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					restorable.keyRanges[rangeFile.fileName] = keyRange;
															#line 1137 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					minKeyRangeVersion = std::min(minKeyRangeVersion, rangeFile.version);
															#line 1138 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					maxKeyRangeVersion = std::max(maxKeyRangeVersion, rangeFile.version);
															#line 5420 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
			}
															#line 1142 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (restorable.ranges.empty())
															#line 5425 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 1143 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(backup_not_overlapped_with_keys_filter(), std::max(0, loopDepth - 1));
															#line 5429 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 1147 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		restorable.targetVersion = targetVersion == latestVersion ? maxKeyRangeVersion : targetVersion;
															#line 1149 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (restorable.targetVersion < maxKeyRangeVersion)
															#line 5436 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			return a_body1cont6continue1(loopDepth); // continue
		}
															#line 1153 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		restorable.snapshot = snapshots[i];
															#line 1156 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (minKeyRangeVersion == maxKeyRangeVersion && maxKeyRangeVersion == restorable.targetVersion)
															#line 5444 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1157 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			restorable.continuousBeginVersion = restorable.continuousEndVersion = invalidVersion;
															#line 1158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent("BackupContainerGetRestorableFilesWithoutLogs") .detail("KeyRangeVersion", restorable.targetVersion) .detail("NumberOfRangeFiles", restorable.ranges.size()) .detail("KeyRangesFilter", printable(keyRangesFilter));
															#line 1162 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(Optional<RestorableFileSet>(restorable)); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5452 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(Optional<RestorableFileSet>(restorable));
			this->~GetRestoreSetActorState();
			static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs = std::vector<LogFile>();
															#line 1167 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		plogs = std::vector<LogFile>();
															#line 1168 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(logs, bc->listLogFiles(minKeyRangeVersion, restorable.targetVersion, false)) && store(plogs, bc->listLogFiles(minKeyRangeVersion, restorable.targetVersion, true));
															#line 1168 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5466 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 4;
															#line 1168 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetRestoreSetActor, 3, Void >*>(static_cast<GetRestoreSetActor*>(this)));
															#line 5471 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreSetActor*>(this)->ActorCallback< GetRestoreSetActor, 2, std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreSetActor, 2, std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >*,std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> const& value) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRestoreSetActor, 2, std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >*,std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> && value) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRestoreSetActor, 2, std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 1171 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (plogs.size() > 0)
															#line 5555 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			logs.swap(plogs);
															#line 1174 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(logs.begin(), logs.end(), [](const LogFile& a, const LogFile& b) { return std::tie(a.tagId, a.beginVersion, a.endVersion) < std::tie(b.tagId, b.beginVersion, b.endVersion); });
															#line 1180 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::vector<LogFile> filtered = filterDuplicates(logs);
															#line 1181 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			restorable.logs.swap(filtered);
															#line 1183 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(restorable.logs.begin(), restorable.logs.end());
															#line 1184 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (isPartitionedLogsContinuous(restorable.logs, minKeyRangeVersion, restorable.targetVersion))
															#line 5569 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 1185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				restorable.continuousBeginVersion = minKeyRangeVersion;
															#line 1186 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				restorable.continuousEndVersion = restorable.targetVersion + 1;
															#line 1187 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(Optional<RestorableFileSet>(restorable)); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5577 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(Optional<RestorableFileSet>(restorable));
				this->~GetRestoreSetActorState();
				static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1189 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(Optional<RestorableFileSet>()); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5585 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(Optional<RestorableFileSet>());
			this->~GetRestoreSetActorState();
			static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1193 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::sort(logs.begin(), logs.end());
															#line 1196 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!logs.empty() && logs.front().beginVersion <= minKeyRangeVersion)
															#line 5595 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1197 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(getRestoreSetFromLogs(logs, targetVersion, restorable)); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5599 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(getRestoreSetFromLogs(logs, targetVersion, restorable));
			this->~GetRestoreSetActorState();
			static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		i--;
															#line 5607 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 1171 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (plogs.size() > 0)
															#line 5616 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			logs.swap(plogs);
															#line 1174 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(logs.begin(), logs.end(), [](const LogFile& a, const LogFile& b) { return std::tie(a.tagId, a.beginVersion, a.endVersion) < std::tie(b.tagId, b.beginVersion, b.endVersion); });
															#line 1180 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::vector<LogFile> filtered = filterDuplicates(logs);
															#line 1181 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			restorable.logs.swap(filtered);
															#line 1183 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(restorable.logs.begin(), restorable.logs.end());
															#line 1184 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (isPartitionedLogsContinuous(restorable.logs, minKeyRangeVersion, restorable.targetVersion))
															#line 5630 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 1185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				restorable.continuousBeginVersion = minKeyRangeVersion;
															#line 1186 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				restorable.continuousEndVersion = restorable.targetVersion + 1;
															#line 1187 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(Optional<RestorableFileSet>(restorable)); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5638 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(Optional<RestorableFileSet>(restorable));
				this->~GetRestoreSetActorState();
				static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1189 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(Optional<RestorableFileSet>()); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5646 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(Optional<RestorableFileSet>());
			this->~GetRestoreSetActorState();
			static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1193 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::sort(logs.begin(), logs.end());
															#line 1196 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!logs.empty() && logs.front().beginVersion <= minKeyRangeVersion)
															#line 5656 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1197 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(getRestoreSetFromLogs(logs, targetVersion, restorable)); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5660 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(getRestoreSetFromLogs(logs, targetVersion, restorable));
			this->~GetRestoreSetActorState();
			static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		i--;
															#line 5668 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreSetActor*>(this)->ActorCallback< GetRestoreSetActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreSetActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetRestoreSetActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetRestoreSetActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version targetVersion;
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	VectorRef<KeyRangeRef> keyRangesFilter;
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	bool logsOnly;
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version beginVersion;
															#line 1096 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	RestorableFileSet restorableSet;
															#line 1098 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> logFiles;
															#line 1109 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<KeyspaceSnapshotFile> snapshots;
															#line 1110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int i;
															#line 1117 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	RestorableFileSet restorable;
															#line 1118 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version minKeyRangeVersion;
															#line 1119 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version maxKeyRangeVersion;
															#line 1166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> logs;
															#line 1167 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> plogs;
															#line 5776 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getRestoreSet()
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class GetRestoreSetActor final : public Actor<Optional<RestorableFileSet>>, public ActorCallback< GetRestoreSetActor, 0, Void >, public ActorCallback< GetRestoreSetActor, 1, std::vector<KeyspaceSnapshotFile> >, public ActorCallback< GetRestoreSetActor, 2, std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >, public ActorCallback< GetRestoreSetActor, 3, Void >, public FastAllocated<GetRestoreSetActor>, public GetRestoreSetActorState<GetRestoreSetActor> {
															#line 5781 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetRestoreSetActor>::operator new;
	using FastAllocated<GetRestoreSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14854520375465244672UL, 2946847344291250688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<RestorableFileSet>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRestoreSetActor, 0, Void >;
friend struct ActorCallback< GetRestoreSetActor, 1, std::vector<KeyspaceSnapshotFile> >;
friend struct ActorCallback< GetRestoreSetActor, 2, std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >;
friend struct ActorCallback< GetRestoreSetActor, 3, Void >;
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	GetRestoreSetActor(Reference<BackupContainerFileSystem> const& bc,Version const& targetVersion,VectorRef<KeyRangeRef> const& keyRangesFilter,bool const& logsOnly = false,Version const& beginVersion = invalidVersion) 
															#line 5801 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Optional<RestorableFileSet>>(),
		   GetRestoreSetActorState<GetRestoreSetActor>(bc, targetVersion, keyRangesFilter, logsOnly, beginVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12008909710218968832UL, 11005026045665115392UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRestoreSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRestoreSetActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRestoreSetActor, 1, std::vector<KeyspaceSnapshotFile> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRestoreSetActor, 2, std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetRestoreSetActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Optional<RestorableFileSet>> getRestoreSet( Reference<BackupContainerFileSystem> const& bc, Version const& targetVersion, VectorRef<KeyRangeRef> const& keyRangesFilter, bool const& logsOnly = false, Version const& beginVersion = invalidVersion ) {
															#line 1086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Optional<RestorableFileSet>>(new GetRestoreSetActor(bc, targetVersion, keyRangesFilter, logsOnly, beginVersion));
															#line 5836 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 1202 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

	static std::string versionFolderString(Version v, int smallestBucket) {
		ASSERT_LT(smallestBucket, 14);
		// Get a 0-padded fixed size representation of v
		std::string vFixedPrecision = format("%019lld", v);
		ASSERT_EQ(vFixedPrecision.size(), 19);
		// Truncate smallestBucket from the fixed length representation
		vFixedPrecision.resize(vFixedPrecision.size() - smallestBucket);

		// Split the remaining digits with a '/' 4 places from the right
		vFixedPrecision.insert(vFixedPrecision.size() - 4, 1, '/');

		return vFixedPrecision;
	}

	// This useful for comparing version folder strings regardless of where their "/" dividers are, as it is possible
	// that division points would change in the future.
	static std::string cleanFolderString(std::string f) {
		f.erase(std::remove(f.begin(), f.end(), '/'), f.end());
		return f;
	}

	// The innermost folder covers 100 seconds (1e8 versions) During a full speed backup it is possible though very
	// unlikely write about 10,000 snapshot range files during that time.
	static std::string old_rangeVersionFolderString(Version v) {
		return format("ranges/%s/", versionFolderString(v, 8).c_str());
	}

	// Get the root folder for a snapshot's data based on its begin version
	static std::string snapshotFolderString(Version snapshotBeginVersion) {
		return format("kvranges/snapshot.%018" PRId64, snapshotBeginVersion);
	}

	// Extract the snapshot begin version from a path
	static Version extractSnapshotBeginVersion(const std::string& path) {
		Version snapshotBeginVersion;
		if (sscanf(path.c_str(), "kvranges/snapshot.%018" SCNd64, &snapshotBeginVersion) == 1) {
			return snapshotBeginVersion;
		}
		return invalidVersion;
	}

	// The innermost folder covers 100,000 seconds (1e11 versions) which is 5,000 mutation log files at current
	// settings.
	static std::string logVersionFolderString(Version v, bool partitioned) {
		return format("%s/%s/", (partitioned ? "plogs" : "logs"), versionFolderString(v, 11).c_str());
	}

	static bool pathToLogFile(LogFile& out, const std::string& path, int64_t size) {
		std::string name = fileNameOnly(path);
		LogFile f;
		f.fileName = path;
		f.fileSize = size;
		int len;
		if (sscanf(name.c_str(),
		           "log,%" SCNd64 ",%" SCNd64 ",%*[^,],%u%n",
		           &f.beginVersion,
		           &f.endVersion,
		           &f.blockSize,
		           &len) == 3 &&
		    len == name.size()) {
			out = f;
			return true;
		} else if (sscanf(name.c_str(),
		                  "log,%" SCNd64 ",%" SCNd64 ",%*[^,],%d-of-%d,%u%n",
		                  &f.beginVersion,
		                  &f.endVersion,
		                  &f.tagId,
		                  &f.totalTags,
		                  &f.blockSize,
		                  &len) == 5 &&
		           len == name.size() && f.tagId >= 0) {
			out = f;
			return true;
		}
		return false;
	}

	static bool pathToKeyspaceSnapshotFile(KeyspaceSnapshotFile& out, const std::string& path) {
		std::string name = fileNameOnly(path);
		KeyspaceSnapshotFile f;
		f.fileName = path;
		int len;
		if (sscanf(name.c_str(),
		           "snapshot,%" SCNd64 ",%" SCNd64 ",%" SCNd64 "%n",
		           &f.beginVersion,
		           &f.endVersion,
		           &f.totalSize,
		           &len) == 3 &&
		    len == name.size()) {
			out = f;
			return true;
		}
		return false;
	}

	// fallback for using existing write api if the underlying blob store doesn't support efficient writeEntireFile
																#line 5937 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via writeEntireFileFallback()
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class WriteEntireFileFallbackActor>
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteEntireFileFallbackActorState {
															#line 5943 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteEntireFileFallbackActorState(Reference<BackupContainerFileSystem> const& bc,std::string const& fileName,std::string const& fileContents) 
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   fileName(fileName),
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   fileContents(fileContents)
															#line 5954 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeEntireFileFallback", reinterpret_cast<unsigned long>(this));

	}
	~WriteEntireFileFallbackActorState() 
	{
		fdb_probe_actor_destroy("writeEntireFileFallback", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1302 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Reference<IBackupFile>> __when_expr_0 = bc->writeFile(fileName);
															#line 1302 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5971 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state = 1;
															#line 1302 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteEntireFileFallbackActor, 0, Reference<IBackupFile> >*>(static_cast<WriteEntireFileFallbackActor*>(this)));
															#line 5976 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteEntireFileFallbackActorState();
		static_cast<WriteEntireFileFallbackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1303 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = objectFile->append(&fileContents[0], fileContents.size());
															#line 1303 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6001 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state = 2;
															#line 1303 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteEntireFileFallbackActor, 1, Void >*>(static_cast<WriteEntireFileFallbackActor*>(this)));
															#line 6006 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IBackupFile> const& __objectFile,int loopDepth) 
	{
															#line 1302 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		objectFile = __objectFile;
															#line 6015 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IBackupFile> && __objectFile,int loopDepth) 
	{
		objectFile = std::move(__objectFile);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state > 0) static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<WriteEntireFileFallbackActor*>(this)->ActorCallback< WriteEntireFileFallbackActor, 0, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteEntireFileFallbackActor, 0, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteEntireFileFallbackActor, 0, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteEntireFileFallbackActor, 0, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1304 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = objectFile->finish();
															#line 1304 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6096 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state = 3;
															#line 1304 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteEntireFileFallbackActor, 2, Void >*>(static_cast<WriteEntireFileFallbackActor*>(this)));
															#line 6101 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1304 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = objectFile->finish();
															#line 1304 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6112 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state = 3;
															#line 1304 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteEntireFileFallbackActor, 2, Void >*>(static_cast<WriteEntireFileFallbackActor*>(this)));
															#line 6117 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state > 0) static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<WriteEntireFileFallbackActor*>(this)->ActorCallback< WriteEntireFileFallbackActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteEntireFileFallbackActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteEntireFileFallbackActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteEntireFileFallbackActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1305 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<WriteEntireFileFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteEntireFileFallbackActorState(); static_cast<WriteEntireFileFallbackActor*>(this)->destroy(); return 0; }
															#line 6201 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<WriteEntireFileFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteEntireFileFallbackActorState();
		static_cast<WriteEntireFileFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1305 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<WriteEntireFileFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteEntireFileFallbackActorState(); static_cast<WriteEntireFileFallbackActor*>(this)->destroy(); return 0; }
															#line 6213 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<WriteEntireFileFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteEntireFileFallbackActorState();
		static_cast<WriteEntireFileFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state > 0) static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<WriteEntireFileFallbackActor*>(this)->ActorCallback< WriteEntireFileFallbackActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteEntireFileFallbackActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteEntireFileFallbackActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteEntireFileFallbackActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string fileName;
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string fileContents;
															#line 1302 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> objectFile;
															#line 6304 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeEntireFileFallback()
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteEntireFileFallbackActor final : public Actor<Void>, public ActorCallback< WriteEntireFileFallbackActor, 0, Reference<IBackupFile> >, public ActorCallback< WriteEntireFileFallbackActor, 1, Void >, public ActorCallback< WriteEntireFileFallbackActor, 2, Void >, public FastAllocated<WriteEntireFileFallbackActor>, public WriteEntireFileFallbackActorState<WriteEntireFileFallbackActor> {
															#line 6309 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteEntireFileFallbackActor>::operator new;
	using FastAllocated<WriteEntireFileFallbackActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5990346504771453440UL, 16629278603265815808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteEntireFileFallbackActor, 0, Reference<IBackupFile> >;
friend struct ActorCallback< WriteEntireFileFallbackActor, 1, Void >;
friend struct ActorCallback< WriteEntireFileFallbackActor, 2, Void >;
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteEntireFileFallbackActor(Reference<BackupContainerFileSystem> const& bc,std::string const& fileName,std::string const& fileContents) 
															#line 6328 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteEntireFileFallbackActorState<WriteEntireFileFallbackActor>(bc, fileName, fileContents),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1619473515880821760UL, 4362335262871378176UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeEntireFileFallback");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteEntireFileFallbackActor, 0, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteEntireFileFallbackActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteEntireFileFallbackActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Void> writeEntireFileFallback( Reference<BackupContainerFileSystem> const& bc, std::string const& fileName, std::string const& fileContents ) {
															#line 1299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new WriteEntireFileFallbackActor(bc, fileName, fileContents));
															#line 6362 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 1307 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

																#line 6367 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via createTestEncryptionKeyFile()
															#line 1308 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class CreateTestEncryptionKeyFileActor>
															#line 1308 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class CreateTestEncryptionKeyFileActorState {
															#line 6373 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 1308 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	CreateTestEncryptionKeyFileActorState(std::string const& filename) 
															#line 1308 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1308 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : filename(filename)
															#line 6380 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this));

	}
	~CreateTestEncryptionKeyFileActorState() 
	{
		fdb_probe_actor_destroy("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1309 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (fileExists(filename))
															#line 6395 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 1312 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent("EncryptionKeyFileExists").detail("FileName", filename);
															#line 1313 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!static_cast<CreateTestEncryptionKeyFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTestEncryptionKeyFileActorState(); static_cast<CreateTestEncryptionKeyFileActor*>(this)->destroy(); return 0; }
															#line 6401 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				new (&static_cast<CreateTestEncryptionKeyFileActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CreateTestEncryptionKeyFileActorState();
				static_cast<CreateTestEncryptionKeyFileActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( filename, IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_CREATE, 0600);
															#line 1315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<CreateTestEncryptionKeyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6411 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateTestEncryptionKeyFileActor*>(this)->actor_wait_state = 1;
															#line 1315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateTestEncryptionKeyFileActor, 0, Reference<IAsyncFile> >*>(static_cast<CreateTestEncryptionKeyFileActor*>(this)));
															#line 6416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateTestEncryptionKeyFileActorState();
		static_cast<CreateTestEncryptionKeyFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StreamCipherKey testKey(AES_256_KEY_LENGTH);
															#line 1320 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		testKey.initializeRandomTestKey();
															#line 1321 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		keyFile->write(testKey.data(), testKey.size(), 0);
															#line 1322 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = keyFile->sync();
															#line 1322 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<CreateTestEncryptionKeyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateTestEncryptionKeyFileActor*>(this)->actor_wait_state = 2;
															#line 1322 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateTestEncryptionKeyFileActor, 1, Void >*>(static_cast<CreateTestEncryptionKeyFileActor*>(this)));
															#line 6452 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __keyFile,int loopDepth) 
	{
															#line 1315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		keyFile = __keyFile;
															#line 6461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __keyFile,int loopDepth) 
	{
		keyFile = std::move(__keyFile);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateTestEncryptionKeyFileActor*>(this)->actor_wait_state > 0) static_cast<CreateTestEncryptionKeyFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTestEncryptionKeyFileActor*>(this)->ActorCallback< CreateTestEncryptionKeyFileActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTestEncryptionKeyFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTestEncryptionKeyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateTestEncryptionKeyFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTestEncryptionKeyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateTestEncryptionKeyFileActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTestEncryptionKeyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1323 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<CreateTestEncryptionKeyFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTestEncryptionKeyFileActorState(); static_cast<CreateTestEncryptionKeyFileActor*>(this)->destroy(); return 0; }
															#line 6540 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<CreateTestEncryptionKeyFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateTestEncryptionKeyFileActorState();
		static_cast<CreateTestEncryptionKeyFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1323 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<CreateTestEncryptionKeyFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTestEncryptionKeyFileActorState(); static_cast<CreateTestEncryptionKeyFileActor*>(this)->destroy(); return 0; }
															#line 6552 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<CreateTestEncryptionKeyFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateTestEncryptionKeyFileActorState();
		static_cast<CreateTestEncryptionKeyFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateTestEncryptionKeyFileActor*>(this)->actor_wait_state > 0) static_cast<CreateTestEncryptionKeyFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTestEncryptionKeyFileActor*>(this)->ActorCallback< CreateTestEncryptionKeyFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTestEncryptionKeyFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTestEncryptionKeyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateTestEncryptionKeyFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTestEncryptionKeyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateTestEncryptionKeyFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTestEncryptionKeyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1308 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string filename;
															#line 1315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IAsyncFile> keyFile;
															#line 6639 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via createTestEncryptionKeyFile()
															#line 1308 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class CreateTestEncryptionKeyFileActor final : public Actor<Void>, public ActorCallback< CreateTestEncryptionKeyFileActor, 0, Reference<IAsyncFile> >, public ActorCallback< CreateTestEncryptionKeyFileActor, 1, Void >, public FastAllocated<CreateTestEncryptionKeyFileActor>, public CreateTestEncryptionKeyFileActorState<CreateTestEncryptionKeyFileActor> {
															#line 6644 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<CreateTestEncryptionKeyFileActor>::operator new;
	using FastAllocated<CreateTestEncryptionKeyFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6940157056393090048UL, 4636044073015155200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateTestEncryptionKeyFileActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< CreateTestEncryptionKeyFileActor, 1, Void >;
															#line 1308 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	CreateTestEncryptionKeyFileActor(std::string const& filename) 
															#line 6662 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CreateTestEncryptionKeyFileActorState<CreateTestEncryptionKeyFileActor>(filename),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7353405283783222784UL, 17494758805968910080UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTestEncryptionKeyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createTestEncryptionKeyFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateTestEncryptionKeyFileActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateTestEncryptionKeyFileActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1308 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Void> createTestEncryptionKeyFile( std::string const& filename ) {
															#line 1308 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new CreateTestEncryptionKeyFileActor(filename));
															#line 6695 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 1325 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

																#line 6700 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via readEncryptionKey()
															#line 1326 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class ReadEncryptionKeyActor>
															#line 1326 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class ReadEncryptionKeyActorState {
															#line 6706 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 1326 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	ReadEncryptionKeyActorState(std::string const& encryptionKeyFileName) 
															#line 1326 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1326 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : encryptionKeyFileName(encryptionKeyFileName),
															#line 1327 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   keyFile(),
															#line 1328 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   cipherKey(StreamCipherKey::getGlobalCipherKey())
															#line 6717 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readEncryptionKey", reinterpret_cast<unsigned long>(this));

	}
	~ReadEncryptionKeyActorState() 
	{
		fdb_probe_actor_destroy("readEncryptionKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1330 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( encryptionKeyFileName, IAsyncFile::OPEN_NO_AIO | IAsyncFile::OPEN_READONLY | IAsyncFile::OPEN_UNCACHED, 0400);
															#line 1330 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<ReadEncryptionKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6735 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadEncryptionKeyActor*>(this)->actor_wait_state = 1;
															#line 1330 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadEncryptionKeyActor, 0, Reference<IAsyncFile> >*>(static_cast<ReadEncryptionKeyActor*>(this)));
															#line 6740 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadEncryptionKeyActorState();
		static_cast<ReadEncryptionKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<int> __when_expr_1 = keyFile->read(cipherKey->data(), cipherKey->size(), 0);
															#line 1341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ReadEncryptionKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6771 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadEncryptionKeyActor*>(this)->actor_wait_state = 2;
															#line 1341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadEncryptionKeyActor, 1, int >*>(static_cast<ReadEncryptionKeyActor*>(this)));
															#line 6776 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1336 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "FailedToOpenEncryptionKeyFile") .error(e) .detail("FileName", encryptionKeyFileName);
															#line 1339 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 6788 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Reference<IAsyncFile> const& _keyFile,int loopDepth) 
	{
															#line 1334 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		keyFile = _keyFile;
															#line 6802 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Reference<IAsyncFile> && _keyFile,int loopDepth) 
	{
															#line 1334 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		keyFile = _keyFile;
															#line 6811 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& _keyFile,int loopDepth) 
	{
		loopDepth = a_body1cont2(_keyFile, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && _keyFile,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_keyFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadEncryptionKeyActor*>(this)->actor_wait_state > 0) static_cast<ReadEncryptionKeyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadEncryptionKeyActor*>(this)->ActorCallback< ReadEncryptionKeyActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadEncryptionKeyActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("readEncryptionKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadEncryptionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readEncryptionKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadEncryptionKeyActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("readEncryptionKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadEncryptionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readEncryptionKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadEncryptionKeyActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("readEncryptionKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadEncryptionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readEncryptionKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int const& bytesRead,int loopDepth) 
	{
															#line 1342 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (bytesRead != cipherKey->size())
															#line 6908 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1343 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "InvalidEncryptionKeyFileSize") .detail("ExpectedSize", cipherKey->size()) .detail("ActualSize", bytesRead);
															#line 1346 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(invalid_encryption_key_file(), loopDepth);
															#line 6914 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 1348 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(bytesRead, cipherKey->size());
															#line 1349 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<ReadEncryptionKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadEncryptionKeyActorState(); static_cast<ReadEncryptionKeyActor*>(this)->destroy(); return 0; }
															#line 6920 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<ReadEncryptionKeyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadEncryptionKeyActorState();
		static_cast<ReadEncryptionKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(int && bytesRead,int loopDepth) 
	{
															#line 1342 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (bytesRead != cipherKey->size())
															#line 6932 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1343 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "InvalidEncryptionKeyFileSize") .detail("ExpectedSize", cipherKey->size()) .detail("ActualSize", bytesRead);
															#line 1346 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(invalid_encryption_key_file(), loopDepth);
															#line 6938 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 1348 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(bytesRead, cipherKey->size());
															#line 1349 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<ReadEncryptionKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadEncryptionKeyActorState(); static_cast<ReadEncryptionKeyActor*>(this)->destroy(); return 0; }
															#line 6944 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<ReadEncryptionKeyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadEncryptionKeyActorState();
		static_cast<ReadEncryptionKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont5(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadEncryptionKeyActor*>(this)->actor_wait_state > 0) static_cast<ReadEncryptionKeyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadEncryptionKeyActor*>(this)->ActorCallback< ReadEncryptionKeyActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< ReadEncryptionKeyActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readEncryptionKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadEncryptionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readEncryptionKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadEncryptionKeyActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("readEncryptionKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadEncryptionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readEncryptionKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadEncryptionKeyActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("readEncryptionKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadEncryptionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readEncryptionKey", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1326 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string encryptionKeyFileName;
															#line 1327 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IAsyncFile> keyFile;
															#line 1328 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	StreamCipherKey const* cipherKey;
															#line 7033 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readEncryptionKey()
															#line 1326 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class ReadEncryptionKeyActor final : public Actor<Void>, public ActorCallback< ReadEncryptionKeyActor, 0, Reference<IAsyncFile> >, public ActorCallback< ReadEncryptionKeyActor, 1, int >, public FastAllocated<ReadEncryptionKeyActor>, public ReadEncryptionKeyActorState<ReadEncryptionKeyActor> {
															#line 7038 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadEncryptionKeyActor>::operator new;
	using FastAllocated<ReadEncryptionKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1140282475523988480UL, 6555565591015877888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadEncryptionKeyActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< ReadEncryptionKeyActor, 1, int >;
															#line 1326 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	ReadEncryptionKeyActor(std::string const& encryptionKeyFileName) 
															#line 7056 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ReadEncryptionKeyActorState<ReadEncryptionKeyActor>(encryptionKeyFileName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readEncryptionKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10298366554447832320UL, 8112828672925133056UL);
		ActorExecutionContextHelper __helper(static_cast<ReadEncryptionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readEncryptionKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readEncryptionKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadEncryptionKeyActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadEncryptionKeyActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1326 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Void> readEncryptionKey( std::string const& encryptionKeyFileName ) {
															#line 1326 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new ReadEncryptionKeyActor(encryptionKeyFileName));
															#line 7089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 1351 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

																#line 7094 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via writeEncryptionMetadataIfNotExists()
															#line 1352 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class WriteEncryptionMetadataIfNotExistsActor>
															#line 1352 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteEncryptionMetadataIfNotExistsActorState {
															#line 7100 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 1352 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteEncryptionMetadataIfNotExistsActorState(Reference<BackupContainerFileSystem> const& bc) 
															#line 1352 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1352 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc)
															#line 7107 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this));

	}
	~WriteEncryptionMetadataIfNotExistsActorState() 
	{
		fdb_probe_actor_destroy("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1353 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Optional<Version>> __when_expr_0 = bc->fileLevelEncryption().get();
															#line 1353 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7124 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state = 1;
															#line 1353 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 0, Optional<Version> >*>(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)));
															#line 7129 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteEncryptionMetadataIfNotExistsActorState();
		static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Version> const& existingEncryptionMetadata,int loopDepth) 
	{
															#line 1355 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!existingEncryptionMetadata.present())
															#line 7152 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1356 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<bool> __when_expr_1 = bc->exists();
															#line 1356 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7158 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state = 2;
															#line 1356 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, bool >*>(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)));
															#line 7163 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Optional<Version> && existingEncryptionMetadata,int loopDepth) 
	{
															#line 1355 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!existingEncryptionMetadata.present())
															#line 7177 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1356 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<bool> __when_expr_1 = bc->exists();
															#line 1356 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7183 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state = 2;
															#line 1356 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, bool >*>(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)));
															#line 7188 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Optional<Version> const& existingEncryptionMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont1(existingEncryptionMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Version> && existingEncryptionMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(existingEncryptionMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state > 0) static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state = 0;
		static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 0, Optional<Version> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 0, Optional<Version> >*,Optional<Version> const& value) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 0, Optional<Version> >*,Optional<Version> && value) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 0, Optional<Version> >*,Error err) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1362 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteEncryptionMetadataIfNotExistsActorState(); static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->destroy(); return 0; }
															#line 7277 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteEncryptionMetadataIfNotExistsActorState();
		static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(bool const& exists,int loopDepth) 
	{
															#line 1357 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!exists)
															#line 7289 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1358 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_2 = bc->create();
															#line 1358 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7295 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state = 3;
															#line 1358 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 2, Void >*>(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)));
															#line 7300 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(bool && exists,int loopDepth) 
	{
															#line 1357 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!exists)
															#line 7314 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1358 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_2 = bc->create();
															#line 1358 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7320 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state = 3;
															#line 1358 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 2, Void >*>(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)));
															#line 7325 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(bool const& exists,int loopDepth) 
	{
		loopDepth = a_body1cont3(exists, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && exists,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(exists), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state > 0) static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state = 0;
		static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1360 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_3 = bc->fileLevelEncryption().set(bc->encryptionKeyFileName.present() ? 1 : 0);
															#line 1360 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7416 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state = 4;
															#line 1360 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 3, Void >*>(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)));
															#line 7421 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state > 0) static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state = 0;
		static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state > 0) static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state = 0;
		static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1352 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 7602 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeEncryptionMetadataIfNotExists()
															#line 1352 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteEncryptionMetadataIfNotExistsActor final : public Actor<Void>, public ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 0, Optional<Version> >, public ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, bool >, public ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 2, Void >, public ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 3, Void >, public FastAllocated<WriteEncryptionMetadataIfNotExistsActor>, public WriteEncryptionMetadataIfNotExistsActorState<WriteEncryptionMetadataIfNotExistsActor> {
															#line 7607 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteEncryptionMetadataIfNotExistsActor>::operator new;
	using FastAllocated<WriteEncryptionMetadataIfNotExistsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(130187554304135168UL, 1690251714954677248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 0, Optional<Version> >;
friend struct ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, bool >;
friend struct ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 2, Void >;
friend struct ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 3, Void >;
															#line 1352 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteEncryptionMetadataIfNotExistsActor(Reference<BackupContainerFileSystem> const& bc) 
															#line 7627 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteEncryptionMetadataIfNotExistsActorState<WriteEncryptionMetadataIfNotExistsActor>(bc),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9737599539893382656UL, 3476537158842691328UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeEncryptionMetadataIfNotExists");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 0, Optional<Version> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1352 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Void> writeEncryptionMetadataIfNotExists( Reference<BackupContainerFileSystem> const& bc ) {
															#line 1352 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new WriteEncryptionMetadataIfNotExistsActor(bc));
															#line 7662 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 1364 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

}; // class BackupContainerFileSystemImpl

Future<Reference<IBackupFile>> BackupContainerFileSystem::writeLogFile(Version beginVersion,
                                                                       Version endVersion,
                                                                       int blockSize) {
	return writeFile(BackupContainerFileSystemImpl::logVersionFolderString(beginVersion, false) +
	                 format("log,%lld,%lld,%s,%d",
	                        beginVersion,
	                        endVersion,
	                        deterministicRandom()->randomUniqueID().toString().c_str(),
	                        blockSize));
}

Future<Reference<IBackupFile>> BackupContainerFileSystem::writeTaggedLogFile(Version beginVersion,
                                                                             Version endVersion,
                                                                             int blockSize,
                                                                             uint16_t tagId,
                                                                             int totalTags) {
	return writeFile(BackupContainerFileSystemImpl::logVersionFolderString(beginVersion, true) +
	                 format("log,%lld,%lld,%s,%d-of-%d,%d",
	                        beginVersion,
	                        endVersion,
	                        deterministicRandom()->randomUniqueID().toString().c_str(),
	                        tagId,
	                        totalTags,
	                        blockSize));
}

Future<Reference<IBackupFile>> BackupContainerFileSystem::writeRangeFile(Version snapshotBeginVersion,
                                                                         int snapshotFileCount,
                                                                         Version fileVersion,
                                                                         int blockSize) {
	std::string fileName = format(
	    "range,%" PRId64 ",%s,%d", fileVersion, deterministicRandom()->randomUniqueID().toString().c_str(), blockSize);

	// In order to test backward compatibility in simulation, sometimes write to the old path format
	if (g_network->isSimulated() && deterministicRandom()->coinflip()) {
		return writeFile(BackupContainerFileSystemImpl::old_rangeVersionFolderString(fileVersion) + fileName);
	}

	return writeFile(BackupContainerFileSystemImpl::snapshotFolderString(snapshotBeginVersion) +
	                 format("/%d/", snapshotFileCount / (BUGGIFY ? 1 : 5000)) + fileName);
}

Future<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>>
BackupContainerFileSystem::readKeyspaceSnapshot(KeyspaceSnapshotFile snapshot) {
	return BackupContainerFileSystemImpl::readKeyspaceSnapshot(Reference<BackupContainerFileSystem>::addRef(this),
	                                                           snapshot);
}

Future<Void> BackupContainerFileSystem::writeKeyspaceSnapshotFile(const std::vector<std::string>& fileNames,
                                                                  const std::vector<std::pair<Key, Key>>& beginEndKeys,
                                                                  int64_t totalBytes,
                                                                  IncludeKeyRangeMap includeKeyRangeMap,
                                                                  Optional<SnapshotMetadata> metadata) {
	return BackupContainerFileSystemImpl::writeKeyspaceSnapshotFile(Reference<BackupContainerFileSystem>::addRef(this),
	                                                                fileNames,
	                                                                beginEndKeys,
	                                                                totalBytes,
	                                                                includeKeyRangeMap,
	                                                                metadata);
};

Future<std::vector<LogFile>> BackupContainerFileSystem::listLogFiles(Version beginVersion,
                                                                     Version targetVersion,
                                                                     bool partitioned) {
	// The first relevant log file could have a begin version less than beginVersion based on the knobs which
	// determine log file range size, so start at an earlier version adjusted by how many versions a file could
	// contain.
	//
	// Get the cleaned (without slashes) first and last folders that could contain relevant results.
	std::string firstPath =
	    BackupContainerFileSystemImpl::cleanFolderString(BackupContainerFileSystemImpl::logVersionFolderString(
	        std::max<Version>(0,
	                          beginVersion - CLIENT_KNOBS->BACKUP_MAX_LOG_RANGES * CLIENT_KNOBS->LOG_RANGE_BLOCK_SIZE),
	        partitioned));
	std::string lastPath = BackupContainerFileSystemImpl::cleanFolderString(
	    BackupContainerFileSystemImpl::logVersionFolderString(targetVersion, partitioned));

	std::function<bool(std::string const&)> pathFilter = [=](const std::string& folderPath) {
		// Remove slashes in the given folder path so that the '/' positions in the version folder string do not
		// matter

		std::string cleaned = BackupContainerFileSystemImpl::cleanFolderString(folderPath);
		return StringRef(firstPath).startsWith(cleaned) || StringRef(lastPath).startsWith(cleaned) ||
		       (cleaned > firstPath && cleaned < lastPath);
	};

	return map(listFiles((partitioned ? "plogs/" : "logs/"), pathFilter), [=](const FilesAndSizesT& files) {
		std::vector<LogFile> results;
		LogFile lf;
		for (auto& f : files) {
			if (BackupContainerFileSystemImpl::pathToLogFile(lf, f.first, f.second) && lf.endVersion > beginVersion &&
			    lf.beginVersion <= targetVersion)
				results.push_back(lf);
		}
		return results;
	});
}

Future<std::vector<RangeFile>> BackupContainerFileSystem::old_listRangeFiles(Version beginVersion, Version endVersion) {
	// Get the cleaned (without slashes) first and last folders that could contain relevant results.
	std::string firstPath = BackupContainerFileSystemImpl::cleanFolderString(
	    BackupContainerFileSystemImpl::old_rangeVersionFolderString(beginVersion));
	std::string lastPath = BackupContainerFileSystemImpl::cleanFolderString(
	    BackupContainerFileSystemImpl::old_rangeVersionFolderString(endVersion));

	std::function<bool(std::string const&)> pathFilter = [=](const std::string& folderPath) {
		// Remove slashes in the given folder path so that the '/' positions in the version folder string do not
		// matter
		std::string cleaned = BackupContainerFileSystemImpl::cleanFolderString(folderPath);

		return StringRef(firstPath).startsWith(cleaned) || StringRef(lastPath).startsWith(cleaned) ||
		       (cleaned > firstPath && cleaned < lastPath);
	};

	return map(listFiles("ranges/", pathFilter), [=](const FilesAndSizesT& files) {
		std::vector<RangeFile> results;
		RangeFile rf;
		for (auto& f : files) {
			if (BackupContainerFileSystemImpl::pathToRangeFile(rf, f.first, f.second) && rf.version >= beginVersion &&
			    rf.version <= endVersion)
				results.push_back(rf);
		}
		return results;
	});
}

Future<std::vector<RangeFile>> BackupContainerFileSystem::listRangeFiles(Version beginVersion, Version endVersion) {
	// Until the old folder scheme is no longer supported, read files stored using old folder scheme
	Future<std::vector<RangeFile>> oldFiles = old_listRangeFiles(beginVersion, endVersion);

	// Define filter function (for listFiles() implementations that use it) to reject any folder
	// starting after endVersion
	std::function<bool(std::string const&)> pathFilter = [=](std::string const& path) {
		return BackupContainerFileSystemImpl::extractSnapshotBeginVersion(path) <= endVersion;
	};

	Future<std::vector<RangeFile>> newFiles = map(listFiles("kvranges/", pathFilter), [=](const FilesAndSizesT& files) {
		std::vector<RangeFile> results;
		RangeFile rf;
		for (auto& f : files) {
			if (BackupContainerFileSystemImpl::pathToRangeFile(rf, f.first, f.second) && rf.version >= beginVersion &&
			    rf.version <= endVersion)
				results.push_back(rf);
		}
		return results;
	});

	return map(success(oldFiles) && success(newFiles), [=](Void _) {
		std::vector<RangeFile> results = std::move(newFiles.get());
		std::vector<RangeFile> oldResults = std::move(oldFiles.get());
		results.insert(
		    results.end(), std::make_move_iterator(oldResults.begin()), std::make_move_iterator(oldResults.end()));
		return results;
	});
}

Future<std::vector<KeyspaceSnapshotFile>> BackupContainerFileSystem::listKeyspaceSnapshots(Version begin, Version end) {
	return map(listFiles("snapshots/"), [=](const FilesAndSizesT& files) {
		std::vector<KeyspaceSnapshotFile> results;
		KeyspaceSnapshotFile sf;
		for (auto& f : files) {
			if (BackupContainerFileSystemImpl::pathToKeyspaceSnapshotFile(sf, f.first) && sf.beginVersion < end &&
			    sf.endVersion >= begin)
				results.push_back(sf);
		}
		std::sort(results.begin(), results.end());
		return results;
	});
}

Future<BackupFileList> BackupContainerFileSystem::dumpFileList(Version begin, Version end) {
	return BackupContainerFileSystemImpl::dumpFileList(Reference<BackupContainerFileSystem>::addRef(this), begin, end);
}

Future<BackupDescription> BackupContainerFileSystem::describeBackup(bool deepScan, Version logStartVersionOverride) {
	return BackupContainerFileSystemImpl::describeBackup(
	    Reference<BackupContainerFileSystem>::addRef(this), deepScan, logStartVersionOverride);
}

Future<Void> BackupContainerFileSystem::expireData(Version expireEndVersion,
                                                   bool force,
                                                   ExpireProgress* progress,
                                                   Version restorableBeginVersion) {
	return BackupContainerFileSystemImpl::expireData(
	    Reference<BackupContainerFileSystem>::addRef(this), expireEndVersion, force, progress, restorableBeginVersion);
}

Future<Void> BackupContainerFileSystem::writeEncryptionMetadata() {
	return BackupContainerFileSystemImpl::writeEncryptionMetadataIfNotExists(
	    Reference<BackupContainerFileSystem>::addRef(this));
}

															#line 7861 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getSnapshotFileKeyRange_impl()
															#line 1559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class GetSnapshotFileKeyRange_implActor>
															#line 1559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class GetSnapshotFileKeyRange_implActorState {
															#line 7868 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 1559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	GetSnapshotFileKeyRange_implActorState(Reference<BackupContainerFileSystem> const& bc,RangeFile const& file,Database const& cx) 
															#line 1559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 1559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   file(file),
															#line 1559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   cx(cx),
															#line 1562 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   readFileRetries(0),
															#line 1563 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   beginKeySet(false),
															#line 1564 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   beginKey(),
															#line 1565 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   endKey()
															#line 7887 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this));

	}
	~GetSnapshotFileKeyRange_implActorState() 
	{
		fdb_probe_actor_destroy("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1566 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			;
															#line 7902 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetSnapshotFileKeyRange_implActorState();
		static_cast<GetSnapshotFileKeyRange_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1600 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<GetSnapshotFileKeyRange_implActor*>(this)->SAV<KeyRange>::futures) { (void)(KeyRange(KeyRangeRef(beginKey, endKey))); this->~GetSnapshotFileKeyRange_implActorState(); static_cast<GetSnapshotFileKeyRange_implActor*>(this)->destroy(); return 0; }
															#line 7925 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<GetSnapshotFileKeyRange_implActor*>(this)->SAV< KeyRange >::value()) KeyRange(KeyRange(KeyRangeRef(beginKey, endKey)));
		this->~GetSnapshotFileKeyRange_implActorState();
		static_cast<GetSnapshotFileKeyRange_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1568 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = bc->readFile(file.fileName);
															#line 1568 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7947 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state = 1;
															#line 1568 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotFileKeyRange_implActor, 0, Reference<IAsyncFile> >*>(static_cast<GetSnapshotFileKeyRange_implActor*>(this)));
															#line 7952 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1583 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (e.code() == error_code_restore_bad_read || e.code() == error_code_restore_unsupported_file_version || e.code() == error_code_restore_corrupted_data_padding)
															#line 7987 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 1585 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent(SevError, "BackupContainerGetSnapshotFileKeyRange").error(e);
															#line 1586 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7993 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1587 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (e.code() == error_code_http_request_failed || e.code() == error_code_connection_failed || e.code() == error_code_timed_out || e.code() == error_code_lookup_failed)
															#line 7999 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 1590 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					TraceEvent(SevWarnAlways, "BackupContainerGetSnapshotFileKeyRangeConnectionFailure") .error(e) .detail("Retries", ++readFileRetries);
															#line 1593 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					StrictFuture<Void> __when_expr_2 = delayJittered(0.1);
															#line 1593 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					if (static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8007 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
					static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state = 3;
															#line 1593 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotFileKeyRange_implActor, 2, Void >*>(static_cast<GetSnapshotFileKeyRange_implActor*>(this)));
															#line 8012 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 1595 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					TraceEvent(SevError, "BackupContainerGetSnapshotFileKeyRangeUnexpectedError").error(e);
															#line 1596 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 8021 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1569 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		beginKeySet = false;
															#line 1570 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		j = 0;
															#line 1571 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 8041 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<IAsyncFile> const& __inFile,int loopDepth) 
	{
															#line 1568 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		inFile = __inFile;
															#line 8050 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<IAsyncFile> && __inFile,int loopDepth) 
	{
		inFile = std::move(__inFile);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotFileKeyRange_implActor*>(this)->ActorCallback< GetSnapshotFileKeyRange_implActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotFileKeyRange_implActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetSnapshotFileKeyRange_implActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetSnapshotFileKeyRange_implActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 1571 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(j < file.fileSize))
															#line 8142 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1572 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int64_t len = std::min<int64_t>(file.blockSize, file.fileSize - j);
															#line 1573 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyValueRef>>> __when_expr_1 = fileBackup::decodeRangeFileBlock(inFile, j, len, cx);
															#line 1573 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8152 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state = 2;
															#line 1573 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotFileKeyRange_implActor, 1, Standalone<VectorRef<KeyValueRef>> >*>(static_cast<GetSnapshotFileKeyRange_implActor*>(this)));
															#line 8157 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Standalone<VectorRef<KeyValueRef>> const& blockData,int loopDepth) 
	{
															#line 1575 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!beginKeySet)
															#line 8179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1576 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			beginKey = blockData.front().key;
															#line 1577 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			beginKeySet = true;
															#line 8185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 1579 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		endKey = blockData.back().key;
															#line 1571 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		j += file.blockSize;
															#line 8191 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Standalone<VectorRef<KeyValueRef>> && blockData,int loopDepth) 
	{
															#line 1575 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!beginKeySet)
															#line 8200 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1576 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			beginKey = blockData.front().key;
															#line 1577 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			beginKeySet = true;
															#line 8206 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 1579 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		endKey = blockData.back().key;
															#line 1571 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		j += file.blockSize;
															#line 8212 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Standalone<VectorRef<KeyValueRef>> const& blockData,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(blockData, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Standalone<VectorRef<KeyValueRef>> && blockData,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(blockData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotFileKeyRange_implActor*>(this)->ActorCallback< GetSnapshotFileKeyRange_implActor, 1, Standalone<VectorRef<KeyValueRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotFileKeyRange_implActor, 1, Standalone<VectorRef<KeyValueRef>> >*,Standalone<VectorRef<KeyValueRef>> const& value) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetSnapshotFileKeyRange_implActor, 1, Standalone<VectorRef<KeyValueRef>> >*,Standalone<VectorRef<KeyValueRef>> && value) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetSnapshotFileKeyRange_implActor, 1, Standalone<VectorRef<KeyValueRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotFileKeyRange_implActor*>(this)->ActorCallback< GetSnapshotFileKeyRange_implActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotFileKeyRange_implActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetSnapshotFileKeyRange_implActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetSnapshotFileKeyRange_implActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 1559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	RangeFile file;
															#line 1559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Database cx;
															#line 1562 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int readFileRetries;
															#line 1563 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	bool beginKeySet;
															#line 1564 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key beginKey;
															#line 1565 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key endKey;
															#line 1568 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IAsyncFile> inFile;
															#line 1570 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int64_t j;
															#line 8409 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getSnapshotFileKeyRange_impl()
															#line 1559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class GetSnapshotFileKeyRange_implActor final : public Actor<KeyRange>, public ActorCallback< GetSnapshotFileKeyRange_implActor, 0, Reference<IAsyncFile> >, public ActorCallback< GetSnapshotFileKeyRange_implActor, 1, Standalone<VectorRef<KeyValueRef>> >, public ActorCallback< GetSnapshotFileKeyRange_implActor, 2, Void >, public FastAllocated<GetSnapshotFileKeyRange_implActor>, public GetSnapshotFileKeyRange_implActorState<GetSnapshotFileKeyRange_implActor> {
															#line 8414 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetSnapshotFileKeyRange_implActor>::operator new;
	using FastAllocated<GetSnapshotFileKeyRange_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4182042511925463040UL, 10748013414359492608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<KeyRange>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetSnapshotFileKeyRange_implActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< GetSnapshotFileKeyRange_implActor, 1, Standalone<VectorRef<KeyValueRef>> >;
friend struct ActorCallback< GetSnapshotFileKeyRange_implActor, 2, Void >;
															#line 1559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	GetSnapshotFileKeyRange_implActor(Reference<BackupContainerFileSystem> const& bc,RangeFile const& file,Database const& cx) 
															#line 8433 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<KeyRange>(),
		   GetSnapshotFileKeyRange_implActorState<GetSnapshotFileKeyRange_implActor>(bc, file, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7397033236399725056UL, 9079865723238831872UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getSnapshotFileKeyRange_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetSnapshotFileKeyRange_implActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetSnapshotFileKeyRange_implActor, 1, Standalone<VectorRef<KeyValueRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetSnapshotFileKeyRange_implActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<KeyRange> getSnapshotFileKeyRange_impl( Reference<BackupContainerFileSystem> const& bc, RangeFile const& file, Database const& cx ) {
															#line 1559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<KeyRange>(new GetSnapshotFileKeyRange_implActor(bc, file, cx));
															#line 8468 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 1602 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 8473 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via writeVersionProperty()
															#line 1603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class WriteVersionPropertyActor>
															#line 1603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteVersionPropertyActorState {
															#line 8480 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 1603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteVersionPropertyActorState(Reference<BackupContainerFileSystem> const& bc,std::string const& path,Version const& v) 
															#line 1603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 1603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   path(path),
															#line 1603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   v(v)
															#line 8491 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeVersionProperty", reinterpret_cast<unsigned long>(this));

	}
	~WriteVersionPropertyActorState() 
	{
		fdb_probe_actor_destroy("writeVersionProperty", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1605 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Reference<IBackupFile>> __when_expr_0 = bc->writeFile(path);
															#line 1605 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8509 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state = 1;
															#line 1605 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteVersionPropertyActor, 0, Reference<IBackupFile> >*>(static_cast<WriteVersionPropertyActor*>(this)));
															#line 8514 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteVersionPropertyActorState();
		static_cast<WriteVersionPropertyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1611 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarn, "BackupContainerWritePropertyFailed") .error(e) .detail("URL", bc->getURL()) .detail("Path", path);
															#line 1615 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 8546 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1606 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::string s = format("%lld", v);
															#line 1607 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f->append(s.data(), s.size());
															#line 1607 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8564 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state = 2;
															#line 1607 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteVersionPropertyActor, 1, Void >*>(static_cast<WriteVersionPropertyActor*>(this)));
															#line 8569 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IBackupFile> const& __f,int loopDepth) 
	{
															#line 1605 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		f = __f;
															#line 8578 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IBackupFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state > 0) static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state = 0;
		static_cast<WriteVersionPropertyActor*>(this)->ActorCallback< WriteVersionPropertyActor, 0, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteVersionPropertyActor, 0, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteVersionPropertyActor, 0, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteVersionPropertyActor, 0, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1608 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->finish();
															#line 1608 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8659 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state = 3;
															#line 1608 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteVersionPropertyActor, 2, Void >*>(static_cast<WriteVersionPropertyActor*>(this)));
															#line 8664 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1608 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->finish();
															#line 1608 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8675 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state = 3;
															#line 1608 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteVersionPropertyActor, 2, Void >*>(static_cast<WriteVersionPropertyActor*>(this)));
															#line 8680 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state > 0) static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state = 0;
		static_cast<WriteVersionPropertyActor*>(this)->ActorCallback< WriteVersionPropertyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteVersionPropertyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteVersionPropertyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteVersionPropertyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1609 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<WriteVersionPropertyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteVersionPropertyActorState(); static_cast<WriteVersionPropertyActor*>(this)->destroy(); return 0; }
															#line 8764 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<WriteVersionPropertyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteVersionPropertyActorState();
		static_cast<WriteVersionPropertyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1609 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<WriteVersionPropertyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteVersionPropertyActorState(); static_cast<WriteVersionPropertyActor*>(this)->destroy(); return 0; }
															#line 8776 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<WriteVersionPropertyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteVersionPropertyActorState();
		static_cast<WriteVersionPropertyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state > 0) static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state = 0;
		static_cast<WriteVersionPropertyActor*>(this)->ActorCallback< WriteVersionPropertyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteVersionPropertyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteVersionPropertyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteVersionPropertyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 1603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string path;
															#line 1603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version v;
															#line 1605 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> f;
															#line 8867 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeVersionProperty()
															#line 1603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteVersionPropertyActor final : public Actor<Void>, public ActorCallback< WriteVersionPropertyActor, 0, Reference<IBackupFile> >, public ActorCallback< WriteVersionPropertyActor, 1, Void >, public ActorCallback< WriteVersionPropertyActor, 2, Void >, public FastAllocated<WriteVersionPropertyActor>, public WriteVersionPropertyActorState<WriteVersionPropertyActor> {
															#line 8872 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteVersionPropertyActor>::operator new;
	using FastAllocated<WriteVersionPropertyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13115312989471100672UL, 1516174770983835648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteVersionPropertyActor, 0, Reference<IBackupFile> >;
friend struct ActorCallback< WriteVersionPropertyActor, 1, Void >;
friend struct ActorCallback< WriteVersionPropertyActor, 2, Void >;
															#line 1603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteVersionPropertyActor(Reference<BackupContainerFileSystem> const& bc,std::string const& path,Version const& v) 
															#line 8891 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteVersionPropertyActorState<WriteVersionPropertyActor>(bc, path, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3950136920544534016UL, 12704436107426719232UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeVersionProperty");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteVersionPropertyActor, 0, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteVersionPropertyActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteVersionPropertyActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Void> writeVersionProperty( Reference<BackupContainerFileSystem> const& bc, std::string const& path, Version const& v ) {
															#line 1603 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new WriteVersionPropertyActor(bc, path, v));
															#line 8926 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 1618 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 8931 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via readVersionProperty()
															#line 1619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class ReadVersionPropertyActor>
															#line 1619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class ReadVersionPropertyActorState {
															#line 8938 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 1619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	ReadVersionPropertyActorState(Reference<BackupContainerFileSystem> const& bc,std::string const& path) 
															#line 1619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 1619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   path(path)
															#line 8947 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readVersionProperty", reinterpret_cast<unsigned long>(this));

	}
	~ReadVersionPropertyActorState() 
	{
		fdb_probe_actor_destroy("readVersionProperty", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1621 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Reference<IAsyncFile>> __when_expr_0 = bc->readFile(path);
															#line 1621 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8965 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state = 1;
															#line 1621 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadVersionPropertyActor, 0, Reference<IAsyncFile> >*>(static_cast<ReadVersionPropertyActor*>(this)));
															#line 8970 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadVersionPropertyActorState();
		static_cast<ReadVersionPropertyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1635 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (e.code() == error_code_file_not_found)
															#line 9000 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 1636 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!static_cast<ReadVersionPropertyActor*>(this)->SAV<Optional<Version>>::futures) { (void)(Optional<Version>()); this->~ReadVersionPropertyActorState(); static_cast<ReadVersionPropertyActor*>(this)->destroy(); return 0; }
															#line 9004 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				new (&static_cast<ReadVersionPropertyActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(Optional<Version>());
				this->~ReadVersionPropertyActorState();
				static_cast<ReadVersionPropertyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1638 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarn, "BackupContainerReadPropertyFailed") .error(e) .detail("URL", bc->getURL()) .detail("Path", path);
															#line 1643 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 9014 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1622 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = f->size();
															#line 1622 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9030 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state = 2;
															#line 1622 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadVersionPropertyActor, 1, int64_t >*>(static_cast<ReadVersionPropertyActor*>(this)));
															#line 9035 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __f,int loopDepth) 
	{
															#line 1621 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		f = __f;
															#line 9044 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state > 0) static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadVersionPropertyActor*>(this)->ActorCallback< ReadVersionPropertyActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadVersionPropertyActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadVersionPropertyActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadVersionPropertyActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1623 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		s = std::string();
															#line 1624 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		s.resize(size);
															#line 1625 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<int> __when_expr_2 = f->read((uint8_t*)s.data(), size, 0);
															#line 1625 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9129 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state = 3;
															#line 1625 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadVersionPropertyActor, 2, int >*>(static_cast<ReadVersionPropertyActor*>(this)));
															#line 9134 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(int64_t const& __size,int loopDepth) 
	{
															#line 1622 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		size = __size;
															#line 9143 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t && __size,int loopDepth) 
	{
		size = std::move(__size);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state > 0) static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadVersionPropertyActor*>(this)->ActorCallback< ReadVersionPropertyActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< ReadVersionPropertyActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadVersionPropertyActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadVersionPropertyActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int const& rs,int loopDepth) 
	{
															#line 1626 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		Version v;
															#line 1627 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int len;
															#line 1628 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (rs == size && sscanf(s.c_str(), "%" SCNd64 "%n", &v, &len) == 1 && len == size)
															#line 9226 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1629 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<ReadVersionPropertyActor*>(this)->SAV<Optional<Version>>::futures) { (void)(v); this->~ReadVersionPropertyActorState(); static_cast<ReadVersionPropertyActor*>(this)->destroy(); return 0; }
															#line 9230 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			new (&static_cast<ReadVersionPropertyActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(v);
			this->~ReadVersionPropertyActorState();
			static_cast<ReadVersionPropertyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1631 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent(SevWarn, "BackupContainerInvalidProperty").detail("URL", bc->getURL()).detail("Path", path);
															#line 1633 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		return a_body1Catch2(backup_invalid_info(), loopDepth);
															#line 9240 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1cont4(int && rs,int loopDepth) 
	{
															#line 1626 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		Version v;
															#line 1627 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int len;
															#line 1628 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (rs == size && sscanf(s.c_str(), "%" SCNd64 "%n", &v, &len) == 1 && len == size)
															#line 9252 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1629 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<ReadVersionPropertyActor*>(this)->SAV<Optional<Version>>::futures) { (void)(v); this->~ReadVersionPropertyActorState(); static_cast<ReadVersionPropertyActor*>(this)->destroy(); return 0; }
															#line 9256 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			new (&static_cast<ReadVersionPropertyActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(v);
			this->~ReadVersionPropertyActorState();
			static_cast<ReadVersionPropertyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1631 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent(SevWarn, "BackupContainerInvalidProperty").detail("URL", bc->getURL()).detail("Path", path);
															#line 1633 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		return a_body1Catch2(backup_invalid_info(), loopDepth);
															#line 9266 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1cont3when1(int const& rs,int loopDepth) 
	{
		loopDepth = a_body1cont4(rs, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(int && rs,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(rs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state > 0) static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadVersionPropertyActor*>(this)->ActorCallback< ReadVersionPropertyActor, 2, int >::remove();

	}
	void a_callback_fire(ActorCallback< ReadVersionPropertyActor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadVersionPropertyActor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadVersionPropertyActor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 1619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string path;
															#line 1621 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IAsyncFile> f;
															#line 1622 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int64_t size;
															#line 1623 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string s;
															#line 9355 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readVersionProperty()
															#line 1619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class ReadVersionPropertyActor final : public Actor<Optional<Version>>, public ActorCallback< ReadVersionPropertyActor, 0, Reference<IAsyncFile> >, public ActorCallback< ReadVersionPropertyActor, 1, int64_t >, public ActorCallback< ReadVersionPropertyActor, 2, int >, public FastAllocated<ReadVersionPropertyActor>, public ReadVersionPropertyActorState<ReadVersionPropertyActor> {
															#line 9360 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadVersionPropertyActor>::operator new;
	using FastAllocated<ReadVersionPropertyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14743340088475359744UL, 10217101838311954688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Version>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadVersionPropertyActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< ReadVersionPropertyActor, 1, int64_t >;
friend struct ActorCallback< ReadVersionPropertyActor, 2, int >;
															#line 1619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	ReadVersionPropertyActor(Reference<BackupContainerFileSystem> const& bc,std::string const& path) 
															#line 9379 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Optional<Version>>(),
		   ReadVersionPropertyActorState<ReadVersionPropertyActor>(bc, path),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10522111719328892928UL, 9104695102772332288UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readVersionProperty");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadVersionPropertyActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadVersionPropertyActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadVersionPropertyActor, 2, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Optional<Version>> readVersionProperty( Reference<BackupContainerFileSystem> const& bc, std::string const& path ) {
															#line 1619 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Optional<Version>>(new ReadVersionPropertyActor(bc, path));
															#line 9414 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 1646 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

Future<KeyRange> BackupContainerFileSystem::getSnapshotFileKeyRange(const RangeFile& file, Database cx) {
	ASSERT(g_network->isSimulated());
	return getSnapshotFileKeyRange_impl(Reference<BackupContainerFileSystem>::addRef(this), file, cx);
}

Future<Optional<RestorableFileSet>> BackupContainerFileSystem::getRestoreSet(Version targetVersion,
                                                                             VectorRef<KeyRangeRef> keyRangesFilter,
                                                                             bool logsOnly,
                                                                             Version beginVersion) {
	return BackupContainerFileSystemImpl::getRestoreSet(
	    Reference<BackupContainerFileSystem>::addRef(this), targetVersion, keyRangesFilter, logsOnly, beginVersion);
}

Future<Optional<Version>> BackupContainerFileSystem::VersionProperty::get() {
	return readVersionProperty(bc, path);
}
Future<Void> BackupContainerFileSystem::VersionProperty::set(Version v) {
	return writeVersionProperty(bc, path, v);
}
Future<Void> BackupContainerFileSystem::VersionProperty::clear() {
	return bc->deleteFile(path);
}

BackupContainerFileSystem::VersionProperty BackupContainerFileSystem::logBeginVersion() {
	return { Reference<BackupContainerFileSystem>::addRef(this), "log_begin_version" };
}
BackupContainerFileSystem::VersionProperty BackupContainerFileSystem::logEndVersion() {
	return { Reference<BackupContainerFileSystem>::addRef(this), "log_end_version" };
}
BackupContainerFileSystem::VersionProperty BackupContainerFileSystem::expiredEndVersion() {
	return { Reference<BackupContainerFileSystem>::addRef(this), "expired_end_version" };
}
BackupContainerFileSystem::VersionProperty BackupContainerFileSystem::unreliableEndVersion() {
	return { Reference<BackupContainerFileSystem>::addRef(this), "unreliable_end_version" };
}
BackupContainerFileSystem::VersionProperty BackupContainerFileSystem::logType() {
	return { Reference<BackupContainerFileSystem>::addRef(this), "mutation_log_type" };
}
BackupContainerFileSystem::VersionProperty BackupContainerFileSystem::fileLevelEncryption() {
	return { Reference<BackupContainerFileSystem>::addRef(this), "file_level_encryption" };
}

bool BackupContainerFileSystem::usesEncryption() const {
	return encryptionSetupFuture.isValid();
}
Future<Void> BackupContainerFileSystem::encryptionSetupComplete() const {
	return encryptionSetupFuture;
}

Future<Void> BackupContainerFileSystem::writeEntireFileFallback(const std::string& fileName,
                                                                const std::string& fileContents) {
	return BackupContainerFileSystemImpl::writeEntireFileFallback(
	    Reference<BackupContainerFileSystem>::addRef(this), fileName, fileContents);
}

void BackupContainerFileSystem::setEncryptionKey(Optional<std::string> const& encryptionKeyFileName) {
	if (encryptionKeyFileName.present()) {
		encryptionSetupFuture = BackupContainerFileSystemImpl::readEncryptionKey(encryptionKeyFileName.get());
	}
}
Future<Void> BackupContainerFileSystem::createTestEncryptionKeyFile(std::string const& filename) {
	return BackupContainerFileSystemImpl::createTestEncryptionKeyFile(filename);
}

// Get a BackupContainerFileSystem based on a container URL string
// TODO: refactor to not duplicate IBackupContainer::openContainer. It's the exact same
// code but returning a different template type because you can't cast between them
Reference<BackupContainerFileSystem> BackupContainerFileSystem::openContainerFS(
    const std::string& url,
    const Optional<std::string>& proxy,
    const Optional<std::string>& encryptionKeyFileName,
    bool isBackup) {
	static std::map<std::string, Reference<BackupContainerFileSystem>> m_cache;

	Reference<BackupContainerFileSystem>& r = m_cache[url];
	if (r)
		return r;

	try {
		StringRef u(url);
		if (u.startsWith("file://"_sr)) {
			r = makeReference<BackupContainerLocalDirectory>(url, encryptionKeyFileName);
		} else if (u.startsWith("blobstore://"_sr)) {
			std::string resource;
			Optional<std::string> blobstoreProxy;

			// If no proxy is passed down to the openContainer method, try to fallback to the
			// fileBackupAgentProxy which is a global variable and will be set for the backup_agent.
			if (proxy.present()) {
				blobstoreProxy = proxy.get();
			} else if (fileBackupAgentProxy.present()) {
				blobstoreProxy = fileBackupAgentProxy.get();
			}

			// The URL parameters contain blobstore endpoint tunables as well as possible backup-specific options.
			S3BlobStoreEndpoint::ParametersT backupParams;
			Reference<S3BlobStoreEndpoint> bstore =
			    S3BlobStoreEndpoint::fromString(url, blobstoreProxy, &resource, &lastOpenError, &backupParams);

			if (resource.empty())
				throw backup_invalid_url();
			for (auto c : resource)
				if (!isalnum(c) && c != '_' && c != '-' && c != '.' && c != '/')
					throw backup_invalid_url();
			r = makeReference<BackupContainerS3BlobStore>(
			    bstore, resource, backupParams, encryptionKeyFileName, isBackup);
		}
#ifdef BUILD_AZURE_BACKUP
		else if (u.startsWith("azure://"_sr)) {
			u.eat("azure://"_sr);
			auto address = u.eat("/"_sr);
			if (address.endsWith(std::string(azure::storage_lite::constants::default_endpoint_suffix))) {
				CODE_PROBE(true, "Azure backup url with standard azure storage account endpoint");
				// <account>.<service>.core.windows.net/<resource_path>
				auto endPoint = address.toString();
				auto accountName = address.eat("."_sr).toString();
				auto containerName = u.eat("/"_sr).toString();
				r = makeReference<BackupContainerAzureBlobStore>(
				    endPoint, accountName, containerName, encryptionKeyFileName);
			} else {
				// resolve the network address if necessary
				std::string endpoint(address.toString());
				Optional<NetworkAddress> parsedAddress = NetworkAddress::parseOptional(endpoint);
				if (!parsedAddress.present()) {
					try {
						auto hostname = Hostname::parse(endpoint);
						auto resolvedAddress = hostname.resolveBlocking();
						if (resolvedAddress.present()) {
							CODE_PROBE(true, "Azure backup url with hostname in the endpoint");
							parsedAddress = resolvedAddress.get();
						}
					} catch (Error& e) {
						TraceEvent(SevError, "InvalidAzureBackupUrl").error(e).detail("Endpoint", endpoint);
						throw backup_invalid_url();
					}
				}
				if (!parsedAddress.present()) {
					TraceEvent(SevError, "InvalidAzureBackupUrl").detail("Endpoint", endpoint);
					throw backup_invalid_url();
				}
				auto accountName = u.eat("/"_sr).toString();
				// Avoid including ":tls" and "(fromHostname)"
				// note: the endpoint needs to contain the account name
				// so either "<account_name>.blob.core.windows.net" or "<ip>:<port>/<account_name>"
				endpoint =
				    fmt::format("{}/{}", formatIpPort(parsedAddress.get().ip, parsedAddress.get().port), accountName);
				auto containerName = u.eat("/"_sr).toString();
				r = makeReference<BackupContainerAzureBlobStore>(
				    endpoint, accountName, containerName, encryptionKeyFileName);
			}
		}
#endif
		else {
			lastOpenError = "invalid URL prefix";
			throw backup_invalid_url();
		}

		r->encryptionKeyFileName = encryptionKeyFileName;
		r->URL = url;
		return r;
	} catch (Error& e) {
		if (e.code() == error_code_actor_cancelled)
			throw;

		TraceEvent m(SevWarn, "BackupContainer");
		m.error(e);
		m.detail("Description", "Invalid container specification.  See help.");
		m.detail("URL", url);
		if (e.code() == error_code_backup_invalid_url)
			m.detail("LastOpenError", lastOpenError);

		throw;
	}
}

namespace backup_test {

int chooseFileSize(std::vector<int>& sizes) {
	if (!sizes.empty()) {
		int size = sizes.back();
		sizes.pop_back();
		return size;
	}
	return deterministicRandom()->randomInt(0, 2e6);
}

															#line 9605 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via writeAndVerifyFile()
															#line 1833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class WriteAndVerifyFileActor>
															#line 1833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteAndVerifyFileActorState {
															#line 9611 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 1833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteAndVerifyFileActorState(Reference<IBackupContainer> const& c,Reference<IBackupFile> const& f,int const& size,FlowLock* const& lock) 
															#line 1833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : c(c),
															#line 1833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   f(f),
															#line 1833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   size(size),
															#line 1833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   lock(lock),
															#line 1837 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   content()
															#line 9626 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeAndVerifyFile", reinterpret_cast<unsigned long>(this));

	}
	~WriteAndVerifyFileActorState() 
	{
		fdb_probe_actor_destroy("writeAndVerifyFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1839 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = lock->take(TaskPriority::DefaultYield, size);
															#line 1839 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9643 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 1;
															#line 1839 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyFileActor, 0, Void >*>(static_cast<WriteAndVerifyFileActor*>(this)));
															#line 9648 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteAndVerifyFileActorState();
		static_cast<WriteAndVerifyFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1840 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		releaser = FlowLock::Releaser(*lock, size);
															#line 1842 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("writeAndVerify size=%d file=%s\n", size, f->getFileName().c_str());
															#line 1843 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		content.resize(content.arena(), size);
															#line 1844 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for(int i = 0;i < content.size();++i) {
															#line 1845 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			content[i] = (uint8_t)deterministicRandom()->randomInt(0, 256);
															#line 9679 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 1848 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		sendBuf = content;
															#line 1849 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 9685 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1840 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		releaser = FlowLock::Releaser(*lock, size);
															#line 1842 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("writeAndVerify size=%d file=%s\n", size, f->getFileName().c_str());
															#line 1843 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		content.resize(content.arena(), size);
															#line 1844 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for(int i = 0;i < content.size();++i) {
															#line 1845 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			content[i] = (uint8_t)deterministicRandom()->randomInt(0, 256);
															#line 9702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 1848 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		sendBuf = content;
															#line 1849 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 9708 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyFileActor*>(this)->ActorCallback< WriteAndVerifyFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1854 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->finish();
															#line 1854 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9794 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 3;
															#line 1854 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyFileActor, 2, Void >*>(static_cast<WriteAndVerifyFileActor*>(this)));
															#line 9799 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1849 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(sendBuf.size() > 0))
															#line 9815 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1850 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		n = std::min(sendBuf.size(), deterministicRandom()->randomInt(1, 16384));
															#line 1851 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f->append(sendBuf.begin(), n);
															#line 1851 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9825 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 2;
															#line 1851 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyFileActor, 1, Void >*>(static_cast<WriteAndVerifyFileActor*>(this)));
															#line 9830 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1852 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		sendBuf.pop_front(n);
															#line 9852 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1852 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		sendBuf.pop_front(n);
															#line 9861 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyFileActor*>(this)->ActorCallback< WriteAndVerifyFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1856 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_3 = c->readFile(f->getFileName());
															#line 1856 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9947 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 4;
															#line 1856 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >*>(static_cast<WriteAndVerifyFileActor*>(this)));
															#line 9952 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1856 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_3 = c->readFile(f->getFileName());
															#line 1856 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9963 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 4;
															#line 1856 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >*>(static_cast<WriteAndVerifyFileActor*>(this)));
															#line 9968 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyFileActor*>(this)->ActorCallback< WriteAndVerifyFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1857 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<int64_t> __when_expr_4 = inputFile->size();
															#line 1857 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10054 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 5;
															#line 1857 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyFileActor, 4, int64_t >*>(static_cast<WriteAndVerifyFileActor*>(this)));
															#line 10059 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Reference<IAsyncFile> const& __inputFile,int loopDepth) 
	{
															#line 1856 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		inputFile = __inputFile;
															#line 10068 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Reference<IAsyncFile> && __inputFile,int loopDepth) 
	{
		inputFile = std::move(__inputFile);
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyFileActor*>(this)->ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(int64_t const& fileSize,int loopDepth) 
	{
															#line 1858 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(size, fileSize);
															#line 1859 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (size > 0)
															#line 10149 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1860 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			buf = Standalone<VectorRef<uint8_t>>();
															#line 1861 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			buf.resize(buf.arena(), fileSize);
															#line 1862 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<int> __when_expr_5 = inputFile->read(buf.begin(), buf.size(), 0);
															#line 1862 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
			static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 6;
															#line 1862 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyFileActor, 5, int >*>(static_cast<WriteAndVerifyFileActor*>(this)));
															#line 10164 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(int64_t && fileSize,int loopDepth) 
	{
															#line 1858 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(size, fileSize);
															#line 1859 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (size > 0)
															#line 10180 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1860 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			buf = Standalone<VectorRef<uint8_t>>();
															#line 1861 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			buf.resize(buf.arena(), fileSize);
															#line 1862 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<int> __when_expr_5 = inputFile->read(buf.begin(), buf.size(), 0);
															#line 1862 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10190 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
			static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 6;
															#line 1862 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyFileActor, 5, int >*>(static_cast<WriteAndVerifyFileActor*>(this)));
															#line 10195 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5when1(int64_t const& fileSize,int loopDepth) 
	{
		loopDepth = a_body1cont6(fileSize, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(int64_t && fileSize,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(fileSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyFileActor*>(this)->ActorCallback< WriteAndVerifyFileActor, 4, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 4, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 4, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyFileActor, 4, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1866 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<WriteAndVerifyFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteAndVerifyFileActorState(); static_cast<WriteAndVerifyFileActor*>(this)->destroy(); return 0; }
															#line 10284 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<WriteAndVerifyFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteAndVerifyFileActorState();
		static_cast<WriteAndVerifyFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(int const& b,int loopDepth) 
	{
															#line 1863 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(b, buf.size());
															#line 1864 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(buf == content);
															#line 10298 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(int && b,int loopDepth) 
	{
															#line 1863 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(b, buf.size());
															#line 1864 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(buf == content);
															#line 10309 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(int const& b,int loopDepth) 
	{
		loopDepth = a_body1cont8(b, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(int && b,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(b), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyFileActor*>(this)->ActorCallback< WriteAndVerifyFileActor, 5, int >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 5, int >*,int const& value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 5, int >*,int && value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyFileActor, 5, int >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 1833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupContainer> c;
															#line 1833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> f;
															#line 1833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int size;
															#line 1833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowLock* lock;
															#line 1837 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Standalone<VectorRef<uint8_t>> content;
															#line 1840 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowLock::Releaser releaser;
															#line 1848 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	VectorRef<uint8_t> sendBuf;
															#line 1850 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int n;
															#line 1856 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IAsyncFile> inputFile;
															#line 1860 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Standalone<VectorRef<uint8_t>> buf;
															#line 10409 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeAndVerifyFile()
															#line 1833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteAndVerifyFileActor final : public Actor<Void>, public ActorCallback< WriteAndVerifyFileActor, 0, Void >, public ActorCallback< WriteAndVerifyFileActor, 1, Void >, public ActorCallback< WriteAndVerifyFileActor, 2, Void >, public ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >, public ActorCallback< WriteAndVerifyFileActor, 4, int64_t >, public ActorCallback< WriteAndVerifyFileActor, 5, int >, public FastAllocated<WriteAndVerifyFileActor>, public WriteAndVerifyFileActorState<WriteAndVerifyFileActor> {
															#line 10414 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteAndVerifyFileActor>::operator new;
	using FastAllocated<WriteAndVerifyFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4109213940032810496UL, 12219852189675145216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteAndVerifyFileActor, 0, Void >;
friend struct ActorCallback< WriteAndVerifyFileActor, 1, Void >;
friend struct ActorCallback< WriteAndVerifyFileActor, 2, Void >;
friend struct ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >;
friend struct ActorCallback< WriteAndVerifyFileActor, 4, int64_t >;
friend struct ActorCallback< WriteAndVerifyFileActor, 5, int >;
															#line 1833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteAndVerifyFileActor(Reference<IBackupContainer> const& c,Reference<IBackupFile> const& f,int const& size,FlowLock* const& lock) 
															#line 10436 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteAndVerifyFileActorState<WriteAndVerifyFileActor>(c, f, size, lock),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10679368928020552448UL, 15202424407061132288UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeAndVerifyFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteAndVerifyFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteAndVerifyFileActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteAndVerifyFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WriteAndVerifyFileActor, 4, int64_t >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< WriteAndVerifyFileActor, 5, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] Future<Void> writeAndVerifyFile( Reference<IBackupContainer> const& c, Reference<IBackupFile> const& f, int const& size, FlowLock* const& lock ) {
															#line 1833 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new WriteAndVerifyFileActor(c, f, size, lock));
															#line 10473 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 1868 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

// Randomly advance version by up to 1 second of versions
Version nextVersion(Version v) {
	int64_t increment = deterministicRandom()->randomInt64(1, CLIENT_KNOBS->CORE_VERSIONSPERSECOND);
	return v + increment;
}

// Write a snapshot file with only begin & end key
															#line 10485 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via testWriteSnapshotFile()
															#line 1876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class TestWriteSnapshotFileActor>
															#line 1876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class TestWriteSnapshotFileActorState {
															#line 10491 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 1876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	TestWriteSnapshotFileActorState(Reference<IBackupFile> const& file,Key const& begin,Key const& end,uint32_t const& blockSize) 
															#line 1876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : file(file),
															#line 1876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   begin(begin),
															#line 1876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   end(end),
															#line 1876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   blockSize(blockSize)
															#line 10504 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this));

	}
	~TestWriteSnapshotFileActorState() 
	{
		fdb_probe_actor_destroy("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1877 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT_GT(blockSize, 3 * sizeof(uint32_t) + begin.size() + end.size());
															#line 1879 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			uint32_t fileVersion = BACKUP_AGENT_SNAPSHOT_FILE_VERSION;
															#line 1881 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = file->append((uint8_t*)&fileVersion, sizeof(fileVersion));
															#line 1881 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10525 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 1;
															#line 1881 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestWriteSnapshotFileActor, 0, Void >*>(static_cast<TestWriteSnapshotFileActor*>(this)));
															#line 10530 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestWriteSnapshotFileActorState();
		static_cast<TestWriteSnapshotFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1884 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = file->appendStringRefWithLen(begin);
															#line 1884 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10555 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 2;
															#line 1884 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestWriteSnapshotFileActor, 1, Void >*>(static_cast<TestWriteSnapshotFileActor*>(this)));
															#line 10560 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1884 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = file->appendStringRefWithLen(begin);
															#line 1884 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10571 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 2;
															#line 1884 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestWriteSnapshotFileActor, 1, Void >*>(static_cast<TestWriteSnapshotFileActor*>(this)));
															#line 10576 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<TestWriteSnapshotFileActor*>(this)->ActorCallback< TestWriteSnapshotFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestWriteSnapshotFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1887 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->appendStringRefWithLen(end);
															#line 1887 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10662 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 3;
															#line 1887 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestWriteSnapshotFileActor, 2, Void >*>(static_cast<TestWriteSnapshotFileActor*>(this)));
															#line 10667 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1887 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->appendStringRefWithLen(end);
															#line 1887 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10678 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 3;
															#line 1887 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestWriteSnapshotFileActor, 2, Void >*>(static_cast<TestWriteSnapshotFileActor*>(this)));
															#line 10683 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<TestWriteSnapshotFileActor*>(this)->ActorCallback< TestWriteSnapshotFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestWriteSnapshotFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1889 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int bytesLeft = blockSize - file->size();
															#line 1890 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (bytesLeft > 0)
															#line 10769 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1891 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			Value paddings = fileBackup::makePadding(bytesLeft);
															#line 1892 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_3 = file->append(paddings.begin(), bytesLeft);
															#line 1892 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10777 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 4;
															#line 1892 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestWriteSnapshotFileActor, 3, Void >*>(static_cast<TestWriteSnapshotFileActor*>(this)));
															#line 10782 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1889 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int bytesLeft = blockSize - file->size();
															#line 1890 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (bytesLeft > 0)
															#line 10798 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1891 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			Value paddings = fileBackup::makePadding(bytesLeft);
															#line 1892 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_3 = file->append(paddings.begin(), bytesLeft);
															#line 1892 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10806 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 4;
															#line 1892 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestWriteSnapshotFileActor, 3, Void >*>(static_cast<TestWriteSnapshotFileActor*>(this)));
															#line 10811 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<TestWriteSnapshotFileActor*>(this)->ActorCallback< TestWriteSnapshotFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestWriteSnapshotFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1894 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_4 = file->finish();
															#line 1894 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10902 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 5;
															#line 1894 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestWriteSnapshotFileActor, 4, Void >*>(static_cast<TestWriteSnapshotFileActor*>(this)));
															#line 10907 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<TestWriteSnapshotFileActor*>(this)->ActorCallback< TestWriteSnapshotFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestWriteSnapshotFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1895 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<TestWriteSnapshotFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestWriteSnapshotFileActorState(); static_cast<TestWriteSnapshotFileActor*>(this)->destroy(); return 0; }
															#line 11003 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<TestWriteSnapshotFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestWriteSnapshotFileActorState();
		static_cast<TestWriteSnapshotFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1895 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<TestWriteSnapshotFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestWriteSnapshotFileActorState(); static_cast<TestWriteSnapshotFileActor*>(this)->destroy(); return 0; }
															#line 11015 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<TestWriteSnapshotFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestWriteSnapshotFileActorState();
		static_cast<TestWriteSnapshotFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<TestWriteSnapshotFileActor*>(this)->ActorCallback< TestWriteSnapshotFileActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestWriteSnapshotFileActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> file;
															#line 1876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key begin;
															#line 1876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key end;
															#line 1876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	uint32_t blockSize;
															#line 11106 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testWriteSnapshotFile()
															#line 1876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class TestWriteSnapshotFileActor final : public Actor<Void>, public ActorCallback< TestWriteSnapshotFileActor, 0, Void >, public ActorCallback< TestWriteSnapshotFileActor, 1, Void >, public ActorCallback< TestWriteSnapshotFileActor, 2, Void >, public ActorCallback< TestWriteSnapshotFileActor, 3, Void >, public ActorCallback< TestWriteSnapshotFileActor, 4, Void >, public FastAllocated<TestWriteSnapshotFileActor>, public TestWriteSnapshotFileActorState<TestWriteSnapshotFileActor> {
															#line 11111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestWriteSnapshotFileActor>::operator new;
	using FastAllocated<TestWriteSnapshotFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18395746745947710464UL, 14386726560171769600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestWriteSnapshotFileActor, 0, Void >;
friend struct ActorCallback< TestWriteSnapshotFileActor, 1, Void >;
friend struct ActorCallback< TestWriteSnapshotFileActor, 2, Void >;
friend struct ActorCallback< TestWriteSnapshotFileActor, 3, Void >;
friend struct ActorCallback< TestWriteSnapshotFileActor, 4, Void >;
															#line 1876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	TestWriteSnapshotFileActor(Reference<IBackupFile> const& file,Key const& begin,Key const& end,uint32_t const& blockSize) 
															#line 11132 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestWriteSnapshotFileActorState<TestWriteSnapshotFileActor>(file, begin, end, blockSize),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5978292015299530752UL, 7007095461914833152UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testWriteSnapshotFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestWriteSnapshotFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestWriteSnapshotFileActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestWriteSnapshotFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestWriteSnapshotFileActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestWriteSnapshotFileActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Void> testWriteSnapshotFile( Reference<IBackupFile> const& file, Key const& begin, Key const& end, uint32_t const& blockSize ) {
															#line 1876 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new TestWriteSnapshotFileActor(file, begin, end, blockSize));
															#line 11168 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 1897 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 11173 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via testBackupContainer()
															#line 1898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class TestBackupContainerActor>
															#line 1898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class TestBackupContainerActorState {
															#line 11179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 1898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	TestBackupContainerActorState(std::string const& url,Optional<std::string> const& proxy,Optional<std::string> const& encryptionKeyFileName) 
															#line 1898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : url(url),
															#line 1898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   proxy(proxy),
															#line 1898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   encryptionKeyFileName(encryptionKeyFileName),
															#line 1901 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   lock(100e6)
															#line 11192 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testBackupContainer", reinterpret_cast<unsigned long>(this));

	}
	~TestBackupContainerActorState() 
	{
		fdb_probe_actor_destroy("testBackupContainer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1903 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (encryptionKeyFileName.present())
															#line 11207 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 1904 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Void> __when_expr_0 = BackupContainerFileSystem::createTestEncryptionKeyFile(encryptionKeyFileName.get());
															#line 1904 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11213 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 1;
															#line 1904 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 0, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11218 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestBackupContainerActorState();
		static_cast<TestBackupContainerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1907 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("BackupContainerTest URL %s\n", url.c_str());
															#line 1909 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		c = IBackupContainer::openContainer(url, proxy, encryptionKeyFileName);
															#line 11248 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		try {
															#line 1913 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_1 = c->deleteContainer();
															#line 1913 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 11254 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 2;
															#line 1913 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 1, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11259 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1919 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = c->create();
															#line 1919 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11363 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 3;
															#line 1919 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 2, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11368 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1915 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (e.code() != error_code_backup_invalid_url && e.code() != error_code_backup_does_not_exist)
															#line 11378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 1916 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 11382 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1921 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes = std::vector<Future<Void>>();
															#line 1922 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshots = std::map<Version, std::vector<std::string>>();
															#line 1923 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotSizes = std::map<Version, int64_t>();
															#line 1924 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginEndKeys = std::map<Version, std::vector<std::pair<Key, Key>>>();
															#line 1925 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		nRangeFiles = 0;
															#line 1926 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs = std::map<Version, std::string>();
															#line 1927 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = deterministicRandom()->randomInt64(0, std::numeric_limits<Version>::max() / 2);
															#line 1930 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		fileSizes = { 0 };
															#line 1931 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (StringRef(url).startsWith("blob"_sr))
															#line 11514 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1932 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			fileSizes.push_back(CLIENT_KNOBS->BLOBSTORE_MULTIPART_MIN_PART_SIZE);
															#line 1933 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			fileSizes.push_back(CLIENT_KNOBS->BLOBSTORE_MULTIPART_MIN_PART_SIZE + 10);
															#line 11520 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 1936 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 11524 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1921 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes = std::vector<Future<Void>>();
															#line 1922 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshots = std::map<Version, std::vector<std::string>>();
															#line 1923 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotSizes = std::map<Version, int64_t>();
															#line 1924 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginEndKeys = std::map<Version, std::vector<std::pair<Key, Key>>>();
															#line 1925 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		nRangeFiles = 0;
															#line 1926 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs = std::map<Version, std::string>();
															#line 1927 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = deterministicRandom()->randomInt64(0, std::numeric_limits<Version>::max() / 2);
															#line 1930 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		fileSizes = { 0 };
															#line 1931 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (StringRef(url).startsWith("blob"_sr))
															#line 11549 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1932 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			fileSizes.push_back(CLIENT_KNOBS->BLOBSTORE_MULTIPART_MIN_PART_SIZE);
															#line 1933 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			fileSizes.push_back(CLIENT_KNOBS->BLOBSTORE_MULTIPART_MIN_PART_SIZE + 10);
															#line 11555 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 1936 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 11559 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1994 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_6 = waitForAll(writes);
															#line 1994 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11645 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 7;
															#line 1994 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 6, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11650 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 1937 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logStart = v;
															#line 1938 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		kvfiles = deterministicRandom()->randomInt(0, 3);
															#line 1939 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		begin = ""_sr;
															#line 1940 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		end = ""_sr;
															#line 1941 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		blockSize = 3 * sizeof(uint32_t) + begin.size() + end.size() + 8;
															#line 1943 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 11676 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(int loopDepth) 
	{
															#line 1978 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (logStart == v || deterministicRandom()->coinflip())
															#line 11698 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1979 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			v = nextVersion(v);
															#line 11702 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 1981 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IBackupFile>> __when_expr_5 = c->writeLogFile(logStart, v, 10);
															#line 1981 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11708 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 6;
															#line 1981 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 5, Reference<IBackupFile> >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11713 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1(int loopDepth) 
	{
															#line 1943 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(kvfiles > 0))
															#line 11729 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			return a_body1cont6loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1944 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (snapshots.empty())
															#line 11735 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1945 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshots[v] = {};
															#line 1946 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshotBeginEndKeys[v] = {};
															#line 1947 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshotSizes[v] = 0;
															#line 1948 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 11745 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 1949 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				v = nextVersion(v);
															#line 11749 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
		}
															#line 1952 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IBackupFile>> __when_expr_3 = c->writeRangeFile(snapshots.rbegin()->first, 0, v, blockSize);
															#line 1952 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11756 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont6loopBody1loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 4;
															#line 1952 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 3, Reference<IBackupFile> >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11761 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont6loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1cont1(Reference<IBackupFile> const& range,int loopDepth) 
	{
															#line 1953 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++nRangeFiles;
															#line 1954 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = nextVersion(v);
															#line 1955 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshots.rbegin()->second.push_back(range->getFileName());
															#line 1956 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginEndKeys.rbegin()->second.emplace_back(begin, end);
															#line 1958 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int size = chooseFileSize(fileSizes);
															#line 1959 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotSizes.rbegin()->second += size;
															#line 1962 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_4 = testWriteSnapshotFile(range, begin, end, blockSize);
															#line 1962 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11797 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1cont6loopBody1loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 5;
															#line 1962 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 4, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11802 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1cont1(Reference<IBackupFile> && range,int loopDepth) 
	{
															#line 1953 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++nRangeFiles;
															#line 1954 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = nextVersion(v);
															#line 1955 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshots.rbegin()->second.push_back(range->getFileName());
															#line 1956 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginEndKeys.rbegin()->second.emplace_back(begin, end);
															#line 1958 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int size = chooseFileSize(fileSizes);
															#line 1959 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotSizes.rbegin()->second += size;
															#line 1962 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_4 = testWriteSnapshotFile(range, begin, end, blockSize);
															#line 1962 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11825 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1cont6loopBody1loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 5;
															#line 1962 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 4, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11830 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1when1(Reference<IBackupFile> const& range,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1loopBody1cont1(range, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1when1(Reference<IBackupFile> && range,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1loopBody1cont1(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 3, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 3, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 3, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 3, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6loopBody1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1964 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (deterministicRandom()->random01() < .2)
															#line 11914 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1965 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			writes.push_back(c->writeKeyspaceSnapshotFile(snapshots.rbegin()->second, snapshotBeginEndKeys.rbegin()->second, snapshotSizes.rbegin()->second, IncludeKeyRangeMap(BUGGIFY)));
															#line 1969 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshots[v] = {};
															#line 1970 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshotBeginEndKeys[v] = {};
															#line 1971 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshotSizes[v] = 0;
															#line 11924 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			return a_body1cont6loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1975 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		--kvfiles;
															#line 11929 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont6loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1964 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (deterministicRandom()->random01() < .2)
															#line 11938 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1965 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			writes.push_back(c->writeKeyspaceSnapshotFile(snapshots.rbegin()->second, snapshotBeginEndKeys.rbegin()->second, snapshotSizes.rbegin()->second, IncludeKeyRangeMap(BUGGIFY)));
															#line 1969 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshots[v] = {};
															#line 1970 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshotBeginEndKeys[v] = {};
															#line 1971 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshotSizes[v] = 0;
															#line 11948 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			return a_body1cont6loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1975 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		--kvfiles;
															#line 11953 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont6loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6loopBody1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6loopBody1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6loopBody1cont2(int loopDepth) 
	{
															#line 1982 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs[logStart] = log->getFileName();
															#line 1983 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int size = chooseFileSize(fileSizes);
															#line 1984 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes.push_back(writeAndVerifyFile(c, log, size, &lock));
															#line 1987 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (fileSizes.empty() && !snapshots.empty() && snapshots.rbegin()->second.empty() && deterministicRandom()->random01() < .2)
															#line 12043 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 1989 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshots.erase(snapshots.rbegin()->first);
															#line 12047 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Reference<IBackupFile> const& __log,int loopDepth) 
	{
															#line 1981 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		log = __log;
															#line 12058 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Reference<IBackupFile> && __log,int loopDepth) 
	{
		log = std::move(__log);
		loopDepth = a_body1cont6loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 5, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 5, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 5, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 5, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 1996 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_7 = c->dumpFileList();
															#line 1996 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12139 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 8;
															#line 1996 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 7, BackupFileList >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12144 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 1996 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_7 = c->dumpFileList();
															#line 1996 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12155 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 8;
															#line 1996 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 7, BackupFileList >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12160 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 1997 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(listing.ranges.size(), nRangeFiles);
															#line 1998 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(listing.logs.size(), logs.size());
															#line 1999 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(listing.snapshots.size(), snapshots.size());
															#line 2001 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupDescription> __when_expr_8 = c->describeBackup();
															#line 2001 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12252 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 9;
															#line 2001 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 8, BackupDescription >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12257 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(BackupFileList const& __listing,int loopDepth) 
	{
															#line 1996 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		listing = __listing;
															#line 12266 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(BackupFileList && __listing,int loopDepth) 
	{
		listing = std::move(__listing);
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 7, BackupFileList >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 7, BackupFileList >*,BackupFileList const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 7, BackupFileList >*,BackupFileList && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 7, BackupFileList >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 2002 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("\n%s\n", desc.toString().c_str());
															#line 2005 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		i = 0;
															#line 2006 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 12349 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(BackupDescription const& __desc,int loopDepth) 
	{
															#line 2001 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc = __desc;
															#line 12358 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(BackupDescription && __desc,int loopDepth) 
	{
		desc = std::move(__desc);
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 8, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 8, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 8, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 8, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont2(int loopDepth) 
	{
															#line 2038 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("DELETING\n");
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_14 = c->deleteContainer();
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12441 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_14.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 15;
															#line 2039 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 14, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12446 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1(int loopDepth) 
	{
															#line 2006 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(i < listing.snapshots.size()))
															#line 12462 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			return a_body1cont10cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		{
															#line 2009 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Optional<RestorableFileSet>> __when_expr_9 = c->getRestoreSet(desc.maxRestorableVersion.get());
															#line 2009 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12471 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1when1(__when_expr_9.get(), loopDepth); };
			static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 10;
															#line 2009 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 9, Optional<RestorableFileSet> >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12476 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1(int loopDepth) 
	{
		{
															#line 2015 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Optional<RestorableFileSet>> __when_expr_10 = c->getRestoreSet(listing.snapshots[i].endVersion);
															#line 2015 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12502 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont1when1(__when_expr_10.get(), loopDepth); };
			static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 11;
															#line 2015 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 10, Optional<RestorableFileSet> >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12507 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont3(Optional<RestorableFileSet> const& rest,int loopDepth) 
	{
															#line 2010 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(rest.present());
															#line 12517 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont3(Optional<RestorableFileSet> && rest,int loopDepth) 
	{
															#line 2010 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(rest.present());
															#line 12526 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1when1(Optional<RestorableFileSet> const& rest,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont3(rest, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1when1(Optional<RestorableFileSet> && rest,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont3(std::move(rest), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 9, Optional<RestorableFileSet> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 9, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 9, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 9, Optional<RestorableFileSet> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont1loopBody1cont5(int loopDepth) 
	{
															#line 2020 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		expireVersion = listing.snapshots[i].endVersion;
															#line 2023 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		fmt::print("EXPIRE TO {}\n", expireVersion);
															#line 2024 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		f = c->expireData(expireVersion);
															#line 2025 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_11 = ready(f);
															#line 2025 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12618 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont5when1(__when_expr_11.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 12;
															#line 2025 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 11, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12623 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont6(Optional<RestorableFileSet> const& rest,int loopDepth) 
	{
															#line 2016 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(rest.present());
															#line 12632 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont6(Optional<RestorableFileSet> && rest,int loopDepth) 
	{
															#line 2016 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(rest.present());
															#line 12641 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1when1(Optional<RestorableFileSet> const& rest,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont6(rest, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1when1(Optional<RestorableFileSet> && rest,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont6(std::move(rest), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 10, Optional<RestorableFileSet> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 10, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 10, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 10, Optional<RestorableFileSet> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10cont1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 2028 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (f.isError())
															#line 12725 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 2029 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT_EQ(f.getError().code(), error_code_backup_cannot_expire);
															#line 2030 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT_EQ(i, listing.snapshots.size() - 1);
															#line 2031 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_12 = c->expireData(expireVersion, true);
															#line 2031 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12735 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont8when1(__when_expr_12.get(), loopDepth); };
			static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 13;
															#line 2031 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 12, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12740 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont1loopBody1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 2028 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (f.isError())
															#line 12754 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 2029 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT_EQ(f.getError().code(), error_code_backup_cannot_expire);
															#line 2030 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT_EQ(i, listing.snapshots.size() - 1);
															#line 2031 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_12 = c->expireData(expireVersion, true);
															#line 2031 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12764 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont8when1(__when_expr_12.get(), loopDepth); };
			static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 13;
															#line 2031 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 12, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12769 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont1loopBody1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont10cont1loopBody1cont9(int loopDepth) 
	{
															#line 2034 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupDescription> __when_expr_13 = c->describeBackup();
															#line 2034 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12860 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont9when1(__when_expr_13.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 14;
															#line 2034 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 13, BackupDescription >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12865 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont10cont1loopBody1cont11(BackupDescription const& d,int loopDepth) 
	{
															#line 2035 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("\n%s\n", d.toString().c_str());
															#line 2006 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++i;
															#line 12963 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont10cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont11(BackupDescription && d,int loopDepth) 
	{
															#line 2035 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("\n%s\n", d.toString().c_str());
															#line 2006 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++i;
															#line 12974 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont10cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont9when1(BackupDescription const& d,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont11(d, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont9when1(BackupDescription && d,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont11(std::move(d), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 13, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 13, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 13, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 13, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont10cont3(Void const& _,int loopDepth) 
	{
															#line 2041 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		d = c->describeBackup();
															#line 2042 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_15 = ready(d);
															#line 2042 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13062 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_15.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 16;
															#line 2042 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 15, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 13067 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont3(Void && _,int loopDepth) 
	{
															#line 2041 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		d = c->describeBackup();
															#line 2042 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_15 = ready(d);
															#line 2042 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13080 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_15.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 16;
															#line 2042 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 15, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 13085 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont10cont4(Void const& _,int loopDepth) 
	{
															#line 2043 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(d.isError() && d.getError().code() == error_code_backup_does_not_exist);
															#line 2045 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_16 = c->dumpFileList();
															#line 2045 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13173 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont10cont4when1(__when_expr_16.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 17;
															#line 2045 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 16, BackupFileList >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 13178 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont4(Void && _,int loopDepth) 
	{
															#line 2043 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(d.isError() && d.getError().code() == error_code_backup_does_not_exist);
															#line 2045 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_16 = c->dumpFileList();
															#line 2045 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13191 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont10cont4when1(__when_expr_16.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 17;
															#line 2045 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 16, BackupFileList >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 13196 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont10cont5(BackupFileList const& empty,int loopDepth) 
	{
															#line 2046 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.ranges.size(), 0);
															#line 2047 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.logs.size(), 0);
															#line 2048 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.snapshots.size(), 0);
															#line 2050 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("BackupContainerTest URL=%s PASSED.\n", url.c_str());
															#line 2052 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<TestBackupContainerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestBackupContainerActorState(); static_cast<TestBackupContainerActor*>(this)->destroy(); return 0; }
															#line 13288 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<TestBackupContainerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestBackupContainerActorState();
		static_cast<TestBackupContainerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont5(BackupFileList && empty,int loopDepth) 
	{
															#line 2046 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.ranges.size(), 0);
															#line 2047 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.logs.size(), 0);
															#line 2048 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.snapshots.size(), 0);
															#line 2050 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("BackupContainerTest URL=%s PASSED.\n", url.c_str());
															#line 2052 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<TestBackupContainerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestBackupContainerActorState(); static_cast<TestBackupContainerActor*>(this)->destroy(); return 0; }
															#line 13308 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<TestBackupContainerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestBackupContainerActorState();
		static_cast<TestBackupContainerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont4when1(BackupFileList const& empty,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(empty, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when1(BackupFileList && empty,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(std::move(empty), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 16, BackupFileList >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 16, BackupFileList >*,BackupFileList const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 16, BackupFileList >*,BackupFileList && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 16, BackupFileList >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 16);

	}
															#line 1898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string url;
															#line 1898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<std::string> proxy;
															#line 1898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<std::string> encryptionKeyFileName;
															#line 1901 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowLock lock;
															#line 1909 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupContainer> c;
															#line 1921 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<Future<Void>> writes;
															#line 1922 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::map<Version, std::vector<std::string>> snapshots;
															#line 1923 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::map<Version, int64_t> snapshotSizes;
															#line 1924 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::map<Version, std::vector<std::pair<Key, Key>>> snapshotBeginEndKeys;
															#line 1925 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int nRangeFiles;
															#line 1926 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::map<Version, std::string> logs;
															#line 1927 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version v;
															#line 1930 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<int> fileSizes;
															#line 1937 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version logStart;
															#line 1938 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int kvfiles;
															#line 1939 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key begin;
															#line 1940 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key end;
															#line 1941 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int blockSize;
															#line 1981 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> log;
															#line 1996 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	BackupFileList listing;
															#line 2001 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	BackupDescription desc;
															#line 2005 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int i;
															#line 2020 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version expireVersion;
															#line 2024 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Future<Void> f;
															#line 2041 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Future<BackupDescription> d;
															#line 13441 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testBackupContainer()
															#line 1898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class TestBackupContainerActor final : public Actor<Void>, public ActorCallback< TestBackupContainerActor, 0, Void >, public ActorCallback< TestBackupContainerActor, 1, Void >, public ActorCallback< TestBackupContainerActor, 2, Void >, public ActorCallback< TestBackupContainerActor, 3, Reference<IBackupFile> >, public ActorCallback< TestBackupContainerActor, 4, Void >, public ActorCallback< TestBackupContainerActor, 5, Reference<IBackupFile> >, public ActorCallback< TestBackupContainerActor, 6, Void >, public ActorCallback< TestBackupContainerActor, 7, BackupFileList >, public ActorCallback< TestBackupContainerActor, 8, BackupDescription >, public ActorCallback< TestBackupContainerActor, 9, Optional<RestorableFileSet> >, public ActorCallback< TestBackupContainerActor, 10, Optional<RestorableFileSet> >, public ActorCallback< TestBackupContainerActor, 11, Void >, public ActorCallback< TestBackupContainerActor, 12, Void >, public ActorCallback< TestBackupContainerActor, 13, BackupDescription >, public ActorCallback< TestBackupContainerActor, 14, Void >, public ActorCallback< TestBackupContainerActor, 15, Void >, public ActorCallback< TestBackupContainerActor, 16, BackupFileList >, public FastAllocated<TestBackupContainerActor>, public TestBackupContainerActorState<TestBackupContainerActor> {
															#line 13446 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestBackupContainerActor>::operator new;
	using FastAllocated<TestBackupContainerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15880919620653803776UL, 14863681682428484864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestBackupContainerActor, 0, Void >;
friend struct ActorCallback< TestBackupContainerActor, 1, Void >;
friend struct ActorCallback< TestBackupContainerActor, 2, Void >;
friend struct ActorCallback< TestBackupContainerActor, 3, Reference<IBackupFile> >;
friend struct ActorCallback< TestBackupContainerActor, 4, Void >;
friend struct ActorCallback< TestBackupContainerActor, 5, Reference<IBackupFile> >;
friend struct ActorCallback< TestBackupContainerActor, 6, Void >;
friend struct ActorCallback< TestBackupContainerActor, 7, BackupFileList >;
friend struct ActorCallback< TestBackupContainerActor, 8, BackupDescription >;
friend struct ActorCallback< TestBackupContainerActor, 9, Optional<RestorableFileSet> >;
friend struct ActorCallback< TestBackupContainerActor, 10, Optional<RestorableFileSet> >;
friend struct ActorCallback< TestBackupContainerActor, 11, Void >;
friend struct ActorCallback< TestBackupContainerActor, 12, Void >;
friend struct ActorCallback< TestBackupContainerActor, 13, BackupDescription >;
friend struct ActorCallback< TestBackupContainerActor, 14, Void >;
friend struct ActorCallback< TestBackupContainerActor, 15, Void >;
friend struct ActorCallback< TestBackupContainerActor, 16, BackupFileList >;
															#line 1898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	TestBackupContainerActor(std::string const& url,Optional<std::string> const& proxy,Optional<std::string> const& encryptionKeyFileName) 
															#line 13479 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestBackupContainerActorState<TestBackupContainerActor>(url, proxy, encryptionKeyFileName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(264860235252261888UL, 13065414093191862528UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testBackupContainer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestBackupContainerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestBackupContainerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestBackupContainerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestBackupContainerActor, 3, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestBackupContainerActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestBackupContainerActor, 5, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TestBackupContainerActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< TestBackupContainerActor, 7, BackupFileList >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< TestBackupContainerActor, 8, BackupDescription >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< TestBackupContainerActor, 9, Optional<RestorableFileSet> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< TestBackupContainerActor, 10, Optional<RestorableFileSet> >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< TestBackupContainerActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< TestBackupContainerActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< TestBackupContainerActor, 13, BackupDescription >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< TestBackupContainerActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< TestBackupContainerActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< TestBackupContainerActor, 16, BackupFileList >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] Future<Void> testBackupContainer( std::string const& url, Optional<std::string> const& proxy, Optional<std::string> const& encryptionKeyFileName ) {
															#line 1898 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new TestBackupContainerActor(url, proxy, encryptionKeyFileName));
															#line 13527 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 2054 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 13532 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase2055()
															#line 2055 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2055Actor>
															#line 2055 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2055ActorState {
															#line 13538 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 2055 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2055ActorState(UnitTestParameters const& params) 
															#line 2055 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2055 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 13545 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase2055", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2055ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2055", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2056 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testBackupContainer(format("file://%s/fdb_backups/%llx", params.getDataDir().c_str(), timer_int()), {}, {});
															#line 2056 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<FlowTestCase2055Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13562 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase2055Actor*>(this)->actor_wait_state = 1;
															#line 2056 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase2055Actor, 0, Void >*>(static_cast<FlowTestCase2055Actor*>(this)));
															#line 13567 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2055ActorState();
		static_cast<FlowTestCase2055Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2057 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2055Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2055ActorState(); static_cast<FlowTestCase2055Actor*>(this)->destroy(); return 0; }
															#line 13590 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase2055Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2055ActorState();
		static_cast<FlowTestCase2055Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2057 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2055Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2055ActorState(); static_cast<FlowTestCase2055Actor*>(this)->destroy(); return 0; }
															#line 13602 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase2055Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2055ActorState();
		static_cast<FlowTestCase2055Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase2055Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase2055Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase2055Actor*>(this)->ActorCallback< FlowTestCase2055Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase2055Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase2055", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2055Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2055", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase2055Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase2055", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2055Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2055", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase2055Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase2055", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2055Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2055", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2055 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 13687 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase2055()
															#line 2055 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2055Actor final : public Actor<Void>, public ActorCallback< FlowTestCase2055Actor, 0, Void >, public FastAllocated<FlowTestCase2055Actor>, public FlowTestCase2055ActorState<FlowTestCase2055Actor> {
															#line 13692 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase2055Actor>::operator new;
	using FastAllocated<FlowTestCase2055Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2174885340054800128UL, 14882915102260026624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase2055Actor, 0, Void >;
															#line 2055 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2055Actor(UnitTestParameters const& params) 
															#line 13709 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase2055ActorState<FlowTestCase2055Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2055", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8556160105811949824UL, 9848130278739103232UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2055Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2055");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2055", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase2055Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2055 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2055( UnitTestParameters const& params ) {
															#line 2055 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2055Actor(params));
															#line 13741 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase2055, "/backup/containers/localdir/unencrypted")

#line 2059 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 13747 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase2060()
															#line 2060 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2060Actor>
															#line 2060 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2060ActorState {
															#line 13753 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 2060 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2060ActorState(UnitTestParameters const& params) 
															#line 2060 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2060 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 13760 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase2060", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2060ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2060", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2061 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testBackupContainer(format("file://%s/fdb_backups/%llx", params.getDataDir().c_str(), timer_int()), {}, format("%s/test_encryption_key", params.getDataDir().c_str()));
															#line 2061 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<FlowTestCase2060Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13777 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase2060Actor*>(this)->actor_wait_state = 1;
															#line 2061 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase2060Actor, 0, Void >*>(static_cast<FlowTestCase2060Actor*>(this)));
															#line 13782 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2060ActorState();
		static_cast<FlowTestCase2060Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2064 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2060Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2060ActorState(); static_cast<FlowTestCase2060Actor*>(this)->destroy(); return 0; }
															#line 13805 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase2060Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2060ActorState();
		static_cast<FlowTestCase2060Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2064 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2060Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2060ActorState(); static_cast<FlowTestCase2060Actor*>(this)->destroy(); return 0; }
															#line 13817 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase2060Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2060ActorState();
		static_cast<FlowTestCase2060Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase2060Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase2060Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase2060Actor*>(this)->ActorCallback< FlowTestCase2060Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase2060Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase2060", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2060Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2060", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase2060Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase2060", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2060Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2060", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase2060Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase2060", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2060Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2060", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2060 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 13902 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase2060()
															#line 2060 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2060Actor final : public Actor<Void>, public ActorCallback< FlowTestCase2060Actor, 0, Void >, public FastAllocated<FlowTestCase2060Actor>, public FlowTestCase2060ActorState<FlowTestCase2060Actor> {
															#line 13907 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase2060Actor>::operator new;
	using FastAllocated<FlowTestCase2060Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4186415245897394688UL, 3097168238745076736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase2060Actor, 0, Void >;
															#line 2060 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2060Actor(UnitTestParameters const& params) 
															#line 13924 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase2060ActorState<FlowTestCase2060Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2060", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14029797367006832896UL, 3911029193583832320UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2060Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2060");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2060", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase2060Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2060 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2060( UnitTestParameters const& params ) {
															#line 2060 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2060Actor(params));
															#line 13956 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase2060, "/backup/containers/localdir/encrypted")

#line 2066 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 13962 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase2067()
															#line 2067 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2067Actor>
															#line 2067 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2067ActorState {
															#line 13968 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 2067 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2067ActorState(UnitTestParameters const& params) 
															#line 2067 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2067 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 13975 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase2067", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2067ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2067", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2068 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!g_network->isSimulated())
															#line 13990 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 2069 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				const char* url = getenv("FDB_TEST_BACKUP_URL");
															#line 2070 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				ASSERT(url != nullptr);
															#line 2071 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Void> __when_expr_0 = testBackupContainer(url, {}, {});
															#line 2071 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<FlowTestCase2067Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14000 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FlowTestCase2067Actor*>(this)->actor_wait_state = 1;
															#line 2071 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase2067Actor, 0, Void >*>(static_cast<FlowTestCase2067Actor*>(this)));
															#line 14005 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2067ActorState();
		static_cast<FlowTestCase2067Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2073 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2067Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2067ActorState(); static_cast<FlowTestCase2067Actor*>(this)->destroy(); return 0; }
															#line 14033 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase2067Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2067ActorState();
		static_cast<FlowTestCase2067Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase2067Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase2067Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase2067Actor*>(this)->ActorCallback< FlowTestCase2067Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase2067Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase2067", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2067Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2067", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase2067Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase2067", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2067Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2067", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase2067Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase2067", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2067Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2067", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2067 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 14130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase2067()
															#line 2067 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2067Actor final : public Actor<Void>, public ActorCallback< FlowTestCase2067Actor, 0, Void >, public FastAllocated<FlowTestCase2067Actor>, public FlowTestCase2067ActorState<FlowTestCase2067Actor> {
															#line 14135 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase2067Actor>::operator new;
	using FastAllocated<FlowTestCase2067Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12299797975896399104UL, 7639731512923664896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase2067Actor, 0, Void >;
															#line 2067 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2067Actor(UnitTestParameters const& params) 
															#line 14152 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase2067ActorState<FlowTestCase2067Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2067", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10289150400300771584UL, 6089901324051538432UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2067Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2067");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2067", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase2067Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2067 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2067( UnitTestParameters const& params ) {
															#line 2067 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2067Actor(params));
															#line 14184 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase2067, "/backup/containers/url")

#line 2075 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 14190 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase2076()
															#line 2076 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2076Actor>
															#line 2076 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2076ActorState {
															#line 14196 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 2076 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2076ActorState(UnitTestParameters const& params) 
															#line 2076 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2076 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 14203 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase2076", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2076ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2076", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2077 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!g_network->isSimulated())
															#line 14218 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 2078 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				url = getenv("FDB_TEST_BACKUP_URL");
															#line 2079 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				ASSERT(url != nullptr);
															#line 2080 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				printf("Listing %s\n", url);
															#line 2081 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<std::vector<std::string>> __when_expr_0 = IBackupContainer::listContainers(url, {});
															#line 2081 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<FlowTestCase2076Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14230 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FlowTestCase2076Actor*>(this)->actor_wait_state = 1;
															#line 2081 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase2076Actor, 0, std::vector<std::string> >*>(static_cast<FlowTestCase2076Actor*>(this)));
															#line 14235 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2076ActorState();
		static_cast<FlowTestCase2076Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2086 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2076Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2076ActorState(); static_cast<FlowTestCase2076Actor*>(this)->destroy(); return 0; }
															#line 14263 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase2076Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2076ActorState();
		static_cast<FlowTestCase2076Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(std::vector<std::string> const& urls,int loopDepth) 
	{
															#line 2082 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto& u : urls ) {
															#line 2083 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			printf("%s\n", u.c_str());
															#line 14277 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::vector<std::string> && urls,int loopDepth) 
	{
															#line 2082 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto& u : urls ) {
															#line 2083 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			printf("%s\n", u.c_str());
															#line 14289 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::string> const& urls,int loopDepth) 
	{
		loopDepth = a_body1cont2(urls, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::string> && urls,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(urls), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase2076Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase2076Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase2076Actor*>(this)->ActorCallback< FlowTestCase2076Actor, 0, std::vector<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase2076Actor, 0, std::vector<std::string> >*,std::vector<std::string> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase2076", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2076Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2076", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase2076Actor, 0, std::vector<std::string> >*,std::vector<std::string> && value) 
	{
		fdb_probe_actor_enter("flowTestCase2076", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2076Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2076", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase2076Actor, 0, std::vector<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase2076", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2076Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2076", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2076 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 2078 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	const char* url;
															#line 14374 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase2076()
															#line 2076 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2076Actor final : public Actor<Void>, public ActorCallback< FlowTestCase2076Actor, 0, std::vector<std::string> >, public FastAllocated<FlowTestCase2076Actor>, public FlowTestCase2076ActorState<FlowTestCase2076Actor> {
															#line 14379 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase2076Actor>::operator new;
	using FastAllocated<FlowTestCase2076Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2413730945832482560UL, 11666562529354144000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase2076Actor, 0, std::vector<std::string> >;
															#line 2076 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2076Actor(UnitTestParameters const& params) 
															#line 14396 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase2076ActorState<FlowTestCase2076Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2076", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17605568632963610624UL, 5757144048842809344UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2076Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2076");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2076", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase2076Actor, 0, std::vector<std::string> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2076 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2076( UnitTestParameters const& params ) {
															#line 2076 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2076Actor(params));
															#line 14428 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase2076, "/backup/containers_list")

#line 2088 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 14434 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase2089()
															#line 2089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2089Actor>
															#line 2089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2089ActorState {
															#line 14440 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 2089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2089ActorState(UnitTestParameters const& params) 
															#line 2089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 14447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase2089", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2089ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2089", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2091 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			for(int i = 0;i < 1000;++i) {
															#line 2092 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				int64_t ts = deterministicRandom()->randomInt64(0, std::numeric_limits<int32_t>::max());
															#line 2093 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				ASSERT(BackupAgentBase::parseTime(BackupAgentBase::formatTime(ts)) == ts);
															#line 14466 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
															#line 2096 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupAgentBase::parseTime("2019/03/18.17:51:11-0600") == BackupAgentBase::parseTime("2019/03/18.16:51:11-0700"));
															#line 2098 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupAgentBase::parseTime("2019/03/31.22:45:07-0700") == BackupAgentBase::parseTime("2019/04/01.03:45:07-0200"));
															#line 2100 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupAgentBase::parseTime("2019/03/31.22:45:07+0000") == BackupAgentBase::parseTime("2019/04/01.03:45:07+0500"));
															#line 2102 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupAgentBase::parseTime("2019/03/31.22:45:07+0030") == BackupAgentBase::parseTime("2019/04/01.03:45:07+0530"));
															#line 2104 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupAgentBase::parseTime("2019/03/31.22:45:07+0030") == BackupAgentBase::parseTime("2019/04/01.04:00:07+0545"));
															#line 2107 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<FlowTestCase2089Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2089ActorState(); static_cast<FlowTestCase2089Actor*>(this)->destroy(); return 0; }
															#line 14480 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase2089Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase2089ActorState();
			static_cast<FlowTestCase2089Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2089ActorState();
		static_cast<FlowTestCase2089Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 2089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 14504 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase2089()
															#line 2089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2089Actor final : public Actor<Void>, public FastAllocated<FlowTestCase2089Actor>, public FlowTestCase2089ActorState<FlowTestCase2089Actor> {
															#line 14509 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase2089Actor>::operator new;
	using FastAllocated<FlowTestCase2089Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12472528642788190720UL, 18444410695505221888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 2089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2089Actor(UnitTestParameters const& params) 
															#line 14525 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase2089ActorState<FlowTestCase2089Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2089", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18396766403608709376UL, 11986537664335958272UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2089Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2089");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2089", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 2089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2089( UnitTestParameters const& params ) {
															#line 2089 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2089Actor(params));
															#line 14556 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase2089, "/backup/time")

#line 2109 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 14562 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase2110()
															#line 2110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2110Actor>
															#line 2110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2110ActorState {
															#line 14568 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 2110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2110ActorState(UnitTestParameters const& params) 
															#line 2110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 14575 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase2110", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2110ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2110", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2111 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::vector<LogFile> files;
															#line 2114 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 0, 100, 10, "file1", 100, 0, 2 });
															#line 2115 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 0, 99));
															#line 2116 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 0) == 0);
															#line 2118 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 0, 100, 10, "file2", 200, 1, 2 });
															#line 2119 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2120 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 0, 99));
															#line 2121 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 0, 100));
															#line 2122 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 0) == 99);
															#line 2125 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 100, 200, 10, "file3", 200, 0, 3 });
															#line 2126 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 100, 250, 10, "file4", 200, 1, 3 });
															#line 2127 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2128 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 0, 99));
															#line 2129 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 0, 100));
															#line 2130 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 50, 150));
															#line 2131 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 0) == 99);
															#line 2133 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 100, 300, 10, "file5", 200, 2, 3 });
															#line 2134 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2135 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 50, 150));
															#line 2136 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 50, 200));
															#line 2137 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 10, 199));
															#line 2138 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 0) == 199);
															#line 2139 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 100) == 199);
															#line 2141 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 250, 300, 10, "file6", 200, 0, 3 });
															#line 2142 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2143 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 50, 240));
															#line 2144 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 100, 280));
															#line 2145 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 99) == 199);
															#line 2147 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 250, 300, 10, "file7", 200, 1, 3 });
															#line 2148 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2149 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 100, 280));
															#line 2151 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 200, 250, 10, "file8", 200, 0, 3 });
															#line 2152 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2153 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 0, 299));
															#line 2154 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 100, 280));
															#line 2155 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 150) == 299);
															#line 2159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 300, 400, 10, "file10", 200, 0, 1 });
															#line 2160 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2161 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 0, 399));
															#line 2162 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 100, 399));
															#line 2163 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 150, 399));
															#line 2164 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 250, 399));
															#line 2165 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 0) == 399);
															#line 2166 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 99) == 399);
															#line 2167 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 250) == 399);
															#line 2169 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<FlowTestCase2110Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2110ActorState(); static_cast<FlowTestCase2110Actor*>(this)->destroy(); return 0; }
															#line 14680 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase2110Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase2110ActorState();
			static_cast<FlowTestCase2110Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2110ActorState();
		static_cast<FlowTestCase2110Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 2110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 14704 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase2110()
															#line 2110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2110Actor final : public Actor<Void>, public FastAllocated<FlowTestCase2110Actor>, public FlowTestCase2110ActorState<FlowTestCase2110Actor> {
															#line 14709 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase2110Actor>::operator new;
	using FastAllocated<FlowTestCase2110Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(780417436751244800UL, 2136989382834317824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 2110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2110Actor(UnitTestParameters const& params) 
															#line 14725 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase2110ActorState<FlowTestCase2110Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2110", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8269867332757572864UL, 9780443534752733696UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2110Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2110");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2110", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 2110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2110( UnitTestParameters const& params ) {
															#line 2110 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2110Actor(params));
															#line 14756 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase2110, "/backup/continuous")

#line 2171 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 14762 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase2172()
															#line 2172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2172Actor>
															#line 2172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2172ActorState {
															#line 14768 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 2172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2172ActorState(UnitTestParameters const& params) 
															#line 2172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 14775 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase2172", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2172ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2172", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2173 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::vector<LogFile> files;
															#line 2176 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 10, 100, 10, "file1", 100 });
															#line 2177 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 0, 5));
															#line 2178 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 50));
															#line 2179 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 105));
															#line 2180 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 100, 101));
															#line 2181 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 101, 150));
															#line 2182 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 99));
															#line 2183 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 100));
															#line 2184 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 101));
															#line 2185 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 150));
															#line 2186 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 70));
															#line 2187 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 99));
															#line 2188 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 100));
															#line 2189 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 11));
															#line 2190 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 98, 99));
															#line 2191 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 99, 100));
															#line 2192 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 99, 99));
															#line 2193 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 100, 100));
															#line 2194 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 0) == invalidVersion);
															#line 2195 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 5) == invalidVersion);
															#line 2196 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 10) == 100);
															#line 2197 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 50) == 100);
															#line 2198 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 99) == 100);
															#line 2199 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 100) == invalidVersion);
															#line 2200 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 101) == invalidVersion);
															#line 2203 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 100, 200, 10, "file2", 100 });
															#line 2204 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2205 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 0, 5));
															#line 2206 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 50));
															#line 2207 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 105));
															#line 2208 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 100, 101));
															#line 2209 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 101, 150));
															#line 2210 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 99));
															#line 2211 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 100));
															#line 2212 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 101));
															#line 2213 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 150));
															#line 2214 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 70));
															#line 2215 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 99));
															#line 2216 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 100));
															#line 2217 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 11));
															#line 2218 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 98, 99));
															#line 2219 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 99, 100));
															#line 2220 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 99, 99));
															#line 2221 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 100, 100));
															#line 2223 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 150));
															#line 2224 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 205));
															#line 2225 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 200, 201));
															#line 2226 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 201, 250));
															#line 2227 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 199));
															#line 2228 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 200));
															#line 2229 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 201));
															#line 2230 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 70, 170));
															#line 2231 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 70, 200));
															#line 2232 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 199, 200));
															#line 2233 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 199, 199));
															#line 2234 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 200, 200));
															#line 2236 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 0) == invalidVersion);
															#line 2237 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 5) == invalidVersion);
															#line 2238 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 10) == 200);
															#line 2239 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 50) == 200);
															#line 2240 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 99) == 200);
															#line 2241 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 100) == 200);
															#line 2242 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 101) == 200);
															#line 2243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 199) == 200);
															#line 2244 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 200) == invalidVersion);
															#line 2245 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 201) == invalidVersion);
															#line 2248 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 300, 400, 10, "file3", 100 });
															#line 2249 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 0, 5));
															#line 2251 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 50));
															#line 2252 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 105));
															#line 2253 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 100, 101));
															#line 2254 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 101, 150));
															#line 2255 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 99));
															#line 2256 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 100));
															#line 2257 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 101));
															#line 2258 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 150));
															#line 2259 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 70));
															#line 2260 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 99));
															#line 2261 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 100));
															#line 2262 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 11));
															#line 2263 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 98, 99));
															#line 2264 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 99, 100));
															#line 2265 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 99, 99));
															#line 2266 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 100, 100));
															#line 2268 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 150));
															#line 2269 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 205));
															#line 2270 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 200, 201));
															#line 2271 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 201, 250));
															#line 2272 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 199));
															#line 2273 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 200));
															#line 2274 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 201));
															#line 2275 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 70, 170));
															#line 2276 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 70, 200));
															#line 2277 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 199, 200));
															#line 2278 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 199, 199));
															#line 2279 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 200, 200));
															#line 2281 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 250, 260));
															#line 2282 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 250, 310));
															#line 2283 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 250, 405));
															#line 2284 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 400, 401));
															#line 2285 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 401, 450));
															#line 2286 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 300, 399));
															#line 2287 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 300, 400));
															#line 2288 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 300, 401));
															#line 2289 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 300, 350));
															#line 2290 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 350, 370));
															#line 2291 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 350, 400));
															#line 2292 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 400));
															#line 2293 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 100, 400));
															#line 2294 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 200, 400));
															#line 2295 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 299, 400));
															#line 2296 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 399, 400));
															#line 2297 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 399, 399));
															#line 2298 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 400, 400));
															#line 2300 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 0) == invalidVersion);
															#line 2301 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 5) == invalidVersion);
															#line 2302 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 10) == 200);
															#line 2303 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 50) == 200);
															#line 2304 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 99) == 200);
															#line 2305 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 100) == 200);
															#line 2306 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 101) == 200);
															#line 2307 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 199) == 200);
															#line 2308 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 200) == invalidVersion);
															#line 2309 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 201) == invalidVersion);
															#line 2310 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 250) == invalidVersion);
															#line 2311 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 299) == invalidVersion);
															#line 2312 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 300) == 400);
															#line 2313 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 301) == 400);
															#line 2314 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 399) == 400);
															#line 2315 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 400) == invalidVersion);
															#line 2316 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 401) == invalidVersion);
															#line 2317 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 450) == invalidVersion);
															#line 2319 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<FlowTestCase2172Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2172ActorState(); static_cast<FlowTestCase2172Actor*>(this)->destroy(); return 0; }
															#line 15058 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			new (&static_cast<FlowTestCase2172Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase2172ActorState();
			static_cast<FlowTestCase2172Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2172ActorState();
		static_cast<FlowTestCase2172Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 2172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 15082 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase2172()
															#line 2172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2172Actor final : public Actor<Void>, public FastAllocated<FlowTestCase2172Actor>, public FlowTestCase2172ActorState<FlowTestCase2172Actor> {
															#line 15087 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase2172Actor>::operator new;
	using FastAllocated<FlowTestCase2172Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12715211923499501568UL, 18065628817164017920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 2172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2172Actor(UnitTestParameters const& params) 
															#line 15103 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase2172ActorState<FlowTestCase2172Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2172", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10362881383423456256UL, 7178446050345912832UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2172Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2172");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2172", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 2172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2172( UnitTestParameters const& params ) {
															#line 2172 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2172Actor(params));
															#line 15134 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase2172, "/backup/logs_continuous")

#line 2321 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

void printFileList(BackupFileList& backupFileList) {
	printf("\nRangeFiles count:%lu", backupFileList.ranges.size());
	for (auto r : backupFileList.ranges)
		printf("\n%s", r.toString().c_str());

	printf("\nLogFiles count:%lu", backupFileList.logs.size());
	for (auto l : backupFileList.logs)
		printf("\n%s", l.toString().c_str());

	printf("\nSnapshotFiles count:%lu", backupFileList.snapshots.size());
	for (auto s : backupFileList.snapshots)
		printf("\n%" PRId64 ", %" PRId64 ", %s, %" PRId64 "\n",
		       s.beginVersion,
		       s.endVersion,
		       s.fileName.c_str(),
		       s.totalSize);
}

// Intentionally missing some log range files and checking if the snapshot can be restored.
															#line 15159 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via testBackupContainerWithMissingLogRanges()
															#line 2341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class TestBackupContainerWithMissingLogRangesActor>
															#line 2341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class TestBackupContainerWithMissingLogRangesActorState {
															#line 15165 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 2341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	TestBackupContainerWithMissingLogRangesActorState(std::string const& url,Optional<std::string> const& proxy) 
															#line 2341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : url(url),
															#line 2341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   proxy(proxy),
															#line 2342 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   lock(100e6)
															#line 15176 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this));

	}
	~TestBackupContainerWithMissingLogRangesActorState() 
	{
		fdb_probe_actor_destroy("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2343 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			printf("BackupContainerTest URL %s\n", url.c_str());
															#line 2345 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			c = IBackupContainer::openContainer(url, proxy, {});
															#line 15193 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			try {
															#line 2348 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Void> __when_expr_0 = c->deleteContainer();
															#line 2348 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 15199 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 1;
															#line 2348 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 0, Void >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 15204 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestBackupContainerWithMissingLogRangesActorState();
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2353 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = c->create();
															#line 2353 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15235 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 2;
															#line 2353 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 1, Void >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 15240 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2350 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (e.code() != error_code_backup_invalid_url && e.code() != error_code_backup_does_not_exist)
															#line 15250 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 2351 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 15254 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 2355 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		begin = randomKeyBetween(normalKeys);
															#line 2356 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		end = randomKeyBetween(KeyRangeRef(begin, normalKeys.end));
															#line 2357 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		blockSize = 3 * sizeof(uint32_t) + begin.size() + end.size() + 8;
															#line 2358 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes = std::vector<Future<Void>>();
															#line 2359 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		beginEndKeys = std::make_pair(begin, end);
															#line 2360 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotsMissingLogs = std::vector<bool>();
															#line 2361 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = deterministicRandom()->randomInt64(0, std::numeric_limits<Version>::max() / 2);
															#line 2362 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		tempLogEnd = 0;
															#line 2363 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logStart = v;
															#line 2364 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logEnd = v;
															#line 2365 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginVersion = v;
															#line 2366 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotEndVersion = v;
															#line 2367 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		lastMissedLogFileEnd = 0;
															#line 2370 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		numSnapshots = deterministicRandom()->randomInt(1, 10);
															#line 2371 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 15398 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 2355 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		begin = randomKeyBetween(normalKeys);
															#line 2356 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		end = randomKeyBetween(KeyRangeRef(begin, normalKeys.end));
															#line 2357 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		blockSize = 3 * sizeof(uint32_t) + begin.size() + end.size() + 8;
															#line 2358 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes = std::vector<Future<Void>>();
															#line 2359 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		beginEndKeys = std::make_pair(begin, end);
															#line 2360 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotsMissingLogs = std::vector<bool>();
															#line 2361 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = deterministicRandom()->randomInt64(0, std::numeric_limits<Version>::max() / 2);
															#line 2362 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		tempLogEnd = 0;
															#line 2363 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logStart = v;
															#line 2364 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logEnd = v;
															#line 2365 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginVersion = v;
															#line 2366 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotEndVersion = v;
															#line 2367 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		lastMissedLogFileEnd = 0;
															#line 2370 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		numSnapshots = deterministicRandom()->randomInt(1, 10);
															#line 2371 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 15435 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 2418 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_4 = waitForAll(writes);
															#line 2418 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15521 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 5;
															#line 2418 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 4, Void >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 15526 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 2371 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(numSnapshots))
															#line 15542 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2372 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		rangeFileNames = std::vector<std::string>();
															#line 2373 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginEndKeys = std::vector<std::pair<Key, Key>>();
															#line 2376 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		numRangeFiles = deterministicRandom()->randomInt(2, 5);
															#line 2377 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginVersion = v;
															#line 2378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 15556 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
															#line 2388 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotEndVersion = logEnd;
															#line 2391 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes.push_back(c->writeKeyspaceSnapshotFile(rangeFileNames, snapshotBeginEndKeys, deterministicRandom()->randomInt(0, 2e6), IncludeKeyRangeMap(BUGGIFY)));
															#line 2398 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotsMissingLogs.push_back(lastMissedLogFileEnd > snapshotBeginVersion);
															#line 2401 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 15584 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1(int loopDepth) 
	{
															#line 2378 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(numRangeFiles))
															#line 15600 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			return a_body1cont4loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2379 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IBackupFile>> __when_expr_2 = c->writeRangeFile(v, 0, v, blockSize);
															#line 2379 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 15608 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1cont4loopBody1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 3;
															#line 2379 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 2, Reference<IBackupFile> >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 15613 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont4loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 2380 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes.push_back(writeAndVerifyFile(c, range, deterministicRandom()->randomInt(0, 2e6), &lock));
															#line 2381 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		rangeFileNames.push_back(range->getFileName());
															#line 2382 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginEndKeys.push_back(beginEndKeys);
															#line 2384 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logEnd = v;
															#line 2385 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = nextVersion(v);
															#line 2386 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		--numRangeFiles;
															#line 15645 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont4loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1when1(Reference<IBackupFile> const& __range,int loopDepth) 
	{
															#line 2379 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		range = __range;
															#line 15654 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1when1(Reference<IBackupFile> && __range,int loopDepth) 
	{
		range = std::move(__range);
		loopDepth = a_body1cont4loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 2, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 2, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 2, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 2, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4loopBody1cont3(int loopDepth) 
	{
															#line 2415 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		--numSnapshots;
															#line 15733 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 2401 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(logStart < logEnd))
															#line 15749 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			return a_body1cont4loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2402 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		tempLogEnd = nextVersion(logStart);
															#line 2403 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (deterministicRandom()->random01() < 0.5)
															#line 15757 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 2404 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Reference<IBackupFile>> __when_expr_3 = c->writeLogFile(logStart, tempLogEnd, blockSize);
															#line 2404 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 15763 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont4loopBody1cont1loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 4;
															#line 2404 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 3, Reference<IBackupFile> >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 15768 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 2408 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!(tempLogEnd < snapshotBeginVersion || snapshotEndVersion < logStart))
															#line 15775 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 2409 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				snapshotsMissingLogs.back() = true;
															#line 15779 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			}
															#line 2410 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			lastMissedLogFileEnd = tempLogEnd;
															#line 15783 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = a_body1cont4loopBody1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont4loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2412 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logStart = tempLogEnd;
															#line 15806 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont4loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1loopBody1cont3(int loopDepth) 
	{
															#line 2405 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes.push_back(writeAndVerifyFile(c, log, deterministicRandom()->randomInt(0, 2e6), &lock));
															#line 15815 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1loopBody1when1(Reference<IBackupFile> const& __log,int loopDepth) 
	{
															#line 2404 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		log = __log;
															#line 15824 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4loopBody1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1loopBody1when1(Reference<IBackupFile> && __log,int loopDepth) 
	{
		log = std::move(__log);
		loopDepth = a_body1cont4loopBody1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 3, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 3, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 3, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 3, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 2419 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_5 = c->dumpFileList();
															#line 2419 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15905 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 6;
															#line 2419 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 15910 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 2419 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_5 = c->dumpFileList();
															#line 2419 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15921 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 6;
															#line 2419 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 15926 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 2420 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printFileList(listing);
															#line 2422 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("\n\nSnapshots missing logs:");
															#line 2423 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		i = 0;
															#line 2424 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for(;i < snapshotsMissingLogs.size();++i) {
															#line 2425 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			printf("\nSnapshot%d: %s", i, snapshotsMissingLogs[i] ? "true" : "false");
															#line 16018 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 2427 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupDescription> __when_expr_6 = c->describeBackup();
															#line 2427 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16024 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 7;
															#line 2427 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 6, BackupDescription >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 16029 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(BackupFileList const& __listing,int loopDepth) 
	{
															#line 2419 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		listing = __listing;
															#line 16038 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(BackupFileList && __listing,int loopDepth) 
	{
		listing = std::move(__listing);
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >*,BackupFileList const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >*,BackupFileList && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 2428 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("\n\n%s\n", desc.toString().c_str());
															#line 2430 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		i = 0;
															#line 16119 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(BackupDescription const& __desc,int loopDepth) 
	{
															#line 2427 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc = __desc;
															#line 16128 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(BackupDescription && __desc,int loopDepth) 
	{
		desc = std::move(__desc);
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 6, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 6, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 6, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 6, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 2439 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for(i = snapshotsMissingLogs.size() - 1;i >= 0;--i) {
															#line 2440 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!snapshotsMissingLogs[i])
															#line 16209 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			{
															#line 2441 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				int j = i - 1;
															#line 2442 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				for(;j >= 0;--j) {
															#line 2443 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					if (snapshotsMissingLogs[j] || !BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot( listing.logs, listing.snapshots[j].endVersion, listing.snapshots[j + 1].beginVersion))
															#line 16217 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
					{
						break;
					}
				}
															#line 2448 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				ASSERT(desc.minRestorableVersion.get() == listing.snapshots[j + 1].endVersion);
															#line 2449 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				ASSERT(desc.maxRestorableVersion.get() >= listing.snapshots[i].endVersion);
															#line 2450 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (i + 1 < snapshotsMissingLogs.size())
															#line 16228 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				{
															#line 2451 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					ASSERT(desc.maxRestorableVersion.get() < listing.snapshots[i + 1].endVersion);
															#line 16232 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
				}
				break;
			}
		}
															#line 2456 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("DELETING\n");
															#line 2457 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_8 = c->deleteContainer();
															#line 2457 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16243 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 9;
															#line 2457 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 8, Void >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 16248 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont8loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1(int loopDepth) 
	{
															#line 2430 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(i < listing.snapshots.size()))
															#line 16264 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
			return a_body1cont8break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2432 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Optional<RestorableFileSet>> __when_expr_7 = c->getRestoreSet(listing.snapshots[i].endVersion);
															#line 2432 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16272 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont8loopBody1when1(__when_expr_7.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 8;
															#line 2432 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 7, Optional<RestorableFileSet> >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 16277 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8break1(int loopDepth) 
	{
		try {
			return a_body1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8loopBody1cont1(Optional<RestorableFileSet> const& rest,int loopDepth) 
	{
															#line 2433 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (snapshotsMissingLogs[i])
															#line 16299 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 2434 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!rest.present());
															#line 16303 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2436 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(rest.present());
															#line 16309 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 2430 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++i;
															#line 16313 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont8loopHead1(0);

		return loopDepth;
	}
	int a_body1cont8loopBody1cont1(Optional<RestorableFileSet> && rest,int loopDepth) 
	{
															#line 2433 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (snapshotsMissingLogs[i])
															#line 16322 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		{
															#line 2434 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!rest.present());
															#line 16326 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2436 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(rest.present());
															#line 16332 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		}
															#line 2430 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++i;
															#line 16336 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont8loopHead1(0);

		return loopDepth;
	}
	int a_body1cont8loopBody1when1(Optional<RestorableFileSet> const& rest,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody1cont1(rest, loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1when1(Optional<RestorableFileSet> && rest,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody1cont1(std::move(rest), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 7, Optional<RestorableFileSet> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 7, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 7, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 7, Optional<RestorableFileSet> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 2459 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		d = c->describeBackup();
															#line 2460 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_9 = ready(d);
															#line 2460 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16424 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 10;
															#line 2460 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 16429 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 2459 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		d = c->describeBackup();
															#line 2460 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_9 = ready(d);
															#line 2460 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16442 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 10;
															#line 2460 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 16447 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont7(Void const& _,int loopDepth) 
	{
															#line 2461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(d.isError() && d.getError().code() == error_code_backup_does_not_exist);
															#line 2463 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_10 = c->dumpFileList();
															#line 2463 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16535 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont7when1(__when_expr_10.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 11;
															#line 2463 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 16540 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont7(Void && _,int loopDepth) 
	{
															#line 2461 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(d.isError() && d.getError().code() == error_code_backup_does_not_exist);
															#line 2463 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_10 = c->dumpFileList();
															#line 2463 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16553 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont7when1(__when_expr_10.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 11;
															#line 2463 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 16558 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont8(BackupFileList const& empty,int loopDepth) 
	{
															#line 2464 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.ranges.size(), 0);
															#line 2465 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.logs.size(), 0);
															#line 2466 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.snapshots.size(), 0);
															#line 2468 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("BackupContainerTest URL=%s PASSED.\n", url.c_str());
															#line 2470 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestBackupContainerWithMissingLogRangesActorState(); static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->destroy(); return 0; }
															#line 16650 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestBackupContainerWithMissingLogRangesActorState();
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont8(BackupFileList && empty,int loopDepth) 
	{
															#line 2464 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.ranges.size(), 0);
															#line 2465 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.logs.size(), 0);
															#line 2466 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.snapshots.size(), 0);
															#line 2468 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("BackupContainerTest URL=%s PASSED.\n", url.c_str());
															#line 2470 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestBackupContainerWithMissingLogRangesActorState(); static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->destroy(); return 0; }
															#line 16670 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestBackupContainerWithMissingLogRangesActorState();
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont7when1(BackupFileList const& empty,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8(empty, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont7when1(BackupFileList && empty,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8(std::move(empty), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >*,BackupFileList const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >*,BackupFileList && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 10);

	}
															#line 2341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string url;
															#line 2341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<std::string> proxy;
															#line 2342 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowLock lock;
															#line 2345 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupContainer> c;
															#line 2355 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key begin;
															#line 2356 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key end;
															#line 2357 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int blockSize;
															#line 2358 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<Future<Void>> writes;
															#line 2359 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::pair<Key, Key> beginEndKeys;
															#line 2360 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<bool> snapshotsMissingLogs;
															#line 2361 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version v;
															#line 2362 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version tempLogEnd;
															#line 2363 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version logStart;
															#line 2364 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version logEnd;
															#line 2365 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version snapshotBeginVersion;
															#line 2366 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version snapshotEndVersion;
															#line 2367 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version lastMissedLogFileEnd;
															#line 2370 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int numSnapshots;
															#line 2372 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<std::string> rangeFileNames;
															#line 2373 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<std::pair<Key, Key>> snapshotBeginEndKeys;
															#line 2376 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int numRangeFiles;
															#line 2379 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> range;
															#line 2404 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> log;
															#line 2419 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	BackupFileList listing;
															#line 2423 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int i;
															#line 2427 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	BackupDescription desc;
															#line 2459 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Future<BackupDescription> d;
															#line 16807 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testBackupContainerWithMissingLogRanges()
															#line 2341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class TestBackupContainerWithMissingLogRangesActor final : public Actor<Void>, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 0, Void >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 1, Void >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 2, Reference<IBackupFile> >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 3, Reference<IBackupFile> >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 4, Void >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 6, BackupDescription >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 7, Optional<RestorableFileSet> >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 8, Void >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >, public FastAllocated<TestBackupContainerWithMissingLogRangesActor>, public TestBackupContainerWithMissingLogRangesActorState<TestBackupContainerWithMissingLogRangesActor> {
															#line 16812 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestBackupContainerWithMissingLogRangesActor>::operator new;
	using FastAllocated<TestBackupContainerWithMissingLogRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7537959803159442176UL, 15385705179236151552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 0, Void >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 1, Void >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 2, Reference<IBackupFile> >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 3, Reference<IBackupFile> >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 4, Void >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 6, BackupDescription >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 7, Optional<RestorableFileSet> >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 8, Void >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >;
															#line 2341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	TestBackupContainerWithMissingLogRangesActor(std::string const& url,Optional<std::string> const& proxy) 
															#line 16839 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestBackupContainerWithMissingLogRangesActorState<TestBackupContainerWithMissingLogRangesActor>(url, proxy),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12217765069977313536UL, 13268377201974446080UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testBackupContainerWithMissingLogRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 2, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 3, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 6, BackupDescription >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 7, Optional<RestorableFileSet> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] Future<Void> testBackupContainerWithMissingLogRanges( std::string const& url, Optional<std::string> const& proxy ) {
															#line 2341 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new TestBackupContainerWithMissingLogRangesActor(url, proxy));
															#line 16881 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}

#line 2472 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 16886 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase2473()
															#line 2473 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2473Actor>
															#line 2473 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2473ActorState {
															#line 16892 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
															#line 2473 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2473ActorState(UnitTestParameters const& params) 
															#line 2473 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2473 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 16899 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase2473", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2473ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2473", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2474 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testBackupContainerWithMissingLogRanges( format("file://%s/fdb_backups/%llx", params.getDataDir().c_str(), timer_int()), {});
															#line 2474 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<FlowTestCase2473Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16916 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase2473Actor*>(this)->actor_wait_state = 1;
															#line 2474 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase2473Actor, 0, Void >*>(static_cast<FlowTestCase2473Actor*>(this)));
															#line 16921 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2473ActorState();
		static_cast<FlowTestCase2473Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2476 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2473Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2473ActorState(); static_cast<FlowTestCase2473Actor*>(this)->destroy(); return 0; }
															#line 16944 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase2473Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2473ActorState();
		static_cast<FlowTestCase2473Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2476 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2473Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2473ActorState(); static_cast<FlowTestCase2473Actor*>(this)->destroy(); return 0; }
															#line 16956 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase2473Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2473ActorState();
		static_cast<FlowTestCase2473Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase2473Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase2473Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase2473Actor*>(this)->ActorCallback< FlowTestCase2473Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase2473Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase2473", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2473Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2473", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase2473Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase2473", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2473Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2473", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase2473Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase2473", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2473Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2473", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2473 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 17041 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase2473()
															#line 2473 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2473Actor final : public Actor<Void>, public ActorCallback< FlowTestCase2473Actor, 0, Void >, public FastAllocated<FlowTestCase2473Actor>, public FlowTestCase2473ActorState<FlowTestCase2473Actor> {
															#line 17046 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase2473Actor>::operator new;
	using FastAllocated<FlowTestCase2473Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7255739916064490240UL, 11203763851414277632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase2473Actor, 0, Void >;
															#line 2473 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2473Actor(UnitTestParameters const& params) 
															#line 17063 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase2473ActorState<FlowTestCase2473Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2473", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7765652611291955712UL, 9375352236060579328UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2473Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2473");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2473", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase2473Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2473 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2473( UnitTestParameters const& params ) {
															#line 2473 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2473Actor(params));
															#line 17095 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase2473, "/backup/containers/localdir/missingLogRangesRestorability")

#line 2478 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 17101 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/build_output/fdbclient/BackupContainerFileSystem.actor.g.cpp.py_gen"
// This generated class is to be used only via testBackupContinuousLogEndVer()
															#line 2479 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class TestBackupContinuousLogEndVerActor>
															#line 2479 "/codebuild/output/src3175872744/src/github.com/apple/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class TestBackupContinuousLogEndVerActorState {
															#line 17107 "/co