/*
 * Copyright 2018-2020 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

#define lr x30
#define ip0 x16

  .data

  .globl _libfdb_c_so_tramp_table
  .hidden _libfdb_c_so_tramp_table
  .align 8
_libfdb_c_so_tramp_table:
  .zero 680

  .text

  .globl _libfdb_c_so_tramp_resolve
  .hidden _libfdb_c_so_tramp_resolve

  .globl _libfdb_c_so_save_regs_and_resolve
  .hidden _libfdb_c_so_save_regs_and_resolve
  .type _libfdb_c_so_save_regs_and_resolve, %function
_libfdb_c_so_save_regs_and_resolve:
  .cfi_startproc

  // Slow path which calls dlsym, taken only on first call.
  // Registers are saved according to "Procedure Call Standard for the Arm® 64-bit Architecture".
  // For DWARF directives, read https://www.imperialviolet.org/2017/01/18/cfi.html.

  // Stack is aligned at 16 bytes

#define PUSH_PAIR(reg1, reg2) stp reg1, reg2, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset reg1, 0; .cfi_rel_offset reg2, 8
#define POP_PAIR(reg1, reg2) ldp reg1, reg2, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore reg2; .cfi_restore reg1

#define PUSH_WIDE_PAIR(reg1, reg2) stp reg1, reg2, [sp, #-32]!; .cfi_adjust_cfa_offset 32; .cfi_rel_offset reg1, 0; .cfi_rel_offset reg2, 16
#define POP_WIDE_PAIR(reg1, reg2) ldp reg1, reg2, [sp], #32; .cfi_adjust_cfa_offset -32; .cfi_restore reg2; .cfi_restore reg1

  // Save only arguments (and lr)
  PUSH_PAIR(x0, x1)
  PUSH_PAIR(x2, x3)
  PUSH_PAIR(x4, x5)
  PUSH_PAIR(x6, x7)
  PUSH_PAIR(x8, lr)

  ldr x0, [sp, #80]  // 16*5

  PUSH_WIDE_PAIR(q0, q1)
  PUSH_WIDE_PAIR(q2, q3)
  PUSH_WIDE_PAIR(q4, q5)
  PUSH_WIDE_PAIR(q6, q7)

  // Stack is aligned at 16 bytes

  bl _libfdb_c_so_tramp_resolve

  // TODO: pop pc?

  POP_WIDE_PAIR(q6, q7)
  POP_WIDE_PAIR(q4, q5)
  POP_WIDE_PAIR(q2, q3)
  POP_WIDE_PAIR(q0, q1)

  POP_PAIR(x8, lr)
  POP_PAIR(x6, x7)
  POP_PAIR(x4, x5)
  POP_PAIR(x2, x3)
  POP_PAIR(x0, x1)

  br lr

  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_add_network_thread_completion_hook
  .p2align 4
  .type fdb_add_network_thread_completion_hook, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_add_network_thread_completion_hook
#endif
fdb_add_network_thread_completion_hook:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+0
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+0]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 0
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_cluster_create_database
  .p2align 4
  .type fdb_cluster_create_database, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_cluster_create_database
#endif
fdb_cluster_create_database:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+8
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+8]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 1
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_cluster_destroy
  .p2align 4
  .type fdb_cluster_destroy, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_cluster_destroy
#endif
fdb_cluster_destroy:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+16
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+16]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 2
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_cluster_set_option
  .p2align 4
  .type fdb_cluster_set_option, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_cluster_set_option
#endif
fdb_cluster_set_option:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+24
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+24]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 3
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_create_cluster
  .p2align 4
  .type fdb_create_cluster, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_create_cluster
#endif
fdb_create_cluster:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+32
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+32]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 4
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_create_database
  .p2align 4
  .type fdb_create_database, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_create_database
#endif
fdb_create_database:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+40
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+40]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 5
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_create_database_from_connection_string
  .p2align 4
  .type fdb_create_database_from_connection_string, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_create_database_from_connection_string
#endif
fdb_create_database_from_connection_string:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+48
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+48]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 6
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_database_create_shared_state
  .p2align 4
  .type fdb_database_create_shared_state, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_database_create_shared_state
#endif
fdb_database_create_shared_state:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+56
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+56]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 7
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_database_create_snapshot
  .p2align 4
  .type fdb_database_create_snapshot, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_database_create_snapshot
#endif
fdb_database_create_snapshot:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+64
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+64]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 8
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_database_create_transaction
  .p2align 4
  .type fdb_database_create_transaction, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_database_create_transaction
#endif
fdb_database_create_transaction:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+72
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+72]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 9
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_database_destroy
  .p2align 4
  .type fdb_database_destroy, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_database_destroy
#endif
fdb_database_destroy:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+80
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+80]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 10
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_database_force_recovery_with_data_loss
  .p2align 4
  .type fdb_database_force_recovery_with_data_loss, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_database_force_recovery_with_data_loss
#endif
fdb_database_force_recovery_with_data_loss:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+88
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+88]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 11
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_database_get_client_status
  .p2align 4
  .type fdb_database_get_client_status, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_database_get_client_status
#endif
fdb_database_get_client_status:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+96
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+96]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 12
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_database_get_main_thread_busyness
  .p2align 4
  .type fdb_database_get_main_thread_busyness, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_database_get_main_thread_busyness
#endif
fdb_database_get_main_thread_busyness:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+104
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+104]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 13
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_database_get_server_protocol
  .p2align 4
  .type fdb_database_get_server_protocol, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_database_get_server_protocol
#endif
fdb_database_get_server_protocol:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+112
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+112]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 14
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_database_open_tenant
  .p2align 4
  .type fdb_database_open_tenant, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_database_open_tenant
#endif
fdb_database_open_tenant:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+120
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+120]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 15
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_database_reboot_worker
  .p2align 4
  .type fdb_database_reboot_worker, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_database_reboot_worker
#endif
fdb_database_reboot_worker:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+128
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+128]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 16
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_database_set_option
  .p2align 4
  .type fdb_database_set_option, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_database_set_option
#endif
fdb_database_set_option:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+136
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+136]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 17
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_database_set_shared_state
  .p2align 4
  .type fdb_database_set_shared_state, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_database_set_shared_state
#endif
fdb_database_set_shared_state:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+144
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+144]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 18
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_error_predicate
  .p2align 4
  .type fdb_error_predicate, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_error_predicate
#endif
fdb_error_predicate:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+152
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+152]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 19
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_block_until_ready
  .p2align 4
  .type fdb_future_block_until_ready, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_block_until_ready
#endif
fdb_future_block_until_ready:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+160
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+160]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 20
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_cancel
  .p2align 4
  .type fdb_future_cancel, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_cancel
#endif
fdb_future_cancel:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+168
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+168]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 21
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_destroy
  .p2align 4
  .type fdb_future_destroy, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_destroy
#endif
fdb_future_destroy:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+176
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+176]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 22
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_get_bool
  .p2align 4
  .type fdb_future_get_bool, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_get_bool
#endif
fdb_future_get_bool:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+184
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+184]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 23
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_get_cluster
  .p2align 4
  .type fdb_future_get_cluster, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_get_cluster
#endif
fdb_future_get_cluster:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+192
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+192]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 24
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_get_database
  .p2align 4
  .type fdb_future_get_database, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_get_database
#endif
fdb_future_get_database:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+200
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+200]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 25
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_get_double
  .p2align 4
  .type fdb_future_get_double, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_get_double
#endif
fdb_future_get_double:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+208
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+208]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 26
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_get_error
  .p2align 4
  .type fdb_future_get_error, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_get_error
#endif
fdb_future_get_error:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+216
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+216]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 27
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_get_int64
  .p2align 4
  .type fdb_future_get_int64, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_get_int64
#endif
fdb_future_get_int64:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+224
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+224]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 28
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_get_key
  .p2align 4
  .type fdb_future_get_key, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_get_key
#endif
fdb_future_get_key:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+232
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+232]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 29
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_get_key_array
  .p2align 4
  .type fdb_future_get_key_array, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_get_key_array
#endif
fdb_future_get_key_array:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+240
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+240]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 30
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_get_keyrange_array
  .p2align 4
  .type fdb_future_get_keyrange_array, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_get_keyrange_array
#endif
fdb_future_get_keyrange_array:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+248
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+248]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 31
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_get_keyvalue_array
  .p2align 4
  .type fdb_future_get_keyvalue_array, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_get_keyvalue_array
#endif
fdb_future_get_keyvalue_array:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+256
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+256]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 32
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_get_mappedkeyvalue_array
  .p2align 4
  .type fdb_future_get_mappedkeyvalue_array, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_get_mappedkeyvalue_array
#endif
fdb_future_get_mappedkeyvalue_array:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+264
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+264]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 33
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_get_shared_state
  .p2align 4
  .type fdb_future_get_shared_state, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_get_shared_state
#endif
fdb_future_get_shared_state:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+272
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+272]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 34
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_get_string_array
  .p2align 4
  .type fdb_future_get_string_array, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_get_string_array
#endif
fdb_future_get_string_array:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+280
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+280]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 35
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_get_uint64
  .p2align 4
  .type fdb_future_get_uint64, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_get_uint64
#endif
fdb_future_get_uint64:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+288
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+288]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 36
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_get_value
  .p2align 4
  .type fdb_future_get_value, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_get_value
#endif
fdb_future_get_value:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+296
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+296]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 37
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_get_version
  .p2align 4
  .type fdb_future_get_version, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_get_version
#endif
fdb_future_get_version:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+304
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+304]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 38
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_is_error
  .p2align 4
  .type fdb_future_is_error, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_is_error
#endif
fdb_future_is_error:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+312
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+312]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 39
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_is_ready
  .p2align 4
  .type fdb_future_is_ready, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_is_ready
#endif
fdb_future_is_ready:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+320
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+320]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 40
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_release_memory
  .p2align 4
  .type fdb_future_release_memory, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_release_memory
#endif
fdb_future_release_memory:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+328
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+328]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 41
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_future_set_callback
  .p2align 4
  .type fdb_future_set_callback, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_future_set_callback
#endif
fdb_future_set_callback:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+336
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+336]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 42
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_get_client_version
  .p2align 4
  .type fdb_get_client_version, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_get_client_version
#endif
fdb_get_client_version:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+344
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+344]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 43
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_get_error
  .p2align 4
  .type fdb_get_error, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_get_error
#endif
fdb_get_error:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+352
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+352]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 44
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_get_max_api_version
  .p2align 4
  .type fdb_get_max_api_version, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_get_max_api_version
#endif
fdb_get_max_api_version:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+360
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+360]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 45
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_network_set_option
  .p2align 4
  .type fdb_network_set_option, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_network_set_option
#endif
fdb_network_set_option:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+368
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+368]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 46
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_result_destroy
  .p2align 4
  .type fdb_result_destroy, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_result_destroy
#endif
fdb_result_destroy:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+376
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+376]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 47
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_result_get_keyvalue_array
  .p2align 4
  .type fdb_result_get_keyvalue_array, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_result_get_keyvalue_array
#endif
fdb_result_get_keyvalue_array:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+384
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+384]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 48
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_run_network
  .p2align 4
  .type fdb_run_network, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_run_network
#endif
fdb_run_network:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+392
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+392]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 49
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_select_api_version_impl
  .p2align 4
  .type fdb_select_api_version_impl, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_select_api_version_impl
#endif
fdb_select_api_version_impl:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+400
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+400]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 50
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_setup_network
  .p2align 4
  .type fdb_setup_network, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_setup_network
#endif
fdb_setup_network:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+408
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+408]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 51
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_stop_network
  .p2align 4
  .type fdb_stop_network, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_stop_network
#endif
fdb_stop_network:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+416
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+416]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 52
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_tenant_create_transaction
  .p2align 4
  .type fdb_tenant_create_transaction, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_tenant_create_transaction
#endif
fdb_tenant_create_transaction:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+424
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+424]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 53
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_tenant_destroy
  .p2align 4
  .type fdb_tenant_destroy, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_tenant_destroy
#endif
fdb_tenant_destroy:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+432
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+432]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 54
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_tenant_get_id
  .p2align 4
  .type fdb_tenant_get_id, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_tenant_get_id
#endif
fdb_tenant_get_id:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+440
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+440]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 55
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_add_conflict_range
  .p2align 4
  .type fdb_transaction_add_conflict_range, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_add_conflict_range
#endif
fdb_transaction_add_conflict_range:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+448
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+448]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 56
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_atomic_op
  .p2align 4
  .type fdb_transaction_atomic_op, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_atomic_op
#endif
fdb_transaction_atomic_op:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+456
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+456]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 57
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_cancel
  .p2align 4
  .type fdb_transaction_cancel, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_cancel
#endif
fdb_transaction_cancel:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+464
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+464]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 58
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_clear
  .p2align 4
  .type fdb_transaction_clear, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_clear
#endif
fdb_transaction_clear:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+472
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+472]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 59
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_clear_range
  .p2align 4
  .type fdb_transaction_clear_range, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_clear_range
#endif
fdb_transaction_clear_range:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+480
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+480]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 60
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_commit
  .p2align 4
  .type fdb_transaction_commit, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_commit
#endif
fdb_transaction_commit:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+488
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+488]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 61
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_destroy
  .p2align 4
  .type fdb_transaction_destroy, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_destroy
#endif
fdb_transaction_destroy:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+496
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+496]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 62
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_get
  .p2align 4
  .type fdb_transaction_get, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_get
#endif
fdb_transaction_get:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+504
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+504]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 63
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_get_addresses_for_key
  .p2align 4
  .type fdb_transaction_get_addresses_for_key, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_get_addresses_for_key
#endif
fdb_transaction_get_addresses_for_key:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+512
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+512]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 64
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_get_approximate_size
  .p2align 4
  .type fdb_transaction_get_approximate_size, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_get_approximate_size
#endif
fdb_transaction_get_approximate_size:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+520
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+520]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 65
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_get_committed_version
  .p2align 4
  .type fdb_transaction_get_committed_version, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_get_committed_version
#endif
fdb_transaction_get_committed_version:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+528
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+528]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 66
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_get_estimated_range_size_bytes
  .p2align 4
  .type fdb_transaction_get_estimated_range_size_bytes, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_get_estimated_range_size_bytes
#endif
fdb_transaction_get_estimated_range_size_bytes:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+536
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+536]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 67
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_get_key
  .p2align 4
  .type fdb_transaction_get_key, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_get_key
#endif
fdb_transaction_get_key:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+544
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+544]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 68
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_get_mapped_range
  .p2align 4
  .type fdb_transaction_get_mapped_range, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_get_mapped_range
#endif
fdb_transaction_get_mapped_range:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+552
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+552]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 69
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_get_range
  .p2align 4
  .type fdb_transaction_get_range, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_get_range
#endif
fdb_transaction_get_range:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+560
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+560]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 70
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_get_range_selector
  .p2align 4
  .type fdb_transaction_get_range_selector, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_get_range_selector
#endif
fdb_transaction_get_range_selector:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+568
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+568]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 71
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_get_range_split_points
  .p2align 4
  .type fdb_transaction_get_range_split_points, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_get_range_split_points
#endif
fdb_transaction_get_range_split_points:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+576
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+576]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 72
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_get_read_version
  .p2align 4
  .type fdb_transaction_get_read_version, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_get_read_version
#endif
fdb_transaction_get_read_version:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+584
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+584]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 73
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_get_tag_throttled_duration
  .p2align 4
  .type fdb_transaction_get_tag_throttled_duration, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_get_tag_throttled_duration
#endif
fdb_transaction_get_tag_throttled_duration:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+592
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+592]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 74
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_get_total_cost
  .p2align 4
  .type fdb_transaction_get_total_cost, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_get_total_cost
#endif
fdb_transaction_get_total_cost:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+600
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+600]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 75
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_get_versionstamp
  .p2align 4
  .type fdb_transaction_get_versionstamp, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_get_versionstamp
#endif
fdb_transaction_get_versionstamp:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+608
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+608]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 76
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_on_error
  .p2align 4
  .type fdb_transaction_on_error, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_on_error
#endif
fdb_transaction_on_error:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+616
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+616]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 77
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_reset
  .p2align 4
  .type fdb_transaction_reset, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_reset
#endif
fdb_transaction_reset:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+624
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+624]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 78
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_set
  .p2align 4
  .type fdb_transaction_set, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_set
#endif
fdb_transaction_set:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+632
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+632]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 79
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_set_option
  .p2align 4
  .type fdb_transaction_set_option, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_set_option
#endif
fdb_transaction_set_option:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+640
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+640]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 80
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_set_read_version
  .p2align 4
  .type fdb_transaction_set_read_version, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_set_read_version
#endif
fdb_transaction_set_read_version:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+648
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+648]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 81
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_transaction_watch
  .p2align 4
  .type fdb_transaction_watch, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_transaction_watch
#endif
fdb_transaction_watch:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+656
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+656]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 82
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

/*
 * Copyright 2018-2021 Yury Gribov
 *
 * The MIT License (MIT)
 *
 * Use of this source code is governed by MIT license that can be
 * found in the LICENSE.txt file.
 */

  .globl fdb_use_future_protocol_version
  .p2align 4
  .type fdb_use_future_protocol_version, %function
#ifdef IMPLIB_HIDDEN_SHIMS
  .hidden fdb_use_future_protocol_version
#endif
fdb_use_future_protocol_version:
  .cfi_startproc

1:
  // Load address
  // TODO: can we do this faster on newer ARMs?
  adrp ip0, _libfdb_c_so_tramp_table+664
  ldr ip0, [ip0, #:lo12:_libfdb_c_so_tramp_table+664]
 
  cbz ip0, 2f

  // Fast path
  br ip0

2:
  // Slow path
  mov ip0, 83
  stp ip0, lr, [sp, #-16]!; .cfi_adjust_cfa_offset 16; .cfi_rel_offset ip0, 0; .cfi_rel_offset lr, 8;
  bl _libfdb_c_so_save_regs_and_resolve
  ldp ip0, lr, [sp], #16; .cfi_adjust_cfa_offset -16; .cfi_restore lr; .cfi_restore ip0
  b 1b
  .cfi_endproc

