""" Protocol Version

This code is generated by `protocol_version.py`. Do not modify by hand.
"""


class ProtocolVersion:
    _supported_protocol_versions = set()

    def __init__(self, version: int):
        self._version = version

    def __hash__(self):
        return hash(self._version)

    @property
    def _version_flag_mask(self) -> int:
        return 0x0FFFFFFFFFFFFFFF

    @property
    def version(self) -> int:
        return self._version & self._version_flag_mask

    @property
    def compatible_protocol_version_mask(self) -> int:
        return 0xFFFFFFFFFFFF0000;

    @property
    def normalized_version(self) -> "ProtocolVersion":
        return ProtocolVersion(self.version & self.compatible_protocol_version_mask)

    def is_compatible(self, other: "ProtocolVersion") -> bool:
        return (other._version & self.compatible_protocol_version_mask) == (self._version & self.compatible_protocol_version_mask)

    def _cmp_(self, other: "ProtocolVersion"):
        if self.version > other.version:
            return 1
        elif self.version == other.version:
            return 0
        else:
            return -1

    def __gt__(self, other: "ProtocolVersion"):
        return self._cmp_(other) > 0

    def __lt__(self, other: "ProtocolVersion"):
        return self._cmp_(other) < 0

    def __eq__(self, other: "ProtocolVersion"):
        return self._cmp_(other) == 0

    def __ne__(self, other: "ProtocolVersion"):
        return self._cmp_(other) != 0

    def __ge__(self, other: "ProtocolVersion"):
        return self._cmp_(other) >= 0

    def __le__(self, other: "ProtocolVersion"):
        return self._cmp_(other) <= 0

    def is_supported(self) -> bool:
        return self in ProtocolVersion._supported_protocol_versions

    
    @property
    def has_watches(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00A200090000)

    @staticmethod
    def with_watches() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00A200090000)

    
    @property
    def has_movable_coordinated_state(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00A2000D0000)

    @staticmethod
    def with_movable_coordinated_state() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00A2000D0000)

    
    @property
    def has_process_id(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00A340000000)

    @staticmethod
    def with_process_id() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00A340000000)

    
    @property
    def has_open_database(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00A400040000)

    @staticmethod
    def with_open_database() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00A400040000)

    
    @property
    def has_locality(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00A446020000)

    @staticmethod
    def with_locality() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00A446020000)

    
    @property
    def has_multigeneration_tlog(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00A460010000)

    @staticmethod
    def with_multigeneration_tlog() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00A460010000)

    
    @property
    def has_shared_mutations(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00A460010000)

    @staticmethod
    def with_shared_mutations() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00A460010000)

    
    @property
    def has_inexpensive_multiversion_client(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00A551000000)

    @staticmethod
    def with_inexpensive_multiversion_client() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00A551000000)

    
    @property
    def has_tag_locality(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00A560010000)

    @staticmethod
    def with_tag_locality() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00A560010000)

    
    @property
    def has_fearless(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B060000000)

    @staticmethod
    def with_fearless() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B060000000)

    
    @property
    def has_endpoint_addr_list(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B061020000)

    @staticmethod
    def with_endpoint_addr_list() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B061020000)

    
    @property
    def has_IPv6(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B061030000)

    @staticmethod
    def with_IPv6() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B061030000)

    
    @property
    def has_tlog_version(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B061030000)

    @staticmethod
    def with_tlog_version() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B061030000)

    
    @property
    def has_pseudo_localities(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B061070000)

    @staticmethod
    def with_pseudo_localities() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B061070000)

    
    @property
    def has_sharded_txs_tags(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B061070000)

    @staticmethod
    def with_sharded_txs_tags() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B061070000)

    
    @property
    def has_tlog_queue_entry_ref(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_tlog_queue_entry_ref() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_generation_reg_val(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_generation_reg_val() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_movable_coordinated_state_v2(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_movable_coordinated_state_v2() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_key_server_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_key_server_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_logs_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_logs_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_server_tag_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_server_tag_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_tag_locality_list_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_tag_locality_list_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_datacenter_replicas_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_datacenter_replicas_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_process_class_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_process_class_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_worker_list_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_worker_list_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_backup_start_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_backup_start_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_log_range_encode_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_log_range_encode_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_healthy_zone_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_healthy_zone_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_dr_backup_ranges(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_dr_backup_ranges() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_region_configuration(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_region_configuration() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_replication_policy(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_replication_policy() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_backup_mutations(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_backup_mutations() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_cluster_controller_priority_info(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_cluster_controller_priority_info() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_process_id_file(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_process_id_file() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_close_unused_connection(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B062010001)

    @staticmethod
    def with_close_unused_connection() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B062010001)

    
    @property
    def has_db_core_state(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B063010000)

    @staticmethod
    def with_db_core_state() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B063010000)

    
    @property
    def has_tag_throttle_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B063010000)

    @staticmethod
    def with_tag_throttle_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B063010000)

    
    @property
    def has_storage_cache_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B063010000)

    @staticmethod
    def with_storage_cache_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B063010000)

    
    @property
    def has_restore_status_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B063010000)

    @staticmethod
    def with_restore_status_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B063010000)

    
    @property
    def has_restore_request_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B063010000)

    @staticmethod
    def with_restore_request_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B063010000)

    
    @property
    def has_restore_request_done_version_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B063010000)

    @staticmethod
    def with_restore_request_done_version_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B063010000)

    
    @property
    def has_restore_request_trigger_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B063010000)

    @staticmethod
    def with_restore_request_trigger_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B063010000)

    
    @property
    def has_restore_worker_interface_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B063010000)

    @staticmethod
    def with_restore_worker_interface_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B063010000)

    
    @property
    def has_backup_progress_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B063010000)

    @staticmethod
    def with_backup_progress_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B063010000)

    
    @property
    def has_key_server_value_v2(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B063010000)

    @staticmethod
    def with_key_server_value_v2() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B063010000)

    
    @property
    def has_backup_worker(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B063010000)

    @staticmethod
    def with_backup_worker() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B063010000)

    
    @property
    def has_report_conflicting_keys(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B063010000)

    @staticmethod
    def with_report_conflicting_keys() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B063010000)

    
    @property
    def has_small_endpoints(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B063010000)

    @staticmethod
    def with_small_endpoints() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B063010000)

    
    @property
    def has_cache_role(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B063010000)

    @staticmethod
    def with_cache_role() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B063010000)

    
    @property
    def has_unified_tlog_spilling(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B063000000)

    @staticmethod
    def with_unified_tlog_spilling() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B063000000)

    
    @property
    def has_stable_interfaces(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B070010000)

    @staticmethod
    def with_stable_interfaces() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B070010000)

    
    @property
    def has_server_list_value(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B070010001)

    @staticmethod
    def with_server_list_value() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B070010001)

    
    @property
    def has_tag_throttle_value_reason(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B070010001)

    @staticmethod
    def with_tag_throttle_value_reason() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B070010001)

    
    @property
    def has_span_context(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B070010001)

    @staticmethod
    def with_span_context() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B070010001)

    
    @property
    def has_tss(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B070010001)

    @staticmethod
    def with_tss() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B070010001)

    
    @property
    def has_change_feed(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B071010000)

    @staticmethod
    def with_change_feed() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B071010000)

    
    @property
    def has_blob_granule(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B071010000)

    @staticmethod
    def with_blob_granule() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B071010000)

    
    @property
    def has_network_address_hostname_flag(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B071010000)

    @staticmethod
    def with_network_address_hostname_flag() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B071010000)

    
    @property
    def has_storage_metadata(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B071010000)

    @staticmethod
    def with_storage_metadata() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B071010000)

    
    @property
    def has_perpetual_wiggle_metadata(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B071010000)

    @staticmethod
    def with_perpetual_wiggle_metadata() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B071010000)

    
    @property
    def has_storage_interface_readiness(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B071010000)

    @staticmethod
    def with_storage_interface_readiness() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B071010000)

    
    @property
    def has_tenants(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B071010000)

    @staticmethod
    def with_tenants() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B071010000)

    
    @property
    def has_resolver_private_mutations(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B071010000)

    @staticmethod
    def with_resolver_private_mutations() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B071010000)

    
    @property
    def has_otel_span_context(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B072000000)

    @staticmethod
    def with_otel_span_context() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B072000000)

    
    @property
    def has_sw_version_tracking(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B072000000)

    @staticmethod
    def with_sw_version_tracking() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B072000000)

    
    @property
    def has_encryption_at_rest(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B072000000)

    @staticmethod
    def with_encryption_at_rest() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B072000000)

    
    @property
    def has_shard_encode_location_metadata(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B072000000)

    @staticmethod
    def with_shard_encode_location_metadata() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B072000000)

    
    @property
    def has_blob_granule_file(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B072000000)

    @staticmethod
    def with_blob_granule_file() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B072000000)

    
    @property
    def has_fdb_encrypted_snapshot_backup_file(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B072000000)

    @staticmethod
    def with_fdb_encrypted_snapshot_backup_file() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B072000000)

    
    @property
    def has_cluster_id_special_key(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B072000000)

    @staticmethod
    def with_cluster_id_special_key() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B072000000)

    
    @property
    def has_blob_granule_file_logical_size(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B072000000)

    @staticmethod
    def with_blob_granule_file_logical_size() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B072000000)

    
    @property
    def has_blob_range_change_log(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B072000000)

    @staticmethod
    def with_blob_range_change_log() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B072000000)

    
    @property
    def has_gc_txn_generations(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B073000000)

    @staticmethod
    def with_gc_txn_generations() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B073000000)

    
    @property
    def has_mutation_checksum(self) -> bool:
        return self >= ProtocolVersion(0x0FDB00B074000000)

    @staticmethod
    def with_mutation_checksum() -> "ProtocolVersion":
        return ProtocolVersion(0x0FDB00B074000000)



PROTOCOL_VERSION_5_2 = 0x0FDB00A552000001
PROTOCOL_VERSION_6_0 = 0x0FDB00A570010001
PROTOCOL_VERSION_6_1 = 0x0FDB00B061060001
PROTOCOL_VERSION_6_2 = 0x0FDB00B062010001
PROTOCOL_VERSION_6_3 = 0x0FDB00B063010001
PROTOCOL_VERSION_7_0 = 0x0FDB00B070010001
PROTOCOL_VERSION_7_1 = 0x0FDB00B071010000
PROTOCOL_VERSION_7_2 = 0x0FDB00B072000000
PROTOCOL_VERSION_7_3 = 0x0FDB00B073000000
PROTOCOL_VERSION_7_4 = 0x0FDB00B074000000
PROTOCOL_VERSION_8_0 = 0x0FDB00B080000000

def _module_init():
    for raw_version in (
        PROTOCOL_VERSION_5_2,
        PROTOCOL_VERSION_6_0,
        PROTOCOL_VERSION_6_1,
        PROTOCOL_VERSION_6_2,
        PROTOCOL_VERSION_6_3,
        PROTOCOL_VERSION_7_0,
        PROTOCOL_VERSION_7_1,
        PROTOCOL_VERSION_7_2,
        PROTOCOL_VERSION_7_3,
        PROTOCOL_VERSION_7_4,
        PROTOCOL_VERSION_8_0,
    ):
        ProtocolVersion._supported_protocol_versions.add(ProtocolVersion(raw_version))

_module_init()