// Automatically generated by script, do NOT modify by hand

package com.apple.cie.foundationdb.hubble;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;

class ProtocolVersion implements Comparable<ProtocolVersion> {

	public static final ProtocolVersion protocolVersionSixThree =
		new ProtocolVersion(0x0FDB00B063010001L);
	public static final ProtocolVersion protocolVersionSixOne =
		new ProtocolVersion(0x0FDB00B061060001L);
	public static final ProtocolVersion protocolVersionSixTwo =
		new ProtocolVersion(0x0FDB00B062010001L);
	public static final ProtocolVersion protocolVersionSixZero =
		new ProtocolVersion(0x0FDB00A570010001L);
	public static final ProtocolVersion protocolVersionSevenZero =
		new ProtocolVersion(0x0FDB00B070010000L);
	public static final ProtocolVersion protocolVersionSevenOne =
		new ProtocolVersion(0x0FDB00B071010000L);
	public static final ProtocolVersion protocolVersionSevenThree =
		new ProtocolVersion(0x0FDB00B073000000L);
	public static final ProtocolVersion protocolVersionSevenFour =
		new ProtocolVersion(0x0FDB00B074000000L);
	public static final ProtocolVersion protocolVersionEightZero =
		new ProtocolVersion(0x0FDB00B080000000L);

	public static final List<ProtocolVersion> supportedVersions = Arrays.asList(
			protocolVersionSixThree,
			protocolVersionSixTwo,
			protocolVersionSixOne,
			protocolVersionSixZero,
			protocolVersionSevenZero,
			protocolVersionSevenOne,
			protocolVersionSevenThree,
			protocolVersionSevenFour,
			protocolVersionEightZero,
	);

	private static final long compatibleProtocolVersionMask = 0xFFFFFFFFFFFF0000L;
	private final long protocolVersion;

	public ProtocolVersion(long version) {
		protocolVersion = version;
	}

	public ProtocolVersion(Long version) {
        protocolVersion = version.longValue();
	}

	public static ProtocolVersion deserialize(ByteBuffer byteBuffer) {
		assert byteBuffer.order() == ByteOrder.LITTLE_ENDIAN;
		final long version = byteBuffer.getLong();
		ProtocolVersion protocolVersion = new ProtocolVersion(version);
		return protocolVersion;
	}

	@Override
	public boolean equals(Object ob) {
		if (!(ob instanceof ProtocolVersion)) {
			return false;
		}
		return compareTo((ProtocolVersion) ob) == 0;
	}

	public boolean isSupported() {
		return supportedVersions.contains(this);
	}

	public ProtocolVersion normalizedVersion() {
		return new ProtocolVersion(
			this.protocolVersion & ProtocolVersion.compatibleProtocolVersionMask);
	}

	public boolean isCompatible(ProtocolVersion other) {
		return this.normalizedVersion().equals(other.normalizedVersion());
	}

	@Override
	public String toString() {
		return String.valueOf(protocolVersion);
	}

	public long getProtocolVersion() {
		return protocolVersion;
	}

	@Override
	public int compareTo(ProtocolVersion o) {
		if (protocolVersion < o.protocolVersion) {
			return -1;
		} else if (protocolVersion > o.protocolVersion) {
			return +1;
		} else {
			return 0;
		}
	}



	public boolean hasWatches() {
		return protocolVersion >= 0x0FDB00A200090000L;
	}

	public static ProtocolVersion withWatches() {
		return new ProtocolVersion(0x0FDB00A200090000L);
	}


	public boolean hasMovableCoordinatedState() {
		return protocolVersion >= 0x0FDB00A2000D0000L;
	}

	public static ProtocolVersion withMovableCoordinatedState() {
		return new ProtocolVersion(0x0FDB00A2000D0000L);
	}


	public boolean hasProcessId() {
		return protocolVersion >= 0x0FDB00A340000000L;
	}

	public static ProtocolVersion withProcessId() {
		return new ProtocolVersion(0x0FDB00A340000000L);
	}


	public boolean hasOpenDatabase() {
		return protocolVersion >= 0x0FDB00A400040000L;
	}

	public static ProtocolVersion withOpenDatabase() {
		return new ProtocolVersion(0x0FDB00A400040000L);
	}


	public boolean hasLocality() {
		return protocolVersion >= 0x0FDB00A446020000L;
	}

	public static ProtocolVersion withLocality() {
		return new ProtocolVersion(0x0FDB00A446020000L);
	}


	public boolean hasMultigenerationTlog() {
		return protocolVersion >= 0x0FDB00A460010000L;
	}

	public static ProtocolVersion withMultigenerationTlog() {
		return new ProtocolVersion(0x0FDB00A460010000L);
	}


	public boolean hasSharedMutations() {
		return protocolVersion >= 0x0FDB00A460010000L;
	}

	public static ProtocolVersion withSharedMutations() {
		return new ProtocolVersion(0x0FDB00A460010000L);
	}


	public boolean hasInexpensiveMultiversionClient() {
		return protocolVersion >= 0x0FDB00A551000000L;
	}

	public static ProtocolVersion withInexpensiveMultiversionClient() {
		return new ProtocolVersion(0x0FDB00A551000000L);
	}


	public boolean hasTagLocality() {
		return protocolVersion >= 0x0FDB00A560010000L;
	}

	public static ProtocolVersion withTagLocality() {
		return new ProtocolVersion(0x0FDB00A560010000L);
	}


	public boolean hasFearless() {
		return protocolVersion >= 0x0FDB00B060000000L;
	}

	public static ProtocolVersion withFearless() {
		return new ProtocolVersion(0x0FDB00B060000000L);
	}


	public boolean hasEndpointAddrList() {
		return protocolVersion >= 0x0FDB00B061020000L;
	}

	public static ProtocolVersion withEndpointAddrList() {
		return new ProtocolVersion(0x0FDB00B061020000L);
	}


	public boolean hasIpv6() {
		return protocolVersion >= 0x0FDB00B061030000L;
	}

	public static ProtocolVersion withIpv6() {
		return new ProtocolVersion(0x0FDB00B061030000L);
	}


	public boolean hasTlogVersion() {
		return protocolVersion >= 0x0FDB00B061030000L;
	}

	public static ProtocolVersion withTlogVersion() {
		return new ProtocolVersion(0x0FDB00B061030000L);
	}


	public boolean hasPseudoLocalities() {
		return protocolVersion >= 0x0FDB00B061070000L;
	}

	public static ProtocolVersion withPseudoLocalities() {
		return new ProtocolVersion(0x0FDB00B061070000L);
	}


	public boolean hasShardedTxsTags() {
		return protocolVersion >= 0x0FDB00B061070000L;
	}

	public static ProtocolVersion withShardedTxsTags() {
		return new ProtocolVersion(0x0FDB00B061070000L);
	}


	public boolean hasTlogQueueEntryRef() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withTlogQueueEntryRef() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasGenerationRegVal() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withGenerationRegVal() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasMovableCoordinatedStateV2() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withMovableCoordinatedStateV2() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasKeyServerValue() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withKeyServerValue() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasLogsValue() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withLogsValue() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasServerTagValue() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withServerTagValue() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasTagLocalityListValue() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withTagLocalityListValue() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasDatacenterReplicasValue() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withDatacenterReplicasValue() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasProcessClassValue() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withProcessClassValue() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasWorkerListValue() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withWorkerListValue() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasBackupStartValue() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withBackupStartValue() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasLogRangeEncodeValue() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withLogRangeEncodeValue() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasHealthyZoneValue() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withHealthyZoneValue() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasDrBackupRanges() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withDrBackupRanges() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasRegionConfiguration() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withRegionConfiguration() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasReplicationPolicy() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withReplicationPolicy() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasBackupMutations() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withBackupMutations() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasClusterControllerPriorityInfo() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withClusterControllerPriorityInfo() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasProcessIdFile() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withProcessIdFile() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasCloseUnusedConnection() {
		return protocolVersion >= 0x0FDB00B062010001L;
	}

	public static ProtocolVersion withCloseUnusedConnection() {
		return new ProtocolVersion(0x0FDB00B062010001L);
	}


	public boolean hasDbCoreState() {
		return protocolVersion >= 0x0FDB00B063010000L;
	}

	public static ProtocolVersion withDbCoreState() {
		return new ProtocolVersion(0x0FDB00B063010000L);
	}


	public boolean hasTagThrottleValue() {
		return protocolVersion >= 0x0FDB00B063010000L;
	}

	public static ProtocolVersion withTagThrottleValue() {
		return new ProtocolVersion(0x0FDB00B063010000L);
	}


	public boolean hasStorageCacheValue() {
		return protocolVersion >= 0x0FDB00B063010000L;
	}

	public static ProtocolVersion withStorageCacheValue() {
		return new ProtocolVersion(0x0FDB00B063010000L);
	}


	public boolean hasRestoreStatusValue() {
		return protocolVersion >= 0x0FDB00B063010000L;
	}

	public static ProtocolVersion withRestoreStatusValue() {
		return new ProtocolVersion(0x0FDB00B063010000L);
	}


	public boolean hasRestoreRequestValue() {
		return protocolVersion >= 0x0FDB00B063010000L;
	}

	public static ProtocolVersion withRestoreRequestValue() {
		return new ProtocolVersion(0x0FDB00B063010000L);
	}


	public boolean hasRestoreRequestDoneVersionValue() {
		return protocolVersion >= 0x0FDB00B063010000L;
	}

	public static ProtocolVersion withRestoreRequestDoneVersionValue() {
		return new ProtocolVersion(0x0FDB00B063010000L);
	}


	public boolean hasRestoreRequestTriggerValue() {
		return protocolVersion >= 0x0FDB00B063010000L;
	}

	public static ProtocolVersion withRestoreRequestTriggerValue() {
		return new ProtocolVersion(0x0FDB00B063010000L);
	}


	public boolean hasRestoreWorkerInterfaceValue() {
		return protocolVersion >= 0x0FDB00B063010000L;
	}

	public static ProtocolVersion withRestoreWorkerInterfaceValue() {
		return new ProtocolVersion(0x0FDB00B063010000L);
	}


	public boolean hasBackupProgressValue() {
		return protocolVersion >= 0x0FDB00B063010000L;
	}

	public static ProtocolVersion withBackupProgressValue() {
		return new ProtocolVersion(0x0FDB00B063010000L);
	}


	public boolean hasKeyServerValueV2() {
		return protocolVersion >= 0x0FDB00B063010000L;
	}

	public static ProtocolVersion withKeyServerValueV2() {
		return new ProtocolVersion(0x0FDB00B063010000L);
	}


	public boolean hasBackupWorker() {
		return protocolVersion >= 0x0FDB00B063010000L;
	}

	public static ProtocolVersion withBackupWorker() {
		return new ProtocolVersion(0x0FDB00B063010000L);
	}


	public boolean hasReportConflictingKeys() {
		return protocolVersion >= 0x0FDB00B063010000L;
	}

	public static ProtocolVersion withReportConflictingKeys() {
		return new ProtocolVersion(0x0FDB00B063010000L);
	}


	public boolean hasSmallEndpoints() {
		return protocolVersion >= 0x0FDB00B063010000L;
	}

	public static ProtocolVersion withSmallEndpoints() {
		return new ProtocolVersion(0x0FDB00B063010000L);
	}


	public boolean hasCacheRole() {
		return protocolVersion >= 0x0FDB00B063010000L;
	}

	public static ProtocolVersion withCacheRole() {
		return new ProtocolVersion(0x0FDB00B063010000L);
	}


	public boolean hasUnifiedTlogSpilling() {
		return protocolVersion >= 0x0FDB00B063000000L;
	}

	public static ProtocolVersion withUnifiedTlogSpilling() {
		return new ProtocolVersion(0x0FDB00B063000000L);
	}


	public boolean hasStableInterfaces() {
		return protocolVersion >= 0x0FDB00B070010000L;
	}

	public static ProtocolVersion withStableInterfaces() {
		return new ProtocolVersion(0x0FDB00B070010000L);
	}


	public boolean hasServerListValue() {
		return protocolVersion >= 0x0FDB00B070010001L;
	}

	public static ProtocolVersion withServerListValue() {
		return new ProtocolVersion(0x0FDB00B070010001L);
	}


	public boolean hasTagThrottleValueReason() {
		return protocolVersion >= 0x0FDB00B070010001L;
	}

	public static ProtocolVersion withTagThrottleValueReason() {
		return new ProtocolVersion(0x0FDB00B070010001L);
	}


	public boolean hasSpanContext() {
		return protocolVersion >= 0x0FDB00B070010001L;
	}

	public static ProtocolVersion withSpanContext() {
		return new ProtocolVersion(0x0FDB00B070010001L);
	}


	public boolean hasTss() {
		return protocolVersion >= 0x0FDB00B070010001L;
	}

	public static ProtocolVersion withTss() {
		return new ProtocolVersion(0x0FDB00B070010001L);
	}


	public boolean hasChangeFeed() {
		return protocolVersion >= 0x0FDB00B071010000L;
	}

	public static ProtocolVersion withChangeFeed() {
		return new ProtocolVersion(0x0FDB00B071010000L);
	}


	public boolean hasBlobGranule() {
		return protocolVersion >= 0x0FDB00B071010000L;
	}

	public static ProtocolVersion withBlobGranule() {
		return new ProtocolVersion(0x0FDB00B071010000L);
	}


	public boolean hasNetworkAddressHostnameFlag() {
		return protocolVersion >= 0x0FDB00B071010000L;
	}

	public static ProtocolVersion withNetworkAddressHostnameFlag() {
		return new ProtocolVersion(0x0FDB00B071010000L);
	}


	public boolean hasStorageMetadata() {
		return protocolVersion >= 0x0FDB00B071010000L;
	}

	public static ProtocolVersion withStorageMetadata() {
		return new ProtocolVersion(0x0FDB00B071010000L);
	}


	public boolean hasPerpetualWiggleMetadata() {
		return protocolVersion >= 0x0FDB00B071010000L;
	}

	public static ProtocolVersion withPerpetualWiggleMetadata() {
		return new ProtocolVersion(0x0FDB00B071010000L);
	}


	public boolean hasStorageInterfaceReadiness() {
		return protocolVersion >= 0x0FDB00B071010000L;
	}

	public static ProtocolVersion withStorageInterfaceReadiness() {
		return new ProtocolVersion(0x0FDB00B071010000L);
	}


	public boolean hasTenants() {
		return protocolVersion >= 0x0FDB00B071010000L;
	}

	public static ProtocolVersion withTenants() {
		return new ProtocolVersion(0x0FDB00B071010000L);
	}


	public boolean hasResolverPrivateMutations() {
		return protocolVersion >= 0x0FDB00B071010000L;
	}

	public static ProtocolVersion withResolverPrivateMutations() {
		return new ProtocolVersion(0x0FDB00B071010000L);
	}


	public boolean hasOtelSpanContext() {
		return protocolVersion >= 0x0FDB00B072000000L;
	}

	public static ProtocolVersion withOtelSpanContext() {
		return new ProtocolVersion(0x0FDB00B072000000L);
	}


	public boolean hasSwVersionTracking() {
		return protocolVersion >= 0x0FDB00B072000000L;
	}

	public static ProtocolVersion withSwVersionTracking() {
		return new ProtocolVersion(0x0FDB00B072000000L);
	}


	public boolean hasEncryptionAtRest() {
		return protocolVersion >= 0x0FDB00B072000000L;
	}

	public static ProtocolVersion withEncryptionAtRest() {
		return new ProtocolVersion(0x0FDB00B072000000L);
	}


	public boolean hasShardEncodeLocationMetadata() {
		return protocolVersion >= 0x0FDB00B072000000L;
	}

	public static ProtocolVersion withShardEncodeLocationMetadata() {
		return new ProtocolVersion(0x0FDB00B072000000L);
	}


	public boolean hasBlobGranuleFile() {
		return protocolVersion >= 0x0FDB00B072000000L;
	}

	public static ProtocolVersion withBlobGranuleFile() {
		return new ProtocolVersion(0x0FDB00B072000000L);
	}


	public boolean hasFdbEncryptedSnapshotBackupFile() {
		return protocolVersion >= 0x0FDB00B072000000L;
	}

	public static ProtocolVersion withFdbEncryptedSnapshotBackupFile() {
		return new ProtocolVersion(0x0FDB00B072000000L);
	}


	public boolean hasClusterIdSpecialKey() {
		return protocolVersion >= 0x0FDB00B072000000L;
	}

	public static ProtocolVersion withClusterIdSpecialKey() {
		return new ProtocolVersion(0x0FDB00B072000000L);
	}


	public boolean hasBlobGranuleFileLogicalSize() {
		return protocolVersion >= 0x0FDB00B072000000L;
	}

	public static ProtocolVersion withBlobGranuleFileLogicalSize() {
		return new ProtocolVersion(0x0FDB00B072000000L);
	}


	public boolean hasBlobRangeChangeLog() {
		return protocolVersion >= 0x0FDB00B072000000L;
	}

	public static ProtocolVersion withBlobRangeChangeLog() {
		return new ProtocolVersion(0x0FDB00B072000000L);
	}


	public boolean hasGcTxnGenerations() {
		return protocolVersion >= 0x0FDB00B073000000L;
	}

	public static ProtocolVersion withGcTxnGenerations() {
		return new ProtocolVersion(0x0FDB00B073000000L);
	}


	public boolean hasMutationChecksum() {
		return protocolVersion >= 0x0FDB00B074000000L;
	}

	public static ProtocolVersion withMutationChecksum() {
		return new ProtocolVersion(0x0FDB00B074000000L);
	}

}