#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
/*
 * RangeLock.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/AuditUtils.actor.h"
#include "fdbclient/RangeLock.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct RangeLocking : TestWorkload {
	static constexpr auto NAME = "RangeLocking";
	const bool enabled;
	bool pass;
	bool shouldExit = false;
	bool verboseLogging = false; // enable to log range lock and commit history
	std::string rangeLockOwnerName = "RangeLockingTest";

	// This workload is not compatible with RandomRangeLock workload because they will race in locked range
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomRangeLock" });
	}

	struct KVOperation {
		std::variant<KeyRange, KeyValue> params;

		KVOperation(KeyRange range) : params(range) {}
		KVOperation(KeyValue keyValue) : params(keyValue) {}

		std::string toString() const {
			std::string res = "KVOperation: ";
			if (std::holds_alternative<KeyRange>(params)) {
				res = res + "[ClearRange]: " + std::get<KeyRange>(params).toString();
			} else {
				res = res + "[SetKeyValue]: key: " + std::get<KeyValue>(params).key.toString() +
				      ", value: " + std::get<KeyValue>(params).value.toString();
			}
			return res;
		}
	};

	struct LockRangeOperation {
		KeyRange range;
		bool lock;
		LockRangeOperation(KeyRange range, bool lock) : range(range), lock(lock) {}

		std::string toString() const {
			std::string res = "LockRangeOperation: ";
			if (lock) {
				res = res + "[LockRange]: " + range.toString();
			} else {
				res = res + "[UnlockRange]: " + range.toString();
			}
			return res;
		}
	};

	KeyRangeMap<bool> lockedRangeMap;
	std::vector<LockRangeOperation> lockRangeOperations;
	std::vector<KVOperation> kvOperations;
	std::map<Key, Value> kvs;

	RangeLocking(WorkloadContext const& wcx) : TestWorkload(wcx), enabled(true), pass(true) {
		lockedRangeMap.insert(allKeys, false);
	}

	Future<Void> setup(Database const& cx) override {
		return registerRangeLockOwner(cx, rangeLockOwnerName, rangeLockOwnerName);
	}

	Future<Void> start(Database const& cx) override { return _start(this, cx); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 98 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
// This generated class is to be used only via setKey()
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
template <class SetKeyActor>
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class SetKeyActorState {
															#line 104 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	SetKeyActorState(Database const& cx,Key const& key,Value const& value) 
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		 : cx(cx),
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   key(key),
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   value(value),
															#line 97 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   tr(cx)
															#line 117 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
	{
		fdb_probe_actor_create("setKey", reinterpret_cast<unsigned long>(this));

	}
	~SetKeyActorState() 
	{
		fdb_probe_actor_destroy("setKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 98 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			;
															#line 132 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetKeyActorState();
		static_cast<SetKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 100 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			tr.set(key, value);
															#line 101 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 101 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (static_cast<SetKeyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 167 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetKeyActor*>(this)->actor_wait_state = 1;
															#line 101 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetKeyActor, 0, Void >*>(static_cast<SetKeyActor*>(this)));
															#line 172 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 104 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 104 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (static_cast<SetKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 196 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SetKeyActor*>(this)->actor_wait_state = 2;
															#line 104 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetKeyActor, 1, Void >*>(static_cast<SetKeyActor*>(this)));
															#line 201 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<SetKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetKeyActorState(); static_cast<SetKeyActor*>(this)->destroy(); return 0; }
															#line 216 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<SetKeyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetKeyActorState();
		static_cast<SetKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<SetKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetKeyActorState(); static_cast<SetKeyActor*>(this)->destroy(); return 0; }
															#line 228 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<SetKeyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetKeyActorState();
		static_cast<SetKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetKeyActor*>(this)->actor_wait_state > 0) static_cast<SetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<SetKeyActor*>(this)->ActorCallback< SetKeyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetKeyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetKeyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetKeyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetKeyActor*>(this)->actor_wait_state > 0) static_cast<SetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<SetKeyActor*>(this)->ActorCallback< SetKeyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetKeyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetKeyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetKeyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKey", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Database cx;
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Key key;
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Value value;
															#line 97 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Transaction tr;
															#line 406 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
};
// This generated class is to be used only via setKey()
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class SetKeyActor final : public Actor<Void>, public ActorCallback< SetKeyActor, 0, Void >, public ActorCallback< SetKeyActor, 1, Void >, public FastAllocated<SetKeyActor>, public SetKeyActorState<SetKeyActor> {
															#line 411 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
	using FastAllocated<SetKeyActor>::operator new;
	using FastAllocated<SetKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14637237657162089728UL, 1717093245139189504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetKeyActor, 0, Void >;
friend struct ActorCallback< SetKeyActor, 1, Void >;
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	SetKeyActor(Database const& cx,Key const& key,Value const& value) 
															#line 429 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		 : Actor<Void>(),
		   SetKeyActorState<SetKeyActor>(cx, key, value),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15678283076829160704UL, 16036865228701634048UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetKeyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetKeyActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
[[nodiscard]] Future<Void> setKey( Database const& cx, Key const& key, Value const& value ) {
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	return Future<Void>(new SetKeyActor(cx, key, value));
															#line 462 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
}

#line 108 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"

																#line 467 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
// This generated class is to be used only via clearKey()
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
template <class ClearKeyActor>
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class ClearKeyActorState {
															#line 473 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	ClearKeyActorState(Database const& cx,Key const& key) 
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		 : cx(cx),
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   key(key),
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   tr(cx)
															#line 484 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
	{
		fdb_probe_actor_create("clearKey", reinterpret_cast<unsigned long>(this));

	}
	~ClearKeyActorState() 
	{
		fdb_probe_actor_destroy("clearKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 111 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			;
															#line 499 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearKeyActorState();
		static_cast<ClearKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 113 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			tr.clear(key);
															#line 114 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 114 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (static_cast<ClearKeyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 534 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearKeyActor*>(this)->actor_wait_state = 1;
															#line 114 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearKeyActor, 0, Void >*>(static_cast<ClearKeyActor*>(this)));
															#line 539 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 117 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 117 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (static_cast<ClearKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 563 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClearKeyActor*>(this)->actor_wait_state = 2;
															#line 117 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearKeyActor, 1, Void >*>(static_cast<ClearKeyActor*>(this)));
															#line 568 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 115 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<ClearKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearKeyActorState(); static_cast<ClearKeyActor*>(this)->destroy(); return 0; }
															#line 583 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<ClearKeyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearKeyActorState();
		static_cast<ClearKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 115 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<ClearKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearKeyActorState(); static_cast<ClearKeyActor*>(this)->destroy(); return 0; }
															#line 595 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<ClearKeyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearKeyActorState();
		static_cast<ClearKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearKeyActor*>(this)->actor_wait_state > 0) static_cast<ClearKeyActor*>(this)->actor_wait_state = 0;
		static_cast<ClearKeyActor*>(this)->ActorCallback< ClearKeyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearKeyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearKeyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearKeyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearKeyActor*>(this)->actor_wait_state > 0) static_cast<ClearKeyActor*>(this)->actor_wait_state = 0;
		static_cast<ClearKeyActor*>(this)->ActorCallback< ClearKeyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearKeyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearKeyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearKeyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearKey", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Database cx;
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Key key;
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Transaction tr;
															#line 771 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
};
// This generated class is to be used only via clearKey()
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class ClearKeyActor final : public Actor<Void>, public ActorCallback< ClearKeyActor, 0, Void >, public ActorCallback< ClearKeyActor, 1, Void >, public FastAllocated<ClearKeyActor>, public ClearKeyActorState<ClearKeyActor> {
															#line 776 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
	using FastAllocated<ClearKeyActor>::operator new;
	using FastAllocated<ClearKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6236289553483349504UL, 1074941223463796480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearKeyActor, 0, Void >;
friend struct ActorCallback< ClearKeyActor, 1, Void >;
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	ClearKeyActor(Database const& cx,Key const& key) 
															#line 794 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		 : Actor<Void>(),
		   ClearKeyActorState<ClearKeyActor>(cx, key),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10880600829552571904UL, 3946498479198721792UL);
		ActorExecutionContextHelper __helper(static_cast<ClearKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearKeyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearKeyActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
[[nodiscard]] Future<Void> clearKey( Database const& cx, Key const& key ) {
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	return Future<Void>(new ClearKeyActor(cx, key));
															#line 827 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
}

#line 121 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"

																#line 832 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
// This generated class is to be used only via clearRange()
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
template <class ClearRangeActor>
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class ClearRangeActorState {
															#line 838 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	ClearRangeActorState(Database const& cx,KeyRange const& range) 
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		 : cx(cx),
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   range(range),
															#line 123 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   tr(cx)
															#line 849 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
	{
		fdb_probe_actor_create("clearRange", reinterpret_cast<unsigned long>(this));

	}
	~ClearRangeActorState() 
	{
		fdb_probe_actor_destroy("clearRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 124 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			;
															#line 864 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearRangeActorState();
		static_cast<ClearRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 126 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			tr.clear(range);
															#line 127 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 127 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (static_cast<ClearRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 899 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearRangeActor*>(this)->actor_wait_state = 1;
															#line 127 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearRangeActor, 0, Void >*>(static_cast<ClearRangeActor*>(this)));
															#line 904 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 130 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 130 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (static_cast<ClearRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 928 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClearRangeActor*>(this)->actor_wait_state = 2;
															#line 130 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearRangeActor, 1, Void >*>(static_cast<ClearRangeActor*>(this)));
															#line 933 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<ClearRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearRangeActorState(); static_cast<ClearRangeActor*>(this)->destroy(); return 0; }
															#line 948 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<ClearRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearRangeActorState();
		static_cast<ClearRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<ClearRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearRangeActorState(); static_cast<ClearRangeActor*>(this)->destroy(); return 0; }
															#line 960 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<ClearRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearRangeActorState();
		static_cast<ClearRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearRangeActor*>(this)->actor_wait_state > 0) static_cast<ClearRangeActor*>(this)->actor_wait_state = 0;
		static_cast<ClearRangeActor*>(this)->ActorCallback< ClearRangeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearRangeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearRangeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearRangeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearRangeActor*>(this)->actor_wait_state > 0) static_cast<ClearRangeActor*>(this)->actor_wait_state = 0;
		static_cast<ClearRangeActor*>(this)->ActorCallback< ClearRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Database cx;
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	KeyRange range;
															#line 123 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Transaction tr;
															#line 1136 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
};
// This generated class is to be used only via clearRange()
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class ClearRangeActor final : public Actor<Void>, public ActorCallback< ClearRangeActor, 0, Void >, public ActorCallback< ClearRangeActor, 1, Void >, public FastAllocated<ClearRangeActor>, public ClearRangeActorState<ClearRangeActor> {
															#line 1141 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
	using FastAllocated<ClearRangeActor>::operator new;
	using FastAllocated<ClearRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10938580722960933632UL, 7786002383682637568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearRangeActor, 0, Void >;
friend struct ActorCallback< ClearRangeActor, 1, Void >;
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	ClearRangeActor(Database const& cx,KeyRange const& range) 
															#line 1159 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		 : Actor<Void>(),
		   ClearRangeActorState<ClearRangeActor>(cx, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15878934994591173888UL, 15476352632497857792UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearRangeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearRangeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
[[nodiscard]] Future<Void> clearRange( Database const& cx, KeyRange const& range ) {
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	return Future<Void>(new ClearRangeActor(cx, range));
															#line 1192 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
}

#line 134 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"

																#line 1197 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
// This generated class is to be used only via getKey()
															#line 135 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
template <class GetKeyActor>
															#line 135 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class GetKeyActorState {
															#line 1203 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
															#line 135 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	GetKeyActorState(Database const& cx,Key const& key) 
															#line 135 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
															#line 135 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		 : cx(cx),
															#line 135 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   key(key),
															#line 136 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   tr(cx)
															#line 1214 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
	{
		fdb_probe_actor_create("getKey", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyActorState() 
	{
		fdb_probe_actor_destroy("getKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 137 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			;
															#line 1229 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyActorState();
		static_cast<GetKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 139 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(key);
															#line 139 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (static_cast<GetKeyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1262 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKeyActor*>(this)->actor_wait_state = 1;
															#line 139 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 0, Optional<Value> >*>(static_cast<GetKeyActor*>(this)));
															#line 1267 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 142 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 142 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (static_cast<GetKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1291 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetKeyActor*>(this)->actor_wait_state = 2;
															#line 142 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 1, Void >*>(static_cast<GetKeyActor*>(this)));
															#line 1296 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& value,int loopDepth) 
	{
															#line 140 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<GetKeyActor*>(this)->SAV<Optional<Value>>::futures) { (void)(value); this->~GetKeyActorState(); static_cast<GetKeyActor*>(this)->destroy(); return 0; }
															#line 1311 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<GetKeyActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(value);
		this->~GetKeyActorState();
		static_cast<GetKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && value,int loopDepth) 
	{
															#line 140 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<GetKeyActor*>(this)->SAV<Optional<Value>>::futures) { (void)(value); this->~GetKeyActorState(); static_cast<GetKeyActor*>(this)->destroy(); return 0; }
															#line 1323 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<GetKeyActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(value);
		this->~GetKeyActorState();
		static_cast<GetKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyActor*>(this)->actor_wait_state > 0) static_cast<GetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyActor*>(this)->actor_wait_state > 0) static_cast<GetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 135 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Database cx;
															#line 135 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Key key;
															#line 136 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Transaction tr;
															#line 1499 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
};
// This generated class is to be used only via getKey()
															#line 135 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class GetKeyActor final : public Actor<Optional<Value>>, public ActorCallback< GetKeyActor, 0, Optional<Value> >, public ActorCallback< GetKeyActor, 1, Void >, public FastAllocated<GetKeyActor>, public GetKeyActorState<GetKeyActor> {
															#line 1504 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
	using FastAllocated<GetKeyActor>::operator new;
	using FastAllocated<GetKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18214412769939245056UL, 10941119515507186944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyActor, 0, Optional<Value> >;
friend struct ActorCallback< GetKeyActor, 1, Void >;
															#line 135 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	GetKeyActor(Database const& cx,Key const& key) 
															#line 1522 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		 : Actor<Optional<Value>>(),
		   GetKeyActorState<GetKeyActor>(cx, key),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3161838746568296704UL, 16159820804706226432UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 135 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
[[nodiscard]] Future<Optional<Value>> getKey( Database const& cx, Key const& key ) {
															#line 135 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	return Future<Optional<Value>>(new GetKeyActor(cx, key));
															#line 1555 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
}

#line 146 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"

	std::string getLockRangesString(const std::vector<std::pair<KeyRange, RangeLockState>>& locks) {
		std::string res = "";
		int count = 0;
		for (const auto& lock : locks) {
			res = res + lock.first.toString();
			if (count < locks.size()) {
				res = res + ", ";
			}
			count = count + 1;
		}
		return res;
	}

	KeyValue getRandomKeyValue() const {
		Key key = StringRef(std::to_string(deterministicRandom()->randomInt(0, 10)));
		Value value = key;
		return Standalone(KeyValueRef(key, value));
	}

	KeyRange getRandomRange() const {
		int startPoint = deterministicRandom()->randomInt(0, 9);
		Key beginKey = StringRef(std::to_string(startPoint));
		Key endKey = StringRef(std::to_string(deterministicRandom()->randomInt(startPoint + 1, 10)));
		return Standalone(KeyRangeRef(beginKey, endKey));
	}

																#line 1586 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
// This generated class is to be used only via updateDBWithRandomOperations()
															#line 173 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
template <class UpdateDBWithRandomOperationsActor>
															#line 173 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class UpdateDBWithRandomOperationsActorState {
															#line 1592 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
															#line 173 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	UpdateDBWithRandomOperationsActorState(RangeLocking* const& self,Database const& cx) 
															#line 173 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
															#line 173 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		 : self(self),
															#line 173 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   cx(cx)
															#line 1601 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
	{
		fdb_probe_actor_create("updateDBWithRandomOperations", reinterpret_cast<unsigned long>(this));

	}
	~UpdateDBWithRandomOperationsActorState() 
	{
		fdb_probe_actor_destroy("updateDBWithRandomOperations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 174 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			self->kvOperations.clear();
															#line 175 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			iterationCount = deterministicRandom()->randomInt(1, 10);
															#line 176 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			i = 0;
															#line 177 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			;
															#line 1622 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateDBWithRandomOperationsActorState();
		static_cast<UpdateDBWithRandomOperationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 216 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<UpdateDBWithRandomOperationsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateDBWithRandomOperationsActorState(); static_cast<UpdateDBWithRandomOperationsActor*>(this)->destroy(); return 0; }
															#line 1645 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<UpdateDBWithRandomOperationsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateDBWithRandomOperationsActorState();
		static_cast<UpdateDBWithRandomOperationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 177 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!(i < iterationCount))
															#line 1664 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 178 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		acceptedByDB = true;
															#line 179 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 1672 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
															#line 180 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			kv = self->getRandomKeyValue();
															#line 1676 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			try {
															#line 182 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->setKey(cx, kv.key, kv.value);
															#line 182 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (static_cast<UpdateDBWithRandomOperationsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1682 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UpdateDBWithRandomOperationsActor*>(this)->actor_wait_state = 1;
															#line 182 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateDBWithRandomOperationsActor, 0, Void >*>(static_cast<UpdateDBWithRandomOperationsActor*>(this)));
															#line 1687 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
															#line 198 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			range = self->getRandomRange();
															#line 1700 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			try {
															#line 200 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				StrictFuture<Void> __when_expr_1 = self->clearRange(cx, range);
															#line 200 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (static_cast<UpdateDBWithRandomOperationsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch2(actor_cancelled(), loopDepth);
															#line 1706 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<UpdateDBWithRandomOperationsActor*>(this)->actor_wait_state = 2;
															#line 200 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateDBWithRandomOperationsActor, 1, Void >*>(static_cast<UpdateDBWithRandomOperationsActor*>(this)));
															#line 1711 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1Catch2(unknown_error(), loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 177 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		i++;
															#line 1740 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 189 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		self->kvOperations.push_back(KVOperation(kv));
															#line 190 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (self->verboseLogging)
															#line 1751 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
															#line 191 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent("RangeLockWorkLoadHistory") .detail("Ops", "SetKey") .detail("Key", kv.key) .detail("Value", kv.value) .detail("Accepted", acceptedByDB);
															#line 1755 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 184 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (e.code() != error_code_transaction_rejected_range_locked)
															#line 1766 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			{
															#line 185 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1770 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			}
															#line 187 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			acceptedByDB = false;
															#line 1774 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateDBWithRandomOperationsActor*>(this)->actor_wait_state > 0) static_cast<UpdateDBWithRandomOperationsActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDBWithRandomOperationsActor*>(this)->ActorCallback< UpdateDBWithRandomOperationsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDBWithRandomOperationsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDBWithRandomOperations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDBWithRandomOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDBWithRandomOperations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateDBWithRandomOperationsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDBWithRandomOperations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDBWithRandomOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDBWithRandomOperations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateDBWithRandomOperationsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDBWithRandomOperations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDBWithRandomOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDBWithRandomOperations", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
															#line 207 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		self->kvOperations.push_back(KVOperation(range));
															#line 208 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (self->verboseLogging)
															#line 1891 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
															#line 209 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent("RangeLockWorkLoadHistory") .detail("Ops", "ClearRange") .detail("Range", range) .detail("Accepted", acceptedByDB);
															#line 1895 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 202 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (e.code() != error_code_transaction_rejected_range_locked)
															#line 1906 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			{
															#line 203 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1910 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			}
															#line 205 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			acceptedByDB = false;
															#line 1914 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = a_body1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateDBWithRandomOperationsActor*>(this)->actor_wait_state > 0) static_cast<UpdateDBWithRandomOperationsActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDBWithRandomOperationsActor*>(this)->ActorCallback< UpdateDBWithRandomOperationsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDBWithRandomOperationsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDBWithRandomOperations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDBWithRandomOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDBWithRandomOperations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateDBWithRandomOperationsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDBWithRandomOperations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDBWithRandomOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDBWithRandomOperations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateDBWithRandomOperationsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDBWithRandomOperations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDBWithRandomOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDBWithRandomOperations", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 173 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	RangeLocking* self;
															#line 173 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Database cx;
															#line 175 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	int iterationCount;
															#line 176 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	int i;
															#line 178 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	bool acceptedByDB;
															#line 180 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	KeyValue kv;
															#line 198 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	KeyRange range;
															#line 2039 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
};
// This generated class is to be used only via updateDBWithRandomOperations()
															#line 173 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class UpdateDBWithRandomOperationsActor final : public Actor<Void>, public ActorCallback< UpdateDBWithRandomOperationsActor, 0, Void >, public ActorCallback< UpdateDBWithRandomOperationsActor, 1, Void >, public FastAllocated<UpdateDBWithRandomOperationsActor>, public UpdateDBWithRandomOperationsActorState<UpdateDBWithRandomOperationsActor> {
															#line 2044 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
	using FastAllocated<UpdateDBWithRandomOperationsActor>::operator new;
	using FastAllocated<UpdateDBWithRandomOperationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11644936664472218624UL, 6680058412038593536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateDBWithRandomOperationsActor, 0, Void >;
friend struct ActorCallback< UpdateDBWithRandomOperationsActor, 1, Void >;
															#line 173 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	UpdateDBWithRandomOperationsActor(RangeLocking* const& self,Database const& cx) 
															#line 2062 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateDBWithRandomOperationsActorState<UpdateDBWithRandomOperationsActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateDBWithRandomOperations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(393646891996065536UL, 2724095666210275072UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDBWithRandomOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateDBWithRandomOperations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateDBWithRandomOperations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateDBWithRandomOperationsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateDBWithRandomOperationsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 173 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
[[nodiscard]] Future<Void> updateDBWithRandomOperations( RangeLocking* const& self, Database const& cx ) {
															#line 173 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	return Future<Void>(new UpdateDBWithRandomOperationsActor(self, cx));
															#line 2095 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
}

#line 218 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"

																#line 2100 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
// This generated class is to be used only via updateLockMapWithRandomOperation()
															#line 219 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
template <class UpdateLockMapWithRandomOperationActor>
															#line 219 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class UpdateLockMapWithRandomOperationActorState {
															#line 2106 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
															#line 219 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	UpdateLockMapWithRandomOperationActorState(RangeLocking* const& self,Database const& cx) 
															#line 219 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
															#line 219 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		 : self(self),
															#line 219 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   cx(cx)
															#line 2115 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
	{
		fdb_probe_actor_create("updateLockMapWithRandomOperation", reinterpret_cast<unsigned long>(this));

	}
	~UpdateLockMapWithRandomOperationActorState() 
	{
		fdb_probe_actor_destroy("updateLockMapWithRandomOperation", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 220 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			self->lockRangeOperations.clear();
															#line 221 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			i = 0;
															#line 222 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			iterationCount = deterministicRandom()->randomInt(1, 10);
															#line 223 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			;
															#line 2136 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateLockMapWithRandomOperationActorState();
		static_cast<UpdateLockMapWithRandomOperationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 263 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<UpdateLockMapWithRandomOperationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLockMapWithRandomOperationActorState(); static_cast<UpdateLockMapWithRandomOperationActor*>(this)->destroy(); return 0; }
															#line 2159 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<UpdateLockMapWithRandomOperationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLockMapWithRandomOperationActorState();
		static_cast<UpdateLockMapWithRandomOperationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 223 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!(i < iterationCount))
															#line 2178 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 224 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		range = self->getRandomRange();
															#line 225 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		lock = deterministicRandom()->coinflip();
															#line 226 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (lock)
															#line 2188 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
			try {
															#line 228 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				StrictFuture<Void> __when_expr_0 = takeExclusiveReadLockOnRange(cx, range, self->rangeLockOwnerName);
															#line 228 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (static_cast<UpdateLockMapWithRandomOperationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2195 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UpdateLockMapWithRandomOperationActor*>(this)->actor_wait_state = 1;
															#line 228 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateLockMapWithRandomOperationActor, 0, Void >*>(static_cast<UpdateLockMapWithRandomOperationActor*>(this)));
															#line 2200 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			try {
															#line 245 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				StrictFuture<Void> __when_expr_1 = releaseExclusiveReadLockOnRange(cx, range, self->rangeLockOwnerName);
															#line 245 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (static_cast<UpdateLockMapWithRandomOperationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch2(actor_cancelled(), loopDepth);
															#line 2216 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<UpdateLockMapWithRandomOperationActor*>(this)->actor_wait_state = 2;
															#line 245 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateLockMapWithRandomOperationActor, 1, Void >*>(static_cast<UpdateLockMapWithRandomOperationActor*>(this)));
															#line 2221 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1Catch2(unknown_error(), loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1continue1(int loopDepth) 
	{
															#line 223 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		i++;
															#line 2250 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 261 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		self->lockRangeOperations.push_back(LockRangeOperation(range, lock));
															#line 223 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		i++;
															#line 2261 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 233 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2277 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			{
															#line 234 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2281 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			}
															#line 236 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent("RangeLockWorkLoadHistory") .errorUnsuppressed(e) .detail("Ops", "LockFailed") .detail("Range", range);
															#line 240 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			ASSERT(e.code() == error_code_range_lock_reject);
															#line 2287 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			return a_body1continue1(loopDepth); // continue
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 229 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (self->verboseLogging)
															#line 2302 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
															#line 230 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent("RangeLockWorkLoadHistory").detail("Ops", "Lock").detail("Range", range);
															#line 2306 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 229 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (self->verboseLogging)
															#line 2316 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
															#line 230 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent("RangeLockWorkLoadHistory").detail("Ops", "Lock").detail("Range", range);
															#line 2320 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateLockMapWithRandomOperationActor*>(this)->actor_wait_state > 0) static_cast<UpdateLockMapWithRandomOperationActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLockMapWithRandomOperationActor*>(this)->ActorCallback< UpdateLockMapWithRandomOperationActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLockMapWithRandomOperationActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLockMapWithRandomOperation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLockMapWithRandomOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLockMapWithRandomOperation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateLockMapWithRandomOperationActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLockMapWithRandomOperation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLockMapWithRandomOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLockMapWithRandomOperation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateLockMapWithRandomOperationActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLockMapWithRandomOperation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLockMapWithRandomOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLockMapWithRandomOperation", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 250 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2425 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			{
															#line 251 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2429 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			}
															#line 253 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent("RangeLockWorkLoadHistory") .errorUnsuppressed(e) .detail("Ops", "UnlockFailed") .detail("Range", range);
															#line 257 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			ASSERT(e.code() == error_code_range_unlock_reject);
															#line 2435 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			return a_body1continue1(loopDepth); // continue
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 246 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (self->verboseLogging)
															#line 2450 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
															#line 247 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent("RangeLockWorkLoadHistory").detail("Ops", "Unlock").detail("Range", range);
															#line 2454 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 246 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (self->verboseLogging)
															#line 2464 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
															#line 247 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent("RangeLockWorkLoadHistory").detail("Ops", "Unlock").detail("Range", range);
															#line 2468 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateLockMapWithRandomOperationActor*>(this)->actor_wait_state > 0) static_cast<UpdateLockMapWithRandomOperationActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLockMapWithRandomOperationActor*>(this)->ActorCallback< UpdateLockMapWithRandomOperationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLockMapWithRandomOperationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLockMapWithRandomOperation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLockMapWithRandomOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLockMapWithRandomOperation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateLockMapWithRandomOperationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLockMapWithRandomOperation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLockMapWithRandomOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLockMapWithRandomOperation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateLockMapWithRandomOperationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLockMapWithRandomOperation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLockMapWithRandomOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLockMapWithRandomOperation", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 219 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	RangeLocking* self;
															#line 219 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Database cx;
															#line 221 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	int i;
															#line 222 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	int iterationCount;
															#line 224 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	KeyRange range;
															#line 225 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	bool lock;
															#line 2574 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
};
// This generated class is to be used only via updateLockMapWithRandomOperation()
															#line 219 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class UpdateLockMapWithRandomOperationActor final : public Actor<Void>, public ActorCallback< UpdateLockMapWithRandomOperationActor, 0, Void >, public ActorCallback< UpdateLockMapWithRandomOperationActor, 1, Void >, public FastAllocated<UpdateLockMapWithRandomOperationActor>, public UpdateLockMapWithRandomOperationActorState<UpdateLockMapWithRandomOperationActor> {
															#line 2579 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
	using FastAllocated<UpdateLockMapWithRandomOperationActor>::operator new;
	using FastAllocated<UpdateLockMapWithRandomOperationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4201926726658207488UL, 7483365215316881664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateLockMapWithRandomOperationActor, 0, Void >;
friend struct ActorCallback< UpdateLockMapWithRandomOperationActor, 1, Void >;
															#line 219 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	UpdateLockMapWithRandomOperationActor(RangeLocking* const& self,Database const& cx) 
															#line 2597 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateLockMapWithRandomOperationActorState<UpdateLockMapWithRandomOperationActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateLockMapWithRandomOperation", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5150598390189172480UL, 8691964498458651136UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLockMapWithRandomOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateLockMapWithRandomOperation");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateLockMapWithRandomOperation", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateLockMapWithRandomOperationActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateLockMapWithRandomOperationActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 219 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
[[nodiscard]] Future<Void> updateLockMapWithRandomOperation( RangeLocking* const& self, Database const& cx ) {
															#line 219 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	return Future<Void>(new UpdateLockMapWithRandomOperationActor(self, cx));
															#line 2630 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
}

#line 265 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"

	bool operationRejectByLocking(RangeLocking* self, const KVOperation& kvOperation) {
		KeyRange rangeToCheck;
		if (std::holds_alternative<KeyRange>(kvOperation.params)) {
			rangeToCheck = std::get<KeyRange>(kvOperation.params);
		} else {
			rangeToCheck = singleKeyRange(std::get<KeyValue>(kvOperation.params).key);
		}
		for (auto lockRange : self->lockedRangeMap.intersectingRanges(rangeToCheck)) {
			if (lockRange.value() == true) {
				return true;
			}
		}
		return false;
	}

	void updateInMemoryKVSStatus(RangeLocking* self) {
		for (const auto& operation : self->kvOperations) {
			if (self->operationRejectByLocking(self, operation)) {
				continue;
			}
			if (std::holds_alternative<KeyValue>(operation.params)) {
				Key key = std::get<KeyValue>(operation.params).key;
				Value value = std::get<KeyValue>(operation.params).value;
				self->kvs[key] = value;
			} else {
				KeyRange clearRange = std::get<KeyRange>(operation.params);
				std::vector<Key> keysToClear;
				for (const auto& [key, value] : self->kvs) {
					if (clearRange.contains(key)) {
						keysToClear.push_back(key);
					}
				}
				for (const auto& key : keysToClear) {
					self->kvs.erase(key);
				}
			}
		}
		return;
	}

	void updateInMemoryLockStatus(RangeLocking* self) {
		for (const auto& operation : self->lockRangeOperations) {
			self->lockedRangeMap.insert(operation.range, operation.lock);
		}
		return;
	}

																#line 2682 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
// This generated class is to be used only via getKVSFromDB()
															#line 313 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
template <class GetKVSFromDBActor>
															#line 313 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class GetKVSFromDBActorState {
															#line 2688 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
															#line 313 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	GetKVSFromDBActorState(RangeLocking* const& self,Database const& cx) 
															#line 313 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
															#line 313 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		 : self(self),
															#line 313 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   cx(cx),
															#line 314 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   kvsFromDB(),
															#line 315 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   beginKey(normalKeys.begin),
															#line 316 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   endKey(normalKeys.end)
															#line 2703 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
	{
		fdb_probe_actor_create("getKVSFromDB", reinterpret_cast<unsigned long>(this));

	}
	~GetKVSFromDBActorState() 
	{
		fdb_probe_actor_destroy("getKVSFromDB", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 317 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			;
															#line 2718 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKVSFromDBActorState();
		static_cast<GetKVSFromDBActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 335 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<GetKVSFromDBActor*>(this)->SAV<std::map<Key, Value>>::futures) { (void)(kvsFromDB); this->~GetKVSFromDBActorState(); static_cast<GetKVSFromDBActor*>(this)->destroy(); return 0; }
															#line 2741 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<GetKVSFromDBActor*>(this)->SAV< std::map<Key, Value> >::value()) std::map<Key, Value>(std::move(kvsFromDB)); // state_var_RVO
		this->~GetKVSFromDBActorState();
		static_cast<GetKVSFromDBActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 318 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		tr = Transaction(cx);
															#line 319 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		KeyRange rangeToRead = KeyRangeRef(beginKey, endKey);
															#line 2762 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		try {
															#line 321 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 322 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(rangeToRead, GetRangeLimits());
															#line 322 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (static_cast<GetKVSFromDBActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2770 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKVSFromDBActor*>(this)->actor_wait_state = 1;
															#line 322 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKVSFromDBActor, 0, RangeResult >*>(static_cast<GetKVSFromDBActor*>(this)));
															#line 2775 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 332 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 332 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (static_cast<GetKVSFromDBActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2812 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetKVSFromDBActor*>(this)->actor_wait_state = 2;
															#line 332 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKVSFromDBActor, 1, Void >*>(static_cast<GetKVSFromDBActor*>(this)));
															#line 2817 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& res,int loopDepth) 
	{
															#line 323 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for(int i = 0;i < res.size();i++) {
															#line 324 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			kvsFromDB[res[i].key] = res[i].value;
															#line 2834 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
															#line 326 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (res.size() > 0)
															#line 2838 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
															#line 327 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			beginKey = keyAfter(res.end()[-1].key);
															#line 2842 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && res,int loopDepth) 
	{
															#line 323 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for(int i = 0;i < res.size();i++) {
															#line 324 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			kvsFromDB[res[i].key] = res[i].value;
															#line 2858 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
															#line 326 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (res.size() > 0)
															#line 2862 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
															#line 327 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			beginKey = keyAfter(res.end()[-1].key);
															#line 2866 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKVSFromDBActor*>(this)->actor_wait_state > 0) static_cast<GetKVSFromDBActor*>(this)->actor_wait_state = 0;
		static_cast<GetKVSFromDBActor*>(this)->ActorCallback< GetKVSFromDBActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetKVSFromDBActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getKVSFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKVSFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKVSFromDBActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getKVSFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKVSFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKVSFromDBActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getKVSFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKVSFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKVSFromDBActor*>(this)->actor_wait_state > 0) static_cast<GetKVSFromDBActor*>(this)->actor_wait_state = 0;
		static_cast<GetKVSFromDBActor*>(this)->ActorCallback< GetKVSFromDBActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKVSFromDBActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKVSFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKVSFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKVSFromDBActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKVSFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKVSFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKVSFromDBActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKVSFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKVSFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 313 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	RangeLocking* self;
															#line 313 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Database cx;
															#line 314 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	std::map<Key, Value> kvsFromDB;
															#line 315 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Key beginKey;
															#line 316 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Key endKey;
															#line 318 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Transaction tr;
															#line 3063 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
};
// This generated class is to be used only via getKVSFromDB()
															#line 313 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class GetKVSFromDBActor final : public Actor<std::map<Key, Value>>, public ActorCallback< GetKVSFromDBActor, 0, RangeResult >, public ActorCallback< GetKVSFromDBActor, 1, Void >, public FastAllocated<GetKVSFromDBActor>, public GetKVSFromDBActorState<GetKVSFromDBActor> {
															#line 3068 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
	using FastAllocated<GetKVSFromDBActor>::operator new;
	using FastAllocated<GetKVSFromDBActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9904345418584369920UL, 6894737534306221568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::map<Key, Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKVSFromDBActor, 0, RangeResult >;
friend struct ActorCallback< GetKVSFromDBActor, 1, Void >;
															#line 313 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	GetKVSFromDBActor(RangeLocking* const& self,Database const& cx) 
															#line 3086 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		 : Actor<std::map<Key, Value>>(),
		   GetKVSFromDBActorState<GetKVSFromDBActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKVSFromDB", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9015029386154430720UL, 17353648461000331008UL);
		ActorExecutionContextHelper __helper(static_cast<GetKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKVSFromDB");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKVSFromDB", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKVSFromDBActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKVSFromDBActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 313 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
[[nodiscard]] Future<std::map<Key, Value>> getKVSFromDB( RangeLocking* const& self, Database const& cx ) {
															#line 313 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	return Future<std::map<Key, Value>>(new GetKVSFromDBActor(self, cx));
															#line 3119 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
}

#line 337 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"

																#line 3124 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
// This generated class is to be used only via getLockedRangesFromDB()
															#line 338 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
template <class GetLockedRangesFromDBActor>
															#line 338 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class GetLockedRangesFromDBActorState {
															#line 3130 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
															#line 338 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	GetLockedRangesFromDBActorState(Database const& cx) 
															#line 338 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
															#line 338 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		 : cx(cx),
															#line 339 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   res()
															#line 3139 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
	{
		fdb_probe_actor_create("getLockedRangesFromDB", reinterpret_cast<unsigned long>(this));

	}
	~GetLockedRangesFromDBActorState() 
	{
		fdb_probe_actor_destroy("getLockedRangesFromDB", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 340 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(res, findExclusiveReadLockOnRange(cx, normalKeys));
															#line 340 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (static_cast<GetLockedRangesFromDBActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3156 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetLockedRangesFromDBActor*>(this)->actor_wait_state = 1;
															#line 340 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLockedRangesFromDBActor, 0, Void >*>(static_cast<GetLockedRangesFromDBActor*>(this)));
															#line 3161 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLockedRangesFromDBActorState();
		static_cast<GetLockedRangesFromDBActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 341 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		std::vector<KeyRange> ranges;
															#line 342 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for( const auto& lock : res ) {
															#line 343 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			ranges.push_back(lock.first);
															#line 3188 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
															#line 345 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<GetLockedRangesFromDBActor*>(this)->SAV<std::vector<KeyRange>>::futures) { (void)(coalesceRangeList(ranges)); this->~GetLockedRangesFromDBActorState(); static_cast<GetLockedRangesFromDBActor*>(this)->destroy(); return 0; }
															#line 3192 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<GetLockedRangesFromDBActor*>(this)->SAV< std::vector<KeyRange> >::value()) std::vector<KeyRange>(coalesceRangeList(ranges));
		this->~GetLockedRangesFromDBActorState();
		static_cast<GetLockedRangesFromDBActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 341 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		std::vector<KeyRange> ranges;
															#line 342 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for( const auto& lock : res ) {
															#line 343 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			ranges.push_back(lock.first);
															#line 3208 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
															#line 345 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<GetLockedRangesFromDBActor*>(this)->SAV<std::vector<KeyRange>>::futures) { (void)(coalesceRangeList(ranges)); this->~GetLockedRangesFromDBActorState(); static_cast<GetLockedRangesFromDBActor*>(this)->destroy(); return 0; }
															#line 3212 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<GetLockedRangesFromDBActor*>(this)->SAV< std::vector<KeyRange> >::value()) std::vector<KeyRange>(coalesceRangeList(ranges));
		this->~GetLockedRangesFromDBActorState();
		static_cast<GetLockedRangesFromDBActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLockedRangesFromDBActor*>(this)->actor_wait_state > 0) static_cast<GetLockedRangesFromDBActor*>(this)->actor_wait_state = 0;
		static_cast<GetLockedRangesFromDBActor*>(this)->ActorCallback< GetLockedRangesFromDBActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLockedRangesFromDBActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLockedRangesFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLockedRangesFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLockedRangesFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLockedRangesFromDBActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLockedRangesFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLockedRangesFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLockedRangesFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLockedRangesFromDBActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLockedRangesFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLockedRangesFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLockedRangesFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 338 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Database cx;
															#line 339 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	std::vector<std::pair<KeyRange, RangeLockState>> res;
															#line 3299 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
};
// This generated class is to be used only via getLockedRangesFromDB()
															#line 338 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class GetLockedRangesFromDBActor final : public Actor<std::vector<KeyRange>>, public ActorCallback< GetLockedRangesFromDBActor, 0, Void >, public FastAllocated<GetLockedRangesFromDBActor>, public GetLockedRangesFromDBActorState<GetLockedRangesFromDBActor> {
															#line 3304 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
	using FastAllocated<GetLockedRangesFromDBActor>::operator new;
	using FastAllocated<GetLockedRangesFromDBActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13692925962969163776UL, 13808081834677158656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyRange>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLockedRangesFromDBActor, 0, Void >;
															#line 338 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	GetLockedRangesFromDBActor(Database const& cx) 
															#line 3321 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		 : Actor<std::vector<KeyRange>>(),
		   GetLockedRangesFromDBActorState<GetLockedRangesFromDBActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLockedRangesFromDB", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11698265988533137664UL, 15795578718769433600UL);
		ActorExecutionContextHelper __helper(static_cast<GetLockedRangesFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLockedRangesFromDB");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLockedRangesFromDB", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLockedRangesFromDBActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 338 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
[[nodiscard]] Future<std::vector<KeyRange>> getLockedRangesFromDB( Database const& cx ) {
															#line 338 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	return Future<std::vector<KeyRange>>(new GetLockedRangesFromDBActor(cx));
															#line 3353 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
}

#line 347 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"

	std::vector<KeyRange> getLockedRangesFromMemory(RangeLocking* self) {
		std::vector<KeyRange> res;
		for (auto range : self->lockedRangeMap.ranges()) {
			if (range.value() == true) {
				res.push_back(range.range());
			}
		}
		return coalesceRangeList(res);
	}

																#line 3368 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
// This generated class is to be used only via checkKVCorrectness()
															#line 358 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
template <class CheckKVCorrectnessActor>
															#line 358 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class CheckKVCorrectnessActorState {
															#line 3374 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
															#line 358 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	CheckKVCorrectnessActorState(RangeLocking* const& self,Database const& cx) 
															#line 358 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
															#line 358 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		 : self(self),
															#line 358 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   cx(cx),
															#line 359 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   currentKvsInDB()
															#line 3385 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
	{
		fdb_probe_actor_create("checkKVCorrectness", reinterpret_cast<unsigned long>(this));

	}
	~CheckKVCorrectnessActorState() 
	{
		fdb_probe_actor_destroy("checkKVCorrectness", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 360 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(currentKvsInDB, self->getKVSFromDB(self, cx));
															#line 360 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (static_cast<CheckKVCorrectnessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3402 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckKVCorrectnessActor*>(this)->actor_wait_state = 1;
															#line 360 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckKVCorrectnessActor, 0, Void >*>(static_cast<CheckKVCorrectnessActor*>(this)));
															#line 3407 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckKVCorrectnessActorState();
		static_cast<CheckKVCorrectnessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 361 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for( const auto& [key, value] : currentKvsInDB ) {
															#line 362 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (self->kvs.find(key) == self->kvs.end())
															#line 3432 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			{
															#line 363 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				TraceEvent(SevError, "RangeLockWorkLoadHistory") .detail("Ops", "CheckDBUniqueKey") .detail("Key", key) .detail("Value", value);
															#line 367 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				self->shouldExit = true;
															#line 368 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (!static_cast<CheckKVCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckKVCorrectnessActorState(); static_cast<CheckKVCorrectnessActor*>(this)->destroy(); return 0; }
															#line 3440 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				new (&static_cast<CheckKVCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckKVCorrectnessActorState();
				static_cast<CheckKVCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 369 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (self->kvs[key] != value)
															#line 3450 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				{
															#line 370 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
					TraceEvent(SevError, "RangeLockWorkLoadHistory") .detail("Ops", "CheckMismatchValue") .detail("Key", key) .detail("MemValue", self->kvs[key]) .detail("DBValue", value);
															#line 375 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
					self->shouldExit = true;
															#line 376 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
					if (!static_cast<CheckKVCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckKVCorrectnessActorState(); static_cast<CheckKVCorrectnessActor*>(this)->destroy(); return 0; }
															#line 3458 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
					new (&static_cast<CheckKVCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CheckKVCorrectnessActorState();
					static_cast<CheckKVCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 379 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for( const auto& [key, value] : self->kvs ) {
															#line 380 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (currentKvsInDB.find(key) == currentKvsInDB.end())
															#line 3470 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			{
															#line 381 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				TraceEvent(SevError, "RangeLockWorkLoadHistory") .detail("Ops", "CheckMemoryUniqueKey") .detail("Key", key) .detail("Value", value);
															#line 385 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				self->shouldExit = true;
															#line 386 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (!static_cast<CheckKVCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckKVCorrectnessActorState(); static_cast<CheckKVCorrectnessActor*>(this)->destroy(); return 0; }
															#line 3478 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				new (&static_cast<CheckKVCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckKVCorrectnessActorState();
				static_cast<CheckKVCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 389 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (self->verboseLogging)
															#line 3487 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
															#line 390 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent e("RangeLockWorkLoadHistory");
															#line 391 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			e.setMaxEventLength(-1);
															#line 392 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			e.setMaxFieldLength(-1);
															#line 393 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			e.detail("Ops", "CheckAllKVCorrect");
															#line 394 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			int i = 0;
															#line 395 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			for( const auto& [key, value] : currentKvsInDB ) {
															#line 396 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				e.detail("Key" + std::to_string(i), key);
															#line 397 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				e.detail("Value" + std::to_string(i), value);
															#line 398 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				i++;
															#line 3507 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			}
		}
															#line 402 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<CheckKVCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckKVCorrectnessActorState(); static_cast<CheckKVCorrectnessActor*>(this)->destroy(); return 0; }
															#line 3512 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<CheckKVCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckKVCorrectnessActorState();
		static_cast<CheckKVCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 361 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for( const auto& [key, value] : currentKvsInDB ) {
															#line 362 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (self->kvs.find(key) == self->kvs.end())
															#line 3526 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			{
															#line 363 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				TraceEvent(SevError, "RangeLockWorkLoadHistory") .detail("Ops", "CheckDBUniqueKey") .detail("Key", key) .detail("Value", value);
															#line 367 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				self->shouldExit = true;
															#line 368 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (!static_cast<CheckKVCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckKVCorrectnessActorState(); static_cast<CheckKVCorrectnessActor*>(this)->destroy(); return 0; }
															#line 3534 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				new (&static_cast<CheckKVCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckKVCorrectnessActorState();
				static_cast<CheckKVCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 369 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (self->kvs[key] != value)
															#line 3544 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				{
															#line 370 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
					TraceEvent(SevError, "RangeLockWorkLoadHistory") .detail("Ops", "CheckMismatchValue") .detail("Key", key) .detail("MemValue", self->kvs[key]) .detail("DBValue", value);
															#line 375 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
					self->shouldExit = true;
															#line 376 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
					if (!static_cast<CheckKVCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckKVCorrectnessActorState(); static_cast<CheckKVCorrectnessActor*>(this)->destroy(); return 0; }
															#line 3552 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
					new (&static_cast<CheckKVCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CheckKVCorrectnessActorState();
					static_cast<CheckKVCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 379 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for( const auto& [key, value] : self->kvs ) {
															#line 380 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (currentKvsInDB.find(key) == currentKvsInDB.end())
															#line 3564 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			{
															#line 381 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				TraceEvent(SevError, "RangeLockWorkLoadHistory") .detail("Ops", "CheckMemoryUniqueKey") .detail("Key", key) .detail("Value", value);
															#line 385 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				self->shouldExit = true;
															#line 386 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (!static_cast<CheckKVCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckKVCorrectnessActorState(); static_cast<CheckKVCorrectnessActor*>(this)->destroy(); return 0; }
															#line 3572 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				new (&static_cast<CheckKVCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckKVCorrectnessActorState();
				static_cast<CheckKVCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 389 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (self->verboseLogging)
															#line 3581 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
															#line 390 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent e("RangeLockWorkLoadHistory");
															#line 391 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			e.setMaxEventLength(-1);
															#line 392 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			e.setMaxFieldLength(-1);
															#line 393 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			e.detail("Ops", "CheckAllKVCorrect");
															#line 394 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			int i = 0;
															#line 395 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			for( const auto& [key, value] : currentKvsInDB ) {
															#line 396 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				e.detail("Key" + std::to_string(i), key);
															#line 397 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				e.detail("Value" + std::to_string(i), value);
															#line 398 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				i++;
															#line 3601 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			}
		}
															#line 402 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<CheckKVCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckKVCorrectnessActorState(); static_cast<CheckKVCorrectnessActor*>(this)->destroy(); return 0; }
															#line 3606 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<CheckKVCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckKVCorrectnessActorState();
		static_cast<CheckKVCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckKVCorrectnessActor*>(this)->actor_wait_state > 0) static_cast<CheckKVCorrectnessActor*>(this)->actor_wait_state = 0;
		static_cast<CheckKVCorrectnessActor*>(this)->ActorCallback< CheckKVCorrectnessActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckKVCorrectnessActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkKVCorrectness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckKVCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkKVCorrectness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckKVCorrectnessActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkKVCorrectness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckKVCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkKVCorrectness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckKVCorrectnessActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkKVCorrectness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckKVCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkKVCorrectness", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 358 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	RangeLocking* self;
															#line 358 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Database cx;
															#line 359 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	std::map<Key, Value> currentKvsInDB;
															#line 3695 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
};
// This generated class is to be used only via checkKVCorrectness()
															#line 358 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class CheckKVCorrectnessActor final : public Actor<Void>, public ActorCallback< CheckKVCorrectnessActor, 0, Void >, public FastAllocated<CheckKVCorrectnessActor>, public CheckKVCorrectnessActorState<CheckKVCorrectnessActor> {
															#line 3700 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
	using FastAllocated<CheckKVCorrectnessActor>::operator new;
	using FastAllocated<CheckKVCorrectnessActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(92816781120453888UL, 3236761078551306752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckKVCorrectnessActor, 0, Void >;
															#line 358 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	CheckKVCorrectnessActor(RangeLocking* const& self,Database const& cx) 
															#line 3717 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		 : Actor<Void>(),
		   CheckKVCorrectnessActorState<CheckKVCorrectnessActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkKVCorrectness", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1269860959909691392UL, 3057134683711597568UL);
		ActorExecutionContextHelper __helper(static_cast<CheckKVCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkKVCorrectness");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkKVCorrectness", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckKVCorrectnessActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 358 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
[[nodiscard]] Future<Void> checkKVCorrectness( RangeLocking* const& self, Database const& cx ) {
															#line 358 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	return Future<Void>(new CheckKVCorrectnessActor(self, cx));
															#line 3749 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
}

#line 404 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"

																#line 3754 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
// This generated class is to be used only via checkLockCorrectness()
															#line 405 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
template <class CheckLockCorrectnessActor>
															#line 405 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class CheckLockCorrectnessActorState {
															#line 3760 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
															#line 405 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	CheckLockCorrectnessActorState(RangeLocking* const& self,Database const& cx) 
															#line 405 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
															#line 405 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		 : self(self),
															#line 405 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   cx(cx),
															#line 406 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   currentLockRangesInDB()
															#line 3771 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
	{
		fdb_probe_actor_create("checkLockCorrectness", reinterpret_cast<unsigned long>(this));

	}
	~CheckLockCorrectnessActorState() 
	{
		fdb_probe_actor_destroy("checkLockCorrectness", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 407 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(currentLockRangesInDB, self->getLockedRangesFromDB(cx));
															#line 407 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (static_cast<CheckLockCorrectnessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3788 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckLockCorrectnessActor*>(this)->actor_wait_state = 1;
															#line 407 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckLockCorrectnessActor, 0, Void >*>(static_cast<CheckLockCorrectnessActor*>(this)));
															#line 3793 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckLockCorrectnessActorState();
		static_cast<CheckLockCorrectnessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 408 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		std::vector<KeyRange> currentLockRangesInMemory = self->getLockedRangesFromMemory(self);
															#line 409 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for(int i = 0;i < currentLockRangesInDB.size();i++) {
															#line 410 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (i >= currentLockRangesInMemory.size())
															#line 3820 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			{
															#line 411 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				TraceEvent(SevError, "RangeLockWorkLoadHistory") .detail("Ops", "CheckDBUniqueLockedRange") .detail("Range", currentLockRangesInDB[i]);
															#line 414 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				self->shouldExit = true;
															#line 415 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (!static_cast<CheckLockCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckLockCorrectnessActorState(); static_cast<CheckLockCorrectnessActor*>(this)->destroy(); return 0; }
															#line 3828 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				new (&static_cast<CheckLockCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckLockCorrectnessActorState();
				static_cast<CheckLockCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 417 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (currentLockRangesInDB[i] != currentLockRangesInMemory[i])
															#line 3836 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			{
															#line 418 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				TraceEvent(SevError, "RangeLockWorkLoadHistory") .detail("Ops", "CheckMismatchLockedRange") .detail("RangeMemory", currentLockRangesInMemory[i]) .detail("RangeDB", currentLockRangesInDB[i]);
															#line 422 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				self->shouldExit = true;
															#line 423 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (!static_cast<CheckLockCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckLockCorrectnessActorState(); static_cast<CheckLockCorrectnessActor*>(this)->destroy(); return 0; }
															#line 3844 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				new (&static_cast<CheckLockCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckLockCorrectnessActorState();
				static_cast<CheckLockCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 426 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for(int i = currentLockRangesInDB.size();i < currentLockRangesInMemory.size();i++) {
															#line 427 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent(SevError, "RangeLockWorkLoadHistory") .detail("Ops", "CheckMemoryUniqueLockedRange") .detail("Key", currentLockRangesInMemory[i]);
															#line 430 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			self->shouldExit = true;
															#line 431 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (!static_cast<CheckLockCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckLockCorrectnessActorState(); static_cast<CheckLockCorrectnessActor*>(this)->destroy(); return 0; }
															#line 3859 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			new (&static_cast<CheckLockCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckLockCorrectnessActorState();
			static_cast<CheckLockCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 433 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (self->verboseLogging)
															#line 3867 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
															#line 434 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent e("RangeLockWorkLoadHistory");
															#line 435 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			e.setMaxEventLength(-1);
															#line 436 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			e.setMaxFieldLength(-1);
															#line 437 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			e.detail("Ops", "CheckAllLockCorrect");
															#line 438 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			int i = 0;
															#line 439 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			for( const auto& range : currentLockRangesInDB ) {
															#line 440 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				e.detail("Range" + std::to_string(i), range);
															#line 441 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				i++;
															#line 3885 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			}
		}
															#line 445 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<CheckLockCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckLockCorrectnessActorState(); static_cast<CheckLockCorrectnessActor*>(this)->destroy(); return 0; }
															#line 3890 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<CheckLockCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckLockCorrectnessActorState();
		static_cast<CheckLockCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 408 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		std::vector<KeyRange> currentLockRangesInMemory = self->getLockedRangesFromMemory(self);
															#line 409 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for(int i = 0;i < currentLockRangesInDB.size();i++) {
															#line 410 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (i >= currentLockRangesInMemory.size())
															#line 3906 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			{
															#line 411 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				TraceEvent(SevError, "RangeLockWorkLoadHistory") .detail("Ops", "CheckDBUniqueLockedRange") .detail("Range", currentLockRangesInDB[i]);
															#line 414 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				self->shouldExit = true;
															#line 415 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (!static_cast<CheckLockCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckLockCorrectnessActorState(); static_cast<CheckLockCorrectnessActor*>(this)->destroy(); return 0; }
															#line 3914 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				new (&static_cast<CheckLockCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckLockCorrectnessActorState();
				static_cast<CheckLockCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 417 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (currentLockRangesInDB[i] != currentLockRangesInMemory[i])
															#line 3922 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			{
															#line 418 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				TraceEvent(SevError, "RangeLockWorkLoadHistory") .detail("Ops", "CheckMismatchLockedRange") .detail("RangeMemory", currentLockRangesInMemory[i]) .detail("RangeDB", currentLockRangesInDB[i]);
															#line 422 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				self->shouldExit = true;
															#line 423 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (!static_cast<CheckLockCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckLockCorrectnessActorState(); static_cast<CheckLockCorrectnessActor*>(this)->destroy(); return 0; }
															#line 3930 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				new (&static_cast<CheckLockCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckLockCorrectnessActorState();
				static_cast<CheckLockCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 426 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for(int i = currentLockRangesInDB.size();i < currentLockRangesInMemory.size();i++) {
															#line 427 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent(SevError, "RangeLockWorkLoadHistory") .detail("Ops", "CheckMemoryUniqueLockedRange") .detail("Key", currentLockRangesInMemory[i]);
															#line 430 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			self->shouldExit = true;
															#line 431 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (!static_cast<CheckLockCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckLockCorrectnessActorState(); static_cast<CheckLockCorrectnessActor*>(this)->destroy(); return 0; }
															#line 3945 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			new (&static_cast<CheckLockCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckLockCorrectnessActorState();
			static_cast<CheckLockCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 433 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (self->verboseLogging)
															#line 3953 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
															#line 434 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent e("RangeLockWorkLoadHistory");
															#line 435 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			e.setMaxEventLength(-1);
															#line 436 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			e.setMaxFieldLength(-1);
															#line 437 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			e.detail("Ops", "CheckAllLockCorrect");
															#line 438 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			int i = 0;
															#line 439 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			for( const auto& range : currentLockRangesInDB ) {
															#line 440 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				e.detail("Range" + std::to_string(i), range);
															#line 441 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				i++;
															#line 3971 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			}
		}
															#line 445 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<CheckLockCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckLockCorrectnessActorState(); static_cast<CheckLockCorrectnessActor*>(this)->destroy(); return 0; }
															#line 3976 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<CheckLockCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckLockCorrectnessActorState();
		static_cast<CheckLockCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckLockCorrectnessActor*>(this)->actor_wait_state > 0) static_cast<CheckLockCorrectnessActor*>(this)->actor_wait_state = 0;
		static_cast<CheckLockCorrectnessActor*>(this)->ActorCallback< CheckLockCorrectnessActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckLockCorrectnessActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkLockCorrectness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckLockCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkLockCorrectness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckLockCorrectnessActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkLockCorrectness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckLockCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkLockCorrectness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckLockCorrectnessActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkLockCorrectness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckLockCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkLockCorrectness", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 405 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	RangeLocking* self;
															#line 405 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Database cx;
															#line 406 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	std::vector<KeyRange> currentLockRangesInDB;
															#line 4065 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
};
// This generated class is to be used only via checkLockCorrectness()
															#line 405 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class CheckLockCorrectnessActor final : public Actor<Void>, public ActorCallback< CheckLockCorrectnessActor, 0, Void >, public FastAllocated<CheckLockCorrectnessActor>, public CheckLockCorrectnessActorState<CheckLockCorrectnessActor> {
															#line 4070 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
	using FastAllocated<CheckLockCorrectnessActor>::operator new;
	using FastAllocated<CheckLockCorrectnessActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10869358492221956864UL, 4883428603216166656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckLockCorrectnessActor, 0, Void >;
															#line 405 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	CheckLockCorrectnessActor(RangeLocking* const& self,Database const& cx) 
															#line 4087 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		 : Actor<Void>(),
		   CheckLockCorrectnessActorState<CheckLockCorrectnessActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkLockCorrectness", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14093748856184035328UL, 1927283709545446656UL);
		ActorExecutionContextHelper __helper(static_cast<CheckLockCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkLockCorrectness");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkLockCorrectness", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckLockCorrectnessActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 405 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
[[nodiscard]] Future<Void> checkLockCorrectness( RangeLocking* const& self, Database const& cx ) {
															#line 405 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	return Future<Void>(new CheckLockCorrectnessActor(self, cx));
															#line 4119 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
}

#line 447 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"

																#line 4124 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
// This generated class is to be used only via complexTest()
															#line 448 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
template <class ComplexTestActor>
															#line 448 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class ComplexTestActorState {
															#line 4130 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
															#line 448 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	ComplexTestActorState(RangeLocking* const& self,Database const& cx) 
															#line 448 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
															#line 448 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		 : self(self),
															#line 448 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   cx(cx),
															#line 449 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   iterationCount(100),
															#line 450 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   iteration(0)
															#line 4143 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
	{
		fdb_probe_actor_create("complexTest", reinterpret_cast<unsigned long>(this));

	}
	~ComplexTestActorState() 
	{
		fdb_probe_actor_destroy("complexTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 451 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			;
															#line 4158 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ComplexTestActorState();
		static_cast<ComplexTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 488 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		StrictFuture<std::vector<std::pair<KeyRange, RangeLockState>>> __when_expr_4 = findExclusiveReadLockOnRange(cx, normalKeys);
															#line 488 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4183 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 5;
															#line 488 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 4, std::vector<std::pair<KeyRange, RangeLockState>> >*>(static_cast<ComplexTestActor*>(this)));
															#line 4188 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 452 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (iteration > iterationCount || self->shouldExit)
															#line 4204 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 455 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 4210 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
															#line 456 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->updateLockMapWithRandomOperation(self, cx);
															#line 456 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4216 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ComplexTestActor*>(this)->actor_wait_state = 1;
															#line 456 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 0, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 4221 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 459 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		TraceEvent("RangeLockWorkloadProgress") .detail("Iteration", iteration) .detail("IterationCount", iterationCount) .detail("Phase", "UpdateLock");
															#line 463 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->checkLockCorrectness(self, cx);
															#line 463 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4252 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 2;
															#line 463 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 1, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 4257 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 457 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		self->updateInMemoryLockStatus(self);
															#line 4266 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 457 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		self->updateInMemoryLockStatus(self);
															#line 4275 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 464 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		TraceEvent("RangeLockWorkloadProgress") .detail("Iteration", iteration) .detail("IterationCount", iterationCount) .detail("Phase", "CheckLockCorrectness");
															#line 468 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 4361 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
			try {
															#line 470 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				StrictFuture<Void> __when_expr_2 = self->updateDBWithRandomOperations(self, cx);
															#line 470 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont5Catch1(actor_cancelled(), loopDepth);
															#line 4368 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont5Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_2.get(), loopDepth); };
				static_cast<ComplexTestActor*>(this)->actor_wait_state = 3;
															#line 470 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 2, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 4373 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1cont5Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1cont5Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 464 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		TraceEvent("RangeLockWorkloadProgress") .detail("Iteration", iteration) .detail("IterationCount", iterationCount) .detail("Phase", "CheckLockCorrectness");
															#line 468 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 4395 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
			try {
															#line 470 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				StrictFuture<Void> __when_expr_2 = self->updateDBWithRandomOperations(self, cx);
															#line 470 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont5Catch1(actor_cancelled(), loopDepth);
															#line 4402 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont5Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_2.get(), loopDepth); };
				static_cast<ComplexTestActor*>(this)->actor_wait_state = 3;
															#line 470 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 2, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 4407 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1cont5Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1cont5Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 477 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		TraceEvent("RangeLockWorkloadProgress") .detail("Iteration", iteration) .detail("IterationCount", iterationCount) .detail("Phase", "UpdateDB");
															#line 481 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->checkKVCorrectness(self, cx);
															#line 481 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4506 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 4;
															#line 481 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 3, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 4511 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 473 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			ASSERT(e.code() == error_code_transaction_rejected_range_locked);
															#line 474 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			self->kvOperations.clear();
															#line 4529 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = a_body1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 471 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		self->updateInMemoryKVSStatus(self);
															#line 4544 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 471 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		self->updateInMemoryKVSStatus(self);
															#line 4553 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 482 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		TraceEvent("RangeLockWorkloadProgress") .detail("Iteration", iteration) .detail("IterationCount", iterationCount) .detail("Phase", "CheckDBCorrectness");
															#line 486 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		iteration++;
															#line 4652 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 482 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		TraceEvent("RangeLockWorkloadProgress") .detail("Iteration", iteration) .detail("IterationCount", iterationCount) .detail("Phase", "CheckDBCorrectness");
															#line 486 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		iteration++;
															#line 4663 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2(std::vector<std::pair<KeyRange, RangeLockState>> const& locks2,int loopDepth) 
	{
															#line 489 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for( const auto& lock : locks2 ) {
															#line 490 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent("RangeLockWorkloadProgress") .detail("Phase", "BeforeLockRelease") .detail("Range", lock.first) .detail("State", lock.second.toString());
															#line 4749 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
															#line 495 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		StrictFuture<Void> __when_expr_5 = releaseExclusiveReadLockByUser(cx, self->rangeLockOwnerName);
															#line 495 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4755 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 6;
															#line 495 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 5, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 4760 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(std::vector<std::pair<KeyRange, RangeLockState>> && locks2,int loopDepth) 
	{
															#line 489 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for( const auto& lock : locks2 ) {
															#line 490 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent("RangeLockWorkloadProgress") .detail("Phase", "BeforeLockRelease") .detail("Range", lock.first) .detail("State", lock.second.toString());
															#line 4771 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
															#line 495 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		StrictFuture<Void> __when_expr_5 = releaseExclusiveReadLockByUser(cx, self->rangeLockOwnerName);
															#line 495 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4777 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 6;
															#line 495 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 5, Void >*>(static_cast<ComplexTestActor*>(this)));
															#line 4782 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<std::pair<KeyRange, RangeLockState>> const& locks2,int loopDepth) 
	{
		loopDepth = a_body1cont2(locks2, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<std::pair<KeyRange, RangeLockState>> && locks2,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(locks2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 4, std::vector<std::pair<KeyRange, RangeLockState>> >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 4, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 4, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 4, std::vector<std::pair<KeyRange, RangeLockState>> >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 496 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		StrictFuture<std::vector<std::pair<KeyRange, RangeLockState>>> __when_expr_6 = findExclusiveReadLockOnRange(cx, normalKeys);
															#line 496 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4868 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 7;
															#line 496 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 6, std::vector<std::pair<KeyRange, RangeLockState>> >*>(static_cast<ComplexTestActor*>(this)));
															#line 4873 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 496 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		StrictFuture<std::vector<std::pair<KeyRange, RangeLockState>>> __when_expr_6 = findExclusiveReadLockOnRange(cx, normalKeys);
															#line 496 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4884 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<ComplexTestActor*>(this)->actor_wait_state = 7;
															#line 496 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ComplexTestActor, 6, std::vector<std::pair<KeyRange, RangeLockState>> >*>(static_cast<ComplexTestActor*>(this)));
															#line 4889 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont5(std::vector<std::pair<KeyRange, RangeLockState>> const& locks,int loopDepth) 
	{
															#line 497 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for( const auto& lock : locks ) {
															#line 498 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent("RangeLockWorkloadProgress") .detail("Phase", "AfterLockRelease") .detail("Range", lock.first) .detail("State", lock.second.toString());
															#line 4975 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
															#line 503 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		ASSERT(locks.empty());
															#line 505 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		TraceEvent("RangeLockWorkloadProgress").detail("Phase", "End");
															#line 506 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<ComplexTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ComplexTestActorState(); static_cast<ComplexTestActor*>(this)->destroy(); return 0; }
															#line 4983 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<ComplexTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ComplexTestActorState();
		static_cast<ComplexTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(std::vector<std::pair<KeyRange, RangeLockState>> && locks,int loopDepth) 
	{
															#line 497 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for( const auto& lock : locks ) {
															#line 498 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent("RangeLockWorkloadProgress") .detail("Phase", "AfterLockRelease") .detail("Range", lock.first) .detail("State", lock.second.toString());
															#line 4997 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
															#line 503 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		ASSERT(locks.empty());
															#line 505 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		TraceEvent("RangeLockWorkloadProgress").detail("Phase", "End");
															#line 506 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<ComplexTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ComplexTestActorState(); static_cast<ComplexTestActor*>(this)->destroy(); return 0; }
															#line 5005 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<ComplexTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ComplexTestActorState();
		static_cast<ComplexTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(std::vector<std::pair<KeyRange, RangeLockState>> const& locks,int loopDepth) 
	{
		loopDepth = a_body1cont5(locks, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(std::vector<std::pair<KeyRange, RangeLockState>> && locks,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(locks), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ComplexTestActor*>(this)->actor_wait_state > 0) static_cast<ComplexTestActor*>(this)->actor_wait_state = 0;
		static_cast<ComplexTestActor*>(this)->ActorCallback< ComplexTestActor, 6, std::vector<std::pair<KeyRange, RangeLockState>> >::remove();

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 6, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> const& value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ComplexTestActor, 6, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> && value) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ComplexTestActor, 6, std::vector<std::pair<KeyRange, RangeLockState>> >*,Error err) 
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 448 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	RangeLocking* self;
															#line 448 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Database cx;
															#line 449 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	int iterationCount;
															#line 450 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	int iteration;
															#line 5096 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
};
// This generated class is to be used only via complexTest()
															#line 448 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class ComplexTestActor final : public Actor<Void>, public ActorCallback< ComplexTestActor, 0, Void >, public ActorCallback< ComplexTestActor, 1, Void >, public ActorCallback< ComplexTestActor, 2, Void >, public ActorCallback< ComplexTestActor, 3, Void >, public ActorCallback< ComplexTestActor, 4, std::vector<std::pair<KeyRange, RangeLockState>> >, public ActorCallback< ComplexTestActor, 5, Void >, public ActorCallback< ComplexTestActor, 6, std::vector<std::pair<KeyRange, RangeLockState>> >, public FastAllocated<ComplexTestActor>, public ComplexTestActorState<ComplexTestActor> {
															#line 5101 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
	using FastAllocated<ComplexTestActor>::operator new;
	using FastAllocated<ComplexTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14380426871839494912UL, 10875173217506898944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ComplexTestActor, 0, Void >;
friend struct ActorCallback< ComplexTestActor, 1, Void >;
friend struct ActorCallback< ComplexTestActor, 2, Void >;
friend struct ActorCallback< ComplexTestActor, 3, Void >;
friend struct ActorCallback< ComplexTestActor, 4, std::vector<std::pair<KeyRange, RangeLockState>> >;
friend struct ActorCallback< ComplexTestActor, 5, Void >;
friend struct ActorCallback< ComplexTestActor, 6, std::vector<std::pair<KeyRange, RangeLockState>> >;
															#line 448 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	ComplexTestActor(RangeLocking* const& self,Database const& cx) 
															#line 5124 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		 : Actor<Void>(),
		   ComplexTestActorState<ComplexTestActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("complexTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(428946891448577280UL, 5305349067125682688UL);
		ActorExecutionContextHelper __helper(static_cast<ComplexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("complexTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("complexTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ComplexTestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ComplexTestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ComplexTestActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ComplexTestActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ComplexTestActor, 4, std::vector<std::pair<KeyRange, RangeLockState>> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ComplexTestActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ComplexTestActor, 6, std::vector<std::pair<KeyRange, RangeLockState>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 448 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
[[nodiscard]] Future<Void> complexTest( RangeLocking* const& self, Database const& cx ) {
															#line 448 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	return Future<Void>(new ComplexTestActor(self, cx));
															#line 5162 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
}

#line 508 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"

	bool sameRangeList(const std::vector<KeyRange>& rangesA,
	                   const std::vector<KeyRange>& rangesB,
	                   const RangeLockOwnerName& owner) {
		if (rangesA.size() != rangesB.size()) {
			TraceEvent(SevError, "RangeLockWorkloadTestUnlockRangeByUserMismatch")
			    .detail("RangesA", describe(rangesA))
			    .detail("RangesB", describe(rangesB))
			    .detail("Owner", owner);
			return false;
		}
		for (const auto& rangeA : rangesA) {
			if (std::find(rangesB.begin(), rangesB.end(), rangeA) == rangesB.end()) {
				TraceEvent(SevError, "RangeLockWorkloadTestUnlockRangeByUserMismatch")
				    .detail("RangesA", describe(rangesA))
				    .detail("RangesB", describe(rangesB))
				    .detail("Owner", owner);
				return false;
			}
		}
		for (const auto& rangeB : rangesB) {
			if (std::find(rangesA.begin(), rangesA.end(), rangeB) == rangesA.end()) {
				TraceEvent(SevError, "RangeLockWorkloadTestUnlockRangeByUserMismatch")
				    .detail("RangesA", describe(rangesA))
				    .detail("RangesB", describe(rangesB))
				    .detail("Owner", owner);
				return false;
			}
		}
		return true;
	}

																#line 5198 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
// This generated class is to be used only via testUnlockByUser()
															#line 540 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
template <class TestUnlockByUserActor>
															#line 540 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class TestUnlockByUserActorState {
															#line 5204 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
															#line 540 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	TestUnlockByUserActorState(RangeLocking* const& self,Database const& cx) 
															#line 540 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
															#line 540 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		 : self(self),
															#line 540 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   cx(cx),
															#line 541 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   i(0),
															#line 542 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   j(0),
															#line 543 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   rangeLocks(),
															#line 544 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   rangeLockOwnerName(),
															#line 545 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   candidates(),
															#line 546 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   rangeToLock(),
															#line 547 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   lockedRanges(),
															#line 548 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   usersToUnlock(),
															#line 549 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   locksPerUser()
															#line 5231 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
	{
		fdb_probe_actor_create("testUnlockByUser", reinterpret_cast<unsigned long>(this));

	}
	~TestUnlockByUserActorState() 
	{
		fdb_probe_actor_destroy("testUnlockByUser", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 550 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			;
															#line 5246 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestUnlockByUserActorState();
		static_cast<TestUnlockByUserActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 574 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		for(i = 0;i < 10;i++) {
															#line 575 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			usersToUnlock.push_back(deterministicRandom()->randomChoice(candidates));
															#line 5271 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
															#line 577 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		i = 0;
															#line 5275 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 550 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!(i < 100))
															#line 5291 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 551 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		rangeLockOwnerName = "TestUnlockByUser" + std::to_string(i);
															#line 552 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		StrictFuture<Void> __when_expr_0 = registerRangeLockOwner(cx, rangeLockOwnerName, rangeLockOwnerName);
															#line 552 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (static_cast<TestUnlockByUserActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5301 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TestUnlockByUserActor*>(this)->actor_wait_state = 1;
															#line 552 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestUnlockByUserActor, 0, Void >*>(static_cast<TestUnlockByUserActor*>(this)));
															#line 5306 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 553 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		lockedRanges.clear();
															#line 554 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		;
															#line 5330 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 553 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		lockedRanges.clear();
															#line 554 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		;
															#line 5341 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestUnlockByUserActor*>(this)->actor_wait_state > 0) static_cast<TestUnlockByUserActor*>(this)->actor_wait_state = 0;
		static_cast<TestUnlockByUserActor*>(this)->ActorCallback< TestUnlockByUserActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestUnlockByUserActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testUnlockByUser", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestUnlockByUserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testUnlockByUser", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestUnlockByUserActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testUnlockByUser", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestUnlockByUserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testUnlockByUser", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestUnlockByUserActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testUnlockByUser", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestUnlockByUserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testUnlockByUser", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 570 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		auto res = rangeLocks.insert({ rangeLockOwnerName, lockedRanges });
															#line 571 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		ASSERT(res.second);
															#line 572 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		candidates.push_back(rangeLockOwnerName);
															#line 550 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		i++;
															#line 5431 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 554 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!(j < 2))
															#line 5447 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 556 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			rangeToLock = self->getRandomRange();
															#line 557 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_1 = takeExclusiveReadLockOnRange(cx, rangeToLock, rangeLockOwnerName);
															#line 557 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (static_cast<TestUnlockByUserActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5458 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestUnlockByUserActor*>(this)->actor_wait_state = 2;
															#line 557 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestUnlockByUserActor, 1, Void >*>(static_cast<TestUnlockByUserActor*>(this)));
															#line 5463 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 554 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		j++;
															#line 5491 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 564 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 5501 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			{
															#line 565 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 5505 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			}
															#line 567 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			ASSERT(e.code() == error_code_range_lock_reject);
															#line 5509 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 558 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		lockedRanges.push_back(rangeToLock);
															#line 559 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		TraceEvent("RangeLockWorkloadTestUnlockRangeByUser") .detail("Ops", "LockRange") .detail("Range", rangeToLock) .detail("User", rangeLockOwnerName);
															#line 5526 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 558 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		lockedRanges.push_back(rangeToLock);
															#line 559 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		TraceEvent("RangeLockWorkloadTestUnlockRangeByUser") .detail("Ops", "LockRange") .detail("Range", rangeToLock) .detail("User", rangeLockOwnerName);
															#line 5537 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestUnlockByUserActor*>(this)->actor_wait_state > 0) static_cast<TestUnlockByUserActor*>(this)->actor_wait_state = 0;
		static_cast<TestUnlockByUserActor*>(this)->ActorCallback< TestUnlockByUserActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestUnlockByUserActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testUnlockByUser", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestUnlockByUserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testUnlockByUser", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestUnlockByUserActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testUnlockByUser", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestUnlockByUserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testUnlockByUser", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestUnlockByUserActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testUnlockByUser", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestUnlockByUserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testUnlockByUser", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 583 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		i = 0;
															#line 5634 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 577 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!(i < usersToUnlock.size()))
															#line 5650 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 578 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		StrictFuture<Void> __when_expr_2 = releaseExclusiveReadLockByUser(cx, usersToUnlock[i]);
															#line 578 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (static_cast<TestUnlockByUserActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5658 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestUnlockByUserActor*>(this)->actor_wait_state = 3;
															#line 578 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestUnlockByUserActor, 2, Void >*>(static_cast<TestUnlockByUserActor*>(this)));
															#line 5663 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 579 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		TraceEvent("RangeLockWorkloadTestUnlockRangeByUser") .detail("Ops", "Unlock by user") .detail("User", usersToUnlock[i]);
															#line 577 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		i++;
															#line 5687 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 579 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		TraceEvent("RangeLockWorkloadTestUnlockRangeByUser") .detail("Ops", "Unlock by user") .detail("User", usersToUnlock[i]);
															#line 577 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		i++;
															#line 5698 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestUnlockByUserActor*>(this)->actor_wait_state > 0) static_cast<TestUnlockByUserActor*>(this)->actor_wait_state = 0;
		static_cast<TestUnlockByUserActor*>(this)->ActorCallback< TestUnlockByUserActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestUnlockByUserActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testUnlockByUser", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestUnlockByUserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testUnlockByUser", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestUnlockByUserActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testUnlockByUser", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestUnlockByUserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testUnlockByUser", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestUnlockByUserActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testUnlockByUser", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestUnlockByUserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testUnlockByUser", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 607 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<TestUnlockByUserActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestUnlockByUserActorState(); static_cast<TestUnlockByUserActor*>(this)->destroy(); return 0; }
															#line 5782 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<TestUnlockByUserActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestUnlockByUserActorState();
		static_cast<TestUnlockByUserActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 583 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!(i < candidates.size()))
															#line 5801 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 584 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		locksPerUser.clear();
															#line 585 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(locksPerUser, findExclusiveReadLockOnRange(cx, normalKeys, candidates[i]));
															#line 585 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (static_cast<TestUnlockByUserActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5811 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestUnlockByUserActor*>(this)->actor_wait_state = 4;
															#line 585 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestUnlockByUserActor, 3, Void >*>(static_cast<TestUnlockByUserActor*>(this)));
															#line 5816 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 586 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (std::find(usersToUnlock.begin(), usersToUnlock.end(), candidates[i]) != usersToUnlock.end())
															#line 5838 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
															#line 587 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent("RangeLockWorkloadTestUnlockRangeByUser") .detail("Ops", "Find unlocked user") .detail("User", candidates[i]) .detail("LockCount", locksPerUser.size());
															#line 591 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			ASSERT(locksPerUser.empty());
															#line 5844 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
		else
		{
															#line 593 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			std::vector<KeyRange> lockedRangeFromMetadata;
															#line 594 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			for( const auto& lock : locksPerUser ) {
															#line 595 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				ASSERT(lock.first == lock.second.getRange());
															#line 596 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				lockedRangeFromMetadata.push_back(lock.first);
															#line 5856 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			}
															#line 598 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent("RangeLockWorkloadTestUnlockRangeByUser") .detail("Ops", "Find locked user") .detail("User", candidates[i]) .detail("LockCount", locksPerUser.size());
															#line 602 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			ASSERT(self->sameRangeList(coalesceRangeList(lockedRangeFromMetadata), coalesceRangeList(rangeLocks[candidates[i]]), candidates[i]));
															#line 5862 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
															#line 583 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		i++;
															#line 5866 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 586 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (std::find(usersToUnlock.begin(), usersToUnlock.end(), candidates[i]) != usersToUnlock.end())
															#line 5875 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		{
															#line 587 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent("RangeLockWorkloadTestUnlockRangeByUser") .detail("Ops", "Find unlocked user") .detail("User", candidates[i]) .detail("LockCount", locksPerUser.size());
															#line 591 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			ASSERT(locksPerUser.empty());
															#line 5881 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
		else
		{
															#line 593 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			std::vector<KeyRange> lockedRangeFromMetadata;
															#line 594 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			for( const auto& lock : locksPerUser ) {
															#line 595 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				ASSERT(lock.first == lock.second.getRange());
															#line 596 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				lockedRangeFromMetadata.push_back(lock.first);
															#line 5893 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			}
															#line 598 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			TraceEvent("RangeLockWorkloadTestUnlockRangeByUser") .detail("Ops", "Find locked user") .detail("User", candidates[i]) .detail("LockCount", locksPerUser.size());
															#line 602 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			ASSERT(self->sameRangeList(coalesceRangeList(lockedRangeFromMetadata), coalesceRangeList(rangeLocks[candidates[i]]), candidates[i]));
															#line 5899 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		}
															#line 583 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		i++;
															#line 5903 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestUnlockByUserActor*>(this)->actor_wait_state > 0) static_cast<TestUnlockByUserActor*>(this)->actor_wait_state = 0;
		static_cast<TestUnlockByUserActor*>(this)->ActorCallback< TestUnlockByUserActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestUnlockByUserActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testUnlockByUser", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestUnlockByUserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testUnlockByUser", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestUnlockByUserActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testUnlockByUser", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestUnlockByUserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testUnlockByUser", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestUnlockByUserActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testUnlockByUser", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestUnlockByUserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testUnlockByUser", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 540 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	RangeLocking* self;
															#line 540 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Database cx;
															#line 541 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	int i;
															#line 542 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	int j;
															#line 543 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	std::unordered_map<RangeLockOwnerName, std::vector<KeyRange>> rangeLocks;
															#line 544 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	RangeLockOwnerName rangeLockOwnerName;
															#line 545 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	std::vector<RangeLockOwnerName> candidates;
															#line 546 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	KeyRange rangeToLock;
															#line 547 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	std::vector<KeyRange> lockedRanges;
															#line 548 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	std::vector<RangeLockOwnerName> usersToUnlock;
															#line 549 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	std::vector<std::pair<KeyRange, RangeLockState>> locksPerUser;
															#line 6005 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
};
// This generated class is to be used only via testUnlockByUser()
															#line 540 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class TestUnlockByUserActor final : public Actor<Void>, public ActorCallback< TestUnlockByUserActor, 0, Void >, public ActorCallback< TestUnlockByUserActor, 1, Void >, public ActorCallback< TestUnlockByUserActor, 2, Void >, public ActorCallback< TestUnlockByUserActor, 3, Void >, public FastAllocated<TestUnlockByUserActor>, public TestUnlockByUserActorState<TestUnlockByUserActor> {
															#line 6010 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
	using FastAllocated<TestUnlockByUserActor>::operator new;
	using FastAllocated<TestUnlockByUserActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5096849560860751104UL, 2467233668631338496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestUnlockByUserActor, 0, Void >;
friend struct ActorCallback< TestUnlockByUserActor, 1, Void >;
friend struct ActorCallback< TestUnlockByUserActor, 2, Void >;
friend struct ActorCallback< TestUnlockByUserActor, 3, Void >;
															#line 540 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	TestUnlockByUserActor(RangeLocking* const& self,Database const& cx) 
															#line 6030 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		 : Actor<Void>(),
		   TestUnlockByUserActorState<TestUnlockByUserActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testUnlockByUser", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15536262685815873792UL, 12686534904881858560UL);
		ActorExecutionContextHelper __helper(static_cast<TestUnlockByUserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testUnlockByUser");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testUnlockByUser", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestUnlockByUserActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestUnlockByUserActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestUnlockByUserActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestUnlockByUserActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 540 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
[[nodiscard]] Future<Void> testUnlockByUser( RangeLocking* const& self, Database const& cx ) {
															#line 540 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	return Future<Void>(new TestUnlockByUserActor(self, cx));
															#line 6065 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
}

#line 609 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"

																#line 6070 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 610 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
template <class _startActor>
															#line 610 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class _startActorState {
															#line 6076 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
															#line 610 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	_startActorState(RangeLocking* const& self,Database const& cx) 
															#line 610 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
															#line 610 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		 : self(self),
															#line 610 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		   cx(cx)
															#line 6085 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 611 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (self->clientId != 0)
															#line 6100 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			{
															#line 612 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
				if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 6104 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
				new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_startActorState();
				static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 614 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->complexTest(self, cx);
															#line 614 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6114 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 614 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 6119 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 615 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testUnlockByUser(self, cx);
															#line 615 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6144 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 615 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 6149 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 615 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->testUnlockByUser(self, cx);
															#line 615 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6160 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 615 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 6165 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 616 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 6249 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 616 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 6261 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 610 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	RangeLocking* self;
															#line 610 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	Database cx;
															#line 6348 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 610 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 6353 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1446807056285570304UL, 907017801643491072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
															#line 610 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	_startActor(RangeLocking* const& self,Database const& cx) 
															#line 6371 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 610 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
[[nodiscard]] Future<Void> _start( RangeLocking* const& self, Database const& cx ) {
															#line 610 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 6404 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RangeLock.actor.g.cpp"
}

#line 618 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/RangeLock.actor.cpp"
};

WorkloadFactory<RangeLocking> RangeLockingFactory;
