#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
/*
 * MutationLogReaderCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstdint>
#include <limits>
#include "fmt/format.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/MutationLogReader.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/flow.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct MutationLogReaderCorrectnessWorkload : TestWorkload {
	static constexpr auto NAME = "MutationLogReaderCorrectness";

	bool enabled;
	int records;
	Version versionRange;
	Version versionIncrement;
	Version beginVersion;
	Version endVersion;
	Key uid;
	Key baLogRangePrefix;
	bool debug = false;

	Version recordVersion(int index) { return beginVersion + versionIncrement * index; }

	Key recordKey(int index) { return getLogKey(recordVersion(index), uid); }

	Value recordValue(int index) {
		Version v = recordVersion(index);
		return StringRef(format("%" PRId64 " (%" PRIx64 ")", v, v));
	}

	MutationLogReaderCorrectnessWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		enabled = !clientId; // only do this on the "first" client
		uid = BinaryWriter::toValue(deterministicRandom()->randomUniqueID(), Unversioned());
		baLogRangePrefix = uid.withPrefix(backupLogKeys.begin);

		beginVersion = deterministicRandom()->randomInt64(
		    0, std::numeric_limits<int32_t>::max()); // intentionally not max of int64
		records = deterministicRandom()->randomInt(0, 500e3);
		versionRange = deterministicRandom()->randomInt64(records, std::numeric_limits<Version>::max());
		versionIncrement = versionRange / (records + 1);

		// The version immediately after the last actual record version
		endVersion = recordVersion(records - 1) + 1;
	}

	Future<Void> start(Database const& cx) override {
		if (enabled) {
			return _start(cx, this);
		}
		return Void();
	}

																#line 80 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 78 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
template <class _startActor>
															#line 78 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
class _startActorState {
															#line 86 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
public:
															#line 78 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
	_startActorState(Database const& cx,MutationLogReaderCorrectnessWorkload* const& self) 
															#line 78 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
															#line 78 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		 : cx(cx),
															#line 78 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		   self(self),
															#line 79 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		   tr(cx),
															#line 80 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		   iStart(0),
															#line 81 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		   batchSize(1000)
															#line 101 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 82 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			fmt::print("Records: {}\n", self->records);
															#line 83 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			fmt::print("BeginVersion: {}\n", self->beginVersion);
															#line 84 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			fmt::print("EndVersion: {}\n", self->endVersion);
															#line 86 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			;
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		StrictFuture<Reference<MutationLogReader>> __when_expr_2 = MutationLogReader::Create( cx, self->beginVersion, self->endVersion, self->uid, backupLogKeys.begin, 1);
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 147 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Reference<MutationLogReader> >*>(static_cast<_startActor*>(this)));
															#line 152 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 86 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		if (!(iStart < self->records))
															#line 168 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 87 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		;
															#line 174 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 89 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			tr.reset();
															#line 90 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 92 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			int i = iStart;
															#line 93 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			iEnd = std::min(iStart + batchSize, self->records);
															#line 95 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			for(;i < iEnd;++i) {
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
				Key key = self->recordKey(i);
															#line 97 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
				Value value = self->recordValue(i);
															#line 98 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
				tr.set(key, value);
															#line 224 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
			}
															#line 101 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 101 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 230 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 101 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 235 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 105 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 105 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 272 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 105 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 277 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		iStart = iEnd;
															#line 292 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		iStart = iEnd;
															#line 301 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 113 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		nextExpectedRecord = 0;
															#line 472 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
		try {
															#line 116 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			;
															#line 476 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Reference<MutationLogReader> const& __reader,int loopDepth) 
	{
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		reader = __reader;
															#line 491 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<MutationLogReader> && __reader,int loopDepth) 
	{
		reader = std::move(__reader);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Reference<MutationLogReader> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Reference<MutationLogReader> >*,Reference<MutationLogReader> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Reference<MutationLogReader> >*,Reference<MutationLogReader> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Reference<MutationLogReader> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 148 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		printf("records expected: %d\n", self->records);
															#line 149 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		printf("records found:    %d\n", nextExpectedRecord);
															#line 151 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		ASSERT_EQ(nextExpectedRecord, self->records);
															#line 153 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 576 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 143 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			if (e.code() != error_code_end_of_stream)
															#line 589 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
			{
															#line 144 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 593 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 117 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		StrictFuture<Standalone<RangeResultRef>> __when_expr_3 = reader->getNext();
															#line 117 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 618 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 117 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Standalone<RangeResultRef> >*>(static_cast<_startActor*>(this)));
															#line 623 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 119 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		for( const auto& rec : results ) {
															#line 120 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			Key expectedKey = self->recordKey(nextExpectedRecord);
															#line 121 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			Value expectedValue = self->recordValue(nextExpectedRecord);
															#line 123 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			bool keyMatch = rec.key == expectedKey;
															#line 124 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			bool valueMatch = rec.value == expectedValue;
															#line 126 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			if (self->debug)
															#line 642 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
			{
															#line 127 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
				if (!keyMatch)
															#line 646 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
				{
															#line 128 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
					printf("key:            %s\n", rec.key.printable().c_str());
															#line 129 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
					printf("expected key:   %s\n", expectedKey.printable().c_str());
															#line 652 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
				}
															#line 131 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
				if (!valueMatch)
															#line 656 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
				{
															#line 132 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
					printf("value:          %s\n", rec.value.printable().c_str());
															#line 133 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
					printf("expected value: %s\n", expectedValue.printable().c_str());
															#line 662 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
				}
			}
															#line 137 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			ASSERT(keyMatch);
															#line 138 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			ASSERT(valueMatch);
															#line 139 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
			++nextExpectedRecord;
															#line 671 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Standalone<RangeResultRef> const& __results,int loopDepth) 
	{
															#line 117 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
		results = __results;
															#line 681 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Standalone<RangeResultRef> && __results,int loopDepth) 
	{
		results = std::move(__results);
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Standalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Standalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 78 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
	Database cx;
															#line 78 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
	MutationLogReaderCorrectnessWorkload* self;
															#line 79 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
	Transaction tr;
															#line 80 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
	int iStart;
															#line 81 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
	int batchSize;
															#line 93 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
	int iEnd;
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
	Reference<MutationLogReader> reader;
															#line 113 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
	int nextExpectedRecord;
															#line 117 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
	Standalone<RangeResultRef> results;
															#line 774 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 78 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Reference<MutationLogReader> >, public ActorCallback< _startActor, 3, Standalone<RangeResultRef> >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 779 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(843055090393621248UL, 12955766943819052800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Reference<MutationLogReader> >;
friend struct ActorCallback< _startActor, 3, Standalone<RangeResultRef> >;
															#line 78 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
	_startActor(Database const& cx,MutationLogReaderCorrectnessWorkload* const& self) 
															#line 799 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Reference<MutationLogReader> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Standalone<RangeResultRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 78 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, MutationLogReaderCorrectnessWorkload* const& self ) {
															#line 78 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 834 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MutationLogReaderCorrectness.actor.g.cpp"
}

#line 155 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/MutationLogReaderCorrectness.actor.cpp"

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<MutationLogReaderCorrectnessWorkload> MutationLogReaderCorrectnessWorkloadFactory;
