#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
/*
 * BlobFailureInjection.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/simulator.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/FaultInjection.h"
#include "flow/DeterministicRandom.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "flow/actorcompiler.h" // This must be the last #include.

/*
 * The BlobFailureInjection workload is designed to simulate blob storage becoming temporarily flaky or unavailable,
 * from a single host to the whole cluster.
 * TODO: add blob storage becoming permanently flaky or unavailable on a single host, to ensure the system moves work
 * away accordingly. Could also handle that through attrition workload maybe?
 * FIXME: make this work outside simulation. Talk to workers like DiskFailureInjection does and add S3BlobStore and
 * AzureBlobStore fault injection points.
 */
struct BlobFailureInjectionWorkload : FailureInjectionWorkload {
	static constexpr auto NAME = "BlobFailureInjection";

	bool enabled;
	double enableProbability = 0.5;
	double testDuration = 10.0;

	std::vector<ISimulator::ProcessInfo*> currentlyAffected;

	BlobFailureInjectionWorkload(WorkloadContext const& wcx, NoOptions) : FailureInjectionWorkload(wcx) {
		enabled = !clientId && g_network->isSimulated() && faultInjectionActivated;
	}

	BlobFailureInjectionWorkload(WorkloadContext const& wcx) : FailureInjectionWorkload(wcx) {
		// only do this on the "first" client, and only when in simulation and only when fault injection is enabled
		enabled = !clientId && g_network->isSimulated() && faultInjectionActivated;
		enableProbability = getOption(options, "enableProbability"_sr, enableProbability);
		testDuration = getOption(options, "testDuration"_sr, testDuration);
		enabled = (enabled && deterministicRandom()->random01() < enableProbability);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override { return _start(cx, this); }

	bool shouldInject(DeterministicRandom& random,
	                  const WorkloadRequest& work,
	                  const unsigned alreadyAdded) const override {
		return alreadyAdded < 1 && work.useDatabase && 0.1 / (1 + alreadyAdded) > random.random01();
	}

	void undoFaultInjection() {
		if (!currentlyAffected.empty()) {
			TraceEvent("BlobFailureInjectionUnFailing").detail("Count", currentlyAffected.size());
		}
		for (auto& it : currentlyAffected) {
			TraceEvent("BlobFailureInjectionUnFailingProcess").detail("Addr", it->address);
			g_simulator->processStopInjectBlobFault(it);
		}
		currentlyAffected.clear();
	}

																#line 79 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 77 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
template <class _startActor>
															#line 77 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
class _startActorState {
															#line 85 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
public:
															#line 77 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
	_startActorState(Database const& cx,BlobFailureInjectionWorkload* const& self) 
															#line 77 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
															#line 77 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		 : cx(cx),
															#line 77 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		   self(self)
															#line 94 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 78 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			if (!self->enabled)
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
			{
															#line 79 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
				if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 113 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
				new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_startActorState();
				static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 82 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			CODE_PROBE(true, "Running workload with blob failure injection");
															#line 83 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			TraceEvent("BlobFailureInjectionBegin").log();
															#line 85 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			auto processes = getServers();
															#line 86 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			deterministicRandom()->randomShuffle(processes);
															#line 88 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(reportErrors(self->worker(cx, self, processes), "BlobFailureInjectionWorkerError"), self->testDuration, Void());
															#line 88 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 131 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 88 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 136 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 93 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		self->undoFaultInjection();
															#line 94 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		TraceEvent("BlobFailureInjectionEnd").log();
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 163 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 93 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		self->undoFaultInjection();
															#line 94 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		TraceEvent("BlobFailureInjectionEnd").log();
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 179 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 77 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
	Database cx;
															#line 77 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
	BlobFailureInjectionWorkload* self;
															#line 266 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 77 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 271 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3927263829214916864UL, 2811211553706989824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 77 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
	_startActor(Database const& cx,BlobFailureInjectionWorkload* const& self) 
															#line 288 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 77 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, BlobFailureInjectionWorkload* const& self ) {
															#line 77 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 320 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
}

#line 98 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"

	// TODO: share code with machine attrition
	static std::vector<ISimulator::ProcessInfo*> getServers() {
		std::vector<ISimulator::ProcessInfo*> machines;
		std::vector<ISimulator::ProcessInfo*> all = g_simulator->getAllProcesses();
		for (int i = 0; i < all.size(); i++)
			if (!all[i]->failed && all[i]->name == std::string("Server") &&
			    all[i]->startingClass != ProcessClass::TesterClass)
				machines.push_back(all[i]);
		return machines;
	}

																#line 336 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
// This generated class is to be used only via worker()
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
template <class WorkerActor>
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
class WorkerActorState {
															#line 342 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
public:
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
	WorkerActorState(Database const& cx,BlobFailureInjectionWorkload* const& self,std::vector<ISimulator::ProcessInfo*> const& processes) 
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		 : cx(cx),
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		   self(self),
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		   processes(processes)
															#line 353 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
	{
		fdb_probe_actor_create("worker", reinterpret_cast<unsigned long>(this));

	}
	~WorkerActorState() 
	{
		fdb_probe_actor_destroy("worker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 113 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			int minFailureDuration = 5;
															#line 114 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			int maxFailureDuration = std::max(10, (int)(self->testDuration / 2));
															#line 116 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			failureDuration = deterministicRandom()->randomSkewedUInt32(minFailureDuration, maxFailureDuration);
															#line 119 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			failureDuration += deterministicRandom()->random01();
															#line 120 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			delayBefore = deterministicRandom()->random01() * (std::max<double>(0.0, self->testDuration - failureDuration));
															#line 123 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(delayBefore);
															#line 123 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			if (static_cast<WorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 380 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkerActor*>(this)->actor_wait_state = 1;
															#line 123 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerActor, 0, Void >*>(static_cast<WorkerActor*>(this)));
															#line 385 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerActorState();
		static_cast<WorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 127 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		int amountToFail = 1;
															#line 128 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 410 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		{
															#line 129 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 414 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
			{
															#line 131 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
				amountToFail = processes.size();
															#line 418 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
			}
			else
			{
															#line 132 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
				if (processes.size() > 3)
															#line 424 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
				{
															#line 134 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
					amountToFail = deterministicRandom()->randomInt(2, std::max<int>(3, processes.size() / 2));
															#line 428 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
				}
			}
		}
															#line 137 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		ASSERT(amountToFail <= processes.size());
															#line 138 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		ASSERT(amountToFail > 0);
															#line 140 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		double failureRate;
															#line 141 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 440 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		{
															#line 143 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			failureRate = 1.0;
															#line 444 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		}
		else
		{
															#line 148 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			failureRate = deterministicRandom()->randomSkewedUInt32(1, 1000) / 1000.0;
															#line 450 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		}
															#line 151 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		CODE_PROBE(true, "blob failure injection killing processes");
															#line 153 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		TraceEvent("BlobFailureInjectionFailing") .detail("Count", amountToFail) .detail("Duration", failureDuration) .detail("FailureRate", failureRate) .log();
															#line 158 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		for(int i = 0;i < amountToFail;i++) {
															#line 159 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			TraceEvent("BlobFailureInjectionFailingProcess").detail("Addr", processes[i]->address);
															#line 160 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			self->currentlyAffected.push_back(processes[i]);
															#line 161 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			g_simulator->processInjectBlobFault(processes[i], failureRate);
															#line 464 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		}
															#line 164 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(failureDuration);
															#line 164 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		if (static_cast<WorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 470 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WorkerActor*>(this)->actor_wait_state = 2;
															#line 164 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerActor, 1, Void >*>(static_cast<WorkerActor*>(this)));
															#line 475 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 127 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		int amountToFail = 1;
															#line 128 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 486 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		{
															#line 129 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 490 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
			{
															#line 131 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
				amountToFail = processes.size();
															#line 494 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
			}
			else
			{
															#line 132 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
				if (processes.size() > 3)
															#line 500 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
				{
															#line 134 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
					amountToFail = deterministicRandom()->randomInt(2, std::max<int>(3, processes.size() / 2));
															#line 504 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
				}
			}
		}
															#line 137 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		ASSERT(amountToFail <= processes.size());
															#line 138 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		ASSERT(amountToFail > 0);
															#line 140 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		double failureRate;
															#line 141 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 516 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		{
															#line 143 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			failureRate = 1.0;
															#line 520 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		}
		else
		{
															#line 148 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			failureRate = deterministicRandom()->randomSkewedUInt32(1, 1000) / 1000.0;
															#line 526 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		}
															#line 151 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		CODE_PROBE(true, "blob failure injection killing processes");
															#line 153 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		TraceEvent("BlobFailureInjectionFailing") .detail("Count", amountToFail) .detail("Duration", failureDuration) .detail("FailureRate", failureRate) .log();
															#line 158 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		for(int i = 0;i < amountToFail;i++) {
															#line 159 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			TraceEvent("BlobFailureInjectionFailingProcess").detail("Addr", processes[i]->address);
															#line 160 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			self->currentlyAffected.push_back(processes[i]);
															#line 161 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
			g_simulator->processInjectBlobFault(processes[i], failureRate);
															#line 540 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		}
															#line 164 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(failureDuration);
															#line 164 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		if (static_cast<WorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 546 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WorkerActor*>(this)->actor_wait_state = 2;
															#line 164 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerActor, 1, Void >*>(static_cast<WorkerActor*>(this)));
															#line 551 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerActor*>(this)->actor_wait_state > 0) static_cast<WorkerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerActor*>(this)->ActorCallback< WorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 166 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		self->undoFaultInjection();
															#line 168 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		if (!static_cast<WorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerActorState(); static_cast<WorkerActor*>(this)->destroy(); return 0; }
															#line 637 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		new (&static_cast<WorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerActorState();
		static_cast<WorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 166 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		self->undoFaultInjection();
															#line 168 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
		if (!static_cast<WorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerActorState(); static_cast<WorkerActor*>(this)->destroy(); return 0; }
															#line 651 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		new (&static_cast<WorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerActorState();
		static_cast<WorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkerActor*>(this)->actor_wait_state > 0) static_cast<WorkerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerActor*>(this)->ActorCallback< WorkerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
	Database cx;
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
	BlobFailureInjectionWorkload* self;
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
	std::vector<ISimulator::ProcessInfo*> processes;
															#line 116 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
	double failureDuration;
															#line 120 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
	double delayBefore;
															#line 744 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
};
// This generated class is to be used only via worker()
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
class WorkerActor final : public Actor<Void>, public ActorCallback< WorkerActor, 0, Void >, public ActorCallback< WorkerActor, 1, Void >, public FastAllocated<WorkerActor>, public WorkerActorState<WorkerActor> {
															#line 749 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
public:
	using FastAllocated<WorkerActor>::operator new;
	using FastAllocated<WorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13102683556424411392UL, 2744320801636522240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerActor, 0, Void >;
friend struct ActorCallback< WorkerActor, 1, Void >;
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
	WorkerActor(Database const& cx,BlobFailureInjectionWorkload* const& self,std::vector<ISimulator::ProcessInfo*> const& processes) 
															#line 767 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
		 : Actor<Void>(),
		   WorkerActorState<WorkerActor>(cx, self, processes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9305151550442981632UL, 410782307204870400UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("worker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
[[nodiscard]] Future<Void> worker( Database const& cx, BlobFailureInjectionWorkload* const& self, std::vector<ISimulator::ProcessInfo*> const& processes ) {
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"
	return Future<Void>(new WorkerActor(cx, self, processes));
															#line 800 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobFailureInjection.actor.g.cpp"
}

#line 170 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/workloads/BlobFailureInjection.actor.cpp"

	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<BlobFailureInjectionWorkload> BlobFailureInjectionWorkloadFactory;
// TODO enable once bugs fixed!
// FailureInjectorFactory<BlobFailureInjectionWorkload> BlobFailureInjectionFailureWorkloadFactory;
