#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
/*
 * Ratekeeper.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ClientKnobs.h"
#include "fdbserver/DataDistribution.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/Ratekeeper.h"
#include "fdbserver/TagThrottler.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/QuietDatabase.h"
#include "flow/OwningResource.h"

#include "flow/actorcompiler.h" // must be last include

const char* limitReasonName[] = {
	"workload",
	"storage_server_write_queue_size",
	"storage_server_write_bandwidth_mvcc",
	"storage_server_readable_behind",
	"log_server_mvcc_write_bandwidth",
	"log_server_write_queue",
	"storage_server_min_free_space",
	"storage_server_min_free_space_ratio",
	"log_server_min_free_space",
	"log_server_min_free_space_ratio",
	"storage_server_durability_lag",
	"storage_server_list_fetch_failed",
};
static_assert(sizeof(limitReasonName) / sizeof(limitReasonName[0]) == limitReason_t_end, "limitReasonDesc table size");

int limitReasonEnd = limitReason_t_end;

// NOTE: This has a corresponding table in Script.cs (see RatekeeperReason graph)
// IF UPDATING THIS ARRAY, UPDATE SCRIPT.CS!
const char* limitReasonDesc[] = {
	"Workload or read performance.",
	"Storage server performance (storage queue).",
	"Storage server MVCC memory.",
	"Storage server version falling behind.",
	"Log server MVCC memory.",
	"Storage server performance (log queue).",
	"Storage server running out of space (approaching 100MB limit).",
	"Storage server running out of space (approaching 5% limit).",
	"Log server running out of space (approaching 100MB limit).",
	"Log server running out of space (approaching 5% limit).",
	"Storage server durable version falling behind.",
	"Unable to fetch storage server list.",
};

static_assert(sizeof(limitReasonDesc) / sizeof(limitReasonDesc[0]) == limitReason_t_end, "limitReasonDesc table size");

															#line 71 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
namespace {
// This generated class is to be used only via splitError()
															#line 69 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
template <class SplitErrorActor>
															#line 69 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class SplitErrorActorState {
															#line 78 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
															#line 69 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	SplitErrorActorState(Future<Void> const& in,Promise<Void> const& errOut) 
															#line 69 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
															#line 69 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		 : in(in),
															#line 69 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   errOut(errOut)
															#line 87 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
	{
		fdb_probe_actor_create("splitError", reinterpret_cast<unsigned long>(this));

	}
	~SplitErrorActorState() 
	{
		fdb_probe_actor_destroy("splitError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 71 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				StrictFuture<Void> __when_expr_0 = in;
															#line 71 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				if (static_cast<SplitErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 105 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SplitErrorActor*>(this)->actor_wait_state = 1;
															#line 71 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SplitErrorActor, 0, Void >*>(static_cast<SplitErrorActor*>(this)));
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SplitErrorActorState();
		static_cast<SplitErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 74 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (e.code() != error_code_actor_cancelled && !errOut.isSet())
															#line 140 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 75 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				errOut.sendError(e);
															#line 144 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
															#line 76 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 148 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 72 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (!static_cast<SplitErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SplitErrorActorState(); static_cast<SplitErrorActor*>(this)->destroy(); return 0; }
															#line 162 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		new (&static_cast<SplitErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SplitErrorActorState();
		static_cast<SplitErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 72 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (!static_cast<SplitErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SplitErrorActorState(); static_cast<SplitErrorActor*>(this)->destroy(); return 0; }
															#line 174 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		new (&static_cast<SplitErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SplitErrorActorState();
		static_cast<SplitErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SplitErrorActor*>(this)->actor_wait_state > 0) static_cast<SplitErrorActor*>(this)->actor_wait_state = 0;
		static_cast<SplitErrorActor*>(this)->ActorCallback< SplitErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SplitErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("splitError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SplitErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("splitError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SplitErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("splitError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SplitErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("splitError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SplitErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("splitError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SplitErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("splitError", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 69 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Future<Void> in;
															#line 69 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Promise<Void> errOut;
															#line 261 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
};
// This generated class is to be used only via splitError()
															#line 69 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class SplitErrorActor final : public Actor<Void>, public ActorCallback< SplitErrorActor, 0, Void >, public FastAllocated<SplitErrorActor>, public SplitErrorActorState<SplitErrorActor> {
															#line 266 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
	using FastAllocated<SplitErrorActor>::operator new;
	using FastAllocated<SplitErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8176455840787929856UL, 12614375506921771008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SplitErrorActor, 0, Void >;
															#line 69 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	SplitErrorActor(Future<Void> const& in,Promise<Void> const& errOut) 
															#line 283 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		 : Actor<Void>(),
		   SplitErrorActorState<SplitErrorActor>(in, errOut),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("splitError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12060009219836764928UL, 12485460052581462272UL);
		ActorExecutionContextHelper __helper(static_cast<SplitErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("splitError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("splitError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SplitErrorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 69 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
[[nodiscard]] static Future<Void> splitError( Future<Void> const& in, Promise<Void> const& errOut ) {
															#line 69 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	return Future<Void>(new SplitErrorActor(in, errOut));
															#line 316 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
}

#line 79 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"

class RatekeeperImpl {
public:
																#line 323 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
// This generated class is to be used only via configurationMonitor()
															#line 82 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
template <class ConfigurationMonitorActor>
															#line 82 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class ConfigurationMonitorActorState {
															#line 329 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
															#line 82 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	ConfigurationMonitorActorState(Ratekeeper* const& self) 
															#line 82 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
															#line 82 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		 : self(self)
															#line 336 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
	{
		fdb_probe_actor_create("configurationMonitor", reinterpret_cast<unsigned long>(this));

	}
	~ConfigurationMonitorActorState() 
	{
		fdb_probe_actor_destroy("configurationMonitor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 83 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			;
															#line 351 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigurationMonitorActorState();
		static_cast<ConfigurationMonitorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 84 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		tr = ReadYourWritesTransaction(self->db);
															#line 86 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		;
															#line 383 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 88 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 89 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 90 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(configKeys, CLIENT_KNOBS->TOO_MANY);
															#line 90 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 412 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 1;
															#line 90 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 0, RangeResult >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 417 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 103 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 103 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 454 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 4;
															#line 103 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 3, Void >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 459 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(RangeResult const& results,int loopDepth) 
	{
															#line 91 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		ASSERT(!results.more && results.size() < CLIENT_KNOBS->TOO_MANY);
															#line 93 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self->configuration.fromKeyValues((VectorRef<KeyValueRef>)results);
															#line 95 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		watchFuture = tr.watch(moveKeysLockOwnerKey) || tr.watch(excludedServersVersionKey) || tr.watch(failedServersVersionKey) || tr.watch(excludedLocalityVersionKey) || tr.watch(failedLocalityVersionKey);
															#line 99 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 99 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 482 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 2;
															#line 99 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 1, Void >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 487 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(RangeResult && results,int loopDepth) 
	{
															#line 91 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		ASSERT(!results.more && results.size() < CLIENT_KNOBS->TOO_MANY);
															#line 93 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self->configuration.fromKeyValues((VectorRef<KeyValueRef>)results);
															#line 95 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		watchFuture = tr.watch(moveKeysLockOwnerKey) || tr.watch(excludedServersVersionKey) || tr.watch(failedServersVersionKey) || tr.watch(excludedLocalityVersionKey) || tr.watch(failedLocalityVersionKey);
															#line 99 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 99 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 504 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 2;
															#line 99 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 1, Void >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 509 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(results, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state > 0) static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigurationMonitorActor*>(this)->ActorCallback< ConfigurationMonitorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigurationMonitorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 100 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 100 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 595 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 3;
															#line 100 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 2, Void >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 600 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 100 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 100 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 611 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 3;
															#line 100 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigurationMonitorActor, 2, Void >*>(static_cast<ConfigurationMonitorActor*>(this)));
															#line 616 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state > 0) static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigurationMonitorActor*>(this)->ActorCallback< ConfigurationMonitorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConfigurationMonitorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state > 0) static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigurationMonitorActor*>(this)->ActorCallback< ConfigurationMonitorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConfigurationMonitorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state > 0) static_cast<ConfigurationMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigurationMonitorActor*>(this)->ActorCallback< ConfigurationMonitorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ConfigurationMonitorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ConfigurationMonitorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 82 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Ratekeeper* self;
															#line 84 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 95 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Future<Void> watchFuture;
															#line 876 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
};
// This generated class is to be used only via configurationMonitor()
															#line 82 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class ConfigurationMonitorActor final : public Actor<Void>, public ActorCallback< ConfigurationMonitorActor, 0, RangeResult >, public ActorCallback< ConfigurationMonitorActor, 1, Void >, public ActorCallback< ConfigurationMonitorActor, 2, Void >, public ActorCallback< ConfigurationMonitorActor, 3, Void >, public FastAllocated<ConfigurationMonitorActor>, public ConfigurationMonitorActorState<ConfigurationMonitorActor> {
															#line 881 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
	using FastAllocated<ConfigurationMonitorActor>::operator new;
	using FastAllocated<ConfigurationMonitorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4156945848302638336UL, 4544967022582039552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigurationMonitorActor, 0, RangeResult >;
friend struct ActorCallback< ConfigurationMonitorActor, 1, Void >;
friend struct ActorCallback< ConfigurationMonitorActor, 2, Void >;
friend struct ActorCallback< ConfigurationMonitorActor, 3, Void >;
															#line 82 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	ConfigurationMonitorActor(Ratekeeper* const& self) 
															#line 901 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		 : Actor<Void>(),
		   ConfigurationMonitorActorState<ConfigurationMonitorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configurationMonitor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11255558610263663616UL, 7933841004617470208UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigurationMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configurationMonitor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configurationMonitor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigurationMonitorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConfigurationMonitorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConfigurationMonitorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ConfigurationMonitorActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 82 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
[[nodiscard]] static Future<Void> configurationMonitor( Ratekeeper* const& self ) {
															#line 82 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	return Future<Void>(new ConfigurationMonitorActor(self));
															#line 936 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
}

#line 108 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"

																#line 941 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
// This generated class is to be used only via monitorServerListChange()
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
template <class MonitorServerListChangeActor>
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class MonitorServerListChangeActorState {
															#line 947 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	MonitorServerListChangeActorState(Ratekeeper* const& self,PromiseStream<std::pair<UID, Optional<StorageServerInterface>>> const& serverChanges) 
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		 : self(self),
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   serverChanges(serverChanges),
															#line 112 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   oldServers(),
															#line 113 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   tr(self->db)
															#line 960 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorServerListChange", reinterpret_cast<unsigned long>(this));

	}
	~MonitorServerListChangeActorState() 
	{
		fdb_probe_actor_destroy("monitorServerListChange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 115 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			;
															#line 975 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorServerListChangeActorState();
		static_cast<MonitorServerListChangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 117 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (now() - self->lastSSListFetchedTimestamp > 2 * SERVER_KNOBS->SERVER_LIST_DELAY)
															#line 1006 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 118 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				TraceEvent(SevWarnAlways, "RatekeeperGetSSListLongLatency", self->id) .detail("Latency", now() - self->lastSSListFetchedTimestamp);
															#line 1010 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
															#line 121 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			StrictFuture<std::vector<std::pair<StorageServerInterface, ProcessClass>>> __when_expr_0 = NativeAPI::getServerListAndProcessClasses(&tr);
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (static_cast<MonitorServerListChangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1018 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorServerListChangeActor*>(this)->actor_wait_state = 1;
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorServerListChangeActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*>(static_cast<MonitorServerListChangeActor*>(this)));
															#line 1023 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 150 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 1045 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 151 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				TraceEvent("RatekeeperGetSSListError", self->id).errorUnsuppressed(e).suppressFor(1.0);
															#line 1049 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
															#line 153 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 153 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (static_cast<MonitorServerListChangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1055 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorServerListChangeActor*>(this)->actor_wait_state = 3;
															#line 153 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorServerListChangeActor, 2, Void >*>(static_cast<MonitorServerListChangeActor*>(this)));
															#line 1060 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<std::pair<StorageServerInterface, ProcessClass>> const& results,int loopDepth) 
	{
															#line 124 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self->lastSSListFetchedTimestamp = now();
															#line 126 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		std::map<UID, StorageServerInterface> newServers;
															#line 127 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		for( const auto& [ssi, _] : results ) {
															#line 128 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			const UID serverId = ssi.id();
															#line 129 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			newServers[serverId] = ssi;
															#line 131 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (oldServers.contains(serverId))
															#line 1085 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 132 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				if (ssi.getValue.getEndpoint() != oldServers[serverId].getValue.getEndpoint() || ssi.isAcceptingRequests() != oldServers[serverId].isAcceptingRequests())
															#line 1089 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				{
															#line 134 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
					serverChanges.send(std::make_pair(serverId, Optional<StorageServerInterface>(ssi)));
															#line 1093 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				}
															#line 136 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				oldServers.erase(serverId);
															#line 1097 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
			else
			{
															#line 138 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				serverChanges.send(std::make_pair(serverId, Optional<StorageServerInterface>(ssi)));
															#line 1103 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
		}
															#line 142 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		for( const auto& it : oldServers ) {
															#line 143 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			serverChanges.send(std::make_pair(it.first, Optional<StorageServerInterface>()));
															#line 1110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 146 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		oldServers.swap(newServers);
															#line 147 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		tr = Transaction(self->db);
															#line 148 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->SERVER_LIST_DELAY);
															#line 148 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<MonitorServerListChangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1120 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorServerListChangeActor*>(this)->actor_wait_state = 2;
															#line 148 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorServerListChangeActor, 1, Void >*>(static_cast<MonitorServerListChangeActor*>(this)));
															#line 1125 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<std::pair<StorageServerInterface, ProcessClass>> && results,int loopDepth) 
	{
															#line 124 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self->lastSSListFetchedTimestamp = now();
															#line 126 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		std::map<UID, StorageServerInterface> newServers;
															#line 127 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		for( const auto& [ssi, _] : results ) {
															#line 128 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			const UID serverId = ssi.id();
															#line 129 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			newServers[serverId] = ssi;
															#line 131 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (oldServers.contains(serverId))
															#line 1144 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 132 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				if (ssi.getValue.getEndpoint() != oldServers[serverId].getValue.getEndpoint() || ssi.isAcceptingRequests() != oldServers[serverId].isAcceptingRequests())
															#line 1148 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				{
															#line 134 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
					serverChanges.send(std::make_pair(serverId, Optional<StorageServerInterface>(ssi)));
															#line 1152 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				}
															#line 136 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				oldServers.erase(serverId);
															#line 1156 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
			else
			{
															#line 138 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				serverChanges.send(std::make_pair(serverId, Optional<StorageServerInterface>(ssi)));
															#line 1162 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
		}
															#line 142 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		for( const auto& it : oldServers ) {
															#line 143 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			serverChanges.send(std::make_pair(it.first, Optional<StorageServerInterface>()));
															#line 1169 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 146 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		oldServers.swap(newServers);
															#line 147 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		tr = Transaction(self->db);
															#line 148 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->SERVER_LIST_DELAY);
															#line 148 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<MonitorServerListChangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1179 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorServerListChangeActor*>(this)->actor_wait_state = 2;
															#line 148 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorServerListChangeActor, 1, Void >*>(static_cast<MonitorServerListChangeActor*>(this)));
															#line 1184 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<std::pair<StorageServerInterface, ProcessClass>> const& results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(results, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<std::pair<StorageServerInterface, ProcessClass>> && results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorServerListChangeActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerListChangeActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerListChangeActor*>(this)->ActorCallback< MonitorServerListChangeActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerListChangeActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,std::vector<std::pair<StorageServerInterface, ProcessClass>> const& value) 
	{
		fdb_probe_actor_enter("monitorServerListChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerListChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerListChange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorServerListChangeActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,std::vector<std::pair<StorageServerInterface, ProcessClass>> && value) 
	{
		fdb_probe_actor_enter("monitorServerListChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerListChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerListChange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorServerListChangeActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerListChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerListChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerListChange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorServerListChangeActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerListChangeActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerListChangeActor*>(this)->ActorCallback< MonitorServerListChangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerListChangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerListChange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerListChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerListChange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorServerListChangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerListChange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerListChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerListChange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorServerListChangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerListChange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerListChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerListChange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorServerListChangeActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerListChangeActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerListChangeActor*>(this)->ActorCallback< MonitorServerListChangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerListChangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerListChange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerListChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerListChange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorServerListChangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerListChange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerListChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerListChange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorServerListChangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerListChange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerListChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerListChange", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Ratekeeper* self;
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	PromiseStream<std::pair<UID, Optional<StorageServerInterface>>> serverChanges;
															#line 112 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	std::map<UID, StorageServerInterface> oldServers;
															#line 113 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Transaction tr;
															#line 1459 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
};
// This generated class is to be used only via monitorServerListChange()
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class MonitorServerListChangeActor final : public Actor<Void>, public ActorCallback< MonitorServerListChangeActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >, public ActorCallback< MonitorServerListChangeActor, 1, Void >, public ActorCallback< MonitorServerListChangeActor, 2, Void >, public FastAllocated<MonitorServerListChangeActor>, public MonitorServerListChangeActorState<MonitorServerListChangeActor> {
															#line 1464 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
	using FastAllocated<MonitorServerListChangeActor>::operator new;
	using FastAllocated<MonitorServerListChangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10706770242223790592UL, 15648037227554555648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorServerListChangeActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >;
friend struct ActorCallback< MonitorServerListChangeActor, 1, Void >;
friend struct ActorCallback< MonitorServerListChangeActor, 2, Void >;
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	MonitorServerListChangeActor(Ratekeeper* const& self,PromiseStream<std::pair<UID, Optional<StorageServerInterface>>> const& serverChanges) 
															#line 1483 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorServerListChangeActorState<MonitorServerListChangeActor>(self, serverChanges),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorServerListChange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11596563793998936320UL, 5671698331209308672UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerListChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorServerListChange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorServerListChange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorServerListChangeActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorServerListChangeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorServerListChangeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
[[nodiscard]] static Future<Void> monitorServerListChange( Ratekeeper* const& self, PromiseStream<std::pair<UID, Optional<StorageServerInterface>>> const& serverChanges ) {
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	return Future<Void>(new MonitorServerListChangeActor(self, serverChanges));
															#line 1517 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
}

#line 157 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"

																#line 1522 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
// This generated class is to be used only via trackStorageServerQueueInfo()
															#line 158 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
template <class TrackStorageServerQueueInfoActor>
															#line 158 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class TrackStorageServerQueueInfoActorState {
															#line 1528 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
															#line 158 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	TrackStorageServerQueueInfoActorState(ActorWeakSelfRef<Ratekeeper> const& self,StorageServerInterface const& ssi) 
															#line 158 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
															#line 158 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		 : self(self),
															#line 158 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   ssi(ssi)
															#line 1537 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
	{
		fdb_probe_actor_create("trackStorageServerQueueInfo", reinterpret_cast<unsigned long>(this));

	}
	~TrackStorageServerQueueInfoActorState() 
	{
		fdb_probe_actor_destroy("trackStorageServerQueueInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 160 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self->storageQueueInfo.insert(mapPair(ssi.id(), StorageQueueInfo(self->id, ssi.id(), ssi.locality)));
															#line 161 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self->healthMetrics.storageStats[ssi.id()] = HealthMetrics::StorageStats();
															#line 162 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			TraceEvent("RkTrackStorageStart", self->id) .detail("StorageServer", ssi.id()) .detail("Locality", ssi.locality.toString());
															#line 166 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			;
															#line 1558 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackStorageServerQueueInfoActorState();
		static_cast<TrackStorageServerQueueInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 168 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			StrictFuture<ErrorOr<StorageQueuingMetricsReply>> __when_expr_0 = ssi.getQueuingMetrics.getReplyUnlessFailedFor( StorageQueuingMetricsRequest(), 0, 0);
															#line 168 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (static_cast<TrackStorageServerQueueInfoActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1591 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TrackStorageServerQueueInfoActor*>(this)->actor_wait_state = 1;
															#line 168 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackStorageServerQueueInfoActor, 0, ErrorOr<StorageQueuingMetricsReply> >*>(static_cast<TrackStorageServerQueueInfoActor*>(this)));
															#line 1596 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 194 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1618 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 195 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				self->storageQueueInfo.erase(ssi.id());
															#line 196 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				self->healthMetrics.storageStats.erase(ssi.id());
															#line 197 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1626 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
															#line 200 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			Map<UID, StorageQueueInfo>::iterator myQueueInfo = self->storageQueueInfo.find(ssi.id());
															#line 201 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			ASSERT(myQueueInfo != self->storageQueueInfo.end());
															#line 202 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			myQueueInfo->value.valid = false;
															#line 203 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			TraceEvent("RkTrackStorageError", self->id) .detail("StorageServer", ssi.id()) .detail("Locality", ssi.locality.toString()) .errorUnsuppressed(e);
															#line 1636 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(ErrorOr<StorageQueuingMetricsReply> const& reply,int loopDepth) 
	{
															#line 170 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		Map<UID, StorageQueueInfo>::iterator myQueueInfo = self->storageQueueInfo.find(ssi.id());
															#line 171 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		ASSERT(myQueueInfo != self->storageQueueInfo.end());
															#line 172 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (reply.present())
															#line 1655 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 173 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			myQueueInfo->value.update(reply.get(), self->smoothTotalDurableBytes);
															#line 174 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			myQueueInfo->value.acceptingRequests = ssi.isAcceptingRequests();
															#line 177 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			auto ssMetrics = self->healthMetrics.storageStats.find(ssi.id());
															#line 178 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			ASSERT(ssMetrics != self->healthMetrics.storageStats.end());
															#line 179 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			ssMetrics->second.storageQueue = myQueueInfo->value.getStorageQueueBytes();
															#line 180 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			ssMetrics->second.storageDurabilityLag = myQueueInfo->value.getDurabilityLag();
															#line 181 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			ssMetrics->second.cpuUsage = reply.get().cpuUsage;
															#line 182 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			ssMetrics->second.diskUsage = reply.get().diskUsage;
															#line 1673 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
		else
		{
															#line 184 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (myQueueInfo->value.valid)
															#line 1679 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 185 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				TraceEvent("RkStorageServerDidNotRespond", self->id).detail("StorageServer", ssi.id());
															#line 1683 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
															#line 187 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			myQueueInfo->value.valid = false;
															#line 1687 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 190 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(SERVER_KNOBS->METRIC_UPDATE_RATE) && IFailureMonitor::failureMonitor().onStateEqual(ssi.getQueuingMetrics.getEndpoint(), FailureStatus(false));
															#line 190 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<TrackStorageServerQueueInfoActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1693 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackStorageServerQueueInfoActor*>(this)->actor_wait_state = 2;
															#line 190 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackStorageServerQueueInfoActor, 1, Void >*>(static_cast<TrackStorageServerQueueInfoActor*>(this)));
															#line 1698 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(ErrorOr<StorageQueuingMetricsReply> && reply,int loopDepth) 
	{
															#line 170 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		Map<UID, StorageQueueInfo>::iterator myQueueInfo = self->storageQueueInfo.find(ssi.id());
															#line 171 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		ASSERT(myQueueInfo != self->storageQueueInfo.end());
															#line 172 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (reply.present())
															#line 1711 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 173 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			myQueueInfo->value.update(reply.get(), self->smoothTotalDurableBytes);
															#line 174 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			myQueueInfo->value.acceptingRequests = ssi.isAcceptingRequests();
															#line 177 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			auto ssMetrics = self->healthMetrics.storageStats.find(ssi.id());
															#line 178 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			ASSERT(ssMetrics != self->healthMetrics.storageStats.end());
															#line 179 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			ssMetrics->second.storageQueue = myQueueInfo->value.getStorageQueueBytes();
															#line 180 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			ssMetrics->second.storageDurabilityLag = myQueueInfo->value.getDurabilityLag();
															#line 181 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			ssMetrics->second.cpuUsage = reply.get().cpuUsage;
															#line 182 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			ssMetrics->second.diskUsage = reply.get().diskUsage;
															#line 1729 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
		else
		{
															#line 184 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (myQueueInfo->value.valid)
															#line 1735 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 185 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				TraceEvent("RkStorageServerDidNotRespond", self->id).detail("StorageServer", ssi.id());
															#line 1739 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
															#line 187 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			myQueueInfo->value.valid = false;
															#line 1743 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 190 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(SERVER_KNOBS->METRIC_UPDATE_RATE) && IFailureMonitor::failureMonitor().onStateEqual(ssi.getQueuingMetrics.getEndpoint(), FailureStatus(false));
															#line 190 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<TrackStorageServerQueueInfoActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1749 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackStorageServerQueueInfoActor*>(this)->actor_wait_state = 2;
															#line 190 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackStorageServerQueueInfoActor, 1, Void >*>(static_cast<TrackStorageServerQueueInfoActor*>(this)));
															#line 1754 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<StorageQueuingMetricsReply> const& reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(reply, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<StorageQueuingMetricsReply> && reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackStorageServerQueueInfoActor*>(this)->actor_wait_state > 0) static_cast<TrackStorageServerQueueInfoActor*>(this)->actor_wait_state = 0;
		static_cast<TrackStorageServerQueueInfoActor*>(this)->ActorCallback< TrackStorageServerQueueInfoActor, 0, ErrorOr<StorageQueuingMetricsReply> >::remove();

	}
	void a_callback_fire(ActorCallback< TrackStorageServerQueueInfoActor, 0, ErrorOr<StorageQueuingMetricsReply> >*,ErrorOr<StorageQueuingMetricsReply> const& value) 
	{
		fdb_probe_actor_enter("trackStorageServerQueueInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackStorageServerQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackStorageServerQueueInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackStorageServerQueueInfoActor, 0, ErrorOr<StorageQueuingMetricsReply> >*,ErrorOr<StorageQueuingMetricsReply> && value) 
	{
		fdb_probe_actor_enter("trackStorageServerQueueInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackStorageServerQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackStorageServerQueueInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackStorageServerQueueInfoActor, 0, ErrorOr<StorageQueuingMetricsReply> >*,Error err) 
	{
		fdb_probe_actor_enter("trackStorageServerQueueInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackStorageServerQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackStorageServerQueueInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TrackStorageServerQueueInfoActor*>(this)->actor_wait_state > 0) static_cast<TrackStorageServerQueueInfoActor*>(this)->actor_wait_state = 0;
		static_cast<TrackStorageServerQueueInfoActor*>(this)->ActorCallback< TrackStorageServerQueueInfoActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackStorageServerQueueInfoActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackStorageServerQueueInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackStorageServerQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackStorageServerQueueInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TrackStorageServerQueueInfoActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackStorageServerQueueInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackStorageServerQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackStorageServerQueueInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TrackStorageServerQueueInfoActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackStorageServerQueueInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackStorageServerQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackStorageServerQueueInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 158 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	ActorWeakSelfRef<Ratekeeper> self;
															#line 158 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	StorageServerInterface ssi;
															#line 1938 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
};
// This generated class is to be used only via trackStorageServerQueueInfo()
															#line 158 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class TrackStorageServerQueueInfoActor final : public Actor<Void>, public ActorCallback< TrackStorageServerQueueInfoActor, 0, ErrorOr<StorageQueuingMetricsReply> >, public ActorCallback< TrackStorageServerQueueInfoActor, 1, Void >, public FastAllocated<TrackStorageServerQueueInfoActor>, public TrackStorageServerQueueInfoActorState<TrackStorageServerQueueInfoActor> {
															#line 1943 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
	using FastAllocated<TrackStorageServerQueueInfoActor>::operator new;
	using FastAllocated<TrackStorageServerQueueInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6238783980186545408UL, 8519264100680889344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackStorageServerQueueInfoActor, 0, ErrorOr<StorageQueuingMetricsReply> >;
friend struct ActorCallback< TrackStorageServerQueueInfoActor, 1, Void >;
															#line 158 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	TrackStorageServerQueueInfoActor(ActorWeakSelfRef<Ratekeeper> const& self,StorageServerInterface const& ssi) 
															#line 1961 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		 : Actor<Void>(),
		   TrackStorageServerQueueInfoActorState<TrackStorageServerQueueInfoActor>(self, ssi),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackStorageServerQueueInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(389715280185442304UL, 187969470333841920UL);
		ActorExecutionContextHelper __helper(static_cast<TrackStorageServerQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackStorageServerQueueInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackStorageServerQueueInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackStorageServerQueueInfoActor, 0, ErrorOr<StorageQueuingMetricsReply> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TrackStorageServerQueueInfoActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 158 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
[[nodiscard]] static Future<Void> trackStorageServerQueueInfo( ActorWeakSelfRef<Ratekeeper> const& self, StorageServerInterface const& ssi ) {
															#line 158 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	return Future<Void>(new TrackStorageServerQueueInfoActor(self, ssi));
															#line 1994 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
}

#line 210 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"

	// works with ExcludeIncludeStorageServersWorkload.actor.cpp to make sure the size of SS list is bounded
																#line 2000 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
// This generated class is to be used only via monitorStorageServerQueueSizeInSimulation()
															#line 212 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
template <class MonitorStorageServerQueueSizeInSimulationActor>
															#line 212 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class MonitorStorageServerQueueSizeInSimulationActorState {
															#line 2006 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
															#line 212 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	MonitorStorageServerQueueSizeInSimulationActorState(ActorWeakSelfRef<Ratekeeper> const& self) 
															#line 212 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
															#line 212 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		 : self(self)
															#line 2013 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this));

	}
	~MonitorStorageServerQueueSizeInSimulationActorState() 
	{
		fdb_probe_actor_destroy("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 213 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (!g_network->isSimulated())
															#line 2028 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 214 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				if (!static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorStorageServerQueueSizeInSimulationActorState(); static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->destroy(); return 0; }
															#line 2032 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				new (&static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~MonitorStorageServerQueueSizeInSimulationActorState();
				static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 216 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			threshold = SERVER_KNOBS->RATEKEEPER_MONITOR_SS_THRESHOLD;
															#line 217 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			cnt = 0;
															#line 218 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			maxCount = 5;
															#line 219 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			tr = Transaction(self->db);
															#line 220 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			;
															#line 2048 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorStorageServerQueueSizeInSimulationActorState();
		static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 222 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 223 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 224 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 225 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			StrictFuture<std::vector<std::pair<StorageServerInterface, ProcessClass>>> __when_expr_0 = NativeAPI::getServerListAndProcessClasses(&tr);
															#line 225 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2087 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->actor_wait_state = 1;
															#line 225 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*>(static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)));
															#line 2092 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 254 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			TraceEvent("RateKeeperFailedToReadSSList").log();
															#line 255 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 255 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2118 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->actor_wait_state = 3;
															#line 255 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 2, Void >*>(static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)));
															#line 2123 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<std::pair<StorageServerInterface, ProcessClass>> const& results,int loopDepth) 
	{
															#line 227 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		serverListSize = results.size();
															#line 228 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		interfaceSize = self->storageServerInterfaces.size();
															#line 229 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		metricSize = self->healthMetrics.storageStats.size();
															#line 230 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (interfaceSize - serverListSize > threshold || metricSize - serverListSize > threshold)
															#line 2144 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 231 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			cnt++;
															#line 2148 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
		else
		{
															#line 233 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			cnt = 0;
															#line 2154 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 235 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (cnt > maxCount)
															#line 2158 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 236 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			TraceEvent(SevError, "TooManySSInRK") .detail("Threshold", threshold) .detail("ServerListSize", serverListSize) .detail("InterfaceSize", interfaceSize) .detail("MetricSize", metricSize) .log();
															#line 2162 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 245 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		for( const auto& [id, _] : self->storageServerInterfaces ) {
															#line 246 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			ASSERT(self->storageQueueInfo.find(id) != self->storageQueueInfo.end());
															#line 247 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			ASSERT(self->healthMetrics.storageStats.find(id) != self->healthMetrics.storageStats.end());
															#line 2170 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 251 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->RATEKEEPER_MONITOR_SS_DELAY);
															#line 251 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2176 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->actor_wait_state = 2;
															#line 251 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 1, Void >*>(static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)));
															#line 2181 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<std::pair<StorageServerInterface, ProcessClass>> && results,int loopDepth) 
	{
															#line 227 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		serverListSize = results.size();
															#line 228 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		interfaceSize = self->storageServerInterfaces.size();
															#line 229 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		metricSize = self->healthMetrics.storageStats.size();
															#line 230 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (interfaceSize - serverListSize > threshold || metricSize - serverListSize > threshold)
															#line 2196 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 231 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			cnt++;
															#line 2200 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
		else
		{
															#line 233 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			cnt = 0;
															#line 2206 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 235 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (cnt > maxCount)
															#line 2210 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 236 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			TraceEvent(SevError, "TooManySSInRK") .detail("Threshold", threshold) .detail("ServerListSize", serverListSize) .detail("InterfaceSize", interfaceSize) .detail("MetricSize", metricSize) .log();
															#line 2214 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 245 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		for( const auto& [id, _] : self->storageServerInterfaces ) {
															#line 246 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			ASSERT(self->storageQueueInfo.find(id) != self->storageQueueInfo.end());
															#line 247 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			ASSERT(self->healthMetrics.storageStats.find(id) != self->healthMetrics.storageStats.end());
															#line 2222 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 251 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->RATEKEEPER_MONITOR_SS_DELAY);
															#line 251 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2228 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->actor_wait_state = 2;
															#line 251 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 1, Void >*>(static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)));
															#line 2233 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<std::pair<StorageServerInterface, ProcessClass>> const& results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(results, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<std::pair<StorageServerInterface, ProcessClass>> && results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,std::vector<std::pair<StorageServerInterface, ProcessClass>> const& value) 
	{
		fdb_probe_actor_enter("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,std::vector<std::pair<StorageServerInterface, ProcessClass>> && value) 
	{
		fdb_probe_actor_enter("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 252 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		tr = Transaction(self->db);
															#line 2317 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 252 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		tr = Transaction(self->db);
															#line 2326 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 212 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	ActorWeakSelfRef<Ratekeeper> self;
															#line 216 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	int threshold;
															#line 217 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	int cnt;
															#line 218 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	int maxCount;
															#line 219 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Transaction tr;
															#line 227 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	int serverListSize;
															#line 228 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	int interfaceSize;
															#line 229 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	int metricSize;
															#line 2522 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
};
// This generated class is to be used only via monitorStorageServerQueueSizeInSimulation()
															#line 212 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class MonitorStorageServerQueueSizeInSimulationActor final : public Actor<Void>, public ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >, public ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 1, Void >, public ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 2, Void >, public FastAllocated<MonitorStorageServerQueueSizeInSimulationActor>, public MonitorStorageServerQueueSizeInSimulationActorState<MonitorStorageServerQueueSizeInSimulationActor> {
															#line 2527 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
	using FastAllocated<MonitorStorageServerQueueSizeInSimulationActor>::operator new;
	using FastAllocated<MonitorStorageServerQueueSizeInSimulationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17721902963405147392UL, 16745465984422873600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >;
friend struct ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 1, Void >;
friend struct ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 2, Void >;
															#line 212 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	MonitorStorageServerQueueSizeInSimulationActor(ActorWeakSelfRef<Ratekeeper> const& self) 
															#line 2546 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorStorageServerQueueSizeInSimulationActorState<MonitorStorageServerQueueSizeInSimulationActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(989421519013249024UL, 18151944036934405888UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageServerQueueSizeInSimulationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorStorageServerQueueSizeInSimulation");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorStorageServerQueueSizeInSimulation", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorStorageServerQueueSizeInSimulationActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 212 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
[[nodiscard]] static Future<Void> monitorStorageServerQueueSizeInSimulation( ActorWeakSelfRef<Ratekeeper> const& self ) {
															#line 212 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	return Future<Void>(new MonitorStorageServerQueueSizeInSimulationActor(self));
															#line 2580 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
}

#line 259 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"

																#line 2585 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
// This generated class is to be used only via trackTLogQueueInfo()
															#line 260 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
template <class TrackTLogQueueInfoActor>
															#line 260 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class TrackTLogQueueInfoActorState {
															#line 2591 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
															#line 260 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	TrackTLogQueueInfoActorState(Ratekeeper* const& self,TLogInterface const& tli) 
															#line 260 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
															#line 260 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		 : self(self),
															#line 260 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   tli(tli)
															#line 2600 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
	{
		fdb_probe_actor_create("trackTLogQueueInfo", reinterpret_cast<unsigned long>(this));

	}
	~TrackTLogQueueInfoActorState() 
	{
		fdb_probe_actor_destroy("trackTLogQueueInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 261 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self->tlogQueueInfo.insert(mapPair(tli.id(), TLogQueueInfo(tli.id())));
															#line 262 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			myQueueInfo = self->tlogQueueInfo.find(tli.id());
															#line 263 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			TraceEvent("RkTrackTLog", self->id).detail("TransactionLog", tli.id());
															#line 2619 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			try {
															#line 265 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				;
															#line 2623 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackTLogQueueInfoActorState();
		static_cast<TrackTLogQueueInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 284 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self->tlogQueueInfo.erase(myQueueInfo);
															#line 285 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 2655 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 286 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				TraceEvent("RkTrackTLogError", self->id).detail("TransactionLog", tli.id()).errorUnsuppressed(e);
															#line 2659 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
															#line 288 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2663 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 266 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<ErrorOr<TLogQueuingMetricsReply>> __when_expr_0 = tli.getQueuingMetrics.getReplyUnlessFailedFor( TLogQueuingMetricsRequest(), 0, 0);
															#line 266 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<TrackTLogQueueInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2686 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TrackTLogQueueInfoActor*>(this)->actor_wait_state = 1;
															#line 266 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackTLogQueueInfoActor, 0, ErrorOr<TLogQueuingMetricsReply> >*>(static_cast<TrackTLogQueueInfoActor*>(this)));
															#line 2691 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(ErrorOr<TLogQueuingMetricsReply> const& reply,int loopDepth) 
	{
															#line 268 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (reply.present())
															#line 2700 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 269 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			myQueueInfo->value.update(reply.get(), self->smoothTotalDurableBytes);
															#line 270 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			myQueueInfo->value.valid = true;
															#line 2706 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
		else
		{
															#line 272 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (myQueueInfo->value.valid)
															#line 2712 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 273 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				TraceEvent("RkTLogDidNotRespond", self->id).detail("TransactionLog", tli.id());
															#line 2716 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
															#line 275 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			myQueueInfo->value.valid = false;
															#line 2720 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 278 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(SERVER_KNOBS->METRIC_UPDATE_RATE) && IFailureMonitor::failureMonitor().onStateEqual(tli.getQueuingMetrics.getEndpoint(), FailureStatus(false));
															#line 278 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<TrackTLogQueueInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2726 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackTLogQueueInfoActor*>(this)->actor_wait_state = 2;
															#line 278 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackTLogQueueInfoActor, 1, Void >*>(static_cast<TrackTLogQueueInfoActor*>(this)));
															#line 2731 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(ErrorOr<TLogQueuingMetricsReply> && reply,int loopDepth) 
	{
															#line 268 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (reply.present())
															#line 2740 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 269 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			myQueueInfo->value.update(reply.get(), self->smoothTotalDurableBytes);
															#line 270 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			myQueueInfo->value.valid = true;
															#line 2746 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
		else
		{
															#line 272 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (myQueueInfo->value.valid)
															#line 2752 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 273 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				TraceEvent("RkTLogDidNotRespond", self->id).detail("TransactionLog", tli.id());
															#line 2756 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
															#line 275 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			myQueueInfo->value.valid = false;
															#line 2760 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 278 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(SERVER_KNOBS->METRIC_UPDATE_RATE) && IFailureMonitor::failureMonitor().onStateEqual(tli.getQueuingMetrics.getEndpoint(), FailureStatus(false));
															#line 278 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<TrackTLogQueueInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2766 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackTLogQueueInfoActor*>(this)->actor_wait_state = 2;
															#line 278 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackTLogQueueInfoActor, 1, Void >*>(static_cast<TrackTLogQueueInfoActor*>(this)));
															#line 2771 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<TLogQueuingMetricsReply> const& reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(reply, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<TLogQueuingMetricsReply> && reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackTLogQueueInfoActor*>(this)->actor_wait_state > 0) static_cast<TrackTLogQueueInfoActor*>(this)->actor_wait_state = 0;
		static_cast<TrackTLogQueueInfoActor*>(this)->ActorCallback< TrackTLogQueueInfoActor, 0, ErrorOr<TLogQueuingMetricsReply> >::remove();

	}
	void a_callback_fire(ActorCallback< TrackTLogQueueInfoActor, 0, ErrorOr<TLogQueuingMetricsReply> >*,ErrorOr<TLogQueuingMetricsReply> const& value) 
	{
		fdb_probe_actor_enter("trackTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackTLogQueueInfoActor, 0, ErrorOr<TLogQueuingMetricsReply> >*,ErrorOr<TLogQueuingMetricsReply> && value) 
	{
		fdb_probe_actor_enter("trackTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackTLogQueueInfoActor, 0, ErrorOr<TLogQueuingMetricsReply> >*,Error err) 
	{
		fdb_probe_actor_enter("trackTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TrackTLogQueueInfoActor*>(this)->actor_wait_state > 0) static_cast<TrackTLogQueueInfoActor*>(this)->actor_wait_state = 0;
		static_cast<TrackTLogQueueInfoActor*>(this)->ActorCallback< TrackTLogQueueInfoActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackTLogQueueInfoActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TrackTLogQueueInfoActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TrackTLogQueueInfoActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 260 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Ratekeeper* self;
															#line 260 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	TLogInterface tli;
															#line 262 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Map<UID, TLogQueueInfo>::iterator myQueueInfo;
															#line 2944 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
};
// This generated class is to be used only via trackTLogQueueInfo()
															#line 260 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class TrackTLogQueueInfoActor final : public Actor<Void>, public ActorCallback< TrackTLogQueueInfoActor, 0, ErrorOr<TLogQueuingMetricsReply> >, public ActorCallback< TrackTLogQueueInfoActor, 1, Void >, public FastAllocated<TrackTLogQueueInfoActor>, public TrackTLogQueueInfoActorState<TrackTLogQueueInfoActor> {
															#line 2949 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
	using FastAllocated<TrackTLogQueueInfoActor>::operator new;
	using FastAllocated<TrackTLogQueueInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6021917215185812224UL, 17187687087063813120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackTLogQueueInfoActor, 0, ErrorOr<TLogQueuingMetricsReply> >;
friend struct ActorCallback< TrackTLogQueueInfoActor, 1, Void >;
															#line 260 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	TrackTLogQueueInfoActor(Ratekeeper* const& self,TLogInterface const& tli) 
															#line 2967 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		 : Actor<Void>(),
		   TrackTLogQueueInfoActorState<TrackTLogQueueInfoActor>(self, tli),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackTLogQueueInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17286477797758820096UL, 14559015223109230592UL);
		ActorExecutionContextHelper __helper(static_cast<TrackTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackTLogQueueInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackTLogQueueInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackTLogQueueInfoActor, 0, ErrorOr<TLogQueuingMetricsReply> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TrackTLogQueueInfoActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 260 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
[[nodiscard]] static Future<Void> trackTLogQueueInfo( Ratekeeper* const& self, TLogInterface const& tli ) {
															#line 260 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	return Future<Void>(new TrackTLogQueueInfoActor(self, tli));
															#line 3000 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
}

#line 291 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"

																#line 3005 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
// This generated class is to be used only via trackEachStorageServer()
															#line 292 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
template <class TrackEachStorageServerActor>
															#line 292 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class TrackEachStorageServerActorState {
															#line 3011 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
															#line 292 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	TrackEachStorageServerActorState(ActorWeakSelfRef<Ratekeeper> const& self,FutureStream<std::pair<UID, Optional<StorageServerInterface>>> const& serverChanges) 
															#line 292 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
															#line 292 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		 : self(self),
															#line 292 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   serverChanges(serverChanges),
															#line 296 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   storageServerTrackers(),
															#line 297 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   err()
															#line 3024 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
	{
		fdb_probe_actor_create("trackEachStorageServer", reinterpret_cast<unsigned long>(this));

	}
	~TrackEachStorageServerActorState() 
	{
		fdb_probe_actor_destroy("trackEachStorageServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 299 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			;
															#line 3039 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackEachStorageServerActorState();
		static_cast<TrackEachStorageServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 300 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		auto __when_expr_0 = serverChanges;
															#line 3069 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<std::pair<UID, Optional<StorageServerInterface>>>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<std::pair<UID, Optional<StorageServerInterface>>>>::value, "invalid type");
															#line 299 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<TrackEachStorageServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3073 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 318 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_1 = err.getFuture();
															#line 3077 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<TrackEachStorageServerActor*>(this)->actor_wait_state = 1;
															#line 300 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< TrackEachStorageServerActor, 0, std::pair<UID, Optional<StorageServerInterface>> >*>(static_cast<TrackEachStorageServerActor*>(this)));
															#line 318 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackEachStorageServerActor, 1, Void >*>(static_cast<TrackEachStorageServerActor*>(this)));
															#line 3084 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::pair<UID, Optional<StorageServerInterface>> const& __change,int loopDepth) 
	{
															#line 300 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		change = __change;
															#line 301 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0);
															#line 301 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<TrackEachStorageServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3103 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_2.get(), loopDepth); };
		static_cast<TrackEachStorageServerActor*>(this)->actor_wait_state = 2;
															#line 301 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TrackEachStorageServerActor, 2, Void >*>(static_cast<TrackEachStorageServerActor*>(this)));
															#line 3108 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::pair<UID, Optional<StorageServerInterface>> && __change,int loopDepth) 
	{
		change = std::move(__change);
															#line 301 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0);
															#line 301 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<TrackEachStorageServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3120 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_2.get(), loopDepth); };
		static_cast<TrackEachStorageServerActor*>(this)->actor_wait_state = 2;
															#line 301 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TrackEachStorageServerActor, 2, Void >*>(static_cast<TrackEachStorageServerActor*>(this)));
															#line 3125 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackEachStorageServerActor*>(this)->actor_wait_state > 0) static_cast<TrackEachStorageServerActor*>(this)->actor_wait_state = 0;
		static_cast<TrackEachStorageServerActor*>(this)->ActorSingleCallback< TrackEachStorageServerActor, 0, std::pair<UID, Optional<StorageServerInterface>> >::remove();
		static_cast<TrackEachStorageServerActor*>(this)->ActorCallback< TrackEachStorageServerActor, 1, Void >::remove();

	}
	int a_body1loopBody1when1cont1(Void const& _,int loopDepth) 
	{
															#line 303 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		const UID& id = change.first;
															#line 304 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (change.second.present())
															#line 3155 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 305 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (!change.second.get().isTss())
															#line 3159 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 307 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				auto& a = storageServerTrackers[change.first];
															#line 308 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				a = Future<Void>();
															#line 309 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				a = splitError(trackStorageServerQueueInfo(self, change.second.get()), err);
															#line 311 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				self->storageServerInterfaces[id] = change.second.get();
															#line 3169 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
		}
		else
		{
															#line 314 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			storageServerTrackers.erase(id);
															#line 315 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self->storageServerInterfaces.erase(id);
															#line 3178 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont1(Void && _,int loopDepth) 
	{
															#line 303 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		const UID& id = change.first;
															#line 304 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (change.second.present())
															#line 3190 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 305 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (!change.second.get().isTss())
															#line 3194 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 307 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				auto& a = storageServerTrackers[change.first];
															#line 308 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				a = Future<Void>();
															#line 309 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				a = splitError(trackStorageServerQueueInfo(self, change.second.get()), err);
															#line 311 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				self->storageServerInterfaces[id] = change.second.get();
															#line 3204 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
		}
		else
		{
															#line 314 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			storageServerTrackers.erase(id);
															#line 315 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self->storageServerInterfaces.erase(id);
															#line 3213 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TrackEachStorageServerActor*>(this)->actor_wait_state > 0) static_cast<TrackEachStorageServerActor*>(this)->actor_wait_state = 0;
		static_cast<TrackEachStorageServerActor*>(this)->ActorCallback< TrackEachStorageServerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackEachStorageServerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackEachStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TrackEachStorageServerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackEachStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TrackEachStorageServerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackEachStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< TrackEachStorageServerActor, 0, std::pair<UID, Optional<StorageServerInterface>> >*,std::pair<UID, Optional<StorageServerInterface>> const& value) 
	{
		fdb_probe_actor_enter("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackEachStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< TrackEachStorageServerActor, 0, std::pair<UID, Optional<StorageServerInterface>> >*,std::pair<UID, Optional<StorageServerInterface>> && value) 
	{
		fdb_probe_actor_enter("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackEachStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< TrackEachStorageServerActor, 0, std::pair<UID, Optional<StorageServerInterface>> >*,Error err) 
	{
		fdb_probe_actor_enter("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackEachStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackEachStorageServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackEachStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TrackEachStorageServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackEachStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TrackEachStorageServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackEachStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackEachStorageServer", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 292 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	ActorWeakSelfRef<Ratekeeper> self;
															#line 292 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	FutureStream<std::pair<UID, Optional<StorageServerInterface>>> serverChanges;
															#line 296 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	std::unordered_map<UID, Future<Void>> storageServerTrackers;
															#line 297 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Promise<Void> err;
															#line 300 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	std::pair<UID, Optional<StorageServerInterface>> change;
															#line 3418 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
};
// This generated class is to be used only via trackEachStorageServer()
															#line 292 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class TrackEachStorageServerActor final : public Actor<Void>, public ActorSingleCallback< TrackEachStorageServerActor, 0, std::pair<UID, Optional<StorageServerInterface>> >, public ActorCallback< TrackEachStorageServerActor, 2, Void >, public ActorCallback< TrackEachStorageServerActor, 1, Void >, public FastAllocated<TrackEachStorageServerActor>, public TrackEachStorageServerActorState<TrackEachStorageServerActor> {
															#line 3423 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
	using FastAllocated<TrackEachStorageServerActor>::operator new;
	using FastAllocated<TrackEachStorageServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8281775599905821952UL, 159085168523523072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< TrackEachStorageServerActor, 0, std::pair<UID, Optional<StorageServerInterface>> >;
friend struct ActorCallback< TrackEachStorageServerActor, 2, Void >;
friend struct ActorCallback< TrackEachStorageServerActor, 1, Void >;
															#line 292 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	TrackEachStorageServerActor(ActorWeakSelfRef<Ratekeeper> const& self,FutureStream<std::pair<UID, Optional<StorageServerInterface>>> const& serverChanges) 
															#line 3442 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		 : Actor<Void>(),
		   TrackEachStorageServerActorState<TrackEachStorageServerActor>(self, serverChanges),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackEachStorageServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17288145185053495296UL, 2489311421014204416UL);
		ActorExecutionContextHelper __helper(static_cast<TrackEachStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackEachStorageServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackEachStorageServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< TrackEachStorageServerActor, 0, std::pair<UID, Optional<StorageServerInterface>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TrackEachStorageServerActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 292 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
[[nodiscard]] static Future<Void> trackEachStorageServer( ActorWeakSelfRef<Ratekeeper> const& self, FutureStream<std::pair<UID, Optional<StorageServerInterface>>> const& serverChanges ) {
															#line 292 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	return Future<Void>(new TrackEachStorageServerActor(self, serverChanges));
															#line 3475 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
}

#line 321 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"

																#line 3480 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
// This generated class is to be used only via monitorHotShards()
															#line 322 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
template <class MonitorHotShardsActor>
															#line 322 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class MonitorHotShardsActorState {
															#line 3486 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
															#line 322 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	MonitorHotShardsActorState(Ratekeeper* const& self,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 322 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
															#line 322 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		 : self(self),
															#line 322 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   dbInfo(dbInfo)
															#line 3495 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorHotShards", reinterpret_cast<unsigned long>(this));

	}
	~MonitorHotShardsActorState() 
	{
		fdb_probe_actor_destroy("monitorHotShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 323 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			;
															#line 3510 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorHotShardsActorState();
		static_cast<MonitorHotShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 324 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->HOT_SHARD_MONITOR_FREQUENCY);
															#line 324 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<MonitorHotShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3542 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorHotShardsActor*>(this)->actor_wait_state = 1;
															#line 324 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorHotShardsActor, 0, Void >*>(static_cast<MonitorHotShardsActor*>(this)));
															#line 3547 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 325 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (!self->ssHighWriteQueue.present())
															#line 3556 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 329 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		ssi = self->ssHighWriteQueue.get();
															#line 330 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		setReq = SetThrottledShardRequest();
															#line 3564 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		try {
															#line 334 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			GetHotShardsRequest getReq;
															#line 335 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			StrictFuture<GetHotShardsReply> __when_expr_1 = self->storageServerInterfaces[ssi].getHotShards.getReply(getReq);
															#line 335 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (static_cast<MonitorHotShardsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3572 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorHotShardsActor*>(this)->actor_wait_state = 2;
															#line 335 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorHotShardsActor, 1, GetHotShardsReply >*>(static_cast<MonitorHotShardsActor*>(this)));
															#line 3577 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 325 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (!self->ssHighWriteQueue.present())
															#line 3592 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 329 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		ssi = self->ssHighWriteQueue.get();
															#line 330 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		setReq = SetThrottledShardRequest();
															#line 3600 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		try {
															#line 334 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			GetHotShardsRequest getReq;
															#line 335 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			StrictFuture<GetHotShardsReply> __when_expr_1 = self->storageServerInterfaces[ssi].getHotShards.getReply(getReq);
															#line 335 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (static_cast<MonitorHotShardsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3608 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorHotShardsActor*>(this)->actor_wait_state = 2;
															#line 335 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorHotShardsActor, 1, GetHotShardsReply >*>(static_cast<MonitorHotShardsActor*>(this)));
															#line 3613 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorHotShardsActor*>(this)->actor_wait_state > 0) static_cast<MonitorHotShardsActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorHotShardsActor*>(this)->ActorCallback< MonitorHotShardsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorHotShardsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorHotShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHotShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHotShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorHotShardsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorHotShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHotShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHotShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorHotShardsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorHotShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHotShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHotShards", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 351 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (!setReq.throttledShards.size())
															#line 3703 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 354 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		setReq.expirationTime = now() + SERVER_KNOBS->HOT_SHARD_THROTTLING_EXPIRE_AFTER;
															#line 355 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		for( auto& shard : setReq.throttledShards ) {
															#line 356 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			TraceEvent(SevInfo, "SendRequestThrottleHotShard") .detail("Shard", shard) .detail("DelayUntil", setReq.expirationTime);
															#line 3713 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 360 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		for( const auto& cpi : dbInfo->get().client.commitProxies ) {
															#line 361 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			cpi.setThrottledShard.send(setReq);
															#line 3719 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 348 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			TraceEvent(SevWarn, "CannotMonitorHotShardForSS").detail("SS", ssi);
															#line 3730 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(GetHotShardsReply const& reply,int loopDepth) 
	{
															#line 339 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		KeyRangeRef applyMutationRange("\xfe\xff\xfe"_sr, "\xfe\xff\xff\xff"_sr);
															#line 340 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		for( const auto& shard : reply.hotShards ) {
															#line 341 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (!shard.intersects(applyMutationRange))
															#line 3749 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 342 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				setReq.throttledShards.push_back(shard);
															#line 3753 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
			else
			{
															#line 344 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				TraceEvent("IgnoreHotShard").detail("Shard", shard);
															#line 3759 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(GetHotShardsReply && reply,int loopDepth) 
	{
															#line 339 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		KeyRangeRef applyMutationRange("\xfe\xff\xfe"_sr, "\xfe\xff\xff\xff"_sr);
															#line 340 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		for( const auto& shard : reply.hotShards ) {
															#line 341 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (!shard.intersects(applyMutationRange))
															#line 3774 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 342 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				setReq.throttledShards.push_back(shard);
															#line 3778 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
			else
			{
															#line 344 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				TraceEvent("IgnoreHotShard").detail("Shard", shard);
															#line 3784 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(GetHotShardsReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(reply, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(GetHotShardsReply && reply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorHotShardsActor*>(this)->actor_wait_state > 0) static_cast<MonitorHotShardsActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorHotShardsActor*>(this)->ActorCallback< MonitorHotShardsActor, 1, GetHotShardsReply >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorHotShardsActor, 1, GetHotShardsReply >*,GetHotShardsReply const& value) 
	{
		fdb_probe_actor_enter("monitorHotShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHotShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHotShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorHotShardsActor, 1, GetHotShardsReply >*,GetHotShardsReply && value) 
	{
		fdb_probe_actor_enter("monitorHotShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHotShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHotShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorHotShardsActor, 1, GetHotShardsReply >*,Error err) 
	{
		fdb_probe_actor_enter("monitorHotShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHotShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHotShards", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 322 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Ratekeeper* self;
															#line 322 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 329 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	UID ssi;
															#line 330 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	SetThrottledShardRequest setReq;
															#line 3887 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
};
// This generated class is to be used only via monitorHotShards()
															#line 322 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class MonitorHotShardsActor final : public Actor<Void>, public ActorCallback< MonitorHotShardsActor, 0, Void >, public ActorCallback< MonitorHotShardsActor, 1, GetHotShardsReply >, public FastAllocated<MonitorHotShardsActor>, public MonitorHotShardsActorState<MonitorHotShardsActor> {
															#line 3892 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
	using FastAllocated<MonitorHotShardsActor>::operator new;
	using FastAllocated<MonitorHotShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12106294906652053504UL, 7079207486720580352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorHotShardsActor, 0, Void >;
friend struct ActorCallback< MonitorHotShardsActor, 1, GetHotShardsReply >;
															#line 322 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	MonitorHotShardsActor(Ratekeeper* const& self,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 3910 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorHotShardsActorState<MonitorHotShardsActor>(self, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorHotShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9296355628883185664UL, 17029230520982449152UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHotShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorHotShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorHotShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorHotShardsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorHotShardsActor, 1, GetHotShardsReply >*)0, actor_cancelled()); break;
		}

	}
};
															#line 322 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
[[nodiscard]] static Future<Void> monitorHotShards( Ratekeeper* const& self, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 322 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	return Future<Void>(new MonitorHotShardsActor(self, dbInfo));
															#line 3943 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
}

#line 365 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"

																#line 3948 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
// This generated class is to be used only via run()
															#line 366 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
template <class RunActor>
															#line 366 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class RunActorState {
															#line 3954 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
															#line 366 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	RunActorState(RatekeeperInterface const& rkInterf,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 366 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
															#line 366 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		 : rkInterf(rkInterf),
															#line 366 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   dbInfo(dbInfo),
															#line 367 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   pSelf(new Ratekeeper(rkInterf.id(), openDBOnServer(dbInfo, TaskPriority::DefaultEndpoint, LockAware::True))),
															#line 369 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   self(*pSelf),
															#line 370 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   timeout(Void()),
															#line 371 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   tlogTrackers(),
															#line 372 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   tlogInterfs(),
															#line 373 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   err(),
															#line 374 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   collection(actorCollection(self.addActor.getFuture()))
															#line 3977 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
	{
		fdb_probe_actor_create("run", reinterpret_cast<unsigned long>(this));

	}
	~RunActorState() 
	{
		fdb_probe_actor_destroy("run", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 376 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			TraceEvent("RatekeeperStarting", rkInterf.id());
															#line 377 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.addActor.send(waitFailureServer(rkInterf.waitFailure.getFuture()));
															#line 378 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.addActor.send(self.configurationMonitor());
															#line 380 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			PromiseStream<std::pair<UID, Optional<StorageServerInterface>>> serverChanges;
															#line 381 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.addActor.send(self.monitorServerListChange(serverChanges));
															#line 382 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.addActor.send(RatekeeperImpl::trackEachStorageServer(pSelf, serverChanges.getFuture()));
															#line 383 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.addActor.send(monitorStorageServerQueueSizeInSimulation(pSelf));
															#line 384 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.addActor.send(traceRole(Role::RATEKEEPER, rkInterf.id()));
															#line 386 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.addActor.send(self.monitorThrottlingChanges());
															#line 388 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (SERVER_KNOBS->HOT_SHARD_THROTTLING_ENABLED)
															#line 4010 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 389 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				self.addActor.send(self.monitorHotShards(dbInfo));
															#line 4014 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
															#line 392 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.addActor.send(self.refreshStorageServerCommitCosts());
															#line 394 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			TraceEvent("RkTLogQueueSizeParameters", rkInterf.id()) .detail("Target", SERVER_KNOBS->TARGET_BYTES_PER_TLOG) .detail("Spring", SERVER_KNOBS->SPRING_BYTES_TLOG) .detail( "Rate", (SERVER_KNOBS->TARGET_BYTES_PER_TLOG - SERVER_KNOBS->SPRING_BYTES_TLOG) / ((((double)SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS) / SERVER_KNOBS->VERSIONS_PER_SECOND) + 2.0));
															#line 403 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			TraceEvent("RkStorageServerQueueSizeParameters", rkInterf.id()) .detail("Target", SERVER_KNOBS->TARGET_BYTES_PER_STORAGE_SERVER) .detail("Spring", SERVER_KNOBS->SPRING_BYTES_STORAGE_SERVER) .detail("EBrake", SERVER_KNOBS->STORAGE_HARD_LIMIT_BYTES) .detail( "Rate", (SERVER_KNOBS->TARGET_BYTES_PER_STORAGE_SERVER - SERVER_KNOBS->SPRING_BYTES_STORAGE_SERVER) / ((((double)SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS) / SERVER_KNOBS->VERSIONS_PER_SECOND) + 2.0));
															#line 413 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			tlogInterfs = dbInfo->get().logSystemConfig.allLocalLogs();
															#line 414 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			tlogTrackers.reserve(tlogInterfs.size());
															#line 415 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			for(int i = 0;i < tlogInterfs.size();i++) {
															#line 416 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				tlogTrackers.push_back(splitError(self.trackTLogQueueInfo(tlogInterfs[i]), err));
															#line 4030 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
															#line 419 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.remoteDC = dbInfo->get().logSystemConfig.getRemoteDcId();
															#line 421 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			recovering = dbInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS;
															#line 422 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			recoveryVersion = std::numeric_limits<Version>::max();
															#line 423 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (recovering)
															#line 4040 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 424 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				self.version_recovery[recoveryVersion] = std::make_pair(now(), Optional<double>());
															#line 4044 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
			try {
															#line 428 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				lastLimited = false;
															#line 429 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				;
															#line 4051 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunActorState();
		static_cast<RunActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 577 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 4080 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& err,int loopDepth=0) 
	{
		try {
															#line 575 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			TraceEvent("RatekeeperDied", rkInterf.id()).errorUnsuppressed(err);
															#line 4093 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 430 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_0 = timeout;
															#line 429 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4123 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 459 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		auto __when_expr_1 = rkInterf.getRateInfo.getFuture();
															#line 4127 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<GetRateInfoRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<GetRateInfoRequest>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 523 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		auto __when_expr_2 = rkInterf.haltRatekeeper.getFuture();
															#line 4132 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<HaltRatekeeperRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<HaltRatekeeperRequest>>::value, "invalid type");
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 528 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		auto __when_expr_3 = rkInterf.reportCommitCostEstimation.getFuture();
															#line 4137 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<ReportCommitCostEstimationRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<ReportCommitCostEstimationRequest>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.pop(), loopDepth); };
															#line 533 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		auto __when_expr_4 = rkInterf.getSSVersionLag.getFuture();
															#line 4142 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<GetSSVersionLagRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<GetSSVersionLagRequest>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.pop(), loopDepth); };
															#line 538 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_5 = err.getFuture();
															#line 4147 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when6(__when_expr_5.get(), loopDepth); };
															#line 539 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_6 = dbInfo->onChange();
															#line 4151 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when7(__when_expr_6.get(), loopDepth); };
															#line 569 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_7 = collection;
															#line 4155 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch2(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when8(__when_expr_7.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 1;
															#line 430 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunActor, 0, Void >*>(static_cast<RunActor*>(this)));
															#line 459 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 1, GetRateInfoRequest >*>(static_cast<RunActor*>(this)));
															#line 523 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 2, HaltRatekeeperRequest >*>(static_cast<RunActor*>(this)));
															#line 528 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 3, ReportCommitCostEstimationRequest >*>(static_cast<RunActor*>(this)));
															#line 533 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 4, GetSSVersionLagRequest >*>(static_cast<RunActor*>(this)));
															#line 538 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunActor, 5, Void >*>(static_cast<RunActor*>(this)));
															#line 539 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunActor, 6, Void >*>(static_cast<RunActor*>(this)));
															#line 569 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunActor, 7, Void >*>(static_cast<RunActor*>(this)));
															#line 4174 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 431 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		double actualTps = self.smoothReleasedTransactions.smoothRate();
															#line 432 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		actualTps = std::max(std::max(1.0, actualTps), self.smoothTotalDurableBytes.smoothRate() / CLIENT_KNOBS->TRANSACTION_SIZE_LIMIT);
															#line 436 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (self.actualTpsHistory.size() > SERVER_KNOBS->MAX_TPS_HISTORY_SAMPLES)
															#line 4206 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 437 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.actualTpsHistory.pop_front();
															#line 4210 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 439 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self.actualTpsHistory.push_back(actualTps);
															#line 441 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		for(;self.version_recovery.size() > CLIENT_KNOBS->MAX_GENERATIONS;) {
															#line 442 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.version_recovery.erase(self.version_recovery.begin());
															#line 4218 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 445 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self.updateRate(&self.normalLimits);
															#line 446 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self.updateRate(&self.batchLimits);
															#line 448 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		lastLimited = self.smoothReleasedTransactions.smoothRate() > SERVER_KNOBS->LAST_LIMITED_RATIO * self.batchLimits.tpsLimit;
															#line 450 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		double tooOld = now() - 1.0;
															#line 451 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		for(auto p = self.grvProxyInfo.begin();p != self.grvProxyInfo.end();) {
															#line 452 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (p->second.lastUpdateTime < tooOld)
															#line 4232 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 453 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				p = self.grvProxyInfo.erase(p);
															#line 4236 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
			else
			{
															#line 455 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				++p;
															#line 4242 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
		}
															#line 457 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		timeout = delayJittered(SERVER_KNOBS->METRIC_UPDATE_RATE);
															#line 4247 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 431 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		double actualTps = self.smoothReleasedTransactions.smoothRate();
															#line 432 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		actualTps = std::max(std::max(1.0, actualTps), self.smoothTotalDurableBytes.smoothRate() / CLIENT_KNOBS->TRANSACTION_SIZE_LIMIT);
															#line 436 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (self.actualTpsHistory.size() > SERVER_KNOBS->MAX_TPS_HISTORY_SAMPLES)
															#line 4260 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 437 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.actualTpsHistory.pop_front();
															#line 4264 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 439 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self.actualTpsHistory.push_back(actualTps);
															#line 441 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		for(;self.version_recovery.size() > CLIENT_KNOBS->MAX_GENERATIONS;) {
															#line 442 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.version_recovery.erase(self.version_recovery.begin());
															#line 4272 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 445 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self.updateRate(&self.normalLimits);
															#line 446 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self.updateRate(&self.batchLimits);
															#line 448 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		lastLimited = self.smoothReleasedTransactions.smoothRate() > SERVER_KNOBS->LAST_LIMITED_RATIO * self.batchLimits.tpsLimit;
															#line 450 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		double tooOld = now() - 1.0;
															#line 451 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		for(auto p = self.grvProxyInfo.begin();p != self.grvProxyInfo.end();) {
															#line 452 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (p->second.lastUpdateTime < tooOld)
															#line 4286 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 453 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				p = self.grvProxyInfo.erase(p);
															#line 4290 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
			else
			{
															#line 455 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				++p;
															#line 4296 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
		}
															#line 457 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		timeout = delayJittered(SERVER_KNOBS->METRIC_UPDATE_RATE);
															#line 4301 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetRateInfoRequest const& req,int loopDepth) 
	{
															#line 460 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		GetRateInfoReply reply;
															#line 462 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		auto& p = self.grvProxyInfo[req.requesterID];
															#line 464 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (p.totalTransactions > 0)
															#line 4314 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 465 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.smoothReleasedTransactions.addDelta(req.totalReleasedTransactions - p.totalTransactions);
															#line 467 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			for( auto const& [tag, count] : req.throttledTagCounts ) {
															#line 468 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				self.tagThrottler->addRequests(tag, count);
															#line 4322 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
		}
															#line 471 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (p.batchTransactions > 0)
															#line 4327 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 472 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.smoothBatchReleasedTransactions.addDelta(req.batchReleasedTransactions - p.batchTransactions);
															#line 4331 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 476 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		p.totalTransactions = req.totalReleasedTransactions;
															#line 477 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		p.batchTransactions = req.batchReleasedTransactions;
															#line 478 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		p.version = req.version;
															#line 479 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self.maxVersion = std::max(self.maxVersion, req.version);
															#line 481 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (recoveryVersion == std::numeric_limits<Version>::max() && self.version_recovery.contains(recoveryVersion))
															#line 4343 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 483 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			recoveryVersion = self.maxVersion;
															#line 484 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.version_recovery[recoveryVersion] = self.version_recovery[std::numeric_limits<Version>::max()];
															#line 486 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.version_recovery.erase(std::numeric_limits<Version>::max());
															#line 4351 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 489 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		p.lastUpdateTime = now();
															#line 491 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		reply.transactionRate = self.normalLimits.tpsLimit / self.grvProxyInfo.size();
															#line 492 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		reply.batchTransactionRate = self.batchLimits.tpsLimit / self.grvProxyInfo.size();
															#line 493 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		reply.leaseDuration = SERVER_KNOBS->METRIC_UPDATE_RATE;
															#line 495 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (p.lastThrottledTagChangeId != self.tagThrottler->getThrottledTagChangeId() || now() > p.lastTagPushTime + SERVER_KNOBS->TAG_THROTTLE_PUSH_INTERVAL)
															#line 4363 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 497 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			p.lastThrottledTagChangeId = self.tagThrottler->getThrottledTagChangeId();
															#line 498 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			p.lastTagPushTime = now();
															#line 500 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			bool returningTagsToProxy{ false };
															#line 501 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (SERVER_KNOBS->ENFORCE_TAG_THROTTLING_ON_PROXIES)
															#line 4373 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 502 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				auto proxyThrottledTags = self.tagThrottler->getProxyRates(self.grvProxyInfo.size());
															#line 503 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				if (!SERVER_KNOBS->GLOBAL_TAG_THROTTLING_REPORT_ONLY)
															#line 4379 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				{
															#line 504 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
					returningTagsToProxy = proxyThrottledTags.size() > 0;
															#line 505 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
					reply.proxyThrottledTags = std::move(proxyThrottledTags);
															#line 4385 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				}
			}
			else
			{
															#line 508 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				auto clientThrottledTags = self.tagThrottler->getClientRates();
															#line 509 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				if (!SERVER_KNOBS->GLOBAL_TAG_THROTTLING_REPORT_ONLY)
															#line 4394 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				{
															#line 510 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
					returningTagsToProxy = clientThrottledTags.size() > 0;
															#line 511 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
					reply.clientThrottledTags = std::move(clientThrottledTags);
															#line 4400 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				}
			}
															#line 514 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			CODE_PROBE(returningTagsToProxy, "Returning tag throttles to a proxy");
															#line 4405 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 517 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		reply.healthMetrics.update(self.healthMetrics, true, req.detailed);
															#line 518 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		reply.healthMetrics.tpsLimit = self.normalLimits.tpsLimit;
															#line 519 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		reply.healthMetrics.batchLimited = lastLimited;
															#line 521 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		req.reply.send(reply);
															#line 4415 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetRateInfoRequest && req,int loopDepth) 
	{
															#line 460 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		GetRateInfoReply reply;
															#line 462 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		auto& p = self.grvProxyInfo[req.requesterID];
															#line 464 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (p.totalTransactions > 0)
															#line 4428 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 465 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.smoothReleasedTransactions.addDelta(req.totalReleasedTransactions - p.totalTransactions);
															#line 467 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			for( auto const& [tag, count] : req.throttledTagCounts ) {
															#line 468 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				self.tagThrottler->addRequests(tag, count);
															#line 4436 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
		}
															#line 471 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (p.batchTransactions > 0)
															#line 4441 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 472 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.smoothBatchReleasedTransactions.addDelta(req.batchReleasedTransactions - p.batchTransactions);
															#line 4445 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 476 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		p.totalTransactions = req.totalReleasedTransactions;
															#line 477 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		p.batchTransactions = req.batchReleasedTransactions;
															#line 478 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		p.version = req.version;
															#line 479 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self.maxVersion = std::max(self.maxVersion, req.version);
															#line 481 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (recoveryVersion == std::numeric_limits<Version>::max() && self.version_recovery.contains(recoveryVersion))
															#line 4457 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 483 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			recoveryVersion = self.maxVersion;
															#line 484 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.version_recovery[recoveryVersion] = self.version_recovery[std::numeric_limits<Version>::max()];
															#line 486 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.version_recovery.erase(std::numeric_limits<Version>::max());
															#line 4465 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 489 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		p.lastUpdateTime = now();
															#line 491 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		reply.transactionRate = self.normalLimits.tpsLimit / self.grvProxyInfo.size();
															#line 492 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		reply.batchTransactionRate = self.batchLimits.tpsLimit / self.grvProxyInfo.size();
															#line 493 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		reply.leaseDuration = SERVER_KNOBS->METRIC_UPDATE_RATE;
															#line 495 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (p.lastThrottledTagChangeId != self.tagThrottler->getThrottledTagChangeId() || now() > p.lastTagPushTime + SERVER_KNOBS->TAG_THROTTLE_PUSH_INTERVAL)
															#line 4477 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 497 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			p.lastThrottledTagChangeId = self.tagThrottler->getThrottledTagChangeId();
															#line 498 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			p.lastTagPushTime = now();
															#line 500 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			bool returningTagsToProxy{ false };
															#line 501 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (SERVER_KNOBS->ENFORCE_TAG_THROTTLING_ON_PROXIES)
															#line 4487 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 502 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				auto proxyThrottledTags = self.tagThrottler->getProxyRates(self.grvProxyInfo.size());
															#line 503 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				if (!SERVER_KNOBS->GLOBAL_TAG_THROTTLING_REPORT_ONLY)
															#line 4493 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				{
															#line 504 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
					returningTagsToProxy = proxyThrottledTags.size() > 0;
															#line 505 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
					reply.proxyThrottledTags = std::move(proxyThrottledTags);
															#line 4499 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				}
			}
			else
			{
															#line 508 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				auto clientThrottledTags = self.tagThrottler->getClientRates();
															#line 509 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				if (!SERVER_KNOBS->GLOBAL_TAG_THROTTLING_REPORT_ONLY)
															#line 4508 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				{
															#line 510 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
					returningTagsToProxy = clientThrottledTags.size() > 0;
															#line 511 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
					reply.clientThrottledTags = std::move(clientThrottledTags);
															#line 4514 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
				}
			}
															#line 514 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			CODE_PROBE(returningTagsToProxy, "Returning tag throttles to a proxy");
															#line 4519 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 517 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		reply.healthMetrics.update(self.healthMetrics, true, req.detailed);
															#line 518 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		reply.healthMetrics.tpsLimit = self.normalLimits.tpsLimit;
															#line 519 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		reply.healthMetrics.batchLimited = lastLimited;
															#line 521 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		req.reply.send(reply);
															#line 4529 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(HaltRatekeeperRequest const& req,int loopDepth) 
	{
															#line 524 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		req.reply.send(Void());
															#line 525 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		TraceEvent("RatekeeperHalted", rkInterf.id()).detail("ReqID", req.requesterID);
															#line 4540 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when3(HaltRatekeeperRequest && req,int loopDepth) 
	{
															#line 524 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		req.reply.send(Void());
															#line 525 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		TraceEvent("RatekeeperHalted", rkInterf.id()).detail("ReqID", req.requesterID);
															#line 4551 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when4(ReportCommitCostEstimationRequest const& req,int loopDepth) 
	{
															#line 530 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self.updateCommitCostEstimation(req.ssTrTagCommitCost);
															#line 531 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		req.reply.send(Void());
															#line 4562 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(ReportCommitCostEstimationRequest && req,int loopDepth) 
	{
															#line 530 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self.updateCommitCostEstimation(req.ssTrTagCommitCost);
															#line 531 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		req.reply.send(Void());
															#line 4573 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(GetSSVersionLagRequest const& req,int loopDepth) 
	{
															#line 534 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		GetSSVersionLagReply reply;
															#line 535 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self.getSSVersionLag(reply.maxPrimarySSVersion, reply.maxRemoteSSVersion);
															#line 536 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		req.reply.send(reply);
															#line 4586 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(GetSSVersionLagRequest && req,int loopDepth) 
	{
															#line 534 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		GetSSVersionLagReply reply;
															#line 535 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self.getSSVersionLag(reply.maxPrimarySSVersion, reply.maxRemoteSSVersion);
															#line 536 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		req.reply.send(reply);
															#line 4599 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(Void const& _,int loopDepth) 
	{
															#line 540 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (!recovering && dbInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS)
															#line 4620 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 541 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			recovering = true;
															#line 542 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			recoveryVersion = self.maxVersion;
															#line 543 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (recoveryVersion == 0)
															#line 4628 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 544 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				recoveryVersion = std::numeric_limits<Version>::max();
															#line 4632 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
															#line 546 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (self.version_recovery.contains(recoveryVersion))
															#line 4636 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 547 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				auto& it = self.version_recovery[recoveryVersion];
															#line 548 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				double existingEnd = it.second.present() ? it.second.get() : now();
															#line 549 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				double existingDuration = existingEnd - it.first;
															#line 550 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				self.version_recovery[recoveryVersion] = std::make_pair(now() - existingDuration, Optional<double>());
															#line 4646 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
			else
			{
															#line 553 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				self.version_recovery[recoveryVersion] = std::make_pair(now(), Optional<double>());
															#line 4652 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
		}
															#line 556 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (recovering && dbInfo->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS)
															#line 4657 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 557 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			recovering = false;
															#line 558 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.version_recovery[recoveryVersion].second = now();
															#line 4663 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 561 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (tlogInterfs != dbInfo->get().logSystemConfig.allLocalLogs())
															#line 4667 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 562 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			tlogInterfs = dbInfo->get().logSystemConfig.allLocalLogs();
															#line 563 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			tlogTrackers = std::vector<Future<Void>>();
															#line 564 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			for(int i = 0;i < tlogInterfs.size();i++) {
															#line 565 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				tlogTrackers.push_back(splitError(self.trackTLogQueueInfo(tlogInterfs[i]), err));
															#line 4677 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
		}
															#line 567 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self.remoteDC = dbInfo->get().logSystemConfig.getRemoteDcId();
															#line 4682 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(Void && _,int loopDepth) 
	{
															#line 540 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (!recovering && dbInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS)
															#line 4691 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 541 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			recovering = true;
															#line 542 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			recoveryVersion = self.maxVersion;
															#line 543 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (recoveryVersion == 0)
															#line 4699 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 544 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				recoveryVersion = std::numeric_limits<Version>::max();
															#line 4703 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
															#line 546 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (self.version_recovery.contains(recoveryVersion))
															#line 4707 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			{
															#line 547 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				auto& it = self.version_recovery[recoveryVersion];
															#line 548 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				double existingEnd = it.second.present() ? it.second.get() : now();
															#line 549 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				double existingDuration = existingEnd - it.first;
															#line 550 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				self.version_recovery[recoveryVersion] = std::make_pair(now() - existingDuration, Optional<double>());
															#line 4717 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
			else
			{
															#line 553 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				self.version_recovery[recoveryVersion] = std::make_pair(now(), Optional<double>());
															#line 4723 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
		}
															#line 556 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (recovering && dbInfo->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS)
															#line 4728 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 557 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			recovering = false;
															#line 558 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			self.version_recovery[recoveryVersion].second = now();
															#line 4734 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
															#line 561 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (tlogInterfs != dbInfo->get().logSystemConfig.allLocalLogs())
															#line 4738 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		{
															#line 562 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			tlogInterfs = dbInfo->get().logSystemConfig.allLocalLogs();
															#line 563 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			tlogTrackers = std::vector<Future<Void>>();
															#line 564 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			for(int i = 0;i < tlogInterfs.size();i++) {
															#line 565 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
				tlogTrackers.push_back(splitError(self.trackTLogQueueInfo(tlogInterfs[i]), err));
															#line 4748 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			}
		}
															#line 567 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		self.remoteDC = dbInfo->get().logSystemConfig.getRemoteDcId();
															#line 4753 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when8(Void const& _,int loopDepth) 
	{
															#line 570 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		ASSERT(false);
															#line 571 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		return a_body1Catch2(internal_error(), std::max(0, loopDepth - 1));
															#line 4764 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1when8(Void && _,int loopDepth) 
	{
															#line 570 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		ASSERT(false);
															#line 571 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		return a_body1Catch2(internal_error(), std::max(0, loopDepth - 1));
															#line 4774 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 0, Void >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 1, GetRateInfoRequest >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 2, HaltRatekeeperRequest >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 3, ReportCommitCostEstimationRequest >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 4, GetSSVersionLagRequest >::remove();
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 5, Void >::remove();
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 6, Void >::remove();
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 1, GetRateInfoRequest >*,GetRateInfoRequest const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 1, GetRateInfoRequest >*,GetRateInfoRequest && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 1, GetRateInfoRequest >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 2, HaltRatekeeperRequest >*,HaltRatekeeperRequest const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 2, HaltRatekeeperRequest >*,HaltRatekeeperRequest && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 2, HaltRatekeeperRequest >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 3, ReportCommitCostEstimationRequest >*,ReportCommitCostEstimationRequest const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 3, ReportCommitCostEstimationRequest >*,ReportCommitCostEstimationRequest && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 3, ReportCommitCostEstimationRequest >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 4, GetSSVersionLagRequest >*,GetSSVersionLagRequest const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 4, GetSSVersionLagRequest >*,GetSSVersionLagRequest && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 4, GetSSVersionLagRequest >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RunActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RunActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RunActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 366 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	RatekeeperInterface rkInterf;
															#line 366 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 367 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	ActorOwningSelfRef<Ratekeeper> pSelf;
															#line 369 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Ratekeeper& self;
															#line 370 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Future<Void> timeout;
															#line 371 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	std::vector<Future<Void>> tlogTrackers;
															#line 372 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	std::vector<TLogInterface> tlogInterfs;
															#line 373 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Promise<Void> err;
															#line 374 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Future<Void> collection;
															#line 421 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	bool recovering;
															#line 422 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Version recoveryVersion;
															#line 428 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	bool lastLimited;
															#line 5284 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
};
// This generated class is to be used only via run()
															#line 366 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class RunActor final : public Actor<Void>, public ActorCallback< RunActor, 0, Void >, public ActorSingleCallback< RunActor, 1, GetRateInfoRequest >, public ActorSingleCallback< RunActor, 2, HaltRatekeeperRequest >, public ActorSingleCallback< RunActor, 3, ReportCommitCostEstimationRequest >, public ActorSingleCallback< RunActor, 4, GetSSVersionLagRequest >, public ActorCallback< RunActor, 5, Void >, public ActorCallback< RunActor, 6, Void >, public ActorCallback< RunActor, 7, Void >, public FastAllocated<RunActor>, public RunActorState<RunActor> {
															#line 5289 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
	using FastAllocated<RunActor>::operator new;
	using FastAllocated<RunActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17702322683734625280UL, 2184350787204528640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunActor, 0, Void >;
friend struct ActorSingleCallback< RunActor, 1, GetRateInfoRequest >;
friend struct ActorSingleCallback< RunActor, 2, HaltRatekeeperRequest >;
friend struct ActorSingleCallback< RunActor, 3, ReportCommitCostEstimationRequest >;
friend struct ActorSingleCallback< RunActor, 4, GetSSVersionLagRequest >;
friend struct ActorCallback< RunActor, 5, Void >;
friend struct ActorCallback< RunActor, 6, Void >;
friend struct ActorCallback< RunActor, 7, Void >;
															#line 366 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	RunActor(RatekeeperInterface const& rkInterf,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 5313 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		 : Actor<Void>(),
		   RunActorState<RunActor>(rkInterf, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(633236942609902848UL, 16810589115111353856UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("run");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 366 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
[[nodiscard]] static Future<Void> run( RatekeeperInterface const& rkInterf, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 366 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	return Future<Void>(new RunActor(rkInterf, dbInfo));
															#line 5345 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
}

#line 579 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"

																#line 5350 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
// This generated class is to be used only via refreshStorageServerCommitCosts()
															#line 580 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
template <class RefreshStorageServerCommitCostsActor>
															#line 580 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class RefreshStorageServerCommitCostsActorState {
															#line 5356 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
															#line 580 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	RefreshStorageServerCommitCostsActorState(Ratekeeper* const& self) 
															#line 580 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
															#line 580 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		 : self(self),
															#line 581 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   lastBusiestCommitTagPick(),
															#line 582 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   replies()
															#line 5367 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
	{
		fdb_probe_actor_create("refreshStorageServerCommitCosts", reinterpret_cast<unsigned long>(this));

	}
	~RefreshStorageServerCommitCostsActorState() 
	{
		fdb_probe_actor_destroy("refreshStorageServerCommitCosts", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 583 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			;
															#line 5382 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RefreshStorageServerCommitCostsActorState();
		static_cast<RefreshStorageServerCommitCostsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 584 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		lastBusiestCommitTagPick = now();
															#line 585 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->TAG_MEASUREMENT_INTERVAL);
															#line 585 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (static_cast<RefreshStorageServerCommitCostsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5416 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RefreshStorageServerCommitCostsActor*>(this)->actor_wait_state = 1;
															#line 585 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RefreshStorageServerCommitCostsActor, 0, Void >*>(static_cast<RefreshStorageServerCommitCostsActor*>(this)));
															#line 5421 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 587 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		replies.clear();
															#line 589 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		double elapsed = now() - lastBusiestCommitTagPick;
															#line 591 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		for( auto& [ssId, ssQueueInfo] : self->storageQueueInfo ) {
															#line 594 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			replies.push_back(self->storageServerInterfaces[ssId].updateCommitCostRequest.getReply( ssQueueInfo.refreshCommitCost(elapsed)));
															#line 5436 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 587 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		replies.clear();
															#line 589 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		double elapsed = now() - lastBusiestCommitTagPick;
															#line 591 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		for( auto& [ssId, ssQueueInfo] : self->storageQueueInfo ) {
															#line 594 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			replies.push_back(self->storageServerInterfaces[ssId].updateCommitCostRequest.getReply( ssQueueInfo.refreshCommitCost(elapsed)));
															#line 5452 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RefreshStorageServerCommitCostsActor*>(this)->actor_wait_state > 0) static_cast<RefreshStorageServerCommitCostsActor*>(this)->actor_wait_state = 0;
		static_cast<RefreshStorageServerCommitCostsActor*>(this)->ActorCallback< RefreshStorageServerCommitCostsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RefreshStorageServerCommitCostsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("refreshStorageServerCommitCosts", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshStorageServerCommitCostsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshStorageServerCommitCosts", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RefreshStorageServerCommitCostsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("refreshStorageServerCommitCosts", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshStorageServerCommitCostsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshStorageServerCommitCosts", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RefreshStorageServerCommitCostsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("refreshStorageServerCommitCosts", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshStorageServerCommitCostsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshStorageServerCommitCosts", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 580 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Ratekeeper* self;
															#line 581 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	double lastBusiestCommitTagPick;
															#line 582 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	std::vector<Future<Void>> replies;
															#line 5539 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
};
// This generated class is to be used only via refreshStorageServerCommitCosts()
															#line 580 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class RefreshStorageServerCommitCostsActor final : public Actor<Void>, public ActorCallback< RefreshStorageServerCommitCostsActor, 0, Void >, public FastAllocated<RefreshStorageServerCommitCostsActor>, public RefreshStorageServerCommitCostsActorState<RefreshStorageServerCommitCostsActor> {
															#line 5544 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
	using FastAllocated<RefreshStorageServerCommitCostsActor>::operator new;
	using FastAllocated<RefreshStorageServerCommitCostsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6837513121636649472UL, 3517094773972896768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RefreshStorageServerCommitCostsActor, 0, Void >;
															#line 580 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	RefreshStorageServerCommitCostsActor(Ratekeeper* const& self) 
															#line 5561 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		 : Actor<Void>(),
		   RefreshStorageServerCommitCostsActorState<RefreshStorageServerCommitCostsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("refreshStorageServerCommitCosts", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5261075080494362368UL, 11083897965992787968UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshStorageServerCommitCostsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("refreshStorageServerCommitCosts");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("refreshStorageServerCommitCosts", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RefreshStorageServerCommitCostsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 580 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
[[nodiscard]] static Future<Void> refreshStorageServerCommitCosts( Ratekeeper* const& self ) {
															#line 580 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	return Future<Void>(new RefreshStorageServerCommitCostsActor(self));
															#line 5593 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
}

#line 599 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
}; // class RatekeeperImpl

Future<Void> Ratekeeper::configurationMonitor() {
	return RatekeeperImpl::configurationMonitor(this);
}

Future<Void> Ratekeeper::monitorServerListChange(
    PromiseStream<std::pair<UID, Optional<StorageServerInterface>>> serverChanges) {
	return RatekeeperImpl::monitorServerListChange(this, serverChanges);
}

Future<Void> Ratekeeper::trackTLogQueueInfo(TLogInterface tli) {
	return RatekeeperImpl::trackTLogQueueInfo(this, tli);
}

Future<Void> Ratekeeper::monitorThrottlingChanges() {
	return tagThrottler->monitorThrottlingChanges();
}

Future<Void> Ratekeeper::monitorHotShards(Reference<AsyncVar<ServerDBInfo> const> dbInfo) {
	return RatekeeperImpl::monitorHotShards(this, dbInfo);
}

Future<Void> Ratekeeper::run(RatekeeperInterface rkInterf, Reference<AsyncVar<ServerDBInfo> const> dbInfo) {
	return RatekeeperImpl::run(rkInterf, dbInfo);
}

Ratekeeper::Ratekeeper(UID id, Database db)
  : id(id), db(db), smoothReleasedTransactions(SERVER_KNOBS->SMOOTHING_AMOUNT),
    smoothBatchReleasedTransactions(SERVER_KNOBS->SMOOTHING_AMOUNT),
    smoothTotalDurableBytes(SERVER_KNOBS->SLOW_SMOOTHING_AMOUNT), actualTpsMetric("Ratekeeper.ActualTPS"_sr),
    lastWarning(0), lastSSListFetchedTimestamp(now()), normalLimits(TransactionPriority::DEFAULT,
                                                                    "",
                                                                    SERVER_KNOBS->TARGET_BYTES_PER_STORAGE_SERVER,
                                                                    SERVER_KNOBS->SPRING_BYTES_STORAGE_SERVER,
                                                                    SERVER_KNOBS->TARGET_BYTES_PER_TLOG,
                                                                    SERVER_KNOBS->SPRING_BYTES_TLOG,
                                                                    SERVER_KNOBS->MAX_TL_SS_VERSION_DIFFERENCE,
                                                                    SERVER_KNOBS->TARGET_DURABILITY_LAG_VERSIONS,
                                                                    SERVER_KNOBS->TARGET_BW_LAG),
    batchLimits(TransactionPriority::BATCH,
                "Batch",
                SERVER_KNOBS->TARGET_BYTES_PER_STORAGE_SERVER_BATCH,
                SERVER_KNOBS->SPRING_BYTES_STORAGE_SERVER_BATCH,
                SERVER_KNOBS->TARGET_BYTES_PER_TLOG_BATCH,
                SERVER_KNOBS->SPRING_BYTES_TLOG_BATCH,
                SERVER_KNOBS->MAX_TL_SS_VERSION_DIFFERENCE_BATCH,
                SERVER_KNOBS->TARGET_DURABILITY_LAG_VERSIONS_BATCH,
                SERVER_KNOBS->TARGET_BW_LAG_BATCH),
    maxVersion(0), blobWorkerTime(now()), unblockedAssignmentTime(now()), anyBlobRanges(false) {
	if (SERVER_KNOBS->GLOBAL_TAG_THROTTLING) {
		tagThrottler = std::make_unique<GlobalTagThrottler>(
		    db, id, SERVER_KNOBS->MAX_MACHINES_FALLING_BEHIND, SERVER_KNOBS->GLOBAL_TAG_THROTTLING_LIMITING_THRESHOLD);
	} else {
		tagThrottler = std::make_unique<TagThrottler>(db, id);
	}
}

void Ratekeeper::updateCommitCostEstimation(
    UIDTransactionTagMap<TransactionCommitCostEstimation> const& costEstimation) {
	for (auto it = storageQueueInfo.begin(); it != storageQueueInfo.end(); ++it) {
		auto tagCostIt = costEstimation.find(it->key);
		if (tagCostIt == costEstimation.end()) {
			continue;
		}
		for (const auto& [tagName, cost] : tagCostIt->second) {
			it->value.addCommitCost(tagName, cost);
		}
	}
}

static std::string getIgnoredZonesReasons(
    std::set<Optional<Standalone<StringRef>>>& ignoredMachines,
    std::map<Optional<Standalone<StringRef>>, std::set<limitReason_t>>& zoneReasons) {
	std::string ignoredZoneReasons;
	for (auto zone : ignoredMachines) {
		ignoredZoneReasons += zone.get().toString() + " [";
		for (auto reason : zoneReasons[zone]) {
			ignoredZoneReasons += std::to_string(reason) + " ";
		}
		ignoredZoneReasons += "] ";
	}
	return ignoredZoneReasons.length() ? ignoredZoneReasons : "None";
}

void Ratekeeper::updateRate(RatekeeperLimits* limits) {
	double actualTps = smoothReleasedTransactions.smoothRate();
	actualTpsMetric = (int64_t)actualTps;
	// SOMEDAY: Remove the max( 1.0, ... ) since the below calculations _should_ be able to recover back
	// up from this value
	actualTps =
	    std::max(std::max(1.0, actualTps), smoothTotalDurableBytes.smoothRate() / CLIENT_KNOBS->TRANSACTION_SIZE_LIMIT);

	limits->tpsLimit = std::numeric_limits<double>::infinity();
	UID reasonID = UID();
	limitReason_t limitReason = limitReason_t::unlimited;

	int sscount = 0;

	int64_t worstFreeSpaceStorageServer = std::numeric_limits<int64_t>::max();
	int64_t worstStorageQueueStorageServer = 0;
	int64_t limitingStorageQueueStorageServer = 0;
	int64_t worstDurabilityLag = 0;

	std::multimap<double, StorageQueueInfo const*> storageTpsLimitReverseIndex;
	std::multimap<int64_t, StorageQueueInfo const*> storageDurabilityLagReverseIndex;

	std::map<UID, limitReason_t> ssReasons;
	std::map<Optional<Standalone<StringRef>>, std::set<limitReason_t>> zoneReasons;

	bool printRateKeepLimitReasonDetails =
	    SERVER_KNOBS->RATEKEEPER_PRINT_LIMIT_REASON &&
	    (deterministicRandom()->random01() < SERVER_KNOBS->RATEKEEPER_LIMIT_REASON_SAMPLE_RATE);

	// Look at each storage server's write queue and local rate, compute and store the desired rate
	// ratio
	for (auto i = storageQueueInfo.begin(); i != storageQueueInfo.end(); ++i) {
		auto const& ss = i->value;
		if (!ss.valid || !ss.acceptingRequests || (remoteDC.present() && ss.locality.dcId() == remoteDC)) {
			continue;
		}
		++sscount;

		limitReason_t ssLimitReason = limitReason_t::unlimited;

		int64_t minFreeSpace = std::max(SERVER_KNOBS->MIN_AVAILABLE_SPACE,
		                                (int64_t)(SERVER_KNOBS->MIN_AVAILABLE_SPACE_RATIO * ss.getSmoothTotalSpace()));

		worstFreeSpaceStorageServer = std::min(worstFreeSpaceStorageServer,
		                                       std::max((int64_t)ss.getSmoothFreeSpace() - minFreeSpace, (int64_t)0));

		int64_t springBytes = std::max<int64_t>(
		    1, std::min<int64_t>(limits->storageSpringBytes, (ss.getSmoothFreeSpace() - minFreeSpace) * 0.2));
		int64_t targetBytes =
		    std::max<int64_t>(1, std::min(limits->storageTargetBytes, (int64_t)ss.getSmoothFreeSpace() - minFreeSpace));
		if (targetBytes != limits->storageTargetBytes) {
			if (minFreeSpace == SERVER_KNOBS->MIN_AVAILABLE_SPACE) {
				ssLimitReason = limitReason_t::storage_server_min_free_space;
			} else {
				ssLimitReason = limitReason_t::storage_server_min_free_space_ratio;
			}
			if (printRateKeepLimitReasonDetails) {
				TraceEvent("RatekeeperLimitReasonDetails")
				    .detail("Reason", ssLimitReason)
				    .detail("SSID", ss.id)
				    .detail("SSSmoothTotalSpace", ss.getSmoothTotalSpace())
				    .detail("SSSmoothFreeSpace", ss.getSmoothFreeSpace())
				    .detail("TargetBytes", targetBytes)
				    .detail("LimitsStorageTargetBytes", limits->storageTargetBytes)
				    .detail("MinFreeSpace", minFreeSpace);
			}
		}

		int64_t storageQueue = ss.getStorageQueueBytes();
		worstStorageQueueStorageServer = std::max(worstStorageQueueStorageServer, storageQueue);

		int64_t storageDurabilityLag = ss.getDurabilityLag();
		worstDurabilityLag = std::max(worstDurabilityLag, storageDurabilityLag);

		storageDurabilityLagReverseIndex.insert(std::make_pair(-1 * storageDurabilityLag, &ss));

		double targetRateRatio = std::min((storageQueue - targetBytes + springBytes) / (double)springBytes, 2.0);

		if (limits->priority == TransactionPriority::DEFAULT) {
			addActor.send(tagThrottler->tryUpdateAutoThrottling(ss));
		}

		double inputRate = ss.getSmoothInputBytesRate();

		/*if( deterministicRandom()->random01() < 0.1 ) {
		  std::string name = "RatekeeperUpdateRate" + limits.context;
		  TraceEvent(name, ss.id)
		  .detail("MinFreeSpace", minFreeSpace)
		  .detail("SpringBytes", springBytes)
		  .detail("TargetBytes", targetBytes)
		  .detail("SmoothTotalSpaceTotal", ss.getSmoothTotalSpace())
		  .detail("SmoothFreeSpaceTotal", ss.getSmoothFreeSpace())
		  .detail("LastReplyBytesInput", ss.lastReply.bytesInput)
		  .detail("SmoothDurableBytesTotal", ss.getSmoothDurableBytes())
		  .detail("TargetRateRatio", targetRateRatio)
		  .detail("SmoothInputBytesRate", ss.getSmoothInputBytesRate())
		  .detail("ActualTPS", actualTps)
		  .detail("InputRate", inputRate)
		  .detail("VerySmoothDurableBytesRate", ss.getVerySmoothDurableBytesRate())
		  .detail("B", b);
		  }*/

		// Don't let any storage server use up its target bytes faster than its MVCC window!
		double maxBytesPerSecond =
		    (targetBytes - springBytes) /
		    ((((double)SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS) / SERVER_KNOBS->VERSIONS_PER_SECOND) + 2.0);
		double limitTps = std::min(actualTps * maxBytesPerSecond / std::max(1.0e-8, inputRate),
		                           maxBytesPerSecond * SERVER_KNOBS->MAX_TRANSACTIONS_PER_BYTE);
		if (ssLimitReason == limitReason_t::unlimited) {
			ssLimitReason = limitReason_t::storage_server_write_bandwidth_mvcc;
		}

		if (targetRateRatio > 0 && inputRate > 0) {
			ASSERT(inputRate != 0);
			double smoothedRate =
			    std::max(ss.getVerySmoothDurableBytesRate(), actualTps / SERVER_KNOBS->MAX_TRANSACTIONS_PER_BYTE);
			double x = smoothedRate / (inputRate * targetRateRatio);
			double lim = actualTps * x;
			if (lim < limitTps) {
				double oldLimitTps = limitTps;
				limitTps = lim;
				if (ssLimitReason == limitReason_t::unlimited ||
				    ssLimitReason == limitReason_t::storage_server_write_bandwidth_mvcc) {
					if (printRateKeepLimitReasonDetails) {
						TraceEvent("RatekeeperLimitReasonDetails")
						    .detail("Reason", limitReason_t::storage_server_write_queue_size)
						    .detail("FromReason", ssLimitReason)
						    .detail("SSID", ss.id)
						    .detail("SSSmoothTotalSpace", ss.getSmoothTotalSpace())
						    .detail("LimitsStorageTargetBytes", limits->storageTargetBytes)
						    .detail("LimitsStorageSpringBytes", limits->storageSpringBytes)
						    .detail("SSSmoothFreeSpace", ss.getSmoothFreeSpace())
						    .detail("MinFreeSpace", minFreeSpace)
						    .detail("SSLastReplyBytesInput", ss.lastReply.bytesInput)
						    .detail("SSSmoothDurableBytes", ss.getSmoothDurableBytes())
						    .detail("StorageQueue", storageQueue)
						    .detail("TargetBytes", targetBytes)
						    .detail("SpringBytes", springBytes)
						    .detail("SSVerySmoothDurableBytesRate", ss.getVerySmoothDurableBytesRate())
						    .detail("SmoothedRate", smoothedRate)
						    .detail("X", x)
						    .detail("ActualTps", actualTps)
						    .detail("Lim", lim)
						    .detail("LimitTps", oldLimitTps)
						    .detail("InputRate", inputRate)
						    .detail("TargetRateRatio", targetRateRatio);
					}
					ssLimitReason = limitReason_t::storage_server_write_queue_size;
				}
			}
		}

		storageTpsLimitReverseIndex.insert(std::make_pair(limitTps, &ss));

		if (limitTps < limits->tpsLimit && (ssLimitReason == limitReason_t::storage_server_min_free_space ||
		                                    ssLimitReason == limitReason_t::storage_server_min_free_space_ratio)) {
			reasonID = ss.id;
			limits->tpsLimit = limitTps;
			limitReason = ssLimitReason;
		}

		ssReasons[ss.id] = ssLimitReason;
		zoneReasons[ss.locality.zoneId()].insert(ssLimitReason);
	}

	tagThrottler->updateThrottling(storageQueueInfo);

	std::set<Optional<Standalone<StringRef>>> ignoredMachines;
	for (auto ss = storageTpsLimitReverseIndex.begin();
	     ss != storageTpsLimitReverseIndex.end() && ss->first < limits->tpsLimit;
	     ++ss) {
		if (ignoredMachines.size() <
		    std::min(configuration.storageTeamSize - 1, SERVER_KNOBS->MAX_MACHINES_FALLING_BEHIND)) {
			ignoredMachines.insert(ss->second->locality.zoneId());
			continue;
		}
		if (ignoredMachines.contains(ss->second->locality.zoneId())) {
			continue;
		}

		limitingStorageQueueStorageServer = ss->second->lastReply.bytesInput - ss->second->getSmoothDurableBytes();
		limits->tpsLimit = ss->first;
		reasonID = storageTpsLimitReverseIndex.begin()->second->id; // Although we aren't controlling based on the worst
		// SS, we still report it as the limiting process
		limitReason = ssReasons[reasonID];
		break;
	}

	// Calculate limited durability lag
	int64_t limitingDurabilityLag = 0;

	std::set<Optional<Standalone<StringRef>>> ignoredDurabilityLagMachines;
	for (auto ss = storageDurabilityLagReverseIndex.begin(); ss != storageDurabilityLagReverseIndex.end(); ++ss) {
		if (ignoredDurabilityLagMachines.size() <
		    std::min(configuration.storageTeamSize - 1, SERVER_KNOBS->MAX_MACHINES_FALLING_BEHIND)) {
			ignoredDurabilityLagMachines.insert(ss->second->locality.zoneId());
			continue;
		}
		if (ignoredDurabilityLagMachines.contains(ss->second->locality.zoneId())) {
			continue;
		}

		limitingDurabilityLag = -1 * ss->first;
		if (limitingDurabilityLag > limits->durabilityLagTargetVersions &&
		    actualTpsHistory.size() > SERVER_KNOBS->NEEDED_TPS_HISTORY_SAMPLES) {
			if (limits->durabilityLagLimit == std::numeric_limits<double>::infinity()) {
				double maxTps = 0;
				for (int i = 0; i < actualTpsHistory.size(); i++) {
					maxTps = std::max(maxTps, actualTpsHistory[i]);
				}
				limits->durabilityLagLimit = SERVER_KNOBS->INITIAL_DURABILITY_LAG_MULTIPLIER * maxTps;
			}
			if (limitingDurabilityLag > limits->lastDurabilityLag) {
				limits->durabilityLagLimit = SERVER_KNOBS->DURABILITY_LAG_REDUCTION_RATE * limits->durabilityLagLimit;
			}
			if (limits->durabilityLagLimit < limits->tpsLimit) {
				if (printRateKeepLimitReasonDetails) {
					TraceEvent("RatekeeperLimitReasonDetails")
					    .detail("SSID", ss->second->id)
					    .detail("Reason", limitReason_t::storage_server_durability_lag)
					    .detail("LimitsDurabilityLagLimit", limits->durabilityLagLimit)
					    .detail("LimitsTpsLimit", limits->tpsLimit)
					    .detail("LimitingDurabilityLag", limitingDurabilityLag)
					    .detail("LimitsLastDurabilityLag", limits->lastDurabilityLag);
				}
				limits->tpsLimit = limits->durabilityLagLimit;
				limitReason = limitReason_t::storage_server_durability_lag;
			}
		} else if (limits->durabilityLagLimit != std::numeric_limits<double>::infinity() &&
		           limitingDurabilityLag >
		               limits->durabilityLagTargetVersions - SERVER_KNOBS->DURABILITY_LAG_UNLIMITED_THRESHOLD) {
			limits->durabilityLagLimit = SERVER_KNOBS->DURABILITY_LAG_INCREASE_RATE * limits->durabilityLagLimit;
		} else {
			limits->durabilityLagLimit = std::numeric_limits<double>::infinity();
		}
		limits->lastDurabilityLag = limitingDurabilityLag;
		break;
	}

	healthMetrics.worstStorageQueue = worstStorageQueueStorageServer;
	healthMetrics.limitingStorageQueue = limitingStorageQueueStorageServer;
	healthMetrics.worstStorageDurabilityLag = worstDurabilityLag;
	healthMetrics.limitingStorageDurabilityLag = limitingDurabilityLag;

	double writeToReadLatencyLimit = 0;
	Version worstVersionLag = 0;
	Version limitingVersionLag = 0;

	{
		Version minSSVer = std::numeric_limits<Version>::max();
		Version minLimitingSSVer = std::numeric_limits<Version>::max();
		for (const auto& it : storageQueueInfo) {
			auto& ss = it.value;
			if (!ss.valid || (remoteDC.present() && ss.locality.dcId() == remoteDC)) {
				continue;
			}

			minSSVer = std::min(minSSVer, ss.lastReply.version);

			// Machines that ratekeeper isn't controlling can fall arbitrarily far behind
			if (!ignoredMachines.contains(it.value.locality.zoneId())) {
				minLimitingSSVer = std::min(minLimitingSSVer, ss.lastReply.version);
			}
		}

		Version maxTLVer = std::numeric_limits<Version>::min();
		for (const auto& it : tlogQueueInfo) {
			auto& tl = it.value;
			if (!tl.valid) {
				continue;
			}
			maxTLVer = std::max(maxTLVer, tl.getLastCommittedVersion());
		}

		if (minSSVer != std::numeric_limits<Version>::max() && maxTLVer != std::numeric_limits<Version>::min()) {
			// writeToReadLatencyLimit: 0 = infinite speed; 1 = TL durable speed ; 2 = half TL durable
			// speed
			writeToReadLatencyLimit =
			    ((maxTLVer - minLimitingSSVer) - limits->maxVersionDifference / 2) / (limits->maxVersionDifference / 4);
			worstVersionLag = std::max((Version)0, maxTLVer - minSSVer);
			limitingVersionLag = std::max((Version)0, maxTLVer - minLimitingSSVer);
		}
	}

	int64_t worstFreeSpaceTLog = std::numeric_limits<int64_t>::max();
	int64_t worstStorageQueueTLog = 0;
	int tlcount = 0;
	for (auto& it : tlogQueueInfo) {
		auto const& tl = it.value;
		if (!tl.valid) {
			continue;
		}
		++tlcount;

		limitReason_t tlogLimitReason = limitReason_t::log_server_write_queue;

		int64_t minFreeSpace = std::max(SERVER_KNOBS->MIN_AVAILABLE_SPACE,
		                                (int64_t)(SERVER_KNOBS->MIN_AVAILABLE_SPACE_RATIO * tl.getSmoothTotalSpace()));

		worstFreeSpaceTLog =
		    std::min(worstFreeSpaceTLog, std::max((int64_t)tl.getSmoothFreeSpace() - minFreeSpace, (int64_t)0));

		int64_t springBytes = std::max<int64_t>(
		    1, std::min<int64_t>(limits->logSpringBytes, (tl.getSmoothFreeSpace() - minFreeSpace) * 0.2));
		int64_t targetBytes =
		    std::max<int64_t>(1, std::min(limits->logTargetBytes, (int64_t)tl.getSmoothFreeSpace() - minFreeSpace));
		if (targetBytes != limits->logTargetBytes) {
			if (minFreeSpace == SERVER_KNOBS->MIN_AVAILABLE_SPACE) {
				tlogLimitReason = limitReason_t::log_server_min_free_space;
			} else {
				tlogLimitReason = limitReason_t::log_server_min_free_space_ratio;
			}
			if (printRateKeepLimitReasonDetails) {
				TraceEvent("RatekeeperLimitReasonDetails")
				    .detail("TLogID", tl.id)
				    .detail("Reason", tlogLimitReason)
				    .detail("TLSmoothFreeSpace", tl.getSmoothFreeSpace())
				    .detail("TLSmoothTotalSpace", tl.getSmoothTotalSpace())
				    .detail("LimitsLogTargetBytes", limits->logTargetBytes)
				    .detail("TargetBytes", targetBytes)
				    .detail("MinFreeSpace", minFreeSpace);
			}
		}

		int64_t queue = tl.lastReply.bytesInput - tl.getSmoothDurableBytes();
		healthMetrics.tLogQueue[tl.id] = queue;
		int64_t b = queue - targetBytes;
		worstStorageQueueTLog = std::max(worstStorageQueueTLog, queue);

		if (tl.lastReply.bytesInput - tl.lastReply.bytesDurable > tl.lastReply.storageBytes.free - minFreeSpace / 2) {
			if (now() - lastWarning > 5.0) {
				lastWarning = now();
				TraceEvent(SevWarnAlways, "RkTLogMinFreeSpaceZero", id).detail("ReasonId", tl.id);
			}
			reasonID = tl.id;
			limitReason = limitReason_t::log_server_min_free_space;
			limits->tpsLimit = 0.0;
		}

		double targetRateRatio = std::min((b + springBytes) / (double)springBytes, 2.0);

		if (writeToReadLatencyLimit > targetRateRatio) {
			if (printRateKeepLimitReasonDetails) {
				TraceEvent("RatekeeperLimitReasonDetails")
				    .detail("TLogID", tl.id)
				    .detail("Reason", limitReason_t::storage_server_readable_behind)
				    .detail("TLSmoothFreeSpace", tl.getSmoothFreeSpace())
				    .detail("TLSmoothTotalSpace", tl.getSmoothTotalSpace())
				    .detail("LimitsLogSpringBytes", limits->logSpringBytes)
				    .detail("LimitsLogTargetBytes", limits->logTargetBytes)
				    .detail("SpringBytes", springBytes)
				    .detail("TargetBytes", targetBytes)
				    .detail("TLLastReplyBytesInput", tl.lastReply.bytesInput)
				    .detail("TLSmoothDurableBytes", tl.getSmoothDurableBytes())
				    .detail("Queue", queue)
				    .detail("B", b)
				    .detail("TargetRateRatio", targetRateRatio)
				    .detail("WriteToReadLatencyLimit", writeToReadLatencyLimit)
				    .detail("MinFreeSpace", minFreeSpace)
				    .detail("LimitsMaxVersionDifference", limits->maxVersionDifference);
			}
			targetRateRatio = writeToReadLatencyLimit;
			tlogLimitReason = limitReason_t::storage_server_readable_behind;
		}

		double inputRate = tl.getSmoothInputBytesRate();

		if (targetRateRatio > 0) {
			double smoothedRate =
			    std::max(tl.getVerySmoothDurableBytesRate(), actualTps / SERVER_KNOBS->MAX_TRANSACTIONS_PER_BYTE);
			double x = smoothedRate / (inputRate * targetRateRatio);
			if (targetRateRatio < .75) { //< FIXME: KNOB for 2.0
				x = std::max(x, 0.95);
			}
			double lim = actualTps * x;
			if (lim < limits->tpsLimit) {
				limits->tpsLimit = lim;
				reasonID = tl.id;
				limitReason = tlogLimitReason;
			}
		}
		if (inputRate > 0) {
			// Don't let any tlogs use up its target bytes faster than its MVCC window!
			double x =
			    ((targetBytes - springBytes) /
			     ((((double)SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS) / SERVER_KNOBS->VERSIONS_PER_SECOND) +
			      2.0)) /
			    inputRate;
			double lim = actualTps * x;
			if (lim < limits->tpsLimit) {
				if (printRateKeepLimitReasonDetails) {
					TraceEvent("RatekeeperLimitReasonDetails")
					    .detail("Reason", limitReason_t::log_server_mvcc_write_bandwidth)
					    .detail("TLogID", tl.id)
					    .detail("MinFreeSpace", minFreeSpace)
					    .detail("TLSmoothFreeSpace", tl.getSmoothFreeSpace())
					    .detail("TLSmoothTotalSpace", tl.getSmoothTotalSpace())
					    .detail("LimitsLogSpringBytes", limits->logSpringBytes)
					    .detail("LimitsLogTargetBytes", limits->logTargetBytes)
					    .detail("SpringBytes", springBytes)
					    .detail("TargetBytes", targetBytes)
					    .detail("InputRate", inputRate)
					    .detail("X", x)
					    .detail("ActualTps", actualTps)
					    .detail("Lim", lim)
					    .detail("LimitsTpsLimit", limits->tpsLimit);
				}
				limits->tpsLimit = lim;
				reasonID = tl.id;
				limitReason = limitReason_t::log_server_mvcc_write_bandwidth;
			}
		}
	}

	healthMetrics.worstTLogQueue = worstStorageQueueTLog;

	limits->tpsLimit = std::max(limits->tpsLimit, 0.0);

	if (g_network->isSimulated() && g_simulator->speedUpSimulation) {
		limits->tpsLimit = std::max(limits->tpsLimit, 100.0);
	}

	int64_t totalDiskUsageBytes = 0;
	for (auto& t : tlogQueueInfo) {
		if (t.value.valid) {
			totalDiskUsageBytes += t.value.lastReply.storageBytes.used;
		}
	}
	for (auto& s : storageQueueInfo) {
		if (s.value.valid) {
			totalDiskUsageBytes += s.value.lastReply.storageBytes.used;
		}
	}

	if (now() - lastSSListFetchedTimestamp > SERVER_KNOBS->STORAGE_SERVER_LIST_FETCH_TIMEOUT) {
		limits->tpsLimit = 0.0;
		limitReason = limitReason_t::storage_server_list_fetch_failed;
		reasonID = UID();
		TraceEvent(SevWarnAlways, "RkSSListFetchTimeout", id).suppressFor(1.0);
	} else if (limits->tpsLimit == std::numeric_limits<double>::infinity()) {
		limits->tpsLimit = SERVER_KNOBS->RATEKEEPER_DEFAULT_LIMIT;
	}

	limits->tpsLimitMetric = std::min(limits->tpsLimit, 1e6);
	limits->reasonMetric = limitReason;

	if (limits->priority == TransactionPriority::DEFAULT) {
		limits->tpsLimit = std::max(limits->tpsLimit, SERVER_KNOBS->RATEKEEPER_MIN_RATE);
		limits->tpsLimit = std::min(limits->tpsLimit, SERVER_KNOBS->RATEKEEPER_MAX_RATE);
	} else if (limits->priority == TransactionPriority::BATCH) {
		limits->tpsLimit = std::max(limits->tpsLimit, SERVER_KNOBS->RATEKEEPER_BATCH_MIN_RATE);
		limits->tpsLimit = std::min(limits->tpsLimit, SERVER_KNOBS->RATEKEEPER_BATCH_MAX_RATE);
	}

	if (deterministicRandom()->random01() < 0.1) {
		const std::string& name = limits->rkUpdateEventCacheHolder.getPtr()->trackingKey;
		TraceEvent(name.c_str(), id)
		    .detail("TPSLimit", limits->tpsLimit)
		    .detail("Reason", limitReason)
		    .detail("ReasonServerID", reasonID == UID() ? std::string() : Traceable<UID>::toString(reasonID))
		    .detail("ReleasedTPS", smoothReleasedTransactions.smoothRate())
		    .detail("ReleasedBatchTPS", smoothBatchReleasedTransactions.smoothRate())
		    .detail("TPSBasis", actualTps)
		    .detail("StorageServers", sscount)
		    .detail("GrvProxies", grvProxyInfo.size())
		    .detail("TLogs", tlcount)
		    .detail("WorstFreeSpaceStorageServer", worstFreeSpaceStorageServer)
		    .detail("WorstFreeSpaceTLog", worstFreeSpaceTLog)
		    .detail("WorstStorageServerQueue", worstStorageQueueStorageServer)
		    .detail("LimitingStorageServerQueue", limitingStorageQueueStorageServer)
		    .detail("WorstTLogQueue", worstStorageQueueTLog)
		    .detail("TotalDiskUsageBytes", totalDiskUsageBytes)
		    .detail("WorstStorageServerVersionLag", worstVersionLag)
		    .detail("LimitingStorageServerVersionLag", limitingVersionLag)
		    .detail("WorstStorageServerDurabilityLag", worstDurabilityLag)
		    .detail("LimitingStorageServerDurabilityLag", limitingDurabilityLag)
		    .detail("IgnoredZonesReasons", getIgnoredZonesReasons(ignoredMachines, zoneReasons))
		    .detail("TagsAutoThrottled", tagThrottler->autoThrottleCount())
		    .detail("TagsAutoThrottledBusyRead", tagThrottler->busyReadTagCount())
		    .detail("TagsAutoThrottledBusyWrite", tagThrottler->busyWriteTagCount())
		    .detail("TagsManuallyThrottled", tagThrottler->manualThrottleCount())
		    .detail("AutoThrottlingEnabled", tagThrottler->isAutoThrottlingEnabled())
		    .trackLatest(name);
	}
	ssHighWriteQueue.reset();
	if (limitReason == limitReason_t::storage_server_write_queue_size) {
		ssHighWriteQueue = reasonID;
	}
}

Future<Void> Ratekeeper::refreshStorageServerCommitCosts() {
	return RatekeeperImpl::refreshStorageServerCommitCosts(this);
}

void Ratekeeper::getSSVersionLag(Version& maxSSPrimaryVersion, Version& maxSSRemoteVersion) {
	maxSSPrimaryVersion = maxSSRemoteVersion = invalidVersion;
	for (auto i = storageQueueInfo.begin(); i != storageQueueInfo.end(); ++i) {
		auto const& ss = i->value;
		if (!ss.valid || !ss.acceptingRequests) {
			continue;
		}

		if (remoteDC.present() && ss.locality.dcId() == remoteDC) {
			maxSSRemoteVersion = std::max(ss.getLatestVersion(), maxSSRemoteVersion);
		} else {
			maxSSPrimaryVersion = std::max(ss.getLatestVersion(), maxSSPrimaryVersion);
		}
	}
}

															#line 6192 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
namespace {
// This generated class is to be used only via ratekeeper()
															#line 1194 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
template <class RatekeeperActor>
															#line 1194 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class RatekeeperActorState {
															#line 6199 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
															#line 1194 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	RatekeeperActorState(RatekeeperInterface const& rkInterf,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 1194 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
															#line 1194 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		 : rkInterf(rkInterf),
															#line 1194 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		   dbInfo(dbInfo)
															#line 6208 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
	{
		fdb_probe_actor_create("ratekeeper", reinterpret_cast<unsigned long>(this));

	}
	~RatekeeperActorState() 
	{
		fdb_probe_actor_destroy("ratekeeper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1195 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Ratekeeper::run(rkInterf, dbInfo);
															#line 1195 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			if (static_cast<RatekeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6225 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RatekeeperActor*>(this)->actor_wait_state = 1;
															#line 1195 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RatekeeperActor, 0, Void >*>(static_cast<RatekeeperActor*>(this)));
															#line 6230 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RatekeeperActorState();
		static_cast<RatekeeperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1196 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (!static_cast<RatekeeperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RatekeeperActorState(); static_cast<RatekeeperActor*>(this)->destroy(); return 0; }
															#line 6253 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		new (&static_cast<RatekeeperActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RatekeeperActorState();
		static_cast<RatekeeperActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1196 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
		if (!static_cast<RatekeeperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RatekeeperActorState(); static_cast<RatekeeperActor*>(this)->destroy(); return 0; }
															#line 6265 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		new (&static_cast<RatekeeperActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RatekeeperActorState();
		static_cast<RatekeeperActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RatekeeperActor*>(this)->actor_wait_state > 0) static_cast<RatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<RatekeeperActor*>(this)->ActorCallback< RatekeeperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RatekeeperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ratekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ratekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RatekeeperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ratekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ratekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RatekeeperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ratekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ratekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1194 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	RatekeeperInterface rkInterf;
															#line 1194 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 6352 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
};
// This generated class is to be used only via ratekeeper()
															#line 1194 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
class RatekeeperActor final : public Actor<Void>, public ActorCallback< RatekeeperActor, 0, Void >, public FastAllocated<RatekeeperActor>, public RatekeeperActorState<RatekeeperActor> {
															#line 6357 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
public:
	using FastAllocated<RatekeeperActor>::operator new;
	using FastAllocated<RatekeeperActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17155963612139142656UL, 2902717357263825408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RatekeeperActor, 0, Void >;
															#line 1194 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	RatekeeperActor(RatekeeperInterface const& rkInterf,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 6374 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
		 : Actor<Void>(),
		   RatekeeperActorState<RatekeeperActor>(rkInterf, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ratekeeper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(444146826992737536UL, 12180647434309883648UL);
		ActorExecutionContextHelper __helper(static_cast<RatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ratekeeper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ratekeeper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RatekeeperActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1194 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
[[nodiscard]] Future<Void> ratekeeper( RatekeeperInterface const& rkInterf, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 1194 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"
	return Future<Void>(new RatekeeperActor(rkInterf, dbInfo));
															#line 6407 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbserver/Ratekeeper.actor.g.cpp"
}

#line 1198 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbserver/Ratekeeper.actor.cpp"

StorageQueueInfo::StorageQueueInfo(const UID& ratekeeperID_, const UID& id_, const LocalityData& locality_)
  : valid(false), ratekeeperID(ratekeeperID_), id(id_), locality(locality_), acceptingRequests(false),
    smoothDurableBytes(SERVER_KNOBS->SMOOTHING_AMOUNT), smoothInputBytes(SERVER_KNOBS->SMOOTHING_AMOUNT),
    verySmoothDurableBytes(SERVER_KNOBS->SLOW_SMOOTHING_AMOUNT), smoothDurableVersion(SERVER_KNOBS->SMOOTHING_AMOUNT),
    smoothLatestVersion(SERVER_KNOBS->SMOOTHING_AMOUNT), smoothFreeSpace(SERVER_KNOBS->SMOOTHING_AMOUNT),
    smoothTotalSpace(SERVER_KNOBS->SMOOTHING_AMOUNT), limitReason(limitReason_t::unlimited) {
	// FIXME: this is a tacky workaround for a potential uninitialized use in trackStorageServerQueueInfo
	lastReply.instanceID = -1;
}

StorageQueueInfo::StorageQueueInfo(const UID& id_, const LocalityData& locality_)
  : StorageQueueInfo(UID(), id_, locality_) {}

void StorageQueueInfo::addCommitCost(TransactionTagRef tagName, TransactionCommitCostEstimation const& cost) {
	tagCostEst[tagName] += cost;
	totalWriteCosts += cost.getCostSum();
	totalWriteOps += cost.getOpsSum();
}

void StorageQueueInfo::update(StorageQueuingMetricsReply const& reply, Smoother& smoothTotalDurableBytes) {
	valid = true;
	auto prevReply = std::move(lastReply);
	lastReply = reply;
	if (prevReply.instanceID != reply.instanceID) {
		smoothDurableBytes.reset(reply.bytesDurable);
		verySmoothDurableBytes.reset(reply.bytesDurable);
		smoothInputBytes.reset(reply.bytesInput);
		smoothFreeSpace.reset(reply.storageBytes.available);
		smoothTotalSpace.reset(reply.storageBytes.total);
		smoothDurableVersion.reset(reply.durableVersion);
		smoothLatestVersion.reset(reply.version);
	} else {
		smoothTotalDurableBytes.addDelta(reply.bytesDurable - prevReply.bytesDurable);
		smoothDurableBytes.setTotal(reply.bytesDurable);
		verySmoothDurableBytes.setTotal(reply.bytesDurable);
		smoothInputBytes.setTotal(reply.bytesInput);
		smoothFreeSpace.setTotal(reply.storageBytes.available);
		smoothTotalSpace.setTotal(reply.storageBytes.total);
		smoothDurableVersion.setTotal(reply.durableVersion);
		smoothLatestVersion.setTotal(reply.version);
	}

	busiestReadTags = reply.busiestTags;
}

UpdateCommitCostRequest StorageQueueInfo::refreshCommitCost(double elapsed) {
	busiestWriteTags.clear();
	TransactionTag busiestTag;
	TransactionCommitCostEstimation maxCost;
	double maxRate = 0;
	std::priority_queue<BusyTagInfo, std::vector<BusyTagInfo>, std::greater<BusyTagInfo>> topKWriters;
	for (const auto& [tag, cost] : tagCostEst) {
		double rate = cost.getCostSum() / elapsed;
		double busyness = static_cast<double>(maxCost.getCostSum()) / totalWriteCosts;
		if (rate < SERVER_KNOBS->MIN_TAG_WRITE_PAGES_RATE * CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE) {
			continue;
		}
		if (topKWriters.size() < SERVER_KNOBS->SS_THROTTLE_TAGS_TRACKED) {
			topKWriters.emplace(tag, rate, busyness);
		} else if (topKWriters.top().rate < rate) {
			topKWriters.pop();
			topKWriters.emplace(tag, rate, busyness);
		}

		if (rate > maxRate) {
			busiestTag = tag;
			maxRate = rate;
			maxCost = cost;
		}
	}

	while (!topKWriters.empty()) {
		busiestWriteTags.push_back(std::move(topKWriters.top()));
		topKWriters.pop();
	}

	UpdateCommitCostRequest updateCommitCostRequest{ ratekeeperID,
		                                             now(),
		                                             elapsed,
		                                             busiestTag,
		                                             maxCost.getOpsSum(),
		                                             maxCost.getCostSum(),
		                                             totalWriteCosts,
		                                             !busiestWriteTags.empty(),
		                                             ReplyPromise<Void>() };

	// reset statistics
	tagCostEst.clear();
	totalWriteOps = 0;
	totalWriteCosts = 0;

	return updateCommitCostRequest;
}

Optional<double> StorageQueueInfo::getTagThrottlingRatio(int64_t storageTargetBytes, int64_t storageSpringBytes) const {
	auto const storageQueue = getStorageQueueBytes();
	// TODO: Remove duplicate calculation from Ratekeeper::updateRate
	double inverseResult = std::min(
	    2.0, (storageQueue - storageTargetBytes + storageSpringBytes) / static_cast<double>(storageSpringBytes));
	if (inverseResult > 0) {
		return 1.0 / inverseResult;
	} else {
		return {};
	}
}

TLogQueueInfo::TLogQueueInfo(UID id)
  : valid(false), id(id), smoothDurableBytes(SERVER_KNOBS->SMOOTHING_AMOUNT),
    smoothInputBytes(SERVER_KNOBS->SMOOTHING_AMOUNT), verySmoothDurableBytes(SERVER_KNOBS->SLOW_SMOOTHING_AMOUNT),
    smoothFreeSpace(SERVER_KNOBS->SMOOTHING_AMOUNT), smoothTotalSpace(SERVER_KNOBS->SMOOTHING_AMOUNT) {
	// FIXME: this is a tacky workaround for a potential uninitialized use in trackTLogQueueInfo (copied
	// from storageQueueInfO)
	lastReply.instanceID = -1;
}

void TLogQueueInfo::update(TLogQueuingMetricsReply const& reply, Smoother& smoothTotalDurableBytes) {
	valid = true;
	auto prevReply = std::move(lastReply);
	lastReply = reply;
	if (prevReply.instanceID != reply.instanceID) {
		smoothDurableBytes.reset(reply.bytesDurable);
		verySmoothDurableBytes.reset(reply.bytesDurable);
		smoothInputBytes.reset(reply.bytesInput);
		smoothFreeSpace.reset(reply.storageBytes.available);
		smoothTotalSpace.reset(reply.storageBytes.total);
	} else {
		smoothTotalDurableBytes.addDelta(reply.bytesDurable - prevReply.bytesDurable);
		smoothDurableBytes.setTotal(reply.bytesDurable);
		verySmoothDurableBytes.setTotal(reply.bytesDurable);
		smoothInputBytes.setTotal(reply.bytesInput);
		smoothFreeSpace.setTotal(reply.storageBytes.available);
		smoothTotalSpace.setTotal(reply.storageBytes.total);
	}
}

RatekeeperLimits::RatekeeperLimits(TransactionPriority priority,
                                   std::string context,
                                   int64_t storageTargetBytes,
                                   int64_t storageSpringBytes,
                                   int64_t logTargetBytes,
                                   int64_t logSpringBytes,
                                   double maxVersionDifference,
                                   int64_t durabilityLagTargetVersions,
                                   double bwLagTarget)
  : tpsLimit(std::numeric_limits<double>::infinity()), tpsLimitMetric(StringRef("Ratekeeper.TPSLimit" + context)),
    reasonMetric(StringRef("Ratekeeper.Reason" + context)), storageTargetBytes(storageTargetBytes),
    storageSpringBytes(storageSpringBytes), logTargetBytes(logTargetBytes), logSpringBytes(logSpringBytes),
    maxVersionDifference(maxVersionDifference),
    durabilityLagTargetVersions(durabilityLagTargetVersions +
                                SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS), // The read transaction life versions
                                                                                   // are expected to not
    // be durable on the storage servers
    lastDurabilityLag(0), durabilityLagLimit(std::numeric_limits<double>::infinity()), bwLagTarget(bwLagTarget),
    priority(priority), context(context),
    rkUpdateEventCacheHolder(makeReference<EventCacheHolder>("RkUpdate" + context)) {}
