#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
/*
 * HotRangeCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <boost/lexical_cast.hpp>

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/StorageServerInterface.h"

#include "fdbclient/json_spirit/json_spirit_value.h"
#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/NetworkAddress.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

ReadHotSubRangeRequest::SplitType parseSplitType(const std::string& typeStr) {
	auto type = ReadHotSubRangeRequest::SplitType::BYTES;
	if (typeStr == "bytes") {
		type = ReadHotSubRangeRequest::BYTES;
	} else if (typeStr == "readBytes") {
		type = ReadHotSubRangeRequest::READ_BYTES;
	} else if (typeStr == "readOps") {
		type = ReadHotSubRangeRequest::READ_OPS;
	} else {
		fmt::print("Error: {} is not a valid split type. Will use bytes as the default split type\n", typeStr);
	}
	return type;
}

} // namespace

namespace fdb_cli {

															#line 58 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
// This generated class is to be used only via hotRangeCommandActor()
															#line 56 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
template <class HotRangeCommandActorActor>
															#line 56 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
class HotRangeCommandActorActorState {
															#line 64 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
public:
															#line 56 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
	HotRangeCommandActorActorState(Database const& localdb,Reference<IDatabase> const& db,std::vector<StringRef> const& tokens,std::map<std::string, StorageServerInterface>* const& storage_interface) 
															#line 56 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
															#line 56 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		 : localdb(localdb),
															#line 56 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		   db(db),
															#line 56 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		   tokens(tokens),
															#line 56 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		   storage_interface(storage_interface)
															#line 77 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("hotRangeCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~HotRangeCommandActorActorState() 
	{
		fdb_probe_actor_destroy("hotRangeCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 61 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			if (tokens.size() == 1)
															#line 92 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
			{
															#line 63 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
				storage_interface->clear();
															#line 64 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
				StrictFuture<Void> __when_expr_0 = getStorageServerInterfaces(db, storage_interface);
															#line 64 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
				if (static_cast<HotRangeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 100 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<HotRangeCommandActorActor*>(this)->actor_wait_state = 1;
															#line 64 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HotRangeCommandActorActor, 0, Void >*>(static_cast<HotRangeCommandActorActor*>(this)));
															#line 105 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 70 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
				if (tokens.size() == 6)
															#line 112 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
				{
															#line 71 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
					if (storage_interface->size() == 0)
															#line 116 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
					{
															#line 72 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
						fprintf(stderr, "ERROR: no storage processes to query. You must run the `hotrange’ command first.\n");
															#line 73 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
						if (!static_cast<HotRangeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~HotRangeCommandActorActorState(); static_cast<HotRangeCommandActorActor*>(this)->destroy(); return 0; }
															#line 122 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
						new (&static_cast<HotRangeCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
						this->~HotRangeCommandActorActorState();
						static_cast<HotRangeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 75 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
					address = tokens[1];
															#line 77 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
					if (!storage_interface->count(address.toString()))
															#line 132 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
					{
															#line 78 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
						fprintf(stderr, "ERROR: storage process `%s' not recognized.\n", printable(address).c_str());
															#line 79 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
						if (!static_cast<HotRangeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~HotRangeCommandActorActorState(); static_cast<HotRangeCommandActorActor*>(this)->destroy(); return 0; }
															#line 138 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
						new (&static_cast<HotRangeCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
						this->~HotRangeCommandActorActorState();
						static_cast<HotRangeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 81 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
					splitCount = int();
															#line 146 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
					try {
															#line 83 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
						splitCount = boost::lexical_cast<int>(tokens[5].toString());
															#line 150 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
						loopDepth = a_body1cont10(loopDepth);
					}
					catch (Error& error) {
						loopDepth = a_body1Catch2(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1Catch2(unknown_error(), loopDepth);
					}
				}
				else
				{
															#line 109 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
					printUsage(tokens[0]);
															#line 110 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
					if (!static_cast<HotRangeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~HotRangeCommandActorActorState(); static_cast<HotRangeCommandActorActor*>(this)->destroy(); return 0; }
															#line 165 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
					new (&static_cast<HotRangeCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
					this->~HotRangeCommandActorActorState();
					static_cast<HotRangeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HotRangeCommandActorActorState();
		static_cast<HotRangeCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 113 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		if (!static_cast<HotRangeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~HotRangeCommandActorActorState(); static_cast<HotRangeCommandActorActor*>(this)->destroy(); return 0; }
															#line 193 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
		new (&static_cast<HotRangeCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~HotRangeCommandActorActorState();
		static_cast<HotRangeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 65 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		fmt::print("\nThe following {} storage servers can be queried:\n", storage_interface->size());
															#line 66 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		for( const auto& [addr, _] : *storage_interface ) {
															#line 67 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			fmt::print("{}\n", addr);
															#line 209 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
		}
															#line 69 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		fmt::print("\n");
															#line 213 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 65 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		fmt::print("\nThe following {} storage servers can be queried:\n", storage_interface->size());
															#line 66 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		for( const auto& [addr, _] : *storage_interface ) {
															#line 67 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			fmt::print("{}\n", addr);
															#line 226 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
		}
															#line 69 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		fmt::print("\n");
															#line 230 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HotRangeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<HotRangeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<HotRangeCommandActorActor*>(this)->ActorCallback< HotRangeCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HotRangeCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("hotRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HotRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("hotRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HotRangeCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("hotRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HotRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("hotRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HotRangeCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("hotRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HotRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("hotRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
															#line 88 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		ReadHotSubRangeRequest::SplitType splitType = parseSplitType(tokens[2].toString());
															#line 89 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		KeyRangeRef range(tokens[3], tokens[4]);
															#line 91 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		StrictFuture<Standalone<VectorRef<ReadHotRangeWithMetrics>>> __when_expr_1 = localdb->getHotRangeMetrics((*storage_interface)[address.toString()], range, splitType, splitCount);
															#line 91 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		if (static_cast<HotRangeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 326 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont6when1(__when_expr_1.get(), loopDepth); };
		static_cast<HotRangeCommandActorActor*>(this)->actor_wait_state = 2;
															#line 91 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HotRangeCommandActorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*>(static_cast<HotRangeCommandActorActor*>(this)));
															#line 331 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 85 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			fmt::print("Error: splitCount value: '{}', cannot be parsed to an Integer\n", tokens[5].toString());
															#line 86 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			if (!static_cast<HotRangeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~HotRangeCommandActorActorState(); static_cast<HotRangeCommandActorActor*>(this)->destroy(); return 0; }
															#line 343 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
			new (&static_cast<HotRangeCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
			this->~HotRangeCommandActorActorState();
			static_cast<HotRangeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(Standalone<VectorRef<ReadHotRangeWithMetrics>> const& metrics,int loopDepth) 
	{
															#line 94 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		json_spirit::mArray resultArray;
															#line 95 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		for( const auto& metric : metrics ) {
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			json_spirit::mObject metricObj;
															#line 97 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			metricObj["begin"] = metric.keys.begin.toString();
															#line 98 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			metricObj["end"] = metric.keys.end.toString();
															#line 99 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			metricObj["readBytesPerSec"] = metric.readBandwidthSec;
															#line 100 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			metricObj["readOpsPerSec"] = metric.readOpsSec;
															#line 101 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			metricObj["bytes"] = metric.bytes;
															#line 102 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			resultArray.push_back(metricObj);
															#line 390 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
		}
															#line 105 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		const std::string result = json_spirit::write_string(json_spirit::mValue(resultArray), json_spirit::pretty_print);
															#line 107 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		fmt::print("\n{}\n", result);
															#line 396 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Standalone<VectorRef<ReadHotRangeWithMetrics>> && metrics,int loopDepth) 
	{
															#line 94 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		json_spirit::mArray resultArray;
															#line 95 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		for( const auto& metric : metrics ) {
															#line 96 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			json_spirit::mObject metricObj;
															#line 97 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			metricObj["begin"] = metric.keys.begin.toString();
															#line 98 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			metricObj["end"] = metric.keys.end.toString();
															#line 99 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			metricObj["readBytesPerSec"] = metric.readBandwidthSec;
															#line 100 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			metricObj["readOpsPerSec"] = metric.readOpsSec;
															#line 101 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			metricObj["bytes"] = metric.bytes;
															#line 102 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
			resultArray.push_back(metricObj);
															#line 421 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
		}
															#line 105 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		const std::string result = json_spirit::write_string(json_spirit::mValue(resultArray), json_spirit::pretty_print);
															#line 107 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
		fmt::print("\n{}\n", result);
															#line 427 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Standalone<VectorRef<ReadHotRangeWithMetrics>> const& metrics,int loopDepth) 
	{
		loopDepth = a_body1cont11(metrics, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Standalone<VectorRef<ReadHotRangeWithMetrics>> && metrics,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(metrics), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HotRangeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<HotRangeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<HotRangeCommandActorActor*>(this)->ActorCallback< HotRangeCommandActorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >::remove();

	}
	void a_callback_fire(ActorCallback< HotRangeCommandActorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*,Standalone<VectorRef<ReadHotRangeWithMetrics>> const& value) 
	{
		fdb_probe_actor_enter("hotRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HotRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("hotRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HotRangeCommandActorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*,Standalone<VectorRef<ReadHotRangeWithMetrics>> && value) 
	{
		fdb_probe_actor_enter("hotRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HotRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("hotRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HotRangeCommandActorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*,Error err) 
	{
		fdb_probe_actor_enter("hotRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HotRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("hotRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 56 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
	Database localdb;
															#line 56 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 56 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 56 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
	std::map<std::string, StorageServerInterface>* storage_interface;
															#line 75 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
	Key address;
															#line 81 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
	int splitCount;
															#line 519 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
};
// This generated class is to be used only via hotRangeCommandActor()
															#line 56 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
class HotRangeCommandActorActor final : public Actor<bool>, public ActorCallback< HotRangeCommandActorActor, 0, Void >, public ActorCallback< HotRangeCommandActorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >, public FastAllocated<HotRangeCommandActorActor>, public HotRangeCommandActorActorState<HotRangeCommandActorActor> {
															#line 524 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
public:
	using FastAllocated<HotRangeCommandActorActor>::operator new;
	using FastAllocated<HotRangeCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5592366952295091456UL, 17319251288132910848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HotRangeCommandActorActor, 0, Void >;
friend struct ActorCallback< HotRangeCommandActorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >;
															#line 56 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
	HotRangeCommandActorActor(Database const& localdb,Reference<IDatabase> const& db,std::vector<StringRef> const& tokens,std::map<std::string, StorageServerInterface>* const& storage_interface) 
															#line 542 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
		 : Actor<bool>(),
		   HotRangeCommandActorActorState<HotRangeCommandActorActor>(localdb, db, tokens, storage_interface),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("hotRangeCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15788103399309188864UL, 15228359767597140736UL);
		ActorExecutionContextHelper __helper(static_cast<HotRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("hotRangeCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("hotRangeCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HotRangeCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HotRangeCommandActorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 56 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
[[nodiscard]] Future<bool> hotRangeCommandActor( Database const& localdb, Reference<IDatabase> const& db, std::vector<StringRef> const& tokens, std::map<std::string, StorageServerInterface>* const& storage_interface ) {
															#line 56 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"
	return Future<bool>(new HotRangeCommandActorActor(localdb, db, tokens, storage_interface));
															#line 575 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/build_output/fdbcli/HotRangeCommand.actor.g.cpp"
}

#line 115 "/codebuild/output/src1514243894/src/github.com/apple/foundationdb/fdbcli/HotRangeCommand.actor.cpp"

CommandFactory hotRangeFactory(
    "hotrange",
    CommandHelp(
        "hotrange <IP:PORT> <bytes|readBytes|readOps> <begin> <end> <splitCount>",
        "Fetch read metrics from a given storage server to detect hot range",
        "If no arguments are specified, populates the list of storage processes that can be queried. "
        "<begin> <end> specify the range you are interested in, "
        "<bytes|readBytes|readOps> is the metric used to divide ranges, "
        "splitCount is the number of returned ranges divided by the given metric. "
        "The command will return an array of json object for each range with their metrics."
        "Notice: the three metrics are sampled by a different way, so their values are not perfectly matched.\n"));

} // namespace fdb_cli
