/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.RequiresDatabase;
import com.apple.foundationdb.Tenant;
import com.apple.foundationdb.TenantManagement;
import com.apple.foundationdb.Transaction;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={RequiresDatabase.class})
public class TransactionIntegrationTest {
    private static final FDB fdb = FDB.selectAPIVersion((int)800);

    @Test
    public void testOperationsAfterCommit() throws Exception {
        try (Database database = fdb.open();){
            for (int i = 0; i < 10; ++i) {
                try (Transaction transaction = database.createTransaction();){
                    this.doTestOperationsAfterCommit(transaction);
                    continue;
                }
            }
        }
    }

    @Test
    public void testOperationsAfterCommitInTenant() throws Exception {
        try (Database database = fdb.open();){
            byte[] byArray = "testOperationsAfterCommitInTenant".getBytes();
            TenantManagement.createTenant((Database)database, (byte[])byArray).join();
            try (Tenant tenant = database.openTenant(byArray);){
                for (int i = 0; i < 10; ++i) {
                    try (Transaction transaction = tenant.createTransaction();){
                        this.doTestOperationsAfterCommit(transaction);
                        continue;
                    }
                }
            }
        }
    }

    private void doTestOperationsAfterCommit(Transaction transaction) {
        transaction.set("key1".getBytes(), "val1".getBytes());
        CompletableFuture completableFuture = transaction.commit();
        this.expectUsedDuringCommitError(() -> transaction.get("key3".getBytes()).join());
        transaction.set("key2".getBytes(), "val2".getBytes());
        this.expectUsedDuringCommitError(() -> transaction.commit().join());
        completableFuture.join();
        this.expectUsedDuringCommitError(() -> transaction.get("key3".getBytes()).join());
        transaction.set("key2".getBytes(), "val2".getBytes());
        this.expectUsedDuringCommitError(() -> transaction.commit().join());
    }

    private void expectUsedDuringCommitError(Runnable runnable) {
        try {
            runnable.run();
            Assertions.fail();
        }
        catch (CompletionException completionException) {
            FDBException fDBException = (FDBException)completionException.getCause();
            Assertions.assertEquals((int)fDBException.getCode(), (int)2017);
        }
    }
}

