/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.AsyncIterable;
import java.util.List;
import java.util.concurrent.CompletionException;

public class RangeTest {
    public static void main(String[] stringArray) {
        System.out.println("About to use version 800");
        FDB fDB = FDB.selectAPIVersion((int)800);
        Database database = fDB.open();
        try {
            FDBException fDBException;
            Object object;
            long l;
            try {
                database.run(transaction -> {
                    long l = (Long)transaction.getReadVersion().join();
                    System.out.println("DB version: " + l);
                    transaction.get("apple1".getBytes()).join();
                    transaction.set("apple1".getBytes(), "crunchy1".getBytes());
                    transaction.set("apple2".getBytes(), "crunchy2".getBytes());
                    transaction.set("apple3".getBytes(), "crunchy3".getBytes());
                    transaction.set("apple4".getBytes(), "crunchy4".getBytes());
                    transaction.set("apple5".getBytes(), "crunchy5".getBytes());
                    transaction.set("apple6".getBytes(), "crunchy6".getBytes());
                    System.out.println("Attempting to commit apple/crunchy pairs...");
                    return null;
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                System.out.println("Non retryable exception caught...");
            }
            System.out.println("First transaction was successful");
            try (Transaction transaction2 = database.createTransaction();){
                RangeTest.checkRange(transaction2);
            }
            Transaction transaction3 = database.createTransaction();
            try {
                l = (Long)transaction3.getReadVersion().join();
                System.out.println("DB version: " + l);
                object = (byte[])transaction3.get("apple3".getBytes()).join();
                System.out.println("Got apple3: " + new String((byte[])object));
                transaction3.cancel();
                try {
                    transaction3.get("apple3".getBytes()).join();
                    throw new RuntimeException("The get() should have thrown an error!");
                }
                catch (CompletionException completionException) {
                    fDBException = (FDBException)completionException.getCause();
                    if (fDBException.getCode() != 1025) {
                        System.err.println("Transaction was not cancelled correctly (" + fDBException.getCode() + ")");
                        throw fDBException;
                    }
                    System.out.println("Transaction was cancelled correctly");
                    if (transaction3 != null) {
                        transaction3.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (transaction3 != null) {
                    try {
                        transaction3.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            transaction3 = database.createTransaction();
            try {
                l = (Long)transaction3.getReadVersion().join();
                System.out.println("DB version: " + l);
                transaction3.clear("apple3".getBytes(), "apple6".getBytes());
                try {
                    transaction3.commit().join();
                    System.out.println("Clear range transaction was successful");
                }
                catch (FDBException fDBException2) {
                    System.err.println("Error in the clear of a single value");
                    fDBException2.printStackTrace();
                    if (transaction3 != null) {
                        transaction3.close();
                    }
                    if (database != null) {
                        database.close();
                    }
                    return;
                }
            }
            finally {
                if (transaction3 != null) {
                    transaction3.close();
                }
            }
            transaction3 = database.createTransaction();
            try {
                RangeTest.checkRange(transaction3);
            }
            finally {
                if (transaction3 != null) {
                    transaction3.close();
                }
            }
            transaction3 = new Range("apple".getBytes(), "banana".getBytes());
            object = new Range("apple".getBytes(), "banana".getBytes());
            Range range = new Range("apple".getBytes(), "crepe".getBytes());
            fDBException = new Range(null, "banana".getBytes());
            Range range2 = new Range(new byte[]{21, 1}, null);
            System.out.println("ranges: " + transaction3 + ", " + object + ", " + range + ", " + (Object)((Object)fDBException) + ", " + range2);
            if (transaction3.equals(null)) {
                System.err.println("range " + transaction3 + " equals null");
            } else if (!transaction3.equals((Object)transaction3)) {
                System.err.println("range equality not reflexive");
            } else if (transaction3.hashCode() != transaction3.hashCode()) {
                System.err.println("range hashcode not reflexive");
            } else if (!transaction3.equals(object)) {
                System.err.println("range " + transaction3 + " and " + object + " not equal");
            } else if (transaction3.hashCode() != object.hashCode()) {
                System.err.println("ranges " + transaction3 + " and " + object + " do not have same hash codes");
            } else if (transaction3.equals((Object)range)) {
                System.err.println("ranges " + transaction3 + " and " + range + " are equal");
            } else if (transaction3.hashCode() == range.hashCode()) {
                System.err.println("range " + transaction3 + " and " + range + " have same hash code");
            } else if (transaction3.equals((Object)fDBException)) {
                System.err.println("ranges " + transaction3 + " and " + (Object)((Object)fDBException) + " are equal");
            } else if (transaction3.hashCode() == fDBException.hashCode()) {
                System.err.println("range " + transaction3 + " and " + (Object)((Object)fDBException) + " have same hash code");
            } else if (transaction3.equals((Object)range2)) {
                System.err.println("ranges " + transaction3 + " and " + range2 + " are equal");
            } else if (transaction3.hashCode() == range2.hashCode()) {
                System.err.println("range " + transaction3 + " and " + range2 + " have same hash code");
            } else {
                System.out.println("range comparisons okay");
            }
            System.out.println("Done with test program");
        }
        finally {
            if (database != null) {
                try {
                    database.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable3;
                    throwable3.addSuppressed(throwable);
                }
            }
        }
    }

    private static void checkRange(Transaction transaction) {
        String string;
        long l = (Long)transaction.getReadVersion().join();
        System.out.println("DB version: " + l);
        byte[] byArray = (byte[])transaction.get("apple4".getBytes()).join();
        System.out.println("Value is " + (byArray != null ? new String(byArray) : "not present"));
        AsyncIterable asyncIterable = transaction.getRange(KeySelector.firstGreaterOrEqual((byte[])"apple".getBytes()), KeySelector.firstGreaterOrEqual((byte[])"banana".getBytes()), 4);
        List list = (List)asyncIterable.asList().join();
        System.out.println("List size is " + list.size());
        for (int i = 0; i < list.size(); ++i) {
            String string2 = new String(((KeyValue)list.get(i)).getKey());
            string = new String(((KeyValue)list.get(i)).getValue());
            System.out.println(" (" + i + ") -> " + string2 + ", " + string);
        }
        System.out.println("\nAlso:");
        for (String string2 : asyncIterable) {
            string = new String(string2.getKey());
            String string3 = new String(string2.getValue());
            System.out.println(" -- " + string + " -> " + string3);
        }
    }

    private RangeTest() {
    }
}

