#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
/*
 * GetEncryptCipherKeys_impl.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#include "flow/EncryptUtils.h"
#include "flow/genericactors.actor.h"
#if defined(NO_INTELLISENSE) && !defined(FDBCLIENT_GETCIPHERKEYS_IMPL_ACTOR_G_H)
#define FDBCLIENT_GETCIPHERKEYS_IMPL_ACTOR_G_H
#include "fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
#elif !defined(FDBCLIENT_GETCIPHERKEYS_IMPL_ACTOR_H)
#define FDBCLIENT_GETCIPHERKEYS_IMPL_ACTOR_H

#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbclient/SpecialKeySpace.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/Tuple.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

#define DEBUG_GET_CIPHER false

namespace {
															#line 45 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
// This generated class is to be used only via monitorGetEncryptCipherKeys()
															#line 43 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T, class MonitorGetEncryptCipherKeysActor>
															#line 43 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class MonitorGetEncryptCipherKeysActorState {
															#line 51 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
															#line 43 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	MonitorGetEncryptCipherKeysActorState(GetEncryptCipherKeysMonitor* const& self,Future<T> const& actor) 
															#line 43 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
															#line 43 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		 : self(self),
															#line 43 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   actor(actor)
															#line 60 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
	{
		fdb_probe_actor_create("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this));

	}
	~MonitorGetEncryptCipherKeysActorState() 
	{
		fdb_probe_actor_destroy("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 45 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			Future<Void> timer = delay(CLIENT_KNOBS->ENCRYPT_GET_CIPHER_KEY_LONG_REQUEST_THRESHOLD, TaskPriority::DefaultDelay);
															#line 47 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			StrictFuture<T> __when_expr_0 = actor;
															#line 46 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (static_cast<MonitorGetEncryptCipherKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 79 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 50 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			StrictFuture<Void> __when_expr_1 = timer;
															#line 83 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorGetEncryptCipherKeysActor*>(this)->actor_wait_state = 1;
															#line 47 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorGetEncryptCipherKeysActor, 0, T >*>(static_cast<MonitorGetEncryptCipherKeysActor*>(this)));
															#line 50 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorGetEncryptCipherKeysActor, 1, Void >*>(static_cast<MonitorGetEncryptCipherKeysActor*>(this)));
															#line 90 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorGetEncryptCipherKeysActorState();
		static_cast<MonitorGetEncryptCipherKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
															#line 48 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<MonitorGetEncryptCipherKeysActor*>(this)->SAV<T>::futures) { (void)(t); this->~MonitorGetEncryptCipherKeysActorState(); static_cast<MonitorGetEncryptCipherKeysActor*>(this)->destroy(); return 0; }
															#line 113 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<MonitorGetEncryptCipherKeysActor*>(this)->SAV< T >::value()) T(t);
		this->~MonitorGetEncryptCipherKeysActorState();
		static_cast<MonitorGetEncryptCipherKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
															#line 48 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<MonitorGetEncryptCipherKeysActor*>(this)->SAV<T>::futures) { (void)(t); this->~MonitorGetEncryptCipherKeysActorState(); static_cast<MonitorGetEncryptCipherKeysActor*>(this)->destroy(); return 0; }
															#line 125 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<MonitorGetEncryptCipherKeysActor*>(this)->SAV< T >::value()) T(t);
		this->~MonitorGetEncryptCipherKeysActorState();
		static_cast<MonitorGetEncryptCipherKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 52 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		r = self->handleLongRunningRequest();
															#line 53 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		StrictFuture<T> __when_expr_2 = actor;
															#line 53 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (static_cast<MonitorGetEncryptCipherKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 141 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorGetEncryptCipherKeysActor*>(this)->actor_wait_state = 2;
															#line 53 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorGetEncryptCipherKeysActor, 2, T >*>(static_cast<MonitorGetEncryptCipherKeysActor*>(this)));
															#line 146 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 52 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		r = self->handleLongRunningRequest();
															#line 53 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		StrictFuture<T> __when_expr_2 = actor;
															#line 53 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (static_cast<MonitorGetEncryptCipherKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 159 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorGetEncryptCipherKeysActor*>(this)->actor_wait_state = 2;
															#line 53 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorGetEncryptCipherKeysActor, 2, T >*>(static_cast<MonitorGetEncryptCipherKeysActor*>(this)));
															#line 164 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorGetEncryptCipherKeysActor*>(this)->actor_wait_state > 0) static_cast<MonitorGetEncryptCipherKeysActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGetEncryptCipherKeysActor*>(this)->ActorCallback< MonitorGetEncryptCipherKeysActor, 0, T >::remove();
		static_cast<MonitorGetEncryptCipherKeysActor*>(this)->ActorCallback< MonitorGetEncryptCipherKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGetEncryptCipherKeysActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGetEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorGetEncryptCipherKeysActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGetEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorGetEncryptCipherKeysActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGetEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1when2cont1(T const& t,int loopDepth) 
	{
															#line 54 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<MonitorGetEncryptCipherKeysActor*>(this)->SAV<T>::futures) { (void)(t); this->~MonitorGetEncryptCipherKeysActorState(); static_cast<MonitorGetEncryptCipherKeysActor*>(this)->destroy(); return 0; }
															#line 237 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<MonitorGetEncryptCipherKeysActor*>(this)->SAV< T >::value()) T(t);
		this->~MonitorGetEncryptCipherKeysActorState();
		static_cast<MonitorGetEncryptCipherKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2cont1(T && t,int loopDepth) 
	{
															#line 54 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<MonitorGetEncryptCipherKeysActor*>(this)->SAV<T>::futures) { (void)(t); this->~MonitorGetEncryptCipherKeysActorState(); static_cast<MonitorGetEncryptCipherKeysActor*>(this)->destroy(); return 0; }
															#line 249 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<MonitorGetEncryptCipherKeysActor*>(this)->SAV< T >::value()) T(t);
		this->~MonitorGetEncryptCipherKeysActorState();
		static_cast<MonitorGetEncryptCipherKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1when2cont1(t, loopDepth);

		return loopDepth;
	}
	int a_body1when2when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1when2cont1(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorGetEncryptCipherKeysActor*>(this)->actor_wait_state > 0) static_cast<MonitorGetEncryptCipherKeysActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGetEncryptCipherKeysActor*>(this)->ActorCallback< MonitorGetEncryptCipherKeysActor, 2, T >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGetEncryptCipherKeysActor, 2, T >*,T const& value) 
	{
		fdb_probe_actor_enter("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGetEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorGetEncryptCipherKeysActor, 2, T >*,T && value) 
	{
		fdb_probe_actor_enter("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGetEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorGetEncryptCipherKeysActor, 2, T >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGetEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorGetEncryptCipherKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGetEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorGetEncryptCipherKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGetEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorGetEncryptCipherKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGetEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 43 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	GetEncryptCipherKeysMonitor* self;
															#line 43 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	Future<T> actor;
															#line 52 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	ActiveCounter<int>::Releaser r;
															#line 395 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
};
// This generated class is to be used only via monitorGetEncryptCipherKeys()
															#line 43 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 43 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class MonitorGetEncryptCipherKeysActor final : public Actor<T>, public ActorCallback< MonitorGetEncryptCipherKeysActor<T>, 0, T >, public ActorCallback< MonitorGetEncryptCipherKeysActor<T>, 1, Void >, public ActorCallback< MonitorGetEncryptCipherKeysActor<T>, 2, T >, public FastAllocated<MonitorGetEncryptCipherKeysActor<T>>, public MonitorGetEncryptCipherKeysActorState<T, MonitorGetEncryptCipherKeysActor<T>> {
															#line 402 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
	using FastAllocated<MonitorGetEncryptCipherKeysActor<T>>::operator new;
	using FastAllocated<MonitorGetEncryptCipherKeysActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(876367485886716672UL, 8223848325443789312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorGetEncryptCipherKeysActor<T>, 0, T >;
friend struct ActorCallback< MonitorGetEncryptCipherKeysActor<T>, 1, Void >;
friend struct ActorCallback< MonitorGetEncryptCipherKeysActor<T>, 2, T >;
															#line 43 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	MonitorGetEncryptCipherKeysActor(GetEncryptCipherKeysMonitor* const& self,Future<T> const& actor) 
															#line 421 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		 : Actor<T>(),
		   MonitorGetEncryptCipherKeysActorState<T, MonitorGetEncryptCipherKeysActor<T>>(self, actor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3665104295614261248UL, 9951711197366366464UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGetEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorGetEncryptCipherKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorGetEncryptCipherKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorGetEncryptCipherKeysActor<T>, 0, T >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorGetEncryptCipherKeysActor<T>, 2, T >*)0, actor_cancelled()); break;
		}

	}
};
															#line 43 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 43 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
[[nodiscard]] Future<T> monitorGetEncryptCipherKeys( GetEncryptCipherKeysMonitor* const& self, Future<T> const& actor ) {
															#line 43 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	return Future<T>(new MonitorGetEncryptCipherKeysActor<T>(self, actor));
															#line 456 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
}

#line 58 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
} // anonymous namespace

template <class T>
Future<T> GetEncryptCipherKeysMonitor::monitor(Future<T> actor) {
	return monitorGetEncryptCipherKeys(this, actor);
}

template <class T>
Optional<EncryptKeyProxyInterface> _getEncryptKeyProxyInterface(const Reference<AsyncVar<T> const>& db) {
	if constexpr (std::is_same_v<T, ClientDBInfo>) {
		return db->get().encryptKeyProxy;
	} else {
		return db->get().client.encryptKeyProxy;
	}
}

template <class T>
Optional<UID> getEncryptKeyProxyId(const Reference<AsyncVar<T> const>& db) {
	return _getEncryptKeyProxyInterface(db).map(&EncryptKeyProxyInterface::id);
}

															#line 481 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
namespace {
// This generated class is to be used only via _onEncryptKeyProxyChange()
															#line 79 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T, class _onEncryptKeyProxyChangeActor>
															#line 79 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class _onEncryptKeyProxyChangeActorState {
															#line 488 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
															#line 79 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	_onEncryptKeyProxyChangeActorState(Reference<AsyncVar<T> const> const& db) 
															#line 79 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
															#line 79 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		 : db(db),
															#line 81 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   previousProxyId(getEncryptKeyProxyId(db)),
															#line 82 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   currentProxyId()
															#line 499 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
	{
		fdb_probe_actor_create("_onEncryptKeyProxyChange", reinterpret_cast<unsigned long>(this));

	}
	~_onEncryptKeyProxyChangeActorState() 
	{
		fdb_probe_actor_destroy("_onEncryptKeyProxyChange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 83 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			;
															#line 514 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_onEncryptKeyProxyChangeActorState();
		static_cast<_onEncryptKeyProxyChangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 91 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (DEBUG_GET_CIPHER)
															#line 537 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		{
															#line 92 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			TraceEvent(SevDebug, "GetEncryptCipherKeysEncryptKeyProxyChanged") .detail("PreviousProxyId", previousProxyId.orDefault(UID())) .detail("CurrentProxyId", currentProxyId.orDefault(UID()));
															#line 541 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		}
															#line 97 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<_onEncryptKeyProxyChangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_onEncryptKeyProxyChangeActorState(); static_cast<_onEncryptKeyProxyChangeActor*>(this)->destroy(); return 0; }
															#line 545 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<_onEncryptKeyProxyChangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_onEncryptKeyProxyChangeActorState();
		static_cast<_onEncryptKeyProxyChangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 84 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 84 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (static_cast<_onEncryptKeyProxyChangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 566 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_onEncryptKeyProxyChangeActor*>(this)->actor_wait_state = 1;
															#line 84 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _onEncryptKeyProxyChangeActor, 0, Void >*>(static_cast<_onEncryptKeyProxyChangeActor*>(this)));
															#line 571 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 85 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		currentProxyId = getEncryptKeyProxyId(db);
															#line 86 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (currentProxyId != previousProxyId)
															#line 595 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 85 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		currentProxyId = getEncryptKeyProxyId(db);
															#line 86 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (currentProxyId != previousProxyId)
															#line 609 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_onEncryptKeyProxyChangeActor*>(this)->actor_wait_state > 0) static_cast<_onEncryptKeyProxyChangeActor*>(this)->actor_wait_state = 0;
		static_cast<_onEncryptKeyProxyChangeActor*>(this)->ActorCallback< _onEncryptKeyProxyChangeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _onEncryptKeyProxyChangeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_onEncryptKeyProxyChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_onEncryptKeyProxyChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_onEncryptKeyProxyChange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _onEncryptKeyProxyChangeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_onEncryptKeyProxyChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_onEncryptKeyProxyChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_onEncryptKeyProxyChange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _onEncryptKeyProxyChangeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_onEncryptKeyProxyChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_onEncryptKeyProxyChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_onEncryptKeyProxyChange", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 79 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	Reference<AsyncVar<T> const> db;
															#line 81 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	Optional<UID> previousProxyId;
															#line 82 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	Optional<UID> currentProxyId;
															#line 698 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
};
// This generated class is to be used only via _onEncryptKeyProxyChange()
															#line 79 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 79 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class _onEncryptKeyProxyChangeActor final : public Actor<Void>, public ActorCallback< _onEncryptKeyProxyChangeActor<T>, 0, Void >, public FastAllocated<_onEncryptKeyProxyChangeActor<T>>, public _onEncryptKeyProxyChangeActorState<T, _onEncryptKeyProxyChangeActor<T>> {
															#line 705 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
	using FastAllocated<_onEncryptKeyProxyChangeActor<T>>::operator new;
	using FastAllocated<_onEncryptKeyProxyChangeActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2437794843335704320UL, 11836950929362438656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _onEncryptKeyProxyChangeActor<T>, 0, Void >;
															#line 79 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	_onEncryptKeyProxyChangeActor(Reference<AsyncVar<T> const> const& db) 
															#line 722 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		 : Actor<Void>(),
		   _onEncryptKeyProxyChangeActorState<T, _onEncryptKeyProxyChangeActor<T>>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_onEncryptKeyProxyChange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16936584531928503040UL, 17780235080934712064UL);
		ActorExecutionContextHelper __helper(static_cast<_onEncryptKeyProxyChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_onEncryptKeyProxyChange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_onEncryptKeyProxyChange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _onEncryptKeyProxyChangeActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 79 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 79 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
[[nodiscard]] Future<Void> _onEncryptKeyProxyChange( Reference<AsyncVar<T> const> const& db ) {
															#line 79 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	return Future<Void>(new _onEncryptKeyProxyChangeActor<T>(db));
															#line 757 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
}

#line 99 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"

															#line 762 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
namespace {
// This generated class is to be used only via _getUncachedLatestEncryptCipherKeys()
															#line 100 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T, class _getUncachedLatestEncryptCipherKeysActor>
															#line 100 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class _getUncachedLatestEncryptCipherKeysActorState {
															#line 769 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
															#line 100 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	_getUncachedLatestEncryptCipherKeysActorState(Reference<AsyncVar<T> const> const& db,EKPGetLatestBaseCipherKeysRequest const& request,BlobCipherMetrics::UsageType const& usageType) 
															#line 100 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
															#line 100 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		 : db(db),
															#line 100 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   request(request),
															#line 100 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   usageType(usageType)
															#line 780 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
	{
		fdb_probe_actor_create("_getUncachedLatestEncryptCipherKeys", reinterpret_cast<unsigned long>(this));

	}
	~_getUncachedLatestEncryptCipherKeysActorState() 
	{
		fdb_probe_actor_destroy("_getUncachedLatestEncryptCipherKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 104 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			Optional<EncryptKeyProxyInterface> proxy = _getEncryptKeyProxyInterface(db);
															#line 105 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (!proxy.present())
															#line 797 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 107 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				if (DEBUG_GET_CIPHER)
															#line 801 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				{
															#line 108 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
					TraceEvent(SevDebug, "GetLatestEncryptCipherKeysEncryptKeyProxyNotPresent") .detail("UsageType", toString(usageType));
															#line 805 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				}
															#line 111 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				this->~_getUncachedLatestEncryptCipherKeysActorState();
															#line 809 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 113 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			request.reply.reset();
															#line 815 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			try {
															#line 115 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				StrictFuture<EKPGetLatestBaseCipherKeysReply> __when_expr_0 = proxy.get().getLatestBaseCipherKeys.getReply(request);
															#line 115 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				if (static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 821 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->actor_wait_state = 1;
															#line 115 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _getUncachedLatestEncryptCipherKeysActor, 0, EKPGetLatestBaseCipherKeysReply >*>(static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)));
															#line 826 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_getUncachedLatestEncryptCipherKeysActorState();
		static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 122 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			TraceEvent("GetLatestEncryptCipherKeysCaughtError").error(e);
															#line 123 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (e.code() == error_code_broken_promise)
															#line 858 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 125 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				this->~_getUncachedLatestEncryptCipherKeysActorState();
															#line 862 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 127 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 868 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(EKPGetLatestBaseCipherKeysReply const& reply,int loopDepth) 
	{
															#line 116 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (reply.error.present())
															#line 882 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		{
															#line 117 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			TraceEvent(SevWarn, "GetLatestEncryptCipherKeysRequestFailed").error(reply.error.get());
															#line 118 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			return a_body1Catch2(reply.error.get(), loopDepth);
															#line 888 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		}
															#line 120 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->SAV<EKPGetLatestBaseCipherKeysReply>::futures) { (void)(reply); this->~_getUncachedLatestEncryptCipherKeysActorState(); static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->destroy(); return 0; }
															#line 892 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->SAV< EKPGetLatestBaseCipherKeysReply >::value()) EKPGetLatestBaseCipherKeysReply(reply);
		this->~_getUncachedLatestEncryptCipherKeysActorState();
		static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(EKPGetLatestBaseCipherKeysReply && reply,int loopDepth) 
	{
															#line 116 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (reply.error.present())
															#line 904 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		{
															#line 117 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			TraceEvent(SevWarn, "GetLatestEncryptCipherKeysRequestFailed").error(reply.error.get());
															#line 118 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			return a_body1Catch2(reply.error.get(), loopDepth);
															#line 910 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		}
															#line 120 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->SAV<EKPGetLatestBaseCipherKeysReply>::futures) { (void)(reply); this->~_getUncachedLatestEncryptCipherKeysActorState(); static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->destroy(); return 0; }
															#line 914 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->SAV< EKPGetLatestBaseCipherKeysReply >::value()) EKPGetLatestBaseCipherKeysReply(reply);
		this->~_getUncachedLatestEncryptCipherKeysActorState();
		static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(EKPGetLatestBaseCipherKeysReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont4(reply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(EKPGetLatestBaseCipherKeysReply && reply,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->actor_wait_state > 0) static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->actor_wait_state = 0;
		static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->ActorCallback< _getUncachedLatestEncryptCipherKeysActor, 0, EKPGetLatestBaseCipherKeysReply >::remove();

	}
	void a_callback_fire(ActorCallback< _getUncachedLatestEncryptCipherKeysActor, 0, EKPGetLatestBaseCipherKeysReply >*,EKPGetLatestBaseCipherKeysReply const& value) 
	{
		fdb_probe_actor_enter("_getUncachedLatestEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getUncachedLatestEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _getUncachedLatestEncryptCipherKeysActor, 0, EKPGetLatestBaseCipherKeysReply >*,EKPGetLatestBaseCipherKeysReply && value) 
	{
		fdb_probe_actor_enter("_getUncachedLatestEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getUncachedLatestEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _getUncachedLatestEncryptCipherKeysActor, 0, EKPGetLatestBaseCipherKeysReply >*,Error err) 
	{
		fdb_probe_actor_enter("_getUncachedLatestEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getUncachedLatestEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 100 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	Reference<AsyncVar<T> const> db;
															#line 100 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	EKPGetLatestBaseCipherKeysRequest request;
															#line 100 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	BlobCipherMetrics::UsageType usageType;
															#line 1003 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
};
// This generated class is to be used only via _getUncachedLatestEncryptCipherKeys()
															#line 100 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 100 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class _getUncachedLatestEncryptCipherKeysActor final : public Actor<EKPGetLatestBaseCipherKeysReply>, public ActorCallback< _getUncachedLatestEncryptCipherKeysActor<T>, 0, EKPGetLatestBaseCipherKeysReply >, public FastAllocated<_getUncachedLatestEncryptCipherKeysActor<T>>, public _getUncachedLatestEncryptCipherKeysActorState<T, _getUncachedLatestEncryptCipherKeysActor<T>> {
															#line 1010 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
	using FastAllocated<_getUncachedLatestEncryptCipherKeysActor<T>>::operator new;
	using FastAllocated<_getUncachedLatestEncryptCipherKeysActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10919674785928417024UL, 3376793798323449600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<EKPGetLatestBaseCipherKeysReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _getUncachedLatestEncryptCipherKeysActor<T>, 0, EKPGetLatestBaseCipherKeysReply >;
															#line 100 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	_getUncachedLatestEncryptCipherKeysActor(Reference<AsyncVar<T> const> const& db,EKPGetLatestBaseCipherKeysRequest const& request,BlobCipherMetrics::UsageType const& usageType) 
															#line 1027 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		 : Actor<EKPGetLatestBaseCipherKeysReply>(),
		   _getUncachedLatestEncryptCipherKeysActorState<T, _getUncachedLatestEncryptCipherKeysActor<T>>(db, request, usageType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_getUncachedLatestEncryptCipherKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17493372853307097088UL, 2321049846944339968UL);
		ActorExecutionContextHelper __helper(static_cast<_getUncachedLatestEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_getUncachedLatestEncryptCipherKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_getUncachedLatestEncryptCipherKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _getUncachedLatestEncryptCipherKeysActor<T>, 0, EKPGetLatestBaseCipherKeysReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 100 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 100 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
[[nodiscard]] Future<EKPGetLatestBaseCipherKeysReply> _getUncachedLatestEncryptCipherKeys( Reference<AsyncVar<T> const> const& db, EKPGetLatestBaseCipherKeysRequest const& request, BlobCipherMetrics::UsageType const& usageType ) {
															#line 100 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	return Future<EKPGetLatestBaseCipherKeysReply>(new _getUncachedLatestEncryptCipherKeysActor<T>(db, request, usageType));
															#line 1062 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
}

#line 130 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"

															#line 1067 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
namespace {
// This generated class is to be used only via _getLatestEncryptCipherKeysImpl()
															#line 131 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T, class _getLatestEncryptCipherKeysImplActor>
															#line 131 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class _getLatestEncryptCipherKeysImplActorState {
															#line 1074 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
															#line 131 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	_getLatestEncryptCipherKeysImplActorState(Reference<AsyncVar<T> const> const& db,std::unordered_set<EncryptCipherDomainId> const& domainIds,BlobCipherMetrics::UsageType const& usageType) 
															#line 131 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
															#line 131 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		 : db(db),
															#line 131 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   domainIds(domainIds),
															#line 131 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   usageType(usageType),
															#line 136 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   cipherKeyCache(BlobCipherKeyCache::getInstance()),
															#line 137 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   cipherKeys(),
															#line 138 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   request()
															#line 1091 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
	{
		fdb_probe_actor_create("_getLatestEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this));

	}
	~_getLatestEncryptCipherKeysImplActorState() 
	{
		fdb_probe_actor_destroy("_getLatestEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 140 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (!db.isValid())
															#line 1106 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 141 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				TraceEvent(SevError, "GetLatestEncryptCipherKeysServerDBInfoNotAvailable");
															#line 142 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				return a_body1Catch1(encrypt_ops_error(), loopDepth);
															#line 1112 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			}
															#line 146 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			for( auto& domainId : domainIds ) {
															#line 147 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				Reference<BlobCipherKey> cachedCipherKey = cipherKeyCache->getLatestCipherKey(domainId);
															#line 148 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				if (cachedCipherKey.isValid())
															#line 1120 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				{
															#line 149 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
					cipherKeys[domainId] = cachedCipherKey;
															#line 1124 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				}
				else
				{
															#line 151 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
					request.encryptDomainIds.emplace_back(domainId);
															#line 1130 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				}
			}
															#line 154 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (request.encryptDomainIds.empty())
															#line 1135 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 155 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				if (!static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->SAV<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>>::futures) { (void)(cipherKeys); this->~_getLatestEncryptCipherKeysImplActorState(); static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->destroy(); return 0; }
															#line 1139 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				new (&static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->SAV< std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >::value()) std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>(std::move(cipherKeys)); // state_var_RVO
				this->~_getLatestEncryptCipherKeysImplActorState();
				static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 158 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			startTime = now();
															#line 159 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			;
															#line 1149 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_getLatestEncryptCipherKeysImplActorState();
		static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 189 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		double elapsed = now() - startTime;
															#line 190 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		BlobCipherMetrics::getInstance()->getLatestCipherKeysLatency.addMeasurement(elapsed);
															#line 191 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->SAV<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>>::futures) { (void)(cipherKeys); this->~_getLatestEncryptCipherKeysImplActorState(); static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->destroy(); return 0; }
															#line 1176 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->SAV< std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >::value()) std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>(std::move(cipherKeys)); // state_var_RVO
		this->~_getLatestEncryptCipherKeysImplActorState();
		static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 160 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		StrictFuture<EKPGetLatestBaseCipherKeysReply> __when_expr_0 = _getUncachedLatestEncryptCipherKeys(db, request, usageType);
															#line 159 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1197 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 187 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		StrictFuture<Void> __when_expr_1 = _onEncryptKeyProxyChange(db);
															#line 1201 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->actor_wait_state = 1;
															#line 160 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _getLatestEncryptCipherKeysImplActor, 0, EKPGetLatestBaseCipherKeysReply >*>(static_cast<_getLatestEncryptCipherKeysImplActor*>(this)));
															#line 187 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _getLatestEncryptCipherKeysImplActor, 1, Void >*>(static_cast<_getLatestEncryptCipherKeysImplActor*>(this)));
															#line 1208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(EKPGetLatestBaseCipherKeysReply const& reply,int loopDepth) 
	{
															#line 163 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		for( const EKPBaseCipherDetails& details : reply.baseCipherDetails ) {
															#line 164 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			EncryptCipherDomainId domainId = details.encryptDomainId;
															#line 165 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (domainIds.count(domainId) > 0 && cipherKeys.count(domainId) == 0)
															#line 1240 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 166 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				Reference<BlobCipherKey> cipherKey = cipherKeyCache->insertCipherKey(domainId, details.baseCipherId, details.baseCipherKey.begin(), details.baseCipherKey.size(), details.baseCipherKCV, details.refreshAt, details.expireAt);
															#line 173 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				ASSERT(cipherKey.isValid());
															#line 174 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				cipherKeys[domainId] = cipherKey;
															#line 1248 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			}
		}
															#line 178 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		for( auto domainId : request.encryptDomainIds ) {
															#line 179 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (cipherKeys.count(domainId) == 0)
															#line 1255 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 180 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				TraceEvent(SevWarn, "GetLatestEncryptCipherKeysKeyMissing").detail("DomainId", domainId);
															#line 181 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				return a_body1Catch1(encrypt_key_not_found(), std::max(0, loopDepth - 1));
															#line 1261 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			}
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(EKPGetLatestBaseCipherKeysReply && reply,int loopDepth) 
	{
															#line 163 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		for( const EKPBaseCipherDetails& details : reply.baseCipherDetails ) {
															#line 164 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			EncryptCipherDomainId domainId = details.encryptDomainId;
															#line 165 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (domainIds.count(domainId) > 0 && cipherKeys.count(domainId) == 0)
															#line 1276 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 166 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				Reference<BlobCipherKey> cipherKey = cipherKeyCache->insertCipherKey(domainId, details.baseCipherId, details.baseCipherKey.begin(), details.baseCipherKey.size(), details.baseCipherKCV, details.refreshAt, details.expireAt);
															#line 173 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				ASSERT(cipherKey.isValid());
															#line 174 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				cipherKeys[domainId] = cipherKey;
															#line 1284 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			}
		}
															#line 178 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		for( auto domainId : request.encryptDomainIds ) {
															#line 179 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (cipherKeys.count(domainId) == 0)
															#line 1291 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 180 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				TraceEvent(SevWarn, "GetLatestEncryptCipherKeysKeyMissing").detail("DomainId", domainId);
															#line 181 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				return a_body1Catch1(encrypt_key_not_found(), std::max(0, loopDepth - 1));
															#line 1297 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			}
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->actor_wait_state > 0) static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->actor_wait_state = 0;
		static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->ActorCallback< _getLatestEncryptCipherKeysImplActor, 0, EKPGetLatestBaseCipherKeysReply >::remove();
		static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->ActorCallback< _getLatestEncryptCipherKeysImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _getLatestEncryptCipherKeysImplActor, 0, EKPGetLatestBaseCipherKeysReply >*,EKPGetLatestBaseCipherKeysReply const& value) 
	{
		fdb_probe_actor_enter("_getLatestEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getLatestEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _getLatestEncryptCipherKeysImplActor, 0, EKPGetLatestBaseCipherKeysReply >*,EKPGetLatestBaseCipherKeysReply && value) 
	{
		fdb_probe_actor_enter("_getLatestEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getLatestEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _getLatestEncryptCipherKeysImplActor, 0, EKPGetLatestBaseCipherKeysReply >*,Error err) 
	{
		fdb_probe_actor_enter("_getLatestEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getLatestEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _getLatestEncryptCipherKeysImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_getLatestEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getLatestEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _getLatestEncryptCipherKeysImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_getLatestEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getLatestEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _getLatestEncryptCipherKeysImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_getLatestEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getLatestEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 131 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	Reference<AsyncVar<T> const> db;
															#line 131 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	std::unordered_set<EncryptCipherDomainId> domainIds;
															#line 131 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	BlobCipherMetrics::UsageType usageType;
															#line 136 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	Reference<BlobCipherKeyCache> cipherKeyCache;
															#line 137 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> cipherKeys;
															#line 138 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	EKPGetLatestBaseCipherKeysRequest request;
															#line 158 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	double startTime;
															#line 1451 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
};
// This generated class is to be used only via _getLatestEncryptCipherKeysImpl()
															#line 131 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 131 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class _getLatestEncryptCipherKeysImplActor final : public Actor<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>>, public ActorCallback< _getLatestEncryptCipherKeysImplActor<T>, 0, EKPGetLatestBaseCipherKeysReply >, public ActorCallback< _getLatestEncryptCipherKeysImplActor<T>, 1, Void >, public FastAllocated<_getLatestEncryptCipherKeysImplActor<T>>, public _getLatestEncryptCipherKeysImplActorState<T, _getLatestEncryptCipherKeysImplActor<T>> {
															#line 1458 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
	using FastAllocated<_getLatestEncryptCipherKeysImplActor<T>>::operator new;
	using FastAllocated<_getLatestEncryptCipherKeysImplActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10970553461081855744UL, 10209886089044865280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _getLatestEncryptCipherKeysImplActor<T>, 0, EKPGetLatestBaseCipherKeysReply >;
friend struct ActorCallback< _getLatestEncryptCipherKeysImplActor<T>, 1, Void >;
															#line 131 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	_getLatestEncryptCipherKeysImplActor(Reference<AsyncVar<T> const> const& db,std::unordered_set<EncryptCipherDomainId> const& domainIds,BlobCipherMetrics::UsageType const& usageType) 
															#line 1476 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		 : Actor<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>>(),
		   _getLatestEncryptCipherKeysImplActorState<T, _getLatestEncryptCipherKeysImplActor<T>>(db, domainIds, usageType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_getLatestEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5654900883316095232UL, 18025253051158264832UL);
		ActorExecutionContextHelper __helper(static_cast<_getLatestEncryptCipherKeysImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_getLatestEncryptCipherKeysImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_getLatestEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _getLatestEncryptCipherKeysImplActor<T>, 0, EKPGetLatestBaseCipherKeysReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 131 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 131 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
[[nodiscard]] Future<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> _getLatestEncryptCipherKeysImpl( Reference<AsyncVar<T> const> const& db, std::unordered_set<EncryptCipherDomainId> const& domainIds, BlobCipherMetrics::UsageType const& usageType ) {
															#line 131 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	return Future<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>>(new _getLatestEncryptCipherKeysImplActor<T>(db, domainIds, usageType));
															#line 1511 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
}

#line 193 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"

template <class T>
Future<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> _getLatestEncryptCipherKeys(
    Reference<AsyncVar<T> const> db,
    std::unordered_set<EncryptCipherDomainId> domainIds,
    BlobCipherMetrics::UsageType usageType,
    Reference<GetEncryptCipherKeysMonitor> monitor) {
	Future<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> actor =
	    _getLatestEncryptCipherKeysImpl(db, domainIds, usageType);
	if (monitor.isValid()) {
		actor = monitor->monitor(actor);
	}
	return actor;
}

															#line 1530 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
namespace {
// This generated class is to be used only via _getLatestEncryptCipherKey()
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T, class _getLatestEncryptCipherKeyActor>
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class _getLatestEncryptCipherKeyActorState {
															#line 1537 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	_getLatestEncryptCipherKeyActorState(Reference<AsyncVar<T> const> const& db,EncryptCipherDomainId const& domainId,BlobCipherMetrics::UsageType const& usageType,Reference<GetEncryptCipherKeysMonitor> const& monitor) 
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		 : db(db),
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   domainId(domainId),
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   usageType(usageType),
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   monitor(monitor)
															#line 1550 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
	{
		fdb_probe_actor_create("_getLatestEncryptCipherKey", reinterpret_cast<unsigned long>(this));

	}
	~_getLatestEncryptCipherKeyActorState() 
	{
		fdb_probe_actor_destroy("_getLatestEncryptCipherKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 213 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			std::unordered_set<EncryptCipherDomainId> domainIds{ domainId };
															#line 214 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			StrictFuture<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> __when_expr_0 = _getLatestEncryptCipherKeys(db, domainIds, usageType, monitor);
															#line 214 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (static_cast<_getLatestEncryptCipherKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1569 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_getLatestEncryptCipherKeyActor*>(this)->actor_wait_state = 1;
															#line 214 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _getLatestEncryptCipherKeyActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*>(static_cast<_getLatestEncryptCipherKeyActor*>(this)));
															#line 1574 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_getLatestEncryptCipherKeyActorState();
		static_cast<_getLatestEncryptCipherKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& cipherKey,int loopDepth) 
	{
															#line 217 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<_getLatestEncryptCipherKeyActor*>(this)->SAV<Reference<BlobCipherKey>>::futures) { (void)(cipherKey.at(domainId)); this->~_getLatestEncryptCipherKeyActorState(); static_cast<_getLatestEncryptCipherKeyActor*>(this)->destroy(); return 0; }
															#line 1597 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<_getLatestEncryptCipherKeyActor*>(this)->SAV< Reference<BlobCipherKey> >::value()) Reference<BlobCipherKey>(cipherKey.at(domainId));
		this->~_getLatestEncryptCipherKeyActorState();
		static_cast<_getLatestEncryptCipherKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && cipherKey,int loopDepth) 
	{
															#line 217 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<_getLatestEncryptCipherKeyActor*>(this)->SAV<Reference<BlobCipherKey>>::futures) { (void)(cipherKey.at(domainId)); this->~_getLatestEncryptCipherKeyActorState(); static_cast<_getLatestEncryptCipherKeyActor*>(this)->destroy(); return 0; }
															#line 1609 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<_getLatestEncryptCipherKeyActor*>(this)->SAV< Reference<BlobCipherKey> >::value()) Reference<BlobCipherKey>(cipherKey.at(domainId));
		this->~_getLatestEncryptCipherKeyActorState();
		static_cast<_getLatestEncryptCipherKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& cipherKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(cipherKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && cipherKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cipherKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_getLatestEncryptCipherKeyActor*>(this)->actor_wait_state > 0) static_cast<_getLatestEncryptCipherKeyActor*>(this)->actor_wait_state = 0;
		static_cast<_getLatestEncryptCipherKeyActor*>(this)->ActorCallback< _getLatestEncryptCipherKeyActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >::remove();

	}
	void a_callback_fire(ActorCallback< _getLatestEncryptCipherKeyActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& value) 
	{
		fdb_probe_actor_enter("_getLatestEncryptCipherKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getLatestEncryptCipherKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getLatestEncryptCipherKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _getLatestEncryptCipherKeyActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && value) 
	{
		fdb_probe_actor_enter("_getLatestEncryptCipherKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getLatestEncryptCipherKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getLatestEncryptCipherKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _getLatestEncryptCipherKeyActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,Error err) 
	{
		fdb_probe_actor_enter("_getLatestEncryptCipherKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_getLatestEncryptCipherKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getLatestEncryptCipherKey", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	Reference<AsyncVar<T> const> db;
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	EncryptCipherDomainId domainId;
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	BlobCipherMetrics::UsageType usageType;
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	Reference<GetEncryptCipherKeysMonitor> monitor;
															#line 1700 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
};
// This generated class is to be used only via _getLatestEncryptCipherKey()
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class _getLatestEncryptCipherKeyActor final : public Actor<Reference<BlobCipherKey>>, public ActorCallback< _getLatestEncryptCipherKeyActor<T>, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >, public FastAllocated<_getLatestEncryptCipherKeyActor<T>>, public _getLatestEncryptCipherKeyActorState<T, _getLatestEncryptCipherKeyActor<T>> {
															#line 1707 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
	using FastAllocated<_getLatestEncryptCipherKeyActor<T>>::operator new;
	using FastAllocated<_getLatestEncryptCipherKeyActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5906934411686081280UL, 13057038810264941312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<BlobCipherKey>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _getLatestEncryptCipherKeyActor<T>, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >;
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	_getLatestEncryptCipherKeyActor(Reference<AsyncVar<T> const> const& db,EncryptCipherDomainId const& domainId,BlobCipherMetrics::UsageType const& usageType,Reference<GetEncryptCipherKeysMonitor> const& monitor) 
															#line 1724 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		 : Actor<Reference<BlobCipherKey>>(),
		   _getLatestEncryptCipherKeyActorState<T, _getLatestEncryptCipherKeyActor<T>>(db, domainId, usageType, monitor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_getLatestEncryptCipherKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7774148917906458368UL, 11979886249217756928UL);
		ActorExecutionContextHelper __helper(static_cast<_getLatestEncryptCipherKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_getLatestEncryptCipherKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_getLatestEncryptCipherKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _getLatestEncryptCipherKeyActor<T>, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
[[nodiscard]] Future<Reference<BlobCipherKey>> _getLatestEncryptCipherKey( Reference<AsyncVar<T> const> const& db, EncryptCipherDomainId const& domainId, BlobCipherMetrics::UsageType const& usageType, Reference<GetEncryptCipherKeysMonitor> const& monitor ) {
															#line 208 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	return Future<Reference<BlobCipherKey>>(new _getLatestEncryptCipherKeyActor<T>(db, domainId, usageType, monitor));
															#line 1759 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
}

#line 219 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"

															#line 1764 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
namespace {
// This generated class is to be used only via _getUncachedEncryptCipherKeys()
															#line 220 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T, class _getUncachedEncryptCipherKeysActor>
															#line 220 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class _getUncachedEncryptCipherKeysActorState {
															#line 1771 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
															#line 220 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	_getUncachedEncryptCipherKeysActorState(Reference<AsyncVar<T> const> const& db,EKPGetBaseCipherKeysByIdsRequest const& request,BlobCipherMetrics::UsageType const& usageType) 
															#line 220 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
															#line 220 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		 : db(db),
															#line 220 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   request(request),
															#line 220 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   usageType(usageType)
															#line 1782 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
	{
		fdb_probe_actor_create("_getUncachedEncryptCipherKeys", reinterpret_cast<unsigned long>(this));

	}
	~_getUncachedEncryptCipherKeysActorState() 
	{
		fdb_probe_actor_destroy("_getUncachedEncryptCipherKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 224 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			Optional<EncryptKeyProxyInterface> proxy = _getEncryptKeyProxyInterface(db);
															#line 225 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (!proxy.present())
															#line 1799 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 227 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				if (DEBUG_GET_CIPHER)
															#line 1803 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				{
															#line 228 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
					TraceEvent(SevDebug, "GetEncryptCipherKeysEncryptKeyProxyNotPresent") .detail("UsageType", toString(usageType));
															#line 1807 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				}
															#line 231 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				this->~_getUncachedEncryptCipherKeysActorState();
															#line 1811 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				static_cast<_getUncachedEncryptCipherKeysActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 233 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			request.reply.reset();
															#line 1817 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			try {
															#line 235 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				StrictFuture<EKPGetBaseCipherKeysByIdsReply> __when_expr_0 = proxy.get().getBaseCipherKeysByIds.getReply(request);
															#line 235 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				if (static_cast<_getUncachedEncryptCipherKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1823 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_getUncachedEncryptCipherKeysActor*>(this)->actor_wait_state = 1;
															#line 235 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _getUncachedEncryptCipherKeysActor, 0, EKPGetBaseCipherKeysByIdsReply >*>(static_cast<_getUncachedEncryptCipherKeysActor*>(this)));
															#line 1828 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_getUncachedEncryptCipherKeysActorState();
		static_cast<_getUncachedEncryptCipherKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 260 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			TraceEvent("GetEncryptCipherKeysCaughtError").error(e);
															#line 261 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (e.code() == error_code_broken_promise)
															#line 1860 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 263 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				this->~_getUncachedEncryptCipherKeysActorState();
															#line 1864 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				static_cast<_getUncachedEncryptCipherKeysActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 265 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 1870 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(EKPGetBaseCipherKeysByIdsReply const& reply,int loopDepth) 
	{
															#line 236 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (reply.error.present())
															#line 1884 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		{
															#line 237 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			TraceEvent(SevWarn, "GetEncryptCipherKeysRequestFailed").error(reply.error.get());
															#line 238 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			return a_body1Catch2(reply.error.get(), loopDepth);
															#line 1890 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		}
															#line 242 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (g_network && g_network->isSimulated() && usageType == BlobCipherMetrics::RESTORE)
															#line 1894 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		{
															#line 243 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			std::unordered_set<int64_t> tenantIdsToDrop = parseStringToUnorderedSet<int64_t>(CLIENT_KNOBS->SIMULATION_EKP_TENANT_IDS_TO_DROP, ',');
															#line 245 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (!tenantIdsToDrop.count(TenantInfo::INVALID_TENANT))
															#line 1900 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 246 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				for( auto& baseCipherInfo : request.baseCipherInfos ) {
															#line 247 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
					if (tenantIdsToDrop.count(baseCipherInfo.domainId))
															#line 1906 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
					{
															#line 248 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
						TraceEvent("GetEncryptCipherKeysSimulatedError").detail("DomainId", baseCipherInfo.domainId);
															#line 249 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
						if (deterministicRandom()->coinflip())
															#line 1912 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
						{
															#line 250 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
							return a_body1Catch2(encrypt_keys_fetch_failed(), loopDepth);
															#line 1916 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
						}
						else
						{
															#line 252 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
							return a_body1Catch2(encrypt_key_not_found(), loopDepth);
															#line 1922 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
						}
					}
				}
			}
		}
															#line 258 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<_getUncachedEncryptCipherKeysActor*>(this)->SAV<EKPGetBaseCipherKeysByIdsReply>::futures) { (void)(reply); this->~_getUncachedEncryptCipherKeysActorState(); static_cast<_getUncachedEncryptCipherKeysActor*>(this)->destroy(); return 0; }
															#line 1930 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<_getUncachedEncryptCipherKeysActor*>(this)->SAV< EKPGetBaseCipherKeysByIdsReply >::value()) EKPGetBaseCipherKeysByIdsReply(reply);
		this->~_getUncachedEncryptCipherKeysActorState();
		static_cast<_getUncachedEncryptCipherKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(EKPGetBaseCipherKeysByIdsReply && reply,int loopDepth) 
	{
															#line 236 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (reply.error.present())
															#line 1942 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		{
															#line 237 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			TraceEvent(SevWarn, "GetEncryptCipherKeysRequestFailed").error(reply.error.get());
															#line 238 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			return a_body1Catch2(reply.error.get(), loopDepth);
															#line 1948 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		}
															#line 242 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (g_network && g_network->isSimulated() && usageType == BlobCipherMetrics::RESTORE)
															#line 1952 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		{
															#line 243 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			std::unordered_set<int64_t> tenantIdsToDrop = parseStringToUnorderedSet<int64_t>(CLIENT_KNOBS->SIMULATION_EKP_TENANT_IDS_TO_DROP, ',');
															#line 245 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (!tenantIdsToDrop.count(TenantInfo::INVALID_TENANT))
															#line 1958 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 246 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				for( auto& baseCipherInfo : request.baseCipherInfos ) {
															#line 247 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
					if (tenantIdsToDrop.count(baseCipherInfo.domainId))
															#line 1964 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
					{
															#line 248 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
						TraceEvent("GetEncryptCipherKeysSimulatedError").detail("DomainId", baseCipherInfo.domainId);
															#line 249 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
						if (deterministicRandom()->coinflip())
															#line 1970 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
						{
															#line 250 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
							return a_body1Catch2(encrypt_keys_fetch_failed(), loopDepth);
															#line 1974 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
						}
						else
						{
															#line 252 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
							return a_body1Catch2(encrypt_key_not_found(), loopDepth);
															#line 1980 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
						}
					}
				}
			}
		}
															#line 258 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<_getUncachedEncryptCipherKeysActor*>(this)->SAV<EKPGetBaseCipherKeysByIdsReply>::futures) { (void)(reply); this->~_getUncachedEncryptCipherKeysActorState(); static_cast<_getUncachedEncryptCipherKeysActor*>(this)->destroy(); return 0; }
															#line 1988 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<_getUncachedEncryptCipherKeysActor*>(this)->SAV< EKPGetBaseCipherKeysByIdsReply >::value()) EKPGetBaseCipherKeysByIdsReply(reply);
		this->~_getUncachedEncryptCipherKeysActorState();
		static_cast<_getUncachedEncryptCipherKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(EKPGetBaseCipherKeysByIdsReply const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont4(reply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(EKPGetBaseCipherKeysByIdsReply && reply,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_getUncachedEncryptCipherKeysActor*>(this)->actor_wait_state > 0) static_cast<_getUncachedEncryptCipherKeysActor*>(this)->actor_wait_state = 0;
		static_cast<_getUncachedEncryptCipherKeysActor*>(this)->ActorCallback< _getUncachedEncryptCipherKeysActor, 0, EKPGetBaseCipherKeysByIdsReply >::remove();

	}
	void a_callback_fire(ActorCallback< _getUncachedEncryptCipherKeysActor, 0, EKPGetBaseCipherKeysByIdsReply >*,EKPGetBaseCipherKeysByIdsReply const& value) 
	{
		fdb_probe_actor_enter("_getUncachedEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getUncachedEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getUncachedEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _getUncachedEncryptCipherKeysActor, 0, EKPGetBaseCipherKeysByIdsReply >*,EKPGetBaseCipherKeysByIdsReply && value) 
	{
		fdb_probe_actor_enter("_getUncachedEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getUncachedEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getUncachedEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _getUncachedEncryptCipherKeysActor, 0, EKPGetBaseCipherKeysByIdsReply >*,Error err) 
	{
		fdb_probe_actor_enter("_getUncachedEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_getUncachedEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getUncachedEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 220 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	Reference<AsyncVar<T> const> db;
															#line 220 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	EKPGetBaseCipherKeysByIdsRequest request;
															#line 220 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	BlobCipherMetrics::UsageType usageType;
															#line 2077 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
};
// This generated class is to be used only via _getUncachedEncryptCipherKeys()
															#line 220 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 220 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class _getUncachedEncryptCipherKeysActor final : public Actor<EKPGetBaseCipherKeysByIdsReply>, public ActorCallback< _getUncachedEncryptCipherKeysActor<T>, 0, EKPGetBaseCipherKeysByIdsReply >, public FastAllocated<_getUncachedEncryptCipherKeysActor<T>>, public _getUncachedEncryptCipherKeysActorState<T, _getUncachedEncryptCipherKeysActor<T>> {
															#line 2084 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
	using FastAllocated<_getUncachedEncryptCipherKeysActor<T>>::operator new;
	using FastAllocated<_getUncachedEncryptCipherKeysActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15345739162258079744UL, 5568268800405463296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<EKPGetBaseCipherKeysByIdsReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _getUncachedEncryptCipherKeysActor<T>, 0, EKPGetBaseCipherKeysByIdsReply >;
															#line 220 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	_getUncachedEncryptCipherKeysActor(Reference<AsyncVar<T> const> const& db,EKPGetBaseCipherKeysByIdsRequest const& request,BlobCipherMetrics::UsageType const& usageType) 
															#line 2101 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		 : Actor<EKPGetBaseCipherKeysByIdsReply>(),
		   _getUncachedEncryptCipherKeysActorState<T, _getUncachedEncryptCipherKeysActor<T>>(db, request, usageType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_getUncachedEncryptCipherKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8356268921510150912UL, 16253733755251264000UL);
		ActorExecutionContextHelper __helper(static_cast<_getUncachedEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_getUncachedEncryptCipherKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_getUncachedEncryptCipherKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _getUncachedEncryptCipherKeysActor<T>, 0, EKPGetBaseCipherKeysByIdsReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 220 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 220 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
[[nodiscard]] Future<EKPGetBaseCipherKeysByIdsReply> _getUncachedEncryptCipherKeys( Reference<AsyncVar<T> const> const& db, EKPGetBaseCipherKeysByIdsRequest const& request, BlobCipherMetrics::UsageType const& usageType ) {
															#line 220 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	return Future<EKPGetBaseCipherKeysByIdsReply>(new _getUncachedEncryptCipherKeysActor<T>(db, request, usageType));
															#line 2136 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
}

#line 268 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"

// Get cipher keys specified by the list of cipher details. It tries to get the cipher keys from local cache.
// In case of cache miss, it fetches the cipher keys from EncryptKeyProxy and put the result in the local cache
// before return.
															#line 2144 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
namespace {
// This generated class is to be used only via _getEncryptCipherKeysImpl()
															#line 272 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T, class _getEncryptCipherKeysImplActor>
															#line 272 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class _getEncryptCipherKeysImplActorState {
															#line 2151 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
															#line 272 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	_getEncryptCipherKeysImplActorState(Reference<AsyncVar<T> const> const& db,std::unordered_set<BlobCipherDetails> const& cipherDetails,BlobCipherMetrics::UsageType const& usageType) 
															#line 272 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
															#line 272 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		 : db(db),
															#line 272 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   cipherDetails(cipherDetails),
															#line 272 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   usageType(usageType),
															#line 277 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   cipherKeyCache(BlobCipherKeyCache::getInstance()),
															#line 278 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   cipherKeys(),
															#line 279 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   uncachedBaseCipherIds(),
															#line 280 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   request()
															#line 2170 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
	{
		fdb_probe_actor_create("_getEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this));

	}
	~_getEncryptCipherKeysImplActorState() 
	{
		fdb_probe_actor_destroy("_getEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 282 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (!db.isValid())
															#line 2185 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 283 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				TraceEvent(SevError, "GetEncryptCipherKeysServerDBInfoNotAvailable");
															#line 284 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				return a_body1Catch1(encrypt_ops_error(), loopDepth);
															#line 2191 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			}
															#line 288 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			for( const BlobCipherDetails& details : cipherDetails ) {
															#line 289 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				Reference<BlobCipherKey> cachedCipherKey = cipherKeyCache->getCipherKey(details.encryptDomainId, details.baseCipherId, details.salt);
															#line 291 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				if (cachedCipherKey.isValid())
															#line 2199 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				{
															#line 292 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
					cipherKeys.emplace(details, cachedCipherKey);
															#line 2203 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				}
				else
				{
															#line 294 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
					uncachedBaseCipherIds.insert(std::make_pair(details.encryptDomainId, details.baseCipherId));
															#line 2209 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				}
			}
															#line 297 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (uncachedBaseCipherIds.empty())
															#line 2214 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 298 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				if (!static_cast<_getEncryptCipherKeysImplActor*>(this)->SAV<std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>>>::futures) { (void)(cipherKeys); this->~_getEncryptCipherKeysImplActorState(); static_cast<_getEncryptCipherKeysImplActor*>(this)->destroy(); return 0; }
															#line 2218 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
				new (&static_cast<_getEncryptCipherKeysImplActor*>(this)->SAV< std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >::value()) std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>>(std::move(cipherKeys)); // state_var_RVO
				this->~_getEncryptCipherKeysImplActorState();
				static_cast<_getEncryptCipherKeysImplActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 300 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			for( const BaseCipherIndex& id : uncachedBaseCipherIds ) {
															#line 301 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				request.baseCipherInfos.emplace_back(id.first , id.second );
															#line 2228 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			}
															#line 304 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			startTime = now();
															#line 305 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			;
															#line 2234 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_getEncryptCipherKeysImplActorState();
		static_cast<_getEncryptCipherKeysImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 341 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		double elapsed = now() - startTime;
															#line 342 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		BlobCipherMetrics::getInstance()->getCipherKeysLatency.addMeasurement(elapsed);
															#line 343 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<_getEncryptCipherKeysImplActor*>(this)->SAV<std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>>>::futures) { (void)(cipherKeys); this->~_getEncryptCipherKeysImplActorState(); static_cast<_getEncryptCipherKeysImplActor*>(this)->destroy(); return 0; }
															#line 2261 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<_getEncryptCipherKeysImplActor*>(this)->SAV< std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >::value()) std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>>(std::move(cipherKeys)); // state_var_RVO
		this->~_getEncryptCipherKeysImplActorState();
		static_cast<_getEncryptCipherKeysImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 306 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		StrictFuture<EKPGetBaseCipherKeysByIdsReply> __when_expr_0 = _getUncachedEncryptCipherKeys(db, request, usageType);
															#line 305 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (static_cast<_getEncryptCipherKeysImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2282 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 339 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		StrictFuture<Void> __when_expr_1 = _onEncryptKeyProxyChange(db);
															#line 2286 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<_getEncryptCipherKeysImplActor*>(this)->actor_wait_state = 1;
															#line 306 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _getEncryptCipherKeysImplActor, 0, EKPGetBaseCipherKeysByIdsReply >*>(static_cast<_getEncryptCipherKeysImplActor*>(this)));
															#line 339 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _getEncryptCipherKeysImplActor, 1, Void >*>(static_cast<_getEncryptCipherKeysImplActor*>(this)));
															#line 2293 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(EKPGetBaseCipherKeysByIdsReply const& reply,int loopDepth) 
	{
															#line 307 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		std::unordered_map<BaseCipherIndex, EKPBaseCipherDetails, boost::hash<BaseCipherIndex>> baseCipherKeys;
															#line 308 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		for( const EKPBaseCipherDetails& baseDetails : reply.baseCipherDetails ) {
															#line 309 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			BaseCipherIndex baseIdx = std::make_pair(baseDetails.encryptDomainId, baseDetails.baseCipherId);
															#line 310 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			baseCipherKeys[baseIdx] = baseDetails;
															#line 2327 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		}
															#line 313 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		for( const BlobCipherDetails& details : cipherDetails ) {
															#line 314 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (cipherKeys.count(details) > 0)
															#line 2333 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
				continue;
			}
															#line 317 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			BaseCipherIndex baseIdx = std::make_pair(details.encryptDomainId, details.baseCipherId);
															#line 318 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			const auto& itr = baseCipherKeys.find(baseIdx);
															#line 319 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (itr == baseCipherKeys.end())
															#line 2343 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 320 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				TraceEvent(SevError, "GetEncryptCipherKeysKeyMissing") .detail("DomainId", details.encryptDomainId) .detail("BaseCipherId", details.baseCipherId);
															#line 323 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				return a_body1Catch1(encrypt_key_not_found(), std::max(0, loopDepth - 1));
															#line 2349 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			}
															#line 325 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			Reference<BlobCipherKey> cipherKey = cipherKeyCache->insertCipherKey(details.encryptDomainId, details.baseCipherId, itr->second.baseCipherKey.begin(), itr->second.baseCipherKey.size(), itr->second.baseCipherKCV, details.salt, itr->second.refreshAt, itr->second.expireAt);
															#line 333 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			ASSERT(cipherKey.isValid());
															#line 334 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			cipherKeys[details] = cipherKey;
															#line 2357 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(EKPGetBaseCipherKeysByIdsReply && reply,int loopDepth) 
	{
															#line 307 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		std::unordered_map<BaseCipherIndex, EKPBaseCipherDetails, boost::hash<BaseCipherIndex>> baseCipherKeys;
															#line 308 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		for( const EKPBaseCipherDetails& baseDetails : reply.baseCipherDetails ) {
															#line 309 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			BaseCipherIndex baseIdx = std::make_pair(baseDetails.encryptDomainId, baseDetails.baseCipherId);
															#line 310 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			baseCipherKeys[baseIdx] = baseDetails;
															#line 2373 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		}
															#line 313 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		for( const BlobCipherDetails& details : cipherDetails ) {
															#line 314 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (cipherKeys.count(details) > 0)
															#line 2379 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
				continue;
			}
															#line 317 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			BaseCipherIndex baseIdx = std::make_pair(details.encryptDomainId, details.baseCipherId);
															#line 318 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			const auto& itr = baseCipherKeys.find(baseIdx);
															#line 319 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (itr == baseCipherKeys.end())
															#line 2389 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 320 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				TraceEvent(SevError, "GetEncryptCipherKeysKeyMissing") .detail("DomainId", details.encryptDomainId) .detail("BaseCipherId", details.baseCipherId);
															#line 323 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				return a_body1Catch1(encrypt_key_not_found(), std::max(0, loopDepth - 1));
															#line 2395 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			}
															#line 325 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			Reference<BlobCipherKey> cipherKey = cipherKeyCache->insertCipherKey(details.encryptDomainId, details.baseCipherId, itr->second.baseCipherKey.begin(), itr->second.baseCipherKey.size(), itr->second.baseCipherKCV, details.salt, itr->second.refreshAt, itr->second.expireAt);
															#line 333 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			ASSERT(cipherKey.isValid());
															#line 334 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			cipherKeys[details] = cipherKey;
															#line 2403 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_getEncryptCipherKeysImplActor*>(this)->actor_wait_state > 0) static_cast<_getEncryptCipherKeysImplActor*>(this)->actor_wait_state = 0;
		static_cast<_getEncryptCipherKeysImplActor*>(this)->ActorCallback< _getEncryptCipherKeysImplActor, 0, EKPGetBaseCipherKeysByIdsReply >::remove();
		static_cast<_getEncryptCipherKeysImplActor*>(this)->ActorCallback< _getEncryptCipherKeysImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _getEncryptCipherKeysImplActor, 0, EKPGetBaseCipherKeysByIdsReply >*,EKPGetBaseCipherKeysByIdsReply const& value) 
	{
		fdb_probe_actor_enter("_getEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getEncryptCipherKeysImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _getEncryptCipherKeysImplActor, 0, EKPGetBaseCipherKeysByIdsReply >*,EKPGetBaseCipherKeysByIdsReply && value) 
	{
		fdb_probe_actor_enter("_getEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getEncryptCipherKeysImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _getEncryptCipherKeysImplActor, 0, EKPGetBaseCipherKeysByIdsReply >*,Error err) 
	{
		fdb_probe_actor_enter("_getEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_getEncryptCipherKeysImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _getEncryptCipherKeysImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_getEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getEncryptCipherKeysImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _getEncryptCipherKeysImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_getEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getEncryptCipherKeysImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _getEncryptCipherKeysImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_getEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_getEncryptCipherKeysImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 272 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	Reference<AsyncVar<T> const> db;
															#line 272 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	std::unordered_set<BlobCipherDetails> cipherDetails;
															#line 272 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	BlobCipherMetrics::UsageType usageType;
															#line 277 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	Reference<BlobCipherKeyCache> cipherKeyCache;
															#line 278 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> cipherKeys;
															#line 279 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	std::unordered_set<BaseCipherIndex, boost::hash<BaseCipherIndex>> uncachedBaseCipherIds;
															#line 280 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	EKPGetBaseCipherKeysByIdsRequest request;
															#line 304 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	double startTime;
															#line 2558 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
};
// This generated class is to be used only via _getEncryptCipherKeysImpl()
															#line 272 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 272 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class _getEncryptCipherKeysImplActor final : public Actor<std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>>>, public ActorCallback< _getEncryptCipherKeysImplActor<T>, 0, EKPGetBaseCipherKeysByIdsReply >, public ActorCallback< _getEncryptCipherKeysImplActor<T>, 1, Void >, public FastAllocated<_getEncryptCipherKeysImplActor<T>>, public _getEncryptCipherKeysImplActorState<T, _getEncryptCipherKeysImplActor<T>> {
															#line 2565 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
	using FastAllocated<_getEncryptCipherKeysImplActor<T>>::operator new;
	using FastAllocated<_getEncryptCipherKeysImplActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16973869875076918272UL, 12556721206442815744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _getEncryptCipherKeysImplActor<T>, 0, EKPGetBaseCipherKeysByIdsReply >;
friend struct ActorCallback< _getEncryptCipherKeysImplActor<T>, 1, Void >;
															#line 272 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	_getEncryptCipherKeysImplActor(Reference<AsyncVar<T> const> const& db,std::unordered_set<BlobCipherDetails> const& cipherDetails,BlobCipherMetrics::UsageType const& usageType) 
															#line 2583 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		 : Actor<std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>>>(),
		   _getEncryptCipherKeysImplActorState<T, _getEncryptCipherKeysImplActor<T>>(db, cipherDetails, usageType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_getEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(252802492969265664UL, 4220177188236655104UL);
		ActorExecutionContextHelper __helper(static_cast<_getEncryptCipherKeysImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_getEncryptCipherKeysImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_getEncryptCipherKeysImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _getEncryptCipherKeysImplActor<T>, 0, EKPGetBaseCipherKeysByIdsReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 272 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 272 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
[[nodiscard]] Future<std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>>> _getEncryptCipherKeysImpl( Reference<AsyncVar<T> const> const& db, std::unordered_set<BlobCipherDetails> const& cipherDetails, BlobCipherMetrics::UsageType const& usageType ) {
															#line 272 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	return Future<std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>>>(new _getEncryptCipherKeysImplActor<T>(db, cipherDetails, usageType));
															#line 2618 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
}

#line 345 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"

template <class T>
Future<std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>>> _getEncryptCipherKeys(
    Reference<AsyncVar<T> const> db,
    std::unordered_set<BlobCipherDetails> cipherDetails,
    BlobCipherMetrics::UsageType usageType,
    Reference<GetEncryptCipherKeysMonitor> monitor) {
	Future<std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>>> actor =
	    _getEncryptCipherKeysImpl(db, cipherDetails, usageType);
	if (monitor.isValid()) {
		actor = monitor->monitor(actor);
	}
	return actor;
}

															#line 2637 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
namespace {
// This generated class is to be used only via _getLatestEncryptCipherKeysForDomain()
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T, class _getLatestEncryptCipherKeysForDomainActor>
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class _getLatestEncryptCipherKeysForDomainActorState {
															#line 2644 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	_getLatestEncryptCipherKeysForDomainActorState(Reference<AsyncVar<T> const> const& db,EncryptCipherDomainId const& domainId,BlobCipherMetrics::UsageType const& usageType,Reference<GetEncryptCipherKeysMonitor> const& monitor) 
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		 : db(db),
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   domainId(domainId),
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   usageType(usageType),
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   monitor(monitor)
															#line 2657 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
	{
		fdb_probe_actor_create("_getLatestEncryptCipherKeysForDomain", reinterpret_cast<unsigned long>(this));

	}
	~_getLatestEncryptCipherKeysForDomainActorState() 
	{
		fdb_probe_actor_destroy("_getLatestEncryptCipherKeysForDomain", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 366 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			std::unordered_set<EncryptCipherDomainId> domainIds = { domainId, ENCRYPT_HEADER_DOMAIN_ID };
															#line 367 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			StrictFuture<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> __when_expr_0 = _getLatestEncryptCipherKeys(db, domainIds, usageType, monitor);
															#line 367 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2676 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->actor_wait_state = 1;
															#line 367 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _getLatestEncryptCipherKeysForDomainActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*>(static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)));
															#line 2681 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_getLatestEncryptCipherKeysForDomainActorState();
		static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& cipherKeys,int loopDepth) 
	{
															#line 369 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		ASSERT(cipherKeys.count(domainId) > 0);
															#line 370 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		ASSERT(cipherKeys.count(ENCRYPT_HEADER_DOMAIN_ID) > 0);
															#line 371 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		TextAndHeaderCipherKeys result{ cipherKeys.at(domainId), cipherKeys.at(ENCRYPT_HEADER_DOMAIN_ID) };
															#line 372 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		ASSERT(result.cipherTextKey.isValid());
															#line 373 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		ASSERT(result.cipherHeaderKey.isValid());
															#line 374 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->SAV<TextAndHeaderCipherKeys>::futures) { (void)(result); this->~_getLatestEncryptCipherKeysForDomainActorState(); static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->destroy(); return 0; }
															#line 2714 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->SAV< TextAndHeaderCipherKeys >::value()) TextAndHeaderCipherKeys(result);
		this->~_getLatestEncryptCipherKeysForDomainActorState();
		static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && cipherKeys,int loopDepth) 
	{
															#line 369 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		ASSERT(cipherKeys.count(domainId) > 0);
															#line 370 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		ASSERT(cipherKeys.count(ENCRYPT_HEADER_DOMAIN_ID) > 0);
															#line 371 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		TextAndHeaderCipherKeys result{ cipherKeys.at(domainId), cipherKeys.at(ENCRYPT_HEADER_DOMAIN_ID) };
															#line 372 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		ASSERT(result.cipherTextKey.isValid());
															#line 373 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		ASSERT(result.cipherHeaderKey.isValid());
															#line 374 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->SAV<TextAndHeaderCipherKeys>::futures) { (void)(result); this->~_getLatestEncryptCipherKeysForDomainActorState(); static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->destroy(); return 0; }
															#line 2736 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->SAV< TextAndHeaderCipherKeys >::value()) TextAndHeaderCipherKeys(result);
		this->~_getLatestEncryptCipherKeysForDomainActorState();
		static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(cipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->actor_wait_state > 0) static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->actor_wait_state = 0;
		static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->ActorCallback< _getLatestEncryptCipherKeysForDomainActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >::remove();

	}
	void a_callback_fire(ActorCallback< _getLatestEncryptCipherKeysForDomainActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& value) 
	{
		fdb_probe_actor_enter("_getLatestEncryptCipherKeysForDomain", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getLatestEncryptCipherKeysForDomain", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _getLatestEncryptCipherKeysForDomainActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && value) 
	{
		fdb_probe_actor_enter("_getLatestEncryptCipherKeysForDomain", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getLatestEncryptCipherKeysForDomain", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _getLatestEncryptCipherKeysForDomainActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,Error err) 
	{
		fdb_probe_actor_enter("_getLatestEncryptCipherKeysForDomain", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getLatestEncryptCipherKeysForDomain", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	Reference<AsyncVar<T> const> db;
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	EncryptCipherDomainId domainId;
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	BlobCipherMetrics::UsageType usageType;
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	Reference<GetEncryptCipherKeysMonitor> monitor;
															#line 2827 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
};
// This generated class is to be used only via _getLatestEncryptCipherKeysForDomain()
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class _getLatestEncryptCipherKeysForDomainActor final : public Actor<TextAndHeaderCipherKeys>, public ActorCallback< _getLatestEncryptCipherKeysForDomainActor<T>, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >, public FastAllocated<_getLatestEncryptCipherKeysForDomainActor<T>>, public _getLatestEncryptCipherKeysForDomainActorState<T, _getLatestEncryptCipherKeysForDomainActor<T>> {
															#line 2834 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
	using FastAllocated<_getLatestEncryptCipherKeysForDomainActor<T>>::operator new;
	using FastAllocated<_getLatestEncryptCipherKeysForDomainActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14719807879570583808UL, 16095544614531527680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<TextAndHeaderCipherKeys>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _getLatestEncryptCipherKeysForDomainActor<T>, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >;
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	_getLatestEncryptCipherKeysForDomainActor(Reference<AsyncVar<T> const> const& db,EncryptCipherDomainId const& domainId,BlobCipherMetrics::UsageType const& usageType,Reference<GetEncryptCipherKeysMonitor> const& monitor) 
															#line 2851 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		 : Actor<TextAndHeaderCipherKeys>(),
		   _getLatestEncryptCipherKeysForDomainActorState<T, _getLatestEncryptCipherKeysForDomainActor<T>>(db, domainId, usageType, monitor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_getLatestEncryptCipherKeysForDomain", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3156348830547227648UL, 4105446179500142592UL);
		ActorExecutionContextHelper __helper(static_cast<_getLatestEncryptCipherKeysForDomainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_getLatestEncryptCipherKeysForDomain");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_getLatestEncryptCipherKeysForDomain", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _getLatestEncryptCipherKeysForDomainActor<T>, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
[[nodiscard]] Future<TextAndHeaderCipherKeys> _getLatestEncryptCipherKeysForDomain( Reference<AsyncVar<T> const> const& db, EncryptCipherDomainId const& domainId, BlobCipherMetrics::UsageType const& usageType, Reference<GetEncryptCipherKeysMonitor> const& monitor ) {
															#line 360 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	return Future<TextAndHeaderCipherKeys>(new _getLatestEncryptCipherKeysForDomainActor<T>(db, domainId, usageType, monitor));
															#line 2886 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
}

#line 376 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"

template <class T>
Future<TextAndHeaderCipherKeys> _getLatestSystemEncryptCipherKeys(const Reference<AsyncVar<T> const>& db,
                                                                  BlobCipherMetrics::UsageType usageType,
                                                                  Reference<GetEncryptCipherKeysMonitor> monitor) {
	return _getLatestEncryptCipherKeysForDomain(db, SYSTEM_KEYSPACE_ENCRYPT_DOMAIN_ID, usageType, monitor);
}

															#line 2898 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
namespace {
// This generated class is to be used only via _getEncryptCipherKeys()
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T, class _getEncryptCipherKeysActor>
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class _getEncryptCipherKeysActorState {
															#line 2905 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	_getEncryptCipherKeysActorState(Reference<AsyncVar<T> const> const& db,BlobCipherEncryptHeaderRef const& header,BlobCipherMetrics::UsageType const& usageType,Reference<GetEncryptCipherKeysMonitor> const& monitor) 
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		 : db(db),
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   header(header),
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   usageType(usageType),
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   monitor(monitor),
															#line 389 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   authenticatedEncryption(header.getAuthTokenMode() != ENCRYPT_HEADER_AUTH_TOKEN_MODE_NONE),
															#line 390 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		   details(header.getCipherDetails())
															#line 2922 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
	{
		fdb_probe_actor_create("_getEncryptCipherKeys", reinterpret_cast<unsigned long>(this));

	}
	~_getEncryptCipherKeysActorState() 
	{
		fdb_probe_actor_destroy("_getEncryptCipherKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 392 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			ASSERT(details.textCipherDetails.isValid());
															#line 393 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			ASSERT(!authenticatedEncryption || (details.headerCipherDetails.present() && details.headerCipherDetails.get().isValid()));
															#line 396 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			std::unordered_set<BlobCipherDetails> cipherDetails{ details.textCipherDetails };
															#line 397 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (authenticatedEncryption)
															#line 2943 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			{
															#line 398 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
				cipherDetails.insert(details.headerCipherDetails.get());
															#line 2947 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			}
															#line 401 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			StrictFuture<std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>>> __when_expr_0 = _getEncryptCipherKeys(db, cipherDetails, usageType, monitor);
															#line 401 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			if (static_cast<_getEncryptCipherKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2953 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_getEncryptCipherKeysActor*>(this)->actor_wait_state = 1;
															#line 401 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _getEncryptCipherKeysActor, 0, std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >*>(static_cast<_getEncryptCipherKeysActor*>(this)));
															#line 2958 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_getEncryptCipherKeysActorState();
		static_cast<_getEncryptCipherKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> const& cipherKeys,int loopDepth) 
	{
															#line 403 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		TextAndHeaderCipherKeys result;
															#line 405 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		auto setCipherKey = [&](const BlobCipherDetails& details, TextAndHeaderCipherKeys& result) { ASSERT(details.isValid()); auto iter = cipherKeys.find(details); ASSERT(iter != cipherKeys.end() && iter->second.isValid()); isEncryptHeaderDomain(details.encryptDomainId) ? result.cipherHeaderKey = iter->second : result.cipherTextKey = iter->second; };
															#line 412 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		setCipherKey(details.textCipherDetails, result);
															#line 413 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (authenticatedEncryption)
															#line 2987 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		{
															#line 414 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			setCipherKey(details.headerCipherDetails.get(), result);
															#line 2991 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		}
															#line 416 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		ASSERT(result.cipherTextKey.isValid() && (!authenticatedEncryption || result.cipherHeaderKey.isValid()));
															#line 418 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<_getEncryptCipherKeysActor*>(this)->SAV<TextAndHeaderCipherKeys>::futures) { (void)(result); this->~_getEncryptCipherKeysActorState(); static_cast<_getEncryptCipherKeysActor*>(this)->destroy(); return 0; }
															#line 2997 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<_getEncryptCipherKeysActor*>(this)->SAV< TextAndHeaderCipherKeys >::value()) TextAndHeaderCipherKeys(result);
		this->~_getEncryptCipherKeysActorState();
		static_cast<_getEncryptCipherKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> && cipherKeys,int loopDepth) 
	{
															#line 403 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		TextAndHeaderCipherKeys result;
															#line 405 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		auto setCipherKey = [&](const BlobCipherDetails& details, TextAndHeaderCipherKeys& result) { ASSERT(details.isValid()); auto iter = cipherKeys.find(details); ASSERT(iter != cipherKeys.end() && iter->second.isValid()); isEncryptHeaderDomain(details.encryptDomainId) ? result.cipherHeaderKey = iter->second : result.cipherTextKey = iter->second; };
															#line 412 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		setCipherKey(details.textCipherDetails, result);
															#line 413 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (authenticatedEncryption)
															#line 3015 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		{
															#line 414 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
			setCipherKey(details.headerCipherDetails.get(), result);
															#line 3019 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		}
															#line 416 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		ASSERT(result.cipherTextKey.isValid() && (!authenticatedEncryption || result.cipherHeaderKey.isValid()));
															#line 418 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
		if (!static_cast<_getEncryptCipherKeysActor*>(this)->SAV<TextAndHeaderCipherKeys>::futures) { (void)(result); this->~_getEncryptCipherKeysActorState(); static_cast<_getEncryptCipherKeysActor*>(this)->destroy(); return 0; }
															#line 3025 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		new (&static_cast<_getEncryptCipherKeysActor*>(this)->SAV< TextAndHeaderCipherKeys >::value()) TextAndHeaderCipherKeys(result);
		this->~_getEncryptCipherKeysActorState();
		static_cast<_getEncryptCipherKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> const& cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(cipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> && cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_getEncryptCipherKeysActor*>(this)->actor_wait_state > 0) static_cast<_getEncryptCipherKeysActor*>(this)->actor_wait_state = 0;
		static_cast<_getEncryptCipherKeysActor*>(this)->ActorCallback< _getEncryptCipherKeysActor, 0, std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >::remove();

	}
	void a_callback_fire(ActorCallback< _getEncryptCipherKeysActor, 0, std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >*,std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> const& value) 
	{
		fdb_probe_actor_enter("_getEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _getEncryptCipherKeysActor, 0, std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >*,std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> && value) 
	{
		fdb_probe_actor_enter("_getEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _getEncryptCipherKeysActor, 0, std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >*,Error err) 
	{
		fdb_probe_actor_enter("_getEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_getEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getEncryptCipherKeys", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	Reference<AsyncVar<T> const> db;
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	BlobCipherEncryptHeaderRef header;
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	BlobCipherMetrics::UsageType usageType;
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	Reference<GetEncryptCipherKeysMonitor> monitor;
															#line 389 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	bool authenticatedEncryption;
															#line 390 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	EncryptHeaderCipherDetails details;
															#line 3120 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
};
// This generated class is to be used only via _getEncryptCipherKeys()
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
class _getEncryptCipherKeysActor final : public Actor<TextAndHeaderCipherKeys>, public ActorCallback< _getEncryptCipherKeysActor<T>, 0, std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >, public FastAllocated<_getEncryptCipherKeysActor<T>>, public _getEncryptCipherKeysActorState<T, _getEncryptCipherKeysActor<T>> {
															#line 3127 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
public:
	using FastAllocated<_getEncryptCipherKeysActor<T>>::operator new;
	using FastAllocated<_getEncryptCipherKeysActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4787430614510525440UL, 9370992137820807936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<TextAndHeaderCipherKeys>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _getEncryptCipherKeysActor<T>, 0, std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >;
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	_getEncryptCipherKeysActor(Reference<AsyncVar<T> const> const& db,BlobCipherEncryptHeaderRef const& header,BlobCipherMetrics::UsageType const& usageType,Reference<GetEncryptCipherKeysMonitor> const& monitor) 
															#line 3144 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
		 : Actor<TextAndHeaderCipherKeys>(),
		   _getEncryptCipherKeysActorState<T, _getEncryptCipherKeysActor<T>>(db, header, usageType, monitor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_getEncryptCipherKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8602133456788076544UL, 13535855107638925056UL);
		ActorExecutionContextHelper __helper(static_cast<_getEncryptCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_getEncryptCipherKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_getEncryptCipherKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _getEncryptCipherKeysActor<T>, 0, std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
template <class T>
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
[[nodiscard]] Future<TextAndHeaderCipherKeys> _getEncryptCipherKeys( Reference<AsyncVar<T> const> const& db, BlobCipherEncryptHeaderRef const& header, BlobCipherMetrics::UsageType const& usageType, Reference<GetEncryptCipherKeysMonitor> const& monitor ) {
															#line 384 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"
	return Future<TextAndHeaderCipherKeys>(new _getEncryptCipherKeysActor<T>(db, header, usageType, monitor));
															#line 3179 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.g.h"
}

#line 420 "/codebuild/output/src1466137952/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/GetEncryptCipherKeys_impl.actor.h"

template <class T>
Future<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>>
GetEncryptCipherKeys<T>::getLatestEncryptCipherKeys(Reference<AsyncVar<T> const> db,
                                                    std::unordered_set<EncryptCipherDomainId> domainIds,
                                                    BlobCipherMetrics::UsageType usageType,
                                                    Reference<GetEncryptCipherKeysMonitor> monitor) {
	return _getLatestEncryptCipherKeys(db, domainIds, usageType, monitor);
}

template <class T>
Future<Reference<BlobCipherKey>> GetEncryptCipherKeys<T>::getLatestEncryptCipherKey(
    Reference<AsyncVar<T> const> db,
    EncryptCipherDomainId domainId,
    BlobCipherMetrics::UsageType usageType,
    Reference<GetEncryptCipherKeysMonitor> monitor) {
	return _getLatestEncryptCipherKey(db, domainId, usageType, monitor);
}

template <class T>
Future<std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>>> GetEncryptCipherKeys<T>::getEncryptCipherKeys(
    Reference<AsyncVar<T> const> db,
    std::unordered_set<BlobCipherDetails> cipherDetails,
    BlobCipherMetrics::UsageType usageType,
    Reference<GetEncryptCipherKeysMonitor> monitor) {
	return _getEncryptCipherKeys(db, cipherDetails, usageType, monitor);
}

template <class T>
Future<TextAndHeaderCipherKeys> GetEncryptCipherKeys<T>::getLatestEncryptCipherKeysForDomain(
    Reference<AsyncVar<T> const> db,
    EncryptCipherDomainId domainId,
    BlobCipherMetrics::UsageType usageType,
    Reference<GetEncryptCipherKeysMonitor> monitor) {
	return _getLatestEncryptCipherKeysForDomain(db, domainId, usageType, monitor);
}

template <class T>
Future<TextAndHeaderCipherKeys> GetEncryptCipherKeys<T>::getLatestSystemEncryptCipherKeys(
    const Reference<AsyncVar<T> const>& db,
    BlobCipherMetrics::UsageType usageType,
    Reference<GetEncryptCipherKeysMonitor> monitor) {
	return _getLatestSystemEncryptCipherKeys(db, usageType, monitor);
}

template <class T>
Future<TextAndHeaderCipherKeys> GetEncryptCipherKeys<T>::getEncryptCipherKeys(
    Reference<AsyncVar<T> const> db,
    BlobCipherEncryptHeaderRef header,
    BlobCipherMetrics::UsageType usageType,
    Reference<GetEncryptCipherKeysMonitor> monitor) {
	return _getEncryptCipherKeys(db, header, usageType, monitor);
}

#include "flow/unactorcompiler.h"
#endif