#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
/*
 * RandomRangeLock.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBTypes.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/RangeLock.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/ActorCollection.h"
#include "flow/Arena.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct RandomRangeLockWorkload : FailureInjectionWorkload {
	static constexpr auto NAME = "RandomRangeLock";

	bool enabled;
	double maxLockDuration = 60.0;
	double maxStartDelay = 300.0;
	int lockActorCount = 10;

	RandomRangeLockWorkload(WorkloadContext const& wcx, NoOptions) : FailureInjectionWorkload(wcx) {
		enabled = SERVER_KNOBS->ENABLE_READ_LOCK_ON_RANGE && !SERVER_KNOBS->ENABLE_VERSION_VECTOR &&
		          !SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST &&
		          !SERVER_KNOBS->PROXY_USE_RESOLVER_PRIVATE_MUTATIONS;
		enabled &= (clientId == 0) && g_network->isSimulated();
	}

	RandomRangeLockWorkload(WorkloadContext const& wcx) : FailureInjectionWorkload(wcx) {
		enabled = (clientId == 0) && g_network->isSimulated();
		maxLockDuration = getOption(options, "maxLockDuration"_sr, maxLockDuration);
		maxStartDelay = getOption(options, "maxStartDelay"_sr, maxStartDelay);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override { return _start(cx, this); }
	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}

	bool shouldInject(DeterministicRandom& random,
	                  const WorkloadRequest& work,
	                  const unsigned alreadyAdded) const override {
		// Inject this workload with 10% probability given that the workload uses database
		return alreadyAdded == 0 && work.useDatabase && random.random01() < 0.1;
	}

	Standalone<StringRef> getRandomStringRef() const {
		int stringLength = deterministicRandom()->randomInt(1, 10);
		Standalone<StringRef> stringBuffer = makeString(stringLength);
		deterministicRandom()->randomBytes(mutateString(stringBuffer), stringLength);
		return stringBuffer;
	}

	KeyRange getRandomRange(RandomRangeLockWorkload* self) const {
		Standalone<StringRef> keyA = self->getRandomStringRef();
		Standalone<StringRef> keyB = self->getRandomStringRef();
		if (keyA < keyB) {
			return Standalone(KeyRangeRef(keyA, keyB));
		} else if (keyA > keyB) {
			return Standalone(KeyRangeRef(keyB, keyA));
		} else {
			return singleKeyRange(keyA);
		}
	}

																#line 88 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
// This generated class is to be used only via lockActor()
															#line 86 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
template <class LockActorActor>
															#line 86 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
class LockActorActorState {
															#line 94 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
public:
															#line 86 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	LockActorActorState(Database const& cx,RandomRangeLockWorkload* const& self,std::string const& rangeLockOwnerNamePrefix) 
															#line 86 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
															#line 86 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		 : cx(cx),
															#line 86 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		   self(self),
															#line 86 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		   rangeLockOwnerNamePrefix(rangeLockOwnerNamePrefix),
															#line 87 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		   testDuration(deterministicRandom()->random01() * self->maxLockDuration),
															#line 88 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		   testStartDelay(deterministicRandom()->random01() * self->maxStartDelay),
															#line 89 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		   rangeLockOwnerName(rangeLockOwnerNamePrefix + "-" + std::to_string(deterministicRandom()->randomInt(0, self->lockActorCount)))
															#line 111 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
	{
		fdb_probe_actor_create("lockActor", reinterpret_cast<unsigned long>(this));

	}
	~LockActorActorState() 
	{
		fdb_probe_actor_destroy("lockActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 92 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			std::string lockOwnerDescription = rangeLockOwnerName + ":" + self->getRandomStringRef().toString();
															#line 93 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_0 = registerRangeLockOwner(cx, rangeLockOwnerName, lockOwnerDescription);
															#line 93 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			if (static_cast<LockActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 130 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LockActorActor*>(this)->actor_wait_state = 1;
															#line 93 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LockActorActor, 0, Void >*>(static_cast<LockActorActor*>(this)));
															#line 135 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LockActorActorState();
		static_cast<LockActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(testStartDelay);
															#line 94 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		if (static_cast<LockActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 160 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LockActorActor*>(this)->actor_wait_state = 2;
															#line 94 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LockActorActor, 1, Void >*>(static_cast<LockActorActor*>(this)));
															#line 165 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(testStartDelay);
															#line 94 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		if (static_cast<LockActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 176 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LockActorActor*>(this)->actor_wait_state = 2;
															#line 94 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LockActorActor, 1, Void >*>(static_cast<LockActorActor*>(this)));
															#line 181 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LockActorActor*>(this)->actor_wait_state > 0) static_cast<LockActorActor*>(this)->actor_wait_state = 0;
		static_cast<LockActorActor*>(this)->ActorCallback< LockActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LockActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LockActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 95 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		range = self->getRandomRange(self);
															#line 96 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		TraceEvent(SevWarnAlways, "InjectRangeLockSubmit") .detail("RangeLockOwnerName", rangeLockOwnerName) .detail("Range", range) .detail("LockStartDelayTime", testStartDelay) .detail("LockTime", testDuration);
															#line 267 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		try {
															#line 102 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			StrictFuture<Optional<RangeLockOwner>> __when_expr_2 = getRangeLockOwner(cx, rangeLockOwnerName);
															#line 102 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			if (static_cast<LockActorActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 273 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<LockActorActor*>(this)->actor_wait_state = 3;
															#line 102 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LockActorActor, 2, Optional<RangeLockOwner> >*>(static_cast<LockActorActor*>(this)));
															#line 278 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 95 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		range = self->getRandomRange(self);
															#line 96 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		TraceEvent(SevWarnAlways, "InjectRangeLockSubmit") .detail("RangeLockOwnerName", rangeLockOwnerName) .detail("Range", range) .detail("LockStartDelayTime", testStartDelay) .detail("LockTime", testDuration);
															#line 295 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		try {
															#line 102 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			StrictFuture<Optional<RangeLockOwner>> __when_expr_2 = getRangeLockOwner(cx, rangeLockOwnerName);
															#line 102 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			if (static_cast<LockActorActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 301 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<LockActorActor*>(this)->actor_wait_state = 3;
															#line 102 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LockActorActor, 2, Optional<RangeLockOwner> >*>(static_cast<LockActorActor*>(this)));
															#line 306 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LockActorActor*>(this)->actor_wait_state > 0) static_cast<LockActorActor*>(this)->actor_wait_state = 0;
		static_cast<LockActorActor*>(this)->ActorCallback< LockActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LockActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LockActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 133 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(testDuration);
															#line 133 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		if (static_cast<LockActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 398 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<LockActorActor*>(this)->actor_wait_state = 5;
															#line 133 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LockActorActor, 4, Void >*>(static_cast<LockActorActor*>(this)));
															#line 403 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 112 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			if (e.code() == error_code_range_lock_failed)
															#line 413 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
			{
															#line 113 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
				TraceEvent(SevWarnAlways, "InjectRangeLockFailed") .detail("RangeLockOwnerName", rangeLockOwnerName) .detail("Range", range) .detail("LockTime", testDuration);
															#line 117 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
				ASSERT(range.end > normalKeys.end);
															#line 419 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
			}
			else
			{
															#line 118 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
				if (e.code() == error_code_range_lock_reject)
															#line 425 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
				{
															#line 119 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
					TraceEvent(SevWarnAlways, "InjectRangeLockRejected") .detail("RangeLockOwnerName", rangeLockOwnerName) .detail("Range", range) .detail("LockTime", testDuration);
															#line 429 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
				}
				else
				{
															#line 125 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
					TraceEvent(SevError, "InjectRangeLockError") .errorUnsuppressed(e) .detail("RangeLockOwnerName", rangeLockOwnerName) .detail("Range", range) .detail("LockTime", testDuration);
															#line 130 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
					return a_body1Catch1(e, loopDepth);
															#line 437 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
				}
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Optional<RangeLockOwner> const& owner,int loopDepth) 
	{
															#line 103 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		ASSERT(owner.present());
															#line 104 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		ASSERT(owner.get().getOwnerUniqueId() == rangeLockOwnerName);
															#line 105 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		StrictFuture<Void> __when_expr_3 = takeExclusiveReadLockOnRange(cx, range, rangeLockOwnerName);
															#line 105 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		if (static_cast<LockActorActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 460 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<LockActorActor*>(this)->actor_wait_state = 4;
															#line 105 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LockActorActor, 3, Void >*>(static_cast<LockActorActor*>(this)));
															#line 465 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Optional<RangeLockOwner> && owner,int loopDepth) 
	{
															#line 103 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		ASSERT(owner.present());
															#line 104 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		ASSERT(owner.get().getOwnerUniqueId() == rangeLockOwnerName);
															#line 105 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		StrictFuture<Void> __when_expr_3 = takeExclusiveReadLockOnRange(cx, range, rangeLockOwnerName);
															#line 105 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		if (static_cast<LockActorActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 480 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<LockActorActor*>(this)->actor_wait_state = 4;
															#line 105 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LockActorActor, 3, Void >*>(static_cast<LockActorActor*>(this)));
															#line 485 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Optional<RangeLockOwner> const& owner,int loopDepth) 
	{
		loopDepth = a_body1cont4(owner, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<RangeLockOwner> && owner,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(owner), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LockActorActor*>(this)->actor_wait_state > 0) static_cast<LockActorActor*>(this)->actor_wait_state = 0;
		static_cast<LockActorActor*>(this)->ActorCallback< LockActorActor, 2, Optional<RangeLockOwner> >::remove();

	}
	void a_callback_fire(ActorCallback< LockActorActor, 2, Optional<RangeLockOwner> >*,Optional<RangeLockOwner> const& value) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LockActorActor, 2, Optional<RangeLockOwner> >*,Optional<RangeLockOwner> && value) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LockActorActor, 2, Optional<RangeLockOwner> >*,Error err) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 106 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		TraceEvent(SevWarnAlways, "InjectRangeLocked") .detail("RangeLockOwnerName", rangeLockOwnerName) .detail("Range", range) .detail("LockTime", testDuration);
															#line 110 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		ASSERT(range.end <= normalKeys.end);
															#line 571 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 106 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		TraceEvent(SevWarnAlways, "InjectRangeLocked") .detail("RangeLockOwnerName", rangeLockOwnerName) .detail("Range", range) .detail("LockTime", testDuration);
															#line 110 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		ASSERT(range.end <= normalKeys.end);
															#line 582 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LockActorActor*>(this)->actor_wait_state > 0) static_cast<LockActorActor*>(this)->actor_wait_state = 0;
		static_cast<LockActorActor*>(this)->ActorCallback< LockActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LockActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LockActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 135 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		TraceEvent(SevWarnAlways, "InjectRangeUnlockSubmit") .detail("RangeLockOwnerName", rangeLockOwnerName) .detail("Range", range) .detail("LockStartDelayTime", testStartDelay) .detail("LockTime", testDuration);
															#line 679 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		try {
															#line 141 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_5 = releaseExclusiveReadLockOnRange(cx, range, rangeLockOwnerName);
															#line 141 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			if (static_cast<LockActorActor*>(this)->actor_wait_state < 0) return a_body1cont8Catch1(actor_cancelled(), loopDepth);
															#line 685 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont8Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
			static_cast<LockActorActor*>(this)->actor_wait_state = 6;
															#line 141 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< LockActorActor, 5, Void >*>(static_cast<LockActorActor*>(this)));
															#line 690 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont8Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont8Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 135 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		TraceEvent(SevWarnAlways, "InjectRangeUnlockSubmit") .detail("RangeLockOwnerName", rangeLockOwnerName) .detail("Range", range) .detail("LockStartDelayTime", testStartDelay) .detail("LockTime", testDuration);
															#line 705 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		try {
															#line 141 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			StrictFuture<Void> __when_expr_5 = releaseExclusiveReadLockOnRange(cx, range, rangeLockOwnerName);
															#line 141 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			if (static_cast<LockActorActor*>(this)->actor_wait_state < 0) return a_body1cont8Catch1(actor_cancelled(), loopDepth);
															#line 711 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont8Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
			static_cast<LockActorActor*>(this)->actor_wait_state = 6;
															#line 141 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< LockActorActor, 5, Void >*>(static_cast<LockActorActor*>(this)));
															#line 716 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont8Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont8Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<LockActorActor*>(this)->actor_wait_state > 0) static_cast<LockActorActor*>(this)->actor_wait_state = 0;
		static_cast<LockActorActor*>(this)->ActorCallback< LockActorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockActorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LockActorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< LockActorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 169 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		if (!static_cast<LockActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LockActorActorState(); static_cast<LockActorActor*>(this)->destroy(); return 0; }
															#line 806 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		new (&static_cast<LockActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LockActorActorState();
		static_cast<LockActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 147 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			if (e.code() == error_code_range_lock_failed)
															#line 819 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
			{
															#line 148 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
				TraceEvent(SevWarnAlways, "InjectRangeUnlockFailed") .detail("RangeLockOwnerName", rangeLockOwnerName) .detail("Range", range) .detail("LockTime", testDuration);
															#line 152 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
				ASSERT(range.end > normalKeys.end);
															#line 825 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
			}
			else
			{
															#line 153 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
				if (e.code() == error_code_range_unlock_reject)
															#line 831 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
				{
															#line 154 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
					TraceEvent(SevWarnAlways, "InjectRangeUnlockRejected") .detail("RangeLockOwnerName", rangeLockOwnerName) .detail("Range", range) .detail("LockTime", testDuration);
															#line 835 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
				}
				else
				{
															#line 160 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
					TraceEvent(SevError, "InjectRangeUnlockError") .errorUnsuppressed(e) .detail("RangeLockOwnerName", rangeLockOwnerName) .detail("Range", range) .detail("LockTime", testDuration);
															#line 165 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
					return a_body1Catch1(e, loopDepth);
															#line 843 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
				}
			}
			loopDepth = a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 142 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		TraceEvent(SevWarnAlways, "InjectRangeUnlocked") .detail("RangeLockOwnerName", rangeLockOwnerName) .detail("Range", range);
															#line 145 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		ASSERT(range.end <= normalKeys.end);
															#line 862 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 142 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		TraceEvent(SevWarnAlways, "InjectRangeUnlocked") .detail("RangeLockOwnerName", rangeLockOwnerName) .detail("Range", range);
															#line 145 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		ASSERT(range.end <= normalKeys.end);
															#line 873 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<LockActorActor*>(this)->actor_wait_state > 0) static_cast<LockActorActor*>(this)->actor_wait_state = 0;
		static_cast<LockActorActor*>(this)->ActorCallback< LockActorActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockActorActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< LockActorActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< LockActorActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 86 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	Database cx;
															#line 86 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	RandomRangeLockWorkload* self;
															#line 86 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	std::string rangeLockOwnerNamePrefix;
															#line 87 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	double testDuration;
															#line 88 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	double testStartDelay;
															#line 89 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	std::string rangeLockOwnerName;
															#line 95 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	KeyRange range;
															#line 980 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
};
// This generated class is to be used only via lockActor()
															#line 86 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
class LockActorActor final : public Actor<Void>, public ActorCallback< LockActorActor, 0, Void >, public ActorCallback< LockActorActor, 1, Void >, public ActorCallback< LockActorActor, 2, Optional<RangeLockOwner> >, public ActorCallback< LockActorActor, 3, Void >, public ActorCallback< LockActorActor, 4, Void >, public ActorCallback< LockActorActor, 5, Void >, public FastAllocated<LockActorActor>, public LockActorActorState<LockActorActor> {
															#line 985 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
public:
	using FastAllocated<LockActorActor>::operator new;
	using FastAllocated<LockActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17743474902442495232UL, 11542631062303099648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LockActorActor, 0, Void >;
friend struct ActorCallback< LockActorActor, 1, Void >;
friend struct ActorCallback< LockActorActor, 2, Optional<RangeLockOwner> >;
friend struct ActorCallback< LockActorActor, 3, Void >;
friend struct ActorCallback< LockActorActor, 4, Void >;
friend struct ActorCallback< LockActorActor, 5, Void >;
															#line 86 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	LockActorActor(Database const& cx,RandomRangeLockWorkload* const& self,std::string const& rangeLockOwnerNamePrefix) 
															#line 1007 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		 : Actor<Void>(),
		   LockActorActorState<LockActorActor>(cx, self, rangeLockOwnerNamePrefix),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lockActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15027281586927872000UL, 8245252288627212032UL);
		ActorExecutionContextHelper __helper(static_cast<LockActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lockActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lockActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LockActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LockActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LockActorActor, 2, Optional<RangeLockOwner> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LockActorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< LockActorActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< LockActorActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 86 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
[[nodiscard]] Future<Void> lockActor( Database const& cx, RandomRangeLockWorkload* const& self, std::string const& rangeLockOwnerNamePrefix ) {
															#line 86 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	return Future<Void>(new LockActorActor(cx, self, rangeLockOwnerNamePrefix));
															#line 1044 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
}

#line 171 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"

																#line 1049 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 172 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
template <class _startActor>
															#line 172 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
class _startActorState {
															#line 1055 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
public:
															#line 172 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	_startActorState(Database const& cx,RandomRangeLockWorkload* const& self) 
															#line 172 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
															#line 172 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		 : cx(cx),
															#line 172 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		   self(self)
															#line 1064 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 173 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
			if (self->enabled)
															#line 1079 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
			{
															#line 183 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
				rangeLockOwnerNamePrefix = "Owner" + std::to_string(self->clientId);
															#line 184 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
				std::vector<Future<Void>> actors;
															#line 185 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
				for(int i = 0;i < self->lockActorCount;i++) {
															#line 186 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
					actors.push_back(self->lockActor(cx, self, rangeLockOwnerNamePrefix));
															#line 1089 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
				}
															#line 188 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAll(actors);
															#line 188 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1095 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 188 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1100 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 200 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1128 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 191 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		j = 0;
															#line 192 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		;
															#line 1142 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 191 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		j = 0;
															#line 192 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		;
															#line 1153 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 198 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		TraceEvent("RandomRangeLockWorkloadEnd").detail("OwnerPrefix", rangeLockOwnerNamePrefix);
															#line 1237 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 192 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		if (!(j < self->lockActorCount))
															#line 1253 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 193 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		StrictFuture<std::vector<std::pair<KeyRange, RangeLockState>>> __when_expr_1 = findExclusiveReadLockOnRange(cx, normalKeys, rangeLockOwnerNamePrefix + "-" + std::to_string(j));
															#line 193 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1261 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 193 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, std::vector<std::pair<KeyRange, RangeLockState>> >*>(static_cast<_startActor*>(this)));
															#line 1266 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(std::vector<std::pair<KeyRange, RangeLockState>> const& res,int loopDepth) 
	{
															#line 195 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		ASSERT(res.empty());
															#line 192 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		j++;
															#line 1290 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(std::vector<std::pair<KeyRange, RangeLockState>> && res,int loopDepth) 
	{
															#line 195 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		ASSERT(res.empty());
															#line 192 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
		j++;
															#line 1301 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(std::vector<std::pair<KeyRange, RangeLockState>> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(std::vector<std::pair<KeyRange, RangeLockState>> && res,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, std::vector<std::pair<KeyRange, RangeLockState>> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, std::vector<std::pair<KeyRange, RangeLockState>> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 172 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	Database cx;
															#line 172 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	RandomRangeLockWorkload* self;
															#line 183 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	std::string rangeLockOwnerNamePrefix;
															#line 191 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	int j;
															#line 1389 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 172 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, std::vector<std::pair<KeyRange, RangeLockState>> >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1394 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(265361652991581952UL, 1181228336744335616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, std::vector<std::pair<KeyRange, RangeLockState>> >;
															#line 172 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	_startActor(Database const& cx,RandomRangeLockWorkload* const& self) 
															#line 1412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, std::vector<std::pair<KeyRange, RangeLockState>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 172 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, RandomRangeLockWorkload* const& self ) {
															#line 172 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1445 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomRangeLock.actor.g.cpp"
}

#line 202 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/RandomRangeLock.actor.cpp"
};

FailureInjectorFactory<RandomRangeLockWorkload> RangeLockFailureInjectionFactory;
WorkloadFactory<RandomRangeLockWorkload> RandomRangeLockWorkloadFactory;
