#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
/*
 * IDDTxnProcessorApiCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbserver/DDSharedContext.h"
#include "fdbserver/DDTxnProcessor.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbclient/StorageServerInterface.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbclient/VersionedMap.h"
#include "flow/actorcompiler.h" // This must be the last #include.

std::string describe(const DDShardInfo& a) {
	std::string res = "key: " + a.key.toString() + "\n";
	res += "\tprimarySrc: " + describe(a.primarySrc) + "\n";
	res += "\tprimaryDest: " + describe(a.primaryDest) + "\n";
	res += "\tremoteSrc: " + describe(a.remoteSrc) + "\n";
	res += "\tremoteDest: " + describe(a.remoteDest) + "\n";
	return res;
}
bool compareShardInfo(const DDShardInfo& a, const DDShardInfo& other) {
	// Mock DD just care about the server<->key mapping in DDShardInfo
	bool result = a.key == other.key && a.hasDest == other.hasDest && a.primaryDest == other.primaryDest &&
	              a.primarySrc == other.primarySrc && a.remoteSrc == other.remoteSrc &&
	              a.remoteDest == other.remoteDest;
	if (!result) {
		std::cout << a.key.toStringView() << " | " << other.key.toStringView() << "\n";
		std::cout << a.hasDest << " | " << other.hasDest << "\n";
		std::cout << describe(a.primarySrc) << " | " << describe(other.primarySrc) << "\n";
		std::cout << describe(a.primaryDest) << " | " << describe(other.primaryDest) << "\n";
		std::cout << describe(a.remoteSrc) << " | " << describe(other.remoteSrc) << "\n";
		std::cout << describe(a.remoteDest) << " | " << describe(other.remoteDest) << "\n";
	}
	return result;
}

void verifyInitDataEqual(Reference<InitialDataDistribution> real, Reference<InitialDataDistribution> mock) {
	// Mock DD just care about the team list and server<->key mapping are consistent with the real cluster
	if (real->shards.size() != mock->shards.size()) {
		std::cout << "shardBoundaries: real v.s. mock \n";
		for (auto& shard : real->shards) {
			std::cout << describe(shard);
		}
		std::cout << " ------- \n";
		for (auto& shard : mock->shards) {
			std::cout << describe(shard);
		}
	}
	ASSERT_EQ(real->shards.size(), mock->shards.size());
	ASSERT(std::equal(
	    real->shards.begin(), real->shards.end(), mock->shards.begin(), mock->shards.end(), compareShardInfo));

	if (real->primaryTeams != mock->primaryTeams) {
		std::cout << describe(real->primaryTeams) << " | " << describe(mock->primaryTeams) << "\n";
		ASSERT(false);
	}

	ASSERT(real->remoteTeams == mock->remoteTeams);
}

// testers expose protected methods
class DDMockTxnProcessorTester : public DDMockTxnProcessor {
public:
	explicit DDMockTxnProcessorTester(std::shared_ptr<MockGlobalState> mgs = nullptr) : DDMockTxnProcessor(mgs) {}
	Future<Void> testRawStartMovement(MoveKeysParams& params, std::map<UID, StorageServerInterface>& tssMapping) {
		return rawStartMovement(params, tssMapping);
	}

	Future<Void> testRawFinishMovement(MoveKeysParams& params,
	                                   const std::map<UID, StorageServerInterface>& tssMapping) {
		for (auto& id : params.destinationTeam) {
			mgs->allServers.at(id)->setShardStatus(params.keys.get(), MockShardStatus::FETCHED);
		}
		return rawFinishMovement(params, tssMapping);
	}
};

class DDTxnProcessorTester : public DDTxnProcessor {
public:
	explicit DDTxnProcessorTester(Database cx) : DDTxnProcessor(cx) {}

	Future<Void> testRawStartMovement(MoveKeysParams& params, std::map<UID, StorageServerInterface>& tssMapping) {
		return rawStartMovement(params, tssMapping);
	}

	Future<Void> testRawFinishMovement(MoveKeysParams& params,
	                                   const std::map<UID, StorageServerInterface>& tssMapping) {
		return rawFinishMovement(params, tssMapping);
	}
};

// Verify that all IDDTxnProcessor API implementations has consistent result
struct IDDTxnProcessorApiWorkload : TestWorkload {
	static constexpr auto NAME = "IDDTxnProcessorApiCorrectness";
	bool enabled;
	bool testStartOnly;
	double testDuration;
	DDSharedContext ddContext;

	std::shared_ptr<DDTxnProcessorTester> real;
	std::shared_ptr<MockGlobalState> mgs;
	std::shared_ptr<DDMockTxnProcessorTester> mock;

	Reference<InitialDataDistribution> realInitDD;
	std::vector<Key> boundaries;

	// counters
	int testRawStart = 0, testAll = 0, testRawFinish = 0;

	IDDTxnProcessorApiWorkload(WorkloadContext const& wcx) : TestWorkload(wcx), ddContext(UID()) {
		enabled = !clientId && g_network->isSimulated(); // only do this on the "first" client
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		testStartOnly = getOption(options, "testStartOnly"_sr, false);
	}

	Future<Void> setup(Database const& cx) override { return enabled ? _setup(cx, this) : Void(); }
	Future<Void> start(Database const& cx) override { return enabled ? _start(cx, this) : Void(); }

	// This workload is not compatible with RandomMoveKeys workload because they will race in changing the DD mode.
	// Other workload injections may make no sense because this workload only use the DB at beginning to reading the
	// real world key-server mappings. It's not harmful to leave other workload injection enabled for now, though.
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomMoveKeys", "Attrition" });
	}

																#line 147 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
// This generated class is to be used only via readRealInitialDataDistribution()
															#line 145 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
template <class ReadRealInitialDataDistributionActor>
															#line 145 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
class ReadRealInitialDataDistributionActorState {
															#line 153 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
public:
															#line 145 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	ReadRealInitialDataDistributionActorState(IDDTxnProcessorApiWorkload* const& self) 
															#line 145 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
															#line 145 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		 : self(self)
															#line 160 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("readRealInitialDataDistribution", reinterpret_cast<unsigned long>(this));

	}
	~ReadRealInitialDataDistributionActorState() 
	{
		fdb_probe_actor_destroy("readRealInitialDataDistribution", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 146 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			;
															#line 175 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadRealInitialDataDistributionActorState();
		static_cast<ReadRealInitialDataDistributionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 165 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		self->updateBoundaries();
															#line 166 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (!static_cast<ReadRealInitialDataDistributionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadRealInitialDataDistributionActorState(); static_cast<ReadRealInitialDataDistributionActor*>(this)->destroy(); return 0; }
															#line 200 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		new (&static_cast<ReadRealInitialDataDistributionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadRealInitialDataDistributionActorState();
		static_cast<ReadRealInitialDataDistributionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 147 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_0 = store(self->ddContext.lock, ::readMoveKeysLock(self->real->context()));
															#line 147 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<ReadRealInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 221 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ReadRealInitialDataDistributionActor*>(this)->actor_wait_state = 1;
															#line 147 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadRealInitialDataDistributionActor, 0, Void >*>(static_cast<ReadRealInitialDataDistributionActor*>(this)));
															#line 226 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		try {
															#line 150 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(self->realInitDD, self->real->getInitialDataDistribution(self->ddContext.id(), self->ddContext.lock, {}, self->ddContext.ddEnabledState.get(), SkipDDModeCheck::True));
															#line 150 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (static_cast<ReadRealInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 251 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadRealInitialDataDistributionActor*>(this)->actor_wait_state = 2;
															#line 150 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadRealInitialDataDistributionActor, 1, Void >*>(static_cast<ReadRealInitialDataDistributionActor*>(this)));
															#line 256 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		try {
															#line 150 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(self->realInitDD, self->real->getInitialDataDistribution(self->ddContext.id(), self->ddContext.lock, {}, self->ddContext.ddEnabledState.get(), SkipDDModeCheck::True));
															#line 150 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (static_cast<ReadRealInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 274 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadRealInitialDataDistributionActor*>(this)->actor_wait_state = 2;
															#line 150 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadRealInitialDataDistributionActor, 1, Void >*>(static_cast<ReadRealInitialDataDistributionActor*>(this)));
															#line 279 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadRealInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<ReadRealInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<ReadRealInitialDataDistributionActor*>(this)->ActorCallback< ReadRealInitialDataDistributionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadRealInitialDataDistributionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readRealInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRealInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRealInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadRealInitialDataDistributionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readRealInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRealInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRealInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadRealInitialDataDistributionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readRealInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRealInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRealInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 161 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (e.code() != error_code_movekeys_conflict)
															#line 376 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			{
															#line 162 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 380 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		std::cout << "Finish read real InitialDataDistribution: server size " << self->realInitDD->allServers.size() << ", shard size: " << self->realInitDD->shards.size() << std::endl;
															#line 396 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		std::cout << "Finish read real InitialDataDistribution: server size " << self->realInitDD->allServers.size() << ", shard size: " << self->realInitDD->shards.size() << std::endl;
															#line 405 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadRealInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<ReadRealInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<ReadRealInitialDataDistributionActor*>(this)->ActorCallback< ReadRealInitialDataDistributionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadRealInitialDataDistributionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readRealInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRealInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRealInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadRealInitialDataDistributionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readRealInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRealInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRealInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadRealInitialDataDistributionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readRealInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRealInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRealInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 145 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	IDDTxnProcessorApiWorkload* self;
															#line 487 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via readRealInitialDataDistribution()
															#line 145 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
class ReadRealInitialDataDistributionActor final : public Actor<Void>, public ActorCallback< ReadRealInitialDataDistributionActor, 0, Void >, public ActorCallback< ReadRealInitialDataDistributionActor, 1, Void >, public FastAllocated<ReadRealInitialDataDistributionActor>, public ReadRealInitialDataDistributionActorState<ReadRealInitialDataDistributionActor> {
															#line 492 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<ReadRealInitialDataDistributionActor>::operator new;
	using FastAllocated<ReadRealInitialDataDistributionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9080624173718605056UL, 12923551073263195904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadRealInitialDataDistributionActor, 0, Void >;
friend struct ActorCallback< ReadRealInitialDataDistributionActor, 1, Void >;
															#line 145 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	ReadRealInitialDataDistributionActor(IDDTxnProcessorApiWorkload* const& self) 
															#line 510 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   ReadRealInitialDataDistributionActorState<ReadRealInitialDataDistributionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readRealInitialDataDistribution", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3435865356948557312UL, 2899105968403959296UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRealInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readRealInitialDataDistribution");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readRealInitialDataDistribution", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadRealInitialDataDistributionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadRealInitialDataDistributionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 145 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> readRealInitialDataDistribution( IDDTxnProcessorApiWorkload* const& self ) {
															#line 145 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	return Future<Void>(new ReadRealInitialDataDistributionActor(self));
															#line 543 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
}

#line 168 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"

	// according to boundaries, generate valid ranges for moveKeys operation
	KeyRange getRandomKeys() const {
		int choice = deterministicRandom()->randomInt(0, 3);
		// merge or split operations
		Key begin, end;
		if (choice == 0) {
			// pure move
			int idx = deterministicRandom()->randomInt(0, boundaries.size() - 1);
			begin = boundaries[idx];
			end = boundaries[idx + 1];
		} else if (choice == 1) {
			// merge shard
			int a = deterministicRandom()->randomInt(0, boundaries.size() - 1);
			int b = deterministicRandom()->randomInt(a + 1, boundaries.size());
			begin = boundaries[a];
			end = boundaries[b];
		} else {
			// split
			double start = deterministicRandom()->random01();
			begin = doubleToTestKey(start);
			auto it = std::upper_bound(boundaries.begin(), boundaries.end(), begin);
			ASSERT(it != boundaries.end()); // allKeys.end is larger than any random keys here
			end = *it;
		}

		return KeyRangeRef(begin, end);
	}

	std::vector<UID> getRandomTeam() {
		int& teamSize = ddContext.configuration.storageTeamSize;
		if (realInitDD->allServers.size() < teamSize) {
			TraceEvent(SevWarnAlways, "CandidatesLessThanTeamSize").log();
			throw operation_failed();
		}
		deterministicRandom()->randomShuffle(realInitDD->allServers, 0, teamSize);
		std::vector<UID> result(teamSize);
		for (int i = 0; i < teamSize; ++i) {
			result[i] = realInitDD->allServers[i].first.id();
		}
		return result;
	}

	void updateBoundaries() {
		boundaries.clear();
		std::set<Key> tempBoundaries;
		for (auto& shard : realInitDD->shards) {
			tempBoundaries.insert(tempBoundaries.end(), shard.key);
		}
		boundaries = std::vector<Key>(tempBoundaries.begin(), tempBoundaries.end());
	}

																#line 599 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 220 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
template <class _setupActor>
															#line 220 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
class _setupActorState {
															#line 605 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
public:
															#line 220 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	_setupActorState(Database const& cx,IDDTxnProcessorApiWorkload* const& self) 
															#line 220 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
															#line 220 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 220 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		   self(self)
															#line 614 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 221 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			StrictFuture<int> __when_expr_0 = setDDMode(cx, 0);
															#line 221 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 631 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 221 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, int >*>(static_cast<_setupActor*>(this)));
															#line 636 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& oldMode,int loopDepth) 
	{
															#line 222 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		TraceEvent("IDDTxnApiTestStartModeSetting").detail("OldValue", oldMode).log();
															#line 224 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		self->real = std::make_shared<DDTxnProcessorTester>(cx);
															#line 226 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(self->ddContext.configuration, self->real->getDatabaseConfiguration());
															#line 226 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 665 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 226 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 670 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int && oldMode,int loopDepth) 
	{
															#line 222 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		TraceEvent("IDDTxnApiTestStartModeSetting").detail("OldValue", oldMode).log();
															#line 224 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		self->real = std::make_shared<DDTxnProcessorTester>(cx);
															#line 226 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(self->ddContext.configuration, self->real->getDatabaseConfiguration());
															#line 226 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 685 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 226 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 690 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(int const& oldMode,int loopDepth) 
	{
		loopDepth = a_body1cont1(oldMode, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && oldMode,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(oldMode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 227 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		ASSERT(self->ddContext.configuration.storageTeamSize > 0);
															#line 229 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		ASSERT_EQ(self->ddContext.usableRegions(), 1);
															#line 230 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = readRealInitialDataDistribution(self);
															#line 230 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 780 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 230 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 785 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 227 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		ASSERT(self->ddContext.configuration.storageTeamSize > 0);
															#line 229 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		ASSERT_EQ(self->ddContext.usableRegions(), 1);
															#line 230 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = readRealInitialDataDistribution(self);
															#line 230 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 800 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 230 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 805 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 231 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 889 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 231 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 901 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _setupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 220 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	Database cx;
															#line 220 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	IDDTxnProcessorApiWorkload* self;
															#line 988 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 220 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, int >, public ActorCallback< _setupActor, 1, Void >, public ActorCallback< _setupActor, 2, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 993 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5243793006264464384UL, 557764905489203456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, int >;
friend struct ActorCallback< _setupActor, 1, Void >;
friend struct ActorCallback< _setupActor, 2, Void >;
															#line 220 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	_setupActor(Database const& cx,IDDTxnProcessorApiWorkload* const& self) 
															#line 1012 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _setupActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 220 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, IDDTxnProcessorApiWorkload* const& self ) {
															#line 220 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 1046 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
}

#line 233 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"

																#line 1051 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 234 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
template <class _startActor>
															#line 234 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
class _startActorState {
															#line 1057 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
public:
															#line 234 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	_startActorState(Database const& cx,IDDTxnProcessorApiWorkload* const& self) 
															#line 234 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
															#line 234 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 234 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		   self(self)
															#line 1066 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 236 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			self->mgs = std::make_shared<MockGlobalState>();
															#line 237 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			self->mgs->configuration = self->ddContext.configuration;
															#line 238 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			self->mgs->restrictSize = false;
															#line 240 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			self->mock = std::make_shared<DDMockTxnProcessorTester>(self->mgs);
															#line 241 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			self->mock->setupMockGlobalState(self->realInitDD);
															#line 243 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			Reference<InitialDataDistribution> mockInitData = self->mock ->getInitialDataDistribution(self->ddContext.id(), self->ddContext.lock, {}, self->ddContext.ddEnabledState.get(), SkipDDModeCheck::True) .get();
															#line 252 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			verifyInitDataEqual(self->realInitDD, mockInitData);
															#line 254 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(reportErrors(self->worker(cx, self), "IDDTxnProcessorApiWorkload"), self->testDuration, Void());
															#line 254 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1097 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 254 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1102 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 257 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		TraceEvent("IDDTxnApiTestDoneMoving").log();
															#line 258 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<int> __when_expr_1 = setDDMode(cx, 1);
															#line 258 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1129 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 258 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, int >*>(static_cast<_startActor*>(this)));
															#line 1134 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 257 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		TraceEvent("IDDTxnApiTestDoneMoving").log();
															#line 258 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<int> __when_expr_1 = setDDMode(cx, 1);
															#line 258 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1147 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 258 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, int >*>(static_cast<_startActor*>(this)));
															#line 1152 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int const& oldValue,int loopDepth) 
	{
															#line 259 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		TraceEvent("IDDTxnApiTestDoneModeSetting").detail("OldValue", oldValue);
															#line 260 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1238 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int && oldValue,int loopDepth) 
	{
															#line 259 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		TraceEvent("IDDTxnApiTestDoneModeSetting").detail("OldValue", oldValue);
															#line 260 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1252 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int const& oldValue,int loopDepth) 
	{
		loopDepth = a_body1cont2(oldValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && oldValue,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(oldValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 234 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	Database cx;
															#line 234 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	IDDTxnProcessorApiWorkload* self;
															#line 1339 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 234 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, int >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1344 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15033369782149125632UL, 9426321106084785152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, int >;
															#line 234 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	_startActor(Database const& cx,IDDTxnProcessorApiWorkload* const& self) 
															#line 1362 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 234 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, IDDTxnProcessorApiWorkload* const& self ) {
															#line 234 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1395 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
}

#line 262 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"

	void verifyServerKeyDest(MoveKeysParams& params) const {
		KeyRangeRef keys;
		if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA) {
			ASSERT(params.ranges.present());
			// TODO: make startMoveShards work with multiple ranges.
			ASSERT(params.ranges.get().size() == 1);
			keys = params.ranges.get().at(0);
		} else {
			ASSERT(params.keys.present());
			keys = params.keys.get();
		}

		// check destination servers
		for (auto& id : params.destinationTeam) {
			ASSERT(mgs->serverIsDestForShard(id, keys));
		}
	}
																#line 1417 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
// This generated class is to be used only via testRawMovementApi()
															#line 280 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
template <class TestRawMovementApiActor>
															#line 280 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
class TestRawMovementApiActorState {
															#line 1423 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
public:
															#line 280 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	TestRawMovementApiActorState(IDDTxnProcessorApiWorkload* const& self) 
															#line 280 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
															#line 280 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		 : self(self),
															#line 281 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		   relocateShardInterval("RelocateShard_TestRawMovementApi"),
															#line 282 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		   fl1(1),
															#line 283 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		   fl2(1),
															#line 284 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		   emptyTssMapping(),
															#line 285 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		   mockInitData()
															#line 1440 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("testRawMovementApi", reinterpret_cast<unsigned long>(this));

	}
	~TestRawMovementApiActorState() 
	{
		fdb_probe_actor_destroy("testRawMovementApi", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 286 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			StrictFuture<MoveKeysParams> __when_expr_0 = generateMoveKeysParams(self);
															#line 286 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1457 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 1;
															#line 286 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestRawMovementApiActor, 0, MoveKeysParams >*>(static_cast<TestRawMovementApiActor*>(this)));
															#line 1462 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestRawMovementApiActorState();
		static_cast<TestRawMovementApiActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 287 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		realParams.startMoveKeysParallelismLock = &fl1;
															#line 288 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		realParams.finishMoveKeysParallelismLock = &fl2;
															#line 289 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		realParams.relocationIntervalId = relocateShardInterval.pairID;
															#line 290 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		TraceEvent(SevDebug, relocateShardInterval.begin(), relocateShardInterval.pairID) .detail("Key", realParams.keys) .detail("Dest", realParams.destinationTeam);
															#line 294 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		mockParams = realParams;
															#line 295 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		mockParams.dataMovementComplete = Promise<Void>();
															#line 297 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		;
															#line 1497 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(MoveKeysParams const& __realParams,int loopDepth) 
	{
															#line 286 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		realParams = __realParams;
															#line 1506 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(MoveKeysParams && __realParams,int loopDepth) 
	{
		realParams = std::move(__realParams);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state > 0) static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestRawMovementApiActor*>(this)->ActorCallback< TestRawMovementApiActor, 0, MoveKeysParams >::remove();

	}
	void a_callback_fire(ActorCallback< TestRawMovementApiActor, 0, MoveKeysParams >*,MoveKeysParams const& value) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestRawMovementApiActor, 0, MoveKeysParams >*,MoveKeysParams && value) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestRawMovementApiActor, 0, MoveKeysParams >*,Error err) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 329 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_7 = readRealInitialDataDistribution(self);
															#line 329 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1587 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont2when1(__when_expr_7.get(), loopDepth); };
		static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 8;
															#line 329 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TestRawMovementApiActor, 7, Void >*>(static_cast<TestRawMovementApiActor*>(this)));
															#line 1592 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 298 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		realParams.dataMovementComplete.reset();
															#line 299 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		mockParams.dataMovementComplete.reset();
															#line 301 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(realParams.lock, self->real->takeMoveKeysLock(UID()));
															#line 301 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1614 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 2;
															#line 301 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestRawMovementApiActor, 1, Void >*>(static_cast<TestRawMovementApiActor*>(this)));
															#line 1619 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		try {
															#line 304 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->mock->testRawStartMovement(mockParams, emptyTssMapping);
															#line 304 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1644 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 3;
															#line 304 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestRawMovementApiActor, 2, Void >*>(static_cast<TestRawMovementApiActor*>(this)));
															#line 1649 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		try {
															#line 304 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->mock->testRawStartMovement(mockParams, emptyTssMapping);
															#line 304 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1667 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 3;
															#line 304 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestRawMovementApiActor, 2, Void >*>(static_cast<TestRawMovementApiActor*>(this)));
															#line 1672 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state > 0) static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestRawMovementApiActor*>(this)->ActorCallback< TestRawMovementApiActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRawMovementApiActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestRawMovementApiActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestRawMovementApiActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 321 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (e.code() != error_code_movekeys_conflict)
															#line 1769 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			{
															#line 322 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1773 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			}
															#line 323 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_6 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 323 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1779 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 7;
															#line 323 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestRawMovementApiActor, 6, Void >*>(static_cast<TestRawMovementApiActor*>(this)));
															#line 1784 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 305 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->real->testRawStartMovement(realParams, emptyTssMapping);
															#line 305 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1801 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 4;
															#line 305 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestRawMovementApiActor, 3, Void >*>(static_cast<TestRawMovementApiActor*>(this)));
															#line 1806 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 305 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->real->testRawStartMovement(realParams, emptyTssMapping);
															#line 305 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1817 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 4;
															#line 305 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestRawMovementApiActor, 3, Void >*>(static_cast<TestRawMovementApiActor*>(this)));
															#line 1822 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state > 0) static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestRawMovementApiActor*>(this)->ActorCallback< TestRawMovementApiActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRawMovementApiActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestRawMovementApiActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestRawMovementApiActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 307 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		self->verifyServerKeyDest(realParams);
															#line 309 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (self->testStartOnly || deterministicRandom()->coinflip())
															#line 1908 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		{
															#line 310 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			CODE_PROBE(true, "RawMovementApi partial started");
															#line 311 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			self->testRawStart++;
															#line 1914 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 316 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->real->testRawFinishMovement(realParams, emptyTssMapping);
															#line 316 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1921 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 5;
															#line 316 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestRawMovementApiActor, 4, Void >*>(static_cast<TestRawMovementApiActor*>(this)));
															#line 1926 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 307 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		self->verifyServerKeyDest(realParams);
															#line 309 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (self->testStartOnly || deterministicRandom()->coinflip())
															#line 1937 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		{
															#line 310 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			CODE_PROBE(true, "RawMovementApi partial started");
															#line 311 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			self->testRawStart++;
															#line 1943 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 316 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->real->testRawFinishMovement(realParams, emptyTssMapping);
															#line 316 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1950 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 5;
															#line 316 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestRawMovementApiActor, 4, Void >*>(static_cast<TestRawMovementApiActor*>(this)));
															#line 1955 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state > 0) static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestRawMovementApiActor*>(this)->ActorCallback< TestRawMovementApiActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRawMovementApiActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestRawMovementApiActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestRawMovementApiActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 317 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->mock->testRawFinishMovement(mockParams, emptyTssMapping);
															#line 317 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2041 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 6;
															#line 317 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestRawMovementApiActor, 5, Void >*>(static_cast<TestRawMovementApiActor*>(this)));
															#line 2046 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 317 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->mock->testRawFinishMovement(mockParams, emptyTssMapping);
															#line 317 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2057 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 6;
															#line 317 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestRawMovementApiActor, 5, Void >*>(static_cast<TestRawMovementApiActor*>(this)));
															#line 2062 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state > 0) static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestRawMovementApiActor*>(this)->ActorCallback< TestRawMovementApiActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRawMovementApiActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestRawMovementApiActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestRawMovementApiActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 318 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		self->testRawFinish++;
															#line 2146 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 318 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		self->testRawFinish++;
															#line 2155 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state > 0) static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestRawMovementApiActor*>(this)->ActorCallback< TestRawMovementApiActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRawMovementApiActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestRawMovementApiActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestRawMovementApiActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state > 0) static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestRawMovementApiActor*>(this)->ActorCallback< TestRawMovementApiActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRawMovementApiActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TestRawMovementApiActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TestRawMovementApiActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 330 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		mockInitData = self->mock ->getInitialDataDistribution(self->ddContext.id(), self->ddContext.lock, {}, self->ddContext.ddEnabledState.get(), SkipDDModeCheck::True) .get();
															#line 338 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		verifyInitDataEqual(self->realInitDD, mockInitData);
															#line 339 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		TraceEvent(SevDebug, relocateShardInterval.end(), relocateShardInterval.pairID);
															#line 343 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		self->mock->setupMockGlobalState(self->realInitDD);
															#line 344 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (!static_cast<TestRawMovementApiActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestRawMovementApiActorState(); static_cast<TestRawMovementApiActor*>(this)->destroy(); return 0; }
															#line 2334 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		new (&static_cast<TestRawMovementApiActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestRawMovementApiActorState();
		static_cast<TestRawMovementApiActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 330 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		mockInitData = self->mock ->getInitialDataDistribution(self->ddContext.id(), self->ddContext.lock, {}, self->ddContext.ddEnabledState.get(), SkipDDModeCheck::True) .get();
															#line 338 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		verifyInitDataEqual(self->realInitDD, mockInitData);
															#line 339 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		TraceEvent(SevDebug, relocateShardInterval.end(), relocateShardInterval.pairID);
															#line 343 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		self->mock->setupMockGlobalState(self->realInitDD);
															#line 344 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (!static_cast<TestRawMovementApiActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestRawMovementApiActorState(); static_cast<TestRawMovementApiActor*>(this)->destroy(); return 0; }
															#line 2354 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		new (&static_cast<TestRawMovementApiActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestRawMovementApiActorState();
		static_cast<TestRawMovementApiActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<TestRawMovementApiActor*>(this)->actor_wait_state > 0) static_cast<TestRawMovementApiActor*>(this)->actor_wait_state = 0;
		static_cast<TestRawMovementApiActor*>(this)->ActorCallback< TestRawMovementApiActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRawMovementApiActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< TestRawMovementApiActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< TestRawMovementApiActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 280 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	IDDTxnProcessorApiWorkload* self;
															#line 281 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	TraceInterval relocateShardInterval;
															#line 282 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	FlowLock fl1;
															#line 283 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	FlowLock fl2;
															#line 284 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	std::map<UID, StorageServerInterface> emptyTssMapping;
															#line 285 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	Reference<InitialDataDistribution> mockInitData;
															#line 286 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	MoveKeysParams realParams;
															#line 294 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	MoveKeysParams mockParams;
															#line 2453 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via testRawMovementApi()
															#line 280 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
class TestRawMovementApiActor final : public Actor<Void>, public ActorCallback< TestRawMovementApiActor, 0, MoveKeysParams >, public ActorCallback< TestRawMovementApiActor, 1, Void >, public ActorCallback< TestRawMovementApiActor, 2, Void >, public ActorCallback< TestRawMovementApiActor, 3, Void >, public ActorCallback< TestRawMovementApiActor, 4, Void >, public ActorCallback< TestRawMovementApiActor, 5, Void >, public ActorCallback< TestRawMovementApiActor, 6, Void >, public ActorCallback< TestRawMovementApiActor, 7, Void >, public FastAllocated<TestRawMovementApiActor>, public TestRawMovementApiActorState<TestRawMovementApiActor> {
															#line 2458 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<TestRawMovementApiActor>::operator new;
	using FastAllocated<TestRawMovementApiActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5454942159874889984UL, 2014534891592519424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestRawMovementApiActor, 0, MoveKeysParams >;
friend struct ActorCallback< TestRawMovementApiActor, 1, Void >;
friend struct ActorCallback< TestRawMovementApiActor, 2, Void >;
friend struct ActorCallback< TestRawMovementApiActor, 3, Void >;
friend struct ActorCallback< TestRawMovementApiActor, 4, Void >;
friend struct ActorCallback< TestRawMovementApiActor, 5, Void >;
friend struct ActorCallback< TestRawMovementApiActor, 6, Void >;
friend struct ActorCallback< TestRawMovementApiActor, 7, Void >;
															#line 280 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	TestRawMovementApiActor(IDDTxnProcessorApiWorkload* const& self) 
															#line 2482 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   TestRawMovementApiActorState<TestRawMovementApiActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testRawMovementApi", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17590913495400459776UL, 18259421141910500608UL);
		ActorExecutionContextHelper __helper(static_cast<TestRawMovementApiActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testRawMovementApi");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testRawMovementApi", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestRawMovementApiActor, 0, MoveKeysParams >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestRawMovementApiActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestRawMovementApiActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestRawMovementApiActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestRawMovementApiActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestRawMovementApiActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TestRawMovementApiActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< TestRawMovementApiActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 280 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> testRawMovementApi( IDDTxnProcessorApiWorkload* const& self ) {
															#line 280 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	return Future<Void>(new TestRawMovementApiActor(self));
															#line 2521 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
}

#line 346 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"

																#line 2526 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
// This generated class is to be used only via generateMoveKeysParams()
															#line 347 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
template <class GenerateMoveKeysParamsActor>
															#line 347 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
class GenerateMoveKeysParamsActorState {
															#line 2532 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
public:
															#line 347 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	GenerateMoveKeysParamsActorState(IDDTxnProcessorApiWorkload* const& self) 
															#line 347 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
															#line 347 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		 : self(self)
															#line 2539 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("generateMoveKeysParams", reinterpret_cast<unsigned long>(this));

	}
	~GenerateMoveKeysParamsActorState() 
	{
		fdb_probe_actor_destroy("generateMoveKeysParams", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 348 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			StrictFuture<MoveKeysLock> __when_expr_0 = takeMoveKeysLock(self->real->context(), UID());
															#line 348 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (static_cast<GenerateMoveKeysParamsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2556 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GenerateMoveKeysParamsActor*>(this)->actor_wait_state = 1;
															#line 348 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GenerateMoveKeysParamsActor, 0, MoveKeysLock >*>(static_cast<GenerateMoveKeysParamsActor*>(this)));
															#line 2561 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GenerateMoveKeysParamsActorState();
		static_cast<GenerateMoveKeysParamsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 350 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		KeyRange keys = self->getRandomKeys();
															#line 351 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		std::vector<UID> destTeam = self->getRandomTeam();
															#line 352 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		std::sort(destTeam.begin(), destTeam.end());
															#line 353 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		const UID dataMoveId = newDataMoveId(deterministicRandom()->randomUInt64(), AssignEmptyRange(false), DataMoveType::LOGICAL, DataMovementReason::INVALID, UnassignShard(false));
															#line 358 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA)
															#line 2592 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		{
															#line 359 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (!static_cast<GenerateMoveKeysParamsActor*>(this)->SAV<MoveKeysParams>::futures) { (void)(MoveKeysParams(dataMoveId, std::vector<KeyRange>{ keys }, destTeam, destTeam, lock, Promise<Void>(), nullptr, nullptr, false, UID(), self->ddContext.ddEnabledState.get(), CancelConflictingDataMoves::True, Optional<BulkLoadTaskState>())); this->~GenerateMoveKeysParamsActorState(); static_cast<GenerateMoveKeysParamsActor*>(this)->destroy(); return 0; }
															#line 2596 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			new (&static_cast<GenerateMoveKeysParamsActor*>(this)->SAV< MoveKeysParams >::value()) MoveKeysParams(MoveKeysParams(dataMoveId, std::vector<KeyRange>{ keys }, destTeam, destTeam, lock, Promise<Void>(), nullptr, nullptr, false, UID(), self->ddContext.ddEnabledState.get(), CancelConflictingDataMoves::True, Optional<BulkLoadTaskState>()));
			this->~GenerateMoveKeysParamsActorState();
			static_cast<GenerateMoveKeysParamsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 373 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (!static_cast<GenerateMoveKeysParamsActor*>(this)->SAV<MoveKeysParams>::futures) { (void)(MoveKeysParams(dataMoveId, keys, destTeam, destTeam, lock, Promise<Void>(), nullptr, nullptr, false, UID(), self->ddContext.ddEnabledState.get(), CancelConflictingDataMoves::True, Optional<BulkLoadTaskState>())); this->~GenerateMoveKeysParamsActorState(); static_cast<GenerateMoveKeysParamsActor*>(this)->destroy(); return 0; }
															#line 2606 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			new (&static_cast<GenerateMoveKeysParamsActor*>(this)->SAV< MoveKeysParams >::value()) MoveKeysParams(MoveKeysParams(dataMoveId, keys, destTeam, destTeam, lock, Promise<Void>(), nullptr, nullptr, false, UID(), self->ddContext.ddEnabledState.get(), CancelConflictingDataMoves::True, Optional<BulkLoadTaskState>()));
			this->~GenerateMoveKeysParamsActorState();
			static_cast<GenerateMoveKeysParamsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1when1(MoveKeysLock const& __lock,int loopDepth) 
	{
															#line 348 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		lock = __lock;
															#line 2619 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(MoveKeysLock && __lock,int loopDepth) 
	{
		lock = std::move(__lock);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GenerateMoveKeysParamsActor*>(this)->actor_wait_state > 0) static_cast<GenerateMoveKeysParamsActor*>(this)->actor_wait_state = 0;
		static_cast<GenerateMoveKeysParamsActor*>(this)->ActorCallback< GenerateMoveKeysParamsActor, 0, MoveKeysLock >::remove();

	}
	void a_callback_fire(ActorCallback< GenerateMoveKeysParamsActor, 0, MoveKeysLock >*,MoveKeysLock const& value) 
	{
		fdb_probe_actor_enter("generateMoveKeysParams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMoveKeysParamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generateMoveKeysParams", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GenerateMoveKeysParamsActor, 0, MoveKeysLock >*,MoveKeysLock && value) 
	{
		fdb_probe_actor_enter("generateMoveKeysParams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMoveKeysParamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generateMoveKeysParams", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GenerateMoveKeysParamsActor, 0, MoveKeysLock >*,Error err) 
	{
		fdb_probe_actor_enter("generateMoveKeysParams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMoveKeysParamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generateMoveKeysParams", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 347 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	IDDTxnProcessorApiWorkload* self;
															#line 348 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	MoveKeysLock lock;
															#line 2698 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via generateMoveKeysParams()
															#line 347 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
class GenerateMoveKeysParamsActor final : public Actor<MoveKeysParams>, public ActorCallback< GenerateMoveKeysParamsActor, 0, MoveKeysLock >, public FastAllocated<GenerateMoveKeysParamsActor>, public GenerateMoveKeysParamsActorState<GenerateMoveKeysParamsActor> {
															#line 2703 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<GenerateMoveKeysParamsActor>::operator new;
	using FastAllocated<GenerateMoveKeysParamsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13066854404274064640UL, 7840322151652178688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<MoveKeysParams>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GenerateMoveKeysParamsActor, 0, MoveKeysLock >;
															#line 347 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	GenerateMoveKeysParamsActor(IDDTxnProcessorApiWorkload* const& self) 
															#line 2720 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		 : Actor<MoveKeysParams>(),
		   GenerateMoveKeysParamsActorState<GenerateMoveKeysParamsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("generateMoveKeysParams", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11361203786426291712UL, 1130296281337419776UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMoveKeysParamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("generateMoveKeysParams");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("generateMoveKeysParams", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GenerateMoveKeysParamsActor, 0, MoveKeysLock >*)0, actor_cancelled()); break;
		}

	}
};
															#line 347 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
[[nodiscard]] static Future<MoveKeysParams> generateMoveKeysParams( IDDTxnProcessorApiWorkload* const& self ) {
															#line 347 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	return Future<MoveKeysParams>(new GenerateMoveKeysParamsActor(self));
															#line 2752 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
}

#line 388 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"

																#line 2757 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
// This generated class is to be used only via testMoveKeys()
															#line 389 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
template <class TestMoveKeysActor>
															#line 389 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
class TestMoveKeysActorState {
															#line 2763 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
public:
															#line 389 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	TestMoveKeysActorState(IDDTxnProcessorApiWorkload* const& self) 
															#line 389 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
															#line 389 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		 : self(self),
															#line 390 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		   relocateShardInterval("RelocateShard_TestMoveKeys"),
															#line 391 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		   fl1(1),
															#line 392 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		   fl2(1),
															#line 393 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		   emptyTssMapping(),
															#line 394 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		   mockInitData()
															#line 2780 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("testMoveKeys", reinterpret_cast<unsigned long>(this));

	}
	~TestMoveKeysActorState() 
	{
		fdb_probe_actor_destroy("testMoveKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 395 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			StrictFuture<MoveKeysParams> __when_expr_0 = generateMoveKeysParams(self);
															#line 395 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (static_cast<TestMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2797 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestMoveKeysActor*>(this)->actor_wait_state = 1;
															#line 395 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestMoveKeysActor, 0, MoveKeysParams >*>(static_cast<TestMoveKeysActor*>(this)));
															#line 2802 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestMoveKeysActorState();
		static_cast<TestMoveKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 396 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		realParams.startMoveKeysParallelismLock = &fl1;
															#line 397 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		realParams.finishMoveKeysParallelismLock = &fl2;
															#line 398 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		realParams.relocationIntervalId = relocateShardInterval.pairID;
															#line 399 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		TraceEvent(SevDebug, relocateShardInterval.begin(), relocateShardInterval.pairID) .detail("Key", realParams.keys) .detail("Dest", realParams.destinationTeam);
															#line 403 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		mockParams = realParams;
															#line 404 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		mockParams.dataMovementComplete = Promise<Void>();
															#line 406 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		;
															#line 2837 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(MoveKeysParams const& __realParams,int loopDepth) 
	{
															#line 395 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		realParams = __realParams;
															#line 2846 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(MoveKeysParams && __realParams,int loopDepth) 
	{
		realParams = std::move(__realParams);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<TestMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<TestMoveKeysActor*>(this)->ActorCallback< TestMoveKeysActor, 0, MoveKeysParams >::remove();

	}
	void a_callback_fire(ActorCallback< TestMoveKeysActor, 0, MoveKeysParams >*,MoveKeysParams const& value) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestMoveKeysActor, 0, MoveKeysParams >*,MoveKeysParams && value) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestMoveKeysActor, 0, MoveKeysParams >*,Error err) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 424 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_5 = readRealInitialDataDistribution(self);
															#line 424 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<TestMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2927 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestMoveKeysActor*>(this)->actor_wait_state = 6;
															#line 424 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestMoveKeysActor, 5, Void >*>(static_cast<TestMoveKeysActor*>(this)));
															#line 2932 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 407 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		realParams.dataMovementComplete.reset();
															#line 408 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		mockParams.dataMovementComplete.reset();
															#line 409 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(realParams.lock, self->real->takeMoveKeysLock(UID()));
															#line 409 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<TestMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2954 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestMoveKeysActor*>(this)->actor_wait_state = 2;
															#line 409 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestMoveKeysActor, 1, Void >*>(static_cast<TestMoveKeysActor*>(this)));
															#line 2959 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		try {
															#line 411 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->mock->moveKeys(mockParams);
															#line 411 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (static_cast<TestMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2984 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestMoveKeysActor*>(this)->actor_wait_state = 3;
															#line 411 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestMoveKeysActor, 2, Void >*>(static_cast<TestMoveKeysActor*>(this)));
															#line 2989 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		try {
															#line 411 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->mock->moveKeys(mockParams);
															#line 411 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (static_cast<TestMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3007 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestMoveKeysActor*>(this)->actor_wait_state = 3;
															#line 411 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestMoveKeysActor, 2, Void >*>(static_cast<TestMoveKeysActor*>(this)));
															#line 3012 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<TestMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<TestMoveKeysActor*>(this)->ActorCallback< TestMoveKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestMoveKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestMoveKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestMoveKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 416 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (e.code() != error_code_movekeys_conflict)
															#line 3109 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			{
															#line 417 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3113 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			}
															#line 418 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_4 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 418 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (static_cast<TestMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3119 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<TestMoveKeysActor*>(this)->actor_wait_state = 5;
															#line 418 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestMoveKeysActor, 4, Void >*>(static_cast<TestMoveKeysActor*>(this)));
															#line 3124 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->real->moveKeys(realParams);
															#line 412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<TestMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3141 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestMoveKeysActor*>(this)->actor_wait_state = 4;
															#line 412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestMoveKeysActor, 3, Void >*>(static_cast<TestMoveKeysActor*>(this)));
															#line 3146 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->real->moveKeys(realParams);
															#line 412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<TestMoveKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3157 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestMoveKeysActor*>(this)->actor_wait_state = 4;
															#line 412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestMoveKeysActor, 3, Void >*>(static_cast<TestMoveKeysActor*>(this)));
															#line 3162 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<TestMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<TestMoveKeysActor*>(this)->ActorCallback< TestMoveKeysActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestMoveKeysActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestMoveKeysActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestMoveKeysActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 413 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		self->testAll++;
															#line 3246 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 413 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		self->testAll++;
															#line 3255 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<TestMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<TestMoveKeysActor*>(this)->ActorCallback< TestMoveKeysActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestMoveKeysActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestMoveKeysActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestMoveKeysActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<TestMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<TestMoveKeysActor*>(this)->ActorCallback< TestMoveKeysActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestMoveKeysActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestMoveKeysActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestMoveKeysActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 425 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		mockInitData = self->mock ->getInitialDataDistribution(self->ddContext.id(), self->ddContext.lock, {}, self->ddContext.ddEnabledState.get(), SkipDDModeCheck::True) .get();
															#line 433 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		verifyInitDataEqual(self->realInitDD, mockInitData);
															#line 434 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		TraceEvent(SevDebug, relocateShardInterval.end(), relocateShardInterval.pairID);
															#line 435 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		self->mock->setupMockGlobalState(self->realInitDD);
															#line 436 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (!static_cast<TestMoveKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestMoveKeysActorState(); static_cast<TestMoveKeysActor*>(this)->destroy(); return 0; }
															#line 3434 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		new (&static_cast<TestMoveKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestMoveKeysActorState();
		static_cast<TestMoveKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 425 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		mockInitData = self->mock ->getInitialDataDistribution(self->ddContext.id(), self->ddContext.lock, {}, self->ddContext.ddEnabledState.get(), SkipDDModeCheck::True) .get();
															#line 433 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		verifyInitDataEqual(self->realInitDD, mockInitData);
															#line 434 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		TraceEvent(SevDebug, relocateShardInterval.end(), relocateShardInterval.pairID);
															#line 435 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		self->mock->setupMockGlobalState(self->realInitDD);
															#line 436 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (!static_cast<TestMoveKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestMoveKeysActorState(); static_cast<TestMoveKeysActor*>(this)->destroy(); return 0; }
															#line 3454 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		new (&static_cast<TestMoveKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestMoveKeysActorState();
		static_cast<TestMoveKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestMoveKeysActor*>(this)->actor_wait_state > 0) static_cast<TestMoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<TestMoveKeysActor*>(this)->ActorCallback< TestMoveKeysActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestMoveKeysActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestMoveKeysActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestMoveKeysActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 389 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	IDDTxnProcessorApiWorkload* self;
															#line 390 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	TraceInterval relocateShardInterval;
															#line 391 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	FlowLock fl1;
															#line 392 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	FlowLock fl2;
															#line 393 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	std::map<UID, StorageServerInterface> emptyTssMapping;
															#line 394 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	Reference<InitialDataDistribution> mockInitData;
															#line 395 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	MoveKeysParams realParams;
															#line 403 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	MoveKeysParams mockParams;
															#line 3553 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via testMoveKeys()
															#line 389 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
class TestMoveKeysActor final : public Actor<Void>, public ActorCallback< TestMoveKeysActor, 0, MoveKeysParams >, public ActorCallback< TestMoveKeysActor, 1, Void >, public ActorCallback< TestMoveKeysActor, 2, Void >, public ActorCallback< TestMoveKeysActor, 3, Void >, public ActorCallback< TestMoveKeysActor, 4, Void >, public ActorCallback< TestMoveKeysActor, 5, Void >, public FastAllocated<TestMoveKeysActor>, public TestMoveKeysActorState<TestMoveKeysActor> {
															#line 3558 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<TestMoveKeysActor>::operator new;
	using FastAllocated<TestMoveKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15779157425008252416UL, 6731213429987011584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestMoveKeysActor, 0, MoveKeysParams >;
friend struct ActorCallback< TestMoveKeysActor, 1, Void >;
friend struct ActorCallback< TestMoveKeysActor, 2, Void >;
friend struct ActorCallback< TestMoveKeysActor, 3, Void >;
friend struct ActorCallback< TestMoveKeysActor, 4, Void >;
friend struct ActorCallback< TestMoveKeysActor, 5, Void >;
															#line 389 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	TestMoveKeysActor(IDDTxnProcessorApiWorkload* const& self) 
															#line 3580 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   TestMoveKeysActorState<TestMoveKeysActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testMoveKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5097845172920927744UL, 9110841789286970368UL);
		ActorExecutionContextHelper __helper(static_cast<TestMoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testMoveKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testMoveKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestMoveKeysActor, 0, MoveKeysParams >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestMoveKeysActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestMoveKeysActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestMoveKeysActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestMoveKeysActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestMoveKeysActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 389 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> testMoveKeys( IDDTxnProcessorApiWorkload* const& self ) {
															#line 389 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	return Future<Void>(new TestMoveKeysActor(self));
															#line 3617 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
}

#line 438 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"

																#line 3622 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
// This generated class is to be used only via worker()
															#line 439 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
template <class WorkerActor>
															#line 439 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
class WorkerActorState {
															#line 3628 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
public:
															#line 439 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	WorkerActorState(Database const& cx,IDDTxnProcessorApiWorkload* const& self) 
															#line 439 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
															#line 439 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		 : cx(cx),
															#line 439 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		   self(self),
															#line 440 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		   choice(0),
															#line 441 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		   maxChoice(self->testStartOnly ? 1 : 2)
															#line 3641 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("worker", reinterpret_cast<unsigned long>(this));

	}
	~WorkerActorState() 
	{
		fdb_probe_actor_destroy("worker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 442 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			;
															#line 3656 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerActorState();
		static_cast<WorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 443 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		choice = deterministicRandom()->randomInt(0, maxChoice);
															#line 444 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (choice == 0)
															#line 3688 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		{
															#line 445 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testRawMovementApi(self);
															#line 445 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (static_cast<WorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3694 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkerActor*>(this)->actor_wait_state = 1;
															#line 445 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerActor, 0, Void >*>(static_cast<WorkerActor*>(this)));
															#line 3699 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 446 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
			if (choice == 1)
															#line 3706 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
			{
															#line 447 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_1 = testMoveKeys(self);
															#line 447 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
				if (static_cast<WorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3712 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<WorkerActor*>(this)->actor_wait_state = 2;
															#line 447 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerActor, 1, Void >*>(static_cast<WorkerActor*>(this)));
															#line 3717 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 449 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
				ASSERT(false);
															#line 3724 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
				loopDepth = a_body1loopBody1cont3(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 451 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 451 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		if (static_cast<WorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3737 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WorkerActor*>(this)->actor_wait_state = 3;
															#line 451 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkerActor, 2, Void >*>(static_cast<WorkerActor*>(this)));
															#line 3742 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerActor*>(this)->actor_wait_state > 0) static_cast<WorkerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerActor*>(this)->ActorCallback< WorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkerActor*>(this)->actor_wait_state > 0) static_cast<WorkerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerActor*>(this)->ActorCallback< WorkerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WorkerActor*>(this)->actor_wait_state > 0) static_cast<WorkerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerActor*>(this)->ActorCallback< WorkerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 439 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	Database cx;
															#line 439 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	IDDTxnProcessorApiWorkload* self;
															#line 440 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	int choice;
															#line 441 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	int maxChoice;
															#line 4022 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
};
// This generated class is to be used only via worker()
															#line 439 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
class WorkerActor final : public Actor<Void>, public ActorCallback< WorkerActor, 0, Void >, public ActorCallback< WorkerActor, 1, Void >, public ActorCallback< WorkerActor, 2, Void >, public FastAllocated<WorkerActor>, public WorkerActorState<WorkerActor> {
															#line 4027 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
public:
	using FastAllocated<WorkerActor>::operator new;
	using FastAllocated<WorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13320835046499255296UL, 8418977426002649088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerActor, 0, Void >;
friend struct ActorCallback< WorkerActor, 1, Void >;
friend struct ActorCallback< WorkerActor, 2, Void >;
															#line 439 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	WorkerActor(Database const& cx,IDDTxnProcessorApiWorkload* const& self) 
															#line 4046 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   WorkerActorState<WorkerActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("worker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9305151550442981632UL, 410782307204870400UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("worker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("worker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WorkerActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 439 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
[[nodiscard]] Future<Void> worker( Database const& cx, IDDTxnProcessorApiWorkload* const& self ) {
															#line 439 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"
	return Future<Void>(new WorkerActor(cx, self));
															#line 4080 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.g.cpp"
}

#line 454 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/workloads/IDDTxnProcessorApiCorrectness.actor.cpp"

	Future<bool> check(Database const& cx) override {
		return tag(delay(testDuration / 2), true);
	} // Give the database time to recover from our damage

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.emplace_back("TestRawStart", testRawStart, Averaged::False);
		m.emplace_back("TestRawFinish", testRawFinish, Averaged::False);
		m.emplace_back("TestRawAll", testAll, Averaged::False);
	}
};

WorkloadFactory<IDDTxnProcessorApiWorkload> IDDTxnProcessorApiWorkload;
