#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
/*
 * BlobMigrator.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include <algorithm>
#include <cmath>
#include <cstddef>
#include <string>
#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/Knobs.h"
#include "fdbserver/RestoreCommon.actor.h"
#include "fdbserver/RestoreUtil.h"
#include "fdbserver/StorageMetrics.actor.h"
#include "flow/CodeProbe.h"
#include "flow/Error.h"
#include "flow/network.h"
#include "flow/flow.h"
#include "flow/ActorCollection.h"
#include "flow/FastRef.h"
#include "flow/IRandom.h"
#include "flow/Platform.h"
#include "flow/Trace.h"
#include "fdbclient/BlobGranuleCommon.h"
#include "fdbclient/StorageServerInterface.h"
#include "fdbclient/BlobConnectionProvider.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/KeyRangeMap.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BlobRestoreCommon.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbserver/BlobGranuleServerCommon.actor.h"
#include "fdbserver/BlobMigratorInterface.h"
#include "fdbserver/Knobs.h"
#include "flow/genericactors.actor.h"
#include "fmt/core.h"

#include "flow/actorcompiler.h" // has to be last include

#define ENABLE_DEBUG_MG false

template <typename... T>
static inline void dprint(fmt::format_string<T...> fmt, T&&... args) {
	if (ENABLE_DEBUG_MG)
		fmt::print(fmt, std::forward<T>(args)...);
}

// BlobMigrator offers APIs to migrate data from blob storage to storage server. It implements a minimal set of
// StorageServerInterface APIs which are needed for DataDistributor to start data migration.
class BlobMigrator : public NonCopyable, public ReferenceCounted<BlobMigrator>, public IStorageMetricsService {
public:
	BlobMigrator(BlobMigratorInterface interf, Reference<AsyncVar<ServerDBInfo> const> dbInfo)
	  : interf_(interf), actors_(false), dbInfo_(dbInfo) {
		db_ = openDBOnServer(dbInfo, TaskPriority::DefaultEndpoint, LockAware::True);
	}
	~BlobMigrator() {}

	// Start migration
																#line 81 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
// This generated class is to be used only via start()
															#line 79 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class StartActor>
															#line 79 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class StartActorState {
															#line 87 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 79 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	StartActorState(Reference<BlobMigrator> const& self) 
															#line 79 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 79 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : self(self)
															#line 94 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("start", reinterpret_cast<unsigned long>(this));

	}
	~StartActorState() 
	{
		fdb_probe_actor_destroy("start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 80 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_0 = initialize(self);
															#line 80 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<StartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 111 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartActor*>(this)->actor_wait_state = 1;
															#line 80 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartActor, 0, Void >*>(static_cast<StartActor*>(this)));
															#line 116 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartActorState();
		static_cast<StartActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 81 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_1 = serverLoop(self);
															#line 81 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<StartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 141 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartActor*>(this)->actor_wait_state = 2;
															#line 81 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartActor, 1, Void >*>(static_cast<StartActor*>(this)));
															#line 146 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 81 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_1 = serverLoop(self);
															#line 81 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<StartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 157 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartActor*>(this)->actor_wait_state = 2;
															#line 81 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartActor, 1, Void >*>(static_cast<StartActor*>(this)));
															#line 162 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartActor*>(this)->actor_wait_state > 0) static_cast<StartActor*>(this)->actor_wait_state = 0;
		static_cast<StartActor*>(this)->ActorCallback< StartActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 82 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<StartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartActorState(); static_cast<StartActor*>(this)->destroy(); return 0; }
															#line 246 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<StartActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartActorState();
		static_cast<StartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 82 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<StartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartActorState(); static_cast<StartActor*>(this)->destroy(); return 0; }
															#line 258 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<StartActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartActorState();
		static_cast<StartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartActor*>(this)->actor_wait_state > 0) static_cast<StartActor*>(this)->actor_wait_state = 0;
		static_cast<StartActor*>(this)->ActorCallback< StartActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("start", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 79 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobMigrator> self;
															#line 343 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via start()
															#line 79 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class StartActor final : public Actor<Void>, public ActorCallback< StartActor, 0, Void >, public ActorCallback< StartActor, 1, Void >, public FastAllocated<StartActor>, public StartActorState<StartActor> {
															#line 348 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<StartActor>::operator new;
	using FastAllocated<StartActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14256077920590752768UL, 11563648461519938048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartActor, 0, Void >;
friend struct ActorCallback< StartActor, 1, Void >;
															#line 79 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	StartActor(Reference<BlobMigrator> const& self) 
															#line 366 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<Void>(),
		   StartActorState<StartActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10219404671476595456UL, 16609373904378240000UL);
		ActorExecutionContextHelper __helper(static_cast<StartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 79 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] static Future<Void> start( Reference<BlobMigrator> const& self ) {
															#line 79 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<Void>(new StartActor(self));
															#line 399 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 84 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"

private:
	// Initialize blob migrator to COPYING_DATA state.
																#line 406 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
// This generated class is to be used only via initialize()
															#line 87 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class InitializeActor>
															#line 87 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class InitializeActorState {
															#line 412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 87 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	InitializeActorState(Reference<BlobMigrator> const& self) 
															#line 87 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 87 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : self(self),
															#line 88 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   controller(makeReference<BlobRestoreController>(self->db_, normalKeys))
															#line 421 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("initialize", reinterpret_cast<unsigned long>(this));

	}
	~InitializeActorState() 
	{
		fdb_probe_actor_destroy("initialize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 89 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_0 = BlobRestoreController::setLockOwner(controller, self->interf_.id());
															#line 89 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 438 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<InitializeActor*>(this)->actor_wait_state = 1;
															#line 89 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 0, Void >*>(static_cast<InitializeActor*>(this)));
															#line 443 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InitializeActorState();
		static_cast<InitializeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 91 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		;
															#line 466 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 91 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		;
															#line 475 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InitializeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 92 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<BlobRestorePhase> __when_expr_1 = BlobRestoreController::currentPhase(controller);
															#line 92 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 568 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 2;
															#line 92 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 1, BlobRestorePhase >*>(static_cast<InitializeActor*>(this)));
															#line 573 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 93 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (phase < BlobRestorePhase::LOADED_MANIFEST)
															#line 582 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 94 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("BlobMigratorWaitingManifest", self->interf_.id()).detail("Phase", phase);
															#line 95 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_2 = BlobRestoreController::onPhaseChange(controller, BlobRestorePhase::LOADED_MANIFEST);
															#line 95 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 590 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<InitializeActor*>(this)->actor_wait_state = 3;
															#line 95 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 2, Void >*>(static_cast<InitializeActor*>(this)));
															#line 595 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(BlobRestorePhase const& __phase,int loopDepth) 
	{
															#line 92 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		phase = __phase;
															#line 609 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(BlobRestorePhase && __phase,int loopDepth) 
	{
		phase = std::move(__phase);
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 1, BlobRestorePhase >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 1, BlobRestorePhase >*,BlobRestorePhase const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 1, BlobRestorePhase >*,BlobRestorePhase && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< InitializeActor, 1, BlobRestorePhase >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 99 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (phase > BlobRestorePhase::COPIED_DATA)
															#line 688 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 100 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			CODE_PROBE(true, "Restart blob migrator after data copy");
															#line 101 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("BlobMigratorAlreadyCopied", self->interf_.id()).detail("Phase", phase);
															#line 102 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (!static_cast<InitializeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeActorState(); static_cast<InitializeActor*>(this)->destroy(); return 0; }
															#line 696 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			new (&static_cast<InitializeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~InitializeActorState();
			static_cast<InitializeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 105 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		auto db = SystemDBWriteLockedNow(self->db_.getReference());
															#line 106 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<std::string> __when_expr_3 = BlobGranuleRestoreConfig().manifestUrl().getD(db);
															#line 106 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 708 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 4;
															#line 106 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 3, std::string >*>(static_cast<InitializeActor*>(this)));
															#line 713 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< InitializeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont5(std::string const& url,int loopDepth) 
	{
															#line 107 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Reference<BlobConnectionProvider> blobConn = BlobConnectionProvider::newBlobConnectionProvider(url);
															#line 108 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<BlobGranuleRestoreVersionVector> __when_expr_4 = listBlobGranules(self->db_, self->dbInfo_, blobConn);
															#line 108 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 813 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 5;
															#line 108 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 4, BlobGranuleRestoreVersionVector >*>(static_cast<InitializeActor*>(this)));
															#line 818 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(std::string && url,int loopDepth) 
	{
															#line 107 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Reference<BlobConnectionProvider> blobConn = BlobConnectionProvider::newBlobConnectionProvider(url);
															#line 108 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<BlobGranuleRestoreVersionVector> __when_expr_4 = listBlobGranules(self->db_, self->dbInfo_, blobConn);
															#line 108 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 831 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 5;
															#line 108 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 4, BlobGranuleRestoreVersionVector >*>(static_cast<InitializeActor*>(this)));
															#line 836 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(std::string const& url,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(url, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(std::string && url,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(url), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 3, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 3, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 3, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< InitializeActor, 3, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont7(BlobGranuleRestoreVersionVector const& granules,int loopDepth) 
	{
															#line 109 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		self->blobGranules_ = granules;
															#line 110 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("RestorableGranule", self->interf_.id()).detail("Size", self->blobGranules_.size());
															#line 111 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (granules.empty())
															#line 924 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 112 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("EmptyBlobGranules", self->interf_.id()).log();
															#line 113 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			CODE_PROBE(true, "Blob restore with no blob granules");
															#line 114 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_5 = canRestore(self);
															#line 114 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 934 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont7when1(__when_expr_5.get(), loopDepth); };
			static_cast<InitializeActor*>(this)->actor_wait_state = 6;
															#line 114 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 5, Void >*>(static_cast<InitializeActor*>(this)));
															#line 939 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(BlobGranuleRestoreVersionVector && granules,int loopDepth) 
	{
															#line 109 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		self->blobGranules_ = granules;
															#line 110 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("RestorableGranule", self->interf_.id()).detail("Size", self->blobGranules_.size());
															#line 111 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (granules.empty())
															#line 957 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 112 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("EmptyBlobGranules", self->interf_.id()).log();
															#line 113 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			CODE_PROBE(true, "Blob restore with no blob granules");
															#line 114 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_5 = canRestore(self);
															#line 114 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 967 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont7when1(__when_expr_5.get(), loopDepth); };
			static_cast<InitializeActor*>(this)->actor_wait_state = 6;
															#line 114 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 5, Void >*>(static_cast<InitializeActor*>(this)));
															#line 972 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(BlobGranuleRestoreVersionVector const& granules,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(granules, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(BlobGranuleRestoreVersionVector && granules,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(granules), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 4, BlobGranuleRestoreVersionVector >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 4, BlobGranuleRestoreVersionVector >*,BlobGranuleRestoreVersionVector const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 4, BlobGranuleRestoreVersionVector >*,BlobGranuleRestoreVersionVector && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< InitializeActor, 4, BlobGranuleRestoreVersionVector >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont8(int loopDepth) 
	{
															#line 121 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (phase == BlobRestorePhase::LOADED_MANIFEST)
															#line 1061 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
			try {
															#line 123 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				StrictFuture<Void> __when_expr_8 = canRestore(self);
															#line 123 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont8Catch1(actor_cancelled(), loopDepth);
															#line 1068 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
				if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1cont8Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1cont8when1(__when_expr_8.get(), loopDepth); };
				static_cast<InitializeActor*>(this)->actor_wait_state = 9;
															#line 123 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 8, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1073 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1cont8Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1cont8Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
															#line 134 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (phase == BlobRestorePhase::COPYING_DATA)
															#line 1086 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			{
															#line 135 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				CODE_PROBE(true, "Restart blob migrator during data copy");
															#line 1090 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
				try {
															#line 137 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
					StrictFuture<Void> __when_expr_13 = prepare(self, normalKeys);
															#line 137 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
					if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont8Catch2(actor_cancelled(), loopDepth);
															#line 1096 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
					if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont1loopBody1cont8Catch2(__when_expr_13.getError(), loopDepth); else return a_body1cont1loopBody1cont8when2(__when_expr_13.get(), loopDepth); };
					static_cast<InitializeActor*>(this)->actor_wait_state = 14;
															#line 137 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
					__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 13, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1101 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1cont1loopBody1cont8Catch2(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont1loopBody1cont8Catch2(unknown_error(), loopDepth);
				}
			}
			else
			{
															#line 146 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				if (phase == BlobRestorePhase::COPIED_DATA)
															#line 1114 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
				{
															#line 147 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
					CODE_PROBE(true, "Restart blob migrator after data copy");
															#line 148 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
					self->addActor(logProgress(self));
															#line 1120 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
				}
				loopDepth = a_body1cont1loopBody1cont14(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 115 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_6 = preloadApplyMutationsKeyVersionMap(self);
															#line 115 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1134 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 7;
															#line 115 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 6, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1139 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 115 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_6 = preloadApplyMutationsKeyVersionMap(self);
															#line 115 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1150 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 7;
															#line 115 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 6, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1155 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< InitializeActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_7 = BlobRestoreController::setPhase(controller, APPLYING_MLOGS, self->interf_.id());
															#line 116 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1241 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont10when1(__when_expr_7.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 8;
															#line 116 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 7, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1246 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_7 = BlobRestoreController::setPhase(controller, APPLYING_MLOGS, self->interf_.id());
															#line 116 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1257 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont10when1(__when_expr_7.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 8;
															#line 116 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 7, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1262 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< InitializeActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 117 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<InitializeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeActorState(); static_cast<InitializeActor*>(this)->destroy(); return 0; }
															#line 1346 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<InitializeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeActorState();
		static_cast<InitializeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont10cont1(Void && _,int loopDepth) 
	{
															#line 117 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<InitializeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeActorState(); static_cast<InitializeActor*>(this)->destroy(); return 0; }
															#line 1358 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<InitializeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeActorState();
		static_cast<InitializeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< InitializeActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1cont11(int loopDepth) 
	{
															#line 150 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<InitializeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeActorState(); static_cast<InitializeActor*>(this)->destroy(); return 0; }
															#line 1445 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<InitializeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeActorState();
		static_cast<InitializeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont12(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 131 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("BlobMigratorStartCopyingError", self->interf_.id()).error(e);
															#line 132 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1466 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13(Void const& _,int loopDepth) 
	{
															#line 124 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_9 = preloadApplyMutationsKeyVersionMap(self);
															#line 124 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont8Catch1(actor_cancelled(), loopDepth);
															#line 1482 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1loopBody1cont8Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont1loopBody1cont13when1(__when_expr_9.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 10;
															#line 124 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 9, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1487 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13(Void && _,int loopDepth) 
	{
															#line 124 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_9 = preloadApplyMutationsKeyVersionMap(self);
															#line 124 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont8Catch1(actor_cancelled(), loopDepth);
															#line 1498 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1loopBody1cont8Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont1loopBody1cont13when1(__when_expr_9.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 10;
															#line 124 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 9, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1503 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< InitializeActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont1loopBody1cont13cont1(Void const& _,int loopDepth) 
	{
															#line 125 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_10 = prepare(self, normalKeys);
															#line 125 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont8Catch1(actor_cancelled(), loopDepth);
															#line 1589 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1loopBody1cont8Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont1when1(__when_expr_10.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 11;
															#line 125 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 10, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1594 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont1(Void && _,int loopDepth) 
	{
															#line 125 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_10 = prepare(self, normalKeys);
															#line 125 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont8Catch1(actor_cancelled(), loopDepth);
															#line 1605 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1loopBody1cont8Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont1when1(__when_expr_10.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 11;
															#line 125 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 10, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1610 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< InitializeActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont1loopBody1cont13cont2(Void const& _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_11 = advanceVersion(self);
															#line 126 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont8Catch1(actor_cancelled(), loopDepth);
															#line 1696 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1loopBody1cont8Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont2when1(__when_expr_11.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 12;
															#line 126 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 11, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1701 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont2(Void && _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_11 = advanceVersion(self);
															#line 126 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont8Catch1(actor_cancelled(), loopDepth);
															#line 1712 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1loopBody1cont8Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont2when1(__when_expr_11.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 12;
															#line 126 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 11, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1717 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont13cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont13cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< InitializeActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont1loopBody1cont13cont3(Void const& _,int loopDepth) 
	{
															#line 127 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_12 = BlobRestoreController::setPhase(controller, COPYING_DATA, self->interf_.id());
															#line 127 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont8Catch1(actor_cancelled(), loopDepth);
															#line 1803 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1loopBody1cont8Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont3when1(__when_expr_12.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 13;
															#line 127 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 12, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1808 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont3(Void && _,int loopDepth) 
	{
															#line 127 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_12 = BlobRestoreController::setPhase(controller, COPYING_DATA, self->interf_.id());
															#line 127 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<InitializeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont8Catch1(actor_cancelled(), loopDepth);
															#line 1819 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1loopBody1cont8Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont1loopBody1cont13cont3when1(__when_expr_12.get(), loopDepth); };
		static_cast<InitializeActor*>(this)->actor_wait_state = 13;
															#line 127 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< InitializeActor, 12, Void >*>(static_cast<InitializeActor*>(this)));
															#line 1824 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont13cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont13cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< InitializeActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont1loopBody1cont13cont4(Void const& _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		self->addActor(logProgress(self));
															#line 129 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("BlobMigratorStartCopying", self->interf_.id()).log();
															#line 1910 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont4(Void && _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		self->addActor(logProgress(self));
															#line 129 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("BlobMigratorStartCopying", self->interf_.id()).log();
															#line 1921 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont13cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont13cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont13cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont13cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< InitializeActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont1loopBody1cont13cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont14(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont15(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 143 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("ReplacedStorageInterfaceError", self->interf_.id()).error(e);
															#line 144 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2033 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont16(Void const& _,int loopDepth) 
	{
															#line 138 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Replace storage server interface {}\n", self->interf_.ssi.id().toString());
															#line 139 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("ReplacedStorageInterface", self->interf_.id()).log();
															#line 141 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		self->addActor(logProgress(self));
															#line 2051 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont16cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont16(Void && _,int loopDepth) 
	{
															#line 138 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Replace storage server interface {}\n", self->interf_.ssi.id().toString());
															#line 139 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("ReplacedStorageInterface", self->interf_.id()).log();
															#line 141 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		self->addActor(logProgress(self));
															#line 2064 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont16cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<InitializeActor*>(this)->actor_wait_state > 0) static_cast<InitializeActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeActor*>(this)->ActorCallback< InitializeActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont8when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< InitializeActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont8when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< InitializeActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont8Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont8Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont8Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont1loopBody1cont16cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 87 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobMigrator> self;
															#line 88 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobRestoreController> controller;
															#line 92 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	BlobRestorePhase phase;
															#line 2163 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via initialize()
															#line 87 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class InitializeActor final : public Actor<Void>, public ActorCallback< InitializeActor, 0, Void >, public ActorCallback< InitializeActor, 1, BlobRestorePhase >, public ActorCallback< InitializeActor, 2, Void >, public ActorCallback< InitializeActor, 3, std::string >, public ActorCallback< InitializeActor, 4, BlobGranuleRestoreVersionVector >, public ActorCallback< InitializeActor, 5, Void >, public ActorCallback< InitializeActor, 6, Void >, public ActorCallback< InitializeActor, 7, Void >, public ActorCallback< InitializeActor, 8, Void >, public ActorCallback< InitializeActor, 9, Void >, public ActorCallback< InitializeActor, 10, Void >, public ActorCallback< InitializeActor, 11, Void >, public ActorCallback< InitializeActor, 12, Void >, public ActorCallback< InitializeActor, 13, Void >, public FastAllocated<InitializeActor>, public InitializeActorState<InitializeActor> {
															#line 2168 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<InitializeActor>::operator new;
	using FastAllocated<InitializeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8996926642696642304UL, 1826779283889957632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InitializeActor, 0, Void >;
friend struct ActorCallback< InitializeActor, 1, BlobRestorePhase >;
friend struct ActorCallback< InitializeActor, 2, Void >;
friend struct ActorCallback< InitializeActor, 3, std::string >;
friend struct ActorCallback< InitializeActor, 4, BlobGranuleRestoreVersionVector >;
friend struct ActorCallback< InitializeActor, 5, Void >;
friend struct ActorCallback< InitializeActor, 6, Void >;
friend struct ActorCallback< InitializeActor, 7, Void >;
friend struct ActorCallback< InitializeActor, 8, Void >;
friend struct ActorCallback< InitializeActor, 9, Void >;
friend struct ActorCallback< InitializeActor, 10, Void >;
friend struct ActorCallback< InitializeActor, 11, Void >;
friend struct ActorCallback< InitializeActor, 12, Void >;
friend struct ActorCallback< InitializeActor, 13, Void >;
															#line 87 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	InitializeActor(Reference<BlobMigrator> const& self) 
															#line 2198 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<Void>(),
		   InitializeActorState<InitializeActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("initialize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(377676441043239424UL, 4804261275250009856UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("initialize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("initialize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InitializeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< InitializeActor, 1, BlobRestorePhase >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< InitializeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< InitializeActor, 3, std::string >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< InitializeActor, 4, BlobGranuleRestoreVersionVector >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< InitializeActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< InitializeActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< InitializeActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< InitializeActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< InitializeActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< InitializeActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< InitializeActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< InitializeActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< InitializeActor, 13, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 87 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] static Future<Void> initialize( Reference<BlobMigrator> const& self ) {
															#line 87 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<Void>(new InitializeActor(self));
															#line 2243 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 153 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"

	// Prepare for data migration for given key range.
																#line 2249 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
// This generated class is to be used only via prepare()
															#line 155 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class PrepareActor>
															#line 155 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class PrepareActorState {
															#line 2255 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 155 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	PrepareActorState(Reference<BlobMigrator> const& self,KeyRangeRef const& keys) 
															#line 155 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 155 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : self(self),
															#line 155 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   keys(keys),
															#line 156 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   replyFuture(Never()),
															#line 157 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   dbInfoChange(Void()),
															#line 158 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   delayTime(Void()),
															#line 159 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   retries(0),
															#line 160 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   requestId()
															#line 2274 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("prepare", reinterpret_cast<unsigned long>(this));

	}
	~PrepareActorState() 
	{
		fdb_probe_actor_destroy("prepare", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 161 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			;
															#line 2289 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrepareActorState();
		static_cast<PrepareActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 163 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_0 = dbInfoChange;
															#line 162 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<PrepareActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2321 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 180 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<ErrorOr<PrepareBlobRestoreReply>> __when_expr_1 = replyFuture;
															#line 2325 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<PrepareActor*>(this)->actor_wait_state = 1;
															#line 163 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrepareActor, 0, Void >*>(static_cast<PrepareActor*>(this)));
															#line 180 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrepareActor, 1, ErrorOr<PrepareBlobRestoreReply> >*>(static_cast<PrepareActor*>(this)));
															#line 2332 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 210 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delayTime;
															#line 210 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<PrepareActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2343 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<PrepareActor*>(this)->actor_wait_state = 2;
															#line 210 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PrepareActor, 2, Void >*>(static_cast<PrepareActor*>(this)));
															#line 2348 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 164 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (self->dbInfo_->get().distributor.present())
															#line 2357 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 165 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			requestId = deterministicRandom()->randomUniqueID();
															#line 166 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			replyFuture = timeout(self->dbInfo_->get().distributor.get().prepareBlobRestoreReq.tryGetReply( PrepareBlobRestoreRequest(requestId, self->interf_.ssi, keys)), SERVER_KNOBS->BLOB_MIGRATOR_PREPARE_TIMEOUT, ErrorOr<PrepareBlobRestoreReply>(timed_out()));
															#line 170 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			dbInfoChange = Never();
															#line 171 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("BlobRestorePrepare", self->interf_.id()) .detail("State", "SendReq") .detail("ReqId", requestId);
															#line 2367 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
		else
		{
															#line 175 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			replyFuture = Never();
															#line 176 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			dbInfoChange = self->dbInfo_->onChange();
															#line 177 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent(SevWarn, "BlobRestorePrepare", self->interf_.id()).detail("State", "WaitDD");
															#line 2377 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 164 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (self->dbInfo_->get().distributor.present())
															#line 2387 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 165 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			requestId = deterministicRandom()->randomUniqueID();
															#line 166 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			replyFuture = timeout(self->dbInfo_->get().distributor.get().prepareBlobRestoreReq.tryGetReply( PrepareBlobRestoreRequest(requestId, self->interf_.ssi, keys)), SERVER_KNOBS->BLOB_MIGRATOR_PREPARE_TIMEOUT, ErrorOr<PrepareBlobRestoreReply>(timed_out()));
															#line 170 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			dbInfoChange = Never();
															#line 171 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("BlobRestorePrepare", self->interf_.id()) .detail("State", "SendReq") .detail("ReqId", requestId);
															#line 2397 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
		else
		{
															#line 175 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			replyFuture = Never();
															#line 176 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			dbInfoChange = self->dbInfo_->onChange();
															#line 177 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent(SevWarn, "BlobRestorePrepare", self->interf_.id()).detail("State", "WaitDD");
															#line 2407 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ErrorOr<PrepareBlobRestoreReply> const& reply,int loopDepth) 
	{
															#line 181 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (reply.isError())
															#line 2417 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 182 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("BlobRestorePrepare", self->interf_.id()) .error(reply.getError()) .detail("State", "Error") .detail("ReqId", requestId);
															#line 186 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (reply.getError().code() == error_code_restore_error)
															#line 2423 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			{
															#line 187 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				return a_body1Catch1(restore_error(), std::max(0, loopDepth - 1));
															#line 2427 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			}
		}
		else
		{
															#line 189 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (reply.get().res == PrepareBlobRestoreReply::SUCCESS)
															#line 2434 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			{
															#line 190 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				TraceEvent("BlobRestorePrepare", self->interf_.id()) .detail("State", "Success") .detail("ReqId", requestId);
															#line 193 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				if (!static_cast<PrepareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrepareActorState(); static_cast<PrepareActor*>(this)->destroy(); return 0; }
															#line 2440 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
				new (&static_cast<PrepareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PrepareActorState();
				static_cast<PrepareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 195 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				TraceEvent("BlobRestorePrepare", self->interf_.id()) .detail("State", "Failed") .detail("ReqId", requestId) .detail("Reply", reply.get().toString()) .detail("Retries", retries);
															#line 2450 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			}
		}
															#line 202 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (++retries > SERVER_KNOBS->BLOB_MIGRATOR_ERROR_RETRIES)
															#line 2455 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 203 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			return a_body1Catch1(restore_error(), std::max(0, loopDepth - 1));
															#line 2459 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
															#line 205 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		delayTime = delayJittered(10.0);
															#line 206 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dbInfoChange = Void();
															#line 2465 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ErrorOr<PrepareBlobRestoreReply> && reply,int loopDepth) 
	{
															#line 181 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (reply.isError())
															#line 2474 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 182 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("BlobRestorePrepare", self->interf_.id()) .error(reply.getError()) .detail("State", "Error") .detail("ReqId", requestId);
															#line 186 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (reply.getError().code() == error_code_restore_error)
															#line 2480 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			{
															#line 187 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				return a_body1Catch1(restore_error(), std::max(0, loopDepth - 1));
															#line 2484 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			}
		}
		else
		{
															#line 189 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (reply.get().res == PrepareBlobRestoreReply::SUCCESS)
															#line 2491 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			{
															#line 190 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				TraceEvent("BlobRestorePrepare", self->interf_.id()) .detail("State", "Success") .detail("ReqId", requestId);
															#line 193 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				if (!static_cast<PrepareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrepareActorState(); static_cast<PrepareActor*>(this)->destroy(); return 0; }
															#line 2497 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
				new (&static_cast<PrepareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PrepareActorState();
				static_cast<PrepareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 195 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				TraceEvent("BlobRestorePrepare", self->interf_.id()) .detail("State", "Failed") .detail("ReqId", requestId) .detail("Reply", reply.get().toString()) .detail("Retries", retries);
															#line 2507 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			}
		}
															#line 202 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (++retries > SERVER_KNOBS->BLOB_MIGRATOR_ERROR_RETRIES)
															#line 2512 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 203 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			return a_body1Catch1(restore_error(), std::max(0, loopDepth - 1));
															#line 2516 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
															#line 205 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		delayTime = delayJittered(10.0);
															#line 206 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dbInfoChange = Void();
															#line 2522 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrepareActor*>(this)->actor_wait_state > 0) static_cast<PrepareActor*>(this)->actor_wait_state = 0;
		static_cast<PrepareActor*>(this)->ActorCallback< PrepareActor, 0, Void >::remove();
		static_cast<PrepareActor*>(this)->ActorCallback< PrepareActor, 1, ErrorOr<PrepareBlobRestoreReply> >::remove();

	}
	void a_callback_fire(ActorCallback< PrepareActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("prepare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrepareActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("prepare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrepareActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("prepare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrepareActor, 1, ErrorOr<PrepareBlobRestoreReply> >*,ErrorOr<PrepareBlobRestoreReply> const& value) 
	{
		fdb_probe_actor_enter("prepare", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepare", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrepareActor, 1, ErrorOr<PrepareBlobRestoreReply> >*,ErrorOr<PrepareBlobRestoreReply> && value) 
	{
		fdb_probe_actor_enter("prepare", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepare", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrepareActor, 1, ErrorOr<PrepareBlobRestoreReply> >*,Error err) 
	{
		fdb_probe_actor_enter("prepare", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepare", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PrepareActor*>(this)->actor_wait_state > 0) static_cast<PrepareActor*>(this)->actor_wait_state = 0;
		static_cast<PrepareActor*>(this)->ActorCallback< PrepareActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrepareActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("prepare", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepare", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PrepareActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("prepare", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepare", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PrepareActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("prepare", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepare", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 155 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobMigrator> self;
															#line 155 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	KeyRangeRef keys;
															#line 156 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Future<ErrorOr<PrepareBlobRestoreReply>> replyFuture;
															#line 157 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Future<Void> dbInfoChange;
															#line 158 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Future<Void> delayTime;
															#line 159 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	int retries;
															#line 160 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	UID requestId;
															#line 2749 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via prepare()
															#line 155 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class PrepareActor final : public Actor<Void>, public ActorCallback< PrepareActor, 0, Void >, public ActorCallback< PrepareActor, 1, ErrorOr<PrepareBlobRestoreReply> >, public ActorCallback< PrepareActor, 2, Void >, public FastAllocated<PrepareActor>, public PrepareActorState<PrepareActor> {
															#line 2754 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<PrepareActor>::operator new;
	using FastAllocated<PrepareActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11590119906612118272UL, 8765660877533851392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrepareActor, 0, Void >;
friend struct ActorCallback< PrepareActor, 1, ErrorOr<PrepareBlobRestoreReply> >;
friend struct ActorCallback< PrepareActor, 2, Void >;
															#line 155 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	PrepareActor(Reference<BlobMigrator> const& self,KeyRangeRef const& keys) 
															#line 2773 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<Void>(),
		   PrepareActorState<PrepareActor>(self, keys),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("prepare", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8052233063364316672UL, 8871075011735933440UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("prepare");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("prepare", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrepareActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PrepareActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 155 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] static Future<Void> prepare( Reference<BlobMigrator> const& self, KeyRangeRef const& keys ) {
															#line 155 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<Void>(new PrepareActor(self, keys));
															#line 2806 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 213 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"

	// Monitor migration progress periodically
																#line 2812 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
// This generated class is to be used only via logProgress()
															#line 215 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class LogProgressActor>
															#line 215 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class LogProgressActorState {
															#line 2818 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 215 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	LogProgressActorState(Reference<BlobMigrator> const& self) 
															#line 215 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 215 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : self(self),
															#line 216 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   controller(makeReference<BlobRestoreController>(self->db_, normalKeys))
															#line 2827 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("logProgress", reinterpret_cast<unsigned long>(this));

	}
	~LogProgressActorState() 
	{
		fdb_probe_actor_destroy("logProgress", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 217 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			;
															#line 2842 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogProgressActorState();
		static_cast<LogProgressActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 218 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<BlobRestorePhase> __when_expr_0 = BlobRestoreController::currentPhase(controller);
															#line 218 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<LogProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2874 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<LogProgressActor*>(this)->actor_wait_state = 1;
															#line 218 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogProgressActor, 0, BlobRestorePhase >*>(static_cast<LogProgressActor*>(this)));
															#line 2879 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(BlobRestorePhase const& phase,int loopDepth) 
	{
															#line 219 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (phase > COPIED_DATA)
															#line 2888 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 220 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (!static_cast<LogProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogProgressActorState(); static_cast<LogProgressActor*>(this)->destroy(); return 0; }
															#line 2892 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			new (&static_cast<LogProgressActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~LogProgressActorState();
			static_cast<LogProgressActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 222 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<bool> __when_expr_1 = checkCopyProgress(self);
															#line 222 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<LogProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2902 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LogProgressActor*>(this)->actor_wait_state = 2;
															#line 222 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LogProgressActor, 1, bool >*>(static_cast<LogProgressActor*>(this)));
															#line 2907 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(BlobRestorePhase && phase,int loopDepth) 
	{
															#line 219 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (phase > COPIED_DATA)
															#line 2916 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 220 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (!static_cast<LogProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogProgressActorState(); static_cast<LogProgressActor*>(this)->destroy(); return 0; }
															#line 2920 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			new (&static_cast<LogProgressActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~LogProgressActorState();
			static_cast<LogProgressActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 222 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<bool> __when_expr_1 = checkCopyProgress(self);
															#line 222 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<LogProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2930 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LogProgressActor*>(this)->actor_wait_state = 2;
															#line 222 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LogProgressActor, 1, bool >*>(static_cast<LogProgressActor*>(this)));
															#line 2935 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(BlobRestorePhase const& phase,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(phase, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(BlobRestorePhase && phase,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(phase), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogProgressActor*>(this)->actor_wait_state > 0) static_cast<LogProgressActor*>(this)->actor_wait_state = 0;
		static_cast<LogProgressActor*>(this)->ActorCallback< LogProgressActor, 0, BlobRestorePhase >::remove();

	}
	void a_callback_fire(ActorCallback< LogProgressActor, 0, BlobRestorePhase >*,BlobRestorePhase const& value) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogProgressActor, 0, BlobRestorePhase >*,BlobRestorePhase && value) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogProgressActor, 0, BlobRestorePhase >*,Error err) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(bool const& done,int loopDepth) 
	{
															#line 223 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (done)
															#line 3019 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 224 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_2 = BlobRestoreController::setPhase(controller, COPIED_DATA, self->interf_.id());
															#line 224 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<LogProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3025 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<LogProgressActor*>(this)->actor_wait_state = 3;
															#line 224 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LogProgressActor, 2, Void >*>(static_cast<LogProgressActor*>(this)));
															#line 3030 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool && done,int loopDepth) 
	{
															#line 223 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (done)
															#line 3044 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 224 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_2 = BlobRestoreController::setPhase(controller, COPIED_DATA, self->interf_.id());
															#line 224 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<LogProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3050 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<LogProgressActor*>(this)->actor_wait_state = 3;
															#line 224 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LogProgressActor, 2, Void >*>(static_cast<LogProgressActor*>(this)));
															#line 3055 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(bool const& done,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(done, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(bool && done,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(done), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LogProgressActor*>(this)->actor_wait_state > 0) static_cast<LogProgressActor*>(this)->actor_wait_state = 0;
		static_cast<LogProgressActor*>(this)->ActorCallback< LogProgressActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< LogProgressActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LogProgressActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LogProgressActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 230 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_5 = delay(SERVER_KNOBS->BLOB_MIGRATOR_CHECK_INTERVAL);
															#line 230 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<LogProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3146 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_5.get(), loopDepth); };
		static_cast<LogProgressActor*>(this)->actor_wait_state = 6;
															#line 230 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< LogProgressActor, 5, Void >*>(static_cast<LogProgressActor*>(this)));
															#line 3151 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 225 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForPendingDataMovements(self);
															#line 225 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<LogProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3162 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<LogProgressActor*>(this)->actor_wait_state = 4;
															#line 225 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LogProgressActor, 3, Void >*>(static_cast<LogProgressActor*>(this)));
															#line 3167 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 225 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForPendingDataMovements(self);
															#line 225 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<LogProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3178 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<LogProgressActor*>(this)->actor_wait_state = 4;
															#line 225 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LogProgressActor, 3, Void >*>(static_cast<LogProgressActor*>(this)));
															#line 3183 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LogProgressActor*>(this)->actor_wait_state > 0) static_cast<LogProgressActor*>(this)->actor_wait_state = 0;
		static_cast<LogProgressActor*>(this)->ActorCallback< LogProgressActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogProgressActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LogProgressActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LogProgressActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 226 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_4 = BlobRestoreController::setPhase(controller, APPLYING_MLOGS, self->interf_.id());
															#line 226 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<LogProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3269 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<LogProgressActor*>(this)->actor_wait_state = 5;
															#line 226 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LogProgressActor, 4, Void >*>(static_cast<LogProgressActor*>(this)));
															#line 3274 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 226 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_4 = BlobRestoreController::setPhase(controller, APPLYING_MLOGS, self->interf_.id());
															#line 226 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<LogProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3285 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<LogProgressActor*>(this)->actor_wait_state = 5;
															#line 226 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LogProgressActor, 4, Void >*>(static_cast<LogProgressActor*>(this)));
															#line 3290 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LogProgressActor*>(this)->actor_wait_state > 0) static_cast<LogProgressActor*>(this)->actor_wait_state = 0;
		static_cast<LogProgressActor*>(this)->ActorCallback< LogProgressActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogProgressActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LogProgressActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LogProgressActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 227 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("BlobMigratorCopied", self->interf_.id()).log();
															#line 228 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<LogProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogProgressActorState(); static_cast<LogProgressActor*>(this)->destroy(); return 0; }
															#line 3376 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<LogProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LogProgressActorState();
		static_cast<LogProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 227 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("BlobMigratorCopied", self->interf_.id()).log();
															#line 228 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<LogProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogProgressActorState(); static_cast<LogProgressActor*>(this)->destroy(); return 0; }
															#line 3390 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<LogProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LogProgressActorState();
		static_cast<LogProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<LogProgressActor*>(this)->actor_wait_state > 0) static_cast<LogProgressActor*>(this)->actor_wait_state = 0;
		static_cast<LogProgressActor*>(this)->ActorCallback< LogProgressActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogProgressActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LogProgressActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< LogProgressActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<LogProgressActor*>(this)->actor_wait_state > 0) static_cast<LogProgressActor*>(this)->actor_wait_state = 0;
		static_cast<LogProgressActor*>(this)->ActorCallback< LogProgressActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogProgressActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< LogProgressActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< LogProgressActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 215 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobMigrator> self;
															#line 216 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobRestoreController> controller;
															#line 3564 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via logProgress()
															#line 215 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class LogProgressActor final : public Actor<Void>, public ActorCallback< LogProgressActor, 0, BlobRestorePhase >, public ActorCallback< LogProgressActor, 1, bool >, public ActorCallback< LogProgressActor, 2, Void >, public ActorCallback< LogProgressActor, 3, Void >, public ActorCallback< LogProgressActor, 4, Void >, public ActorCallback< LogProgressActor, 5, Void >, public FastAllocated<LogProgressActor>, public LogProgressActorState<LogProgressActor> {
															#line 3569 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<LogProgressActor>::operator new;
	using FastAllocated<LogProgressActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8784836578093908736UL, 5740189964290437120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogProgressActor, 0, BlobRestorePhase >;
friend struct ActorCallback< LogProgressActor, 1, bool >;
friend struct ActorCallback< LogProgressActor, 2, Void >;
friend struct ActorCallback< LogProgressActor, 3, Void >;
friend struct ActorCallback< LogProgressActor, 4, Void >;
friend struct ActorCallback< LogProgressActor, 5, Void >;
															#line 215 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	LogProgressActor(Reference<BlobMigrator> const& self) 
															#line 3591 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<Void>(),
		   LogProgressActorState<LogProgressActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logProgress", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16577774797264795904UL, 13145888694212198144UL);
		ActorExecutionContextHelper __helper(static_cast<LogProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logProgress");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logProgress", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogProgressActor, 0, BlobRestorePhase >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LogProgressActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LogProgressActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LogProgressActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< LogProgressActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< LogProgressActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 215 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] static Future<Void> logProgress( Reference<BlobMigrator> const& self ) {
															#line 215 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<Void>(new LogProgressActor(self));
															#line 3628 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 233 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"

	// Wait until all pending data movements are done. Data movement starts earlier may still potentially
	// read data from blob, which may cause race with applying mutation logs.
																#line 3635 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
// This generated class is to be used only via waitForPendingDataMovements()
															#line 236 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class WaitForPendingDataMovementsActor>
															#line 236 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class WaitForPendingDataMovementsActorState {
															#line 3641 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 236 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	WaitForPendingDataMovementsActorState(Reference<BlobMigrator> const& self) 
															#line 236 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 236 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : self(self)
															#line 3648 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForPendingDataMovements", reinterpret_cast<unsigned long>(this));

	}
	~WaitForPendingDataMovementsActorState() 
	{
		fdb_probe_actor_destroy("waitForPendingDataMovements", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 237 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			;
															#line 3663 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForPendingDataMovementsActorState();
		static_cast<WaitForPendingDataMovementsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 238 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<bool> __when_expr_0 = checkPendingDataMovements(self);
															#line 238 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<WaitForPendingDataMovementsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3695 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitForPendingDataMovementsActor*>(this)->actor_wait_state = 1;
															#line 238 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForPendingDataMovementsActor, 0, bool >*>(static_cast<WaitForPendingDataMovementsActor*>(this)));
															#line 3700 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool const& pending,int loopDepth) 
	{
															#line 239 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("BlobMigratorCheckPendingMovement", self->interf_.id()).detail("Pending", pending);
															#line 240 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!pending)
															#line 3711 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 241 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (!static_cast<WaitForPendingDataMovementsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForPendingDataMovementsActorState(); static_cast<WaitForPendingDataMovementsActor*>(this)->destroy(); return 0; }
															#line 3715 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			new (&static_cast<WaitForPendingDataMovementsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForPendingDataMovementsActorState();
			static_cast<WaitForPendingDataMovementsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 242 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->BLOB_MIGRATOR_CHECK_INTERVAL);
															#line 242 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<WaitForPendingDataMovementsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3725 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitForPendingDataMovementsActor*>(this)->actor_wait_state = 2;
															#line 242 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForPendingDataMovementsActor, 1, Void >*>(static_cast<WaitForPendingDataMovementsActor*>(this)));
															#line 3730 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool && pending,int loopDepth) 
	{
															#line 239 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("BlobMigratorCheckPendingMovement", self->interf_.id()).detail("Pending", pending);
															#line 240 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!pending)
															#line 3741 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 241 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (!static_cast<WaitForPendingDataMovementsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForPendingDataMovementsActorState(); static_cast<WaitForPendingDataMovementsActor*>(this)->destroy(); return 0; }
															#line 3745 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			new (&static_cast<WaitForPendingDataMovementsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForPendingDataMovementsActorState();
			static_cast<WaitForPendingDataMovementsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 242 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->BLOB_MIGRATOR_CHECK_INTERVAL);
															#line 242 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<WaitForPendingDataMovementsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3755 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitForPendingDataMovementsActor*>(this)->actor_wait_state = 2;
															#line 242 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForPendingDataMovementsActor, 1, Void >*>(static_cast<WaitForPendingDataMovementsActor*>(this)));
															#line 3760 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& pending,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(pending, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && pending,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(pending), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForPendingDataMovementsActor*>(this)->actor_wait_state > 0) static_cast<WaitForPendingDataMovementsActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForPendingDataMovementsActor*>(this)->ActorCallback< WaitForPendingDataMovementsActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForPendingDataMovementsActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("waitForPendingDataMovements", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPendingDataMovements", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForPendingDataMovementsActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("waitForPendingDataMovements", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPendingDataMovements", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForPendingDataMovementsActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("waitForPendingDataMovements", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPendingDataMovements", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForPendingDataMovementsActor*>(this)->actor_wait_state > 0) static_cast<WaitForPendingDataMovementsActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForPendingDataMovementsActor*>(this)->ActorCallback< WaitForPendingDataMovementsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForPendingDataMovementsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForPendingDataMovements", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPendingDataMovements", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForPendingDataMovementsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForPendingDataMovements", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPendingDataMovements", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForPendingDataMovementsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForPendingDataMovements", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPendingDataMovements", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 236 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobMigrator> self;
															#line 3929 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via waitForPendingDataMovements()
															#line 236 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class WaitForPendingDataMovementsActor final : public Actor<Void>, public ActorCallback< WaitForPendingDataMovementsActor, 0, bool >, public ActorCallback< WaitForPendingDataMovementsActor, 1, Void >, public FastAllocated<WaitForPendingDataMovementsActor>, public WaitForPendingDataMovementsActorState<WaitForPendingDataMovementsActor> {
															#line 3934 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<WaitForPendingDataMovementsActor>::operator new;
	using FastAllocated<WaitForPendingDataMovementsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13168314528654383616UL, 16997120037669926912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForPendingDataMovementsActor, 0, bool >;
friend struct ActorCallback< WaitForPendingDataMovementsActor, 1, Void >;
															#line 236 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	WaitForPendingDataMovementsActor(Reference<BlobMigrator> const& self) 
															#line 3952 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<Void>(),
		   WaitForPendingDataMovementsActorState<WaitForPendingDataMovementsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForPendingDataMovements", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6838156321929548288UL, 18199029814093184512UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForPendingDataMovements");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForPendingDataMovements", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForPendingDataMovementsActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForPendingDataMovementsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 236 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] static Future<Void> waitForPendingDataMovements( Reference<BlobMigrator> const& self ) {
															#line 236 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<Void>(new WaitForPendingDataMovementsActor(self));
															#line 3985 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 245 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"

	// Check if there is any pending data movement
																#line 3991 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
// This generated class is to be used only via checkPendingDataMovements()
															#line 247 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class CheckPendingDataMovementsActor>
															#line 247 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class CheckPendingDataMovementsActorState {
															#line 3997 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 247 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	CheckPendingDataMovementsActorState(Reference<BlobMigrator> const& self) 
															#line 247 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 247 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : self(self),
															#line 248 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   controller(makeReference<BlobRestoreController>(self->db_, normalKeys)),
															#line 249 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   tr(self->db_),
															#line 250 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   begin(normalKeys.begin)
															#line 4010 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("checkPendingDataMovements", reinterpret_cast<unsigned long>(this));

	}
	~CheckPendingDataMovementsActorState() 
	{
		fdb_probe_actor_destroy("checkPendingDataMovements", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 252 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			;
															#line 4025 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckPendingDataMovementsActorState();
		static_cast<CheckPendingDataMovementsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 253 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 254 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 255 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 4059 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		try {
															#line 257 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 257 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<CheckPendingDataMovementsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4065 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckPendingDataMovementsActor*>(this)->actor_wait_state = 1;
															#line 257 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckPendingDataMovementsActor, 0, RangeResult >*>(static_cast<CheckPendingDataMovementsActor*>(this)));
															#line 4070 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 281 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 281 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<CheckPendingDataMovementsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4094 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckPendingDataMovementsActor*>(this)->actor_wait_state = 3;
															#line 281 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckPendingDataMovementsActor, 2, Void >*>(static_cast<CheckPendingDataMovementsActor*>(this)));
															#line 4099 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 258 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		src = std::vector<UID>();
															#line 259 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dest = std::vector<UID>();
															#line 260 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		srcId = UID();
															#line 261 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		destId = UID();
															#line 262 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 263 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		;
															#line 4124 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 257 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 4133 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckPendingDataMovementsActor*>(this)->actor_wait_state > 0) static_cast<CheckPendingDataMovementsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPendingDataMovementsActor*>(this)->ActorCallback< CheckPendingDataMovementsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPendingDataMovementsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckPendingDataMovementsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckPendingDataMovementsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 279 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<CheckPendingDataMovementsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckPendingDataMovementsActorState(); static_cast<CheckPendingDataMovementsActor*>(this)->destroy(); return 0; }
															#line 4212 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<CheckPendingDataMovementsActor*>(this)->SAV< bool >::value()) bool(false);
		this->~CheckPendingDataMovementsActorState();
		static_cast<CheckPendingDataMovementsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 263 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!(begin < normalKeys.end))
															#line 4231 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 264 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = krmGetRanges(&tr, keyServersPrefix, KeyRangeRef(begin, normalKeys.end), SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES);
															#line 264 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<CheckPendingDataMovementsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4239 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckPendingDataMovementsActor*>(this)->actor_wait_state = 2;
															#line 264 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckPendingDataMovementsActor, 1, RangeResult >*>(static_cast<CheckPendingDataMovementsActor*>(this)));
															#line 4244 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
															#line 269 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		i = 0;
															#line 270 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		for(;i < keyServers.size() - 1;++i) {
															#line 271 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			it = keyServers[i];
															#line 272 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, it.value, src, dest, srcId, destId);
															#line 273 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (!dest.empty())
															#line 4274 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			{
															#line 274 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				if (!static_cast<CheckPendingDataMovementsActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckPendingDataMovementsActorState(); static_cast<CheckPendingDataMovementsActor*>(this)->destroy(); return 0; }
															#line 4278 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
				new (&static_cast<CheckPendingDataMovementsActor*>(this)->SAV< bool >::value()) bool(true);
				this->~CheckPendingDataMovementsActorState();
				static_cast<CheckPendingDataMovementsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 277 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		begin = keyServers.back().key;
															#line 4287 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(RangeResult const& __keyServers,int loopDepth) 
	{
															#line 264 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		keyServers = __keyServers;
															#line 4296 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(RangeResult && __keyServers,int loopDepth) 
	{
		keyServers = std::move(__keyServers);
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckPendingDataMovementsActor*>(this)->actor_wait_state > 0) static_cast<CheckPendingDataMovementsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPendingDataMovementsActor*>(this)->ActorCallback< CheckPendingDataMovementsActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPendingDataMovementsActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckPendingDataMovementsActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckPendingDataMovementsActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckPendingDataMovementsActor*>(this)->actor_wait_state > 0) static_cast<CheckPendingDataMovementsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPendingDataMovementsActor*>(this)->ActorCallback< CheckPendingDataMovementsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPendingDataMovementsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckPendingDataMovementsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckPendingDataMovementsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 247 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobMigrator> self;
															#line 248 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobRestoreController> controller;
															#line 249 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Transaction tr;
															#line 250 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Key begin;
															#line 257 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 258 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	std::vector<UID> src;
															#line 259 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	std::vector<UID> dest;
															#line 260 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	UID srcId;
															#line 261 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	UID destId;
															#line 264 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	RangeResult keyServers;
															#line 269 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	int i;
															#line 271 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	KeyValueRef it;
															#line 4482 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via checkPendingDataMovements()
															#line 247 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class CheckPendingDataMovementsActor final : public Actor<bool>, public ActorCallback< CheckPendingDataMovementsActor, 0, RangeResult >, public ActorCallback< CheckPendingDataMovementsActor, 1, RangeResult >, public ActorCallback< CheckPendingDataMovementsActor, 2, Void >, public FastAllocated<CheckPendingDataMovementsActor>, public CheckPendingDataMovementsActorState<CheckPendingDataMovementsActor> {
															#line 4487 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<CheckPendingDataMovementsActor>::operator new;
	using FastAllocated<CheckPendingDataMovementsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16668683196436699136UL, 12782567423489819392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckPendingDataMovementsActor, 0, RangeResult >;
friend struct ActorCallback< CheckPendingDataMovementsActor, 1, RangeResult >;
friend struct ActorCallback< CheckPendingDataMovementsActor, 2, Void >;
															#line 247 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	CheckPendingDataMovementsActor(Reference<BlobMigrator> const& self) 
															#line 4506 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<bool>(),
		   CheckPendingDataMovementsActorState<CheckPendingDataMovementsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2614735818097524992UL, 13014008797484527872UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPendingDataMovementsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkPendingDataMovements");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkPendingDataMovements", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckPendingDataMovementsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckPendingDataMovementsActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckPendingDataMovementsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 247 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] static Future<bool> checkPendingDataMovements( Reference<BlobMigrator> const& self ) {
															#line 247 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<bool>(new CheckPendingDataMovementsActor(self));
															#line 4540 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 285 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"

	// Check key ranges that are copied. Return true if all ranges are done
																#line 4546 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
// This generated class is to be used only via checkCopyProgress()
															#line 287 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class CheckCopyProgressActor>
															#line 287 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class CheckCopyProgressActorState {
															#line 4552 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 287 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	CheckCopyProgressActorState(Reference<BlobMigrator> const& self) 
															#line 287 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 287 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : self(self),
															#line 288 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   controller(makeReference<BlobRestoreController>(self->db_, normalKeys)),
															#line 289 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   tr(self->db_)
															#line 4563 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("checkCopyProgress", reinterpret_cast<unsigned long>(this));

	}
	~CheckCopyProgressActorState() 
	{
		fdb_probe_actor_destroy("checkCopyProgress", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 290 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			;
															#line 4578 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckCopyProgressActorState();
		static_cast<CheckCopyProgressActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 291 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 292 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 293 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 4612 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		try {
															#line 297 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			currentKeys = normalKeys;
															#line 298 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			begin = normalKeys.begin;
															#line 299 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 299 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<CheckCopyProgressActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4622 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckCopyProgressActor*>(this)->actor_wait_state = 1;
															#line 299 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckCopyProgressActor, 0, RangeResult >*>(static_cast<CheckCopyProgressActor*>(this)));
															#line 4627 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 343 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 343 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<CheckCopyProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4651 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckCopyProgressActor*>(this)->actor_wait_state = 4;
															#line 343 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckCopyProgressActor, 3, Void >*>(static_cast<CheckCopyProgressActor*>(this)));
															#line 4656 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 300 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		src = std::vector<UID>();
															#line 301 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dest = std::vector<UID>();
															#line 302 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		srcId = UID();
															#line 303 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		destId = UID();
															#line 304 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 305 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		incompleted = 0;
															#line 306 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		;
															#line 4683 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 299 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 4692 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckCopyProgressActor*>(this)->actor_wait_state > 0) static_cast<CheckCopyProgressActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCopyProgressActor*>(this)->ActorCallback< CheckCopyProgressActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCopyProgressActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkCopyProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCopyProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCopyProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckCopyProgressActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkCopyProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCopyProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCopyProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckCopyProgressActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkCopyProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCopyProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCopyProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 335 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		int64_t total = sizeInBytes(self);
															#line 336 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		progress = (total - incompleted) * 100 / total;
															#line 337 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		done = incompleted == 0;
															#line 338 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Migration progress :{}%. done {}\n", progress, done);
															#line 339 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("BlobMigratorProgress", self->interf_.id()).detail("Progress", progress);
															#line 340 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_2 = BlobRestoreController::setProgress(controller, progress, self->interf_.id());
															#line 340 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<CheckCopyProgressActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4783 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckCopyProgressActor*>(this)->actor_wait_state = 3;
															#line 340 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckCopyProgressActor, 2, Void >*>(static_cast<CheckCopyProgressActor*>(this)));
															#line 4788 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 306 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!(begin < normalKeys.end))
															#line 4804 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 307 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = krmGetRanges(&tr, keyServersPrefix, KeyRangeRef(begin, normalKeys.end), SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES);
															#line 307 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<CheckCopyProgressActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4812 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckCopyProgressActor*>(this)->actor_wait_state = 2;
															#line 307 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckCopyProgressActor, 1, RangeResult >*>(static_cast<CheckCopyProgressActor*>(this)));
															#line 4817 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
															#line 312 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		i = 0;
															#line 313 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		for(;i < keyServers.size() - 1;++i) {
															#line 314 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			it = keyServers[i];
															#line 315 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, it.value, src, dest, srcId, destId);
															#line 317 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (std::find_if(src.begin(), src.end(), BlobMigratorInterface::isBlobMigrator) == src.end() && dest.empty())
															#line 4847 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			{
				continue;
			}
															#line 322 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			range = KeyRangeRef(it.key, keyServers[i + 1].key);
															#line 323 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			int64_t bytes = sizeInBytes(self, range);
															#line 324 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (bytes == 0)
															#line 4857 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			{
															#line 327 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				bytes = 1;
															#line 4861 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			}
															#line 329 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			dprint("   incompleted {}, size: {}\n", range.toString(), bytes);
															#line 330 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			incompleted += bytes;
															#line 4867 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
															#line 332 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		begin = keyServers.end()[-1].key;
															#line 4871 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(RangeResult const& __keyServers,int loopDepth) 
	{
															#line 307 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		keyServers = __keyServers;
															#line 4880 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(RangeResult && __keyServers,int loopDepth) 
	{
		keyServers = std::move(__keyServers);
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckCopyProgressActor*>(this)->actor_wait_state > 0) static_cast<CheckCopyProgressActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCopyProgressActor*>(this)->ActorCallback< CheckCopyProgressActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCopyProgressActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkCopyProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCopyProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCopyProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckCopyProgressActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkCopyProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCopyProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCopyProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckCopyProgressActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkCopyProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCopyProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCopyProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 341 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<CheckCopyProgressActor*>(this)->SAV<bool>::futures) { (void)(done); this->~CheckCopyProgressActorState(); static_cast<CheckCopyProgressActor*>(this)->destroy(); return 0; }
															#line 4959 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<CheckCopyProgressActor*>(this)->SAV< bool >::value()) bool(std::move(done)); // state_var_RVO
		this->~CheckCopyProgressActorState();
		static_cast<CheckCopyProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 341 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<CheckCopyProgressActor*>(this)->SAV<bool>::futures) { (void)(done); this->~CheckCopyProgressActorState(); static_cast<CheckCopyProgressActor*>(this)->destroy(); return 0; }
															#line 4971 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<CheckCopyProgressActor*>(this)->SAV< bool >::value()) bool(std::move(done)); // state_var_RVO
		this->~CheckCopyProgressActorState();
		static_cast<CheckCopyProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckCopyProgressActor*>(this)->actor_wait_state > 0) static_cast<CheckCopyProgressActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCopyProgressActor*>(this)->ActorCallback< CheckCopyProgressActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCopyProgressActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkCopyProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCopyProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCopyProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckCopyProgressActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkCopyProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCopyProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCopyProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckCopyProgressActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkCopyProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCopyProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCopyProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckCopyProgressActor*>(this)->actor_wait_state > 0) static_cast<CheckCopyProgressActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCopyProgressActor*>(this)->ActorCallback< CheckCopyProgressActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCopyProgressActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkCopyProgress", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCopyProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCopyProgress", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckCopyProgressActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkCopyProgress", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCopyProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCopyProgress", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckCopyProgressActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkCopyProgress", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCopyProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCopyProgress", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 287 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobMigrator> self;
															#line 288 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobRestoreController> controller;
															#line 289 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Transaction tr;
															#line 297 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	KeyRange currentKeys;
															#line 298 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Key begin;
															#line 299 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 300 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	std::vector<UID> src;
															#line 301 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	std::vector<UID> dest;
															#line 302 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	UID srcId;
															#line 303 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	UID destId;
															#line 305 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	int64_t incompleted;
															#line 307 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	RangeResult keyServers;
															#line 312 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	int i;
															#line 314 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	KeyValueRef it;
															#line 322 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	KeyRangeRef range;
															#line 336 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	int progress;
															#line 337 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	bool done;
															#line 5175 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via checkCopyProgress()
															#line 287 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class CheckCopyProgressActor final : public Actor<bool>, public ActorCallback< CheckCopyProgressActor, 0, RangeResult >, public ActorCallback< CheckCopyProgressActor, 1, RangeResult >, public ActorCallback< CheckCopyProgressActor, 2, Void >, public ActorCallback< CheckCopyProgressActor, 3, Void >, public FastAllocated<CheckCopyProgressActor>, public CheckCopyProgressActorState<CheckCopyProgressActor> {
															#line 5180 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<CheckCopyProgressActor>::operator new;
	using FastAllocated<CheckCopyProgressActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17327844406562723072UL, 2909421912857598976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckCopyProgressActor, 0, RangeResult >;
friend struct ActorCallback< CheckCopyProgressActor, 1, RangeResult >;
friend struct ActorCallback< CheckCopyProgressActor, 2, Void >;
friend struct ActorCallback< CheckCopyProgressActor, 3, Void >;
															#line 287 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	CheckCopyProgressActor(Reference<BlobMigrator> const& self) 
															#line 5200 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<bool>(),
		   CheckCopyProgressActorState<CheckCopyProgressActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkCopyProgress", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7423516323921237504UL, 14000893207961823232UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCopyProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkCopyProgress");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkCopyProgress", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckCopyProgressActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckCopyProgressActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckCopyProgressActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckCopyProgressActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 287 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] static Future<bool> checkCopyProgress( Reference<BlobMigrator> const& self ) {
															#line 287 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<bool>(new CheckCopyProgressActor(self));
															#line 5235 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 347 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"

	// Advance version, so that future commits will have a larger version than the restored data
																#line 5241 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
// This generated class is to be used only via advanceVersion()
															#line 349 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class AdvanceVersionActor>
															#line 349 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class AdvanceVersionActorState {
															#line 5247 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 349 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	AdvanceVersionActorState(Reference<BlobMigrator> const& self) 
															#line 349 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 349 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : self(self),
															#line 350 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   tr(self->db_)
															#line 5256 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("advanceVersion", reinterpret_cast<unsigned long>(this));

	}
	~AdvanceVersionActorState() 
	{
		fdb_probe_actor_destroy("advanceVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 351 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			;
															#line 5271 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AdvanceVersionActorState();
		static_cast<AdvanceVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 352 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 353 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 354 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 5305 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		try {
															#line 356 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getRawReadVersion();
															#line 356 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<AdvanceVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5311 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AdvanceVersionActor*>(this)->actor_wait_state = 1;
															#line 356 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionActor, 0, Version >*>(static_cast<AdvanceVersionActor*>(this)));
															#line 5316 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 369 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 369 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<AdvanceVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5340 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<AdvanceVersionActor*>(this)->actor_wait_state = 3;
															#line 369 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionActor, 2, Void >*>(static_cast<AdvanceVersionActor*>(this)));
															#line 5345 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& current,int loopDepth) 
	{
															#line 357 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Version expected = maxVersion(self);
															#line 358 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (current <= expected)
															#line 5362 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 359 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			tr.set(minRequiredCommitVersionKey, BinaryWriter::toValue(expected + 1, Unversioned()));
															#line 360 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			dprint("Advance version from {} to {}\n", current, expected);
															#line 361 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("AdvanceVersion", self->interf_.id()).detail("From", current).detail("To", expected);
															#line 362 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 362 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<AdvanceVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5374 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<AdvanceVersionActor*>(this)->actor_wait_state = 2;
															#line 362 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionActor, 1, Void >*>(static_cast<AdvanceVersionActor*>(this)));
															#line 5379 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 364 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			dprint("Skip advancing version {}. current {}\n", expected, current);
															#line 365 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("SkipAdvanceVersion", self->interf_.id()).detail("From", current).detail("To", expected);
															#line 5388 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && current,int loopDepth) 
	{
															#line 357 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Version expected = maxVersion(self);
															#line 358 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (current <= expected)
															#line 5400 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 359 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			tr.set(minRequiredCommitVersionKey, BinaryWriter::toValue(expected + 1, Unversioned()));
															#line 360 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			dprint("Advance version from {} to {}\n", current, expected);
															#line 361 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("AdvanceVersion", self->interf_.id()).detail("From", current).detail("To", expected);
															#line 362 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 362 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<AdvanceVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<AdvanceVersionActor*>(this)->actor_wait_state = 2;
															#line 362 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionActor, 1, Void >*>(static_cast<AdvanceVersionActor*>(this)));
															#line 5417 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 364 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			dprint("Skip advancing version {}. current {}\n", expected, current);
															#line 365 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("SkipAdvanceVersion", self->interf_.id()).detail("From", current).detail("To", expected);
															#line 5426 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& current,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(current, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && current,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(current), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AdvanceVersionActor*>(this)->actor_wait_state > 0) static_cast<AdvanceVersionActor*>(this)->actor_wait_state = 0;
		static_cast<AdvanceVersionActor*>(this)->ActorCallback< AdvanceVersionActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< AdvanceVersionActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AdvanceVersionActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AdvanceVersionActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 367 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<AdvanceVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AdvanceVersionActorState(); static_cast<AdvanceVersionActor*>(this)->destroy(); return 0; }
															#line 5511 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<AdvanceVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AdvanceVersionActorState();
		static_cast<AdvanceVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AdvanceVersionActor*>(this)->actor_wait_state > 0) static_cast<AdvanceVersionActor*>(this)->actor_wait_state = 0;
		static_cast<AdvanceVersionActor*>(this)->ActorCallback< AdvanceVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AdvanceVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AdvanceVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AdvanceVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AdvanceVersionActor*>(this)->actor_wait_state > 0) static_cast<AdvanceVersionActor*>(this)->actor_wait_state = 0;
		static_cast<AdvanceVersionActor*>(this)->ActorCallback< AdvanceVersionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AdvanceVersionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AdvanceVersionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AdvanceVersionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 349 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobMigrator> self;
															#line 350 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Transaction tr;
															#line 5697 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via advanceVersion()
															#line 349 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class AdvanceVersionActor final : public Actor<Void>, public ActorCallback< AdvanceVersionActor, 0, Version >, public ActorCallback< AdvanceVersionActor, 1, Void >, public ActorCallback< AdvanceVersionActor, 2, Void >, public FastAllocated<AdvanceVersionActor>, public AdvanceVersionActorState<AdvanceVersionActor> {
															#line 5702 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<AdvanceVersionActor>::operator new;
	using FastAllocated<AdvanceVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12517850284707359232UL, 4198716480119330560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AdvanceVersionActor, 0, Version >;
friend struct ActorCallback< AdvanceVersionActor, 1, Void >;
friend struct ActorCallback< AdvanceVersionActor, 2, Void >;
															#line 349 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	AdvanceVersionActor(Reference<BlobMigrator> const& self) 
															#line 5721 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<Void>(),
		   AdvanceVersionActorState<AdvanceVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4410712548360414720UL, 13930588585600599040UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("advanceVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AdvanceVersionActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AdvanceVersionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AdvanceVersionActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 349 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] static Future<Void> advanceVersion( Reference<BlobMigrator> const& self ) {
															#line 349 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<Void>(new AdvanceVersionActor(self));
															#line 5755 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 373 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"

	// Check if we need to apply mutation logs. If all granules have data up to targetVersion, we don't need to
	// apply mutation logs
	static bool needApplyLogs(Reference<BlobMigrator> self, Version targetVersion) {
		for (auto& granule : self->blobGranules_) {
			if (granule.version < targetVersion) {
				// at least one granule doesn't have data up to target version, so we'll need to apply mutation logs
				return true;
			}
		}
		return false;
	}

	// Check if we can restore based on blob granule data and mutation logs.
																#line 5773 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
// This generated class is to be used only via canRestore()
															#line 387 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class CanRestoreActor>
															#line 387 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class CanRestoreActorState {
															#line 5779 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 387 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	CanRestoreActorState(Reference<BlobMigrator> const& self) 
															#line 387 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 387 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : self(self)
															#line 5786 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("canRestore", reinterpret_cast<unsigned long>(this));

	}
	~CanRestoreActorState() 
	{
		fdb_probe_actor_destroy("canRestore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 390 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				StrictFuture<std::string> __when_expr_0 = BlobGranuleRestoreConfig().mutationLogsUrl().getD(SystemDBWriteLockedNow(self->db_.getReference()));
															#line 390 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				if (static_cast<CanRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5804 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CanRestoreActor*>(this)->actor_wait_state = 1;
															#line 390 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CanRestoreActor, 0, std::string >*>(static_cast<CanRestoreActor*>(this)));
															#line 5809 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CanRestoreActorState();
		static_cast<CanRestoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 505 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<CanRestoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CanRestoreActorState(); static_cast<CanRestoreActor*>(this)->destroy(); return 0; }
															#line 5838 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<CanRestoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CanRestoreActorState();
		static_cast<CanRestoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 499 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			err = e;
															#line 500 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			Reference<BlobRestoreController> controller = makeReference<BlobRestoreController>(self->db_, normalKeys);
															#line 501 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_5 = BlobRestoreController::setError(controller, e.what());
															#line 501 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<CanRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5857 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_5.get(), loopDepth); };
			static_cast<CanRestoreActor*>(this)->actor_wait_state = 6;
															#line 501 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CanRestoreActor, 5, Void >*>(static_cast<CanRestoreActor*>(this)));
															#line 5862 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 393 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		self->mlogsUrl_ = KeyRef(mlogsUrl);
															#line 394 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		bc = IBackupContainer::openContainer(mlogsUrl, {}, {});
															#line 395 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		beginTs = now();
															#line 396 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<BackupDescription> __when_expr_1 = bc->describeBackup(true);
															#line 396 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<CanRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5885 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CanRestoreActor*>(this)->actor_wait_state = 2;
															#line 396 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CanRestoreActor, 1, BackupDescription >*>(static_cast<CanRestoreActor*>(this)));
															#line 5890 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::string const& __mlogsUrl,int loopDepth) 
	{
															#line 390 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		mlogsUrl = __mlogsUrl;
															#line 5899 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::string && __mlogsUrl,int loopDepth) 
	{
		mlogsUrl = std::move(__mlogsUrl);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CanRestoreActor*>(this)->actor_wait_state > 0) static_cast<CanRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<CanRestoreActor*>(this)->ActorCallback< CanRestoreActor, 0, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< CanRestoreActor, 0, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CanRestoreActor, 0, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CanRestoreActor, 0, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(BackupDescription const& desc,int loopDepth) 
	{
															#line 397 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("DescribeBackupLatency", self->interf_.id()).detail("Seconds", now() - beginTs);
															#line 399 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!desc.contiguousLogEnd.present())
															#line 5980 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 400 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("InvalidMutationLogs", self->interf_.id()).log();
															#line 401 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			return a_body1Catch2(blob_restore_missing_logs(), loopDepth);
															#line 5986 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
															#line 403 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!desc.minLogBegin.present())
															#line 5990 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 404 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("InvalidMutationLogs", self->interf_.id()).log();
															#line 405 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			return a_body1Catch2(blob_restore_missing_logs(), loopDepth);
															#line 5996 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
															#line 408 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		minLogVersion = desc.minLogBegin.get();
															#line 409 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		maxLogVersion = desc.contiguousLogEnd.get() - 1;
															#line 410 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Reference<BlobRestoreController> restoreController = makeReference<BlobRestoreController>(self->db_, normalKeys);
															#line 412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Version> __when_expr_2 = BlobRestoreController::getTargetVersion(restoreController, maxLogVersion);
															#line 412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<CanRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6008 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CanRestoreActor*>(this)->actor_wait_state = 3;
															#line 412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CanRestoreActor, 2, Version >*>(static_cast<CanRestoreActor*>(this)));
															#line 6013 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(BackupDescription && desc,int loopDepth) 
	{
															#line 397 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("DescribeBackupLatency", self->interf_.id()).detail("Seconds", now() - beginTs);
															#line 399 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!desc.contiguousLogEnd.present())
															#line 6024 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 400 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("InvalidMutationLogs", self->interf_.id()).log();
															#line 401 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			return a_body1Catch2(blob_restore_missing_logs(), loopDepth);
															#line 6030 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
															#line 403 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!desc.minLogBegin.present())
															#line 6034 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 404 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("InvalidMutationLogs", self->interf_.id()).log();
															#line 405 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			return a_body1Catch2(blob_restore_missing_logs(), loopDepth);
															#line 6040 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
															#line 408 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		minLogVersion = desc.minLogBegin.get();
															#line 409 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		maxLogVersion = desc.contiguousLogEnd.get() - 1;
															#line 410 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Reference<BlobRestoreController> restoreController = makeReference<BlobRestoreController>(self->db_, normalKeys);
															#line 412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Version> __when_expr_2 = BlobRestoreController::getTargetVersion(restoreController, maxLogVersion);
															#line 412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<CanRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6052 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CanRestoreActor*>(this)->actor_wait_state = 3;
															#line 412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CanRestoreActor, 2, Version >*>(static_cast<CanRestoreActor*>(this)));
															#line 6057 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(BackupDescription const& desc,int loopDepth) 
	{
		loopDepth = a_body1cont3(desc, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(BackupDescription && desc,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(desc), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CanRestoreActor*>(this)->actor_wait_state > 0) static_cast<CanRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<CanRestoreActor*>(this)->ActorCallback< CanRestoreActor, 1, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< CanRestoreActor, 1, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CanRestoreActor, 1, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CanRestoreActor, 1, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 414 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		self->targetVersion_ = targetVersion;
															#line 415 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (targetVersion < maxLogVersion)
															#line 6143 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 416 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (!needApplyLogs(self, targetVersion))
															#line 6147 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			{
															#line 417 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				TraceEvent("SkipMutationLogs", self->interf_.id()).detail("TargetVersion", targetVersion);
															#line 418 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				dprint("Skip mutation logs as all granules are at version {}\n", targetVersion);
															#line 419 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				if (!static_cast<CanRestoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CanRestoreActorState(); static_cast<CanRestoreActor*>(this)->destroy(); return 0; }
															#line 6155 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
				new (&static_cast<CanRestoreActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CanRestoreActorState();
				static_cast<CanRestoreActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 423 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (targetVersion < minLogVersion)
															#line 6164 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 424 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("MissingMutationLogs", self->interf_.id()) .detail("MinLogVersion", minLogVersion) .detail("TargetVersion", maxLogVersion);
															#line 427 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			return a_body1Catch2(blob_restore_missing_logs(), loopDepth);
															#line 6170 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
															#line 430 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (targetVersion > maxLogVersion)
															#line 6174 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 431 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("SkipTargetVersion", self->interf_.id()) .detail("MaxLogVersion", maxLogVersion) .detail("TargetVersion", targetVersion);
															#line 6178 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
															#line 437 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		self->mlogRestoreRanges_.clear();
															#line 438 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		self->mlogRestoreBeginVersions_.clear();
															#line 439 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		for( auto& granule : self->blobGranules_ ) {
															#line 440 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (granule.version < minLogVersion)
															#line 6188 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			{
															#line 441 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				TraceEvent("MissingMutationLogs", self->interf_.id()) .detail("Granule", granule.granuleID) .detail("GranuleVersion", granule.version) .detail("MinLogVersion", minLogVersion) .detail("MaxLogVersion", maxLogVersion) .detail("TargetVersion", targetVersion);
															#line 447 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				dprint("Granule {} version {} is out of the log range {} - {}. restore target version {}\n", granule.granuleID.toString(), granule.version, minLogVersion, maxLogVersion, targetVersion);
															#line 453 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				return a_body1Catch2(blob_restore_missing_logs(), loopDepth);
															#line 6196 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			}
															#line 456 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (granule.version > maxLogVersion)
															#line 6200 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			{
															#line 457 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				TraceEvent("GranuleHasMoreData", self->interf_.id()) .detail("Granule", granule.granuleID) .detail("GranuleVersion", granule.version) .detail("MinLogVersion", minLogVersion) .detail("MaxLogVersion", maxLogVersion) .detail("TargetVersion", targetVersion);
															#line 6204 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			}
															#line 466 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (granule.version < targetVersion)
															#line 6208 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			{
															#line 467 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				self->mlogRestoreRanges_.push_back(self->mlogRestoreRanges_.arena(), granule.keyRange);
															#line 470 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				self->mlogRestoreBeginVersions_.push_back(self->mlogRestoreBeginVersions_.arena(), granule.version);
															#line 471 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				TraceEvent("ApplyMutationLogVersion", self->interf_.id()) .detail("GID", granule.granuleID) .detail("Ver", granule.version);
															#line 6216 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			}
			else
			{
															#line 475 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				TraceEvent("GranuleHasMoreData", self->interf_.id()) .detail("Granule", granule.granuleID) .detail("GranuleVersion", granule.version) .detail("TargetVersion", targetVersion);
															#line 6222 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			}
		}
															#line 483 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Version> __when_expr_3 = getManifestVersion(self->db_);
															#line 483 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<CanRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6229 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<CanRestoreActor*>(this)->actor_wait_state = 4;
															#line 483 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CanRestoreActor, 3, Version >*>(static_cast<CanRestoreActor*>(this)));
															#line 6234 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Version const& __targetVersion,int loopDepth) 
	{
															#line 412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		targetVersion = __targetVersion;
															#line 6243 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Version && __targetVersion,int loopDepth) 
	{
		targetVersion = std::move(__targetVersion);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CanRestoreActor*>(this)->actor_wait_state > 0) static_cast<CanRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<CanRestoreActor*>(this)->ActorCallback< CanRestoreActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CanRestoreActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CanRestoreActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CanRestoreActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(Version const& manifestVersion,int loopDepth) 
	{
															#line 484 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		for( auto& range : getSystemBackupRanges() ) {
															#line 485 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			self->mlogRestoreRanges_.push_back(self->mlogRestoreRanges_.arena(), range);
															#line 486 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			self->mlogRestoreBeginVersions_.push_back(self->mlogRestoreBeginVersions_.arena(), manifestVersion);
															#line 6326 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
															#line 489 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Optional<RestorableFileSet>> __when_expr_4 = bc->getRestoreSet(maxLogVersion, self->mlogRestoreRanges_, OnlyApplyMutationLogs::True, minLogVersion);
															#line 489 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<CanRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6332 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<CanRestoreActor*>(this)->actor_wait_state = 5;
															#line 489 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CanRestoreActor, 4, Optional<RestorableFileSet> >*>(static_cast<CanRestoreActor*>(this)));
															#line 6337 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Version && manifestVersion,int loopDepth) 
	{
															#line 484 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		for( auto& range : getSystemBackupRanges() ) {
															#line 485 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			self->mlogRestoreRanges_.push_back(self->mlogRestoreRanges_.arena(), range);
															#line 486 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			self->mlogRestoreBeginVersions_.push_back(self->mlogRestoreBeginVersions_.arena(), manifestVersion);
															#line 6350 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
															#line 489 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Optional<RestorableFileSet>> __when_expr_4 = bc->getRestoreSet(maxLogVersion, self->mlogRestoreRanges_, OnlyApplyMutationLogs::True, minLogVersion);
															#line 489 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<CanRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6356 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<CanRestoreActor*>(this)->actor_wait_state = 5;
															#line 489 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CanRestoreActor, 4, Optional<RestorableFileSet> >*>(static_cast<CanRestoreActor*>(this)));
															#line 6361 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Version const& manifestVersion,int loopDepth) 
	{
		loopDepth = a_body1cont7(manifestVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Version && manifestVersion,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(manifestVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CanRestoreActor*>(this)->actor_wait_state > 0) static_cast<CanRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<CanRestoreActor*>(this)->ActorCallback< CanRestoreActor, 3, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CanRestoreActor, 3, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CanRestoreActor, 3, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CanRestoreActor, 3, Version >*,Error err) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont17(Optional<RestorableFileSet> const& restoreSet,int loopDepth) 
	{
															#line 491 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!restoreSet.present())
															#line 6445 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 492 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("InvalidMutationLogs", self->interf_.id()) .detail("MinLogVersion", minLogVersion) .detail("MaxLogVersion", maxLogVersion);
															#line 495 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			return a_body1Catch2(blob_restore_corrupted_logs(), loopDepth);
															#line 6451 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
															#line 497 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("BlobMigratorCanRestore", self->interf_.id()).log();
															#line 6455 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1cont17cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont17(Optional<RestorableFileSet> && restoreSet,int loopDepth) 
	{
															#line 491 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!restoreSet.present())
															#line 6464 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 492 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("InvalidMutationLogs", self->interf_.id()) .detail("MinLogVersion", minLogVersion) .detail("MaxLogVersion", maxLogVersion);
															#line 495 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			return a_body1Catch2(blob_restore_corrupted_logs(), loopDepth);
															#line 6470 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
															#line 497 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("BlobMigratorCanRestore", self->interf_.id()).log();
															#line 6474 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1cont17cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Optional<RestorableFileSet> const& restoreSet,int loopDepth) 
	{
		loopDepth = a_body1cont17(restoreSet, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Optional<RestorableFileSet> && restoreSet,int loopDepth) 
	{
		loopDepth = a_body1cont17(std::move(restoreSet), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CanRestoreActor*>(this)->actor_wait_state > 0) static_cast<CanRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<CanRestoreActor*>(this)->ActorCallback< CanRestoreActor, 4, Optional<RestorableFileSet> >::remove();

	}
	void a_callback_fire(ActorCallback< CanRestoreActor, 4, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> const& value) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CanRestoreActor, 4, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> && value) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CanRestoreActor, 4, Optional<RestorableFileSet> >*,Error err) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont17cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
															#line 502 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("BlobMigratorCanRestoreCheckError", self->interf_.id()).error(err);
															#line 503 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 6573 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
															#line 502 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("BlobMigratorCanRestoreCheckError", self->interf_.id()).error(err);
															#line 503 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 6583 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CanRestoreActor*>(this)->actor_wait_state > 0) static_cast<CanRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<CanRestoreActor*>(this)->ActorCallback< CanRestoreActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CanRestoreActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CanRestoreActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CanRestoreActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 387 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobMigrator> self;
															#line 390 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	std::string mlogsUrl;
															#line 394 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 395 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	double beginTs;
															#line 408 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Version minLogVersion;
															#line 409 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Version maxLogVersion;
															#line 412 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Version targetVersion;
															#line 499 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Error err;
															#line 6678 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via canRestore()
															#line 387 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class CanRestoreActor final : public Actor<Void>, public ActorCallback< CanRestoreActor, 0, std::string >, public ActorCallback< CanRestoreActor, 1, BackupDescription >, public ActorCallback< CanRestoreActor, 2, Version >, public ActorCallback< CanRestoreActor, 3, Version >, public ActorCallback< CanRestoreActor, 4, Optional<RestorableFileSet> >, public ActorCallback< CanRestoreActor, 5, Void >, public FastAllocated<CanRestoreActor>, public CanRestoreActorState<CanRestoreActor> {
															#line 6683 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<CanRestoreActor>::operator new;
	using FastAllocated<CanRestoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9994374366761075712UL, 14660735213315158272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CanRestoreActor, 0, std::string >;
friend struct ActorCallback< CanRestoreActor, 1, BackupDescription >;
friend struct ActorCallback< CanRestoreActor, 2, Version >;
friend struct ActorCallback< CanRestoreActor, 3, Version >;
friend struct ActorCallback< CanRestoreActor, 4, Optional<RestorableFileSet> >;
friend struct ActorCallback< CanRestoreActor, 5, Void >;
															#line 387 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	CanRestoreActor(Reference<BlobMigrator> const& self) 
															#line 6705 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<Void>(),
		   CanRestoreActorState<CanRestoreActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("canRestore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(826836615867758592UL, 3144405301861833216UL);
		ActorExecutionContextHelper __helper(static_cast<CanRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("canRestore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("canRestore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CanRestoreActor, 0, std::string >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CanRestoreActor, 1, BackupDescription >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CanRestoreActor, 2, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CanRestoreActor, 3, Version >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CanRestoreActor, 4, Optional<RestorableFileSet> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CanRestoreActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 387 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] static Future<Void> canRestore( Reference<BlobMigrator> const& self ) {
															#line 387 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<Void>(new CanRestoreActor(self));
															#line 6742 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 507 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"

																#line 6747 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
// This generated class is to be used only via preloadApplyMutationsKeyVersionMap()
															#line 508 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class PreloadApplyMutationsKeyVersionMapActor>
															#line 508 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class PreloadApplyMutationsKeyVersionMapActorState {
															#line 6753 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 508 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	PreloadApplyMutationsKeyVersionMapActorState(Reference<BlobMigrator> const& self) 
															#line 508 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 508 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : self(self),
															#line 509 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   tr(new ReadYourWritesTransaction(self->db_)),
															#line 510 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   uid()
															#line 6764 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this));

	}
	~PreloadApplyMutationsKeyVersionMapActorState() 
	{
		fdb_probe_actor_destroy("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 512 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			;
															#line 6779 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PreloadApplyMutationsKeyVersionMapActorState();
		static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 551 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		i = int();
															#line 552 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		stepSize = SERVER_KNOBS->BLOB_RESTORE_LOAD_KEY_VERSION_MAP_STEP_SIZE;
															#line 553 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		i = 0;
															#line 6806 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 514 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 515 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 517 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<UID> __when_expr_0 = BlobGranuleRestoreConfig().uid().getD(tr);
															#line 517 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6829 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state = 1;
															#line 517 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 0, UID >*>(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)));
															#line 6834 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 546 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 546 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6871 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state = 4;
															#line 546 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 3, Void >*>(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)));
															#line 6876 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(UID const& uid_,int loopDepth) 
	{
															#line 518 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		ASSERT(uid_.isValid());
															#line 519 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		uid = uid_;
															#line 521 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Key mapStart = uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid);
															#line 522 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr->clear(KeyRangeRef(mapStart, strinc(mapStart)));
															#line 523 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		int64_t startCount = 0;
															#line 524 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr->set(uidPrefixKey(applyMutationsKeyVersionCountRange.begin, uid), StringRef((uint8_t*)&startCount, 8));
															#line 526 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr->set(mapStart, BinaryWriter::toValue<Version>(invalidVersion, Unversioned()));
															#line 528 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr->clear(uidPrefixKey(applyMutationsEndRange.begin, uid));
															#line 529 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr->clear(uidPrefixKey(applyMutationsBeginRange.begin, uid));
															#line 533 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Version beginVersion = self->targetVersion_;
															#line 534 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!self->mlogRestoreBeginVersions_.empty())
															#line 6911 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 535 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			beginVersion = *std::min_element(self->mlogRestoreBeginVersions_.begin(), self->mlogRestoreBeginVersions_.end());
															#line 6915 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
															#line 538 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		BlobGranuleRestoreConfig().beginVersion().set(tr, beginVersion);
															#line 540 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Value versionEncoded = BinaryWriter::toValue(beginVersion, Unversioned());
															#line 541 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Key prefix = uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid);
															#line 542 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_1 = krmSetRange(tr, prefix, allKeys, versionEncoded);
															#line 542 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6927 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state = 2;
															#line 542 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 1, Void >*>(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)));
															#line 6932 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(UID && uid_,int loopDepth) 
	{
															#line 518 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		ASSERT(uid_.isValid());
															#line 519 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		uid = uid_;
															#line 521 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Key mapStart = uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid);
															#line 522 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr->clear(KeyRangeRef(mapStart, strinc(mapStart)));
															#line 523 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		int64_t startCount = 0;
															#line 524 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr->set(uidPrefixKey(applyMutationsKeyVersionCountRange.begin, uid), StringRef((uint8_t*)&startCount, 8));
															#line 526 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr->set(mapStart, BinaryWriter::toValue<Version>(invalidVersion, Unversioned()));
															#line 528 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr->clear(uidPrefixKey(applyMutationsEndRange.begin, uid));
															#line 529 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		tr->clear(uidPrefixKey(applyMutationsBeginRange.begin, uid));
															#line 533 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Version beginVersion = self->targetVersion_;
															#line 534 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!self->mlogRestoreBeginVersions_.empty())
															#line 6961 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 535 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			beginVersion = *std::min_element(self->mlogRestoreBeginVersions_.begin(), self->mlogRestoreBeginVersions_.end());
															#line 6965 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
															#line 538 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		BlobGranuleRestoreConfig().beginVersion().set(tr, beginVersion);
															#line 540 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Value versionEncoded = BinaryWriter::toValue(beginVersion, Unversioned());
															#line 541 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Key prefix = uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid);
															#line 542 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_1 = krmSetRange(tr, prefix, allKeys, versionEncoded);
															#line 542 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6977 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state = 2;
															#line 542 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 1, Void >*>(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)));
															#line 6982 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(UID const& uid_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(uid_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(UID && uid_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(uid_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state > 0) static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state = 0;
		static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 0, UID >::remove();

	}
	void a_callback_fire(ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 0, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 0, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 0, UID >*,Error err) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 543 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 543 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7068 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state = 3;
															#line 543 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 2, Void >*>(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)));
															#line 7073 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 543 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 543 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7084 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state = 3;
															#line 543 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 2, Void >*>(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)));
															#line 7089 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state > 0) static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state = 0;
		static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state > 0) static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state = 0;
		static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state > 0) static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state = 0;
		static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 558 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("PreloadApplyMutationsKeyVersionMap", uid).detail("Size", self->mlogRestoreRanges_.size());
															#line 559 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PreloadApplyMutationsKeyVersionMapActorState(); static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->destroy(); return 0; }
															#line 7349 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PreloadApplyMutationsKeyVersionMapActorState();
		static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 553 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!(i < self->mlogRestoreRanges_.size()))
															#line 7368 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 554 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		int end = std::min(i + stepSize, self->mlogRestoreRanges_.size());
															#line 555 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_4 = preloadApplyMutationsKeyVersionMap( self->db_, uid, self->mlogRestoreRanges_, self->mlogRestoreBeginVersions_, i, end);
															#line 555 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7378 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state = 5;
															#line 555 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 4, Void >*>(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)));
															#line 7383 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 553 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		i += stepSize;
															#line 7405 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 553 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		i += stepSize;
															#line 7414 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state > 0) static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->actor_wait_state = 0;
		static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 508 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobMigrator> self;
															#line 509 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 510 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	UID uid;
															#line 551 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	int i;
															#line 552 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	int stepSize;
															#line 7504 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via preloadApplyMutationsKeyVersionMap()
															#line 508 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class PreloadApplyMutationsKeyVersionMapActor final : public Actor<Void>, public ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 0, UID >, public ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 1, Void >, public ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 2, Void >, public ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 3, Void >, public ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 4, Void >, public FastAllocated<PreloadApplyMutationsKeyVersionMapActor>, public PreloadApplyMutationsKeyVersionMapActorState<PreloadApplyMutationsKeyVersionMapActor> {
															#line 7509 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<PreloadApplyMutationsKeyVersionMapActor>::operator new;
	using FastAllocated<PreloadApplyMutationsKeyVersionMapActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17561372995952357632UL, 11383811238782563840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 0, UID >;
friend struct ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 1, Void >;
friend struct ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 2, Void >;
friend struct ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 3, Void >;
friend struct ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 4, Void >;
															#line 508 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	PreloadApplyMutationsKeyVersionMapActor(Reference<BlobMigrator> const& self) 
															#line 7530 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<Void>(),
		   PreloadApplyMutationsKeyVersionMapActorState<PreloadApplyMutationsKeyVersionMapActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16890640639779815936UL, 10640728128296356608UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("preloadApplyMutationsKeyVersionMap");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 0, UID >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< PreloadApplyMutationsKeyVersionMapActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 508 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] static Future<Void> preloadApplyMutationsKeyVersionMap( Reference<BlobMigrator> const& self ) {
															#line 508 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<Void>(new PreloadApplyMutationsKeyVersionMapActor(self));
															#line 7566 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 561 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"

																#line 7571 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
// This generated class is to be used only via preloadApplyMutationsKeyVersionMap()
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class PreloadApplyMutationsKeyVersionMapActor1>
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class PreloadApplyMutationsKeyVersionMapActor1State {
															#line 7577 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	PreloadApplyMutationsKeyVersionMapActor1State(Database const& cx,UID const& uid,Standalone<VectorRef<KeyRangeRef>> const& ranges,Standalone<VectorRef<Version>> const& versions,int const& start,int const& end) 
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : cx(cx),
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   uid(uid),
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   ranges(ranges),
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   versions(versions),
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   start(start),
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   end(end),
															#line 568 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   tr(new ReadYourWritesTransaction(cx))
															#line 7596 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this));

	}
	~PreloadApplyMutationsKeyVersionMapActor1State() 
	{
		fdb_probe_actor_destroy("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 569 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			;
															#line 7611 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PreloadApplyMutationsKeyVersionMapActor1State();
		static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 571 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 572 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 573 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			i = int();
															#line 574 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			i = start;
															#line 7648 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 586 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 586 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7672 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->actor_wait_state = 3;
															#line 586 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 2, Void >*>(static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)));
															#line 7677 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 583 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 583 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7694 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->actor_wait_state = 2;
															#line 583 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 1, Void >*>(static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)));
															#line 7699 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 574 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!(i < end))
															#line 7715 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 575 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Version version = versions[i];
															#line 576 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (version == invalidVersion)
															#line 7723 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		{
															#line 577 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			version = 0;
															#line 7727 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
															#line 579 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Value versionEncoded = BinaryWriter::toValue(version, Unversioned());
															#line 580 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Key prefix = uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid);
															#line 581 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		StrictFuture<Void> __when_expr_0 = krmSetRangeCoalescing(tr, prefix, ranges[i], allKeys, versionEncoded);
															#line 581 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7737 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->actor_wait_state = 1;
															#line 581 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 0, Void >*>(static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)));
															#line 7742 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 574 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		++i;
															#line 7764 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 574 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		++i;
															#line 7773 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->actor_wait_state > 0) static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->actor_wait_state = 0;
		static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 584 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PreloadApplyMutationsKeyVersionMapActor1State(); static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->destroy(); return 0; }
															#line 7857 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~PreloadApplyMutationsKeyVersionMapActor1State();
		static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 584 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PreloadApplyMutationsKeyVersionMapActor1State(); static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->destroy(); return 0; }
															#line 7869 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~PreloadApplyMutationsKeyVersionMapActor1State();
		static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->actor_wait_state > 0) static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->actor_wait_state = 0;
		static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->actor_wait_state > 0) static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->actor_wait_state = 0;
		static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Database cx;
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	UID uid;
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Standalone<VectorRef<Version>> versions;
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	int start;
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	int end;
															#line 568 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 573 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	int i;
															#line 8055 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via preloadApplyMutationsKeyVersionMap()
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class PreloadApplyMutationsKeyVersionMapActor1 final : public Actor<Void>, public ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 0, Void >, public ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 1, Void >, public ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 2, Void >, public FastAllocated<PreloadApplyMutationsKeyVersionMapActor1>, public PreloadApplyMutationsKeyVersionMapActor1State<PreloadApplyMutationsKeyVersionMapActor1> {
															#line 8060 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<PreloadApplyMutationsKeyVersionMapActor1>::operator new;
	using FastAllocated<PreloadApplyMutationsKeyVersionMapActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17561372995952357632UL, 11383811238782563840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 0, Void >;
friend struct ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 1, Void >;
friend struct ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 2, Void >;
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	PreloadApplyMutationsKeyVersionMapActor1(Database const& cx,UID const& uid,Standalone<VectorRef<KeyRangeRef>> const& ranges,Standalone<VectorRef<Version>> const& versions,int const& start,int const& end) 
															#line 8079 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<Void>(),
		   PreloadApplyMutationsKeyVersionMapActor1State<PreloadApplyMutationsKeyVersionMapActor1>(cx, uid, ranges, versions, start, end),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6833198052109477376UL, 2397269509471845888UL);
		ActorExecutionContextHelper __helper(static_cast<PreloadApplyMutationsKeyVersionMapActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("preloadApplyMutationsKeyVersionMap");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("preloadApplyMutationsKeyVersionMap", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PreloadApplyMutationsKeyVersionMapActor1, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] static Future<Void> preloadApplyMutationsKeyVersionMap( Database const& cx, UID const& uid, Standalone<VectorRef<KeyRangeRef>> const& ranges, Standalone<VectorRef<Version>> const& versions, int const& start, int const& end ) {
															#line 562 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<Void>(new PreloadApplyMutationsKeyVersionMapActor1(cx, uid, ranges, versions, start, end));
															#line 8113 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 590 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"

	// Main server loop
																#line 8119 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
// This generated class is to be used only via serverLoop()
															#line 592 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class ServerLoopActor>
															#line 592 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class ServerLoopActorState {
															#line 8125 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 592 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	ServerLoopActorState(Reference<BlobMigrator> const& self) 
															#line 592 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 592 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : self(self)
															#line 8132 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("serverLoop", reinterpret_cast<unsigned long>(this));

	}
	~ServerLoopActorState() 
	{
		fdb_probe_actor_destroy("serverLoop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 593 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			self->addActor(waitFailureServer(self->interf_.waitFailure.getFuture()));
															#line 594 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			self->addActor(handleRequest(self));
															#line 595 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			self->addActor(handleUnsupportedRequest(self));
															#line 596 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			self->addActor(serveStorageMetricsRequests(self.getPtr(), self->interf_.ssi));
															#line 597 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			;
															#line 8155 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServerLoopActorState();
		static_cast<ServerLoopActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 613 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		self->actors_.clear(true);
															#line 614 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Stopped blob migrator {}\n", self->interf_.id().toString());
															#line 615 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<ServerLoopActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerLoopActorState(); static_cast<ServerLoopActor*>(this)->destroy(); return 0; }
															#line 8182 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<ServerLoopActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServerLoopActorState();
		static_cast<ServerLoopActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 600 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			auto __when_expr_0 = self->interf_.haltBlobMigrator.getFuture();
															#line 8202 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<HaltBlobMigratorRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<HaltBlobMigratorRequest>>::value, "invalid type");
															#line 599 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<ServerLoopActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8206 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 606 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->actors_.getResult();
															#line 8210 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<ServerLoopActor*>(this)->actor_wait_state = 1;
															#line 600 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ServerLoopActor, 0, HaltBlobMigratorRequest >*>(static_cast<ServerLoopActor*>(this)));
															#line 606 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ServerLoopActor, 1, Void >*>(static_cast<ServerLoopActor*>(this)));
															#line 8217 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 609 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			dprint("Unexpected serverLoop error {}\n", e.what());
															#line 610 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 8254 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(HaltBlobMigratorRequest const& req,int loopDepth) 
	{
															#line 601 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Stopping blob migrator {}\n", self->interf_.id().toString());
															#line 602 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.send(Void());
															#line 603 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("BlobMigratorHalted", self->interf_.id()).detail("ReqID", req.requesterID);
															#line 8278 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(HaltBlobMigratorRequest && req,int loopDepth) 
	{
															#line 601 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Stopping blob migrator {}\n", self->interf_.id().toString());
															#line 602 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.send(Void());
															#line 603 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		TraceEvent("BlobMigratorHalted", self->interf_.id()).detail("ReqID", req.requesterID);
															#line 8291 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServerLoopActor*>(this)->actor_wait_state > 0) static_cast<ServerLoopActor*>(this)->actor_wait_state = 0;
		static_cast<ServerLoopActor*>(this)->ActorSingleCallback< ServerLoopActor, 0, HaltBlobMigratorRequest >::remove();
		static_cast<ServerLoopActor*>(this)->ActorCallback< ServerLoopActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ServerLoopActor, 0, HaltBlobMigratorRequest >*,HaltBlobMigratorRequest const& value) 
	{
		fdb_probe_actor_enter("serverLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ServerLoopActor, 0, HaltBlobMigratorRequest >*,HaltBlobMigratorRequest && value) 
	{
		fdb_probe_actor_enter("serverLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ServerLoopActor, 0, HaltBlobMigratorRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serverLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServerLoopActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ServerLoopActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ServerLoopActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 592 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobMigrator> self;
															#line 8444 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via serverLoop()
															#line 592 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class ServerLoopActor final : public Actor<Void>, public ActorSingleCallback< ServerLoopActor, 0, HaltBlobMigratorRequest >, public ActorCallback< ServerLoopActor, 1, Void >, public FastAllocated<ServerLoopActor>, public ServerLoopActorState<ServerLoopActor> {
															#line 8449 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<ServerLoopActor>::operator new;
	using FastAllocated<ServerLoopActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16034977883486806272UL, 14489216629591917312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ServerLoopActor, 0, HaltBlobMigratorRequest >;
friend struct ActorCallback< ServerLoopActor, 1, Void >;
															#line 592 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	ServerLoopActor(Reference<BlobMigrator> const& self) 
															#line 8467 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<Void>(),
		   ServerLoopActorState<ServerLoopActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serverLoop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13989052592706272000UL, 14261047852390210304UL);
		ActorExecutionContextHelper __helper(static_cast<ServerLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serverLoop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serverLoop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ServerLoopActor, 0, HaltBlobMigratorRequest >*)0, actor_cancelled()); break;
		}

	}
};
															#line 592 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] static Future<Void> serverLoop( Reference<BlobMigrator> const& self ) {
															#line 592 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<Void>(new ServerLoopActor(self));
															#line 8499 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 617 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"

	// Handle StorageServerInterface APIs
																#line 8505 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
// This generated class is to be used only via handleRequest()
															#line 619 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class HandleRequestActor>
															#line 619 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class HandleRequestActorState {
															#line 8511 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 619 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	HandleRequestActorState(Reference<BlobMigrator> const& self) 
															#line 619 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 619 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : self(self),
															#line 620 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   ssi(self->interf_.ssi)
															#line 8520 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("handleRequest", reinterpret_cast<unsigned long>(this));

	}
	~HandleRequestActorState() 
	{
		fdb_probe_actor_destroy("handleRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 621 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			;
															#line 8535 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleRequestActorState();
		static_cast<HandleRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 624 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			auto __when_expr_0 = ssi.getShardState.getFuture();
															#line 8566 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetShardStateRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetShardStateRequest>>::value, "invalid type");
															#line 623 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<HandleRequestActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8570 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 630 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			auto __when_expr_1 = ssi.getKeyValueStoreType.getFuture();
															#line 8574 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_1), FutureStream<ReplyPromise<KeyValueStoreType>>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<ReplyPromise<KeyValueStoreType>>>::value, "invalid type");
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
			static_cast<HandleRequestActor*>(this)->actor_wait_state = 1;
															#line 624 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< HandleRequestActor, 0, GetShardStateRequest >*>(static_cast<HandleRequestActor*>(this)));
															#line 630 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< HandleRequestActor, 1, ReplyPromise<KeyValueStoreType> >*>(static_cast<HandleRequestActor*>(this)));
															#line 8582 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 636 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			dprint("Unexpected blob migrator request error {}\n", e.what());
															#line 637 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 8606 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetShardStateRequest const& req,int loopDepth) 
	{
															#line 625 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Handle GetShardStateRequest\n");
															#line 626 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Version version = maxVersion(self);
															#line 627 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		GetShardStateReply rep(version, version);
															#line 628 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.send(rep);
															#line 8632 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetShardStateRequest && req,int loopDepth) 
	{
															#line 625 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Handle GetShardStateRequest\n");
															#line 626 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		Version version = maxVersion(self);
															#line 627 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		GetShardStateReply rep(version, version);
															#line 628 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.send(rep);
															#line 8647 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ReplyPromise<KeyValueStoreType> const& reply,int loopDepth) 
	{
															#line 631 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Handle KeyValueStoreType\n");
															#line 632 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		reply.send(KeyValueStoreType::MEMORY);
															#line 8658 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ReplyPromise<KeyValueStoreType> && reply,int loopDepth) 
	{
															#line 631 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Handle KeyValueStoreType\n");
															#line 632 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		reply.send(KeyValueStoreType::MEMORY);
															#line 8669 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleRequestActor*>(this)->ActorSingleCallback< HandleRequestActor, 0, GetShardStateRequest >::remove();
		static_cast<HandleRequestActor*>(this)->ActorSingleCallback< HandleRequestActor, 1, ReplyPromise<KeyValueStoreType> >::remove();

	}
	void a_callback_fire(ActorSingleCallback< HandleRequestActor, 0, GetShardStateRequest >*,GetShardStateRequest const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HandleRequestActor, 0, GetShardStateRequest >*,GetShardStateRequest && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< HandleRequestActor, 0, GetShardStateRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HandleRequestActor, 1, ReplyPromise<KeyValueStoreType> >*,ReplyPromise<KeyValueStoreType> const& value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< HandleRequestActor, 1, ReplyPromise<KeyValueStoreType> >*,ReplyPromise<KeyValueStoreType> && value) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< HandleRequestActor, 1, ReplyPromise<KeyValueStoreType> >*,Error err) 
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 619 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobMigrator> self;
															#line 620 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	StorageServerInterface ssi;
															#line 8812 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via handleRequest()
															#line 619 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class HandleRequestActor final : public Actor<Void>, public ActorSingleCallback< HandleRequestActor, 0, GetShardStateRequest >, public ActorSingleCallback< HandleRequestActor, 1, ReplyPromise<KeyValueStoreType> >, public FastAllocated<HandleRequestActor>, public HandleRequestActorState<HandleRequestActor> {
															#line 8817 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<HandleRequestActor>::operator new;
	using FastAllocated<HandleRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11498481834911311104UL, 13062627694469586944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< HandleRequestActor, 0, GetShardStateRequest >;
friend struct ActorSingleCallback< HandleRequestActor, 1, ReplyPromise<KeyValueStoreType> >;
															#line 619 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	HandleRequestActor(Reference<BlobMigrator> const& self) 
															#line 8835 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<Void>(),
		   HandleRequestActorState<HandleRequestActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3085149730912622080UL, 127431907239638784UL);
		ActorExecutionContextHelper __helper(static_cast<HandleRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< HandleRequestActor, 0, GetShardStateRequest >*)0, actor_cancelled()); break;
		}

	}
};
															#line 619 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] static Future<Void> handleRequest( Reference<BlobMigrator> const& self ) {
															#line 619 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<Void>(new HandleRequestActor(self));
															#line 8867 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 641 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"

	// Handle StorageServerInterface APIs that are not supported. Simply log and return error
																#line 8873 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
// This generated class is to be used only via handleUnsupportedRequest()
															#line 643 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class HandleUnsupportedRequestActor>
															#line 643 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class HandleUnsupportedRequestActorState {
															#line 8879 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 643 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	HandleUnsupportedRequestActorState(Reference<BlobMigrator> const& self) 
															#line 643 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 643 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : self(self),
															#line 644 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   ssi(self->interf_.ssi)
															#line 8888 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this));

	}
	~HandleUnsupportedRequestActorState() 
	{
		fdb_probe_actor_destroy("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 645 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			;
															#line 8903 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleUnsupportedRequestActorState();
		static_cast<HandleUnsupportedRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 648 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			auto __when_expr_0 = ssi.getQueuingMetrics.getFuture();
															#line 8934 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<StorageQueuingMetricsRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<StorageQueuingMetricsRequest>>::value, "invalid type");
															#line 647 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<HandleUnsupportedRequestActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8938 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 651 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			auto __when_expr_1 = ssi.getKeyValuesStream.getFuture();
															#line 8942 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_1), FutureStream<GetKeyValuesStreamRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<GetKeyValuesStreamRequest>>::value, "invalid type");
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 655 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			auto __when_expr_2 = ssi.getKey.getFuture();
															#line 8947 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_2), FutureStream<GetKeyRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<GetKeyRequest>>::value, "invalid type");
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 659 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			auto __when_expr_3 = ssi.getKeyValues.getFuture();
															#line 8952 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_3), FutureStream<GetKeyValuesRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<GetKeyValuesRequest>>::value, "invalid type");
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1when4(__when_expr_3.pop(), loopDepth); };
															#line 669 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			auto __when_expr_4 = ssi.getValue.getFuture();
															#line 8957 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_4), FutureStream<GetValueRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<GetValueRequest>>::value, "invalid type");
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1when5(__when_expr_4.pop(), loopDepth); };
															#line 673 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			auto __when_expr_5 = ssi.checkpoint.getFuture();
															#line 8962 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_5), FutureStream<GetCheckpointRequest>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<GetCheckpointRequest>>::value, "invalid type");
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1when6(__when_expr_5.pop(), loopDepth); };
															#line 677 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			auto __when_expr_6 = ssi.fetchCheckpoint.getFuture();
															#line 8967 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_6), FutureStream<FetchCheckpointRequest>>::value || std::is_same<decltype(__when_expr_6), ThreadFutureStream<FetchCheckpointRequest>>::value, "invalid type");
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1when7(__when_expr_6.pop(), loopDepth); };
															#line 681 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			auto __when_expr_7 = ssi.updateCommitCostRequest.getFuture();
															#line 8972 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_7), FutureStream<UpdateCommitCostRequest>>::value || std::is_same<decltype(__when_expr_7), ThreadFutureStream<UpdateCommitCostRequest>>::value, "invalid type");
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1when8(__when_expr_7.pop(), loopDepth); };
															#line 685 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			auto __when_expr_8 = ssi.fetchCheckpointKeyValues.getFuture();
															#line 8977 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_8), FutureStream<FetchCheckpointKeyValuesRequest>>::value || std::is_same<decltype(__when_expr_8), ThreadFutureStream<FetchCheckpointKeyValuesRequest>>::value, "invalid type");
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1when9(__when_expr_8.pop(), loopDepth); };
			static_cast<HandleUnsupportedRequestActor*>(this)->actor_wait_state = 1;
															#line 648 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< HandleUnsupportedRequestActor, 0, StorageQueuingMetricsRequest >*>(static_cast<HandleUnsupportedRequestActor*>(this)));
															#line 651 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< HandleUnsupportedRequestActor, 1, GetKeyValuesStreamRequest >*>(static_cast<HandleUnsupportedRequestActor*>(this)));
															#line 655 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< HandleUnsupportedRequestActor, 2, GetKeyRequest >*>(static_cast<HandleUnsupportedRequestActor*>(this)));
															#line 659 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< HandleUnsupportedRequestActor, 3, GetKeyValuesRequest >*>(static_cast<HandleUnsupportedRequestActor*>(this)));
															#line 669 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< HandleUnsupportedRequestActor, 4, GetValueRequest >*>(static_cast<HandleUnsupportedRequestActor*>(this)));
															#line 673 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< HandleUnsupportedRequestActor, 5, GetCheckpointRequest >*>(static_cast<HandleUnsupportedRequestActor*>(this)));
															#line 677 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorSingleCallback< HandleUnsupportedRequestActor, 6, FetchCheckpointRequest >*>(static_cast<HandleUnsupportedRequestActor*>(this)));
															#line 681 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorSingleCallback< HandleUnsupportedRequestActor, 7, UpdateCommitCostRequest >*>(static_cast<HandleUnsupportedRequestActor*>(this)));
															#line 685 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorSingleCallback< HandleUnsupportedRequestActor, 8, FetchCheckpointKeyValuesRequest >*>(static_cast<HandleUnsupportedRequestActor*>(this)));
															#line 8999 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 691 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			dprint("Unexpected request handling error {}\n", e.what());
															#line 692 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9023 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(StorageQueuingMetricsRequest const& req,int loopDepth) 
	{
															#line 649 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		self->addActor(processStorageQueuingMetricsRequest(req));
															#line 9043 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(StorageQueuingMetricsRequest && req,int loopDepth) 
	{
															#line 649 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		self->addActor(processStorageQueuingMetricsRequest(req));
															#line 9052 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetKeyValuesStreamRequest const& req,int loopDepth) 
	{
															#line 652 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Unsupported GetKeyValuesStreamRequest\n");
															#line 653 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(unsupported_operation());
															#line 9063 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetKeyValuesStreamRequest && req,int loopDepth) 
	{
															#line 652 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Unsupported GetKeyValuesStreamRequest\n");
															#line 653 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(unsupported_operation());
															#line 9074 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetKeyRequest const& req,int loopDepth) 
	{
															#line 656 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Unsupported GetKeyRequest\n");
															#line 657 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(unsupported_operation());
															#line 9085 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetKeyRequest && req,int loopDepth) 
	{
															#line 656 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Unsupported GetKeyRequest\n");
															#line 657 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(unsupported_operation());
															#line 9096 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(GetKeyValuesRequest const& req,int loopDepth) 
	{
															#line 660 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Unsupported GetKeyValuesRequest {} - {} @ {}\n", req.begin.getKey().printable(), req.end.getKey().printable(), req.version);
															#line 667 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(broken_promise());
															#line 9107 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(GetKeyValuesRequest && req,int loopDepth) 
	{
															#line 660 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Unsupported GetKeyValuesRequest {} - {} @ {}\n", req.begin.getKey().printable(), req.end.getKey().printable(), req.version);
															#line 667 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(broken_promise());
															#line 9118 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(GetValueRequest const& req,int loopDepth) 
	{
															#line 670 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Unsupported GetValueRequest\n");
															#line 671 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(unsupported_operation());
															#line 9129 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(GetValueRequest && req,int loopDepth) 
	{
															#line 670 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Unsupported GetValueRequest\n");
															#line 671 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(unsupported_operation());
															#line 9140 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(GetCheckpointRequest const& req,int loopDepth) 
	{
															#line 674 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Unsupported GetCheckpoint \n");
															#line 675 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(unsupported_operation());
															#line 9151 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(GetCheckpointRequest && req,int loopDepth) 
	{
															#line 674 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Unsupported GetCheckpoint \n");
															#line 675 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(unsupported_operation());
															#line 9162 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(FetchCheckpointRequest const& req,int loopDepth) 
	{
															#line 678 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Unsupported FetchCheckpointRequest\n");
															#line 679 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(unsupported_operation());
															#line 9173 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(FetchCheckpointRequest && req,int loopDepth) 
	{
															#line 678 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Unsupported FetchCheckpointRequest\n");
															#line 679 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(unsupported_operation());
															#line 9184 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when8(UpdateCommitCostRequest const& req,int loopDepth) 
	{
															#line 683 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(unsupported_operation());
															#line 9193 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when8(UpdateCommitCostRequest && req,int loopDepth) 
	{
															#line 683 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(unsupported_operation());
															#line 9202 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when9(FetchCheckpointKeyValuesRequest const& req,int loopDepth) 
	{
															#line 686 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Unsupported FetchCheckpointKeyValuesRequest\n");
															#line 687 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(unsupported_operation());
															#line 9213 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when9(FetchCheckpointKeyValuesRequest && req,int loopDepth) 
	{
															#line 686 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		dprint("Unsupported FetchCheckpointKeyValuesRequest\n");
															#line 687 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(unsupported_operation());
															#line 9224 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleUnsupportedRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleUnsupportedRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleUnsupportedRequestActor*>(this)->ActorSingleCallback< HandleUnsupportedRequestActor, 0, StorageQueuingMetricsRequest >::remove();
		static_cast<HandleUnsupportedRequestActor*>(this)->ActorSingleCallback< HandleUnsupportedRequestActor, 1, GetKeyValuesStreamRequest >::remove();
		static_cast<HandleUnsupportedRequestActor*>(this)->ActorSingleCallback< HandleUnsupportedRequestActor, 2, GetKeyRequest >::remove();
		static_cast<HandleUnsupportedRequestActor*>(this)->ActorSingleCallback< HandleUnsupportedRequestActor, 3, GetKeyValuesRequest >::remove();
		static_cast<HandleUnsupportedRequestActor*>(this)->ActorSingleCallback< HandleUnsupportedRequestActor, 4, GetValueRequest >::remove();
		static_cast<HandleUnsupportedRequestActor*>(this)->ActorSingleCallback< HandleUnsupportedRequestActor, 5, GetCheckpointRequest >::remove();
		static_cast<HandleUnsupportedRequestActor*>(this)->ActorSingleCallback< HandleUnsupportedRequestActor, 6, FetchCheckpointRequest >::remove();
		static_cast<HandleUnsupportedRequestActor*>(this)->ActorSingleCallback< HandleUnsupportedRequestActor, 7, UpdateCommitCostRequest >::remove();
		static_cast<HandleUnsupportedRequestActor*>(this)->ActorSingleCallback< HandleUnsupportedRequestActor, 8, FetchCheckpointKeyValuesRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 0, StorageQueuingMetricsRequest >*,StorageQueuingMetricsRequest const& value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 0, StorageQueuingMetricsRequest >*,StorageQueuingMetricsRequest && value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< HandleUnsupportedRequestActor, 0, StorageQueuingMetricsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 1, GetKeyValuesStreamRequest >*,GetKeyValuesStreamRequest const& value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 1, GetKeyValuesStreamRequest >*,GetKeyValuesStreamRequest && value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< HandleUnsupportedRequestActor, 1, GetKeyValuesStreamRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 2, GetKeyRequest >*,GetKeyRequest const& value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 2, GetKeyRequest >*,GetKeyRequest && value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< HandleUnsupportedRequestActor, 2, GetKeyRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 3, GetKeyValuesRequest >*,GetKeyValuesRequest const& value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 3, GetKeyValuesRequest >*,GetKeyValuesRequest && value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< HandleUnsupportedRequestActor, 3, GetKeyValuesRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 4, GetValueRequest >*,GetValueRequest const& value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 4, GetValueRequest >*,GetValueRequest && value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< HandleUnsupportedRequestActor, 4, GetValueRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 5, GetCheckpointRequest >*,GetCheckpointRequest const& value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 5, GetCheckpointRequest >*,GetCheckpointRequest && value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< HandleUnsupportedRequestActor, 5, GetCheckpointRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 6, FetchCheckpointRequest >*,FetchCheckpointRequest const& value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 6, FetchCheckpointRequest >*,FetchCheckpointRequest && value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorSingleCallback< HandleUnsupportedRequestActor, 6, FetchCheckpointRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 7, UpdateCommitCostRequest >*,UpdateCommitCostRequest const& value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 7, UpdateCommitCostRequest >*,UpdateCommitCostRequest && value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorSingleCallback< HandleUnsupportedRequestActor, 7, UpdateCommitCostRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 8, FetchCheckpointKeyValuesRequest >*,FetchCheckpointKeyValuesRequest const& value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when9(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< HandleUnsupportedRequestActor, 8, FetchCheckpointKeyValuesRequest >*,FetchCheckpointKeyValuesRequest && value) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorSingleCallback< HandleUnsupportedRequestActor, 8, FetchCheckpointKeyValuesRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 643 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobMigrator> self;
															#line 644 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	StorageServerInterface ssi;
															#line 9773 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via handleUnsupportedRequest()
															#line 643 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class HandleUnsupportedRequestActor final : public Actor<Void>, public ActorSingleCallback< HandleUnsupportedRequestActor, 0, StorageQueuingMetricsRequest >, public ActorSingleCallback< HandleUnsupportedRequestActor, 1, GetKeyValuesStreamRequest >, public ActorSingleCallback< HandleUnsupportedRequestActor, 2, GetKeyRequest >, public ActorSingleCallback< HandleUnsupportedRequestActor, 3, GetKeyValuesRequest >, public ActorSingleCallback< HandleUnsupportedRequestActor, 4, GetValueRequest >, public ActorSingleCallback< HandleUnsupportedRequestActor, 5, GetCheckpointRequest >, public ActorSingleCallback< HandleUnsupportedRequestActor, 6, FetchCheckpointRequest >, public ActorSingleCallback< HandleUnsupportedRequestActor, 7, UpdateCommitCostRequest >, public ActorSingleCallback< HandleUnsupportedRequestActor, 8, FetchCheckpointKeyValuesRequest >, public FastAllocated<HandleUnsupportedRequestActor>, public HandleUnsupportedRequestActorState<HandleUnsupportedRequestActor> {
															#line 9778 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<HandleUnsupportedRequestActor>::operator new;
	using FastAllocated<HandleUnsupportedRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15457120857001807360UL, 8882982152491862784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< HandleUnsupportedRequestActor, 0, StorageQueuingMetricsRequest >;
friend struct ActorSingleCallback< HandleUnsupportedRequestActor, 1, GetKeyValuesStreamRequest >;
friend struct ActorSingleCallback< HandleUnsupportedRequestActor, 2, GetKeyRequest >;
friend struct ActorSingleCallback< HandleUnsupportedRequestActor, 3, GetKeyValuesRequest >;
friend struct ActorSingleCallback< HandleUnsupportedRequestActor, 4, GetValueRequest >;
friend struct ActorSingleCallback< HandleUnsupportedRequestActor, 5, GetCheckpointRequest >;
friend struct ActorSingleCallback< HandleUnsupportedRequestActor, 6, FetchCheckpointRequest >;
friend struct ActorSingleCallback< HandleUnsupportedRequestActor, 7, UpdateCommitCostRequest >;
friend struct ActorSingleCallback< HandleUnsupportedRequestActor, 8, FetchCheckpointKeyValuesRequest >;
															#line 643 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	HandleUnsupportedRequestActor(Reference<BlobMigrator> const& self) 
															#line 9803 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<Void>(),
		   HandleUnsupportedRequestActorState<HandleUnsupportedRequestActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13850722321892542976UL, 4958106442063751424UL);
		ActorExecutionContextHelper __helper(static_cast<HandleUnsupportedRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleUnsupportedRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleUnsupportedRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< HandleUnsupportedRequestActor, 0, StorageQueuingMetricsRequest >*)0, actor_cancelled()); break;
		}

	}
};
															#line 643 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] static Future<Void> handleUnsupportedRequest( Reference<BlobMigrator> const& self ) {
															#line 643 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<Void>(new HandleUnsupportedRequestActor(self));
															#line 9835 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 696 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"

																#line 9840 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
// This generated class is to be used only via waitMetricsTenantAwareImpl()
															#line 697 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class WaitMetricsTenantAwareImplActor>
															#line 697 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class WaitMetricsTenantAwareImplActorState {
															#line 9846 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 697 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	WaitMetricsTenantAwareImplActorState(Reference<BlobMigrator> const& self,WaitMetricsRequest const& req) 
															#line 697 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 697 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : self(self),
															#line 697 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   req(req),
															#line 698 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   waitMetricsRequest(req),
															#line 699 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   metrics()
															#line 9859 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("waitMetricsTenantAwareImpl", reinterpret_cast<unsigned long>(this));

	}
	~WaitMetricsTenantAwareImplActorState() 
	{
		fdb_probe_actor_destroy("waitMetricsTenantAwareImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 700 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			metrics.bytes = sizeInBytes(self, waitMetricsRequest.keys);
															#line 701 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (waitMetricsRequest.min.allLessOrEqual(metrics) && metrics.allLessOrEqual(waitMetricsRequest.max))
															#line 9876 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			{
															#line 702 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->STORAGE_METRIC_TIMEOUT);
															#line 702 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				if (static_cast<WaitMetricsTenantAwareImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9882 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitMetricsTenantAwareImplActor*>(this)->actor_wait_state = 1;
															#line 702 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitMetricsTenantAwareImplActor, 0, Void >*>(static_cast<WaitMetricsTenantAwareImplActor*>(this)));
															#line 9887 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitMetricsTenantAwareImplActorState();
		static_cast<WaitMetricsTenantAwareImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 704 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		waitMetricsRequest.reply.send(metrics);
															#line 705 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<WaitMetricsTenantAwareImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitMetricsTenantAwareImplActorState(); static_cast<WaitMetricsTenantAwareImplActor*>(this)->destroy(); return 0; }
															#line 9917 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<WaitMetricsTenantAwareImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitMetricsTenantAwareImplActorState();
		static_cast<WaitMetricsTenantAwareImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitMetricsTenantAwareImplActor*>(this)->actor_wait_state > 0) static_cast<WaitMetricsTenantAwareImplActor*>(this)->actor_wait_state = 0;
		static_cast<WaitMetricsTenantAwareImplActor*>(this)->ActorCallback< WaitMetricsTenantAwareImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitMetricsTenantAwareImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitMetricsTenantAwareImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitMetricsTenantAwareImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitMetricsTenantAwareImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitMetricsTenantAwareImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitMetricsTenantAwareImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitMetricsTenantAwareImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitMetricsTenantAwareImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitMetricsTenantAwareImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitMetricsTenantAwareImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitMetricsTenantAwareImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitMetricsTenantAwareImpl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 697 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobMigrator> self;
															#line 697 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	WaitMetricsRequest req;
															#line 698 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	WaitMetricsRequest waitMetricsRequest;
															#line 699 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	StorageMetrics metrics;
															#line 10020 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via waitMetricsTenantAwareImpl()
															#line 697 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class WaitMetricsTenantAwareImplActor final : public Actor<Void>, public ActorCallback< WaitMetricsTenantAwareImplActor, 0, Void >, public FastAllocated<WaitMetricsTenantAwareImplActor>, public WaitMetricsTenantAwareImplActorState<WaitMetricsTenantAwareImplActor> {
															#line 10025 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<WaitMetricsTenantAwareImplActor>::operator new;
	using FastAllocated<WaitMetricsTenantAwareImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12614010286600081408UL, 14752351029934999808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitMetricsTenantAwareImplActor, 0, Void >;
															#line 697 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	WaitMetricsTenantAwareImplActor(Reference<BlobMigrator> const& self,WaitMetricsRequest const& req) 
															#line 10042 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<Void>(),
		   WaitMetricsTenantAwareImplActorState<WaitMetricsTenantAwareImplActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitMetricsTenantAwareImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13086230162416611840UL, 18424156858817012224UL);
		ActorExecutionContextHelper __helper(static_cast<WaitMetricsTenantAwareImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitMetricsTenantAwareImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitMetricsTenantAwareImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitMetricsTenantAwareImplActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 697 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] static Future<Void> waitMetricsTenantAwareImpl( Reference<BlobMigrator> const& self, WaitMetricsRequest const& req ) {
															#line 697 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<Void>(new WaitMetricsTenantAwareImplActor(self, req));
															#line 10074 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 707 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"

																#line 10079 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
// This generated class is to be used only via processStorageQueuingMetricsRequest()
															#line 708 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class ProcessStorageQueuingMetricsRequestActor>
															#line 708 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class ProcessStorageQueuingMetricsRequestActorState {
															#line 10085 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 708 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	ProcessStorageQueuingMetricsRequestActorState(StorageQueuingMetricsRequest const& req) 
															#line 708 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 708 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : req(req)
															#line 10092 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("processStorageQueuingMetricsRequest", reinterpret_cast<unsigned long>(this));

	}
	~ProcessStorageQueuingMetricsRequestActorState() 
	{
		fdb_probe_actor_destroy("processStorageQueuingMetricsRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 712 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(1);
															#line 712 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			if (static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10109 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->actor_wait_state = 1;
															#line 712 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProcessStorageQueuingMetricsRequestActor, 0, Void >*>(static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)));
															#line 10114 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProcessStorageQueuingMetricsRequestActorState();
		static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 713 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(unsupported_operation());
															#line 714 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessStorageQueuingMetricsRequestActorState(); static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->destroy(); return 0; }
															#line 10139 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProcessStorageQueuingMetricsRequestActorState();
		static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 713 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		req.reply.sendError(unsupported_operation());
															#line 714 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessStorageQueuingMetricsRequestActorState(); static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->destroy(); return 0; }
															#line 10153 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProcessStorageQueuingMetricsRequestActorState();
		static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->actor_wait_state > 0) static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->ActorCallback< ProcessStorageQueuingMetricsRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStorageQueuingMetricsRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStorageQueuingMetricsRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStorageQueuingMetricsRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProcessStorageQueuingMetricsRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStorageQueuingMetricsRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStorageQueuingMetricsRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProcessStorageQueuingMetricsRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStorageQueuingMetricsRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStorageQueuingMetricsRequest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 708 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	StorageQueuingMetricsRequest req;
															#line 10238 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via processStorageQueuingMetricsRequest()
															#line 708 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class ProcessStorageQueuingMetricsRequestActor final : public Actor<Void>, public ActorCallback< ProcessStorageQueuingMetricsRequestActor, 0, Void >, public FastAllocated<ProcessStorageQueuingMetricsRequestActor>, public ProcessStorageQueuingMetricsRequestActorState<ProcessStorageQueuingMetricsRequestActor> {
															#line 10243 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<ProcessStorageQueuingMetricsRequestActor>::operator new;
	using FastAllocated<ProcessStorageQueuingMetricsRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18418040303065623552UL, 12307526460698327296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProcessStorageQueuingMetricsRequestActor, 0, Void >;
															#line 708 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	ProcessStorageQueuingMetricsRequestActor(StorageQueuingMetricsRequest const& req) 
															#line 10260 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<Void>(),
		   ProcessStorageQueuingMetricsRequestActorState<ProcessStorageQueuingMetricsRequestActor>(req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("processStorageQueuingMetricsRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5287548791100792576UL, 2009602495852863744UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStorageQueuingMetricsRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("processStorageQueuingMetricsRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("processStorageQueuingMetricsRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProcessStorageQueuingMetricsRequestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 708 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] static Future<Void> processStorageQueuingMetricsRequest( StorageQueuingMetricsRequest const& req ) {
															#line 708 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<Void>(new ProcessStorageQueuingMetricsRequestActor(req));
															#line 10292 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 716 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"

	// Return total storage size in bytes for migration
	static int64_t sizeInBytes(Reference<BlobMigrator> self) { return sizeInBytes(self, normalKeys); }

	// Return storage size in bytes for given key range
	static int64_t sizeInBytes(Reference<BlobMigrator> self, KeyRangeRef range) {
		int64_t bytes = 0;
		for (auto granule : self->blobGranules_) {
			if (range.contains(granule.keyRange))
				bytes += granule.sizeInBytes;
		}
		return bytes;
	}

	// Return max version for all blob granules
	static Version maxVersion(Reference<BlobMigrator> self) {
		Version max = 0;
		for (auto granule : self->blobGranules_) {
			max = std::max(granule.version, max);
		}
		return max;
	}

public: // Methods for IStorageMetricsService
	void addActor(Future<Void> future) override { actors_.add(future); }

	void getSplitPoints(SplitRangeRequest const& req) override {
		dprint("Unsupported SplitRangeRequest\n");
		req.reply.sendError(broken_promise());
	}

	Future<Void> waitMetricsTenantAware(const WaitMetricsRequest& req) override {
		Reference<BlobMigrator> self = Reference<BlobMigrator>::addRef(this);
		return waitMetricsTenantAwareImpl(self, req);
	}

	void getStorageMetrics(const GetStorageMetricsRequest& req) override {
		StorageMetrics metrics;
		Reference<BlobMigrator> self = Reference<BlobMigrator>::addRef(this);
		metrics.bytes = sizeInBytes(self);
		GetStorageMetricsReply resp;
		resp.load = metrics;
		resp.available = StorageMetrics();
		resp.capacity = StorageMetrics();
		resp.bytesInputRate = 0;
		resp.versionLag = 0;
		resp.lastUpdate = now();
		resp.bytesDurable = 0;
		resp.bytesInput = 0;
		req.reply.send(resp);
	}

	// This API is used by DD to figure out split points for data movement.
	void getSplitMetrics(const SplitMetricsRequest& req) override {
		Reference<BlobMigrator> self = Reference<BlobMigrator>::addRef(this);
		SplitMetricsReply rep;
		int64_t bytes = 0; // number of bytes accumulated for current split
		for (auto& granule : self->blobGranules_) {
			if (!req.keys.contains(granule.keyRange)) {
				continue;
			}
			bytes += granule.sizeInBytes;
			if (bytes < req.limits.bytes) {
				continue;
			}
			// Add a split point if the key range exceeds expected minimal size in bytes
			rep.splits.push_back_deep(rep.splits.arena(), granule.keyRange.end);
			bytes = 0;
			// Limit number of splits in single response for fast RPC processing
			if (rep.splits.size() > SERVER_KNOBS->SPLIT_METRICS_MAX_ROWS) {
				CODE_PROBE(true, "Blob Migrator SplitMetrics API has more");
				TraceEvent("BlobMigratorSplitMetricsContinued", self->interf_.id())
				    .detail("Range", req.keys)
				    .detail("Splits", rep.splits.size());
				rep.more = true;
				break;
			}
		}
		req.reply.send(rep);
	}

	void getHotRangeMetrics(const ReadHotSubRangeRequest& req) override {
		ReadHotSubRangeReply emptyReply;
		req.reply.send(emptyReply);
	}

	int64_t getHotShardsMetrics(const KeyRange& range) override { return 0; }

	template <class Reply>
	void sendErrorWithPenalty(const ReplyPromise<Reply>& promise, const Error& err, double) {
		promise.sendError(err);
	}

private:
	Database db_;
	BlobGranuleRestoreVersionVector blobGranules_;
	BlobMigratorInterface interf_;
	ActorCollection actors_;
	FileBackupAgent backupAgent_;

	Key mlogsUrl_;
	Version targetVersion_;
	Standalone<VectorRef<KeyRangeRef>> mlogRestoreRanges_;
	Standalone<VectorRef<Version>> mlogRestoreBeginVersions_;
	Reference<AsyncVar<ServerDBInfo> const> dbInfo_;
};

// Main entry point
															#line 10404 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
namespace {
// This generated class is to be used only via blobMigrator()
															#line 824 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
template <class BlobMigratorActor>
															#line 824 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class BlobMigratorActorState {
															#line 10411 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
															#line 824 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	BlobMigratorActorState(BlobMigratorInterface const& interf,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 824 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
															#line 824 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		 : interf(interf),
															#line 824 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		   dbInfo(dbInfo)
															#line 10420 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
	{
		fdb_probe_actor_create("blobMigrator", reinterpret_cast<unsigned long>(this));

	}
	~BlobMigratorActorState() 
	{
		fdb_probe_actor_destroy("blobMigrator", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 825 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("StartBlobMigrator", interf.id()).detail("Interface", interf.id().toString());
															#line 826 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			dprint("Starting blob migrator {}\n", interf.id().toString());
															#line 827 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			self = makeReference<BlobMigrator>(interf, dbInfo);
															#line 10439 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			try {
															#line 829 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				StrictFuture<Void> __when_expr_0 = BlobMigrator::start(self);
															#line 829 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				if (static_cast<BlobMigratorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 10445 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BlobMigratorActor*>(this)->actor_wait_state = 1;
															#line 829 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobMigratorActor, 0, Void >*>(static_cast<BlobMigratorActor*>(this)));
															#line 10450 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobMigratorActorState();
		static_cast<BlobMigratorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 834 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
		if (!static_cast<BlobMigratorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BlobMigratorActorState(); static_cast<BlobMigratorActor*>(this)->destroy(); return 0; }
															#line 10479 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		new (&static_cast<BlobMigratorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BlobMigratorActorState();
		static_cast<BlobMigratorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 831 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			dprint("Unexpected migrator error {}\n", e.what());
															#line 832 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
			TraceEvent("BlobMigratorError", interf.id()).error(e);
															#line 10494 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobMigratorActor*>(this)->actor_wait_state > 0) static_cast<BlobMigratorActor*>(this)->actor_wait_state = 0;
		static_cast<BlobMigratorActor*>(this)->ActorCallback< BlobMigratorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobMigratorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobMigrator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobMigratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobMigrator", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobMigratorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobMigrator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobMigratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobMigrator", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobMigratorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobMigrator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobMigratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobMigrator", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 824 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	BlobMigratorInterface interf;
															#line 824 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 827 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	Reference<BlobMigrator> self;
															#line 10611 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
};
// This generated class is to be used only via blobMigrator()
															#line 824 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
class BlobMigratorActor final : public Actor<Void>, public ActorCallback< BlobMigratorActor, 0, Void >, public FastAllocated<BlobMigratorActor>, public BlobMigratorActorState<BlobMigratorActor> {
															#line 10616 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
public:
	using FastAllocated<BlobMigratorActor>::operator new;
	using FastAllocated<BlobMigratorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10669324032033068800UL, 13440135591952036096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobMigratorActor, 0, Void >;
															#line 824 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	BlobMigratorActor(BlobMigratorInterface const& interf,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 10633 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
		 : Actor<Void>(),
		   BlobMigratorActorState<BlobMigratorActor>(interf, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("blobMigrator", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8884618726444372992UL, 7260013794394945024UL);
		ActorExecutionContextHelper __helper(static_cast<BlobMigratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("blobMigrator");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("blobMigrator", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobMigratorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 824 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
[[nodiscard]] Future<Void> blobMigrator( BlobMigratorInterface const& interf, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 824 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
	return Future<Void>(new BlobMigratorActor(interf, dbInfo));
															#line 10666 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/build_output/fdbserver/BlobMigrator.actor.g.cpp"
}

#line 836 "/codebuild/output/src1965261092/src/github.com/apple/foundationdb/fdbserver/BlobMigrator.actor.cpp"
