#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
/*
 * RandomClogging.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flow/DeterministicRandom.h"
#include "fdbrpc/simulator.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct RandomCloggingWorkload : FailureInjectionWorkload {
	static constexpr auto NAME = "RandomClogging";

	bool enabled;
	double testDuration = 10.0;
	double scale = 1.0, clogginess = 1.0;
	int swizzleClog = 0;
	bool iterate = false;
	double maxRunDuration = 60.0, backoff = 1.5, suspend = 10.0;

	RandomCloggingWorkload(WorkloadContext const& wcx, NoOptions) : FailureInjectionWorkload(wcx) {}

	RandomCloggingWorkload(WorkloadContext const& wcx) : FailureInjectionWorkload(wcx) {
		enabled = !clientId; // only do this on the "first" client
		testDuration = getOption(options, "testDuration"_sr, testDuration);
		scale = getOption(options, "scale"_sr, scale);
		clogginess = getOption(options, "clogginess"_sr, clogginess);
		swizzleClog = getOption(options, "swizzle"_sr, swizzleClog);
	}

	bool shouldInject(DeterministicRandom& random,
	                  const WorkloadRequest& work,
	                  const unsigned alreadyAdded) const override {
		return work.useDatabase && 0.25 / (1 + alreadyAdded) > random.random01();
	}

	void initFailureInjectionMode(DeterministicRandom& random) override {
		enabled = this->clientId == 0;
		scale = std::max(random.random01(), 0.1);
		clogginess = std::max(random.random01(), 0.1);
		swizzleClog = random.random01() < 0.3;
		iterate = random.random01() < 0.5;
	}

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override {
		if (g_network->isSimulated() && enabled) {
			return _start(this);
		}
		return Void();
	}
	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 75 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 73 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
template <class _startActor>
															#line 73 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
class _startActorState {
															#line 81 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
public:
															#line 73 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	_startActorState(RandomCloggingWorkload* const& self) 
															#line 73 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
															#line 73 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		 : self(self),
															#line 74 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		   done(delay(self->maxRunDuration))
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 75 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			;
															#line 105 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 76 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		StrictFuture<Void> __when_expr_0 = done || timeout(reportErrors(self->swizzleClog ? self->swizzleClogClient(self) : self->clogClient(self), "RandomCloggingError"), self->testDuration, Void());
															#line 76 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 137 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 76 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 142 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 81 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		if (!done.isReady() && self->iterate)
															#line 151 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		{
															#line 82 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(self->suspend);
															#line 82 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 157 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 82 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 162 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 85 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 169 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 81 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		if (!done.isReady() && self->iterate)
															#line 182 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		{
															#line 82 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(self->suspend);
															#line 82 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 188 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 82 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 193 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 85 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 200 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		self->suspend *= self->backoff;
															#line 294 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		self->suspend *= self->backoff;
															#line 303 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 73 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	RandomCloggingWorkload* self;
															#line 74 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	Future<Void> done;
															#line 387 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 73 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 392 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14268871500906438400UL, 14295340503830004736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
															#line 73 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	_startActor(RandomCloggingWorkload* const& self) 
															#line 410 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 73 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
[[nodiscard]] static Future<Void> _start( RandomCloggingWorkload* const& self ) {
															#line 73 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	return Future<Void>(new _startActor(self));
															#line 443 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
}

#line 89 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"

																#line 448 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
// This generated class is to be used only via doClog()
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
template <class DoClogActor>
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
class DoClogActorState {
															#line 454 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
public:
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	DoClogActorState(ISimulator::ProcessInfo* const& machine,double const& t,double const& delay = 0.0) 
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		 : machine(machine),
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		   t(t),
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		   delay(delay)
															#line 465 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doClog", reinterpret_cast<unsigned long>(this));

	}
	~DoClogActorState() 
	{
		fdb_probe_actor_destroy("doClog", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 91 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			StrictFuture<Void> __when_expr_0 = ::delay(delay);
															#line 91 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 482 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
			static_cast<DoClogActor*>(this)->actor_wait_state = 1;
															#line 91 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoClogActor, 0, Void >*>(static_cast<DoClogActor*>(this)));
															#line 486 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<DoClogActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 92 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		g_simulator->clogInterface(machine->address.ip, t);
															#line 508 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 92 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		g_simulator->clogInterface(machine->address.ip, t);
															#line 517 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoClogActor*>(this)->actor_wait_state > 0) static_cast<DoClogActor*>(this)->actor_wait_state = 0;
		static_cast<DoClogActor*>(this)->ActorCallback< DoClogActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoClogActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doClog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoClogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClog", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoClogActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doClog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoClogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClog", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoClogActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doClog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoClogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClog", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		delete static_cast<DoClogActor*>(this);
															#line 601 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		return 0;

		return loopDepth;
	}
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	ISimulator::ProcessInfo* machine;
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	double t;
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	double delay;
															#line 612 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doClog()
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
class DoClogActor final : public Actor<void>, public ActorCallback< DoClogActor, 0, Void >, public FastAllocated<DoClogActor>, public DoClogActorState<DoClogActor> {
															#line 617 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoClogActor>::operator new;
	using FastAllocated<DoClogActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5970622338256426496UL, 11126890849854971904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< DoClogActor, 0, Void >;
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	DoClogActor(ISimulator::ProcessInfo* const& machine,double const& t,double const& delay = 0.0) 
															#line 634 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		 : Actor<void>(),
		   DoClogActorState<DoClogActor>(machine, t, delay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doClog", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6605650474567798528UL, 5449426814526587392UL);
		ActorExecutionContextHelper __helper(static_cast<DoClogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doClog");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doClog", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
void doClog( ISimulator::ProcessInfo* const& machine, double const& t, double const& delay = 0.0 ) {
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	new DoClogActor(machine, t, delay);
															#line 657 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
}

#line 94 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"

	void clogRandomPair(double t) {
		auto m1 = deterministicRandom()->randomChoice(g_simulator->getAllProcesses());
		auto m2 = deterministicRandom()->randomChoice(g_simulator->getAllProcesses());
		if (m1->address.ip != m2->address.ip)
			g_simulator->clogPair(m1->address.ip, m2->address.ip, t);
	}

																#line 669 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
// This generated class is to be used only via clogClient()
															#line 102 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
template <class ClogClientActor>
															#line 102 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
class ClogClientActorState {
															#line 675 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
public:
															#line 102 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	ClogClientActorState(RandomCloggingWorkload* const& self) 
															#line 102 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
															#line 102 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		 : self(self),
															#line 103 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		   lastTime(now()),
															#line 104 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		   workloadEnd(now() + self->testDuration)
															#line 686 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clogClient", reinterpret_cast<unsigned long>(this));

	}
	~ClogClientActorState() 
	{
		fdb_probe_actor_destroy("clogClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 105 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			;
															#line 701 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClogClientActorState();
		static_cast<ClogClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 106 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, self->scale / self->clogginess);
															#line 106 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		if (static_cast<ClogClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 733 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ClogClientActor*>(this)->actor_wait_state = 1;
															#line 106 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClogClientActor, 0, Void >*>(static_cast<ClogClientActor*>(this)));
															#line 738 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 107 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		auto machine = deterministicRandom()->randomChoice(g_simulator->getAllProcesses());
															#line 108 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		double t = self->scale * 10.0 * exp(-10.0 * deterministicRandom()->random01());
															#line 109 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		t = std::max(0.0, std::min(t, workloadEnd - now()));
															#line 110 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		self->doClog(machine, t);
															#line 112 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		t = self->scale * 20.0 * exp(-10.0 * deterministicRandom()->random01());
															#line 113 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		t = std::max(0.0, std::min(t, workloadEnd - now()));
															#line 114 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		self->clogRandomPair(t);
															#line 759 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 107 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		auto machine = deterministicRandom()->randomChoice(g_simulator->getAllProcesses());
															#line 108 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		double t = self->scale * 10.0 * exp(-10.0 * deterministicRandom()->random01());
															#line 109 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		t = std::max(0.0, std::min(t, workloadEnd - now()));
															#line 110 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		self->doClog(machine, t);
															#line 112 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		t = self->scale * 20.0 * exp(-10.0 * deterministicRandom()->random01());
															#line 113 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		t = std::max(0.0, std::min(t, workloadEnd - now()));
															#line 114 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		self->clogRandomPair(t);
															#line 780 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClogClientActor*>(this)->actor_wait_state > 0) static_cast<ClogClientActor*>(this)->actor_wait_state = 0;
		static_cast<ClogClientActor*>(this)->ActorCallback< ClogClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClogClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 102 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	RandomCloggingWorkload* self;
															#line 103 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	double lastTime;
															#line 104 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	double workloadEnd;
															#line 866 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clogClient()
															#line 102 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
class ClogClientActor final : public Actor<Void>, public ActorCallback< ClogClientActor, 0, Void >, public FastAllocated<ClogClientActor>, public ClogClientActorState<ClogClientActor> {
															#line 871 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClogClientActor>::operator new;
	using FastAllocated<ClogClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14376463362205097984UL, 12308465165729362688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClogClientActor, 0, Void >;
															#line 102 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	ClogClientActor(RandomCloggingWorkload* const& self) 
															#line 888 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClogClientActorState<ClogClientActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6639068557903887104UL, 1016936592221440256UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clogClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClogClientActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 102 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
[[nodiscard]] Future<Void> clogClient( RandomCloggingWorkload* const& self ) {
															#line 102 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	return Future<Void>(new ClogClientActor(self));
															#line 920 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
}

#line 117 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"

																#line 925 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
// This generated class is to be used only via swizzleClogClient()
															#line 118 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
template <class SwizzleClogClientActor>
															#line 118 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
class SwizzleClogClientActorState {
															#line 931 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
public:
															#line 118 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	SwizzleClogClientActorState(RandomCloggingWorkload* const& self) 
															#line 118 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
															#line 118 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		 : self(self),
															#line 119 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		   lastTime(now()),
															#line 120 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		   workloadEnd(now() + self->testDuration)
															#line 942 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("swizzleClogClient", reinterpret_cast<unsigned long>(this));

	}
	~SwizzleClogClientActorState() 
	{
		fdb_probe_actor_destroy("swizzleClogClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 121 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			;
															#line 957 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SwizzleClogClientActorState();
		static_cast<SwizzleClogClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 122 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, self->scale / self->clogginess);
															#line 122 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		if (static_cast<SwizzleClogClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 989 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<SwizzleClogClientActor*>(this)->actor_wait_state = 1;
															#line 122 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SwizzleClogClientActor, 0, Void >*>(static_cast<SwizzleClogClientActor*>(this)));
															#line 994 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		double t = self->scale * 10.0 * exp(-10.0 * deterministicRandom()->random01());
															#line 124 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		t = std::max(0.0, std::min(t, workloadEnd - now()));
															#line 128 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		std::vector<ISimulator::ProcessInfo*> swizzled;
															#line 129 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		std::vector<double> starts, ends;
															#line 130 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		for(int m = 0;m < g_simulator->getAllProcesses().size();m++) {
															#line 131 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			if (deterministicRandom()->random01() < 0.5)
															#line 1013 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
			{
															#line 132 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
				swizzled.push_back(g_simulator->getAllProcesses()[m]);
															#line 133 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
				starts.push_back(deterministicRandom()->random01() * t / 2);
															#line 134 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
				ends.push_back(deterministicRandom()->random01() * t / 2 + t / 2);
															#line 1021 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
			}
		}
															#line 136 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		for(int i = 0;i < 10;i++) {
															#line 137 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			self->clogRandomPair(t);
															#line 1028 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		}
															#line 139 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		for(int i = 0;i < swizzled.size();i++) {
															#line 140 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			self->doClog(swizzled[i], ends[i] - starts[i], starts[i]);
															#line 1034 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		double t = self->scale * 10.0 * exp(-10.0 * deterministicRandom()->random01());
															#line 124 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		t = std::max(0.0, std::min(t, workloadEnd - now()));
															#line 128 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		std::vector<ISimulator::ProcessInfo*> swizzled;
															#line 129 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		std::vector<double> starts, ends;
															#line 130 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		for(int m = 0;m < g_simulator->getAllProcesses().size();m++) {
															#line 131 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			if (deterministicRandom()->random01() < 0.5)
															#line 1054 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
			{
															#line 132 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
				swizzled.push_back(g_simulator->getAllProcesses()[m]);
															#line 133 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
				starts.push_back(deterministicRandom()->random01() * t / 2);
															#line 134 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
				ends.push_back(deterministicRandom()->random01() * t / 2 + t / 2);
															#line 1062 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
			}
		}
															#line 136 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		for(int i = 0;i < 10;i++) {
															#line 137 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			self->clogRandomPair(t);
															#line 1069 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		}
															#line 139 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
		for(int i = 0;i < swizzled.size();i++) {
															#line 140 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
			self->doClog(swizzled[i], ends[i] - starts[i], starts[i]);
															#line 1075 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SwizzleClogClientActor*>(this)->actor_wait_state > 0) static_cast<SwizzleClogClientActor*>(this)->actor_wait_state = 0;
		static_cast<SwizzleClogClientActor*>(this)->ActorCallback< SwizzleClogClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SwizzleClogClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("swizzleClogClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwizzleClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("swizzleClogClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SwizzleClogClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("swizzleClogClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwizzleClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("swizzleClogClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SwizzleClogClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("swizzleClogClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SwizzleClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("swizzleClogClient", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 118 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	RandomCloggingWorkload* self;
															#line 119 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	double lastTime;
															#line 120 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	double workloadEnd;
															#line 1162 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
};
// This generated class is to be used only via swizzleClogClient()
															#line 118 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
class SwizzleClogClientActor final : public Actor<Void>, public ActorCallback< SwizzleClogClientActor, 0, Void >, public FastAllocated<SwizzleClogClientActor>, public SwizzleClogClientActorState<SwizzleClogClientActor> {
															#line 1167 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
public:
	using FastAllocated<SwizzleClogClientActor>::operator new;
	using FastAllocated<SwizzleClogClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(476713187728863744UL, 14663684244559749888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SwizzleClogClientActor, 0, Void >;
															#line 118 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	SwizzleClogClientActor(RandomCloggingWorkload* const& self) 
															#line 1184 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SwizzleClogClientActorState<SwizzleClogClientActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("swizzleClogClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12601786714227153408UL, 397916958052883712UL);
		ActorExecutionContextHelper __helper(static_cast<SwizzleClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("swizzleClogClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("swizzleClogClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SwizzleClogClientActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 118 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
[[nodiscard]] Future<Void> swizzleClogClient( RandomCloggingWorkload* const& self ) {
															#line 118 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
	return Future<Void>(new SwizzleClogClientActor(self));
															#line 1216 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RandomClogging.actor.g.cpp.py_gen"
}

#line 143 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbserver/workloads/RandomClogging.actor.cpp"
};

WorkloadFactory<RandomCloggingWorkload> RandomCloggingWorkloadFactory;
FailureInjectorFactory<RandomCloggingWorkload> RandomCloggingFailureInjectionFactory;
