#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
/**
 * FlowGrpcTests.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifdef FLOW_GRPC_ENABLED
#include <cstdio>

#include "fdbrpc/FlowGrpc.h"
#include "fdbrpc/FlowGrpcTests.h"
#include "flow/UnitTest.h"

#include "flow/actorcompiler.h" // This must be the last #include.

// So that tests are not optimized out. :/
void forceLinkGrpcTests() {}

namespace fdbrpc_test {

															#line 36 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase34()
															#line 34 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
template <class FlowTestCase34Actor>
															#line 34 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
class FlowTestCase34ActorState {
															#line 42 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
public:
															#line 34 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	FlowTestCase34ActorState(UnitTestParameters const& params) 
															#line 34 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
															#line 34 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		 : params(params),
															#line 35 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		   addr(NetworkAddress::parse("127.0.0.1:50001")),
															#line 36 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		   server(addr)
															#line 53 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase34", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase34ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase34", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 37 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			server.registerService(make_shared<TestEchoServiceImpl>());
															#line 38 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			server_actor = server.run();
															#line 39 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = server.onRunning();
															#line 39 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			if (static_cast<FlowTestCase34Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 74 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase34Actor*>(this)->actor_wait_state = 1;
															#line 39 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase34Actor, 0, Void >*>(static_cast<FlowTestCase34Actor*>(this)));
															#line 79 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase34ActorState();
		static_cast<FlowTestCase34Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 41 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		EchoClient client(grpc::CreateChannel(addr.toString(), grpc::InsecureChannelCredentials()));
															#line 42 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		std::string reply = client.Echo("Ping!");
															#line 43 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		std::cout << "Echo received: " << reply << std::endl;
															#line 44 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		ASSERT_EQ(reply, "Echo: Ping!");
															#line 46 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = server.shutdown();
															#line 46 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		if (static_cast<FlowTestCase34Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 112 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase34Actor*>(this)->actor_wait_state = 2;
															#line 46 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase34Actor, 1, Void >*>(static_cast<FlowTestCase34Actor*>(this)));
															#line 117 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 41 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		EchoClient client(grpc::CreateChannel(addr.toString(), grpc::InsecureChannelCredentials()));
															#line 42 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		std::string reply = client.Echo("Ping!");
															#line 43 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		std::cout << "Echo received: " << reply << std::endl;
															#line 44 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		ASSERT_EQ(reply, "Echo: Ping!");
															#line 46 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = server.shutdown();
															#line 46 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		if (static_cast<FlowTestCase34Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 136 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase34Actor*>(this)->actor_wait_state = 2;
															#line 46 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase34Actor, 1, Void >*>(static_cast<FlowTestCase34Actor*>(this)));
															#line 141 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase34Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase34Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase34Actor*>(this)->ActorCallback< FlowTestCase34Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase34Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase34", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase34Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase34", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase34Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase34", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase34Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase34", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase34Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase34", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase34Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase34", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = server_actor;
															#line 47 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		if (static_cast<FlowTestCase34Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 227 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase34Actor*>(this)->actor_wait_state = 3;
															#line 47 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase34Actor, 2, Void >*>(static_cast<FlowTestCase34Actor*>(this)));
															#line 232 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = server_actor;
															#line 47 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		if (static_cast<FlowTestCase34Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 243 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase34Actor*>(this)->actor_wait_state = 3;
															#line 47 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase34Actor, 2, Void >*>(static_cast<FlowTestCase34Actor*>(this)));
															#line 248 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase34Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase34Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase34Actor*>(this)->ActorCallback< FlowTestCase34Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase34Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase34", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase34Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase34", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase34Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase34", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase34Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase34", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase34Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase34", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase34Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase34", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 48 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		if (!static_cast<FlowTestCase34Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase34ActorState(); static_cast<FlowTestCase34Actor*>(this)->destroy(); return 0; }
															#line 332 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase34Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase34ActorState();
		static_cast<FlowTestCase34Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 48 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		if (!static_cast<FlowTestCase34Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase34ActorState(); static_cast<FlowTestCase34Actor*>(this)->destroy(); return 0; }
															#line 344 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase34Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase34ActorState();
		static_cast<FlowTestCase34Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase34Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase34Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase34Actor*>(this)->ActorCallback< FlowTestCase34Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase34Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase34", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase34Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase34", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase34Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase34", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase34Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase34", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase34Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase34", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase34Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase34", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 34 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	UnitTestParameters params;
															#line 35 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	NetworkAddress addr;
															#line 36 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	GrpcServer server;
															#line 38 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	Future<Void> server_actor;
															#line 435 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase34()
															#line 34 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
class FlowTestCase34Actor final : public Actor<Void>, public ActorCallback< FlowTestCase34Actor, 0, Void >, public ActorCallback< FlowTestCase34Actor, 1, Void >, public ActorCallback< FlowTestCase34Actor, 2, Void >, public FastAllocated<FlowTestCase34Actor>, public FlowTestCase34ActorState<FlowTestCase34Actor> {
															#line 440 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase34Actor>::operator new;
	using FastAllocated<FlowTestCase34Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16729193127490191104UL, 15670039063877037824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase34Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase34Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase34Actor, 2, Void >;
															#line 34 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	FlowTestCase34Actor(UnitTestParameters const& params) 
															#line 459 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase34ActorState<FlowTestCase34Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase34", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8584289097639883008UL, 2069599197073620736UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase34Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase34");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase34", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase34Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase34Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase34Actor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 34 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
static Future<Void> flowTestCase34( UnitTestParameters const& params ) {
															#line 34 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	return Future<Void>(new FlowTestCase34Actor(params));
															#line 493 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase34, "/fdbrpc/grpc/basic_sync_client")

#line 50 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"

															#line 499 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase51()
															#line 51 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
template <class FlowTestCase51Actor>
															#line 51 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
class FlowTestCase51ActorState {
															#line 505 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
public:
															#line 51 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	FlowTestCase51ActorState(UnitTestParameters const& params) 
															#line 51 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
															#line 51 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		 : params(params),
															#line 52 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		   addr(NetworkAddress::parse("127.0.0.1:50003")),
															#line 53 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		   server(addr)
															#line 516 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase51", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase51ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase51", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 54 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			server.registerService(make_shared<TestEchoServiceImpl>());
															#line 55 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			_ = server.run();
															#line 56 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = server.onRunning();
															#line 56 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			if (static_cast<FlowTestCase51Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 537 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase51Actor*>(this)->actor_wait_state = 1;
															#line 56 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase51Actor, 0, Void >*>(static_cast<FlowTestCase51Actor*>(this)));
															#line 542 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase51ActorState();
		static_cast<FlowTestCase51Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 58 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		pool = make_shared<AsyncTaskExecutor>(4);
															#line 59 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		client = AsyncGrpcClient<TestEchoService>(addr.toString(), pool);
															#line 567 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		try {
															#line 62 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			request = EchoRequest();
															#line 63 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			request.set_message("Ping!");
															#line 64 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			StrictFuture<EchoResponse> __when_expr_1 = client.call(&TestEchoService::Stub::Echo, request);
															#line 64 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			if (static_cast<FlowTestCase51Actor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 577 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase51Actor*>(this)->actor_wait_state = 2;
															#line 64 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase51Actor, 1, EchoResponse >*>(static_cast<FlowTestCase51Actor*>(this)));
															#line 582 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 58 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		pool = make_shared<AsyncTaskExecutor>(4);
															#line 59 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		client = AsyncGrpcClient<TestEchoService>(addr.toString(), pool);
															#line 599 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		try {
															#line 62 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			request = EchoRequest();
															#line 63 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			request.set_message("Ping!");
															#line 64 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			StrictFuture<EchoResponse> __when_expr_1 = client.call(&TestEchoService::Stub::Echo, request);
															#line 64 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			if (static_cast<FlowTestCase51Actor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 609 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase51Actor*>(this)->actor_wait_state = 2;
															#line 64 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase51Actor, 1, EchoResponse >*>(static_cast<FlowTestCase51Actor*>(this)));
															#line 614 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase51Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase51Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase51Actor*>(this)->ActorCallback< FlowTestCase51Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase51Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase51", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase51Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase51", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase51Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase51", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase51Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase51", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase51Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase51", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase51Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase51", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 72 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		if (!static_cast<FlowTestCase51Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase51ActorState(); static_cast<FlowTestCase51Actor*>(this)->destroy(); return 0; }
															#line 704 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase51Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase51ActorState();
		static_cast<FlowTestCase51Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 68 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			ASSERT_EQ(e.code(), error_code_grpc_error);
															#line 69 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			ASSERT(false);
															#line 719 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(EchoResponse const& response,int loopDepth) 
	{
															#line 65 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		std::cout << "Echo received: " << response.message() << std::endl;
															#line 66 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		ASSERT_EQ(response.message(), "Echo: Ping!");
															#line 736 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(EchoResponse && response,int loopDepth) 
	{
															#line 65 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		std::cout << "Echo received: " << response.message() << std::endl;
															#line 66 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		ASSERT_EQ(response.message(), "Echo: Ping!");
															#line 747 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(EchoResponse const& response,int loopDepth) 
	{
		loopDepth = a_body1cont3(response, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(EchoResponse && response,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(response), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase51Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase51Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase51Actor*>(this)->ActorCallback< FlowTestCase51Actor, 1, EchoResponse >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase51Actor, 1, EchoResponse >*,EchoResponse const& value) 
	{
		fdb_probe_actor_enter("flowTestCase51", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase51Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase51", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase51Actor, 1, EchoResponse >*,EchoResponse && value) 
	{
		fdb_probe_actor_enter("flowTestCase51", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase51Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase51", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase51Actor, 1, EchoResponse >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase51", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase51Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase51", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 51 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	UnitTestParameters params;
															#line 52 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	NetworkAddress addr;
															#line 53 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	GrpcServer server;
															#line 55 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	Future<Void> _;
															#line 58 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	shared_ptr<AsyncTaskExecutor> pool;
															#line 59 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	AsyncGrpcClient<TestEchoService> client;
															#line 62 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	EchoRequest request;
															#line 854 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase51()
															#line 51 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
class FlowTestCase51Actor final : public Actor<Void>, public ActorCallback< FlowTestCase51Actor, 0, Void >, public ActorCallback< FlowTestCase51Actor, 1, EchoResponse >, public FastAllocated<FlowTestCase51Actor>, public FlowTestCase51ActorState<FlowTestCase51Actor> {
															#line 859 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase51Actor>::operator new;
	using FastAllocated<FlowTestCase51Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(216917520463820032UL, 14242990349210255360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase51Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase51Actor, 1, EchoResponse >;
															#line 51 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	FlowTestCase51Actor(UnitTestParameters const& params) 
															#line 877 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase51ActorState<FlowTestCase51Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase51", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1442113147393254656UL, 10405476957716565248UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase51Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase51");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase51", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase51Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase51Actor, 1, EchoResponse >*)0, actor_cancelled()); break;
		}

	}
};
															#line 51 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
static Future<Void> flowTestCase51( UnitTestParameters const& params ) {
															#line 51 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	return Future<Void>(new FlowTestCase51Actor(params));
															#line 910 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase51, "/fdbrpc/grpc/basic_async_client")

#line 74 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"

															#line 916 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase75()
															#line 75 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
template <class FlowTestCase75Actor>
															#line 75 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
class FlowTestCase75ActorState {
															#line 922 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
public:
															#line 75 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	FlowTestCase75ActorState(UnitTestParameters const& params) 
															#line 75 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
															#line 75 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		 : params(params),
															#line 76 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		   addr(NetworkAddress::parse("127.0.0.1:50002")),
															#line 77 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		   server(addr)
															#line 933 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase75", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase75ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase75", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 78 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			server.registerService(make_shared<TestEchoServiceImpl>());
															#line 79 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			_ = server.run();
															#line 80 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = server.onRunning();
															#line 80 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			if (static_cast<FlowTestCase75Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 954 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase75Actor*>(this)->actor_wait_state = 1;
															#line 80 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase75Actor, 0, Void >*>(static_cast<FlowTestCase75Actor*>(this)));
															#line 959 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase75ActorState();
		static_cast<FlowTestCase75Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 82 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		pool = make_shared<AsyncTaskExecutor>(4);
															#line 83 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		client = AsyncGrpcClient<TestEchoService>(addr.toString(), pool);
															#line 85 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		count = 0;
															#line 986 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		try {
															#line 87 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			EchoRequest request;
															#line 88 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			request.set_message("Ping!");
															#line 89 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			stream = client.call(&TestEchoService::Stub::EchoRecvStream10, request);
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			;
															#line 996 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 82 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		pool = make_shared<AsyncTaskExecutor>(4);
															#line 83 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		client = AsyncGrpcClient<TestEchoService>(addr.toString(), pool);
															#line 85 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		count = 0;
															#line 1015 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		try {
															#line 87 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			EchoRequest request;
															#line 88 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			request.set_message("Ping!");
															#line 89 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			stream = client.call(&TestEchoService::Stub::EchoRecvStream10, request);
															#line 90 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			;
															#line 1025 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase75Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase75Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase75Actor*>(this)->ActorCallback< FlowTestCase75Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase75Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase75", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase75Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase75", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase75Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase75", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase75Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase75", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase75Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase75", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase75Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase75", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 103 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		if (!static_cast<FlowTestCase75Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase75ActorState(); static_cast<FlowTestCase75Actor*>(this)->destroy(); return 0; }
															#line 1115 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase75Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase75ActorState();
		static_cast<FlowTestCase75Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 96 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			std::cout << "Error: " << e.name() << std::endl;
															#line 97 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 1130 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			{
															#line 98 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
				ASSERT_EQ(count, 10);
															#line 99 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
				if (!static_cast<FlowTestCase75Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase75ActorState(); static_cast<FlowTestCase75Actor*>(this)->destroy(); return 0; }
															#line 1136 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
				new (&static_cast<FlowTestCase75Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase75ActorState();
				static_cast<FlowTestCase75Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 101 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			ASSERT(false);
															#line 1144 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 91 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		auto __when_expr_1 = stream;
															#line 1166 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<EchoResponse>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<EchoResponse>>::value, "invalid type");
															#line 91 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		if (static_cast<FlowTestCase75Actor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1170 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.pop(), loopDepth); };
		static_cast<FlowTestCase75Actor*>(this)->actor_wait_state = 2;
															#line 91 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase75Actor, 1, EchoResponse >*>(static_cast<FlowTestCase75Actor*>(this)));
															#line 1175 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(EchoResponse const& response,int loopDepth) 
	{
															#line 92 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		ASSERT_EQ(response.message(), "Echo: Ping!");
															#line 93 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		count += 1;
															#line 1186 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(EchoResponse && response,int loopDepth) 
	{
															#line 92 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		ASSERT_EQ(response.message(), "Echo: Ping!");
															#line 93 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		count += 1;
															#line 1197 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(EchoResponse const& response,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(response, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(EchoResponse && response,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(response), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase75Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase75Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase75Actor*>(this)->ActorSingleCallback< FlowTestCase75Actor, 1, EchoResponse >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase75Actor, 1, EchoResponse >*,EchoResponse const& value) 
	{
		fdb_probe_actor_enter("flowTestCase75", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase75Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase75", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase75Actor, 1, EchoResponse >*,EchoResponse && value) 
	{
		fdb_probe_actor_enter("flowTestCase75", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase75Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase75", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase75Actor, 1, EchoResponse >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase75", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase75Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase75", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 75 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	UnitTestParameters params;
															#line 76 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	NetworkAddress addr;
															#line 77 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	GrpcServer server;
															#line 79 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	Future<Void> _;
															#line 82 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	shared_ptr<AsyncTaskExecutor> pool;
															#line 83 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	AsyncGrpcClient<TestEchoService> client;
															#line 85 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	int count;
															#line 89 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	ThreadFutureStream<EchoResponse> stream;
															#line 1293 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase75()
															#line 75 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
class FlowTestCase75Actor final : public Actor<Void>, public ActorCallback< FlowTestCase75Actor, 0, Void >, public ActorSingleCallback< FlowTestCase75Actor, 1, EchoResponse >, public FastAllocated<FlowTestCase75Actor>, public FlowTestCase75ActorState<FlowTestCase75Actor> {
															#line 1298 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase75Actor>::operator new;
	using FastAllocated<FlowTestCase75Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4833798395205256704UL, 11840306467345799936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase75Actor, 0, Void >;
friend struct ActorSingleCallback< FlowTestCase75Actor, 1, EchoResponse >;
															#line 75 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	FlowTestCase75Actor(UnitTestParameters const& params) 
															#line 1316 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase75ActorState<FlowTestCase75Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase75", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17948860146838809600UL, 17349461835793376768UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase75Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase75");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase75", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase75Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< FlowTestCase75Actor, 1, EchoResponse >*)0, actor_cancelled()); break;
		}

	}
};
															#line 75 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
static Future<Void> flowTestCase75( UnitTestParameters const& params ) {
															#line 75 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	return Future<Void>(new FlowTestCase75Actor(params));
															#line 1349 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase75, "/fdbrpc/grpc/actor_basic_stream_server")

#line 105 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"

															#line 1355 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase106()
															#line 106 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
template <class FlowTestCase106Actor>
															#line 106 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
class FlowTestCase106ActorState {
															#line 1361 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
public:
															#line 106 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	FlowTestCase106ActorState(UnitTestParameters const& params) 
															#line 106 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
															#line 106 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		 : params(params),
															#line 107 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		   addr(NetworkAddress::parse("127.0.0.1:50004")),
															#line 108 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		   pool(make_shared<AsyncTaskExecutor>(4)),
															#line 109 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		   client(addr.toString(), pool)
															#line 1374 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase106", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase106ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase106", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 112 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
				request = EchoRequest();
															#line 113 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
				request.set_message("Ping!");
															#line 114 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
				StrictFuture<EchoResponse> __when_expr_0 = client.call(&TestEchoService::Stub::Echo, request);
															#line 114 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
				if (static_cast<FlowTestCase106Actor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1396 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FlowTestCase106Actor*>(this)->actor_wait_state = 1;
															#line 114 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase106Actor, 0, EchoResponse >*>(static_cast<FlowTestCase106Actor*>(this)));
															#line 1401 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase106ActorState();
		static_cast<FlowTestCase106Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 120 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		if (!static_cast<FlowTestCase106Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase106ActorState(); static_cast<FlowTestCase106Actor*>(this)->destroy(); return 0; }
															#line 1430 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase106Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase106ActorState();
		static_cast<FlowTestCase106Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 117 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			ASSERT_EQ(e.code(), error_code_grpc_error);
															#line 1443 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(EchoResponse const& response,int loopDepth) 
	{
															#line 115 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		ASSERT(false);
															#line 1458 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(EchoResponse && response,int loopDepth) 
	{
															#line 115 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		ASSERT(false);
															#line 1467 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(EchoResponse const& response,int loopDepth) 
	{
		loopDepth = a_body1cont2(response, loopDepth);

		return loopDepth;
	}
	int a_body1when1(EchoResponse && response,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(response), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase106Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase106Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase106Actor*>(this)->ActorCallback< FlowTestCase106Actor, 0, EchoResponse >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase106Actor, 0, EchoResponse >*,EchoResponse const& value) 
	{
		fdb_probe_actor_enter("flowTestCase106", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase106Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase106", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase106Actor, 0, EchoResponse >*,EchoResponse && value) 
	{
		fdb_probe_actor_enter("flowTestCase106", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase106Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase106", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase106Actor, 0, EchoResponse >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase106", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase106Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase106", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 106 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	UnitTestParameters params;
															#line 107 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	NetworkAddress addr;
															#line 108 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	shared_ptr<AsyncTaskExecutor> pool;
															#line 109 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	AsyncGrpcClient<TestEchoService> client;
															#line 112 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	EchoRequest request;
															#line 1570 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase106()
															#line 106 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
class FlowTestCase106Actor final : public Actor<Void>, public ActorCallback< FlowTestCase106Actor, 0, EchoResponse >, public FastAllocated<FlowTestCase106Actor>, public FlowTestCase106ActorState<FlowTestCase106Actor> {
															#line 1575 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase106Actor>::operator new;
	using FastAllocated<FlowTestCase106Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8558540241074047488UL, 8949915852158564096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase106Actor, 0, EchoResponse >;
															#line 106 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	FlowTestCase106Actor(UnitTestParameters const& params) 
															#line 1592 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase106ActorState<FlowTestCase106Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase106", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4801247695124261120UL, 12919444651343347200UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase106Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase106");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase106", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase106Actor, 0, EchoResponse >*)0, actor_cancelled()); break;
		}

	}
};
															#line 106 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
static Future<Void> flowTestCase106( UnitTestParameters const& params ) {
															#line 106 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	return Future<Void>(new FlowTestCase106Actor(params));
															#line 1624 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase106, "/fdbrpc/grpc/no_server_running")

#line 122 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"

															#line 1630 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
// This generated class is to be used only via flowTestCase123()
															#line 123 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
template <class FlowTestCase123Actor>
															#line 123 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
class FlowTestCase123ActorState {
															#line 1636 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
public:
															#line 123 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	FlowTestCase123ActorState(UnitTestParameters const& params) 
															#line 123 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
															#line 123 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		 : params(params),
															#line 124 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		   addr(NetworkAddress::parse("127.0.0.1:50005")),
															#line 125 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		   server(addr)
															#line 1647 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("flowTestCase123", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase123ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase123", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 126 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			server.registerService(make_shared<TestEchoServiceImpl>());
															#line 127 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			_ = server.run();
															#line 128 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = server.onRunning();
															#line 128 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			if (static_cast<FlowTestCase123Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1668 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase123Actor*>(this)->actor_wait_state = 1;
															#line 128 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase123Actor, 0, Void >*>(static_cast<FlowTestCase123Actor*>(this)));
															#line 1673 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase123ActorState();
		static_cast<FlowTestCase123Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		if (!static_cast<FlowTestCase123Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase123ActorState(); static_cast<FlowTestCase123Actor*>(this)->destroy(); return 0; }
															#line 1696 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase123Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase123ActorState();
		static_cast<FlowTestCase123Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
		if (!static_cast<FlowTestCase123Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase123ActorState(); static_cast<FlowTestCase123Actor*>(this)->destroy(); return 0; }
															#line 1708 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		new (&static_cast<FlowTestCase123Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase123ActorState();
		static_cast<FlowTestCase123Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase123Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase123Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase123Actor*>(this)->ActorCallback< FlowTestCase123Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase123Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase123", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase123Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase123", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase123Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase123", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase123Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase123", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase123Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase123", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase123Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase123", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 123 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	UnitTestParameters params;
															#line 124 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	NetworkAddress addr;
															#line 125 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	GrpcServer server;
															#line 127 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	Future<Void> _;
															#line 1799 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
};
// This generated class is to be used only via flowTestCase123()
															#line 123 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
class FlowTestCase123Actor final : public Actor<Void>, public ActorCallback< FlowTestCase123Actor, 0, Void >, public FastAllocated<FlowTestCase123Actor>, public FlowTestCase123ActorState<FlowTestCase123Actor> {
															#line 1804 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
public:
	using FastAllocated<FlowTestCase123Actor>::operator new;
	using FastAllocated<FlowTestCase123Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(161969298655717888UL, 9542099835596081408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase123Actor, 0, Void >;
															#line 123 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	FlowTestCase123Actor(UnitTestParameters const& params) 
															#line 1821 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FlowTestCase123ActorState<FlowTestCase123Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase123", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1348267762950107392UL, 9207433820124294656UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase123Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase123");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase123", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase123Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 123 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
static Future<Void> flowTestCase123( UnitTestParameters const& params ) {
															#line 123 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"
	return Future<Void>(new FlowTestCase123Actor(params));
															#line 1853 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowGrpcTests.actor.g.cpp.py_gen"
}
ACTOR_TEST_CASE(flowTestCase123, "/fdbrpc/grpc/destroy_server_without_shutdown")

#line 131 "/codebuild/output/src873953251/src/github.com/apple/foundationdb/fdbrpc/FlowGrpcTests.actor.cpp"

} // namespace fdbrpc_test

#endif
