#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
/*
 * MetaclusterRestoreWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstdint>
#include <limits>
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/MultiVersionTransaction.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/RunTransaction.actor.h"
#include "fdbclient/ThreadSafeTransaction.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/Knobs.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/flow.h"

#include "metacluster/Metacluster.h"
#include "metacluster/MetaclusterConsistency.actor.h"
#include "metacluster/MetaclusterData.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

struct MetaclusterRestoreWorkload : TestWorkload {
	static constexpr auto NAME = "MetaclusterRestore";

	struct DataClusterData {
		Database db;
		std::set<int64_t> tenants;
		std::set<TenantGroupName> tenantGroups;
		bool restored = false;
		bool restoreHasMessages = false;

		DataClusterData() {}
		DataClusterData(Database db) : db(db) {}
	};

	struct RestoreTenantData {
		enum class AccessTime { NONE, BEFORE_BACKUP, DURING_BACKUP, AFTER_BACKUP };

		TenantName name;
		ClusterName cluster;
		Optional<TenantGroupName> tenantGroup;
		AccessTime createTime = AccessTime::BEFORE_BACKUP;
		AccessTime renameTime = AccessTime::NONE;
		AccessTime configureTime = AccessTime::NONE;

		RestoreTenantData() {}
		RestoreTenantData(TenantName name,
		                  ClusterName cluster,
		                  Optional<TenantGroupName> tenantGroup,
		                  AccessTime createTime)
		  : name(name), cluster(cluster), tenantGroup(tenantGroup), createTime(createTime) {}
	};

	struct TenantGroupData {
		ClusterName cluster;
		std::set<int64_t> tenants;
	};

	Reference<IDatabase> managementDb;
	std::map<ClusterName, DataClusterData> dataDbs;
	std::vector<ClusterName> dataDbIndex;

	std::map<int64_t, RestoreTenantData> createdTenants;
	std::map<TenantName, int64_t> tenantNameIndex;
	std::map<TenantGroupName, TenantGroupData> tenantGroups;

	std::set<int64_t> deletedTenants;
	std::vector<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> managementTenantsBeforeRestore;

	int initialTenants;
	int maxTenants;
	int maxTenantGroups;
	int tenantGroupCapacity;

	bool recoverManagementCluster;
	bool recoverDataClusters;

	int initialTenantIdPrefix;
	bool backupComplete = false;
	double postBackupDuration;
	double endTime = std::numeric_limits<double>::max();

	MetaclusterRestoreWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		maxTenants = std::min<int>(1e8 - 1, getOption(options, "maxTenants"_sr, 1000));
		initialTenants = std::min<int>(maxTenants, getOption(options, "initialTenants"_sr, 40));
		maxTenantGroups = std::min<int>(2 * maxTenants, getOption(options, "maxTenantGroups"_sr, 20));
		postBackupDuration = getOption(options, "postBackupDuration"_sr, 30);

		tenantGroupCapacity = (initialTenants / 2 + maxTenantGroups - 1) / g_simulator->extraDatabases.size();
		int mode = deterministicRandom()->randomInt(0, 3);
		recoverManagementCluster = (mode != 2);
		recoverDataClusters = (mode != 1);

		initialTenantIdPrefix = deterministicRandom()->randomInt(TenantAPI::TENANT_ID_PREFIX_MIN_VALUE,
		                                                         TenantAPI::TENANT_ID_PREFIX_MAX_VALUE + 1);
	}

	ClusterName chooseClusterName() { return dataDbIndex[deterministicRandom()->randomInt(0, dataDbIndex.size())]; }

	TenantName chooseTenantName() {
		TenantName tenant(format("tenant%08d", deterministicRandom()->randomInt(0, maxTenants)));
		return tenant;
	}

	Optional<TenantGroupName> chooseTenantGroup(Optional<ClusterName> cluster = Optional<ClusterName>()) {
		Optional<TenantGroupName> tenantGroup;
		if (deterministicRandom()->coinflip()) {
			if (!cluster.present()) {
				tenantGroup =
				    TenantGroupNameRef(format("tenantgroup%08d", deterministicRandom()->randomInt(0, maxTenantGroups)));
			} else {
				auto const& existingGroups = dataDbs[cluster.get()].tenantGroups;
				if (deterministicRandom()->coinflip() && !existingGroups.empty()) {
					tenantGroup = deterministicRandom()->randomChoice(
					    std::vector<TenantGroupName>(existingGroups.begin(), existingGroups.end()));
				} else if (tenantGroups.size() < maxTenantGroups) {
					do {
						tenantGroup = TenantGroupNameRef(
						    format("tenantgroup%08d", deterministicRandom()->randomInt(0, maxTenantGroups)));
					} while (tenantGroups.contains(tenantGroup.get()));
				}
			}
		}

		return tenantGroup;
	}

	// Used to gradually increase capacity so that the tenants are somewhat evenly distributed across the clusters
																#line 153 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via increaseMetaclusterCapacity()
															#line 151 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class IncreaseMetaclusterCapacityActor>
															#line 151 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class IncreaseMetaclusterCapacityActorState {
															#line 159 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 151 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	IncreaseMetaclusterCapacityActorState(MetaclusterRestoreWorkload* const& self) 
															#line 151 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 151 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : self(self)
															#line 166 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this));

	}
	~IncreaseMetaclusterCapacityActorState() 
	{
		fdb_probe_actor_destroy("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 152 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			self->tenantGroupCapacity = ceil(self->tenantGroupCapacity * 1.2);
															#line 153 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tr = self->managementDb->createTransaction();
															#line 154 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			;
															#line 185 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncreaseMetaclusterCapacityActorState();
		static_cast<IncreaseMetaclusterCapacityActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 173 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<IncreaseMetaclusterCapacityActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncreaseMetaclusterCapacityActorState(); static_cast<IncreaseMetaclusterCapacityActor*>(this)->destroy(); return 0; }
															#line 208 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<IncreaseMetaclusterCapacityActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncreaseMetaclusterCapacityActorState();
		static_cast<IncreaseMetaclusterCapacityActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 156 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 157 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			dbIndex = int();
															#line 158 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			dbIndex = 0;
															#line 232 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 169 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 169 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<IncreaseMetaclusterCapacityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 269 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<IncreaseMetaclusterCapacityActor*>(this)->actor_wait_state = 3;
															#line 169 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< IncreaseMetaclusterCapacityActor, 2, Void >*>(static_cast<IncreaseMetaclusterCapacityActor*>(this)));
															#line 274 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 166 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 166 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<IncreaseMetaclusterCapacityActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 291 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<IncreaseMetaclusterCapacityActor*>(this)->actor_wait_state = 2;
															#line 166 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncreaseMetaclusterCapacityActor, 1, Void >*>(static_cast<IncreaseMetaclusterCapacityActor*>(this)));
															#line 296 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 158 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!(dbIndex < self->dataDbIndex.size()))
															#line 312 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 159 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<metacluster::DataClusterMetadata> __when_expr_0 = metacluster::getClusterTransaction(tr, self->dataDbIndex[dbIndex]);
															#line 159 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<IncreaseMetaclusterCapacityActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 320 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<IncreaseMetaclusterCapacityActor*>(this)->actor_wait_state = 1;
															#line 159 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncreaseMetaclusterCapacityActor, 0, metacluster::DataClusterMetadata >*>(static_cast<IncreaseMetaclusterCapacityActor*>(this)));
															#line 325 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(metacluster::DataClusterMetadata const& clusterMetadata,int loopDepth) 
	{
															#line 161 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		metacluster::DataClusterEntry updatedEntry = clusterMetadata.entry;
															#line 162 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		updatedEntry.capacity.numTenantGroups = self->tenantGroupCapacity;
															#line 163 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		metacluster::updateClusterMetadata( tr, self->dataDbIndex[dbIndex], clusterMetadata, {}, updatedEntry);
															#line 158 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		++dbIndex;
															#line 353 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(metacluster::DataClusterMetadata && clusterMetadata,int loopDepth) 
	{
															#line 161 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		metacluster::DataClusterEntry updatedEntry = clusterMetadata.entry;
															#line 162 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		updatedEntry.capacity.numTenantGroups = self->tenantGroupCapacity;
															#line 163 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		metacluster::updateClusterMetadata( tr, self->dataDbIndex[dbIndex], clusterMetadata, {}, updatedEntry);
															#line 158 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		++dbIndex;
															#line 368 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(metacluster::DataClusterMetadata const& clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(clusterMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(metacluster::DataClusterMetadata && clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(clusterMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncreaseMetaclusterCapacityActor*>(this)->actor_wait_state > 0) static_cast<IncreaseMetaclusterCapacityActor*>(this)->actor_wait_state = 0;
		static_cast<IncreaseMetaclusterCapacityActor*>(this)->ActorCallback< IncreaseMetaclusterCapacityActor, 0, metacluster::DataClusterMetadata >::remove();

	}
	void a_callback_fire(ActorCallback< IncreaseMetaclusterCapacityActor, 0, metacluster::DataClusterMetadata >*,metacluster::DataClusterMetadata const& value) 
	{
		fdb_probe_actor_enter("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncreaseMetaclusterCapacityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncreaseMetaclusterCapacityActor, 0, metacluster::DataClusterMetadata >*,metacluster::DataClusterMetadata && value) 
	{
		fdb_probe_actor_enter("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncreaseMetaclusterCapacityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncreaseMetaclusterCapacityActor, 0, metacluster::DataClusterMetadata >*,Error err) 
	{
		fdb_probe_actor_enter("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncreaseMetaclusterCapacityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IncreaseMetaclusterCapacityActor*>(this)->actor_wait_state > 0) static_cast<IncreaseMetaclusterCapacityActor*>(this)->actor_wait_state = 0;
		static_cast<IncreaseMetaclusterCapacityActor*>(this)->ActorCallback< IncreaseMetaclusterCapacityActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncreaseMetaclusterCapacityActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncreaseMetaclusterCapacityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IncreaseMetaclusterCapacityActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncreaseMetaclusterCapacityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IncreaseMetaclusterCapacityActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncreaseMetaclusterCapacityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<IncreaseMetaclusterCapacityActor*>(this)->actor_wait_state > 0) static_cast<IncreaseMetaclusterCapacityActor*>(this)->actor_wait_state = 0;
		static_cast<IncreaseMetaclusterCapacityActor*>(this)->ActorCallback< IncreaseMetaclusterCapacityActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncreaseMetaclusterCapacityActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncreaseMetaclusterCapacityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< IncreaseMetaclusterCapacityActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncreaseMetaclusterCapacityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< IncreaseMetaclusterCapacityActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncreaseMetaclusterCapacityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 151 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 153 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Reference<ITransaction> tr;
															#line 157 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	int dbIndex;
															#line 628 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via increaseMetaclusterCapacity()
															#line 151 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class IncreaseMetaclusterCapacityActor final : public Actor<Void>, public ActorCallback< IncreaseMetaclusterCapacityActor, 0, metacluster::DataClusterMetadata >, public ActorCallback< IncreaseMetaclusterCapacityActor, 1, Void >, public ActorCallback< IncreaseMetaclusterCapacityActor, 2, Void >, public FastAllocated<IncreaseMetaclusterCapacityActor>, public IncreaseMetaclusterCapacityActorState<IncreaseMetaclusterCapacityActor> {
															#line 633 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<IncreaseMetaclusterCapacityActor>::operator new;
	using FastAllocated<IncreaseMetaclusterCapacityActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(111379040423008768UL, 1507663689849231360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IncreaseMetaclusterCapacityActor, 0, metacluster::DataClusterMetadata >;
friend struct ActorCallback< IncreaseMetaclusterCapacityActor, 1, Void >;
friend struct ActorCallback< IncreaseMetaclusterCapacityActor, 2, Void >;
															#line 151 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	IncreaseMetaclusterCapacityActor(MetaclusterRestoreWorkload* const& self) 
															#line 652 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   IncreaseMetaclusterCapacityActorState<IncreaseMetaclusterCapacityActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3118645400528211712UL, 8518560321299493632UL);
		ActorExecutionContextHelper __helper(static_cast<IncreaseMetaclusterCapacityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("increaseMetaclusterCapacity");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("increaseMetaclusterCapacity", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncreaseMetaclusterCapacityActor, 0, metacluster::DataClusterMetadata >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IncreaseMetaclusterCapacityActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< IncreaseMetaclusterCapacityActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 151 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> increaseMetaclusterCapacity( MetaclusterRestoreWorkload* const& self ) {
															#line 151 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<Void>(new IncreaseMetaclusterCapacityActor(self));
															#line 686 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 175 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

	Future<Void> setup(Database const& cx) override {
		if (clientId == 0) {
			metacluster::metadata::RestoreId::simAllowUidRestoreId = false;
			return _setup(cx, this);
		} else {
			return Void();
		}
	}
																#line 699 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 184 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class _setupActor>
															#line 184 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class _setupActorState {
															#line 705 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 184 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	_setupActorState(Database const& cx,MetaclusterRestoreWorkload* const& self) 
															#line 184 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 184 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : cx(cx),
															#line 184 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   self(self)
															#line 714 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 185 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			metacluster::DataClusterEntry clusterEntry;
															#line 186 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			clusterEntry.capacity.numTenantGroups = self->tenantGroupCapacity;
															#line 188 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<metacluster::util::SimulatedMetacluster> __when_expr_0 = metacluster::util::createSimulatedMetacluster(cx, self->initialTenantIdPrefix, clusterEntry);
															#line 188 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 735 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 188 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >*>(static_cast<_setupActor*>(this)));
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(metacluster::util::SimulatedMetacluster const& simMetacluster,int loopDepth) 
	{
															#line 191 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->managementDb = simMetacluster.managementDb;
															#line 192 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT(!simMetacluster.dataDbs.empty());
															#line 193 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& [name, db] : simMetacluster.dataDbs ) {
															#line 194 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			self->dataDbs[name] = DataClusterData(db);
															#line 195 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			self->dataDbIndex.push_back(name);
															#line 771 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 198 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterRestoreWorkloadCreateTenants").detail("NumTenants", self->initialTenants);
															#line 200 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		;
															#line 777 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(metacluster::util::SimulatedMetacluster && simMetacluster,int loopDepth) 
	{
															#line 191 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->managementDb = simMetacluster.managementDb;
															#line 192 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT(!simMetacluster.dataDbs.empty());
															#line 193 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& [name, db] : simMetacluster.dataDbs ) {
															#line 194 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			self->dataDbs[name] = DataClusterData(db);
															#line 195 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			self->dataDbIndex.push_back(name);
															#line 794 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 198 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterRestoreWorkloadCreateTenants").detail("NumTenants", self->initialTenants);
															#line 200 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		;
															#line 800 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(metacluster::util::SimulatedMetacluster const& simMetacluster,int loopDepth) 
	{
		loopDepth = a_body1cont1(simMetacluster, loopDepth);

		return loopDepth;
	}
	int a_body1when1(metacluster::util::SimulatedMetacluster && simMetacluster,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(simMetacluster), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >*,metacluster::util::SimulatedMetacluster const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >*,metacluster::util::SimulatedMetacluster && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 204 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterRestoreWorkloadCreateTenantsComplete");
															#line 206 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 886 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 200 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!(self->createdTenants.size() < self->initialTenants))
															#line 905 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 201 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = createTenant(self, RestoreTenantData::AccessTime::BEFORE_BACKUP);
															#line 201 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 913 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 201 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 918 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 184 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Database cx;
															#line 184 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 1027 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 184 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >, public ActorCallback< _setupActor, 1, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 1032 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13543714965320948480UL, 1545554900078101504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >;
friend struct ActorCallback< _setupActor, 1, Void >;
															#line 184 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	_setupActor(Database const& cx,MetaclusterRestoreWorkload* const& self) 
															#line 1050 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 184 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _setup( Database const& cx, MetaclusterRestoreWorkload* const& self ) {
															#line 184 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 1083 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 208 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

																#line 1088 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via backupCluster()
															#line 209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class BackupClusterActor>
															#line 209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class BackupClusterActorState {
															#line 1094 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	BackupClusterActorState(ClusterName const& clusterName,Database const& dataDb,MetaclusterRestoreWorkload* const& self) 
															#line 209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : clusterName(clusterName),
															#line 209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   dataDb(dataDb),
															#line 209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   self(self),
															#line 212 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   backupAgent(),
															#line 213 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   backupContainer("file://simfdb/backups/"_sr.withSuffix(clusterName)),
															#line 214 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   backupRanges()
															#line 1111 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("backupCluster", reinterpret_cast<unsigned long>(this));

	}
	~BackupClusterActorState() 
	{
		fdb_probe_actor_destroy("backupCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 216 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			addDefaultBackupRanges(backupRanges);
															#line 218 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			TraceEvent("MetaclusterRestoreWorkloadSubmitBackup").detail("ClusterName", clusterName);
															#line 1128 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			try {
															#line 220 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_0 = backupAgent.submitBackup( dataDb, backupContainer, {}, 0, 0, clusterName.toString(), backupRanges, StopWhenDone::True);
															#line 220 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (static_cast<BackupClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1134 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BackupClusterActor*>(this)->actor_wait_state = 1;
															#line 220 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BackupClusterActor, 0, Void >*>(static_cast<BackupClusterActor*>(this)));
															#line 1139 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BackupClusterActorState();
		static_cast<BackupClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 227 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadWaitBackup").detail("ClusterName", clusterName);
															#line 228 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		container = Reference<IBackupContainer>();
															#line 229 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(backupAgent.waitBackup(dataDb, clusterName.toString(), StopWhenDone::True, &container));
															#line 229 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<BackupClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1174 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<BackupClusterActor*>(this)->actor_wait_state = 2;
															#line 229 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BackupClusterActor, 1, Void >*>(static_cast<BackupClusterActor*>(this)));
															#line 1179 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 223 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 1189 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 224 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1193 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BackupClusterActor*>(this)->actor_wait_state > 0) static_cast<BackupClusterActor*>(this)->actor_wait_state = 0;
		static_cast<BackupClusterActor*>(this)->ActorCallback< BackupClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BackupClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backupCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BackupClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backupCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BackupClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backupCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackupClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadBackupComplete").detail("ClusterName", clusterName);
															#line 231 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<BackupClusterActor*>(this)->SAV<std::string>::futures) { (void)(container->getURL()); this->~BackupClusterActorState(); static_cast<BackupClusterActor*>(this)->destroy(); return 0; }
															#line 1311 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<BackupClusterActor*>(this)->SAV< std::string >::value()) std::string(container->getURL());
		this->~BackupClusterActorState();
		static_cast<BackupClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadBackupComplete").detail("ClusterName", clusterName);
															#line 231 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<BackupClusterActor*>(this)->SAV<std::string>::futures) { (void)(container->getURL()); this->~BackupClusterActorState(); static_cast<BackupClusterActor*>(this)->destroy(); return 0; }
															#line 1325 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<BackupClusterActor*>(this)->SAV< std::string >::value()) std::string(container->getURL());
		this->~BackupClusterActorState();
		static_cast<BackupClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BackupClusterActor*>(this)->actor_wait_state > 0) static_cast<BackupClusterActor*>(this)->actor_wait_state = 0;
		static_cast<BackupClusterActor*>(this)->ActorCallback< BackupClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BackupClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backupCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BackupClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backupCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BackupClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backupCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackupClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupCluster", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	ClusterName clusterName;
															#line 209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Database dataDb;
															#line 209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 212 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	FileBackupAgent backupAgent;
															#line 213 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Standalone<StringRef> backupContainer;
															#line 214 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 228 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Reference<IBackupContainer> container;
															#line 1422 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via backupCluster()
															#line 209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class BackupClusterActor final : public Actor<std::string>, public ActorCallback< BackupClusterActor, 0, Void >, public ActorCallback< BackupClusterActor, 1, Void >, public FastAllocated<BackupClusterActor>, public BackupClusterActorState<BackupClusterActor> {
															#line 1427 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<BackupClusterActor>::operator new;
	using FastAllocated<BackupClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1870471785916491520UL, 7851866447949552128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BackupClusterActor, 0, Void >;
friend struct ActorCallback< BackupClusterActor, 1, Void >;
															#line 209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	BackupClusterActor(ClusterName const& clusterName,Database const& dataDb,MetaclusterRestoreWorkload* const& self) 
															#line 1445 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<std::string>(),
		   BackupClusterActorState<BackupClusterActor>(clusterName, dataDb, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("backupCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15996816721031098624UL, 3341916476502701056UL);
		ActorExecutionContextHelper __helper(static_cast<BackupClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("backupCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("backupCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BackupClusterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BackupClusterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<std::string> backupCluster( ClusterName const& clusterName, Database const& dataDb, MetaclusterRestoreWorkload* const& self ) {
															#line 209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<std::string>(new BackupClusterActor(clusterName, dataDb, self));
															#line 1478 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 233 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

																#line 1483 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via restoreDataCluster()
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class RestoreDataClusterActor>
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class RestoreDataClusterActorState {
															#line 1489 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	RestoreDataClusterActorState(ClusterName const& clusterName,Database const& dataDb,std::string const& backupUrl,bool const& addToMetacluster,metacluster::ForceJoin const& forceJoin,int const& simultaneousRestoreCount,MetaclusterRestoreWorkload* const& self) 
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : clusterName(clusterName),
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   dataDb(dataDb),
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   backupUrl(backupUrl),
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   addToMetacluster(addToMetacluster),
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   forceJoin(forceJoin),
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   simultaneousRestoreCount(simultaneousRestoreCount),
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   self(self),
															#line 241 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   backupAgent(),
															#line 242 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   backupRanges(),
															#line 243 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   forceReuseTenantIdPrefix(deterministicRandom()->coinflip())
															#line 1514 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("restoreDataCluster", reinterpret_cast<unsigned long>(this));

	}
	~RestoreDataClusterActorState() 
	{
		fdb_probe_actor_destroy("restoreDataCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 244 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			addDefaultBackupRanges(backupRanges);
															#line 246 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			TraceEvent("MetaclusterRestoreWorkloadClearDatabase").detail("ClusterName", clusterName);
															#line 247 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runTransaction(dataDb.getReference(), [backupRanges = backupRanges](Reference<ReadYourWritesTransaction> tr) { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); for (auto range : backupRanges) { tr->clear(range); } return Future<Void>(Void()); });
															#line 247 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1535 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 1;
															#line 247 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreDataClusterActor, 0, Void >*>(static_cast<RestoreDataClusterActor*>(this)));
															#line 1540 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreDataClusterActorState();
		static_cast<RestoreDataClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 256 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadRestoreCluster").detail("ClusterName", clusterName);
															#line 257 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(backupAgent.restore(dataDb, dataDb, clusterName, StringRef(backupUrl), {}, backupRanges));
															#line 257 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1567 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 2;
															#line 257 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RestoreDataClusterActor, 1, Void >*>(static_cast<RestoreDataClusterActor*>(this)));
															#line 1572 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 256 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadRestoreCluster").detail("ClusterName", clusterName);
															#line 257 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(backupAgent.restore(dataDb, dataDb, clusterName, StringRef(backupUrl), {}, backupRanges));
															#line 257 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 2;
															#line 257 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RestoreDataClusterActor, 1, Void >*>(static_cast<RestoreDataClusterActor*>(this)));
															#line 1590 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreDataClusterActor*>(this)->ActorCallback< RestoreDataClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreDataClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreDataClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreDataClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		messages = std::vector<std::string>();
															#line 260 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (addToMetacluster)
															#line 1676 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 261 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			TraceEvent("MetaclusterRestoreWorkloadAddClusterToMetacluster").detail("ClusterName", clusterName);
															#line 262 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 1682 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 263 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				TraceEvent("MetaclusterRestoreWorkloadAddClusterToMetaclusterDryRun") .detail("ClusterName", clusterName);
															#line 266 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				preDryRunMetaclusterData = metacluster::util::MetaclusterData<IDatabase>(self->managementDb);
															#line 267 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_2 = preDryRunMetaclusterData.load();
															#line 267 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1692 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
				static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 3;
															#line 267 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RestoreDataClusterActor, 2, Void >*>(static_cast<RestoreDataClusterActor*>(this)));
															#line 1697 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont4(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		messages = std::vector<std::string>();
															#line 260 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (addToMetacluster)
															#line 1718 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 261 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			TraceEvent("MetaclusterRestoreWorkloadAddClusterToMetacluster").detail("ClusterName", clusterName);
															#line 262 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 1724 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 263 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				TraceEvent("MetaclusterRestoreWorkloadAddClusterToMetaclusterDryRun") .detail("ClusterName", clusterName);
															#line 266 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				preDryRunMetaclusterData = metacluster::util::MetaclusterData<IDatabase>(self->managementDb);
															#line 267 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_2 = preDryRunMetaclusterData.load();
															#line 267 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1734 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
				static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 3;
															#line 267 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RestoreDataClusterActor, 2, Void >*>(static_cast<RestoreDataClusterActor*>(this)));
															#line 1739 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont4(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreDataClusterActor*>(this)->ActorCallback< RestoreDataClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreDataClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RestoreDataClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RestoreDataClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 333 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->dataDbs[clusterName].restored = true;
															#line 334 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->dataDbs[clusterName].restoreHasMessages = !messages.empty();
															#line 336 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<RestoreDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestoreDataClusterActorState(); static_cast<RestoreDataClusterActor*>(this)->destroy(); return 0; }
															#line 1837 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<RestoreDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RestoreDataClusterActorState();
		static_cast<RestoreDataClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 295 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		numRestores = deterministicRandom()->randomInt(1, 3);
															#line 296 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		successfulRestore = false;
															#line 297 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		;
															#line 1853 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 269 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = metacluster::restoreCluster(self->managementDb, clusterName, dataDb->getConnectionRecord()->getConnectionString(), metacluster::ApplyManagementClusterUpdates::True, metacluster::RestoreDryRun::True, forceJoin, forceReuseTenantIdPrefix, &messages);
															#line 269 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1864 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 4;
															#line 269 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RestoreDataClusterActor, 3, Void >*>(static_cast<RestoreDataClusterActor*>(this)));
															#line 1869 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 269 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = metacluster::restoreCluster(self->managementDb, clusterName, dataDb->getConnectionRecord()->getConnectionString(), metacluster::ApplyManagementClusterUpdates::True, metacluster::RestoreDryRun::True, forceJoin, forceReuseTenantIdPrefix, &messages);
															#line 269 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1880 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 4;
															#line 269 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RestoreDataClusterActor, 3, Void >*>(static_cast<RestoreDataClusterActor*>(this)));
															#line 1885 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreDataClusterActor*>(this)->ActorCallback< RestoreDataClusterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreDataClusterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RestoreDataClusterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RestoreDataClusterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 278 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		postDryRunMetaclusterData = metacluster::util::MetaclusterData<IDatabase>(self->managementDb);
															#line 279 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = postDryRunMetaclusterData.load();
															#line 279 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1973 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 5;
															#line 279 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RestoreDataClusterActor, 4, Void >*>(static_cast<RestoreDataClusterActor*>(this)));
															#line 1978 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 278 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		postDryRunMetaclusterData = metacluster::util::MetaclusterData<IDatabase>(self->managementDb);
															#line 279 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = postDryRunMetaclusterData.load();
															#line 279 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1991 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 5;
															#line 279 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RestoreDataClusterActor, 4, Void >*>(static_cast<RestoreDataClusterActor*>(this)));
															#line 1996 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreDataClusterActor*>(this)->ActorCallback< RestoreDataClusterActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreDataClusterActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RestoreDataClusterActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RestoreDataClusterActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 282 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (simultaneousRestoreCount == 1)
															#line 2080 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 283 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			CODE_PROBE(true, "Checking data cluster dry-run with no simultaneous restores");
															#line 284 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			preDryRunMetaclusterData.assertEquals(postDryRunMetaclusterData);
															#line 2086 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
		else
		{
															#line 286 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			preDryRunMetaclusterData.dataClusterMetadata[clusterName].assertEquals( postDryRunMetaclusterData.dataClusterMetadata[clusterName]);
															#line 2092 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 290 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadAddClusterToMetaclusterDryRunDone") .detail("ClusterName", clusterName);
															#line 292 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		messages.clear();
															#line 2098 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 282 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (simultaneousRestoreCount == 1)
															#line 2107 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 283 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			CODE_PROBE(true, "Checking data cluster dry-run with no simultaneous restores");
															#line 284 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			preDryRunMetaclusterData.assertEquals(postDryRunMetaclusterData);
															#line 2113 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
		else
		{
															#line 286 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			preDryRunMetaclusterData.dataClusterMetadata[clusterName].assertEquals( postDryRunMetaclusterData.dataClusterMetadata[clusterName]);
															#line 2119 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 290 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadAddClusterToMetaclusterDryRunDone") .detail("ClusterName", clusterName);
															#line 292 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		messages.clear();
															#line 2125 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreDataClusterActor*>(this)->ActorCallback< RestoreDataClusterActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreDataClusterActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RestoreDataClusterActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RestoreDataClusterActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 327 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<metacluster::DataClusterMetadata> __when_expr_7 = metacluster::getCluster(self->managementDb, clusterName);
															#line 327 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2211 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont11when1(__when_expr_7.get(), loopDepth); };
		static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 8;
															#line 327 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RestoreDataClusterActor, 7, metacluster::DataClusterMetadata >*>(static_cast<RestoreDataClusterActor*>(this)));
															#line 2216 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 297 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!(!successfulRestore))
															#line 2232 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 298 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		restoreFutures = std::vector<Future<ErrorOr<Void>>>();
															#line 299 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		;
															#line 2240 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
															#line 312 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = waitForAll(restoreFutures);
															#line 312 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2264 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 7;
															#line 312 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RestoreDataClusterActor, 6, Void >*>(static_cast<RestoreDataClusterActor*>(this)));
															#line 2269 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1(int loopDepth) 
	{
															#line 299 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!(numRestores > 0))
															#line 2285 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
			return a_body1cont4loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 300 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		restoreFutures.push_back( errorOr(metacluster::restoreCluster(self->managementDb, clusterName, dataDb->getConnectionRecord()->getConnectionString(), metacluster::ApplyManagementClusterUpdates::True, metacluster::RestoreDryRun::False, forceJoin, forceReuseTenantIdPrefix, &messages)));
															#line 309 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = delay(deterministicRandom()->random01() * 5);
															#line 309 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2295 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1cont4loopBody1loopBody1when1(__when_expr_5.get(), loopDepth); };
		static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 6;
															#line 309 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RestoreDataClusterActor, 5, Void >*>(static_cast<RestoreDataClusterActor*>(this)));
															#line 2300 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont4loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 299 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		numRestores--;
															#line 2322 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 299 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		numRestores--;
															#line 2331 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreDataClusterActor*>(this)->ActorCallback< RestoreDataClusterActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreDataClusterActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RestoreDataClusterActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RestoreDataClusterActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont4loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 314 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& f : restoreFutures ) {
															#line 315 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (!f.get().isError())
															#line 2417 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 316 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				successfulRestore = true;
															#line 2421 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
			else
			{
															#line 318 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT(f.get().getError().code() == error_code_conflicting_restore);
															#line 2427 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
		}
															#line 322 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		CODE_PROBE(!successfulRestore, "Simultaneous restores all failed");
															#line 323 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT(successfulRestore || restoreFutures.size() > 1);
															#line 324 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		numRestores = 1;
															#line 2436 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 314 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& f : restoreFutures ) {
															#line 315 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (!f.get().isError())
															#line 2447 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 316 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				successfulRestore = true;
															#line 2451 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
			else
			{
															#line 318 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT(f.get().getError().code() == error_code_conflicting_restore);
															#line 2457 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
		}
															#line 322 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		CODE_PROBE(!successfulRestore, "Simultaneous restores all failed");
															#line 323 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT(successfulRestore || restoreFutures.size() > 1);
															#line 324 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		numRestores = 1;
															#line 2466 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreDataClusterActor*>(this)->ActorCallback< RestoreDataClusterActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreDataClusterActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RestoreDataClusterActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RestoreDataClusterActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont11cont1(metacluster::DataClusterMetadata const& clusterMetadata,int loopDepth) 
	{
															#line 329 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT_EQ(clusterMetadata.entry.clusterState, metacluster::DataClusterState::READY);
															#line 330 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadRestoreComplete").detail("ClusterName", clusterName);
															#line 2552 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1(metacluster::DataClusterMetadata && clusterMetadata,int loopDepth) 
	{
															#line 329 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT_EQ(clusterMetadata.entry.clusterState, metacluster::DataClusterState::READY);
															#line 330 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadRestoreComplete").detail("ClusterName", clusterName);
															#line 2563 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(metacluster::DataClusterMetadata const& clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(clusterMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(metacluster::DataClusterMetadata && clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(clusterMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<RestoreDataClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreDataClusterActor*>(this)->ActorCallback< RestoreDataClusterActor, 7, metacluster::DataClusterMetadata >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreDataClusterActor, 7, metacluster::DataClusterMetadata >*,metacluster::DataClusterMetadata const& value) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RestoreDataClusterActor, 7, metacluster::DataClusterMetadata >*,metacluster::DataClusterMetadata && value) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RestoreDataClusterActor, 7, metacluster::DataClusterMetadata >*,Error err) 
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	ClusterName clusterName;
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Database dataDb;
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	std::string backupUrl;
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	bool addToMetacluster;
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	metacluster::ForceJoin forceJoin;
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	int simultaneousRestoreCount;
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 241 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	FileBackupAgent backupAgent;
															#line 242 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 243 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	metacluster::ForceReuseTenantIdPrefix forceReuseTenantIdPrefix;
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	std::vector<std::string> messages;
															#line 266 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	metacluster::util::MetaclusterData<IDatabase> preDryRunMetaclusterData;
															#line 278 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	metacluster::util::MetaclusterData<IDatabase> postDryRunMetaclusterData;
															#line 295 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	int numRestores;
															#line 296 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	bool successfulRestore;
															#line 298 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	std::vector<Future<ErrorOr<Void>>> restoreFutures;
															#line 2675 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via restoreDataCluster()
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class RestoreDataClusterActor final : public Actor<Void>, public ActorCallback< RestoreDataClusterActor, 0, Void >, public ActorCallback< RestoreDataClusterActor, 1, Void >, public ActorCallback< RestoreDataClusterActor, 2, Void >, public ActorCallback< RestoreDataClusterActor, 3, Void >, public ActorCallback< RestoreDataClusterActor, 4, Void >, public ActorCallback< RestoreDataClusterActor, 5, Void >, public ActorCallback< RestoreDataClusterActor, 6, Void >, public ActorCallback< RestoreDataClusterActor, 7, metacluster::DataClusterMetadata >, public FastAllocated<RestoreDataClusterActor>, public RestoreDataClusterActorState<RestoreDataClusterActor> {
															#line 2680 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<RestoreDataClusterActor>::operator new;
	using FastAllocated<RestoreDataClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1972574706643364096UL, 11748623011500334336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreDataClusterActor, 0, Void >;
friend struct ActorCallback< RestoreDataClusterActor, 1, Void >;
friend struct ActorCallback< RestoreDataClusterActor, 2, Void >;
friend struct ActorCallback< RestoreDataClusterActor, 3, Void >;
friend struct ActorCallback< RestoreDataClusterActor, 4, Void >;
friend struct ActorCallback< RestoreDataClusterActor, 5, Void >;
friend struct ActorCallback< RestoreDataClusterActor, 6, Void >;
friend struct ActorCallback< RestoreDataClusterActor, 7, metacluster::DataClusterMetadata >;
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	RestoreDataClusterActor(ClusterName const& clusterName,Database const& dataDb,std::string const& backupUrl,bool const& addToMetacluster,metacluster::ForceJoin const& forceJoin,int const& simultaneousRestoreCount,MetaclusterRestoreWorkload* const& self) 
															#line 2704 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RestoreDataClusterActorState<RestoreDataClusterActor>(clusterName, dataDb, backupUrl, addToMetacluster, forceJoin, simultaneousRestoreCount, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("restoreDataCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17029935368033680896UL, 4967852877758994944UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("restoreDataCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("restoreDataCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreDataClusterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RestoreDataClusterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RestoreDataClusterActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RestoreDataClusterActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RestoreDataClusterActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RestoreDataClusterActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RestoreDataClusterActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< RestoreDataClusterActor, 7, metacluster::DataClusterMetadata >*)0, actor_cancelled()); break;
		}

	}
};
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> restoreDataCluster( ClusterName const& clusterName, Database const& dataDb, std::string const& backupUrl, bool const& addToMetacluster, metacluster::ForceJoin const& forceJoin, int const& simultaneousRestoreCount, MetaclusterRestoreWorkload* const& self ) {
															#line 234 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<Void>(new RestoreDataClusterActor(clusterName, dataDb, backupUrl, addToMetacluster, forceJoin, simultaneousRestoreCount, self));
															#line 2743 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 338 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

	void removeTrackedTenant(int64_t tenantId) {
		auto itr = createdTenants.find(tenantId);
		if (itr != createdTenants.end()) {
			TraceEvent(SevDebug, "MetaclusterRestoreWorkloadRemoveTrackedTenant")
			    .detail("TenantId", tenantId)
			    .detail("TenantName", itr->second.name);
			deletedTenants.insert(tenantId);
			dataDbs[itr->second.cluster].tenants.erase(tenantId);
			if (itr->second.tenantGroup.present()) {
				tenantGroups[itr->second.tenantGroup.get()].tenants.erase(tenantId);
			}
			createdTenants.erase(itr);
		}
	}

	// A map from tenant name to a pair of IDs. The first ID is from the data cluster, and the second is from the
	// management cluster.
	using TenantCollisions = std::unordered_map<TenantName, std::pair<int64_t, int64_t>>;

	using GroupCollisions = std::unordered_set<TenantGroupName>;

	Future<Void> resolveTenantCollisions(MetaclusterRestoreWorkload* self,
	                                     ClusterName clusterName,
	                                     Database dataDb,
	                                     TenantCollisions const& tenantCollisions) {
		TraceEvent("MetaclusterRestoreWorkloadDeleteTenantCollisions")
		    .detail("FromCluster", clusterName)
		    .detail("TenantCollisions", tenantCollisions.size());
		std::vector<Future<Void>> deleteFutures;
		for (auto const& t : tenantCollisions) {
			// If the data cluster tenant is expected, then remove the management tenant
			// Note that the management tenant may also have been expected
			if (self->createdTenants.contains(t.second.first)) {
				CODE_PROBE(true, "Remove management tenant in restore collision");
				removeTrackedTenant(t.second.second);
				deleteFutures.push_back(metacluster::deleteTenant(self->managementDb, t.second.second));
			}
			// We don't expect the data cluster tenant, so delete it
			else {
				CODE_PROBE(true, "Remove data cluster tenant in restore collision");
				removeTrackedTenant(t.second.first);
				deleteFutures.push_back(TenantAPI::deleteTenant(dataDb.getReference(), t.first, t.second.first));
			}
		}

		return waitForAll(deleteFutures);
	}

																#line 2796 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via getTenantsInGroup()
															#line 387 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class Transaction, class TenantTypes, class GetTenantsInGroupActor>
															#line 387 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class GetTenantsInGroupActorState {
															#line 2802 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 387 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	GetTenantsInGroupActorState(Transaction const& tr,TenantMetadataSpecification<TenantTypes> const& tenantMetadata,TenantGroupName const& tenantGroup) 
															#line 387 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 387 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : tr(tr),
															#line 387 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   tenantMetadata(tenantMetadata),
															#line 387 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   tenantGroup(tenantGroup)
															#line 2813 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("getTenantsInGroup", reinterpret_cast<unsigned long>(this));

	}
	~GetTenantsInGroupActorState() 
	{
		fdb_probe_actor_destroy("getTenantsInGroup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 392 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<KeyBackedRangeResult<Tuple>> __when_expr_0 = tenantMetadata.tenantGroupTenantIndex.getRange(tr, Tuple::makeTuple(tenantGroup), Tuple::makeTuple(keyAfter(tenantGroup)), CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1);
															#line 392 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<GetTenantsInGroupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2830 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTenantsInGroupActor*>(this)->actor_wait_state = 1;
															#line 392 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTenantsInGroupActor, 0, KeyBackedRangeResult<Tuple> >*>(static_cast<GetTenantsInGroupActor*>(this)));
															#line 2835 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTenantsInGroupActorState();
		static_cast<GetTenantsInGroupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(KeyBackedRangeResult<Tuple> const& groupTenants,int loopDepth) 
	{
															#line 397 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		std::unordered_set<int64_t> tenants;
															#line 398 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& tuple : groupTenants.results ) {
															#line 399 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tenants.insert(tuple.getInt(2));
															#line 2862 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 402 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<GetTenantsInGroupActor*>(this)->SAV<std::unordered_set<int64_t>>::futures) { (void)(tenants); this->~GetTenantsInGroupActorState(); static_cast<GetTenantsInGroupActor*>(this)->destroy(); return 0; }
															#line 2866 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<GetTenantsInGroupActor*>(this)->SAV< std::unordered_set<int64_t> >::value()) std::unordered_set<int64_t>(tenants);
		this->~GetTenantsInGroupActorState();
		static_cast<GetTenantsInGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(KeyBackedRangeResult<Tuple> && groupTenants,int loopDepth) 
	{
															#line 397 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		std::unordered_set<int64_t> tenants;
															#line 398 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& tuple : groupTenants.results ) {
															#line 399 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tenants.insert(tuple.getInt(2));
															#line 2882 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 402 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<GetTenantsInGroupActor*>(this)->SAV<std::unordered_set<int64_t>>::futures) { (void)(tenants); this->~GetTenantsInGroupActorState(); static_cast<GetTenantsInGroupActor*>(this)->destroy(); return 0; }
															#line 2886 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<GetTenantsInGroupActor*>(this)->SAV< std::unordered_set<int64_t> >::value()) std::unordered_set<int64_t>(tenants);
		this->~GetTenantsInGroupActorState();
		static_cast<GetTenantsInGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<Tuple> const& groupTenants,int loopDepth) 
	{
		loopDepth = a_body1cont1(groupTenants, loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<Tuple> && groupTenants,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(groupTenants), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTenantsInGroupActor*>(this)->actor_wait_state > 0) static_cast<GetTenantsInGroupActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantsInGroupActor*>(this)->ActorCallback< GetTenantsInGroupActor, 0, KeyBackedRangeResult<Tuple> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantsInGroupActor, 0, KeyBackedRangeResult<Tuple> >*,KeyBackedRangeResult<Tuple> const& value) 
	{
		fdb_probe_actor_enter("getTenantsInGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantsInGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantsInGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTenantsInGroupActor, 0, KeyBackedRangeResult<Tuple> >*,KeyBackedRangeResult<Tuple> && value) 
	{
		fdb_probe_actor_enter("getTenantsInGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantsInGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantsInGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTenantsInGroupActor, 0, KeyBackedRangeResult<Tuple> >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantsInGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantsInGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantsInGroup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 387 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Transaction tr;
															#line 387 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	TenantMetadataSpecification<TenantTypes> tenantMetadata;
															#line 387 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	TenantGroupName tenantGroup;
															#line 2975 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via getTenantsInGroup()
															#line 387 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class Transaction, class TenantTypes>
															#line 387 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class GetTenantsInGroupActor final : public Actor<std::unordered_set<int64_t>>, public ActorCallback< GetTenantsInGroupActor<Transaction, TenantTypes>, 0, KeyBackedRangeResult<Tuple> >, public FastAllocated<GetTenantsInGroupActor<Transaction, TenantTypes>>, public GetTenantsInGroupActorState<Transaction, TenantTypes, GetTenantsInGroupActor<Transaction, TenantTypes>> {
															#line 2982 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<GetTenantsInGroupActor<Transaction, TenantTypes>>::operator new;
	using FastAllocated<GetTenantsInGroupActor<Transaction, TenantTypes>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5139973422068509952UL, 17892058076278857472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::unordered_set<int64_t>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTenantsInGroupActor<Transaction, TenantTypes>, 0, KeyBackedRangeResult<Tuple> >;
															#line 387 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	GetTenantsInGroupActor(Transaction const& tr,TenantMetadataSpecification<TenantTypes> const& tenantMetadata,TenantGroupName const& tenantGroup) 
															#line 2999 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<std::unordered_set<int64_t>>(),
		   GetTenantsInGroupActorState<Transaction, TenantTypes, GetTenantsInGroupActor<Transaction, TenantTypes>>(tr, tenantMetadata, tenantGroup),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTenantsInGroup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13289838464966167808UL, 14962504526763200256UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantsInGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTenantsInGroup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTenantsInGroup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTenantsInGroupActor<Transaction, TenantTypes>, 0, KeyBackedRangeResult<Tuple> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 387 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class Transaction, class TenantTypes>
															#line 387 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<std::unordered_set<int64_t>> getTenantsInGroup( Transaction const& tr, TenantMetadataSpecification<TenantTypes> const& tenantMetadata, TenantGroupName const& tenantGroup ) {
															#line 387 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<std::unordered_set<int64_t>>(new GetTenantsInGroupActor<Transaction, TenantTypes>(tr, tenantMetadata, tenantGroup));
															#line 3033 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 404 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

																#line 3038 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via resolveGroupCollisions()
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class ResolveGroupCollisionsActor>
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class ResolveGroupCollisionsActorState {
															#line 3044 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	ResolveGroupCollisionsActorState(MetaclusterRestoreWorkload* const& self,ClusterName const& clusterName,Database const& dataDb,GroupCollisions const& groupCollisions) 
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : self(self),
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   clusterName(clusterName),
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   dataDb(dataDb),
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   groupCollisions(groupCollisions)
															#line 3057 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("resolveGroupCollisions", reinterpret_cast<unsigned long>(this));

	}
	~ResolveGroupCollisionsActorState() 
	{
		fdb_probe_actor_destroy("resolveGroupCollisions", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 409 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			TraceEvent("MetaclusterRestoreWorkloadDeleteTenantGroupCollisions") .detail("FromCluster", clusterName) .detail("GroupCollisions", groupCollisions.size());
															#line 413 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			deleteFutures = std::vector<Future<Void>>();
															#line 415 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			collisionItr = GroupCollisions::const_iterator();
															#line 416 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			collisionItr = groupCollisions.begin();
															#line 3078 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ResolveGroupCollisionsActorState();
		static_cast<ResolveGroupCollisionsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 461 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(deleteFutures);
															#line 461 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<ResolveGroupCollisionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3103 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ResolveGroupCollisionsActor*>(this)->actor_wait_state = 3;
															#line 461 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ResolveGroupCollisionsActor, 2, Void >*>(static_cast<ResolveGroupCollisionsActor*>(this)));
															#line 3108 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 416 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!(collisionItr != groupCollisions.end()))
															#line 3124 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 419 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		auto itr = self->tenantGroups.find(*collisionItr);
															#line 420 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (itr->second.cluster == clusterName)
															#line 3132 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 421 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			CODE_PROBE(true, "Remove management tenant group in restore collision");
															#line 422 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterRestoreWorkloadDeleteTenantGroupCollision") .detail("From", "ManagementCluster") .detail("TenantGroup", *collisionItr);
															#line 425 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<std::unordered_set<int64_t>> __when_expr_0 = runTransaction(self->managementDb, [collisionItr = collisionItr](Reference<ITransaction> tr) { return getTenantsInGroup( tr, metacluster::metadata::management::tenantMetadata(), *collisionItr); });
															#line 425 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<ResolveGroupCollisionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3142 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ResolveGroupCollisionsActor*>(this)->actor_wait_state = 1;
															#line 425 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ResolveGroupCollisionsActor, 0, std::unordered_set<int64_t> >*>(static_cast<ResolveGroupCollisionsActor*>(this)));
															#line 3147 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 438 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			CODE_PROBE(true, "Remove data cluster tenant group in restore collision");
															#line 439 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterRestoreWorkloadDeleteTenantGroupCollision") .detail("From", "DataCluster") .detail("TenantGroup", *collisionItr);
															#line 442 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<std::unordered_set<int64_t>> __when_expr_1 = runTransaction( dataDb.getReference(), [collisionItr = collisionItr](Reference<ReadYourWritesTransaction> tr) { tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS); return getTenantsInGroup(tr, TenantMetadata::instance(), *collisionItr); });
															#line 442 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<ResolveGroupCollisionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3160 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<ResolveGroupCollisionsActor*>(this)->actor_wait_state = 2;
															#line 442 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ResolveGroupCollisionsActor, 1, std::unordered_set<int64_t> >*>(static_cast<ResolveGroupCollisionsActor*>(this)));
															#line 3165 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 416 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		++collisionItr;
															#line 3188 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::unordered_set<int64_t> const& tenantsInGroup,int loopDepth) 
	{
															#line 431 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& t : tenantsInGroup ) {
															#line 432 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			self->removeTrackedTenant(t);
															#line 433 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			deleteFutures.push_back(metacluster::deleteTenant(self->managementDb, t));
															#line 3201 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::unordered_set<int64_t> && tenantsInGroup,int loopDepth) 
	{
															#line 431 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& t : tenantsInGroup ) {
															#line 432 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			self->removeTrackedTenant(t);
															#line 433 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			deleteFutures.push_back(metacluster::deleteTenant(self->managementDb, t));
															#line 3215 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::unordered_set<int64_t> const& tenantsInGroup,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(tenantsInGroup, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::unordered_set<int64_t> && tenantsInGroup,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(tenantsInGroup), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ResolveGroupCollisionsActor*>(this)->actor_wait_state > 0) static_cast<ResolveGroupCollisionsActor*>(this)->actor_wait_state = 0;
		static_cast<ResolveGroupCollisionsActor*>(this)->ActorCallback< ResolveGroupCollisionsActor, 0, std::unordered_set<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< ResolveGroupCollisionsActor, 0, std::unordered_set<int64_t> >*,std::unordered_set<int64_t> const& value) 
	{
		fdb_probe_actor_enter("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveGroupCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResolveGroupCollisionsActor, 0, std::unordered_set<int64_t> >*,std::unordered_set<int64_t> && value) 
	{
		fdb_probe_actor_enter("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveGroupCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ResolveGroupCollisionsActor, 0, std::unordered_set<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveGroupCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont6(std::unordered_set<int64_t> const& tenantsInGroup,int loopDepth) 
	{
															#line 448 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		deleteFutures.push_back(runTransactionVoid( dataDb.getReference(), [self = self, tenantsInGroup](Reference<ReadYourWritesTransaction> tr) { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); std::vector<Future<Void>> groupDeletions; for (auto const& t : tenantsInGroup) { self->removeTrackedTenant(t); groupDeletions.push_back(TenantAPI::deleteTenantTransaction(tr, t)); } return waitForAll(groupDeletions); }));
															#line 3300 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(std::unordered_set<int64_t> && tenantsInGroup,int loopDepth) 
	{
															#line 448 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		deleteFutures.push_back(runTransactionVoid( dataDb.getReference(), [self = self, tenantsInGroup](Reference<ReadYourWritesTransaction> tr) { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); std::vector<Future<Void>> groupDeletions; for (auto const& t : tenantsInGroup) { self->removeTrackedTenant(t); groupDeletions.push_back(TenantAPI::deleteTenantTransaction(tr, t)); } return waitForAll(groupDeletions); }));
															#line 3309 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(std::unordered_set<int64_t> const& tenantsInGroup,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(tenantsInGroup, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(std::unordered_set<int64_t> && tenantsInGroup,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(tenantsInGroup), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ResolveGroupCollisionsActor*>(this)->actor_wait_state > 0) static_cast<ResolveGroupCollisionsActor*>(this)->actor_wait_state = 0;
		static_cast<ResolveGroupCollisionsActor*>(this)->ActorCallback< ResolveGroupCollisionsActor, 1, std::unordered_set<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< ResolveGroupCollisionsActor, 1, std::unordered_set<int64_t> >*,std::unordered_set<int64_t> const& value) 
	{
		fdb_probe_actor_enter("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveGroupCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ResolveGroupCollisionsActor, 1, std::unordered_set<int64_t> >*,std::unordered_set<int64_t> && value) 
	{
		fdb_probe_actor_enter("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveGroupCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ResolveGroupCollisionsActor, 1, std::unordered_set<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveGroupCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 462 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<ResolveGroupCollisionsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResolveGroupCollisionsActorState(); static_cast<ResolveGroupCollisionsActor*>(this)->destroy(); return 0; }
															#line 3393 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<ResolveGroupCollisionsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResolveGroupCollisionsActorState();
		static_cast<ResolveGroupCollisionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 462 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<ResolveGroupCollisionsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResolveGroupCollisionsActorState(); static_cast<ResolveGroupCollisionsActor*>(this)->destroy(); return 0; }
															#line 3405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<ResolveGroupCollisionsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResolveGroupCollisionsActorState();
		static_cast<ResolveGroupCollisionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ResolveGroupCollisionsActor*>(this)->actor_wait_state > 0) static_cast<ResolveGroupCollisionsActor*>(this)->actor_wait_state = 0;
		static_cast<ResolveGroupCollisionsActor*>(this)->ActorCallback< ResolveGroupCollisionsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResolveGroupCollisionsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveGroupCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ResolveGroupCollisionsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveGroupCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ResolveGroupCollisionsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveGroupCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	ClusterName clusterName;
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Database dataDb;
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	GroupCollisions groupCollisions;
															#line 413 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	std::vector<Future<Void>> deleteFutures;
															#line 415 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	GroupCollisions::const_iterator collisionItr;
															#line 3500 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via resolveGroupCollisions()
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class ResolveGroupCollisionsActor final : public Actor<Void>, public ActorCallback< ResolveGroupCollisionsActor, 0, std::unordered_set<int64_t> >, public ActorCallback< ResolveGroupCollisionsActor, 1, std::unordered_set<int64_t> >, public ActorCallback< ResolveGroupCollisionsActor, 2, Void >, public FastAllocated<ResolveGroupCollisionsActor>, public ResolveGroupCollisionsActorState<ResolveGroupCollisionsActor> {
															#line 3505 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<ResolveGroupCollisionsActor>::operator new;
	using FastAllocated<ResolveGroupCollisionsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6275053039726499840UL, 10477737971917910528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ResolveGroupCollisionsActor, 0, std::unordered_set<int64_t> >;
friend struct ActorCallback< ResolveGroupCollisionsActor, 1, std::unordered_set<int64_t> >;
friend struct ActorCallback< ResolveGroupCollisionsActor, 2, Void >;
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	ResolveGroupCollisionsActor(MetaclusterRestoreWorkload* const& self,ClusterName const& clusterName,Database const& dataDb,GroupCollisions const& groupCollisions) 
															#line 3524 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ResolveGroupCollisionsActorState<ResolveGroupCollisionsActor>(self, clusterName, dataDb, groupCollisions),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9101197877337767168UL, 5409067514911611392UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveGroupCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("resolveGroupCollisions");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("resolveGroupCollisions", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ResolveGroupCollisionsActor, 0, std::unordered_set<int64_t> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ResolveGroupCollisionsActor, 1, std::unordered_set<int64_t> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ResolveGroupCollisionsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] Future<Void> resolveGroupCollisions( MetaclusterRestoreWorkload* const& self, ClusterName const& clusterName, Database const& dataDb, GroupCollisions const& groupCollisions ) {
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<Void>(new ResolveGroupCollisionsActor(self, clusterName, dataDb, groupCollisions));
															#line 3558 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 464 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

																#line 3563 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via getDataClusterTenants()
															#line 465 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class GetDataClusterTenantsActor>
															#line 465 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class GetDataClusterTenantsActorState {
															#line 3569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 465 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	GetDataClusterTenantsActorState(Database const& db) 
															#line 465 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 465 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : db(db)
															#line 3576 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("getDataClusterTenants", reinterpret_cast<unsigned long>(this));

	}
	~GetDataClusterTenantsActorState() 
	{
		fdb_probe_actor_destroy("getDataClusterTenants", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 466 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>>> __when_expr_0 = runTransaction(db.getReference(), [](Reference<ReadYourWritesTransaction> tr) { tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS); return TenantMetadata::tenantMap().getRange(tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1); });
															#line 466 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<GetDataClusterTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3593 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetDataClusterTenantsActor*>(this)->actor_wait_state = 1;
															#line 466 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDataClusterTenantsActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*>(static_cast<GetDataClusterTenantsActor*>(this)));
															#line 3598 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDataClusterTenantsActorState();
		static_cast<GetDataClusterTenantsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> const& tenants,int loopDepth) 
	{
															#line 472 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT_LE(tenants.results.size(), CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 473 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<GetDataClusterTenantsActor*>(this)->SAV<std::vector<std::pair<int64_t, TenantMapEntry>>>::futures) { (void)(tenants.results); this->~GetDataClusterTenantsActorState(); static_cast<GetDataClusterTenantsActor*>(this)->destroy(); return 0; }
															#line 3623 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<GetDataClusterTenantsActor*>(this)->SAV< std::vector<std::pair<int64_t, TenantMapEntry>> >::value()) std::vector<std::pair<int64_t, TenantMapEntry>>(tenants.results);
		this->~GetDataClusterTenantsActorState();
		static_cast<GetDataClusterTenantsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> && tenants,int loopDepth) 
	{
															#line 472 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT_LE(tenants.results.size(), CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 473 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<GetDataClusterTenantsActor*>(this)->SAV<std::vector<std::pair<int64_t, TenantMapEntry>>>::futures) { (void)(tenants.results); this->~GetDataClusterTenantsActorState(); static_cast<GetDataClusterTenantsActor*>(this)->destroy(); return 0; }
															#line 3637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<GetDataClusterTenantsActor*>(this)->SAV< std::vector<std::pair<int64_t, TenantMapEntry>> >::value()) std::vector<std::pair<int64_t, TenantMapEntry>>(tenants.results);
		this->~GetDataClusterTenantsActorState();
		static_cast<GetDataClusterTenantsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> const& tenants,int loopDepth) 
	{
		loopDepth = a_body1cont1(tenants, loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> && tenants,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tenants), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDataClusterTenantsActor*>(this)->actor_wait_state > 0) static_cast<GetDataClusterTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<GetDataClusterTenantsActor*>(this)->ActorCallback< GetDataClusterTenantsActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataClusterTenantsActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("getDataClusterTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataClusterTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataClusterTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDataClusterTenantsActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("getDataClusterTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataClusterTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataClusterTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDataClusterTenantsActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("getDataClusterTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataClusterTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataClusterTenants", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 465 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Database db;
															#line 3722 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via getDataClusterTenants()
															#line 465 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class GetDataClusterTenantsActor final : public Actor<std::vector<std::pair<int64_t, TenantMapEntry>>>, public ActorCallback< GetDataClusterTenantsActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >, public FastAllocated<GetDataClusterTenantsActor>, public GetDataClusterTenantsActorState<GetDataClusterTenantsActor> {
															#line 3727 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<GetDataClusterTenantsActor>::operator new;
	using FastAllocated<GetDataClusterTenantsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7579728930152168448UL, 9387663001698537472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<int64_t, TenantMapEntry>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDataClusterTenantsActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >;
															#line 465 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	GetDataClusterTenantsActor(Database const& db) 
															#line 3744 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<std::vector<std::pair<int64_t, TenantMapEntry>>>(),
		   GetDataClusterTenantsActorState<GetDataClusterTenantsActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDataClusterTenants", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10340880133079742976UL, 3303124740388399104UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataClusterTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDataClusterTenants");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDataClusterTenants", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDataClusterTenantsActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 465 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<std::vector<std::pair<int64_t, TenantMapEntry>>> getDataClusterTenants( Database const& db ) {
															#line 465 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<std::vector<std::pair<int64_t, TenantMapEntry>>>(new GetDataClusterTenantsActor(db));
															#line 3776 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 475 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

																#line 3781 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via getCollisions()
															#line 476 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class GetCollisionsActor>
															#line 476 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class GetCollisionsActorState {
															#line 3787 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 476 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	GetCollisionsActorState(MetaclusterRestoreWorkload* const& self,Database const& db) 
															#line 476 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 476 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : self(self),
															#line 476 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   db(db),
															#line 478 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   managementTenantList(),
															#line 479 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   managementGroupList(),
															#line 481 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   dataClusterTenants(),
															#line 482 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   dataClusterGroups(),
															#line 484 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   tenantCollisions(),
															#line 485 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   groupCollisions()
															#line 3808 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("getCollisions", reinterpret_cast<unsigned long>(this));

	}
	~GetCollisionsActorState() 
	{
		fdb_probe_actor_destroy("getCollisions", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 488 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runTransactionVoid( self->managementDb, [managementTenantList = &managementTenantList, managementGroupList = &managementGroupList](Reference<ITransaction> tr) { return store(*managementTenantList, metacluster::metadata::management::tenantMetadata().tenantNameIndex.getRange( tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1)) && store(*managementGroupList, metacluster::metadata::management::tenantMetadata().tenantGroupMap.getRange( tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1)); });
															#line 488 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<GetCollisionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3825 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetCollisionsActor*>(this)->actor_wait_state = 1;
															#line 488 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCollisionsActor, 0, Void >*>(static_cast<GetCollisionsActor*>(this)));
															#line 3830 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCollisionsActorState();
		static_cast<GetCollisionsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 501 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runTransaction(db.getReference(), [dataClusterTenants = &dataClusterTenants, dataClusterGroups = &dataClusterGroups](Reference<ReadYourWritesTransaction> tr) { tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS); return store(*dataClusterTenants, TenantMetadata::tenantNameIndex().getRange( tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1)) && store(*dataClusterGroups, TenantMetadata::tenantGroupMap().getRange( tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1)); });
															#line 501 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<GetCollisionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3855 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetCollisionsActor*>(this)->actor_wait_state = 2;
															#line 501 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetCollisionsActor, 1, Void >*>(static_cast<GetCollisionsActor*>(this)));
															#line 3860 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 501 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runTransaction(db.getReference(), [dataClusterTenants = &dataClusterTenants, dataClusterGroups = &dataClusterGroups](Reference<ReadYourWritesTransaction> tr) { tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS); return store(*dataClusterTenants, TenantMetadata::tenantNameIndex().getRange( tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1)) && store(*dataClusterGroups, TenantMetadata::tenantGroupMap().getRange( tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1)); });
															#line 501 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<GetCollisionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3871 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetCollisionsActor*>(this)->actor_wait_state = 2;
															#line 501 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetCollisionsActor, 1, Void >*>(static_cast<GetCollisionsActor*>(this)));
															#line 3876 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCollisionsActor*>(this)->actor_wait_state > 0) static_cast<GetCollisionsActor*>(this)->actor_wait_state = 0;
		static_cast<GetCollisionsActor*>(this)->ActorCallback< GetCollisionsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCollisionsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCollisions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCollisions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCollisionsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCollisions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCollisions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCollisionsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCollisions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCollisions", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 513 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		std::unordered_map<TenantName, int64_t> managementTenants(managementTenantList.results.begin(), managementTenantList.results.end());
															#line 515 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		std::unordered_map<TenantGroupName, metacluster::MetaclusterTenantGroupEntry> managementGroups( managementGroupList.results.begin(), managementGroupList.results.end());
															#line 518 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT(managementTenants.size() <= CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 519 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT(managementGroups.size() <= CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 520 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT(dataClusterTenants.results.size() <= CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 521 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT(dataClusterGroups.results.size() <= CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 523 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& t : dataClusterTenants.results ) {
															#line 524 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			auto itr = managementTenants.find(t.first);
															#line 525 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (itr != managementTenants.end())
															#line 3976 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 526 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				tenantCollisions[t.first] = std::make_pair(t.second, itr->second);
															#line 3980 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
		}
															#line 529 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& g : dataClusterGroups.results ) {
															#line 530 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (managementGroups.contains(g.first))
															#line 3987 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 531 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				groupCollisions.insert(g.first);
															#line 3991 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
		}
															#line 535 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<GetCollisionsActor*>(this)->SAV<std::pair<TenantCollisions, GroupCollisions>>::futures) { (void)(std::make_pair(tenantCollisions, groupCollisions)); this->~GetCollisionsActorState(); static_cast<GetCollisionsActor*>(this)->destroy(); return 0; }
															#line 3996 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<GetCollisionsActor*>(this)->SAV< std::pair<TenantCollisions, GroupCollisions> >::value()) std::pair<TenantCollisions, GroupCollisions>(std::make_pair(tenantCollisions, groupCollisions));
		this->~GetCollisionsActorState();
		static_cast<GetCollisionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 513 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		std::unordered_map<TenantName, int64_t> managementTenants(managementTenantList.results.begin(), managementTenantList.results.end());
															#line 515 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		std::unordered_map<TenantGroupName, metacluster::MetaclusterTenantGroupEntry> managementGroups( managementGroupList.results.begin(), managementGroupList.results.end());
															#line 518 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT(managementTenants.size() <= CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 519 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT(managementGroups.size() <= CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 520 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT(dataClusterTenants.results.size() <= CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 521 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT(dataClusterGroups.results.size() <= CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 523 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& t : dataClusterTenants.results ) {
															#line 524 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			auto itr = managementTenants.find(t.first);
															#line 525 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (itr != managementTenants.end())
															#line 4024 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 526 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				tenantCollisions[t.first] = std::make_pair(t.second, itr->second);
															#line 4028 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
		}
															#line 529 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& g : dataClusterGroups.results ) {
															#line 530 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (managementGroups.contains(g.first))
															#line 4035 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 531 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				groupCollisions.insert(g.first);
															#line 4039 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
		}
															#line 535 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<GetCollisionsActor*>(this)->SAV<std::pair<TenantCollisions, GroupCollisions>>::futures) { (void)(std::make_pair(tenantCollisions, groupCollisions)); this->~GetCollisionsActorState(); static_cast<GetCollisionsActor*>(this)->destroy(); return 0; }
															#line 4044 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<GetCollisionsActor*>(this)->SAV< std::pair<TenantCollisions, GroupCollisions> >::value()) std::pair<TenantCollisions, GroupCollisions>(std::make_pair(tenantCollisions, groupCollisions));
		this->~GetCollisionsActorState();
		static_cast<GetCollisionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetCollisionsActor*>(this)->actor_wait_state > 0) static_cast<GetCollisionsActor*>(this)->actor_wait_state = 0;
		static_cast<GetCollisionsActor*>(this)->ActorCallback< GetCollisionsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCollisionsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCollisions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCollisions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetCollisionsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCollisions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCollisions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetCollisionsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCollisions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCollisions", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 476 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 476 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Database db;
															#line 478 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	KeyBackedRangeResult<std::pair<TenantName, int64_t>> managementTenantList;
															#line 479 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	KeyBackedRangeResult<std::pair<TenantGroupName, metacluster::MetaclusterTenantGroupEntry>> managementGroupList;
															#line 481 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	KeyBackedRangeResult<std::pair<TenantName, int64_t>> dataClusterTenants;
															#line 482 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	KeyBackedRangeResult<std::pair<TenantGroupName, TenantGroupEntry>> dataClusterGroups;
															#line 484 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	TenantCollisions tenantCollisions;
															#line 485 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	GroupCollisions groupCollisions;
															#line 4143 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via getCollisions()
															#line 476 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class GetCollisionsActor final : public Actor<std::pair<TenantCollisions, GroupCollisions>>, public ActorCallback< GetCollisionsActor, 0, Void >, public ActorCallback< GetCollisionsActor, 1, Void >, public FastAllocated<GetCollisionsActor>, public GetCollisionsActorState<GetCollisionsActor> {
															#line 4148 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<GetCollisionsActor>::operator new;
	using FastAllocated<GetCollisionsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17786072449919002368UL, 6884133496505440000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<TenantCollisions, GroupCollisions>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCollisionsActor, 0, Void >;
friend struct ActorCallback< GetCollisionsActor, 1, Void >;
															#line 476 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	GetCollisionsActor(MetaclusterRestoreWorkload* const& self,Database const& db) 
															#line 4166 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<std::pair<TenantCollisions, GroupCollisions>>(),
		   GetCollisionsActorState<GetCollisionsActor>(self, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCollisions", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10306128929325453056UL, 11105385672879284224UL);
		ActorExecutionContextHelper __helper(static_cast<GetCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCollisions");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCollisions", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCollisionsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetCollisionsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 476 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<std::pair<TenantCollisions, GroupCollisions>> getCollisions( MetaclusterRestoreWorkload* const& self, Database const& db ) {
															#line 476 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<std::pair<TenantCollisions, GroupCollisions>>(new GetCollisionsActor(self, db));
															#line 4199 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 537 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

																#line 4204 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via restoreManagementCluster()
															#line 538 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class RestoreManagementClusterActor>
															#line 538 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class RestoreManagementClusterActorState {
															#line 4210 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 538 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	RestoreManagementClusterActorState(MetaclusterRestoreWorkload* const& self) 
															#line 538 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 538 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : self(self)
															#line 4217 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("restoreManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	~RestoreManagementClusterActorState() 
	{
		fdb_probe_actor_destroy("restoreManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 539 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			TraceEvent("MetaclusterRestoreWorkloadRestoringManagementCluster");
															#line 541 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			newTenantIdPrefix = self->initialTenantIdPrefix;
															#line 542 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 4236 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 543 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				for(;newTenantIdPrefix == self->initialTenantIdPrefix;) {
															#line 544 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					newTenantIdPrefix = deterministicRandom()->randomInt(TenantAPI::TENANT_ID_PREFIX_MIN_VALUE, TenantAPI::TENANT_ID_PREFIX_MAX_VALUE + 1);
															#line 4242 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				}
			}
															#line 549 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success( metacluster::createMetacluster(self->managementDb, "management_cluster"_sr, newTenantIdPrefix, false));
															#line 549 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4249 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 1;
															#line 549 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 0, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 4254 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreManagementClusterActorState();
		static_cast<RestoreManagementClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 552 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		clusterItr = std::map<ClusterName, DataClusterData>::iterator();
															#line 553 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		clusterItr = self->dataDbs.begin();
															#line 4279 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 552 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		clusterItr = std::map<ClusterName, DataClusterData>::iterator();
															#line 553 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		clusterItr = self->dataDbs.begin();
															#line 4290 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 743 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadRestoredManagementCluster");
															#line 744 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<RestoreManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestoreManagementClusterActorState(); static_cast<RestoreManagementClusterActor*>(this)->destroy(); return 0; }
															#line 4376 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<RestoreManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RestoreManagementClusterActorState();
		static_cast<RestoreManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 553 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!(clusterItr != self->dataDbs.end()))
															#line 4395 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 554 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadProcessDataCluster").detail("FromCluster", clusterItr->first);
															#line 557 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(metacluster::removeCluster(clusterItr->second.db.getReference(), clusterItr->first, ClusterType::METACLUSTER_DATA, metacluster::ForceRemove::True));
															#line 557 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 2;
															#line 557 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 1, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 4410 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 561 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadForgotMetacluster").detail("ClusterName", clusterItr->first);
															#line 563 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<std::pair<TenantCollisions, GroupCollisions>> __when_expr_2 = getCollisions(self, clusterItr->second.db);
															#line 563 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4436 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 3;
															#line 563 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 2, std::pair<TenantCollisions, GroupCollisions> >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 4441 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 561 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadForgotMetacluster").detail("ClusterName", clusterItr->first);
															#line 563 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<std::pair<TenantCollisions, GroupCollisions>> __when_expr_2 = getCollisions(self, clusterItr->second.db);
															#line 563 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4454 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 3;
															#line 563 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 2, std::pair<TenantCollisions, GroupCollisions> >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 4459 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 566 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		messages = std::vector<std::string>();
															#line 567 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		completed = false;
															#line 568 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		;
															#line 4547 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(std::pair<TenantCollisions, GroupCollisions> const& __collisions,int loopDepth) 
	{
															#line 563 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		collisions = __collisions;
															#line 4556 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(std::pair<TenantCollisions, GroupCollisions> && __collisions,int loopDepth) 
	{
		collisions = std::move(__collisions);
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 2, std::pair<TenantCollisions, GroupCollisions> >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 2, std::pair<TenantCollisions, GroupCollisions> >*,std::pair<TenantCollisions, GroupCollisions> const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 2, std::pair<TenantCollisions, GroupCollisions> >*,std::pair<TenantCollisions, GroupCollisions> && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 2, std::pair<TenantCollisions, GroupCollisions> >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
															#line 739 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadRestoredDataClusterToManagementCluster") .detail("FromCluster", clusterItr->first);
															#line 553 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		++clusterItr;
															#line 4637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 568 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!(!completed))
															#line 4653 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
			return a_body1cont1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<std::vector<std::pair<int64_t, TenantMapEntry>>> __when_expr_3 = getDataClusterTenants(clusterItr->second.db);
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4661 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 4;
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 3, std::vector<std::pair<int64_t, TenantMapEntry>> >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 4666 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1(int loopDepth) 
	{
		try {
															#line 573 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			TraceEvent("MetaclusterRestoreWorkloadRestoreManagementCluster") .detail("FromCluster", clusterItr->first) .detail("TenantCollisions", collisions.first.size());
															#line 577 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 4691 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 578 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				TraceEvent("MetaclusterRestoreWorkloadRestoreManagementClusterDryRun") .detail("FromCluster", clusterItr->first) .detail("TenantCollisions", collisions.first.size());
															#line 582 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				preDryRunMetaclusterData = metacluster::util::MetaclusterData<IDatabase>(self->managementDb);
															#line 584 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_4 = preDryRunMetaclusterData.load();
															#line 584 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4701 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont3loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
				static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 5;
															#line 584 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 4, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 4706 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont3loopBody1cont4(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1when1(std::vector<std::pair<int64_t, TenantMapEntry>> const& __dataTenantsBeforeRestore,int loopDepth) 
	{
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		dataTenantsBeforeRestore = __dataTenantsBeforeRestore;
															#line 4726 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1when1(std::vector<std::pair<int64_t, TenantMapEntry>> && __dataTenantsBeforeRestore,int loopDepth) 
	{
		dataTenantsBeforeRestore = std::move(__dataTenantsBeforeRestore);
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 3, std::vector<std::pair<int64_t, TenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 3, std::vector<std::pair<int64_t, TenantMapEntry>> >*,std::vector<std::pair<int64_t, TenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 3, std::vector<std::pair<int64_t, TenantMapEntry>> >*,std::vector<std::pair<int64_t, TenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 3, std::vector<std::pair<int64_t, TenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont3loopBody1cont3(int loopDepth) 
	{
															#line 716 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<std::vector<std::pair<int64_t, TenantMapEntry>>> __when_expr_15 = getDataClusterTenants(clusterItr->second.db);
															#line 716 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4807 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont3loopBody1cont3when1(__when_expr_15.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 16;
															#line 716 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 15, std::vector<std::pair<int64_t, TenantMapEntry>> >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 4812 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 690 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			bool failedDueToCollision = (e.code() == error_code_tenant_already_exists && !collisions.first.empty()) || (e.code() == error_code_invalid_tenant_configuration && !collisions.second.empty());
															#line 693 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (!failedDueToCollision)
															#line 4824 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 694 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				TraceEvent(SevError, "MetaclusterRestoreWorkloadRestoreManagementClusterFailed") .error(e) .detail("FromCluster", clusterItr->first) .detail("TenantCollisions", collisions.first.size());
															#line 698 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT(false);
															#line 4830 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
			try {
															#line 703 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_14 = success(metacluster::removeCluster(self->managementDb, clusterItr->first, ClusterType::METACLUSTER_MANAGEMENT, metacluster::ForceRemove::True));
															#line 703 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 4837 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont1loopBody1cont3loopBody1cont1Catch1when1(__when_expr_14.get(), loopDepth); };
				static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 15;
															#line 703 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 14, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 4842 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1cont3loopBody1cont1Catch1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1cont3loopBody1cont1Catch1Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4(int loopDepth) 
	{
															#line 622 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		numRestores = deterministicRandom()->randomInt(1, 3);
															#line 623 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		successfulRestore = false;
															#line 624 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		;
															#line 4867 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		std::vector<Future<Void>> preDataClusterLoadFutures;
															#line 586 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& [name, data] : self->dataDbs ) {
															#line 587 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			preDataClusterLoadFutures.push_back(preDryRunMetaclusterData.loadDataCluster( name, data.db->getConnectionRecord()->getConnectionString()));
															#line 4880 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 590 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = waitForAll(preDataClusterLoadFutures);
															#line 590 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4886 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont3loopBody1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 6;
															#line 590 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 5, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 4891 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		std::vector<Future<Void>> preDataClusterLoadFutures;
															#line 586 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& [name, data] : self->dataDbs ) {
															#line 587 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			preDataClusterLoadFutures.push_back(preDryRunMetaclusterData.loadDataCluster( name, data.db->getConnectionRecord()->getConnectionString()));
															#line 4904 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 590 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = waitForAll(preDataClusterLoadFutures);
															#line 590 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4910 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont3loopBody1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 6;
															#line 590 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 5, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 4915 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont3loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 592 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = metacluster::restoreCluster( self->managementDb, clusterItr->first, clusterItr->second.db->getConnectionRecord()->getConnectionString(), metacluster::ApplyManagementClusterUpdates::False, metacluster::RestoreDryRun::True, metacluster::ForceJoin(deterministicRandom()->coinflip()), metacluster::ForceReuseTenantIdPrefix(newTenantIdPrefix == self->initialTenantIdPrefix), &messages);
															#line 592 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5001 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont3loopBody1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 7;
															#line 592 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 6, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 5006 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 592 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = metacluster::restoreCluster( self->managementDb, clusterItr->first, clusterItr->second.db->getConnectionRecord()->getConnectionString(), metacluster::ApplyManagementClusterUpdates::False, metacluster::RestoreDryRun::True, metacluster::ForceJoin(deterministicRandom()->coinflip()), metacluster::ForceReuseTenantIdPrefix(newTenantIdPrefix == self->initialTenantIdPrefix), &messages);
															#line 592 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5017 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont3loopBody1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 7;
															#line 592 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 6, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 5022 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont3loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont3loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont3loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 602 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		postDryRunMetaclusterData = metacluster::util::MetaclusterData<IDatabase>(self->managementDb);
															#line 604 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_7 = postDryRunMetaclusterData.load();
															#line 604 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1cont3loopBody1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 8;
															#line 604 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 7, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 5115 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 602 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		postDryRunMetaclusterData = metacluster::util::MetaclusterData<IDatabase>(self->managementDb);
															#line 604 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_7 = postDryRunMetaclusterData.load();
															#line 604 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5128 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1cont3loopBody1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 8;
															#line 604 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 7, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 5133 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont3loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont3loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1cont3loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 605 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		std::vector<Future<Void>> postDataClusterLoadFutures;
															#line 606 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& [name, data] : self->dataDbs ) {
															#line 607 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			postDataClusterLoadFutures.push_back(postDryRunMetaclusterData.loadDataCluster( name, data.db->getConnectionRecord()->getConnectionString()));
															#line 5221 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 610 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_8 = waitForAll(postDataClusterLoadFutures);
															#line 610 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5227 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1cont3loopBody1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 9;
															#line 610 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 8, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 5232 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 605 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		std::vector<Future<Void>> postDataClusterLoadFutures;
															#line 606 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& [name, data] : self->dataDbs ) {
															#line 607 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			postDataClusterLoadFutures.push_back(postDryRunMetaclusterData.loadDataCluster( name, data.db->getConnectionRecord()->getConnectionString()));
															#line 5245 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 610 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_8 = waitForAll(postDataClusterLoadFutures);
															#line 610 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5251 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1cont3loopBody1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 9;
															#line 610 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 8, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 5256 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont3loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont3loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1cont3loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		preDryRunMetaclusterData.assertEquals(postDryRunMetaclusterData);
															#line 615 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadRestoreManagementClusterDryRunDone") .detail("FromCluster", clusterItr->first) .detail("TenantCollisions", collisions.first.size());
															#line 619 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		messages.clear();
															#line 5344 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		preDryRunMetaclusterData.assertEquals(postDryRunMetaclusterData);
															#line 615 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadRestoreManagementClusterDryRunDone") .detail("FromCluster", clusterItr->first) .detail("TenantCollisions", collisions.first.size());
															#line 619 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		messages.clear();
															#line 5357 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont3loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont3loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont1loopBody1cont3loopBody1cont12(int loopDepth) 
	{
															#line 683 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<metacluster::DataClusterMetadata> __when_expr_13 = metacluster::getCluster(self->managementDb, clusterItr->first);
															#line 683 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5443 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont1loopBody1cont3loopBody1cont12when1(__when_expr_13.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 14;
															#line 683 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 13, metacluster::DataClusterMetadata >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 5448 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont3loopBody1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1(int loopDepth) 
	{
															#line 625 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		messagesList = std::vector<std::vector<std::string>>(numRestores);
															#line 626 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		restoreFutures = std::vector<Future<ErrorOr<Void>>>();
															#line 627 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		;
															#line 5468 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont4loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont3loopBody1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont1(int loopDepth) 
	{
															#line 640 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_10 = waitForAll(restoreFutures);
															#line 640 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5492 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont1when1(__when_expr_10.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 11;
															#line 640 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 10, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 5497 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont3loopBody1cont4loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1loopBody1(int loopDepth) 
	{
															#line 627 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!(numRestores > 0))
															#line 5513 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
			return a_body1cont1loopBody1cont3loopBody1cont4loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 628 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		restoreFutures.push_back(errorOr(metacluster::restoreCluster( self->managementDb, clusterItr->first, clusterItr->second.db->getConnectionRecord()->getConnectionString(), metacluster::ApplyManagementClusterUpdates::False, metacluster::RestoreDryRun::False, metacluster::ForceJoin(deterministicRandom()->coinflip()), metacluster::ForceReuseTenantIdPrefix(newTenantIdPrefix == self->initialTenantIdPrefix), &messagesList[restoreFutures.size()])));
															#line 637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_9 = delay(deterministicRandom()->random01() * 5);
															#line 637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5523 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont3loopBody1cont4loopBody1loopBody1when1(__when_expr_9.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 10;
															#line 637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 9, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 5528 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 627 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		numRestores--;
															#line 5550 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont3loopBody1cont4loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 627 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		numRestores--;
															#line 5559 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont3loopBody1cont4loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont4loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont4loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont3loopBody1cont4loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont3loopBody1cont4loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 642 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		Optional<Error> nonConflictError;
															#line 643 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for(int i = 0;i < restoreFutures.size();++i) {
															#line 644 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ErrorOr<Void> result = restoreFutures[i].get();
															#line 645 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (!result.isError())
															#line 5649 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 646 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT(!successfulRestore);
															#line 647 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				successfulRestore = true;
															#line 648 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				messages = messagesList[i];
															#line 5657 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
			else
			{
															#line 649 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (result.getError().code() != error_code_conflicting_restore && result.getError().code() != error_code_cluster_already_registered && result.getError().code() != error_code_cluster_already_exists && !nonConflictError.present())
															#line 5663 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				{
															#line 653 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					nonConflictError = result.getError().code();
															#line 654 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					messages = messagesList[i];
															#line 5669 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				}
			}
		}
															#line 658 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (nonConflictError.present())
															#line 5675 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 659 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ASSERT(!successfulRestore);
															#line 660 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			return a_body1cont1loopBody1cont3loopBody1cont1Catch1(nonConflictError.get(), std::max(0, loopDepth - 1));
															#line 5681 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
		else
		{
															#line 661 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (successfulRestore)
															#line 5687 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
				return a_body1cont1loopBody1cont3loopBody1cont4break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
															#line 665 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		CODE_PROBE(true, "Management cluster restore conflict for all simultaneous attempts", probe::decoration::rare);
															#line 668 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT_GT(restoreFutures.size(), 1);
															#line 670 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		numRestores = 1;
															#line 671 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_11 = success(metacluster::removeCluster(clusterItr->second.db.getReference(), clusterItr->first, ClusterType::METACLUSTER_DATA, metacluster::ForceRemove::True));
															#line 671 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5702 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont2when1(__when_expr_11.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 12;
															#line 671 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 11, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 5707 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 642 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		Optional<Error> nonConflictError;
															#line 643 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for(int i = 0;i < restoreFutures.size();++i) {
															#line 644 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ErrorOr<Void> result = restoreFutures[i].get();
															#line 645 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (!result.isError())
															#line 5722 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 646 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT(!successfulRestore);
															#line 647 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				successfulRestore = true;
															#line 648 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				messages = messagesList[i];
															#line 5730 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
			else
			{
															#line 649 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (result.getError().code() != error_code_conflicting_restore && result.getError().code() != error_code_cluster_already_registered && result.getError().code() != error_code_cluster_already_exists && !nonConflictError.present())
															#line 5736 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				{
															#line 653 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					nonConflictError = result.getError().code();
															#line 654 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					messages = messagesList[i];
															#line 5742 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				}
			}
		}
															#line 658 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (nonConflictError.present())
															#line 5748 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 659 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ASSERT(!successfulRestore);
															#line 660 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			return a_body1cont1loopBody1cont3loopBody1cont1Catch1(nonConflictError.get(), std::max(0, loopDepth - 1));
															#line 5754 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
		else
		{
															#line 661 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (successfulRestore)
															#line 5760 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
				return a_body1cont1loopBody1cont3loopBody1cont4break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
															#line 665 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		CODE_PROBE(true, "Management cluster restore conflict for all simultaneous attempts", probe::decoration::rare);
															#line 668 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT_GT(restoreFutures.size(), 1);
															#line 670 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		numRestores = 1;
															#line 671 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_11 = success(metacluster::removeCluster(clusterItr->second.db.getReference(), clusterItr->first, ClusterType::METACLUSTER_DATA, metacluster::ForceRemove::True));
															#line 671 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5775 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont2when1(__when_expr_11.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 12;
															#line 671 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 11, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 5780 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 675 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_12 = success(metacluster::removeCluster(self->managementDb, clusterItr->first, ClusterType::METACLUSTER_MANAGEMENT, metacluster::ForceRemove::True));
															#line 675 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5866 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont3when1(__when_expr_12.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 13;
															#line 675 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 12, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 5871 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 675 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_12 = success(metacluster::removeCluster(self->managementDb, clusterItr->first, ClusterType::METACLUSTER_MANAGEMENT, metacluster::ForceRemove::True));
															#line 675 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5882 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1loopBody1cont3loopBody1cont1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont3when1(__when_expr_12.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 13;
															#line 675 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 12, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 5887 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 679 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadRemovedFailedCluster") .detail("ClusterName", clusterItr->first);
															#line 5971 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont3loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 679 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadRemovedFailedCluster") .detail("ClusterName", clusterItr->first);
															#line 5980 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont3loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont3loopBody1cont4loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont1loopBody1cont3loopBody1cont12cont1(metacluster::DataClusterMetadata const& clusterMetadata,int loopDepth) 
	{
															#line 685 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT_EQ(clusterMetadata.entry.clusterState, metacluster::DataClusterState::READY);
															#line 687 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT(collisions.first.empty() && collisions.second.empty());
															#line 688 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		completed = true;
															#line 6068 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont12cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont12cont1(metacluster::DataClusterMetadata && clusterMetadata,int loopDepth) 
	{
															#line 685 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT_EQ(clusterMetadata.entry.clusterState, metacluster::DataClusterState::READY);
															#line 687 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT(collisions.first.empty() && collisions.second.empty());
															#line 688 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		completed = true;
															#line 6081 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont12cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont12when1(metacluster::DataClusterMetadata const& clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont12cont1(clusterMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont12when1(metacluster::DataClusterMetadata && clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont12cont1(std::move(clusterMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 13, metacluster::DataClusterMetadata >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 13, metacluster::DataClusterMetadata >*,metacluster::DataClusterMetadata const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont3loopBody1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 13, metacluster::DataClusterMetadata >*,metacluster::DataClusterMetadata && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont3loopBody1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 13, metacluster::DataClusterMetadata >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont1loopBody1cont3loopBody1cont12cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont3loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1Catch1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 710 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (e.code() != error_code_cluster_not_found)
															#line 6185 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 711 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 6189 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
			loopDepth = a_body1cont1loopBody1cont3loopBody1cont1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1Catch1cont3(Void const& _,int loopDepth) 
	{
															#line 707 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadRemovedFailedCluster") .detail("ClusterName", clusterItr->first);
															#line 6205 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1Catch1cont3(Void && _,int loopDepth) 
	{
															#line 707 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadRemovedFailedCluster") .detail("ClusterName", clusterItr->first);
															#line 6214 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont3loopBody1cont1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont1loopBody1cont3loopBody1cont1Catch1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont3loopBody1cont1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont13(std::vector<std::pair<int64_t, TenantMapEntry>> const& dataTenantsAfterRestore,int loopDepth) 
	{
															#line 720 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT_EQ(dataTenantsBeforeRestore.size(), dataTenantsAfterRestore.size());
															#line 721 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for(int i = 0;i < dataTenantsBeforeRestore.size();++i) {
															#line 722 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ASSERT_EQ(dataTenantsBeforeRestore[i].first, dataTenantsAfterRestore[i].first);
															#line 723 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ASSERT(dataTenantsBeforeRestore[i].second == dataTenantsAfterRestore[i].second);
															#line 6317 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 727 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!completed)
															#line 6321 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 728 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ASSERT(messages.size() > 0);
															#line 730 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_16 = self->resolveTenantCollisions( self, clusterItr->first, clusterItr->second.db, collisions.first);
															#line 730 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6329 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont3loopBody1cont13when1(__when_expr_16.get(), loopDepth); };
			static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 17;
															#line 730 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 16, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 6334 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont3loopBody1cont13cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont13(std::vector<std::pair<int64_t, TenantMapEntry>> && dataTenantsAfterRestore,int loopDepth) 
	{
															#line 720 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT_EQ(dataTenantsBeforeRestore.size(), dataTenantsAfterRestore.size());
															#line 721 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for(int i = 0;i < dataTenantsBeforeRestore.size();++i) {
															#line 722 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ASSERT_EQ(dataTenantsBeforeRestore[i].first, dataTenantsAfterRestore[i].first);
															#line 723 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ASSERT(dataTenantsBeforeRestore[i].second == dataTenantsAfterRestore[i].second);
															#line 6354 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 727 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!completed)
															#line 6358 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 728 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ASSERT(messages.size() > 0);
															#line 730 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_16 = self->resolveTenantCollisions( self, clusterItr->first, clusterItr->second.db, collisions.first);
															#line 730 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6366 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont3loopBody1cont13when1(__when_expr_16.get(), loopDepth); };
			static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 17;
															#line 730 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 16, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 6371 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont3loopBody1cont13cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont3when1(std::vector<std::pair<int64_t, TenantMapEntry>> const& dataTenantsAfterRestore,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont13(dataTenantsAfterRestore, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont3when1(std::vector<std::pair<int64_t, TenantMapEntry>> && dataTenantsAfterRestore,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont13(std::move(dataTenantsAfterRestore), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 15, std::vector<std::pair<int64_t, TenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 15, std::vector<std::pair<int64_t, TenantMapEntry>> >*,std::vector<std::pair<int64_t, TenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1loopBody1cont3loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 15, std::vector<std::pair<int64_t, TenantMapEntry>> >*,std::vector<std::pair<int64_t, TenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1loopBody1cont3loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 15, std::vector<std::pair<int64_t, TenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont1loopBody1cont3loopBody1cont13cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont13cont3(Void const& _,int loopDepth) 
	{
															#line 732 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_17 = self->resolveGroupCollisions( self, clusterItr->first, clusterItr->second.db, collisions.second);
															#line 732 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6468 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch1(__when_expr_17.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont3loopBody1cont13cont3when1(__when_expr_17.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 18;
															#line 732 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 17, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 6473 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont13cont3(Void && _,int loopDepth) 
	{
															#line 732 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_17 = self->resolveGroupCollisions( self, clusterItr->first, clusterItr->second.db, collisions.second);
															#line 732 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6484 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch1(__when_expr_17.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont3loopBody1cont13cont3when1(__when_expr_17.get(), loopDepth); };
		static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 18;
															#line 732 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< RestoreManagementClusterActor, 17, Void >*>(static_cast<RestoreManagementClusterActor*>(this)));
															#line 6489 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont13when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont13cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont13when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont13cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1loopBody1cont3loopBody1cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1loopBody1cont3loopBody1cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont1loopBody1cont3loopBody1cont13cont4(Void const& _,int loopDepth) 
	{
															#line 735 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		collisions.first.clear();
															#line 736 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		collisions.second.clear();
															#line 6575 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont13cont4(Void && _,int loopDepth) 
	{
															#line 735 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		collisions.first.clear();
															#line 736 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		collisions.second.clear();
															#line 6586 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont13cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont13cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont13cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont13cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreManagementClusterActor*>(this)->ActorCallback< RestoreManagementClusterActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1loopBody1cont3loopBody1cont13cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< RestoreManagementClusterActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1loopBody1cont3loopBody1cont13cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< RestoreManagementClusterActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), 17);

	}
															#line 538 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 541 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	int newTenantIdPrefix;
															#line 552 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	std::map<ClusterName, DataClusterData>::iterator clusterItr;
															#line 563 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	std::pair<TenantCollisions, GroupCollisions> collisions;
															#line 566 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	std::vector<std::string> messages;
															#line 567 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	bool completed;
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	std::vector<std::pair<int64_t, TenantMapEntry>> dataTenantsBeforeRestore;
															#line 582 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	metacluster::util::MetaclusterData<IDatabase> preDryRunMetaclusterData;
															#line 602 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	metacluster::util::MetaclusterData<IDatabase> postDryRunMetaclusterData;
															#line 622 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	int numRestores;
															#line 623 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	bool successfulRestore;
															#line 625 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	std::vector<std::vector<std::string>> messagesList;
															#line 626 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	std::vector<Future<ErrorOr<Void>>> restoreFutures;
															#line 6692 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via restoreManagementCluster()
															#line 538 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class RestoreManagementClusterActor final : public Actor<Void>, public ActorCallback< RestoreManagementClusterActor, 0, Void >, public ActorCallback< RestoreManagementClusterActor, 1, Void >, public ActorCallback< RestoreManagementClusterActor, 2, std::pair<TenantCollisions, GroupCollisions> >, public ActorCallback< RestoreManagementClusterActor, 3, std::vector<std::pair<int64_t, TenantMapEntry>> >, public ActorCallback< RestoreManagementClusterActor, 4, Void >, public ActorCallback< RestoreManagementClusterActor, 5, Void >, public ActorCallback< RestoreManagementClusterActor, 6, Void >, public ActorCallback< RestoreManagementClusterActor, 7, Void >, public ActorCallback< RestoreManagementClusterActor, 8, Void >, public ActorCallback< RestoreManagementClusterActor, 9, Void >, public ActorCallback< RestoreManagementClusterActor, 10, Void >, public ActorCallback< RestoreManagementClusterActor, 11, Void >, public ActorCallback< RestoreManagementClusterActor, 12, Void >, public ActorCallback< RestoreManagementClusterActor, 13, metacluster::DataClusterMetadata >, public ActorCallback< RestoreManagementClusterActor, 14, Void >, public ActorCallback< RestoreManagementClusterActor, 15, std::vector<std::pair<int64_t, TenantMapEntry>> >, public ActorCallback< RestoreManagementClusterActor, 16, Void >, public ActorCallback< RestoreManagementClusterActor, 17, Void >, public FastAllocated<RestoreManagementClusterActor>, public RestoreManagementClusterActorState<RestoreManagementClusterActor> {
															#line 6697 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<RestoreManagementClusterActor>::operator new;
	using FastAllocated<RestoreManagementClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11037531502517885184UL, 8955207156929234688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreManagementClusterActor, 0, Void >;
friend struct ActorCallback< RestoreManagementClusterActor, 1, Void >;
friend struct ActorCallback< RestoreManagementClusterActor, 2, std::pair<TenantCollisions, GroupCollisions> >;
friend struct ActorCallback< RestoreManagementClusterActor, 3, std::vector<std::pair<int64_t, TenantMapEntry>> >;
friend struct ActorCallback< RestoreManagementClusterActor, 4, Void >;
friend struct ActorCallback< RestoreManagementClusterActor, 5, Void >;
friend struct ActorCallback< RestoreManagementClusterActor, 6, Void >;
friend struct ActorCallback< RestoreManagementClusterActor, 7, Void >;
friend struct ActorCallback< RestoreManagementClusterActor, 8, Void >;
friend struct ActorCallback< RestoreManagementClusterActor, 9, Void >;
friend struct ActorCallback< RestoreManagementClusterActor, 10, Void >;
friend struct ActorCallback< RestoreManagementClusterActor, 11, Void >;
friend struct ActorCallback< RestoreManagementClusterActor, 12, Void >;
friend struct ActorCallback< RestoreManagementClusterActor, 13, metacluster::DataClusterMetadata >;
friend struct ActorCallback< RestoreManagementClusterActor, 14, Void >;
friend struct ActorCallback< RestoreManagementClusterActor, 15, std::vector<std::pair<int64_t, TenantMapEntry>> >;
friend struct ActorCallback< RestoreManagementClusterActor, 16, Void >;
friend struct ActorCallback< RestoreManagementClusterActor, 17, Void >;
															#line 538 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	RestoreManagementClusterActor(MetaclusterRestoreWorkload* const& self) 
															#line 6731 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RestoreManagementClusterActorState<RestoreManagementClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("restoreManagementCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15443272290528326656UL, 5071464697311822080UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("restoreManagementCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("restoreManagementCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 2, std::pair<TenantCollisions, GroupCollisions> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 3, std::vector<std::pair<int64_t, TenantMapEntry>> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 13, metacluster::DataClusterMetadata >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 15, std::vector<std::pair<int64_t, TenantMapEntry>> >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 16, Void >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< RestoreManagementClusterActor, 17, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 538 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> restoreManagementCluster( MetaclusterRestoreWorkload* const& self ) {
															#line 538 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<Void>(new RestoreManagementClusterActor(self));
															#line 6780 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 746 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

																#line 6785 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via resetManagementCluster()
															#line 747 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class ResetManagementClusterActor>
															#line 747 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class ResetManagementClusterActorState {
															#line 6791 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 747 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	ResetManagementClusterActorState(MetaclusterRestoreWorkload* const& self) 
															#line 747 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 747 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : self(self),
															#line 748 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   tr(self->managementDb->createTransaction())
															#line 6800 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("resetManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	~ResetManagementClusterActorState() 
	{
		fdb_probe_actor_destroy("resetManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 749 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			TraceEvent("MetaclusterRestoreWorkloadEraseManagementCluster");
															#line 750 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			;
															#line 6817 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ResetManagementClusterActorState();
		static_cast<ResetManagementClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 752 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 753 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tr->clear(""_sr, "\xff"_sr);
															#line 754 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			metacluster::metadata::metaclusterRegistration().clear(tr);
															#line 755 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = safeThreadFutureToFuture(tr->commit());
															#line 755 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<ResetManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6856 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ResetManagementClusterActor*>(this)->actor_wait_state = 1;
															#line 755 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ResetManagementClusterActor, 0, Void >*>(static_cast<ResetManagementClusterActor*>(this)));
															#line 6861 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 759 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 759 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<ResetManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6885 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ResetManagementClusterActor*>(this)->actor_wait_state = 2;
															#line 759 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ResetManagementClusterActor, 1, Void >*>(static_cast<ResetManagementClusterActor*>(this)));
															#line 6890 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 756 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadManagementClusterErased");
															#line 757 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<ResetManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResetManagementClusterActorState(); static_cast<ResetManagementClusterActor*>(this)->destroy(); return 0; }
															#line 6907 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<ResetManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResetManagementClusterActorState();
		static_cast<ResetManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 756 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadManagementClusterErased");
															#line 757 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<ResetManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResetManagementClusterActorState(); static_cast<ResetManagementClusterActor*>(this)->destroy(); return 0; }
															#line 6921 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<ResetManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResetManagementClusterActorState();
		static_cast<ResetManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ResetManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<ResetManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<ResetManagementClusterActor*>(this)->ActorCallback< ResetManagementClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResetManagementClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resetManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResetManagementClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resetManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ResetManagementClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resetManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResetManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ResetManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<ResetManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<ResetManagementClusterActor*>(this)->ActorCallback< ResetManagementClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResetManagementClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resetManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ResetManagementClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resetManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ResetManagementClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resetManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResetManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 747 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 748 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Reference<ITransaction> tr;
															#line 7095 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via resetManagementCluster()
															#line 747 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class ResetManagementClusterActor final : public Actor<Void>, public ActorCallback< ResetManagementClusterActor, 0, Void >, public ActorCallback< ResetManagementClusterActor, 1, Void >, public FastAllocated<ResetManagementClusterActor>, public ResetManagementClusterActorState<ResetManagementClusterActor> {
															#line 7100 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<ResetManagementClusterActor>::operator new;
	using FastAllocated<ResetManagementClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7469261874644171776UL, 14892016894022324736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ResetManagementClusterActor, 0, Void >;
friend struct ActorCallback< ResetManagementClusterActor, 1, Void >;
															#line 747 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	ResetManagementClusterActor(MetaclusterRestoreWorkload* const& self) 
															#line 7118 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ResetManagementClusterActorState<ResetManagementClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("resetManagementCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5235160532797520896UL, 17823830438448817408UL);
		ActorExecutionContextHelper __helper(static_cast<ResetManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("resetManagementCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("resetManagementCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ResetManagementClusterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ResetManagementClusterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 747 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> resetManagementCluster( MetaclusterRestoreWorkload* const& self ) {
															#line 747 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<Void>(new ResetManagementClusterActor(self));
															#line 7151 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 763 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

																#line 7156 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via createTenant()
															#line 764 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class CreateTenantActor>
															#line 764 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class CreateTenantActorState {
															#line 7162 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 764 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	CreateTenantActorState(MetaclusterRestoreWorkload* const& self,RestoreTenantData::AccessTime const& createTime) 
															#line 764 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 764 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : self(self),
															#line 764 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   createTime(createTime),
															#line 765 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   tenantName()
															#line 7173 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("createTenant", reinterpret_cast<unsigned long>(this));

	}
	~CreateTenantActorState() 
	{
		fdb_probe_actor_destroy("createTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 766 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			for(int i = 0;i < 10;++i) {
															#line 767 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				tenantName = self->chooseTenantName();
															#line 768 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (!self->tenantNameIndex.contains(tenantName))
															#line 7192 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				{
					break;
				}
			}
															#line 773 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (self->tenantNameIndex.contains(tenantName))
															#line 7199 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 774 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 7203 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CreateTenantActorState();
				static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 777 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			;
															#line 7211 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 779 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			metacluster::MetaclusterTenantMapEntry tenantEntry;
															#line 780 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tenantEntry.tenantName = tenantName;
															#line 781 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tenantEntry.tenantGroup = self->chooseTenantGroup();
															#line 782 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = metacluster::createTenant(self->managementDb, tenantEntry, metacluster::AssignClusterAutomatically::True, metacluster::IgnoreCapacityLimit::False);
															#line 782 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7250 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 1;
															#line 782 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 0, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 7255 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 805 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (e.code() != error_code_metacluster_no_capacity)
															#line 7277 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 806 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7281 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
															#line 809 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = increaseMetaclusterCapacity(self);
															#line 809 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7287 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 3;
															#line 809 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 2, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 7292 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 786 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<metacluster::MetaclusterTenantMapEntry> __when_expr_1 = metacluster::getTenant(self->managementDb, tenantName);
															#line 786 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7309 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateTenantActor*>(this)->actor_wait_state = 2;
															#line 786 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 1, metacluster::MetaclusterTenantMapEntry >*>(static_cast<CreateTenantActor*>(this)));
															#line 7314 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 786 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<metacluster::MetaclusterTenantMapEntry> __when_expr_1 = metacluster::getTenant(self->managementDb, tenantName);
															#line 786 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7325 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateTenantActor*>(this)->actor_wait_state = 2;
															#line 786 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 1, metacluster::MetaclusterTenantMapEntry >*>(static_cast<CreateTenantActor*>(this)));
															#line 7330 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(metacluster::MetaclusterTenantMapEntry const& createdEntry,int loopDepth) 
	{
															#line 788 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterRestoreWorkloadCreatedTenant") .detail("Tenant", tenantName) .detail("TenantId", createdEntry.id) .detail("AccessTime", createTime);
															#line 792 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->createdTenants[createdEntry.id] = RestoreTenantData(tenantName, createdEntry.assignedCluster, createdEntry.tenantGroup, createTime);
															#line 794 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->tenantNameIndex[tenantName] = createdEntry.id;
															#line 795 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		auto& dataDb = self->dataDbs[createdEntry.assignedCluster];
															#line 796 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		dataDb.tenants.insert(createdEntry.id);
															#line 797 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (createdEntry.tenantGroup.present())
															#line 7424 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 798 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			auto& tenantGroupData = self->tenantGroups[createdEntry.tenantGroup.get()];
															#line 799 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tenantGroupData.cluster = createdEntry.assignedCluster;
															#line 800 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tenantGroupData.tenants.insert(createdEntry.id);
															#line 801 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			dataDb.tenantGroups.insert(createdEntry.tenantGroup.get());
															#line 7434 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 803 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 7438 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(metacluster::MetaclusterTenantMapEntry && createdEntry,int loopDepth) 
	{
															#line 788 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterRestoreWorkloadCreatedTenant") .detail("Tenant", tenantName) .detail("TenantId", createdEntry.id) .detail("AccessTime", createTime);
															#line 792 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->createdTenants[createdEntry.id] = RestoreTenantData(tenantName, createdEntry.assignedCluster, createdEntry.tenantGroup, createTime);
															#line 794 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->tenantNameIndex[tenantName] = createdEntry.id;
															#line 795 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		auto& dataDb = self->dataDbs[createdEntry.assignedCluster];
															#line 796 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		dataDb.tenants.insert(createdEntry.id);
															#line 797 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (createdEntry.tenantGroup.present())
															#line 7460 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 798 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			auto& tenantGroupData = self->tenantGroups[createdEntry.tenantGroup.get()];
															#line 799 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tenantGroupData.cluster = createdEntry.assignedCluster;
															#line 800 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tenantGroupData.tenants.insert(createdEntry.id);
															#line 801 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			dataDb.tenantGroups.insert(createdEntry.tenantGroup.get());
															#line 7470 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 803 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 7474 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(metacluster::MetaclusterTenantMapEntry const& createdEntry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(createdEntry, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(metacluster::MetaclusterTenantMapEntry && createdEntry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(createdEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 1, metacluster::MetaclusterTenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 1, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 1, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 1, metacluster::MetaclusterTenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 764 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 764 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	RestoreTenantData::AccessTime createTime;
															#line 765 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	TenantName tenantName;
															#line 7650 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via createTenant()
															#line 764 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class CreateTenantActor final : public Actor<Void>, public ActorCallback< CreateTenantActor, 0, Void >, public ActorCallback< CreateTenantActor, 1, metacluster::MetaclusterTenantMapEntry >, public ActorCallback< CreateTenantActor, 2, Void >, public FastAllocated<CreateTenantActor>, public CreateTenantActorState<CreateTenantActor> {
															#line 7655 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<CreateTenantActor>::operator new;
	using FastAllocated<CreateTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2423787026040465664UL, 8359583085912275200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateTenantActor, 0, Void >;
friend struct ActorCallback< CreateTenantActor, 1, metacluster::MetaclusterTenantMapEntry >;
friend struct ActorCallback< CreateTenantActor, 2, Void >;
															#line 764 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	CreateTenantActor(MetaclusterRestoreWorkload* const& self,RestoreTenantData::AccessTime const& createTime) 
															#line 7674 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   CreateTenantActorState<CreateTenantActor>(self, createTime),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2480746510970185984UL, 428737674404862208UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateTenantActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateTenantActor, 1, metacluster::MetaclusterTenantMapEntry >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateTenantActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 764 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> createTenant( MetaclusterRestoreWorkload* const& self, RestoreTenantData::AccessTime const& createTime ) {
															#line 764 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<Void>(new CreateTenantActor(self, createTime));
															#line 7708 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 813 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

																#line 7713 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via deleteTenant()
															#line 814 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class DeleteTenantActor>
															#line 814 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class DeleteTenantActorState {
															#line 7719 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 814 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	DeleteTenantActorState(MetaclusterRestoreWorkload* const& self,RestoreTenantData::AccessTime const& accessTime) 
															#line 814 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 814 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : self(self),
															#line 814 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   accessTime(accessTime),
															#line 815 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   tenantName()
															#line 7730 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteTenant", reinterpret_cast<unsigned long>(this));

	}
	~DeleteTenantActorState() 
	{
		fdb_probe_actor_destroy("deleteTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 816 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			for(int i = 0;i < 10;++i) {
															#line 817 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				tenantName = self->chooseTenantName();
															#line 818 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (self->tenantNameIndex.contains(tenantName))
															#line 7749 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				{
					break;
				}
			}
															#line 823 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (!self->tenantNameIndex.contains(tenantName))
															#line 7756 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 824 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 7760 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DeleteTenantActorState();
				static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 827 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tenantId = self->tenantNameIndex[tenantName];
															#line 829 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterRestoreWorkloadDeleteTenant") .detail("Tenant", tenantName) .detail("TenantId", tenantId) .detail("AccessTime", accessTime);
															#line 833 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = metacluster::deleteTenant(self->managementDb, tenantName);
															#line 833 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7774 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteTenantActor*>(this)->actor_wait_state = 1;
															#line 833 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 0, Void >*>(static_cast<DeleteTenantActor*>(this)));
															#line 7779 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteTenantActorState();
		static_cast<DeleteTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 834 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		auto const& tenantData = self->createdTenants[tenantId];
															#line 836 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		auto& dataDb = self->dataDbs[tenantData.cluster];
															#line 837 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		dataDb.tenants.erase(tenantId);
															#line 838 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (tenantData.tenantGroup.present())
															#line 7808 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 839 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			auto groupItr = self->tenantGroups.find(tenantData.tenantGroup.get());
															#line 840 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			groupItr->second.tenants.erase(tenantId);
															#line 841 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (groupItr->second.tenants.empty())
															#line 7816 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 842 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				self->tenantGroups.erase(groupItr);
															#line 843 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				dataDb.tenantGroups.erase(tenantData.tenantGroup.get());
															#line 7822 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
		}
															#line 847 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->createdTenants.erase(tenantId);
															#line 848 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->tenantNameIndex.erase(tenantName);
															#line 849 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->deletedTenants.insert(tenantId);
															#line 851 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 7833 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantActorState();
		static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 834 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		auto const& tenantData = self->createdTenants[tenantId];
															#line 836 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		auto& dataDb = self->dataDbs[tenantData.cluster];
															#line 837 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		dataDb.tenants.erase(tenantId);
															#line 838 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (tenantData.tenantGroup.present())
															#line 7851 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 839 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			auto groupItr = self->tenantGroups.find(tenantData.tenantGroup.get());
															#line 840 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			groupItr->second.tenants.erase(tenantId);
															#line 841 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (groupItr->second.tenants.empty())
															#line 7859 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 842 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				self->tenantGroups.erase(groupItr);
															#line 843 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				dataDb.tenantGroups.erase(tenantData.tenantGroup.get());
															#line 7865 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
		}
															#line 847 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->createdTenants.erase(tenantId);
															#line 848 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->tenantNameIndex.erase(tenantName);
															#line 849 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->deletedTenants.insert(tenantId);
															#line 851 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 7876 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantActorState();
		static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 814 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 814 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	RestoreTenantData::AccessTime accessTime;
															#line 815 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	TenantName tenantName;
															#line 827 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	int64_t tenantId;
															#line 7967 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via deleteTenant()
															#line 814 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class DeleteTenantActor final : public Actor<Void>, public ActorCallback< DeleteTenantActor, 0, Void >, public FastAllocated<DeleteTenantActor>, public DeleteTenantActorState<DeleteTenantActor> {
															#line 7972 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<DeleteTenantActor>::operator new;
	using FastAllocated<DeleteTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18206267413836436224UL, 15620603918041410816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteTenantActor, 0, Void >;
															#line 814 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	DeleteTenantActor(MetaclusterRestoreWorkload* const& self,RestoreTenantData::AccessTime const& accessTime) 
															#line 7989 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteTenantActorState<DeleteTenantActor>(self, accessTime),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14546017859301560576UL, 18123705475076122368UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteTenantActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 814 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> deleteTenant( MetaclusterRestoreWorkload* const& self, RestoreTenantData::AccessTime const& accessTime ) {
															#line 814 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<Void>(new DeleteTenantActor(self, accessTime));
															#line 8021 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 853 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

																#line 8026 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via configureTenant()
															#line 854 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class ConfigureTenantActor>
															#line 854 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class ConfigureTenantActorState {
															#line 8032 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 854 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	ConfigureTenantActorState(MetaclusterRestoreWorkload* const& self,RestoreTenantData::AccessTime const& accessTime) 
															#line 854 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 854 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : self(self),
															#line 854 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   accessTime(accessTime),
															#line 856 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   tenantName()
															#line 8043 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("configureTenant", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureTenantActorState() 
	{
		fdb_probe_actor_destroy("configureTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 857 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			for(int i = 0;i < 10;++i) {
															#line 858 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				tenantName = self->chooseTenantName();
															#line 859 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (self->tenantNameIndex.contains(tenantName))
															#line 8062 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				{
					break;
				}
			}
															#line 864 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (!self->tenantNameIndex.contains(tenantName))
															#line 8069 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 865 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 8073 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ConfigureTenantActorState();
				static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 868 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tenantId = self->tenantNameIndex[tenantName];
															#line 870 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tenantGroup = self->chooseTenantGroup(self->createdTenants[tenantId].cluster);
															#line 871 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			configurationParams = { { "tenant_group"_sr, tenantGroup } };
															#line 874 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			;
															#line 8087 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureTenantActorState();
		static_cast<ConfigureTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 876 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = metacluster::configureTenant( self->managementDb, tenantName, configurationParams, metacluster::IgnoreCapacityLimit::False);
															#line 876 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8120 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 1;
															#line 876 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantActor, 0, Void >*>(static_cast<ConfigureTenantActor*>(this)));
															#line 8125 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 909 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (e.code() != error_code_cluster_no_capacity)
															#line 8147 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 910 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 8151 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
															#line 913 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = increaseMetaclusterCapacity(self);
															#line 913 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8157 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 2;
															#line 913 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantActor, 1, Void >*>(static_cast<ConfigureTenantActor*>(this)));
															#line 8162 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 879 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		auto& tenantData = self->createdTenants[tenantId];
															#line 881 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterRestoreWorkloadConfigureTenant") .detail("Tenant", tenantName) .detail("TenantId", tenantId) .detail("OldTenantGroup", tenantData.tenantGroup) .detail("NewTenantGroup", tenantGroup) .detail("AccessTime", accessTime);
															#line 888 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (tenantData.tenantGroup != tenantGroup)
															#line 8181 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 889 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			auto& dataDb = self->dataDbs[tenantData.cluster];
															#line 890 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (tenantData.tenantGroup.present())
															#line 8187 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 891 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				auto groupItr = self->tenantGroups.find(tenantData.tenantGroup.get());
															#line 892 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				groupItr->second.tenants.erase(tenantId);
															#line 893 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (groupItr->second.tenants.empty())
															#line 8195 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				{
															#line 894 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					self->tenantGroups.erase(groupItr);
															#line 895 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					dataDb.tenantGroups.erase(tenantData.tenantGroup.get());
															#line 8201 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				}
			}
															#line 899 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (tenantGroup.present())
															#line 8206 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 900 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				self->tenantGroups[tenantGroup.get()].tenants.insert(tenantId);
															#line 901 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				dataDb.tenantGroups.insert(tenantGroup.get());
															#line 8212 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
															#line 904 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tenantData.tenantGroup = tenantGroup;
															#line 905 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tenantData.configureTime = accessTime;
															#line 8218 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 907 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 8222 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureTenantActorState();
		static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 879 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		auto& tenantData = self->createdTenants[tenantId];
															#line 881 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterRestoreWorkloadConfigureTenant") .detail("Tenant", tenantName) .detail("TenantId", tenantId) .detail("OldTenantGroup", tenantData.tenantGroup) .detail("NewTenantGroup", tenantGroup) .detail("AccessTime", accessTime);
															#line 888 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (tenantData.tenantGroup != tenantGroup)
															#line 8238 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 889 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			auto& dataDb = self->dataDbs[tenantData.cluster];
															#line 890 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (tenantData.tenantGroup.present())
															#line 8244 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 891 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				auto groupItr = self->tenantGroups.find(tenantData.tenantGroup.get());
															#line 892 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				groupItr->second.tenants.erase(tenantId);
															#line 893 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (groupItr->second.tenants.empty())
															#line 8252 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				{
															#line 894 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					self->tenantGroups.erase(groupItr);
															#line 895 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					dataDb.tenantGroups.erase(tenantData.tenantGroup.get());
															#line 8258 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				}
			}
															#line 899 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (tenantGroup.present())
															#line 8263 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 900 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				self->tenantGroups[tenantGroup.get()].tenants.insert(tenantId);
															#line 901 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				dataDb.tenantGroups.insert(tenantGroup.get());
															#line 8269 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
															#line 904 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tenantData.tenantGroup = tenantGroup;
															#line 905 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tenantData.configureTime = accessTime;
															#line 8275 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 907 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 8279 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureTenantActorState();
		static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state > 0) static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureTenantActor*>(this)->ActorCallback< ConfigureTenantActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureTenantActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state > 0) static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureTenantActor*>(this)->ActorCallback< ConfigureTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConfigureTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 854 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 854 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	RestoreTenantData::AccessTime accessTime;
															#line 856 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	TenantName tenantName;
															#line 868 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	int64_t tenantId;
															#line 870 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Optional<TenantGroupName> tenantGroup;
															#line 871 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	std::map<Standalone<StringRef>, Optional<Value>> configurationParams;
															#line 8461 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via configureTenant()
															#line 854 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class ConfigureTenantActor final : public Actor<Void>, public ActorCallback< ConfigureTenantActor, 0, Void >, public ActorCallback< ConfigureTenantActor, 1, Void >, public FastAllocated<ConfigureTenantActor>, public ConfigureTenantActorState<ConfigureTenantActor> {
															#line 8466 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<ConfigureTenantActor>::operator new;
	using FastAllocated<ConfigureTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17593094824911073792UL, 10667247405616953344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureTenantActor, 0, Void >;
friend struct ActorCallback< ConfigureTenantActor, 1, Void >;
															#line 854 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	ConfigureTenantActor(MetaclusterRestoreWorkload* const& self,RestoreTenantData::AccessTime const& accessTime) 
															#line 8484 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ConfigureTenantActorState<ConfigureTenantActor>(self, accessTime),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7048885742222706688UL, 1739664772098993408UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureTenantActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConfigureTenantActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 854 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> configureTenant( MetaclusterRestoreWorkload* const& self, RestoreTenantData::AccessTime const& accessTime ) {
															#line 854 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<Void>(new ConfigureTenantActor(self, accessTime));
															#line 8517 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 917 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

																#line 8522 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via renameTenant()
															#line 918 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class RenameTenantActor>
															#line 918 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class RenameTenantActorState {
															#line 8528 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 918 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	RenameTenantActorState(MetaclusterRestoreWorkload* const& self,RestoreTenantData::AccessTime const& accessTime) 
															#line 918 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 918 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : self(self),
															#line 918 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   accessTime(accessTime),
															#line 919 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   oldTenantName(),
															#line 920 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   newTenantName()
															#line 8541 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("renameTenant", reinterpret_cast<unsigned long>(this));

	}
	~RenameTenantActorState() 
	{
		fdb_probe_actor_destroy("renameTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 921 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			for(int i = 0;i < 10;++i) {
															#line 922 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				oldTenantName = self->chooseTenantName();
															#line 923 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (self->tenantNameIndex.contains(oldTenantName))
															#line 8560 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				{
					break;
				}
			}
															#line 927 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			for(int i = 0;i < 10;++i) {
															#line 928 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				newTenantName = self->chooseTenantName();
															#line 929 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (!self->tenantNameIndex.contains(newTenantName))
															#line 8571 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				{
					break;
				}
			}
															#line 934 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (!self->tenantNameIndex.contains(oldTenantName) || self->tenantNameIndex.contains(newTenantName))
															#line 8578 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 935 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 8582 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RenameTenantActorState();
				static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 938 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tenantId = self->tenantNameIndex[oldTenantName];
															#line 940 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterRestoreWorkloadRenameTenant") .detail("OldTenantName", oldTenantName) .detail("NewTenantName", newTenantName) .detail("TenantId", tenantId) .detail("AccessTime", accessTime);
															#line 945 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = metacluster::renameTenant(self->managementDb, oldTenantName, newTenantName);
															#line 945 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8596 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RenameTenantActor*>(this)->actor_wait_state = 1;
															#line 945 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 0, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 8601 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 947 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		RestoreTenantData& tenantData = self->createdTenants[tenantId];
															#line 948 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		tenantData.name = newTenantName;
															#line 949 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		tenantData.renameTime = accessTime;
															#line 950 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->tenantNameIndex[newTenantName] = tenantId;
															#line 951 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->tenantNameIndex.erase(oldTenantName);
															#line 953 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 8634 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 947 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		RestoreTenantData& tenantData = self->createdTenants[tenantId];
															#line 948 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		tenantData.name = newTenantName;
															#line 949 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		tenantData.renameTime = accessTime;
															#line 950 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->tenantNameIndex[newTenantName] = tenantId;
															#line 951 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->tenantNameIndex.erase(oldTenantName);
															#line 953 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 8656 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 918 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 918 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	RestoreTenantData::AccessTime accessTime;
															#line 919 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	TenantName oldTenantName;
															#line 920 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	TenantName newTenantName;
															#line 938 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	int64_t tenantId;
															#line 8749 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via renameTenant()
															#line 918 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class RenameTenantActor final : public Actor<Void>, public ActorCallback< RenameTenantActor, 0, Void >, public FastAllocated<RenameTenantActor>, public RenameTenantActorState<RenameTenantActor> {
															#line 8754 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<RenameTenantActor>::operator new;
	using FastAllocated<RenameTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7637491318954393344UL, 136538565966353920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RenameTenantActor, 0, Void >;
															#line 918 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	RenameTenantActor(MetaclusterRestoreWorkload* const& self,RestoreTenantData::AccessTime const& accessTime) 
															#line 8771 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RenameTenantActorState<RenameTenantActor>(self, accessTime),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(972264867922354944UL, 1896563828629082368UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("renameTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RenameTenantActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 918 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> renameTenant( MetaclusterRestoreWorkload* const& self, RestoreTenantData::AccessTime const& accessTime ) {
															#line 918 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<Void>(new RenameTenantActor(self, accessTime));
															#line 8803 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 955 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

																#line 8808 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via runOperations()
															#line 956 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class RunOperationsActor>
															#line 956 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class RunOperationsActorState {
															#line 8814 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 956 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	RunOperationsActorState(MetaclusterRestoreWorkload* const& self) 
															#line 956 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 956 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : self(self)
															#line 8821 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("runOperations", reinterpret_cast<unsigned long>(this));

	}
	~RunOperationsActorState() 
	{
		fdb_probe_actor_destroy("runOperations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 957 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			;
															#line 8836 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunOperationsActorState();
		static_cast<RunOperationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 973 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<RunOperationsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunOperationsActorState(); static_cast<RunOperationsActor*>(this)->destroy(); return 0; }
															#line 8859 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<RunOperationsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunOperationsActorState();
		static_cast<RunOperationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 957 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!(now() < self->endTime))
															#line 8878 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 958 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		operation = deterministicRandom()->randomInt(0, 4);
															#line 959 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		accessTime = self->backupComplete ? RestoreTenantData::AccessTime::AFTER_BACKUP : RestoreTenantData::AccessTime::DURING_BACKUP;
															#line 962 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (operation == 0)
															#line 8888 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 963 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = createTenant(self, accessTime);
															#line 963 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<RunOperationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8894 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunOperationsActor*>(this)->actor_wait_state = 1;
															#line 963 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunOperationsActor, 0, Void >*>(static_cast<RunOperationsActor*>(this)));
															#line 8899 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 964 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (operation == 1)
															#line 8906 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 965 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_1 = deleteTenant(self, accessTime);
															#line 965 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (static_cast<RunOperationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8912 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<RunOperationsActor*>(this)->actor_wait_state = 2;
															#line 965 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunOperationsActor, 1, Void >*>(static_cast<RunOperationsActor*>(this)));
															#line 8917 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 966 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (operation == 2)
															#line 8924 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				{
															#line 967 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_2 = configureTenant(self, accessTime);
															#line 967 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					if (static_cast<RunOperationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8930 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
					static_cast<RunOperationsActor*>(this)->actor_wait_state = 3;
															#line 967 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunOperationsActor, 2, Void >*>(static_cast<RunOperationsActor*>(this)));
															#line 8935 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 968 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					if (operation == 3)
															#line 8942 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
					{
															#line 969 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_3 = renameTenant(self, accessTime);
															#line 969 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
						if (static_cast<RunOperationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8948 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.get(), loopDepth); };
						static_cast<RunOperationsActor*>(this)->actor_wait_state = 4;
															#line 969 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunOperationsActor, 3, Void >*>(static_cast<RunOperationsActor*>(this)));
															#line 8953 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1loopBody1cont8(loopDepth);
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunOperationsActor*>(this)->actor_wait_state > 0) static_cast<RunOperationsActor*>(this)->actor_wait_state = 0;
		static_cast<RunOperationsActor*>(this)->ActorCallback< RunOperationsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunOperationsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runOperations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runOperations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunOperationsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runOperations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runOperations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunOperationsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runOperations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runOperations", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunOperationsActor*>(this)->actor_wait_state > 0) static_cast<RunOperationsActor*>(this)->actor_wait_state = 0;
		static_cast<RunOperationsActor*>(this)->ActorCallback< RunOperationsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunOperationsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runOperations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runOperations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunOperationsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runOperations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runOperations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunOperationsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runOperations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runOperations", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunOperationsActor*>(this)->actor_wait_state > 0) static_cast<RunOperationsActor*>(this)->actor_wait_state = 0;
		static_cast<RunOperationsActor*>(this)->ActorCallback< RunOperationsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunOperationsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runOperations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runOperations", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunOperationsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runOperations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runOperations", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunOperationsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runOperations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runOperations", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunOperationsActor*>(this)->actor_wait_state > 0) static_cast<RunOperationsActor*>(this)->actor_wait_state = 0;
		static_cast<RunOperationsActor*>(this)->ActorCallback< RunOperationsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunOperationsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runOperations", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runOperations", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunOperationsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runOperations", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runOperations", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunOperationsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runOperations", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runOperations", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 956 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 958 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	int operation;
															#line 959 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	RestoreTenantData::AccessTime accessTime;
															#line 9357 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via runOperations()
															#line 956 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class RunOperationsActor final : public Actor<Void>, public ActorCallback< RunOperationsActor, 0, Void >, public ActorCallback< RunOperationsActor, 1, Void >, public ActorCallback< RunOperationsActor, 2, Void >, public ActorCallback< RunOperationsActor, 3, Void >, public FastAllocated<RunOperationsActor>, public RunOperationsActorState<RunOperationsActor> {
															#line 9362 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<RunOperationsActor>::operator new;
	using FastAllocated<RunOperationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14702011949134704384UL, 17441347236658714112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunOperationsActor, 0, Void >;
friend struct ActorCallback< RunOperationsActor, 1, Void >;
friend struct ActorCallback< RunOperationsActor, 2, Void >;
friend struct ActorCallback< RunOperationsActor, 3, Void >;
															#line 956 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	RunOperationsActor(MetaclusterRestoreWorkload* const& self) 
															#line 9382 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RunOperationsActorState<RunOperationsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runOperations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4631979979997647104UL, 10826109447390800384UL);
		ActorExecutionContextHelper __helper(static_cast<RunOperationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runOperations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runOperations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunOperationsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunOperationsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunOperationsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunOperationsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 956 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> runOperations( MetaclusterRestoreWorkload* const& self ) {
															#line 956 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<Void>(new RunOperationsActor(self));
															#line 9417 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 975 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (clientId == 0) {
			return _start(cx, this);
		} else {
			return Void();
		}
	}
																#line 9429 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 983 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class _startActor>
															#line 983 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class _startActorState {
															#line 9435 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 983 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	_startActorState(Database const& cx,MetaclusterRestoreWorkload* const& self) 
															#line 983 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 983 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : cx(cx),
															#line 983 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   self(self),
															#line 984 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   clustersToRestore()
															#line 9446 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 986 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			TraceEvent("MetaclusterRestoreWorkloadStart") .detail("RecoverManagementCluster", self->recoverManagementCluster) .detail("RecoverDataClusters", self->recoverDataClusters);
															#line 990 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (self->recoverDataClusters)
															#line 9463 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 991 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				for( auto db : self->dataDbIndex ) {
															#line 992 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					if (deterministicRandom()->random01() < 0.1)
															#line 9469 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
					{
															#line 993 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
						clustersToRestore.insert(db);
															#line 9473 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
					}
				}
															#line 997 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (clustersToRestore.empty())
															#line 9478 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				{
															#line 998 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					clustersToRestore.insert(deterministicRandom()->randomChoice(self->dataDbIndex));
															#line 9482 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				}
															#line 1001 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				for( auto c : clustersToRestore ) {
															#line 1002 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					TraceEvent("MetaclusterRestoreWorkloadChoseClusterForRestore").detail("ClusterName", c);
															#line 9488 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				}
			}
															#line 1006 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			opsFuture = runOperations(self);
															#line 1008 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			backups = std::map<ClusterName, Future<std::string>>();
															#line 1009 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			for( auto cluster : clustersToRestore ) {
															#line 1010 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				backups[cluster] = backupCluster(cluster, self->dataDbs[cluster].db, self);
															#line 9499 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
															#line 1013 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			RangeForbody1Iterator0 = std::begin(backups);
															#line 9503 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1017 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->backupComplete = true;
															#line 1018 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->endTime = now() + self->postBackupDuration;
															#line 1020 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = opsFuture;
															#line 1020 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9532 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 1020 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 9537 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1013 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!(RangeForbody1Iterator0 != std::end(backups)))
															#line 9553 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1013 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		auto [_, f] = *RangeForbody1Iterator0;
															#line 9559 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 1014 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(f);
															#line 1014 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9565 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 1014 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 9570 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1013 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		++RangeForbody1Iterator0;
															#line 9593 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 1021 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadOperationsComplete");
															#line 1023 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (self->recoverManagementCluster)
															#line 9691 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 1024 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = resetManagementCluster(self);
															#line 1024 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9697 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont8when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 1024 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 9702 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1026 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>>> __when_expr_3 = runTransaction(self->managementDb, [](Reference<ITransaction> tr) { return metacluster::metadata::management::tenantMetadata().tenantMap.getRange( tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1); });
															#line 1026 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9711 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when2(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 1026 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*>(static_cast<_startActor*>(this)));
															#line 9716 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 1021 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		TraceEvent("MetaclusterRestoreWorkloadOperationsComplete");
															#line 1023 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (self->recoverManagementCluster)
															#line 9728 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 1024 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = resetManagementCluster(self);
															#line 1024 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9734 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont8when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 1024 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 9739 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1026 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>>> __when_expr_3 = runTransaction(self->managementDb, [](Reference<ITransaction> tr) { return metacluster::metadata::management::tenantMetadata().tenantMap.getRange( tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1); });
															#line 1026 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9748 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when2(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 1026 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*>(static_cast<_startActor*>(this)));
															#line 9753 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 1035 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		std::vector<Future<Void>> restores;
															#line 1036 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto [cluster, backupUrl] : backups ) {
															#line 1037 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			restores.push_back(restoreDataCluster(cluster, self->dataDbs[cluster].db, backupUrl.get(), !self->recoverManagementCluster, metacluster::ForceJoin(deterministicRandom()->coinflip()), backups.size(), self));
															#line 9842 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 1046 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = waitForAll(restores);
															#line 1046 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9848 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont9when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 1046 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 9853 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11(KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> const& tenants,int loopDepth) 
	{
															#line 1031 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT_LE(tenants.results.size(), CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 1032 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->managementTenantsBeforeRestore = tenants.results;
															#line 9951 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> && tenants,int loopDepth) 
	{
															#line 1031 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT_LE(tenants.results.size(), CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 1032 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		self->managementTenantsBeforeRestore = tenants.results;
															#line 9962 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when2(KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> const& tenants,int loopDepth) 
	{
		loopDepth = a_body1cont11(tenants, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when2(KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> && tenants,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(tenants), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 1048 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (self->recoverManagementCluster)
															#line 10046 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 1049 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_5 = restoreManagementCluster(self);
															#line 1049 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10052 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12when1(__when_expr_5.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 1049 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 10057 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 1048 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (self->recoverManagementCluster)
															#line 10071 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 1049 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_5 = restoreManagementCluster(self);
															#line 1049 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10077 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12when1(__when_expr_5.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 1049 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 10082 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
															#line 1066 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 10171 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont2(Void const& _,int loopDepth) 
	{
															#line 1051 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 10183 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 1052 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			std::vector<Future<Void>> secondRestores;
															#line 1053 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			for( auto [cluster, backupUrl] : backups ) {
															#line 1054 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				secondRestores.push_back(restoreDataCluster(cluster, self->dataDbs[cluster].db, backupUrl.get(), true, metacluster::ForceJoin::True, backups.size(), self));
															#line 10191 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
															#line 1062 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_6 = waitForAll(secondRestores);
															#line 1062 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10197 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont12cont2when1(__when_expr_6.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 1062 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 10202 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont2(Void && _,int loopDepth) 
	{
															#line 1051 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 10216 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 1052 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			std::vector<Future<Void>> secondRestores;
															#line 1053 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			for( auto [cluster, backupUrl] : backups ) {
															#line 1054 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				secondRestores.push_back(restoreDataCluster(cluster, self->dataDbs[cluster].db, backupUrl.get(), true, metacluster::ForceJoin::True, backups.size(), self));
															#line 10224 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
															#line 1062 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_6 = waitForAll(secondRestores);
															#line 1062 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10230 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont12cont2when1(__when_expr_6.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 1062 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 10235 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12cont3(int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 983 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Database cx;
															#line 983 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 984 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	std::set<ClusterName> clustersToRestore;
															#line 1006 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Future<Void> opsFuture;
															#line 1008 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	std::map<ClusterName, Future<std::string>> backups;
															#line 1013 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	decltype(std::begin(std::declval<std::map<ClusterName, Future<std::string>>>())) RangeForbody1Iterator0;
															#line 10425 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 983 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 10430 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17192367917071724544UL, 15058012217089176832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
															#line 983 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	_startActor(Database const& cx,MetaclusterRestoreWorkload* const& self) 
															#line 10453 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 983 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, MetaclusterRestoreWorkload* const& self ) {
															#line 983 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 10491 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 1068 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

	// Checks that the data cluster state matches our local state
																#line 10497 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via checkDataCluster()
															#line 1070 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class CheckDataClusterActor>
															#line 1070 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class CheckDataClusterActorState {
															#line 10503 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 1070 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	CheckDataClusterActorState(MetaclusterRestoreWorkload* const& self,ClusterName const& clusterName,DataClusterData const& clusterData) 
															#line 1070 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 1070 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : self(self),
															#line 1070 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   clusterName(clusterName),
															#line 1070 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   clusterData(clusterData),
															#line 1073 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   metaclusterRegistration(),
															#line 1074 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   tenants(),
															#line 1075 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   tr(clusterData.db->createTransaction())
															#line 10520 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("checkDataCluster", reinterpret_cast<unsigned long>(this));

	}
	~CheckDataClusterActorState() 
	{
		fdb_probe_actor_destroy("checkDataCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1077 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			;
															#line 10535 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckDataClusterActorState();
		static_cast<CheckDataClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1089 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT_LE(tenants.results.size(), CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 1091 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT(metaclusterRegistration.present() && metaclusterRegistration.get().clusterType == ClusterType::METACLUSTER_DATA);
															#line 1094 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!clusterData.restored)
															#line 10562 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 1095 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ASSERT_EQ(tenants.results.size(), clusterData.tenants.size());
															#line 1096 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			for( auto [tenantId, tenantEntry] : tenants.results ) {
															#line 1097 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT(clusterData.tenants.contains(tenantId));
															#line 1098 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				auto tenantData = self->createdTenants[tenantId];
															#line 1099 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT(tenantData.cluster == clusterName);
															#line 1100 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT(tenantData.tenantGroup == tenantEntry.tenantGroup);
															#line 1101 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT(tenantData.name == tenantEntry.tenantName);
															#line 10578 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
		}
		else
		{
															#line 1104 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			int expectedTenantCount = 0;
															#line 1105 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			std::map<int64_t, TenantMapEntry> tenantMap(tenants.results.begin(), tenants.results.end());
															#line 1106 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			for( auto tenantId : clusterData.tenants ) {
															#line 1107 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				RestoreTenantData tenantData = self->createdTenants[tenantId];
															#line 1108 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				auto tenantItr = tenantMap.find(tenantId);
															#line 1109 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (tenantData.createTime == RestoreTenantData::AccessTime::BEFORE_BACKUP)
															#line 10595 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				{
															#line 1110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					++expectedTenantCount;
															#line 1111 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					ASSERT(tenantItr != tenantMap.end());
															#line 1112 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					ASSERT(tenantData.cluster == clusterName);
															#line 1113 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					if (!self->recoverManagementCluster || tenantData.configureTime <= RestoreTenantData::AccessTime::BEFORE_BACKUP)
															#line 10605 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
					{
															#line 1115 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
						ASSERT(tenantItr->second.tenantGroup == tenantData.tenantGroup);
															#line 10609 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
					}
															#line 1117 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					if (!self->recoverManagementCluster || tenantData.renameTime <= RestoreTenantData::AccessTime::BEFORE_BACKUP)
															#line 10613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
					{
															#line 1119 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
						ASSERT(tenantItr->second.tenantName == tenantData.name);
															#line 10617 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
					}
				}
				else
				{
															#line 1121 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					if (tenantData.createTime == RestoreTenantData::AccessTime::AFTER_BACKUP)
															#line 10624 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
					{
															#line 1122 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
						ASSERT(tenantItr == tenantMap.end());
															#line 10628 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
					}
					else
					{
															#line 1123 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
						if (tenantItr != tenantMap.end())
															#line 10634 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
						{
															#line 1124 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
							++expectedTenantCount;
															#line 10638 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
						}
					}
				}
			}
															#line 1129 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			int unexpectedTenants = 0;
															#line 1130 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			for( auto const& [tenantId, tenantEntry] : tenantMap ) {
															#line 1131 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (!clusterData.tenants.contains(tenantId))
															#line 10649 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				{
															#line 1132 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					ASSERT(self->recoverManagementCluster);
															#line 1133 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					ASSERT(self->deletedTenants.contains(tenantId));
															#line 1134 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					++unexpectedTenants;
															#line 10657 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				}
			}
															#line 1138 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			CODE_PROBE(unexpectedTenants > 0, "Deleted tenants reappeared during metacluster restore");
															#line 1139 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ASSERT_EQ(tenantMap.size() - unexpectedTenants, expectedTenantCount);
															#line 10664 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 1142 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<CheckDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataClusterActorState(); static_cast<CheckDataClusterActor*>(this)->destroy(); return 0; }
															#line 10668 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<CheckDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckDataClusterActorState();
		static_cast<CheckDataClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1079 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1080 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(metaclusterRegistration, metacluster::metadata::metaclusterRegistration().get(tr)) && store(tenants, TenantMetadata::tenantMap().getRange(tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1));
															#line 1080 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<CheckDataClusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10692 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckDataClusterActor*>(this)->actor_wait_state = 1;
															#line 1080 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckDataClusterActor, 0, Void >*>(static_cast<CheckDataClusterActor*>(this)));
															#line 10697 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1086 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 1086 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<CheckDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10734 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckDataClusterActor*>(this)->actor_wait_state = 2;
															#line 1086 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckDataClusterActor, 1, Void >*>(static_cast<CheckDataClusterActor*>(this)));
															#line 10739 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckDataClusterActor*>(this)->actor_wait_state > 0) static_cast<CheckDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataClusterActor*>(this)->ActorCallback< CheckDataClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckDataClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckDataClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckDataClusterActor*>(this)->actor_wait_state > 0) static_cast<CheckDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataClusterActor*>(this)->ActorCallback< CheckDataClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckDataClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckDataClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1070 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 1070 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	ClusterName clusterName;
															#line 1070 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	DataClusterData clusterData;
															#line 1073 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Optional<MetaclusterRegistrationEntry> metaclusterRegistration;
															#line 1074 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> tenants;
															#line 1075 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 10936 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via checkDataCluster()
															#line 1070 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class CheckDataClusterActor final : public Actor<Void>, public ActorCallback< CheckDataClusterActor, 0, Void >, public ActorCallback< CheckDataClusterActor, 1, Void >, public FastAllocated<CheckDataClusterActor>, public CheckDataClusterActorState<CheckDataClusterActor> {
															#line 10941 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<CheckDataClusterActor>::operator new;
	using FastAllocated<CheckDataClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16506354143857808384UL, 11073434916433217280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckDataClusterActor, 0, Void >;
friend struct ActorCallback< CheckDataClusterActor, 1, Void >;
															#line 1070 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	CheckDataClusterActor(MetaclusterRestoreWorkload* const& self,ClusterName const& clusterName,DataClusterData const& clusterData) 
															#line 10959 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   CheckDataClusterActorState<CheckDataClusterActor>(self, clusterName, clusterData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkDataCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7796995959147916032UL, 12232873414231258624UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkDataCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkDataCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckDataClusterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckDataClusterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1070 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> checkDataCluster( MetaclusterRestoreWorkload* const& self, ClusterName const& clusterName, DataClusterData const& clusterData ) {
															#line 1070 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<Void>(new CheckDataClusterActor(self, clusterName, clusterData));
															#line 10992 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 1144 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

																#line 10997 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via checkTenants()
															#line 1145 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class CheckTenantsActor>
															#line 1145 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class CheckTenantsActorState {
															#line 11003 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 1145 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	CheckTenantsActorState(MetaclusterRestoreWorkload* const& self) 
															#line 1145 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 1145 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : self(self)
															#line 11010 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("checkTenants", reinterpret_cast<unsigned long>(this));

	}
	~CheckTenantsActorState() 
	{
		fdb_probe_actor_destroy("checkTenants", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1146 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>>> __when_expr_0 = runTransaction(self->managementDb, [](Reference<ITransaction> tr) { return metacluster::metadata::management::tenantMetadata().tenantMap.getRange( tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1); });
															#line 1146 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<CheckTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11027 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckTenantsActor*>(this)->actor_wait_state = 1;
															#line 1146 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckTenantsActor, 0, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*>(static_cast<CheckTenantsActor*>(this)));
															#line 11032 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckTenantsActorState();
		static_cast<CheckTenantsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1152 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		ASSERT_LE(tenants.results.size(), CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
															#line 1153 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		std::map<int64_t, metacluster::MetaclusterTenantMapEntry> tenantMap(tenants.results.begin(), tenants.results.end());
															#line 1160 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		tenantsInErrorState = std::set<TenantName>();
															#line 1161 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& [tenantId, tenantEntry] : self->managementTenantsBeforeRestore ) {
															#line 1162 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			auto itr = tenantMap.find(tenantId);
															#line 1163 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ASSERT(itr != tenantMap.end());
															#line 1165 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			metacluster::MetaclusterTenantMapEntry postRecoveryEntry = itr->second;
															#line 1166 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (postRecoveryEntry.tenantState == metacluster::TenantState::ERROR)
															#line 11069 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 1167 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT(self->dataDbs[itr->second.assignedCluster].restored);
															#line 1168 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				postRecoveryEntry.tenantState = tenantEntry.tenantState;
															#line 1169 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				postRecoveryEntry.error.clear();
															#line 1170 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				tenantsInErrorState.emplace(itr->second.tenantName);
															#line 11079 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
															#line 1173 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ASSERT(tenantEntry == postRecoveryEntry);
															#line 11083 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 1176 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!self->managementTenantsBeforeRestore.empty())
															#line 11087 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 1177 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ASSERT_EQ(self->managementTenantsBeforeRestore.size(), tenantMap.size());
															#line 11091 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 1180 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& [tenantId, tenantData] : self->createdTenants ) {
															#line 1181 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			auto tenantItr = tenantMap.find(tenantId);
															#line 1182 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (tenantItr == tenantMap.end())
															#line 11099 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 1185 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT_NE(tenantData.createTime, RestoreTenantData::AccessTime::BEFORE_BACKUP);
															#line 1186 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT(self->dataDbs[tenantData.cluster].restored && self->recoverManagementCluster);
															#line 1187 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				CODE_PROBE(true, "Tenant lost when recovering management and data cluster");
															#line 11107 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
			else
			{
															#line 1189 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				if (tenantData.createTime != RestoreTenantData::AccessTime::BEFORE_BACKUP && self->dataDbs[tenantData.cluster].restored)
															#line 11113 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				{
															#line 1191 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					ASSERT(tenantItr->second.tenantState == metacluster::TenantState::ERROR || (tenantItr->second.tenantState == metacluster::TenantState::READY && tenantData.createTime == RestoreTenantData::AccessTime::DURING_BACKUP));
															#line 1194 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					if (tenantItr->second.tenantState == metacluster::TenantState::ERROR)
															#line 11119 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
					{
															#line 1195 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
						ASSERT(self->dataDbs[tenantData.cluster].restoreHasMessages);
															#line 1196 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
						CODE_PROBE(true, "Tenant lost when recovering data cluster");
															#line 11125 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
					}
				}
				else
				{
															#line 1199 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
					ASSERT_EQ(tenantItr->second.tenantState, metacluster::TenantState::READY);
															#line 11132 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
				}
			}
		}
															#line 1206 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto const& [tenantId, tenantEntry] : tenantMap ) {
															#line 1207 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (!self->createdTenants.contains(tenantId))
															#line 11140 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 1208 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT(self->deletedTenants.contains(tenantId));
															#line 1209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT(self->recoverManagementCluster);
															#line 1210 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT(self->recoverDataClusters);
															#line 11148 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
		}
															#line 1214 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!tenantsInErrorState.empty())
															#line 11153 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		{
															#line 1215 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			CODE_PROBE(true, "One or more tenants in ERROR state");
															#line 1216 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			std::vector<Future<Void>> resetErrorFutures;
															#line 1217 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			for( const auto& tenantName : tenantsInErrorState ) {
															#line 1218 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				resetErrorFutures.emplace_back(metacluster::resetTenantStateToReady(self->managementDb, tenantName));
															#line 11163 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
															#line 1220 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitForAll(resetErrorFutures);
															#line 1220 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<CheckTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11169 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckTenantsActor*>(this)->actor_wait_state = 2;
															#line 1220 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckTenantsActor, 1, Void >*>(static_cast<CheckTenantsActor*>(this)));
															#line 11174 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> const& __tenants,int loopDepth) 
	{
															#line 1146 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		tenants = __tenants;
															#line 11188 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> && __tenants,int loopDepth) 
	{
		tenants = std::move(__tenants);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckTenantsActor*>(this)->actor_wait_state > 0) static_cast<CheckTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTenantsActor*>(this)->ActorCallback< CheckTenantsActor, 0, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTenantsActor, 0, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("checkTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckTenantsActor, 0, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("checkTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckTenantsActor, 0, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1243 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<CheckTenantsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckTenantsActorState(); static_cast<CheckTenantsActor*>(this)->destroy(); return 0; }
															#line 11267 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<CheckTenantsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckTenantsActorState();
		static_cast<CheckTenantsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
															#line 1221 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>>> __when_expr_2 = runTransaction(self->managementDb, [](Reference<ITransaction> tr) { tr->setOption(FDBTransactionOptions::RAW_ACCESS); return metacluster::metadata::management::tenantMetadata().tenantMap.getRange( tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1); });
															#line 1221 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<CheckTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11281 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont14when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckTenantsActor*>(this)->actor_wait_state = 3;
															#line 1221 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckTenantsActor, 2, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*>(static_cast<CheckTenantsActor*>(this)));
															#line 11286 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
															#line 1221 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>>> __when_expr_2 = runTransaction(self->managementDb, [](Reference<ITransaction> tr) { tr->setOption(FDBTransactionOptions::RAW_ACCESS); return metacluster::metadata::management::tenantMetadata().tenantMap.getRange( tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1); });
															#line 1221 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<CheckTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11297 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont14when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckTenantsActor*>(this)->actor_wait_state = 3;
															#line 1221 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckTenantsActor, 2, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*>(static_cast<CheckTenantsActor*>(this)));
															#line 11302 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckTenantsActor*>(this)->actor_wait_state > 0) static_cast<CheckTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTenantsActor*>(this)->ActorCallback< CheckTenantsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTenantsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckTenantsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckTenantsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont14cont1(KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> const& _tenants,int loopDepth) 
	{
															#line 1227 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( const auto& [tenantId, tenantEntry] : _tenants.results ) {
															#line 1228 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ASSERT(tenantEntry.tenantState != metacluster::TenantState::ERROR);
															#line 1229 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (tenantsInErrorState.contains(tenantEntry.tenantName))
															#line 11390 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 1230 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT_EQ(metacluster::TenantState::READY, tenantEntry.tenantState);
															#line 11394 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
		}
															#line 1235 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		std::vector<Future<Void>> deleteFutures;
															#line 1236 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( TenantName const& tenantName : tenantsInErrorState ) {
															#line 1237 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			deleteFutures.push_back(metacluster::deleteTenant(self->managementDb, tenantName));
															#line 11403 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 1240 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(deleteFutures);
															#line 1240 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<CheckTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11409 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont14cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckTenantsActor*>(this)->actor_wait_state = 4;
															#line 1240 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckTenantsActor, 3, Void >*>(static_cast<CheckTenantsActor*>(this)));
															#line 11414 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont1(KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> && _tenants,int loopDepth) 
	{
															#line 1227 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( const auto& [tenantId, tenantEntry] : _tenants.results ) {
															#line 1228 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			ASSERT(tenantEntry.tenantState != metacluster::TenantState::ERROR);
															#line 1229 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (tenantsInErrorState.contains(tenantEntry.tenantName))
															#line 11427 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			{
															#line 1230 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
				ASSERT_EQ(metacluster::TenantState::READY, tenantEntry.tenantState);
															#line 11431 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			}
		}
															#line 1235 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		std::vector<Future<Void>> deleteFutures;
															#line 1236 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( TenantName const& tenantName : tenantsInErrorState ) {
															#line 1237 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			deleteFutures.push_back(metacluster::deleteTenant(self->managementDb, tenantName));
															#line 11440 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 1240 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(deleteFutures);
															#line 1240 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<CheckTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11446 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont14cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckTenantsActor*>(this)->actor_wait_state = 4;
															#line 1240 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckTenantsActor, 3, Void >*>(static_cast<CheckTenantsActor*>(this)));
															#line 11451 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14when1(KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> const& _tenants,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1(_tenants, loopDepth);

		return loopDepth;
	}
	int a_body1cont14when1(KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> && _tenants,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1(std::move(_tenants), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckTenantsActor*>(this)->actor_wait_state > 0) static_cast<CheckTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTenantsActor*>(this)->ActorCallback< CheckTenantsActor, 2, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTenantsActor, 2, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("checkTenants", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont14when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenants", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckTenantsActor, 2, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("checkTenants", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont14when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenants", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckTenantsActor, 2, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkTenants", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenants", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont14cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckTenantsActor*>(this)->actor_wait_state > 0) static_cast<CheckTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTenantsActor*>(this)->ActorCallback< CheckTenantsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTenantsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkTenants", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont14cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenants", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckTenantsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkTenants", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont14cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenants", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckTenantsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkTenants", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenants", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1145 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 1146 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> tenants;
															#line 1160 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	std::set<TenantName> tenantsInErrorState;
															#line 11624 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via checkTenants()
															#line 1145 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class CheckTenantsActor final : public Actor<Void>, public ActorCallback< CheckTenantsActor, 0, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >, public ActorCallback< CheckTenantsActor, 1, Void >, public ActorCallback< CheckTenantsActor, 2, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >, public ActorCallback< CheckTenantsActor, 3, Void >, public FastAllocated<CheckTenantsActor>, public CheckTenantsActorState<CheckTenantsActor> {
															#line 11629 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<CheckTenantsActor>::operator new;
	using FastAllocated<CheckTenantsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4390045201561614336UL, 15325975412080635136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckTenantsActor, 0, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >;
friend struct ActorCallback< CheckTenantsActor, 1, Void >;
friend struct ActorCallback< CheckTenantsActor, 2, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >;
friend struct ActorCallback< CheckTenantsActor, 3, Void >;
															#line 1145 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	CheckTenantsActor(MetaclusterRestoreWorkload* const& self) 
															#line 11649 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   CheckTenantsActorState<CheckTenantsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkTenants", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9542879563774268928UL, 13150205647943593728UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkTenants");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkTenants", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckTenantsActor, 0, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckTenantsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckTenantsActor, 2, KeyBackedRangeResult<std::pair<int64_t, metacluster::MetaclusterTenantMapEntry>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckTenantsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1145 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> checkTenants( MetaclusterRestoreWorkload* const& self ) {
															#line 1145 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<Void>(new CheckTenantsActor(self));
															#line 11684 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 1245 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

	Future<bool> check(Database const& cx) override {
		if (clientId == 0) {
			return _check(this);
		} else {
			return true;
		}
	}
																#line 11696 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 1253 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
template <class _checkActor>
															#line 1253 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class _checkActorState {
															#line 11702 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
															#line 1253 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	_checkActorState(MetaclusterRestoreWorkload* const& self) 
															#line 1253 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
															#line 1253 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		 : self(self),
															#line 1255 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		   metaclusterConsistencyCheck(self->managementDb, metacluster::util::AllowPartialMetaclusterOperations::True)
															#line 11711 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1258 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = metaclusterConsistencyCheck.run();
															#line 1258 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11728 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 1258 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Void >*>(static_cast<_checkActor*>(this)));
															#line 11733 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1260 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		std::vector<Future<Void>> dataClusterChecks;
															#line 1261 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto [clusterName, dataClusterData] : self->dataDbs ) {
															#line 1262 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			dataClusterChecks.push_back(checkDataCluster(self, clusterName, dataClusterData));
															#line 11760 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 1264 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(dataClusterChecks);
															#line 1264 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11766 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 1264 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 11771 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1260 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		std::vector<Future<Void>> dataClusterChecks;
															#line 1261 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		for( auto [clusterName, dataClusterData] : self->dataDbs ) {
															#line 1262 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
			dataClusterChecks.push_back(checkDataCluster(self, clusterName, dataClusterData));
															#line 11784 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		}
															#line 1264 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(dataClusterChecks);
															#line 1264 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11790 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 1264 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 11795 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1265 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = checkTenants(self);
															#line 1265 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11881 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 1265 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, Void >*>(static_cast<_checkActor*>(this)));
															#line 11886 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1265 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = checkTenants(self);
															#line 1265 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11897 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 1265 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, Void >*>(static_cast<_checkActor*>(this)));
															#line 11902 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1267 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 11986 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1267 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 11998 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _checkActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1253 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	MetaclusterRestoreWorkload* self;
															#line 1255 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	metacluster::util::MetaclusterConsistencyCheck<IDatabase> metaclusterConsistencyCheck;
															#line 12085 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 1253 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Void >, public ActorCallback< _checkActor, 1, Void >, public ActorCallback< _checkActor, 2, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 12090 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(956872412669122816UL, 2613454534915426816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Void >;
friend struct ActorCallback< _checkActor, 1, Void >;
friend struct ActorCallback< _checkActor, 2, Void >;
															#line 1253 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	_checkActor(MetaclusterRestoreWorkload* const& self) 
															#line 12109 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _checkActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1253 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<bool> _check( MetaclusterRestoreWorkload* const& self ) {
															#line 1253 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"
	return Future<bool>(new _checkActor(self));
															#line 12143 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterRestoreWorkload.actor.g.cpp"
}

#line 1269 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterRestoreWorkload.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<MetaclusterRestoreWorkload> MetaclusterRestoreWorkloadFactory;
