#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
/*
 * TCInfo.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ServerKnobs.h"
#include "fdbserver/DDTeamCollection.h"
#include "fdbserver/TCInfo.h"
#include "flow/actorcompiler.h" // This must be the last #include.

class TCServerInfoImpl {
public:
																#line 30 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
// This generated class is to be used only via updateServerMetrics()
															#line 28 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
template <class UpdateServerMetricsActor>
															#line 28 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
class UpdateServerMetricsActorState {
															#line 36 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
public:
															#line 28 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	UpdateServerMetricsActorState(TCServerInfo* const& server) 
															#line 28 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
															#line 28 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		 : server(server),
															#line 29 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		   ssi(server->lastKnownInterface),
															#line 30 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		   metricsRequest(ssi.getStorageMetrics.tryGetReply(GetStorageMetricsRequest(), TaskPriority::DataDistributionLaunch)),
															#line 32 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		   resetRequest(Never()),
															#line 33 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		   interfaceChanged(server->onInterfaceChanged),
															#line 34 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		   serverRemoved(server->onRemoved)
															#line 53 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
	{
		fdb_probe_actor_create("updateServerMetrics", reinterpret_cast<unsigned long>(this));

	}
	~UpdateServerMetricsActorState() 
	{
		fdb_probe_actor_destroy("updateServerMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 36 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			;
															#line 68 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateServerMetricsActorState();
		static_cast<UpdateServerMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 70 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (server->metrics.get().lastUpdate < now() - SERVER_KNOBS->DD_SS_STUCK_TIME_LIMIT)
															#line 91 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		{
															#line 71 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			if (server->ssVersionTooFarBehind.get() == false)
															#line 95 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
			{
															#line 72 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
				TraceEvent("StorageServerStuck", server->collection->getDistributorId()) .detail("ServerId", server->id.toString()) .detail("LastUpdate", server->metrics.get().lastUpdate);
															#line 75 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
				server->ssVersionTooFarBehind.set(true);
															#line 76 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
				server->collection->addLaggingStorageServer(server->lastKnownInterface.locality.zoneId().get());
															#line 103 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
			}
		}
		else
		{
															#line 78 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			if (server->metrics.get().versionLag > SERVER_KNOBS->DD_SS_FAILURE_VERSIONLAG)
															#line 110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
			{
															#line 79 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
				if (server->ssVersionTooFarBehind.get() == false)
															#line 114 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
				{
															#line 80 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
					TraceEvent(SevWarn, "SSVersionDiffLarge", server->collection->getDistributorId()) .detail("ServerId", server->id.toString()) .detail("VersionLag", server->metrics.get().versionLag);
															#line 83 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
					server->ssVersionTooFarBehind.set(true);
															#line 84 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
					server->collection->addLaggingStorageServer(server->lastKnownInterface.locality.zoneId().get());
															#line 122 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
				}
			}
			else
			{
															#line 86 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
				if (server->metrics.get().versionLag < SERVER_KNOBS->DD_SS_ALLOWED_VERSIONLAG)
															#line 129 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
				{
															#line 87 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
					if (server->ssVersionTooFarBehind.get() == true)
															#line 133 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
					{
															#line 88 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
						TraceEvent("SSVersionDiffNormal", server->collection->getDistributorId()) .detail("ServerId", server->id.toString()) .detail("VersionLag", server->metrics.get().versionLag);
															#line 91 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
						server->ssVersionTooFarBehind.set(false);
															#line 92 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
						server->collection->removeLaggingStorageServer(server->lastKnownInterface.locality.zoneId().get());
															#line 141 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
					}
				}
			}
		}
															#line 98 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (SERVER_KNOBS->ENABLE_REBALANCE_STORAGE_QUEUE)
															#line 148 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		{
															#line 99 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			int64_t queueSize = server->getStorageQueueSize();
															#line 100 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			bool storageQueueKeepTooLong = server->updateAndGetStorageQueueTooLong(queueSize);
															#line 101 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			double currentTime = now();
															#line 102 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			if (storageQueueKeepTooLong)
															#line 158 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
			{
															#line 103 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
				if (!server->lastTimeNotifyLongStorageQueue.present() || currentTime - server->lastTimeNotifyLongStorageQueue.get() > SERVER_KNOBS->DD_REBALANCE_STORAGE_QUEUE_TIME_INTERVAL)
															#line 162 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
				{
															#line 106 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
					server->longStorageQueue.set(queueSize);
															#line 107 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
					TraceEvent(SevInfo, "SSTrackerTriggerLongStorageQueue", server->getId()) .detail("CurrentQueueSize", queueSize);
															#line 109 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
					server->lastTimeNotifyLongStorageQueue = currentTime;
															#line 170 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
				}
			}
		}
															#line 114 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (!static_cast<UpdateServerMetricsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateServerMetricsActorState(); static_cast<UpdateServerMetricsActor*>(this)->destroy(); return 0; }
															#line 176 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		new (&static_cast<UpdateServerMetricsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateServerMetricsActorState();
		static_cast<UpdateServerMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 38 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		StrictFuture<ErrorOr<GetStorageMetricsReply>> __when_expr_0 = metricsRequest;
															#line 37 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (static_cast<UpdateServerMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 197 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 49 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		StrictFuture<std::pair<StorageServerInterface, ProcessClass>> __when_expr_1 = interfaceChanged;
															#line 201 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 54 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		StrictFuture<Void> __when_expr_2 = serverRemoved;
															#line 205 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
															#line 57 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		StrictFuture<Void> __when_expr_3 = resetRequest;
															#line 209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.get(), loopDepth); };
		static_cast<UpdateServerMetricsActor*>(this)->actor_wait_state = 1;
															#line 38 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateServerMetricsActor, 0, ErrorOr<GetStorageMetricsReply> >*>(static_cast<UpdateServerMetricsActor*>(this)));
															#line 49 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateServerMetricsActor, 1, std::pair<StorageServerInterface, ProcessClass> >*>(static_cast<UpdateServerMetricsActor*>(this)));
															#line 54 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateServerMetricsActor, 2, Void >*>(static_cast<UpdateServerMetricsActor*>(this)));
															#line 57 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateServerMetricsActor, 3, Void >*>(static_cast<UpdateServerMetricsActor*>(this)));
															#line 220 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<GetStorageMetricsReply> const& rep,int loopDepth) 
	{
															#line 39 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (rep.present())
															#line 248 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		{
															#line 40 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			server->metrics = rep;
															#line 41 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			if (server->updated.canBeSet())
															#line 254 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
			{
															#line 42 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
				server->updated.send(Void());
															#line 258 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
			}
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 46 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		metricsRequest = Never();
															#line 47 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		resetRequest = delay(SERVER_KNOBS->METRIC_DELAY, TaskPriority::DataDistributionLaunch);
															#line 266 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<GetStorageMetricsReply> && rep,int loopDepth) 
	{
															#line 39 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (rep.present())
															#line 275 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		{
															#line 40 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			server->metrics = rep;
															#line 41 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			if (server->updated.canBeSet())
															#line 281 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
			{
															#line 42 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
				server->updated.send(Void());
															#line 285 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
			}
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 46 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		metricsRequest = Never();
															#line 47 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		resetRequest = delay(SERVER_KNOBS->METRIC_DELAY, TaskPriority::DataDistributionLaunch);
															#line 293 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(std::pair<StorageServerInterface, ProcessClass> const& _ssi,int loopDepth) 
	{
															#line 50 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		ssi = _ssi.first;
															#line 51 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		interfaceChanged = server->onInterfaceChanged;
															#line 52 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		resetRequest = Void();
															#line 306 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(std::pair<StorageServerInterface, ProcessClass> && _ssi,int loopDepth) 
	{
															#line 50 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		ssi = _ssi.first;
															#line 51 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		interfaceChanged = server->onInterfaceChanged;
															#line 52 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		resetRequest = Void();
															#line 319 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 55 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (!static_cast<UpdateServerMetricsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateServerMetricsActorState(); static_cast<UpdateServerMetricsActor*>(this)->destroy(); return 0; }
															#line 328 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		new (&static_cast<UpdateServerMetricsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateServerMetricsActorState();
		static_cast<UpdateServerMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 55 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (!static_cast<UpdateServerMetricsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateServerMetricsActorState(); static_cast<UpdateServerMetricsActor*>(this)->destroy(); return 0; }
															#line 340 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		new (&static_cast<UpdateServerMetricsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateServerMetricsActorState();
		static_cast<UpdateServerMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when4(Void const& _,int loopDepth) 
	{
															#line 58 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (IFailureMonitor::failureMonitor().getState(ssi.getStorageMetrics.getEndpoint()).isFailed())
															#line 352 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		{
															#line 59 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			resetRequest = IFailureMonitor::failureMonitor().onStateEqual( ssi.getStorageMetrics.getEndpoint(), FailureStatus(false));
															#line 356 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		}
		else
		{
															#line 62 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			resetRequest = Never();
															#line 63 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			metricsRequest = ssi.getStorageMetrics.tryGetReply(GetStorageMetricsRequest(), TaskPriority::DataDistributionLaunch);
															#line 364 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void && _,int loopDepth) 
	{
															#line 58 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (IFailureMonitor::failureMonitor().getState(ssi.getStorageMetrics.getEndpoint()).isFailed())
															#line 374 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		{
															#line 59 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			resetRequest = IFailureMonitor::failureMonitor().onStateEqual( ssi.getStorageMetrics.getEndpoint(), FailureStatus(false));
															#line 378 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		}
		else
		{
															#line 62 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			resetRequest = Never();
															#line 63 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			metricsRequest = ssi.getStorageMetrics.tryGetReply(GetStorageMetricsRequest(), TaskPriority::DataDistributionLaunch);
															#line 386 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateServerMetricsActor*>(this)->actor_wait_state > 0) static_cast<UpdateServerMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateServerMetricsActor*>(this)->ActorCallback< UpdateServerMetricsActor, 0, ErrorOr<GetStorageMetricsReply> >::remove();
		static_cast<UpdateServerMetricsActor*>(this)->ActorCallback< UpdateServerMetricsActor, 1, std::pair<StorageServerInterface, ProcessClass> >::remove();
		static_cast<UpdateServerMetricsActor*>(this)->ActorCallback< UpdateServerMetricsActor, 2, Void >::remove();
		static_cast<UpdateServerMetricsActor*>(this)->ActorCallback< UpdateServerMetricsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateServerMetricsActor, 0, ErrorOr<GetStorageMetricsReply> >*,ErrorOr<GetStorageMetricsReply> const& value) 
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateServerMetricsActor, 0, ErrorOr<GetStorageMetricsReply> >*,ErrorOr<GetStorageMetricsReply> && value) 
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateServerMetricsActor, 0, ErrorOr<GetStorageMetricsReply> >*,Error err) 
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateServerMetricsActor, 1, std::pair<StorageServerInterface, ProcessClass> >*,std::pair<StorageServerInterface, ProcessClass> const& value) 
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateServerMetricsActor, 1, std::pair<StorageServerInterface, ProcessClass> >*,std::pair<StorageServerInterface, ProcessClass> && value) 
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateServerMetricsActor, 1, std::pair<StorageServerInterface, ProcessClass> >*,Error err) 
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateServerMetricsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateServerMetricsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateServerMetricsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateServerMetricsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UpdateServerMetricsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UpdateServerMetricsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 28 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	TCServerInfo* server;
															#line 29 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	StorageServerInterface ssi;
															#line 30 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	Future<ErrorOr<GetStorageMetricsReply>> metricsRequest;
															#line 32 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	Future<Void> resetRequest;
															#line 33 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	Future<std::pair<StorageServerInterface, ProcessClass>> interfaceChanged;
															#line 34 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	Future<Void> serverRemoved;
															#line 641 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
};
// This generated class is to be used only via updateServerMetrics()
															#line 28 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
class UpdateServerMetricsActor final : public Actor<Void>, public ActorCallback< UpdateServerMetricsActor, 0, ErrorOr<GetStorageMetricsReply> >, public ActorCallback< UpdateServerMetricsActor, 1, std::pair<StorageServerInterface, ProcessClass> >, public ActorCallback< UpdateServerMetricsActor, 2, Void >, public ActorCallback< UpdateServerMetricsActor, 3, Void >, public FastAllocated<UpdateServerMetricsActor>, public UpdateServerMetricsActorState<UpdateServerMetricsActor> {
															#line 646 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
public:
	using FastAllocated<UpdateServerMetricsActor>::operator new;
	using FastAllocated<UpdateServerMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2573211374341439232UL, 15039756593927618560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateServerMetricsActor, 0, ErrorOr<GetStorageMetricsReply> >;
friend struct ActorCallback< UpdateServerMetricsActor, 1, std::pair<StorageServerInterface, ProcessClass> >;
friend struct ActorCallback< UpdateServerMetricsActor, 2, Void >;
friend struct ActorCallback< UpdateServerMetricsActor, 3, Void >;
															#line 28 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	UpdateServerMetricsActor(TCServerInfo* const& server) 
															#line 666 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateServerMetricsActorState<UpdateServerMetricsActor>(server),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4926400855656211968UL, 11614727230864119040UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateServerMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateServerMetricsActor, 0, ErrorOr<GetStorageMetricsReply> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 28 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
[[nodiscard]] static Future<Void> updateServerMetrics( TCServerInfo* const& server ) {
															#line 28 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	return Future<Void>(new UpdateServerMetricsActor(server));
															#line 698 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
}

#line 116 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"

																#line 703 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
// This generated class is to be used only via updateServerMetrics()
															#line 117 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
template <class UpdateServerMetricsActor1>
															#line 117 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
class UpdateServerMetricsActor1State {
															#line 709 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
public:
															#line 117 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	UpdateServerMetricsActor1State(Reference<TCServerInfo> const& server) 
															#line 117 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
															#line 117 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		 : server(server)
															#line 716 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
	{
		fdb_probe_actor_create("updateServerMetrics", reinterpret_cast<unsigned long>(this));

	}
	~UpdateServerMetricsActor1State() 
	{
		fdb_probe_actor_destroy("updateServerMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 118 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			StrictFuture<Void> __when_expr_0 = updateServerMetrics(server.getPtr());
															#line 118 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			if (static_cast<UpdateServerMetricsActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 733 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateServerMetricsActor1*>(this)->actor_wait_state = 1;
															#line 118 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateServerMetricsActor1, 0, Void >*>(static_cast<UpdateServerMetricsActor1*>(this)));
															#line 738 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateServerMetricsActor1State();
		static_cast<UpdateServerMetricsActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 119 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (!static_cast<UpdateServerMetricsActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateServerMetricsActor1State(); static_cast<UpdateServerMetricsActor1*>(this)->destroy(); return 0; }
															#line 761 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		new (&static_cast<UpdateServerMetricsActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateServerMetricsActor1State();
		static_cast<UpdateServerMetricsActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 119 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (!static_cast<UpdateServerMetricsActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateServerMetricsActor1State(); static_cast<UpdateServerMetricsActor1*>(this)->destroy(); return 0; }
															#line 773 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		new (&static_cast<UpdateServerMetricsActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateServerMetricsActor1State();
		static_cast<UpdateServerMetricsActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateServerMetricsActor1*>(this)->actor_wait_state > 0) static_cast<UpdateServerMetricsActor1*>(this)->actor_wait_state = 0;
		static_cast<UpdateServerMetricsActor1*>(this)->ActorCallback< UpdateServerMetricsActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateServerMetricsActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateServerMetricsActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateServerMetricsActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 117 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	Reference<TCServerInfo> server;
															#line 858 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
};
// This generated class is to be used only via updateServerMetrics()
															#line 117 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
class UpdateServerMetricsActor1 final : public Actor<Void>, public ActorCallback< UpdateServerMetricsActor1, 0, Void >, public FastAllocated<UpdateServerMetricsActor1>, public UpdateServerMetricsActor1State<UpdateServerMetricsActor1> {
															#line 863 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
public:
	using FastAllocated<UpdateServerMetricsActor1>::operator new;
	using FastAllocated<UpdateServerMetricsActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2573211374341439232UL, 15039756593927618560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateServerMetricsActor1, 0, Void >;
															#line 117 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	UpdateServerMetricsActor1(Reference<TCServerInfo> const& server) 
															#line 880 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateServerMetricsActor1State<UpdateServerMetricsActor1>(server),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateServerMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2707398964935623168UL, 1323215021307541248UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerMetricsActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateServerMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateServerMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateServerMetricsActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 117 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
[[nodiscard]] static Future<Void> updateServerMetrics( Reference<TCServerInfo> const& server ) {
															#line 117 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	return Future<Void>(new UpdateServerMetricsActor1(server));
															#line 912 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
}

#line 121 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"

																#line 917 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
// This generated class is to be used only via serverMetricsPolling()
															#line 122 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
template <class ServerMetricsPollingActor>
															#line 122 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
class ServerMetricsPollingActorState {
															#line 923 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
public:
															#line 122 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	ServerMetricsPollingActorState(TCServerInfo* const& server,Reference<IDDTxnProcessor> const& txnProcessor) 
															#line 122 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
															#line 122 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		 : server(server),
															#line 122 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		   txnProcessor(txnProcessor),
															#line 123 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		   lastUpdate(now())
															#line 934 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
	{
		fdb_probe_actor_create("serverMetricsPolling", reinterpret_cast<unsigned long>(this));

	}
	~ServerMetricsPollingActorState() 
	{
		fdb_probe_actor_destroy("serverMetricsPolling", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 124 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			;
															#line 949 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServerMetricsPollingActorState();
		static_cast<ServerMetricsPollingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 125 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		StrictFuture<Void> __when_expr_0 = server->updateServerMetrics() && store(server->storageStats, txnProcessor->getStorageStats(server->getId(), SERVER_KNOBS->DETAILED_METRIC_UPDATE_RATE));
															#line 125 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (static_cast<ServerMetricsPollingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 981 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ServerMetricsPollingActor*>(this)->actor_wait_state = 1;
															#line 125 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ServerMetricsPollingActor, 0, Void >*>(static_cast<ServerMetricsPollingActor*>(this)));
															#line 986 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayUntil(lastUpdate + SERVER_KNOBS->STORAGE_METRICS_POLLING_DELAY + SERVER_KNOBS->STORAGE_METRICS_RANDOM_DELAY * deterministicRandom()->random01(), TaskPriority::DataDistributionLaunch);
															#line 128 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (static_cast<ServerMetricsPollingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 997 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ServerMetricsPollingActor*>(this)->actor_wait_state = 2;
															#line 128 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ServerMetricsPollingActor, 1, Void >*>(static_cast<ServerMetricsPollingActor*>(this)));
															#line 1002 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayUntil(lastUpdate + SERVER_KNOBS->STORAGE_METRICS_POLLING_DELAY + SERVER_KNOBS->STORAGE_METRICS_RANDOM_DELAY * deterministicRandom()->random01(), TaskPriority::DataDistributionLaunch);
															#line 128 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (static_cast<ServerMetricsPollingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1013 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ServerMetricsPollingActor*>(this)->actor_wait_state = 2;
															#line 128 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ServerMetricsPollingActor, 1, Void >*>(static_cast<ServerMetricsPollingActor*>(this)));
															#line 1018 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServerMetricsPollingActor*>(this)->actor_wait_state > 0) static_cast<ServerMetricsPollingActor*>(this)->actor_wait_state = 0;
		static_cast<ServerMetricsPollingActor*>(this)->ActorCallback< ServerMetricsPollingActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServerMetricsPollingActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverMetricsPolling", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerMetricsPollingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverMetricsPolling", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServerMetricsPollingActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverMetricsPolling", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerMetricsPollingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverMetricsPolling", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ServerMetricsPollingActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverMetricsPolling", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerMetricsPollingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverMetricsPolling", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		lastUpdate = now();
															#line 1102 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		lastUpdate = now();
															#line 1111 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ServerMetricsPollingActor*>(this)->actor_wait_state > 0) static_cast<ServerMetricsPollingActor*>(this)->actor_wait_state = 0;
		static_cast<ServerMetricsPollingActor*>(this)->ActorCallback< ServerMetricsPollingActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServerMetricsPollingActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverMetricsPolling", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerMetricsPollingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverMetricsPolling", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ServerMetricsPollingActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverMetricsPolling", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerMetricsPollingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverMetricsPolling", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ServerMetricsPollingActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverMetricsPolling", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerMetricsPollingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverMetricsPolling", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 122 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	TCServerInfo* server;
															#line 122 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	Reference<IDDTxnProcessor> txnProcessor;
															#line 123 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	double lastUpdate;
															#line 1197 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
};
// This generated class is to be used only via serverMetricsPolling()
															#line 122 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
class ServerMetricsPollingActor final : public Actor<Void>, public ActorCallback< ServerMetricsPollingActor, 0, Void >, public ActorCallback< ServerMetricsPollingActor, 1, Void >, public FastAllocated<ServerMetricsPollingActor>, public ServerMetricsPollingActorState<ServerMetricsPollingActor> {
															#line 1202 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
public:
	using FastAllocated<ServerMetricsPollingActor>::operator new;
	using FastAllocated<ServerMetricsPollingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15491912267605701120UL, 5375458646581009152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ServerMetricsPollingActor, 0, Void >;
friend struct ActorCallback< ServerMetricsPollingActor, 1, Void >;
															#line 122 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	ServerMetricsPollingActor(TCServerInfo* const& server,Reference<IDDTxnProcessor> const& txnProcessor) 
															#line 1220 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		 : Actor<Void>(),
		   ServerMetricsPollingActorState<ServerMetricsPollingActor>(server, txnProcessor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serverMetricsPolling", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13804522636156270336UL, 3324242973435963136UL);
		ActorExecutionContextHelper __helper(static_cast<ServerMetricsPollingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serverMetricsPolling");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serverMetricsPolling", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ServerMetricsPollingActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ServerMetricsPollingActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 122 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
[[nodiscard]] static Future<Void> serverMetricsPolling( TCServerInfo* const& server, Reference<IDDTxnProcessor> const& txnProcessor ) {
															#line 122 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	return Future<Void>(new ServerMetricsPollingActor(server, txnProcessor));
															#line 1253 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
}

#line 134 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
};

class TCTeamInfoImpl {
public:
																#line 1261 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
// This generated class is to be used only via updateStorageMetrics()
															#line 138 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
template <class UpdateStorageMetricsActor>
															#line 138 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
class UpdateStorageMetricsActorState {
															#line 1267 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
public:
															#line 138 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	UpdateStorageMetricsActorState(TCTeamInfo* const& self) 
															#line 138 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
															#line 138 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		 : self(self)
															#line 1274 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
	{
		fdb_probe_actor_create("updateStorageMetrics", reinterpret_cast<unsigned long>(this));

	}
	~UpdateStorageMetricsActorState() 
	{
		fdb_probe_actor_destroy("updateStorageMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 139 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			std::vector<Future<Void>> updates;
															#line 140 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			updates.reserve(self->servers.size());
															#line 141 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			for(int i = 0;i < self->servers.size();i++) {
															#line 142 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
				updates.push_back(TCServerInfo::updateServerMetrics(self->servers[i]));
															#line 1295 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
			}
															#line 143 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(updates);
															#line 143 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			if (static_cast<UpdateStorageMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1301 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateStorageMetricsActor*>(this)->actor_wait_state = 1;
															#line 143 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateStorageMetricsActor, 0, Void >*>(static_cast<UpdateStorageMetricsActor*>(this)));
															#line 1306 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateStorageMetricsActorState();
		static_cast<UpdateStorageMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 144 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (!static_cast<UpdateStorageMetricsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateStorageMetricsActorState(); static_cast<UpdateStorageMetricsActor*>(this)->destroy(); return 0; }
															#line 1329 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		new (&static_cast<UpdateStorageMetricsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateStorageMetricsActorState();
		static_cast<UpdateStorageMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 144 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
		if (!static_cast<UpdateStorageMetricsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateStorageMetricsActorState(); static_cast<UpdateStorageMetricsActor*>(this)->destroy(); return 0; }
															#line 1341 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		new (&static_cast<UpdateStorageMetricsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateStorageMetricsActorState();
		static_cast<UpdateStorageMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateStorageMetricsActor*>(this)->actor_wait_state > 0) static_cast<UpdateStorageMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateStorageMetricsActor*>(this)->ActorCallback< UpdateStorageMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateStorageMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateStorageMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorageMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateStorageMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateStorageMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorageMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateStorageMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateStorageMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateStorageMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 138 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	TCTeamInfo* self;
															#line 1426 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
};
// This generated class is to be used only via updateStorageMetrics()
															#line 138 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
class UpdateStorageMetricsActor final : public Actor<Void>, public ActorCallback< UpdateStorageMetricsActor, 0, Void >, public FastAllocated<UpdateStorageMetricsActor>, public UpdateStorageMetricsActorState<UpdateStorageMetricsActor> {
															#line 1431 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
public:
	using FastAllocated<UpdateStorageMetricsActor>::operator new;
	using FastAllocated<UpdateStorageMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7834363834121820160UL, 7005372420321382912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateStorageMetricsActor, 0, Void >;
															#line 138 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	UpdateStorageMetricsActor(TCTeamInfo* const& self) 
															#line 1448 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateStorageMetricsActorState<UpdateStorageMetricsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateStorageMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13566645348397369344UL, 4018347377793837568UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateStorageMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateStorageMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateStorageMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 138 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
[[nodiscard]] static Future<Void> updateStorageMetrics( TCTeamInfo* const& self ) {
															#line 138 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
	return Future<Void>(new UpdateStorageMetricsActor(self));
															#line 1480 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/TCInfo.actor.g.cpp"
}

#line 146 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/TCInfo.actor.cpp"
};

TCServerInfo::TCServerInfo(StorageServerInterface ssi,
                           DDTeamCollection* collection,
                           ProcessClass processClass,
                           bool inDesiredDC,
                           Reference<LocalitySet> storageServerSet,
                           Version addedVersion)
  : id(ssi.id()), inDesiredDC(inDesiredDC), collection(collection), addedVersion(addedVersion), lastKnownInterface(ssi),
    lastKnownClass(processClass), storeType(KeyValueStoreType::END), dataInFlightToServer(0),
    onInterfaceChanged(interfaceChanged.getFuture()), onRemoved(removed.getFuture()), onTSSPairRemoved(Never()) {

	if (!ssi.isTss()) {
		localityEntry = ((LocalityMap<UID>*)storageServerSet.getPtr())->add(ssi.locality, &id);
	}
}

bool TCServerInfo::hasHealthyAvailableSpace(double minAvailableSpaceRatio) const {
	ASSERT(metricsPresent());

	auto& metrics = getMetrics();
	ASSERT(metrics.available.bytes >= 0);
	ASSERT(metrics.capacity.bytes >= 0);

	double availableSpaceRatio;
	if (metrics.capacity.bytes == 0) {
		availableSpaceRatio = 0;
	} else {
		availableSpaceRatio = (((double)metrics.available.bytes) / metrics.capacity.bytes);
	}

	return availableSpaceRatio >= minAvailableSpaceRatio;
}

bool TCServerInfo::isWigglePausedServer() const {
	return collection && collection->isWigglePausedServer(id);
}

Future<Void> TCServerInfo::updateServerMetrics() {
	return TCServerInfoImpl::updateServerMetrics(this);
}

Future<Void> TCServerInfo::updateServerMetrics(Reference<TCServerInfo> server) {
	return TCServerInfoImpl::updateServerMetrics(server);
}

Future<Void> TCServerInfo::serverMetricsPolling(Reference<IDDTxnProcessor> txnProcessor) {
	return TCServerInfoImpl::serverMetricsPolling(this, txnProcessor);
}

// Return true if the storage queue of the input storage server ssi keeps too long for a while
bool TCServerInfo::updateAndGetStorageQueueTooLong(int64_t currentBytes) {
	double currentTime = now();
	if (currentBytes > SERVER_KNOBS->REBALANCE_STORAGE_QUEUE_LONG_BYTES) {
		if (!storageQueueTooLongStartTime.present()) {
			storageQueueTooLongStartTime = currentTime;
			TraceEvent(SevWarn, "SSTrackerDetectStorageQueueBecomeLong", id)
			    .detail("StorageQueueBytes", currentBytes)
			    .detail("Duration", currentTime - storageQueueTooLongStartTime.get());
		} else {
			TraceEvent(SevDebug, "SSTrackerDetectStorageQueueRemainLong", id)
			    .detail("StorageQueueBytes", currentBytes)
			    .detail("Duration", currentTime - storageQueueTooLongStartTime.get());
		}
	} else if (currentBytes < SERVER_KNOBS->REBALANCE_STORAGE_QUEUE_SHORT_BYTES) {
		if (storageQueueTooLongStartTime.present()) {
			storageQueueTooLongStartTime.reset();
			TraceEvent(SevInfo, "SSTrackerDetectStorageQueueBecomeShort", id).detail("StorageQueueBytes", currentBytes);
		}
	} else {
		if (storageQueueTooLongStartTime.present()) {
			TraceEvent(SevDebug, "SSTrackerDetectStorageQueueRemainLong", id)
			    .detail("StorageQueueBytes", currentBytes)
			    .detail("Duration", currentTime - storageQueueTooLongStartTime.get());
		}
	}
	if (storageQueueTooLongStartTime.present() &&
	    currentTime - storageQueueTooLongStartTime.get() > SERVER_KNOBS->DD_LONG_STORAGE_QUEUE_TIMESPAN) {
		return true;
	} else {
		return false;
	}
}

void TCServerInfo::updateInDesiredDC(std::vector<Optional<Key>> const& includedDCs) {
	inDesiredDC =
	    (includedDCs.empty() ||
	     std::find(includedDCs.begin(), includedDCs.end(), lastKnownInterface.locality.dcId()) != includedDCs.end());
}

void TCServerInfo::cancel() {
	tracker.cancel();
	collection = nullptr;
}

void TCServerInfo::updateLastKnown(StorageServerInterface const& ssi, ProcessClass processClass) {
	lastKnownInterface = ssi;
	lastKnownClass = processClass;
}

Future<Void> TCServerInfo::updateStoreType() {
	return store(storeType,
	             brokenPromiseToNever(lastKnownInterface.getKeyValueStoreType.getReplyWithTaskID<KeyValueStoreType>(
	                 TaskPriority::DataDistribution)));
}

void TCServerInfo::removeTeamsContainingServer(UID removedServer) {
	for (int t = 0; t < teams.size(); t++) {
		auto const& serverIds = teams[t]->getServerIDs();
		if (std::find(serverIds.begin(), serverIds.end(), removedServer) != serverIds.end()) {
			teams[t--] = teams.back();
			teams.pop_back();
		}
	}
}

std::pair<int64_t, int64_t> TCServerInfo::spaceBytes(bool includeInFlight) const {
	auto& metrics = getMetrics();
	ASSERT(metrics.capacity.bytes >= 0);
	ASSERT(metrics.available.bytes >= 0);

	int64_t bytesAvailable = metrics.available.bytes;
	if (includeInFlight) {
		bytesAvailable -= getDataInFlightToServer();
	}

	return std::make_pair(bytesAvailable, metrics.capacity.bytes); // bytesAvailable could be negative
}

int64_t TCServerInfo::loadBytes() const {
	return getMetrics().load.bytes;
}

int64_t TCServerInfo::getStorageQueueSize() const {
	return getMetrics().bytesInput - getMetrics().bytesDurable;
}

int TCServerInfo::getMaxOngoingBulkLoadTaskCount() const {
	return getMetrics().ongoingBulkLoadTaskCount;
}

void TCServerInfo::removeTeam(Reference<TCTeamInfo> team) {
	for (int t = 0; t < teams.size(); t++) {
		if (teams[t] == team) {
			teams[t--] = teams.back();
			teams.pop_back();
			return; // The teams on a server should never duplicate
		}
	}
}

void TCServerInfo::markTeamUnhealthy(int teamIndex) {
	teams[teamIndex]->setHealthy(false);
}

TCServerInfo::~TCServerInfo() {
	if (collection && ssVersionTooFarBehind.get() && !lastKnownInterface.isTss()) {
		collection->removeLaggingStorageServer(lastKnownInterface.locality.zoneId().get());
	}
}

bool TCMachineTeamInfo::matches(std::vector<Standalone<StringRef>> const& sortedMachineIDs) {
	std::sort(machineIDs.begin(), machineIDs.end());
	return sortedMachineIDs == machineIDs;
}

bool TCMachineTeamInfo::removeServerTeam(Reference<TCTeamInfo> team) {
	for (int t = 0; t < serverTeams.size(); ++t) {
		if (serverTeams[t] == team) {
			serverTeams[t--] = serverTeams.back();
			serverTeams.pop_back();
			return true; // The same team is added to the serverTeams only once
		}
	}
	return false;
}

Reference<TCMachineInfo> TCMachineInfo::clone() const {
	auto result = Reference<TCMachineInfo>(new TCMachineInfo);
	result->serversOnMachine = serversOnMachine;
	result->machineID = machineID;
	result->machineTeams = machineTeams;
	result->localityEntry = localityEntry;
	return result;
}

TCMachineInfo::TCMachineInfo(Reference<TCServerInfo> server, const LocalityEntry& entry) : localityEntry(entry) {
	ASSERT(serversOnMachine.empty());
	serversOnMachine.push_back(server);

	LocalityData const& locality = server->getLastKnownInterface().locality;
	ASSERT(locality.zoneId().present());
	machineID = locality.zoneId().get();
}

std::string TCMachineInfo::getServersIDStr() const {
	std::stringstream ss;
	if (serversOnMachine.empty())
		return "[unset]";

	for (const auto& server : serversOnMachine) {
		ss << server->getId().toString() << " ";
	}

	return std::move(ss).str();
}

TCMachineTeamInfo::TCMachineTeamInfo(std::vector<Reference<TCMachineInfo>> const& machines)
  : _id(deterministicRandom()->randomUniqueID()), machines(machines) {
	machineIDs.reserve(machines.size());
	for (int i = 0; i < machines.size(); i++) {
		machineIDs.push_back(machines[i]->machineID);
	}
	sort(machineIDs.begin(), machineIDs.end());
}

std::string TCMachineTeamInfo::getMachineIDsStr() const {
	std::stringstream ss;

	if (machineIDs.empty())
		return "[unset]";

	for (const auto& id : machineIDs) {
		ss << id.contents().toString() << " ";
	}

	return std::move(ss).str();
}

TCTeamInfo::TCTeamInfo(std::vector<Reference<TCServerInfo>> const& servers, Optional<Reference<TCTenantInfo>> tenant)
  : servers(servers), tenant(tenant), healthy(true), wrongConfiguration(false),
    priority(SERVER_KNOBS->PRIORITY_TEAM_HEALTHY), id(deterministicRandom()->randomUniqueID()) {
	if (servers.empty()) {
		TraceEvent(SevInfo, "ConstructTCTeamFromEmptyServers").log();
	}
	serverIDs.reserve(servers.size());
	for (int i = 0; i < servers.size(); i++) {
		serverIDs.push_back(servers[i]->getId());
	}
}

// static
std::string TCTeamInfo::serversToString(std::vector<UID> servers) {
	if (servers.empty()) {
		return "[unset]";
	}

	std::sort(servers.begin(), servers.end());
	std::stringstream ss;
	for (const auto& id : servers) {
		ss << id.toString() << " ";
	}

	return ss.str();
}

std::vector<StorageServerInterface> TCTeamInfo::getLastKnownServerInterfaces() const {
	std::vector<StorageServerInterface> v;
	v.reserve(servers.size());
	for (const auto& server : servers) {
		v.push_back(server->getLastKnownInterface());
	}
	return v;
}

std::string TCTeamInfo::getServerIDsStr() const {
	return serversToString(this->serverIDs);
}

void TCTeamInfo::addDataInFlightToTeam(int64_t delta) {
	for (int i = 0; i < servers.size(); i++)
		servers[i]->incrementDataInFlightToServer(delta);
}

void TCTeamInfo::addReadInFlightToTeam(int64_t delta) {
	for (int i = 0; i < servers.size(); i++)
		servers[i]->incrementReadInFlightToServer(delta);
}

int64_t TCTeamInfo::getDataInFlightToTeam() const {
	int64_t dataInFlight = 0.0;
	for (auto const& server : servers) {
		dataInFlight += server->getDataInFlightToServer();
	}
	return dataInFlight;
}

int64_t TCTeamInfo::getReadInFlightToTeam() const {
	int64_t inFlight = 0.0;
	for (auto const& server : servers) {
		inFlight += server->getReadInFlightToServer();
	}
	return inFlight;
}

Optional<int64_t> TCTeamInfo::getLongestStorageQueueSize() const {
	int64_t longestQueueSize = 0;
	for (const auto& server : servers) {
		if (server->metricsPresent()) {
			longestQueueSize = std::max(longestQueueSize, server->getStorageQueueSize());
		} else {
			return Optional<int64_t>();
		}
	}
	return longestQueueSize;
}

Optional<int> TCTeamInfo::getMaxOngoingBulkLoadTaskCount() const {
	int count = 0;
	for (const auto& server : servers) {
		if (server->metricsPresent()) {
			count = std::max(count, server->getMaxOngoingBulkLoadTaskCount());
		} else {
			return Optional<int>();
		}
	}
	return count;
}

int64_t TCTeamInfo::getLoadBytes(bool includeInFlight, double inflightPenalty) const {
	int64_t physicalBytes = getLoadAverage();
	double minAvailableSpaceRatio = getMinAvailableSpaceRatio(includeInFlight);
	int64_t inFlightBytes = includeInFlight ? getDataInFlightToTeam() / servers.size() : 0;
	double availableSpaceMultiplier =
	    SERVER_KNOBS->AVAILABLE_SPACE_RATIO_CUTOFF /
	    (std::max(std::min(SERVER_KNOBS->AVAILABLE_SPACE_RATIO_CUTOFF, minAvailableSpaceRatio), 0.000001));
	if (servers.size() > 2) {
		// make sure in triple replication the penalty is high enough that you will always avoid a team with a
		// member at 20% free space
		availableSpaceMultiplier = availableSpaceMultiplier * availableSpaceMultiplier;
	}

	if (minAvailableSpaceRatio < SERVER_KNOBS->TARGET_AVAILABLE_SPACE_RATIO) {
		TraceEvent(SevWarn, "DiskNearCapacity").suppressFor(1.0).detail("AvailableSpaceRatio", minAvailableSpaceRatio);
	}

	return (physicalBytes + (inflightPenalty * inFlightBytes)) * availableSpaceMultiplier;
}

// average read bandwidth within a team
double TCTeamInfo::getReadLoad(bool includeInFlight, double inflightPenalty) const {
	// FIXME: consider team load variance
	double sum = 0;
	int size = 0;
	for (const auto& server : servers) {
		if (server->metricsPresent()) {
			auto replyValue = server->getMetrics().load.readLoadKSecond();
			ASSERT(replyValue >= 0);
			sum += replyValue;
			size += 1;
		}
	}
	return (size == 0 ? 0 : sum / size) +
	       (includeInFlight ? inflightPenalty * getReadInFlightToTeam() / servers.size() : 0);
}

double TCTeamInfo::getAverageCPU() const {
	double sum = 0;
	for (const auto& server : servers) {
		auto& stats = server->getStorageStats();
		// If storage server hasn't gotten the health metrics updated, we assume it's too busy to respond so
		// return 100.0;
		sum += stats.present() ? stats.get().cpuUsage : 100.0;
	}
	return servers.empty() ? 0.0 : sum / servers.size();
}

int64_t TCTeamInfo::getMinAvailableSpace(bool includeInFlight) const {
	int64_t minAvailableSpace = std::numeric_limits<int64_t>::max();
	for (const auto& server : servers) {
		if (server->metricsPresent()) {
			const auto [bytesAvailable, bytesCapacity] = server->spaceBytes(includeInFlight);
			minAvailableSpace = std::min(bytesAvailable, minAvailableSpace);
		}
	}

	return minAvailableSpace; // Could be negative
}

// return the min ratio of servers in this team
double TCTeamInfo::getMinAvailableSpaceRatio(bool includeInFlight) const {
	double minRatio = 1.0;
	for (const auto& server : servers) {
		if (server->metricsPresent()) {
			auto [bytesAvailable, bytesCapacity] = server->spaceBytes(includeInFlight);
			bytesAvailable = std::max((int64_t)0, bytesAvailable);

			if (bytesCapacity == 0)
				minRatio = 0;
			else
				minRatio = std::min(minRatio, ((double)bytesAvailable) / bytesCapacity);
		}
	}

	return minRatio;
}

bool TCTeamInfo::allServersHaveHealthyAvailableSpace() const {
	bool result = true;
	double minAvailableSpaceRatio =
	    SERVER_KNOBS->MIN_AVAILABLE_SPACE_RATIO + SERVER_KNOBS->MIN_AVAILABLE_SPACE_RATIO_SAFETY_BUFFER;
	for (const auto& server : servers) {
		if (!server->metricsPresent() || !server->hasHealthyAvailableSpace(minAvailableSpaceRatio)) {
			result = false;
			break;
		}
	}

	return result;
}

bool TCTeamInfo::hasHealthyAvailableSpace(double minRatio) const {
	return getMinAvailableSpaceRatio() >= minRatio && getMinAvailableSpace() > SERVER_KNOBS->MIN_AVAILABLE_SPACE &&
	       allServersHaveHealthyAvailableSpace();
}

bool TCTeamInfo::isOptimal() const {
	for (const auto& server : servers) {
		if (server->getLastKnownClass().machineClassFitness(ProcessClass::Storage) > ProcessClass::UnsetFit) {
			return false;
		}
	}
	return true;
}

bool TCTeamInfo::hasServer(const UID& server) const {
	return std::find(serverIDs.begin(), serverIDs.end(), server) != serverIDs.end();
}

bool TCTeamInfo::hasWigglePausedServer() const {
	for (const auto& server : servers) {
		if (server->isWigglePausedServer())
			return true;
	}
	return false;
}

void TCTeamInfo::addServers(const std::vector<UID>& servers) {
	serverIDs.reserve(servers.size());
	for (int i = 0; i < servers.size(); i++) {
		serverIDs.push_back(servers[i]);
	}
}

int64_t TCTeamInfo::getLoadAverage() const {
	int64_t bytesSum = 0;
	int added = 0;
	for (const auto& server : servers) {
		if (server->metricsPresent()) {
			added++;
			bytesSum += server->loadBytes();
		}
	}

	if (added < servers.size())
		bytesSum *= 2;

	return added == 0 ? 0 : bytesSum / added;
}

Future<Void> TCTeamInfo::updateStorageMetrics() {
	return TCTeamInfoImpl::updateStorageMetrics(this);
}
