#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
/*
 * QuietDatabase.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cinttypes>
#include <vector>
#include <map>

#include <boost/lexical_cast.hpp>
#include <fmt/ranges.h>

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/SystemData.h"
#include "fdbrpc/simulator.h"
#include "flow/flow.h"
#include "flow/ProcessEvents.h"
#include "flow/Trace.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

															#line 45 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getWorkers()
															#line 43 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetWorkersActor>
															#line 43 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetWorkersActorState {
															#line 52 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 43 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetWorkersActorState(Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,int const& flags = 0) 
															#line 43 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 43 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : dbInfo(dbInfo),
															#line 43 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   flags(flags)
															#line 61 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getWorkers", reinterpret_cast<unsigned long>(this));

	}
	~GetWorkersActorState() 
	{
		fdb_probe_actor_destroy("getWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 44 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 76 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 46 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = brokenPromiseToNever( dbInfo->get().clusterInterface.getWorkers.getReply(GetWorkersRequest(flags)));
															#line 45 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 108 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 50 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = dbInfo->onChange();
															#line 112 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<GetWorkersActor*>(this)->actor_wait_state = 1;
															#line 46 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetWorkersActor, 0, std::vector<WorkerDetails> >*>(static_cast<GetWorkersActor*>(this)));
															#line 50 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetWorkersActor, 1, Void >*>(static_cast<GetWorkersActor*>(this)));
															#line 119 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> const& w,int loopDepth) 
	{
															#line 48 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetWorkersActor*>(this)->SAV<std::vector<WorkerDetails>>::futures) { (void)(w); this->~GetWorkersActorState(); static_cast<GetWorkersActor*>(this)->destroy(); return 0; }
															#line 134 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetWorkersActor*>(this)->SAV< std::vector<WorkerDetails> >::value()) std::vector<WorkerDetails>(w);
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> && w,int loopDepth) 
	{
															#line 48 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetWorkersActor*>(this)->SAV<std::vector<WorkerDetails>>::futures) { (void)(w); this->~GetWorkersActorState(); static_cast<GetWorkersActor*>(this)->destroy(); return 0; }
															#line 146 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetWorkersActor*>(this)->SAV< std::vector<WorkerDetails> >::value()) std::vector<WorkerDetails>(w);
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetWorkersActor*>(this)->ActorCallback< GetWorkersActor, 0, std::vector<WorkerDetails> >::remove();
		static_cast<GetWorkersActor*>(this)->ActorCallback< GetWorkersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetWorkersActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetWorkersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 43 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 43 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int flags;
															#line 291 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getWorkers()
															#line 43 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetWorkersActor final : public Actor<std::vector<WorkerDetails>>, public ActorCallback< GetWorkersActor, 0, std::vector<WorkerDetails> >, public ActorCallback< GetWorkersActor, 1, Void >, public FastAllocated<GetWorkersActor>, public GetWorkersActorState<GetWorkersActor> {
															#line 296 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetWorkersActor>::operator new;
	using FastAllocated<GetWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7675040123220217088UL, 9874669206585749248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<WorkerDetails>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetWorkersActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< GetWorkersActor, 1, Void >;
															#line 43 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetWorkersActor(Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,int const& flags = 0) 
															#line 314 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<std::vector<WorkerDetails>>(),
		   GetWorkersActorState<GetWorkersActor>(dbInfo, flags),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14779239272732970240UL, 16642038601798370048UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetWorkersActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 43 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<std::vector<WorkerDetails>> getWorkers( Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, int const& flags = 0 ) {
															#line 43 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<std::vector<WorkerDetails>>(new GetWorkersActor(dbInfo, flags));
															#line 347 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 54 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets the WorkerInterface representing the Master server.
															#line 353 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getMasterWorker()
															#line 56 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetMasterWorkerActor>
															#line 56 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetMasterWorkerActorState {
															#line 360 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 56 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetMasterWorkerActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 56 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 56 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 56 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo)
															#line 369 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getMasterWorker", reinterpret_cast<unsigned long>(this));

	}
	~GetMasterWorkerActorState() 
	{
		fdb_probe_actor_destroy("getMasterWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 57 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("GetMasterWorker").detail("Stage", "GettingWorkers");
															#line 59 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 386 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetMasterWorkerActorState();
		static_cast<GetMasterWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 60 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(dbInfo);
															#line 60 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetMasterWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 418 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetMasterWorkerActor*>(this)->actor_wait_state = 1;
															#line 60 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetMasterWorkerActor, 0, std::vector<WorkerDetails> >*>(static_cast<GetMasterWorkerActor*>(this)));
															#line 423 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 62 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 63 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (workers[i].interf.address() == dbInfo->get().master.address())
															#line 434 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 64 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("GetMasterWorker") .detail("Stage", "GotWorkers") .detail("MasterId", dbInfo->get().master.id()) .detail("WorkerId", workers[i].interf.id());
															#line 68 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<GetMasterWorkerActor*>(this)->SAV<WorkerInterface>::futures) { (void)(workers[i].interf); this->~GetMasterWorkerActorState(); static_cast<GetMasterWorkerActor*>(this)->destroy(); return 0; }
															#line 440 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<GetMasterWorkerActor*>(this)->SAV< WorkerInterface >::value()) WorkerInterface(workers[i].interf);
				this->~GetMasterWorkerActorState();
				static_cast<GetMasterWorkerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 72 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent(SevWarn, "GetMasterWorkerError") .detail("Error", "MasterWorkerNotFound") .detail("Master", dbInfo->get().master.id()) .detail("MasterAddress", dbInfo->get().master.address()) .detail("WorkerCount", workers.size());
															#line 78 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 78 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetMasterWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 453 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetMasterWorkerActor*>(this)->actor_wait_state = 2;
															#line 78 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetMasterWorkerActor, 1, Void >*>(static_cast<GetMasterWorkerActor*>(this)));
															#line 458 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 60 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		workers = __workers;
															#line 467 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetMasterWorkerActor*>(this)->actor_wait_state > 0) static_cast<GetMasterWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<GetMasterWorkerActor*>(this)->ActorCallback< GetMasterWorkerActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< GetMasterWorkerActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getMasterWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMasterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMasterWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetMasterWorkerActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getMasterWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMasterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMasterWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetMasterWorkerActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getMasterWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMasterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMasterWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetMasterWorkerActor*>(this)->actor_wait_state > 0) static_cast<GetMasterWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<GetMasterWorkerActor*>(this)->ActorCallback< GetMasterWorkerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetMasterWorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getMasterWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMasterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMasterWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetMasterWorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getMasterWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMasterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMasterWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetMasterWorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getMasterWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMasterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMasterWorker", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 56 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 56 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 60 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 635 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getMasterWorker()
															#line 56 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetMasterWorkerActor final : public Actor<WorkerInterface>, public ActorCallback< GetMasterWorkerActor, 0, std::vector<WorkerDetails> >, public ActorCallback< GetMasterWorkerActor, 1, Void >, public FastAllocated<GetMasterWorkerActor>, public GetMasterWorkerActorState<GetMasterWorkerActor> {
															#line 640 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetMasterWorkerActor>::operator new;
	using FastAllocated<GetMasterWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5127110474259153664UL, 16617074826421892352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<WorkerInterface>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetMasterWorkerActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< GetMasterWorkerActor, 1, Void >;
															#line 56 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetMasterWorkerActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 658 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<WorkerInterface>(),
		   GetMasterWorkerActorState<GetMasterWorkerActor>(cx, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getMasterWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(126253898944419840UL, 13347791939979559936UL);
		ActorExecutionContextHelper __helper(static_cast<GetMasterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getMasterWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getMasterWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetMasterWorkerActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetMasterWorkerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 56 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<WorkerInterface> getMasterWorker( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 56 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<WorkerInterface>(new GetMasterWorkerActor(cx, dbInfo));
															#line 692 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 81 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets the WorkerInterface representing the data distributor.
															#line 698 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getDataDistributorWorker()
															#line 83 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetDataDistributorWorkerActor>
															#line 83 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataDistributorWorkerActorState {
															#line 705 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 83 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataDistributorWorkerActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 83 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 83 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 83 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo)
															#line 714 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getDataDistributorWorker", reinterpret_cast<unsigned long>(this));

	}
	~GetDataDistributorWorkerActorState() 
	{
		fdb_probe_actor_destroy("getDataDistributorWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 84 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("GetDataDistributorWorker").detail("Stage", "GettingWorkers");
															#line 86 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 731 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDataDistributorWorkerActorState();
		static_cast<GetDataDistributorWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 87 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(dbInfo);
															#line 87 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetDataDistributorWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 763 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetDataDistributorWorkerActor*>(this)->actor_wait_state = 1;
															#line 87 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDataDistributorWorkerActor, 0, std::vector<WorkerDetails> >*>(static_cast<GetDataDistributorWorkerActor*>(this)));
															#line 768 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 88 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!dbInfo->get().distributor.present())
															#line 777 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 91 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 92 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (workers[i].interf.address() == dbInfo->get().distributor.get().address())
															#line 785 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 93 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("GetDataDistributorWorker") .detail("Stage", "GotWorkers") .detail("DataDistributorId", dbInfo->get().distributor.get().id()) .detail("WorkerId", workers[i].interf.id());
															#line 97 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<GetDataDistributorWorkerActor*>(this)->SAV<WorkerInterface>::futures) { (void)(workers[i].interf); this->~GetDataDistributorWorkerActorState(); static_cast<GetDataDistributorWorkerActor*>(this)->destroy(); return 0; }
															#line 791 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<GetDataDistributorWorkerActor*>(this)->SAV< WorkerInterface >::value()) WorkerInterface(workers[i].interf);
				this->~GetDataDistributorWorkerActorState();
				static_cast<GetDataDistributorWorkerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 101 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent(SevWarn, "GetDataDistributorWorker") .detail("Error", "DataDistributorWorkerNotFound") .detail("DataDistributorId", dbInfo->get().distributor.get().id()) .detail("DataDistributorAddress", dbInfo->get().distributor.get().address()) .detail("WorkerCount", workers.size());
															#line 800 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 87 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		workers = __workers;
															#line 809 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDataDistributorWorkerActor*>(this)->actor_wait_state > 0) static_cast<GetDataDistributorWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<GetDataDistributorWorkerActor*>(this)->ActorCallback< GetDataDistributorWorkerActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataDistributorWorkerActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getDataDistributorWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributorWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDataDistributorWorkerActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getDataDistributorWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributorWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDataDistributorWorkerActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getDataDistributorWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributorWorker", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 83 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 83 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 87 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 890 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getDataDistributorWorker()
															#line 83 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataDistributorWorkerActor final : public Actor<WorkerInterface>, public ActorCallback< GetDataDistributorWorkerActor, 0, std::vector<WorkerDetails> >, public FastAllocated<GetDataDistributorWorkerActor>, public GetDataDistributorWorkerActorState<GetDataDistributorWorkerActor> {
															#line 895 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetDataDistributorWorkerActor>::operator new;
	using FastAllocated<GetDataDistributorWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12205603165705344768UL, 9815125080182209792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<WorkerInterface>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDataDistributorWorkerActor, 0, std::vector<WorkerDetails> >;
															#line 83 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataDistributorWorkerActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 912 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<WorkerInterface>(),
		   GetDataDistributorWorkerActorState<GetDataDistributorWorkerActor>(cx, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDataDistributorWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(588571917037638656UL, 7461604007364582144UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDataDistributorWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDataDistributorWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDataDistributorWorkerActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 83 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<WorkerInterface> getDataDistributorWorker( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 83 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<WorkerInterface>(new GetDataDistributorWorkerActor(cx, dbInfo));
															#line 945 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 108 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets the number of bytes in flight from the data distributor.
															#line 951 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getDataInFlight()
															#line 110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetDataInFlightActor>
															#line 110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataInFlightActorState {
															#line 958 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataInFlightActorState(Database const& cx,WorkerInterface const& distributorWorker) 
															#line 110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   distributorWorker(distributorWorker)
															#line 967 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getDataInFlight", reinterpret_cast<unsigned long>(this));

	}
	~GetDataInFlightActorState() 
	{
		fdb_probe_actor_destroy("getDataInFlight", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 112 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("DataInFlight").detail("Stage", "ContactingDataDistributor");
															#line 113 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<TraceEventFields> __when_expr_0 = timeoutError(distributorWorker.eventLogRequest.getReply(EventLogRequest("TotalDataInFlight"_sr)), 1.0);
															#line 113 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<GetDataInFlightActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 987 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetDataInFlightActor*>(this)->actor_wait_state = 1;
															#line 113 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDataInFlightActor, 0, TraceEventFields >*>(static_cast<GetDataInFlightActor*>(this)));
															#line 992 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDataInFlightActorState();
		static_cast<GetDataInFlightActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 118 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseFailure", distributorWorker.id()) .error(e) .detail("Reason", "Failed to extract DataInFlight");
															#line 121 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1024 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields const& md,int loopDepth) 
	{
															#line 115 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int64_t dataInFlight = boost::lexical_cast<int64_t>(md.getValue("TotalBytes"));
															#line 116 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataInFlightActor*>(this)->SAV<int64_t>::futures) { (void)(dataInFlight); this->~GetDataInFlightActorState(); static_cast<GetDataInFlightActor*>(this)->destroy(); return 0; }
															#line 1040 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataInFlightActor*>(this)->SAV< int64_t >::value()) int64_t(dataInFlight);
		this->~GetDataInFlightActorState();
		static_cast<GetDataInFlightActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields && md,int loopDepth) 
	{
															#line 115 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int64_t dataInFlight = boost::lexical_cast<int64_t>(md.getValue("TotalBytes"));
															#line 116 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataInFlightActor*>(this)->SAV<int64_t>::futures) { (void)(dataInFlight); this->~GetDataInFlightActorState(); static_cast<GetDataInFlightActor*>(this)->destroy(); return 0; }
															#line 1054 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataInFlightActor*>(this)->SAV< int64_t >::value()) int64_t(dataInFlight);
		this->~GetDataInFlightActorState();
		static_cast<GetDataInFlightActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TraceEventFields const& md,int loopDepth) 
	{
		loopDepth = a_body1cont2(md, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TraceEventFields && md,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(md), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDataInFlightActor*>(this)->actor_wait_state > 0) static_cast<GetDataInFlightActor*>(this)->actor_wait_state = 0;
		static_cast<GetDataInFlightActor*>(this)->ActorCallback< GetDataInFlightActor, 0, TraceEventFields >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataInFlightActor, 0, TraceEventFields >*,TraceEventFields const& value) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDataInFlightActor, 0, TraceEventFields >*,TraceEventFields && value) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDataInFlightActor, 0, TraceEventFields >*,Error err) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WorkerInterface distributorWorker;
															#line 1141 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getDataInFlight()
															#line 110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataInFlightActor final : public Actor<int64_t>, public ActorCallback< GetDataInFlightActor, 0, TraceEventFields >, public FastAllocated<GetDataInFlightActor>, public GetDataInFlightActorState<GetDataInFlightActor> {
															#line 1146 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetDataInFlightActor>::operator new;
	using FastAllocated<GetDataInFlightActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8733052170655946496UL, 2727989617610236160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDataInFlightActor, 0, TraceEventFields >;
															#line 110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataInFlightActor(Database const& cx,WorkerInterface const& distributorWorker) 
															#line 1163 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetDataInFlightActorState<GetDataInFlightActor>(cx, distributorWorker),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12984054617648128512UL, 5570494499612544512UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDataInFlight");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDataInFlightActor, 0, TraceEventFields >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<int64_t> getDataInFlight( Database const& cx, WorkerInterface const& distributorWorker ) {
															#line 110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<int64_t>(new GetDataInFlightActor(cx, distributorWorker));
															#line 1196 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 124 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets the number of bytes in flight from the data distributor.
															#line 1202 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getDataInFlight()
															#line 126 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetDataInFlightActor1>
															#line 126 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataInFlightActor1State {
															#line 1209 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 126 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataInFlightActor1State(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 126 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 126 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 126 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo)
															#line 1218 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getDataInFlight", reinterpret_cast<unsigned long>(this));

	}
	~GetDataInFlightActor1State() 
	{
		fdb_probe_actor_destroy("getDataInFlight", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 127 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<WorkerInterface> __when_expr_0 = getDataDistributorWorker(cx, dbInfo);
															#line 127 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetDataInFlightActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1235 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetDataInFlightActor1*>(this)->actor_wait_state = 1;
															#line 127 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDataInFlightActor1, 0, WorkerInterface >*>(static_cast<GetDataInFlightActor1*>(this)));
															#line 1240 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDataInFlightActor1State();
		static_cast<GetDataInFlightActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(WorkerInterface const& distributorInterf,int loopDepth) 
	{
															#line 128 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = getDataInFlight(cx, distributorInterf);
															#line 128 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetDataInFlightActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1265 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetDataInFlightActor1*>(this)->actor_wait_state = 2;
															#line 128 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetDataInFlightActor1, 1, int64_t >*>(static_cast<GetDataInFlightActor1*>(this)));
															#line 1270 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(WorkerInterface && distributorInterf,int loopDepth) 
	{
															#line 128 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = getDataInFlight(cx, distributorInterf);
															#line 128 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetDataInFlightActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1281 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetDataInFlightActor1*>(this)->actor_wait_state = 2;
															#line 128 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetDataInFlightActor1, 1, int64_t >*>(static_cast<GetDataInFlightActor1*>(this)));
															#line 1286 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(WorkerInterface const& distributorInterf,int loopDepth) 
	{
		loopDepth = a_body1cont1(distributorInterf, loopDepth);

		return loopDepth;
	}
	int a_body1when1(WorkerInterface && distributorInterf,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(distributorInterf), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDataInFlightActor1*>(this)->actor_wait_state > 0) static_cast<GetDataInFlightActor1*>(this)->actor_wait_state = 0;
		static_cast<GetDataInFlightActor1*>(this)->ActorCallback< GetDataInFlightActor1, 0, WorkerInterface >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataInFlightActor1, 0, WorkerInterface >*,WorkerInterface const& value) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDataInFlightActor1, 0, WorkerInterface >*,WorkerInterface && value) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDataInFlightActor1, 0, WorkerInterface >*,Error err) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int64_t const& dataInFlight,int loopDepth) 
	{
															#line 129 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataInFlightActor1*>(this)->SAV<int64_t>::futures) { (void)(dataInFlight); this->~GetDataInFlightActor1State(); static_cast<GetDataInFlightActor1*>(this)->destroy(); return 0; }
															#line 1370 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataInFlightActor1*>(this)->SAV< int64_t >::value()) int64_t(dataInFlight);
		this->~GetDataInFlightActor1State();
		static_cast<GetDataInFlightActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int64_t && dataInFlight,int loopDepth) 
	{
															#line 129 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataInFlightActor1*>(this)->SAV<int64_t>::futures) { (void)(dataInFlight); this->~GetDataInFlightActor1State(); static_cast<GetDataInFlightActor1*>(this)->destroy(); return 0; }
															#line 1382 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataInFlightActor1*>(this)->SAV< int64_t >::value()) int64_t(dataInFlight);
		this->~GetDataInFlightActor1State();
		static_cast<GetDataInFlightActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int64_t const& dataInFlight,int loopDepth) 
	{
		loopDepth = a_body1cont2(dataInFlight, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t && dataInFlight,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(dataInFlight), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetDataInFlightActor1*>(this)->actor_wait_state > 0) static_cast<GetDataInFlightActor1*>(this)->actor_wait_state = 0;
		static_cast<GetDataInFlightActor1*>(this)->ActorCallback< GetDataInFlightActor1, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataInFlightActor1, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetDataInFlightActor1, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetDataInFlightActor1, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 126 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 126 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1469 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getDataInFlight()
															#line 126 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataInFlightActor1 final : public Actor<int64_t>, public ActorCallback< GetDataInFlightActor1, 0, WorkerInterface >, public ActorCallback< GetDataInFlightActor1, 1, int64_t >, public FastAllocated<GetDataInFlightActor1>, public GetDataInFlightActor1State<GetDataInFlightActor1> {
															#line 1474 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetDataInFlightActor1>::operator new;
	using FastAllocated<GetDataInFlightActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8733052170655946496UL, 2727989617610236160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDataInFlightActor1, 0, WorkerInterface >;
friend struct ActorCallback< GetDataInFlightActor1, 1, int64_t >;
															#line 126 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataInFlightActor1(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 1492 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetDataInFlightActor1State<GetDataInFlightActor1>(cx, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16099919889532499712UL, 8724869199332730624UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDataInFlight");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDataInFlightActor1, 0, WorkerInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetDataInFlightActor1, 1, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 126 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<int64_t> getDataInFlight( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 126 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<int64_t>(new GetDataInFlightActor1(cx, dbInfo));
															#line 1526 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 131 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Computes the queue size for storage servers and tlogs using the bytesInput and bytesDurable attributes
int64_t getQueueSize(const TraceEventFields& md) {
	double inputRate, durableRate;
	double inputRoughness, durableRoughness;
	int64_t inputBytes, durableBytes;

	sscanf(md.getValue("BytesInput").c_str(), "%lf %lf %" SCNd64, &inputRate, &inputRoughness, &inputBytes);
	sscanf(md.getValue("BytesDurable").c_str(), "%lf %lf %" SCNd64, &durableRate, &durableRoughness, &durableBytes);

	return inputBytes - durableBytes;
}

int64_t getDurableVersion(const TraceEventFields& md) {
	return boost::lexical_cast<int64_t>(md.getValue("DurableVersion"));
}

// Computes the popped version lag for tlogs
int64_t getPoppedVersionLag(const TraceEventFields& md) {
	int64_t persistentDataDurableVersion = boost::lexical_cast<int64_t>(md.getValue("PersistentDataDurableVersion"));
	int64_t queuePoppedVersion = boost::lexical_cast<int64_t>(md.getValue("QueuePoppedVersion"));

	return persistentDataDurableVersion - queuePoppedVersion;
}

															#line 1555 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getCoordWorkers()
															#line 156 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetCoordWorkersActor>
															#line 156 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetCoordWorkersActorState {
															#line 1562 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 156 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetCoordWorkersActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 156 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 156 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 156 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo)
															#line 1571 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getCoordWorkers", reinterpret_cast<unsigned long>(this));

	}
	~GetCoordWorkersActorState() 
	{
		fdb_probe_actor_destroy("getCoordWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 158 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(dbInfo);
															#line 158 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetCoordWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1588 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetCoordWorkersActor*>(this)->actor_wait_state = 1;
															#line 158 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCoordWorkersActor, 0, std::vector<WorkerDetails> >*>(static_cast<GetCoordWorkersActor*>(this)));
															#line 1593 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCoordWorkersActorState();
		static_cast<GetCoordWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 160 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Optional<Value>> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); tr->setOption(FDBTransactionOptions::LOCK_AWARE); return tr->get(coordinatorsKey); });
															#line 160 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetCoordWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1618 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetCoordWorkersActor*>(this)->actor_wait_state = 2;
															#line 160 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetCoordWorkersActor, 1, Optional<Value> >*>(static_cast<GetCoordWorkersActor*>(this)));
															#line 1623 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 158 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		workers = __workers;
															#line 1632 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCoordWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetCoordWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetCoordWorkersActor*>(this)->ActorCallback< GetCoordWorkersActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< GetCoordWorkersActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCoordWorkersActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCoordWorkersActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<Value> const& coordinators,int loopDepth) 
	{
															#line 166 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!coordinators.present())
															#line 1711 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 167 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(operation_failed(), loopDepth);
															#line 1715 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 169 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ClusterConnectionString ccs(coordinators.get().toString());
															#line 170 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_2 = ccs.tryResolveHostnames();
															#line 170 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetCoordWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1723 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetCoordWorkersActor*>(this)->actor_wait_state = 3;
															#line 170 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >*>(static_cast<GetCoordWorkersActor*>(this)));
															#line 1728 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && coordinators,int loopDepth) 
	{
															#line 166 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!coordinators.present())
															#line 1737 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 167 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(operation_failed(), loopDepth);
															#line 1741 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 169 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ClusterConnectionString ccs(coordinators.get().toString());
															#line 170 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_2 = ccs.tryResolveHostnames();
															#line 170 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetCoordWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1749 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetCoordWorkersActor*>(this)->actor_wait_state = 3;
															#line 170 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >*>(static_cast<GetCoordWorkersActor*>(this)));
															#line 1754 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& coordinators,int loopDepth) 
	{
		loopDepth = a_body1cont2(coordinators, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && coordinators,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(coordinators), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetCoordWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetCoordWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetCoordWorkersActor*>(this)->ActorCallback< GetCoordWorkersActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetCoordWorkersActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetCoordWorkersActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetCoordWorkersActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(std::vector<NetworkAddress> const& coordinatorsAddr,int loopDepth) 
	{
															#line 171 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::set<NetworkAddress> coordinatorsAddrSet;
															#line 172 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( const auto& addr : coordinatorsAddr ) {
															#line 173 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent(SevDebug, "CoordinatorAddress").detail("Addr", addr);
															#line 174 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			coordinatorsAddrSet.insert(addr);
															#line 1844 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 177 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::vector<WorkerInterface> result;
															#line 178 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( const auto& worker : workers ) {
															#line 179 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			NetworkAddress primary = worker.interf.address();
															#line 180 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			Optional<NetworkAddress> secondary = worker.interf.tLog.getEndpoint().addresses.secondaryAddress;
															#line 181 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (coordinatorsAddrSet.find(primary) != coordinatorsAddrSet.end() || (secondary.present() && (coordinatorsAddrSet.find(secondary.get()) != coordinatorsAddrSet.end())))
															#line 1856 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 183 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				result.push_back(worker.interf);
															#line 1860 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
		}
															#line 186 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetCoordWorkersActor*>(this)->SAV<std::vector<WorkerInterface>>::futures) { (void)(result); this->~GetCoordWorkersActorState(); static_cast<GetCoordWorkersActor*>(this)->destroy(); return 0; }
															#line 1865 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetCoordWorkersActor*>(this)->SAV< std::vector<WorkerInterface> >::value()) std::vector<WorkerInterface>(result);
		this->~GetCoordWorkersActorState();
		static_cast<GetCoordWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(std::vector<NetworkAddress> && coordinatorsAddr,int loopDepth) 
	{
															#line 171 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::set<NetworkAddress> coordinatorsAddrSet;
															#line 172 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( const auto& addr : coordinatorsAddr ) {
															#line 173 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent(SevDebug, "CoordinatorAddress").detail("Addr", addr);
															#line 174 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			coordinatorsAddrSet.insert(addr);
															#line 1883 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 177 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::vector<WorkerInterface> result;
															#line 178 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( const auto& worker : workers ) {
															#line 179 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			NetworkAddress primary = worker.interf.address();
															#line 180 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			Optional<NetworkAddress> secondary = worker.interf.tLog.getEndpoint().addresses.secondaryAddress;
															#line 181 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (coordinatorsAddrSet.find(primary) != coordinatorsAddrSet.end() || (secondary.present() && (coordinatorsAddrSet.find(secondary.get()) != coordinatorsAddrSet.end())))
															#line 1895 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 183 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				result.push_back(worker.interf);
															#line 1899 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
		}
															#line 186 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetCoordWorkersActor*>(this)->SAV<std::vector<WorkerInterface>>::futures) { (void)(result); this->~GetCoordWorkersActorState(); static_cast<GetCoordWorkersActor*>(this)->destroy(); return 0; }
															#line 1904 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetCoordWorkersActor*>(this)->SAV< std::vector<WorkerInterface> >::value()) std::vector<WorkerInterface>(result);
		this->~GetCoordWorkersActorState();
		static_cast<GetCoordWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<NetworkAddress> const& coordinatorsAddr,int loopDepth) 
	{
		loopDepth = a_body1cont3(coordinatorsAddr, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<NetworkAddress> && coordinatorsAddr,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(coordinatorsAddr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetCoordWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetCoordWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetCoordWorkersActor*>(this)->ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 156 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 156 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 158 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 1993 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getCoordWorkers()
															#line 156 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetCoordWorkersActor final : public Actor<std::vector<WorkerInterface>>, public ActorCallback< GetCoordWorkersActor, 0, std::vector<WorkerDetails> >, public ActorCallback< GetCoordWorkersActor, 1, Optional<Value> >, public ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >, public FastAllocated<GetCoordWorkersActor>, public GetCoordWorkersActorState<GetCoordWorkersActor> {
															#line 1998 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetCoordWorkersActor>::operator new;
	using FastAllocated<GetCoordWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6929053089821405440UL, 10719153008283634688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<WorkerInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCoordWorkersActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< GetCoordWorkersActor, 1, Optional<Value> >;
friend struct ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >;
															#line 156 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetCoordWorkersActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 2017 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<std::vector<WorkerInterface>>(),
		   GetCoordWorkersActorState<GetCoordWorkersActor>(cx, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6656396714784752384UL, 15106635022399449344UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCoordWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCoordWorkersActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetCoordWorkersActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 156 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<std::vector<WorkerInterface>> getCoordWorkers( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 156 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<std::vector<WorkerInterface>>(new GetCoordWorkersActor(cx, dbInfo));
															#line 2052 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 188 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// This is not robust in the face of a TLog failure
															#line 2058 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getTLogQueueInfo()
															#line 190 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetTLogQueueInfoActor>
															#line 190 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetTLogQueueInfoActorState {
															#line 2065 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 190 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetTLogQueueInfoActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 190 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 190 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 190 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo)
															#line 2074 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getTLogQueueInfo", reinterpret_cast<unsigned long>(this));

	}
	~GetTLogQueueInfoActorState() 
	{
		fdb_probe_actor_destroy("getTLogQueueInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 192 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("MaxTLogQueueSize").detail("Stage", "ContactingLogs");
															#line 194 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(dbInfo);
															#line 194 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetTLogQueueInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2093 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTLogQueueInfoActor*>(this)->actor_wait_state = 1;
															#line 194 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTLogQueueInfoActor, 0, std::vector<WorkerDetails> >*>(static_cast<GetTLogQueueInfoActor*>(this)));
															#line 2098 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTLogQueueInfoActorState();
		static_cast<GetTLogQueueInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 195 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::map<NetworkAddress, WorkerInterface> workersMap;
															#line 196 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( auto worker : workers ) {
															#line 197 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			workersMap[worker.interf.address()] = worker.interf;
															#line 2125 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 200 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		messages = std::vector<Future<TraceEventFields>>();
															#line 201 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tlogs = dbInfo->get().logSystemConfig.allPresentLogs();
															#line 202 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for(int i = 0;i < tlogs.size();i++) {
															#line 203 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			auto itr = workersMap.find(tlogs[i].address());
															#line 204 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (itr == workersMap.end())
															#line 2137 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 205 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("QuietDatabaseFailure") .detail("Reason", "Could not find worker for log server") .detail("Tlog", tlogs[i].id());
															#line 208 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				return a_body1Catch1(attribute_not_found(), loopDepth);
															#line 2143 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 210 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			messages.push_back(timeoutError( itr->second.eventLogRequest.getReply(EventLogRequest(StringRef(tlogs[i].id().toString() + "/TLogMetrics"))), 1.0));
															#line 2147 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 214 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(messages);
															#line 214 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetTLogQueueInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2153 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetTLogQueueInfoActor*>(this)->actor_wait_state = 2;
															#line 214 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTLogQueueInfoActor, 1, Void >*>(static_cast<GetTLogQueueInfoActor*>(this)));
															#line 2158 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 194 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		workers = __workers;
															#line 2167 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTLogQueueInfoActor*>(this)->actor_wait_state > 0) static_cast<GetTLogQueueInfoActor*>(this)->actor_wait_state = 0;
		static_cast<GetTLogQueueInfoActor*>(this)->ActorCallback< GetTLogQueueInfoActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTLogQueueInfoActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTLogQueueInfoActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTLogQueueInfoActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 216 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("MaxTLogQueueSize").detail("Stage", "ComputingMax").detail("MessageCount", messages.size());
															#line 218 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxQueueSize = 0;
															#line 219 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxPoppedVersionLag = 0;
															#line 220 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		i = 0;
															#line 221 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 2254 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 216 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("MaxTLogQueueSize").detail("Stage", "ComputingMax").detail("MessageCount", messages.size());
															#line 218 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxQueueSize = 0;
															#line 219 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxPoppedVersionLag = 0;
															#line 220 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		i = 0;
															#line 221 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 2271 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetTLogQueueInfoActor*>(this)->actor_wait_state > 0) static_cast<GetTLogQueueInfoActor*>(this)->actor_wait_state = 0;
		static_cast<GetTLogQueueInfoActor*>(this)->ActorCallback< GetTLogQueueInfoActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTLogQueueInfoActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTLogQueueInfoActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTLogQueueInfoActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 233 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetTLogQueueInfoActor*>(this)->SAV<std::pair<int64_t, int64_t>>::futures) { (void)(std::make_pair(maxQueueSize, maxPoppedVersionLag)); this->~GetTLogQueueInfoActorState(); static_cast<GetTLogQueueInfoActor*>(this)->destroy(); return 0; }
															#line 2355 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetTLogQueueInfoActor*>(this)->SAV< std::pair<int64_t, int64_t> >::value()) std::pair<int64_t, int64_t>(std::make_pair(maxQueueSize, maxPoppedVersionLag));
		this->~GetTLogQueueInfoActorState();
		static_cast<GetTLogQueueInfoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 221 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!(i < messages.size()))
															#line 2374 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 223 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			maxQueueSize = std::max(maxQueueSize, getQueueSize(messages[i].get()));
															#line 224 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			maxPoppedVersionLag = std::max(maxPoppedVersionLag, getPoppedVersionLag(messages[i].get()));
															#line 2383 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1cont2loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 221 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		i++;
															#line 2411 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 226 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseFailure") .detail("Reason", "Failed to extract MaxTLogQueue") .detail("Tlog", tlogs[i].id());
															#line 229 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2423 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 190 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 190 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 194 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 200 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<Future<TraceEventFields>> messages;
															#line 201 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<TLogInterface> tlogs;
															#line 218 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxQueueSize;
															#line 219 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxPoppedVersionLag;
															#line 220 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int i;
															#line 2462 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getTLogQueueInfo()
															#line 190 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetTLogQueueInfoActor final : public Actor<std::pair<int64_t, int64_t>>, public ActorCallback< GetTLogQueueInfoActor, 0, std::vector<WorkerDetails> >, public ActorCallback< GetTLogQueueInfoActor, 1, Void >, public FastAllocated<GetTLogQueueInfoActor>, public GetTLogQueueInfoActorState<GetTLogQueueInfoActor> {
															#line 2467 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetTLogQueueInfoActor>::operator new;
	using FastAllocated<GetTLogQueueInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14232175198032837120UL, 16077666738875982592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<int64_t, int64_t>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTLogQueueInfoActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< GetTLogQueueInfoActor, 1, Void >;
															#line 190 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetTLogQueueInfoActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 2485 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<std::pair<int64_t, int64_t>>(),
		   GetTLogQueueInfoActorState<GetTLogQueueInfoActor>(cx, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(370706174253031168UL, 8003024138511153152UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTLogQueueInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTLogQueueInfoActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetTLogQueueInfoActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 190 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<std::pair<int64_t, int64_t>> getTLogQueueInfo( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 190 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<std::pair<int64_t, int64_t>>(new GetTLogQueueInfoActor(cx, dbInfo));
															#line 2519 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 235 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

															#line 2524 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getStorageServers()
															#line 236 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetStorageServersActor>
															#line 236 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetStorageServersActorState {
															#line 2531 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 236 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetStorageServersActorState(Database const& cx,bool const& use_system_priority = false) 
															#line 236 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 236 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 236 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   use_system_priority(use_system_priority),
															#line 237 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   tr(cx)
															#line 2542 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getStorageServers", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageServersActorState() 
	{
		fdb_probe_actor_destroy("getStorageServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 238 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 2557 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 239 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (use_system_priority)
															#line 2587 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 240 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2591 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 242 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 243 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2597 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		try {
															#line 245 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 245 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetStorageServersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2603 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetStorageServersActor*>(this)->actor_wait_state = 1;
															#line 245 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageServersActor, 0, RangeResult >*>(static_cast<GetStorageServersActor*>(this)));
															#line 2608 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 254 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 254 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetStorageServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2632 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetStorageServersActor*>(this)->actor_wait_state = 2;
															#line 254 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetStorageServersActor, 1, Void >*>(static_cast<GetStorageServersActor*>(this)));
															#line 2637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult const& serverList,int loopDepth) 
	{
															#line 246 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 248 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::vector<StorageServerInterface> servers;
															#line 249 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		servers.reserve(serverList.size());
															#line 250 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 251 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			servers.push_back(decodeServerListValue(serverList[i].value));
															#line 2660 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 252 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetStorageServersActor*>(this)->SAV<std::vector<StorageServerInterface>>::futures) { (void)(servers); this->~GetStorageServersActorState(); static_cast<GetStorageServersActor*>(this)->destroy(); return 0; }
															#line 2664 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetStorageServersActor*>(this)->SAV< std::vector<StorageServerInterface> >::value()) std::vector<StorageServerInterface>(servers);
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && serverList,int loopDepth) 
	{
															#line 246 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 248 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::vector<StorageServerInterface> servers;
															#line 249 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		servers.reserve(serverList.size());
															#line 250 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 251 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			servers.push_back(decodeServerListValue(serverList[i].value));
															#line 2684 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 252 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetStorageServersActor*>(this)->SAV<std::vector<StorageServerInterface>>::futures) { (void)(servers); this->~GetStorageServersActorState(); static_cast<GetStorageServersActor*>(this)->destroy(); return 0; }
															#line 2688 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetStorageServersActor*>(this)->SAV< std::vector<StorageServerInterface> >::value()) std::vector<StorageServerInterface>(servers);
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(serverList, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(serverList), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageServersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServersActor*>(this)->ActorCallback< GetStorageServersActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageServersActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetStorageServersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServersActor*>(this)->ActorCallback< GetStorageServersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetStorageServersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 236 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 236 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool use_system_priority;
															#line 237 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Transaction tr;
															#line 2864 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getStorageServers()
															#line 236 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetStorageServersActor final : public Actor<std::vector<StorageServerInterface>>, public ActorCallback< GetStorageServersActor, 0, RangeResult >, public ActorCallback< GetStorageServersActor, 1, Void >, public FastAllocated<GetStorageServersActor>, public GetStorageServersActorState<GetStorageServersActor> {
															#line 2869 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetStorageServersActor>::operator new;
	using FastAllocated<GetStorageServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2904817759406537984UL, 709183148524152576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<StorageServerInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageServersActor, 0, RangeResult >;
friend struct ActorCallback< GetStorageServersActor, 1, Void >;
															#line 236 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetStorageServersActor(Database const& cx,bool const& use_system_priority = false) 
															#line 2887 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<std::vector<StorageServerInterface>>(),
		   GetStorageServersActorState<GetStorageServersActor>(cx, use_system_priority),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(503193769027834112UL, 12559137560131112960UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageServersActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetStorageServersActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 236 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<std::vector<StorageServerInterface>> getStorageServers( Database const& cx, bool const& use_system_priority = false ) {
															#line 236 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<std::vector<StorageServerInterface>>(new GetStorageServersActor(cx, use_system_priority));
															#line 2921 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 258 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

															#line 2926 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getStorageWorkers()
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetStorageWorkersActor>
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetStorageWorkersActorState {
															#line 2933 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetStorageWorkersActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,bool const& localOnly) 
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo),
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   localOnly(localOnly)
															#line 2944 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getStorageWorkers", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageWorkersActorState() 
	{
		fdb_probe_actor_destroy("getStorageWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 261 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<std::vector<StorageServerInterface>> __when_expr_0 = getStorageServers(cx);
															#line 261 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetStorageWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetStorageWorkersActor*>(this)->actor_wait_state = 1;
															#line 261 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageWorkersActor, 0, std::vector<StorageServerInterface> >*>(static_cast<GetStorageWorkersActor*>(this)));
															#line 2966 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageWorkersActorState();
		static_cast<GetStorageWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 262 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		workersMap = std::map<NetworkAddress, WorkerInterface>();
															#line 263 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_1 = getWorkers(dbInfo);
															#line 263 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetStorageWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2993 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetStorageWorkersActor*>(this)->actor_wait_state = 2;
															#line 263 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetStorageWorkersActor, 1, std::vector<WorkerDetails> >*>(static_cast<GetStorageWorkersActor*>(this)));
															#line 2998 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> const& __servers,int loopDepth) 
	{
															#line 261 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		servers = __servers;
															#line 3007 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> && __servers,int loopDepth) 
	{
		servers = std::move(__servers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageWorkersActor*>(this)->ActorCallback< GetStorageWorkersActor, 0, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageWorkersActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageWorkersActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageWorkersActor, 0, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
															#line 265 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( const auto& worker : workers ) {
															#line 266 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			workersMap[worker.interf.address()] = worker.interf;
															#line 3088 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 268 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Optional<Value>> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); tr->setOption(FDBTransactionOptions::LOCK_AWARE); return tr->get("usable_regions"_sr.withPrefix(configKeysPrefix)); });
															#line 268 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetStorageWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3094 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetStorageWorkersActor*>(this)->actor_wait_state = 3;
															#line 268 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >*>(static_cast<GetStorageWorkersActor*>(this)));
															#line 3099 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
															#line 265 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( const auto& worker : workers ) {
															#line 266 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			workersMap[worker.interf.address()] = worker.interf;
															#line 3110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 268 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Optional<Value>> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); tr->setOption(FDBTransactionOptions::LOCK_AWARE); return tr->get("usable_regions"_sr.withPrefix(configKeysPrefix)); });
															#line 268 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetStorageWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3116 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetStorageWorkersActor*>(this)->actor_wait_state = 3;
															#line 268 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >*>(static_cast<GetStorageWorkersActor*>(this)));
															#line 3121 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
		loopDepth = a_body1cont2(workers, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetStorageWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageWorkersActor*>(this)->ActorCallback< GetStorageWorkersActor, 1, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageWorkersActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetStorageWorkersActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetStorageWorkersActor, 1, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Optional<Value> const& regionsValue,int loopDepth) 
	{
															#line 274 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int usableRegions = 1;
															#line 275 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (regionsValue.present())
															#line 3207 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 276 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			usableRegions = atoi(regionsValue.get().toString().c_str());
															#line 3211 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 278 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		auto masterDcId = dbInfo->get().master.locality.dcId();
															#line 280 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::pair<std::vector<WorkerInterface>, int> result;
															#line 281 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		auto& [workerInterfaces, failures] = result;
															#line 282 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		failures = 0;
															#line 283 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( const auto& server : servers ) {
															#line 284 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent(SevDebug, "DcIdInfo") .detail("ServerLocalityID", server.locality.dcId()) .detail("MasterDcID", masterDcId);
															#line 287 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!localOnly || (usableRegions == 1 || server.locality.dcId() == masterDcId))
															#line 3227 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 288 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto itr = workersMap.find(server.address());
															#line 289 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (itr == workersMap.end())
															#line 3233 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				{
															#line 290 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					TraceEvent(SevWarn, "GetStorageWorkers") .detail("Reason", "Could not find worker for storage server") .detail("SS", server.id());
															#line 293 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					++failures;
															#line 3239 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				}
				else
				{
															#line 295 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					workerInterfaces.push_back(itr->second);
															#line 3245 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				}
			}
		}
															#line 299 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetStorageWorkersActor*>(this)->SAV<std::pair<std::vector<WorkerInterface>, int>>::futures) { (void)(result); this->~GetStorageWorkersActorState(); static_cast<GetStorageWorkersActor*>(this)->destroy(); return 0; }
															#line 3251 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetStorageWorkersActor*>(this)->SAV< std::pair<std::vector<WorkerInterface>, int> >::value()) std::pair<std::vector<WorkerInterface>, int>(result);
		this->~GetStorageWorkersActorState();
		static_cast<GetStorageWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Optional<Value> && regionsValue,int loopDepth) 
	{
															#line 274 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int usableRegions = 1;
															#line 275 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (regionsValue.present())
															#line 3265 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 276 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			usableRegions = atoi(regionsValue.get().toString().c_str());
															#line 3269 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 278 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		auto masterDcId = dbInfo->get().master.locality.dcId();
															#line 280 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::pair<std::vector<WorkerInterface>, int> result;
															#line 281 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		auto& [workerInterfaces, failures] = result;
															#line 282 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		failures = 0;
															#line 283 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( const auto& server : servers ) {
															#line 284 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent(SevDebug, "DcIdInfo") .detail("ServerLocalityID", server.locality.dcId()) .detail("MasterDcID", masterDcId);
															#line 287 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!localOnly || (usableRegions == 1 || server.locality.dcId() == masterDcId))
															#line 3285 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 288 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto itr = workersMap.find(server.address());
															#line 289 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (itr == workersMap.end())
															#line 3291 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				{
															#line 290 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					TraceEvent(SevWarn, "GetStorageWorkers") .detail("Reason", "Could not find worker for storage server") .detail("SS", server.id());
															#line 293 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					++failures;
															#line 3297 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				}
				else
				{
															#line 295 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					workerInterfaces.push_back(itr->second);
															#line 3303 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				}
			}
		}
															#line 299 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetStorageWorkersActor*>(this)->SAV<std::pair<std::vector<WorkerInterface>, int>>::futures) { (void)(result); this->~GetStorageWorkersActorState(); static_cast<GetStorageWorkersActor*>(this)->destroy(); return 0; }
															#line 3309 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetStorageWorkersActor*>(this)->SAV< std::pair<std::vector<WorkerInterface>, int> >::value()) std::pair<std::vector<WorkerInterface>, int>(result);
		this->~GetStorageWorkersActorState();
		static_cast<GetStorageWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Optional<Value> const& regionsValue,int loopDepth) 
	{
		loopDepth = a_body1cont3(regionsValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<Value> && regionsValue,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(regionsValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetStorageWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageWorkersActor*>(this)->ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool localOnly;
															#line 261 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<StorageServerInterface> servers;
															#line 262 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::map<NetworkAddress, WorkerInterface> workersMap;
															#line 3402 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getStorageWorkers()
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetStorageWorkersActor final : public Actor<std::pair<std::vector<WorkerInterface>, int>>, public ActorCallback< GetStorageWorkersActor, 0, std::vector<StorageServerInterface> >, public ActorCallback< GetStorageWorkersActor, 1, std::vector<WorkerDetails> >, public ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >, public FastAllocated<GetStorageWorkersActor>, public GetStorageWorkersActorState<GetStorageWorkersActor> {
															#line 3407 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetStorageWorkersActor>::operator new;
	using FastAllocated<GetStorageWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12305925607560892672UL, 6138942999050760192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<std::vector<WorkerInterface>, int>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageWorkersActor, 0, std::vector<StorageServerInterface> >;
friend struct ActorCallback< GetStorageWorkersActor, 1, std::vector<WorkerDetails> >;
friend struct ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >;
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetStorageWorkersActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,bool const& localOnly) 
															#line 3426 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<std::pair<std::vector<WorkerInterface>, int>>(),
		   GetStorageWorkersActorState<GetStorageWorkersActor>(cx, dbInfo, localOnly),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10929927552547220992UL, 12825001964226426112UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageWorkersActor, 0, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetStorageWorkersActor, 1, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<std::pair<std::vector<WorkerInterface>, int>> getStorageWorkers( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, bool const& localOnly ) {
															#line 259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<std::pair<std::vector<WorkerInterface>, int>>(new GetStorageWorkersActor(cx, dbInfo, localOnly));
															#line 3461 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 301 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Helper function to extract he maximum SQ size of all provided messages. All futures in the
// messages vector have to be ready.
int64_t extractMaxQueueSize(const std::vector<Future<TraceEventFields>>& messages,
                            const std::vector<StorageServerInterface>& servers) {

	int64_t maxQueueSize = 0;
	UID maxQueueServer;

	for (int i = 0; i < messages.size(); i++) {
		try {
			auto queueSize = getQueueSize(messages[i].get());
			if (queueSize > maxQueueSize) {
				maxQueueSize = queueSize;
				maxQueueServer = servers[i].id();
			}
		} catch (Error& e) {
			TraceEvent("QuietDatabaseFailure")
			    .detail("Reason", "Failed to extract MaxStorageServerQueue")
			    .detail("SS", servers[i].id());
			for (auto& m : messages) {
				TraceEvent("Messages").detail("Info", m.get().toString());
			}
			throw;
		}
	}

	TraceEvent("QuietDatabaseGotMaxStorageServerQueueSize")
	    .detail("Stage", "MaxComputed")
	    .detail("Max", maxQueueSize)
	    .detail("MaxQueueServer", maxQueueServer);
	return maxQueueSize;
}

// Timeout wrapper when getting the storage metrics. This will do some additional tracing
															#line 3500 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getStorageMetricsTimeout()
															#line 336 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetStorageMetricsTimeoutActor>
															#line 336 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetStorageMetricsTimeoutActorState {
															#line 3507 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 336 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetStorageMetricsTimeoutActorState(UID const& storage,WorkerInterface const& wi,Version const& version) 
															#line 336 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 336 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : storage(storage),
															#line 336 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   wi(wi),
															#line 336 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   version(version),
															#line 337 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   retries(0)
															#line 3520 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageMetricsTimeoutActorState() 
	{
		fdb_probe_actor_destroy("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 338 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 3535 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageMetricsTimeoutActorState();
		static_cast<GetStorageMetricsTimeoutActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 339 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		++retries;
															#line 340 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		eventLogReply = wi.eventLogRequest.getReply(EventLogRequest(StringRef(storage.toString() + "/StorageMetrics")));
															#line 342 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		timeout = delay(30.0);
															#line 343 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		storageMetrics = TraceEventFields();
															#line 345 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_0 = store(storageMetrics, eventLogReply);
															#line 344 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetStorageMetricsTimeoutActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3575 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 360 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = timeout;
															#line 3579 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<GetStorageMetricsTimeoutActor*>(this)->actor_wait_state = 1;
															#line 345 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageMetricsTimeoutActor, 0, Void >*>(static_cast<GetStorageMetricsTimeoutActor*>(this)));
															#line 360 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetStorageMetricsTimeoutActor, 1, Void >*>(static_cast<GetStorageMetricsTimeoutActor*>(this)));
															#line 3586 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 367 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (retries > 30)
															#line 3595 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 368 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseFailure") .detail("Reason", "Could not fetch StorageMetrics x30") .detail("Storage", storage) .detail("Version", version);
															#line 372 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(timed_out(), std::max(0, loopDepth - 1));
															#line 3601 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 374 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(1.0);
															#line 374 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetStorageMetricsTimeoutActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3607 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetStorageMetricsTimeoutActor*>(this)->actor_wait_state = 2;
															#line 374 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetStorageMetricsTimeoutActor, 2, Void >*>(static_cast<GetStorageMetricsTimeoutActor*>(this)));
															#line 3612 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		try {
															#line 347 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (version == invalidVersion || getDurableVersion(storageMetrics) >= static_cast<int64_t>(version))
															#line 3622 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 349 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<GetStorageMetricsTimeoutActor*>(this)->SAV<TraceEventFields>::futures) { (void)(storageMetrics); this->~GetStorageMetricsTimeoutActorState(); static_cast<GetStorageMetricsTimeoutActor*>(this)->destroy(); return 0; }
															#line 3626 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<GetStorageMetricsTimeoutActor*>(this)->SAV< TraceEventFields >::value()) TraceEventFields(std::move(storageMetrics)); // state_var_RVO
				this->~GetStorageMetricsTimeoutActorState();
				static_cast<GetStorageMetricsTimeoutActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			loopDepth = a_body1loopBody1when1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1when1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1when1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		try {
															#line 347 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (version == invalidVersion || getDurableVersion(storageMetrics) >= static_cast<int64_t>(version))
															#line 3647 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 349 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<GetStorageMetricsTimeoutActor*>(this)->SAV<TraceEventFields>::futures) { (void)(storageMetrics); this->~GetStorageMetricsTimeoutActorState(); static_cast<GetStorageMetricsTimeoutActor*>(this)->destroy(); return 0; }
															#line 3651 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<GetStorageMetricsTimeoutActor*>(this)->SAV< TraceEventFields >::value()) TraceEventFields(std::move(storageMetrics)); // state_var_RVO
				this->~GetStorageMetricsTimeoutActorState();
				static_cast<GetStorageMetricsTimeoutActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			loopDepth = a_body1loopBody1when1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1when1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1when1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 361 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("QuietDatabaseFailure") .detail("Reason", "Could not fetch StorageMetrics") .detail("Storage", storage);
															#line 364 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		return a_body1Catch1(timed_out(), std::max(0, loopDepth - 1));
															#line 3673 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 361 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("QuietDatabaseFailure") .detail("Reason", "Could not fetch StorageMetrics") .detail("Storage", storage);
															#line 364 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		return a_body1Catch1(timed_out(), std::max(0, loopDepth - 1));
															#line 3683 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageMetricsTimeoutActor*>(this)->actor_wait_state > 0) static_cast<GetStorageMetricsTimeoutActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageMetricsTimeoutActor*>(this)->ActorCallback< GetStorageMetricsTimeoutActor, 0, Void >::remove();
		static_cast<GetStorageMetricsTimeoutActor*>(this)->ActorCallback< GetStorageMetricsTimeoutActor, 1, Void >::remove();

	}
	int a_body1loopBody1when1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 352 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseFailure") .error(e) .detail("Reason", "Failed to extract DurableVersion from StorageMetrics") .detail("SSID", storage) .detail("StorageMetrics", storageMetrics.toString());
															#line 357 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3707 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1when1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	void a_callback_fire(ActorCallback< GetStorageMetricsTimeoutActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageMetricsTimeoutActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageMetricsTimeoutActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageMetricsTimeoutActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetStorageMetricsTimeoutActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetStorageMetricsTimeoutActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetStorageMetricsTimeoutActor*>(this)->actor_wait_state > 0) static_cast<GetStorageMetricsTimeoutActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageMetricsTimeoutActor*>(this)->ActorCallback< GetStorageMetricsTimeoutActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageMetricsTimeoutActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetStorageMetricsTimeoutActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetStorageMetricsTimeoutActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 336 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	UID storage;
															#line 336 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WorkerInterface wi;
															#line 336 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Version version;
															#line 337 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int retries;
															#line 340 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<TraceEventFields> eventLogReply;
															#line 342 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<Void> timeout;
															#line 343 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	TraceEventFields storageMetrics;
															#line 3945 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getStorageMetricsTimeout()
															#line 336 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetStorageMetricsTimeoutActor final : public Actor<TraceEventFields>, public ActorCallback< GetStorageMetricsTimeoutActor, 0, Void >, public ActorCallback< GetStorageMetricsTimeoutActor, 1, Void >, public ActorCallback< GetStorageMetricsTimeoutActor, 2, Void >, public FastAllocated<GetStorageMetricsTimeoutActor>, public GetStorageMetricsTimeoutActorState<GetStorageMetricsTimeoutActor> {
															#line 3950 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetStorageMetricsTimeoutActor>::operator new;
	using FastAllocated<GetStorageMetricsTimeoutActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2363931405489816832UL, 6382876869067677696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<TraceEventFields>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageMetricsTimeoutActor, 0, Void >;
friend struct ActorCallback< GetStorageMetricsTimeoutActor, 1, Void >;
friend struct ActorCallback< GetStorageMetricsTimeoutActor, 2, Void >;
															#line 336 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetStorageMetricsTimeoutActor(UID const& storage,WorkerInterface const& wi,Version const& version) 
															#line 3969 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<TraceEventFields>(),
		   GetStorageMetricsTimeoutActorState<GetStorageMetricsTimeoutActor>(storage, wi, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7551662535136818944UL, 6468539700573326848UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageMetricsTimeout");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageMetricsTimeoutActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetStorageMetricsTimeoutActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 336 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<TraceEventFields> getStorageMetricsTimeout( UID const& storage, WorkerInterface const& wi, Version const& version ) {
															#line 336 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<TraceEventFields>(new GetStorageMetricsTimeoutActor(storage, wi, version));
															#line 4003 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 377 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets the maximum size of all the storage server queues
															#line 4009 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getMaxStorageServerQueueSize()
															#line 379 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetMaxStorageServerQueueSizeActor>
															#line 379 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetMaxStorageServerQueueSizeActorState {
															#line 4016 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 379 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetMaxStorageServerQueueSizeActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Version const& version) 
															#line 379 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 379 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 379 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo),
															#line 379 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   version(version)
															#line 4027 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this));

	}
	~GetMaxStorageServerQueueSizeActorState() 
	{
		fdb_probe_actor_destroy("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 383 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("MaxStorageServerQueueSize").detail("Stage", "ContactingStorageServers");
															#line 385 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			Future<std::vector<StorageServerInterface>> serversFuture = getStorageServers(cx);
															#line 386 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			workersFuture = getWorkers(dbInfo);
															#line 388 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<std::vector<StorageServerInterface>> __when_expr_0 = serversFuture;
															#line 388 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4050 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state = 1;
															#line 388 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetMaxStorageServerQueueSizeActor, 0, std::vector<StorageServerInterface> >*>(static_cast<GetMaxStorageServerQueueSizeActor*>(this)));
															#line 4055 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetMaxStorageServerQueueSizeActorState();
		static_cast<GetMaxStorageServerQueueSizeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 389 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_1 = workersFuture;
															#line 389 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4080 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state = 2;
															#line 389 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetMaxStorageServerQueueSizeActor, 1, std::vector<WorkerDetails> >*>(static_cast<GetMaxStorageServerQueueSizeActor*>(this)));
															#line 4085 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> const& __servers,int loopDepth) 
	{
															#line 388 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		servers = __servers;
															#line 4094 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> && __servers,int loopDepth) 
	{
		servers = std::move(__servers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state > 0) static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetMaxStorageServerQueueSizeActor*>(this)->ActorCallback< GetMaxStorageServerQueueSizeActor, 0, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< GetMaxStorageServerQueueSizeActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetMaxStorageServerQueueSizeActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetMaxStorageServerQueueSizeActor, 0, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 391 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::map<NetworkAddress, WorkerInterface> workersMap;
															#line 392 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( auto worker : workers ) {
															#line 393 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			workersMap[worker.interf.address()] = worker.interf;
															#line 4177 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 396 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		messages = std::vector<Future<TraceEventFields>>();
															#line 397 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for(int i = 0;i < servers.size();i++) {
															#line 398 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			auto itr = workersMap.find(servers[i].address());
															#line 399 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (itr == workersMap.end())
															#line 4187 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 400 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("QuietDatabaseFailure") .detail("Reason", "Could not find worker for storage server") .detail("SS", servers[i].id());
															#line 403 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				return a_body1Catch1(attribute_not_found(), loopDepth);
															#line 4193 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 405 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			messages.push_back(getStorageMetricsTimeout(servers[i].id(), itr->second, version));
															#line 4197 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 408 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(messages);
															#line 408 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4203 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state = 3;
															#line 408 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetMaxStorageServerQueueSizeActor, 2, Void >*>(static_cast<GetMaxStorageServerQueueSizeActor*>(this)));
															#line 4208 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 389 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		workers = __workers;
															#line 4217 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state > 0) static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetMaxStorageServerQueueSizeActor*>(this)->ActorCallback< GetMaxStorageServerQueueSizeActor, 1, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< GetMaxStorageServerQueueSizeActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetMaxStorageServerQueueSizeActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetMaxStorageServerQueueSizeActor, 1, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 410 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("MaxStorageServerQueueSize").detail("Stage", "ComputingMax").detail("MessageCount", messages.size());
															#line 412 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetMaxStorageServerQueueSizeActor*>(this)->SAV<int64_t>::futures) { (void)(extractMaxQueueSize(messages, servers)); this->~GetMaxStorageServerQueueSizeActorState(); static_cast<GetMaxStorageServerQueueSizeActor*>(this)->destroy(); return 0; }
															#line 4298 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetMaxStorageServerQueueSizeActor*>(this)->SAV< int64_t >::value()) int64_t(extractMaxQueueSize(messages, servers));
		this->~GetMaxStorageServerQueueSizeActorState();
		static_cast<GetMaxStorageServerQueueSizeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 410 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("MaxStorageServerQueueSize").detail("Stage", "ComputingMax").detail("MessageCount", messages.size());
															#line 412 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetMaxStorageServerQueueSizeActor*>(this)->SAV<int64_t>::futures) { (void)(extractMaxQueueSize(messages, servers)); this->~GetMaxStorageServerQueueSizeActorState(); static_cast<GetMaxStorageServerQueueSizeActor*>(this)->destroy(); return 0; }
															#line 4312 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetMaxStorageServerQueueSizeActor*>(this)->SAV< int64_t >::value()) int64_t(extractMaxQueueSize(messages, servers));
		this->~GetMaxStorageServerQueueSizeActorState();
		static_cast<GetMaxStorageServerQueueSizeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state > 0) static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetMaxStorageServerQueueSizeActor*>(this)->ActorCallback< GetMaxStorageServerQueueSizeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetMaxStorageServerQueueSizeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetMaxStorageServerQueueSizeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetMaxStorageServerQueueSizeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 379 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 379 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 379 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Version version;
															#line 386 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<std::vector<WorkerDetails>> workersFuture;
															#line 388 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<StorageServerInterface> servers;
															#line 389 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 396 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<Future<TraceEventFields>> messages;
															#line 4409 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getMaxStorageServerQueueSize()
															#line 379 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetMaxStorageServerQueueSizeActor final : public Actor<int64_t>, public ActorCallback< GetMaxStorageServerQueueSizeActor, 0, std::vector<StorageServerInterface> >, public ActorCallback< GetMaxStorageServerQueueSizeActor, 1, std::vector<WorkerDetails> >, public ActorCallback< GetMaxStorageServerQueueSizeActor, 2, Void >, public FastAllocated<GetMaxStorageServerQueueSizeActor>, public GetMaxStorageServerQueueSizeActorState<GetMaxStorageServerQueueSizeActor> {
															#line 4414 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetMaxStorageServerQueueSizeActor>::operator new;
	using FastAllocated<GetMaxStorageServerQueueSizeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13311374377921170944UL, 11927400915542141440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetMaxStorageServerQueueSizeActor, 0, std::vector<StorageServerInterface> >;
friend struct ActorCallback< GetMaxStorageServerQueueSizeActor, 1, std::vector<WorkerDetails> >;
friend struct ActorCallback< GetMaxStorageServerQueueSizeActor, 2, Void >;
															#line 379 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetMaxStorageServerQueueSizeActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Version const& version) 
															#line 4433 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetMaxStorageServerQueueSizeActorState<GetMaxStorageServerQueueSizeActor>(cx, dbInfo, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3846086542767416832UL, 5760051474831440384UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getMaxStorageServerQueueSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetMaxStorageServerQueueSizeActor, 0, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetMaxStorageServerQueueSizeActor, 1, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetMaxStorageServerQueueSizeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 379 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<int64_t> getMaxStorageServerQueueSize( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Version const& version ) {
															#line 379 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<int64_t>(new GetMaxStorageServerQueueSizeActor(cx, dbInfo, version));
															#line 4468 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 414 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets the size of the data distribution queue.  If reportInFlight is true, then data in flight is considered part of
// the queue
															#line 4475 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getDataDistributionQueueSize()
															#line 417 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetDataDistributionQueueSizeActor>
															#line 417 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataDistributionQueueSizeActorState {
															#line 4482 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 417 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataDistributionQueueSizeActorState(Database const& cx,WorkerInterface const& distributorWorker,bool const& reportInFlight) 
															#line 417 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 417 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 417 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   distributorWorker(distributorWorker),
															#line 417 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   reportInFlight(reportInFlight)
															#line 4493 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this));

	}
	~GetDataDistributionQueueSizeActorState() 
	{
		fdb_probe_actor_destroy("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 421 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("DataDistributionQueueSize").detail("Stage", "ContactingDataDistributor");
															#line 423 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<TraceEventFields> __when_expr_0 = timeoutError(distributorWorker.eventLogRequest.getReply(EventLogRequest("MovingData"_sr)), 1.0);
															#line 423 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<GetDataDistributionQueueSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4513 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetDataDistributionQueueSizeActor*>(this)->actor_wait_state = 1;
															#line 423 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDataDistributionQueueSizeActor, 0, TraceEventFields >*>(static_cast<GetDataDistributionQueueSizeActor*>(this)));
															#line 4518 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDataDistributionQueueSizeActorState();
		static_cast<GetDataDistributionQueueSizeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 437 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseFailure", distributorWorker.id()) .detail("Reason", "Failed to extract DataDistributionQueueSize");
															#line 439 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 4550 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields const& movingDataMessage,int loopDepth) 
	{
															#line 426 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("DataDistributionQueueSize").detail("Stage", "GotString");
															#line 428 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int64_t inQueue = boost::lexical_cast<int64_t>(movingDataMessage.getValue("InQueue"));
															#line 430 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (reportInFlight)
															#line 4568 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 431 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			int64_t inFlight = boost::lexical_cast<int64_t>(movingDataMessage.getValue("InFlight"));
															#line 432 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			inQueue += inFlight;
															#line 4574 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 435 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataDistributionQueueSizeActor*>(this)->SAV<int64_t>::futures) { (void)(inQueue); this->~GetDataDistributionQueueSizeActorState(); static_cast<GetDataDistributionQueueSizeActor*>(this)->destroy(); return 0; }
															#line 4578 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataDistributionQueueSizeActor*>(this)->SAV< int64_t >::value()) int64_t(inQueue);
		this->~GetDataDistributionQueueSizeActorState();
		static_cast<GetDataDistributionQueueSizeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields && movingDataMessage,int loopDepth) 
	{
															#line 426 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("DataDistributionQueueSize").detail("Stage", "GotString");
															#line 428 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int64_t inQueue = boost::lexical_cast<int64_t>(movingDataMessage.getValue("InQueue"));
															#line 430 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (reportInFlight)
															#line 4594 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 431 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			int64_t inFlight = boost::lexical_cast<int64_t>(movingDataMessage.getValue("InFlight"));
															#line 432 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			inQueue += inFlight;
															#line 4600 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 435 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataDistributionQueueSizeActor*>(this)->SAV<int64_t>::futures) { (void)(inQueue); this->~GetDataDistributionQueueSizeActorState(); static_cast<GetDataDistributionQueueSizeActor*>(this)->destroy(); return 0; }
															#line 4604 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataDistributionQueueSizeActor*>(this)->SAV< int64_t >::value()) int64_t(inQueue);
		this->~GetDataDistributionQueueSizeActorState();
		static_cast<GetDataDistributionQueueSizeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TraceEventFields const& movingDataMessage,int loopDepth) 
	{
		loopDepth = a_body1cont2(movingDataMessage, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TraceEventFields && movingDataMessage,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(movingDataMessage), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDataDistributionQueueSizeActor*>(this)->actor_wait_state > 0) static_cast<GetDataDistributionQueueSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetDataDistributionQueueSizeActor*>(this)->ActorCallback< GetDataDistributionQueueSizeActor, 0, TraceEventFields >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataDistributionQueueSizeActor, 0, TraceEventFields >*,TraceEventFields const& value) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDataDistributionQueueSizeActor, 0, TraceEventFields >*,TraceEventFields && value) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDataDistributionQueueSizeActor, 0, TraceEventFields >*,Error err) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 417 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 417 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WorkerInterface distributorWorker;
															#line 417 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool reportInFlight;
															#line 4693 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getDataDistributionQueueSize()
															#line 417 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataDistributionQueueSizeActor final : public Actor<int64_t>, public ActorCallback< GetDataDistributionQueueSizeActor, 0, TraceEventFields >, public FastAllocated<GetDataDistributionQueueSizeActor>, public GetDataDistributionQueueSizeActorState<GetDataDistributionQueueSizeActor> {
															#line 4698 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetDataDistributionQueueSizeActor>::operator new;
	using FastAllocated<GetDataDistributionQueueSizeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16681885693062404864UL, 4418121463606353152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDataDistributionQueueSizeActor, 0, TraceEventFields >;
															#line 417 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataDistributionQueueSizeActor(Database const& cx,WorkerInterface const& distributorWorker,bool const& reportInFlight) 
															#line 4715 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetDataDistributionQueueSizeActorState<GetDataDistributionQueueSizeActor>(cx, distributorWorker, reportInFlight),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3628305357356396544UL, 10461804314796803328UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDataDistributionQueueSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDataDistributionQueueSizeActor, 0, TraceEventFields >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 417 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<int64_t> getDataDistributionQueueSize( Database const& cx, WorkerInterface const& distributorWorker, bool const& reportInFlight ) {
															#line 417 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<int64_t>(new GetDataDistributionQueueSizeActor(cx, distributorWorker, reportInFlight));
															#line 4748 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 442 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets the size of the data distribution queue.  If reportInFlight is true, then data in flight is considered part of
// the queue Convenience method that first finds the master worker from a zookeeper interface
															#line 4755 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getDataDistributionQueueSize()
															#line 445 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetDataDistributionQueueSizeActor1>
															#line 445 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataDistributionQueueSizeActor1State {
															#line 4762 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 445 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataDistributionQueueSizeActor1State(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,bool const& reportInFlight) 
															#line 445 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 445 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 445 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo),
															#line 445 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   reportInFlight(reportInFlight)
															#line 4773 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this));

	}
	~GetDataDistributionQueueSizeActor1State() 
	{
		fdb_probe_actor_destroy("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 448 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<WorkerInterface> __when_expr_0 = getDataDistributorWorker(cx, dbInfo);
															#line 448 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4790 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state = 1;
															#line 448 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDataDistributionQueueSizeActor1, 0, WorkerInterface >*>(static_cast<GetDataDistributionQueueSizeActor1*>(this)));
															#line 4795 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDataDistributionQueueSizeActor1State();
		static_cast<GetDataDistributionQueueSizeActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(WorkerInterface const& distributorInterf,int loopDepth) 
	{
															#line 449 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = getDataDistributionQueueSize(cx, distributorInterf, reportInFlight);
															#line 449 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4820 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state = 2;
															#line 449 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >*>(static_cast<GetDataDistributionQueueSizeActor1*>(this)));
															#line 4825 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(WorkerInterface && distributorInterf,int loopDepth) 
	{
															#line 449 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = getDataDistributionQueueSize(cx, distributorInterf, reportInFlight);
															#line 449 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4836 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state = 2;
															#line 449 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >*>(static_cast<GetDataDistributionQueueSizeActor1*>(this)));
															#line 4841 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(WorkerInterface const& distributorInterf,int loopDepth) 
	{
		loopDepth = a_body1cont1(distributorInterf, loopDepth);

		return loopDepth;
	}
	int a_body1when1(WorkerInterface && distributorInterf,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(distributorInterf), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state > 0) static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state = 0;
		static_cast<GetDataDistributionQueueSizeActor1*>(this)->ActorCallback< GetDataDistributionQueueSizeActor1, 0, WorkerInterface >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataDistributionQueueSizeActor1, 0, WorkerInterface >*,WorkerInterface const& value) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDataDistributionQueueSizeActor1, 0, WorkerInterface >*,WorkerInterface && value) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDataDistributionQueueSizeActor1, 0, WorkerInterface >*,Error err) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int64_t const& inQueue,int loopDepth) 
	{
															#line 450 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataDistributionQueueSizeActor1*>(this)->SAV<int64_t>::futures) { (void)(inQueue); this->~GetDataDistributionQueueSizeActor1State(); static_cast<GetDataDistributionQueueSizeActor1*>(this)->destroy(); return 0; }
															#line 4925 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataDistributionQueueSizeActor1*>(this)->SAV< int64_t >::value()) int64_t(inQueue);
		this->~GetDataDistributionQueueSizeActor1State();
		static_cast<GetDataDistributionQueueSizeActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int64_t && inQueue,int loopDepth) 
	{
															#line 450 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataDistributionQueueSizeActor1*>(this)->SAV<int64_t>::futures) { (void)(inQueue); this->~GetDataDistributionQueueSizeActor1State(); static_cast<GetDataDistributionQueueSizeActor1*>(this)->destroy(); return 0; }
															#line 4937 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataDistributionQueueSizeActor1*>(this)->SAV< int64_t >::value()) int64_t(inQueue);
		this->~GetDataDistributionQueueSizeActor1State();
		static_cast<GetDataDistributionQueueSizeActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int64_t const& inQueue,int loopDepth) 
	{
		loopDepth = a_body1cont2(inQueue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t && inQueue,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(inQueue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state > 0) static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state = 0;
		static_cast<GetDataDistributionQueueSizeActor1*>(this)->ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 445 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 445 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 445 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool reportInFlight;
															#line 5026 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getDataDistributionQueueSize()
															#line 445 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataDistributionQueueSizeActor1 final : public Actor<int64_t>, public ActorCallback< GetDataDistributionQueueSizeActor1, 0, WorkerInterface >, public ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >, public FastAllocated<GetDataDistributionQueueSizeActor1>, public GetDataDistributionQueueSizeActor1State<GetDataDistributionQueueSizeActor1> {
															#line 5031 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetDataDistributionQueueSizeActor1>::operator new;
	using FastAllocated<GetDataDistributionQueueSizeActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16681885693062404864UL, 4418121463606353152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDataDistributionQueueSizeActor1, 0, WorkerInterface >;
friend struct ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >;
															#line 445 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataDistributionQueueSizeActor1(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,bool const& reportInFlight) 
															#line 5049 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetDataDistributionQueueSizeActor1State<GetDataDistributionQueueSizeActor1>(cx, dbInfo, reportInFlight),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7272709098130670336UL, 15142656947648547328UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDataDistributionQueueSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDataDistributionQueueSizeActor1, 0, WorkerInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 445 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<int64_t> getDataDistributionQueueSize( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, bool const& reportInFlight ) {
															#line 445 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<int64_t>(new GetDataDistributionQueueSizeActor1(cx, dbInfo, reportInFlight));
															#line 5083 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 452 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets if the number of process and machine teams does not exceed the maximum allowed number of teams
															#line 5089 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getTeamCollectionValid()
															#line 454 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetTeamCollectionValidActor>
															#line 454 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetTeamCollectionValidActorState {
															#line 5096 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 454 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetTeamCollectionValidActorState(Database const& cx,WorkerInterface const& dataDistributorWorker) 
															#line 454 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 454 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 454 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dataDistributorWorker(dataDistributorWorker),
															#line 455 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   attempts(0),
															#line 456 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   ret(false)
															#line 5109 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getTeamCollectionValid", reinterpret_cast<unsigned long>(this));

	}
	~GetTeamCollectionValidActorState() 
	{
		fdb_probe_actor_destroy("getTeamCollectionValid", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 457 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 5124 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTeamCollectionValidActorState();
		static_cast<GetTeamCollectionValidActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 459 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!g_network->isSimulated())
															#line 5155 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 460 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<GetTeamCollectionValidActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetTeamCollectionValidActorState(); static_cast<GetTeamCollectionValidActor*>(this)->destroy(); return 0; }
															#line 5159 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<GetTeamCollectionValidActor*>(this)->SAV< bool >::value()) bool(true);
				this->~GetTeamCollectionValidActorState();
				static_cast<GetTeamCollectionValidActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 463 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("GetTeamCollectionValid").detail("Stage", "ContactingMaster");
															#line 465 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<TraceEventFields> __when_expr_0 = timeoutError( dataDistributorWorker.eventLogRequest.getReply(EventLogRequest("TeamCollectionInfo"_sr)), 1.0);
															#line 465 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5171 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state = 1;
															#line 465 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTeamCollectionValidActor, 0, TraceEventFields >*>(static_cast<GetTeamCollectionValidActor*>(this)));
															#line 5176 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 543 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 5198 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 544 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5202 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 546 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseFailure", dataDistributorWorker.id()) .detail("Reason", "Failed to extract GetTeamCollectionValid information");
															#line 548 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			attempts++;
															#line 549 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (attempts > 10)
															#line 5210 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 550 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("QuietDatabaseNoTeamCollectionInfo", dataDistributorWorker.id()) .detail("Reason", "Had never called build team to build any team");
															#line 552 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<GetTeamCollectionValidActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetTeamCollectionValidActorState(); static_cast<GetTeamCollectionValidActor*>(this)->destroy(); return 0; }
															#line 5216 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<GetTeamCollectionValidActor*>(this)->SAV< bool >::value()) bool(true);
				this->~GetTeamCollectionValidActorState();
				static_cast<GetTeamCollectionValidActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 555 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(10.0);
															#line 555 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5226 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state = 3;
															#line 555 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetTeamCollectionValidActor, 2, Void >*>(static_cast<GetTeamCollectionValidActor*>(this)));
															#line 5231 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(TraceEventFields const& teamCollectionInfoMessage,int loopDepth) 
	{
															#line 468 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("GetTeamCollectionValid").detail("Stage", "GotString");
															#line 470 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		currentTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("CurrentServerTeams"));
															#line 472 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		desiredTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("DesiredTeams"));
															#line 474 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MaxTeams"));
															#line 475 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		currentMachineTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("CurrentMachineTeams"));
															#line 477 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		healthyMachineTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("CurrentHealthyMachineTeams"));
															#line 479 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		desiredMachineTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("DesiredMachineTeams"));
															#line 481 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxMachineTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MaxMachineTeams"));
															#line 484 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		minServerTeamsOnServer = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MinTeamsOnServer"));
															#line 486 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxServerTeamsOnServer = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MaxTeamsOnServer"));
															#line 488 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		minMachineTeamsOnMachine = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MinMachineTeamsOnMachine"));
															#line 490 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxMachineTeamsOnMachine = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MaxMachineTeamsOnMachine"));
															#line 509 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if ((minMachineTeamsOnMachine <= 0 || minServerTeamsOnServer <= 0) && SERVER_KNOBS->TR_FLAG_REMOVE_MT_WITH_MOST_TEAMS)
															#line 5270 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 511 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			ret = false;
															#line 513 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (attempts++ < 10)
															#line 5276 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 514 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delay(60);
															#line 514 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5282 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
				static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state = 2;
															#line 514 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTeamCollectionValidActor, 1, Void >*>(static_cast<GetTeamCollectionValidActor*>(this)));
															#line 5287 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont5(loopDepth);
			}
		}
		else
		{
															#line 539 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!static_cast<GetTeamCollectionValidActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetTeamCollectionValidActorState(); static_cast<GetTeamCollectionValidActor*>(this)->destroy(); return 0; }
															#line 5299 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			new (&static_cast<GetTeamCollectionValidActor*>(this)->SAV< bool >::value()) bool(true);
			this->~GetTeamCollectionValidActorState();
			static_cast<GetTeamCollectionValidActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(TraceEventFields && teamCollectionInfoMessage,int loopDepth) 
	{
															#line 468 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("GetTeamCollectionValid").detail("Stage", "GotString");
															#line 470 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		currentTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("CurrentServerTeams"));
															#line 472 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		desiredTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("DesiredTeams"));
															#line 474 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MaxTeams"));
															#line 475 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		currentMachineTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("CurrentMachineTeams"));
															#line 477 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		healthyMachineTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("CurrentHealthyMachineTeams"));
															#line 479 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		desiredMachineTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("DesiredMachineTeams"));
															#line 481 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxMachineTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MaxMachineTeams"));
															#line 484 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		minServerTeamsOnServer = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MinTeamsOnServer"));
															#line 486 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxServerTeamsOnServer = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MaxTeamsOnServer"));
															#line 488 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		minMachineTeamsOnMachine = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MinMachineTeamsOnMachine"));
															#line 490 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxMachineTeamsOnMachine = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MaxMachineTeamsOnMachine"));
															#line 509 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if ((minMachineTeamsOnMachine <= 0 || minServerTeamsOnServer <= 0) && SERVER_KNOBS->TR_FLAG_REMOVE_MT_WITH_MOST_TEAMS)
															#line 5336 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 511 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			ret = false;
															#line 513 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (attempts++ < 10)
															#line 5342 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 514 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delay(60);
															#line 514 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5348 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
				static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state = 2;
															#line 514 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTeamCollectionValidActor, 1, Void >*>(static_cast<GetTeamCollectionValidActor*>(this)));
															#line 5353 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont5(loopDepth);
			}
		}
		else
		{
															#line 539 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!static_cast<GetTeamCollectionValidActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetTeamCollectionValidActorState(); static_cast<GetTeamCollectionValidActor*>(this)->destroy(); return 0; }
															#line 5365 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			new (&static_cast<GetTeamCollectionValidActor*>(this)->SAV< bool >::value()) bool(true);
			this->~GetTeamCollectionValidActorState();
			static_cast<GetTeamCollectionValidActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(TraceEventFields const& teamCollectionInfoMessage,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(teamCollectionInfoMessage, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(TraceEventFields && teamCollectionInfoMessage,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(teamCollectionInfoMessage), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state > 0) static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state = 0;
		static_cast<GetTeamCollectionValidActor*>(this)->ActorCallback< GetTeamCollectionValidActor, 0, TraceEventFields >::remove();

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor, 0, TraceEventFields >*,TraceEventFields const& value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor, 0, TraceEventFields >*,TraceEventFields && value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTeamCollectionValidActor, 0, TraceEventFields >*,Error err) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 522 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("GetTeamCollectionValid") .detail("CurrentServerTeams", currentTeams) .detail("DesiredTeams", desiredTeams) .detail("MaxTeams", maxTeams) .detail("CurrentHealthyMachineTeams", healthyMachineTeams) .detail("DesiredMachineTeams", desiredMachineTeams) .detail("CurrentMachineTeams", currentMachineTeams) .detail("MaxMachineTeams", maxMachineTeams) .detail("MinTeamsOnServer", minServerTeamsOnServer) .detail("MaxTeamsOnServer", maxServerTeamsOnServer) .detail("MinMachineTeamsOnMachine", minMachineTeamsOnMachine) .detail("MaxMachineTeamsOnMachine", maxMachineTeamsOnMachine) .detail("DesiredTeamsPerServer", SERVER_KNOBS->DESIRED_TEAMS_PER_SERVER) .detail("MaxTeamsPerServer", SERVER_KNOBS->MAX_TEAMS_PER_SERVER) .detail("RemoveMTWithMostTeams", SERVER_KNOBS->TR_FLAG_REMOVE_MT_WITH_MOST_TEAMS);
															#line 537 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetTeamCollectionValidActor*>(this)->SAV<bool>::futures) { (void)(ret); this->~GetTeamCollectionValidActorState(); static_cast<GetTeamCollectionValidActor*>(this)->destroy(); return 0; }
															#line 5455 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetTeamCollectionValidActor*>(this)->SAV< bool >::value()) bool(std::move(ret)); // state_var_RVO
		this->~GetTeamCollectionValidActorState();
		static_cast<GetTeamCollectionValidActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state > 0) static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state = 0;
		static_cast<GetTeamCollectionValidActor*>(this)->ActorCallback< GetTeamCollectionValidActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTeamCollectionValidActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state > 0) static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state = 0;
		static_cast<GetTeamCollectionValidActor*>(this)->ActorCallback< GetTeamCollectionValidActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetTeamCollectionValidActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 454 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 454 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WorkerInterface dataDistributorWorker;
															#line 455 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int attempts;
															#line 456 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool ret;
															#line 470 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t currentTeams;
															#line 472 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t desiredTeams;
															#line 474 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxTeams;
															#line 475 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t currentMachineTeams;
															#line 477 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t healthyMachineTeams;
															#line 479 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t desiredMachineTeams;
															#line 481 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxMachineTeams;
															#line 484 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t minServerTeamsOnServer;
															#line 486 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxServerTeamsOnServer;
															#line 488 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t minMachineTeamsOnMachine;
															#line 490 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxMachineTeamsOnMachine;
															#line 5667 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getTeamCollectionValid()
															#line 454 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetTeamCollectionValidActor final : public Actor<bool>, public ActorCallback< GetTeamCollectionValidActor, 0, TraceEventFields >, public ActorCallback< GetTeamCollectionValidActor, 1, Void >, public ActorCallback< GetTeamCollectionValidActor, 2, Void >, public FastAllocated<GetTeamCollectionValidActor>, public GetTeamCollectionValidActorState<GetTeamCollectionValidActor> {
															#line 5672 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetTeamCollectionValidActor>::operator new;
	using FastAllocated<GetTeamCollectionValidActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12776446563128156160UL, 68104155262674432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTeamCollectionValidActor, 0, TraceEventFields >;
friend struct ActorCallback< GetTeamCollectionValidActor, 1, Void >;
friend struct ActorCallback< GetTeamCollectionValidActor, 2, Void >;
															#line 454 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetTeamCollectionValidActor(Database const& cx,WorkerInterface const& dataDistributorWorker) 
															#line 5691 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<bool>(),
		   GetTeamCollectionValidActorState<GetTeamCollectionValidActor>(cx, dataDistributorWorker),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13786627008753859072UL, 2126391119096204800UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTeamCollectionValid");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTeamCollectionValidActor, 0, TraceEventFields >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetTeamCollectionValidActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetTeamCollectionValidActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 454 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<bool> getTeamCollectionValid( Database const& cx, WorkerInterface const& dataDistributorWorker ) {
															#line 454 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<bool>(new GetTeamCollectionValidActor(cx, dataDistributorWorker));
															#line 5726 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 559 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets if the number of process and machine teams does not exceed the maximum allowed number of teams
// Convenience method that first finds the master worker from a zookeeper interface
															#line 5733 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getTeamCollectionValid()
															#line 562 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetTeamCollectionValidActor1>
															#line 562 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetTeamCollectionValidActor1State {
															#line 5740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 562 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetTeamCollectionValidActor1State(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 562 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 562 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 562 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo)
															#line 5749 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getTeamCollectionValid", reinterpret_cast<unsigned long>(this));

	}
	~GetTeamCollectionValidActor1State() 
	{
		fdb_probe_actor_destroy("getTeamCollectionValid", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 563 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<WorkerInterface> __when_expr_0 = getDataDistributorWorker(cx, dbInfo);
															#line 563 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5766 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state = 1;
															#line 563 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTeamCollectionValidActor1, 0, WorkerInterface >*>(static_cast<GetTeamCollectionValidActor1*>(this)));
															#line 5771 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTeamCollectionValidActor1State();
		static_cast<GetTeamCollectionValidActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(WorkerInterface const& dataDistributorWorker,int loopDepth) 
	{
															#line 564 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<bool> __when_expr_1 = getTeamCollectionValid(cx, dataDistributorWorker);
															#line 564 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5796 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state = 2;
															#line 564 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTeamCollectionValidActor1, 1, bool >*>(static_cast<GetTeamCollectionValidActor1*>(this)));
															#line 5801 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(WorkerInterface && dataDistributorWorker,int loopDepth) 
	{
															#line 564 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<bool> __when_expr_1 = getTeamCollectionValid(cx, dataDistributorWorker);
															#line 564 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5812 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state = 2;
															#line 564 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTeamCollectionValidActor1, 1, bool >*>(static_cast<GetTeamCollectionValidActor1*>(this)));
															#line 5817 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(WorkerInterface const& dataDistributorWorker,int loopDepth) 
	{
		loopDepth = a_body1cont1(dataDistributorWorker, loopDepth);

		return loopDepth;
	}
	int a_body1when1(WorkerInterface && dataDistributorWorker,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(dataDistributorWorker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state > 0) static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state = 0;
		static_cast<GetTeamCollectionValidActor1*>(this)->ActorCallback< GetTeamCollectionValidActor1, 0, WorkerInterface >::remove();

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor1, 0, WorkerInterface >*,WorkerInterface const& value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor1, 0, WorkerInterface >*,WorkerInterface && value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTeamCollectionValidActor1, 0, WorkerInterface >*,Error err) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(bool const& valid,int loopDepth) 
	{
															#line 565 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetTeamCollectionValidActor1*>(this)->SAV<bool>::futures) { (void)(valid); this->~GetTeamCollectionValidActor1State(); static_cast<GetTeamCollectionValidActor1*>(this)->destroy(); return 0; }
															#line 5901 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetTeamCollectionValidActor1*>(this)->SAV< bool >::value()) bool(valid);
		this->~GetTeamCollectionValidActor1State();
		static_cast<GetTeamCollectionValidActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(bool && valid,int loopDepth) 
	{
															#line 565 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetTeamCollectionValidActor1*>(this)->SAV<bool>::futures) { (void)(valid); this->~GetTeamCollectionValidActor1State(); static_cast<GetTeamCollectionValidActor1*>(this)->destroy(); return 0; }
															#line 5913 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetTeamCollectionValidActor1*>(this)->SAV< bool >::value()) bool(valid);
		this->~GetTeamCollectionValidActor1State();
		static_cast<GetTeamCollectionValidActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& valid,int loopDepth) 
	{
		loopDepth = a_body1cont2(valid, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && valid,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(valid), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state > 0) static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state = 0;
		static_cast<GetTeamCollectionValidActor1*>(this)->ActorCallback< GetTeamCollectionValidActor1, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor1, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor1, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTeamCollectionValidActor1, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 562 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 562 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 6000 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getTeamCollectionValid()
															#line 562 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetTeamCollectionValidActor1 final : public Actor<bool>, public ActorCallback< GetTeamCollectionValidActor1, 0, WorkerInterface >, public ActorCallback< GetTeamCollectionValidActor1, 1, bool >, public FastAllocated<GetTeamCollectionValidActor1>, public GetTeamCollectionValidActor1State<GetTeamCollectionValidActor1> {
															#line 6005 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetTeamCollectionValidActor1>::operator new;
	using FastAllocated<GetTeamCollectionValidActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12776446563128156160UL, 68104155262674432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTeamCollectionValidActor1, 0, WorkerInterface >;
friend struct ActorCallback< GetTeamCollectionValidActor1, 1, bool >;
															#line 562 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetTeamCollectionValidActor1(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 6023 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<bool>(),
		   GetTeamCollectionValidActor1State<GetTeamCollectionValidActor1>(cx, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1263504681258774016UL, 16594126347194509824UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTeamCollectionValid");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTeamCollectionValidActor1, 0, WorkerInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetTeamCollectionValidActor1, 1, bool >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 562 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<bool> getTeamCollectionValid( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 562 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<bool>(new GetTeamCollectionValidActor1(cx, dbInfo));
															#line 6057 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 567 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Checks that data distribution is active
															#line 6063 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getDataDistributionActive()
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetDataDistributionActiveActor>
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataDistributionActiveActorState {
															#line 6070 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataDistributionActiveActorState(Database const& cx,WorkerInterface const& distributorWorker) 
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   distributorWorker(distributorWorker)
															#line 6079 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getDataDistributionActive", reinterpret_cast<unsigned long>(this));

	}
	~GetDataDistributionActiveActorState() 
	{
		fdb_probe_actor_destroy("getDataDistributionActive", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 571 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("DataDistributionActive").detail("Stage", "ContactingDataDistributor");
															#line 573 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<TraceEventFields> __when_expr_0 = timeoutError(distributorWorker.eventLogRequest.getReply(EventLogRequest("DDTrackerStarting"_sr)), 1.0);
															#line 573 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<GetDataDistributionActiveActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6099 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetDataDistributionActiveActor*>(this)->actor_wait_state = 1;
															#line 573 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDataDistributionActiveActor, 0, TraceEventFields >*>(static_cast<GetDataDistributionActiveActor*>(this)));
															#line 6104 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDataDistributionActiveActorState();
		static_cast<GetDataDistributionActiveActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 578 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseFailure", distributorWorker.id()) .detail("Reason", "Failed to extract DataDistributionActive");
															#line 580 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 6136 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields const& activeMessage,int loopDepth) 
	{
															#line 576 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataDistributionActiveActor*>(this)->SAV<bool>::futures) { (void)(activeMessage.getValue("State") == "Active"); this->~GetDataDistributionActiveActorState(); static_cast<GetDataDistributionActiveActor*>(this)->destroy(); return 0; }
															#line 6150 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataDistributionActiveActor*>(this)->SAV< bool >::value()) bool(activeMessage.getValue("State") == "Active");
		this->~GetDataDistributionActiveActorState();
		static_cast<GetDataDistributionActiveActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields && activeMessage,int loopDepth) 
	{
															#line 576 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataDistributionActiveActor*>(this)->SAV<bool>::futures) { (void)(activeMessage.getValue("State") == "Active"); this->~GetDataDistributionActiveActorState(); static_cast<GetDataDistributionActiveActor*>(this)->destroy(); return 0; }
															#line 6162 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataDistributionActiveActor*>(this)->SAV< bool >::value()) bool(activeMessage.getValue("State") == "Active");
		this->~GetDataDistributionActiveActorState();
		static_cast<GetDataDistributionActiveActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TraceEventFields const& activeMessage,int loopDepth) 
	{
		loopDepth = a_body1cont2(activeMessage, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TraceEventFields && activeMessage,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(activeMessage), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDataDistributionActiveActor*>(this)->actor_wait_state > 0) static_cast<GetDataDistributionActiveActor*>(this)->actor_wait_state = 0;
		static_cast<GetDataDistributionActiveActor*>(this)->ActorCallback< GetDataDistributionActiveActor, 0, TraceEventFields >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataDistributionActiveActor, 0, TraceEventFields >*,TraceEventFields const& value) 
	{
		fdb_probe_actor_enter("getDataDistributionActive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionActive", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDataDistributionActiveActor, 0, TraceEventFields >*,TraceEventFields && value) 
	{
		fdb_probe_actor_enter("getDataDistributionActive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionActive", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDataDistributionActiveActor, 0, TraceEventFields >*,Error err) 
	{
		fdb_probe_actor_enter("getDataDistributionActive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionActive", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WorkerInterface distributorWorker;
															#line 6249 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getDataDistributionActive()
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataDistributionActiveActor final : public Actor<bool>, public ActorCallback< GetDataDistributionActiveActor, 0, TraceEventFields >, public FastAllocated<GetDataDistributionActiveActor>, public GetDataDistributionActiveActorState<GetDataDistributionActiveActor> {
															#line 6254 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetDataDistributionActiveActor>::operator new;
	using FastAllocated<GetDataDistributionActiveActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3498522009317263104UL, 16221200931367143168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDataDistributionActiveActor, 0, TraceEventFields >;
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataDistributionActiveActor(Database const& cx,WorkerInterface const& distributorWorker) 
															#line 6271 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<bool>(),
		   GetDataDistributionActiveActorState<GetDataDistributionActiveActor>(cx, distributorWorker),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDataDistributionActive", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(695917296241182976UL, 14234114386133646592UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDataDistributionActive");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDataDistributionActive", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDataDistributionActiveActor, 0, TraceEventFields >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<bool> getDataDistributionActive( Database const& cx, WorkerInterface const& distributorWorker ) {
															#line 569 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<bool>(new GetDataDistributionActiveActor(cx, distributorWorker));
															#line 6304 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 583 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Checks to see if any storage servers are being recruited
															#line 6310 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getStorageServersRecruiting()
															#line 585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetStorageServersRecruitingActor>
															#line 585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetStorageServersRecruitingActorState {
															#line 6317 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetStorageServersRecruitingActorState(Database const& cx,WorkerInterface const& distributorWorker,UID const& distributorUID) 
															#line 585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   distributorWorker(distributorWorker),
															#line 585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   distributorUID(distributorUID)
															#line 6328 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageServersRecruitingActorState() 
	{
		fdb_probe_actor_destroy("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 587 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("StorageServersRecruiting").detail("Stage", "ContactingDataDistributor");
															#line 588 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<TraceEventFields> __when_expr_0 = timeoutError(distributorWorker.eventLogRequest.getReply( EventLogRequest(StringRef("StorageServerRecruitment_" + distributorUID.toString()))), 1.0);
															#line 588 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<GetStorageServersRecruitingActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6348 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetStorageServersRecruitingActor*>(this)->actor_wait_state = 1;
															#line 588 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageServersRecruitingActor, 0, TraceEventFields >*>(static_cast<GetStorageServersRecruitingActor*>(this)));
															#line 6353 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageServersRecruitingActorState();
		static_cast<GetStorageServersRecruitingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 604 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseFailure", distributorWorker.id()) .detail("Reason", "Failed to extract StorageServersRecruiting") .detail("DataDistributorID", distributorUID);
															#line 607 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 6385 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields const& recruitingMessage,int loopDepth) 
	{
															#line 593 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("StorageServersRecruiting").detail("Message", recruitingMessage.toString());
															#line 595 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (recruitingMessage.getValue("State") == "Recruiting")
															#line 6401 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 596 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			std::string tssValue;
															#line 598 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!recruitingMessage.tryGetValue("IsTSS", tssValue) || tssValue == "False")
															#line 6407 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 599 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<GetStorageServersRecruitingActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetStorageServersRecruitingActorState(); static_cast<GetStorageServersRecruitingActor*>(this)->destroy(); return 0; }
															#line 6411 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<GetStorageServersRecruitingActor*>(this)->SAV< bool >::value()) bool(true);
				this->~GetStorageServersRecruitingActorState();
				static_cast<GetStorageServersRecruitingActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 602 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetStorageServersRecruitingActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetStorageServersRecruitingActorState(); static_cast<GetStorageServersRecruitingActor*>(this)->destroy(); return 0; }
															#line 6420 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetStorageServersRecruitingActor*>(this)->SAV< bool >::value()) bool(false);
		this->~GetStorageServersRecruitingActorState();
		static_cast<GetStorageServersRecruitingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields && recruitingMessage,int loopDepth) 
	{
															#line 593 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("StorageServersRecruiting").detail("Message", recruitingMessage.toString());
															#line 595 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (recruitingMessage.getValue("State") == "Recruiting")
															#line 6434 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 596 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			std::string tssValue;
															#line 598 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!recruitingMessage.tryGetValue("IsTSS", tssValue) || tssValue == "False")
															#line 6440 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 599 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<GetStorageServersRecruitingActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetStorageServersRecruitingActorState(); static_cast<GetStorageServersRecruitingActor*>(this)->destroy(); return 0; }
															#line 6444 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<GetStorageServersRecruitingActor*>(this)->SAV< bool >::value()) bool(true);
				this->~GetStorageServersRecruitingActorState();
				static_cast<GetStorageServersRecruitingActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 602 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetStorageServersRecruitingActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetStorageServersRecruitingActorState(); static_cast<GetStorageServersRecruitingActor*>(this)->destroy(); return 0; }
															#line 6453 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetStorageServersRecruitingActor*>(this)->SAV< bool >::value()) bool(false);
		this->~GetStorageServersRecruitingActorState();
		static_cast<GetStorageServersRecruitingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TraceEventFields const& recruitingMessage,int loopDepth) 
	{
		loopDepth = a_body1cont2(recruitingMessage, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TraceEventFields && recruitingMessage,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(recruitingMessage), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageServersRecruitingActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServersRecruitingActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServersRecruitingActor*>(this)->ActorCallback< GetStorageServersRecruitingActor, 0, TraceEventFields >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServersRecruitingActor, 0, TraceEventFields >*,TraceEventFields const& value) 
	{
		fdb_probe_actor_enter("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersRecruitingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageServersRecruitingActor, 0, TraceEventFields >*,TraceEventFields && value) 
	{
		fdb_probe_actor_enter("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersRecruitingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageServersRecruitingActor, 0, TraceEventFields >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersRecruitingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WorkerInterface distributorWorker;
															#line 585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	UID distributorUID;
															#line 6542 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getStorageServersRecruiting()
															#line 585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetStorageServersRecruitingActor final : public Actor<bool>, public ActorCallback< GetStorageServersRecruitingActor, 0, TraceEventFields >, public FastAllocated<GetStorageServersRecruitingActor>, public GetStorageServersRecruitingActorState<GetStorageServersRecruitingActor> {
															#line 6547 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetStorageServersRecruitingActor>::operator new;
	using FastAllocated<GetStorageServersRecruitingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4585167324059265280UL, 2162851879970034944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageServersRecruitingActor, 0, TraceEventFields >;
															#line 585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetStorageServersRecruitingActor(Database const& cx,WorkerInterface const& distributorWorker,UID const& distributorUID) 
															#line 6564 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<bool>(),
		   GetStorageServersRecruitingActorState<GetStorageServersRecruitingActor>(cx, distributorWorker, distributorUID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5963433431947749888UL, 6542897603703102976UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersRecruitingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageServersRecruiting");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageServersRecruitingActor, 0, TraceEventFields >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<bool> getStorageServersRecruiting( Database const& cx, WorkerInterface const& distributorWorker, UID const& distributorUID ) {
															#line 585 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<bool>(new GetStorageServersRecruitingActor(cx, distributorWorker, distributorUID));
															#line 6597 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 610 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets the difference between the expected version (based on the version
// epoch) and the actual version.
															#line 6604 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getVersionOffset()
															#line 613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetVersionOffsetActor>
															#line 613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetVersionOffsetActorState {
															#line 6611 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetVersionOffsetActorState(Database const& cx,WorkerInterface const& distributorWorker,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   distributorWorker(distributorWorker),
															#line 613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo)
															#line 6622 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getVersionOffset", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionOffsetActorState() 
	{
		fdb_probe_actor_destroy("getVersionOffset", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 616 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 6637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionOffsetActorState();
		static_cast<GetVersionOffsetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 617 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tr = Transaction(cx);
															#line 6667 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		try {
															#line 619 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("GetVersionOffset").detail("Stage", "ReadingVersionEpoch");
															#line 621 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 622 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 622 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetVersionOffsetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6677 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetVersionOffsetActor*>(this)->actor_wait_state = 1;
															#line 622 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionOffsetActor, 0, Version >*>(static_cast<GetVersionOffsetActor*>(this)));
															#line 6682 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 631 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 631 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetVersionOffsetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6706 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetVersionOffsetActor*>(this)->actor_wait_state = 3;
															#line 631 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetVersionOffsetActor, 2, Void >*>(static_cast<GetVersionOffsetActor*>(this)));
															#line 6711 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 623 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Optional<Standalone<StringRef>>> __when_expr_1 = tr.get(versionEpochKey);
															#line 623 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetVersionOffsetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6728 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetVersionOffsetActor*>(this)->actor_wait_state = 2;
															#line 623 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetVersionOffsetActor, 1, Optional<Standalone<StringRef>> >*>(static_cast<GetVersionOffsetActor*>(this)));
															#line 6733 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& __rv,int loopDepth) 
	{
															#line 622 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		rv = __rv;
															#line 6742 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && __rv,int loopDepth) 
	{
		rv = std::move(__rv);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionOffsetActor*>(this)->actor_wait_state > 0) static_cast<GetVersionOffsetActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionOffsetActor*>(this)->ActorCallback< GetVersionOffsetActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionOffsetActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionOffsetActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionOffsetActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Standalone<StringRef>> const& versionEpochValue,int loopDepth) 
	{
															#line 624 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!versionEpochValue.present())
															#line 6821 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 625 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!static_cast<GetVersionOffsetActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~GetVersionOffsetActorState(); static_cast<GetVersionOffsetActor*>(this)->destroy(); return 0; }
															#line 6825 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			new (&static_cast<GetVersionOffsetActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~GetVersionOffsetActorState();
			static_cast<GetVersionOffsetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 627 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int64_t versionEpoch = BinaryReader::fromStringRef<int64_t>(versionEpochValue.get(), Unversioned());
															#line 628 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int64_t versionOffset = abs(rv - (g_network->timer() * SERVER_KNOBS->VERSIONS_PER_SECOND - versionEpoch));
															#line 629 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetVersionOffsetActor*>(this)->SAV<int64_t>::futures) { (void)(versionOffset); this->~GetVersionOffsetActorState(); static_cast<GetVersionOffsetActor*>(this)->destroy(); return 0; }
															#line 6837 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetVersionOffsetActor*>(this)->SAV< int64_t >::value()) int64_t(versionOffset);
		this->~GetVersionOffsetActorState();
		static_cast<GetVersionOffsetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Standalone<StringRef>> && versionEpochValue,int loopDepth) 
	{
															#line 624 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!versionEpochValue.present())
															#line 6849 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 625 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!static_cast<GetVersionOffsetActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~GetVersionOffsetActorState(); static_cast<GetVersionOffsetActor*>(this)->destroy(); return 0; }
															#line 6853 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			new (&static_cast<GetVersionOffsetActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~GetVersionOffsetActorState();
			static_cast<GetVersionOffsetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 627 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int64_t versionEpoch = BinaryReader::fromStringRef<int64_t>(versionEpochValue.get(), Unversioned());
															#line 628 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int64_t versionOffset = abs(rv - (g_network->timer() * SERVER_KNOBS->VERSIONS_PER_SECOND - versionEpoch));
															#line 629 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetVersionOffsetActor*>(this)->SAV<int64_t>::futures) { (void)(versionOffset); this->~GetVersionOffsetActorState(); static_cast<GetVersionOffsetActor*>(this)->destroy(); return 0; }
															#line 6865 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetVersionOffsetActor*>(this)->SAV< int64_t >::value()) int64_t(versionOffset);
		this->~GetVersionOffsetActorState();
		static_cast<GetVersionOffsetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Standalone<StringRef>> const& versionEpochValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(versionEpochValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Standalone<StringRef>> && versionEpochValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(versionEpochValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetVersionOffsetActor*>(this)->actor_wait_state > 0) static_cast<GetVersionOffsetActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionOffsetActor*>(this)->ActorCallback< GetVersionOffsetActor, 1, Optional<Standalone<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionOffsetActor, 1, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetVersionOffsetActor, 1, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> && value) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetVersionOffsetActor, 1, Optional<Standalone<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetVersionOffsetActor*>(this)->actor_wait_state > 0) static_cast<GetVersionOffsetActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionOffsetActor*>(this)->ActorCallback< GetVersionOffsetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionOffsetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetVersionOffsetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetVersionOffsetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WorkerInterface distributorWorker;
															#line 613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 617 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Transaction tr;
															#line 622 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Version rv;
															#line 7045 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getVersionOffset()
															#line 613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetVersionOffsetActor final : public Actor<int64_t>, public ActorCallback< GetVersionOffsetActor, 0, Version >, public ActorCallback< GetVersionOffsetActor, 1, Optional<Standalone<StringRef>> >, public ActorCallback< GetVersionOffsetActor, 2, Void >, public FastAllocated<GetVersionOffsetActor>, public GetVersionOffsetActorState<GetVersionOffsetActor> {
															#line 7050 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetVersionOffsetActor>::operator new;
	using FastAllocated<GetVersionOffsetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7567775892603855360UL, 15827423024169419776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionOffsetActor, 0, Version >;
friend struct ActorCallback< GetVersionOffsetActor, 1, Optional<Standalone<StringRef>> >;
friend struct ActorCallback< GetVersionOffsetActor, 2, Void >;
															#line 613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetVersionOffsetActor(Database const& cx,WorkerInterface const& distributorWorker,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 7069 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetVersionOffsetActorState<GetVersionOffsetActor>(cx, distributorWorker, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17604902736507671296UL, 2799015556771665408UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersionOffset");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionOffsetActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetVersionOffsetActor, 1, Optional<Standalone<StringRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetVersionOffsetActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<int64_t> getVersionOffset( Database const& cx, WorkerInterface const& distributorWorker, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 613 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<int64_t>(new GetVersionOffsetActor(cx, distributorWorker, dbInfo));
															#line 7104 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 635 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Returns DC lag for simulation runs
															#line 7110 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getDatacenterLag()
															#line 637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetDatacenterLagActor>
															#line 637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDatacenterLagActorState {
															#line 7117 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDatacenterLagActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo)
															#line 7126 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getDatacenterLag", reinterpret_cast<unsigned long>(this));

	}
	~GetDatacenterLagActorState() 
	{
		fdb_probe_actor_destroy("getDatacenterLag", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 638 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 7141 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDatacenterLagActorState();
		static_cast<GetDatacenterLagActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 639 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!g_network->isSimulated() || g_simulator->usableRegions == 1)
															#line 7171 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 640 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!static_cast<GetDatacenterLagActor*>(this)->SAV<Version>::futures) { (void)(0); this->~GetDatacenterLagActorState(); static_cast<GetDatacenterLagActor*>(this)->destroy(); return 0; }
															#line 7175 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			new (&static_cast<GetDatacenterLagActor*>(this)->SAV< Version >::value()) Version(0);
			this->~GetDatacenterLagActorState();
			static_cast<GetDatacenterLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 643 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		primaryLog = Optional<TLogInterface>();
															#line 644 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		remoteLog = Optional<TLogInterface>();
															#line 645 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (dbInfo->get().recoveryState >= RecoveryState::ALL_LOGS_RECRUITED)
															#line 7187 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 646 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			for( const auto& logset : dbInfo->get().logSystemConfig.tLogs ) {
															#line 647 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (logset.isLocal && logset.locality != tagLocalitySatellite)
															#line 7193 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				{
															#line 648 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					for( const auto& tlog : logset.tLogs ) {
															#line 649 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
						if (tlog.present())
															#line 7199 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
						{
															#line 650 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
							primaryLog = tlog.interf();
															#line 7203 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
							break;
						}
					}
				}
															#line 655 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!logset.isLocal)
															#line 7210 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				{
															#line 656 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					for( const auto& tlog : logset.tLogs ) {
															#line 657 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
						if (tlog.present())
															#line 7216 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
						{
															#line 658 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
							remoteLog = tlog.interf();
															#line 7220 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
							break;
						}
					}
				}
			}
		}
															#line 666 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!primaryLog.present() || !remoteLog.present())
															#line 7229 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 667 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_0 = dbInfo->onChange();
															#line 667 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetDatacenterLagActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7235 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetDatacenterLagActor*>(this)->actor_wait_state = 1;
															#line 667 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDatacenterLagActor, 0, Void >*>(static_cast<GetDatacenterLagActor*>(this)));
															#line 7240 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 671 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ASSERT(primaryLog.present());
															#line 672 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ASSERT(remoteLog.present());
															#line 674 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		onChange = dbInfo->onChange();
															#line 675 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 7260 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDatacenterLagActor*>(this)->actor_wait_state > 0) static_cast<GetDatacenterLagActor*>(this)->actor_wait_state = 0;
		static_cast<GetDatacenterLagActor*>(this)->ActorCallback< GetDatacenterLagActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetDatacenterLagActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getDatacenterLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatacenterLag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDatacenterLagActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getDatacenterLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatacenterLag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDatacenterLagActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getDatacenterLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatacenterLag", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 676 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		primaryMetrics = brokenPromiseToNever(primaryLog.get().getQueuingMetrics.getReply(TLogQueuingMetricsRequest()));
															#line 678 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		remoteMetrics = brokenPromiseToNever(remoteLog.get().getQueuingMetrics.getReply(TLogQueuingMetricsRequest()));
															#line 681 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = (success(primaryMetrics) && success(remoteMetrics)) || onChange;
															#line 681 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetDatacenterLagActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 7375 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetDatacenterLagActor*>(this)->actor_wait_state = 2;
															#line 681 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetDatacenterLagActor, 1, Void >*>(static_cast<GetDatacenterLagActor*>(this)));
															#line 7380 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 682 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (onChange.isReady())
															#line 7402 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 686 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("DCLag").detail("Primary", primaryMetrics.get().v).detail("Remote", remoteMetrics.get().v);
															#line 687 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ASSERT(primaryMetrics.get().v >= 0 && remoteMetrics.get().v >= 0);
															#line 688 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDatacenterLagActor*>(this)->SAV<Version>::futures) { (void)(primaryMetrics.get().v - remoteMetrics.get().v); this->~GetDatacenterLagActorState(); static_cast<GetDatacenterLagActor*>(this)->destroy(); return 0; }
															#line 7412 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDatacenterLagActor*>(this)->SAV< Version >::value()) Version(primaryMetrics.get().v - remoteMetrics.get().v);
		this->~GetDatacenterLagActorState();
		static_cast<GetDatacenterLagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 682 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (onChange.isReady())
															#line 7424 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 686 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("DCLag").detail("Primary", primaryMetrics.get().v).detail("Remote", remoteMetrics.get().v);
															#line 687 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ASSERT(primaryMetrics.get().v >= 0 && remoteMetrics.get().v >= 0);
															#line 688 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDatacenterLagActor*>(this)->SAV<Version>::futures) { (void)(primaryMetrics.get().v - remoteMetrics.get().v); this->~GetDatacenterLagActorState(); static_cast<GetDatacenterLagActor*>(this)->destroy(); return 0; }
															#line 7434 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDatacenterLagActor*>(this)->SAV< Version >::value()) Version(primaryMetrics.get().v - remoteMetrics.get().v);
		this->~GetDatacenterLagActorState();
		static_cast<GetDatacenterLagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetDatacenterLagActor*>(this)->actor_wait_state > 0) static_cast<GetDatacenterLagActor*>(this)->actor_wait_state = 0;
		static_cast<GetDatacenterLagActor*>(this)->ActorCallback< GetDatacenterLagActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetDatacenterLagActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getDatacenterLag", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatacenterLag", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetDatacenterLagActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getDatacenterLag", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatacenterLag", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetDatacenterLagActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getDatacenterLag", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatacenterLag", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 643 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Optional<TLogInterface> primaryLog;
															#line 644 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Optional<TLogInterface> remoteLog;
															#line 674 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<Void> onChange;
															#line 676 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<TLogQueuingMetricsReply> primaryMetrics;
															#line 678 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<TLogQueuingMetricsReply> remoteMetrics;
															#line 7531 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getDatacenterLag()
															#line 637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDatacenterLagActor final : public Actor<Version>, public ActorCallback< GetDatacenterLagActor, 0, Void >, public ActorCallback< GetDatacenterLagActor, 1, Void >, public FastAllocated<GetDatacenterLagActor>, public GetDatacenterLagActorState<GetDatacenterLagActor> {
															#line 7536 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetDatacenterLagActor>::operator new;
	using FastAllocated<GetDatacenterLagActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6623198432317734144UL, 12268786750233156352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDatacenterLagActor, 0, Void >;
friend struct ActorCallback< GetDatacenterLagActor, 1, Void >;
															#line 637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDatacenterLagActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 7554 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<Version>(),
		   GetDatacenterLagActorState<GetDatacenterLagActor>(cx, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDatacenterLag", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2452971605864480512UL, 1323858774840231424UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDatacenterLag");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDatacenterLag", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDatacenterLagActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetDatacenterLagActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<Version> getDatacenterLag( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 637 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<Version>(new GetDatacenterLagActor(cx, dbInfo));
															#line 7588 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 692 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

															#line 7593 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via repairDeadDatacenter()
															#line 693 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class RepairDeadDatacenterActor>
															#line 693 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class RepairDeadDatacenterActorState {
															#line 7600 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 693 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	RepairDeadDatacenterActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,std::string const& context) 
															#line 693 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 693 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 693 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo),
															#line 693 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   context(context)
															#line 7611 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("repairDeadDatacenter", reinterpret_cast<unsigned long>(this));

	}
	~RepairDeadDatacenterActorState() 
	{
		fdb_probe_actor_destroy("repairDeadDatacenter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 696 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (g_network->isSimulated() && g_simulator->usableRegions > 1 && !g_simulator->quiesced)
															#line 7626 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 697 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				primaryDead = g_simulator->datacenterDead(g_simulator->primaryDcId);
															#line 698 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				remoteDead = g_simulator->datacenterDead(g_simulator->remoteDcId);
															#line 702 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (primaryDead && remoteDead)
															#line 7634 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				{
															#line 703 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					TraceEvent(SevWarnAlways, "CannotDisableFearlessConfiguration").log();
															#line 704 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					if (!static_cast<RepairDeadDatacenterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RepairDeadDatacenterActorState(); static_cast<RepairDeadDatacenterActor*>(this)->destroy(); return 0; }
															#line 7640 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
					new (&static_cast<RepairDeadDatacenterActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~RepairDeadDatacenterActorState();
					static_cast<RepairDeadDatacenterActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 706 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (primaryDead || remoteDead)
															#line 7648 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				{
															#line 707 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					if (remoteDead)
															#line 7652 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
					{
															#line 708 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
						std::vector<AddressExclusion> servers = g_simulator->getAllAddressesInDCToExclude(g_simulator->remoteDcId);
															#line 710 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
						TraceEvent(SevWarnAlways, "DisablingFearlessConfiguration") .detail("Location", context) .detail("Stage", "ExcludeServers") .detail("Servers", describe(servers));
															#line 714 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
						StrictFuture<Void> __when_expr_0 = excludeServers(cx, servers, false);
															#line 714 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
						if (static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7662 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
						if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
						static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state = 1;
															#line 714 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
						__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RepairDeadDatacenterActor, 0, Void >*>(static_cast<RepairDeadDatacenterActor*>(this)));
															#line 7667 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1cont4(loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RepairDeadDatacenterActorState();
		static_cast<RepairDeadDatacenterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 737 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<RepairDeadDatacenterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RepairDeadDatacenterActorState(); static_cast<RepairDeadDatacenterActor*>(this)->destroy(); return 0; }
															#line 7705 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<RepairDeadDatacenterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RepairDeadDatacenterActorState();
		static_cast<RepairDeadDatacenterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 717 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent(SevWarnAlways, "DisablingFearlessConfiguration") .detail("Location", context) .detail("Stage", "Repopulate") .detail("RemoteDead", remoteDead) .detail("PrimaryDead", primaryDead);
															#line 722 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		g_simulator->usableRegions = 1;
															#line 724 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(ManagementAPI::changeConfig( cx.getReference(), (primaryDead ? g_simulator->disablePrimary : g_simulator->disableRemote) + " repopulate_anti_quorum=1", true));
															#line 724 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7729 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont4when1(__when_expr_1.get(), loopDepth); };
		static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state = 2;
															#line 724 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RepairDeadDatacenterActor, 1, Void >*>(static_cast<RepairDeadDatacenterActor*>(this)));
															#line 7734 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state > 0) static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state = 0;
		static_cast<RepairDeadDatacenterActor*>(this)->ActorCallback< RepairDeadDatacenterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RepairDeadDatacenterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RepairDeadDatacenterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RepairDeadDatacenterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 728 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 7830 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 728 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 7839 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state > 0) static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state = 0;
		static_cast<RepairDeadDatacenterActor*>(this)->ActorCallback< RepairDeadDatacenterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RepairDeadDatacenterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RepairDeadDatacenterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RepairDeadDatacenterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 731 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent(SevWarnAlways, "DisablingFearlessConfiguration") .detail("Location", context) .detail("Stage", "Usable_Regions");
															#line 734 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(ManagementAPI::changeConfig(cx.getReference(), "usable_regions=1", true));
															#line 734 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7927 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state = 4;
															#line 734 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RepairDeadDatacenterActor, 3, Void >*>(static_cast<RepairDeadDatacenterActor*>(this)));
															#line 7932 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 728 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!(dbInfo->get().recoveryState < RecoveryState::STORAGE_RECOVERED))
															#line 7948 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
			return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 729 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_2 = dbInfo->onChange();
															#line 729 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7956 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state = 3;
															#line 729 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RepairDeadDatacenterActor, 2, Void >*>(static_cast<RepairDeadDatacenterActor*>(this)));
															#line 7961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state > 0) static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state = 0;
		static_cast<RepairDeadDatacenterActor*>(this)->ActorCallback< RepairDeadDatacenterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RepairDeadDatacenterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RepairDeadDatacenterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RepairDeadDatacenterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state > 0) static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state = 0;
		static_cast<RepairDeadDatacenterActor*>(this)->ActorCallback< RepairDeadDatacenterActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RepairDeadDatacenterActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RepairDeadDatacenterActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RepairDeadDatacenterActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 693 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 693 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 693 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::string context;
															#line 697 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool primaryDead;
															#line 698 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool remoteDead;
															#line 8163 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via repairDeadDatacenter()
															#line 693 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class RepairDeadDatacenterActor final : public Actor<Void>, public ActorCallback< RepairDeadDatacenterActor, 0, Void >, public ActorCallback< RepairDeadDatacenterActor, 1, Void >, public ActorCallback< RepairDeadDatacenterActor, 2, Void >, public ActorCallback< RepairDeadDatacenterActor, 3, Void >, public FastAllocated<RepairDeadDatacenterActor>, public RepairDeadDatacenterActorState<RepairDeadDatacenterActor> {
															#line 8168 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<RepairDeadDatacenterActor>::operator new;
	using FastAllocated<RepairDeadDatacenterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4750134836008312320UL, 10489567626305365248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RepairDeadDatacenterActor, 0, Void >;
friend struct ActorCallback< RepairDeadDatacenterActor, 1, Void >;
friend struct ActorCallback< RepairDeadDatacenterActor, 2, Void >;
friend struct ActorCallback< RepairDeadDatacenterActor, 3, Void >;
															#line 693 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	RepairDeadDatacenterActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,std::string const& context) 
															#line 8188 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<Void>(),
		   RepairDeadDatacenterActorState<RepairDeadDatacenterActor>(cx, dbInfo, context),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6159519692349520640UL, 14447699372185362944UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("repairDeadDatacenter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RepairDeadDatacenterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RepairDeadDatacenterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RepairDeadDatacenterActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RepairDeadDatacenterActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 693 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<Void> repairDeadDatacenter( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, std::string const& context ) {
															#line 693 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<Void>(new RepairDeadDatacenterActor(cx, dbInfo, context));
															#line 8224 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 739 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

															#line 8229 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via reconfigureAfter()
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class ReconfigureAfterActor>
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class ReconfigureAfterActorState {
															#line 8236 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	ReconfigureAfterActorState(Database const& cx,double const& time,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,std::string const& context) 
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   time(time),
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo),
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   context(context)
															#line 8249 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("reconfigureAfter", reinterpret_cast<unsigned long>(this));

	}
	~ReconfigureAfterActorState() 
	{
		fdb_probe_actor_destroy("reconfigureAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 744 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(time);
															#line 744 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<ReconfigureAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8266 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReconfigureAfterActor*>(this)->actor_wait_state = 1;
															#line 744 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReconfigureAfterActor, 0, Void >*>(static_cast<ReconfigureAfterActor*>(this)));
															#line 8271 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReconfigureAfterActorState();
		static_cast<ReconfigureAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 745 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = uncancellable(repairDeadDatacenter(cx, dbInfo, context));
															#line 745 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<ReconfigureAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8296 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReconfigureAfterActor*>(this)->actor_wait_state = 2;
															#line 745 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReconfigureAfterActor, 1, Void >*>(static_cast<ReconfigureAfterActor*>(this)));
															#line 8301 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 745 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = uncancellable(repairDeadDatacenter(cx, dbInfo, context));
															#line 745 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<ReconfigureAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8312 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReconfigureAfterActor*>(this)->actor_wait_state = 2;
															#line 745 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReconfigureAfterActor, 1, Void >*>(static_cast<ReconfigureAfterActor*>(this)));
															#line 8317 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReconfigureAfterActor*>(this)->actor_wait_state > 0) static_cast<ReconfigureAfterActor*>(this)->actor_wait_state = 0;
		static_cast<ReconfigureAfterActor*>(this)->ActorCallback< ReconfigureAfterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReconfigureAfterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reconfigureAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconfigureAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconfigureAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReconfigureAfterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reconfigureAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconfigureAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconfigureAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReconfigureAfterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reconfigureAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReconfigureAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconfigureAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 746 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<ReconfigureAfterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReconfigureAfterActorState(); static_cast<ReconfigureAfterActor*>(this)->destroy(); return 0; }
															#line 8401 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<ReconfigureAfterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReconfigureAfterActorState();
		static_cast<ReconfigureAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 746 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<ReconfigureAfterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReconfigureAfterActorState(); static_cast<ReconfigureAfterActor*>(this)->destroy(); return 0; }
															#line 8413 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<ReconfigureAfterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReconfigureAfterActorState();
		static_cast<ReconfigureAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReconfigureAfterActor*>(this)->actor_wait_state > 0) static_cast<ReconfigureAfterActor*>(this)->actor_wait_state = 0;
		static_cast<ReconfigureAfterActor*>(this)->ActorCallback< ReconfigureAfterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReconfigureAfterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reconfigureAfter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconfigureAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconfigureAfter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReconfigureAfterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reconfigureAfter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconfigureAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconfigureAfter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReconfigureAfterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reconfigureAfter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReconfigureAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconfigureAfter", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	double time;
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::string context;
															#line 8504 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via reconfigureAfter()
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class ReconfigureAfterActor final : public Actor<Void>, public ActorCallback< ReconfigureAfterActor, 0, Void >, public ActorCallback< ReconfigureAfterActor, 1, Void >, public FastAllocated<ReconfigureAfterActor>, public ReconfigureAfterActorState<ReconfigureAfterActor> {
															#line 8509 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<ReconfigureAfterActor>::operator new;
	using FastAllocated<ReconfigureAfterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14847647391202715904UL, 1834291693721350144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReconfigureAfterActor, 0, Void >;
friend struct ActorCallback< ReconfigureAfterActor, 1, Void >;
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	ReconfigureAfterActor(Database const& cx,double const& time,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,std::string const& context) 
															#line 8527 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<Void>(),
		   ReconfigureAfterActorState<ReconfigureAfterActor>(cx, time, dbInfo, context),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("reconfigureAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(392835930889393664UL, 13442961960112630784UL);
		ActorExecutionContextHelper __helper(static_cast<ReconfigureAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("reconfigureAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("reconfigureAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReconfigureAfterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReconfigureAfterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<Void> reconfigureAfter( Database const& cx, double const& time, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, std::string const& context ) {
															#line 740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<Void>(new ReconfigureAfterActor(cx, time, dbInfo, context));
															#line 8561 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 748 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

struct QuietDatabaseChecker {
	ProcessEvents::Callback timeoutCallback = [this](StringRef name, std::any const& msg, Error const& e) {
		logFailure(name, std::any_cast<StringRef>(msg), e);
	};
	double start = now();
	double maxDDRunTime;
	ProcessEvents::Event timeoutEvent;
	std::vector<std::string> lastFailReasons;

	QuietDatabaseChecker(double maxDDRunTime)
	  : maxDDRunTime(maxDDRunTime), timeoutEvent({ "Timeout"_sr, "TracedTooManyLines"_sr }, timeoutCallback) {}

	void logFailure(StringRef name, StringRef msg, Error const& e) {
		std::string reasons = fmt::format("{}", fmt::join(lastFailReasons, ", "));
		TraceEvent(SevError, "QuietDatabaseFailure")
		    .error(e)
		    .detail("EventName", name)
		    .detail("EventMessage", msg)
		    .detail("Reasons", lastFailReasons)
		    .log();
	};

	struct Impl {
		double start;
		std::string const& phase;
		double maxDDRunTime;
		std::vector<std::string>& failReasons;

		Impl(double start, const std::string& phase, const double maxDDRunTime, std::vector<std::string>& failReasons)
		  : start(start), phase(phase), maxDDRunTime(maxDDRunTime), failReasons(failReasons) {}

		template <class T, class Comparison = std::less_equal<>>
		Impl& add(BaseTraceEvent& evt,
		          const char* name,
		          T value,
		          T expected,
		          Comparison const& cmp = std::less_equal<>()) {
			std::string k = fmt::format("{}Gate", name);
			evt.detail(name, value).detail(k.c_str(), expected);
			if (!cmp(value, expected)) {
				failReasons.push_back(name);
			}
			return *this;
		}

		bool success() {
			bool timedOut = now() - start > maxDDRunTime;
			if (!failReasons.empty()) {
				std::string traceMessage = fmt::format("QuietDatabase{}Fail", phase);
				std::string reasons = fmt::format("{}", fmt::join(failReasons, ", "));
				TraceEvent(timedOut ? SevError : SevWarnAlways, traceMessage.c_str())
				    .detail("Reasons", reasons)
				    .detail("FailedAfter", now() - start)
				    .detail("Timeout", maxDDRunTime);
				if (timedOut) {
					// this bool is just created to make the assertion more readable
					bool ddGotStuck = true;
					// This assertion is here to make the test fail more quickly. If quietDatabase takes this
					// long without completing, we can assume that the test will eventually time out. However,
					// time outs are more annoying to debug. This will hopefully be easier to track down.
					ASSERT(!ddGotStuck || !g_network->isSimulated());
				}
				return false;
			}
			return true;
		}
	};

	Impl startIteration(std::string const& phase) {
		lastFailReasons.clear();
		Impl res(start, phase, maxDDRunTime, lastFailReasons);
		return res;
	}
};

															#line 8641 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via enableConsistencyScanInSim()
															#line 824 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class EnableConsistencyScanInSimActor>
															#line 824 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class EnableConsistencyScanInSimActorState {
															#line 8648 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 824 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	EnableConsistencyScanInSimActorState(Database const& db) 
															#line 824 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 824 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : db(db),
															#line 825 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(db)),
															#line 826 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   cs()
															#line 8659 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this));

	}
	~EnableConsistencyScanInSimActorState() 
	{
		fdb_probe_actor_destroy("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 827 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!g_network->isSimulated())
															#line 8674 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 828 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<EnableConsistencyScanInSimActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EnableConsistencyScanInSimActorState(); static_cast<EnableConsistencyScanInSimActor*>(this)->destroy(); return 0; }
															#line 8678 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<EnableConsistencyScanInSimActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~EnableConsistencyScanInSimActorState();
				static_cast<EnableConsistencyScanInSimActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 830 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("ConsistencyScan_SimEnable").log();
															#line 831 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 8688 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EnableConsistencyScanInSimActorState();
		static_cast<EnableConsistencyScanInSimActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 882 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<EnableConsistencyScanInSimActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EnableConsistencyScanInSimActorState(); static_cast<EnableConsistencyScanInSimActor*>(this)->destroy(); return 0; }
															#line 8711 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<EnableConsistencyScanInSimActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~EnableConsistencyScanInSimActorState();
		static_cast<EnableConsistencyScanInSimActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 833 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			SystemDBWriteLockedNow(db.getReference())->setOptions(tr);
															#line 834 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<ConsistencyScanState::Config> __when_expr_0 = cs.config().getD(tr);
															#line 834 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8735 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state = 1;
															#line 834 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EnableConsistencyScanInSimActor, 0, ConsistencyScanState::Config >*>(static_cast<EnableConsistencyScanInSimActor*>(this)));
															#line 8740 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 878 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 878 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8777 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state = 3;
															#line 878 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< EnableConsistencyScanInSimActor, 2, Void >*>(static_cast<EnableConsistencyScanInSimActor*>(this)));
															#line 8782 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 837 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!config.enabled && g_simulator->consistencyScanState < ISimulator::SimConsistencyScanState::Enabled)
															#line 8797 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 838 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!g_simulator->doInjectConsistencyScanCorruption.present())
															#line 8801 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 839 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				g_simulator->doInjectConsistencyScanCorruption = BUGGIFY_WITH_PROB(0.1);
															#line 840 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("ConsistencyScan_DoInjectCorruption") .detail("Val", g_simulator->doInjectConsistencyScanCorruption.get());
															#line 8807 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 844 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::DisabledStart, ISimulator::SimConsistencyScanState::Enabling);
															#line 846 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			config.enabled = true;
															#line 8813 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		else
		{
															#line 848 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (config.enabled && g_simulator->restarted && g_simulator->consistencyScanState == ISimulator::SimConsistencyScanState::DisabledStart)
															#line 8819 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 850 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("ConsistencyScan_SimEnableAlreadyDoneFromRestart").log();
															#line 851 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::DisabledStart, ISimulator::SimConsistencyScanState::Enabling);
															#line 8825 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 854 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (BUGGIFY_WITH_PROB(0.5))
															#line 8829 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 855 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				config.minStartVersion = tr->getReadVersion().get();
															#line 8833 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
		}
															#line 859 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		config.maxReadByteRate = deterministicRandom()->randomInt(1, 50e6);
															#line 860 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		config.targetRoundTimeSeconds = deterministicRandom()->randomSkewedUInt32(1, 100);
															#line 861 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		config.minRoundTimeSeconds = deterministicRandom()->randomSkewedUInt32(1, 100);
															#line 863 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (config.enabled)
															#line 8844 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 864 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			cs.config().set(tr, config);
															#line 865 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 865 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8852 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state = 2;
															#line 865 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EnableConsistencyScanInSimActor, 1, Void >*>(static_cast<EnableConsistencyScanInSimActor*>(this)));
															#line 8857 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ConsistencyScanState::Config const& __config,int loopDepth) 
	{
															#line 834 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		config = __config;
															#line 8871 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ConsistencyScanState::Config && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<EnableConsistencyScanInSimActor*>(this)->ActorCallback< EnableConsistencyScanInSimActor, 0, ConsistencyScanState::Config >::remove();

	}
	void a_callback_fire(ActorCallback< EnableConsistencyScanInSimActor, 0, ConsistencyScanState::Config >*,ConsistencyScanState::Config const& value) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EnableConsistencyScanInSimActor, 0, ConsistencyScanState::Config >*,ConsistencyScanState::Config && value) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EnableConsistencyScanInSimActor, 0, ConsistencyScanState::Config >*,Error err) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 867 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Enabling, ISimulator::SimConsistencyScanState::Enabled);
															#line 869 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("ConsistencyScan_SimEnabled") .detail("MaxReadByteRate", config.maxReadByteRate) .detail("TargetRoundTimeSeconds", config.targetRoundTimeSeconds) .detail("MinRoundTimeSeconds", config.minRoundTimeSeconds);
															#line 873 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		CODE_PROBE(true, "Consistency Scan enabled in simulation");
															#line 8960 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 867 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Enabling, ISimulator::SimConsistencyScanState::Enabled);
															#line 869 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("ConsistencyScan_SimEnabled") .detail("MaxReadByteRate", config.maxReadByteRate) .detail("TargetRoundTimeSeconds", config.targetRoundTimeSeconds) .detail("MinRoundTimeSeconds", config.minRoundTimeSeconds);
															#line 873 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		CODE_PROBE(true, "Consistency Scan enabled in simulation");
															#line 8973 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<EnableConsistencyScanInSimActor*>(this)->ActorCallback< EnableConsistencyScanInSimActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EnableConsistencyScanInSimActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< EnableConsistencyScanInSimActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< EnableConsistencyScanInSimActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<EnableConsistencyScanInSimActor*>(this)->ActorCallback< EnableConsistencyScanInSimActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EnableConsistencyScanInSimActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< EnableConsistencyScanInSimActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< EnableConsistencyScanInSimActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 824 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database db;
															#line 825 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 826 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	ConsistencyScanState cs;
															#line 834 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	ConsistencyScanState::Config config;
															#line 9148 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via enableConsistencyScanInSim()
															#line 824 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class EnableConsistencyScanInSimActor final : public Actor<Void>, public ActorCallback< EnableConsistencyScanInSimActor, 0, ConsistencyScanState::Config >, public ActorCallback< EnableConsistencyScanInSimActor, 1, Void >, public ActorCallback< EnableConsistencyScanInSimActor, 2, Void >, public FastAllocated<EnableConsistencyScanInSimActor>, public EnableConsistencyScanInSimActorState<EnableConsistencyScanInSimActor> {
															#line 9153 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<EnableConsistencyScanInSimActor>::operator new;
	using FastAllocated<EnableConsistencyScanInSimActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17628599990675142400UL, 17185872978631117312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EnableConsistencyScanInSimActor, 0, ConsistencyScanState::Config >;
friend struct ActorCallback< EnableConsistencyScanInSimActor, 1, Void >;
friend struct ActorCallback< EnableConsistencyScanInSimActor, 2, Void >;
															#line 824 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	EnableConsistencyScanInSimActor(Database const& db) 
															#line 9172 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<Void>(),
		   EnableConsistencyScanInSimActorState<EnableConsistencyScanInSimActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13916349905056491520UL, 10108342155947120896UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("enableConsistencyScanInSim");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EnableConsistencyScanInSimActor, 0, ConsistencyScanState::Config >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< EnableConsistencyScanInSimActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< EnableConsistencyScanInSimActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 824 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<Void> enableConsistencyScanInSim( Database const& db ) {
															#line 824 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<Void>(new EnableConsistencyScanInSimActor(db));
															#line 9207 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 884 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

															#line 9212 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via disableConsistencyScanInSim()
															#line 885 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class DisableConsistencyScanInSimActor>
															#line 885 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class DisableConsistencyScanInSimActorState {
															#line 9219 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 885 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	DisableConsistencyScanInSimActorState(Database const& db,bool const& waitForCompletion) 
															#line 885 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 885 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : db(db),
															#line 885 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   waitForCompletion(waitForCompletion),
															#line 886 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(db)),
															#line 887 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   cs()
															#line 9232 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this));

	}
	~DisableConsistencyScanInSimActorState() 
	{
		fdb_probe_actor_destroy("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 888 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!g_network->isSimulated())
															#line 9247 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 889 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<DisableConsistencyScanInSimActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DisableConsistencyScanInSimActorState(); static_cast<DisableConsistencyScanInSimActor*>(this)->destroy(); return 0; }
															#line 9251 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<DisableConsistencyScanInSimActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DisableConsistencyScanInSimActorState();
				static_cast<DisableConsistencyScanInSimActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 892 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (waitForCompletion)
															#line 9259 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 893 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("ConsistencyScan_SimDisableWaiting").log();
															#line 894 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				printf("Waiting for consistency scan to complete...\n");
															#line 895 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				;
															#line 9267 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DisableConsistencyScanInSimActorState();
		static_cast<DisableConsistencyScanInSimActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 907 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("ConsistencyScan_SimDisable").log();
															#line 908 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 9297 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 896 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		bool waitForCorruption = g_simulator->doInjectConsistencyScanCorruption.present() && g_simulator->doInjectConsistencyScanCorruption.get();
															#line 898 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (((waitForCorruption && g_simulator->consistencyScanState >= ISimulator::SimConsistencyScanState::Enabled_FoundCorruption) || (!waitForCorruption && g_simulator->consistencyScanState >= ISimulator::SimConsistencyScanState::Enabled)))
															#line 9321 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 904 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 904 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9329 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 1;
															#line 904 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DisableConsistencyScanInSimActor, 0, Void >*>(static_cast<DisableConsistencyScanInSimActor*>(this)));
															#line 9334 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConsistencyScanInSimActor*>(this)->ActorCallback< DisableConsistencyScanInSimActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DisableConsistencyScanInSimActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 951 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Complete, ISimulator::SimConsistencyScanState::DisabledEnd);
															#line 953 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		CODE_PROBE(true, "Consistency Scan disabled in simulation");
															#line 954 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("ConsistencyScan_SimDisabled").log();
															#line 955 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		printf("Consistency scan complete.\n");
															#line 956 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<DisableConsistencyScanInSimActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DisableConsistencyScanInSimActorState(); static_cast<DisableConsistencyScanInSimActor*>(this)->destroy(); return 0; }
															#line 9451 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<DisableConsistencyScanInSimActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DisableConsistencyScanInSimActorState();
		static_cast<DisableConsistencyScanInSimActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 910 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			SystemDBWriteLockedNow(db.getReference())->setOptions(tr);
															#line 911 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<ConsistencyScanState::Config> __when_expr_1 = cs.config().getD(tr);
															#line 911 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9475 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 2;
															#line 911 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DisableConsistencyScanInSimActor, 1, ConsistencyScanState::Config >*>(static_cast<DisableConsistencyScanInSimActor*>(this)));
															#line 9480 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 947 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_6 = tr->onError(e);
															#line 947 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9517 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 7;
															#line 947 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DisableConsistencyScanInSimActor, 6, Void >*>(static_cast<DisableConsistencyScanInSimActor*>(this)));
															#line 9522 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 912 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		skipDisable = false;
															#line 914 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (waitForCompletion)
															#line 9539 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 915 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<ConsistencyScanState::RoundStats> __when_expr_2 = cs.currentRoundStats().getD(tr);
															#line 915 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9545 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 3;
															#line 915 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DisableConsistencyScanInSimActor, 2, ConsistencyScanState::RoundStats >*>(static_cast<DisableConsistencyScanInSimActor*>(this)));
															#line 9550 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ConsistencyScanState::Config const& __config,int loopDepth) 
	{
															#line 911 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		config = __config;
															#line 9564 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ConsistencyScanState::Config && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConsistencyScanInSimActor*>(this)->ActorCallback< DisableConsistencyScanInSimActor, 1, ConsistencyScanState::Config >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 1, ConsistencyScanState::Config >*,ConsistencyScanState::Config const& value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 1, ConsistencyScanState::Config >*,ConsistencyScanState::Config && value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DisableConsistencyScanInSimActor, 1, ConsistencyScanState::Config >*,Error err) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 925 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (config.enabled)
															#line 9643 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 927 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Enabled, ISimulator::SimConsistencyScanState::Complete);
															#line 929 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Enabled_FoundCorruption, ISimulator::SimConsistencyScanState::Complete);
															#line 931 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			config.enabled = false;
															#line 9651 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		else
		{
															#line 933 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("ConsistencyScan_SimDisableAlreadyDisabled").log();
															#line 934 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			printf("Consistency scan already complete.\n");
															#line 935 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!static_cast<DisableConsistencyScanInSimActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DisableConsistencyScanInSimActorState(); static_cast<DisableConsistencyScanInSimActor*>(this)->destroy(); return 0; }
															#line 9661 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			new (&static_cast<DisableConsistencyScanInSimActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~DisableConsistencyScanInSimActorState();
			static_cast<DisableConsistencyScanInSimActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 938 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (skipDisable)
															#line 9669 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 939 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_4 = delay(2.0);
															#line 939 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9675 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
			static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 5;
															#line 939 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DisableConsistencyScanInSimActor, 4, Void >*>(static_cast<DisableConsistencyScanInSimActor*>(this)));
															#line 9680 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 942 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			cs.config().set(tr, config);
															#line 943 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr->commit();
															#line 943 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9691 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont3when2(__when_expr_5.get(), loopDepth); };
			static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 6;
															#line 943 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DisableConsistencyScanInSimActor, 5, Void >*>(static_cast<DisableConsistencyScanInSimActor*>(this)));
															#line 9696 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
															#line 916 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<ConsistencyScanState::StatsHistoryMap::RangeResultType> __when_expr_3 = cs.roundStatsHistory().getRange(tr, {}, {}, 1, Snapshot::False, Reverse::False);
															#line 916 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9708 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 4;
															#line 916 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DisableConsistencyScanInSimActor, 3, ConsistencyScanState::StatsHistoryMap::RangeResultType >*>(static_cast<DisableConsistencyScanInSimActor*>(this)));
															#line 9713 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ConsistencyScanState::RoundStats const& __statsCurrentRound,int loopDepth) 
	{
															#line 915 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		statsCurrentRound = __statsCurrentRound;
															#line 9722 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ConsistencyScanState::RoundStats && __statsCurrentRound,int loopDepth) 
	{
		statsCurrentRound = std::move(__statsCurrentRound);
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConsistencyScanInSimActor*>(this)->ActorCallback< DisableConsistencyScanInSimActor, 2, ConsistencyScanState::RoundStats >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 2, ConsistencyScanState::RoundStats >*,ConsistencyScanState::RoundStats const& value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 2, ConsistencyScanState::RoundStats >*,ConsistencyScanState::RoundStats && value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DisableConsistencyScanInSimActor, 2, ConsistencyScanState::RoundStats >*,Error err) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
															#line 918 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (olderStats.results.empty() && !statsCurrentRound.complete)
															#line 9801 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 919 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("ConsistencyScan_SimDisable_NoRoundsCompleted").log();
															#line 920 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			skipDisable = true;
															#line 9807 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(ConsistencyScanState::StatsHistoryMap::RangeResultType const& __olderStats,int loopDepth) 
	{
															#line 916 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		olderStats = __olderStats;
															#line 9817 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(ConsistencyScanState::StatsHistoryMap::RangeResultType && __olderStats,int loopDepth) 
	{
		olderStats = std::move(__olderStats);
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConsistencyScanInSimActor*>(this)->ActorCallback< DisableConsistencyScanInSimActor, 3, ConsistencyScanState::StatsHistoryMap::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 3, ConsistencyScanState::StatsHistoryMap::RangeResultType >*,ConsistencyScanState::StatsHistoryMap::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 3, ConsistencyScanState::StatsHistoryMap::RangeResultType >*,ConsistencyScanState::StatsHistoryMap::RangeResultType && value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DisableConsistencyScanInSimActor, 3, ConsistencyScanState::StatsHistoryMap::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 940 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tr->reset();
															#line 9902 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 940 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tr->reset();
															#line 9911 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConsistencyScanInSimActor*>(this)->ActorCallback< DisableConsistencyScanInSimActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DisableConsistencyScanInSimActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont12(Void const& _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont12(Void && _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConsistencyScanInSimActor*>(this)->ActorCallback< DisableConsistencyScanInSimActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont3when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont3when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DisableConsistencyScanInSimActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont13(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConsistencyScanInSimActor*>(this)->ActorCallback< DisableConsistencyScanInSimActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DisableConsistencyScanInSimActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 885 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database db;
															#line 885 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool waitForCompletion;
															#line 886 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 887 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	ConsistencyScanState cs;
															#line 911 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	ConsistencyScanState::Config config;
															#line 912 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool skipDisable;
															#line 915 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	ConsistencyScanState::RoundStats statsCurrentRound;
															#line 916 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	ConsistencyScanState::StatsHistoryMap::RangeResultType olderStats;
															#line 10194 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via disableConsistencyScanInSim()
															#line 885 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class DisableConsistencyScanInSimActor final : public Actor<Void>, public ActorCallback< DisableConsistencyScanInSimActor, 0, Void >, public ActorCallback< DisableConsistencyScanInSimActor, 1, ConsistencyScanState::Config >, public ActorCallback< DisableConsistencyScanInSimActor, 2, ConsistencyScanState::RoundStats >, public ActorCallback< DisableConsistencyScanInSimActor, 3, ConsistencyScanState::StatsHistoryMap::RangeResultType >, public ActorCallback< DisableConsistencyScanInSimActor, 4, Void >, public ActorCallback< DisableConsistencyScanInSimActor, 5, Void >, public ActorCallback< DisableConsistencyScanInSimActor, 6, Void >, public FastAllocated<DisableConsistencyScanInSimActor>, public DisableConsistencyScanInSimActorState<DisableConsistencyScanInSimActor> {
															#line 10199 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<DisableConsistencyScanInSimActor>::operator new;
	using FastAllocated<DisableConsistencyScanInSimActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12213339772170416128UL, 4013096969614764544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DisableConsistencyScanInSimActor, 0, Void >;
friend struct ActorCallback< DisableConsistencyScanInSimActor, 1, ConsistencyScanState::Config >;
friend struct ActorCallback< DisableConsistencyScanInSimActor, 2, ConsistencyScanState::RoundStats >;
friend struct ActorCallback< DisableConsistencyScanInSimActor, 3, ConsistencyScanState::StatsHistoryMap::RangeResultType >;
friend struct ActorCallback< DisableConsistencyScanInSimActor, 4, Void >;
friend struct ActorCallback< DisableConsistencyScanInSimActor, 5, Void >;
friend struct ActorCallback< DisableConsistencyScanInSimActor, 6, Void >;
															#line 885 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	DisableConsistencyScanInSimActor(Database const& db,bool const& waitForCompletion) 
															#line 10222 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<Void>(),
		   DisableConsistencyScanInSimActorState<DisableConsistencyScanInSimActor>(db, waitForCompletion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4193161891400256256UL, 3023070201654291200UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("disableConsistencyScanInSim");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DisableConsistencyScanInSimActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DisableConsistencyScanInSimActor, 1, ConsistencyScanState::Config >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DisableConsistencyScanInSimActor, 2, ConsistencyScanState::RoundStats >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DisableConsistencyScanInSimActor, 3, ConsistencyScanState::StatsHistoryMap::RangeResultType >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DisableConsistencyScanInSimActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DisableConsistencyScanInSimActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DisableConsistencyScanInSimActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 885 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<Void> disableConsistencyScanInSim( Database const& db, bool const& waitForCompletion ) {
															#line 885 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<Void>(new DisableConsistencyScanInSimActor(db, waitForCompletion));
															#line 10261 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 958 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Waits until a database quiets down (no data in flight, small tlog queue, low SQ, no active data distribution). This
// requires the database to be available and healthy in order to succeed.
															#line 10268 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via waitForQuietDatabase()
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class WaitForQuietDatabaseActor>
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class WaitForQuietDatabaseActorState {
															#line 10275 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WaitForQuietDatabaseActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,std::string const& phase,int64_t const& dataInFlightGate = 2e6,int64_t const& maxTLogQueueGate = 5e6,int64_t const& maxStorageServerQueueGate = 5e6,int64_t const& maxDataDistributionQueueSize = 0,int64_t const& maxPoppedVersionLag = 30e6,int64_t const& maxVersionOffset = 1e6) 
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo),
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   phase(phase),
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dataInFlightGate(dataInFlightGate),
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   maxTLogQueueGate(maxTLogQueueGate),
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   maxStorageServerQueueGate(maxStorageServerQueueGate),
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   maxDataDistributionQueueSize(maxDataDistributionQueueSize),
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   maxPoppedVersionLag(maxPoppedVersionLag),
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   maxVersionOffset(maxVersionOffset),
															#line 970 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   checker(isGeneralBuggifyEnabled() ? 4000.0 : 1000.0),
															#line 971 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   reconfig(reconfigureAfter(cx, 100 + (deterministicRandom()->random01() * 100), dbInfo, "QuietDatabase")),
															#line 973 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dataInFlight(),
															#line 974 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   tLogQueueInfo(),
															#line 975 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dataDistributionQueueSize(),
															#line 976 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   teamCollectionValid(),
															#line 977 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   storageQueueSize(),
															#line 978 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dataDistributionActive(),
															#line 979 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   storageServersRecruiting(),
															#line 980 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   versionOffset(),
															#line 981 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dcLag(),
															#line 982 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   maxDcLag(100e6),
															#line 983 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   traceMessage("QuietDatabase" + phase + "Begin")
															#line 10324 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForQuietDatabase", reinterpret_cast<unsigned long>(this));

	}
	~WaitForQuietDatabaseActorState() 
	{
		fdb_probe_actor_destroy("waitForQuietDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 984 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent(traceMessage.c_str()).log();
															#line 987 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (g_network->isSimulated())
															#line 10341 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 988 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(5.0);
															#line 988 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10347 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 1;
															#line 988 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 0, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 10352 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForQuietDatabaseActorState();
		static_cast<WaitForQuietDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 990 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("QuietDatabaseWaitingOnFullRecovery").detail("Phase", phase).log();
															#line 991 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 10382 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 998 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		printf("Set perpetual_storage_wiggle=0 ...\n");
															#line 999 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Version> __when_expr_2 = setPerpetualStorageWiggle(cx, false, LockAware::True);
															#line 999 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10482 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 3;
															#line 999 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 2, Version >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 10487 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 991 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!(dbInfo->get().recoveryState != RecoveryState::FULLY_RECOVERED))
															#line 10503 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 992 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = dbInfo->onChange();
															#line 992 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10511 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 2;
															#line 992 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 1, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 10516 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1000 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		printf("Set perpetual_storage_wiggle=0 Done.\n");
															#line 1002 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		printf("Disabling backup worker ...\n");
															#line 1003 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_3 = disableBackupWorker(cx);
															#line 1003 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10631 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 4;
															#line 1003 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 3, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 10636 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Version const& __version,int loopDepth) 
	{
															#line 999 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		version = __version;
															#line 10645 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Version && __version,int loopDepth) 
	{
		version = std::move(__version);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1004 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		printf("Disabled backup worker.\n");
															#line 1006 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_4 = disableConsistencyScanInSim(cx, false);
															#line 1006 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10728 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 5;
															#line 1006 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 4, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 10733 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1004 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		printf("Disabled backup worker.\n");
															#line 1006 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_4 = disableConsistencyScanInSim(cx, false);
															#line 1006 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10746 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 5;
															#line 1006 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 4, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 10751 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1009 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		numSuccesses = 0;
															#line 1010 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 10837 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1009 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		numSuccesses = 0;
															#line 1010 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 10848 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1116 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<WaitForQuietDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForQuietDatabaseActorState(); static_cast<WaitForQuietDatabaseActor*>(this)->destroy(); return 0; }
															#line 10932 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<WaitForQuietDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForQuietDatabaseActorState();
		static_cast<WaitForQuietDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
		try {
															#line 1012 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseWaitingOnDataDistributor").log();
															#line 1013 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<WorkerInterface> __when_expr_5 = getDataDistributorWorker(cx, dbInfo);
															#line 1013 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10956 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont6loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6loopBody1when1(__when_expr_5.get(), loopDepth); };
			static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 6;
															#line 1013 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 5, WorkerInterface >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 10961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont6loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1065 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent(("QuietDatabase" + phase + "Error").c_str()).errorUnsuppressed(e);
															#line 1066 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (e.code() != error_code_actor_cancelled && e.code() != error_code_attribute_not_found && e.code() != error_code_timed_out)
															#line 10998 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1068 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent(("QuietDatabase" + phase + "Error").c_str()).error(e);
															#line 11002 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1072 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (e.code() != error_code_attribute_not_found && e.code() != error_code_timed_out)
															#line 11006 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1073 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 11010 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1075 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			auto evtType = "QuietDatabase" + phase + "Retry";
															#line 1076 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent evt(evtType.c_str());
															#line 1077 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			evt.error(e);
															#line 1078 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			int notReadyCount = 0;
															#line 1079 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (dataInFlight.isReady() && dataInFlight.isError())
															#line 11022 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1080 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto key = "NotReady" + std::to_string(notReadyCount++);
															#line 1081 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				evt.detail(key.c_str(), "dataInFlight");
															#line 11028 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1083 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (tLogQueueInfo.isReady() && tLogQueueInfo.isError())
															#line 11032 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1084 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto key = "NotReady" + std::to_string(notReadyCount++);
															#line 1085 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				evt.detail(key.c_str(), "tLogQueueInfo");
															#line 11038 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1087 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (dataDistributionQueueSize.isReady() && dataDistributionQueueSize.isError())
															#line 11042 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1088 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto key = "NotReady" + std::to_string(notReadyCount++);
															#line 1089 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				evt.detail(key.c_str(), "dataDistributionQueueSize");
															#line 11048 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1091 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (teamCollectionValid.isReady() && teamCollectionValid.isError())
															#line 11052 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1092 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto key = "NotReady" + std::to_string(notReadyCount++);
															#line 1093 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				evt.detail(key.c_str(), "teamCollectionValid");
															#line 11058 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1095 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (storageQueueSize.isReady() && storageQueueSize.isError())
															#line 11062 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1096 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto key = "NotReady" + std::to_string(notReadyCount++);
															#line 1097 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				evt.detail(key.c_str(), "storageQueueSize");
															#line 11068 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1099 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (dataDistributionActive.isReady() && dataDistributionActive.isError())
															#line 11072 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1100 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto key = "NotReady" + std::to_string(notReadyCount++);
															#line 1101 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				evt.detail(key.c_str(), "dataDistributionActive");
															#line 11078 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1103 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (storageServersRecruiting.isReady() && storageServersRecruiting.isError())
															#line 11082 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1104 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto key = "NotReady" + std::to_string(notReadyCount++);
															#line 1105 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				evt.detail(key.c_str(), "storageServersRecruiting");
															#line 11088 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1107 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (versionOffset.isReady() && versionOffset.isError())
															#line 11092 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1108 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto key = "NotReady" + std::to_string(notReadyCount++);
															#line 1109 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				evt.detail(key.c_str(), "versionOffset");
															#line 11098 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1111 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_9 = delay(1.0);
															#line 1111 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11104 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1Catch1when1(__when_expr_9.get(), loopDepth); };
			static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 10;
															#line 1111 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 9, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 11109 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2(WorkerInterface const& distributorWorker,int loopDepth) 
	{
															#line 1014 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		UID distributorUID = dbInfo->get().distributor.get().id();
															#line 1015 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("QuietDatabaseGotDataDistributor", distributorUID) .detail("Locality", distributorWorker.locality.toString());
															#line 1018 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		dataInFlight = getDataInFlight(cx, distributorWorker);
															#line 1019 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tLogQueueInfo = getTLogQueueInfo(cx, dbInfo);
															#line 1020 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		dataDistributionQueueSize = getDataDistributionQueueSize(cx, distributorWorker, dataInFlightGate == 0);
															#line 1021 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		teamCollectionValid = getTeamCollectionValid(cx, distributorWorker);
															#line 1022 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		storageQueueSize = getMaxStorageServerQueueSize(cx, dbInfo, version);
															#line 1023 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		dataDistributionActive = getDataDistributionActive(cx, distributorWorker);
															#line 1024 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		storageServersRecruiting = getStorageServersRecruiting(cx, distributorWorker, distributorUID);
															#line 1025 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		versionOffset = getVersionOffset(cx, distributorWorker, dbInfo);
															#line 1026 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		dcLag = getDatacenterLag(cx, dbInfo);
															#line 1028 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(dataInFlight) && success(tLogQueueInfo) && success(dataDistributionQueueSize) && success(teamCollectionValid) && success(storageQueueSize) && success(dataDistributionActive) && success(storageServersRecruiting) && success(versionOffset) && success(dcLag);
															#line 1028 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11148 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont6loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 7;
															#line 1028 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 6, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 11153 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2(WorkerInterface && distributorWorker,int loopDepth) 
	{
															#line 1014 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		UID distributorUID = dbInfo->get().distributor.get().id();
															#line 1015 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("QuietDatabaseGotDataDistributor", distributorUID) .detail("Locality", distributorWorker.locality.toString());
															#line 1018 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		dataInFlight = getDataInFlight(cx, distributorWorker);
															#line 1019 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tLogQueueInfo = getTLogQueueInfo(cx, dbInfo);
															#line 1020 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		dataDistributionQueueSize = getDataDistributionQueueSize(cx, distributorWorker, dataInFlightGate == 0);
															#line 1021 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		teamCollectionValid = getTeamCollectionValid(cx, distributorWorker);
															#line 1022 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		storageQueueSize = getMaxStorageServerQueueSize(cx, dbInfo, version);
															#line 1023 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		dataDistributionActive = getDataDistributionActive(cx, distributorWorker);
															#line 1024 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		storageServersRecruiting = getStorageServersRecruiting(cx, distributorWorker, distributorUID);
															#line 1025 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		versionOffset = getVersionOffset(cx, distributorWorker, dbInfo);
															#line 1026 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		dcLag = getDatacenterLag(cx, dbInfo);
															#line 1028 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(dataInFlight) && success(tLogQueueInfo) && success(dataDistributionQueueSize) && success(teamCollectionValid) && success(storageQueueSize) && success(dataDistributionActive) && success(storageServersRecruiting) && success(versionOffset) && success(dcLag);
															#line 1028 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11186 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont6loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 7;
															#line 1028 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 6, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 11191 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(WorkerInterface const& distributorWorker,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont2(distributorWorker, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(WorkerInterface && distributorWorker,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont2(std::move(distributorWorker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 5, WorkerInterface >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 5, WorkerInterface >*,WorkerInterface const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 5, WorkerInterface >*,WorkerInterface && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 5, WorkerInterface >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont6loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1032 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxVersionOffset += dbInfo->get().recoveryCount * SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT;
															#line 1034 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		auto check = checker.startIteration(phase);
															#line 1036 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::string evtType = "QuietDatabase" + phase;
															#line 1037 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent evt(evtType.c_str());
															#line 1038 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		check.add(evt, "DataInFlight", dataInFlight.get(), dataInFlightGate) .add(evt, "MaxTLogQueueSize", tLogQueueInfo.get().first, maxTLogQueueGate) .add(evt, "MaxTLogPoppedVersionLag", tLogQueueInfo.get().second, maxPoppedVersionLag) .add(evt, "DataDistributionQueueSize", dataDistributionQueueSize.get(), maxDataDistributionQueueSize) .add(evt, "TeamCollectionValid", teamCollectionValid.get(), true, std::equal_to<>()) .add(evt, "MaxStorageQueueSize", storageQueueSize.get(), maxStorageServerQueueGate) .add(evt, "DataDistributionActive", dataDistributionActive.get(), true, std::equal_to<>()) .add(evt, "StorageServersRecruiting", storageServersRecruiting.get(), false, std::equal_to<>()) .add(evt, "VersionOffset", versionOffset.get(), maxVersionOffset) .add(evt, "DatacenterLag", dcLag.get(), maxDcLag);
															#line 1049 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		evt.detail("RecoveryCount", dbInfo->get().recoveryCount).detail("NumSuccesses", numSuccesses);
															#line 1050 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		evt.log();
															#line 1052 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (check.success())
															#line 11289 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 1053 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (++numSuccesses == 3)
															#line 11293 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1054 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto msg = "QuietDatabase" + phase + "Done";
															#line 1055 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent(msg.c_str()).log();
															#line 11299 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 1058 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<Void> __when_expr_7 = delay(g_network->isSimulated() ? 2.0 : 30.0);
															#line 1058 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11308 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont6loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont6loopBody1cont3when1(__when_expr_7.get(), loopDepth); };
				static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 8;
															#line 1058 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 7, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 11313 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
		}
		else
		{
															#line 1061 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_8 = delay(1.0);
															#line 1061 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11323 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont6loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont6loopBody1cont3when2(__when_expr_8.get(), loopDepth); };
			static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 9;
															#line 1061 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 8, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 11328 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1032 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxVersionOffset += dbInfo->get().recoveryCount * SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT;
															#line 1034 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		auto check = checker.startIteration(phase);
															#line 1036 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::string evtType = "QuietDatabase" + phase;
															#line 1037 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent evt(evtType.c_str());
															#line 1038 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		check.add(evt, "DataInFlight", dataInFlight.get(), dataInFlightGate) .add(evt, "MaxTLogQueueSize", tLogQueueInfo.get().first, maxTLogQueueGate) .add(evt, "MaxTLogPoppedVersionLag", tLogQueueInfo.get().second, maxPoppedVersionLag) .add(evt, "DataDistributionQueueSize", dataDistributionQueueSize.get(), maxDataDistributionQueueSize) .add(evt, "TeamCollectionValid", teamCollectionValid.get(), true, std::equal_to<>()) .add(evt, "MaxStorageQueueSize", storageQueueSize.get(), maxStorageServerQueueGate) .add(evt, "DataDistributionActive", dataDistributionActive.get(), true, std::equal_to<>()) .add(evt, "StorageServersRecruiting", storageServersRecruiting.get(), false, std::equal_to<>()) .add(evt, "VersionOffset", versionOffset.get(), maxVersionOffset) .add(evt, "DatacenterLag", dcLag.get(), maxDcLag);
															#line 1049 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		evt.detail("RecoveryCount", dbInfo->get().recoveryCount).detail("NumSuccesses", numSuccesses);
															#line 1050 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		evt.log();
															#line 1052 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (check.success())
															#line 11352 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 1053 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (++numSuccesses == 3)
															#line 11356 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1054 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto msg = "QuietDatabase" + phase + "Done";
															#line 1055 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent(msg.c_str()).log();
															#line 11362 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 1058 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<Void> __when_expr_7 = delay(g_network->isSimulated() ? 2.0 : 30.0);
															#line 1058 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11371 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont6loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont6loopBody1cont3when1(__when_expr_7.get(), loopDepth); };
				static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 8;
															#line 1058 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 7, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 11376 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
		}
		else
		{
															#line 1061 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_8 = delay(1.0);
															#line 1061 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11386 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont6loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont6loopBody1cont3when2(__when_expr_8.get(), loopDepth); };
			static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 9;
															#line 1061 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 8, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 11391 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont6loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont6loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 1062 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		numSuccesses = 0;
															#line 11575 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont6loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 1062 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		numSuccesses = 0;
															#line 11584 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont6loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont6loopBody1cont3when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont6loopBody1cont3when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont6loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont6loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont6loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 1112 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		numSuccesses = 0;
															#line 11681 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 1112 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		numSuccesses = 0;
															#line 11690 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont6loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont6loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::string phase;
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t dataInFlightGate;
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxTLogQueueGate;
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxStorageServerQueueGate;
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxDataDistributionQueueSize;
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxPoppedVersionLag;
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxVersionOffset;
															#line 970 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	QuietDatabaseChecker checker;
															#line 971 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<Void> reconfig;
															#line 973 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<int64_t> dataInFlight;
															#line 974 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<std::pair<int64_t, int64_t>> tLogQueueInfo;
															#line 975 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<int64_t> dataDistributionQueueSize;
															#line 976 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<bool> teamCollectionValid;
															#line 977 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<int64_t> storageQueueSize;
															#line 978 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<bool> dataDistributionActive;
															#line 979 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<bool> storageServersRecruiting;
															#line 980 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<int64_t> versionOffset;
															#line 981 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<Version> dcLag;
															#line 982 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Version maxDcLag;
															#line 983 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::string traceMessage;
															#line 999 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Version version;
															#line 1009 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int numSuccesses;
															#line 11818 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via waitForQuietDatabase()
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class WaitForQuietDatabaseActor final : public Actor<Void>, public ActorCallback< WaitForQuietDatabaseActor, 0, Void >, public ActorCallback< WaitForQuietDatabaseActor, 1, Void >, public ActorCallback< WaitForQuietDatabaseActor, 2, Version >, public ActorCallback< WaitForQuietDatabaseActor, 3, Void >, public ActorCallback< WaitForQuietDatabaseActor, 4, Void >, public ActorCallback< WaitForQuietDatabaseActor, 5, WorkerInterface >, public ActorCallback< WaitForQuietDatabaseActor, 6, Void >, public ActorCallback< WaitForQuietDatabaseActor, 7, Void >, public ActorCallback< WaitForQuietDatabaseActor, 8, Void >, public ActorCallback< WaitForQuietDatabaseActor, 9, Void >, public FastAllocated<WaitForQuietDatabaseActor>, public WaitForQuietDatabaseActorState<WaitForQuietDatabaseActor> {
															#line 11823 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<WaitForQuietDatabaseActor>::operator new;
	using FastAllocated<WaitForQuietDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10767411576563569920UL, 10736586544854885376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForQuietDatabaseActor, 0, Void >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 1, Void >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 2, Version >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 3, Void >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 4, Void >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 5, WorkerInterface >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 6, Void >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 7, Void >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 8, Void >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 9, Void >;
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WaitForQuietDatabaseActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,std::string const& phase,int64_t const& dataInFlightGate = 2e6,int64_t const& maxTLogQueueGate = 5e6,int64_t const& maxStorageServerQueueGate = 5e6,int64_t const& maxDataDistributionQueueSize = 0,int64_t const& maxPoppedVersionLag = 30e6,int64_t const& maxVersionOffset = 1e6) 
															#line 11849 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<Void>(),
		   WaitForQuietDatabaseActorState<WaitForQuietDatabaseActor>(cx, dbInfo, phase, dataInFlightGate, maxTLogQueueGate, maxStorageServerQueueGate, maxDataDistributionQueueSize, maxPoppedVersionLag, maxVersionOffset),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16870213735109939200UL, 17663630716451811840UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForQuietDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 2, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 5, WorkerInterface >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<Void> waitForQuietDatabase( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, std::string const& phase, int64_t const& dataInFlightGate = 2e6, int64_t const& maxTLogQueueGate = 5e6, int64_t const& maxStorageServerQueueGate = 5e6, int64_t const& maxDataDistributionQueueSize = 0, int64_t const& maxPoppedVersionLag = 30e6, int64_t const& maxVersionOffset = 1e6 ) {
															#line 961 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<Void>(new WaitForQuietDatabaseActor(cx, dbInfo, phase, dataInFlightGate, maxTLogQueueGate, maxStorageServerQueueGate, maxDataDistributionQueueSize, maxPoppedVersionLag, maxVersionOffset));
															#line 11891 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 1118 "/codebuild/output/src2177420633/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

Future<Void> quietDatabase(Database const& cx,
                           Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,
                           std::string phase,
                           int64_t dataInFlightGate,
                           int64_t maxTLogQueueGate,
                           int64_t maxStorageServerQueueGate,
                           int64_t maxDataDistributionQueueSize,
                           int64_t maxPoppedVersionLag,
                           int64_t maxVersionOffset) {
	return waitForQuietDatabase(cx,
	                            dbInfo,
	                            phase,
	                            dataInFlightGate,
	                            maxTLogQueueGate,
	                            maxStorageServerQueueGate,
	                            maxDataDistributionQueueSize,
	                            maxPoppedVersionLag,
	                            maxVersionOffset);
}
