#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
/*
 * workloads.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cinttypes>

#include "flow/flow.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/DataDistributionConfig.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

															#line 30 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via customShardConfigWorkload()
															#line 28 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
template <class CustomShardConfigWorkloadActor>
															#line 28 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
class CustomShardConfigWorkloadActorState {
															#line 37 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
public:
															#line 28 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
	CustomShardConfigWorkloadActorState(Database const& cx) 
															#line 28 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
															#line 28 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		 : cx(cx),
															#line 29 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		   tr(cx),
															#line 30 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		   verbose((KEYBACKEDTYPES_DEBUG != 0)),
															#line 34 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		   rangeConfig(DDConfiguration().userRangeConfig())
															#line 50 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("customShardConfigWorkload", reinterpret_cast<unsigned long>(this));

	}
	~CustomShardConfigWorkloadActorState() 
	{
		fdb_probe_actor_destroy("customShardConfigWorkload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 36 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			;
															#line 65 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CustomShardConfigWorkloadActorState();
		static_cast<CustomShardConfigWorkloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 132 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (!static_cast<CustomShardConfigWorkloadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CustomShardConfigWorkloadActorState(); static_cast<CustomShardConfigWorkloadActor*>(this)->destroy(); return 0; }
															#line 88 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		new (&static_cast<CustomShardConfigWorkloadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CustomShardConfigWorkloadActorState();
		static_cast<CustomShardConfigWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 38 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 39 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 42 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 112 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
			{
															#line 43 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
				TraceEvent("KeyRangeConfigSetDefault").log();
															#line 44 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
				CODE_PROBE(true, "Set default shard range");
															#line 45 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
				StrictFuture<Void> __when_expr_0 = rangeConfig->updateRange(&tr, allKeys.begin, allKeys.end, DDRangeConfig());
															#line 45 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
				if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 122 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 1;
															#line 45 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 0, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 127 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 128 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			TraceEvent("KeyRangeConfigCommitError").error(e);
															#line 129 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			StrictFuture<Void> __when_expr_12 = tr.onError(e);
															#line 129 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 171 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
			if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_12.get(), loopDepth); };
			static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 13;
															#line 129 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 12, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 176 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 48 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 191 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		{
															#line 49 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			CODE_PROBE(true, "Set range config test cases");
															#line 50 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			TraceEvent("KeyRangeConfigSetTestRanges").log();
															#line 52 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			StrictFuture<Void> __when_expr_1 = rangeConfig->updateRange(&tr, "\xff\x03"_sr, "\xff\x04"_sr, DDRangeConfig(3));
															#line 52 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 201 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 2;
															#line 52 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 1, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 206 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state > 0) static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<CustomShardConfigWorkloadActor*>(this)->ActorCallback< CustomShardConfigWorkloadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CustomShardConfigWorkloadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 124 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Void> __when_expr_11 = tr.commit();
															#line 124 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 309 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1loopBody1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_11.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 12;
															#line 124 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 11, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 314 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 53 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Void> __when_expr_2 = rangeConfig->updateRange(&tr, "\xff\x06"_sr, "\xff\x07"_sr, DDRangeConfig(6));
															#line 53 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 325 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 3;
															#line 53 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 2, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 330 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 53 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Void> __when_expr_2 = rangeConfig->updateRange(&tr, "\xff\x06"_sr, "\xff\x07"_sr, DDRangeConfig(6));
															#line 53 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 341 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 3;
															#line 53 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 2, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 346 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state > 0) static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<CustomShardConfigWorkloadActor*>(this)->ActorCallback< CustomShardConfigWorkloadActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CustomShardConfigWorkloadActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 54 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Void> __when_expr_3 = rangeConfig->updateRange(&tr, "\xff\x04"_sr, "\xff\x05"_sr, DDRangeConfig(4));
															#line 54 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 432 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 4;
															#line 54 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 3, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 437 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 54 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Void> __when_expr_3 = rangeConfig->updateRange(&tr, "\xff\x04"_sr, "\xff\x05"_sr, DDRangeConfig(4));
															#line 54 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 448 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 4;
															#line 54 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 3, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 453 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state > 0) static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<CustomShardConfigWorkloadActor*>(this)->ActorCallback< CustomShardConfigWorkloadActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CustomShardConfigWorkloadActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 56 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Void> __when_expr_4 = rangeConfig->updateRange(&tr, "\xff\x03k"_sr, "\xff\x03z"_sr, DDRangeConfig(3));
															#line 56 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 539 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 5;
															#line 56 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 4, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 544 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 56 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Void> __when_expr_4 = rangeConfig->updateRange(&tr, "\xff\x03k"_sr, "\xff\x03z"_sr, DDRangeConfig(3));
															#line 56 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 555 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 5;
															#line 56 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 4, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 560 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state > 0) static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<CustomShardConfigWorkloadActor*>(this)->ActorCallback< CustomShardConfigWorkloadActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CustomShardConfigWorkloadActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Void> __when_expr_5 = rangeConfig->updateRange(&tr, "\xff\x04t"_sr, "\xff\x05h"_sr, DDRangeConfig(3, 1), true);
															#line 57 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 646 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 6;
															#line 57 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 5, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 651 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Void> __when_expr_5 = rangeConfig->updateRange(&tr, "\xff\x04t"_sr, "\xff\x05h"_sr, DDRangeConfig(3, 1), true);
															#line 57 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 662 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 6;
															#line 57 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 5, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 667 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state > 0) static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<CustomShardConfigWorkloadActor*>(this)->ActorCallback< CustomShardConfigWorkloadActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CustomShardConfigWorkloadActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 58 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Void> __when_expr_6 = rangeConfig->updateRange(&tr, "\xff\x06u"_sr, "\xff\x07m"_sr, DDRangeConfig({}, 2));
															#line 58 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 753 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 7;
															#line 58 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 6, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 758 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 58 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Void> __when_expr_6 = rangeConfig->updateRange(&tr, "\xff\x06u"_sr, "\xff\x07m"_sr, DDRangeConfig({}, 2));
															#line 58 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 769 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 7;
															#line 58 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 6, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 774 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state > 0) static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<CustomShardConfigWorkloadActor*>(this)->ActorCallback< CustomShardConfigWorkloadActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CustomShardConfigWorkloadActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 60 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Void> __when_expr_7 = rangeConfig->updateRange(&tr, "a"_sr, "b"_sr, DDRangeConfig(3, 20), true);
															#line 60 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 860 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont10when1(__when_expr_7.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 8;
															#line 60 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 7, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 865 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 60 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Void> __when_expr_7 = rangeConfig->updateRange(&tr, "a"_sr, "b"_sr, DDRangeConfig(3, 20), true);
															#line 60 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 876 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont10when1(__when_expr_7.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 8;
															#line 60 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 7, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 881 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state > 0) static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<CustomShardConfigWorkloadActor*>(this)->ActorCallback< CustomShardConfigWorkloadActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CustomShardConfigWorkloadActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 61 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Void> __when_expr_8 = rangeConfig->updateRange(&tr, "a"_sr, "a10"_sr, DDRangeConfig(3, 20), true);
															#line 61 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 967 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont10cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 9;
															#line 61 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 8, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 972 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont1(Void && _,int loopDepth) 
	{
															#line 61 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Void> __when_expr_8 = rangeConfig->updateRange(&tr, "a"_sr, "a10"_sr, DDRangeConfig(3, 20), true);
															#line 61 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 983 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont10cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 9;
															#line 61 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 8, Void >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 988 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state > 0) static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<CustomShardConfigWorkloadActor*>(this)->ActorCallback< CustomShardConfigWorkloadActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CustomShardConfigWorkloadActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont10cont2(Void const& _,int loopDepth) 
	{
															#line 64 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		rangeTests = { { "\x01"_sr, false, DDRangeConfig() }, { "\xff\x10"_sr, false, DDRangeConfig() }, { "\xff\x03x"_sr, true, DDRangeConfig(3) }, { "\xff\x04z"_sr, true, DDRangeConfig(3, 1) }, { "\xff\x05"_sr, true, DDRangeConfig(3, 1) }, { "\xff\x06"_sr, true, DDRangeConfig(6) }, { "\xff\x06u"_sr, true, DDRangeConfig(6, 2) }, { "\xff\x06v"_sr, true, DDRangeConfig(6, 2) }, { "\xff\x07m"_sr, false, DDRangeConfig() }, { "\xff\x07k"_sr, true, DDRangeConfig({}, 2) }, { "a"_sr, true, DDRangeConfig(3, 20) }, { "a10"_sr, true, DDRangeConfig(3, 20) }, { "a11"_sr, true, DDRangeConfig(3, 20) }, { "b"_sr, false, DDRangeConfig() }, { "b1"_sr, false, DDRangeConfig() } };
															#line 82 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Reference<DDConfiguration::RangeConfigMapSnapshot>> __when_expr_9 = rangeConfig->getSnapshot(&tr, allKeys.begin, allKeys.end);
															#line 82 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1076 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1loopBody1cont10cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 10;
															#line 82 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 9, Reference<DDConfiguration::RangeConfigMapSnapshot> >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 1081 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont2(Void && _,int loopDepth) 
	{
															#line 64 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		rangeTests = { { "\x01"_sr, false, DDRangeConfig() }, { "\xff\x10"_sr, false, DDRangeConfig() }, { "\xff\x03x"_sr, true, DDRangeConfig(3) }, { "\xff\x04z"_sr, true, DDRangeConfig(3, 1) }, { "\xff\x05"_sr, true, DDRangeConfig(3, 1) }, { "\xff\x06"_sr, true, DDRangeConfig(6) }, { "\xff\x06u"_sr, true, DDRangeConfig(6, 2) }, { "\xff\x06v"_sr, true, DDRangeConfig(6, 2) }, { "\xff\x07m"_sr, false, DDRangeConfig() }, { "\xff\x07k"_sr, true, DDRangeConfig({}, 2) }, { "a"_sr, true, DDRangeConfig(3, 20) }, { "a10"_sr, true, DDRangeConfig(3, 20) }, { "a11"_sr, true, DDRangeConfig(3, 20) }, { "b"_sr, false, DDRangeConfig() }, { "b1"_sr, false, DDRangeConfig() } };
															#line 82 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Reference<DDConfiguration::RangeConfigMapSnapshot>> __when_expr_9 = rangeConfig->getSnapshot(&tr, allKeys.begin, allKeys.end);
															#line 82 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1094 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1loopBody1cont10cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 10;
															#line 82 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 9, Reference<DDConfiguration::RangeConfigMapSnapshot> >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 1099 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state > 0) static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<CustomShardConfigWorkloadActor*>(this)->ActorCallback< CustomShardConfigWorkloadActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CustomShardConfigWorkloadActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1cont10cont3(int loopDepth) 
	{
															#line 85 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (verbose)
															#line 1183 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		{
															#line 86 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			fmt::print( "DD User Range Config:\n{}\n", json_spirit::write_string(DDConfiguration::toJSON(*snapshot, true), json_spirit::pretty_print));
															#line 1187 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		}
															#line 91 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		i = int();
															#line 92 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		i = 0;
															#line 1193 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont10cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont2when1(Reference<DDConfiguration::RangeConfigMapSnapshot> const& __snapshot,int loopDepth) 
	{
															#line 82 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		snapshot = __snapshot;
															#line 1202 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont10cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont2when1(Reference<DDConfiguration::RangeConfigMapSnapshot> && __snapshot,int loopDepth) 
	{
		snapshot = std::move(__snapshot);
		loopDepth = a_body1loopBody1cont10cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state > 0) static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<CustomShardConfigWorkloadActor*>(this)->ActorCallback< CustomShardConfigWorkloadActor, 9, Reference<DDConfiguration::RangeConfigMapSnapshot> >::remove();

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 9, Reference<DDConfiguration::RangeConfigMapSnapshot> >*,Reference<DDConfiguration::RangeConfigMapSnapshot> const& value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 9, Reference<DDConfiguration::RangeConfigMapSnapshot> >*,Reference<DDConfiguration::RangeConfigMapSnapshot> && value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CustomShardConfigWorkloadActor, 9, Reference<DDConfiguration::RangeConfigMapSnapshot> >*,Error err) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1cont10cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont10cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont3loopBody1(int loopDepth) 
	{
															#line 92 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (!(i < rangeTests.size()))
															#line 1294 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont10cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 93 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		query = std::get<0>(rangeTests[i]);
															#line 94 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		StrictFuture<Optional<DDConfiguration::RangeConfigMap::RangeValue>> __when_expr_10 = rangeConfig->getRangeForKey(&tr, query);
															#line 94 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1304 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1loopBody1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont10cont3loopBody1when1(__when_expr_10.get(), loopDepth); };
		static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 11;
															#line 94 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< CustomShardConfigWorkloadActor, 10, Optional<DDConfiguration::RangeConfigMap::RangeValue> >*>(static_cast<CustomShardConfigWorkloadActor*>(this)));
															#line 1309 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont10cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont10cont3loopBody1cont1(Optional<DDConfiguration::RangeConfigMap::RangeValue> const& verify,int loopDepth) 
	{
															#line 97 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (verbose)
															#line 1331 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		{
															#line 98 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			if (verify.present())
															#line 1335 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
			{
															#line 99 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
				fmt::print("'{}' is in '{}' to '{}' with config {}\n", query.printable(), verify->range.begin, verify->range.end, verify->value.toString());
															#line 1339 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
			}
			else
			{
															#line 105 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
				fmt::print("'{}' is not in a range in the config\n", query.printable());
															#line 1345 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
			}
		}
															#line 110 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		ASSERT(verify.present() || !std::get<1>(rangeTests[i]));
															#line 111 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		DDRangeConfig rc = std::get<2>(rangeTests[i]);
															#line 112 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		ASSERT(!verify.present() || verify->value == rc);
															#line 114 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		auto snapshotRange = snapshot->rangeContaining(query);
															#line 115 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		ASSERT(snapshotRange.value() == rc);
															#line 117 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (verify.present())
															#line 1360 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		{
															#line 118 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			ASSERT(snapshotRange.range().begin == verify->range.begin);
															#line 119 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			ASSERT(snapshotRange.range().end == verify->range.end);
															#line 1366 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		}
															#line 92 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		++i;
															#line 1370 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont10cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont3loopBody1cont1(Optional<DDConfiguration::RangeConfigMap::RangeValue> && verify,int loopDepth) 
	{
															#line 97 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (verbose)
															#line 1379 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		{
															#line 98 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			if (verify.present())
															#line 1383 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
			{
															#line 99 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
				fmt::print("'{}' is in '{}' to '{}' with config {}\n", query.printable(), verify->range.begin, verify->range.end, verify->value.toString());
															#line 1387 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
			}
			else
			{
															#line 105 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
				fmt::print("'{}' is not in a range in the config\n", query.printable());
															#line 1393 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
			}
		}
															#line 110 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		ASSERT(verify.present() || !std::get<1>(rangeTests[i]));
															#line 111 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		DDRangeConfig rc = std::get<2>(rangeTests[i]);
															#line 112 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		ASSERT(!verify.present() || verify->value == rc);
															#line 114 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		auto snapshotRange = snapshot->rangeContaining(query);
															#line 115 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		ASSERT(snapshotRange.value() == rc);
															#line 117 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		if (verify.present())
															#line 1408 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		{
															#line 118 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			ASSERT(snapshotRange.range().begin == verify->range.begin);
															#line 119 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
			ASSERT(snapshotRange.range().end == verify->range.end);
															#line 1414 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		}
															#line 92 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		++i;
															#line 1418 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont10cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont3loopBody1when1(Optional<DDConfiguration::RangeConfigMap::RangeValue> const& verify,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont3loopBody1cont1(verify, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont3loopBody1when1(Optional<DDConfiguration::RangeConfigMap::RangeValue> && verify,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont3loopBody1cont1(std::move(verify), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state > 0) static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<CustomShardConfigWorkloadActor*>(this)->ActorCallback< CustomShardConfigWorkloadActor, 10, Optional<DDConfiguration::RangeConfigMap::RangeValue> >::remove();

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 10, Optional<DDConfiguration::RangeConfigMap::RangeValue> >*,Optional<DDConfiguration::RangeConfigMap::RangeValue> const& value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont10cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 10, Optional<DDConfiguration::RangeConfigMap::RangeValue> >*,Optional<DDConfiguration::RangeConfigMap::RangeValue> && value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont10cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< CustomShardConfigWorkloadActor, 10, Optional<DDConfiguration::RangeConfigMap::RangeValue> >*,Error err) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 125 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		TraceEvent("KeyRangeConfigCommitted").log();
															#line 1502 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 125 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
		TraceEvent("KeyRangeConfigCommitted").log();
															#line 1511 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state > 0) static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<CustomShardConfigWorkloadActor*>(this)->ActorCallback< CustomShardConfigWorkloadActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< CustomShardConfigWorkloadActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state > 0) static_cast<CustomShardConfigWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<CustomShardConfigWorkloadActor*>(this)->ActorCallback< CustomShardConfigWorkloadActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< CustomShardConfigWorkloadActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< CustomShardConfigWorkloadActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), 12);

	}
															#line 28 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
	Database cx;
															#line 29 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 30 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
	bool verbose;
															#line 34 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
	Optional<DDConfiguration::RangeConfigMap> rangeConfig;
															#line 64 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
	std::vector<std::tuple<Key, bool, DDRangeConfig>> rangeTests;
															#line 82 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
	Reference<DDConfiguration::RangeConfigMapSnapshot> snapshot;
															#line 91 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
	int i;
															#line 93 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
	Key query;
															#line 1694 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
};
// This generated class is to be used only via customShardConfigWorkload()
															#line 28 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
class CustomShardConfigWorkloadActor final : public Actor<Void>, public ActorCallback< CustomShardConfigWorkloadActor, 0, Void >, public ActorCallback< CustomShardConfigWorkloadActor, 1, Void >, public ActorCallback< CustomShardConfigWorkloadActor, 2, Void >, public ActorCallback< CustomShardConfigWorkloadActor, 3, Void >, public ActorCallback< CustomShardConfigWorkloadActor, 4, Void >, public ActorCallback< CustomShardConfigWorkloadActor, 5, Void >, public ActorCallback< CustomShardConfigWorkloadActor, 6, Void >, public ActorCallback< CustomShardConfigWorkloadActor, 7, Void >, public ActorCallback< CustomShardConfigWorkloadActor, 8, Void >, public ActorCallback< CustomShardConfigWorkloadActor, 9, Reference<DDConfiguration::RangeConfigMapSnapshot> >, public ActorCallback< CustomShardConfigWorkloadActor, 10, Optional<DDConfiguration::RangeConfigMap::RangeValue> >, public ActorCallback< CustomShardConfigWorkloadActor, 11, Void >, public ActorCallback< CustomShardConfigWorkloadActor, 12, Void >, public FastAllocated<CustomShardConfigWorkloadActor>, public CustomShardConfigWorkloadActorState<CustomShardConfigWorkloadActor> {
															#line 1699 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
public:
	using FastAllocated<CustomShardConfigWorkloadActor>::operator new;
	using FastAllocated<CustomShardConfigWorkloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8421926545093528832UL, 11157768289513011968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CustomShardConfigWorkloadActor, 0, Void >;
friend struct ActorCallback< CustomShardConfigWorkloadActor, 1, Void >;
friend struct ActorCallback< CustomShardConfigWorkloadActor, 2, Void >;
friend struct ActorCallback< CustomShardConfigWorkloadActor, 3, Void >;
friend struct ActorCallback< CustomShardConfigWorkloadActor, 4, Void >;
friend struct ActorCallback< CustomShardConfigWorkloadActor, 5, Void >;
friend struct ActorCallback< CustomShardConfigWorkloadActor, 6, Void >;
friend struct ActorCallback< CustomShardConfigWorkloadActor, 7, Void >;
friend struct ActorCallback< CustomShardConfigWorkloadActor, 8, Void >;
friend struct ActorCallback< CustomShardConfigWorkloadActor, 9, Reference<DDConfiguration::RangeConfigMapSnapshot> >;
friend struct ActorCallback< CustomShardConfigWorkloadActor, 10, Optional<DDConfiguration::RangeConfigMap::RangeValue> >;
friend struct ActorCallback< CustomShardConfigWorkloadActor, 11, Void >;
friend struct ActorCallback< CustomShardConfigWorkloadActor, 12, Void >;
															#line 28 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
	CustomShardConfigWorkloadActor(Database const& cx) 
															#line 1728 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CustomShardConfigWorkloadActorState<CustomShardConfigWorkloadActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15538770699401834496UL, 65756121519738624UL);
		ActorExecutionContextHelper __helper(static_cast<CustomShardConfigWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("customShardConfigWorkload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("customShardConfigWorkload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CustomShardConfigWorkloadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CustomShardConfigWorkloadActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CustomShardConfigWorkloadActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CustomShardConfigWorkloadActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CustomShardConfigWorkloadActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CustomShardConfigWorkloadActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CustomShardConfigWorkloadActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CustomShardConfigWorkloadActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CustomShardConfigWorkloadActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CustomShardConfigWorkloadActor, 9, Reference<DDConfiguration::RangeConfigMapSnapshot> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< CustomShardConfigWorkloadActor, 10, Optional<DDConfiguration::RangeConfigMap::RangeValue> >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< CustomShardConfigWorkloadActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< CustomShardConfigWorkloadActor, 12, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 28 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
[[nodiscard]] Future<Void> customShardConfigWorkload( Database const& cx ) {
															#line 28 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
	return Future<Void>(new CustomShardConfigWorkloadActor(cx));
															#line 1773 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/workloads.actor.g.cpp.py_gen"
}

#line 134 "/codebuild/output/src4210423301/src/github.com/apple/foundationdb/fdbserver/workloads/workloads.actor.cpp"
