package com.apple.foundationdb;

/**
 * A set of options that can be set globally for the {@link FDB FoundationDB API}.
 */
public class NetworkOptions extends OptionsSet {
	public NetworkOptions( OptionConsumer consumer ) { super(consumer); }

	/**
	 * Deprecated.
	 * 
	 * @param value IP:PORT
	 */
	@Deprecated
	public void setLocalAddress(String value) { setOption(10, value); }

	/**
	 * Deprecated.
	 * 
	 * @param value path to cluster file
	 */
	@Deprecated
	public void setClusterFile(String value) { setOption(20, value); }

	/**
	 * Enables trace output to a file in a directory of the clients choosing.
	 * 
	 * @param value path to output directory (or NULL for current working directory)
	 */
	public void setTraceEnable(String value) { setOption(30, value); }

	/**
	 * Sets the maximum size in bytes of a single trace output file. This value should be in the range {@code [0, INT64_MAX]}. If the value is set to 0, there is no limit on individual file size. The default is a maximum size of 10,485,760 bytes.
	 * 
	 * @param value max size of a single trace output file
	 */
	public void setTraceRollSize(long value) { setOption(31, value); }

	/**
	 * Sets the maximum size of all the trace output files put together. This value should be in the range {@code [0, INT64_MAX]}. If the value is set to 0, there is no limit on the total size of the files. The default is a maximum size of 104,857,600 bytes. If the default roll size is used, this means that a maximum of 10 trace files will be written at a time.
	 * 
	 * @param value max total size of trace files
	 */
	public void setTraceMaxLogsSize(long value) { setOption(32, value); }

	/**
	 * Sets the 'LogGroup' attribute with the specified value for all events in the trace output files. The default log group is 'default'.
	 * 
	 * @param value value of the LogGroup attribute
	 */
	public void setTraceLogGroup(String value) { setOption(33, value); }

	/**
	 * Select the format of the log files. xml (the default) and json are supported.
	 * 
	 * @param value Format of trace files
	 */
	public void setTraceFormat(String value) { setOption(34, value); }

	/**
	 * Select clock source for trace files. now (the default) or realtime are supported.
	 * 
	 * @param value Trace clock source
	 */
	public void setTraceClockSource(String value) { setOption(35, value); }

	/**
	 * Once provided, this string will be used to replace the port/PID in the log file names.
	 * 
	 * @param value The identifier that will be part of all trace file names
	 */
	public void setTraceFileIdentifier(String value) { setOption(36, value); }

	/**
	 * Use the same base trace file name for all client threads as it did before version 7.2. The current default behavior is to use distinct trace file names for client threads by including their version and thread index.
	 */
	public void setTraceShareAmongClientThreads() { setOption(37); }

	/**
	 * Initialize trace files on network setup, determine the local IP later. Otherwise tracing is initialized when opening the first database.
	 */
	public void setTraceInitializeOnSetup() { setOption(38); }

	/**
	 * Set file suffix for partially written log files.
	 * 
	 * @param value Append this suffix to partially written log files. When a log file is complete, it is renamed to remove the suffix. No separator is added between the file and the suffix. If you want to add a file extension, you should include the separator - e.g. '.tmp' instead of 'tmp' to add the 'tmp' extension.
	 */
	public void setTracePartialFileSuffix(String value) { setOption(39, value); }

	/**
	 * Set internal tuning or debugging knobs.
	 * 
	 * @param value knob_name=knob_value
	 */
	public void setKnob(String value) { setOption(40, value); }

	/**
	 * Deprecated.
	 * 
	 * @param value file path or linker-resolved name
	 */
	@Deprecated
	public void setTLSPlugin(String value) { setOption(41, value); }

	/**
	 * Set the certificate chain.
	 * 
	 * @param value certificates
	 */
	public void setTLSCertBytes(byte[] value) { setOption(42, value); }

	/**
	 * Set the file from which to load the certificate chain.
	 * 
	 * @param value file path
	 */
	public void setTLSCertPath(String value) { setOption(43, value); }

	/**
	 * Set the private key corresponding to your own certificate.
	 * 
	 * @param value key
	 */
	public void setTLSKeyBytes(byte[] value) { setOption(45, value); }

	/**
	 * Set the file from which to load the private key corresponding to your own certificate.
	 * 
	 * @param value file path
	 */
	public void setTLSKeyPath(String value) { setOption(46, value); }

	/**
	 * Set the peer certificate field verification criteria.
	 * 
	 * @param value verification pattern
	 */
	public void setTLSVerifyPeers(byte[] value) { setOption(47, value); }

	/**
	 * Set the probability of a BUGGIFY section being active for the current execution.  Only applies to code paths first traversed AFTER this option is changed.
	 * 
	 * @param value probability expressed as a percentage between 0 and 100
	 */
	public void setBuggifySectionActivatedProbability(long value) { setOption(50, value); }

	/**
	 * Set the probability of an active BUGGIFY section being fired.
	 * 
	 * @param value probability expressed as a percentage between 0 and 100
	 */
	public void setBuggifySectionFiredProbability(long value) { setOption(51, value); }

	/**
	 * Set the ca bundle.
	 * 
	 * @param value ca bundle
	 */
	public void setTLSCaBytes(byte[] value) { setOption(52, value); }

	/**
	 * Set the file from which to load the certificate authority bundle.
	 * 
	 * @param value file path
	 */
	public void setTLSCaPath(String value) { setOption(53, value); }

	/**
	 * Set the passphrase for encrypted private key. Password should be set before setting the key for the password to be used.
	 * 
	 * @param value key passphrase
	 */
	public void setTLSPassword(String value) { setOption(54, value); }

	/**
	 * Prevent client from connecting to a non-TLS endpoint by throwing network connection failed error.
	 */
	public void setTLSDisablePlaintextConnection() { setOption(55); }

	/**
	 * Disables the multi-version client API and instead uses the local client directly. Must be set before setting up the network.
	 */
	public void setDisableMultiVersionClientApi() { setOption(60); }

	/**
	 * If set, callbacks from external client libraries can be called from threads created by the FoundationDB client library. Otherwise, callbacks will be called from either the thread used to add the callback or the network thread. Setting this option can improve performance when connected using an external client, but may not be safe to use in all environments. Must be set before setting up the network. WARNING: This feature is considered experimental at this time.
	 */
	public void setCallbacksOnExternalThreads() { setOption(61); }

	/**
	 * Adds an external client library for use by the multi-version client API. Must be set before setting up the network.
	 * 
	 * @param value path to client library
	 */
	public void setExternalClientLibrary(String value) { setOption(62, value); }

	/**
	 * Searches the specified path for dynamic libraries and adds them to the list of client libraries for use by the multi-version client API. Must be set before setting up the network.
	 * 
	 * @param value path to directory containing client libraries
	 */
	public void setExternalClientDirectory(String value) { setOption(63, value); }

	/**
	 * Prevents connections through the local client, allowing only connections through externally loaded client libraries.
	 */
	public void setDisableLocalClient() { setOption(64); }

	/**
	 * Spawns multiple worker threads for each version of the client that is loaded.  Setting this to a number greater than one implies disable_local_client.
	 * 
	 * @param value Number of client threads to be spawned.  Each cluster will be serviced by a single client thread.
	 */
	public void setClientThreadsPerVersion(long value) { setOption(65, value); }

	/**
	 * Adds an external client library to be used with a future version protocol. This option can be used testing purposes only!.
	 * 
	 * @param value path to client library
	 */
	public void setFutureVersionClientLibrary(String value) { setOption(66, value); }

	/**
	 * Retain temporary external client library copies that are created for enabling multi-threading.
	 */
	public void setRetainClientLibraryCopies() { setOption(67); }

	/**
	 * Ignore the failure to initialize some of the external clients.
	 */
	public void setIgnoreExternalClientFailures() { setOption(68); }

	/**
	 * Fail with an error if there is no client matching the server version the client is connecting to.
	 */
	public void setFailIncompatibleClient() { setOption(69); }

	/**
	 * Disables logging of client statistics, such as sampled transaction activity.
	 */
	public void setDisableClientStatisticsLogging() { setOption(70); }

	/**
	 * Deprecated.
	 */
	@Deprecated
	public void setEnableSlowTaskProfiling() { setOption(71); }

	/**
	 * Enables debugging feature to perform run loop profiling. Requires trace logging to be enabled. WARNING: this feature is not recommended for use in production.
	 */
	public void setEnableRunLoopProfiling() { setOption(71); }

	/**
	 * Prevents the multi-version client API from being disabled, even if no external clients are configured. This option is required to use GRV caching.
	 */
	public void setDisableClientBypass() { setOption(72); }

	/**
	 * Enable client buggify - will make requests randomly fail (intended for client testing).
	 */
	public void setClientBuggifyEnable() { setOption(80); }

	/**
	 * Disable client buggify.
	 */
	public void setClientBuggifyDisable() { setOption(81); }

	/**
	 * Set the probability of a CLIENT_BUGGIFY section being active for the current execution.
	 * 
	 * @param value probability expressed as a percentage between 0 and 100
	 */
	public void setClientBuggifySectionActivatedProbability(long value) { setOption(82, value); }

	/**
	 * Set the probability of an active CLIENT_BUGGIFY section being fired. A section will only fire if it was activated.
	 * 
	 * @param value probability expressed as a percentage between 0 and 100
	 */
	public void setClientBuggifySectionFiredProbability(long value) { setOption(83, value); }

	/**
	 * Set a tracer to run on the client. Should be set to the same value as the tracer set on the server.
	 * 
	 * @param value Distributed tracer type. Choose from none, log_file, or network_lossy
	 */
	public void setDistributedClientTracer(String value) { setOption(90, value); }

	/**
	 * Sets the directory for storing temporary files created by FDB client, such as temporary copies of client libraries. Defaults to /tmp.
	 * 
	 * @param value Client directory for temporary files.
	 */
	public void setClientTmpDir(String value) { setOption(91, value); }

	public void setBuggifyEnable() { setOption(48); }

	public void setBuggifyDisable() { setOption(49); }
}
