/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.tuple;

import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.Versionstamp;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class TupleComparisonTest {
    static List<Tuple> comparisons = Arrays.asList(Tuple.from((Object[])new Object[]{0L}), Tuple.from((Object[])new Object[]{BigInteger.ZERO}), Tuple.from((Object[])new Object[]{1L}), Tuple.from((Object[])new Object[]{BigInteger.ONE}), Tuple.from((Object[])new Object[]{-1L}), Tuple.from((Object[])new Object[]{BigInteger.ONE.negate()}), Tuple.from((Object[])new Object[]{Long.MAX_VALUE}), Tuple.from((Object[])new Object[]{Long.MIN_VALUE}), Tuple.from((Object[])new Object[]{BigInteger.valueOf(Long.MIN_VALUE).subtract(BigInteger.ONE)}), Tuple.from((Object[])new Object[]{BigInteger.valueOf(Long.MIN_VALUE).shiftLeft(1)}), Tuple.from((Object[])new Object[]{Float.valueOf(-0.0f)}), Tuple.from((Object[])new Object[]{Float.valueOf(0.0f)}), Tuple.from((Object[])new Object[]{-0.0}), Tuple.from((Object[])new Object[]{0.0}), Tuple.from((Object[])new Object[]{Float.valueOf(Float.NEGATIVE_INFINITY)}), Tuple.from((Object[])new Object[]{Double.NEGATIVE_INFINITY}), Tuple.from((Object[])new Object[]{Float.valueOf(Float.NaN)}), Tuple.from((Object[])new Object[]{Double.NaN}), Tuple.from((Object[])new Object[]{Float.valueOf(Float.intBitsToFloat(Float.floatToIntBits(Float.NaN) + 1))}), Tuple.from((Object[])new Object[]{Double.longBitsToDouble(Double.doubleToLongBits(Double.NaN) + 1L)}), Tuple.from((Object[])new Object[]{Float.valueOf(Float.intBitsToFloat(Float.floatToIntBits(Float.NaN) + 2))}), Tuple.from((Object[])new Object[]{Double.longBitsToDouble(Double.doubleToLongBits(Double.NaN) + 2L)}), Tuple.from((Object[])new Object[]{Float.valueOf(Float.intBitsToFloat(Float.floatToIntBits(Float.NaN) ^ Integer.MIN_VALUE))}), Tuple.from((Object[])new Object[]{Double.longBitsToDouble(Double.doubleToLongBits(Double.NaN) ^ Long.MIN_VALUE)}), Tuple.from((Object[])new Object[]{Float.valueOf(Float.intBitsToFloat(Float.floatToIntBits(Float.NaN) ^ 0x80000001))}), Tuple.from((Object[])new Object[]{Double.longBitsToDouble(Double.doubleToLongBits(Double.NaN) ^ 0x8000000000000001L)}), Tuple.from((Object[])new Object[]{Float.valueOf(Float.POSITIVE_INFINITY)}), Tuple.from((Object[])new Object[]{Double.POSITIVE_INFINITY}), Tuple.from((Object[])new Object[]{new byte[0]}), Tuple.from((Object[])new Object[]{new byte[]{0}}), Tuple.from((Object[])new Object[]{new byte[]{0, -1}}), Tuple.from((Object[])new Object[]{new byte[]{127}}), Tuple.from((Object[])new Object[]{new byte[]{-128}}), Tuple.from((Object[])new Object[]{null, new byte[0]}), Tuple.from((Object[])new Object[]{null, new byte[]{0}}), Tuple.from((Object[])new Object[]{null, new byte[]{0, -1}}), Tuple.from((Object[])new Object[]{null, new byte[]{127}}), Tuple.from((Object[])new Object[]{null, new byte[]{-128}}), Tuple.from((Object[])new Object[]{Tuple.from((Object[])new Object[]{null, new byte[0]})}), Tuple.from((Object[])new Object[]{Tuple.from((Object[])new Object[]{null, new byte[]{0}})}), Tuple.from((Object[])new Object[]{Tuple.from((Object[])new Object[]{null, new byte[]{0, -1}})}), Tuple.from((Object[])new Object[]{Tuple.from((Object[])new Object[]{null, new byte[]{127}})}), Tuple.from((Object[])new Object[]{Tuple.from((Object[])new Object[]{null, new byte[]{-128}})}), Tuple.from((Object[])new Object[]{"a"}), Tuple.from((Object[])new Object[]{"\u03bc\u03ac\u03b8\u03b7\u03bc\u03b1"}), Tuple.from((Object[])new Object[]{"\u03bc\u03b1\u0301\u03b8\u03b7\u03bc\u03b1"}), Tuple.from((Object[])new Object[]{"\u4e2d\u6587"}), Tuple.from((Object[])new Object[]{"\u4e2d\u570b"}), Tuple.from((Object[])new Object[]{"\ud83d\udd25"}), Tuple.from((Object[])new Object[]{"\ud83e\udd6f"}), Tuple.from((Object[])new Object[]{"a\ud83d\udd25"}), Tuple.from((Object[])new Object[]{"\ufb49"}), Tuple.from((Object[])new Object[]{"\ud83d\udd25\ufb49"}), Tuple.from((Object[])new Object[]{new UUID(-1L, 0L)}), Tuple.from((Object[])new Object[]{new UUID(-1L, -1L)}), Tuple.from((Object[])new Object[]{new UUID(1L, -1L)}), Tuple.from((Object[])new Object[]{new UUID(1L, 1L)}), Tuple.from((Object[])new Object[]{false}), Tuple.from((Object[])new Object[]{true}), Tuple.from((Object[])new Object[]{Arrays.asList(0, 1, 2)}), Tuple.from((Object[])new Object[]{Arrays.asList(0, 1), "hello"}), Tuple.from((Object[])new Object[]{Arrays.asList(0, 1), "help"}), Tuple.from((Object[])new Object[]{Versionstamp.complete((byte[])new byte[]{10, -69, -52, -35, -18, -1, 0, 1, 2, 3})}), Tuple.from((Object[])new Object[]{Versionstamp.complete((byte[])new byte[]{-86, -69, -52, -35, -18, -1, 0, 1, 2, 3})}), Tuple.from((Object[])new Object[]{Versionstamp.complete((byte[])new byte[]{-86, -69, -52, -35, -18, -1, 0, 1, 2, 3}, (int)1)}), Tuple.from((Object[])new Object[]{Versionstamp.complete((byte[])new byte[]{-86, -69, -52, -35, -18, -1, 0, 1, 2, 3}, (int)41217)}), Tuple.from((Object[])new Object[]{Versionstamp.complete((byte[])new byte[]{-86, -69, -52, -35, -18, -1, 0, 1, 2, 3}, (int)65535)}));

    TupleComparisonTest() {
    }

    static Stream<Arguments> cartesianProvider() {
        ArrayList<Arguments> arrayList = new ArrayList<Arguments>(comparisons.size() * comparisons.size());
        for (Tuple tuple : comparisons) {
            for (Tuple tuple2 : comparisons) {
                arrayList.add(Arguments.of((Object[])new Object[]{tuple, tuple2}));
            }
        }
        return arrayList.stream();
    }

    @ParameterizedTest
    @MethodSource(value={"cartesianProvider"})
    void testCanCompare(Tuple tuple, Tuple tuple2) {
        Tuple tuple3 = Tuple.fromList((List)tuple.getItems());
        Tuple tuple4 = Tuple.fromList((List)tuple2.getItems());
        int n = tuple3.compareTo(tuple4);
        int n2 = ByteArrayUtil.compareUnsigned((byte[])tuple.pack(), (byte[])tuple2.pack());
        String string = String.format("tuple l and r comparisons mismatched; semantic: <%d>,byte: <%d>", n, n2);
        Assertions.assertEquals((int)Integer.signum(n), (int)Integer.signum(n2), (String)string);
        int n3 = tuple.compareTo(tuple2);
        Assertions.assertEquals((int)Integer.signum(n), (int)Integer.signum(n3), (String)string);
    }
}

