#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
/*
 * DDMetrics.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/Status.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct DDMetricsWorkload : TestWorkload {
	static constexpr auto NAME = "DDMetrics";
	double startDelay, ddDone;

	DDMetricsWorkload(WorkloadContext const& wcx) : TestWorkload(wcx), ddDone(0.0) {
		startDelay = getOption(options, "beginPoll"_sr, 10.0);
	}

																#line 39 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
// This generated class is to be used only via getHighPriorityRelocationsInFlight()
															#line 37 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
template <class GetHighPriorityRelocationsInFlightActor>
															#line 37 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
class GetHighPriorityRelocationsInFlightActorState {
															#line 45 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
public:
															#line 37 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
	GetHighPriorityRelocationsInFlightActorState(Database const& cx,DDMetricsWorkload* const& self) 
															#line 37 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
															#line 37 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		 : cx(cx),
															#line 37 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		   self(self)
															#line 54 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
	{
		fdb_probe_actor_create("getHighPriorityRelocationsInFlight", reinterpret_cast<unsigned long>(this));

	}
	~GetHighPriorityRelocationsInFlightActorState() 
	{
		fdb_probe_actor_destroy("getHighPriorityRelocationsInFlight", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 38 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
			StrictFuture<WorkerInterface> __when_expr_0 = getMasterWorker(cx, self->dbInfo);
															#line 38 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
			if (static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 71 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->actor_wait_state = 1;
															#line 38 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetHighPriorityRelocationsInFlightActor, 0, WorkerInterface >*>(static_cast<GetHighPriorityRelocationsInFlightActor*>(this)));
															#line 76 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetHighPriorityRelocationsInFlightActorState();
		static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(WorkerInterface const& masterWorker,int loopDepth) 
	{
															#line 40 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		TraceEvent("GetHighPriorityReliocationsInFlight").detail("Stage", "ContactingMaster");
															#line 41 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		StrictFuture<TraceEventFields> __when_expr_1 = timeoutError(masterWorker.eventLogRequest.getReply(EventLogRequest("MovingData"_sr)), 1.0);
															#line 41 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		if (static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 103 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->actor_wait_state = 2;
															#line 41 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetHighPriorityRelocationsInFlightActor, 1, TraceEventFields >*>(static_cast<GetHighPriorityRelocationsInFlightActor*>(this)));
															#line 108 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(WorkerInterface && masterWorker,int loopDepth) 
	{
															#line 40 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		TraceEvent("GetHighPriorityReliocationsInFlight").detail("Stage", "ContactingMaster");
															#line 41 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		StrictFuture<TraceEventFields> __when_expr_1 = timeoutError(masterWorker.eventLogRequest.getReply(EventLogRequest("MovingData"_sr)), 1.0);
															#line 41 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		if (static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 121 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->actor_wait_state = 2;
															#line 41 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetHighPriorityRelocationsInFlightActor, 1, TraceEventFields >*>(static_cast<GetHighPriorityRelocationsInFlightActor*>(this)));
															#line 126 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(WorkerInterface const& masterWorker,int loopDepth) 
	{
		loopDepth = a_body1cont1(masterWorker, loopDepth);

		return loopDepth;
	}
	int a_body1when1(WorkerInterface && masterWorker,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(masterWorker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->actor_wait_state > 0) static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->actor_wait_state = 0;
		static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->ActorCallback< GetHighPriorityRelocationsInFlightActor, 0, WorkerInterface >::remove();

	}
	void a_callback_fire(ActorCallback< GetHighPriorityRelocationsInFlightActor, 0, WorkerInterface >*,WorkerInterface const& value) 
	{
		fdb_probe_actor_enter("getHighPriorityRelocationsInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getHighPriorityRelocationsInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetHighPriorityRelocationsInFlightActor, 0, WorkerInterface >*,WorkerInterface && value) 
	{
		fdb_probe_actor_enter("getHighPriorityRelocationsInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getHighPriorityRelocationsInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetHighPriorityRelocationsInFlightActor, 0, WorkerInterface >*,Error err) 
	{
		fdb_probe_actor_enter("getHighPriorityRelocationsInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getHighPriorityRelocationsInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(TraceEventFields const& md,int loopDepth) 
	{
															#line 43 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		int relocations;
															#line 44 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		sscanf(md.getValue("UnhealthyRelocations").c_str(), "%d", &relocations);
															#line 45 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		if (!static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->SAV<int>::futures) { (void)(relocations); this->~GetHighPriorityRelocationsInFlightActorState(); static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->destroy(); return 0; }
															#line 214 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		new (&static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->SAV< int >::value()) int(relocations);
		this->~GetHighPriorityRelocationsInFlightActorState();
		static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields && md,int loopDepth) 
	{
															#line 43 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		int relocations;
															#line 44 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		sscanf(md.getValue("UnhealthyRelocations").c_str(), "%d", &relocations);
															#line 45 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		if (!static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->SAV<int>::futures) { (void)(relocations); this->~GetHighPriorityRelocationsInFlightActorState(); static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->destroy(); return 0; }
															#line 230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		new (&static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->SAV< int >::value()) int(relocations);
		this->~GetHighPriorityRelocationsInFlightActorState();
		static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(TraceEventFields const& md,int loopDepth) 
	{
		loopDepth = a_body1cont2(md, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(TraceEventFields && md,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(md), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->actor_wait_state > 0) static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->actor_wait_state = 0;
		static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->ActorCallback< GetHighPriorityRelocationsInFlightActor, 1, TraceEventFields >::remove();

	}
	void a_callback_fire(ActorCallback< GetHighPriorityRelocationsInFlightActor, 1, TraceEventFields >*,TraceEventFields const& value) 
	{
		fdb_probe_actor_enter("getHighPriorityRelocationsInFlight", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getHighPriorityRelocationsInFlight", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetHighPriorityRelocationsInFlightActor, 1, TraceEventFields >*,TraceEventFields && value) 
	{
		fdb_probe_actor_enter("getHighPriorityRelocationsInFlight", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getHighPriorityRelocationsInFlight", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetHighPriorityRelocationsInFlightActor, 1, TraceEventFields >*,Error err) 
	{
		fdb_probe_actor_enter("getHighPriorityRelocationsInFlight", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getHighPriorityRelocationsInFlight", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 37 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
	Database cx;
															#line 37 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
	DDMetricsWorkload* self;
															#line 317 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
};
// This generated class is to be used only via getHighPriorityRelocationsInFlight()
															#line 37 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
class GetHighPriorityRelocationsInFlightActor final : public Actor<int>, public ActorCallback< GetHighPriorityRelocationsInFlightActor, 0, WorkerInterface >, public ActorCallback< GetHighPriorityRelocationsInFlightActor, 1, TraceEventFields >, public FastAllocated<GetHighPriorityRelocationsInFlightActor>, public GetHighPriorityRelocationsInFlightActorState<GetHighPriorityRelocationsInFlightActor> {
															#line 322 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
public:
	using FastAllocated<GetHighPriorityRelocationsInFlightActor>::operator new;
	using FastAllocated<GetHighPriorityRelocationsInFlightActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18058800066329503232UL, 760858444507219200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetHighPriorityRelocationsInFlightActor, 0, WorkerInterface >;
friend struct ActorCallback< GetHighPriorityRelocationsInFlightActor, 1, TraceEventFields >;
															#line 37 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
	GetHighPriorityRelocationsInFlightActor(Database const& cx,DDMetricsWorkload* const& self) 
															#line 340 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		 : Actor<int>(),
		   GetHighPriorityRelocationsInFlightActorState<GetHighPriorityRelocationsInFlightActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getHighPriorityRelocationsInFlight", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7139272502748929024UL, 8487774916447720448UL);
		ActorExecutionContextHelper __helper(static_cast<GetHighPriorityRelocationsInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getHighPriorityRelocationsInFlight");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getHighPriorityRelocationsInFlight", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetHighPriorityRelocationsInFlightActor, 0, WorkerInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetHighPriorityRelocationsInFlightActor, 1, TraceEventFields >*)0, actor_cancelled()); break;
		}

	}
};
															#line 37 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
[[nodiscard]] Future<int> getHighPriorityRelocationsInFlight( Database const& cx, DDMetricsWorkload* const& self ) {
															#line 37 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
	return Future<int>(new GetHighPriorityRelocationsInFlightActor(cx, self));
															#line 373 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
}

#line 47 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"

																#line 378 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
// This generated class is to be used only via work()
															#line 48 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
template <class WorkActor>
															#line 48 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
class WorkActorState {
															#line 384 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
public:
															#line 48 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
	WorkActorState(Database const& cx,DDMetricsWorkload* const& self) 
															#line 48 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
															#line 48 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		 : cx(cx),
															#line 48 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		   self(self)
															#line 393 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
	{
		fdb_probe_actor_create("work", reinterpret_cast<unsigned long>(this));

	}
	~WorkActorState() 
	{
		fdb_probe_actor_destroy("work", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 50 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
				TraceEvent("DDMetricsWaiting").detail("StartDelay", self->startDelay);
															#line 51 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(self->startDelay);
															#line 51 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
				if (static_cast<WorkActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 413 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WorkActor*>(this)->actor_wait_state = 1;
															#line 51 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkActor, 0, Void >*>(static_cast<WorkActor*>(this)));
															#line 418 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkActorState();
		static_cast<WorkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 66 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		if (!static_cast<WorkActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkActorState(); static_cast<WorkActor*>(this)->destroy(); return 0; }
															#line 447 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		new (&static_cast<WorkActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkActorState();
		static_cast<WorkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 64 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
			TraceEvent("DDMetricsError").error(e);
															#line 460 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 52 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		TraceEvent("DDMetricsStarting").log();
															#line 53 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		startTime = now();
															#line 54 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		;
															#line 479 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 52 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		TraceEvent("DDMetricsStarting").log();
															#line 53 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		startTime = now();
															#line 54 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		;
															#line 492 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkActor*>(this)->actor_wait_state > 0) static_cast<WorkActor*>(this)->actor_wait_state = 0;
		static_cast<WorkActor*>(this)->ActorCallback< WorkActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("work", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("work", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("work", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("work", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("work", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("work", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 55 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(2.5);
															#line 55 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		if (static_cast<WorkActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 585 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WorkActor*>(this)->actor_wait_state = 2;
															#line 55 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkActor, 1, Void >*>(static_cast<WorkActor*>(this)));
															#line 590 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 56 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		StrictFuture<int> __when_expr_2 = self->getHighPriorityRelocationsInFlight(cx, self);
															#line 56 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		if (static_cast<WorkActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 601 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WorkActor*>(this)->actor_wait_state = 3;
															#line 56 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkActor, 2, int >*>(static_cast<WorkActor*>(this)));
															#line 606 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 56 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		StrictFuture<int> __when_expr_2 = self->getHighPriorityRelocationsInFlight(cx, self);
															#line 56 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		if (static_cast<WorkActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 617 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WorkActor*>(this)->actor_wait_state = 3;
															#line 56 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkActor, 2, int >*>(static_cast<WorkActor*>(this)));
															#line 622 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkActor*>(this)->actor_wait_state > 0) static_cast<WorkActor*>(this)->actor_wait_state = 0;
		static_cast<WorkActor*>(this)->ActorCallback< WorkActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("work", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("work", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("work", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("work", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("work", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("work", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1cont2(int const& dif,int loopDepth) 
	{
															#line 57 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		TraceEvent("DDMetricsCheck").detail("DIF", dif);
															#line 58 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		if (dif == 0)
															#line 708 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		{
															#line 59 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
			self->ddDone = now() - startTime;
															#line 60 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
			if (!static_cast<WorkActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkActorState(); static_cast<WorkActor*>(this)->destroy(); return 0; }
															#line 714 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
			new (&static_cast<WorkActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WorkActorState();
			static_cast<WorkActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(int && dif,int loopDepth) 
	{
															#line 57 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		TraceEvent("DDMetricsCheck").detail("DIF", dif);
															#line 58 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
		if (dif == 0)
															#line 730 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		{
															#line 59 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
			self->ddDone = now() - startTime;
															#line 60 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
			if (!static_cast<WorkActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkActorState(); static_cast<WorkActor*>(this)->destroy(); return 0; }
															#line 736 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
			new (&static_cast<WorkActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WorkActorState();
			static_cast<WorkActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(int const& dif,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(dif, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(int && dif,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(dif), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WorkActor*>(this)->actor_wait_state > 0) static_cast<WorkActor*>(this)->actor_wait_state = 0;
		static_cast<WorkActor*>(this)->ActorCallback< WorkActor, 2, int >::remove();

	}
	void a_callback_fire(ActorCallback< WorkActor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("work", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("work", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WorkActor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("work", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("work", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WorkActor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("work", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("work", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 48 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
	Database cx;
															#line 48 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
	DDMetricsWorkload* self;
															#line 53 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
	double startTime;
															#line 827 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
};
// This generated class is to be used only via work()
															#line 48 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
class WorkActor final : public Actor<Void>, public ActorCallback< WorkActor, 0, Void >, public ActorCallback< WorkActor, 1, Void >, public ActorCallback< WorkActor, 2, int >, public FastAllocated<WorkActor>, public WorkActorState<WorkActor> {
															#line 832 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
public:
	using FastAllocated<WorkActor>::operator new;
	using FastAllocated<WorkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5578352907423182848UL, 9545446754908544512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkActor, 0, Void >;
friend struct ActorCallback< WorkActor, 1, Void >;
friend struct ActorCallback< WorkActor, 2, int >;
															#line 48 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
	WorkActor(Database const& cx,DDMetricsWorkload* const& self) 
															#line 851 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
		 : Actor<Void>(),
		   WorkActorState<WorkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("work", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9966828970801374464UL, 16048102293507540992UL);
		ActorExecutionContextHelper __helper(static_cast<WorkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("work");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("work", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WorkActor, 2, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 48 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
[[nodiscard]] Future<Void> work( Database const& cx, DDMetricsWorkload* const& self ) {
															#line 48 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"
	return Future<Void>(new WorkActor(cx, self));
															#line 885 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetrics.actor.g.cpp"
}

#line 68 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetrics.actor.cpp"

	Future<Void> start(Database const& cx) override { return clientId == 0 ? work(cx, this) : Void(); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override { m.emplace_back("DDDuration", ddDone, Averaged::False); }
};

WorkloadFactory<DDMetricsWorkload> DDMetricsWorkloadFactory;
