#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
/*
 * ConsistencyCheck.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <math.h>
#include "boost/lexical_cast.hpp"

#include "flow/IRandom.h"
#include "flow/ProcessEvents.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/FDBTypes.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/IRateControl.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/StorageMetrics.actor.h"
#include "fdbserver/DataDistribution.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbserver/TSSMappingUtil.actor.h"
#include "flow/DeterministicRandom.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/StorageServerInterface.h"
#include "flow/network.h"
#include "fdbrpc/SimulatorProcessInfo.h"

#include "flow/actorcompiler.h" // This must be the last #include.

// #define SevCCheckInfo SevVerbose
#define SevCCheckInfo SevInfo

struct ConsistencyCheckWorkload : TestWorkload {
	struct OnTimeout {
		ConsistencyCheckWorkload& self;
		explicit OnTimeout(ConsistencyCheckWorkload& self) : self(self) {}
		void operator()(StringRef name, std::any const& msg, Error const& e) {
			TraceEvent(SevError, "ConsistencyCheckFailure")
			    .error(e)
			    .detail("EventName", name)
			    .detail("EventMessage", std::any_cast<StringRef>(msg))
			    .log();
		}
	};

	static constexpr auto NAME = "ConsistencyCheck";
	// Whether or not we should perform checks that will only pass if the database is in a quiescent state
	bool performQuiescentChecks;

	// Whether or not to perform consistency check between storage servers and pair TSS
	bool performTSSCheck;

	// Maximum time Data Distributor can run before being considered stuck (for quiescent checks)
	double maxDDRunTime;

	// If true, then perform all checks on this client.  The first client is the only one to perform all of the fast
	// checks All other clients will perform slow checks if this test is distributed
	bool firstClient;

	// If true, then the expensive checks will be distributed to multiple clients
	bool distributed;

	// Determines how many shards are checked for consistency: out of every <shardSampleFactor> shards, 1 will be
	// checked
	int shardSampleFactor;

	// The previous data distribution mode
	int oldDataDistributionMode;

	// If true, then any failure of the consistency check will be logged as SevError.  Otherwise, it will be logged as
	// SevWarn
	bool failureIsError;

	// Max number of bytes per second to read from each storage server
	int rateLimitMax;

	// DataSet Size
	int64_t bytesReadInPreviousRound;

	// Randomize shard order with each iteration if true
	bool shuffleShards;

	bool success;

	// Number of times this client has run its portion of the consistency check
	int64_t repetitions;

	// Whether to continuously perform the consistency check
	bool indefinite;

	// Whether to suspendConsistencyCheck
	AsyncVar<bool> suspendConsistencyCheck;

	Future<Void> monitorConsistencyCheckSettingsActor;

	OnTimeout onTimeout;
	ProcessEvents::Event onTimeoutEvent;

	ConsistencyCheckWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), onTimeout(*this), onTimeoutEvent({ "Timeout"_sr, "TracedTooManyLines"_sr }, onTimeout) {
		performQuiescentChecks = getOption(options, "performQuiescentChecks"_sr, false);
		performTSSCheck = getOption(options, "performTSSCheck"_sr, true);
		maxDDRunTime = getOption(options, "maxDDRunTime"_sr, 600.0);
		distributed = getOption(options, "distributed"_sr, true);
		shardSampleFactor = std::max(getOption(options, "shardSampleFactor"_sr, 1), 1);
		failureIsError = getOption(options, "failureIsError"_sr, false);
		rateLimitMax = getOption(options, "rateLimitMax"_sr, 0);
		shuffleShards = getOption(options, "shuffleShards"_sr, false);
		indefinite = getOption(options, "indefinite"_sr, false);
		suspendConsistencyCheck.set(true);

		success = true;

		firstClient = clientId == 0;

		repetitions = 0;
		bytesReadInPreviousRound = 0;
	}

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }

																#line 139 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 137 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class _setupActor>
															#line 137 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class _setupActorState {
															#line 145 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 137 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	_setupActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 137 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 137 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 137 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 154 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 139 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (self->firstClient && self->performQuiescentChecks)
															#line 169 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 140 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (g_network->isSimulated())
															#line 173 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 141 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					StrictFuture<Void> __when_expr_0 = timeKeeperSetDisable(cx);
															#line 141 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 179 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 141 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 184 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 160 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		self->monitorConsistencyCheckSettingsActor = self->monitorConsistencyCheckSettings(cx, self);
															#line 161 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 219 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		try {
															#line 145 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_1 = timeoutError( quietDatabase( cx, self->dbInfo, "ConsistencyCheckStart", 0, 1e5, 0, 0, 30e6, 1e6, self->maxDDRunTime), self->maxDDRunTime);
															#line 145 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 234 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 145 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 239 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 154 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_QuietDatabaseError").error(e);
															#line 155 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Unable to achieve a quiet database");
															#line 156 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->performQuiescentChecks = false;
															#line 352 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 149 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (g_network->isSimulated())
															#line 367 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 150 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			g_simulator->quiesced = true;
															#line 151 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheckQuiesced").detail("Quiesced", g_simulator->quiesced);
															#line 373 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 149 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (g_network->isSimulated())
															#line 383 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 150 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			g_simulator->quiesced = true;
															#line 151 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheckQuiesced").detail("Quiesced", g_simulator->quiesced);
															#line 389 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 137 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 137 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 487 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 137 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 492 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6265047082308218112UL, 8481245167909191424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
															#line 137 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	_setupActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 510 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 137 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 137 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 543 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 163 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	Future<Void> start(Database const& cx) override {
		TraceEvent("ConsistencyCheck").log();
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override { return success; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	void testFailure(std::string message, bool isError = false) {
		success = false;

		TraceEvent failEvent((failureIsError || isError) ? SevError : SevWarn, "TestFailure");
		if (performQuiescentChecks)
			failEvent.detail("Workload", "QuiescentCheck");
		else
			failEvent.detail("Workload", "ConsistencyCheck");

		failEvent.detail("Reason", "Consistency check: " + message);
	}

																#line 569 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via monitorConsistencyCheckSettings()
															#line 185 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class MonitorConsistencyCheckSettingsActor>
															#line 185 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class MonitorConsistencyCheckSettingsActorState {
															#line 575 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 185 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	MonitorConsistencyCheckSettingsActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 185 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 185 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 185 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 584 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this));

	}
	~MonitorConsistencyCheckSettingsActorState() 
	{
		fdb_probe_actor_destroy("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			;
															#line 599 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorConsistencyCheckSettingsActorState();
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 187 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 629 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		try {
															#line 189 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 190 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 191 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 192 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(fdbShouldConsistencyCheckBeSuspended);
															#line 192 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 641 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 1;
															#line 192 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >*>(static_cast<MonitorConsistencyCheckSettingsActor*>(this)));
															#line 646 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 201 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 201 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 670 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 4;
															#line 201 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >*>(static_cast<MonitorConsistencyCheckSettingsActor*>(this)));
															#line 675 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 193 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		bool ccSuspend = ccSuspendVal.present() ? BinaryReader::fromStringRef<bool>(ccSuspendVal.get(), Unversioned()) : false;
															#line 196 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		self->suspendConsistencyCheck.set(ccSuspend);
															#line 197 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		watchCCSuspendFuture = tr.watch(fdbShouldConsistencyCheckBeSuspended);
															#line 198 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 198 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 698 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 2;
															#line 198 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >*>(static_cast<MonitorConsistencyCheckSettingsActor*>(this)));
															#line 703 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __ccSuspendVal,int loopDepth) 
	{
															#line 192 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ccSuspendVal = __ccSuspendVal;
															#line 712 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __ccSuspendVal,int loopDepth) 
	{
		ccSuspendVal = std::move(__ccSuspendVal);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state > 0) static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 199 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchCCSuspendFuture;
															#line 199 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 793 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 3;
															#line 199 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*>(static_cast<MonitorConsistencyCheckSettingsActor*>(this)));
															#line 798 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 199 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchCCSuspendFuture;
															#line 199 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 809 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 3;
															#line 199 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*>(static_cast<MonitorConsistencyCheckSettingsActor*>(this)));
															#line 814 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state > 0) static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state > 0) static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state > 0) static_cast<MonitorConsistencyCheckSettingsActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorConsistencyCheckSettingsActor*>(this)->ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 185 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 185 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 187 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 192 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Optional<Value> ccSuspendVal;
															#line 197 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Future<Void> watchCCSuspendFuture;
															#line 1091 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via monitorConsistencyCheckSettings()
															#line 185 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class MonitorConsistencyCheckSettingsActor final : public Actor<Void>, public ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >, public ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >, public ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >, public ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >, public FastAllocated<MonitorConsistencyCheckSettingsActor>, public MonitorConsistencyCheckSettingsActorState<MonitorConsistencyCheckSettingsActor> {
															#line 1096 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<MonitorConsistencyCheckSettingsActor>::operator new;
	using FastAllocated<MonitorConsistencyCheckSettingsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5789736706798208768UL, 8451234135377591552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >;
friend struct ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >;
friend struct ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >;
															#line 185 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	MonitorConsistencyCheckSettingsActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 1116 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorConsistencyCheckSettingsActorState<MonitorConsistencyCheckSettingsActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16598048751331225600UL, 3236326283404452096UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyCheckSettingsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorConsistencyCheckSettings");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorConsistencyCheckSettings", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorConsistencyCheckSettingsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorConsistencyCheckSettingsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorConsistencyCheckSettingsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorConsistencyCheckSettingsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 185 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<Void> monitorConsistencyCheckSettings( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 185 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<Void>(new MonitorConsistencyCheckSettingsActor(cx, self));
															#line 1151 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 205 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

																#line 1156 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 206 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class _startActor>
															#line 206 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class _startActorState {
															#line 1162 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 206 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	_startActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 206 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 206 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 206 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 1171 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 207 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			;
															#line 1186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 223 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (self->firstClient && g_network->isSimulated() && self->performQuiescentChecks)
															#line 1209 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 224 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			g_simulator->quiesced = false;
															#line 225 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheckQuiescedEnd").detail("Quiesced", g_simulator->quiesced);
															#line 1215 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 227 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1219 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 208 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		;
															#line 1238 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 212 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("ConsistencyCheck_StartingOrResuming").log();
															#line 214 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->runCheck(cx, self);
															#line 213 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1264 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 220 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->suspendConsistencyCheck.onChange();
															#line 1268 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 214 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 220 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1275 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 208 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!(self->suspendConsistencyCheck.get()))
															#line 1291 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 209 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("ConsistencyCheck_Suspended").log();
															#line 210 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->suspendConsistencyCheck.onChange();
															#line 210 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1301 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 210 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1306 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
															#line 215 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!self->indefinite)
															#line 1421 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 217 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		self->repetitions++;
															#line 218 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(5.0);
															#line 218 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1431 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 218 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1436 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
															#line 215 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!self->indefinite)
															#line 1445 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 217 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		self->repetitions++;
															#line 218 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(5.0);
															#line 218 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1455 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 218 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1460 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	int a_body1loopBody1cont1when1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 206 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 206 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 1689 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 206 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 2, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1694 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16819426792952580096UL, 13323796292178777344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
															#line 206 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	_startActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 1714 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 206 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 206 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1748 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 229 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

																#line 1753 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via runCheck()
															#line 230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class RunCheckActor>
															#line 230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class RunCheckActorState {
															#line 1759 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	RunCheckActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 1768 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("runCheck", reinterpret_cast<unsigned long>(this));

	}
	~RunCheckActorState() 
	{
		fdb_probe_actor_destroy("runCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 231 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			CODE_PROBE(self->performQuiescentChecks, "Quiescent consistency check");
															#line 232 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			CODE_PROBE(!self->performQuiescentChecks, "Non-quiescent consistency check");
															#line 233 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			consistenyCheckerBeginTime = now();
															#line 235 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (self->firstClient || self->distributed)
															#line 1789 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
				try {
															#line 237 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					configuration = DatabaseConfiguration();
															#line 238 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					tssMapping = std::map<UID, StorageServerInterface>();
															#line 240 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					tr = Transaction(cx);
															#line 241 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 242 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					;
															#line 1802 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					loopDepth = a_body1loopHead1(loopDepth);
				}
				catch (Error& error) {
					loopDepth = a_body1Catch2(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch2(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunCheckActorState();
		static_cast<RunCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 402 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent("ConsistencyCheck_FinishedCheck") .detail("Repetitions", self->repetitions) .detail("TimeSpan", now() - consistenyCheckerBeginTime);
															#line 406 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<RunCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCheckActorState(); static_cast<RunCheckActor*>(this)->destroy(); return 0; }
															#line 1838 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<RunCheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunCheckActorState();
		static_cast<RunCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 391 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (e.code() == error_code_transaction_too_old || e.code() == error_code_future_version || e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed || e.code() == error_code_process_behind || e.code() == error_code_actor_cancelled)
															#line 1857 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 394 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_Retry") .error(e);
															#line 1861 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
			else
			{
															#line 397 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				self->testFailure(format("Error %d - %s", e.code(), e.name()));
															#line 1867 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 262 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (self->firstClient && self->performQuiescentChecks)
															#line 1883 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 265 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<bool> __when_expr_3 = self->checkForUndesirableServers(cx, configuration, self);
															#line 265 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1889 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 4;
															#line 265 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 3, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 1894 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 244 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (self->performTSSCheck)
															#line 1916 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 245 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				tssMapping.clear();
															#line 246 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				StrictFuture<Void> __when_expr_0 = readTSSMapping(&tr, &tssMapping);
															#line 246 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1924 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunCheckActor*>(this)->actor_wait_state = 1;
															#line 246 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 0, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 1929 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 257 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 257 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1971 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 3;
															#line 257 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 2, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 1976 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 248 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(configKeys, 1000);
															#line 248 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1993 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 2;
															#line 248 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 1, RangeResult >*>(static_cast<RunCheckActor*>(this)));
															#line 1998 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(RangeResult const& res,int loopDepth) 
	{
															#line 249 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (res.size() == 1000)
															#line 2094 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 250 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_TooManyConfigOptions").log();
															#line 251 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Read too many configuration options");
															#line 2100 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < res.size();i++) {
															#line 254 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			configuration.set(res[i].key, res[i].value);
															#line 2106 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(RangeResult && res,int loopDepth) 
	{
															#line 249 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (res.size() == 1000)
															#line 2116 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 250 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_TooManyConfigOptions").log();
															#line 251 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Read too many configuration options");
															#line 2122 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < res.size();i++) {
															#line 254 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			configuration.set(res[i].key, res[i].value);
															#line 2128 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 349 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		keyServerPromise = Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>>();
															#line 350 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_15 = getKeyServers(cx, keyServerPromise, keyServersKeys, self->performQuiescentChecks, self->failureIsError, &self->success);
															#line 350 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2304 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch2(__when_expr_15.getError(), loopDepth); else return a_body1cont4when1(__when_expr_15.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 16;
															#line 350 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 15, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 2309 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 268 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<int64_t> __when_expr_4 = getDataDistributionQueueSize(cx, self->dbInfo, true);
															#line 268 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2320 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 5;
															#line 268 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 4, int64_t >*>(static_cast<RunCheckActor*>(this)));
															#line 2325 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(bool const& __hasUndesirableServers,int loopDepth) 
	{
															#line 265 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		hasUndesirableServers = __hasUndesirableServers;
															#line 2334 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(bool && __hasUndesirableServers,int loopDepth) 
	{
		hasUndesirableServers = std::move(__hasUndesirableServers);
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(int64_t const& inDataDistributionQueue,int loopDepth) 
	{
															#line 269 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (inDataDistributionQueue > 0)
															#line 2413 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 270 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NonZeroDataDistributionQueue") .detail("QueueSize", inDataDistributionQueue);
															#line 272 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Non-zero data distribution queue/in-flight size");
															#line 2419 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 277 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_5 = getTeamCollectionValid(cx, self->dbInfo);
															#line 277 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2425 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 6;
															#line 277 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 5, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 2430 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(int64_t && inDataDistributionQueue,int loopDepth) 
	{
															#line 269 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (inDataDistributionQueue > 0)
															#line 2439 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 270 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NonZeroDataDistributionQueue") .detail("QueueSize", inDataDistributionQueue);
															#line 272 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Non-zero data distribution queue/in-flight size");
															#line 2445 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 277 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_5 = getTeamCollectionValid(cx, self->dbInfo);
															#line 277 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2451 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 6;
															#line 277 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 5, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 2456 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(int64_t const& inDataDistributionQueue,int loopDepth) 
	{
		loopDepth = a_body1cont6(inDataDistributionQueue, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(int64_t && inDataDistributionQueue,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(inDataDistributionQueue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 4, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 4, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 4, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 4, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(bool const& teamCollectionValid,int loopDepth) 
	{
															#line 278 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!teamCollectionValid)
															#line 2540 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 279 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevError, "ConsistencyCheck_TooManyTeams").log();
															#line 280 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("The number of process or machine teams is larger than the allowed maximum " "number of teams");
															#line 2546 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 285 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::pair<int64_t, int64_t>> __when_expr_6 = getTLogQueueInfo(cx, self->dbInfo);
															#line 285 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2552 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 7;
															#line 285 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*>(static_cast<RunCheckActor*>(this)));
															#line 2557 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(bool && teamCollectionValid,int loopDepth) 
	{
															#line 278 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!teamCollectionValid)
															#line 2566 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 279 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevError, "ConsistencyCheck_TooManyTeams").log();
															#line 280 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("The number of process or machine teams is larger than the allowed maximum " "number of teams");
															#line 2572 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 285 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::pair<int64_t, int64_t>> __when_expr_6 = getTLogQueueInfo(cx, self->dbInfo);
															#line 285 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2578 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 7;
															#line 285 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*>(static_cast<RunCheckActor*>(this)));
															#line 2583 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(bool const& teamCollectionValid,int loopDepth) 
	{
		loopDepth = a_body1cont7(teamCollectionValid, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(bool && teamCollectionValid,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(teamCollectionValid), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(std::pair<int64_t, int64_t> const& maxTLogQueueInfo,int loopDepth) 
	{
															#line 286 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxTLogQueueInfo.first > 1e5)
															#line 2667 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 288 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NonZeroTLogQueue").detail("MaxQueueSize", maxTLogQueueInfo.first);
															#line 289 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Non-zero tlog queue size");
															#line 2673 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 292 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxTLogQueueInfo.second > 30e6)
															#line 2677 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 293 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_PoppedVersionLag") .detail("PoppedVersionLag", maxTLogQueueInfo.second);
															#line 295 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("large popped version lag");
															#line 2683 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		try {
															#line 300 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<int64_t> __when_expr_7 = getMaxStorageServerQueueSize(cx, self->dbInfo, invalidVersion);
															#line 300 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1cont9Catch1(actor_cancelled(), loopDepth);
															#line 2690 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont9Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 8;
															#line 300 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 7, int64_t >*>(static_cast<RunCheckActor*>(this)));
															#line 2695 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont9Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont9Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(std::pair<int64_t, int64_t> && maxTLogQueueInfo,int loopDepth) 
	{
															#line 286 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxTLogQueueInfo.first > 1e5)
															#line 2710 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 288 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NonZeroTLogQueue").detail("MaxQueueSize", maxTLogQueueInfo.first);
															#line 289 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Non-zero tlog queue size");
															#line 2716 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 292 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxTLogQueueInfo.second > 30e6)
															#line 2720 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 293 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_PoppedVersionLag") .detail("PoppedVersionLag", maxTLogQueueInfo.second);
															#line 295 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("large popped version lag");
															#line 2726 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		try {
															#line 300 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<int64_t> __when_expr_7 = getMaxStorageServerQueueSize(cx, self->dbInfo, invalidVersion);
															#line 300 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1cont9Catch1(actor_cancelled(), loopDepth);
															#line 2733 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont9Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 8;
															#line 300 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 7, int64_t >*>(static_cast<RunCheckActor*>(this)));
															#line 2738 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont9Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont9Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7when1(std::pair<int64_t, int64_t> const& maxTLogQueueInfo,int loopDepth) 
	{
		loopDepth = a_body1cont9(maxTLogQueueInfo, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(std::pair<int64_t, int64_t> && maxTLogQueueInfo,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(maxTLogQueueInfo), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*,std::pair<int64_t, int64_t> const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*,std::pair<int64_t, int64_t> && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 321 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_8 = ::success(self->checkForStorage(cx, configuration, tssMapping, self));
															#line 321 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2830 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch2(__when_expr_8.getError(), loopDepth); else return a_body1cont11when1(__when_expr_8.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 9;
															#line 321 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 8, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 2835 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 308 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (e.code() == error_code_attribute_not_found)
															#line 2845 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 309 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_StorageQueueSizeError") .error(e) .detail("Reason", "Could not read queue size");
															#line 315 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!hasUndesirableServers)
															#line 2851 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 316 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					self->testFailure("Could not read storage queue size");
															#line 2855 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
			}
			else
			{
															#line 318 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				return a_body1Catch2(e, loopDepth);
															#line 2862 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14(int64_t const& maxStorageServerQueueSize,int loopDepth) 
	{
															#line 302 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxStorageServerQueueSize > 0)
															#line 2878 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 303 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ExceedStorageServerQueueLimit") .detail("MaxQueueSize", maxStorageServerQueueSize);
															#line 305 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Storage server queue size exceeds limit");
															#line 2884 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont14cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(int64_t && maxStorageServerQueueSize,int loopDepth) 
	{
															#line 302 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (maxStorageServerQueueSize > 0)
															#line 2894 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 303 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ExceedStorageServerQueueLimit") .detail("MaxQueueSize", maxStorageServerQueueSize);
															#line 305 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Storage server queue size exceeds limit");
															#line 2900 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont14cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(int64_t const& maxStorageServerQueueSize,int loopDepth) 
	{
		loopDepth = a_body1cont14(maxStorageServerQueueSize, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(int64_t && maxStorageServerQueueSize,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(maxStorageServerQueueSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 7, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 7, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 7, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 7, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont14cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1(Void const& _,int loopDepth) 
	{
															#line 322 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_9 = ::success(self->checkForExtraDataStores(cx, self));
															#line 322 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3000 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch2(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 10;
															#line 322 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 9, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 3005 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1(Void && _,int loopDepth) 
	{
															#line 322 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_9 = ::success(self->checkForExtraDataStores(cx, self));
															#line 322 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3016 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch2(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 10;
															#line 322 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 9, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 3021 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont11cont2(Void const& _,int loopDepth) 
	{
															#line 323 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_10 = ::success(self->checkStorageMetadata(cx, self));
															#line 323 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3107 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch2(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_10.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 11;
															#line 323 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 10, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 3112 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont2(Void && _,int loopDepth) 
	{
															#line 323 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<Void> __when_expr_10 = ::success(self->checkStorageMetadata(cx, self));
															#line 323 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3123 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch2(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_10.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 11;
															#line 323 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 10, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 3128 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont11cont3(Void const& _,int loopDepth) 
	{
															#line 326 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_11 = self->checkUsingDesiredClasses(cx, self);
															#line 326 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3214 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch2(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont3when1(__when_expr_11.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 12;
															#line 326 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 11, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3219 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont3(Void && _,int loopDepth) 
	{
															#line 326 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_11 = self->checkUsingDesiredClasses(cx, self);
															#line 326 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch2(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont3when1(__when_expr_11.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 12;
															#line 326 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 11, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3235 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont11cont4(bool const& usingDesiredClasses,int loopDepth) 
	{
															#line 327 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!usingDesiredClasses)
															#line 3319 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 328 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Cluster has machine(s) not using requested classes");
															#line 3323 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 330 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_12 = self->checkWorkerList(cx, self);
															#line 330 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3329 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch2(__when_expr_12.getError(), loopDepth); else return a_body1cont11cont4when1(__when_expr_12.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 13;
															#line 330 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 12, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3334 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont4(bool && usingDesiredClasses,int loopDepth) 
	{
															#line 327 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!usingDesiredClasses)
															#line 3343 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 328 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Cluster has machine(s) not using requested classes");
															#line 3347 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 330 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_12 = self->checkWorkerList(cx, self);
															#line 330 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3353 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch2(__when_expr_12.getError(), loopDepth); else return a_body1cont11cont4when1(__when_expr_12.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 13;
															#line 330 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 12, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3358 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont3when1(bool const& usingDesiredClasses,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4(usingDesiredClasses, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont3when1(bool && usingDesiredClasses,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4(std::move(usingDesiredClasses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 11, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 11, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 11, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 11, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont11cont5(bool const& workerListCorrect,int loopDepth) 
	{
															#line 331 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!workerListCorrect)
															#line 3442 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 332 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Worker list incorrect");
															#line 3446 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 334 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_13 = self->checkCoordinators(cx);
															#line 334 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3452 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch2(__when_expr_13.getError(), loopDepth); else return a_body1cont11cont5when1(__when_expr_13.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 14;
															#line 334 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 13, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3457 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont5(bool && workerListCorrect,int loopDepth) 
	{
															#line 331 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!workerListCorrect)
															#line 3466 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 332 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Worker list incorrect");
															#line 3470 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 334 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_13 = self->checkCoordinators(cx);
															#line 334 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3476 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch2(__when_expr_13.getError(), loopDepth); else return a_body1cont11cont5when1(__when_expr_13.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 14;
															#line 334 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 13, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3481 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont4when1(bool const& workerListCorrect,int loopDepth) 
	{
		loopDepth = a_body1cont11cont5(workerListCorrect, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4when1(bool && workerListCorrect,int loopDepth) 
	{
		loopDepth = a_body1cont11cont5(std::move(workerListCorrect), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 12, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 12, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont11cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 12, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont11cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 12, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont11cont7(bool const& coordinatorsCorrect,int loopDepth) 
	{
															#line 335 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!coordinatorsCorrect)
															#line 3565 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 336 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Coordinators incorrect");
															#line 3569 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 338 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_14 = self->checkConsistencyScan(cx);
															#line 338 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3575 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch2(__when_expr_14.getError(), loopDepth); else return a_body1cont11cont7when1(__when_expr_14.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 15;
															#line 338 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 14, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3580 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont7(bool && coordinatorsCorrect,int loopDepth) 
	{
															#line 335 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!coordinatorsCorrect)
															#line 3589 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 336 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Coordinators incorrect");
															#line 3593 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 338 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<bool> __when_expr_14 = self->checkConsistencyScan(cx);
															#line 338 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3599 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch2(__when_expr_14.getError(), loopDepth); else return a_body1cont11cont7when1(__when_expr_14.get(), loopDepth); };
		static_cast<RunCheckActor*>(this)->actor_wait_state = 15;
															#line 338 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 14, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3604 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont5when1(bool const& coordinatorsCorrect,int loopDepth) 
	{
		loopDepth = a_body1cont11cont7(coordinatorsCorrect, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont5when1(bool && coordinatorsCorrect,int loopDepth) 
	{
		loopDepth = a_body1cont11cont7(std::move(coordinatorsCorrect), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 13, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 13, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont11cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 13, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont11cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 13, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont11cont9(bool const& consistencyScanStopped,int loopDepth) 
	{
															#line 339 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!consistencyScanStopped)
															#line 3688 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 340 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Consistency scan active");
															#line 3692 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont9(bool && consistencyScanStopped,int loopDepth) 
	{
															#line 339 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!consistencyScanStopped)
															#line 3702 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 340 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Consistency scan active");
															#line 3706 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont7when1(bool const& consistencyScanStopped,int loopDepth) 
	{
		loopDepth = a_body1cont11cont9(consistencyScanStopped, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont7when1(bool && consistencyScanStopped,int loopDepth) 
	{
		loopDepth = a_body1cont11cont9(std::move(consistencyScanStopped), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 14, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 14, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont11cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 14, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont11cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 14, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont15(bool const& keyServerResult,int loopDepth) 
	{
															#line 356 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (keyServerResult)
															#line 3791 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 357 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyServers = keyServerPromise.getFuture().get();
															#line 361 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyLocationPromise = Promise<Standalone<VectorRef<KeyValueRef>>>();
															#line 362 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<bool> __when_expr_16 = getKeyLocations( cx, keyServers, keyLocationPromise, self->performQuiescentChecks, &self->success);
															#line 362 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3801 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch2(__when_expr_16.getError(), loopDepth); else return a_body1cont15when1(__when_expr_16.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 17;
															#line 362 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 16, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3806 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15(bool && keyServerResult,int loopDepth) 
	{
															#line 356 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (keyServerResult)
															#line 3820 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 357 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyServers = keyServerPromise.getFuture().get();
															#line 361 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyLocationPromise = Promise<Standalone<VectorRef<KeyValueRef>>>();
															#line 362 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<bool> __when_expr_16 = getKeyLocations( cx, keyServers, keyLocationPromise, self->performQuiescentChecks, &self->success);
															#line 362 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3830 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch2(__when_expr_16.getError(), loopDepth); else return a_body1cont15when1(__when_expr_16.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 17;
															#line 362 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 16, bool >*>(static_cast<RunCheckActor*>(this)));
															#line 3835 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4when1(bool const& keyServerResult,int loopDepth) 
	{
		loopDepth = a_body1cont15(keyServerResult, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(bool && keyServerResult,int loopDepth) 
	{
		loopDepth = a_body1cont15(std::move(keyServerResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 15, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 15, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 15, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 15, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont15cont1(int loopDepth) 
	{
		loopDepth = a_body1cont15cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2(bool const& keyLocationResult,int loopDepth) 
	{
															#line 364 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (keyLocationResult)
															#line 3930 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 365 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyLocations = keyLocationPromise.getFuture().get();
															#line 368 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_17 = checkDataConsistency(cx, keyLocations, configuration, tssMapping, self->performQuiescentChecks, self->performTSSCheck, self->firstClient, self->failureIsError, self->clientId, self->clientCount, self->distributed, self->shuffleShards, self->shardSampleFactor, self->sharedRandomNumber, self->repetitions, &(self->bytesReadInPreviousRound), true, self->rateLimitMax, CLIENT_KNOBS->CONSISTENCY_CHECK_ONE_ROUND_TARGET_COMPLETION_TIME, &self->success);
															#line 368 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3938 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch2(__when_expr_17.getError(), loopDepth); else return a_body1cont15cont2when1(__when_expr_17.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 18;
															#line 368 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 17, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 3943 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15cont2(bool && keyLocationResult,int loopDepth) 
	{
															#line 364 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (keyLocationResult)
															#line 3957 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 365 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			keyLocations = keyLocationPromise.getFuture().get();
															#line 368 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_17 = checkDataConsistency(cx, keyLocations, configuration, tssMapping, self->performQuiescentChecks, self->performTSSCheck, self->firstClient, self->failureIsError, self->clientId, self->clientCount, self->distributed, self->shuffleShards, self->shardSampleFactor, self->sharedRandomNumber, self->repetitions, &(self->bytesReadInPreviousRound), true, self->rateLimitMax, CLIENT_KNOBS->CONSISTENCY_CHECK_ONE_ROUND_TARGET_COMPLETION_TIME, &self->success);
															#line 368 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<RunCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3965 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch2(__when_expr_17.getError(), loopDepth); else return a_body1cont15cont2when1(__when_expr_17.get(), loopDepth); };
			static_cast<RunCheckActor*>(this)->actor_wait_state = 18;
															#line 368 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< RunCheckActor, 17, Void >*>(static_cast<RunCheckActor*>(this)));
															#line 3970 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15when1(bool const& keyLocationResult,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2(keyLocationResult, loopDepth);

		return loopDepth;
	}
	int a_body1cont15when1(bool && keyLocationResult,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2(std::move(keyLocationResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 16, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 16, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont15when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 16, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont15when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 16, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont15cont3(int loopDepth) 
	{
		loopDepth = a_body1cont15cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<RunCheckActor*>(this)->actor_wait_state > 0) static_cast<RunCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RunCheckActor*>(this)->ActorCallback< RunCheckActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont15cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< RunCheckActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont15cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< RunCheckActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont15cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 233 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	double consistenyCheckerBeginTime;
															#line 237 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	DatabaseConfiguration configuration;
															#line 238 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 240 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Transaction tr;
															#line 265 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	bool hasUndesirableServers;
															#line 349 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> keyServerPromise;
															#line 357 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> keyServers;
															#line 361 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Promise<Standalone<VectorRef<KeyValueRef>>> keyLocationPromise;
															#line 365 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> keyLocations;
															#line 4183 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via runCheck()
															#line 230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class RunCheckActor final : public Actor<Void>, public ActorCallback< RunCheckActor, 0, Void >, public ActorCallback< RunCheckActor, 1, RangeResult >, public ActorCallback< RunCheckActor, 2, Void >, public ActorCallback< RunCheckActor, 3, bool >, public ActorCallback< RunCheckActor, 4, int64_t >, public ActorCallback< RunCheckActor, 5, bool >, public ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >, public ActorCallback< RunCheckActor, 7, int64_t >, public ActorCallback< RunCheckActor, 8, Void >, public ActorCallback< RunCheckActor, 9, Void >, public ActorCallback< RunCheckActor, 10, Void >, public ActorCallback< RunCheckActor, 11, bool >, public ActorCallback< RunCheckActor, 12, bool >, public ActorCallback< RunCheckActor, 13, bool >, public ActorCallback< RunCheckActor, 14, bool >, public ActorCallback< RunCheckActor, 15, bool >, public ActorCallback< RunCheckActor, 16, bool >, public ActorCallback< RunCheckActor, 17, Void >, public FastAllocated<RunCheckActor>, public RunCheckActorState<RunCheckActor> {
															#line 4188 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<RunCheckActor>::operator new;
	using FastAllocated<RunCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2818605834032716288UL, 521848059617632256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunCheckActor, 0, Void >;
friend struct ActorCallback< RunCheckActor, 1, RangeResult >;
friend struct ActorCallback< RunCheckActor, 2, Void >;
friend struct ActorCallback< RunCheckActor, 3, bool >;
friend struct ActorCallback< RunCheckActor, 4, int64_t >;
friend struct ActorCallback< RunCheckActor, 5, bool >;
friend struct ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >;
friend struct ActorCallback< RunCheckActor, 7, int64_t >;
friend struct ActorCallback< RunCheckActor, 8, Void >;
friend struct ActorCallback< RunCheckActor, 9, Void >;
friend struct ActorCallback< RunCheckActor, 10, Void >;
friend struct ActorCallback< RunCheckActor, 11, bool >;
friend struct ActorCallback< RunCheckActor, 12, bool >;
friend struct ActorCallback< RunCheckActor, 13, bool >;
friend struct ActorCallback< RunCheckActor, 14, bool >;
friend struct ActorCallback< RunCheckActor, 15, bool >;
friend struct ActorCallback< RunCheckActor, 16, bool >;
friend struct ActorCallback< RunCheckActor, 17, Void >;
															#line 230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	RunCheckActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 4222 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<Void>(),
		   RunCheckActorState<RunCheckActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15195670578295965440UL, 8790465732451613440UL);
		ActorExecutionContextHelper __helper(static_cast<RunCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunCheckActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunCheckActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunCheckActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunCheckActor, 3, bool >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunCheckActor, 4, int64_t >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RunCheckActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RunCheckActor, 6, std::pair<int64_t, int64_t> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< RunCheckActor, 7, int64_t >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< RunCheckActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< RunCheckActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< RunCheckActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< RunCheckActor, 11, bool >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< RunCheckActor, 12, bool >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< RunCheckActor, 13, bool >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< RunCheckActor, 14, bool >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< RunCheckActor, 15, bool >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< RunCheckActor, 16, bool >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< RunCheckActor, 17, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<Void> runCheck( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<Void>(new RunCheckActor(cx, self));
															#line 4271 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 408 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Comparison function used to compare map elements by value
	template <class K, class T>
	static bool compareByValue(std::pair<K, T> a, std::pair<K, T> b) {
		return a.second < b.second;
	}

	// Returns true if any storage servers have the exact same network address or are not using the correct key value
	// store type
																#line 4284 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkForUndesirableServers()
															#line 417 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckForUndesirableServersActor>
															#line 417 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForUndesirableServersActorState {
															#line 4290 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 417 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForUndesirableServersActorState(Database const& cx,DatabaseConfiguration const& configuration,ConsistencyCheckWorkload* const& self) 
															#line 417 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 417 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 417 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   configuration(configuration),
															#line 417 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self),
															#line 420 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   i(),
															#line 421 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   j()
															#line 4305 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkForUndesirableServers", reinterpret_cast<unsigned long>(this));

	}
	~CheckForUndesirableServersActorState() 
	{
		fdb_probe_actor_destroy("checkForUndesirableServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 422 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<std::vector<StorageServerInterface>> __when_expr_0 = getStorageServers(cx);
															#line 422 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4322 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state = 1;
															#line 422 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >*>(static_cast<CheckForUndesirableServersActor*>(this)));
															#line 4327 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckForUndesirableServersActorState();
		static_cast<CheckForUndesirableServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 423 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		wiggleLocalityKeyValue = configuration.perpetualStorageWiggleLocality;
															#line 424 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		wiggleLocalityKeyValues = ParsePerpetualStorageWiggleLocality(configuration.perpetualStorageWiggleLocality);
															#line 428 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i = 0;
															#line 4354 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> const& __storageServers,int loopDepth) 
	{
															#line 422 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		storageServers = __storageServers;
															#line 4363 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> && __storageServers,int loopDepth) 
	{
		storageServers = std::move(__storageServers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state > 0) static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForUndesirableServersActor*>(this)->ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 491 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 4442 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(false);
		this->~CheckForUndesirableServersActorState();
		static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 428 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!(i < storageServers.size()))
															#line 4461 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 430 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ReplyPromise<KeyValueStoreType> typeReply;
															#line 431 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<ErrorOr<KeyValueStoreType>> __when_expr_1 = storageServers[i].getKeyValueStoreType.getReplyUnlessFailedFor(typeReply, 2, 0);
															#line 431 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4471 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state = 2;
															#line 431 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >*>(static_cast<CheckForUndesirableServersActor*>(this)));
															#line 4476 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(ErrorOr<KeyValueStoreType> const& keyValueStoreType,int loopDepth) 
	{
															#line 434 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!keyValueStoreType.present())
															#line 4498 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 435 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ServerUnavailable").detail("ServerID", storageServers[i].id());
															#line 436 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Storage server unavailable");
															#line 4504 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		else
		{
															#line 437 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (configuration.perpetualStoreType.isValid())
															#line 4510 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 440 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (wiggleLocalityKeyValue == "0" || localityMatchInList(wiggleLocalityKeyValues, storageServers[i].locality))
															#line 4514 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 442 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (keyValueStoreType.get() != configuration.perpetualStoreType)
															#line 4518 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 443 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.perpetualStoreType.toString()) .detail("IsPerpetualStoreType", true);
															#line 448 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Storage server has wrong key-value store type");
															#line 449 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 4526 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
						this->~CheckForUndesirableServersActorState();
						static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
				else
				{
															#line 451 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if ((!storageServers[i].isTss() && keyValueStoreType.get() != configuration.storageServerStoreType) || (storageServers[i].isTss() && keyValueStoreType.get() != configuration.testingStorageServerStoreType))
															#line 4537 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 455 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.perpetualStoreType.toString()) .detail("IsPerpetualStoreType", false);
															#line 460 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Storage server has wrong key-value store type");
															#line 461 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 4545 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
						this->~CheckForUndesirableServersActorState();
						static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
			else
			{
															#line 463 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (((!storageServers[i].isTss() && keyValueStoreType.get() != configuration.storageServerStoreType) || (storageServers[i].isTss() && keyValueStoreType.get() != configuration.testingStorageServerStoreType)) && (wiggleLocalityKeyValue == "0" || localityMatchInList(wiggleLocalityKeyValues, storageServers[i].locality)))
															#line 4557 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 469 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.storageServerStoreType.toString()) .detail("IsPerpetualStoreType", false);
															#line 474 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					self->testFailure("Storage server has wrong key-value store type");
															#line 475 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 4565 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
					this->~CheckForUndesirableServersActorState();
					static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 479 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(j = i + 1;j < storageServers.size();j++) {
															#line 480 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (storageServers[i].address() == storageServers[j].address())
															#line 4577 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 481 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_UndesirableServer") .detail("StorageServer1", storageServers[i].id()) .detail("StorageServer2", storageServers[j].id()) .detail("Address", storageServers[i].address());
															#line 485 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				self->testFailure("Multiple storage servers have the same address");
															#line 486 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 4585 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
				this->~CheckForUndesirableServersActorState();
				static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 428 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i++;
															#line 4594 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(ErrorOr<KeyValueStoreType> && keyValueStoreType,int loopDepth) 
	{
															#line 434 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!keyValueStoreType.present())
															#line 4603 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 435 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ServerUnavailable").detail("ServerID", storageServers[i].id());
															#line 436 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Storage server unavailable");
															#line 4609 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		else
		{
															#line 437 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (configuration.perpetualStoreType.isValid())
															#line 4615 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 440 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (wiggleLocalityKeyValue == "0" || localityMatchInList(wiggleLocalityKeyValues, storageServers[i].locality))
															#line 4619 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 442 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (keyValueStoreType.get() != configuration.perpetualStoreType)
															#line 4623 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 443 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.perpetualStoreType.toString()) .detail("IsPerpetualStoreType", true);
															#line 448 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Storage server has wrong key-value store type");
															#line 449 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 4631 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
						this->~CheckForUndesirableServersActorState();
						static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
				else
				{
															#line 451 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if ((!storageServers[i].isTss() && keyValueStoreType.get() != configuration.storageServerStoreType) || (storageServers[i].isTss() && keyValueStoreType.get() != configuration.testingStorageServerStoreType))
															#line 4642 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 455 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.perpetualStoreType.toString()) .detail("IsPerpetualStoreType", false);
															#line 460 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						self->testFailure("Storage server has wrong key-value store type");
															#line 461 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 4650 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
						this->~CheckForUndesirableServersActorState();
						static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
			else
			{
															#line 463 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (((!storageServers[i].isTss() && keyValueStoreType.get() != configuration.storageServerStoreType) || (storageServers[i].isTss() && keyValueStoreType.get() != configuration.testingStorageServerStoreType)) && (wiggleLocalityKeyValue == "0" || localityMatchInList(wiggleLocalityKeyValues, storageServers[i].locality)))
															#line 4662 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 469 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_WrongKeyValueStoreType") .detail("ServerID", storageServers[i].id()) .detail("StoreType", keyValueStoreType.get().toString()) .detail("DesiredType", configuration.storageServerStoreType.toString()) .detail("IsPerpetualStoreType", false);
															#line 474 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					self->testFailure("Storage server has wrong key-value store type");
															#line 475 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 4670 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
					this->~CheckForUndesirableServersActorState();
					static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 479 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(j = i + 1;j < storageServers.size();j++) {
															#line 480 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (storageServers[i].address() == storageServers[j].address())
															#line 4682 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 481 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_UndesirableServer") .detail("StorageServer1", storageServers[i].id()) .detail("StorageServer2", storageServers[j].id()) .detail("Address", storageServers[i].address());
															#line 485 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				self->testFailure("Multiple storage servers have the same address");
															#line 486 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckForUndesirableServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForUndesirableServersActorState(); static_cast<CheckForUndesirableServersActor*>(this)->destroy(); return 0; }
															#line 4690 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckForUndesirableServersActor*>(this)->SAV< bool >::value()) bool(true);
				this->~CheckForUndesirableServersActorState();
				static_cast<CheckForUndesirableServersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 428 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		i++;
															#line 4699 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ErrorOr<KeyValueStoreType> const& keyValueStoreType,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(keyValueStoreType, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ErrorOr<KeyValueStoreType> && keyValueStoreType,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(keyValueStoreType), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state > 0) static_cast<CheckForUndesirableServersActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForUndesirableServersActor*>(this)->ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >*,ErrorOr<KeyValueStoreType> const& value) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >*,ErrorOr<KeyValueStoreType> && value) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 417 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 417 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	DatabaseConfiguration configuration;
															#line 417 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 420 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int i;
															#line 421 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	int j;
															#line 422 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<StorageServerInterface> storageServers;
															#line 423 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::string wiggleLocalityKeyValue;
															#line 424 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<std::pair<Optional<Value>, Optional<Value>>> wiggleLocalityKeyValues;
															#line 4795 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkForUndesirableServers()
															#line 417 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForUndesirableServersActor final : public Actor<bool>, public ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >, public ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >, public FastAllocated<CheckForUndesirableServersActor>, public CheckForUndesirableServersActorState<CheckForUndesirableServersActor> {
															#line 4800 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckForUndesirableServersActor>::operator new;
	using FastAllocated<CheckForUndesirableServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3447346807636151296UL, 6531772124510464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >;
friend struct ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >;
															#line 417 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForUndesirableServersActor(Database const& cx,DatabaseConfiguration const& configuration,ConsistencyCheckWorkload* const& self) 
															#line 4818 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckForUndesirableServersActorState<CheckForUndesirableServersActor>(cx, configuration, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11876187790522090240UL, 13735064405301590272UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForUndesirableServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkForUndesirableServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkForUndesirableServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckForUndesirableServersActor, 0, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckForUndesirableServersActor, 1, ErrorOr<KeyValueStoreType> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 417 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkForUndesirableServers( Database const& cx, DatabaseConfiguration const& configuration, ConsistencyCheckWorkload* const& self ) {
															#line 417 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckForUndesirableServersActor(cx, configuration, self));
															#line 4851 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 493 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Every storage server should have it metadata populated and no metadata leak when the database reach the quiescent
	// state
																#line 4858 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkStorageMetadata()
															#line 496 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckStorageMetadataActor>
															#line 496 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckStorageMetadataActorState {
															#line 4864 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 496 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckStorageMetadataActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 496 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 496 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 496 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self),
															#line 497 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   metadataMap(serverMetadataKeys.begin, IncludeVersion()),
															#line 499 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   servers(),
															#line 500 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   id_ssi(),
															#line 501 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   tr(cx)
															#line 4881 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkStorageMetadata", reinterpret_cast<unsigned long>(this));

	}
	~CheckStorageMetadataActorState() 
	{
		fdb_probe_actor_destroy("checkStorageMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 502 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			;
															#line 4896 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckStorageMetadataActorState();
		static_cast<CheckStorageMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 524 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( auto& ssi : servers ) {
															#line 525 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ASSERT(id_ssi.contains(ssi.id()));
															#line 4921 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 527 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckStorageMetadataActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckStorageMetadataActorState(); static_cast<CheckStorageMetadataActor*>(this)->destroy(); return 0; }
															#line 4925 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckStorageMetadataActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckStorageMetadataActorState();
		static_cast<CheckStorageMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 503 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		servers.clear();
															#line 504 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		id_ssi.clear();
															#line 505 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 506 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 4950 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		try {
															#line 508 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<KeyBackedRangeResult<std::pair<UID, StorageMetadataType>>> __when_expr_0 = metadataMap.getRange(&tr, {}, {}, CLIENT_KNOBS->TOO_MANY);
															#line 508 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4956 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 1;
															#line 508 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >*>(static_cast<CheckStorageMetadataActor*>(this)));
															#line 4961 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 520 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 520 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4998 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 3;
															#line 520 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckStorageMetadataActor, 2, Void >*>(static_cast<CheckStorageMetadataActor*>(this)));
															#line 5003 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 510 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(!metadata.more && metadata.results.size() < CLIENT_KNOBS->TOO_MANY);
															#line 511 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 511 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5022 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 2;
															#line 511 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckStorageMetadataActor, 1, RangeResult >*>(static_cast<CheckStorageMetadataActor*>(this)));
															#line 5027 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> const& __metadata,int loopDepth) 
	{
															#line 508 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		metadata = __metadata;
															#line 5036 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> && __metadata,int loopDepth) 
	{
		metadata = std::move(__metadata);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckStorageMetadataActor*>(this)->ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >*,KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> const& value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >*,KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> && value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& serverList,int loopDepth) 
	{
															#line 512 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 513 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT_EQ(metadata.results.size(), serverList.size());
															#line 514 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		id_ssi = std::unordered_map<UID, StorageMetadataType>(metadata.results.begin(), metadata.results.end());
															#line 515 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		servers.reserve(serverList.size());
															#line 516 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 517 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			servers.push_back(decodeServerListValue(serverList[i].value));
															#line 5125 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && serverList,int loopDepth) 
	{
															#line 512 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 513 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ASSERT_EQ(metadata.results.size(), serverList.size());
															#line 514 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		id_ssi = std::unordered_map<UID, StorageMetadataType>(metadata.results.begin(), metadata.results.end());
															#line 515 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		servers.reserve(serverList.size());
															#line 516 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 517 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			servers.push_back(decodeServerListValue(serverList[i].value));
															#line 5145 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(serverList, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(serverList), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckStorageMetadataActor*>(this)->ActorCallback< CheckStorageMetadataActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckStorageMetadataActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<CheckStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckStorageMetadataActor*>(this)->ActorCallback< CheckStorageMetadataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckStorageMetadataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckStorageMetadataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 496 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 496 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 497 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	KeyBackedObjectMap<UID, StorageMetadataType, decltype(IncludeVersion())> metadataMap;
															#line 499 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<StorageServerInterface> servers;
															#line 500 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::unordered_map<UID, StorageMetadataType> id_ssi;
															#line 501 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Transaction tr;
															#line 508 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> metadata;
															#line 5327 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkStorageMetadata()
															#line 496 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckStorageMetadataActor final : public Actor<bool>, public ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >, public ActorCallback< CheckStorageMetadataActor, 1, RangeResult >, public ActorCallback< CheckStorageMetadataActor, 2, Void >, public FastAllocated<CheckStorageMetadataActor>, public CheckStorageMetadataActorState<CheckStorageMetadataActor> {
															#line 5332 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckStorageMetadataActor>::operator new;
	using FastAllocated<CheckStorageMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1179112592958995712UL, 15668847642768794880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >;
friend struct ActorCallback< CheckStorageMetadataActor, 1, RangeResult >;
friend struct ActorCallback< CheckStorageMetadataActor, 2, Void >;
															#line 496 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckStorageMetadataActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 5351 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckStorageMetadataActorState<CheckStorageMetadataActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkStorageMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14773869242612564736UL, 6352906758137099520UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkStorageMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkStorageMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckStorageMetadataActor, 0, KeyBackedRangeResult<std::pair<UID, StorageMetadataType>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckStorageMetadataActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckStorageMetadataActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 496 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkStorageMetadata( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 496 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckStorageMetadataActor(cx, self));
															#line 5385 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 529 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Returns false if any worker that should have a storage server does not have one
																#line 5391 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkForStorage()
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckForStorageActor>
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForStorageActorState {
															#line 5397 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForStorageActorState(Database const& cx,DatabaseConfiguration const& configuration,std::map<UID, StorageServerInterface> const& tssMapping,ConsistencyCheckWorkload* const& self) 
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   configuration(configuration),
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   tssMapping(tssMapping),
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 5410 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkForStorage", reinterpret_cast<unsigned long>(this));

	}
	~CheckForStorageActorState() 
	{
		fdb_probe_actor_destroy("checkForStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 535 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(self->dbInfo);
															#line 535 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckForStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5427 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckForStorageActor*>(this)->actor_wait_state = 1;
															#line 535 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >*>(static_cast<CheckForStorageActor*>(this)));
															#line 5432 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckForStorageActorState();
		static_cast<CheckForStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 536 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<StorageServerInterface>> __when_expr_1 = getStorageServers(cx);
															#line 536 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckForStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5457 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckForStorageActor*>(this)->actor_wait_state = 2;
															#line 536 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >*>(static_cast<CheckForStorageActor*>(this)));
															#line 5462 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 535 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		workers = __workers;
															#line 5471 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckForStorageActor*>(this)->actor_wait_state > 0) static_cast<CheckForStorageActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForStorageActor*>(this)->ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 537 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::vector<Optional<Key>> missingStorage;
															#line 539 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 540 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			NetworkAddress addr = workers[i].interf.stableAddress();
															#line 541 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!configuration.isExcludedServer(workers[i].interf.addresses(), workers[i].interf.locality) && (workers[i].processClass == ProcessClass::StorageClass || workers[i].processClass == ProcessClass::UnsetClass))
															#line 5556 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 544 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				bool found = false;
															#line 545 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				for(int j = 0;j < storageServers.size();j++) {
															#line 546 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (storageServers[j].stableAddress() == addr)
															#line 5564 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 547 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						found = true;
															#line 5568 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						break;
					}
				}
															#line 551 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!found)
															#line 5574 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 552 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_NoStorage") .detail("Address", addr) .detail("ProcessId", workers[i].interf.locality.processId()) .detail("ProcessClassEqualToStorageClass", (int)(workers[i].processClass == ProcessClass::StorageClass));
															#line 557 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					missingStorage.push_back(workers[i].interf.locality.dcId());
															#line 5580 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
			}
		}
															#line 562 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		int missingDc0 = configuration.regions.size() == 0 ? 0 : std::count(missingStorage.begin(), missingStorage.end(), configuration.regions[0].dcId);
															#line 565 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		int missingDc1 = configuration.regions.size() < 2 ? 0 : std::count(missingStorage.begin(), missingStorage.end(), configuration.regions[1].dcId);
															#line 569 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if ((configuration.regions.size() == 0 && missingStorage.size()) || (configuration.regions.size() == 1 && missingDc0) || (configuration.regions.size() == 2 && configuration.usableRegions == 1 && missingDc0 && missingDc1) || (configuration.regions.size() == 2 && configuration.usableRegions > 1 && (missingDc0 || missingDc1)))
															#line 5590 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 575 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			bool couldExpectMissingTss = (configuration.desiredTSSCount - tssMapping.size()) > 0;
															#line 577 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			int countMissing = missingStorage.size();
															#line 578 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			int acceptableTssMissing = 1;
															#line 579 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (configuration.regions.size() == 1)
															#line 5600 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 580 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				countMissing = missingDc0;
															#line 5604 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
			else
			{
															#line 581 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (configuration.regions.size() == 2)
															#line 5610 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 582 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (configuration.usableRegions == 1)
															#line 5614 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					{
															#line 584 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						countMissing = std::min(missingDc0, missingDc1);
															#line 5618 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					}
					else
					{
															#line 585 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (configuration.usableRegions == 2)
															#line 5624 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						{
															#line 586 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							countMissing = missingDc0 + missingDc1;
															#line 587 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							acceptableTssMissing = 2;
															#line 5630 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						}
						else
						{
															#line 589 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							ASSERT(false);
															#line 5636 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						}
					}
				}
			}
															#line 593 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!couldExpectMissingTss || countMissing > acceptableTssMissing)
															#line 5643 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 594 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				self->testFailure("No storage server on worker");
															#line 595 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckForStorageActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckForStorageActorState(); static_cast<CheckForStorageActor*>(this)->destroy(); return 0; }
															#line 5649 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckForStorageActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckForStorageActorState();
				static_cast<CheckForStorageActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 597 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent(SevWarn, "ConsistencyCheck_TSSMissing").log();
															#line 5659 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
		}
															#line 601 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckForStorageActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForStorageActorState(); static_cast<CheckForStorageActor*>(this)->destroy(); return 0; }
															#line 5664 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckForStorageActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckForStorageActorState();
		static_cast<CheckForStorageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<StorageServerInterface> const& __storageServers,int loopDepth) 
	{
															#line 536 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		storageServers = __storageServers;
															#line 5676 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<StorageServerInterface> && __storageServers,int loopDepth) 
	{
		storageServers = std::move(__storageServers);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckForStorageActor*>(this)->actor_wait_state > 0) static_cast<CheckForStorageActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForStorageActor*>(this)->ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	DatabaseConfiguration configuration;
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 535 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 536 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<StorageServerInterface> storageServers;
															#line 5763 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkForStorage()
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForStorageActor final : public Actor<bool>, public ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >, public ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >, public FastAllocated<CheckForStorageActor>, public CheckForStorageActorState<CheckForStorageActor> {
															#line 5768 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckForStorageActor>::operator new;
	using FastAllocated<CheckForStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3149508155837000704UL, 13473135334414068480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >;
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForStorageActor(Database const& cx,DatabaseConfiguration const& configuration,std::map<UID, StorageServerInterface> const& tssMapping,ConsistencyCheckWorkload* const& self) 
															#line 5786 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckForStorageActorState<CheckForStorageActor>(cx, configuration, tssMapping, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkForStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8398300410677844736UL, 6230040935244071680UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkForStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkForStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckForStorageActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckForStorageActor, 1, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkForStorage( Database const& cx, DatabaseConfiguration const& configuration, std::map<UID, StorageServerInterface> const& tssMapping, ConsistencyCheckWorkload* const& self ) {
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckForStorageActor(cx, configuration, tssMapping, self));
															#line 5819 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 603 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

																#line 5824 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkForExtraDataStores()
															#line 604 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckForExtraDataStoresActor>
															#line 604 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForExtraDataStoresActorState {
															#line 5830 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 604 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForExtraDataStoresActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 604 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 604 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 604 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 5839 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkForExtraDataStores", reinterpret_cast<unsigned long>(this));

	}
	~CheckForExtraDataStoresActorState() 
	{
		fdb_probe_actor_destroy("checkForExtraDataStores", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 605 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(self->dbInfo);
															#line 605 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5856 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 1;
															#line 605 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >*>(static_cast<CheckForExtraDataStoresActor*>(this)));
															#line 5861 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckForExtraDataStoresActorState();
		static_cast<CheckForExtraDataStoresActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 606 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<StorageServerInterface>> __when_expr_1 = getStorageServers(cx);
															#line 606 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5886 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 2;
															#line 606 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >*>(static_cast<CheckForExtraDataStoresActor*>(this)));
															#line 5891 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 605 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		workers = __workers;
															#line 5900 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state > 0) static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExtraDataStoresActor*>(this)->ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 607 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<WorkerInterface>> __when_expr_2 = getCoordWorkers(cx, self->dbInfo);
															#line 607 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5981 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 3;
															#line 607 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >*>(static_cast<CheckForExtraDataStoresActor*>(this)));
															#line 5986 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<StorageServerInterface> const& __storageServers,int loopDepth) 
	{
															#line 606 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		storageServers = __storageServers;
															#line 5995 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<StorageServerInterface> && __storageServers,int loopDepth) 
	{
		storageServers = std::move(__storageServers);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state > 0) static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExtraDataStoresActor*>(this)->ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 608 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		auto& db = self->dbInfo->get();
															#line 609 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		logs = db.logSystemConfig.allPresentLogs();
															#line 611 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		itr = std::vector<WorkerDetails>::iterator();
															#line 612 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		foundExtraDataStore = false;
															#line 613 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		protectedProcessesToKill = std::vector<struct ProcessInfo*>();
															#line 615 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		statefulProcesses = std::map<NetworkAddress, std::set<UID>>();
															#line 616 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& ss : storageServers ) {
															#line 617 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			statefulProcesses[ss.address()].insert(ss.id());
															#line 619 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (ss.secondaryAddress().present())
															#line 6090 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 620 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				statefulProcesses[ss.secondaryAddress().get()].insert(ss.id());
															#line 6094 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 622 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevCCheckInfo, "StatefulProcess") .detail("StorageServer", ss.id()) .detail("PrimaryAddress", ss.address().toString()) .detail("SecondaryAddress", ss.secondaryAddress().present() ? ss.secondaryAddress().get().toString() : "Unset");
															#line 6098 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 628 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& log : logs ) {
															#line 629 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			statefulProcesses[log.address()].insert(log.id());
															#line 630 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (log.secondaryAddress().present())
															#line 6106 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 631 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				statefulProcesses[log.secondaryAddress().get()].insert(log.id());
															#line 6110 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 633 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevCCheckInfo, "StatefulProcess") .detail("Log", log.id()) .detail("PrimaryAddress", log.address().toString()) .detail("SecondaryAddress", log.secondaryAddress().present() ? log.secondaryAddress().get().toString() : "Unset");
															#line 6114 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 640 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& cWorker : coordWorkers ) {
															#line 641 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			statefulProcesses[cWorker.address()].insert(cWorker.id());
															#line 642 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (cWorker.secondaryAddress().present())
															#line 6122 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 643 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				statefulProcesses[cWorker.secondaryAddress().get()].insert(cWorker.id());
															#line 6126 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 645 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent(SevCCheckInfo, "StatefulProcess") .detail("Coordinator", cWorker.id()) .detail("PrimaryAddress", cWorker.address().toString()) .detail("SecondaryAddress", cWorker.secondaryAddress().present() ? cWorker.secondaryAddress().get().toString() : "Unset");
															#line 6130 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 652 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		itr = workers.begin();
															#line 6134 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<WorkerInterface> const& __coordWorkers,int loopDepth) 
	{
															#line 607 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		coordWorkers = __coordWorkers;
															#line 6143 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<WorkerInterface> && __coordWorkers,int loopDepth) 
	{
		coordWorkers = std::move(__coordWorkers);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state > 0) static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExtraDataStoresActor*>(this)->ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >*,std::vector<WorkerInterface> const& value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >*,std::vector<WorkerInterface> && value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 705 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (foundExtraDataStore)
															#line 6222 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 706 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Extra data stores present on workers");
															#line 707 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckForExtraDataStoresActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckForExtraDataStoresActorState(); static_cast<CheckForExtraDataStoresActor*>(this)->destroy(); return 0; }
															#line 6228 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckForExtraDataStoresActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckForExtraDataStoresActorState();
			static_cast<CheckForExtraDataStoresActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 710 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckForExtraDataStoresActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForExtraDataStoresActorState(); static_cast<CheckForExtraDataStoresActor*>(this)->destroy(); return 0; }
															#line 6236 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckForExtraDataStoresActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckForExtraDataStoresActorState();
		static_cast<CheckForExtraDataStoresActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 652 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!(itr != workers.end()))
															#line 6255 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 653 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<ErrorOr<Standalone<VectorRef<UID>>>> __when_expr_3 = itr->interf.diskStoreRequest.getReplyUnlessFailedFor(DiskStoreRequest(false), 2, 0);
															#line 653 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6263 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 4;
															#line 653 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >*>(static_cast<CheckForExtraDataStoresActor*>(this)));
															#line 6268 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(ErrorOr<Standalone<VectorRef<UID>>> const& stores,int loopDepth) 
	{
															#line 655 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (stores.isError())
															#line 6290 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 656 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_GetDataStoreFailure") .error(stores.getError()) .detail("Address", itr->interf.address());
															#line 659 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Failed to get data stores");
															#line 660 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckForExtraDataStoresActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckForExtraDataStoresActorState(); static_cast<CheckForExtraDataStoresActor*>(this)->destroy(); return 0; }
															#line 6298 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckForExtraDataStoresActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckForExtraDataStoresActorState();
			static_cast<CheckForExtraDataStoresActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 663 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent(SevCCheckInfo, "ConsistencyCheck_ExtraDataStore") .detail("Worker", itr->interf.id().toString()) .detail("PrimaryAddress", itr->interf.address().toString()) .detail("SecondaryAddress", itr->interf.secondaryAddress().present() ? itr->interf.secondaryAddress().get().toString() : "Unset");
															#line 669 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& id : stores.get() ) {
															#line 670 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (statefulProcesses[itr->interf.address()].contains(id))
															#line 6310 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
				continue;
			}
															#line 674 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ExtraDataStore") .detail("Address", itr->interf.address()) .detail("DataStoreID", id);
															#line 677 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (g_network->isSimulated())
															#line 6318 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 681 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				ISimulator::ProcessInfo* p = g_simulator->getProcessByAddress(itr->interf.address());
															#line 684 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_RebootProcess") .detail("Address", itr->interf.address()) .detail("ProcessPrimaryAddress", p->address) .detail("ProcessAddresses", p->addresses.toString()) .detail("DataStoreID", id) .detail("Protected", g_simulator->protectedAddresses.contains(itr->interf.address())) .detail("Reliable", p->isReliable()) .detail("ReliableInfo", p->getReliableInfo()) .detail("KillOrRebootProcess", p->address);
															#line 694 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (p->isReliable())
															#line 6326 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 695 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					g_simulator->rebootProcess(p, ISimulator::KillType::RebootProcess);
															#line 6330 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
				else
				{
															#line 697 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					g_simulator->killProcess(p, ISimulator::KillType::KillInstantly);
															#line 6336 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
			}
															#line 701 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			foundExtraDataStore = true;
															#line 6341 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 652 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		++itr;
															#line 6345 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(ErrorOr<Standalone<VectorRef<UID>>> && stores,int loopDepth) 
	{
															#line 655 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (stores.isError())
															#line 6354 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 656 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_GetDataStoreFailure") .error(stores.getError()) .detail("Address", itr->interf.address());
															#line 659 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			self->testFailure("Failed to get data stores");
															#line 660 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckForExtraDataStoresActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckForExtraDataStoresActorState(); static_cast<CheckForExtraDataStoresActor*>(this)->destroy(); return 0; }
															#line 6362 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckForExtraDataStoresActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckForExtraDataStoresActorState();
			static_cast<CheckForExtraDataStoresActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 663 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		TraceEvent(SevCCheckInfo, "ConsistencyCheck_ExtraDataStore") .detail("Worker", itr->interf.id().toString()) .detail("PrimaryAddress", itr->interf.address().toString()) .detail("SecondaryAddress", itr->interf.secondaryAddress().present() ? itr->interf.secondaryAddress().get().toString() : "Unset");
															#line 669 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& id : stores.get() ) {
															#line 670 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (statefulProcesses[itr->interf.address()].contains(id))
															#line 6374 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
				continue;
			}
															#line 674 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ExtraDataStore") .detail("Address", itr->interf.address()) .detail("DataStoreID", id);
															#line 677 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (g_network->isSimulated())
															#line 6382 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 681 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				ISimulator::ProcessInfo* p = g_simulator->getProcessByAddress(itr->interf.address());
															#line 684 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_RebootProcess") .detail("Address", itr->interf.address()) .detail("ProcessPrimaryAddress", p->address) .detail("ProcessAddresses", p->addresses.toString()) .detail("DataStoreID", id) .detail("Protected", g_simulator->protectedAddresses.contains(itr->interf.address())) .detail("Reliable", p->isReliable()) .detail("ReliableInfo", p->getReliableInfo()) .detail("KillOrRebootProcess", p->address);
															#line 694 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (p->isReliable())
															#line 6390 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 695 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					g_simulator->rebootProcess(p, ISimulator::KillType::RebootProcess);
															#line 6394 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
				else
				{
															#line 697 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					g_simulator->killProcess(p, ISimulator::KillType::KillInstantly);
															#line 6400 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				}
			}
															#line 701 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			foundExtraDataStore = true;
															#line 6405 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 652 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		++itr;
															#line 6409 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(ErrorOr<Standalone<VectorRef<UID>>> const& stores,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(stores, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(ErrorOr<Standalone<VectorRef<UID>>> && stores,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(stores), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state > 0) static_cast<CheckForExtraDataStoresActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExtraDataStoresActor*>(this)->ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >*,ErrorOr<Standalone<VectorRef<UID>>> const& value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >*,ErrorOr<Standalone<VectorRef<UID>>> && value) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 604 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 604 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 605 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 606 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<StorageServerInterface> storageServers;
															#line 607 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerInterface> coordWorkers;
															#line 609 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<TLogInterface> logs;
															#line 611 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerDetails>::iterator itr;
															#line 612 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	bool foundExtraDataStore;
															#line 613 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<struct ProcessInfo*> protectedProcessesToKill;
															#line 615 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::map<NetworkAddress, std::set<UID>> statefulProcesses;
															#line 6509 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkForExtraDataStores()
															#line 604 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckForExtraDataStoresActor final : public Actor<bool>, public ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >, public ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >, public ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >, public ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >, public FastAllocated<CheckForExtraDataStoresActor>, public CheckForExtraDataStoresActorState<CheckForExtraDataStoresActor> {
															#line 6514 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckForExtraDataStoresActor>::operator new;
	using FastAllocated<CheckForExtraDataStoresActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16798344058801288448UL, 3311562756568974592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >;
friend struct ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >;
friend struct ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >;
															#line 604 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckForExtraDataStoresActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 6534 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckForExtraDataStoresActorState<CheckForExtraDataStoresActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(427473886050604288UL, 3872966658194644992UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExtraDataStoresActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkForExtraDataStores");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkForExtraDataStores", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckForExtraDataStoresActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckForExtraDataStoresActor, 1, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckForExtraDataStoresActor, 2, std::vector<WorkerInterface> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckForExtraDataStoresActor, 3, ErrorOr<Standalone<VectorRef<UID>>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 604 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkForExtraDataStores( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 604 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckForExtraDataStoresActor(cx, self));
															#line 6569 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 712 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

																#line 6574 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkWorkerList()
															#line 713 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckWorkerListActor>
															#line 713 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckWorkerListActorState {
															#line 6580 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 713 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckWorkerListActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 713 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 713 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 713 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self)
															#line 6589 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkWorkerList", reinterpret_cast<unsigned long>(this));

	}
	~CheckWorkerListActorState() 
	{
		fdb_probe_actor_destroy("checkWorkerList", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 714 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!g_simulator->extraDatabases.empty())
															#line 6604 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 715 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 6608 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(true);
				this->~CheckWorkerListActorState();
				static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 718 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(self->dbInfo);
															#line 718 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckWorkerListActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6618 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckWorkerListActor*>(this)->actor_wait_state = 1;
															#line 718 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >*>(static_cast<CheckWorkerListActor*>(this)));
															#line 6623 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckWorkerListActorState();
		static_cast<CheckWorkerListActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
															#line 719 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::set<NetworkAddress> workerAddresses;
															#line 721 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& it : workers ) {
															#line 722 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			NetworkAddress addr = it.interf.tLog.getEndpoint().addresses.getTLSAddress();
															#line 723 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ISimulator::ProcessInfo* info = g_simulator->getProcessByAddress(addr);
															#line 724 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!info || info->failed)
															#line 6654 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 725 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_FailedWorkerInList").detail("Addr", it.interf.address());
															#line 726 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 6660 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckWorkerListActorState();
				static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 728 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			workerAddresses.insert(NetworkAddress(addr.ip, addr.port, true, addr.isTLS()));
															#line 6668 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 731 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::vector<ISimulator::ProcessInfo*> all = g_simulator->getAllProcesses();
															#line 732 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < all.size();i++) {
															#line 733 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (all[i]->isReliable() && all[i]->name == std::string("Server") && all[i]->startingClass != ProcessClass::TesterClass && all[i]->startingClass != ProcessClass::SimHTTPServerClass && all[i]->protocolVersion == g_network->protocolVersion())
															#line 6676 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 737 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!workerAddresses.contains(all[i]->address))
															#line 6680 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 738 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_WorkerMissingFromList").detail("Addr", all[i]->address);
															#line 739 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 6686 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(false);
					this->~CheckWorkerListActorState();
					static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 744 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 6696 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckWorkerListActorState();
		static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
															#line 719 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::set<NetworkAddress> workerAddresses;
															#line 721 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& it : workers ) {
															#line 722 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			NetworkAddress addr = it.interf.tLog.getEndpoint().addresses.getTLSAddress();
															#line 723 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			ISimulator::ProcessInfo* info = g_simulator->getProcessByAddress(addr);
															#line 724 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!info || info->failed)
															#line 6716 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 725 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_FailedWorkerInList").detail("Addr", it.interf.address());
															#line 726 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 6722 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckWorkerListActorState();
				static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 728 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			workerAddresses.insert(NetworkAddress(addr.ip, addr.port, true, addr.isTLS()));
															#line 6730 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 731 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::vector<ISimulator::ProcessInfo*> all = g_simulator->getAllProcesses();
															#line 732 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for(int i = 0;i < all.size();i++) {
															#line 733 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (all[i]->isReliable() && all[i]->name == std::string("Server") && all[i]->startingClass != ProcessClass::TesterClass && all[i]->startingClass != ProcessClass::SimHTTPServerClass && all[i]->protocolVersion == g_network->protocolVersion())
															#line 6738 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 737 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!workerAddresses.contains(all[i]->address))
															#line 6742 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 738 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_WorkerMissingFromList").detail("Addr", all[i]->address);
															#line 739 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 6748 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(false);
					this->~CheckWorkerListActorState();
					static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 744 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckWorkerListActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckWorkerListActorState(); static_cast<CheckWorkerListActor*>(this)->destroy(); return 0; }
															#line 6758 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckWorkerListActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckWorkerListActorState();
		static_cast<CheckWorkerListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(workers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckWorkerListActor*>(this)->actor_wait_state > 0) static_cast<CheckWorkerListActor*>(this)->actor_wait_state = 0;
		static_cast<CheckWorkerListActor*>(this)->ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckWorkerListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckWorkerListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckWorkerListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkWorkerList", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 713 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 713 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 6845 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkWorkerList()
															#line 713 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckWorkerListActor final : public Actor<bool>, public ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >, public FastAllocated<CheckWorkerListActor>, public CheckWorkerListActorState<CheckWorkerListActor> {
															#line 6850 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckWorkerListActor>::operator new;
	using FastAllocated<CheckWorkerListActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5180165826808105728UL, 10380710669023032576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >;
															#line 713 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckWorkerListActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 6867 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckWorkerListActorState<CheckWorkerListActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkWorkerList", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13452236408503872000UL, 17501392737149118464UL);
		ActorExecutionContextHelper __helper(static_cast<CheckWorkerListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkWorkerList");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkWorkerList", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckWorkerListActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 713 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkWorkerList( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 713 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckWorkerListActor(cx, self));
															#line 6899 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 746 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	static ProcessClass::Fitness getBestAvailableFitness(
	    const std::vector<ProcessClass::ClassType>& availableClassTypes,
	    ProcessClass::ClusterRole role) {
		ProcessClass::Fitness bestAvailableFitness = ProcessClass::NeverAssign;
		for (auto classType : availableClassTypes) {
			bestAvailableFitness = std::min(
			    bestAvailableFitness, ProcessClass(classType, ProcessClass::InvalidSource).machineClassFitness(role));
		}

		return bestAvailableFitness;
	}

	template <class T>
	static std::string getOptionalString(Optional<T> opt) {
		if (opt.present())
			return opt.get().toString();
		return "NotSet";
	}

																#line 6923 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkCoordinators()
															#line 766 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckCoordinatorsActor>
															#line 766 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckCoordinatorsActorState {
															#line 6929 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 766 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckCoordinatorsActorState(Database const& cx) 
															#line 766 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 766 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 767 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   tr(cx)
															#line 6938 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkCoordinators", reinterpret_cast<unsigned long>(this));

	}
	~CheckCoordinatorsActorState() 
	{
		fdb_probe_actor_destroy("checkCoordinators", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 768 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			;
															#line 6953 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckCoordinatorsActorState();
		static_cast<CheckCoordinatorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 770 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 771 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(coordinatorsKey);
															#line 771 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6988 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 1;
															#line 771 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >*>(static_cast<CheckCoordinatorsActor*>(this)));
															#line 6993 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 804 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 804 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7017 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 4;
															#line 804 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckCoordinatorsActor, 3, Void >*>(static_cast<CheckCoordinatorsActor*>(this)));
															#line 7022 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& currentKey,int loopDepth) 
	{
															#line 773 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!currentKey.present())
															#line 7037 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 774 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NoCoordinatorKey").log();
															#line 775 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 7043 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckCoordinatorsActorState();
			static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 778 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ClusterConnectionString old(currentKey.get().toString());
															#line 779 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_1 = old.tryResolveHostnames();
															#line 779 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7055 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 2;
															#line 779 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*>(static_cast<CheckCoordinatorsActor*>(this)));
															#line 7060 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && currentKey,int loopDepth) 
	{
															#line 773 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!currentKey.present())
															#line 7069 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 774 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_NoCoordinatorKey").log();
															#line 775 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 7075 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckCoordinatorsActorState();
			static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 778 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ClusterConnectionString old(currentKey.get().toString());
															#line 779 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_1 = old.tryResolveHostnames();
															#line 779 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7087 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 2;
															#line 779 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*>(static_cast<CheckCoordinatorsActor*>(this)));
															#line 7092 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& currentKey,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(currentKey, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && currentKey,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(currentKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCoordinatorsActor*>(this)->ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 781 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<ProcessData>> __when_expr_2 = ::getWorkers(&tr);
															#line 781 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7178 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 3;
															#line 781 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >*>(static_cast<CheckCoordinatorsActor*>(this)));
															#line 7183 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<NetworkAddress> const& __oldCoordinators,int loopDepth) 
	{
															#line 779 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		oldCoordinators = __oldCoordinators;
															#line 7192 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<NetworkAddress> && __oldCoordinators,int loopDepth) 
	{
		oldCoordinators = std::move(__oldCoordinators);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCoordinatorsActor*>(this)->ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(std::vector<ProcessData> const& workers,int loopDepth) 
	{
															#line 783 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<NetworkAddress, LocalityData> addr_locality;
															#line 784 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( auto w : workers ) {
															#line 785 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			addr_locality[w.address] = w.locality;
															#line 7275 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 788 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::set<Optional<Standalone<StringRef>>> checkDuplicates;
															#line 789 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& addr : oldCoordinators ) {
															#line 790 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			auto findResult = addr_locality.find(addr);
															#line 791 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (findResult != addr_locality.end())
															#line 7285 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 792 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (checkDuplicates.contains(findResult->second.zoneId()))
															#line 7289 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 793 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_BadCoordinator") .detail("Addr", addr) .detail("NotFound", findResult == addr_locality.end());
															#line 796 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 7295 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(false);
					this->~CheckCoordinatorsActorState();
					static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 798 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				checkDuplicates.insert(findResult->second.zoneId());
															#line 7303 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
		}
															#line 802 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 7308 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckCoordinatorsActorState();
		static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(std::vector<ProcessData> && workers,int loopDepth) 
	{
															#line 783 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<NetworkAddress, LocalityData> addr_locality;
															#line 784 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( auto w : workers ) {
															#line 785 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			addr_locality[w.address] = w.locality;
															#line 7324 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 788 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::set<Optional<Standalone<StringRef>>> checkDuplicates;
															#line 789 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& addr : oldCoordinators ) {
															#line 790 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			auto findResult = addr_locality.find(addr);
															#line 791 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (findResult != addr_locality.end())
															#line 7334 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 792 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (checkDuplicates.contains(findResult->second.zoneId()))
															#line 7338 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 793 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					TraceEvent("ConsistencyCheck_BadCoordinator") .detail("Addr", addr) .detail("NotFound", findResult == addr_locality.end());
															#line 796 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 7344 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
					new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(false);
					this->~CheckCoordinatorsActorState();
					static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 798 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				checkDuplicates.insert(findResult->second.zoneId());
															#line 7352 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
		}
															#line 802 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckCoordinatorsActorState(); static_cast<CheckCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 7357 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckCoordinatorsActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckCoordinatorsActorState();
		static_cast<CheckCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(std::vector<ProcessData> const& workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(workers, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(std::vector<ProcessData> && workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCoordinatorsActor*>(this)->ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<CheckCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckCoordinatorsActor*>(this)->ActorCallback< CheckCoordinatorsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckCoordinatorsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckCoordinatorsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 766 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 767 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Transaction tr;
															#line 779 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<NetworkAddress> oldCoordinators;
															#line 7533 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkCoordinators()
															#line 766 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckCoordinatorsActor final : public Actor<bool>, public ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >, public ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >, public ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >, public ActorCallback< CheckCoordinatorsActor, 3, Void >, public FastAllocated<CheckCoordinatorsActor>, public CheckCoordinatorsActorState<CheckCoordinatorsActor> {
															#line 7538 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckCoordinatorsActor>::operator new;
	using FastAllocated<CheckCoordinatorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4177205906785393408UL, 1214467525923021568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >;
friend struct ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >;
friend struct ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >;
friend struct ActorCallback< CheckCoordinatorsActor, 3, Void >;
															#line 766 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckCoordinatorsActor(Database const& cx) 
															#line 7558 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckCoordinatorsActorState<CheckCoordinatorsActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkCoordinators", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4936341211804007168UL, 10483879935152264448UL);
		ActorExecutionContextHelper __helper(static_cast<CheckCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkCoordinators");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkCoordinators", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckCoordinatorsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckCoordinatorsActor, 1, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckCoordinatorsActor, 2, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckCoordinatorsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 766 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkCoordinators( Database const& cx ) {
															#line 766 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckCoordinatorsActor(cx));
															#line 7593 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 808 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// Returns true if all machines in the cluster that specified a desired class are operating in that class
																#line 7599 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkUsingDesiredClasses()
															#line 810 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckUsingDesiredClassesActor>
															#line 810 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckUsingDesiredClassesActorState {
															#line 7605 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 810 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckUsingDesiredClassesActorState(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 810 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 810 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx),
															#line 810 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   self(self),
															#line 811 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   expectedPrimaryDcId(),
															#line 812 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		   expectedRemoteDcId()
															#line 7618 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this));

	}
	~CheckUsingDesiredClassesActorState() 
	{
		fdb_probe_actor_destroy("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 813 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(cx);
															#line 813 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7635 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 1;
															#line 813 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >*>(static_cast<CheckUsingDesiredClassesActor*>(this)));
															#line 7640 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckUsingDesiredClassesActorState();
		static_cast<CheckUsingDesiredClassesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 814 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_1 = getWorkers(self->dbInfo);
															#line 814 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7665 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 2;
															#line 814 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >*>(static_cast<CheckUsingDesiredClassesActor*>(this)));
															#line 7670 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration const& __config,int loopDepth) 
	{
															#line 813 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		config = __config;
															#line 7679 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state > 0) static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckUsingDesiredClassesActor*>(this)->ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 815 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_2 = getWorkers(self->dbInfo, GetWorkersRequest::NON_EXCLUDED_PROCESSES_ONLY);
															#line 815 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7760 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 3;
															#line 815 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >*>(static_cast<CheckUsingDesiredClassesActor*>(this)));
															#line 7765 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<WorkerDetails> const& __allWorkers,int loopDepth) 
	{
															#line 814 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		allWorkers = __allWorkers;
															#line 7774 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<WorkerDetails> && __allWorkers,int loopDepth) 
	{
		allWorkers = std::move(__allWorkers);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state > 0) static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckUsingDesiredClassesActor*>(this)->ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 817 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		auto& db = self->dbInfo->get();
															#line 819 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<NetworkAddress, WorkerDetails> allWorkerProcessMap;
															#line 820 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<Optional<Key>, std::vector<ProcessClass::ClassType>> dcToAllClassTypes;
															#line 821 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& worker : allWorkers ) {
															#line 822 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			allWorkerProcessMap[worker.interf.address()] = worker;
															#line 823 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			Optional<Key> dc = worker.interf.locality.dcId();
															#line 824 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!dcToAllClassTypes.contains(dc))
															#line 7865 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 825 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				dcToAllClassTypes.insert({});
															#line 7869 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 826 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			dcToAllClassTypes[dc].push_back(worker.processClass.classType());
															#line 7873 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 829 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<NetworkAddress, WorkerDetails> nonExcludedWorkerProcessMap;
															#line 830 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		std::map<Optional<Key>, std::vector<ProcessClass::ClassType>> dcToNonExcludedClassTypes;
															#line 831 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& worker : nonExcludedWorkers ) {
															#line 832 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			nonExcludedWorkerProcessMap[worker.interf.address()] = worker;
															#line 833 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			Optional<Key> dc = worker.interf.locality.dcId();
															#line 834 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!dcToNonExcludedClassTypes.contains(dc))
															#line 7887 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 835 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				dcToNonExcludedClassTypes.insert({});
															#line 7891 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 836 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			dcToNonExcludedClassTypes[dc].push_back(worker.processClass.classType());
															#line 7895 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		}
															#line 839 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!allWorkerProcessMap.contains(db.clusterInterface.clientInterface.address()))
															#line 7899 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 840 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_CCNotInWorkerList") .detail("CCAddress", db.clusterInterface.clientInterface.address().toString());
															#line 842 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 7905 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 844 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!allWorkerProcessMap.contains(db.master.address()))
															#line 7913 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 845 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_MasterNotInWorkerList") .detail("MasterAddress", db.master.address().toString());
															#line 847 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 7919 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 850 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		Optional<Key> ccDcId = allWorkerProcessMap[db.clusterInterface.clientInterface.address()].interf.locality.dcId();
															#line 852 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		Optional<Key> masterDcId = allWorkerProcessMap[db.master.address()].interf.locality.dcId();
															#line 854 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (ccDcId != masterDcId)
															#line 7931 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 855 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_CCAndMasterNotInSameDC") .detail("ClusterControllerDcId", getOptionalString(ccDcId)) .detail("MasterDcId", getOptionalString(masterDcId));
															#line 858 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 7937 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 863 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (g_network->isSimulated() && config.usableRegions > 1 && g_simulator->primaryDcId.present() && !g_simulator->datacenterDead(g_simulator->primaryDcId) && !g_simulator->datacenterDead(g_simulator->remoteDcId))
															#line 7945 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 866 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			expectedPrimaryDcId = config.regions[0].dcId;
															#line 867 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			expectedRemoteDcId = config.regions[1].dcId;
															#line 869 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (config.regions[0].priority == config.regions[1].priority)
															#line 7953 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 870 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				expectedPrimaryDcId = masterDcId;
															#line 871 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				expectedRemoteDcId = config.regions[0].dcId == expectedPrimaryDcId.get() ? config.regions[1].dcId : config.regions[0].dcId;
															#line 7959 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
															#line 875 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (ccDcId != expectedPrimaryDcId)
															#line 7963 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 876 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_ClusterControllerDcNotBest") .detail("PreferredDcId", getOptionalString(expectedPrimaryDcId)) .detail("ExistingDcId", getOptionalString(ccDcId));
															#line 879 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 7969 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckUsingDesiredClassesActorState();
				static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 881 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (masterDcId != expectedPrimaryDcId)
															#line 7977 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 882 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_MasterDcNotBest") .detail("PreferredDcId", getOptionalString(expectedPrimaryDcId)) .detail("ExistingDcId", getOptionalString(masterDcId));
															#line 885 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 7983 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckUsingDesiredClassesActorState();
				static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 890 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness bestClusterControllerFitness = getBestAvailableFitness(dcToNonExcludedClassTypes[ccDcId], ProcessClass::ClusterController);
															#line 892 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!nonExcludedWorkerProcessMap.contains(db.clusterInterface.clientInterface.address()) || nonExcludedWorkerProcessMap[db.clusterInterface.clientInterface.address()].processClass.machineClassFitness( ProcessClass::ClusterController) != bestClusterControllerFitness)
															#line 7994 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 895 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ClusterControllerNotBest") .detail("BestClusterControllerFitness", bestClusterControllerFitness) .detail("ExistingClusterControllerFit", nonExcludedWorkerProcessMap.contains(db.clusterInterface.clientInterface.address()) ? nonExcludedWorkerProcessMap[db.clusterInterface.clientInterface.address()] .processClass.machineClassFitness(ProcessClass::ClusterController) : -1);
															#line 902 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 8000 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 906 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness bestMasterFitness = getBestAvailableFitness(dcToNonExcludedClassTypes[masterDcId], ProcessClass::Master);
															#line 908 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (bestMasterFitness == ProcessClass::NeverAssign)
															#line 8010 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 909 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			bestMasterFitness = getBestAvailableFitness(dcToAllClassTypes[masterDcId], ProcessClass::Master);
															#line 910 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (bestMasterFitness != ProcessClass::NeverAssign)
															#line 8016 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 911 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				bestMasterFitness = ProcessClass::ExcludeFit;
															#line 8020 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			}
		}
															#line 915 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if ((!nonExcludedWorkerProcessMap.contains(db.master.address()) && bestMasterFitness != ProcessClass::ExcludeFit) || nonExcludedWorkerProcessMap[db.master.address()].processClass.machineClassFitness(ProcessClass::Master) != bestMasterFitness)
															#line 8025 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 919 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_MasterNotBest") .detail("BestMasterFitness", bestMasterFitness) .detail("ExistingMasterFit", nonExcludedWorkerProcessMap.contains(db.master.address()) ? nonExcludedWorkerProcessMap[db.master.address()].processClass.machineClassFitness( ProcessClass::Master) : -1);
															#line 926 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 8031 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 930 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness bestCommitProxyFitness = getBestAvailableFitness(dcToNonExcludedClassTypes[masterDcId], ProcessClass::CommitProxy);
															#line 932 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& commitProxy : db.client.commitProxies ) {
															#line 933 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!nonExcludedWorkerProcessMap.contains(commitProxy.address()) || nonExcludedWorkerProcessMap[commitProxy.address()].processClass.machineClassFitness( ProcessClass::CommitProxy) != bestCommitProxyFitness)
															#line 8043 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 936 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_CommitProxyNotBest") .detail("BestCommitProxyFitness", bestCommitProxyFitness) .detail("ExistingCommitProxyFitness", nonExcludedWorkerProcessMap.contains(commitProxy.address()) ? nonExcludedWorkerProcessMap[commitProxy.address()].processClass.machineClassFitness( ProcessClass::CommitProxy) : -1);
															#line 943 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 8049 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckUsingDesiredClassesActorState();
				static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 948 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness bestGrvProxyFitness = getBestAvailableFitness(dcToNonExcludedClassTypes[masterDcId], ProcessClass::GrvProxy);
															#line 950 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& grvProxy : db.client.grvProxies ) {
															#line 951 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!nonExcludedWorkerProcessMap.contains(grvProxy.address()) || nonExcludedWorkerProcessMap[grvProxy.address()].processClass.machineClassFitness( ProcessClass::GrvProxy) != bestGrvProxyFitness)
															#line 8062 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 954 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_GrvProxyNotBest") .detail("BestGrvProxyFitness", bestGrvProxyFitness) .detail("ExistingGrvProxyFitness", nonExcludedWorkerProcessMap.contains(grvProxy.address()) ? nonExcludedWorkerProcessMap[grvProxy.address()].processClass.machineClassFitness( ProcessClass::GrvProxy) : -1);
															#line 961 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 8068 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckUsingDesiredClassesActorState();
				static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 966 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness bestResolverFitness = getBestAvailableFitness(dcToNonExcludedClassTypes[masterDcId], ProcessClass::Resolver);
															#line 968 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		for( const auto& resolver : db.resolvers ) {
															#line 969 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!nonExcludedWorkerProcessMap.contains(resolver.address()) || nonExcludedWorkerProcessMap[resolver.address()].processClass.machineClassFitness( ProcessClass::Resolver) != bestResolverFitness)
															#line 8081 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 972 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				TraceEvent("ConsistencyCheck_ResolverNotBest") .detail("BestResolverFitness", bestResolverFitness) .detail("ExistingResolverFitness", nonExcludedWorkerProcessMap.contains(resolver.address()) ? nonExcludedWorkerProcessMap[resolver.address()].processClass.machineClassFitness( ProcessClass::Resolver) : -1);
															#line 979 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 8087 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckUsingDesiredClassesActorState();
				static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 984 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (g_network->isSimulated() && config.usableRegions > 1 && g_simulator->primaryDcId.present() && !g_simulator->datacenterDead(g_simulator->primaryDcId) && !g_simulator->datacenterDead(g_simulator->remoteDcId))
															#line 8096 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 987 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			for( auto& tlogSet : db.logSystemConfig.tLogs ) {
															#line 988 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!tlogSet.isLocal && tlogSet.logRouters.size())
															#line 8102 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				{
															#line 989 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
					for( auto& logRouter : tlogSet.logRouters ) {
															#line 990 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (!nonExcludedWorkerProcessMap.contains(logRouter.interf().address()))
															#line 8108 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						{
															#line 991 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							TraceEvent("ConsistencyCheck_LogRouterNotInNonExcludedWorkers") .detail("Id", logRouter.id());
															#line 993 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 8114 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
							new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckUsingDesiredClassesActorState();
							static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 995 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
						if (logRouter.interf().filteredLocality.dcId() != expectedRemoteDcId)
															#line 8122 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
						{
															#line 996 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							TraceEvent("ConsistencyCheck_LogRouterNotBestDC") .detail("expectedDC", getOptionalString(expectedRemoteDcId)) .detail("ActualDC", getOptionalString(logRouter.interf().filteredLocality.dcId()));
															#line 999 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
							if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 8128 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
							new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
							this->~CheckUsingDesiredClassesActorState();
							static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
					}
				}
			}
		}
															#line 1007 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		ProcessClass::Fitness fitnessLowerBound = allWorkerProcessMap[db.master.address()].processClass.machineClassFitness(ProcessClass::DataDistributor);
															#line 1009 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (db.distributor.present() && (!nonExcludedWorkerProcessMap.contains(db.distributor.get().address()) || nonExcludedWorkerProcessMap[db.distributor.get().address()].processClass.machineClassFitness( ProcessClass::DataDistributor) > fitnessLowerBound))
															#line 8142 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1013 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_DistributorNotBest") .detail("DataDistributorFitnessLowerBound", fitnessLowerBound) .detail( "ExistingDistributorFitness", nonExcludedWorkerProcessMap.contains(db.distributor.get().address()) ? nonExcludedWorkerProcessMap[db.distributor.get().address()].processClass.machineClassFitness( ProcessClass::DataDistributor) : -1);
															#line 1021 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 8148 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1025 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (db.ratekeeper.present() && (!nonExcludedWorkerProcessMap.contains(db.ratekeeper.get().address()) || nonExcludedWorkerProcessMap[db.ratekeeper.get().address()].processClass.machineClassFitness( ProcessClass::Ratekeeper) > fitnessLowerBound))
															#line 8156 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1029 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_RatekeeperNotBest") .detail("BestRatekeeperFitness", fitnessLowerBound) .detail( "ExistingRatekeeperFitness", nonExcludedWorkerProcessMap.contains(db.ratekeeper.get().address()) ? nonExcludedWorkerProcessMap[db.ratekeeper.get().address()].processClass.machineClassFitness( ProcessClass::Ratekeeper) : -1);
															#line 1037 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 8162 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1041 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (config.encryptionAtRestMode.isEncryptionEnabled() && db.client.encryptKeyProxy.present() && (!nonExcludedWorkerProcessMap.contains(db.client.encryptKeyProxy.get().address()) || nonExcludedWorkerProcessMap[db.client.encryptKeyProxy.get().address()].processClass.machineClassFitness( ProcessClass::EncryptKeyProxy) > fitnessLowerBound))
															#line 8170 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1045 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_EncryptKeyProxyNotBest") .detail("BestEncryptKeyProxyFitness", fitnessLowerBound) .detail("ExistingEncryptKeyProxyFitness", nonExcludedWorkerProcessMap.contains(db.client.encryptKeyProxy.get().address()) ? nonExcludedWorkerProcessMap[db.client.encryptKeyProxy.get().address()] .processClass.machineClassFitness(ProcessClass::EncryptKeyProxy) : -1);
															#line 1052 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 8176 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1056 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (db.consistencyScan.present() && (!nonExcludedWorkerProcessMap.contains(db.consistencyScan.get().address()) || nonExcludedWorkerProcessMap[db.consistencyScan.get().address()].processClass.machineClassFitness( ProcessClass::ConsistencyScan) > fitnessLowerBound))
															#line 8184 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		{
															#line 1060 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			TraceEvent("ConsistencyCheck_ConsistencyScanNotBest") .detail("BestConsistencyScanFitness", fitnessLowerBound) .detail("ExistingConsistencyScanFitness", nonExcludedWorkerProcessMap.contains(db.consistencyScan.get().address()) ? nonExcludedWorkerProcessMap[db.consistencyScan.get().address()] .processClass.machineClassFitness(ProcessClass::ConsistencyScan) : -1);
															#line 1067 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 8190 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckUsingDesiredClassesActorState();
			static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1072 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckUsingDesiredClassesActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckUsingDesiredClassesActorState(); static_cast<CheckUsingDesiredClassesActor*>(this)->destroy(); return 0; }
															#line 8198 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckUsingDesiredClassesActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckUsingDesiredClassesActorState();
		static_cast<CheckUsingDesiredClassesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<WorkerDetails> const& __nonExcludedWorkers,int loopDepth) 
	{
															#line 815 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		nonExcludedWorkers = __nonExcludedWorkers;
															#line 8210 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<WorkerDetails> && __nonExcludedWorkers,int loopDepth) 
	{
		nonExcludedWorkers = std::move(__nonExcludedWorkers);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state > 0) static_cast<CheckUsingDesiredClassesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckUsingDesiredClassesActor*>(this)->ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 810 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 810 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyCheckWorkload* self;
															#line 811 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Optional<Key> expectedPrimaryDcId;
															#line 812 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Optional<Key> expectedRemoteDcId;
															#line 813 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	DatabaseConfiguration config;
															#line 814 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerDetails> allWorkers;
															#line 815 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	std::vector<WorkerDetails> nonExcludedWorkers;
															#line 8299 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkUsingDesiredClasses()
															#line 810 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckUsingDesiredClassesActor final : public Actor<bool>, public ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >, public ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >, public ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >, public FastAllocated<CheckUsingDesiredClassesActor>, public CheckUsingDesiredClassesActorState<CheckUsingDesiredClassesActor> {
															#line 8304 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckUsingDesiredClassesActor>::operator new;
	using FastAllocated<CheckUsingDesiredClassesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6576661497139645696UL, 16997200475906331648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >;
friend struct ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >;
															#line 810 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckUsingDesiredClassesActor(Database const& cx,ConsistencyCheckWorkload* const& self) 
															#line 8323 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckUsingDesiredClassesActorState<CheckUsingDesiredClassesActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16621575950694749952UL, 13688324977771477760UL);
		ActorExecutionContextHelper __helper(static_cast<CheckUsingDesiredClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkUsingDesiredClasses");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkUsingDesiredClasses", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckUsingDesiredClassesActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckUsingDesiredClassesActor, 1, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckUsingDesiredClassesActor, 2, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 810 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkUsingDesiredClasses( Database const& cx, ConsistencyCheckWorkload* const& self ) {
															#line 810 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckUsingDesiredClassesActor(cx, self));
															#line 8357 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1074 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	// returns true if stopped, false otherwise
																#line 8363 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
// This generated class is to be used only via checkConsistencyScan()
															#line 1076 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
template <class CheckConsistencyScanActor>
															#line 1076 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckConsistencyScanActorState {
															#line 8369 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
															#line 1076 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckConsistencyScanActorState(Database const& cx) 
															#line 1076 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
															#line 1076 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		 : cx(cx)
															#line 8376 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
	{
		fdb_probe_actor_create("checkConsistencyScan", reinterpret_cast<unsigned long>(this));

	}
	~CheckConsistencyScanActorState() 
	{
		fdb_probe_actor_destroy("checkConsistencyScan", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1077 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (!g_network->isSimulated())
															#line 8391 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			{
															#line 1078 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
				if (!static_cast<CheckConsistencyScanActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckConsistencyScanActorState(); static_cast<CheckConsistencyScanActor*>(this)->destroy(); return 0; }
															#line 8395 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
				new (&static_cast<CheckConsistencyScanActor*>(this)->SAV< bool >::value()) bool(true);
				this->~CheckConsistencyScanActorState();
				static_cast<CheckConsistencyScanActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1080 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 1081 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			cs = ConsistencyScanState();
															#line 1082 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			;
															#line 8407 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckConsistencyScanActorState();
		static_cast<CheckConsistencyScanActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1084 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			SystemDBWriteLockedNow(cx.getReference())->setOptions(tr);
															#line 1085 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<ConsistencyScanState::Config> __when_expr_0 = cs.config().getD(tr);
															#line 1085 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8442 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state = 1;
															#line 1085 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >*>(static_cast<CheckConsistencyScanActor*>(this)));
															#line 8447 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1088 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 1088 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			if (static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8471 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state = 2;
															#line 1088 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckConsistencyScanActor, 1, Void >*>(static_cast<CheckConsistencyScanActor*>(this)));
															#line 8476 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(ConsistencyScanState::Config const& config,int loopDepth) 
	{
															#line 1086 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckConsistencyScanActor*>(this)->SAV<bool>::futures) { (void)(!config.enabled); this->~CheckConsistencyScanActorState(); static_cast<CheckConsistencyScanActor*>(this)->destroy(); return 0; }
															#line 8491 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckConsistencyScanActor*>(this)->SAV< bool >::value()) bool(!config.enabled);
		this->~CheckConsistencyScanActorState();
		static_cast<CheckConsistencyScanActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(ConsistencyScanState::Config && config,int loopDepth) 
	{
															#line 1086 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
		if (!static_cast<CheckConsistencyScanActor*>(this)->SAV<bool>::futures) { (void)(!config.enabled); this->~CheckConsistencyScanActorState(); static_cast<CheckConsistencyScanActor*>(this)->destroy(); return 0; }
															#line 8503 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		new (&static_cast<CheckConsistencyScanActor*>(this)->SAV< bool >::value()) bool(!config.enabled);
		this->~CheckConsistencyScanActorState();
		static_cast<CheckConsistencyScanActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ConsistencyScanState::Config const& config,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(config, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ConsistencyScanState::Config && config,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(config), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state > 0) static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state = 0;
		static_cast<CheckConsistencyScanActor*>(this)->ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >::remove();

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >*,ConsistencyScanState::Config const& value) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >*,ConsistencyScanState::Config && value) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >*,Error err) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state > 0) static_cast<CheckConsistencyScanActor*>(this)->actor_wait_state = 0;
		static_cast<CheckConsistencyScanActor*>(this)->ActorCallback< CheckConsistencyScanActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckConsistencyScanActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1076 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Database cx;
															#line 1080 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1081 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	ConsistencyScanState cs;
															#line 8679 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
};
// This generated class is to be used only via checkConsistencyScan()
															#line 1076 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
class CheckConsistencyScanActor final : public Actor<bool>, public ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >, public ActorCallback< CheckConsistencyScanActor, 1, Void >, public FastAllocated<CheckConsistencyScanActor>, public CheckConsistencyScanActorState<CheckConsistencyScanActor> {
															#line 8684 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
public:
	using FastAllocated<CheckConsistencyScanActor>::operator new;
	using FastAllocated<CheckConsistencyScanActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16267630167122983936UL, 10669917072898460416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >;
friend struct ActorCallback< CheckConsistencyScanActor, 1, Void >;
															#line 1076 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	CheckConsistencyScanActor(Database const& cx) 
															#line 8702 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
		 : Actor<bool>(),
		   CheckConsistencyScanActorState<CheckConsistencyScanActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkConsistencyScan", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13688259443744744960UL, 983808638632960256UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkConsistencyScan");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkConsistencyScan", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckConsistencyScanActor, 0, ConsistencyScanState::Config >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckConsistencyScanActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1076 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
[[nodiscard]] Future<bool> checkConsistencyScan( Database const& cx ) {
															#line 1076 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"
	return Future<bool>(new CheckConsistencyScanActor(cx));
															#line 8735 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConsistencyCheck.actor.g.cpp"
}

#line 1092 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/ConsistencyCheck.actor.cpp"

	bool checkSingleSingleton(std::vector<ISimulator::ProcessInfo*> const& allProcesses,
	                          TraceEvent& ev,
	                          std::string const& role,
	                          int expectedCount) {
		// FIXME: this doesn't actually check that there aren't multiple of the same role running on the same process
		// either
		int count = 0;
		for (int i = 0; i < allProcesses.size(); i++) {
			if (g_simulator->hasRole(allProcesses[i]->address, role)) {
				count++;
				ev.detail(role + std::to_string(count), allProcesses[i]->address.toString());
			}
		}
		ev.detail(role + "Count", count).detail(role + "ExpectedCount", expectedCount);
		if (count != expectedCount) {
			fmt::print("ConsistencyCheck failure: incorrect number {0} of singleton {1} running (expected {2})\n",
			           count,
			           role,
			           expectedCount);
		}
		return count == expectedCount;
	}

	// checks that there is only one instance of each singleton running in the cluster in simulation
	bool checkSingleSingletons(ConsistencyCheckWorkload* self, DatabaseConfiguration config) {
		if (!g_network->isSimulated()) {
			return true;
		}

		CODE_PROBE(self->performQuiescentChecks, "Checking for single singletons");

		std::vector<ISimulator::ProcessInfo*> allProcesses = g_simulator->getAllProcesses();

		bool success = true;
		TraceEvent ev("CheckSingletons");

		success &= self->checkSingleSingleton(allProcesses, ev, "Ratekeeper", 1);
		success &= self->checkSingleSingleton(allProcesses, ev, "DataDistributor", 1);
		success &= self->checkSingleSingleton(allProcesses, ev, "ConsistencyScan", 1);

		success &= self->checkSingleSingleton(
		    allProcesses,
		    ev,
		    "EncryptKeyProxy",
		    config.encryptionAtRestMode.isEncryptionEnabled() || SERVER_KNOBS->ENABLE_REST_KMS_COMMUNICATION ? 1 : 0);

		if (!success) {
			// TODO REMOVE
			fmt::print("ConsistencyCheck singletons: roles map:\n");
			for (int i = 0; i < allProcesses.size(); i++) {
				fmt::print(
				    "{0}: {1}\n", allProcesses[i]->address.toString(), g_simulator->getRoles(allProcesses[i]->address));
			}
		}

		return success;
	}
};

WorkloadFactory<ConsistencyCheckWorkload> ConsistencyCheckWorkloadFactory;
