#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
/*
 * AtomicOps.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// #define SevAtomicOpDebug SevInfo
#define SevAtomicOpDebug SevVerbose

struct AtomicOpsWorkload : TestWorkload {
	static constexpr auto NAME = "AtomicOps";
	int opNum, actorCount, nodeCount;
	uint32_t opType;
	bool apiVersion500 = false;

	double testDuration, transactionsPerSecond;
	std::vector<Future<Void>> clients;
	uint64_t lbsum, ubsum; // The lower bound and upper bound sum of operations when opType = AddValue

	AtomicOpsWorkload(WorkloadContext const& wcx) : TestWorkload(wcx), opNum(0) {
		testDuration = getOption(options, "testDuration"_sr, 600.0);
		transactionsPerSecond = getOption(options, "transactionsPerSecond"_sr, 5000.0) / clientCount;
		actorCount = getOption(options, "actorsPerClient"_sr, transactionsPerSecond / 5);
		opType = getOption(options, "opType"_sr, -1);
		nodeCount = getOption(options, "nodeCount"_sr, 1000);
		// Atomic OPs Min and And have modified behavior from api version 510. Hence allowing testing for older version
		// (500) with a 10% probability Actual change of api Version happens in setup
		apiVersion500 = ((sharedRandomNumber % 10) == 0);
		TraceEvent("AtomicOpsApiVersion500").detail("ApiVersion500", apiVersion500);

		lbsum = 0;
		ubsum = 0;

		int64_t randNum = sharedRandomNumber / 10;
		if (opType == -1)
			opType = randNum % 10;

		switch (opType) {
		case 0:
			CODE_PROBE(true, "Testing atomic AddValue");
			opType = MutationRef::AddValue;
			break;
		case 1:
			CODE_PROBE(true, "Testing atomic And");
			opType = MutationRef::And;
			break;
		case 2:
			CODE_PROBE(true, "Testing atomic Or");
			opType = MutationRef::Or;
			break;
		case 3:
			CODE_PROBE(true, "Testing atomic Xor");
			opType = MutationRef::Xor;
			break;
		case 4:
			CODE_PROBE(true, "Testing atomic Max");
			opType = MutationRef::Max;
			break;
		case 5:
			CODE_PROBE(true, "Testing atomic Min");
			opType = MutationRef::Min;
			break;
		case 6:
			CODE_PROBE(true, "Testing atomic ByteMin");
			opType = MutationRef::ByteMin;
			break;
		case 7:
			CODE_PROBE(true, "Testing atomic ByteMax");
			opType = MutationRef::ByteMax;
			break;
		case 8:
			CODE_PROBE(true, "Testing atomic MinV2");
			opType = MutationRef::MinV2;
			break;
		case 9:
			CODE_PROBE(true, "Testing atomic AndV2");
			opType = MutationRef::AndV2;
			break;
		// case 10:
		// 	CODE_PROBE(true, "Testing atomic CompareAndClear Not supported yet");
		// 	opType = MutationRef::CompareAndClear
		//  break;
		default:
			ASSERT(false);
		}
		TraceEvent("AtomicWorkload").detail("OpType", opType);
	}

	Future<Void> setup(Database const& cx) override {
		if (apiVersion500)
			cx->apiVersion = ApiVersion(500);

		if (clientId != 0)
			return Void();
		return _setup(cx, this);
	}

	Future<Void> start(Database const& cx) override {
		for (int c = 0; c < actorCount; c++) {
			clients.push_back(
			    timeout(atomicOpWorker(cx->clone(), this, actorCount / transactionsPerSecond), testDuration, Void()));
		}

		return delay(testDuration);
	}

	Future<bool> check(Database const& cx) override {
		if (clientId != 0)
			return true;
		return _check(cx, this);
	}

	void getMetrics(std::vector<PerfMetric>& m) override {}

	std::pair<Key, Key> logDebugKey(int group) {
		Key logKey(format("log%08x%08x%08x", group, clientId, opNum));
		Key debugKey(format("debug%08x%08x%08x", group, clientId, opNum));
		opNum++;
		return std::make_pair(logKey, debugKey);
	}

																#line 145 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 143 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
template <class _setupActor>
															#line 143 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
class _setupActorState {
															#line 151 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
public:
															#line 143 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	_setupActorState(Database const& cx,AtomicOpsWorkload* const& self) 
															#line 143 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
															#line 143 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		 : cx(cx),
															#line 143 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   self(self),
															#line 145 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   tr1(cx)
															#line 162 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 146 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			;
															#line 177 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 166 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		g = 0;
															#line 167 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		;
															#line 202 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 148 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			Key begin(std::string("log"));
															#line 149 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr1.getRange(KeyRangeRef(begin, strinc(begin)), CLIENT_KNOBS->TOO_MANY);
															#line 149 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 223 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 149 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, RangeResult >*>(static_cast<_setupActor*>(this)));
															#line 228 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 162 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr1.onError(e);
															#line 162 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 265 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 162 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 270 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& log,int loopDepth) 
	{
															#line 150 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (!log.empty())
															#line 285 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 151 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent(SevError, "AtomicOpSetup") .detail("LogKeySpace", "Not empty") .detail("Result", log.toString());
															#line 154 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			for( auto& kv : log ) {
															#line 155 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				TraceEvent(SevWarn, "AtomicOpSetup") .detail("K", kv.key.toString()) .detail("V", kv.value.toString());
															#line 293 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			}
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && log,int loopDepth) 
	{
															#line 150 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (!log.empty())
															#line 304 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 151 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent(SevError, "AtomicOpSetup") .detail("LogKeySpace", "Not empty") .detail("Result", log.toString());
															#line 154 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			for( auto& kv : log ) {
															#line 155 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				TraceEvent(SevWarn, "AtomicOpSetup") .detail("K", kv.key.toString()) .detail("V", kv.value.toString());
															#line 312 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			}
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& log,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(log, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && log,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(log), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 183 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 485 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 167 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (!(g < 100))
															#line 504 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 168 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 169 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		;
															#line 512 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 167 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		g++;
															#line 534 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 171 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			for(int i = 0;i < self->nodeCount / 100;i++) {
															#line 172 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				uint64_t intValue = 0;
															#line 173 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				tr.set(StringRef(format("ops%08x%08x", g, i)), StringRef((const uint8_t*)&intValue, sizeof(intValue)));
															#line 555 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			}
															#line 176 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 176 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 561 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 176 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 566 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 179 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 179 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 603 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 4;
															#line 179 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 3, Void >*>(static_cast<_setupActor*>(this)));
															#line 608 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _setupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _setupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _setupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 143 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	Database cx;
															#line 143 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	AtomicOpsWorkload* self;
															#line 145 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	ReadYourWritesTransaction tr1;
															#line 166 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	int g;
															#line 168 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 803 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 143 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, RangeResult >, public ActorCallback< _setupActor, 1, Void >, public ActorCallback< _setupActor, 2, Void >, public ActorCallback< _setupActor, 3, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 808 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(871984312414653952UL, 8856858075153000192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, RangeResult >;
friend struct ActorCallback< _setupActor, 1, Void >;
friend struct ActorCallback< _setupActor, 2, Void >;
friend struct ActorCallback< _setupActor, 3, Void >;
															#line 143 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	_setupActor(Database const& cx,AtomicOpsWorkload* const& self) 
															#line 828 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _setupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _setupActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 143 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, AtomicOpsWorkload* const& self ) {
															#line 143 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 863 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
}

#line 185 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"

																#line 868 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
// This generated class is to be used only via atomicOpWorker()
															#line 186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
template <class AtomicOpWorkerActor>
															#line 186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
class AtomicOpWorkerActorState {
															#line 874 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
public:
															#line 186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	AtomicOpWorkerActorState(Database const& cx,AtomicOpsWorkload* const& self,double const& delay) 
															#line 186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
															#line 186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		 : cx(cx),
															#line 186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   self(self),
															#line 186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   delay(delay),
															#line 187 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   lastTime(now())
															#line 887 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
	{
		fdb_probe_actor_create("atomicOpWorker", reinterpret_cast<unsigned long>(this));

	}
	~AtomicOpWorkerActorState() 
	{
		fdb_probe_actor_destroy("atomicOpWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 188 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			;
															#line 902 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AtomicOpWorkerActorState();
		static_cast<AtomicOpWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 189 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, delay);
															#line 189 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (static_cast<AtomicOpWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 934 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<AtomicOpWorkerActor*>(this)->actor_wait_state = 1;
															#line 189 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AtomicOpWorkerActor, 0, Void >*>(static_cast<AtomicOpWorkerActor*>(this)));
															#line 939 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 190 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 191 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		;
															#line 950 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 190 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 191 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		;
															#line 961 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AtomicOpWorkerActor*>(this)->actor_wait_state > 0) static_cast<AtomicOpWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<AtomicOpWorkerActor*>(this)->ActorCallback< AtomicOpWorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AtomicOpWorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("atomicOpWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AtomicOpWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("atomicOpWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AtomicOpWorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("atomicOpWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AtomicOpWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("atomicOpWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AtomicOpWorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("atomicOpWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AtomicOpWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("atomicOpWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 192 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		int group = deterministicRandom()->randomInt(0, 100);
															#line 193 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		intValue = deterministicRandom()->randomInt(0, 10000000);
															#line 194 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		val = StringRef((const uint8_t*)&intValue, sizeof(intValue));
															#line 195 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		logDebugKey = self->logDebugKey(group);
															#line 196 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		int nodeIndex = deterministicRandom()->randomInt(0, self->nodeCount / 100);
															#line 197 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		opsKey = Key(format("ops%08x%08x", group, nodeIndex));
															#line 1068 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		try {
															#line 199 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			tr.set(logDebugKey.first, val);
															#line 200 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			tr.set(logDebugKey.second, opsKey);
															#line 201 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			tr.atomicOp(opsKey, val, self->opType);
															#line 202 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 202 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (static_cast<AtomicOpWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1080 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<AtomicOpWorkerActor*>(this)->actor_wait_state = 2;
															#line 202 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AtomicOpWorkerActor, 1, Void >*>(static_cast<AtomicOpWorkerActor*>(this)));
															#line 1085 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 213 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (e.code() == 1021)
															#line 1120 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			{
															#line 214 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				self->ubsum += intValue;
															#line 215 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				TraceEvent(SevInfo, "TxnCommitUnknownResult") .detail("Value", intValue) .detail("LogKey", logDebugKey.first) .detail("OpsKey", opsKey);
															#line 1126 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			}
															#line 220 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 220 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (static_cast<AtomicOpWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1132 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<AtomicOpWorkerActor*>(this)->actor_wait_state = 3;
															#line 220 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AtomicOpWorkerActor, 2, Void >*>(static_cast<AtomicOpWorkerActor*>(this)));
															#line 1137 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 203 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		TraceEvent(SevAtomicOpDebug, "AtomicOpWorker") .detail("OpsKey", opsKey) .detail("LogKey", logDebugKey.first) .detail("Value", val.toString());
															#line 207 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (self->opType == MutationRef::AddValue)
															#line 1154 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 208 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			self->lbsum += intValue;
															#line 209 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			self->ubsum += intValue;
															#line 1160 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 203 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		TraceEvent(SevAtomicOpDebug, "AtomicOpWorker") .detail("OpsKey", opsKey) .detail("LogKey", logDebugKey.first) .detail("Value", val.toString());
															#line 207 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (self->opType == MutationRef::AddValue)
															#line 1172 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 208 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			self->lbsum += intValue;
															#line 209 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			self->ubsum += intValue;
															#line 1178 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AtomicOpWorkerActor*>(this)->actor_wait_state > 0) static_cast<AtomicOpWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<AtomicOpWorkerActor*>(this)->ActorCallback< AtomicOpWorkerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AtomicOpWorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("atomicOpWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AtomicOpWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("atomicOpWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AtomicOpWorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("atomicOpWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AtomicOpWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("atomicOpWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AtomicOpWorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("atomicOpWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AtomicOpWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("atomicOpWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AtomicOpWorkerActor*>(this)->actor_wait_state > 0) static_cast<AtomicOpWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<AtomicOpWorkerActor*>(this)->ActorCallback< AtomicOpWorkerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AtomicOpWorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("atomicOpWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AtomicOpWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("atomicOpWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AtomicOpWorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("atomicOpWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AtomicOpWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("atomicOpWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AtomicOpWorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("atomicOpWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AtomicOpWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("atomicOpWorker", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	Database cx;
															#line 186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	AtomicOpsWorkload* self;
															#line 186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	double delay;
															#line 187 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	double lastTime;
															#line 190 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 193 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	uint64_t intValue;
															#line 194 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	Key val;
															#line 195 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	std::pair<Key, Key> logDebugKey;
															#line 197 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	Key opsKey;
															#line 1364 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
};
// This generated class is to be used only via atomicOpWorker()
															#line 186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
class AtomicOpWorkerActor final : public Actor<Void>, public ActorCallback< AtomicOpWorkerActor, 0, Void >, public ActorCallback< AtomicOpWorkerActor, 1, Void >, public ActorCallback< AtomicOpWorkerActor, 2, Void >, public FastAllocated<AtomicOpWorkerActor>, public AtomicOpWorkerActorState<AtomicOpWorkerActor> {
															#line 1369 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
public:
	using FastAllocated<AtomicOpWorkerActor>::operator new;
	using FastAllocated<AtomicOpWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6002733890519896064UL, 490264271901882112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AtomicOpWorkerActor, 0, Void >;
friend struct ActorCallback< AtomicOpWorkerActor, 1, Void >;
friend struct ActorCallback< AtomicOpWorkerActor, 2, Void >;
															#line 186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	AtomicOpWorkerActor(Database const& cx,AtomicOpsWorkload* const& self,double const& delay) 
															#line 1388 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		 : Actor<Void>(),
		   AtomicOpWorkerActorState<AtomicOpWorkerActor>(cx, self, delay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("atomicOpWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13463276061615063552UL, 4293422635989132032UL);
		ActorExecutionContextHelper __helper(static_cast<AtomicOpWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("atomicOpWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("atomicOpWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AtomicOpWorkerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AtomicOpWorkerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AtomicOpWorkerActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
[[nodiscard]] Future<Void> atomicOpWorker( Database const& cx, AtomicOpsWorkload* const& self, double const& delay ) {
															#line 186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	return Future<Void>(new AtomicOpWorkerActor(cx, self, delay));
															#line 1422 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
}

#line 225 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"

																#line 1427 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
// This generated class is to be used only via dumpLogKV()
															#line 226 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
template <class DumpLogKVActor>
															#line 226 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
class DumpLogKVActorState {
															#line 1433 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
public:
															#line 226 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	DumpLogKVActorState(Database const& cx,int const& g) 
															#line 226 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
															#line 226 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		 : cx(cx),
															#line 226 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   g(g),
															#line 227 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   tr(cx)
															#line 1444 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
	{
		fdb_probe_actor_create("dumpLogKV", reinterpret_cast<unsigned long>(this));

	}
	~DumpLogKVActorState() 
	{
		fdb_probe_actor_destroy("dumpLogKV", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 229 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				Key begin(format("log%08x", g));
															#line 230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = tr.getRange(KeyRangeRef(begin, strinc(begin)), CLIENT_KNOBS->TOO_MANY);
															#line 230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				if (static_cast<DumpLogKVActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1464 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DumpLogKVActor*>(this)->actor_wait_state = 1;
															#line 230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DumpLogKVActor, 0, RangeResult >*>(static_cast<DumpLogKVActor*>(this)));
															#line 1469 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DumpLogKVActorState();
		static_cast<DumpLogKVActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 249 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (!static_cast<DumpLogKVActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DumpLogKVActorState(); static_cast<DumpLogKVActor*>(this)->destroy(); return 0; }
															#line 1498 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		new (&static_cast<DumpLogKVActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DumpLogKVActorState();
		static_cast<DumpLogKVActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 246 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent("DumpLogKVError").detail("Error", e.what());
															#line 247 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 247 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (static_cast<DumpLogKVActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1515 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_1.get(), loopDepth); };
			static_cast<DumpLogKVActor*>(this)->actor_wait_state = 2;
															#line 247 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DumpLogKVActor, 1, Void >*>(static_cast<DumpLogKVActor*>(this)));
															#line 1520 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(RangeResult const& log,int loopDepth) 
	{
															#line 231 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (log.more)
															#line 1535 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 232 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent(SevError, "LogHitTxnLimits").detail("Result", log.toString());
															#line 1539 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
															#line 234 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		uint64_t sum = 0;
															#line 235 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : log ) {
															#line 236 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			uint64_t intValue = 0;
															#line 237 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			memcpy(&intValue, kv.value.begin(), kv.value.size());
															#line 238 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			sum += intValue;
															#line 239 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent("AtomicOpLog") .detail("Key", kv.key) .detail("Val", kv.value) .detail("IntValue", intValue) .detail("CurSum", sum);
															#line 1553 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(RangeResult && log,int loopDepth) 
	{
															#line 231 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (log.more)
															#line 1563 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 232 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent(SevError, "LogHitTxnLimits").detail("Result", log.toString());
															#line 1567 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
															#line 234 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		uint64_t sum = 0;
															#line 235 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : log ) {
															#line 236 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			uint64_t intValue = 0;
															#line 237 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			memcpy(&intValue, kv.value.begin(), kv.value.size());
															#line 238 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			sum += intValue;
															#line 239 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent("AtomicOpLog") .detail("Key", kv.key) .detail("Val", kv.value) .detail("IntValue", intValue) .detail("CurSum", sum);
															#line 1581 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult const& log,int loopDepth) 
	{
		loopDepth = a_body1cont2(log, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && log,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(log), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DumpLogKVActor*>(this)->actor_wait_state > 0) static_cast<DumpLogKVActor*>(this)->actor_wait_state = 0;
		static_cast<DumpLogKVActor*>(this)->ActorCallback< DumpLogKVActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< DumpLogKVActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("dumpLogKV", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpLogKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpLogKV", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DumpLogKVActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("dumpLogKV", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpLogKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpLogKV", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DumpLogKVActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("dumpLogKV", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpLogKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpLogKV", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DumpLogKVActor*>(this)->actor_wait_state > 0) static_cast<DumpLogKVActor*>(this)->actor_wait_state = 0;
		static_cast<DumpLogKVActor*>(this)->ActorCallback< DumpLogKVActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpLogKVActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpLogKV", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpLogKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpLogKV", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DumpLogKVActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpLogKV", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpLogKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpLogKV", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DumpLogKVActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpLogKV", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpLogKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpLogKV", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 226 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	Database cx;
															#line 226 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	int g;
															#line 227 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1768 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
};
// This generated class is to be used only via dumpLogKV()
															#line 226 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
class DumpLogKVActor final : public Actor<Void>, public ActorCallback< DumpLogKVActor, 0, RangeResult >, public ActorCallback< DumpLogKVActor, 1, Void >, public FastAllocated<DumpLogKVActor>, public DumpLogKVActorState<DumpLogKVActor> {
															#line 1773 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
public:
	using FastAllocated<DumpLogKVActor>::operator new;
	using FastAllocated<DumpLogKVActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5443535973922267392UL, 7198670565804345856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DumpLogKVActor, 0, RangeResult >;
friend struct ActorCallback< DumpLogKVActor, 1, Void >;
															#line 226 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	DumpLogKVActor(Database const& cx,int const& g) 
															#line 1791 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		 : Actor<Void>(),
		   DumpLogKVActorState<DumpLogKVActor>(cx, g),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dumpLogKV", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11279008082015052800UL, 6958981882005057024UL);
		ActorExecutionContextHelper __helper(static_cast<DumpLogKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dumpLogKV");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dumpLogKV", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DumpLogKVActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DumpLogKVActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 226 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
[[nodiscard]] Future<Void> dumpLogKV( Database const& cx, int const& g ) {
															#line 226 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	return Future<Void>(new DumpLogKVActor(cx, g));
															#line 1824 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
}

#line 251 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"

																#line 1829 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
// This generated class is to be used only via dumpDebugKV()
															#line 252 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
template <class DumpDebugKVActor>
															#line 252 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
class DumpDebugKVActorState {
															#line 1835 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
public:
															#line 252 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	DumpDebugKVActorState(Database const& cx,int const& g) 
															#line 252 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
															#line 252 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		 : cx(cx),
															#line 252 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   g(g),
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   tr(cx)
															#line 1846 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
	{
		fdb_probe_actor_create("dumpDebugKV", reinterpret_cast<unsigned long>(this));

	}
	~DumpDebugKVActorState() 
	{
		fdb_probe_actor_destroy("dumpDebugKV", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 255 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				Key begin(format("debug%08x", g));
															#line 256 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = tr.getRange(KeyRangeRef(begin, strinc(begin)), CLIENT_KNOBS->TOO_MANY);
															#line 256 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				if (static_cast<DumpDebugKVActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1866 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DumpDebugKVActor*>(this)->actor_wait_state = 1;
															#line 256 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DumpDebugKVActor, 0, RangeResult >*>(static_cast<DumpDebugKVActor*>(this)));
															#line 1871 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DumpDebugKVActorState();
		static_cast<DumpDebugKVActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 267 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (!static_cast<DumpDebugKVActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DumpDebugKVActorState(); static_cast<DumpDebugKVActor*>(this)->destroy(); return 0; }
															#line 1900 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		new (&static_cast<DumpDebugKVActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DumpDebugKVActorState();
		static_cast<DumpDebugKVActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 264 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent("DumpDebugKVError").detail("Error", e.what());
															#line 265 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 265 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (static_cast<DumpDebugKVActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1917 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_1.get(), loopDepth); };
			static_cast<DumpDebugKVActor*>(this)->actor_wait_state = 2;
															#line 265 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DumpDebugKVActor, 1, Void >*>(static_cast<DumpDebugKVActor*>(this)));
															#line 1922 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(RangeResult const& debuglog,int loopDepth) 
	{
															#line 257 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (debuglog.more)
															#line 1937 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 258 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent(SevError, "DebugLogHitTxnLimits").detail("Result", debuglog.toString());
															#line 1941 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
															#line 260 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : debuglog ) {
															#line 261 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent("AtomicOpDebug").detail("Key", kv.key).detail("Val", kv.value);
															#line 1947 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(RangeResult && debuglog,int loopDepth) 
	{
															#line 257 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (debuglog.more)
															#line 1957 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 258 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent(SevError, "DebugLogHitTxnLimits").detail("Result", debuglog.toString());
															#line 1961 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
															#line 260 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : debuglog ) {
															#line 261 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent("AtomicOpDebug").detail("Key", kv.key).detail("Val", kv.value);
															#line 1967 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult const& debuglog,int loopDepth) 
	{
		loopDepth = a_body1cont2(debuglog, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && debuglog,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(debuglog), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DumpDebugKVActor*>(this)->actor_wait_state > 0) static_cast<DumpDebugKVActor*>(this)->actor_wait_state = 0;
		static_cast<DumpDebugKVActor*>(this)->ActorCallback< DumpDebugKVActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< DumpDebugKVActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("dumpDebugKV", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDebugKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpDebugKV", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DumpDebugKVActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("dumpDebugKV", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDebugKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpDebugKV", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DumpDebugKVActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("dumpDebugKV", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDebugKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpDebugKV", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DumpDebugKVActor*>(this)->actor_wait_state > 0) static_cast<DumpDebugKVActor*>(this)->actor_wait_state = 0;
		static_cast<DumpDebugKVActor*>(this)->ActorCallback< DumpDebugKVActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpDebugKVActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpDebugKV", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDebugKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpDebugKV", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DumpDebugKVActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpDebugKV", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDebugKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpDebugKV", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DumpDebugKVActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpDebugKV", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDebugKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpDebugKV", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 252 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	Database cx;
															#line 252 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	int g;
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 2154 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
};
// This generated class is to be used only via dumpDebugKV()
															#line 252 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
class DumpDebugKVActor final : public Actor<Void>, public ActorCallback< DumpDebugKVActor, 0, RangeResult >, public ActorCallback< DumpDebugKVActor, 1, Void >, public FastAllocated<DumpDebugKVActor>, public DumpDebugKVActorState<DumpDebugKVActor> {
															#line 2159 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
public:
	using FastAllocated<DumpDebugKVActor>::operator new;
	using FastAllocated<DumpDebugKVActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16476072965614818560UL, 14930895469230114048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DumpDebugKVActor, 0, RangeResult >;
friend struct ActorCallback< DumpDebugKVActor, 1, Void >;
															#line 252 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	DumpDebugKVActor(Database const& cx,int const& g) 
															#line 2177 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		 : Actor<Void>(),
		   DumpDebugKVActorState<DumpDebugKVActor>(cx, g),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dumpDebugKV", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17146638211587407360UL, 3070597481105539072UL);
		ActorExecutionContextHelper __helper(static_cast<DumpDebugKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dumpDebugKV");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dumpDebugKV", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DumpDebugKVActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DumpDebugKVActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 252 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
[[nodiscard]] Future<Void> dumpDebugKV( Database const& cx, int const& g ) {
															#line 252 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	return Future<Void>(new DumpDebugKVActor(cx, g));
															#line 2210 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
}

#line 269 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"

																#line 2215 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
// This generated class is to be used only via dumpOpsKV()
															#line 270 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
template <class DumpOpsKVActor>
															#line 270 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
class DumpOpsKVActorState {
															#line 2221 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
public:
															#line 270 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	DumpOpsKVActorState(Database const& cx,int const& g) 
															#line 270 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
															#line 270 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		 : cx(cx),
															#line 270 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   g(g),
															#line 271 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   tr(cx)
															#line 2232 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
	{
		fdb_probe_actor_create("dumpOpsKV", reinterpret_cast<unsigned long>(this));

	}
	~DumpOpsKVActorState() 
	{
		fdb_probe_actor_destroy("dumpOpsKV", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 273 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				Key begin(format("ops%08x", g));
															#line 274 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = tr.getRange(KeyRangeRef(begin, strinc(begin)), CLIENT_KNOBS->TOO_MANY);
															#line 274 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				if (static_cast<DumpOpsKVActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2252 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DumpOpsKVActor*>(this)->actor_wait_state = 1;
															#line 274 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DumpOpsKVActor, 0, RangeResult >*>(static_cast<DumpOpsKVActor*>(this)));
															#line 2257 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DumpOpsKVActorState();
		static_cast<DumpOpsKVActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 293 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (!static_cast<DumpOpsKVActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DumpOpsKVActorState(); static_cast<DumpOpsKVActor*>(this)->destroy(); return 0; }
															#line 2286 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		new (&static_cast<DumpOpsKVActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DumpOpsKVActorState();
		static_cast<DumpOpsKVActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 290 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent("DumpOpsKVError").detail("Error", e.what());
															#line 291 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 291 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (static_cast<DumpOpsKVActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2303 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_1.get(), loopDepth); };
			static_cast<DumpOpsKVActor*>(this)->actor_wait_state = 2;
															#line 291 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DumpOpsKVActor, 1, Void >*>(static_cast<DumpOpsKVActor*>(this)));
															#line 2308 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(RangeResult const& ops,int loopDepth) 
	{
															#line 275 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (ops.more)
															#line 2323 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 276 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent(SevError, "OpsHitTxnLimits").detail("Result", ops.toString());
															#line 2327 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
															#line 278 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		uint64_t sum = 0;
															#line 279 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : ops ) {
															#line 280 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			uint64_t intValue = 0;
															#line 281 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			memcpy(&intValue, kv.value.begin(), kv.value.size());
															#line 282 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			sum += intValue;
															#line 283 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent("AtomicOpOps") .detail("Key", kv.key) .detail("Val", kv.value) .detail("IntVal", intValue) .detail("CurSum", sum);
															#line 2341 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(RangeResult && ops,int loopDepth) 
	{
															#line 275 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (ops.more)
															#line 2351 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 276 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent(SevError, "OpsHitTxnLimits").detail("Result", ops.toString());
															#line 2355 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
															#line 278 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		uint64_t sum = 0;
															#line 279 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : ops ) {
															#line 280 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			uint64_t intValue = 0;
															#line 281 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			memcpy(&intValue, kv.value.begin(), kv.value.size());
															#line 282 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			sum += intValue;
															#line 283 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent("AtomicOpOps") .detail("Key", kv.key) .detail("Val", kv.value) .detail("IntVal", intValue) .detail("CurSum", sum);
															#line 2369 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult const& ops,int loopDepth) 
	{
		loopDepth = a_body1cont2(ops, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && ops,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(ops), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DumpOpsKVActor*>(this)->actor_wait_state > 0) static_cast<DumpOpsKVActor*>(this)->actor_wait_state = 0;
		static_cast<DumpOpsKVActor*>(this)->ActorCallback< DumpOpsKVActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< DumpOpsKVActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("dumpOpsKV", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpOpsKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpOpsKV", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DumpOpsKVActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("dumpOpsKV", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpOpsKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpOpsKV", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DumpOpsKVActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("dumpOpsKV", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpOpsKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpOpsKV", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DumpOpsKVActor*>(this)->actor_wait_state > 0) static_cast<DumpOpsKVActor*>(this)->actor_wait_state = 0;
		static_cast<DumpOpsKVActor*>(this)->ActorCallback< DumpOpsKVActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpOpsKVActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpOpsKV", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpOpsKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpOpsKV", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DumpOpsKVActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpOpsKV", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpOpsKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpOpsKV", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DumpOpsKVActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpOpsKV", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpOpsKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpOpsKV", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 270 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	Database cx;
															#line 270 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	int g;
															#line 271 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 2556 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
};
// This generated class is to be used only via dumpOpsKV()
															#line 270 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
class DumpOpsKVActor final : public Actor<Void>, public ActorCallback< DumpOpsKVActor, 0, RangeResult >, public ActorCallback< DumpOpsKVActor, 1, Void >, public FastAllocated<DumpOpsKVActor>, public DumpOpsKVActorState<DumpOpsKVActor> {
															#line 2561 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
public:
	using FastAllocated<DumpOpsKVActor>::operator new;
	using FastAllocated<DumpOpsKVActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15186430472274176512UL, 10374784229644244736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DumpOpsKVActor, 0, RangeResult >;
friend struct ActorCallback< DumpOpsKVActor, 1, Void >;
															#line 270 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	DumpOpsKVActor(Database const& cx,int const& g) 
															#line 2579 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		 : Actor<Void>(),
		   DumpOpsKVActorState<DumpOpsKVActor>(cx, g),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dumpOpsKV", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15357864231788919808UL, 15566998731326837248UL);
		ActorExecutionContextHelper __helper(static_cast<DumpOpsKVActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dumpOpsKV");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dumpOpsKV", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DumpOpsKVActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DumpOpsKVActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 270 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
[[nodiscard]] Future<Void> dumpOpsKV( Database const& cx, int const& g ) {
															#line 270 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	return Future<Void>(new DumpOpsKVActor(cx, g));
															#line 2612 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
}

#line 295 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"

																#line 2617 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
// This generated class is to be used only via validateOpsKey()
															#line 296 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
template <class ValidateOpsKeyActor>
															#line 296 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
class ValidateOpsKeyActorState {
															#line 2623 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
public:
															#line 296 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	ValidateOpsKeyActorState(Database const& cx,AtomicOpsWorkload* const& self,int const& g) 
															#line 296 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
															#line 296 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		 : cx(cx),
															#line 296 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   self(self),
															#line 296 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   g(g),
															#line 298 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   tr1(cx),
															#line 299 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   records()
															#line 2638 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
	{
		fdb_probe_actor_create("validateOpsKey", reinterpret_cast<unsigned long>(this));

	}
	~ValidateOpsKeyActorState() 
	{
		fdb_probe_actor_destroy("validateOpsKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 300 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr1.getRange(prefixRange(format("debug%08x", g)), CLIENT_KNOBS->TOO_MANY);
															#line 300 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (static_cast<ValidateOpsKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2655 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ValidateOpsKeyActor*>(this)->actor_wait_state = 1;
															#line 300 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateOpsKeyActor, 0, RangeResult >*>(static_cast<ValidateOpsKeyActor*>(this)));
															#line 2660 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateOpsKeyActorState();
		static_cast<ValidateOpsKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& debuglog,int loopDepth) 
	{
															#line 301 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (debuglog.more)
															#line 2683 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 302 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent(SevError, "DebugLogHitTxnLimits").detail("Result", debuglog.toString());
															#line 303 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (!static_cast<ValidateOpsKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateOpsKeyActorState(); static_cast<ValidateOpsKeyActor*>(this)->destroy(); return 0; }
															#line 2689 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			new (&static_cast<ValidateOpsKeyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ValidateOpsKeyActorState();
			static_cast<ValidateOpsKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 305 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : debuglog ) {
															#line 306 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			records[kv.value] = kv.key;
															#line 2699 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
															#line 310 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		tr2 = ReadYourWritesTransaction(cx);
															#line 311 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		logVal = std::map<Key, int64_t>();
															#line 312 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr2.getRange(prefixRange(format("log%08x", g)), CLIENT_KNOBS->TOO_MANY);
															#line 312 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (static_cast<ValidateOpsKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2709 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ValidateOpsKeyActor*>(this)->actor_wait_state = 2;
															#line 312 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateOpsKeyActor, 1, RangeResult >*>(static_cast<ValidateOpsKeyActor*>(this)));
															#line 2714 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && debuglog,int loopDepth) 
	{
															#line 301 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (debuglog.more)
															#line 2723 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 302 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent(SevError, "DebugLogHitTxnLimits").detail("Result", debuglog.toString());
															#line 303 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (!static_cast<ValidateOpsKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateOpsKeyActorState(); static_cast<ValidateOpsKeyActor*>(this)->destroy(); return 0; }
															#line 2729 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			new (&static_cast<ValidateOpsKeyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ValidateOpsKeyActorState();
			static_cast<ValidateOpsKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 305 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : debuglog ) {
															#line 306 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			records[kv.value] = kv.key;
															#line 2739 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
															#line 310 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		tr2 = ReadYourWritesTransaction(cx);
															#line 311 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		logVal = std::map<Key, int64_t>();
															#line 312 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr2.getRange(prefixRange(format("log%08x", g)), CLIENT_KNOBS->TOO_MANY);
															#line 312 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (static_cast<ValidateOpsKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2749 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ValidateOpsKeyActor*>(this)->actor_wait_state = 2;
															#line 312 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateOpsKeyActor, 1, RangeResult >*>(static_cast<ValidateOpsKeyActor*>(this)));
															#line 2754 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& debuglog,int loopDepth) 
	{
		loopDepth = a_body1cont1(debuglog, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && debuglog,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(debuglog), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateOpsKeyActor*>(this)->actor_wait_state > 0) static_cast<ValidateOpsKeyActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateOpsKeyActor*>(this)->ActorCallback< ValidateOpsKeyActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateOpsKeyActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("validateOpsKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateOpsKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateOpsKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateOpsKeyActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("validateOpsKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateOpsKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateOpsKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateOpsKeyActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("validateOpsKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateOpsKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateOpsKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(RangeResult const& log,int loopDepth) 
	{
															#line 313 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (log.more)
															#line 2838 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 314 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent(SevError, "LogHitTxnLimits").detail("Result", log.toString());
															#line 315 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (!static_cast<ValidateOpsKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateOpsKeyActorState(); static_cast<ValidateOpsKeyActor*>(this)->destroy(); return 0; }
															#line 2844 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			new (&static_cast<ValidateOpsKeyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ValidateOpsKeyActorState();
			static_cast<ValidateOpsKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 317 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : log ) {
															#line 318 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			uint64_t intValue = 0;
															#line 319 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			memcpy(&intValue, kv.value.begin(), kv.value.size());
															#line 320 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			logVal[kv.key.removePrefix("log"_sr).withPrefix("debug"_sr)] = intValue;
															#line 2858 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
															#line 324 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		tr3 = ReadYourWritesTransaction(cx);
															#line 325 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		opsVal = std::map<Key, int64_t>();
															#line 326 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = tr3.getRange(prefixRange(format("ops%08x", g)), CLIENT_KNOBS->TOO_MANY);
															#line 326 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (static_cast<ValidateOpsKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2868 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ValidateOpsKeyActor*>(this)->actor_wait_state = 3;
															#line 326 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ValidateOpsKeyActor, 2, RangeResult >*>(static_cast<ValidateOpsKeyActor*>(this)));
															#line 2873 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(RangeResult && log,int loopDepth) 
	{
															#line 313 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (log.more)
															#line 2882 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 314 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent(SevError, "LogHitTxnLimits").detail("Result", log.toString());
															#line 315 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (!static_cast<ValidateOpsKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateOpsKeyActorState(); static_cast<ValidateOpsKeyActor*>(this)->destroy(); return 0; }
															#line 2888 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			new (&static_cast<ValidateOpsKeyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ValidateOpsKeyActorState();
			static_cast<ValidateOpsKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 317 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : log ) {
															#line 318 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			uint64_t intValue = 0;
															#line 319 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			memcpy(&intValue, kv.value.begin(), kv.value.size());
															#line 320 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			logVal[kv.key.removePrefix("log"_sr).withPrefix("debug"_sr)] = intValue;
															#line 2902 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
															#line 324 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		tr3 = ReadYourWritesTransaction(cx);
															#line 325 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		opsVal = std::map<Key, int64_t>();
															#line 326 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = tr3.getRange(prefixRange(format("ops%08x", g)), CLIENT_KNOBS->TOO_MANY);
															#line 326 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (static_cast<ValidateOpsKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2912 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ValidateOpsKeyActor*>(this)->actor_wait_state = 3;
															#line 326 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ValidateOpsKeyActor, 2, RangeResult >*>(static_cast<ValidateOpsKeyActor*>(this)));
															#line 2917 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult const& log,int loopDepth) 
	{
		loopDepth = a_body1cont2(log, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult && log,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(log), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ValidateOpsKeyActor*>(this)->actor_wait_state > 0) static_cast<ValidateOpsKeyActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateOpsKeyActor*>(this)->ActorCallback< ValidateOpsKeyActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateOpsKeyActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("validateOpsKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateOpsKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateOpsKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ValidateOpsKeyActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("validateOpsKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateOpsKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateOpsKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ValidateOpsKeyActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("validateOpsKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateOpsKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateOpsKey", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(RangeResult const& ops,int loopDepth) 
	{
															#line 327 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (ops.more)
															#line 3001 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 328 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent(SevError, "OpsHitTxnLimits").detail("Result", ops.toString());
															#line 329 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (!static_cast<ValidateOpsKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateOpsKeyActorState(); static_cast<ValidateOpsKeyActor*>(this)->destroy(); return 0; }
															#line 3007 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			new (&static_cast<ValidateOpsKeyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ValidateOpsKeyActorState();
			static_cast<ValidateOpsKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 332 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : ops ) {
															#line 333 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			bool inRecord = records.find(kv.key) != records.end();
															#line 334 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			uint64_t intValue = 0;
															#line 335 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			memcpy(&intValue, kv.value.begin(), kv.value.size());
															#line 336 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			opsVal[kv.key] = intValue;
															#line 337 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (!inRecord)
															#line 3025 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			{
															#line 338 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				TraceEvent(SevWarnAlways, "MissingLogKey").detail("OpsKey", kv.key);
															#line 3029 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			}
															#line 340 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (inRecord && (self->actorCount == 1 && intValue != logVal[records[kv.key]]))
															#line 3033 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			{
															#line 342 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				TraceEvent(SevError, "InconsistentOpsKeyValue") .detail("OpsKey", kv.key) .detail("DebugKey", records[kv.key]) .detail("LogValue", logVal[records[kv.key]]) .detail("OpValue", intValue);
															#line 3037 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			}
		}
															#line 351 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : records ) {
															#line 352 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (opsVal.find(kv.first) == opsVal.end())
															#line 3044 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			{
															#line 353 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				TraceEvent(SevError, "MissingOpsKey2").detail("OpsKey", kv.first).detail("DebugKey", kv.second);
															#line 3048 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			}
		}
															#line 356 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (!static_cast<ValidateOpsKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateOpsKeyActorState(); static_cast<ValidateOpsKeyActor*>(this)->destroy(); return 0; }
															#line 3053 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		new (&static_cast<ValidateOpsKeyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateOpsKeyActorState();
		static_cast<ValidateOpsKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(RangeResult && ops,int loopDepth) 
	{
															#line 327 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (ops.more)
															#line 3065 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 328 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent(SevError, "OpsHitTxnLimits").detail("Result", ops.toString());
															#line 329 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (!static_cast<ValidateOpsKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateOpsKeyActorState(); static_cast<ValidateOpsKeyActor*>(this)->destroy(); return 0; }
															#line 3071 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			new (&static_cast<ValidateOpsKeyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ValidateOpsKeyActorState();
			static_cast<ValidateOpsKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 332 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : ops ) {
															#line 333 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			bool inRecord = records.find(kv.key) != records.end();
															#line 334 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			uint64_t intValue = 0;
															#line 335 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			memcpy(&intValue, kv.value.begin(), kv.value.size());
															#line 336 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			opsVal[kv.key] = intValue;
															#line 337 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (!inRecord)
															#line 3089 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			{
															#line 338 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				TraceEvent(SevWarnAlways, "MissingLogKey").detail("OpsKey", kv.key);
															#line 3093 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			}
															#line 340 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (inRecord && (self->actorCount == 1 && intValue != logVal[records[kv.key]]))
															#line 3097 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			{
															#line 342 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				TraceEvent(SevError, "InconsistentOpsKeyValue") .detail("OpsKey", kv.key) .detail("DebugKey", records[kv.key]) .detail("LogValue", logVal[records[kv.key]]) .detail("OpValue", intValue);
															#line 3101 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			}
		}
															#line 351 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : records ) {
															#line 352 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (opsVal.find(kv.first) == opsVal.end())
															#line 3108 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			{
															#line 353 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				TraceEvent(SevError, "MissingOpsKey2").detail("OpsKey", kv.first).detail("DebugKey", kv.second);
															#line 3112 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			}
		}
															#line 356 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (!static_cast<ValidateOpsKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateOpsKeyActorState(); static_cast<ValidateOpsKeyActor*>(this)->destroy(); return 0; }
															#line 3117 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		new (&static_cast<ValidateOpsKeyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateOpsKeyActorState();
		static_cast<ValidateOpsKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(RangeResult const& ops,int loopDepth) 
	{
		loopDepth = a_body1cont5(ops, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(RangeResult && ops,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(ops), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ValidateOpsKeyActor*>(this)->actor_wait_state > 0) static_cast<ValidateOpsKeyActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateOpsKeyActor*>(this)->ActorCallback< ValidateOpsKeyActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateOpsKeyActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("validateOpsKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateOpsKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateOpsKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ValidateOpsKeyActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("validateOpsKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateOpsKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateOpsKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ValidateOpsKeyActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("validateOpsKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateOpsKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateOpsKey", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 296 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	Database cx;
															#line 296 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	AtomicOpsWorkload* self;
															#line 296 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	int g;
															#line 298 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	ReadYourWritesTransaction tr1;
															#line 299 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	std::map<Key, Key> records;
															#line 310 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	ReadYourWritesTransaction tr2;
															#line 311 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	std::map<Key, int64_t> logVal;
															#line 324 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	ReadYourWritesTransaction tr3;
															#line 325 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	std::map<Key, int64_t> opsVal;
															#line 3218 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
};
// This generated class is to be used only via validateOpsKey()
															#line 296 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
class ValidateOpsKeyActor final : public Actor<Void>, public ActorCallback< ValidateOpsKeyActor, 0, RangeResult >, public ActorCallback< ValidateOpsKeyActor, 1, RangeResult >, public ActorCallback< ValidateOpsKeyActor, 2, RangeResult >, public FastAllocated<ValidateOpsKeyActor>, public ValidateOpsKeyActorState<ValidateOpsKeyActor> {
															#line 3223 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
public:
	using FastAllocated<ValidateOpsKeyActor>::operator new;
	using FastAllocated<ValidateOpsKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4368073665794415104UL, 10473354882082589696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateOpsKeyActor, 0, RangeResult >;
friend struct ActorCallback< ValidateOpsKeyActor, 1, RangeResult >;
friend struct ActorCallback< ValidateOpsKeyActor, 2, RangeResult >;
															#line 296 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	ValidateOpsKeyActor(Database const& cx,AtomicOpsWorkload* const& self,int const& g) 
															#line 3242 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		 : Actor<Void>(),
		   ValidateOpsKeyActorState<ValidateOpsKeyActor>(cx, self, g),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateOpsKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17614453632332736512UL, 8353055004346410496UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateOpsKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateOpsKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateOpsKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateOpsKeyActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ValidateOpsKeyActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ValidateOpsKeyActor, 2, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 296 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
[[nodiscard]] Future<Void> validateOpsKey( Database const& cx, AtomicOpsWorkload* const& self, int const& g ) {
															#line 296 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	return Future<Void>(new ValidateOpsKeyActor(cx, self, g));
															#line 3276 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
}

#line 358 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"

																#line 3281 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 359 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
template <class _checkActor>
															#line 359 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
class _checkActorState {
															#line 3287 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
public:
															#line 359 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	_checkActorState(Database const& cx,AtomicOpsWorkload* const& self) 
															#line 359 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
															#line 359 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		 : cx(cx),
															#line 359 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   self(self),
															#line 360 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   g(0),
															#line 361 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		   ret(true)
															#line 3300 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 362 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			;
															#line 3315 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 435 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(ret); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 3338 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(std::move(ret)); // state_var_RVO
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 362 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (!(g < 100))
															#line 3357 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 363 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 364 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		log = RangeResult();
															#line 365 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		;
															#line 3367 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 362 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		g++;
															#line 3389 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
			{
															#line 369 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				Key begin(format("log%08x", g));
															#line 370 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = tr.getRange(KeyRangeRef(begin, strinc(begin)), CLIENT_KNOBS->TOO_MANY);
															#line 370 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3411 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 370 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, RangeResult >*>(static_cast<_checkActor*>(this)));
															#line 3416 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 431 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			StrictFuture<Void> __when_expr_6 = tr.onError(e);
															#line 431 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3454 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 7;
															#line 431 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 6, Void >*>(static_cast<_checkActor*>(this)));
															#line 3459 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
		{
															#line 383 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			Key begin(format("ops%08x", g));
															#line 384 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			StrictFuture<RangeResult> __when_expr_1 = tr.getRange(KeyRangeRef(begin, strinc(begin)), CLIENT_KNOBS->TOO_MANY);
															#line 384 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3479 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 384 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, RangeResult >*>(static_cast<_checkActor*>(this)));
															#line 3484 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(RangeResult const& log_,int loopDepth) 
	{
															#line 371 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		log = log_;
															#line 372 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		uint64_t zeroValue = 0;
															#line 373 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		tr.set("xlogResult"_sr, StringRef((const uint8_t*)&zeroValue, sizeof(zeroValue)));
															#line 374 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : log ) {
															#line 375 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			uint64_t intValue = 0;
															#line 376 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			memcpy(&intValue, kv.value.begin(), kv.value.size());
															#line 377 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			tr.atomicOp("xlogResult"_sr, kv.value, self->opType);
															#line 3506 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(RangeResult && log_,int loopDepth) 
	{
															#line 371 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		log = log_;
															#line 372 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		uint64_t zeroValue = 0;
															#line 373 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		tr.set("xlogResult"_sr, StringRef((const uint8_t*)&zeroValue, sizeof(zeroValue)));
															#line 374 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : log ) {
															#line 375 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			uint64_t intValue = 0;
															#line 376 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			memcpy(&intValue, kv.value.begin(), kv.value.size());
															#line 377 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			tr.atomicOp("xlogResult"_sr, kv.value, self->opType);
															#line 3528 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& log_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(log_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && log_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(log_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont7(RangeResult const& ops,int loopDepth) 
	{
															#line 385 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		uint64_t zeroValue = 0;
															#line 386 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		tr.set("xopsResult"_sr, StringRef((const uint8_t*)&zeroValue, sizeof(zeroValue)));
															#line 387 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : ops ) {
															#line 388 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			uint64_t intValue = 0;
															#line 389 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			memcpy(&intValue, kv.value.begin(), kv.value.size());
															#line 390 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			tr.atomicOp("xopsResult"_sr, kv.value, self->opType);
															#line 3623 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
															#line 393 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (tr.get("xlogResult"_sr).get() != tr.get("xopsResult"_sr).get())
															#line 3627 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 394 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			Optional<Standalone<StringRef>> logResult = tr.get("xlogResult"_sr).get();
															#line 395 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			Optional<Standalone<StringRef>> opsResult = tr.get("xopsResult"_sr).get();
															#line 396 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			ASSERT(logResult.present());
															#line 397 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			ASSERT(opsResult.present());
															#line 398 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent(SevError, "LogMismatch") .detail("Index", format("log%08x", g)) .detail("LogResult", printable(logResult)) .detail("OpsResult", printable(opsResult));
															#line 3639 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
															#line 404 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (self->opType == MutationRef::AddValue)
															#line 3643 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 405 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			uint64_t opsResult = 0;
															#line 406 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			Key opsResultStr = tr.get("xopsResult"_sr).get().get();
															#line 407 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			memcpy(&opsResult, opsResultStr.begin(), opsResultStr.size());
															#line 408 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			uint64_t logResult = 0;
															#line 409 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			for( auto& kv : log ) {
															#line 410 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				uint64_t intValue = 0;
															#line 411 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				memcpy(&intValue, kv.value.begin(), kv.value.size());
															#line 412 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				logResult += intValue;
															#line 3661 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			}
															#line 414 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (logResult != opsResult)
															#line 3665 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			{
															#line 415 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				TraceEvent(SevError, "LogAddMismatch") .detail("LogResult", logResult) .detail("OpResult", opsResult) .detail("OpsResultStr", printable(opsResultStr)) .detail("Size", opsResultStr.size()) .detail("LowerBoundSum", self->lbsum) .detail("UpperBoundSum", self->ubsum);
															#line 422 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				StrictFuture<Void> __when_expr_2 = self->dumpLogKV(cx, g);
															#line 422 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3673 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont7when1(__when_expr_2.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 422 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, Void >*>(static_cast<_checkActor*>(this)));
															#line 3678 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1loopBody1cont11(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont7(RangeResult && ops,int loopDepth) 
	{
															#line 385 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		uint64_t zeroValue = 0;
															#line 386 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		tr.set("xopsResult"_sr, StringRef((const uint8_t*)&zeroValue, sizeof(zeroValue)));
															#line 387 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		for( auto& kv : ops ) {
															#line 388 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			uint64_t intValue = 0;
															#line 389 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			memcpy(&intValue, kv.value.begin(), kv.value.size());
															#line 390 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			tr.atomicOp("xopsResult"_sr, kv.value, self->opType);
															#line 3707 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
															#line 393 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (tr.get("xlogResult"_sr).get() != tr.get("xopsResult"_sr).get())
															#line 3711 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 394 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			Optional<Standalone<StringRef>> logResult = tr.get("xlogResult"_sr).get();
															#line 395 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			Optional<Standalone<StringRef>> opsResult = tr.get("xopsResult"_sr).get();
															#line 396 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			ASSERT(logResult.present());
															#line 397 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			ASSERT(opsResult.present());
															#line 398 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			TraceEvent(SevError, "LogMismatch") .detail("Index", format("log%08x", g)) .detail("LogResult", printable(logResult)) .detail("OpsResult", printable(opsResult));
															#line 3723 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		}
															#line 404 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (self->opType == MutationRef::AddValue)
															#line 3727 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		{
															#line 405 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			uint64_t opsResult = 0;
															#line 406 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			Key opsResultStr = tr.get("xopsResult"_sr).get().get();
															#line 407 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			memcpy(&opsResult, opsResultStr.begin(), opsResultStr.size());
															#line 408 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			uint64_t logResult = 0;
															#line 409 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			for( auto& kv : log ) {
															#line 410 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				uint64_t intValue = 0;
															#line 411 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				memcpy(&intValue, kv.value.begin(), kv.value.size());
															#line 412 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				logResult += intValue;
															#line 3745 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			}
															#line 414 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
			if (logResult != opsResult)
															#line 3749 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
			{
															#line 415 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				TraceEvent(SevError, "LogAddMismatch") .detail("LogResult", logResult) .detail("OpResult", opsResult) .detail("OpsResultStr", printable(opsResultStr)) .detail("Size", opsResultStr.size()) .detail("LowerBoundSum", self->lbsum) .detail("UpperBoundSum", self->ubsum);
															#line 422 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				StrictFuture<Void> __when_expr_2 = self->dumpLogKV(cx, g);
															#line 422 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3757 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont7when1(__when_expr_2.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 422 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, Void >*>(static_cast<_checkActor*>(this)));
															#line 3762 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1loopBody1cont11(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult const& ops,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont7(ops, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult && ops,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont7(std::move(ops), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont8(int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont11(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont13(Void const& _,int loopDepth) 
	{
															#line 423 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->dumpDebugKV(cx, g);
															#line 423 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3870 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont13when1(__when_expr_3.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 4;
															#line 423 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 3, Void >*>(static_cast<_checkActor*>(this)));
															#line 3875 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont13(Void && _,int loopDepth) 
	{
															#line 423 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->dumpDebugKV(cx, g);
															#line 423 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3886 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont13when1(__when_expr_3.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 4;
															#line 423 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 3, Void >*>(static_cast<_checkActor*>(this)));
															#line 3891 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _checkActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont13cont1(Void const& _,int loopDepth) 
	{
															#line 424 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->dumpOpsKV(cx, g);
															#line 424 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3977 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1loopBody1cont13cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 5;
															#line 424 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 4, Void >*>(static_cast<_checkActor*>(this)));
															#line 3982 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont13cont1(Void && _,int loopDepth) 
	{
															#line 424 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->dumpOpsKV(cx, g);
															#line 424 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3993 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1loopBody1cont13cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 5;
															#line 424 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 4, Void >*>(static_cast<_checkActor*>(this)));
															#line 3998 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont13when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont13cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont13when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont13cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _checkActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1cont13cont2(Void const& _,int loopDepth) 
	{
															#line 425 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->validateOpsKey(cx, self, g);
															#line 425 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4084 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1loopBody1cont13cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 6;
															#line 425 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 5, Void >*>(static_cast<_checkActor*>(this)));
															#line 4089 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont13cont2(Void && _,int loopDepth) 
	{
															#line 425 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->validateOpsKey(cx, self, g);
															#line 425 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4100 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1loopBody1cont13cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 6;
															#line 425 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 5, Void >*>(static_cast<_checkActor*>(this)));
															#line 4105 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont13cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont13cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont13cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont13cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont13cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _checkActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont13cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _checkActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1loopBody1cont13cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont13cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont13cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont13cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont13cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont13cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1cont13cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _checkActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1cont13cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _checkActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _checkActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _checkActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 359 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	Database cx;
															#line 359 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	AtomicOpsWorkload* self;
															#line 360 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	int g;
															#line 361 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	bool ret;
															#line 363 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 364 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	RangeResult log;
															#line 4371 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 359 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, RangeResult >, public ActorCallback< _checkActor, 1, RangeResult >, public ActorCallback< _checkActor, 2, Void >, public ActorCallback< _checkActor, 3, Void >, public ActorCallback< _checkActor, 4, Void >, public ActorCallback< _checkActor, 5, Void >, public ActorCallback< _checkActor, 6, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 4376 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13550989086407946496UL, 17222537332306885120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, RangeResult >;
friend struct ActorCallback< _checkActor, 1, RangeResult >;
friend struct ActorCallback< _checkActor, 2, Void >;
friend struct ActorCallback< _checkActor, 3, Void >;
friend struct ActorCallback< _checkActor, 4, Void >;
friend struct ActorCallback< _checkActor, 5, Void >;
friend struct ActorCallback< _checkActor, 6, Void >;
															#line 359 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	_checkActor(Database const& cx,AtomicOpsWorkload* const& self) 
															#line 4399 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _checkActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _checkActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _checkActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _checkActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _checkActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 359 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
[[nodiscard]] Future<bool> _check( Database const& cx, AtomicOpsWorkload* const& self ) {
															#line 359 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 4437 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicOps.actor.g.cpp"
}

#line 437 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicOps.actor.cpp"
};

WorkloadFactory<AtomicOpsWorkload> AtomicOpsWorkloadFactory;
