#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
/*
 * StorageMetrics.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(FDBSERVER_STORAGEMETRICS_G_H)
#define FDBSERVER_STORAGEMETRICS_G_H
#include "fdbserver/StorageMetrics.actor.g.h"
#elif !defined(FDBSERVER_STORAGEMETRICS_H)
#define FDBSERVER_STORAGEMETRICS_H
#include "fdbclient/FDBTypes.h"
#include "fdbrpc/simulator.h"
#include "flow/UnitTest.h"
#include "fdbclient/StorageServerInterface.h"
#include "fdbclient/KeyRangeMap.h"
#include "fdbserver/Knobs.h"
#include "flow/actorcompiler.h"

const StringRef STORAGESERVER_HISTOGRAM_GROUP = "StorageServer"_sr;
const StringRef FETCH_KEYS_LATENCY_HISTOGRAM = "FetchKeysLatency"_sr;
const StringRef FETCH_KEYS_BYTES_HISTOGRAM = "FetchKeysSize"_sr;
const StringRef FETCH_KEYS_BYTES_PER_SECOND_HISTOGRAM = "FetchKeysBandwidth"_sr;
const StringRef FETCH_KEYS_BYTES_PER_COMMIT_HISTOGRAM = "FetchKeysBytesPerCommit"_sr;
const StringRef TLOG_CURSOR_READS_LATENCY_HISTOGRAM = "TLogCursorReadsLatency"_sr;
const StringRef SS_VERSION_LOCK_LATENCY_HISTOGRAM = "SSVersionLockLatency"_sr;
const StringRef EAGER_READS_LATENCY_HISTOGRAM = "EagerReadsLatency"_sr;
const StringRef FETCH_KEYS_PTREE_UPDATES_LATENCY_HISTOGRAM = "FetchKeysPTreeUpdatesLatency"_sr;
const StringRef TLOG_MSGS_PTREE_UPDATES_LATENCY_HISTOGRAM = "TLogMsgsPTreeUpdatesLatency"_sr;
const StringRef STORAGE_UPDATES_DURABLE_LATENCY_HISTOGRAM = "StorageUpdatesDurableLatency"_sr;
const StringRef STORAGE_COMMIT_LATENCY_HISTOGRAM = "StorageCommitLatency"_sr;
const StringRef SS_DURABLE_VERSION_UPDATE_LATENCY_HISTOGRAM = "SSDurableVersionUpdateLatency"_sr;
const StringRef SS_READ_RANGE_BYTES_RETURNED_HISTOGRAM = "SSReadRangeBytesReturned"_sr;
const StringRef SS_READ_RANGE_BYTES_LIMIT_HISTOGRAM = "SSReadRangeBytesLimit"_sr;
const StringRef SS_READ_RANGE_KV_PAIRS_RETURNED_HISTOGRAM = "SSReadRangeKVPairsReturned"_sr;

struct StorageMetricSample {
	IndexedSet<Key, int64_t> sample;
	int64_t metricUnitsPerSample;

	explicit StorageMetricSample(int64_t metricUnitsPerSample) : metricUnitsPerSample(metricUnitsPerSample) {}

	int64_t getEstimate(KeyRangeRef keys) const;
	KeyRef splitEstimate(KeyRangeRef range, int64_t offset, bool front = true) const;
};

struct TransientStorageMetricSample : StorageMetricSample {
	Deque<std::pair<double, std::pair<Key, int64_t>>> queue;

	explicit TransientStorageMetricSample(int64_t metricUnitsPerSample) : StorageMetricSample(metricUnitsPerSample) {}

	int64_t addAndExpire(const Key& key, int64_t metric, double expiration);

	int64_t erase(KeyRef key);
	void erase(KeyRangeRef keys);

	void poll(KeyRangeMap<std::vector<PromiseStream<StorageMetrics>>>& waitMap, StorageMetrics m);

	void poll();

private:
	bool roll(int64_t metric) const;

	// return the sampled metric delta
	int64_t add(const Key& key, int64_t metric);
};

struct StorageServerMetrics {
	KeyRangeMap<std::vector<PromiseStream<StorageMetrics>>> waitMetricsMap;
	StorageMetricSample byteSample;

	// FIXME: iops is not effectively tested, and is not used by data distribution
	TransientStorageMetricSample iopsSample, bytesWriteSample;
	TransientStorageMetricSample bytesReadSample;
	TransientStorageMetricSample opsReadSample;

	StorageServerMetrics()
	  : byteSample(0), iopsSample(SERVER_KNOBS->IOPS_UNITS_PER_SAMPLE),
	    bytesWriteSample(SERVER_KNOBS->BYTES_WRITTEN_UNITS_PER_SAMPLE),
	    bytesReadSample(SERVER_KNOBS->BYTES_READ_UNITS_PER_SAMPLE),
	    opsReadSample(SERVER_KNOBS->OPS_READ_UNITS_PER_SAMPLE) {}

	StorageMetrics getMetrics(KeyRangeRef const& keys) const;

	void notify(const Key& key, StorageMetrics& metrics);

	void notifyBytesReadPerKSecond(const Key& key, int64_t in);

	void notifyBytes(RangeMap<Key, std::vector<PromiseStream<StorageMetrics>>, KeyRangeRef>::iterator shard,
	                 int64_t bytes);

	void notifyBytes(const KeyRef& key, int64_t bytes);

	void notifyNotReadable(KeyRangeRef keys);

	void poll();

	// static void waitMetrics( StorageServerMetrics* const& self, WaitMetricsRequest const& req );

	KeyRef getSplitKey(int64_t remaining,
	                   int64_t estimated,
	                   int64_t limits,
	                   int64_t used,
	                   int64_t infinity,
	                   bool isLastShard,
	                   const StorageMetricSample& sample,
	                   double divisor,
	                   KeyRef const& lastKey,
	                   KeyRef const& key,
	                   bool hasUsed) const;

	void splitMetrics(SplitMetricsRequest req) const;

	void getStorageMetrics(GetStorageMetricsRequest req,
	                       StorageBytes sb,
	                       double bytesInputRate,
	                       int64_t versionLag,
	                       double lastUpdate,
	                       int64_t bytesDurable,
	                       int64_t bytesInput,
	                       int ongoingBulkLoadTaskCount) const;

	Future<Void> waitMetrics(WaitMetricsRequest req, Future<Void> delay);

	std::vector<ReadHotRangeWithMetrics> getReadHotRanges(KeyRangeRef shard, int chunkCount, uint8_t splitType) const;

	void getReadHotRanges(ReadHotSubRangeRequest req) const;

	int64_t getHotShards(const KeyRange& range) const;

	std::vector<KeyRef> getSplitPoints(KeyRangeRef range, int64_t chunkSize, Optional<KeyRef> prefixToRemove) const;

	void getSplitPoints(SplitRangeRequest req, Optional<KeyRef> prefix) const;

	[[maybe_unused]] std::vector<ReadHotRangeWithMetrics> _getReadHotRanges(
	    KeyRangeRef shard,
	    double readDensityRatio,
	    int64_t baseChunkSize,
	    int64_t minShardReadBandwidthPerKSeconds) const;

private:
	static void collapse(KeyRangeMap<int>& map, KeyRef const& key);
	static void add(KeyRangeMap<int>& map, KeyRangeRef const& keys, int delta);
};

// Contains information about whether or not a key-value pair should be included in a byte sample.
//
// The invariant holds:
//    probability * sampledSize == size
struct ByteSampleInfo {
	// True if we've decided to sample this key-value pair.
	bool inSample;

	// Actual size of the key value pair.
	int64_t size;

	// Probability that the key-value pair will be sampled.
	// This is a function of key and value sizes.
	// The goal is to sample ~1/BYTE_SAMPLING_FACTOR of the key-value space,
	// which by default is 1/250th.
	double probability;

	// The recorded size of the sample (max of bytesPerSample, size).
	int64_t sampledSize;
};

// Determines whether a key-value pair should be included in a byte sample
// Also returns size information about the sample
ByteSampleInfo isKeyValueInSample(KeyRef key, int64_t totalKvSize);
inline ByteSampleInfo isKeyValueInSample(KeyValueRef keyValue) {
	return isKeyValueInSample(keyValue.key, keyValue.key.size() + keyValue.value.size());
}

struct CommonStorageCounters {
	CounterCollection cc;
	// read ops
	Counter finishedQueries, bytesQueried;

	// write ops
	// Bytes of the mutations that have been added to the memory of the storage server. When the data is durable
	// and cleared from the memory, we do not subtract it but add it to bytesDurable.
	Counter bytesInput;
	// Like bytesInput but without MVCC accounting. The size is counted as how much it takes when serialized. It
	// is basically the size of both parameters of the mutation and a 12 bytes overhead that keeps mutation type
	// and the lengths of both parameters.
	Counter mutationBytes;
	Counter mutations, setMutations, clearRangeMutations;

	// Bytes fetched by fetchKeys() for data movements. The size is counted as a collection of KeyValueRef.
	Counter bytesFetched;
	// The number of key-value pairs fetched by fetchKeys()
	Counter kvFetched;

	// Bytes replied for fetchKeys
	Counter kvFetchBytesServed;

	// The number of key-value pairs replied for fetchKeys
	Counter kvFetchServed;

	// The number of fetchKeys errors
	Counter fetchKeyErrors;

	// name and id are the inputs to CounterCollection initialization. If metrics provided, the caller should guarantee
	// the lifetime of metrics is longer than this counter
	CommonStorageCounters(const std::string& name,
	                      const std::string& id,
	                      const StorageServerMetrics* metrics = nullptr);
};

class IStorageMetricsService {
public:
	StorageServerMetrics metrics;

	// penalty used by loadBalance() to balance requests among service instances
	virtual double getPenalty() const { return 1; }

	virtual bool isReadable(KeyRangeRef const& keys) const { return true; }

	virtual void addActor(Future<Void> future) = 0;

	virtual void getSplitPoints(SplitRangeRequest const& req) = 0;

	virtual Future<Void> waitMetricsTenantAware(const WaitMetricsRequest& req) = 0;

	virtual void getStorageMetrics(const GetStorageMetricsRequest& req) = 0;

	virtual void getSplitMetrics(const SplitMetricsRequest& req) = 0;

	virtual void getHotRangeMetrics(const ReadHotSubRangeRequest& req) = 0;

	virtual int64_t getHotShardsMetrics(const KeyRange& range) = 0;

	// NOTE: also need to have this function but template can't be a virtual so...
	// template <class Reply>
	// void sendErrorWithPenalty(const ReplyPromise<Reply>& promise, const Error& err, double penalty);
};

															#line 255 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
namespace {
// This generated class is to be used only via serveStorageMetricsRequests()
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
template <class ServiceType, class ServeStorageMetricsRequestsActor>
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
class ServeStorageMetricsRequestsActorState {
															#line 262 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
public:
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
	ServeStorageMetricsRequestsActorState(ServiceType* const& self,StorageServerInterface const& ssi) 
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		 : self(self),
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		   ssi(ssi),
															#line 255 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		   doPollMetrics(Void())
															#line 273 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
	{
		fdb_probe_actor_create("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this));

	}
	~ServeStorageMetricsRequestsActorState() 
	{
		fdb_probe_actor_destroy("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 256 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			;
															#line 288 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServeStorageMetricsRequestsActorState();
		static_cast<ServeStorageMetricsRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 258 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		auto __when_expr_0 = ssi.waitMetrics.getFuture();
															#line 318 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<WaitMetricsRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<WaitMetricsRequest>>::value, "invalid type");
															#line 257 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		if (static_cast<ServeStorageMetricsRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 322 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 266 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		auto __when_expr_1 = ssi.splitMetrics.getFuture();
															#line 326 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<SplitMetricsRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<SplitMetricsRequest>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 274 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		auto __when_expr_2 = ssi.getStorageMetrics.getFuture();
															#line 331 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<GetStorageMetricsRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<GetStorageMetricsRequest>>::value, "invalid type");
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 277 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		auto __when_expr_3 = ssi.getReadHotRanges.getFuture();
															#line 336 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<ReadHotSubRangeRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<ReadHotSubRangeRequest>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.pop(), loopDepth); };
															#line 280 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		auto __when_expr_4 = ssi.getRangeSplitPoints.getFuture();
															#line 341 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<SplitRangeRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<SplitRangeRequest>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.pop(), loopDepth); };
															#line 290 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		StrictFuture<Void> __when_expr_5 = doPollMetrics;
															#line 346 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when6(__when_expr_5.get(), loopDepth); };
		static_cast<ServeStorageMetricsRequestsActor*>(this)->actor_wait_state = 1;
															#line 258 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ServeStorageMetricsRequestsActor, 0, WaitMetricsRequest >*>(static_cast<ServeStorageMetricsRequestsActor*>(this)));
															#line 266 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ServeStorageMetricsRequestsActor, 1, SplitMetricsRequest >*>(static_cast<ServeStorageMetricsRequestsActor*>(this)));
															#line 274 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< ServeStorageMetricsRequestsActor, 2, GetStorageMetricsRequest >*>(static_cast<ServeStorageMetricsRequestsActor*>(this)));
															#line 277 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< ServeStorageMetricsRequestsActor, 3, ReadHotSubRangeRequest >*>(static_cast<ServeStorageMetricsRequestsActor*>(this)));
															#line 280 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< ServeStorageMetricsRequestsActor, 4, SplitRangeRequest >*>(static_cast<ServeStorageMetricsRequestsActor*>(this)));
															#line 290 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ServeStorageMetricsRequestsActor, 5, Void >*>(static_cast<ServeStorageMetricsRequestsActor*>(this)));
															#line 361 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(WaitMetricsRequest const& __req,int loopDepth) 
	{
															#line 258 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		req = __req;
															#line 259 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		if (!req.tenantInfo.hasTenant() && !self->isReadable(req.keys))
															#line 378 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		{
															#line 260 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			CODE_PROBE(true, "waitMetrics immediate wrong_shard_server()");
															#line 261 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			self->sendErrorWithPenalty(req.reply, wrong_shard_server(), self->getPenalty());
															#line 384 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		}
		else
		{
															#line 263 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			self->addActor(self->waitMetricsTenantAware(req));
															#line 390 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(WaitMetricsRequest && __req,int loopDepth) 
	{
		req = std::move(__req);
															#line 259 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		if (!req.tenantInfo.hasTenant() && !self->isReadable(req.keys))
															#line 401 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		{
															#line 260 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			CODE_PROBE(true, "waitMetrics immediate wrong_shard_server()");
															#line 261 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			self->sendErrorWithPenalty(req.reply, wrong_shard_server(), self->getPenalty());
															#line 407 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		}
		else
		{
															#line 263 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			self->addActor(self->waitMetricsTenantAware(req));
															#line 413 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(SplitMetricsRequest const& req,int loopDepth) 
	{
															#line 267 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		if (!self->isReadable(req.keys))
															#line 423 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		{
															#line 268 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			CODE_PROBE(true, "splitMetrics immediate wrong_shard_server()");
															#line 269 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			self->sendErrorWithPenalty(req.reply, wrong_shard_server(), self->getPenalty());
															#line 429 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		}
		else
		{
															#line 271 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			self->getSplitMetrics(req);
															#line 435 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(SplitMetricsRequest && req,int loopDepth) 
	{
															#line 267 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		if (!self->isReadable(req.keys))
															#line 445 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		{
															#line 268 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			CODE_PROBE(true, "splitMetrics immediate wrong_shard_server()");
															#line 269 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			self->sendErrorWithPenalty(req.reply, wrong_shard_server(), self->getPenalty());
															#line 451 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		}
		else
		{
															#line 271 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			self->getSplitMetrics(req);
															#line 457 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetStorageMetricsRequest const& req,int loopDepth) 
	{
															#line 275 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		self->getStorageMetrics(req);
															#line 467 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetStorageMetricsRequest && req,int loopDepth) 
	{
															#line 275 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		self->getStorageMetrics(req);
															#line 476 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(ReadHotSubRangeRequest const& req,int loopDepth) 
	{
															#line 278 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		self->getHotRangeMetrics(req);
															#line 485 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(ReadHotSubRangeRequest && req,int loopDepth) 
	{
															#line 278 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		self->getHotRangeMetrics(req);
															#line 494 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(SplitRangeRequest const& req,int loopDepth) 
	{
															#line 281 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		if ((!req.tenantInfo.hasTenant() && !self->isReadable(req.keys)) || (req.tenantInfo.hasTenant() && !self->isReadable(req.keys.withPrefix(req.tenantInfo.prefix.get()))))
															#line 503 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		{
															#line 284 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			CODE_PROBE(true, "getSplitPoints immediate wrong_shard_server()");
															#line 285 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			self->sendErrorWithPenalty(req.reply, wrong_shard_server(), self->getPenalty());
															#line 509 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		}
		else
		{
															#line 287 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			self->getSplitPoints(req);
															#line 515 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(SplitRangeRequest && req,int loopDepth) 
	{
															#line 281 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		if ((!req.tenantInfo.hasTenant() && !self->isReadable(req.keys)) || (req.tenantInfo.hasTenant() && !self->isReadable(req.keys.withPrefix(req.tenantInfo.prefix.get()))))
															#line 525 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		{
															#line 284 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			CODE_PROBE(true, "getSplitPoints immediate wrong_shard_server()");
															#line 285 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			self->sendErrorWithPenalty(req.reply, wrong_shard_server(), self->getPenalty());
															#line 531 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		}
		else
		{
															#line 287 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
			self->getSplitPoints(req);
															#line 537 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(Void const& _,int loopDepth) 
	{
															#line 291 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		self->metrics.poll();
															#line 292 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		doPollMetrics = delay(SERVER_KNOBS->STORAGE_SERVER_POLL_METRICS_DELAY);
															#line 549 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(Void && _,int loopDepth) 
	{
															#line 291 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		self->metrics.poll();
															#line 292 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
		doPollMetrics = delay(SERVER_KNOBS->STORAGE_SERVER_POLL_METRICS_DELAY);
															#line 560 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServeStorageMetricsRequestsActor*>(this)->actor_wait_state > 0) static_cast<ServeStorageMetricsRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<ServeStorageMetricsRequestsActor*>(this)->ActorSingleCallback< ServeStorageMetricsRequestsActor, 0, WaitMetricsRequest >::remove();
		static_cast<ServeStorageMetricsRequestsActor*>(this)->ActorSingleCallback< ServeStorageMetricsRequestsActor, 1, SplitMetricsRequest >::remove();
		static_cast<ServeStorageMetricsRequestsActor*>(this)->ActorSingleCallback< ServeStorageMetricsRequestsActor, 2, GetStorageMetricsRequest >::remove();
		static_cast<ServeStorageMetricsRequestsActor*>(this)->ActorSingleCallback< ServeStorageMetricsRequestsActor, 3, ReadHotSubRangeRequest >::remove();
		static_cast<ServeStorageMetricsRequestsActor*>(this)->ActorSingleCallback< ServeStorageMetricsRequestsActor, 4, SplitRangeRequest >::remove();
		static_cast<ServeStorageMetricsRequestsActor*>(this)->ActorCallback< ServeStorageMetricsRequestsActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ServeStorageMetricsRequestsActor, 0, WaitMetricsRequest >*,WaitMetricsRequest const& value) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ServeStorageMetricsRequestsActor, 0, WaitMetricsRequest >*,WaitMetricsRequest && value) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ServeStorageMetricsRequestsActor, 0, WaitMetricsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ServeStorageMetricsRequestsActor, 1, SplitMetricsRequest >*,SplitMetricsRequest const& value) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ServeStorageMetricsRequestsActor, 1, SplitMetricsRequest >*,SplitMetricsRequest && value) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< ServeStorageMetricsRequestsActor, 1, SplitMetricsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ServeStorageMetricsRequestsActor, 2, GetStorageMetricsRequest >*,GetStorageMetricsRequest const& value) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< ServeStorageMetricsRequestsActor, 2, GetStorageMetricsRequest >*,GetStorageMetricsRequest && value) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< ServeStorageMetricsRequestsActor, 2, GetStorageMetricsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< ServeStorageMetricsRequestsActor, 3, ReadHotSubRangeRequest >*,ReadHotSubRangeRequest const& value) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< ServeStorageMetricsRequestsActor, 3, ReadHotSubRangeRequest >*,ReadHotSubRangeRequest && value) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< ServeStorageMetricsRequestsActor, 3, ReadHotSubRangeRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< ServeStorageMetricsRequestsActor, 4, SplitRangeRequest >*,SplitRangeRequest const& value) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< ServeStorageMetricsRequestsActor, 4, SplitRangeRequest >*,SplitRangeRequest && value) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< ServeStorageMetricsRequestsActor, 4, SplitRangeRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ServeStorageMetricsRequestsActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ServeStorageMetricsRequestsActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ServeStorageMetricsRequestsActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
	ServiceType* self;
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
	StorageServerInterface ssi;
															#line 255 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
	Future<Void> doPollMetrics;
															#line 258 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
	WaitMetricsRequest req;
															#line 926 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
};
// This generated class is to be used only via serveStorageMetricsRequests()
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
template <class ServiceType>
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
class ServeStorageMetricsRequestsActor final : public Actor<Void>, public ActorSingleCallback< ServeStorageMetricsRequestsActor<ServiceType>, 0, WaitMetricsRequest >, public ActorSingleCallback< ServeStorageMetricsRequestsActor<ServiceType>, 1, SplitMetricsRequest >, public ActorSingleCallback< ServeStorageMetricsRequestsActor<ServiceType>, 2, GetStorageMetricsRequest >, public ActorSingleCallback< ServeStorageMetricsRequestsActor<ServiceType>, 3, ReadHotSubRangeRequest >, public ActorSingleCallback< ServeStorageMetricsRequestsActor<ServiceType>, 4, SplitRangeRequest >, public ActorCallback< ServeStorageMetricsRequestsActor<ServiceType>, 5, Void >, public FastAllocated<ServeStorageMetricsRequestsActor<ServiceType>>, public ServeStorageMetricsRequestsActorState<ServiceType, ServeStorageMetricsRequestsActor<ServiceType>> {
															#line 933 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
public:
	using FastAllocated<ServeStorageMetricsRequestsActor<ServiceType>>::operator new;
	using FastAllocated<ServeStorageMetricsRequestsActor<ServiceType>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12052095903644615424UL, 10292146442621539840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ServeStorageMetricsRequestsActor<ServiceType>, 0, WaitMetricsRequest >;
friend struct ActorSingleCallback< ServeStorageMetricsRequestsActor<ServiceType>, 1, SplitMetricsRequest >;
friend struct ActorSingleCallback< ServeStorageMetricsRequestsActor<ServiceType>, 2, GetStorageMetricsRequest >;
friend struct ActorSingleCallback< ServeStorageMetricsRequestsActor<ServiceType>, 3, ReadHotSubRangeRequest >;
friend struct ActorSingleCallback< ServeStorageMetricsRequestsActor<ServiceType>, 4, SplitRangeRequest >;
friend struct ActorCallback< ServeStorageMetricsRequestsActor<ServiceType>, 5, Void >;
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
	ServeStorageMetricsRequestsActor(ServiceType* const& self,StorageServerInterface const& ssi) 
															#line 955 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
		 : Actor<Void>(),
		   ServeStorageMetricsRequestsActorState<ServiceType, ServeStorageMetricsRequestsActor<ServiceType>>(self, ssi),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3331298439766141696UL, 12674132504034694144UL);
		ActorExecutionContextHelper __helper(static_cast<ServeStorageMetricsRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serveStorageMetricsRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serveStorageMetricsRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ServeStorageMetricsRequestsActor<ServiceType>, 0, WaitMetricsRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
template <class ServiceType>
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
[[nodiscard]] Future<Void> serveStorageMetricsRequests( ServiceType* const& self, StorageServerInterface const& ssi ) {
															#line 253 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
	return Future<Void>(new ServeStorageMetricsRequestsActor<ServiceType>(self, ssi));
															#line 990 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/StorageMetrics.actor.g.h"
}

#line 297 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/StorageMetrics.actor.h"
#include "flow/unactorcompiler.h"
#endif // FDBSERVER_STORAGEMETRICS_H
