#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
/*
 * MockGlobalState.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/MockGlobalState.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/DataDistribution.actor.h"
#include "fdbclient/FDBTypes.h"
#include "flow/actorcompiler.h"

class MockGlobalStateImpl {
public:
																#line 31 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
// This generated class is to be used only via waitStorageMetrics()
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
template <class WaitStorageMetricsActor>
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class WaitStorageMetricsActorState {
															#line 37 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	WaitStorageMetricsActorState(MockGlobalState* const& mgs,KeyRange const& keys,StorageMetrics const& min,StorageMetrics const& max,StorageMetrics const& permittedError,int const& shardLimit,int const& expectedShardCount) 
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		 : mgs(mgs),
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		   keys(keys),
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		   min(min),
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		   max(max),
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		   permittedError(permittedError),
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		   shardLimit(shardLimit),
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		   expectedShardCount(expectedShardCount),
															#line 36 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		   tenantInfo(),
															#line 37 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		   version(0)
															#line 60 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
	{
		fdb_probe_actor_create("waitStorageMetrics", reinterpret_cast<unsigned long>(this));

	}
	~WaitStorageMetricsActorState() 
	{
		fdb_probe_actor_destroy("waitStorageMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 38 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			;
															#line 75 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitStorageMetricsActorState();
		static_cast<WaitStorageMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 39 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		auto locations = mgs->getKeyRangeLocations(tenantInfo, keys, shardLimit, Reverse::False, SpanContext(), Optional<UID>(), UseProvisionalProxies::False, version) .get();
															#line 48 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		TraceEvent(SevDebug, "MGSWaitStorageMetrics") .detail("Phase", "GetLocation") .detail("KeyRange", keys.toString()) .detail("LocationsCount", locations.size()) .detail("ExpectedShardCount", expectedShardCount);
															#line 56 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		CODE_PROBE(expectedShardCount >= 0 && locations.size() != expectedShardCount, "Some shard is in the same location.", probe::decoration::rare);
															#line 109 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		try {
															#line 61 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			StrictFuture<Optional<StorageMetrics>> __when_expr_0 = ::waitStorageMetricsWithLocation(tenantInfo, version, keys, locations, min, max, permittedError);
															#line 61 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			if (static_cast<WaitStorageMetricsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 115 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitStorageMetricsActor*>(this)->actor_wait_state = 1;
															#line 61 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitStorageMetricsActor, 0, Optional<StorageMetrics> >*>(static_cast<WaitStorageMetricsActor*>(this)));
															#line 120 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 85 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(0.1, TaskPriority::DataDistribution);
															#line 85 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (static_cast<WaitStorageMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 137 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<WaitStorageMetricsActor*>(this)->actor_wait_state = 4;
															#line 85 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitStorageMetricsActor, 3, Void >*>(static_cast<WaitStorageMetricsActor*>(this)));
															#line 142 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			TraceEvent(SevDebug, "MGSWaitStorageMetricsHandleError").error(e);
															#line 74 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed)
															#line 154 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			{
															#line 75 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, TaskPriority::DataDistribution);
															#line 75 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				if (static_cast<WaitStorageMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 160 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
				static_cast<WaitStorageMetricsActor*>(this)->actor_wait_state = 2;
															#line 75 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitStorageMetricsActor, 1, Void >*>(static_cast<WaitStorageMetricsActor*>(this)));
															#line 165 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 76 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				if (e.code() == error_code_future_version)
															#line 172 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
				{
															#line 77 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
					StrictFuture<Void> __when_expr_2 = delay(CLIENT_KNOBS->FUTURE_VERSION_RETRY_DELAY, TaskPriority::DataDistribution);
															#line 77 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
					if (static_cast<WaitStorageMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 178 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when2(__when_expr_2.get(), loopDepth); };
					static_cast<WaitStorageMetricsActor*>(this)->actor_wait_state = 3;
															#line 77 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitStorageMetricsActor, 2, Void >*>(static_cast<WaitStorageMetricsActor*>(this)));
															#line 183 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 79 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
					bool ok = e.code() == error_code_tenant_not_found;
															#line 80 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
					TraceEvent(ok ? SevInfo : SevError, "MGSWaitStorageMetricsError").error(e);
															#line 81 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 194 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<StorageMetrics> const& res,int loopDepth) 
	{
															#line 64 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		TraceEvent(SevDebug, "MGSWaitStorageMetrics") .detail("Phase", "GetStorageMetrics") .detail("KeyRange", keys.toString()) .detail("Present", res.present());
															#line 69 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (res.present())
															#line 212 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		{
															#line 70 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			if (!static_cast<WaitStorageMetricsActor*>(this)->SAV<std::pair<Optional<StorageMetrics>, int>>::futures) { (void)(std::make_pair(res, -1)); this->~WaitStorageMetricsActorState(); static_cast<WaitStorageMetricsActor*>(this)->destroy(); return 0; }
															#line 216 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			new (&static_cast<WaitStorageMetricsActor*>(this)->SAV< std::pair<Optional<StorageMetrics>, int> >::value()) std::pair<Optional<StorageMetrics>, int>(std::make_pair(res, -1));
			this->~WaitStorageMetricsActorState();
			static_cast<WaitStorageMetricsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<StorageMetrics> && res,int loopDepth) 
	{
															#line 64 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		TraceEvent(SevDebug, "MGSWaitStorageMetrics") .detail("Phase", "GetStorageMetrics") .detail("KeyRange", keys.toString()) .detail("Present", res.present());
															#line 69 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (res.present())
															#line 232 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		{
															#line 70 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			if (!static_cast<WaitStorageMetricsActor*>(this)->SAV<std::pair<Optional<StorageMetrics>, int>>::futures) { (void)(std::make_pair(res, -1)); this->~WaitStorageMetricsActorState(); static_cast<WaitStorageMetricsActor*>(this)->destroy(); return 0; }
															#line 236 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			new (&static_cast<WaitStorageMetricsActor*>(this)->SAV< std::pair<Optional<StorageMetrics>, int> >::value()) std::pair<Optional<StorageMetrics>, int>(std::make_pair(res, -1));
			this->~WaitStorageMetricsActorState();
			static_cast<WaitStorageMetricsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<StorageMetrics> const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<StorageMetrics> && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitStorageMetricsActor*>(this)->actor_wait_state > 0) static_cast<WaitStorageMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<WaitStorageMetricsActor*>(this)->ActorCallback< WaitStorageMetricsActor, 0, Optional<StorageMetrics> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitStorageMetricsActor, 0, Optional<StorageMetrics> >*,Optional<StorageMetrics> const& value) 
	{
		fdb_probe_actor_enter("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitStorageMetricsActor, 0, Optional<StorageMetrics> >*,Optional<StorageMetrics> && value) 
	{
		fdb_probe_actor_enter("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitStorageMetricsActor, 0, Optional<StorageMetrics> >*,Error err) 
	{
		fdb_probe_actor_enter("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitStorageMetricsActor*>(this)->actor_wait_state > 0) static_cast<WaitStorageMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<WaitStorageMetricsActor*>(this)->ActorCallback< WaitStorageMetricsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitStorageMetricsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitStorageMetricsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitStorageMetricsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitStorageMetricsActor*>(this)->actor_wait_state > 0) static_cast<WaitStorageMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<WaitStorageMetricsActor*>(this)->ActorCallback< WaitStorageMetricsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitStorageMetricsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitStorageMetricsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitStorageMetricsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WaitStorageMetricsActor*>(this)->actor_wait_state > 0) static_cast<WaitStorageMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<WaitStorageMetricsActor*>(this)->ActorCallback< WaitStorageMetricsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitStorageMetricsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitStorageMetricsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitStorageMetricsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitStorageMetrics", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	MockGlobalState* mgs;
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	KeyRange keys;
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	StorageMetrics min;
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	StorageMetrics max;
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	StorageMetrics permittedError;
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	int shardLimit;
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	int expectedShardCount;
															#line 36 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	TenantInfo tenantInfo;
															#line 37 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	Version version;
															#line 625 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
};
// This generated class is to be used only via waitStorageMetrics()
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class WaitStorageMetricsActor final : public Actor<std::pair<Optional<StorageMetrics>, int>>, public ActorCallback< WaitStorageMetricsActor, 0, Optional<StorageMetrics> >, public ActorCallback< WaitStorageMetricsActor, 1, Void >, public ActorCallback< WaitStorageMetricsActor, 2, Void >, public ActorCallback< WaitStorageMetricsActor, 3, Void >, public FastAllocated<WaitStorageMetricsActor>, public WaitStorageMetricsActorState<WaitStorageMetricsActor> {
															#line 630 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
	using FastAllocated<WaitStorageMetricsActor>::operator new;
	using FastAllocated<WaitStorageMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11991562846091578368UL, 15400731152536894208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<Optional<StorageMetrics>, int>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitStorageMetricsActor, 0, Optional<StorageMetrics> >;
friend struct ActorCallback< WaitStorageMetricsActor, 1, Void >;
friend struct ActorCallback< WaitStorageMetricsActor, 2, Void >;
friend struct ActorCallback< WaitStorageMetricsActor, 3, Void >;
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	WaitStorageMetricsActor(MockGlobalState* const& mgs,KeyRange const& keys,StorageMetrics const& min,StorageMetrics const& max,StorageMetrics const& permittedError,int const& shardLimit,int const& expectedShardCount) 
															#line 650 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		 : Actor<std::pair<Optional<StorageMetrics>, int>>(),
		   WaitStorageMetricsActorState<WaitStorageMetricsActor>(mgs, keys, min, max, permittedError, shardLimit, expectedShardCount),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitStorageMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7368768244777035008UL, 1065219109917351936UL);
		ActorExecutionContextHelper __helper(static_cast<WaitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitStorageMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitStorageMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitStorageMetricsActor, 0, Optional<StorageMetrics> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitStorageMetricsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitStorageMetricsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WaitStorageMetricsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
[[nodiscard]] static Future<std::pair<Optional<StorageMetrics>, int>> waitStorageMetrics( MockGlobalState* const& mgs, KeyRange const& keys, StorageMetrics const& min, StorageMetrics const& max, StorageMetrics const& permittedError, int const& shardLimit, int const& expectedShardCount ) {
															#line 29 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	return Future<std::pair<Optional<StorageMetrics>, int>>(new WaitStorageMetricsActor(mgs, keys, min, max, permittedError, shardLimit, expectedShardCount));
															#line 685 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
}

#line 88 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"

	// SOMEDAY: reuse the NativeAPI implementation
																#line 691 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
// This generated class is to be used only via splitStorageMetrics()
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
template <class SplitStorageMetricsActor>
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class SplitStorageMetricsActorState {
															#line 697 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	SplitStorageMetricsActorState(MockGlobalState* const& mgs,KeyRange const& keys,StorageMetrics const& limit,StorageMetrics const& estimated,Optional<int> const& minSplitBytes) 
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		 : mgs(mgs),
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		   keys(keys),
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		   limit(limit),
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		   estimated(estimated),
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		   minSplitBytes(minSplitBytes),
															#line 95 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		   tenantInfo()
															#line 714 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
	{
		fdb_probe_actor_create("splitStorageMetrics", reinterpret_cast<unsigned long>(this));

	}
	~SplitStorageMetricsActorState() 
	{
		fdb_probe_actor_destroy("splitStorageMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 96 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			;
															#line 729 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SplitStorageMetricsActorState();
		static_cast<SplitStorageMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 97 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		locations = mgs->getKeyRangeLocations(tenantInfo, keys, CLIENT_KNOBS->STORAGE_METRICS_SHARD_LIMIT, Reverse::False, SpanContext(), Optional<UID>(), UseProvisionalProxies::False, 0) .get();
															#line 109 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (locations.size() == CLIENT_KNOBS->STORAGE_METRICS_SHARD_LIMIT)
															#line 761 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		{
															#line 110 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(CLIENT_KNOBS->STORAGE_METRICS_TOO_MANY_SHARDS_DELAY, TaskPriority::DataDistribution);
															#line 110 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			if (static_cast<SplitStorageMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 767 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SplitStorageMetricsActor*>(this)->actor_wait_state = 1;
															#line 110 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SplitStorageMetricsActor, 0, Void >*>(static_cast<SplitStorageMetricsActor*>(this)));
															#line 772 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 113 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		StrictFuture<Optional<Standalone<VectorRef<KeyRef>>>> __when_expr_1 = splitStorageMetricsWithLocations(locations, keys, limit, estimated, minSplitBytes);
															#line 113 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (static_cast<SplitStorageMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 788 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SplitStorageMetricsActor*>(this)->actor_wait_state = 2;
															#line 113 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SplitStorageMetricsActor, 1, Optional<Standalone<VectorRef<KeyRef>>> >*>(static_cast<SplitStorageMetricsActor*>(this)));
															#line 793 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SplitStorageMetricsActor*>(this)->actor_wait_state > 0) static_cast<SplitStorageMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<SplitStorageMetricsActor*>(this)->ActorCallback< SplitStorageMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SplitStorageMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SplitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SplitStorageMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SplitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SplitStorageMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SplitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Standalone<VectorRef<KeyRef>>> const& results,int loopDepth) 
	{
															#line 116 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (results.present())
															#line 889 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		{
															#line 117 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			if (!static_cast<SplitStorageMetricsActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(results.get()); this->~SplitStorageMetricsActorState(); static_cast<SplitStorageMetricsActor*>(this)->destroy(); return 0; }
															#line 893 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			new (&static_cast<SplitStorageMetricsActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(results.get());
			this->~SplitStorageMetricsActorState();
			static_cast<SplitStorageMetricsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 120 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, TaskPriority::DataDistribution);
															#line 120 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (static_cast<SplitStorageMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 903 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<SplitStorageMetricsActor*>(this)->actor_wait_state = 3;
															#line 120 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SplitStorageMetricsActor, 2, Void >*>(static_cast<SplitStorageMetricsActor*>(this)));
															#line 908 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Standalone<VectorRef<KeyRef>>> && results,int loopDepth) 
	{
															#line 116 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (results.present())
															#line 917 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		{
															#line 117 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			if (!static_cast<SplitStorageMetricsActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(results.get()); this->~SplitStorageMetricsActorState(); static_cast<SplitStorageMetricsActor*>(this)->destroy(); return 0; }
															#line 921 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			new (&static_cast<SplitStorageMetricsActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(results.get());
			this->~SplitStorageMetricsActorState();
			static_cast<SplitStorageMetricsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 120 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, TaskPriority::DataDistribution);
															#line 120 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (static_cast<SplitStorageMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 931 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<SplitStorageMetricsActor*>(this)->actor_wait_state = 3;
															#line 120 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SplitStorageMetricsActor, 2, Void >*>(static_cast<SplitStorageMetricsActor*>(this)));
															#line 936 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Optional<Standalone<VectorRef<KeyRef>>> const& results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(results, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Optional<Standalone<VectorRef<KeyRef>>> && results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SplitStorageMetricsActor*>(this)->actor_wait_state > 0) static_cast<SplitStorageMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<SplitStorageMetricsActor*>(this)->ActorCallback< SplitStorageMetricsActor, 1, Optional<Standalone<VectorRef<KeyRef>>> >::remove();

	}
	void a_callback_fire(ActorCallback< SplitStorageMetricsActor, 1, Optional<Standalone<VectorRef<KeyRef>>> >*,Optional<Standalone<VectorRef<KeyRef>>> const& value) 
	{
		fdb_probe_actor_enter("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SplitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SplitStorageMetricsActor, 1, Optional<Standalone<VectorRef<KeyRef>>> >*,Optional<Standalone<VectorRef<KeyRef>>> && value) 
	{
		fdb_probe_actor_enter("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SplitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SplitStorageMetricsActor, 1, Optional<Standalone<VectorRef<KeyRef>>> >*,Error err) 
	{
		fdb_probe_actor_enter("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SplitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SplitStorageMetricsActor*>(this)->actor_wait_state > 0) static_cast<SplitStorageMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<SplitStorageMetricsActor*>(this)->ActorCallback< SplitStorageMetricsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SplitStorageMetricsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SplitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SplitStorageMetricsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SplitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SplitStorageMetricsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SplitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("splitStorageMetrics", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	MockGlobalState* mgs;
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	KeyRange keys;
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	StorageMetrics limit;
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	StorageMetrics estimated;
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	Optional<int> minSplitBytes;
															#line 95 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	TenantInfo tenantInfo;
															#line 97 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	std::vector<KeyRangeLocationInfo> locations;
															#line 1117 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
};
// This generated class is to be used only via splitStorageMetrics()
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class SplitStorageMetricsActor final : public Actor<Standalone<VectorRef<KeyRef>>>, public ActorCallback< SplitStorageMetricsActor, 0, Void >, public ActorCallback< SplitStorageMetricsActor, 1, Optional<Standalone<VectorRef<KeyRef>>> >, public ActorCallback< SplitStorageMetricsActor, 2, Void >, public FastAllocated<SplitStorageMetricsActor>, public SplitStorageMetricsActorState<SplitStorageMetricsActor> {
															#line 1122 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
	using FastAllocated<SplitStorageMetricsActor>::operator new;
	using FastAllocated<SplitStorageMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12041207196981308672UL, 7399034793376776192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SplitStorageMetricsActor, 0, Void >;
friend struct ActorCallback< SplitStorageMetricsActor, 1, Optional<Standalone<VectorRef<KeyRef>>> >;
friend struct ActorCallback< SplitStorageMetricsActor, 2, Void >;
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	SplitStorageMetricsActor(MockGlobalState* const& mgs,KeyRange const& keys,StorageMetrics const& limit,StorageMetrics const& estimated,Optional<int> const& minSplitBytes) 
															#line 1141 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		 : Actor<Standalone<VectorRef<KeyRef>>>(),
		   SplitStorageMetricsActorState<SplitStorageMetricsActor>(mgs, keys, limit, estimated, minSplitBytes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("splitStorageMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15024100830874825216UL, 16341904195814654976UL);
		ActorExecutionContextHelper __helper(static_cast<SplitStorageMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("splitStorageMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("splitStorageMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SplitStorageMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SplitStorageMetricsActor, 1, Optional<Standalone<VectorRef<KeyRef>>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SplitStorageMetricsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<KeyRef>>> splitStorageMetrics( MockGlobalState* const& mgs, KeyRange const& keys, StorageMetrics const& limit, StorageMetrics const& estimated, Optional<int> const& minSplitBytes ) {
															#line 90 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	return Future<Standalone<VectorRef<KeyRef>>>(new SplitStorageMetricsActor(mgs, keys, limit, estimated, minSplitBytes));
															#line 1175 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
}

#line 123 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
};

class MockStorageServerImpl {
public:
																#line 1183 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
// This generated class is to be used only via waitMetricsTenantAware()
															#line 127 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
template <class WaitMetricsTenantAwareActor>
															#line 127 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class WaitMetricsTenantAwareActorState {
															#line 1189 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
															#line 127 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	WaitMetricsTenantAwareActorState(MockStorageServer* const& self,WaitMetricsRequest const& req) 
															#line 127 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
															#line 127 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		 : self(self),
															#line 127 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		   req(req)
															#line 1198 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
	{
		fdb_probe_actor_create("waitMetricsTenantAware", reinterpret_cast<unsigned long>(this));

	}
	~WaitMetricsTenantAwareActorState() 
	{
		fdb_probe_actor_destroy("waitMetricsTenantAware", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 128 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			if (req.tenantInfo.hasTenant())
															#line 1213 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			{
															#line 130 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				Optional<TenantMapEntry> entry;
															#line 131 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				Optional<Key> tenantPrefix = entry.map(&TenantMapEntry::prefix);
															#line 132 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				if (tenantPrefix.present())
															#line 1221 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
				{
															#line 133 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
					UNREACHABLE();
															#line 1225 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
				}
			}
															#line 138 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			if (!self->isReadable(req.keys))
															#line 1230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			{
															#line 139 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				self->sendErrorWithPenalty(req.reply, wrong_shard_server(), self->getPenalty());
															#line 1234 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
				loopDepth = a_body1cont1(loopDepth);
			}
			else
			{
															#line 141 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->metrics.waitMetrics(req, delayJittered(SERVER_KNOBS->STORAGE_METRIC_TIMEOUT));
															#line 141 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				if (static_cast<WaitMetricsTenantAwareActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1243 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitMetricsTenantAwareActor*>(this)->actor_wait_state = 1;
															#line 141 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitMetricsTenantAwareActor, 0, Void >*>(static_cast<WaitMetricsTenantAwareActor*>(this)));
															#line 1248 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitMetricsTenantAwareActorState();
		static_cast<WaitMetricsTenantAwareActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 143 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (!static_cast<WaitMetricsTenantAwareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitMetricsTenantAwareActorState(); static_cast<WaitMetricsTenantAwareActor*>(this)->destroy(); return 0; }
															#line 1272 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		new (&static_cast<WaitMetricsTenantAwareActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitMetricsTenantAwareActorState();
		static_cast<WaitMetricsTenantAwareActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitMetricsTenantAwareActor*>(this)->actor_wait_state > 0) static_cast<WaitMetricsTenantAwareActor*>(this)->actor_wait_state = 0;
		static_cast<WaitMetricsTenantAwareActor*>(this)->ActorCallback< WaitMetricsTenantAwareActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitMetricsTenantAwareActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitMetricsTenantAware", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitMetricsTenantAwareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitMetricsTenantAware", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitMetricsTenantAwareActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitMetricsTenantAware", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitMetricsTenantAwareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitMetricsTenantAware", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitMetricsTenantAwareActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitMetricsTenantAware", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitMetricsTenantAwareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitMetricsTenantAware", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 127 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	MockStorageServer* self;
															#line 127 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	WaitMetricsRequest req;
															#line 1371 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
};
// This generated class is to be used only via waitMetricsTenantAware()
															#line 127 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class WaitMetricsTenantAwareActor final : public Actor<Void>, public ActorCallback< WaitMetricsTenantAwareActor, 0, Void >, public FastAllocated<WaitMetricsTenantAwareActor>, public WaitMetricsTenantAwareActorState<WaitMetricsTenantAwareActor> {
															#line 1376 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
	using FastAllocated<WaitMetricsTenantAwareActor>::operator new;
	using FastAllocated<WaitMetricsTenantAwareActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9926295238298543360UL, 6683685371201012480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitMetricsTenantAwareActor, 0, Void >;
															#line 127 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	WaitMetricsTenantAwareActor(MockStorageServer* const& self,WaitMetricsRequest const& req) 
															#line 1393 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		 : Actor<Void>(),
		   WaitMetricsTenantAwareActorState<WaitMetricsTenantAwareActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitMetricsTenantAware", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10820025973110180352UL, 6430555454419745280UL);
		ActorExecutionContextHelper __helper(static_cast<WaitMetricsTenantAwareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitMetricsTenantAware");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitMetricsTenantAware", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitMetricsTenantAwareActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 127 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
[[nodiscard]] static Future<Void> waitMetricsTenantAware( MockStorageServer* const& self, WaitMetricsRequest const& req ) {
															#line 127 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	return Future<Void>(new WaitMetricsTenantAwareActor(self, req));
															#line 1425 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
}

#line 145 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"

	// Randomly generate keys and kv size between the fetch range, updating the byte sample.
	// Once the fetchKeys return, the shard status will become FETCHED.
																#line 1432 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
// This generated class is to be used only via waitFetchKeysFinish()
															#line 148 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
template <class WaitFetchKeysFinishActor>
															#line 148 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class WaitFetchKeysFinishActorState {
															#line 1438 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
															#line 148 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	WaitFetchKeysFinishActorState(MockStorageServer* const& self,MockStorageServer::FetchKeysParams const& params) 
															#line 148 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
															#line 148 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		 : self(self),
															#line 148 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		   params(params),
															#line 149 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		   interval("MockFetchKeys")
															#line 1449 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
	{
		fdb_probe_actor_create("waitFetchKeysFinish", reinterpret_cast<unsigned long>(this));

	}
	~WaitFetchKeysFinishActorState() 
	{
		fdb_probe_actor_destroy("waitFetchKeysFinish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 151 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(params.totalRangeBytes > 0);
															#line 152 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			chunkCount = std::ceil(params.totalRangeBytes * 1.0 / SERVER_KNOBS->FETCH_BLOCK_BYTES);
															#line 153 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			currentTotal = 0;
															#line 154 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			lastKey = params.keys.begin;
															#line 156 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			TraceEvent(SevDebug, interval.begin(), self->id) .detail("Range", params.keys) .detail("ChunkCount", chunkCount) .detail("TotalBytes", params.totalRangeBytes);
															#line 161 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			i = 0;
															#line 162 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			;
															#line 1476 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitFetchKeysFinishActorState();
		static_cast<WaitFetchKeysFinishActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 207 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		self->setShardStatus(params.keys, MockShardStatus::FETCHED);
															#line 208 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		TraceEvent(SevDebug, interval.end(), self->id).log();
															#line 209 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (!static_cast<WaitFetchKeysFinishActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitFetchKeysFinishActorState(); static_cast<WaitFetchKeysFinishActor*>(this)->destroy(); return 0; }
															#line 1503 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		new (&static_cast<WaitFetchKeysFinishActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitFetchKeysFinishActorState();
		static_cast<WaitFetchKeysFinishActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 162 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (!(i < chunkCount && currentTotal < params.totalRangeBytes))
															#line 1522 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 163 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delayJittered(0.1, TaskPriority::FetchKeys);
															#line 163 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (static_cast<WaitFetchKeysFinishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1530 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitFetchKeysFinishActor*>(this)->actor_wait_state = 1;
															#line 163 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitFetchKeysFinishActor, 0, Void >*>(static_cast<WaitFetchKeysFinishActor*>(this)));
															#line 1535 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 165 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		int remainedBytes = (chunkCount == 1 ? params.totalRangeBytes : SERVER_KNOBS->FETCH_BLOCK_BYTES);
															#line 167 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		for(;remainedBytes >= lastKey.size();) {
															#line 168 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			Key nextKey;
															#line 170 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			for(int j = 0;j < 10;j++) {
															#line 171 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				nextKey = randomKeyBetween(KeyRangeRef(lastKey, params.keys.end));
															#line 172 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				if (nextKey < params.keys.end)
															#line 1567 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
				{
					break;
				}
			}
															#line 176 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			++self->counters.kvFetched;
															#line 179 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			if (nextKey == params.keys.end)
															#line 1576 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			{
															#line 180 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				auto bytes = params.totalRangeBytes - currentTotal;
															#line 181 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				self->counters.bytesFetched += bytes;
															#line 182 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				self->byteSampleApplySet(lastKey, bytes);
															#line 183 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				self->usedDiskSpace += bytes;
															#line 184 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				currentTotal = params.totalRangeBytes;
															#line 185 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				TraceEvent(SevWarn, "MockFetchKeysInaccurateSample", self->id) .detail("PairId", interval.pairID) .detail("LastKey", lastKey) .detail("Size", bytes);
															#line 1590 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
				break;
			}
															#line 192 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			int maxSize = std::min(remainedBytes, 130000) + 1;
															#line 193 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			int randomSize = deterministicRandom()->randomInt(lastKey.size(), maxSize);
															#line 194 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			self->counters.bytesFetched += randomSize;
															#line 195 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			self->usedDiskSpace += randomSize;
															#line 196 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			currentTotal += randomSize;
															#line 198 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			self->byteSampleApplySet(lastKey, randomSize);
															#line 199 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			remainedBytes -= randomSize;
															#line 200 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			lastKey = nextKey;
															#line 201 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			DisabledTraceEvent(SevDebug, "MockFetchKeys_SingleKey", self->id) .detail("LastKey", lastKey) .detail("RemainedBytes", remainedBytes);
															#line 1611 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		}
															#line 162 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		++i;
															#line 1615 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 165 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		int remainedBytes = (chunkCount == 1 ? params.totalRangeBytes : SERVER_KNOBS->FETCH_BLOCK_BYTES);
															#line 167 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		for(;remainedBytes >= lastKey.size();) {
															#line 168 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			Key nextKey;
															#line 170 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			for(int j = 0;j < 10;j++) {
															#line 171 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				nextKey = randomKeyBetween(KeyRangeRef(lastKey, params.keys.end));
															#line 172 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				if (nextKey < params.keys.end)
															#line 1634 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
				{
					break;
				}
			}
															#line 176 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			++self->counters.kvFetched;
															#line 179 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			if (nextKey == params.keys.end)
															#line 1643 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			{
															#line 180 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				auto bytes = params.totalRangeBytes - currentTotal;
															#line 181 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				self->counters.bytesFetched += bytes;
															#line 182 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				self->byteSampleApplySet(lastKey, bytes);
															#line 183 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				self->usedDiskSpace += bytes;
															#line 184 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				currentTotal = params.totalRangeBytes;
															#line 185 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				TraceEvent(SevWarn, "MockFetchKeysInaccurateSample", self->id) .detail("PairId", interval.pairID) .detail("LastKey", lastKey) .detail("Size", bytes);
															#line 1657 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
				break;
			}
															#line 192 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			int maxSize = std::min(remainedBytes, 130000) + 1;
															#line 193 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			int randomSize = deterministicRandom()->randomInt(lastKey.size(), maxSize);
															#line 194 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			self->counters.bytesFetched += randomSize;
															#line 195 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			self->usedDiskSpace += randomSize;
															#line 196 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			currentTotal += randomSize;
															#line 198 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			self->byteSampleApplySet(lastKey, randomSize);
															#line 199 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			remainedBytes -= randomSize;
															#line 200 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			lastKey = nextKey;
															#line 201 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			DisabledTraceEvent(SevDebug, "MockFetchKeys_SingleKey", self->id) .detail("LastKey", lastKey) .detail("RemainedBytes", remainedBytes);
															#line 1678 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		}
															#line 162 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		++i;
															#line 1682 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitFetchKeysFinishActor*>(this)->actor_wait_state > 0) static_cast<WaitFetchKeysFinishActor*>(this)->actor_wait_state = 0;
		static_cast<WaitFetchKeysFinishActor*>(this)->ActorCallback< WaitFetchKeysFinishActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitFetchKeysFinishActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitFetchKeysFinish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFetchKeysFinishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFetchKeysFinish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitFetchKeysFinishActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitFetchKeysFinish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFetchKeysFinishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFetchKeysFinish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitFetchKeysFinishActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitFetchKeysFinish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFetchKeysFinishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitFetchKeysFinish", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 148 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	MockStorageServer* self;
															#line 148 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	MockStorageServer::FetchKeysParams params;
															#line 149 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	TraceInterval interval;
															#line 152 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	int chunkCount;
															#line 153 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	int64_t currentTotal;
															#line 154 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	Key lastKey;
															#line 161 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	int i;
															#line 1776 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
};
// This generated class is to be used only via waitFetchKeysFinish()
															#line 148 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class WaitFetchKeysFinishActor final : public Actor<Void>, public ActorCallback< WaitFetchKeysFinishActor, 0, Void >, public FastAllocated<WaitFetchKeysFinishActor>, public WaitFetchKeysFinishActorState<WaitFetchKeysFinishActor> {
															#line 1781 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
	using FastAllocated<WaitFetchKeysFinishActor>::operator new;
	using FastAllocated<WaitFetchKeysFinishActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13511259945098611200UL, 3494604173999226880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitFetchKeysFinishActor, 0, Void >;
															#line 148 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	WaitFetchKeysFinishActor(MockStorageServer* const& self,MockStorageServer::FetchKeysParams const& params) 
															#line 1798 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		 : Actor<Void>(),
		   WaitFetchKeysFinishActorState<WaitFetchKeysFinishActor>(self, params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitFetchKeysFinish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1026322101817255168UL, 9384391949738916352UL);
		ActorExecutionContextHelper __helper(static_cast<WaitFetchKeysFinishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitFetchKeysFinish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitFetchKeysFinish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitFetchKeysFinishActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 148 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
[[nodiscard]] static Future<Void> waitFetchKeysFinish( MockStorageServer* const& self, MockStorageServer::FetchKeysParams const& params ) {
															#line 148 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	return Future<Void>(new WaitFetchKeysFinishActor(self, params));
															#line 1830 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
}

#line 211 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
};

bool MockStorageServer::allShardStatusEqual(const KeyRangeRef& range, MockShardStatus status) const {
	auto ranges = serverKeys.intersectingRanges(range);
	ASSERT(!ranges.empty()); // at least the range is allKeys

	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		if (it->cvalue().status != status)
			return false;
	}
	return true;
}

bool MockStorageServer::allShardStatusIn(const KeyRangeRef& range, const std::set<MockShardStatus>& status) const {
	auto ranges = serverKeys.intersectingRanges(range);
	ASSERT(!ranges.empty()); // at least the range is allKeys

	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		// fmt::print("allShardStatusIn: {}: {} \n", id.toString(), it->range().toString());
		if (!status.contains(it->cvalue().status))
			return false;
	}
	return true;
}

void MockStorageServer::setShardStatus(const KeyRangeRef& range, MockShardStatus status) {
	auto ranges = serverKeys.intersectingRanges(range);
	// ranges at least has allKeys
	ASSERT(!ranges.empty());

	DisabledTraceEvent(SevDebug, "SetShardStatus", ssi.id()).detail("Range", range);

	// change the shard boundary if the status will change
	if (ranges.begin().begin() < range.begin && ranges.begin().end() > range.end &&
	    ranges.begin()->cvalue().status != status) {
		CODE_PROBE(true, "Implicitly split single shard to 3 pieces");
		threeWayShardSplitting(ranges.begin().range(), range, ranges.begin().cvalue().shardSize);
	} else {
		if (ranges.begin().begin() < range.begin && ranges.begin()->cvalue().status != status) {
			CODE_PROBE(true, "Implicitly split begin range to 2 pieces");
			twoWayShardSplitting(ranges.begin().range(), range.begin, ranges.begin().cvalue().shardSize);
		}
		if (ranges.end().begin() > range.end) {
			auto lastRange = ranges.end();
			--lastRange;
			if (lastRange->cvalue().status != status) {
				CODE_PROBE(true, "Implicitly split end range to 2 pieces");
				twoWayShardSplitting(lastRange.range(), range.end, lastRange.cvalue().shardSize);
			}
		}
	}
	ranges = serverKeys.containedRanges(range);

	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		auto oldStatus = it->cvalue().status;
		if (isStatusTransitionValid(oldStatus, status)) {
			it->value().status = status;
		} else if ((oldStatus == MockShardStatus::COMPLETED || oldStatus == MockShardStatus::FETCHED) &&
		           (status == MockShardStatus::INFLIGHT || status == MockShardStatus::FETCHED)) {
			CODE_PROBE(true, "Shard already on server");
		} else {
			TraceEvent(SevError, "MockShardStatusTransitionError", id)
			    .detail("From", oldStatus)
			    .detail("To", status)
			    .detail("KeyBegin", range.begin)
			    .detail("KeyEnd", range.begin);
			ASSERT(false);
		}
	}
}

void MockStorageServer::coalesceCompletedRange(const KeyRangeRef& range) {
	auto ranges = serverKeys.intersectingRanges(range);
	// ranges at least has allKeys
	ASSERT(!ranges.empty());
	auto allRanges = serverKeys.ranges();
	auto left = ranges.begin(), right = ranges.end();
	while (true) {
		if (left->cvalue().status != MockShardStatus::COMPLETED) {
			ASSERT(left != ranges.begin());
			++left;
			break;
		}
		if (left == allRanges.begin())
			break;
		--left;
	}

	while (right != allRanges.end() && right->cvalue().status == MockShardStatus::COMPLETED) {
		++right;
	}

	int newSize = 0;
	for (auto it = left; it != right; ++it) {
		ASSERT(it->cvalue().status == MockShardStatus::COMPLETED);
		newSize += it->cvalue().shardSize;
		it->value().shardSize = 0;
	}
	auto beginKey = left.begin(), endKey = right.begin();
	serverKeys.coalesce(KeyRangeRef(beginKey, endKey));
	serverKeys[beginKey].shardSize = newSize;
}

// split the out range [a, d) based on the inner range's boundary [b, c). The result would be [a,b), [b,c), [c,d). The
// size of the new shards are randomly split from old size of [a, d)
void MockStorageServer::threeWayShardSplitting(const KeyRangeRef& outerRange,
                                               const KeyRangeRef& innerRange,
                                               uint64_t outerRangeSize) {
	ASSERT(outerRange.contains(innerRange));
	if (outerRange == innerRange) {
		return;
	}

	Key left = outerRange.begin;

	// assume the split are even
	int leftSize = outerRangeSize / 3;
	int rightSize = leftSize;
	int midSize = outerRangeSize - leftSize - rightSize;

	serverKeys.insert(innerRange, { serverKeys[left].status, (uint64_t)midSize });
	serverKeys[left].shardSize = leftSize;
	serverKeys[innerRange.end].shardSize = rightSize;
}

// split the range [a,c) with split point b. The result would be [a, b), [b, c). The
// size of the new shards are randomly split from old size of [a, c)
void MockStorageServer::twoWayShardSplitting(const KeyRangeRef& range, const KeyRef& splitPoint, uint64_t rangeSize) {
	if (splitPoint == range.begin || !range.contains(splitPoint)) {
		return;
	}
	Key left = range.begin;
	DisabledTraceEvent(SevDebug, "TwoWayShardSplitting")
	    .detail("Range", range)
	    .detail("SplitPoint", splitPoint)
	    .detail("RangeSize", rangeSize);
	// Assume equally split the old range
	int leftSize = rangeSize / 2, rightSize = rangeSize - leftSize;
	serverKeys.rawInsert(splitPoint, { serverKeys[left].status, (uint64_t)rightSize });
	serverKeys[left].shardSize = leftSize;
}

void MockStorageServer::removeShard(const KeyRangeRef& range) {
	auto rangeSize = sumRangeSize(range);
	usedDiskSpace -= rangeSize;
	serverKeys.insert(range, MockStorageServer::ShardInfo{ MockShardStatus::UNSET, 0 });
	serverKeys.coalesce(range);
	byteSampleApplyClear(range);
	metrics.notifyNotReadable(range);
}

uint64_t MockStorageServer::sumRangeSize(const KeyRangeRef& range) const {
	auto ranges = serverKeys.intersectingRanges(range);
	uint64_t totalSize = 0;
	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		totalSize += it->cvalue().shardSize;
	}
	return totalSize;
}

void MockStorageServer::addActor(Future<Void> future) {
	actors.add(future);
}

void MockStorageServer::getSplitPoints(const SplitRangeRequest& req) {}

Future<Void> MockStorageServer::waitMetricsTenantAware(const WaitMetricsRequest& req) {
	return MockStorageServerImpl::waitMetricsTenantAware(this, req);
}

void MockStorageServer::getStorageMetrics(const GetStorageMetricsRequest& req) {
	StorageBytes storageBytes(
	    totalDiskSpace - usedDiskSpace, totalDiskSpace, usedDiskSpace, totalDiskSpace - usedDiskSpace);
	metrics.getStorageMetrics(
	    req, storageBytes, counters.bytesInput.getRate(), 0, now(), 0, counters.bytesInput.getValue(), 0);
	// FIXME: MockStorageServer does not support bytesDurable yet
}

void MockStorageServer::getSplitMetrics(const SplitMetricsRequest& req) {
	this->metrics.splitMetrics(req);
}

void MockStorageServer::getHotRangeMetrics(const ReadHotSubRangeRequest& req) {
	this->metrics.getReadHotRanges(req);
}

int64_t MockStorageServer::getHotShardsMetrics(const KeyRange& range) {
	return 0;
}

Future<Void> MockStorageServer::run() {
	ssi.initEndpoints();
	ssi.startAcceptingRequests();
	IFailureMonitor::failureMonitor().setStatus(ssi.address(), FailureStatus(false));

	TraceEvent("MockStorageServerStart", ssi.id()).detail("Address", ssi.address());
	auto& recruited = ssi;
	DUMPTOKEN(recruited.getStorageMetrics);
	addActor(serveStorageMetricsRequests(this, ssi));
	addActor(counters.cc.traceCounters("MockStorageMetrics",
	                                   ssi.id(),
	                                   SERVER_KNOBS->STORAGE_LOGGING_DELAY,
	                                   std::string(),
	                                   [self = this](TraceEvent& te) {
		                                   te.detail("CpuUsage", self->calculateCpuUsage());
		                                   te.detail("DiskUsedBytes", self->usedDiskSpace);
		                                   te.detail("BytesStored", self->metrics.byteSample.getEstimate(allKeys));
	                                   }));
	return actors.getResult();
}

void MockStorageServer::set(KeyRef const& key, int64_t bytes, int64_t oldBytes) {
	++counters.mutations;
	++counters.setMutations;
	counters.mutationBytes += bytes;
	counters.bytesInput += mvccStorageBytes(bytes);

	notifyWriteMetrics(key, bytes);
	byteSampleApplySet(key, bytes);
	auto delta = bytes - oldBytes;
	usedDiskSpace += delta;
	serverKeys[key].shardSize += delta;
}

void MockStorageServer::clear(KeyRef const& key, int64_t bytes) {
	++counters.mutations;
	++counters.clearRangeMutations;
	counters.mutationBytes += key.size();
	counters.bytesInput += mvccStorageBytes(key.size());

	notifyWriteMetrics(key, bytes);
	KeyRange sr = singleKeyRange(key);
	byteSampleApplyClear(sr);
	usedDiskSpace -= bytes;
	serverKeys[key].shardSize -= bytes;
}

int64_t MockStorageServer::clearRange(KeyRangeRef const& range, int64_t beginShardBytes, int64_t endShardBytes) {
	++counters.mutations;
	++counters.clearRangeMutations;
	counters.mutationBytes += range.expectedSize();
	counters.bytesInput += mvccStorageBytes(range.expectedSize());

	notifyWriteMetrics(range.begin, range.begin.size() + range.end.size());
	byteSampleApplyClear(range);
	auto totalByteSize = estimateRangeTotalBytes(range, beginShardBytes, endShardBytes);
	usedDiskSpace -= totalByteSize;
	clearRangeTotalBytes(range, beginShardBytes, endShardBytes);
	return totalByteSize;
}

void MockStorageServer::get(KeyRef const& key, int64_t bytes) {
	++counters.finishedQueries;
	counters.bytesQueried += bytes;

	// If the read yields no value, randomly sample the empty read.
	int64_t bytesReadPerKSecond = std::max(bytes, SERVER_KNOBS->EMPTY_READ_PENALTY);
	metrics.notifyBytesReadPerKSecond(key, bytesReadPerKSecond);
}

int64_t MockStorageServer::getRange(KeyRangeRef const& range, int64_t beginShardBytes, int64_t endShardBytes) {
	++counters.finishedQueries;

	int64_t totalByteSize = estimateRangeTotalBytes(range, beginShardBytes, endShardBytes);
	counters.bytesQueried += totalByteSize;
	// For performance concerns, the cost of a range read is billed to the start key and end key of the
	// range.
	if (totalByteSize > 0) {
		int64_t bytesReadPerKSecond = std::max(totalByteSize, SERVER_KNOBS->EMPTY_READ_PENALTY) / 2;
		metrics.notifyBytesReadPerKSecond(range.begin, bytesReadPerKSecond);
		metrics.notifyBytesReadPerKSecond(range.end, bytesReadPerKSecond);
	}
	return totalByteSize;
}

int64_t MockStorageServer::estimateRangeTotalBytes(KeyRangeRef const& range,
                                                   int64_t beginShardBytes,
                                                   int64_t endShardBytes) {
	int64_t totalByteSize = 0;
	auto ranges = serverKeys.intersectingRanges(range);

	// use the beginShardBytes as partial size
	if (ranges.begin().begin() < range.begin) {
		ranges.pop_front();
		totalByteSize += beginShardBytes;
	}
	// use the endShardBytes as partial size
	if (ranges.end().begin() < range.end) {
		totalByteSize += endShardBytes;
	}
	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		totalByteSize += it->cvalue().shardSize;
	}
	return totalByteSize;
}

void MockStorageServer::clearRangeTotalBytes(KeyRangeRef const& range, int64_t beginShardBytes, int64_t endShardBytes) {
	auto ranges = serverKeys.intersectingRanges(range);

	// use the beginShardBytes as partial size
	if (ranges.begin().begin() < range.begin) {
		auto delta = std::min(ranges.begin().value().shardSize, (uint64_t)beginShardBytes);
		ranges.begin().value().shardSize -= delta;
		ranges.pop_front();
	}
	// use the endShardBytes as partial size
	if (ranges.end().begin() < range.end) {
		auto delta = std::min(ranges.end().value().shardSize, (uint64_t)endShardBytes);
		ranges.end().value().shardSize -= delta;
	}
	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		it->value().shardSize = 0;
	}
}

void MockStorageServer::notifyWriteMetrics(KeyRef const& key, int64_t size) {
	// update write bandwidth and iops as mock the cost of writing a mutation
	StorageMetrics s;
	// FIXME: remove the / 2 and double the related knobs.
	s.bytesWrittenPerKSecond = mvccStorageBytes(size) / 2;
	s.iosPerKSecond = 1;
	metrics.notify(key, s);
}

void MockStorageServer::signalFetchKeys(const KeyRangeRef& range, int64_t rangeTotalBytes) {
	if (!allShardStatusEqual(range, MockShardStatus::COMPLETED)) {
		actors.add(MockStorageServerImpl::waitFetchKeysFinish(this, { range, rangeTotalBytes }));
	}
}

HealthMetrics::StorageStats MockStorageServer::getStorageStats() const {
	HealthMetrics::StorageStats res;
	res.diskUsage = usedDiskSpace * 100.0 / totalDiskSpace;
	res.cpuUsage = calculateCpuUsage();
	return res;
}

void MockStorageServer::byteSampleApplySet(KeyRef const& key, int64_t kvSize) {
	// Update byteSample in memory and notify waiting metrics
	ByteSampleInfo sampleInfo = isKeyValueInSample(key, kvSize);
	auto& byteSample = metrics.byteSample.sample;

	int64_t delta = 0;
	auto old = byteSample.find(key);
	if (old != byteSample.end())
		delta = -byteSample.getMetric(old);

	if (sampleInfo.inSample) {
		delta += sampleInfo.sampledSize;
		byteSample.insert(key, sampleInfo.sampledSize);
	} else if (old != byteSample.end()) {
		byteSample.erase(old);
	}

	if (delta)
		metrics.notifyBytes(key, delta);
}

void MockStorageServer::byteSampleApplyClear(KeyRangeRef const& range) {
	// Update byteSample and notify waiting metrics

	auto& byteSample = metrics.byteSample.sample;
	bool any = false;

	if (range.begin < allKeys.end) {
		// NotifyBytes should not be called for keys past allKeys.end
		KeyRangeRef searchRange = KeyRangeRef(range.begin, std::min(range.end, allKeys.end));

		auto r = metrics.waitMetricsMap.intersectingRanges(searchRange);
		for (auto shard = r.begin(); shard != r.end(); ++shard) {
			KeyRangeRef intersectingRange = shard.range() & range;
			int64_t bytes = byteSample.sumRange(intersectingRange.begin, intersectingRange.end);
			metrics.notifyBytes(shard, -bytes);
			any = any || bytes > 0;
		}
	}

	if (range.end > allKeys.end && byteSample.sumRange(std::max(allKeys.end, range.begin), range.end) > 0)
		any = true;

	if (any) {
		byteSample.eraseAsync(range.begin, range.end);
	}
}

double MockStorageServer::calculateCpuUsage() const {
	double res = counters.mutations.getRate() * write_op_cpu_multiplier +
	             counters.finishedQueries.getRate() * read_op_cpu_multiplier +
	             counters.mutationBytes.getRate() * write_byte_cpu_multiplier +
	             counters.bytesQueried.getRate() * read_byte_cpu_multiplier;
	return std::min(100.0, res);
}

std::shared_ptr<MockGlobalState>& MockGlobalState::g_mockState() {
	static std::shared_ptr<MockGlobalState> res(new MockGlobalState);
	return res;
}

void MockGlobalState::initializeClusterLayout(const BasicSimulationConfig& conf) {
	fmt::print("MGS Cluster Layout: {} dc, {} machines, {} processes per machine.\n",
	           conf.datacenters,
	           conf.machine_count,
	           conf.processes_per_machine);

	int mod = conf.machine_count % conf.datacenters;
	for (int i = 0; i < conf.datacenters; ++i) {
		Standalone<StringRef> dcId(StringRef(fmt::format("data_hall_{}", i)));
		clusterLayout.emplace_back(new mock::TopologyObject(mock::TopologyObject::DATA_HALL, dcId));

		auto& dc = clusterLayout.back();
		int machineCount = conf.machine_count / conf.datacenters + int(i < mod);
		for (int j = 0; j < machineCount; ++j) {
			Standalone<StringRef> mcId(StringRef(fmt::format("machine_{}_{}", i, j)));
			dc->children.emplace_back(new mock::TopologyObject(mock::TopologyObject::MACHINE, mcId, dc));

			auto& machine = dc->children.back();
			for (int k = 0; k < conf.processes_per_machine; ++k) {
				Standalone<StringRef> pid(StringRef(fmt::format("process_{}_{}_{}", i, j, k)));
				LocalityData localityData(pid, mcId, mcId, dcId);
				processes.emplace_back(new mock::Process(localityData, pid, machine));
				machine->children.emplace_back(processes.back());

				if (seedProcesses.size() < conf.db.storageTeamSize && j == 0 && k == 0) {
					seedProcesses.emplace_back(processes.back());
					fmt::print("(seed) ");
				}
				fmt::print("Mock Process: {}\n", processes.back()->locality.toString());
			}
		}
	}
}

void MockGlobalState::initializeAsEmptyDatabaseMGS(const DatabaseConfiguration& conf, uint64_t defaultDiskSpace) {
	ASSERT(conf.storageTeamSize > 0);
	ASSERT(!seedProcesses.empty());
	configuration = conf;
	std::vector<UID> serverIds;
	fmt::print("Initial Team Size: {}, initial server Ids: ", conf.storageTeamSize);
	for (int i = 1; i <= conf.storageTeamSize; ++i) {
		UID id = indexToUID(i);
		serverIds.push_back(id);

		// select seed Storage Server
		StorageServerInterface ssi(id);
		auto& process = seedProcesses[(i - 1) % seedProcesses.size()];
		ssi.locality = process->locality;
		process->ssInterfaces.push_back(ssi);
		fmt::print("{}, ", id.toString());

		allServers[id] = makeReference<MockStorageServer>(ssi, defaultDiskSpace);
		allServers[id]->serverKeys.insert(allKeys, { MockShardStatus::COMPLETED, 0 });
	}
	fmt::print("\n");
	shardMapping->assignRangeToTeams(allKeys, { Team(serverIds, true) });
}

void MockGlobalState::addStorageServer(StorageServerInterface server, uint64_t diskSpace) {
	allServers[server.id()] = makeReference<MockStorageServer>(server, diskSpace);
}

void MockGlobalState::addStoragePerProcess(uint64_t defaultDiskSpace) {
	for (auto p : processes) {
		if (p->ssInterfaces.empty()) {
			p->ssInterfaces.emplace_back(deterministicRandom()->randomUniqueID());
			p->ssInterfaces.back().locality = p->locality;
			addStorageServer(p->ssInterfaces.back(), defaultDiskSpace);
		}
	}
}

bool MockGlobalState::serverIsSourceForShard(const UID& serverId, KeyRangeRef shard, bool inFlightShard) {
	if (!allServers.contains(serverId))
		return false;

	// check serverKeys
	auto& mss = allServers.at(serverId);
	if (!mss->allShardStatusEqual(shard, MockShardStatus::COMPLETED)) {
		return false;
	}

	// check keyServers
	auto teams = shardMapping->getTeamsForFirstShard(shard);
	if (inFlightShard) {
		return std::any_of(teams.second.begin(), teams.second.end(), [&serverId](const Team& team) {
			return team.hasServer(serverId);
		});
	}
	return std::any_of(
	    teams.first.begin(), teams.first.end(), [&serverId](const Team& team) { return team.hasServer(serverId); });
}

bool MockGlobalState::serverIsDestForShard(const UID& serverId, KeyRangeRef shard) {
	TraceEvent(SevDebug, "ServerIsDestForShard")
	    .detail("ServerId", serverId)
	    .detail("Keys", shard)
	    .detail("Contains", allServers.contains(serverId));

	if (!allServers.contains(serverId))
		return false;

	// check serverKeys
	auto& mss = allServers.at(serverId);
	if (!mss->allShardStatusIn(shard,
	                           { MockShardStatus::INFLIGHT, MockShardStatus::COMPLETED, MockShardStatus::FETCHED })) {
		return false;
	}

	// check keyServers
	auto teams = shardMapping->getTeamsForFirstShard(shard);
	return !teams.second.empty() && std::any_of(teams.first.begin(), teams.first.end(), [&serverId](const Team& team) {
		return team.hasServer(serverId);
	});
}

bool MockGlobalState::allShardsRemovedFromServer(const UID& serverId) {
	return allServers.contains(serverId) && shardMapping->getNumberOfShards(serverId) == 0;
}

Future<std::pair<Optional<StorageMetrics>, int>> MockGlobalState::waitStorageMetrics(
    const KeyRange& keys,
    const StorageMetrics& min,
    const StorageMetrics& max,
    const StorageMetrics& permittedError,
    int shardLimit,
    int expectedShardCount) {
	return MockGlobalStateImpl::waitStorageMetrics(
	    this, keys, min, max, permittedError, shardLimit, expectedShardCount);
}

Reference<LocationInfo> buildLocationInfo(const std::vector<StorageServerInterface>& interfaces) {
	// construct the location info with the servers
	std::vector<Reference<ReferencedInterface<StorageServerInterface>>> serverRefs;
	serverRefs.reserve(interfaces.size());
	for (const auto& interf : interfaces) {
		serverRefs.push_back(makeReference<ReferencedInterface<StorageServerInterface>>(interf));
	}

	return makeReference<LocationInfo>(serverRefs);
}

Future<KeyRangeLocationInfo> MockGlobalState::getKeyLocation(TenantInfo tenant,
                                                             Key key,
                                                             SpanContext spanContext,
                                                             Optional<UID> debugID,
                                                             UseProvisionalProxies useProvisionalProxies,
                                                             Reverse isBackward,
                                                             Version version) {
	if (isBackward) {
		// DD never ask for backward range.
		UNREACHABLE();
	}
	ASSERT(key < allKeys.end);

	GetKeyServerLocationsReply rep;
	KeyRange single = singleKeyRange(key);
	auto teamPair = shardMapping->getTeamsForFirstShard(single);
	auto& srcTeam = teamPair.second.empty() ? teamPair.first : teamPair.second;
	ASSERT_EQ(srcTeam.size(), 1);
	rep.results.emplace_back(single, extractStorageServerInterfaces(srcTeam.front().servers));

	return KeyRangeLocationInfo(KeyRange(toPrefixRelativeRange(rep.results[0].first, tenant.prefix), rep.arena),
	                            buildLocationInfo(rep.results[0].second));
}

Future<std::vector<KeyRangeLocationInfo>> MockGlobalState::getKeyRangeLocations(
    TenantInfo tenant,
    KeyRange keys,
    int limit,
    Reverse reverse,
    SpanContext spanContext,
    Optional<UID> debugID,
    UseProvisionalProxies useProvisionalProxies,
    Version version) {

	if (reverse) {
		// DD never ask for backward range.
		ASSERT(false);
	}
	ASSERT(keys.begin < keys.end);

	GetKeyServerLocationsReply rep;
	auto ranges = shardMapping->intersectingRanges(keys);
	auto it = ranges.begin();
	for (int count = 0; it != ranges.end() && count < limit; ++it, ++count) {
		auto teamPair = shardMapping->getTeamsFor(it->begin());
		auto& srcTeam = teamPair.second.empty() ? teamPair.first : teamPair.second;
		ASSERT_EQ(srcTeam.size(), 1);
		rep.results.emplace_back(it->range(), extractStorageServerInterfaces(srcTeam.front().servers));
	}
	CODE_PROBE(it != ranges.end(), "getKeyRangeLocations is limited");

	std::vector<KeyRangeLocationInfo> results;
	for (int shard = 0; shard < rep.results.size(); shard++) {
		results.emplace_back((toPrefixRelativeRange(rep.results[shard].first, tenant.prefix) & keys),
		                     buildLocationInfo(rep.results[shard].second));
	}
	return results;
}

std::vector<StorageServerInterface> MockGlobalState::extractStorageServerInterfaces(const std::vector<UID>& ids) const {
	std::vector<StorageServerInterface> interfaces;
	for (auto& id : ids) {
		interfaces.emplace_back(allServers.at(id)->ssi);
	}
	return interfaces;
}

Future<Standalone<VectorRef<KeyRef>>> MockGlobalState::splitStorageMetrics(const KeyRange& keys,
                                                                           const StorageMetrics& limit,
                                                                           const StorageMetrics& estimated,
                                                                           const Optional<int>& minSplitBytes) {
	return MockGlobalStateImpl::splitStorageMetrics(this, keys, limit, estimated, minSplitBytes);
}

std::vector<Future<Void>> MockGlobalState::runAllMockServers() {
	std::vector<Future<Void>> futures;
	futures.reserve(allServers.size());
	for (auto& [id, _] : allServers) {
		futures.emplace_back(runMockServer(id));
	}
	return futures;
}
Future<Void> MockGlobalState::runMockServer(const UID& id) {
	return allServers.at(id)->run();
}

int MockGlobalState::getRangeSize(KeyRangeRef const& range) {
	// FIXME: return realistic number
	return SERVER_KNOBS->MIN_SHARD_BYTES;
}

int64_t MockGlobalState::get(KeyRef const& key) {
	auto ids = shardMapping->getSourceServerIdsFor(key);
	int64_t randomBytes = 0;
	if (deterministicRandom()->random01() > emptyProb) {
		randomBytes = deterministicRandom()->randomInt64(minByteSize, maxByteSize + 1);
	}
	// randomly choose 1 server
	auto id = deterministicRandom()->randomChoice(ids);
	allServers.at(id)->get(key, randomBytes);
	return randomBytes;
}

int64_t MockGlobalState::getRange(KeyRangeRef const& range) {
	auto ranges = shardMapping->intersectingRanges(range);
	int64_t totalSize = 0;
	KeyRef begin, end;
	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		auto ids = shardMapping->getSourceServerIdsFor(it->begin());
		if (range.begin > it->begin()) {
			begin = range.begin;
		}
		if (range.end < it->end()) {
			end = range.end;
		}

		// randomly choose 1 server
		auto id = deterministicRandom()->randomChoice(ids);
		int64_t beginSize = deterministicRandom()->randomInt64(0, SERVER_KNOBS->MIN_SHARD_BYTES),
		        endSize = deterministicRandom()->randomInt64(0, SERVER_KNOBS->MIN_SHARD_BYTES);
		totalSize += allServers.at(id)->getRange(KeyRangeRef(begin, end), beginSize, endSize);
	}
	return totalSize;
}

int64_t MockGlobalState::set(KeyRef const& key, int valueSize, bool insert) {
	auto ids = shardMapping->getSourceServerIdsFor(key);
	int64_t oldKvBytes = 0;
	insert |= (deterministicRandom()->random01() < emptyProb);

	if (!insert) {
		oldKvBytes = key.size() + deterministicRandom()->randomInt64(minByteSize, maxByteSize + 1);
	}

	for (auto& id : ids) {
		allServers.at(id)->set(key, valueSize + key.size(), oldKvBytes);
	}
	return oldKvBytes;
}

int64_t MockGlobalState::clear(KeyRef const& key) {
	auto ids = shardMapping->getSourceServerIdsFor(key);
	int64_t randomBytes = 0;
	if (deterministicRandom()->random01() > emptyProb) {
		randomBytes = deterministicRandom()->randomInt64(minByteSize, maxByteSize + 1) + key.size();
	}

	for (auto& id : ids) {
		allServers.at(id)->clear(key, randomBytes);
	}
	return randomBytes;
}

int64_t MockGlobalState::clearRange(KeyRangeRef const& range) {
	auto ranges = shardMapping->intersectingRanges(range);
	int64_t totalSize = 0;
	KeyRef begin, end;
	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		auto ids = shardMapping->getSourceServerIdsFor(it->begin());
		if (range.begin > it->begin()) {
			begin = range.begin;
		}
		if (range.end < it->end()) {
			end = range.end;
		}

		int64_t beginSize = deterministicRandom()->randomInt64(0, SERVER_KNOBS->MIN_SHARD_BYTES),
		        endSize = deterministicRandom()->randomInt64(0, SERVER_KNOBS->MIN_SHARD_BYTES);
		int64_t lastSize = -1;
		for (auto& id : ids) {
			int64_t size = allServers.at(id)->clearRange(KeyRangeRef(begin, end), beginSize, endSize);
			ASSERT(lastSize == size || lastSize == -1); // every server should return the same result
		}
		totalSize += lastSize;
	}
	return totalSize;
}

															#line 2552 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase929()
															#line 929 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
template <class FlowTestCase929Actor>
															#line 929 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class FlowTestCase929ActorState {
															#line 2559 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
															#line 929 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	FlowTestCase929ActorState(UnitTestParameters const& params) 
															#line 929 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
															#line 929 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		 : params(params)
															#line 2566 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase929", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase929ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase929", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 930 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			BasicTestConfig testConfig;
															#line 931 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.simpleConfig = true;
															#line 932 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.minimumReplication = 3;
															#line 933 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.logAntiQuorum = 0;
															#line 935 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			BasicSimulationConfig dbConfig = generateBasicSimulationConfig(testConfig);
															#line 936 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			TraceEvent("UnitTestDBConfig").detail("Config", dbConfig.db.toString());
															#line 937 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			std::shared_ptr<MockGlobalState> mgs = std::make_shared<MockGlobalState>();
															#line 938 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs->initializeClusterLayout(dbConfig);
															#line 939 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs->initializeAsEmptyDatabaseMGS(dbConfig.db);
															#line 941 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			for(int i = 1;i <= dbConfig.db.storageTeamSize;++i) {
															#line 942 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				auto id = MockGlobalState::indexToUID(i);
															#line 943 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				std::cout << "Check server " << i << "\n";
															#line 944 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				ASSERT(mgs->serverIsSourceForShard(id, allKeys));
															#line 945 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				ASSERT(mgs->allServers.at(id)->sumRangeSize(allKeys) == 0);
															#line 2607 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			}
															#line 948 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			if (!static_cast<FlowTestCase929Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase929ActorState(); static_cast<FlowTestCase929Actor*>(this)->destroy(); return 0; }
															#line 2611 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			new (&static_cast<FlowTestCase929Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase929ActorState();
			static_cast<FlowTestCase929Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase929ActorState();
		static_cast<FlowTestCase929Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 929 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	UnitTestParameters params;
															#line 2635 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase929()
															#line 929 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class FlowTestCase929Actor final : public Actor<Void>, public FastAllocated<FlowTestCase929Actor>, public FlowTestCase929ActorState<FlowTestCase929Actor> {
															#line 2640 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase929Actor>::operator new;
	using FastAllocated<FlowTestCase929Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12608238011181738752UL, 12935452340923650816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 929 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	FlowTestCase929Actor(UnitTestParameters const& params) 
															#line 2656 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase929ActorState<FlowTestCase929Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase929", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13552241739248480512UL, 12514350653774520832UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase929Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase929");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase929", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 929 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
static Future<Void> flowTestCase929( UnitTestParameters const& params ) {
															#line 929 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	return Future<Void>(new FlowTestCase929Actor(params));
															#line 2688 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase929, "/MockGlobalState/initializeAsEmptyDatabaseMGS/SimpleThree")

#line 950 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"

struct MockGlobalStateTester {

	// expectation [r0.begin, r0.end) => [r0.begin, x1), [x1, x2), [x2, r0.end)
	void testThreeWaySplitFirstRange(MockStorageServer& mss) {
		auto it = mss.serverKeys.ranges().begin();
		uint64_t oldSize =
		    deterministicRandom()->randomInt(SERVER_KNOBS->MIN_SHARD_BYTES, std::numeric_limits<int>::max());
		MockShardStatus oldStatus = it.cvalue().status;
		it->value().shardSize = oldSize;
		KeyRangeRef outerRange = it->range();
		Key x1 = keyAfter(it->range().begin);
		Key x2 = keyAfter(x1);
		std::cout << "it->range.begin: " << it->range().begin.toHexString() << " size: " << oldSize << "\n";

		mss.threeWayShardSplitting(outerRange, KeyRangeRef(x1, x2), oldSize);
		auto ranges = mss.serverKeys.containedRanges(outerRange);
		ASSERT(ranges.begin().range() == KeyRangeRef(outerRange.begin, x1));
		ASSERT(ranges.begin().cvalue().status == oldStatus);
		ranges.pop_front();
		ASSERT(ranges.begin().range() == KeyRangeRef(x1, x2));
		ASSERT(ranges.begin().cvalue().status == oldStatus);
		ranges.pop_front();
		ASSERT(ranges.begin().range() == KeyRangeRef(x2, outerRange.end));
		ASSERT(ranges.begin().cvalue().status == oldStatus);
		ranges.pop_front();
		ASSERT(ranges.empty());
	}

	// expectation [r0.begin, r0.end) => [r0.begin, x1), [x1, r0.end)
	void testTwoWaySplitFirstRange(MockStorageServer& mss) {
		auto it = mss.serverKeys.nthRange(0);
		MockShardStatus oldStatus = it.cvalue().status;
		uint64_t oldSize =
		    deterministicRandom()->randomInt(SERVER_KNOBS->MIN_SHARD_BYTES, std::numeric_limits<int>::max());
		it->value().shardSize = oldSize;
		KeyRangeRef outerRange = it->range();
		Key x1 = keyAfter(it->range().begin);
		std::cout << "it->range.begin: " << it->range().begin.toHexString() << " size: " << oldSize << "\n";

		mss.twoWayShardSplitting(it->range(), x1, oldSize);
		auto ranges = mss.serverKeys.containedRanges(outerRange);
		ASSERT(ranges.begin().range() == KeyRangeRef(outerRange.begin, x1));
		ASSERT(ranges.begin().cvalue().status == oldStatus);
		ranges.pop_front();
		ASSERT(ranges.begin().range() == KeyRangeRef(x1, outerRange.end));
		ASSERT(ranges.begin().cvalue().status == oldStatus);
		ranges.pop_front();
		ASSERT(ranges.empty());
	}

	KeyRangeLocationInfo getKeyLocationInfo(KeyRef key, std::shared_ptr<MockGlobalState> mgs) {
		return mgs
		    ->getKeyLocation(
		        TenantInfo(), key, SpanContext(), Optional<UID>(), UseProvisionalProxies::False, Reverse::False, 0)
		    .get();
	}

	std::vector<KeyRangeLocationInfo> getKeyRangeLocations(KeyRangeRef keys,
	                                                       int limit,
	                                                       std::shared_ptr<MockGlobalState> mgs) {
		return mgs
		    ->getKeyRangeLocations(TenantInfo(),
		                           keys,
		                           limit,
		                           Reverse::False,
		                           SpanContext(),
		                           Optional<UID>(),
		                           UseProvisionalProxies::False,
		                           0)
		    .get();
	}
};

															#line 2767 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1024()
															#line 1024 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
template <class FlowTestCase1024Actor>
															#line 1024 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class FlowTestCase1024ActorState {
															#line 2774 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
															#line 1024 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	FlowTestCase1024ActorState(UnitTestParameters const& params) 
															#line 1024 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
															#line 1024 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		 : params(params)
															#line 2781 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1024", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1024ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1024", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1025 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			BasicTestConfig testConfig;
															#line 1026 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.simpleConfig = true;
															#line 1027 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.minimumReplication = 1;
															#line 1028 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.logAntiQuorum = 0;
															#line 1029 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			BasicSimulationConfig dbConfig = generateBasicSimulationConfig(testConfig);
															#line 1030 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			TraceEvent("UnitTestDBConfig").detail("Config", dbConfig.db.toString());
															#line 1031 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			std::shared_ptr<MockGlobalState> mgs = std::make_shared<MockGlobalState>();
															#line 1032 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs->initializeClusterLayout(dbConfig);
															#line 1033 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs->initializeAsEmptyDatabaseMGS(dbConfig.db);
															#line 1035 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			MockGlobalStateTester tester;
															#line 1036 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			auto& mss = mgs->allServers.at(MockGlobalState::indexToUID(1));
															#line 1037 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			std::cout << "Test 3-way splitting...\n";
															#line 1038 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			tester.testThreeWaySplitFirstRange(*mss);
															#line 1039 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			std::cout << "Test 2-way splitting...\n";
															#line 1040 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mss->serverKeys.insert(allKeys, { MockShardStatus::COMPLETED, 0 });
															#line 1041 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			tester.testTwoWaySplitFirstRange(*mss);
															#line 1043 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			if (!static_cast<FlowTestCase1024Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1024ActorState(); static_cast<FlowTestCase1024Actor*>(this)->destroy(); return 0; }
															#line 2828 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			new (&static_cast<FlowTestCase1024Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1024ActorState();
			static_cast<FlowTestCase1024Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1024ActorState();
		static_cast<FlowTestCase1024Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1024 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	UnitTestParameters params;
															#line 2852 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1024()
															#line 1024 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class FlowTestCase1024Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1024Actor>, public FlowTestCase1024ActorState<FlowTestCase1024Actor> {
															#line 2857 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1024Actor>::operator new;
	using FastAllocated<FlowTestCase1024Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6570134922177233152UL, 2467188958228024064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1024 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	FlowTestCase1024Actor(UnitTestParameters const& params) 
															#line 2873 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1024ActorState<FlowTestCase1024Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1024", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12382361145670144512UL, 11656564354995394816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1024Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1024");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1024", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1024 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
static Future<Void> flowTestCase1024( UnitTestParameters const& params ) {
															#line 1024 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	return Future<Void>(new FlowTestCase1024Actor(params));
															#line 2905 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1024, "/MockGlobalState/MockStorageServer/SplittingFunctions")

#line 1045 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"

															#line 2911 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1046()
															#line 1046 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
template <class FlowTestCase1046Actor>
															#line 1046 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class FlowTestCase1046ActorState {
															#line 2918 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
															#line 1046 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	FlowTestCase1046ActorState(UnitTestParameters const& params) 
															#line 1046 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
															#line 1046 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		 : params(params)
															#line 2925 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1046", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1046ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1046", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1047 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			BasicTestConfig testConfig;
															#line 1048 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.simpleConfig = true;
															#line 1049 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.minimumReplication = 1;
															#line 1050 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.logAntiQuorum = 0;
															#line 1051 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			BasicSimulationConfig dbConfig = generateBasicSimulationConfig(testConfig);
															#line 1052 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			TraceEvent("UnitTestDBConfig").detail("Config", dbConfig.db.toString());
															#line 1053 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs = std::make_shared<MockGlobalState>();
															#line 1054 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs->initializeClusterLayout(dbConfig);
															#line 1055 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs->initializeAsEmptyDatabaseMGS(dbConfig.db);
															#line 1057 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			auto& mss = mgs->allServers.at(MockGlobalState::indexToUID(1));
															#line 1058 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mss->serverKeys.insert(allKeys, { MockShardStatus::UNSET, 1400 });
															#line 1061 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			KeyRange testRange(KeyRangeRef("a"_sr, "b"_sr));
															#line 1062 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mss->setShardStatus(testRange, MockShardStatus::INFLIGHT);
															#line 1063 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(mss->allShardStatusEqual(testRange, MockShardStatus::INFLIGHT));
															#line 1064 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT_EQ(mss->sumRangeSize(allKeys), 1400);
															#line 1065 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT_EQ(mss->serverKeys.size(), 3);
															#line 1068 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testRange = KeyRangeRef("ac"_sr, "bc"_sr);
															#line 1069 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mss->setShardStatus(testRange, MockShardStatus::INFLIGHT);
															#line 1070 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(mss->allShardStatusEqual(testRange, MockShardStatus::INFLIGHT));
															#line 1071 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT_EQ(mss->sumRangeSize(allKeys), 1400);
															#line 1072 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT_EQ(mss->serverKeys.size(), 4);
															#line 1073 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testRange = KeyRangeRef("ab"_sr, "bb"_sr);
															#line 1074 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mss->setShardStatus(testRange, MockShardStatus::INFLIGHT);
															#line 1075 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT_EQ(mss->serverKeys.size(), 4);
															#line 1077 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testRange = KeyRangeRef("b"_sr, "bc"_sr);
															#line 1079 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mss->setShardStatus(testRange, MockShardStatus::FETCHED);
															#line 1080 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(mss->allShardStatusEqual(testRange, MockShardStatus::FETCHED));
															#line 1081 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mss->setShardStatus(testRange, MockShardStatus::COMPLETED);
															#line 1082 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(mss->allShardStatusEqual(testRange, MockShardStatus::COMPLETED));
															#line 1083 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mss->setShardStatus(testRange, MockShardStatus::FETCHED);
															#line 1084 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(mss->allShardStatusEqual(testRange, MockShardStatus::COMPLETED));
															#line 1085 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT_EQ(mss->sumRangeSize(allKeys), 1400);
															#line 1086 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT_EQ(mss->serverKeys.size(), 4);
															#line 1088 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testRange = KeyRangeRef("ac"_sr, allKeys.end);
															#line 1090 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mss->setShardStatus(testRange, MockShardStatus::FETCHED);
															#line 1091 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT_EQ(mss->sumRangeSize(allKeys), 1400);
															#line 1092 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT_EQ(mss->serverKeys.size(), 5);
															#line 1093 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(mss->allShardStatusEqual(KeyRangeRef("ac"_sr, "b"_sr), MockShardStatus::FETCHED));
															#line 1094 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(mss->allShardStatusEqual(KeyRangeRef("b"_sr, "bc"_sr), MockShardStatus::COMPLETED));
															#line 1095 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(mss->allShardStatusEqual(KeyRangeRef("bc"_sr, allKeys.end), MockShardStatus::FETCHED));
															#line 1097 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mss->setShardStatus(allKeys, MockShardStatus::INFLIGHT);
															#line 1098 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mss->setShardStatus(allKeys, MockShardStatus::FETCHED);
															#line 1099 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mss->setShardStatus(allKeys, MockShardStatus::COMPLETED);
															#line 1100 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mss->coalesceCompletedRange(KeyRangeRef("a"_sr, "b"_sr));
															#line 1101 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT_EQ(mss->sumRangeSize(allKeys), 1400);
															#line 1102 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT_EQ(mss->serverKeys.size(), 1);
															#line 1103 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			if (!static_cast<FlowTestCase1046Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1046ActorState(); static_cast<FlowTestCase1046Actor*>(this)->destroy(); return 0; }
															#line 3032 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			new (&static_cast<FlowTestCase1046Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1046ActorState();
			static_cast<FlowTestCase1046Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1046ActorState();
		static_cast<FlowTestCase1046Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1046 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	UnitTestParameters params;
															#line 1053 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	std::shared_ptr<MockGlobalState> mgs;
															#line 3058 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1046()
															#line 1046 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class FlowTestCase1046Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1046Actor>, public FlowTestCase1046ActorState<FlowTestCase1046Actor> {
															#line 3063 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1046Actor>::operator new;
	using FastAllocated<FlowTestCase1046Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(511906520389726976UL, 10353493135135774464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1046 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	FlowTestCase1046Actor(UnitTestParameters const& params) 
															#line 3079 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1046ActorState<FlowTestCase1046Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1046", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5005910929832521984UL, 5176848593931809792UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1046Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1046");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1046", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1046 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
static Future<Void> flowTestCase1046( UnitTestParameters const& params ) {
															#line 1046 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	return Future<Void>(new FlowTestCase1046Actor(params));
															#line 3111 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1046, "/MockGlobalState/MockStorageServer/SetShardStatus")

#line 1105 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"

namespace {
inline bool locationInfoEqualsToTeam(Reference<LocationInfo> loc, const std::vector<UID>& ids) {
	return loc->locations()->size() == ids.size() &&
	       std::all_of(ids.begin(), ids.end(), [loc](const UID& id) { return loc->locations()->hasInterface(id); });
}
}; // namespace
															#line 3123 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1112()
															#line 1112 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
template <class FlowTestCase1112Actor>
															#line 1112 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class FlowTestCase1112ActorState {
															#line 3130 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
															#line 1112 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	FlowTestCase1112ActorState(UnitTestParameters const& params) 
															#line 1112 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
															#line 1112 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		 : params(params)
															#line 3137 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1112", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1112ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1112", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1113 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			BasicTestConfig testConfig;
															#line 1114 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.simpleConfig = true;
															#line 1115 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.minimumReplication = 1;
															#line 1116 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.logAntiQuorum = 0;
															#line 1117 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			BasicSimulationConfig dbConfig = generateBasicSimulationConfig(testConfig);
															#line 1118 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			TraceEvent("UnitTestDBConfig").detail("Config", dbConfig.db.toString());
															#line 1119 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs = std::make_shared<MockGlobalState>();
															#line 1120 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs->initializeClusterLayout(dbConfig);
															#line 1121 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs->initializeAsEmptyDatabaseMGS(dbConfig.db);
															#line 1123 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs->addStorageServer(StorageServerInterface(mgs->indexToUID(mgs->allServers.size() + 1)));
															#line 1128 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ShardsAffectedByTeamFailure::Team team1, team2;
															#line 1129 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			for(int i = 0;i < mgs->allServers.size() - 1;++i) {
															#line 1130 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				UID id = mgs->indexToUID(i + 1);
															#line 1131 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				team1.servers.emplace_back(id);
															#line 1132 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				id = mgs->indexToUID(i + 2);
															#line 1133 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				team2.servers.emplace_back(id);
															#line 3182 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			}
															#line 1135 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			Key one = doubleToTestKey(1.0), two = doubleToTestKey(2.0);
															#line 1136 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			std::vector<KeyRangeRef> ranges{ KeyRangeRef(allKeys.begin, one), KeyRangeRef(one, two), KeyRangeRef(two, allKeys.end) };
															#line 1139 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs->shardMapping->assignRangeToTeams(ranges[0], { team1 });
															#line 1140 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs->shardMapping->assignRangeToTeams(ranges[1], { team2 });
															#line 1141 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs->shardMapping->assignRangeToTeams(ranges[2], { team1 });
															#line 1144 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			MockGlobalStateTester tester;
															#line 1146 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			Key testKey = doubleToTestKey(0.5);
															#line 1147 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			auto locInfo = tester.getKeyLocationInfo(testKey, mgs);
															#line 1148 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(locationInfoEqualsToTeam(locInfo.locations, team1.servers));
															#line 1151 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testKey = doubleToTestKey(1.3);
															#line 1152 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			locInfo = tester.getKeyLocationInfo(testKey, mgs);
															#line 1153 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(locationInfoEqualsToTeam(locInfo.locations, team2.servers));
															#line 1156 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testKey = doubleToTestKey(3.0);
															#line 1158 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			auto locInfos = tester.getKeyRangeLocations(KeyRangeRef(allKeys.begin, testKey), 100, mgs);
															#line 1159 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(locInfos.size() == 3);
															#line 1160 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(locInfos[0].range == ranges[0]);
															#line 1161 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(locationInfoEqualsToTeam(locInfos[0].locations, team1.servers));
															#line 1162 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(locInfos[1].range == ranges[1]);
															#line 1163 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(locationInfoEqualsToTeam(locInfos[1].locations, team2.servers));
															#line 1164 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(locInfos[2].range == KeyRangeRef(ranges[2].begin, testKey));
															#line 1165 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(locationInfoEqualsToTeam(locInfos[2].locations, team1.servers));
															#line 1168 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			locInfos = tester.getKeyRangeLocations(KeyRangeRef(allKeys.begin, testKey), 2, mgs);
															#line 1169 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(locInfos.size() == 2);
															#line 1170 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(locInfos[0].range == ranges[0]);
															#line 1171 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(locationInfoEqualsToTeam(locInfos[0].locations, team1.servers));
															#line 1172 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(locInfos[1].range == ranges[1]);
															#line 1173 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT(locationInfoEqualsToTeam(locInfos[1].locations, team2.servers));
															#line 1175 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			if (!static_cast<FlowTestCase1112Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1112ActorState(); static_cast<FlowTestCase1112Actor*>(this)->destroy(); return 0; }
															#line 3240 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			new (&static_cast<FlowTestCase1112Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1112ActorState();
			static_cast<FlowTestCase1112Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1112ActorState();
		static_cast<FlowTestCase1112Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1112 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	UnitTestParameters params;
															#line 1119 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	std::shared_ptr<MockGlobalState> mgs;
															#line 3266 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1112()
															#line 1112 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class FlowTestCase1112Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1112Actor>, public FlowTestCase1112ActorState<FlowTestCase1112Actor> {
															#line 3271 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1112Actor>::operator new;
	using FastAllocated<FlowTestCase1112Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15958354122959033600UL, 2584685797578129152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1112 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	FlowTestCase1112Actor(UnitTestParameters const& params) 
															#line 3287 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1112ActorState<FlowTestCase1112Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1112", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7043727469638013696UL, 1846439935757093376UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1112Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1112");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1112", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1112 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
static Future<Void> flowTestCase1112( UnitTestParameters const& params ) {
															#line 1112 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	return Future<Void>(new FlowTestCase1112Actor(params));
															#line 3319 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1112, "/MockGlobalState/MockStorageServer/GetKeyLocations")

#line 1177 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"

															#line 3325 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1178()
															#line 1178 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
template <class FlowTestCase1178Actor>
															#line 1178 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class FlowTestCase1178ActorState {
															#line 3332 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
															#line 1178 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	FlowTestCase1178ActorState(UnitTestParameters const& params) 
															#line 1178 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
															#line 1178 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		 : params(params)
															#line 3339 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1178", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1178ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1178", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1179 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			BasicTestConfig testConfig;
															#line 1180 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.simpleConfig = true;
															#line 1181 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.minimumReplication = 1;
															#line 1182 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.logAntiQuorum = 0;
															#line 1184 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			BasicSimulationConfig dbConfig = generateBasicSimulationConfig(testConfig);
															#line 1185 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			TraceEvent("UnitTestDBConfig").detail("Config", dbConfig.db.toString());
															#line 1186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs = std::make_shared<MockGlobalState>();
															#line 1187 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs->initializeClusterLayout(dbConfig);
															#line 1188 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs->initializeAsEmptyDatabaseMGS(dbConfig.db);
															#line 1190 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			std::for_each(mgs->allServers.begin(), mgs->allServers.end(), [](auto& server) { server.second->metrics.byteSample.sample.insert("something"_sr, 500000); });
															#line 1194 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			allServerFutures = waitForAll(mgs->runAllMockServers());
															#line 1196 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			KeyRange testRange = allKeys;
															#line 1197 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ShardSizeBounds bounds = ShardSizeBounds::shardSizeBoundsBeforeTrack();
															#line 1198 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			StrictFuture<std::pair<Optional<StorageMetrics>, int>> __when_expr_0 = mgs->waitStorageMetrics(testRange, bounds.min, bounds.max, bounds.permittedError, 1, 1);
															#line 1198 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			if (static_cast<FlowTestCase1178Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3382 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase1178Actor*>(this)->actor_wait_state = 1;
															#line 1198 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1178Actor, 0, std::pair<Optional<StorageMetrics>, int> >*>(static_cast<FlowTestCase1178Actor*>(this)));
															#line 3387 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1178ActorState();
		static_cast<FlowTestCase1178Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::pair<Optional<StorageMetrics>, int> const& res,int loopDepth) 
	{
															#line 1202 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		ASSERT_EQ(res.second, -1);
															#line 1203 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		ASSERT_EQ(res.first.get().bytes, 500000);
															#line 1204 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (!static_cast<FlowTestCase1178Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1178ActorState(); static_cast<FlowTestCase1178Actor*>(this)->destroy(); return 0; }
															#line 3414 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		new (&static_cast<FlowTestCase1178Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1178ActorState();
		static_cast<FlowTestCase1178Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::pair<Optional<StorageMetrics>, int> && res,int loopDepth) 
	{
															#line 1202 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		ASSERT_EQ(res.second, -1);
															#line 1203 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		ASSERT_EQ(res.first.get().bytes, 500000);
															#line 1204 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (!static_cast<FlowTestCase1178Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1178ActorState(); static_cast<FlowTestCase1178Actor*>(this)->destroy(); return 0; }
															#line 3430 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		new (&static_cast<FlowTestCase1178Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1178ActorState();
		static_cast<FlowTestCase1178Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::pair<Optional<StorageMetrics>, int> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::pair<Optional<StorageMetrics>, int> && res,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1178Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1178Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1178Actor*>(this)->ActorCallback< FlowTestCase1178Actor, 0, std::pair<Optional<StorageMetrics>, int> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1178Actor, 0, std::pair<Optional<StorageMetrics>, int> >*,std::pair<Optional<StorageMetrics>, int> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1178", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1178Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1178", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1178Actor, 0, std::pair<Optional<StorageMetrics>, int> >*,std::pair<Optional<StorageMetrics>, int> && value) 
	{
		fdb_probe_actor_enter("flowTestCase1178", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1178Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1178", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1178Actor, 0, std::pair<Optional<StorageMetrics>, int> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1178", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1178Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1178", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1178 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	UnitTestParameters params;
															#line 1186 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	std::shared_ptr<MockGlobalState> mgs;
															#line 1194 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	Future<Void> allServerFutures;
															#line 3519 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1178()
															#line 1178 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class FlowTestCase1178Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1178Actor, 0, std::pair<Optional<StorageMetrics>, int> >, public FastAllocated<FlowTestCase1178Actor>, public FlowTestCase1178ActorState<FlowTestCase1178Actor> {
															#line 3524 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1178Actor>::operator new;
	using FastAllocated<FlowTestCase1178Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15343013579409090304UL, 7624850716976327168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1178Actor, 0, std::pair<Optional<StorageMetrics>, int> >;
															#line 1178 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	FlowTestCase1178Actor(UnitTestParameters const& params) 
															#line 3541 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1178ActorState<FlowTestCase1178Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1178", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6100604890808512512UL, 11356005338514284800UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1178Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1178");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1178", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1178Actor, 0, std::pair<Optional<StorageMetrics>, int> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1178 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
static Future<Void> flowTestCase1178( UnitTestParameters const& params ) {
															#line 1178 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	return Future<Void>(new FlowTestCase1178Actor(params));
															#line 3574 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1178, "/MockGlobalState/MockStorageServer/WaitStorageMetricsRequest")

#line 1206 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"

															#line 3580 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1207()
															#line 1207 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
template <class FlowTestCase1207Actor>
															#line 1207 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class FlowTestCase1207ActorState {
															#line 3587 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
															#line 1207 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	FlowTestCase1207ActorState(UnitTestParameters const& params) 
															#line 1207 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
															#line 1207 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		 : params(params)
															#line 3594 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1207", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1207ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1207", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1208 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			BasicTestConfig testConfig;
															#line 1209 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.simpleConfig = true;
															#line 1210 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.minimumReplication = 1;
															#line 1211 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			testConfig.logAntiQuorum = 0;
															#line 1213 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			BasicSimulationConfig dbConfig = generateBasicSimulationConfig(testConfig);
															#line 1214 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			TraceEvent("UnitTestDBConfig").detail("Config", dbConfig.db.toString());
															#line 1215 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs = std::make_shared<MockGlobalState>();
															#line 1216 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs->initializeClusterLayout(dbConfig);
															#line 1217 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			mgs->initializeAsEmptyDatabaseMGS(dbConfig.db);
															#line 1219 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			allServerFutures = waitForAll(mgs->runAllMockServers());
															#line 3627 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
			{
															#line 1223 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				mgs->set("a"_sr, 1 * SERVER_KNOBS->BYTES_WRITTEN_UNITS_PER_SAMPLE, true);
															#line 1224 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				mgs->set("b"_sr, 2 * SERVER_KNOBS->BYTES_WRITTEN_UNITS_PER_SAMPLE, true);
															#line 1225 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				mgs->set("c"_sr, 3 * SERVER_KNOBS->BYTES_WRITTEN_UNITS_PER_SAMPLE, true);
															#line 1226 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				for( auto& server : mgs->allServers ) {
															#line 1227 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
					ASSERT_EQ(server.second->usedDiskSpace, 3 + 6 * SERVER_KNOBS->BYTES_WRITTEN_UNITS_PER_SAMPLE);
															#line 1228 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
					ASSERT_EQ(server.second->serverKeys[""_sr].shardSize, 3 + 6 * SERVER_KNOBS->BYTES_WRITTEN_UNITS_PER_SAMPLE);
															#line 3641 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
				}
															#line 1230 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				ShardSizeBounds bounds = ShardSizeBounds::shardSizeBoundsBeforeTrack();
															#line 1231 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				StrictFuture<std::pair<Optional<StorageMetrics>, int>> __when_expr_0 = mgs->waitStorageMetrics(KeyRangeRef("a"_sr, "bc"_sr), bounds.min, bounds.max, bounds.permittedError, 1, 1);
															#line 1231 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				if (static_cast<FlowTestCase1207Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3649 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FlowTestCase1207Actor*>(this)->actor_wait_state = 1;
															#line 1231 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1207Actor, 0, std::pair<Optional<StorageMetrics>, int> >*>(static_cast<FlowTestCase1207Actor*>(this)));
															#line 3654 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1207ActorState();
		static_cast<FlowTestCase1207Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1242 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (!static_cast<FlowTestCase1207Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1207ActorState(); static_cast<FlowTestCase1207Actor*>(this)->destroy(); return 0; }
															#line 3678 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		new (&static_cast<FlowTestCase1207Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1207ActorState();
		static_cast<FlowTestCase1207Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(std::pair<Optional<StorageMetrics>, int> const& res,int loopDepth) 
	{
															#line 1234 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		int64_t testSize = 2 + 3 * SERVER_KNOBS->BYTES_WRITTEN_UNITS_PER_SAMPLE;
															#line 1236 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (res.first.get().bytes > 0)
															#line 3692 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		{
															#line 1238 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT_EQ(res.first.get().bytes, testSize);
															#line 1239 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT_GT(res.first.get().bytesWrittenPerKSecond, 0);
															#line 3698 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::pair<Optional<StorageMetrics>, int> && res,int loopDepth) 
	{
															#line 1234 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		int64_t testSize = 2 + 3 * SERVER_KNOBS->BYTES_WRITTEN_UNITS_PER_SAMPLE;
															#line 1236 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
		if (res.first.get().bytes > 0)
															#line 3710 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		{
															#line 1238 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT_EQ(res.first.get().bytes, testSize);
															#line 1239 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
			ASSERT_GT(res.first.get().bytesWrittenPerKSecond, 0);
															#line 3716 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::pair<Optional<StorageMetrics>, int> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::pair<Optional<StorageMetrics>, int> && res,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1207Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1207Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1207Actor*>(this)->ActorCallback< FlowTestCase1207Actor, 0, std::pair<Optional<StorageMetrics>, int> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1207Actor, 0, std::pair<Optional<StorageMetrics>, int> >*,std::pair<Optional<StorageMetrics>, int> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1207", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1207Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1207", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1207Actor, 0, std::pair<Optional<StorageMetrics>, int> >*,std::pair<Optional<StorageMetrics>, int> && value) 
	{
		fdb_probe_actor_enter("flowTestCase1207", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1207Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1207", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1207Actor, 0, std::pair<Optional<StorageMetrics>, int> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1207", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1207Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1207", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1207 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	UnitTestParameters params;
															#line 1215 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	std::shared_ptr<MockGlobalState> mgs;
															#line 1219 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	Future<Void> allServerFutures;
															#line 3803 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1207()
															#line 1207 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
class FlowTestCase1207Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1207Actor, 0, std::pair<Optional<StorageMetrics>, int> >, public FastAllocated<FlowTestCase1207Actor>, public FlowTestCase1207ActorState<FlowTestCase1207Actor> {
															#line 3808 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1207Actor>::operator new;
	using FastAllocated<FlowTestCase1207Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10024375167880469248UL, 9258580574358965504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1207Actor, 0, std::pair<Optional<StorageMetrics>, int> >;
															#line 1207 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	FlowTestCase1207Actor(UnitTestParameters const& params) 
															#line 3825 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1207ActorState<FlowTestCase1207Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1207", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14607670732684446208UL, 16302466078286692352UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1207Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1207");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1207", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1207Actor, 0, std::pair<Optional<StorageMetrics>, int> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1207 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
static Future<Void> flowTestCase1207( UnitTestParameters const& params ) {
															#line 1207 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
	return Future<Void>(new FlowTestCase1207Actor(params));
															#line 3858 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/build_output/fdbserver/MockGlobalState.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1207, "/MockGlobalState/MockStorageServer/DataOpsSet")

#line 1244 "/codebuild/output/src2589146249/src/github.com/apple/foundationdb/fdbserver/MockGlobalState.actor.cpp"
