/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.ReadTransactionContext;
import com.apple.foundationdb.RequiresDatabase;
import com.apple.foundationdb.TransactionContext;
import com.apple.foundationdb.directory.DirectoryAlreadyExistsException;
import com.apple.foundationdb.directory.DirectoryLayer;
import com.apple.foundationdb.directory.DirectorySubspace;
import com.apple.foundationdb.directory.NoSuchDirectoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={RequiresDatabase.class})
class DirectoryTest {
    private static final FDB fdb = FDB.selectAPIVersion((int)800);

    DirectoryTest() {
    }

    @Test
    void testCanCreateDirectory() throws Exception {
        DirectoryLayer directoryLayer = new DirectoryLayer();
        try (Database database = fdb.open();){
            database.run(transaction -> {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("toCreate");
                try {
                    DirectorySubspace directorySubspace = (DirectorySubspace)directoryLayer.create((TransactionContext)transaction, arrayList).join();
                    Assertions.assertIterableEquals(arrayList, (Iterable)directorySubspace.getPath(), (String)"Incorrect path");
                    Assertions.assertTrue((boolean)((Boolean)directorySubspace.exists((ReadTransactionContext)transaction).join()), (String)"does not exist even though it's been created!");
                }
                finally {
                    directoryLayer.remove((TransactionContext)transaction, arrayList).join();
                }
                return null;
            });
        }
    }

    @Test
    void testCanCreateSubDirectory() throws Exception {
        DirectoryLayer directoryLayer = new DirectoryLayer();
        try (Database database = fdb.open();){
            database.run(transaction -> {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("foo");
                try {
                    DirectorySubspace directorySubspace = (DirectorySubspace)directoryLayer.create((TransactionContext)transaction, arrayList).join();
                    Assertions.assertIterableEquals(arrayList, (Iterable)directorySubspace.getPath(), (String)"Incorrect path");
                    Assertions.assertTrue((boolean)((Boolean)directorySubspace.exists((ReadTransactionContext)transaction).join()), (String)"does not exist even though it's been created!");
                    arrayList.add("bar");
                    DirectorySubspace directorySubspace2 = (DirectorySubspace)directoryLayer.create((TransactionContext)transaction, arrayList).join();
                    Assertions.assertIterableEquals(arrayList, (Iterable)directorySubspace2.getPath(), (String)"incorrect path");
                    Assertions.assertTrue((boolean)((Boolean)directorySubspace2.exists((ReadTransactionContext)transaction).join()), (String)"does not exist even though it's been created!");
                }
                finally {
                    directoryLayer.remove((TransactionContext)transaction, arrayList).join();
                }
                return null;
            });
        }
    }

    @Test
    void testCanMoveSubDirectory() throws Exception {
        DirectoryLayer directoryLayer = new DirectoryLayer();
        try (Database database = fdb.open();){
            database.run(transaction -> {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("src");
                try {
                    DirectorySubspace directorySubspace = (DirectorySubspace)directoryLayer.create((TransactionContext)transaction, arrayList).join();
                    Assertions.assertIterableEquals(arrayList, (Iterable)directorySubspace.getPath(), (String)"Incorrect path");
                    Assertions.assertTrue((boolean)((Boolean)directorySubspace.exists((ReadTransactionContext)transaction).join()), (String)"does not exist even though it's been created!");
                    arrayList.add("bar");
                    DirectorySubspace directorySubspace2 = (DirectorySubspace)directoryLayer.create((TransactionContext)transaction, arrayList).join();
                    Assertions.assertIterableEquals(arrayList, (Iterable)directorySubspace2.getPath(), (String)"incorrect path");
                    Assertions.assertTrue((boolean)((Boolean)directorySubspace2.exists((ReadTransactionContext)transaction).join()), (String)"does not exist even though it's been created!");
                    DirectorySubspace directorySubspace3 = (DirectorySubspace)directoryLayer.create((TransactionContext)transaction, Arrays.asList("dest")).join();
                    Assertions.assertIterableEquals(Arrays.asList("dest"), (Iterable)directorySubspace3.getPath(), (String)"incorrect path");
                    Assertions.assertTrue((boolean)((Boolean)directorySubspace3.exists((ReadTransactionContext)transaction).join()), (String)"does not exist even though it's been created!");
                    DirectorySubspace directorySubspace4 = (DirectorySubspace)directorySubspace2.moveTo((TransactionContext)transaction, Arrays.asList("dest", "bar")).join();
                    Assertions.assertIterableEquals(Arrays.asList("dest", "bar"), (Iterable)directorySubspace4.getPath(), (String)"incorrect path");
                    Assertions.assertTrue((boolean)((Boolean)directorySubspace4.exists((ReadTransactionContext)transaction).join()), (String)"does not exist even though it's been created!");
                    Assertions.assertFalse((boolean)((Boolean)directorySubspace2.exists((ReadTransactionContext)transaction).join()), (String)"Still exists in old location!");
                }
                catch (Throwable throwable) {
                    directoryLayer.remove((TransactionContext)transaction, Arrays.asList("src")).join();
                    try {
                        directoryLayer.remove((TransactionContext)transaction, Arrays.asList("dest")).join();
                        throw throwable;
                    }
                    catch (CompletionException completionException) {
                        Throwable throwable2 = completionException.getCause();
                        if (throwable2 instanceof NoSuchDirectoryException) throw throwable;
                        throw completionException;
                    }
                }
                directoryLayer.remove((TransactionContext)transaction, Arrays.asList("src")).join();
                try {
                    directoryLayer.remove((TransactionContext)transaction, Arrays.asList("dest")).join();
                    return null;
                }
                catch (CompletionException completionException) {
                    Throwable throwable = completionException.getCause();
                    if (throwable instanceof NoSuchDirectoryException) return null;
                    throw completionException;
                }
            });
        }
    }

    @Test
    void testCannotCreateDirectoryTwice() throws Exception {
        DirectoryLayer directoryLayer = new DirectoryLayer();
        try (Database database = fdb.open();){
            database.run(transaction -> {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("foo");
                try {
                    DirectorySubspace directorySubspace = (DirectorySubspace)directoryLayer.createOrOpen((TransactionContext)transaction, arrayList).join();
                    Assertions.assertEquals(arrayList, (Object)directorySubspace.getPath(), (String)"Incorrect path");
                    Assertions.assertTrue((boolean)((Boolean)directorySubspace.exists((ReadTransactionContext)transaction).join()), (String)"does not exist even though it's been created!");
                    try {
                        DirectorySubspace directorySubspace2 = (DirectorySubspace)directoryLayer.create((TransactionContext)transaction, arrayList).join();
                        Assertions.fail((String)"Was able to create a directory twice");
                    }
                    catch (DirectoryAlreadyExistsException directoryAlreadyExistsException) {
                    }
                    catch (CompletionException completionException) {
                        Throwable throwable = completionException.getCause();
                        if (!(throwable instanceof DirectoryAlreadyExistsException)) {
                            throw completionException;
                        }
                    }
                }
                finally {
                    directoryLayer.remove((TransactionContext)transaction, arrayList).join();
                }
                return null;
            });
        }
    }

    @Test
    void testCannotRemoveNonexistingDirectory() throws Exception {
        DirectoryLayer directoryLayer = new DirectoryLayer();
        try (Database database = fdb.open();){
            database.run(transaction -> {
                block2: {
                    try {
                        directoryLayer.remove((TransactionContext)transaction, Arrays.asList("doesnotexist")).join();
                    }
                    catch (CompletionException completionException) {
                        Throwable throwable = completionException.getCause();
                        if (throwable instanceof NoSuchDirectoryException) break block2;
                        throw completionException;
                    }
                }
                return null;
            });
        }
    }
}

