/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.TransactionContext;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.test.AbstractTester;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class PerformanceTester
extends AbstractTester {
    private final int keyCount;
    private final int keySize;
    private final int valueSize;
    private final String keyFormat;
    private final byte[] valueBytes;
    public static final int DEFAULT_KEY_COUNT = 10000;
    public static final int DEFAULT_KEY_SIZE = 16;
    public static final int DEFAULT_VALUE_SIZE = 100;

    public PerformanceTester() {
        this(10000, 16, 100);
    }

    public PerformanceTester(int n, int n2, int n3) {
        this.keyCount = n;
        this.keySize = n2;
        this.valueSize = n3;
        this.keyFormat = "%0" + n2 + "d";
        this.valueBytes = new byte[n3];
        Arrays.fill(this.valueBytes, (byte)120);
        Tests.FUTURE_LATENCY.setFunction(database -> this.futureLatency((Database)database, 100000));
        Tests.SET.setFunction(database -> this.set((Database)database, 100000));
        Tests.CLEAR.setFunction(database -> this.clear((Database)database, 100000));
        Tests.CLEAR_RANGE.setFunction(database -> this.clearRange((Database)database, 100000));
        Tests.PARALLEL_GET.setFunction(database -> this.parallelGet((TransactionContext)database, 10000));
        Tests.SERIAL_GET.setFunction(database -> this.serialGet((TransactionContext)database, 2000));
        Tests.GET_RANGE.setFunction(database -> this.getRange((TransactionContext)database, 1000));
        Tests.GET_KEY.setFunction(database -> this.getKey((TransactionContext)database, 2000));
        Tests.GET_SINGLE_KEY_RANGE.setFunction(database -> this.getSingleKeyRange((TransactionContext)database, 2000));
        Tests.ALTERNATING_GET_SET.setFunction(database -> this.alternatingGetSet((TransactionContext)database, 2000));
        Tests.WRITE_TRANSACTION.setFunction(database -> this.writeTransaction((TransactionContext)database, 1000));
    }

    @Override
    public void testPerformance(Database database) {
        this.insertData(database);
        List<String> list = this.args.getTestsToRun().isEmpty() ? Arrays.stream(Tests.values()).map(Enum::name).map(String::toLowerCase).sorted().collect(Collectors.toList()) : this.args.getTestsToRun();
        for (String string : list) {
            Tests tests;
            try {
                tests = Tests.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.result.addError(new IllegalArgumentException("Test " + string + " not implemented"));
                continue;
            }
            Function<? super Database, ? extends Double> function = tests.getFunction();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                this.result.addError(this.wrapAndPrintError(interruptedException, "Interrupted while sleeping"));
            }
            System.out.println("Running test " + string);
            ArrayList<Double> arrayList = new ArrayList<Double>(25);
            for (int i = 0; i < 25; ++i) {
                try {
                    arrayList.add(function.apply((Database)database));
                    continue;
                }
                catch (Exception exception) {
                    this.result.addError(this.wrapAndPrintError(exception, "Performance test failed: " + string));
                    break;
                }
            }
            if (arrayList.size() != 25) continue;
            Collections.sort(arrayList);
            this.result.addKpi(String.format("%s (%s)", tests.getKpi(), this.multiVersionDescription()), ((Double)arrayList.get(arrayList.size() / 2)).intValue(), "keys/s");
        }
    }

    public void insertData(Database database) {
        System.out.println("Loading database");
        database.run(transaction -> {
            byte[] byArray = this.args.getSubspace().pack();
            if (byArray.length == 0) {
                transaction.clear(new byte[0], new byte[]{-1});
            } else {
                transaction.clear(this.args.getSubspace().range());
            }
            return null;
        });
        int n = 100000 / (this.keySize + this.valueSize);
        int n2 = (int)Math.ceil((double)this.keyCount * 1.0 / (double)n);
        List list = IntStream.range(0, n2).mapToObj(n3 -> {
            int n4 = n * n3;
            int n5 = n3 + 1 == n2 ? this.keyCount : n * (n3 + 1);
            return database.runAsync(transaction -> {
                IntStream.range(n4, n5).forEach(n -> transaction.set(this.key(n), this.value(n)));
                return CompletableFuture.completedFuture(null);
            });
        }).collect(Collectors.toList());
        try {
            AsyncUtil.whenAll(list).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.result.addError(this.wrapAndPrintError(exception, "Data insertion failed"));
        }
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException interruptedException) {
            this.result.addError(this.wrapAndPrintError(interruptedException, "Interrupted while waiting for quiescence"));
        }
    }

    public Double futureLatency(Database database, int n) {
        return (Double)database.run(transaction -> {
            transaction.options().setRetryLimit(5L);
            transaction.getReadVersion().join();
            long l = System.nanoTime();
            for (int i = 0; i < n; ++i) {
                transaction.getReadVersion().join();
            }
            long l2 = System.nanoTime();
            return (double)n * 1.0E9 / (double)(l2 - l);
        });
    }

    public Double clear(Database database, int n) {
        try (Transaction transaction = database.createTransaction();){
            long l = System.nanoTime();
            for (int i = 0; i < n; ++i) {
                transaction.clear(this.randomKey());
            }
            long l2 = System.nanoTime();
            transaction.cancel();
            Double d = (double)n * 1.0E9 / (double)(l2 - l);
            return d;
        }
    }

    public Double clearRange(Database database, int n) {
        try (Transaction transaction = database.createTransaction();){
            long l = System.nanoTime();
            for (int i = 0; i < n; ++i) {
                int n2 = this.randomKeyIndex();
                transaction.clear(this.key(n2), this.key(n2 + 1));
            }
            long l2 = System.nanoTime();
            transaction.cancel();
            Double d = (double)n * 1.0E9 / (double)(l2 - l);
            return d;
        }
    }

    public Double set(Database database, int n) {
        try (Transaction transaction = database.createTransaction();){
            long l = System.nanoTime();
            for (int i = 0; i < n; ++i) {
                int n2 = this.randomKeyIndex();
                transaction.set(this.key(n2), this.value(n2));
            }
            long l2 = System.nanoTime();
            transaction.cancel();
            Double d = (double)n * 1.0E9 / (double)(l2 - l);
            return d;
        }
    }

    public Double parallelGet(TransactionContext transactionContext, int n) {
        return (Double)transactionContext.run(transaction -> {
            transaction.options().setRetryLimit(5L);
            long l = System.nanoTime();
            List list = IntStream.range(0, n).mapToObj(n -> transaction.get(this.randomKey())).collect(Collectors.toList());
            AsyncUtil.whenAll(list).join();
            long l2 = System.nanoTime();
            return (double)n * 1.0E9 / (double)(l2 - l);
        });
    }

    public Double alternatingGetSet(TransactionContext transactionContext, int n) {
        return (Double)transactionContext.run(transaction -> {
            transaction.options().setRetryLimit(5L);
            long l = System.nanoTime();
            List list = IntStream.range(0, n).mapToObj(n -> {
                int n2 = this.randomKeyIndex();
                byte[] byArray = this.key(n2);
                byte[] byArray2 = this.value(n2);
                transaction.set(byArray, byArray2);
                return transaction.get(byArray);
            }).collect(Collectors.toList());
            AsyncUtil.whenAll(list).join();
            long l2 = System.nanoTime();
            return (double)n * 1.0E9 / (double)(l2 - l);
        });
    }

    public Double serialGet(TransactionContext transactionContext, int n) {
        return (Double)transactionContext.run(transaction -> {
            List list;
            transaction.options().setRetryLimit(5L);
            if (n > this.keyCount / 2) {
                list = Stream.generate(this::randomKey).limit(n).collect(Collectors.toList());
            } else {
                HashSet<Integer> hashSet = new HashSet<Integer>();
                while (hashSet.size() < n) {
                    hashSet.add(this.randomKeyIndex());
                }
                list = hashSet.stream().map(this::key).collect(Collectors.toList());
            }
            long l = System.nanoTime();
            for (byte[] byArray : list) {
                transaction.get(byArray).join();
            }
            long l2 = System.nanoTime();
            return (double)n * 1.0E9 / (double)(l2 - l);
        });
    }

    public Double getRange(TransactionContext transactionContext, int n) {
        return (Double)transactionContext.run(transaction -> {
            transaction.options().setRetryLimit(5L);
            int n2 = this.random.nextInt(this.keyCount - n);
            long l = System.nanoTime();
            transaction.getRange(this.key(n2), this.key(n2 + n)).asList().join();
            long l2 = System.nanoTime();
            return (double)n * 1.0E9 / (double)(l2 - l);
        });
    }

    public Double getKey(TransactionContext transactionContext, int n) {
        return (Double)transactionContext.run(transaction -> {
            transaction.options().setRetryLimit(5L);
            long l = System.nanoTime();
            for (int i = 0; i < n; ++i) {
                transaction.getKey(new KeySelector(this.randomKey(), true, this.random.nextInt(20) - 10)).join();
            }
            long l2 = System.nanoTime();
            return (double)n * 1.0E9 / (double)(l2 - l);
        });
    }

    public Double getSingleKeyRange(TransactionContext transactionContext, int n) {
        return (Double)transactionContext.run(transaction -> {
            transaction.options().setRetryLimit(5L);
            long l = System.nanoTime();
            for (int i = 0; i < n; ++i) {
                int n2 = this.randomKeyIndex();
                transaction.getRange(this.key(n2), this.key(n2 + 1), 2).asList().join();
            }
            long l2 = System.nanoTime();
            return (double)n * 1.0E9 / (double)(l2 - l);
        });
    }

    public Double writeTransaction(TransactionContext transactionContext, int n) {
        long l = System.nanoTime();
        for (int i = 0; i < n; ++i) {
            transactionContext.run(transaction -> {
                int n = this.randomKeyIndex();
                transaction.set(this.key(n), this.value(n));
                return null;
            });
        }
        long l2 = System.nanoTime();
        return (double)n * 1.0E9 / (double)(l2 - l);
    }

    public byte[] key(int n) {
        return ByteArrayUtil.join((byte[][])new byte[][]{this.args.getSubspace().pack(), String.format(this.keyFormat, n).getBytes(ASCII)});
    }

    public int randomKeyIndex() {
        return this.random.nextInt(this.keyCount);
    }

    public byte[] randomKey() {
        return this.key(this.randomKeyIndex());
    }

    public byte[] value(int n) {
        return this.valueBytes;
    }

    public static void main(String[] stringArray) {
        System.out.println("Running Java performance test on Java version " + System.getProperty("java.version"));
        try {
            new PerformanceTester().run(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Could not run test due to malformed arguments.");
            System.out.println(illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            System.out.println("Fatal error encountered during run: " + exception);
            exception.printStackTrace();
            System.exit(2);
        }
    }

    private static enum Tests {
        FUTURE_LATENCY("Java Completable API future throughput"),
        SET("Java Completable API set throughput"),
        CLEAR("Java Completable API clear throughput"),
        CLEAR_RANGE("Java Completable API clear_range throughput"),
        PARALLEL_GET("Java Completable API parallel get throughput"),
        SERIAL_GET("Java Completable API serial get throughput"),
        GET_RANGE("Java Completable API get_range throughput"),
        GET_KEY("Java Completable API get_key throughput"),
        GET_SINGLE_KEY_RANGE("Java Completable API get_single_key_range throughput"),
        ALTERNATING_GET_SET("Java Completable API alternating get and set throughput"),
        WRITE_TRANSACTION("Java Completable API single-key transaction throughput");

        private String kpi;
        private Function<? super Database, ? extends Double> function;

        private Tests(String string2) {
            this.kpi = string2;
        }

        public void setFunction(Function<? super Database, ? extends Double> function) {
            this.function = function;
        }

        public Function<? super Database, ? extends Double> getFunction() {
            return this.function;
        }

        public String getKpi() {
            return this.kpi;
        }
    }
}

