#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
/*
 * UDPWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBTypes.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/ActorCollection.h"
#include "flow/Arena.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/flow.h"
#include "flow/network.h"
#include "flow/serialize.h"
#include <functional>
#include <limits>
#include <unordered_map>
#include <vector>
#include <memory>
#include <functional>
#include "flow/IUDPSocket.h"
#include "flow/IConnection.h"
#include "flow/actorcompiler.h" // has to be last include

namespace {

struct UDPWorkload : TestWorkload {
	constexpr static auto NAME = "UDPWorkload";
	// config
	Key keyPrefix;
	double runFor;
	int minPort, maxPort;
	//  members
	NetworkAddress serverAddress;
	Reference<IUDPSocket> serverSocket;
	std::unordered_map<NetworkAddress, unsigned> sent, received, acked, successes;
	PromiseStream<NetworkAddress> toAck;

	UDPWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		keyPrefix = getOption(options, "keyPrefix"_sr, "/udp/"_sr);
		runFor = getOption(options, "runFor"_sr, 60.0);
		minPort = getOption(options, "minPort"_sr, 5000);
		maxPort = getOption(options, "minPort"_sr, 6000);
		for (auto p : { minPort, maxPort }) {
			ASSERT(p > 0 && p < std::numeric_limits<unsigned short>::max());
		}
	}

																#line 67 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
template <class _setupActor>
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
class _setupActorState {
															#line 73 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
public:
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	_setupActorState(UDPWorkload* const& self,Database const& cx) 
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		 : self(self),
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   cx(cx),
															#line 66 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   localAddress(g_network->getLocalAddress().ip, deterministicRandom()->randomInt(self->minPort, self->maxPort + 1), true, false),
															#line 70 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   key(self->keyPrefix.withSuffix(BinaryWriter::toValue(self->clientId, Unversioned()))),
															#line 71 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   serializedLocalAddress(BinaryWriter::toValue(localAddress, IncludeVersion())),
															#line 72 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   tr(cx)
															#line 90 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			StrictFuture<Reference<IUDPSocket>> __when_expr_0 = INetworkConnections::net()->createUDPSocket(localAddress.isV6());
															#line 73 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 107 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 73 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Reference<IUDPSocket> >*>(static_cast<_setupActor*>(this)));
															#line 112 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IUDPSocket> const& s,int loopDepth) 
	{
															#line 74 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		self->serverSocket = std::move(s);
															#line 75 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		self->serverSocket->bind(localAddress);
															#line 76 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		self->serverAddress = localAddress;
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		;
															#line 141 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Reference<IUDPSocket> && s,int loopDepth) 
	{
															#line 74 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		self->serverSocket = std::move(s);
															#line 75 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		self->serverSocket->bind(localAddress);
															#line 76 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		self->serverAddress = localAddress;
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		;
															#line 156 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IUDPSocket> const& s,int loopDepth) 
	{
		loopDepth = a_body1cont1(s, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IUDPSocket> && s,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Reference<IUDPSocket> >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Reference<IUDPSocket> >*,Reference<IUDPSocket> const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Reference<IUDPSocket> >*,Reference<IUDPSocket> && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Reference<IUDPSocket> >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 79 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(key);
															#line 79 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 250 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 79 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Optional<Value> >*>(static_cast<_setupActor*>(this)));
															#line 255 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 87 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 87 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 279 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 4;
															#line 87 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 3, Void >*>(static_cast<_setupActor*>(this)));
															#line 284 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Value> const& v,int loopDepth) 
	{
															#line 80 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (v.present())
															#line 299 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		{
															#line 81 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 303 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_setupActorState();
			static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 83 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		tr.set(key, serializedLocalAddress);
															#line 84 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 84 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 315 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 84 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 320 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Value> && v,int loopDepth) 
	{
															#line 80 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (v.present())
															#line 329 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		{
															#line 81 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 333 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_setupActorState();
			static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 83 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		tr.set(key, serializedLocalAddress);
															#line 84 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 84 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 345 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 84 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 350 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 85 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 434 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 85 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 446 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _setupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _setupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _setupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	UDPWorkload* self;
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	Database cx;
															#line 66 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	NetworkAddress localAddress;
															#line 70 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	Key key;
															#line 71 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	Value serializedLocalAddress;
															#line 72 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 628 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Reference<IUDPSocket> >, public ActorCallback< _setupActor, 1, Optional<Value> >, public ActorCallback< _setupActor, 2, Void >, public ActorCallback< _setupActor, 3, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 633 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3389550262530236160UL, 18371524754731708672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Reference<IUDPSocket> >;
friend struct ActorCallback< _setupActor, 1, Optional<Value> >;
friend struct ActorCallback< _setupActor, 2, Void >;
friend struct ActorCallback< _setupActor, 3, Void >;
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	_setupActor(UDPWorkload* const& self,Database const& cx) 
															#line 653 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Reference<IUDPSocket> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _setupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _setupActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _setup( UDPWorkload* const& self, Database const& cx ) {
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	return Future<Void>(new _setupActor(self, cx));
															#line 688 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
}

#line 91 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	Future<Void> setup(Database const& cx) override { return _setup(this, cx); }

	class Message {
		int _type = 0;

	public:
		enum class Type : uint8_t { PING, PONG };
		Message() {}
		explicit Message(Type t) {
			switch (t) {
			case Type::PING:
				_type = 0;
				break;
			case Type::PONG:
				_type = 1;
				break;
			default:
				UNSTOPPABLE_ASSERT(false);
			}
		}

		Type type() const {
			switch (_type) {
			case 0:
				return Type::PING;
			case 1:
				return Type::PONG;
			default:
				UNSTOPPABLE_ASSERT(false);
			}
		}

		template <class Ar>
		void serialize(Ar& ar) {
			serializer(ar, _type);
		}
	};

	static Message ping() { return Message{ Message::Type::PING }; }
	static Message pong() { return Message{ Message::Type::PONG }; }

																#line 733 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
// This generated class is to be used only via _receiver()
															#line 132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
template <class _receiverActor>
															#line 132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
class _receiverActorState {
															#line 739 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
public:
															#line 132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	_receiverActorState(UDPWorkload* const& self) 
															#line 132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
															#line 132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		 : self(self),
															#line 133 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   packetString(makeString(IUDPSocket::MAX_PACKET_SIZE)),
															#line 134 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   packet(mutateString(packetString)),
															#line 135 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   peerAddress()
															#line 752 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_receiver", reinterpret_cast<unsigned long>(this));

	}
	~_receiverActorState() 
	{
		fdb_probe_actor_destroy("_receiver", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 136 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			;
															#line 767 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_receiverActorState();
		static_cast<_receiverActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 137 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		StrictFuture<int> __when_expr_0 = self->serverSocket->receiveFrom(packet, packet + IUDPSocket::MAX_PACKET_SIZE, &peerAddress);
															#line 137 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (static_cast<_receiverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 799 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_receiverActor*>(this)->actor_wait_state = 1;
															#line 137 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _receiverActor, 0, int >*>(static_cast<_receiverActor*>(this)));
															#line 804 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int const& sz,int loopDepth) 
	{
															#line 138 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		auto msg = BinaryReader::fromStringRef<Message>(packetString.substr(0, sz), IncludeVersion());
															#line 139 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (msg.type() == Message::Type::PONG)
															#line 815 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		{
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			self->successes[peerAddress] += 1;
															#line 819 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		}
		else
		{
															#line 141 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			if (msg.type() == Message::Type::PING)
															#line 825 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			{
															#line 142 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
				self->received[peerAddress] += 1;
															#line 143 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
				self->toAck.send(peerAddress);
															#line 831 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			}
			else
			{
															#line 145 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
				UNSTOPPABLE_ASSERT(false);
															#line 837 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int && sz,int loopDepth) 
	{
															#line 138 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		auto msg = BinaryReader::fromStringRef<Message>(packetString.substr(0, sz), IncludeVersion());
															#line 139 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (msg.type() == Message::Type::PONG)
															#line 850 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		{
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			self->successes[peerAddress] += 1;
															#line 854 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		}
		else
		{
															#line 141 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			if (msg.type() == Message::Type::PING)
															#line 860 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			{
															#line 142 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
				self->received[peerAddress] += 1;
															#line 143 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
				self->toAck.send(peerAddress);
															#line 866 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			}
			else
			{
															#line 145 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
				UNSTOPPABLE_ASSERT(false);
															#line 872 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(int const& sz,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(sz, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int && sz,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(sz), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_receiverActor*>(this)->actor_wait_state > 0) static_cast<_receiverActor*>(this)->actor_wait_state = 0;
		static_cast<_receiverActor*>(this)->ActorCallback< _receiverActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< _receiverActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("_receiver", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_receiverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_receiver", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _receiverActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("_receiver", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_receiverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_receiver", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _receiverActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("_receiver", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_receiverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_receiver", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	UDPWorkload* self;
															#line 133 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	Standalone<StringRef> packetString;
															#line 134 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	uint8_t* packet;
															#line 135 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	NetworkAddress peerAddress;
															#line 962 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
};
// This generated class is to be used only via _receiver()
															#line 132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
class _receiverActor final : public Actor<Void>, public ActorCallback< _receiverActor, 0, int >, public FastAllocated<_receiverActor>, public _receiverActorState<_receiverActor> {
															#line 967 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
public:
	using FastAllocated<_receiverActor>::operator new;
	using FastAllocated<_receiverActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11840387066135300096UL, 12498816420680804864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _receiverActor, 0, int >;
															#line 132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	_receiverActor(UDPWorkload* const& self) 
															#line 984 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _receiverActorState<_receiverActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_receiver", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10928306750396110336UL, 17010161351475176448UL);
		ActorExecutionContextHelper __helper(static_cast<_receiverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_receiver");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_receiver", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _receiverActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _receiver( UDPWorkload* const& self ) {
															#line 132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	return Future<Void>(new _receiverActor(self));
															#line 1016 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
}

#line 149 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"

																#line 1021 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
// This generated class is to be used only via serverSender()
															#line 150 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
template <class ServerSenderActor>
															#line 150 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
class ServerSenderActorState {
															#line 1027 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
public:
															#line 150 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	ServerSenderActorState(UDPWorkload* const& self,std::vector<NetworkAddress>* const& remotes) 
															#line 150 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
															#line 150 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		 : self(self),
															#line 150 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   remotes(remotes),
															#line 151 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   packetString(),
															#line 152 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   peer()
															#line 1040 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("serverSender", reinterpret_cast<unsigned long>(this));

	}
	~ServerSenderActorState() 
	{
		fdb_probe_actor_destroy("serverSender", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 153 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			;
															#line 1055 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServerSenderActorState();
		static_cast<ServerSenderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 155 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0.1);
															#line 154 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (static_cast<ServerSenderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1087 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 160 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		auto __when_expr_1 = self->toAck.getFuture();
															#line 1091 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<NetworkAddress>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<NetworkAddress>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
		static_cast<ServerSenderActor*>(this)->actor_wait_state = 1;
															#line 155 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ServerSenderActor, 0, Void >*>(static_cast<ServerSenderActor*>(this)));
															#line 160 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ServerSenderActor, 1, NetworkAddress >*>(static_cast<ServerSenderActor*>(this)));
															#line 1099 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 166 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		StrictFuture<int> __when_expr_2 = self->serverSocket->sendTo(packetString.begin(), packetString.end(), peer);
															#line 166 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (static_cast<ServerSenderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1110 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ServerSenderActor*>(this)->actor_wait_state = 2;
															#line 166 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ServerSenderActor, 2, int >*>(static_cast<ServerSenderActor*>(this)));
															#line 1115 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		peer = deterministicRandom()->randomChoice(*remotes);
															#line 157 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		packetString = BinaryWriter::toValue(Message{ Message::Type::PING }, IncludeVersion());
															#line 158 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		self->sent[peer] += 1;
															#line 1128 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		peer = deterministicRandom()->randomChoice(*remotes);
															#line 157 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		packetString = BinaryWriter::toValue(Message{ Message::Type::PING }, IncludeVersion());
															#line 158 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		self->sent[peer] += 1;
															#line 1141 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(NetworkAddress const& p,int loopDepth) 
	{
															#line 161 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		peer = p;
															#line 162 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		packetString = BinaryWriter::toValue(pong(), IncludeVersion());
															#line 163 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		self->acked[peer] += 1;
															#line 1154 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(NetworkAddress && p,int loopDepth) 
	{
															#line 161 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		peer = p;
															#line 162 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		packetString = BinaryWriter::toValue(pong(), IncludeVersion());
															#line 163 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		self->acked[peer] += 1;
															#line 1167 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServerSenderActor*>(this)->actor_wait_state > 0) static_cast<ServerSenderActor*>(this)->actor_wait_state = 0;
		static_cast<ServerSenderActor*>(this)->ActorCallback< ServerSenderActor, 0, Void >::remove();
		static_cast<ServerSenderActor*>(this)->ActorSingleCallback< ServerSenderActor, 1, NetworkAddress >::remove();

	}
	void a_callback_fire(ActorCallback< ServerSenderActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverSender", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverSender", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServerSenderActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverSender", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverSender", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ServerSenderActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverSender", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverSender", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ServerSenderActor, 1, NetworkAddress >*,NetworkAddress const& value) 
	{
		fdb_probe_actor_enter("serverSender", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverSender", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ServerSenderActor, 1, NetworkAddress >*,NetworkAddress && value) 
	{
		fdb_probe_actor_enter("serverSender", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverSender", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< ServerSenderActor, 1, NetworkAddress >*,Error err) 
	{
		fdb_probe_actor_enter("serverSender", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverSender", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2(int const& res,int loopDepth) 
	{
															#line 167 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		ASSERT(res == packetString.size());
															#line 1297 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(int && res,int loopDepth) 
	{
															#line 167 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		ASSERT(res == packetString.size());
															#line 1306 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(int const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(int && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ServerSenderActor*>(this)->actor_wait_state > 0) static_cast<ServerSenderActor*>(this)->actor_wait_state = 0;
		static_cast<ServerSenderActor*>(this)->ActorCallback< ServerSenderActor, 2, int >::remove();

	}
	void a_callback_fire(ActorCallback< ServerSenderActor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("serverSender", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverSender", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ServerSenderActor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("serverSender", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverSender", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ServerSenderActor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("serverSender", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverSender", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 150 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	UDPWorkload* self;
															#line 150 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	std::vector<NetworkAddress>* remotes;
															#line 151 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	Standalone<StringRef> packetString;
															#line 152 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	NetworkAddress peer;
															#line 1394 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
};
// This generated class is to be used only via serverSender()
															#line 150 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
class ServerSenderActor final : public Actor<Void>, public ActorCallback< ServerSenderActor, 0, Void >, public ActorSingleCallback< ServerSenderActor, 1, NetworkAddress >, public ActorCallback< ServerSenderActor, 2, int >, public FastAllocated<ServerSenderActor>, public ServerSenderActorState<ServerSenderActor> {
															#line 1399 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
public:
	using FastAllocated<ServerSenderActor>::operator new;
	using FastAllocated<ServerSenderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4402226870543011072UL, 814525898809461504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ServerSenderActor, 0, Void >;
friend struct ActorSingleCallback< ServerSenderActor, 1, NetworkAddress >;
friend struct ActorCallback< ServerSenderActor, 2, int >;
															#line 150 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	ServerSenderActor(UDPWorkload* const& self,std::vector<NetworkAddress>* const& remotes) 
															#line 1418 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ServerSenderActorState<ServerSenderActor>(self, remotes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serverSender", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7945865053695731456UL, 5314207074791644160UL);
		ActorExecutionContextHelper __helper(static_cast<ServerSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serverSender");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serverSender", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ServerSenderActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ServerSenderActor, 2, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 150 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
[[nodiscard]] static Future<Void> serverSender( UDPWorkload* const& self, std::vector<NetworkAddress>* const& remotes ) {
															#line 150 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	return Future<Void>(new ServerSenderActor(self, remotes));
															#line 1451 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
}

#line 170 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"

																#line 1456 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
// This generated class is to be used only via clientReceiver()
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
template <class ClientReceiverActor>
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
class ClientReceiverActorState {
															#line 1462 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
public:
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	ClientReceiverActorState(UDPWorkload* const& self,Reference<IUDPSocket> const& socket,Future<Void> const& done) 
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		 : self(self),
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   socket(socket),
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   done(done),
															#line 172 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   packetString(makeString(IUDPSocket::MAX_PACKET_SIZE)),
															#line 173 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   packet(mutateString(packetString)),
															#line 174 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   peer(),
															#line 175 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   finished(Never())
															#line 1481 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("clientReceiver", reinterpret_cast<unsigned long>(this));

	}
	~ClientReceiverActorState() 
	{
		fdb_probe_actor_destroy("clientReceiver", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 176 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			;
															#line 1496 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClientReceiverActorState();
		static_cast<ClientReceiverActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 178 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		StrictFuture<int> __when_expr_0 = socket->receiveFrom(packet, packet + IUDPSocket::MAX_PACKET_SIZE, &peer);
															#line 177 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (static_cast<ClientReceiverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1528 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 183 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = done;
															#line 1532 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 187 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = finished;
															#line 1536 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
		static_cast<ClientReceiverActor*>(this)->actor_wait_state = 1;
															#line 178 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClientReceiverActor, 0, int >*>(static_cast<ClientReceiverActor*>(this)));
															#line 183 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClientReceiverActor, 1, Void >*>(static_cast<ClientReceiverActor*>(this)));
															#line 187 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClientReceiverActor, 2, Void >*>(static_cast<ClientReceiverActor*>(this)));
															#line 1545 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(int const& sz,int loopDepth) 
	{
															#line 179 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		auto res = BinaryReader::fromStringRef<Message>(packetString.substr(0, sz), IncludeVersion());
															#line 180 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		ASSERT(res.type() == Message::Type::PONG);
															#line 181 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		self->successes[peer] += 1;
															#line 1564 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int && sz,int loopDepth) 
	{
															#line 179 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		auto res = BinaryReader::fromStringRef<Message>(packetString.substr(0, sz), IncludeVersion());
															#line 180 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		ASSERT(res.type() == Message::Type::PONG);
															#line 181 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		self->successes[peer] += 1;
															#line 1577 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 184 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		finished = delay(1.0);
															#line 185 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		done = Never();
															#line 1588 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 184 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		finished = delay(1.0);
															#line 185 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		done = Never();
															#line 1599 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 188 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (!static_cast<ClientReceiverActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClientReceiverActorState(); static_cast<ClientReceiverActor*>(this)->destroy(); return 0; }
															#line 1608 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		new (&static_cast<ClientReceiverActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClientReceiverActorState();
		static_cast<ClientReceiverActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 188 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (!static_cast<ClientReceiverActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClientReceiverActorState(); static_cast<ClientReceiverActor*>(this)->destroy(); return 0; }
															#line 1620 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		new (&static_cast<ClientReceiverActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClientReceiverActorState();
		static_cast<ClientReceiverActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClientReceiverActor*>(this)->actor_wait_state > 0) static_cast<ClientReceiverActor*>(this)->actor_wait_state = 0;
		static_cast<ClientReceiverActor*>(this)->ActorCallback< ClientReceiverActor, 0, int >::remove();
		static_cast<ClientReceiverActor*>(this)->ActorCallback< ClientReceiverActor, 1, Void >::remove();
		static_cast<ClientReceiverActor*>(this)->ActorCallback< ClientReceiverActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClientReceiverActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("clientReceiver", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientReceiverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientReceiver", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClientReceiverActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("clientReceiver", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientReceiverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientReceiver", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClientReceiverActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("clientReceiver", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClientReceiverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientReceiver", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClientReceiverActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clientReceiver", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientReceiverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientReceiver", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClientReceiverActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clientReceiver", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientReceiverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientReceiver", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClientReceiverActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clientReceiver", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClientReceiverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientReceiver", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClientReceiverActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clientReceiver", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientReceiverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientReceiver", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClientReceiverActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clientReceiver", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientReceiverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientReceiver", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClientReceiverActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clientReceiver", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClientReceiverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientReceiver", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	UDPWorkload* self;
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	Reference<IUDPSocket> socket;
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	Future<Void> done;
															#line 172 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	Standalone<StringRef> packetString;
															#line 173 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	uint8_t* packet;
															#line 174 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	NetworkAddress peer;
															#line 175 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	Future<Void> finished;
															#line 1821 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
};
// This generated class is to be used only via clientReceiver()
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
class ClientReceiverActor final : public Actor<Void>, public ActorCallback< ClientReceiverActor, 0, int >, public ActorCallback< ClientReceiverActor, 1, Void >, public ActorCallback< ClientReceiverActor, 2, Void >, public FastAllocated<ClientReceiverActor>, public ClientReceiverActorState<ClientReceiverActor> {
															#line 1826 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
public:
	using FastAllocated<ClientReceiverActor>::operator new;
	using FastAllocated<ClientReceiverActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11071811170309745152UL, 8331368404746096384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClientReceiverActor, 0, int >;
friend struct ActorCallback< ClientReceiverActor, 1, Void >;
friend struct ActorCallback< ClientReceiverActor, 2, Void >;
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	ClientReceiverActor(UDPWorkload* const& self,Reference<IUDPSocket> const& socket,Future<Void> const& done) 
															#line 1845 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ClientReceiverActorState<ClientReceiverActor>(self, socket, done),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clientReceiver", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6500394047193376256UL, 6856538299099899648UL);
		ActorExecutionContextHelper __helper(static_cast<ClientReceiverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clientReceiver");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clientReceiver", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClientReceiverActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
[[nodiscard]] static Future<Void> clientReceiver( UDPWorkload* const& self, Reference<IUDPSocket> const& socket, Future<Void> const& done ) {
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	return Future<Void>(new ClientReceiverActor(self, socket, done));
															#line 1877 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
}

#line 193 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"

																#line 1882 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
// This generated class is to be used only via clientSender()
															#line 194 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
template <class ClientSenderActor>
															#line 194 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
class ClientSenderActorState {
															#line 1888 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
public:
															#line 194 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	ClientSenderActorState(UDPWorkload* const& self,std::vector<NetworkAddress>* const& remotes) 
															#line 194 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
															#line 194 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		 : self(self),
															#line 194 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   remotes(remotes),
															#line 195 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   socket(),
															#line 196 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   sendString(),
															#line 197 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   actors(false),
															#line 198 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   peer()
															#line 1905 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("clientSender", reinterpret_cast<unsigned long>(this));

	}
	~ClientSenderActorState() 
	{
		fdb_probe_actor_destroy("clientSender", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 200 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			;
															#line 1920 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClientSenderActorState();
		static_cast<ClientSenderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 202 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0.1);
															#line 201 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (static_cast<ClientSenderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1952 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 203 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = actors.getResult();
															#line 1956 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ClientSenderActor*>(this)->actor_wait_state = 1;
															#line 202 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClientSenderActor, 0, Void >*>(static_cast<ClientSenderActor*>(this)));
															#line 203 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClientSenderActor, 1, Void >*>(static_cast<ClientSenderActor*>(this)));
															#line 1963 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 207 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (!socket.get().isValid() || deterministicRandom()->random01() < 0.05)
															#line 1972 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		{
															#line 208 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			peer = deterministicRandom()->randomChoice(*remotes);
															#line 209 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			StrictFuture<Reference<IUDPSocket>> __when_expr_2 = INetworkConnections::net()->createUDPSocket(peer);
															#line 209 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			if (static_cast<ClientSenderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1980 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ClientSenderActor*>(this)->actor_wait_state = 2;
															#line 209 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClientSenderActor, 2, Reference<IUDPSocket> >*>(static_cast<ClientSenderActor*>(this)));
															#line 1985 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 204 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		UNSTOPPABLE_ASSERT(false);
															#line 2011 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 204 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		UNSTOPPABLE_ASSERT(false);
															#line 2020 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClientSenderActor*>(this)->actor_wait_state > 0) static_cast<ClientSenderActor*>(this)->actor_wait_state = 0;
		static_cast<ClientSenderActor*>(this)->ActorCallback< ClientSenderActor, 0, Void >::remove();
		static_cast<ClientSenderActor*>(this)->ActorCallback< ClientSenderActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClientSenderActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clientSender", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientSender", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClientSenderActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clientSender", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientSender", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClientSenderActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clientSender", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClientSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientSender", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClientSenderActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clientSender", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientSender", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClientSenderActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clientSender", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientSender", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClientSenderActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clientSender", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClientSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientSender", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 214 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		sendString = BinaryWriter::toValue(ping(), IncludeVersion());
															#line 215 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		StrictFuture<int> __when_expr_3 = socket.get()->send(sendString.begin(), sendString.end());
															#line 215 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (static_cast<ClientSenderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2154 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<ClientSenderActor*>(this)->actor_wait_state = 3;
															#line 215 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClientSenderActor, 3, int >*>(static_cast<ClientSenderActor*>(this)));
															#line 2159 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Reference<IUDPSocket> const& s,int loopDepth) 
	{
															#line 210 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		socket.set(s);
															#line 211 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		socket = s;
															#line 212 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		actors.add(clientReceiver(self, socket.get(), socket.onChange()));
															#line 2172 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Reference<IUDPSocket> && s,int loopDepth) 
	{
															#line 210 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		socket.set(s);
															#line 211 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		socket = s;
															#line 212 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		actors.add(clientReceiver(self, socket.get(), socket.onChange()));
															#line 2185 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Reference<IUDPSocket> const& s,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(s, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Reference<IUDPSocket> && s,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClientSenderActor*>(this)->actor_wait_state > 0) static_cast<ClientSenderActor*>(this)->actor_wait_state = 0;
		static_cast<ClientSenderActor*>(this)->ActorCallback< ClientSenderActor, 2, Reference<IUDPSocket> >::remove();

	}
	void a_callback_fire(ActorCallback< ClientSenderActor, 2, Reference<IUDPSocket> >*,Reference<IUDPSocket> const& value) 
	{
		fdb_probe_actor_enter("clientSender", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientSender", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClientSenderActor, 2, Reference<IUDPSocket> >*,Reference<IUDPSocket> && value) 
	{
		fdb_probe_actor_enter("clientSender", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientSender", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClientSenderActor, 2, Reference<IUDPSocket> >*,Error err) 
	{
		fdb_probe_actor_enter("clientSender", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClientSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientSender", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int const& res,int loopDepth) 
	{
															#line 216 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		ASSERT(res == sendString.size());
															#line 217 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		self->sent[peer] += 1;
															#line 2271 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5(int && res,int loopDepth) 
	{
															#line 216 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		ASSERT(res == sendString.size());
															#line 217 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		self->sent[peer] += 1;
															#line 2282 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(int const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(int && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClientSenderActor*>(this)->actor_wait_state > 0) static_cast<ClientSenderActor*>(this)->actor_wait_state = 0;
		static_cast<ClientSenderActor*>(this)->ActorCallback< ClientSenderActor, 3, int >::remove();

	}
	void a_callback_fire(ActorCallback< ClientSenderActor, 3, int >*,int const& value) 
	{
		fdb_probe_actor_enter("clientSender", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientSender", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClientSenderActor, 3, int >*,int && value) 
	{
		fdb_probe_actor_enter("clientSender", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientSender", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClientSenderActor, 3, int >*,Error err) 
	{
		fdb_probe_actor_enter("clientSender", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClientSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientSender", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 194 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	UDPWorkload* self;
															#line 194 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	std::vector<NetworkAddress>* remotes;
															#line 195 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	AsyncVar<Reference<IUDPSocket>> socket;
															#line 196 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	Standalone<StringRef> sendString;
															#line 197 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	ActorCollection actors;
															#line 198 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	NetworkAddress peer;
															#line 2374 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
};
// This generated class is to be used only via clientSender()
															#line 194 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
class ClientSenderActor final : public Actor<Void>, public ActorCallback< ClientSenderActor, 0, Void >, public ActorCallback< ClientSenderActor, 1, Void >, public ActorCallback< ClientSenderActor, 2, Reference<IUDPSocket> >, public ActorCallback< ClientSenderActor, 3, int >, public FastAllocated<ClientSenderActor>, public ClientSenderActorState<ClientSenderActor> {
															#line 2379 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
public:
	using FastAllocated<ClientSenderActor>::operator new;
	using FastAllocated<ClientSenderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14892314957945332992UL, 8386728684695747072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClientSenderActor, 0, Void >;
friend struct ActorCallback< ClientSenderActor, 1, Void >;
friend struct ActorCallback< ClientSenderActor, 2, Reference<IUDPSocket> >;
friend struct ActorCallback< ClientSenderActor, 3, int >;
															#line 194 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	ClientSenderActor(UDPWorkload* const& self,std::vector<NetworkAddress>* const& remotes) 
															#line 2399 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ClientSenderActorState<ClientSenderActor>(self, remotes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clientSender", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17000371753195964928UL, 4599227785104826880UL);
		ActorExecutionContextHelper __helper(static_cast<ClientSenderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clientSender");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clientSender", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClientSenderActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClientSenderActor, 2, Reference<IUDPSocket> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClientSenderActor, 3, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 194 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
[[nodiscard]] static Future<Void> clientSender( UDPWorkload* const& self, std::vector<NetworkAddress>* const& remotes ) {
															#line 194 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	return Future<Void>(new ClientSenderActor(self, remotes));
															#line 2433 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
}

#line 220 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"

																#line 2438 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 221 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
template <class _startActor>
															#line 221 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
class _startActorState {
															#line 2444 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
public:
															#line 221 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	_startActorState(UDPWorkload* const& self,Database const& cx) 
															#line 221 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
															#line 221 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		 : self(self),
															#line 221 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   cx(cx),
															#line 222 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   tr(cx),
															#line 223 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		   remotes()
															#line 2457 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 224 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			;
															#line 2472 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 240 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = clientSender(self, &remotes) && serverSender(self, &remotes) && _receiver(self);
															#line 240 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2497 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 240 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 2502 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 226 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(prefixRange(self->keyPrefix), CLIENT_KNOBS->TOO_MANY);
															#line 226 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2521 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 226 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 2526 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 237 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 237 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2563 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 237 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 2568 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& range,int loopDepth) 
	{
															#line 227 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		ASSERT(!range.more);
															#line 228 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		for( auto const& p : range ) {
															#line 229 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			auto cID = BinaryReader::fromStringRef<decltype(self->clientId)>( p.key.removePrefix(self->keyPrefix), Unversioned());
															#line 231 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			if (cID != self->clientId)
															#line 2589 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			{
															#line 232 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
				remotes.emplace_back(BinaryReader::fromStringRef<NetworkAddress>(p.value, IncludeVersion()));
															#line 2593 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			}
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && range,int loopDepth) 
	{
															#line 227 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		ASSERT(!range.more);
															#line 228 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		for( auto const& p : range ) {
															#line 229 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			auto cID = BinaryReader::fromStringRef<decltype(self->clientId)>( p.key.removePrefix(self->keyPrefix), Unversioned());
															#line 231 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
			if (cID != self->clientId)
															#line 2610 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			{
															#line 232 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
				remotes.emplace_back(BinaryReader::fromStringRef<NetworkAddress>(p.value, IncludeVersion()));
															#line 2614 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
			}
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(range, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 241 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		UNSTOPPABLE_ASSERT(false);
															#line 242 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 2789 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 241 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		UNSTOPPABLE_ASSERT(false);
															#line 242 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 2803 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 221 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	UDPWorkload* self;
															#line 221 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	Database cx;
															#line 222 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 223 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	std::vector<NetworkAddress> remotes;
															#line 2894 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 221 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, RangeResult >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 2899 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14715335439026512128UL, 13746131196869741312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, RangeResult >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
															#line 221 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	_startActor(UDPWorkload* const& self,Database const& cx) 
															#line 2918 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 221 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _start( UDPWorkload* const& self, Database const& cx ) {
															#line 221 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 2952 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UDPWorkload.actor.g.cpp"
}

#line 244 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/UDPWorkload.actor.cpp"
	Future<Void> start(Database const& cx) override { return delay(runFor) || _start(this, cx); }
	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {
		unsigned totalReceived = 0, totalSent = 0, totalAcked = 0, totalSuccess = 0;
		for (const auto& p : sent) {
			totalSent += p.second;
		}
		for (const auto& p : received) {
			totalReceived += p.second;
		}
		for (const auto& p : acked) {
			totalAcked += p.second;
		}
		for (const auto& p : successes) {
			totalSuccess += p.second;
		}
		m.emplace_back("Sent", totalSent, Averaged::False);
		m.emplace_back("Received", totalReceived, Averaged::False);
		m.emplace_back("Acknknowledged", totalAcked, Averaged::False);
		m.emplace_back("Successes", totalSuccess, Averaged::False);
	}
};

} // namespace

WorkloadFactory<UDPWorkload> UDPWorkloadFactory;
