#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
/*
 * SpecialKeySpaceRobustness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "boost/lexical_cast.hpp"
#include "boost/algorithm/string.hpp"

#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/Schemas.h"
#include "fdbclient/SpecialKeySpace.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h"

struct SpecialKeySpaceRobustnessWorkload : TestWorkload {
	static constexpr auto NAME = "SpecialKeySpaceRobustness";

	SpecialKeySpaceRobustnessWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {}

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }
	Future<Void> start(Database const& cx) override { return _start(cx, this); }
	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}

	Future<Void> _setup(Database cx, SpecialKeySpaceRobustnessWorkload* self) { return Void(); }

																#line 45 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 43 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
template <class _startActor>
															#line 43 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
class _startActorState {
															#line 51 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
public:
															#line 43 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	_startActorState(Database const& cx,SpecialKeySpaceRobustnessWorkload* const& self) 
															#line 43 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
															#line 43 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		 : cx(cx),
															#line 43 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		   self(self)
															#line 60 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 45 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (self->clientId == 0)
															#line 75 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			{
															#line 46 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->managementApiCorrectnessActor(cx, self);
															#line 46 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 81 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 46 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 86 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 47 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 114 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 43 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	Database cx;
															#line 43 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	SpecialKeySpaceRobustnessWorkload* self;
															#line 213 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 43 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 218 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17331122980236662272UL, 4386018484933080320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 43 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	_startActor(Database const& cx,SpecialKeySpaceRobustnessWorkload* const& self) 
															#line 235 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 43 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, SpecialKeySpaceRobustnessWorkload* const& self ) {
															#line 43 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 267 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
}

#line 49 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"

	bool getRangeResultInOrder(const RangeResult& result) {
		for (int i = 0; i < result.size() - 1; ++i) {
			if (result[i].key >= result[i + 1].key) {
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "GetRangeResultNotInOrder")
				    .detail("Index", i)
				    .detail("Key1", result[i].key)
				    .detail("Key2", result[i + 1].key);
				return false;
			}
		}
		return true;
	}

	// A test utility that exclude the worker with `workerAddress` using `command` and return the value of `versionKey`.
																#line 287 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
// This generated class is to be used only via runExcludeAndGetVersionKey()
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
template <class RunExcludeAndGetVersionKeyActor>
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
class RunExcludeAndGetVersionKeyActorState {
															#line 293 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
public:
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	RunExcludeAndGetVersionKeyActorState(Reference<ReadYourWritesTransaction> const& tx,std::string const& workerAddress,std::string const& command,KeyRef const& versionKey) 
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		 : tx(tx),
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		   workerAddress(workerAddress),
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		   command(command),
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		   versionKey(versionKey)
															#line 306 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
	{
		fdb_probe_actor_create("runExcludeAndGetVersionKey", reinterpret_cast<unsigned long>(this));

	}
	~RunExcludeAndGetVersionKeyActorState() 
	{
		fdb_probe_actor_destroy("runExcludeAndGetVersionKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 69 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->reset();
															#line 70 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 71 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 72 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->set(Key(workerAddress).withPrefix(SpecialKeySpace::getManagementApiCommandPrefix(command)), ValueRef());
															#line 73 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tx->commit();
															#line 73 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<RunExcludeAndGetVersionKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 331 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunExcludeAndGetVersionKeyActor*>(this)->actor_wait_state = 1;
															#line 73 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunExcludeAndGetVersionKeyActor, 0, Void >*>(static_cast<RunExcludeAndGetVersionKeyActor*>(this)));
															#line 336 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunExcludeAndGetVersionKeyActorState();
		static_cast<RunExcludeAndGetVersionKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 74 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 76 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tx->get(versionKey);
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<RunExcludeAndGetVersionKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 365 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunExcludeAndGetVersionKeyActor*>(this)->actor_wait_state = 2;
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunExcludeAndGetVersionKeyActor, 1, Optional<Value> >*>(static_cast<RunExcludeAndGetVersionKeyActor*>(this)));
															#line 370 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 74 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 76 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tx->get(versionKey);
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<RunExcludeAndGetVersionKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 385 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunExcludeAndGetVersionKeyActor*>(this)->actor_wait_state = 2;
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunExcludeAndGetVersionKeyActor, 1, Optional<Value> >*>(static_cast<RunExcludeAndGetVersionKeyActor*>(this)));
															#line 390 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunExcludeAndGetVersionKeyActor*>(this)->actor_wait_state > 0) static_cast<RunExcludeAndGetVersionKeyActor*>(this)->actor_wait_state = 0;
		static_cast<RunExcludeAndGetVersionKeyActor*>(this)->ActorCallback< RunExcludeAndGetVersionKeyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunExcludeAndGetVersionKeyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runExcludeAndGetVersionKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunExcludeAndGetVersionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runExcludeAndGetVersionKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunExcludeAndGetVersionKeyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runExcludeAndGetVersionKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunExcludeAndGetVersionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runExcludeAndGetVersionKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunExcludeAndGetVersionKeyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runExcludeAndGetVersionKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunExcludeAndGetVersionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runExcludeAndGetVersionKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<Value> const& versionKeyValue,int loopDepth) 
	{
															#line 78 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 79 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (!static_cast<RunExcludeAndGetVersionKeyActor*>(this)->SAV<Optional<Value>>::futures) { (void)(versionKeyValue); this->~RunExcludeAndGetVersionKeyActorState(); static_cast<RunExcludeAndGetVersionKeyActor*>(this)->destroy(); return 0; }
															#line 476 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		new (&static_cast<RunExcludeAndGetVersionKeyActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(versionKeyValue);
		this->~RunExcludeAndGetVersionKeyActorState();
		static_cast<RunExcludeAndGetVersionKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && versionKeyValue,int loopDepth) 
	{
															#line 78 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 79 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (!static_cast<RunExcludeAndGetVersionKeyActor*>(this)->SAV<Optional<Value>>::futures) { (void)(versionKeyValue); this->~RunExcludeAndGetVersionKeyActorState(); static_cast<RunExcludeAndGetVersionKeyActor*>(this)->destroy(); return 0; }
															#line 490 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		new (&static_cast<RunExcludeAndGetVersionKeyActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(versionKeyValue);
		this->~RunExcludeAndGetVersionKeyActorState();
		static_cast<RunExcludeAndGetVersionKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& versionKeyValue,int loopDepth) 
	{
		loopDepth = a_body1cont2(versionKeyValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && versionKeyValue,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(versionKeyValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunExcludeAndGetVersionKeyActor*>(this)->actor_wait_state > 0) static_cast<RunExcludeAndGetVersionKeyActor*>(this)->actor_wait_state = 0;
		static_cast<RunExcludeAndGetVersionKeyActor*>(this)->ActorCallback< RunExcludeAndGetVersionKeyActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< RunExcludeAndGetVersionKeyActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("runExcludeAndGetVersionKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunExcludeAndGetVersionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runExcludeAndGetVersionKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunExcludeAndGetVersionKeyActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("runExcludeAndGetVersionKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunExcludeAndGetVersionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runExcludeAndGetVersionKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunExcludeAndGetVersionKeyActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("runExcludeAndGetVersionKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunExcludeAndGetVersionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runExcludeAndGetVersionKey", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	Reference<ReadYourWritesTransaction> tx;
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	std::string workerAddress;
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	std::string command;
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	KeyRef versionKey;
															#line 581 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
};
// This generated class is to be used only via runExcludeAndGetVersionKey()
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
class RunExcludeAndGetVersionKeyActor final : public Actor<Optional<Value>>, public ActorCallback< RunExcludeAndGetVersionKeyActor, 0, Void >, public ActorCallback< RunExcludeAndGetVersionKeyActor, 1, Optional<Value> >, public FastAllocated<RunExcludeAndGetVersionKeyActor>, public RunExcludeAndGetVersionKeyActorState<RunExcludeAndGetVersionKeyActor> {
															#line 586 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
public:
	using FastAllocated<RunExcludeAndGetVersionKeyActor>::operator new;
	using FastAllocated<RunExcludeAndGetVersionKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17547514697611844608UL, 7117340243442831104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunExcludeAndGetVersionKeyActor, 0, Void >;
friend struct ActorCallback< RunExcludeAndGetVersionKeyActor, 1, Optional<Value> >;
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	RunExcludeAndGetVersionKeyActor(Reference<ReadYourWritesTransaction> const& tx,std::string const& workerAddress,std::string const& command,KeyRef const& versionKey) 
															#line 604 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		 : Actor<Optional<Value>>(),
		   RunExcludeAndGetVersionKeyActorState<RunExcludeAndGetVersionKeyActor>(tx, workerAddress, command, versionKey),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runExcludeAndGetVersionKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3291173217409180672UL, 5495864534338448896UL);
		ActorExecutionContextHelper __helper(static_cast<RunExcludeAndGetVersionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runExcludeAndGetVersionKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runExcludeAndGetVersionKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunExcludeAndGetVersionKeyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunExcludeAndGetVersionKeyActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
[[nodiscard]] static Future<Optional<Value>> runExcludeAndGetVersionKey( Reference<ReadYourWritesTransaction> const& tx, std::string const& workerAddress, std::string const& command, KeyRef const& versionKey ) {
															#line 65 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	return Future<Optional<Value>>(new RunExcludeAndGetVersionKeyActor(tx, workerAddress, command, versionKey));
															#line 637 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
}

#line 81 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"

																#line 642 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
// This generated class is to be used only via managementApiCorrectnessActor()
															#line 82 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
template <class ManagementApiCorrectnessActorActor>
															#line 82 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
class ManagementApiCorrectnessActorActorState {
															#line 648 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
public:
															#line 82 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	ManagementApiCorrectnessActorActorState(Database const& cx,SpecialKeySpaceRobustnessWorkload* const& self) 
															#line 82 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
															#line 82 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		 : cx(cx),
															#line 82 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		   self(self),
															#line 84 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		   tx(makeReference<ReadYourWritesTransaction>(cx))
															#line 659 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
	{
		fdb_probe_actor_create("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this));

	}
	~ManagementApiCorrectnessActorActorState() 
	{
		fdb_probe_actor_destroy("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 87 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 88 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 89 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				for( const std::string& option : SpecialKeySpace::getManagementApiOptionsSet() ) {
															#line 90 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					tx->set( "options/"_sr.withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin) .withSuffix(option), ValueRef());
															#line 681 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				}
															#line 95 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = tx->getRange( KeyRangeRef("options/"_sr, "options0"_sr) .withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin), CLIENT_KNOBS->TOO_MANY);
															#line 95 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 687 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 1;
															#line 95 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 0, RangeResult >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 692 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ManagementApiCorrectnessActorActorState();
		static_cast<ManagementApiCorrectnessActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		try {
															#line 106 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 107 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 108 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->set("Invalid_Network_Address"_sr.withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("exclude")), ValueRef());
															#line 110 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tx->commit();
															#line 110 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 725 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 2;
															#line 110 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 1, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 730 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(RangeResult const& result,int loopDepth) 
	{
															#line 99 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(!result.more && result.size() < CLIENT_KNOBS->TOO_MANY);
															#line 100 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(result.size() == SpecialKeySpace::getManagementApiOptionsSet().size());
															#line 101 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(self->getRangeResultInOrder(result));
															#line 102 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 751 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(RangeResult && result,int loopDepth) 
	{
															#line 99 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(!result.more && result.size() < CLIENT_KNOBS->TOO_MANY);
															#line 100 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(result.size() == SpecialKeySpace::getManagementApiOptionsSet().size());
															#line 101 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(self->getRangeResultInOrder(result));
															#line 102 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 766 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		{
			try {
															#line 134 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				excludeWorker = std::string();
															#line 135 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				excludeCommand = std::string();
															#line 136 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				failedCommand = std::string();
															#line 137 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				excludeVersionKey = KeyRef();
															#line 138 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				failedVersionKey = KeyRef();
															#line 141 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (deterministicRandom()->coinflip())
															#line 862 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				{
															#line 142 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					excludeWorker = "123.4.56.7:9876";
															#line 143 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					excludeCommand = "exclude";
															#line 144 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					failedCommand = "failed";
															#line 145 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					excludeVersionKey = excludedServersVersionKey;
															#line 146 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					failedVersionKey = failedServersVersionKey;
															#line 874 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				}
				else
				{
															#line 148 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					excludeWorker = "locality_zoneid:12345";
															#line 149 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					excludeCommand = "excludedlocality";
															#line 150 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					failedCommand = "failedlocality";
															#line 151 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					excludeVersionKey = excludedLocalityVersionKey;
															#line 152 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					failedVersionKey = failedLocalityVersionKey;
															#line 888 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				}
															#line 155 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				TraceEvent(SevDebug, "ManagementAPITestExclude") .detail("ExcludeWorker", excludeWorker) .detail("ExcludeCommand", excludeCommand) .detail("ExcludeFailedCommand", failedCommand);
															#line 160 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 161 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_4 = tx->get(excludeVersionKey);
															#line 161 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont5Catch1(actor_cancelled(), loopDepth);
															#line 898 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont5Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 5;
															#line 161 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 4, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 903 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont5Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont5Catch1(unknown_error(), loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 113 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 920 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			{
															#line 114 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 924 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			}
															#line 115 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 928 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			{
															#line 116 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_2 = tx->get(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::ERRORMSG).begin);
															#line 116 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 934 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 3;
															#line 116 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 2, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 939 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 126 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				TraceEvent(SevDebug, "UnexpectedError").error(e).detail("Command", "Exclude");
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<Void> __when_expr_3 = tx->onError(e);
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 950 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1Catch1when2(__when_expr_3.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 4;
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 955 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 111 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(false);
															#line 971 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 111 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(false);
															#line 980 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1cont1(int loopDepth) 
	{
															#line 129 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 1077 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1cont3(Optional<Value> const& errorMsg,int loopDepth) 
	{
															#line 118 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 119 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		std::string errorStr;
															#line 120 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 121 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 123 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 124 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "exclude" && !valueObj["retriable"].get_bool());
															#line 1096 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1cont3(Optional<Value> && errorMsg,int loopDepth) 
	{
															#line 118 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 119 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		std::string errorStr;
															#line 120 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 121 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 123 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 124 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "exclude" && !valueObj["retriable"].get_bool());
															#line 1115 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1when1(Optional<Value> const& errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont1Catch1cont3(errorMsg, loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1when1(Optional<Value> && errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont1Catch1cont3(std::move(errorMsg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1Catch1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1Catch1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1Catch1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont9(int loopDepth) 
	{
		{
			try {
															#line 215 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 216 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 218 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<RangeResult> __when_expr_12 = tx->getRange( KeyRangeRef("process/class_type/"_sr, "process/class_type0"_sr) .withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::CONFIGURATION).begin), CLIENT_KNOBS->TOO_MANY);
															#line 218 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont9Catch1(actor_cancelled(), loopDepth);
															#line 1294 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont9Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont9when1(__when_expr_12.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 13;
															#line 218 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 12, RangeResult >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 1299 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont9Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont9Catch1(unknown_error(), loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 188 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1322 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			{
															#line 189 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1326 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			}
															#line 190 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 1330 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			{
															#line 191 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_10 = tx->get(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::ERRORMSG).begin);
															#line 191 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1336 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont5Catch1when1(__when_expr_10.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 11;
															#line 191 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 10, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 1341 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 203 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				TraceEvent(SevDebug, "UnexpectedError") .error(e) .detail("Command", "Exclude") .detail("Test", "Repeated exclusions");
															#line 207 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<Void> __when_expr_11 = tx->onError(e);
															#line 207 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1352 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont5Catch1when2(__when_expr_11.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 12;
															#line 207 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 1357 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
															#line 163 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = runExcludeAndGetVersionKey(tx, excludeWorker, excludeCommand, excludeVersionKey);
															#line 163 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont5Catch1(actor_cancelled(), loopDepth);
															#line 1375 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont5Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont11when1(__when_expr_5.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 6;
															#line 163 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 5, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 1380 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Optional<Value> const& __versionKey0,int loopDepth) 
	{
															#line 161 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		versionKey0 = __versionKey0;
															#line 1389 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Optional<Value> && __versionKey0,int loopDepth) 
	{
		versionKey0 = std::move(__versionKey0);
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 4, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11cont1(int loopDepth) 
	{
															#line 165 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(versionKey1.present());
															#line 166 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(versionKey0 != versionKey1);
															#line 167 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_6 = runExcludeAndGetVersionKey(tx, excludeWorker, excludeCommand, excludeVersionKey);
															#line 167 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont5Catch1(actor_cancelled(), loopDepth);
															#line 1474 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont5Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 7;
															#line 167 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 1479 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11when1(Optional<Value> const& __versionKey1,int loopDepth) 
	{
															#line 163 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		versionKey1 = __versionKey1;
															#line 1488 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Optional<Value> && __versionKey1,int loopDepth) 
	{
		versionKey1 = std::move(__versionKey1);
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 5, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 5, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 5, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 5, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont11cont2(Optional<Value> const& versionKey2,int loopDepth) 
	{
															#line 169 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(versionKey2.present());
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(versionKey1 == versionKey2);
															#line 173 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 174 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_7 = tx->get(failedVersionKey);
															#line 174 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont5Catch1(actor_cancelled(), loopDepth);
															#line 1575 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont5Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_7.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 8;
															#line 174 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 7, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 1580 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont2(Optional<Value> && versionKey2,int loopDepth) 
	{
															#line 169 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(versionKey2.present());
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(versionKey1 == versionKey2);
															#line 173 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 174 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_7 = tx->get(failedVersionKey);
															#line 174 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont5Catch1(actor_cancelled(), loopDepth);
															#line 1597 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont5Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_7.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 8;
															#line 174 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 7, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 1602 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1when1(Optional<Value> const& versionKey2,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(versionKey2, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Optional<Value> && versionKey2,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(std::move(versionKey2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont11cont3(int loopDepth) 
	{
															#line 176 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_8 = runExcludeAndGetVersionKey(tx, excludeWorker, failedCommand, failedVersionKey);
															#line 176 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont5Catch1(actor_cancelled(), loopDepth);
															#line 1688 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont5Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont11cont3when1(__when_expr_8.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 9;
															#line 176 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 8, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 1693 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont2when1(Optional<Value> const& __versionKey3,int loopDepth) 
	{
															#line 174 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		versionKey3 = __versionKey3;
															#line 1702 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont11cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2when1(Optional<Value> && __versionKey3,int loopDepth) 
	{
		versionKey3 = std::move(__versionKey3);
		loopDepth = a_body1cont11cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 7, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 7, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 7, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 7, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont11cont4(int loopDepth) 
	{
															#line 178 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(versionKey4.present());
															#line 179 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(versionKey3 != versionKey4);
															#line 180 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_9 = runExcludeAndGetVersionKey(tx, excludeWorker, failedCommand, failedVersionKey);
															#line 180 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont5Catch1(actor_cancelled(), loopDepth);
															#line 1787 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont5Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont4when1(__when_expr_9.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 10;
															#line 180 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 1792 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont3when1(Optional<Value> const& __versionKey4,int loopDepth) 
	{
															#line 176 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		versionKey4 = __versionKey4;
															#line 1801 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont3when1(Optional<Value> && __versionKey4,int loopDepth) 
	{
		versionKey4 = std::move(__versionKey4);
		loopDepth = a_body1cont11cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 8, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 8, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 8, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 8, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont11cont5(Optional<Value> const& versionKey5,int loopDepth) 
	{
															#line 182 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(versionKey5.present());
															#line 184 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(versionKey4 == versionKey5);
															#line 186 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 1884 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont11cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont5(Optional<Value> && versionKey5,int loopDepth) 
	{
															#line 182 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(versionKey5.present());
															#line 184 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(versionKey4 == versionKey5);
															#line 186 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 1897 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont11cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4when1(Optional<Value> const& versionKey5,int loopDepth) 
	{
		loopDepth = a_body1cont11cont5(versionKey5, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4when1(Optional<Value> && versionKey5,int loopDepth) 
	{
		loopDepth = a_body1cont11cont5(std::move(versionKey5), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont11cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5Catch1cont1(int loopDepth) 
	{
															#line 209 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 1994 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont5Catch1cont3(Optional<Value> const& errorMsg,int loopDepth) 
	{
															#line 193 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 194 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		std::string errorStr;
															#line 195 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 196 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 198 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 199 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT((valueObj["command"].get_str() == "exclude" || valueObj["command"].get_str() == "exclude failed") && !valueObj["retriable"].get_bool());
															#line 2013 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont5Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5Catch1cont3(Optional<Value> && errorMsg,int loopDepth) 
	{
															#line 193 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 194 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		std::string errorStr;
															#line 195 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 196 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 198 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 199 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT((valueObj["command"].get_str() == "exclude" || valueObj["command"].get_str() == "exclude failed") && !valueObj["retriable"].get_bool());
															#line 2032 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont5Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5Catch1when1(Optional<Value> const& errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont5Catch1cont3(errorMsg, loopDepth);

		return loopDepth;
	}
	int a_body1cont5Catch1when1(Optional<Value> && errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont5Catch1cont3(std::move(errorMsg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 10, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 10, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont5Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 10, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont5Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 10, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont5Catch1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5Catch1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5Catch1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5Catch1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont5Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont5Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont14(int loopDepth) 
	{
		{
			try {
															#line 287 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 288 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<RangeResult> __when_expr_19 = tx->getRange( KeyRangeRef("process/class_source/"_sr, "process/class_source0"_sr) .withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::CONFIGURATION).begin), CLIENT_KNOBS->TOO_MANY);
															#line 288 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14Catch1(actor_cancelled(), loopDepth);
															#line 2209 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1cont14Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont14when1(__when_expr_19.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 20;
															#line 288 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 19, RangeResult >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 2214 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont14Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont14Catch1(unknown_error(), loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont15(int loopDepth) 
	{
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont9Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 264 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2237 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			{
															#line 265 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2241 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			}
															#line 266 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 2245 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			{
															#line 267 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_17 = tx->get(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::ERRORMSG).begin);
															#line 267 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2251 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont9Catch1when1(__when_expr_17.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 18;
															#line 267 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 17, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 2256 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 277 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				TraceEvent(SevDebug, "UnexpectedError").error(e).detail("Command", "Setclass");
															#line 278 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<Void> __when_expr_18 = tx->onError(e);
															#line 278 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2267 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont9Catch1when2(__when_expr_18.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 19;
															#line 278 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 18, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 2272 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16(int loopDepth) 
	{
															#line 222 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(!result.more && result.size() < CLIENT_KNOBS->TOO_MANY);
															#line 223 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(self->getRangeResultInOrder(result));
															#line 225 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<std::vector<ProcessData>> __when_expr_13 = getWorkers(&tx->getTransaction());
															#line 225 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont9Catch1(actor_cancelled(), loopDepth);
															#line 2294 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont9Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont16when1(__when_expr_13.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 14;
															#line 225 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 13, std::vector<ProcessData> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 2299 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(RangeResult const& __result,int loopDepth) 
	{
															#line 218 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		result = __result;
															#line 2308 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(RangeResult && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1cont16(loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 12, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 12, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 12, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 12, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont16cont1(std::vector<ProcessData> const& workers,int loopDepth) 
	{
															#line 226 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (workers.size())
															#line 2387 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		{
															#line 227 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			for( const auto& worker : workers ) {
															#line 228 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				Key addr = Key("process/class_type/" + formatIpPort(worker.address.ip, worker.address.port)) .withPrefix( SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::CONFIGURATION).begin);
															#line 232 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				bool found = false;
															#line 233 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				for( const auto& kv : result ) {
															#line 234 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					if (kv.key == addr)
															#line 2399 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
					{
															#line 235 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
						ASSERT(kv.value.toString() == worker.processClass.toString());
															#line 236 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
						found = true;
															#line 2405 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
						break;
					}
				}
															#line 241 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				ASSERT(found);
															#line 2411 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			}
															#line 243 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			worker = deterministicRandom()->randomChoice(workers);
															#line 244 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			addr = Key("process/class_type/" + formatIpPort(worker.address.ip, worker.address.port)) .withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::CONFIGURATION).begin);
															#line 247 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->set(addr, "InvalidProcessType"_sr);
															#line 249 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_14 = tx->get(addr);
															#line 249 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont9Catch1(actor_cancelled(), loopDepth);
															#line 2423 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont9Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont16cont1when1(__when_expr_14.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 15;
															#line 249 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 2428 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 261 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			TraceEvent(SevDebug, "EmptyWorkerListInSetClassTest").log();
															#line 2435 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = a_body1cont16cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16cont1(std::vector<ProcessData> && workers,int loopDepth) 
	{
															#line 226 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (workers.size())
															#line 2445 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		{
															#line 227 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			for( const auto& worker : workers ) {
															#line 228 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				Key addr = Key("process/class_type/" + formatIpPort(worker.address.ip, worker.address.port)) .withPrefix( SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::CONFIGURATION).begin);
															#line 232 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				bool found = false;
															#line 233 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				for( const auto& kv : result ) {
															#line 234 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					if (kv.key == addr)
															#line 2457 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
					{
															#line 235 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
						ASSERT(kv.value.toString() == worker.processClass.toString());
															#line 236 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
						found = true;
															#line 2463 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
						break;
					}
				}
															#line 241 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				ASSERT(found);
															#line 2469 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			}
															#line 243 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			worker = deterministicRandom()->randomChoice(workers);
															#line 244 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			addr = Key("process/class_type/" + formatIpPort(worker.address.ip, worker.address.port)) .withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::CONFIGURATION).begin);
															#line 247 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->set(addr, "InvalidProcessType"_sr);
															#line 249 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_14 = tx->get(addr);
															#line 249 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont9Catch1(actor_cancelled(), loopDepth);
															#line 2481 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont9Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont16cont1when1(__when_expr_14.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 15;
															#line 249 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 2486 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 261 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			TraceEvent(SevDebug, "EmptyWorkerListInSetClassTest").log();
															#line 2493 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = a_body1cont16cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16when1(std::vector<ProcessData> const& workers,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(workers, loopDepth);

		return loopDepth;
	}
	int a_body1cont16when1(std::vector<ProcessData> && workers,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 13, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 13, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont16when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 13, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont16when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 13, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont16cont2(int loopDepth) 
	{
		loopDepth = a_body1cont16cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont3(Optional<Value> const& processType,int loopDepth) 
	{
															#line 250 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(processType.present() && processType.get() == "InvalidProcessType"_sr);
															#line 252 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 253 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_15 = tx->get(addr);
															#line 253 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont9Catch1(actor_cancelled(), loopDepth);
															#line 2590 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont9Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont16cont3when1(__when_expr_15.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 16;
															#line 253 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 15, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 2595 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16cont3(Optional<Value> && processType,int loopDepth) 
	{
															#line 250 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(processType.present() && processType.get() == "InvalidProcessType"_sr);
															#line 252 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 253 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_15 = tx->get(addr);
															#line 253 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont9Catch1(actor_cancelled(), loopDepth);
															#line 2610 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont9Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont16cont3when1(__when_expr_15.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 16;
															#line 253 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 15, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 2615 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16cont1when1(Optional<Value> const& processType,int loopDepth) 
	{
		loopDepth = a_body1cont16cont3(processType, loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont1when1(Optional<Value> && processType,int loopDepth) 
	{
		loopDepth = a_body1cont16cont3(std::move(processType), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont16cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont16cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont16cont7(Optional<Value> const& originalProcessType,int loopDepth) 
	{
															#line 254 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(originalProcessType.present() && originalProcessType.get() == worker.processClass.toString());
															#line 257 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Void> __when_expr_16 = tx->commit();
															#line 257 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont9Catch1(actor_cancelled(), loopDepth);
															#line 2703 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont9Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont16cont7when1(__when_expr_16.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 17;
															#line 257 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 2708 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16cont7(Optional<Value> && originalProcessType,int loopDepth) 
	{
															#line 254 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(originalProcessType.present() && originalProcessType.get() == worker.processClass.toString());
															#line 257 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Void> __when_expr_16 = tx->commit();
															#line 257 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont9Catch1(actor_cancelled(), loopDepth);
															#line 2721 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont9Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont16cont7when1(__when_expr_16.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 17;
															#line 257 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 2726 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16cont3when1(Optional<Value> const& originalProcessType,int loopDepth) 
	{
		loopDepth = a_body1cont16cont7(originalProcessType, loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont3when1(Optional<Value> && originalProcessType,int loopDepth) 
	{
		loopDepth = a_body1cont16cont7(std::move(originalProcessType), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 15, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 15, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont16cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 15, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont16cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 15, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont16cont8(Void const& _,int loopDepth) 
	{
															#line 258 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(false);
															#line 2810 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont16cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont8(Void && _,int loopDepth) 
	{
															#line 258 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(false);
															#line 2819 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont16cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont16cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont16cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont16cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9Catch1cont1(int loopDepth) 
	{
															#line 280 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 2916 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont9Catch1cont3(Optional<Value> const& errorMsg,int loopDepth) 
	{
															#line 269 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 270 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		std::string errorStr;
															#line 271 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 272 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 274 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 275 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "setclass" && !valueObj["retriable"].get_bool());
															#line 2935 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont9Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9Catch1cont3(Optional<Value> && errorMsg,int loopDepth) 
	{
															#line 269 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 270 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		std::string errorStr;
															#line 271 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 272 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 274 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 275 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "setclass" && !valueObj["retriable"].get_bool());
															#line 2954 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont9Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9Catch1when1(Optional<Value> const& errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont9Catch1cont3(errorMsg, loopDepth);

		return loopDepth;
	}
	int a_body1cont9Catch1when1(Optional<Value> && errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont9Catch1cont3(std::move(errorMsg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 17, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 17, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont9Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 17, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont9Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 17, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont9Catch1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9Catch1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9Catch1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9Catch1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 18, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 18, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont9Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 18, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont9Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 18, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont14cont1(int loopDepth) 
	{
															#line 367 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		;
															#line 3125 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont2(int loopDepth) 
	{
		loopDepth = a_body1cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 362 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Void> __when_expr_24 = tx->onError(e);
															#line 362 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3143 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1Catch1(__when_expr_24.getError(), loopDepth); else return a_body1cont14Catch1when1(__when_expr_24.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 25;
															#line 362 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_24.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 3148 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont3(int loopDepth) 
	{
															#line 292 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(!class_source_result.more && class_source_result.size() < CLIENT_KNOBS->TOO_MANY);
															#line 293 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(self->getRangeResultInOrder(class_source_result));
															#line 295 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<std::vector<ProcessData>> __when_expr_20 = getWorkers(&tx->getTransaction());
															#line 295 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14Catch1(actor_cancelled(), loopDepth);
															#line 3169 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1cont14Catch1(__when_expr_20.getError(), loopDepth); else return a_body1cont14cont3when1(__when_expr_20.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 21;
															#line 295 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 20, std::vector<ProcessData> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 3174 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14when1(RangeResult const& __class_source_result,int loopDepth) 
	{
															#line 288 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		class_source_result = __class_source_result;
															#line 3183 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont14when1(RangeResult && __class_source_result,int loopDepth) 
	{
		class_source_result = std::move(__class_source_result);
		loopDepth = a_body1cont14cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 19, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 19, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont14when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14Catch1(error, 0);
		} catch (...) {
			a_body1cont14Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 19, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont14when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14Catch1(error, 0);
		} catch (...) {
			a_body1cont14Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 19, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont14Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14Catch1(error, 0);
		} catch (...) {
			a_body1cont14Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont14cont4(std::vector<ProcessData> const& workers,int loopDepth) 
	{
															#line 296 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (workers.size())
															#line 3262 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		{
															#line 297 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			for( const auto& worker : workers ) {
															#line 298 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				Key addr = Key("process/class_source/" + formatIpPort(worker.address.ip, worker.address.port)) .withPrefix( SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::CONFIGURATION).begin);
															#line 302 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				bool found = false;
															#line 303 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				for( const auto& kv : class_source_result ) {
															#line 304 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					if (kv.key == addr)
															#line 3274 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
					{
															#line 305 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
						ASSERT(kv.value.toString() == worker.processClass.sourceString());
															#line 307 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
						ASSERT(kv.value == "command_line"_sr);
															#line 308 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
						found = true;
															#line 3282 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
						break;
					}
				}
															#line 313 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				ASSERT(found);
															#line 3288 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			}
															#line 315 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			ProcessData worker = deterministicRandom()->randomChoice(workers);
															#line 316 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			address = formatIpPort(worker.address.ip, worker.address.port);
															#line 317 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 318 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->set( Key("process/class_type/" + address) .withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::CONFIGURATION).begin), Value(worker.processClass.toString()));
															#line 323 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Void> __when_expr_21 = tx->commit();
															#line 323 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14Catch1(actor_cancelled(), loopDepth);
															#line 3302 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1cont14Catch1(__when_expr_21.getError(), loopDepth); else return a_body1cont14cont4when1(__when_expr_21.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 22;
															#line 323 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 21, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 3307 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 359 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			TraceEvent(SevDebug, "EmptyWorkerListInSetClassTest").log();
															#line 3314 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = a_body1cont14cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont4(std::vector<ProcessData> && workers,int loopDepth) 
	{
															#line 296 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (workers.size())
															#line 3324 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		{
															#line 297 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			for( const auto& worker : workers ) {
															#line 298 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				Key addr = Key("process/class_source/" + formatIpPort(worker.address.ip, worker.address.port)) .withPrefix( SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::CONFIGURATION).begin);
															#line 302 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				bool found = false;
															#line 303 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				for( const auto& kv : class_source_result ) {
															#line 304 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					if (kv.key == addr)
															#line 3336 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
					{
															#line 305 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
						ASSERT(kv.value.toString() == worker.processClass.sourceString());
															#line 307 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
						ASSERT(kv.value == "command_line"_sr);
															#line 308 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
						found = true;
															#line 3344 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
						break;
					}
				}
															#line 313 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				ASSERT(found);
															#line 3350 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			}
															#line 315 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			ProcessData worker = deterministicRandom()->randomChoice(workers);
															#line 316 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			address = formatIpPort(worker.address.ip, worker.address.port);
															#line 317 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 318 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->set( Key("process/class_type/" + address) .withPrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::CONFIGURATION).begin), Value(worker.processClass.toString()));
															#line 323 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Void> __when_expr_21 = tx->commit();
															#line 323 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14Catch1(actor_cancelled(), loopDepth);
															#line 3364 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1cont14Catch1(__when_expr_21.getError(), loopDepth); else return a_body1cont14cont4when1(__when_expr_21.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 22;
															#line 323 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 21, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 3369 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 359 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			TraceEvent(SevDebug, "EmptyWorkerListInSetClassTest").log();
															#line 3376 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = a_body1cont14cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont3when1(std::vector<ProcessData> const& workers,int loopDepth) 
	{
		loopDepth = a_body1cont14cont4(workers, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont3when1(std::vector<ProcessData> && workers,int loopDepth) 
	{
		loopDepth = a_body1cont14cont4(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose21() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 20, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 20, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont14cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14Catch1(error, 0);
		} catch (...) {
			a_body1cont14Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 20, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont14cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14Catch1(error, 0);
		} catch (...) {
			a_body1cont14Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 20, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont14Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14Catch1(error, 0);
		} catch (...) {
			a_body1cont14Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);

	}
	int a_body1cont14cont5(int loopDepth) 
	{
		loopDepth = a_body1cont14cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6(Void const& _,int loopDepth) 
	{
															#line 324 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 325 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 326 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_22 = tx->get( Key("process/class_source/" + address) .withPrefix( SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::CONFIGURATION).begin));
															#line 326 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14Catch1(actor_cancelled(), loopDepth);
															#line 3473 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1cont14Catch1(__when_expr_22.getError(), loopDepth); else return a_body1cont14cont6when1(__when_expr_22.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 23;
															#line 326 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 22, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 3478 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont6(Void && _,int loopDepth) 
	{
															#line 324 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 325 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 326 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_22 = tx->get( Key("process/class_source/" + address) .withPrefix( SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::CONFIGURATION).begin));
															#line 326 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14Catch1(actor_cancelled(), loopDepth);
															#line 3493 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1cont14Catch1(__when_expr_22.getError(), loopDepth); else return a_body1cont14cont6when1(__when_expr_22.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 23;
															#line 326 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 22, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 3498 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose22() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 21, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 21, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont14cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14Catch1(error, 0);
		} catch (...) {
			a_body1cont14Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 21, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont14cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14Catch1(error, 0);
		} catch (...) {
			a_body1cont14Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 21, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont14Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14Catch1(error, 0);
		} catch (...) {
			a_body1cont14Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);

	}
	int a_body1cont14cont10(Optional<Value> const& class_source,int loopDepth) 
	{
															#line 330 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		TraceEvent(SevDebug, "SetClassSourceDebug") .detail("Address", address) .detail("Present", class_source.present()) .detail("ClassSource", class_source.present() ? class_source.get().toString() : "__Nothing");
															#line 335 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (class_source.present())
															#line 3584 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		{
															#line 336 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (class_source.get() == "command_line"_sr)
															#line 3588 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			{
															#line 339 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				_locality = LocalityData(worker.locality);
															#line 340 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<std::vector<ProcessData>> __when_expr_23 = getWorkers(&tx->getTransaction());
															#line 340 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14Catch1(actor_cancelled(), loopDepth);
															#line 3596 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1cont14Catch1(__when_expr_23.getError(), loopDepth); else return a_body1cont14cont10when1(__when_expr_23.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 24;
															#line 340 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 23, std::vector<ProcessData> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 3601 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 352 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				ASSERT(class_source.get() == "set_class"_sr);
															#line 3608 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = a_body1cont14cont10cont2(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont14cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont10(Optional<Value> && class_source,int loopDepth) 
	{
															#line 330 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		TraceEvent(SevDebug, "SetClassSourceDebug") .detail("Address", address) .detail("Present", class_source.present()) .detail("ClassSource", class_source.present() ? class_source.get().toString() : "__Nothing");
															#line 335 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (class_source.present())
															#line 3625 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		{
															#line 336 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (class_source.get() == "command_line"_sr)
															#line 3629 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			{
															#line 339 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				_locality = LocalityData(worker.locality);
															#line 340 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<std::vector<ProcessData>> __when_expr_23 = getWorkers(&tx->getTransaction());
															#line 340 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14Catch1(actor_cancelled(), loopDepth);
															#line 3637 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1cont14Catch1(__when_expr_23.getError(), loopDepth); else return a_body1cont14cont10when1(__when_expr_23.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 24;
															#line 340 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 23, std::vector<ProcessData> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 3642 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 352 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				ASSERT(class_source.get() == "set_class"_sr);
															#line 3649 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = a_body1cont14cont10cont2(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont14cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont6when1(Optional<Value> const& class_source,int loopDepth) 
	{
		loopDepth = a_body1cont14cont10(class_source, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont6when1(Optional<Value> && class_source,int loopDepth) 
	{
		loopDepth = a_body1cont14cont10(std::move(class_source), loopDepth);

		return loopDepth;
	}
	void a_exitChoose23() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 22, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 22, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont14cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14Catch1(error, 0);
		} catch (...) {
			a_body1cont14Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 22, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont14cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14Catch1(error, 0);
		} catch (...) {
			a_body1cont14Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 22, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont14Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14Catch1(error, 0);
		} catch (...) {
			a_body1cont14Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);

	}
	int a_body1cont14cont10cont1(int loopDepth) 
	{
															#line 356 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 3739 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont10cont2(int loopDepth) 
	{
		loopDepth = a_body1cont14cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont10cont3(std::vector<ProcessData> const& _workers,int loopDepth) 
	{
															#line 341 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		bool found = false;
															#line 342 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		for( const auto& w : _workers ) {
															#line 343 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			auto w_addr = formatIpPort(w.address.ip, w.address.port);
															#line 344 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (w_addr == address)
															#line 3760 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			{
															#line 345 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				ASSERT(w.locality.describeProcessId() != _locality.describeProcessId());
															#line 346 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				found = true;
															#line 3766 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				break;
			}
		}
															#line 350 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(found);
															#line 3772 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont10cont3(std::vector<ProcessData> && _workers,int loopDepth) 
	{
															#line 341 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		bool found = false;
															#line 342 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		for( const auto& w : _workers ) {
															#line 343 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			auto w_addr = formatIpPort(w.address.ip, w.address.port);
															#line 344 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (w_addr == address)
															#line 3787 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			{
															#line 345 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				ASSERT(w.locality.describeProcessId() != _locality.describeProcessId());
															#line 346 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				found = true;
															#line 3793 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				break;
			}
		}
															#line 350 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(found);
															#line 3799 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont10when1(std::vector<ProcessData> const& _workers,int loopDepth) 
	{
		loopDepth = a_body1cont14cont10cont3(_workers, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont10when1(std::vector<ProcessData> && _workers,int loopDepth) 
	{
		loopDepth = a_body1cont14cont10cont3(std::move(_workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose24() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 23, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 23, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont14cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14Catch1(error, 0);
		} catch (...) {
			a_body1cont14Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 23, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont14cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14Catch1(error, 0);
		} catch (...) {
			a_body1cont14Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 23, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont14Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14Catch1(error, 0);
		} catch (...) {
			a_body1cont14Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);

	}
	int a_body1cont14cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont14cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont14Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont14Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose25() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont14Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont14Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);

	}
	int a_body1cont14cont13(int loopDepth) 
	{
															#line 401 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		TraceEvent(SevDebug, "DatabaseLocked").log();
															#line 403 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 404 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		;
															#line 3987 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont13loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont14cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont1loopBody1(int loopDepth) 
	{
		try {
															#line 369 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 370 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 372 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			UID uid = deterministicRandom()->randomUniqueID();
															#line 373 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->set(SpecialKeySpace::getManagementApiCommandPrefix("lock"), uid.toString());
															#line 375 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Void> __when_expr_25 = tx->commit();
															#line 375 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4014 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1cont14cont1loopBody1Catch1(__when_expr_25.getError(), loopDepth); else return a_body1cont14cont1loopBody1when1(__when_expr_25.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 26;
															#line 375 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 4019 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont14cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont14cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont14cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont14cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont14cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 378 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			TraceEvent(SevDebug, "DatabaseLockFailure").error(e);
															#line 381 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 4056 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			{
															#line 382 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_26 = tx->get(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::ERRORMSG).begin);
															#line 382 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4062 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1Catch1(__when_expr_26.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont1loopBody1Catch1when1(__when_expr_26.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 27;
															#line 382 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_26.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 4067 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 392 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (e.code() == error_code_database_locked)
															#line 4074 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				{
					return a_body1cont14cont1break1(loopDepth==0?0:loopDepth-1); // break
				}
				else
				{
															#line 397 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					StrictFuture<Void> __when_expr_27 = tx->onError(e);
															#line 397 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4084 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
					if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1Catch1(__when_expr_27.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont1loopBody1Catch1when2(__when_expr_27.get(), loopDepth); };
					static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 28;
															#line 397 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
					__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 4089 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
					loopDepth = 0;
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont14cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont14cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont14cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont14cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont14cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose26() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont14cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont14cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont14cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);

	}
	int a_body1cont14cont1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont14cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont1loopBody1Catch1cont2(Optional<Value> const& errorMsg,int loopDepth) 
	{
															#line 384 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 385 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		std::string errorStr;
															#line 386 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 387 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 389 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 390 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "lock" && !valueObj["retriable"].get_bool());
															#line 4209 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		return a_body1cont14cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont14cont1loopBody1Catch1cont2(Optional<Value> && errorMsg,int loopDepth) 
	{
															#line 384 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 385 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		std::string errorStr;
															#line 386 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 387 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 389 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 390 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "lock" && !valueObj["retriable"].get_bool());
															#line 4228 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		return a_body1cont14cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont14cont1loopBody1Catch1when1(Optional<Value> const& errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1loopBody1Catch1cont2(errorMsg, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont1loopBody1Catch1when1(Optional<Value> && errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1loopBody1Catch1cont2(std::move(errorMsg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose27() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont14cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont14cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);

	}
	int a_body1cont14cont1loopBody1Catch1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont14cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont1loopBody1Catch1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1loopBody1Catch1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont1loopBody1Catch1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1loopBody1Catch1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1loopBody1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1loopBody1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose28() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont14cont1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont14cont1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);

	}
	int a_body1cont14cont13cont1(int loopDepth) 
	{
															#line 422 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 423 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		;
															#line 4407 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont13cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont14cont13loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13loopBody1(int loopDepth) 
	{
		try {
															#line 406 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 407 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_28 = tx->getRange(normalKeys, 1);
															#line 407 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4428 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1cont14cont13loopBody1Catch1(__when_expr_28.getError(), loopDepth); else return a_body1cont14cont13loopBody1when1(__when_expr_28.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 29;
															#line 407 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 28, RangeResult >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 4433 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont14cont13loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont14cont13loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13break1(int loopDepth) 
	{
		try {
			return a_body1cont14cont13cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont14cont13loopHead1(0);

		return loopDepth;
	}
	int a_body1cont14cont13loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 409 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 4468 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			{
															#line 410 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 4472 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			}
															#line 411 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (e.code() == error_code_grv_proxy_memory_limit_exceeded || e.code() == error_code_batch_transaction_throttled)
															#line 4476 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			{
															#line 413 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<Void> __when_expr_29 = tx->onError(e);
															#line 413 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4482 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_29.isReady()) { if (__when_expr_29.isError()) return a_body1Catch1(__when_expr_29.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont13loopBody1Catch1when1(__when_expr_29.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 30;
															#line 413 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_29.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 4487 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 415 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				ASSERT(e.code() == error_code_database_locked);
															#line 4494 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				return a_body1cont14cont13break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont14cont13loopBody1cont2(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13loopBody1cont2(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13loopBody1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13loopBody1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose29() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 28, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 28, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont14cont13loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 28, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont14cont13loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 28, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont14cont13loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);

	}
	int a_body1cont14cont13loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont14cont13loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont14cont13loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont14cont13loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose30() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1cont14cont13loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1cont14cont13loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);

	}
	int a_body1cont14cont13cont2(int loopDepth) 
	{
															#line 439 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 440 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		;
															#line 4705 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont13cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont14cont13cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont1loopBody1(int loopDepth) 
	{
		try {
															#line 425 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 426 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 428 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->clear(SpecialKeySpace::getManagementApiCommandPrefix("lock"));
															#line 429 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Void> __when_expr_30 = tx->commit();
															#line 429 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4730 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_30.isReady()) { if (__when_expr_30.isError()) return a_body1cont14cont13cont1loopBody1Catch1(__when_expr_30.getError(), loopDepth); else return a_body1cont14cont13cont1loopBody1when1(__when_expr_30.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 31;
															#line 429 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_30.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 4735 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont14cont13cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont14cont13cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont14cont13cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont14cont13cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont14cont13cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 433 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			TraceEvent(SevDebug, "DatabaseUnlockFailure").error(e);
															#line 434 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			ASSERT(e.code() != error_code_database_locked);
															#line 435 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Void> __when_expr_31 = tx->onError(e);
															#line 435 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4776 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_31.isReady()) { if (__when_expr_31.isError()) return a_body1Catch1(__when_expr_31.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont13cont1loopBody1Catch1when1(__when_expr_31.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 32;
															#line 435 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_31.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 31, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 4781 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 430 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		TraceEvent(SevDebug, "DatabaseUnlocked").log();
															#line 4796 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		return a_body1cont14cont13cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont14cont13cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 430 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		TraceEvent(SevDebug, "DatabaseUnlocked").log();
															#line 4805 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		return a_body1cont14cont13cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont14cont13cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose31() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1cont14cont13cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1cont14cont13cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1cont14cont13cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);

	}
	int a_body1cont14cont13cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose32() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 31, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 31, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose32();
		try {
			a_body1cont14cont13cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 31, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose32();
		try {
			a_body1cont14cont13cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 31, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose32();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);

	}
	int a_body1cont14cont13cont3(int loopDepth) 
	{
															#line 454 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 4976 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		{
			try {
															#line 457 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 458 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_34 = tx->get(fdbShouldConsistencyCheckBeSuspended);
															#line 458 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont3Catch1(actor_cancelled(), loopDepth);
															#line 4985 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_34.isReady()) { if (__when_expr_34.isError()) return a_body1cont14cont13cont3Catch1(__when_expr_34.getError(), loopDepth); else return a_body1cont14cont13cont3when1(__when_expr_34.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 35;
															#line 458 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_34.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 34, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 4990 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont14cont13cont3Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont14cont13cont3Catch1(unknown_error(), loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont14cont13cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont2loopBody1(int loopDepth) 
	{
		try {
															#line 443 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 444 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_32 = tx->getRange(normalKeys, 1);
															#line 444 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5018 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_32.isReady()) { if (__when_expr_32.isError()) return a_body1cont14cont13cont2loopBody1Catch1(__when_expr_32.getError(), loopDepth); else return a_body1cont14cont13cont2loopBody1when1(__when_expr_32.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 33;
															#line 444 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_32.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 32, RangeResult >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 5023 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont14cont13cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont14cont13cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont14cont13cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont14cont13cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont14cont13cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 447 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Void> __when_expr_33 = tx->onError(e);
															#line 447 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5060 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_33.isReady()) { if (__when_expr_33.isError()) return a_body1Catch1(__when_expr_33.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont13cont2loopBody1Catch1when1(__when_expr_33.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 34;
															#line 447 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_33.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 33, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 5065 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont2loopBody1cont2(RangeResult const& res,int loopDepth) 
	{
		return a_body1cont14cont13cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont14cont13cont2loopBody1cont2(RangeResult && res,int loopDepth) 
	{
		return a_body1cont14cont13cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont14cont13cont2loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont2loopBody1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont2loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont2loopBody1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose33() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 32, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 32, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose33();
		try {
			a_body1cont14cont13cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 32, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose33();
		try {
			a_body1cont14cont13cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 32, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose33();
		try {
			a_body1cont14cont13cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);

	}
	int a_body1cont14cont13cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose34() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 33, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 33, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose34();
		try {
			a_body1cont14cont13cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 33, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose34();
		try {
			a_body1cont14cont13cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 33, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose34();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);

	}
	int a_body1cont14cont13cont4(int loopDepth) 
	{
		{
															#line 485 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			;
															#line 5255 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = a_body1cont14cont13cont4loopHead1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont5(int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 480 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Void> __when_expr_38 = tx->onError(e);
															#line 480 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5274 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_38.isReady()) { if (__when_expr_38.isError()) return a_body1Catch1(__when_expr_38.getError(), loopDepth); else return a_body1cont14cont13cont3Catch1when1(__when_expr_38.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 39;
															#line 480 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_38.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 38, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 5279 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont6(Optional<Value> const& val1,int loopDepth) 
	{
															#line 459 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ccSuspendSetting = val1.present() ? BinaryReader::fromStringRef<bool>(val1.get(), Unversioned()) : false;
															#line 461 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_35 = tx->get(SpecialKeySpace::getManagementApiCommandPrefix("consistencycheck"));
															#line 461 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont3Catch1(actor_cancelled(), loopDepth);
															#line 5298 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_35.isReady()) { if (__when_expr_35.isError()) return a_body1cont14cont13cont3Catch1(__when_expr_35.getError(), loopDepth); else return a_body1cont14cont13cont6when1(__when_expr_35.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 36;
															#line 461 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_35.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 35, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 5303 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont6(Optional<Value> && val1,int loopDepth) 
	{
															#line 459 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ccSuspendSetting = val1.present() ? BinaryReader::fromStringRef<bool>(val1.get(), Unversioned()) : false;
															#line 461 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_35 = tx->get(SpecialKeySpace::getManagementApiCommandPrefix("consistencycheck"));
															#line 461 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont3Catch1(actor_cancelled(), loopDepth);
															#line 5316 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_35.isReady()) { if (__when_expr_35.isError()) return a_body1cont14cont13cont3Catch1(__when_expr_35.getError(), loopDepth); else return a_body1cont14cont13cont6when1(__when_expr_35.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 36;
															#line 461 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_35.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 35, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 5321 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont3when1(Optional<Value> const& val1,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont6(val1, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont3when1(Optional<Value> && val1,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont6(std::move(val1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose35() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 34, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 34, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose35();
		try {
			a_body1cont14cont13cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 34, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose35();
		try {
			a_body1cont14cont13cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 34, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose35();
		try {
			a_body1cont14cont13cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);

	}
	int a_body1cont14cont13cont7(Optional<Value> const& val2,int loopDepth) 
	{
															#line 464 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(ccSuspendSetting ? val2.present() : !val2.present());
															#line 465 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 467 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(!ccSuspendSetting);
															#line 469 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->set(SpecialKeySpace::getManagementApiCommandPrefix("consistencycheck"), ValueRef());
															#line 470 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Void> __when_expr_36 = tx->commit();
															#line 470 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont3Catch1(actor_cancelled(), loopDepth);
															#line 5415 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_36.isReady()) { if (__when_expr_36.isError()) return a_body1cont14cont13cont3Catch1(__when_expr_36.getError(), loopDepth); else return a_body1cont14cont13cont7when1(__when_expr_36.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 37;
															#line 470 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_36.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 5420 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont7(Optional<Value> && val2,int loopDepth) 
	{
															#line 464 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(ccSuspendSetting ? val2.present() : !val2.present());
															#line 465 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 467 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(!ccSuspendSetting);
															#line 469 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->set(SpecialKeySpace::getManagementApiCommandPrefix("consistencycheck"), ValueRef());
															#line 470 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Void> __when_expr_36 = tx->commit();
															#line 470 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont3Catch1(actor_cancelled(), loopDepth);
															#line 5439 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_36.isReady()) { if (__when_expr_36.isError()) return a_body1cont14cont13cont3Catch1(__when_expr_36.getError(), loopDepth); else return a_body1cont14cont13cont7when1(__when_expr_36.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 37;
															#line 470 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_36.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 5444 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont6when1(Optional<Value> const& val2,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont7(val2, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont6when1(Optional<Value> && val2,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont7(std::move(val2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose36() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 35, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 35, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose36();
		try {
			a_body1cont14cont13cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 35, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose36();
		try {
			a_body1cont14cont13cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 35, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose36();
		try {
			a_body1cont14cont13cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);

	}
	int a_body1cont14cont13cont8(Void const& _,int loopDepth) 
	{
															#line 471 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 473 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 474 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_37 = tx->get(fdbShouldConsistencyCheckBeSuspended);
															#line 474 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont3Catch1(actor_cancelled(), loopDepth);
															#line 5534 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_37.isReady()) { if (__when_expr_37.isError()) return a_body1cont14cont13cont3Catch1(__when_expr_37.getError(), loopDepth); else return a_body1cont14cont13cont8when1(__when_expr_37.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 38;
															#line 474 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_37.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 5539 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont8(Void && _,int loopDepth) 
	{
															#line 471 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 473 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 474 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_37 = tx->get(fdbShouldConsistencyCheckBeSuspended);
															#line 474 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont3Catch1(actor_cancelled(), loopDepth);
															#line 5554 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_37.isReady()) { if (__when_expr_37.isError()) return a_body1cont14cont13cont3Catch1(__when_expr_37.getError(), loopDepth); else return a_body1cont14cont13cont8when1(__when_expr_37.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 38;
															#line 474 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_37.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 5559 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose37() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose37();
		try {
			a_body1cont14cont13cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose37();
		try {
			a_body1cont14cont13cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose37();
		try {
			a_body1cont14cont13cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);

	}
	int a_body1cont14cont13cont9(Optional<Value> const& val3,int loopDepth) 
	{
															#line 475 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		bool ccSuspendSetting2 = val3.present() ? BinaryReader::fromStringRef<bool>(val3.get(), Unversioned()) : false;
															#line 477 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(ccSuspendSetting2);
															#line 478 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 5647 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont13cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont9(Optional<Value> && val3,int loopDepth) 
	{
															#line 475 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		bool ccSuspendSetting2 = val3.present() ? BinaryReader::fromStringRef<bool>(val3.get(), Unversioned()) : false;
															#line 477 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(ccSuspendSetting2);
															#line 478 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 5660 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont13cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont8when1(Optional<Value> const& val3,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont9(val3, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont8when1(Optional<Value> && val3,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont9(std::move(val3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose38() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose38();
		try {
			a_body1cont14cont13cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose38();
		try {
			a_body1cont14cont13cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose38();
		try {
			a_body1cont14cont13cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);

	}
	int a_body1cont14cont13cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont14cont13cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont3Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont3Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont3Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont3Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont3Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont3Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose39() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 38, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 38, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose39();
		try {
			a_body1cont14cont13cont3Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 38, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose39();
		try {
			a_body1cont14cont13cont3Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 38, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose39();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);

	}
	int a_body1cont14cont13cont12(int loopDepth) 
	{
															#line 500 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		;
															#line 5844 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont13cont12loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont13(int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont14cont13cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont4loopBody1(int loopDepth) 
	{
		try {
															#line 487 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 488 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 489 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->clear(SpecialKeySpace::getManagementApiCommandPrefix("consistencycheck"));
															#line 490 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Void> __when_expr_39 = tx->commit();
															#line 490 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5875 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_39.isReady()) { if (__when_expr_39.isError()) return a_body1cont14cont13cont4loopBody1Catch1(__when_expr_39.getError(), loopDepth); else return a_body1cont14cont13cont4loopBody1when1(__when_expr_39.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 40;
															#line 490 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_39.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 39, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 5880 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont14cont13cont4loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont14cont13cont4loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont14cont13cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont4loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont14cont13cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont14cont13cont4loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 494 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Void> __when_expr_40 = tx->onError(e);
															#line 494 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5917 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_40.isReady()) { if (__when_expr_40.isError()) return a_body1Catch1(__when_expr_40.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont13cont4loopBody1Catch1when1(__when_expr_40.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 41;
															#line 494 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_40.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 5922 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont4loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 491 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 5937 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		return a_body1cont14cont13cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont14cont13cont4loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 491 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 5946 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		return a_body1cont14cont13cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont14cont13cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont4loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont4loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose40() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 39, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 39, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose40();
		try {
			a_body1cont14cont13cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 39, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose40();
		try {
			a_body1cont14cont13cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 39, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose40();
		try {
			a_body1cont14cont13cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);

	}
	int a_body1cont14cont13cont4loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont4loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont4loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont4loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont4loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont4loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose41() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose41();
		try {
			a_body1cont14cont13cont4loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose41();
		try {
			a_body1cont14cont13cont4loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose41();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);

	}
	int a_body1cont14cont13cont12cont1(int loopDepth) 
	{
		try {
															#line 527 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 528 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Version> __when_expr_45 = tx->getReadVersion();
															#line 528 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12cont1Catch1(actor_cancelled(), loopDepth);
															#line 6122 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_45.isReady()) { if (__when_expr_45.isError()) return a_body1cont14cont13cont12cont1Catch1(__when_expr_45.getError(), loopDepth); else return a_body1cont14cont13cont12cont1when1(__when_expr_45.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 46;
															#line 528 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_45.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 45, Version >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont14cont13cont12cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont14cont13cont12cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont14cont13cont12loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopBody1(int loopDepth) 
	{
		try {
															#line 502 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 503 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_41 = tx->get(coordinatorsKey);
															#line 503 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6154 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_41.isReady()) { if (__when_expr_41.isError()) return a_body1cont14cont13cont12loopBody1Catch1(__when_expr_41.getError(), loopDepth); else return a_body1cont14cont13cont12loopBody1when1(__when_expr_41.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 42;
															#line 503 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_41.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 41, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6159 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont14cont13cont12loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont14cont13cont12loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont12break1(int loopDepth) 
	{
		try {
			return a_body1cont14cont13cont12cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont14cont13cont12loopHead1(0);

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 522 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Void> __when_expr_44 = tx->onError(e);
															#line 522 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6196 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_44.isReady()) { if (__when_expr_44.isError()) return a_body1Catch1(__when_expr_44.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont13cont12loopBody1Catch1when1(__when_expr_44.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 45;
															#line 522 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_44.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 44, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6201 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopBody1cont2(Optional<Value> const& res,int loopDepth) 
	{
															#line 504 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(res.present());
															#line 505 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		cs = ClusterConnectionString(res.get().toString());
															#line 506 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_42 = tx->get("processes"_sr.withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("coordinators")));
															#line 506 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6222 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_42.isReady()) { if (__when_expr_42.isError()) return a_body1cont14cont13cont12loopBody1Catch1(__when_expr_42.getError(), loopDepth); else return a_body1cont14cont13cont12loopBody1cont2when1(__when_expr_42.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 43;
															#line 506 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_42.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 42, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6227 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopBody1cont2(Optional<Value> && res,int loopDepth) 
	{
															#line 504 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(res.present());
															#line 505 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		cs = ClusterConnectionString(res.get().toString());
															#line 506 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_42 = tx->get("processes"_sr.withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("coordinators")));
															#line 506 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6242 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_42.isReady()) { if (__when_expr_42.isError()) return a_body1cont14cont13cont12loopBody1Catch1(__when_expr_42.getError(), loopDepth); else return a_body1cont14cont13cont12loopBody1cont2when1(__when_expr_42.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 43;
															#line 506 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_42.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 42, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6247 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopBody1when1(Optional<Value> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12loopBody1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopBody1when1(Optional<Value> && res,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12loopBody1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose42() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 41, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 41, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 41);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose42();
		try {
			a_body1cont14cont13cont12loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 41);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 41, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 41);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose42();
		try {
			a_body1cont14cont13cont12loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 41);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 41, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 41);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose42();
		try {
			a_body1cont14cont13cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 41);

	}
	int a_body1cont14cont13cont12loopBody1cont3(Optional<Value> const& coordinator_processes_key,int loopDepth) 
	{
															#line 508 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(coordinator_processes_key.present());
															#line 509 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		process_addresses = std::vector<std::string>();
															#line 510 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		boost::split( process_addresses, coordinator_processes_key.get().toString(), [](char c) { return c == ','; });
															#line 512 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(process_addresses.size() == cs.coords.size() + cs.hostnames.size());
															#line 514 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_43 = cs.tryResolveHostnames();
															#line 514 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6341 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_43.isReady()) { if (__when_expr_43.isError()) return a_body1cont14cont13cont12loopBody1Catch1(__when_expr_43.getError(), loopDepth); else return a_body1cont14cont13cont12loopBody1cont3when1(__when_expr_43.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 44;
															#line 514 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_43.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 43, std::vector<NetworkAddress> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6346 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopBody1cont3(Optional<Value> && coordinator_processes_key,int loopDepth) 
	{
															#line 508 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(coordinator_processes_key.present());
															#line 509 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		process_addresses = std::vector<std::string>();
															#line 510 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		boost::split( process_addresses, coordinator_processes_key.get().toString(), [](char c) { return c == ','; });
															#line 512 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(process_addresses.size() == cs.coords.size() + cs.hostnames.size());
															#line 514 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_43 = cs.tryResolveHostnames();
															#line 514 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6365 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_43.isReady()) { if (__when_expr_43.isError()) return a_body1cont14cont13cont12loopBody1Catch1(__when_expr_43.getError(), loopDepth); else return a_body1cont14cont13cont12loopBody1cont3when1(__when_expr_43.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 44;
															#line 514 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_43.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 43, std::vector<NetworkAddress> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6370 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopBody1cont2when1(Optional<Value> const& coordinator_processes_key,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12loopBody1cont3(coordinator_processes_key, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopBody1cont2when1(Optional<Value> && coordinator_processes_key,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12loopBody1cont3(std::move(coordinator_processes_key), loopDepth);

		return loopDepth;
	}
	void a_exitChoose43() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 42, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 42, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 42);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose43();
		try {
			a_body1cont14cont13cont12loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 42);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 42, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 42);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose43();
		try {
			a_body1cont14cont13cont12loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 42);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 42, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 42);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose43();
		try {
			a_body1cont14cont13cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 42);

	}
	int a_body1cont14cont13cont12loopBody1cont4(std::vector<NetworkAddress> const& coordinators,int loopDepth) 
	{
															#line 515 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		for( const auto& network_address : coordinators ) {
															#line 516 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			ASSERT(std::find(process_addresses.begin(), process_addresses.end(), network_address.toString()) != process_addresses.end());
															#line 6456 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		}
															#line 519 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 6460 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		return a_body1cont14cont13cont12break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopBody1cont4(std::vector<NetworkAddress> && coordinators,int loopDepth) 
	{
															#line 515 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		for( const auto& network_address : coordinators ) {
															#line 516 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			ASSERT(std::find(process_addresses.begin(), process_addresses.end(), network_address.toString()) != process_addresses.end());
															#line 6471 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		}
															#line 519 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 6475 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		return a_body1cont14cont13cont12break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopBody1cont3when1(std::vector<NetworkAddress> const& coordinators,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12loopBody1cont4(coordinators, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopBody1cont3when1(std::vector<NetworkAddress> && coordinators,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12loopBody1cont4(std::move(coordinators), loopDepth);

		return loopDepth;
	}
	void a_exitChoose44() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 43, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 43, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 43);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose44();
		try {
			a_body1cont14cont13cont12loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 43);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 43, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 43);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose44();
		try {
			a_body1cont14cont13cont12loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 43);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 43, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 43);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose44();
		try {
			a_body1cont14cont13cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 43);

	}
	int a_body1cont14cont13cont12loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose45() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 44, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 44, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 44);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose45();
		try {
			a_body1cont14cont13cont12loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 44);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 44, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 44);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose45();
		try {
			a_body1cont14cont13cont12loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 44);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 44, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 44);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose45();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 44);

	}
	int a_body1cont14cont13cont12cont2(int loopDepth) 
	{
		{
															#line 557 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tr1 = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 558 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tr2 = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 559 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			;
															#line 6651 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = a_body1cont14cont13cont12cont2loopHead1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 552 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Void> __when_expr_49 = tx->onError(e);
															#line 552 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6664 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_49.isReady()) { if (__when_expr_49.isError()) return a_body1Catch1(__when_expr_49.getError(), loopDepth); else return a_body1cont14cont13cont12cont1Catch1when1(__when_expr_49.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 50;
															#line 552 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_49.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 49, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6669 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3(Version const& v1,int loopDepth) 
	{
															#line 529 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		TraceEvent(SevDebug, "InitialReadVersion").detail("Version", v1);
															#line 530 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		v2 = 2 * v1;
															#line 531 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		;
															#line 6688 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont13cont12cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3(Version && v1,int loopDepth) 
	{
															#line 529 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		TraceEvent(SevDebug, "InitialReadVersion").detail("Version", v1);
															#line 530 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		v2 = 2 * v1;
															#line 531 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		;
															#line 6701 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont13cont12cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont1when1(Version const& v1,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont3(v1, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont1when1(Version && v1,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont3(std::move(v1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose46() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 45, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 45, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 45);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose46();
		try {
			a_body1cont14cont13cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 45);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 45, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 45);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose46();
		try {
			a_body1cont14cont13cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 45);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 45, Version >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 45);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose46();
		try {
			a_body1cont14cont13cont12cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 45);

	}
	int a_body1cont14cont13cont12cont4(int loopDepth) 
	{
															#line 550 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->reset();
															#line 6785 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont13cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont14cont13cont12cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3loopBody1(int loopDepth) 
	{
		try {
															#line 534 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Version> __when_expr_46 = tx->getReadVersion();
															#line 534 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6804 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_46.isReady()) { if (__when_expr_46.isError()) return a_body1cont14cont13cont12cont3loopBody1Catch1(__when_expr_46.getError(), loopDepth); else return a_body1cont14cont13cont12cont3loopBody1when1(__when_expr_46.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 47;
															#line 534 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_46.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 46, Version >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6809 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont14cont13cont12cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont14cont13cont12cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont14cont13cont12cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont14cont13cont12cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont14cont13cont12cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont14cont13cont12cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 546 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			TraceEvent(SevDebug, "AdvanceVersionCommitFailure").error(e);
															#line 547 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Void> __when_expr_48 = tx->onError(e);
															#line 547 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6848 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_48.isReady()) { if (__when_expr_48.isError()) return a_body1cont14cont13cont12cont1Catch1(__when_expr_48.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont13cont12cont3loopBody1Catch1when1(__when_expr_48.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 49;
															#line 547 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_48.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 48, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6853 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont14cont13cont12cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont14cont13cont12cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3loopBody1cont2(Version const& v3,int loopDepth) 
	{
															#line 535 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (v3 > v2)
															#line 6868 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		{
															#line 536 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			TraceEvent(SevDebug, "AdvanceVersionSuccess").detail("Version", v3);
															#line 6872 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			return a_body1cont14cont13cont12cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 539 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 540 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 542 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->set(SpecialKeySpace::getManagementApiCommandPrefix("advanceversion"), std::to_string(v2));
															#line 543 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Void> __when_expr_47 = tx->commit();
															#line 543 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6885 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_47.isReady()) { if (__when_expr_47.isError()) return a_body1cont14cont13cont12cont3loopBody1Catch1(__when_expr_47.getError(), loopDepth); else return a_body1cont14cont13cont12cont3loopBody1cont2when1(__when_expr_47.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 48;
															#line 543 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_47.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 47, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6890 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3loopBody1cont2(Version && v3,int loopDepth) 
	{
															#line 535 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (v3 > v2)
															#line 6899 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		{
															#line 536 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			TraceEvent(SevDebug, "AdvanceVersionSuccess").detail("Version", v3);
															#line 6903 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			return a_body1cont14cont13cont12cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 539 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 540 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 542 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tx->set(SpecialKeySpace::getManagementApiCommandPrefix("advanceversion"), std::to_string(v2));
															#line 543 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Void> __when_expr_47 = tx->commit();
															#line 543 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6916 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_47.isReady()) { if (__when_expr_47.isError()) return a_body1cont14cont13cont12cont3loopBody1Catch1(__when_expr_47.getError(), loopDepth); else return a_body1cont14cont13cont12cont3loopBody1cont2when1(__when_expr_47.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 48;
															#line 543 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_47.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 47, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6921 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3loopBody1when1(Version const& v3,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont3loopBody1cont2(v3, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3loopBody1when1(Version && v3,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont3loopBody1cont2(std::move(v3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose47() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 46, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 46, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 46);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose47();
		try {
			a_body1cont14cont13cont12cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 46);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 46, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 46);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose47();
		try {
			a_body1cont14cont13cont12cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 46);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 46, Version >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 46);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose47();
		try {
			a_body1cont14cont13cont12cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 46);

	}
	int a_body1cont14cont13cont12cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 544 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(false);
															#line 7005 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont13cont12cont3loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 544 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(false);
															#line 7014 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont13cont12cont3loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose48() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 47, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 47, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 47);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose48();
		try {
			a_body1cont14cont13cont12cont3loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 47);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 47, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 47);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose48();
		try {
			a_body1cont14cont13cont12cont3loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 47);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 47, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 47);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose48();
		try {
			a_body1cont14cont13cont12cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 47);

	}
	int a_body1cont14cont13cont12cont3loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont14cont13cont12cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont14cont13cont12cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont14cont13cont12cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont3loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont3loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont3loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose49() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 48, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 48, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 48);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose49();
		try {
			a_body1cont14cont13cont12cont3loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 48);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 48, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 48);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose49();
		try {
			a_body1cont14cont13cont12cont3loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 48);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 48, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 48);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose49();
		try {
			a_body1cont14cont13cont12cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 48);

	}
	int a_body1cont14cont13cont12cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont14cont13cont12cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose50() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 49, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 49, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 49);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose50();
		try {
			a_body1cont14cont13cont12cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 49);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 49, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 49);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose50();
		try {
			a_body1cont14cont13cont12cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 49);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 49, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 49);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose50();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 49);

	}
	int a_body1cont14cont13cont12cont7(int loopDepth) 
	{
															#line 590 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (!static_cast<ManagementApiCorrectnessActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ManagementApiCorrectnessActorActorState(); static_cast<ManagementApiCorrectnessActorActor*>(this)->destroy(); return 0; }
															#line 7298 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		new (&static_cast<ManagementApiCorrectnessActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ManagementApiCorrectnessActorActorState();
		static_cast<ManagementApiCorrectnessActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont8(int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont14cont13cont12cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1(int loopDepth) 
	{
		try {
															#line 561 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tr1->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 562 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tr1->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 563 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			tr2->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 565 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			StrictFuture<Version> __when_expr_50 = tr1->getReadVersion();
															#line 565 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7332 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			if (__when_expr_50.isReady()) { if (__when_expr_50.isError()) return a_body1cont14cont13cont12cont2loopBody1Catch1(__when_expr_50.getError(), loopDepth); else return a_body1cont14cont13cont12cont2loopBody1when1(__when_expr_50.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 51;
															#line 565 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			__when_expr_50.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 50, Version >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7337 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont14cont13cont12cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont14cont13cont12cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont14cont13cont12cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont14cont13cont12cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 579 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
			if (e.code() != error_code_not_committed)
															#line 7372 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
			{
															#line 581 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				StrictFuture<Void> __when_expr_54 = tr2->onError(e);
															#line 581 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7378 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				if (__when_expr_54.isReady()) { if (__when_expr_54.isError()) return a_body1Catch1(__when_expr_54.getError(), std::max(0, loopDepth - 1)); else return a_body1cont14cont13cont12cont2loopBody1Catch1when1(__when_expr_54.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 55;
															#line 581 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
				__when_expr_54.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 54, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7383 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				return a_body1cont14cont13cont12cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1cont2(Version const& readVersion,int loopDepth) 
	{
															#line 566 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tr2->setVersion(readVersion);
															#line 567 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		KeyRef ddPrefix = SpecialKeySpace::getManagementApiCommandPrefix("datadistribution");
															#line 568 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tr1->set("mode"_sr.withPrefix(ddPrefix), "1"_sr);
															#line 569 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Void> __when_expr_51 = tr1->commit();
															#line 569 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7411 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_51.isReady()) { if (__when_expr_51.isError()) return a_body1cont14cont13cont12cont2loopBody1Catch1(__when_expr_51.getError(), loopDepth); else return a_body1cont14cont13cont12cont2loopBody1cont2when1(__when_expr_51.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 52;
															#line 569 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_51.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 51, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7416 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1cont2(Version && readVersion,int loopDepth) 
	{
															#line 566 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tr2->setVersion(readVersion);
															#line 567 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		KeyRef ddPrefix = SpecialKeySpace::getManagementApiCommandPrefix("datadistribution");
															#line 568 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tr1->set("mode"_sr.withPrefix(ddPrefix), "1"_sr);
															#line 569 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Void> __when_expr_51 = tr1->commit();
															#line 569 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7433 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_51.isReady()) { if (__when_expr_51.isError()) return a_body1cont14cont13cont12cont2loopBody1Catch1(__when_expr_51.getError(), loopDepth); else return a_body1cont14cont13cont12cont2loopBody1cont2when1(__when_expr_51.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 52;
															#line 569 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_51.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 51, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7438 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1when1(Version const& readVersion,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont2loopBody1cont2(readVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1when1(Version && readVersion,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont2loopBody1cont2(std::move(readVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose51() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 50, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 50, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 50);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose51();
		try {
			a_body1cont14cont13cont12cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 50);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 50, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 50);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose51();
		try {
			a_body1cont14cont13cont12cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 50);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 50, Version >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 50);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose51();
		try {
			a_body1cont14cont13cont12cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 50);

	}
	int a_body1cont14cont13cont12cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 572 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Void> __when_expr_52 = success( tr2->get(deterministicRandom()->coinflip() ? moveKeysLockOwnerKey : moveKeysLockWriteKey));
															#line 572 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7524 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_52.isReady()) { if (__when_expr_52.isError()) return a_body1cont14cont13cont12cont2loopBody1Catch1(__when_expr_52.getError(), loopDepth); else return a_body1cont14cont13cont12cont2loopBody1cont3when1(__when_expr_52.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 53;
															#line 572 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_52.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 52, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7529 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 572 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Void> __when_expr_52 = success( tr2->get(deterministicRandom()->coinflip() ? moveKeysLockOwnerKey : moveKeysLockWriteKey));
															#line 572 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7540 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_52.isReady()) { if (__when_expr_52.isError()) return a_body1cont14cont13cont12cont2loopBody1Catch1(__when_expr_52.getError(), loopDepth); else return a_body1cont14cont13cont12cont2loopBody1cont3when1(__when_expr_52.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 53;
															#line 572 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_52.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 52, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7545 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose52() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 51, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 51, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 51);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose52();
		try {
			a_body1cont14cont13cont12cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 51);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 51, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 51);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose52();
		try {
			a_body1cont14cont13cont12cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 51);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 51, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 51);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose52();
		try {
			a_body1cont14cont13cont12cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 51);

	}
	int a_body1cont14cont13cont12cont2loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 575 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tr2->addWriteConflictRange(singleKeyRange(""_sr));
															#line 576 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Void> __when_expr_53 = tr2->commit();
															#line 576 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7633 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_53.isReady()) { if (__when_expr_53.isError()) return a_body1cont14cont13cont12cont2loopBody1Catch1(__when_expr_53.getError(), loopDepth); else return a_body1cont14cont13cont12cont2loopBody1cont4when1(__when_expr_53.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 54;
															#line 576 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_53.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 53, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7638 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 575 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tr2->addWriteConflictRange(singleKeyRange(""_sr));
															#line 576 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		StrictFuture<Void> __when_expr_53 = tr2->commit();
															#line 576 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont14cont13cont12cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7651 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		if (__when_expr_53.isReady()) { if (__when_expr_53.isError()) return a_body1cont14cont13cont12cont2loopBody1Catch1(__when_expr_53.getError(), loopDepth); else return a_body1cont14cont13cont12cont2loopBody1cont4when1(__when_expr_53.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 54;
															#line 576 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		__when_expr_53.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 53, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7656 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont2loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont2loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose53() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 52, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 52, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 52);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose53();
		try {
			a_body1cont14cont13cont12cont2loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 52);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 52, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 52);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose53();
		try {
			a_body1cont14cont13cont12cont2loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 52);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 52, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 52);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose53();
		try {
			a_body1cont14cont13cont12cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 52);

	}
	int a_body1cont14cont13cont12cont2loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 577 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(false);
															#line 7740 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont13cont12cont2loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 577 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		ASSERT(false);
															#line 7749 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont13cont12cont2loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont2loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont2loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose54() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 53, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 53, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 53);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose54();
		try {
			a_body1cont14cont13cont12cont2loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 53);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 53, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 53);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose54();
		try {
			a_body1cont14cont13cont12cont2loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 53);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 53, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 53);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose54();
		try {
			a_body1cont14cont13cont12cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont14cont13cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 53);

	}
	int a_body1cont14cont13cont12cont2loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont14cont13cont12cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
															#line 582 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tr1->reset();
															#line 7852 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont13cont12cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
															#line 582 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
		tr1->reset();
															#line 7861 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		loopDepth = a_body1cont14cont13cont12cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont2loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont14cont13cont12cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont13cont12cont2loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose55() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 54, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 54, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 54);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose55();
		try {
			a_body1cont14cont13cont12cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 54);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 54, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 54);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose55();
		try {
			a_body1cont14cont13cont12cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 54);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 54, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 54);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose55();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 54);

	}
															#line 82 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	Database cx;
															#line 82 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	SpecialKeySpaceRobustnessWorkload* self;
															#line 84 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	Reference<ReadYourWritesTransaction> tx;
															#line 134 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	std::string excludeWorker;
															#line 135 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	std::string excludeCommand;
															#line 136 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	std::string failedCommand;
															#line 137 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	KeyRef excludeVersionKey;
															#line 138 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	KeyRef failedVersionKey;
															#line 161 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	Optional<Value> versionKey0;
															#line 163 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	Optional<Value> versionKey1;
															#line 174 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	Optional<Value> versionKey3;
															#line 176 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	Optional<Value> versionKey4;
															#line 218 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	RangeResult result;
															#line 243 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	ProcessData worker;
															#line 244 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	Key addr;
															#line 288 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	RangeResult class_source_result;
															#line 316 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	std::string address;
															#line 339 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	LocalityData _locality;
															#line 459 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	bool ccSuspendSetting;
															#line 505 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	ClusterConnectionString cs;
															#line 509 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	std::vector<std::string> process_addresses;
															#line 530 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	Version v2;
															#line 557 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	Reference<ReadYourWritesTransaction> tr1;
															#line 558 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	Reference<ReadYourWritesTransaction> tr2;
															#line 7989 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
};
// This generated class is to be used only via managementApiCorrectnessActor()
															#line 82 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
class ManagementApiCorrectnessActorActor final : public Actor<Void>, public ActorCallback< ManagementApiCorrectnessActorActor, 0, RangeResult >, public ActorCallback< ManagementApiCorrectnessActorActor, 1, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 2, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 4, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 5, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 7, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 8, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 10, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 12, RangeResult >, public ActorCallback< ManagementApiCorrectnessActorActor, 13, std::vector<ProcessData> >, public ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 15, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 17, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 18, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 19, RangeResult >, public ActorCallback< ManagementApiCorrectnessActorActor, 20, std::vector<ProcessData> >, public ActorCallback< ManagementApiCorrectnessActorActor, 21, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 22, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 23, std::vector<ProcessData> >, public ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 28, RangeResult >, public ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 31, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 32, RangeResult >, public ActorCallback< ManagementApiCorrectnessActorActor, 33, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 34, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 35, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 38, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 39, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 41, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 42, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 43, std::vector<NetworkAddress> >, public ActorCallback< ManagementApiCorrectnessActorActor, 44, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 45, Version >, public ActorCallback< ManagementApiCorrectnessActorActor, 46, Version >, public ActorCallback< ManagementApiCorrectnessActorActor, 47, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 48, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 49, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 50, Version >, public ActorCallback< ManagementApiCorrectnessActorActor, 51, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 52, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 53, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 54, Void >, public FastAllocated<ManagementApiCorrectnessActorActor>, public ManagementApiCorrectnessActorActorState<ManagementApiCorrectnessActorActor> {
															#line 7994 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
public:
	using FastAllocated<ManagementApiCorrectnessActorActor>::operator new;
	using FastAllocated<ManagementApiCorrectnessActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7146614316718259712UL, 18058026189336117760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 0, RangeResult >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 1, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 2, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 4, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 5, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 7, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 8, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 10, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 12, RangeResult >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 13, std::vector<ProcessData> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 15, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 17, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 18, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 19, RangeResult >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 20, std::vector<ProcessData> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 21, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 22, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 23, std::vector<ProcessData> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 28, RangeResult >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 31, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 32, RangeResult >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 33, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 34, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 35, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 38, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 39, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 41, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 42, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 43, std::vector<NetworkAddress> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 44, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 45, Version >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 46, Version >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 47, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 48, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 49, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 50, Version >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 51, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 52, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 53, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 54, Void >;
															#line 82 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	ManagementApiCorrectnessActorActor(Database const& cx,SpecialKeySpaceRobustnessWorkload* const& self) 
															#line 8065 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
		 : Actor<Void>(),
		   ManagementApiCorrectnessActorActorState<ManagementApiCorrectnessActorActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15613886550486222848UL, 15598498704839473152UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("managementApiCorrectnessActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 4, Optional<Value> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 5, Optional<Value> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 7, Optional<Value> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 8, Optional<Value> >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 10, Optional<Value> >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 12, RangeResult >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 13, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 15, Optional<Value> >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 17, Optional<Value> >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 18, Void >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 19, RangeResult >*)0, actor_cancelled()); break;
		case 21: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 20, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		case 22: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 21, Void >*)0, actor_cancelled()); break;
		case 23: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 22, Optional<Value> >*)0, actor_cancelled()); break;
		case 24: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 23, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		case 25: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >*)0, actor_cancelled()); break;
		case 26: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*)0, actor_cancelled()); break;
		case 27: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >*)0, actor_cancelled()); break;
		case 28: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >*)0, actor_cancelled()); break;
		case 29: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 28, RangeResult >*)0, actor_cancelled()); break;
		case 30: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >*)0, actor_cancelled()); break;
		case 31: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >*)0, actor_cancelled()); break;
		case 32: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 31, Void >*)0, actor_cancelled()); break;
		case 33: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 32, RangeResult >*)0, actor_cancelled()); break;
		case 34: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 33, Void >*)0, actor_cancelled()); break;
		case 35: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 34, Optional<Value> >*)0, actor_cancelled()); break;
		case 36: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 35, Optional<Value> >*)0, actor_cancelled()); break;
		case 37: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >*)0, actor_cancelled()); break;
		case 38: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >*)0, actor_cancelled()); break;
		case 39: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 38, Void >*)0, actor_cancelled()); break;
		case 40: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 39, Void >*)0, actor_cancelled()); break;
		case 41: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >*)0, actor_cancelled()); break;
		case 42: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 41, Optional<Value> >*)0, actor_cancelled()); break;
		case 43: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 42, Optional<Value> >*)0, actor_cancelled()); break;
		case 44: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 43, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		case 45: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 44, Void >*)0, actor_cancelled()); break;
		case 46: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 45, Version >*)0, actor_cancelled()); break;
		case 47: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 46, Version >*)0, actor_cancelled()); break;
		case 48: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 47, Void >*)0, actor_cancelled()); break;
		case 49: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 48, Void >*)0, actor_cancelled()); break;
		case 50: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 49, Void >*)0, actor_cancelled()); break;
		case 51: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 50, Version >*)0, actor_cancelled()); break;
		case 52: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 51, Void >*)0, actor_cancelled()); break;
		case 53: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 52, Void >*)0, actor_cancelled()); break;
		case 54: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 53, Void >*)0, actor_cancelled()); break;
		case 55: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 54, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 82 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
[[nodiscard]] Future<Void> managementApiCorrectnessActor( Database const& cx, SpecialKeySpaceRobustnessWorkload* const& self ) {
															#line 82 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
	return Future<Void>(new ManagementApiCorrectnessActorActor(cx, self));
															#line 8151 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SpecialKeySpaceRobustness.actor.g.cpp"
}

#line 592 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/SpecialKeySpaceRobustness.actor.cpp"
};

WorkloadFactory<SpecialKeySpaceRobustnessWorkload> SpecialKeySpaceRobustnessFactory;
