#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
/*
 * Backup.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2025 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ReadYourWrites.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BackupContainerFileSystem.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/IRandom.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// A workload which only performs backup operations. A separate workload is used to perform restore operations.
struct BackupWorkload : TestWorkload {
	static constexpr auto NAME = "Backup";
	double backupAfter, restoreAfter, abortAndRestartAfter;
	double minBackupAfter;
	double backupStartAt, restoreStartAfterBackupFinished, stopDifferentialAfter;
	Key backupTag;
	bool differentialBackup;
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
	LockDB locked{ false };
	UsePartitionedLog usePartitionedLog{ true };
	bool allowPauses;
	Optional<std::string> encryptionKeyFileName;

	BackupWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		locked.set(sharedRandomNumber % 2);
		bool partitioned = getOption(options, "usePartitionedLog"_sr, true);
		usePartitionedLog.set(partitioned);
		backupAfter = getOption(options, "backupAfter"_sr, 10.0);
		double minBackupAfter = getOption(options, "minBackupAfter"_sr, backupAfter);
		if (backupAfter > minBackupAfter) {
			backupAfter = deterministicRandom()->random01() * (backupAfter - minBackupAfter) + minBackupAfter;
		}
		restoreAfter = getOption(options, "restoreAfter"_sr, 35.0);
		backupTag = getOption(options, "backupTag"_sr, BackupAgentBase::getDefaultTag());
		abortAndRestartAfter =
		    getOption(options,
		              "abortAndRestartAfter"_sr,
		              deterministicRandom()->random01() < 0.5
		                  ? deterministicRandom()->random01() * (restoreAfter - backupAfter) + backupAfter
		                  : 0.0);
		differentialBackup =
		    getOption(options, "differentialBackup"_sr, deterministicRandom()->random01() < 0.5 ? true : false);
		stopDifferentialAfter =
		    getOption(options,
		              "stopDifferentialAfter"_sr,
		              differentialBackup ? deterministicRandom()->random01() *
		                                           (restoreAfter - std::max(abortAndRestartAfter, backupAfter)) +
		                                       std::max(abortAndRestartAfter, backupAfter)
		                                 : 0.0);
		allowPauses = getOption(options, "allowPauses"_sr, true);

		std::vector<std::string> restorePrefixesToInclude =
		    getOption(options, "restorePrefixesToInclude"_sr, std::vector<std::string>());

		if (getOption(options, "encrypted"_sr, deterministicRandom()->random01() < 0.5)) {
			encryptionKeyFileName = "simfdb/" + getTestEncryptionFileName();
		}

		TraceEvent("BW_ClientId").detail("Id", wcx.clientId);
		backupRanges.push_back_deep(backupRanges.arena(), normalKeys);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();

		TraceEvent(SevInfo, "BW_Param")
		    .detail("Locked", locked)
		    .detail("BackupAfter", backupAfter)
		    .detail("RestoreAfter", restoreAfter)
		    .detail("BackupTag", printable(backupTag).c_str())
		    .detail("AbortAndRestartAfter", abortAndRestartAfter)
		    .detail("DifferentialBackup", differentialBackup)
		    .detail("StopDifferentialAfter", stopDifferentialAfter)
		    .detail("Encrypted", encryptionKeyFileName.present());

		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 110 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
// This generated class is to be used only via changePaused()
															#line 108 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
template <class ChangePausedActor>
															#line 108 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
class ChangePausedActorState {
															#line 116 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
public:
															#line 108 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	ChangePausedActorState(Database const& cx,FileBackupAgent* const& backupAgent) 
															#line 108 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
															#line 108 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		 : cx(cx),
															#line 108 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		   backupAgent(backupAgent)
															#line 125 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
	{
		fdb_probe_actor_create("changePaused", reinterpret_cast<unsigned long>(this));

	}
	~ChangePausedActorState() 
	{
		fdb_probe_actor_destroy("changePaused", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 109 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			;
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangePausedActorState();
		static_cast<ChangePausedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 110 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<Void> __when_expr_0 = backupAgent->changePause(cx, true);
															#line 110 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 172 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 1;
															#line 110 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 0, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 177 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 111 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_AgentPaused").log();
															#line 112 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(30 * deterministicRandom()->random01());
															#line 112 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 190 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 2;
															#line 112 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 1, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 195 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 111 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_AgentPaused").log();
															#line 112 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(30 * deterministicRandom()->random01());
															#line 112 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 208 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 2;
															#line 112 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 1, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 213 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 113 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<Void> __when_expr_2 = backupAgent->changePause(cx, false);
															#line 113 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 299 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 3;
															#line 113 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 2, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 304 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 113 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<Void> __when_expr_2 = backupAgent->changePause(cx, false);
															#line 113 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 315 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 3;
															#line 113 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 2, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 320 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 114 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_AgentResumed").log();
															#line 115 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(120 * deterministicRandom()->random01());
															#line 115 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 408 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 4;
															#line 115 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 3, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 413 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 114 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_AgentResumed").log();
															#line 115 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(120 * deterministicRandom()->random01());
															#line 115 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 426 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 4;
															#line 115 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 3, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 431 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 108 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	Database cx;
															#line 108 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 602 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
};
// This generated class is to be used only via changePaused()
															#line 108 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
class ChangePausedActor final : public Actor<Void>, public ActorCallback< ChangePausedActor, 0, Void >, public ActorCallback< ChangePausedActor, 1, Void >, public ActorCallback< ChangePausedActor, 2, Void >, public ActorCallback< ChangePausedActor, 3, Void >, public FastAllocated<ChangePausedActor>, public ChangePausedActorState<ChangePausedActor> {
															#line 607 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
public:
	using FastAllocated<ChangePausedActor>::operator new;
	using FastAllocated<ChangePausedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2914002293864534784UL, 14750507073448495616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangePausedActor, 0, Void >;
friend struct ActorCallback< ChangePausedActor, 1, Void >;
friend struct ActorCallback< ChangePausedActor, 2, Void >;
friend struct ActorCallback< ChangePausedActor, 3, Void >;
															#line 108 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	ChangePausedActor(Database const& cx,FileBackupAgent* const& backupAgent) 
															#line 627 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		 : Actor<Void>(),
		   ChangePausedActorState<ChangePausedActor>(cx, backupAgent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5431177707453768448UL, 12966551901980677120UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changePaused");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangePausedActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangePausedActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangePausedActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangePausedActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 108 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
[[nodiscard]] static Future<Void> changePaused( Database const& cx, FileBackupAgent* const& backupAgent ) {
															#line 108 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	return Future<Void>(new ChangePausedActor(cx, backupAgent));
															#line 662 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
}

#line 118 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"

	// Resume the backup agent if it is paused
																#line 668 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
// This generated class is to be used only via resumeAgent()
															#line 120 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
template <class ResumeAgentActor>
															#line 120 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
class ResumeAgentActorState {
															#line 674 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
public:
															#line 120 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	ResumeAgentActorState(Database const& cx,FileBackupAgent* const& backupAgent) 
															#line 120 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
															#line 120 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		 : cx(cx),
															#line 120 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		   backupAgent(backupAgent)
															#line 683 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
	{
		fdb_probe_actor_create("resumeAgent", reinterpret_cast<unsigned long>(this));

	}
	~ResumeAgentActorState() 
	{
		fdb_probe_actor_destroy("resumeAgent", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 121 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			TraceEvent("BW_AgentResuming").log();
															#line 122 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			StrictFuture<Void> __when_expr_0 = backupAgent->changePause(cx, false);
															#line 122 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (static_cast<ResumeAgentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 702 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ResumeAgentActor*>(this)->actor_wait_state = 1;
															#line 122 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ResumeAgentActor, 0, Void >*>(static_cast<ResumeAgentActor*>(this)));
															#line 707 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ResumeAgentActorState();
		static_cast<ResumeAgentActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_AgentResumed").log();
															#line 124 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (!static_cast<ResumeAgentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResumeAgentActorState(); static_cast<ResumeAgentActor*>(this)->destroy(); return 0; }
															#line 732 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		new (&static_cast<ResumeAgentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResumeAgentActorState();
		static_cast<ResumeAgentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_AgentResumed").log();
															#line 124 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (!static_cast<ResumeAgentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResumeAgentActorState(); static_cast<ResumeAgentActor*>(this)->destroy(); return 0; }
															#line 746 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		new (&static_cast<ResumeAgentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResumeAgentActorState();
		static_cast<ResumeAgentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ResumeAgentActor*>(this)->actor_wait_state > 0) static_cast<ResumeAgentActor*>(this)->actor_wait_state = 0;
		static_cast<ResumeAgentActor*>(this)->ActorCallback< ResumeAgentActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResumeAgentActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resumeAgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResumeAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resumeAgent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResumeAgentActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resumeAgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResumeAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resumeAgent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ResumeAgentActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resumeAgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResumeAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resumeAgent", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 120 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	Database cx;
															#line 120 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 833 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
};
// This generated class is to be used only via resumeAgent()
															#line 120 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
class ResumeAgentActor final : public Actor<Void>, public ActorCallback< ResumeAgentActor, 0, Void >, public FastAllocated<ResumeAgentActor>, public ResumeAgentActorState<ResumeAgentActor> {
															#line 838 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
public:
	using FastAllocated<ResumeAgentActor>::operator new;
	using FastAllocated<ResumeAgentActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16658401289212388096UL, 5750217188679516672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ResumeAgentActor, 0, Void >;
															#line 120 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	ResumeAgentActor(Database const& cx,FileBackupAgent* const& backupAgent) 
															#line 855 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		 : Actor<Void>(),
		   ResumeAgentActorState<ResumeAgentActor>(cx, backupAgent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("resumeAgent", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(235103107035615488UL, 11787397912531345664UL);
		ActorExecutionContextHelper __helper(static_cast<ResumeAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("resumeAgent");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("resumeAgent", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ResumeAgentActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 120 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
[[nodiscard]] static Future<Void> resumeAgent( Database const& cx, FileBackupAgent* const& backupAgent ) {
															#line 120 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	return Future<Void>(new ResumeAgentActor(cx, backupAgent));
															#line 887 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
}

#line 126 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"

																#line 892 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
// This generated class is to be used only via statusLoop()
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
template <class StatusLoopActor>
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
class StatusLoopActorState {
															#line 898 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
public:
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	StatusLoopActorState(Database const& cx,std::string const& tag) 
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		 : cx(cx),
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		   tag(tag),
															#line 128 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		   agent()
															#line 909 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
	{
		fdb_probe_actor_create("statusLoop", reinterpret_cast<unsigned long>(this));

	}
	~StatusLoopActorState() 
	{
		fdb_probe_actor_destroy("statusLoop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 129 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			;
															#line 924 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StatusLoopActorState();
		static_cast<StatusLoopActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 130 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<bool> __when_expr_0 = agent.checkActive(cx);
															#line 130 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 956 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 1;
															#line 130 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 0, bool >*>(static_cast<StatusLoopActor*>(this)));
															#line 961 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool const& active,int loopDepth) 
	{
															#line 131 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_AgentActivityCheck").detail("IsActive", active);
															#line 132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = agent.getStatus(cx, ShowErrors::True, tag);
															#line 132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 974 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 2;
															#line 132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 1, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 979 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool && active,int loopDepth) 
	{
															#line 131 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_AgentActivityCheck").detail("IsActive", active);
															#line 132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = agent.getStatus(cx, ShowErrors::True, tag);
															#line 132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 992 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 2;
															#line 132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 1, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 997 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& active,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(active, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && active,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(active), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(std::string const& status,int loopDepth) 
	{
															#line 133 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		puts(status.c_str());
															#line 134 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = agent.getStatusJSON(cx, tag);
															#line 134 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1085 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 3;
															#line 134 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 2, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 1090 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::string && status,int loopDepth) 
	{
															#line 133 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		puts(status.c_str());
															#line 134 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = agent.getStatusJSON(cx, tag);
															#line 134 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1103 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 3;
															#line 134 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 2, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 1108 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::string const& status,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(status, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::string && status,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(std::string const& statusJSON,int loopDepth) 
	{
															#line 135 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		puts(statusJSON.c_str());
															#line 136 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(2.0);
															#line 136 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1196 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 4;
															#line 136 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 3, Void >*>(static_cast<StatusLoopActor*>(this)));
															#line 1201 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::string && statusJSON,int loopDepth) 
	{
															#line 135 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		puts(statusJSON.c_str());
															#line 136 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(2.0);
															#line 136 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1214 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 4;
															#line 136 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 3, Void >*>(static_cast<StatusLoopActor*>(this)));
															#line 1219 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::string const& statusJSON,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(statusJSON, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::string && statusJSON,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(statusJSON), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	Database cx;
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	std::string tag;
															#line 128 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	FileBackupAgent agent;
															#line 1392 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
};
// This generated class is to be used only via statusLoop()
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
class StatusLoopActor final : public Actor<Void>, public ActorCallback< StatusLoopActor, 0, bool >, public ActorCallback< StatusLoopActor, 1, std::string >, public ActorCallback< StatusLoopActor, 2, std::string >, public ActorCallback< StatusLoopActor, 3, Void >, public FastAllocated<StatusLoopActor>, public StatusLoopActorState<StatusLoopActor> {
															#line 1397 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
public:
	using FastAllocated<StatusLoopActor>::operator new;
	using FastAllocated<StatusLoopActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5687847172745265920UL, 8166849706756986624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StatusLoopActor, 0, bool >;
friend struct ActorCallback< StatusLoopActor, 1, std::string >;
friend struct ActorCallback< StatusLoopActor, 2, std::string >;
friend struct ActorCallback< StatusLoopActor, 3, Void >;
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	StatusLoopActor(Database const& cx,std::string const& tag) 
															#line 1417 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		 : Actor<Void>(),
		   StatusLoopActorState<StatusLoopActor>(cx, tag),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1858547908313483776UL, 2242404897950274816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("statusLoop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StatusLoopActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StatusLoopActor, 1, std::string >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StatusLoopActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StatusLoopActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
[[nodiscard]] static Future<Void> statusLoop( Database const& cx, std::string const& tag ) {
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	return Future<Void>(new StatusLoopActor(cx, tag));
															#line 1452 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
}

#line 139 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"

																#line 1457 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
// This generated class is to be used only via doBackup()
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
template <class DoBackupActor>
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
class DoBackupActorState {
															#line 1463 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
public:
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	DoBackupActorState(BackupWorkload* const& self,double const& startDelay,FileBackupAgent* const& backupAgent,Database const& cx,Key const& tag,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,double const& stopDifferentialDelay) 
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		 : self(self),
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		   startDelay(startDelay),
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		   backupAgent(backupAgent),
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		   cx(cx),
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		   tag(tag),
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		   backupRanges(backupRanges),
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		   stopDifferentialDelay(stopDifferentialDelay),
															#line 148 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		   randomID(nondeterministicRandom()->randomUniqueID()),
															#line 150 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		   stopDifferentialFuture(delay(stopDifferentialDelay))
															#line 1486 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
	{
		fdb_probe_actor_create("doBackup", reinterpret_cast<unsigned long>(this));

	}
	~DoBackupActorState() 
	{
		fdb_probe_actor_destroy("doBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 151 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(startDelay);
															#line 151 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1503 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 1;
															#line 151 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 0, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1508 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 153 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (startDelay || BUGGIFY)
															#line 1531 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		{
															#line 154 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			TraceEvent("BW_DoBackupAbortBackup1", randomID) .detail("Tag", printable(tag)) .detail("StartDelay", startDelay);
															#line 1535 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			try {
															#line 159 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				StrictFuture<Void> __when_expr_1 = backupAgent->abortBackup(cx, tag.toString());
															#line 159 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1541 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 159 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1546 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 153 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (startDelay || BUGGIFY)
															#line 1566 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		{
															#line 154 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			TraceEvent("BW_DoBackupAbortBackup1", randomID) .detail("Tag", printable(tag)) .detail("StartDelay", startDelay);
															#line 1570 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			try {
															#line 159 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				StrictFuture<Void> __when_expr_1 = backupAgent->abortBackup(cx, tag.toString());
															#line 159 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1576 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 159 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1581 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 167 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_DoBackupSubmitBackup", randomID) .detail("Tag", printable(tag)) .detail("StopWhenDone", stopDifferentialDelay ? "False" : "True");
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		backupContainer = "file://simfdb/backups/";
															#line 172 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		status = statusLoop(cx, tag.toString());
															#line 1680 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		try {
															#line 174 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			StrictFuture<Void> __when_expr_2 = backupAgent->submitBackup(cx, StringRef(backupContainer), {}, deterministicRandom()->randomInt(0, 60), deterministicRandom()->randomInt(0, 2000), tag.toString(), backupRanges, false, StopWhenDone{ !stopDifferentialDelay }, self->usePartitionedLog, IncrementalBackupOnly::False, self->encryptionKeyFileName);
															#line 174 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 1686 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 3;
															#line 174 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 2, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1691 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 161 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			TraceEvent("BW_DoBackupAbortBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 162 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (e.code() != error_code_backup_unneeded)
															#line 1715 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			{
															#line 163 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1719 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
															#line 193 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (stopDifferentialDelay)
															#line 1835 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		{
															#line 194 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			CODE_PROBE(!stopDifferentialFuture.isReady(), "Restore starts at specified time - stopDifferential not ready");
															#line 196 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			StrictFuture<Void> __when_expr_3 = stopDifferentialFuture;
															#line 196 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1843 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 4;
															#line 196 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 3, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1848 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 187 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			TraceEvent("BW_DoBackupSubmitBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 188 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 1865 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			{
															#line 189 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1869 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			}
			loopDepth = a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 290 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_DoBackupWaitBackup", randomID).detail("Tag", printable(tag));
															#line 291 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<EBackupState> __when_expr_10 = backupAgent->waitBackup(cx, tag.toString(), StopWhenDone::True);
															#line 291 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1989 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont9when1(__when_expr_10.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 11;
															#line 291 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 10, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 1994 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 197 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_DoBackupWaitToDiscontinue", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 2003 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		try {
															#line 202 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (BUGGIFY)
															#line 2007 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			{
															#line 203 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				backupTag = makeBackupTag(tag.toString());
															#line 204 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				TraceEvent("BW_DoBackupWaitForRestorable", randomID).detail("Tag", backupTag.tagName);
															#line 207 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				lastBackupContainer = Reference<IBackupContainer>();
															#line 208 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				lastBackupUID = UID();
															#line 209 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				StrictFuture<EBackupState> __when_expr_4 = backupAgent->waitBackup( cx, backupTag.tagName, StopWhenDone::False, &lastBackupContainer, &lastBackupUID);
															#line 209 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2021 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont10Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10when1(__when_expr_4.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 5;
															#line 209 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 4, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 2026 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 277 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				TraceEvent("BW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 280 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				StrictFuture<Void> __when_expr_9 = backupAgent->discontinueBackup(cx, tag);
															#line 280 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2037 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont10Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when2(__when_expr_9.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 10;
															#line 280 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 9, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2042 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont10Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 197 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_DoBackupWaitToDiscontinue", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 2058 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		try {
															#line 202 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (BUGGIFY)
															#line 2062 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			{
															#line 203 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				backupTag = makeBackupTag(tag.toString());
															#line 204 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				TraceEvent("BW_DoBackupWaitForRestorable", randomID).detail("Tag", backupTag.tagName);
															#line 207 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				lastBackupContainer = Reference<IBackupContainer>();
															#line 208 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				lastBackupUID = UID();
															#line 209 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				StrictFuture<EBackupState> __when_expr_4 = backupAgent->waitBackup( cx, backupTag.tagName, StopWhenDone::False, &lastBackupContainer, &lastBackupUID);
															#line 209 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2076 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont10Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10when1(__when_expr_4.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 5;
															#line 209 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 4, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 2081 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 277 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				TraceEvent("BW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 280 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				StrictFuture<Void> __when_expr_9 = backupAgent->discontinueBackup(cx, tag);
															#line 280 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2092 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont10Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when2(__when_expr_9.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 10;
															#line 280 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 9, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2097 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont10Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 283 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			TraceEvent("BW_DoBackupDiscontinueBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 284 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 2197 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			{
															#line 285 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2201 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			}
			loopDepth = a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont2(int loopDepth) 
	{
		loopDepth = a_body1cont10cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3(int loopDepth) 
	{
															#line 212 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_DoBackupWaitForRestorable", randomID) .detail("Tag", backupTag.tagName) .detail("Result", BackupAgentBase::getStateText(resultWait));
															#line 216 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		restorable = false;
															#line 217 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (lastBackupContainer)
															#line 2227 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		{
															#line 218 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			fdesc = lastBackupContainer->describeBackup();
															#line 219 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			StrictFuture<Void> __when_expr_5 = ready(fdesc);
															#line 219 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2235 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont10Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_5.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 6;
															#line 219 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 5, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2240 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10when1(EBackupState const& __resultWait,int loopDepth) 
	{
															#line 209 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		resultWait = __resultWait;
															#line 2254 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = a_body1cont10cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(EBackupState && __resultWait,int loopDepth) 
	{
		resultWait = std::move(__resultWait);
		loopDepth = a_body1cont10cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 4, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 4, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 4, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 4, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10cont4(int loopDepth) 
	{
															#line 229 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_LastBackupContainer", randomID) .detail("BackupTag", printable(tag)) .detail("LastBackupContainer", lastBackupContainer ? lastBackupContainer->getURL() : "") .detail("LastBackupUID", lastBackupUID) .detail("WaitStatus", BackupAgentBase::getStateText(resultWait)) .detail("Restorable", restorable);
															#line 237 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (resultWait == EBackupState::STATE_ABORTED)
															#line 2335 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		{
		}
		else
		{
															#line 240 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (!lastBackupContainer)
															#line 2342 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			{
															#line 241 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				TraceEvent(SevError, "BW_MissingBackupContainer", randomID) .detail("LastBackupUID", lastBackupUID) .detail("BackupTag", printable(tag)) .detail("WaitStatus", BackupAgentBase::getStateText(resultWait));
															#line 245 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				printf("BackupCorrectnessMissingBackupContainer   tag: %s  status: %s\n", printable(tag).c_str(), BackupAgentBase::getStateText(resultWait));
															#line 2348 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			}
			else
			{
															#line 250 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				if (!restorable)
															#line 2354 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
				{
															#line 251 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
					TraceEvent(SevError, "BW_NotRestorable", randomID) .detail("LastBackupUID", lastBackupUID) .detail("BackupTag", printable(tag)) .detail("BackupFolder", lastBackupContainer->getURL()) .detail("WaitStatus", BackupAgentBase::getStateText(resultWait));
															#line 256 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
					printf("BackupCorrectnessNotRestorable:  tag: %s\n", printable(tag).c_str());
															#line 2360 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
				}
			}
		}
															#line 261 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (startDelay)
															#line 2366 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		{
															#line 262 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			TraceEvent("BW_DoBackupAbortBackup2", randomID) .detail("Tag", printable(tag)) .detail("WaitStatus", BackupAgentBase::getStateText(resultWait)) .detail("LastBackupContainer", lastBackupContainer ? lastBackupContainer->getURL() : "") .detail("Restorable", restorable);
															#line 267 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			StrictFuture<Void> __when_expr_7 = backupAgent->abortBackup(cx, tag.toString());
															#line 267 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2374 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont10Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont10cont4when1(__when_expr_7.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 8;
															#line 267 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 7, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2379 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 269 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			TraceEvent("BW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 272 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			StrictFuture<Void> __when_expr_8 = backupAgent->discontinueBackup(cx, tag);
															#line 272 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2390 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont10Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10cont4when2(__when_expr_8.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 9;
															#line 272 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 8, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2395 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont5(Void const& _,int loopDepth) 
	{
															#line 221 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (!fdesc.isError())
															#line 2405 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		{
															#line 222 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			desc = fdesc.get();
															#line 223 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			StrictFuture<Void> __when_expr_6 = desc.resolveVersionTimes(cx);
															#line 223 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2413 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont10Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont5when1(__when_expr_6.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 7;
															#line 223 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 6, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2418 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont5(Void && _,int loopDepth) 
	{
															#line 221 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (!fdesc.isError())
															#line 2432 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		{
															#line 222 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			desc = fdesc.get();
															#line 223 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			StrictFuture<Void> __when_expr_6 = desc.resolveVersionTimes(cx);
															#line 223 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2440 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont10Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont5when1(__when_expr_6.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 7;
															#line 223 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 6, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2445 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10cont6(int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont7(Void const& _,int loopDepth) 
	{
															#line 224 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		printf("BackupDescription:\n%s\n", desc.toString().c_str());
															#line 225 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		restorable = desc.maxRestorableVersion.present();
															#line 2542 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = a_body1cont10cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont7(Void && _,int loopDepth) 
	{
															#line 224 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		printf("BackupDescription:\n%s\n", desc.toString().c_str());
															#line 225 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		restorable = desc.maxRestorableVersion.present();
															#line 2553 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = a_body1cont10cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10cont9(int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont15(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont15(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont15(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont15(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont4when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont4when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont16(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont16(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont17(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
															#line 293 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<std::string> __when_expr_11 = backupAgent->getStatus(cx, ShowErrors::True, tag.toString());
															#line 293 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2919 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont11when1(__when_expr_11.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 12;
															#line 293 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 11, std::string >*>(static_cast<DoBackupActor*>(this)));
															#line 2924 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(EBackupState const& __statusValue,int loopDepth) 
	{
															#line 291 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		statusValue = __statusValue;
															#line 2933 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(EBackupState && __statusValue,int loopDepth) 
	{
		statusValue = std::move(__statusValue);
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 10, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 10, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 10, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 10, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont11cont1(std::string const& statusText,int loopDepth) 
	{
															#line 296 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_DoBackupComplete", randomID) .detail("Tag", printable(tag)) .detail("Status", statusText) .detail("StatusValue", BackupAgentBase::getStateText(statusValue));
															#line 301 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 3014 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11cont1(std::string && statusText,int loopDepth) 
	{
															#line 296 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_DoBackupComplete", randomID) .detail("Tag", printable(tag)) .detail("Status", statusText) .detail("StatusValue", BackupAgentBase::getStateText(statusValue));
															#line 301 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 3028 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11when1(std::string const& statusText,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(statusText, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(std::string && statusText,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(statusText), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 11, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 11, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 11, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 11, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	BackupWorkload* self;
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	double startDelay;
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	Database cx;
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	Key tag;
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	double stopDifferentialDelay;
															#line 148 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	UID randomID;
															#line 150 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	Future<Void> stopDifferentialFuture;
															#line 171 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	std::string backupContainer;
															#line 172 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	Future<Void> status;
															#line 203 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	KeyBackedTag backupTag;
															#line 207 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	Reference<IBackupContainer> lastBackupContainer;
															#line 208 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	UID lastBackupUID;
															#line 209 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	EBackupState resultWait;
															#line 216 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	bool restorable;
															#line 218 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	Future<BackupDescription> fdesc;
															#line 222 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	BackupDescription desc;
															#line 291 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	EBackupState statusValue;
															#line 3149 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
};
// This generated class is to be used only via doBackup()
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
class DoBackupActor final : public Actor<Void>, public ActorCallback< DoBackupActor, 0, Void >, public ActorCallback< DoBackupActor, 1, Void >, public ActorCallback< DoBackupActor, 2, Void >, public ActorCallback< DoBackupActor, 3, Void >, public ActorCallback< DoBackupActor, 4, EBackupState >, public ActorCallback< DoBackupActor, 5, Void >, public ActorCallback< DoBackupActor, 6, Void >, public ActorCallback< DoBackupActor, 7, Void >, public ActorCallback< DoBackupActor, 8, Void >, public ActorCallback< DoBackupActor, 9, Void >, public ActorCallback< DoBackupActor, 10, EBackupState >, public ActorCallback< DoBackupActor, 11, std::string >, public FastAllocated<DoBackupActor>, public DoBackupActorState<DoBackupActor> {
															#line 3154 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
public:
	using FastAllocated<DoBackupActor>::operator new;
	using FastAllocated<DoBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(683413839877953792UL, 8294404465581713920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoBackupActor, 0, Void >;
friend struct ActorCallback< DoBackupActor, 1, Void >;
friend struct ActorCallback< DoBackupActor, 2, Void >;
friend struct ActorCallback< DoBackupActor, 3, Void >;
friend struct ActorCallback< DoBackupActor, 4, EBackupState >;
friend struct ActorCallback< DoBackupActor, 5, Void >;
friend struct ActorCallback< DoBackupActor, 6, Void >;
friend struct ActorCallback< DoBackupActor, 7, Void >;
friend struct ActorCallback< DoBackupActor, 8, Void >;
friend struct ActorCallback< DoBackupActor, 9, Void >;
friend struct ActorCallback< DoBackupActor, 10, EBackupState >;
friend struct ActorCallback< DoBackupActor, 11, std::string >;
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	DoBackupActor(BackupWorkload* const& self,double const& startDelay,FileBackupAgent* const& backupAgent,Database const& cx,Key const& tag,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,double const& stopDifferentialDelay) 
															#line 3182 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		 : Actor<Void>(),
		   DoBackupActorState<DoBackupActor>(self, startDelay, backupAgent, cx, tag, backupRanges, stopDifferentialDelay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15925328432552866816UL, 11115638302355080704UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoBackupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoBackupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoBackupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoBackupActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DoBackupActor, 4, EBackupState >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DoBackupActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DoBackupActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< DoBackupActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< DoBackupActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< DoBackupActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< DoBackupActor, 10, EBackupState >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< DoBackupActor, 11, std::string >*)0, actor_cancelled()); break;
		}

	}
};
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
[[nodiscard]] static Future<Void> doBackup( BackupWorkload* const& self, double const& startDelay, FileBackupAgent* const& backupAgent, Database const& cx, Key const& tag, Standalone<VectorRef<KeyRangeRef>> const& backupRanges, double const& stopDifferentialDelay ) {
															#line 140 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	return Future<Void>(new DoBackupActor(self, startDelay, backupAgent, cx, tag, backupRanges, stopDifferentialDelay));
															#line 3225 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
}

#line 303 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"

																#line 3230 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 304 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
template <class _startActor>
															#line 304 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
class _startActorState {
															#line 3236 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
public:
															#line 304 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	_startActorState(Database const& cx,BackupWorkload* const& self) 
															#line 304 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
															#line 304 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		 : cx(cx),
															#line 304 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		   self(self),
															#line 305 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		   backupAgent(),
															#line 306 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		   cp()
															#line 3249 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 307 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			TraceEvent("BW_Arguments") .detail("BackupTag", printable(self->backupTag)) .detail("BackupAfter", self->backupAfter) .detail("RestoreAfter", self->restoreAfter) .detail("AbortAndRestartAfter", self->abortAndRestartAfter) .detail("DifferentialAfter", self->stopDifferentialAfter);
															#line 314 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			randomID = nondeterministicRandom()->randomUniqueID();
															#line 315 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (self->allowPauses && BUGGIFY)
															#line 3268 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			{
															#line 316 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				cp = changePaused(cx, &backupAgent);
															#line 3272 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			}
			else
			{
															#line 318 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				cp = resumeAgent(cx, &backupAgent);
															#line 3278 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			}
															#line 321 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (self->encryptionKeyFileName.present())
															#line 3282 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			{
															#line 322 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				StrictFuture<Void> __when_expr_0 = BackupContainerFileSystem::createTestEncryptionKeyFile(self->encryptionKeyFileName.get());
															#line 322 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3288 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 322 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 3293 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		try {
															#line 326 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			startRestore = delay(self->restoreAfter);
															#line 329 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(self->backupAfter);
															#line 329 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3326 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 329 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 3331 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 357 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3433 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 354 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			TraceEvent(SevError, "BackupCorrectness").error(e).GetLastError();
															#line 355 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 3448 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 331 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_DoBackup1", randomID).detail("Tag", printable(self->backupTag));
															#line 332 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		b = doBackup(self, 0, &backupAgent, cx, self->backupTag, self->backupRanges, self->stopDifferentialAfter);
															#line 335 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_DoBackupWait", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("AbortAndRestartAfter", self->abortAndRestartAfter);
															#line 3466 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		try {
															#line 339 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			StrictFuture<Void> __when_expr_2 = b;
															#line 339 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont6Catch1(actor_cancelled(), loopDepth);
															#line 3472 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont6Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont6when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 339 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 3477 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 331 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_DoBackup1", randomID).detail("Tag", printable(self->backupTag));
															#line 332 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		b = doBackup(self, 0, &backupAgent, cx, self->backupTag, self->backupRanges, self->stopDifferentialAfter);
															#line 335 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_DoBackupWait", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("AbortAndRestartAfter", self->abortAndRestartAfter);
															#line 3496 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		try {
															#line 339 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			StrictFuture<Void> __when_expr_2 = b;
															#line 339 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont6Catch1(actor_cancelled(), loopDepth);
															#line 3502 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont6Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont6when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 339 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 3507 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 345 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		TraceEvent("BW_DoBackupDone", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("AbortAndRestartAfter", self->abortAndRestartAfter);
															#line 349 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		StrictFuture<Void> __when_expr_3 = startRestore;
															#line 349 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3601 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 349 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 3606 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 341 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (e.code() != error_code_database_locked)
															#line 3616 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			{
															#line 342 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
				return a_body1cont1Catch1(e, loopDepth);
															#line 3620 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			}
															#line 343 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3624 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 304 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	Database cx;
															#line 304 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	BackupWorkload* self;
															#line 305 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	FileBackupAgent backupAgent;
															#line 306 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	Future<Void> cp;
															#line 314 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	UID randomID;
															#line 326 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	Future<Void> startRestore;
															#line 332 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	Future<Void> b;
															#line 3852 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 304 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 3857 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18174825700958944256UL, 9872351890948245248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
															#line 304 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	_startActor(Database const& cx,BackupWorkload* const& self) 
															#line 3877 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 304 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, BackupWorkload* const& self ) {
															#line 304 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 3912 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Backup.actor.g.cpp"
}

#line 359 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbserver/workloads/Backup.actor.cpp"
};

WorkloadFactory<BackupWorkload> BackupWorkloadFactory;
