#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
/*
 * ClusterConnectionKey.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ClusterConnectionKey.actor.h"
#include "flow/actorcompiler.h" // has to be last include

// Creates a cluster connection record with a given connection string and saves it to the specified key. Needs to be
// persisted should be set to true unless this ClusterConnectionKey is being created with the value read from the
// key.
ClusterConnectionKey::ClusterConnectionKey(Database db,
                                           Key connectionStringKey,
                                           ClusterConnectionString const& contents,
                                           ConnectionStringNeedsPersisted needsToBePersisted)
  : IClusterConnectionRecord(needsToBePersisted), db(db), connectionStringKey(connectionStringKey) {
	if (!needsToBePersisted) {
		lastPersistedConnectionString = ValueRef(contents.toString());
	}
	cs = contents;
}

// Loads and parses the connection string at the specified key, throwing errors if the file cannot be read or the
// format is invalid.
															#line 42 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
// This generated class is to be used only via loadClusterConnectionKey()
															#line 40 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
template <class ClusterConnectionKey_LoadClusterConnectionKeyActor>
															#line 40 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
class ClusterConnectionKey_LoadClusterConnectionKeyActorState {
															#line 48 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
public:
															#line 40 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	ClusterConnectionKey_LoadClusterConnectionKeyActorState(Database const& db,Key const& connectionStringKey) 
															#line 40 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
															#line 40 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		 : db(db),
															#line 40 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		   connectionStringKey(connectionStringKey),
															#line 42 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		   tr(db)
															#line 59 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
	{
		fdb_probe_actor_create("loadClusterConnectionKey", reinterpret_cast<unsigned long>(this));

	}
	~ClusterConnectionKey_LoadClusterConnectionKeyActorState() 
	{
		fdb_probe_actor_destroy("loadClusterConnectionKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 43 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			;
															#line 74 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterConnectionKey_LoadClusterConnectionKeyActorState();
		static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 45 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(connectionStringKey);
															#line 45 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			if (static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 107 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->actor_wait_state = 1;
															#line 45 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterConnectionKey_LoadClusterConnectionKeyActor, 0, Optional<Value> >*>(static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)));
															#line 112 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 54 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 54 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			if (static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 136 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->actor_wait_state = 2;
															#line 54 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterConnectionKey_LoadClusterConnectionKeyActor, 1, Void >*>(static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)));
															#line 141 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& v,int loopDepth) 
	{
															#line 46 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		if (!v.present())
															#line 156 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		{
															#line 47 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			return a_body1loopBody1Catch1(connection_string_invalid(), loopDepth);
															#line 160 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		}
															#line 49 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		if (!static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->SAV<Reference<ClusterConnectionKey>>::futures) { (void)(makeReference<ClusterConnectionKey>(db, connectionStringKey, ClusterConnectionString(v.get().toString()), ConnectionStringNeedsPersisted::False)); this->~ClusterConnectionKey_LoadClusterConnectionKeyActorState(); static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->destroy(); return 0; }
															#line 164 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		new (&static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->SAV< Reference<ClusterConnectionKey> >::value()) Reference<ClusterConnectionKey>(makeReference<ClusterConnectionKey>(db, connectionStringKey, ClusterConnectionString(v.get().toString()), ConnectionStringNeedsPersisted::False));
		this->~ClusterConnectionKey_LoadClusterConnectionKeyActorState();
		static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && v,int loopDepth) 
	{
															#line 46 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		if (!v.present())
															#line 176 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		{
															#line 47 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			return a_body1loopBody1Catch1(connection_string_invalid(), loopDepth);
															#line 180 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		}
															#line 49 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		if (!static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->SAV<Reference<ClusterConnectionKey>>::futures) { (void)(makeReference<ClusterConnectionKey>(db, connectionStringKey, ClusterConnectionString(v.get().toString()), ConnectionStringNeedsPersisted::False)); this->~ClusterConnectionKey_LoadClusterConnectionKeyActorState(); static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->destroy(); return 0; }
															#line 184 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		new (&static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->SAV< Reference<ClusterConnectionKey> >::value()) Reference<ClusterConnectionKey>(makeReference<ClusterConnectionKey>(db, connectionStringKey, ClusterConnectionString(v.get().toString()), ConnectionStringNeedsPersisted::False));
		this->~ClusterConnectionKey_LoadClusterConnectionKeyActorState();
		static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->actor_wait_state > 0) static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->ActorCallback< ClusterConnectionKey_LoadClusterConnectionKeyActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterConnectionKey_LoadClusterConnectionKeyActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("loadClusterConnectionKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadClusterConnectionKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterConnectionKey_LoadClusterConnectionKeyActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("loadClusterConnectionKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadClusterConnectionKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterConnectionKey_LoadClusterConnectionKeyActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("loadClusterConnectionKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadClusterConnectionKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->actor_wait_state > 0) static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->ActorCallback< ClusterConnectionKey_LoadClusterConnectionKeyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterConnectionKey_LoadClusterConnectionKeyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadClusterConnectionKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadClusterConnectionKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterConnectionKey_LoadClusterConnectionKeyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadClusterConnectionKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadClusterConnectionKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterConnectionKey_LoadClusterConnectionKeyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadClusterConnectionKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadClusterConnectionKey", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 40 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	Database db;
															#line 40 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	Key connectionStringKey;
															#line 42 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	Transaction tr;
															#line 360 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
};
// This generated class is to be used only via loadClusterConnectionKey()
															#line 40 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
class ClusterConnectionKey_LoadClusterConnectionKeyActor final : public Actor<Reference<ClusterConnectionKey>>, public ActorCallback< ClusterConnectionKey_LoadClusterConnectionKeyActor, 0, Optional<Value> >, public ActorCallback< ClusterConnectionKey_LoadClusterConnectionKeyActor, 1, Void >, public FastAllocated<ClusterConnectionKey_LoadClusterConnectionKeyActor>, public ClusterConnectionKey_LoadClusterConnectionKeyActorState<ClusterConnectionKey_LoadClusterConnectionKeyActor> {
															#line 365 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
public:
	using FastAllocated<ClusterConnectionKey_LoadClusterConnectionKeyActor>::operator new;
	using FastAllocated<ClusterConnectionKey_LoadClusterConnectionKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14817532308006431488UL, 18238745673755591168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<ClusterConnectionKey>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterConnectionKey_LoadClusterConnectionKeyActor, 0, Optional<Value> >;
friend struct ActorCallback< ClusterConnectionKey_LoadClusterConnectionKeyActor, 1, Void >;
															#line 40 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	ClusterConnectionKey_LoadClusterConnectionKeyActor(Database const& db,Key const& connectionStringKey) 
															#line 383 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		 : Actor<Reference<ClusterConnectionKey>>(),
		   ClusterConnectionKey_LoadClusterConnectionKeyActorState<ClusterConnectionKey_LoadClusterConnectionKeyActor>(db, connectionStringKey),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadClusterConnectionKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14083889035238560256UL, 7765905927218716928UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_LoadClusterConnectionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadClusterConnectionKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadClusterConnectionKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterConnectionKey_LoadClusterConnectionKeyActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterConnectionKey_LoadClusterConnectionKeyActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 40 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
[[nodiscard]] Future<Reference<ClusterConnectionKey>> ClusterConnectionKey::loadClusterConnectionKey( Database const& db, Key const& connectionStringKey ) {
															#line 40 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	return Future<Reference<ClusterConnectionKey>>(new ClusterConnectionKey_LoadClusterConnectionKeyActor(db, connectionStringKey));
															#line 416 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
}

#line 58 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"

// Sets the connections string held by this object and persists it.
Future<Void> ClusterConnectionKey::setAndPersistConnectionString(ClusterConnectionString const& connectionString) {
	cs = connectionString;
	return success(persist());
}

// Get the connection string stored in the database.
															#line 428 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
// This generated class is to be used only via getStoredConnectionStringImpl()
															#line 66 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
template <class ClusterConnectionKey_GetStoredConnectionStringImplActor>
															#line 66 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
class ClusterConnectionKey_GetStoredConnectionStringImplActorState {
															#line 434 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
public:
															#line 66 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	ClusterConnectionKey_GetStoredConnectionStringImplActorState(Reference<ClusterConnectionKey> const& self) 
															#line 66 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
															#line 66 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		 : self(self)
															#line 441 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
	{
		fdb_probe_actor_create("getStoredConnectionStringImpl", reinterpret_cast<unsigned long>(this));

	}
	~ClusterConnectionKey_GetStoredConnectionStringImplActorState() 
	{
		fdb_probe_actor_destroy("getStoredConnectionStringImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 68 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			StrictFuture<Reference<ClusterConnectionKey>> __when_expr_0 = ClusterConnectionKey::loadClusterConnectionKey(self->db, self->connectionStringKey);
															#line 68 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			if (static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 458 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->actor_wait_state = 1;
															#line 68 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterConnectionKey_GetStoredConnectionStringImplActor, 0, Reference<ClusterConnectionKey> >*>(static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)));
															#line 463 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterConnectionKey_GetStoredConnectionStringImplActorState();
		static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<ClusterConnectionKey> const& cck,int loopDepth) 
	{
															#line 70 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		if (!static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->SAV<ClusterConnectionString>::futures) { (void)(cck->cs); this->~ClusterConnectionKey_GetStoredConnectionStringImplActorState(); static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->destroy(); return 0; }
															#line 486 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		new (&static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->SAV< ClusterConnectionString >::value()) ClusterConnectionString(cck->cs);
		this->~ClusterConnectionKey_GetStoredConnectionStringImplActorState();
		static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<ClusterConnectionKey> && cck,int loopDepth) 
	{
															#line 70 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		if (!static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->SAV<ClusterConnectionString>::futures) { (void)(cck->cs); this->~ClusterConnectionKey_GetStoredConnectionStringImplActorState(); static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->destroy(); return 0; }
															#line 498 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		new (&static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->SAV< ClusterConnectionString >::value()) ClusterConnectionString(cck->cs);
		this->~ClusterConnectionKey_GetStoredConnectionStringImplActorState();
		static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Reference<ClusterConnectionKey> const& cck,int loopDepth) 
	{
		loopDepth = a_body1cont1(cck, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<ClusterConnectionKey> && cck,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cck), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->actor_wait_state > 0) static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->ActorCallback< ClusterConnectionKey_GetStoredConnectionStringImplActor, 0, Reference<ClusterConnectionKey> >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterConnectionKey_GetStoredConnectionStringImplActor, 0, Reference<ClusterConnectionKey> >*,Reference<ClusterConnectionKey> const& value) 
	{
		fdb_probe_actor_enter("getStoredConnectionStringImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStoredConnectionStringImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterConnectionKey_GetStoredConnectionStringImplActor, 0, Reference<ClusterConnectionKey> >*,Reference<ClusterConnectionKey> && value) 
	{
		fdb_probe_actor_enter("getStoredConnectionStringImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStoredConnectionStringImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterConnectionKey_GetStoredConnectionStringImplActor, 0, Reference<ClusterConnectionKey> >*,Error err) 
	{
		fdb_probe_actor_enter("getStoredConnectionStringImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStoredConnectionStringImpl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 66 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	Reference<ClusterConnectionKey> self;
															#line 583 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
};
// This generated class is to be used only via getStoredConnectionStringImpl()
															#line 66 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
class ClusterConnectionKey_GetStoredConnectionStringImplActor final : public Actor<ClusterConnectionString>, public ActorCallback< ClusterConnectionKey_GetStoredConnectionStringImplActor, 0, Reference<ClusterConnectionKey> >, public FastAllocated<ClusterConnectionKey_GetStoredConnectionStringImplActor>, public ClusterConnectionKey_GetStoredConnectionStringImplActorState<ClusterConnectionKey_GetStoredConnectionStringImplActor> {
															#line 588 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
public:
	using FastAllocated<ClusterConnectionKey_GetStoredConnectionStringImplActor>::operator new;
	using FastAllocated<ClusterConnectionKey_GetStoredConnectionStringImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5078043430538761472UL, 8376362591666318848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ClusterConnectionString>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterConnectionKey_GetStoredConnectionStringImplActor, 0, Reference<ClusterConnectionKey> >;
															#line 66 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	ClusterConnectionKey_GetStoredConnectionStringImplActor(Reference<ClusterConnectionKey> const& self) 
															#line 605 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		 : Actor<ClusterConnectionString>(),
		   ClusterConnectionKey_GetStoredConnectionStringImplActorState<ClusterConnectionKey_GetStoredConnectionStringImplActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStoredConnectionStringImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8767008665297193472UL, 1780622720673230592UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_GetStoredConnectionStringImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStoredConnectionStringImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStoredConnectionStringImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterConnectionKey_GetStoredConnectionStringImplActor, 0, Reference<ClusterConnectionKey> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 66 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
[[nodiscard]] Future<ClusterConnectionString> ClusterConnectionKey::getStoredConnectionStringImpl( Reference<ClusterConnectionKey> const& self ) {
															#line 66 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	return Future<ClusterConnectionString>(new ClusterConnectionKey_GetStoredConnectionStringImplActor(self));
															#line 637 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
}

#line 72 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"

Future<ClusterConnectionString> ClusterConnectionKey::getStoredConnectionString() {
	return getStoredConnectionStringImpl(Reference<ClusterConnectionKey>::addRef(this));
}

															#line 646 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
// This generated class is to be used only via upToDateImpl()
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
template <class ClusterConnectionKey_UpToDateImplActor>
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
class ClusterConnectionKey_UpToDateImplActorState {
															#line 652 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
public:
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	ClusterConnectionKey_UpToDateImplActorState(Reference<ClusterConnectionKey> const& self,ClusterConnectionString* const& connectionString) 
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		 : self(self),
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		   connectionString(connectionString)
															#line 661 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
	{
		fdb_probe_actor_create("upToDateImpl", reinterpret_cast<unsigned long>(this));

	}
	~ClusterConnectionKey_UpToDateImplActorState() 
	{
		fdb_probe_actor_destroy("upToDateImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 81 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
				if (self->needsToBePersisted())
															#line 677 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
				{
															#line 82 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
					if (!static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ClusterConnectionKey_UpToDateImplActorState(); static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->destroy(); return 0; }
															#line 681 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
					new (&static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->SAV< bool >::value()) bool(true);
					this->~ClusterConnectionKey_UpToDateImplActorState();
					static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 84 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
				StrictFuture<Reference<ClusterConnectionKey>> __when_expr_0 = ClusterConnectionKey::loadClusterConnectionKey(self->db, self->connectionStringKey);
															#line 84 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
				if (static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 691 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->actor_wait_state = 1;
															#line 84 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterConnectionKey_UpToDateImplActor, 0, Reference<ClusterConnectionKey> >*>(static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)));
															#line 696 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterConnectionKey_UpToDateImplActorState();
		static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 89 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			TraceEvent(SevWarnAlways, "ClusterKeyError").error(e).detail("Key", self->connectionStringKey);
															#line 90 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			if (!static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ClusterConnectionKey_UpToDateImplActorState(); static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->destroy(); return 0; }
															#line 728 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			new (&static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ClusterConnectionKey_UpToDateImplActorState();
			static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Reference<ClusterConnectionKey> const& temp,int loopDepth) 
	{
															#line 86 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		*connectionString = temp->getConnectionString();
															#line 87 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		if (!static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->SAV<bool>::futures) { (void)(connectionString->toString() == self->cs.toString()); this->~ClusterConnectionKey_UpToDateImplActorState(); static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->destroy(); return 0; }
															#line 748 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		new (&static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->SAV< bool >::value()) bool(connectionString->toString() == self->cs.toString());
		this->~ClusterConnectionKey_UpToDateImplActorState();
		static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<ClusterConnectionKey> && temp,int loopDepth) 
	{
															#line 86 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		*connectionString = temp->getConnectionString();
															#line 87 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		if (!static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->SAV<bool>::futures) { (void)(connectionString->toString() == self->cs.toString()); this->~ClusterConnectionKey_UpToDateImplActorState(); static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->destroy(); return 0; }
															#line 762 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		new (&static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->SAV< bool >::value()) bool(connectionString->toString() == self->cs.toString());
		this->~ClusterConnectionKey_UpToDateImplActorState();
		static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Reference<ClusterConnectionKey> const& temp,int loopDepth) 
	{
		loopDepth = a_body1cont2(temp, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<ClusterConnectionKey> && temp,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(temp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->actor_wait_state > 0) static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->ActorCallback< ClusterConnectionKey_UpToDateImplActor, 0, Reference<ClusterConnectionKey> >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterConnectionKey_UpToDateImplActor, 0, Reference<ClusterConnectionKey> >*,Reference<ClusterConnectionKey> const& value) 
	{
		fdb_probe_actor_enter("upToDateImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("upToDateImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterConnectionKey_UpToDateImplActor, 0, Reference<ClusterConnectionKey> >*,Reference<ClusterConnectionKey> && value) 
	{
		fdb_probe_actor_enter("upToDateImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("upToDateImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterConnectionKey_UpToDateImplActor, 0, Reference<ClusterConnectionKey> >*,Error err) 
	{
		fdb_probe_actor_enter("upToDateImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("upToDateImpl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	Reference<ClusterConnectionKey> self;
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	ClusterConnectionString* connectionString;
															#line 849 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
};
// This generated class is to be used only via upToDateImpl()
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
class ClusterConnectionKey_UpToDateImplActor final : public Actor<bool>, public ActorCallback< ClusterConnectionKey_UpToDateImplActor, 0, Reference<ClusterConnectionKey> >, public FastAllocated<ClusterConnectionKey_UpToDateImplActor>, public ClusterConnectionKey_UpToDateImplActorState<ClusterConnectionKey_UpToDateImplActor> {
															#line 854 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
public:
	using FastAllocated<ClusterConnectionKey_UpToDateImplActor>::operator new;
	using FastAllocated<ClusterConnectionKey_UpToDateImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4316711439926527744UL, 14199547584116975104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterConnectionKey_UpToDateImplActor, 0, Reference<ClusterConnectionKey> >;
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	ClusterConnectionKey_UpToDateImplActor(Reference<ClusterConnectionKey> const& self,ClusterConnectionString* const& connectionString) 
															#line 871 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		 : Actor<bool>(),
		   ClusterConnectionKey_UpToDateImplActorState<ClusterConnectionKey_UpToDateImplActor>(self, connectionString),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("upToDateImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2698025374813084416UL, 11003603137694916864UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_UpToDateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("upToDateImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("upToDateImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterConnectionKey_UpToDateImplActor, 0, Reference<ClusterConnectionKey> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
[[nodiscard]] Future<bool> ClusterConnectionKey::upToDateImpl( Reference<ClusterConnectionKey> const& self, ClusterConnectionString* const& connectionString ) {
															#line 77 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	return Future<bool>(new ClusterConnectionKey_UpToDateImplActor(self, connectionString));
															#line 903 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
}

#line 93 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"

// Checks whether the connection string in the database matches the connection string stored in memory. The cluster
// string stored in the database is returned via the reference parameter connectionString.
Future<bool> ClusterConnectionKey::upToDate(ClusterConnectionString& connectionString) {
	return upToDateImpl(Reference<ClusterConnectionKey>::addRef(this), &connectionString);
}

// Returns the key where the connection string is stored.
std::string ClusterConnectionKey::getLocation() const {
	return printable(connectionStringKey);
}

// Creates a copy of this object with a modified connection string but that isn't persisted.
Reference<IClusterConnectionRecord> ClusterConnectionKey::makeIntermediateRecord(
    ClusterConnectionString const& connectionString) const {
	return makeReference<ClusterConnectionKey>(db, connectionStringKey, connectionString);
}

// Returns a string representation of this cluster connection record. This will include the type of record and the
// key where the record is stored.
std::string ClusterConnectionKey::toString() const {
	return "fdbkey://" + printable(connectionStringKey);
}

															#line 931 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
// This generated class is to be used only via persistImpl()
															#line 117 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
template <class ClusterConnectionKey_PersistImplActor>
															#line 117 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
class ClusterConnectionKey_PersistImplActorState {
															#line 937 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
public:
															#line 117 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	ClusterConnectionKey_PersistImplActorState(Reference<ClusterConnectionKey> const& self) 
															#line 117 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
															#line 117 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		 : self(self)
															#line 944 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
	{
		fdb_probe_actor_create("persistImpl", reinterpret_cast<unsigned long>(this));

	}
	~ClusterConnectionKey_PersistImplActorState() 
	{
		fdb_probe_actor_destroy("persistImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 118 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			self->setPersisted();
															#line 119 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			newConnectionString = ValueRef(self->cs.toString());
															#line 961 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			try {
															#line 122 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
				tr = Transaction(self->db);
															#line 123 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
				;
															#line 967 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterConnectionKey_PersistImplActorState();
		static_cast<ClusterConnectionKey_PersistImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 161 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		if (!static_cast<ClusterConnectionKey_PersistImplActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ClusterConnectionKey_PersistImplActorState(); static_cast<ClusterConnectionKey_PersistImplActor*>(this)->destroy(); return 0; }
															#line 996 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		new (&static_cast<ClusterConnectionKey_PersistImplActor*>(this)->SAV< bool >::value()) bool(false);
		this->~ClusterConnectionKey_PersistImplActorState();
		static_cast<ClusterConnectionKey_PersistImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 155 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			TraceEvent(SevWarnAlways, "UnableToChangeConnectionKey") .error(e) .detail("ConnectionKey", self->connectionStringKey) .detail("ConnectionString", self->cs.toString());
															#line 1009 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 125 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(self->connectionStringKey);
															#line 125 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			if (static_cast<ClusterConnectionKey_PersistImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1034 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClusterConnectionKey_PersistImplActor*>(this)->actor_wait_state = 1;
															#line 125 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterConnectionKey_PersistImplActor, 0, Optional<Value> >*>(static_cast<ClusterConnectionKey_PersistImplActor*>(this)));
															#line 1039 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 151 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 151 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			if (static_cast<ClusterConnectionKey_PersistImplActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1063 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ClusterConnectionKey_PersistImplActor*>(this)->actor_wait_state = 3;
															#line 151 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClusterConnectionKey_PersistImplActor, 2, Void >*>(static_cast<ClusterConnectionKey_PersistImplActor*>(this)));
															#line 1068 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& existingConnectionString,int loopDepth) 
	{
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		if (existingConnectionString.present() && existingConnectionString.get() == newConnectionString)
															#line 1083 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		{
															#line 128 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			self->lastPersistedConnectionString = newConnectionString;
															#line 129 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			if (!static_cast<ClusterConnectionKey_PersistImplActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ClusterConnectionKey_PersistImplActorState(); static_cast<ClusterConnectionKey_PersistImplActor*>(this)->destroy(); return 0; }
															#line 1089 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			new (&static_cast<ClusterConnectionKey_PersistImplActor*>(this)->SAV< bool >::value()) bool(true);
			this->~ClusterConnectionKey_PersistImplActorState();
			static_cast<ClusterConnectionKey_PersistImplActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 136 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			if (existingConnectionString.present() && existingConnectionString != self->lastPersistedConnectionString)
															#line 1099 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			{
															#line 138 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
				TraceEvent(SevWarnAlways, "UnableToChangeConnectionKeyDueToMismatch") .detail("ConnectionKey", self->connectionStringKey) .detail("NewConnectionString", newConnectionString) .detail("ExpectedStoredConnectionString", self->lastPersistedConnectionString) .detail("ActualStoredConnectionString", existingConnectionString);
															#line 143 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
				if (!static_cast<ClusterConnectionKey_PersistImplActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ClusterConnectionKey_PersistImplActorState(); static_cast<ClusterConnectionKey_PersistImplActor*>(this)->destroy(); return 0; }
															#line 1105 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
				new (&static_cast<ClusterConnectionKey_PersistImplActor*>(this)->SAV< bool >::value()) bool(false);
				this->~ClusterConnectionKey_PersistImplActorState();
				static_cast<ClusterConnectionKey_PersistImplActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 145 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		tr.set(self->connectionStringKey, newConnectionString);
															#line 146 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 146 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		if (static_cast<ClusterConnectionKey_PersistImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1118 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterConnectionKey_PersistImplActor*>(this)->actor_wait_state = 2;
															#line 146 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterConnectionKey_PersistImplActor, 1, Void >*>(static_cast<ClusterConnectionKey_PersistImplActor*>(this)));
															#line 1123 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && existingConnectionString,int loopDepth) 
	{
															#line 127 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		if (existingConnectionString.present() && existingConnectionString.get() == newConnectionString)
															#line 1132 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		{
															#line 128 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			self->lastPersistedConnectionString = newConnectionString;
															#line 129 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			if (!static_cast<ClusterConnectionKey_PersistImplActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ClusterConnectionKey_PersistImplActorState(); static_cast<ClusterConnectionKey_PersistImplActor*>(this)->destroy(); return 0; }
															#line 1138 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			new (&static_cast<ClusterConnectionKey_PersistImplActor*>(this)->SAV< bool >::value()) bool(true);
			this->~ClusterConnectionKey_PersistImplActorState();
			static_cast<ClusterConnectionKey_PersistImplActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 136 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
			if (existingConnectionString.present() && existingConnectionString != self->lastPersistedConnectionString)
															#line 1148 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
			{
															#line 138 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
				TraceEvent(SevWarnAlways, "UnableToChangeConnectionKeyDueToMismatch") .detail("ConnectionKey", self->connectionStringKey) .detail("NewConnectionString", newConnectionString) .detail("ExpectedStoredConnectionString", self->lastPersistedConnectionString) .detail("ActualStoredConnectionString", existingConnectionString);
															#line 143 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
				if (!static_cast<ClusterConnectionKey_PersistImplActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ClusterConnectionKey_PersistImplActorState(); static_cast<ClusterConnectionKey_PersistImplActor*>(this)->destroy(); return 0; }
															#line 1154 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
				new (&static_cast<ClusterConnectionKey_PersistImplActor*>(this)->SAV< bool >::value()) bool(false);
				this->~ClusterConnectionKey_PersistImplActorState();
				static_cast<ClusterConnectionKey_PersistImplActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 145 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		tr.set(self->connectionStringKey, newConnectionString);
															#line 146 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 146 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		if (static_cast<ClusterConnectionKey_PersistImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1167 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterConnectionKey_PersistImplActor*>(this)->actor_wait_state = 2;
															#line 146 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterConnectionKey_PersistImplActor, 1, Void >*>(static_cast<ClusterConnectionKey_PersistImplActor*>(this)));
															#line 1172 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& existingConnectionString,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(existingConnectionString, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && existingConnectionString,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(existingConnectionString), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterConnectionKey_PersistImplActor*>(this)->actor_wait_state > 0) static_cast<ClusterConnectionKey_PersistImplActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterConnectionKey_PersistImplActor*>(this)->ActorCallback< ClusterConnectionKey_PersistImplActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterConnectionKey_PersistImplActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("persistImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_PersistImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterConnectionKey_PersistImplActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("persistImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_PersistImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterConnectionKey_PersistImplActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("persistImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_PersistImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 148 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		self->lastPersistedConnectionString = newConnectionString;
															#line 149 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		if (!static_cast<ClusterConnectionKey_PersistImplActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ClusterConnectionKey_PersistImplActorState(); static_cast<ClusterConnectionKey_PersistImplActor*>(this)->destroy(); return 0; }
															#line 1258 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		new (&static_cast<ClusterConnectionKey_PersistImplActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ClusterConnectionKey_PersistImplActorState();
		static_cast<ClusterConnectionKey_PersistImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 148 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		self->lastPersistedConnectionString = newConnectionString;
															#line 149 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
		if (!static_cast<ClusterConnectionKey_PersistImplActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ClusterConnectionKey_PersistImplActorState(); static_cast<ClusterConnectionKey_PersistImplActor*>(this)->destroy(); return 0; }
															#line 1272 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		new (&static_cast<ClusterConnectionKey_PersistImplActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ClusterConnectionKey_PersistImplActorState();
		static_cast<ClusterConnectionKey_PersistImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterConnectionKey_PersistImplActor*>(this)->actor_wait_state > 0) static_cast<ClusterConnectionKey_PersistImplActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterConnectionKey_PersistImplActor*>(this)->ActorCallback< ClusterConnectionKey_PersistImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterConnectionKey_PersistImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_PersistImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterConnectionKey_PersistImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_PersistImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterConnectionKey_PersistImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_PersistImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClusterConnectionKey_PersistImplActor*>(this)->actor_wait_state > 0) static_cast<ClusterConnectionKey_PersistImplActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterConnectionKey_PersistImplActor*>(this)->ActorCallback< ClusterConnectionKey_PersistImplActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterConnectionKey_PersistImplActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_PersistImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterConnectionKey_PersistImplActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_PersistImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClusterConnectionKey_PersistImplActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_PersistImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistImpl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 117 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	Reference<ClusterConnectionKey> self;
															#line 119 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	Value newConnectionString;
															#line 122 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	Transaction tr;
															#line 1448 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
};
// This generated class is to be used only via persistImpl()
															#line 117 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
class ClusterConnectionKey_PersistImplActor final : public Actor<bool>, public ActorCallback< ClusterConnectionKey_PersistImplActor, 0, Optional<Value> >, public ActorCallback< ClusterConnectionKey_PersistImplActor, 1, Void >, public ActorCallback< ClusterConnectionKey_PersistImplActor, 2, Void >, public FastAllocated<ClusterConnectionKey_PersistImplActor>, public ClusterConnectionKey_PersistImplActorState<ClusterConnectionKey_PersistImplActor> {
															#line 1453 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
public:
	using FastAllocated<ClusterConnectionKey_PersistImplActor>::operator new;
	using FastAllocated<ClusterConnectionKey_PersistImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13643417268793713152UL, 2665378204191930368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterConnectionKey_PersistImplActor, 0, Optional<Value> >;
friend struct ActorCallback< ClusterConnectionKey_PersistImplActor, 1, Void >;
friend struct ActorCallback< ClusterConnectionKey_PersistImplActor, 2, Void >;
															#line 117 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	ClusterConnectionKey_PersistImplActor(Reference<ClusterConnectionKey> const& self) 
															#line 1472 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
		 : Actor<bool>(),
		   ClusterConnectionKey_PersistImplActorState<ClusterConnectionKey_PersistImplActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("persistImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16007808872051901952UL, 723754461129074176UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterConnectionKey_PersistImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("persistImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("persistImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterConnectionKey_PersistImplActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterConnectionKey_PersistImplActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClusterConnectionKey_PersistImplActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 117 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
[[nodiscard]] Future<bool> ClusterConnectionKey::persistImpl( Reference<ClusterConnectionKey> const& self ) {
															#line 117 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"
	return Future<bool>(new ClusterConnectionKey_PersistImplActor(self));
															#line 1506 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/build_output/fdbclient/ClusterConnectionKey.actor.g.cpp"
}

#line 162 "/codebuild/output/src1564695889/src/github.com/apple/foundationdb/fdbclient/ClusterConnectionKey.actor.cpp"


// Writes the connection string to the database
Future<bool> ClusterConnectionKey::persist() {
	return persistImpl(Reference<ClusterConnectionKey>::addRef(this));
}