#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
/*
 * Watches.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/DDSketch.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "flow/CodeProbe.h"
#include "flow/Coroutines.h"
#include "flow/DeterministicRandom.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct WatchesWorkload : TestWorkload {
	static constexpr auto NAME = "Watches";

	int nodes, keyBytes, extraPerNode;
	double testDuration;
	std::vector<Future<Void>> clients;
	PerfIntCounter cycles;
	DDSketch<double> cycleLatencies;
	std::vector<int> nodeOrder;

	WatchesWorkload(WorkloadContext const& wcx) : TestWorkload(wcx), cycles("Cycles"), cycleLatencies() {
		testDuration = getOption(options, "testDuration"_sr, 600.0);
		nodes = getOption(options, "nodeCount"_sr, 100);
		extraPerNode = getOption(options, "extraPerNode"_sr, 1000);
		keyBytes = std::max(getOption(options, "keyBytes"_sr, 16), 16);

		for (int i = 0; i < nodes + 1; i++)
			nodeOrder.push_back(i);
		DeterministicRandom tempRand(1);
		tempRand.randomShuffle(nodeOrder);
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		// We disable RandomRangeLock workload injection because watchesWorker() does not handle the
		// transaction error, in particular, transaction_rejected_range_locked can happen when enabling RandomRangeLock.
		// TODO: remove after the workload handles the transaction error.
		out.insert("RandomRangeLock");
	}

	Future<Void> setup(Database const& cx) override {
		// return _setup(cx, this);
		std::vector<Future<Void>> setupActors;
		for (int i = 0; i < nodes; i++)
			if (i % clientCount == clientId)
				setupActors.push_back(
				    watcherInit(cx, keyForIndex(nodeOrder[i]), keyForIndex(nodeOrder[i + 1]), extraPerNode));

		co_await waitForAll(setupActors);

		for (int i = 0; i < nodes; i++)
			if (i % clientCount == clientId)
				clients.push_back(watcher(cx, keyForIndex(nodeOrder[i]), keyForIndex(nodeOrder[i + 1]), extraPerNode));

		co_return;
	}

	Future<Void> start(Database const& cx) override {
		if (clientId == 0)
			return watchesWorker(cx, this);
		return Void();
	}

	Future<bool> check(Database const& cx) override {
		bool ok = true;
		for (int i = 0; i < clients.size(); i++)
			if (clients[i].isError())
				ok = false;
		clients.clear();
		return ok;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		if (clientId == 0) {
			m.push_back(cycles.getMetric());
			m.emplace_back("Mean Latency (ms)", 1000 * cycleLatencies.mean() / nodes, Averaged::True);
		}
	}

	Key keyForIndex(uint64_t index) {
		Key result = makeString(keyBytes);
		uint8_t* data = mutateString(result);
		memset(data, '.', keyBytes);

		double d = double(index) / nodes;
		emplaceIndex(data, 0, *(int64_t*)&d);

		return result;
	}

	Future<Void> watcherInit(Database cx, Key watchKey, Key setKey, int extraNodes) {
		int extraLoc = 0;
		while (extraLoc < extraNodes) {
			co_await cx.run([&](Transaction* tr) -> Future<Void> {
				for (int i = 0; i < 1000 && extraLoc + i < extraNodes; i++) {
					Key extraKey = KeyRef(watchKey.toString() + format("%d", extraLoc + i));
					Value extraValue = ValueRef(std::string(100, '.'));
					tr->set(extraKey, extraValue);
					// TraceEvent("WatcherInitialSetupExtra").detail("Key", extraKey).detail("Value", extraValue);
				}
				co_await tr->commit();
				extraLoc += 1000;
				CODE_PROBE(true, "Watches workload initial setup");
				// TraceEvent("WatcherInitialSetup").detail("Watch", watchKey).detail("Ver", tr->getCommittedVersion());
			});
		}
	}

																#line 129 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
// This generated class is to be used only via watcher()
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
template <class WatcherActor>
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
class WatcherActorState {
															#line 135 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
public:
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
	WatcherActorState(Database const& cx,Key const& watchKey,Key const& setKey,int const& extraNodes) 
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		 : cx(cx),
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		   watchKey(watchKey),
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		   setKey(setKey),
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		   extraNodes(extraNodes),
															#line 128 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		   lastValue()
															#line 150 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
	{
		fdb_probe_actor_create("watcher", reinterpret_cast<unsigned long>(this));

	}
	~WatcherActorState() 
	{
		fdb_probe_actor_destroy("watcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 130 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			;
															#line 165 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatcherActorState();
		static_cast<WatcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 131 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		;
															#line 195 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 132 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		tr = std::make_unique<Transaction>(cx);
															#line 217 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		try {
															#line 134 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			setValueFuture = tr->get(setKey);
															#line 135 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(watchKey);
															#line 135 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			if (static_cast<WatcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 225 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WatcherActor*>(this)->actor_wait_state = 1;
															#line 135 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatcherActor, 0, Optional<Value> >*>(static_cast<WatcherActor*>(this)));
															#line 230 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 171 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			if (tr != nullptr)
															#line 265 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			{
															#line 172 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
				StrictFuture<Void> __when_expr_5 = tr->onError(e);
															#line 172 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
				if (static_cast<WatcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 271 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
				static_cast<WatcherActor*>(this)->actor_wait_state = 6;
															#line 172 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< WatcherActor, 5, Void >*>(static_cast<WatcherActor*>(this)));
															#line 276 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 136 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = setValueFuture;
															#line 136 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		if (static_cast<WatcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 298 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WatcherActor*>(this)->actor_wait_state = 2;
															#line 136 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatcherActor, 1, Optional<Value> >*>(static_cast<WatcherActor*>(this)));
															#line 303 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& __watchValue,int loopDepth) 
	{
															#line 135 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		watchValue = __watchValue;
															#line 312 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && __watchValue,int loopDepth) 
	{
		watchValue = std::move(__watchValue);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatcherActor*>(this)->actor_wait_state > 0) static_cast<WatcherActor*>(this)->actor_wait_state = 0;
		static_cast<WatcherActor*>(this)->ActorCallback< WatcherActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< WatcherActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatcherActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatcherActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Optional<Value> const& setValue,int loopDepth) 
	{
															#line 138 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		if (lastValue.present() && lastValue.get() == watchValue)
															#line 391 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		{
															#line 139 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			TraceEvent(SevError, "WatcherTriggeredWithoutChanging") .detail("WatchKey", printable(watchKey)) .detail("SetKey", printable(setKey)) .detail("WatchValue", printable(watchValue)) .detail("SetValue", printable(setValue)) .detail("ReadVersion", tr->getReadVersion().get());
															#line 395 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		}
															#line 147 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		lastValue = Optional<Optional<Value>>();
															#line 149 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		if (watchValue != setValue)
															#line 401 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		{
															#line 150 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			if (watchValue.present())
															#line 405 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			{
															#line 151 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
				tr->set(setKey, watchValue.get());
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			}
			else
			{
															#line 153 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
				tr->clear(setKey);
															#line 415 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			}
															#line 155 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 155 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			if (static_cast<WatcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 421 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<WatcherActor*>(this)->actor_wait_state = 3;
															#line 155 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WatcherActor, 2, Void >*>(static_cast<WatcherActor*>(this)));
															#line 426 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 159 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			watchFuture = tr->watch(makeReference<Watch>(watchKey, watchValue));
															#line 160 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 160 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			if (static_cast<WatcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 437 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when2(__when_expr_3.get(), loopDepth); };
			static_cast<WatcherActor*>(this)->actor_wait_state = 4;
															#line 160 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WatcherActor, 3, Void >*>(static_cast<WatcherActor*>(this)));
															#line 442 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Optional<Value> && setValue,int loopDepth) 
	{
															#line 138 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		if (lastValue.present() && lastValue.get() == watchValue)
															#line 452 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		{
															#line 139 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			TraceEvent(SevError, "WatcherTriggeredWithoutChanging") .detail("WatchKey", printable(watchKey)) .detail("SetKey", printable(setKey)) .detail("WatchValue", printable(watchValue)) .detail("SetValue", printable(setValue)) .detail("ReadVersion", tr->getReadVersion().get());
															#line 456 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		}
															#line 147 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		lastValue = Optional<Optional<Value>>();
															#line 149 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		if (watchValue != setValue)
															#line 462 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		{
															#line 150 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			if (watchValue.present())
															#line 466 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			{
															#line 151 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
				tr->set(setKey, watchValue.get());
															#line 470 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			}
			else
			{
															#line 153 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
				tr->clear(setKey);
															#line 476 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			}
															#line 155 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 155 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			if (static_cast<WatcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 482 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<WatcherActor*>(this)->actor_wait_state = 3;
															#line 155 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WatcherActor, 2, Void >*>(static_cast<WatcherActor*>(this)));
															#line 487 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 159 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			watchFuture = tr->watch(makeReference<Watch>(watchKey, watchValue));
															#line 160 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 160 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			if (static_cast<WatcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 498 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when2(__when_expr_3.get(), loopDepth); };
			static_cast<WatcherActor*>(this)->actor_wait_state = 4;
															#line 160 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WatcherActor, 3, Void >*>(static_cast<WatcherActor*>(this)));
															#line 503 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Optional<Value> const& setValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(setValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Optional<Value> && setValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(setValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WatcherActor*>(this)->actor_wait_state > 0) static_cast<WatcherActor*>(this)->actor_wait_state = 0;
		static_cast<WatcherActor*>(this)->ActorCallback< WatcherActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< WatcherActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatcherActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WatcherActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont4(int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WatcherActor*>(this)->actor_wait_state > 0) static_cast<WatcherActor*>(this)->actor_wait_state = 0;
		static_cast<WatcherActor*>(this)->ActorCallback< WatcherActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WatcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WatcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 161 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		if (BUGGIFY)
															#line 681 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		{
															#line 163 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			tr.reset();
															#line 685 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		}
															#line 165 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		StrictFuture<Void> __when_expr_4 = watchFuture;
															#line 165 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		if (static_cast<WatcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 691 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1loopBody1cont9when1(__when_expr_4.get(), loopDepth); };
		static_cast<WatcherActor*>(this)->actor_wait_state = 5;
															#line 165 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WatcherActor, 4, Void >*>(static_cast<WatcherActor*>(this)));
															#line 696 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 161 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		if (BUGGIFY)
															#line 705 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		{
															#line 163 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			tr.reset();
															#line 709 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		}
															#line 165 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		StrictFuture<Void> __when_expr_4 = watchFuture;
															#line 165 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		if (static_cast<WatcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 715 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1loopBody1cont9when1(__when_expr_4.get(), loopDepth); };
		static_cast<WatcherActor*>(this)->actor_wait_state = 5;
															#line 165 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WatcherActor, 4, Void >*>(static_cast<WatcherActor*>(this)));
															#line 720 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WatcherActor*>(this)->actor_wait_state > 0) static_cast<WatcherActor*>(this)->actor_wait_state = 0;
		static_cast<WatcherActor*>(this)->ActorCallback< WatcherActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatcherActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont3when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WatcherActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont3when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WatcherActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 166 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		if (watchValue.present())
															#line 804 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		{
															#line 167 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			lastValue = watchValue;
															#line 808 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 166 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
		if (watchValue.present())
															#line 818 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		{
															#line 167 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
			lastValue = watchValue;
															#line 822 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WatcherActor*>(this)->actor_wait_state > 0) static_cast<WatcherActor*>(this)->actor_wait_state = 0;
		static_cast<WatcherActor*>(this)->ActorCallback< WatcherActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatcherActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WatcherActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WatcherActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<WatcherActor*>(this)->actor_wait_state > 0) static_cast<WatcherActor*>(this)->actor_wait_state = 0;
		static_cast<WatcherActor*>(this)->ActorCallback< WatcherActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatcherActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< WatcherActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< WatcherActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
	Database cx;
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
	Key watchKey;
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
	Key setKey;
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
	int extraNodes;
															#line 128 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
	Optional<Optional<Value>> lastValue;
															#line 132 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
	std::unique_ptr<Transaction> tr;
															#line 134 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
	Future<Optional<Value>> setValueFuture;
															#line 135 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
	Optional<Value> watchValue;
															#line 159 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
	Future<Void> watchFuture;
															#line 1014 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
};
// This generated class is to be used only via watcher()
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
class WatcherActor final : public Actor<Void>, public ActorCallback< WatcherActor, 0, Optional<Value> >, public ActorCallback< WatcherActor, 1, Optional<Value> >, public ActorCallback< WatcherActor, 2, Void >, public ActorCallback< WatcherActor, 3, Void >, public ActorCallback< WatcherActor, 4, Void >, public ActorCallback< WatcherActor, 5, Void >, public FastAllocated<WatcherActor>, public WatcherActorState<WatcherActor> {
															#line 1019 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
public:
	using FastAllocated<WatcherActor>::operator new;
	using FastAllocated<WatcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15164422727479689984UL, 17400377027157505792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatcherActor, 0, Optional<Value> >;
friend struct ActorCallback< WatcherActor, 1, Optional<Value> >;
friend struct ActorCallback< WatcherActor, 2, Void >;
friend struct ActorCallback< WatcherActor, 3, Void >;
friend struct ActorCallback< WatcherActor, 4, Void >;
friend struct ActorCallback< WatcherActor, 5, Void >;
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
	WatcherActor(Database const& cx,Key const& watchKey,Key const& setKey,int const& extraNodes) 
															#line 1041 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
		 : Actor<Void>(),
		   WatcherActorState<WatcherActor>(cx, watchKey, setKey, extraNodes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1827621701897782272UL, 4672126941619720704UL);
		ActorExecutionContextHelper __helper(static_cast<WatcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatcherActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WatcherActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WatcherActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WatcherActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WatcherActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< WatcherActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
[[nodiscard]] static Future<Void> watcher( Database const& cx, Key const& watchKey, Key const& setKey, int const& extraNodes ) {
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"
	return Future<Void>(new WatcherActor(cx, watchKey, setKey, extraNodes));
															#line 1078 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Watches.actor.g.cpp"
}

#line 178 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/Watches.actor.cpp"

	Future<Void> watchesWorker(Database cx, WatchesWorkload* self) {
		Key startKey = self->keyForIndex(self->nodeOrder[0]);
		Key endKey = self->keyForIndex(self->nodeOrder[self->nodes]);
		Optional<Value> expectedValue;
		Optional<Value> startValue;
		double startTime = now();
		double chainStartTime;
		loop {
			bool isValue = deterministicRandom()->random01() > 0.5;
			Value assignedValue = Value(deterministicRandom()->randomUniqueID().toString());
			bool firstAttempt = true;
			co_await cx.run([&](Transaction* tr) -> Future<Void> {
				co_await tr->getReadVersion();
				Optional<Value> _startValue = co_await tr->get(startKey);
				if (firstAttempt) {
					startValue = _startValue;
					firstAttempt = false;
				}
				expectedValue = Optional<Value>();
				if (startValue.present()) {
					if (isValue)
						expectedValue = assignedValue;
				} else
					expectedValue = assignedValue;

				if (expectedValue.present())
					tr->set(startKey, expectedValue.get());
				else
					tr->clear(startKey);

				co_await tr->commit();
				CODE_PROBE(expectedValue.present(), "watches workload set a key");
				CODE_PROBE(!expectedValue.present(), "watches workload clear a key");
				co_return;
			});

			chainStartTime = now();
			firstAttempt = true;
			bool finished = false;
			while (!finished) {
				co_await cx.run([&](Transaction* tr2) -> Future<Void> {
					Optional<Value> endValue = co_await tr2->get(endKey);
					if (endValue == expectedValue) {
						finished = true;
						co_return;
					}
					if (!firstAttempt || endValue != startValue) {
						TraceEvent(SevError, "WatcherError")
						    .detail("FirstAttempt", firstAttempt)
						    .detail("StartValue", printable(startValue))
						    .detail("EndValue", printable(endValue))
						    .detail("ExpectedValue", printable(expectedValue))
						    .detail("EndVersion", tr2->getReadVersion().get());
					}
					Future<Void> watchFuture = tr2->watch(makeReference<Watch>(endKey, startValue));
					co_await tr2->commit();
					co_await watchFuture;
					CODE_PROBE(true, "watcher workload watch fired");
					firstAttempt = false;
				});
			}
			self->cycleLatencies.addSample(now() - chainStartTime);
			++self->cycles;

			if (g_network->isSimulated())
				co_await delay(deterministicRandom()->random01() < 0.5 ? 0 : deterministicRandom()->random01() * 60);

			if (now() - startTime > self->testDuration)
				break;
		}
	}
};

WorkloadFactory<WatchesWorkload> WatchesWorkloadFactory;
