#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
/*
 * RawTenantAccessWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/workloads/workloads.actor.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/ThreadSafeTransaction.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "fdbclient/TenantSpecialKeys.actor.h"
#include "fdbserver/Knobs.h"
#include "flow/actorcompiler.h"

struct RawTenantAccessWorkload : TestWorkload {
	static constexpr auto NAME = "RawTenantAccess";

	const Key specialKeysTenantMapPrefix = SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT)
	                                           .begin.withSuffix(TenantRangeImpl::submoduleRange.begin)
	                                           .withSuffix(TenantRangeImpl::mapSubRange.begin);
	const KeyRef writeKey = "key"_sr;
	const ValueRef writeValue = "value"_sr;

	int tenantCount;
	double testDuration;

	enum Op {
		CREATE_TENANT,
		DELETE_TENANT,
		VALID_WRITE, // write to existing tenant
		INVALID_WRITE, // write to nonexistent tenant
	};
	std::vector<std::pair<Op, int>> txnOps; // Operations and corresponding tenant index
	std::set<int> lastCreatedTenants; // the index of tenant to be created if the last transaction succeed
	std::set<int> lastDeletedTenants; // the index of tenant to be deleted if the last transaction succeed

	std::map<int, int64_t> idx2Tid; // workload tenant idx to tenantId
	std::map<int64_t, int> tid2Idx; // tenant id to tenant index in this workload

	RawTenantAccessWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		tenantCount = std::min(getOption(options, "tenantCount"_sr, 1000), CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER);
		testDuration = getOption(options, "testDuration"_sr, 120.0);
	}

	Future<Void> setup(Database const& cx) override {
		if (clientId == 0) {
			return _setup(cx, this);
		}
		return Void();
	}

	TenantName indexToTenantName(int index) const {
		auto name = fmt::format("tenant_idx_{:06d}", index);
		return TenantName(StringRef(name));
	}

																#line 73 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 71 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
template <class _setupActor>
															#line 71 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
class _setupActorState {
															#line 79 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
public:
															#line 71 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	_setupActorState(Database const& cx,RawTenantAccessWorkload* const& self) 
															#line 71 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
															#line 71 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		 : cx(cx),
															#line 71 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		   self(self)
															#line 88 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 72 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			RawTenantAccessWorkload* workload = self;
															#line 74 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runRYWTransaction(cx, [workload](Reference<ReadYourWritesTransaction> tr) { tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES); for (int i = 0; i < workload->tenantCount; i += 2) { tr->set(workload->specialKeysTenantMapPrefix.withSuffix(workload->indexToTenantName(i)), ""_sr); } return Future<Void>(Void()); });
															#line 74 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 107 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 74 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 112 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 82 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		for(int i = 0;i < self->tenantCount;i += 2) {
															#line 83 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			self->lastCreatedTenants.insert(i);
															#line 137 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		}
															#line 85 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 141 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 82 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		for(int i = 0;i < self->tenantCount;i += 2) {
															#line 83 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			self->lastCreatedTenants.insert(i);
															#line 155 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		}
															#line 85 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 159 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 71 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	Database cx;
															#line 71 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	RawTenantAccessWorkload* self;
															#line 246 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 71 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 251 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11210304697310716672UL, 17312396132520484096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
															#line 71 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	_setupActor(Database const& cx,RawTenantAccessWorkload* const& self) 
															#line 268 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 71 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _setup( Database const& cx, RawTenantAccessWorkload* const& self ) {
															#line 71 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 300 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
}

#line 87 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"

	bool hasNonexistentTenant() const { return lastCreatedTenants.size() + idx2Tid.size() < tenantCount; }

	bool hasExistingTenant() const { return idx2Tid.size() - lastDeletedTenants.size() > 0; }

	int64_t extractTenantId(ValueRef value) const {
		int64_t id;
		json_spirit::mValue jsonObject;
		json_spirit::read_string(value.toString(), jsonObject);
		JSONDoc jsonDoc(jsonObject);
		jsonDoc.get("id", id);
		return id;
	}

	void eraseDeletedTenants() {
		for (auto idx : lastDeletedTenants) {
			auto tid = idx2Tid.at(idx);
			tid2Idx.erase(tid);
			idx2Tid.erase(idx);
		}
	}

	void addCreatedTenants(std::unordered_map<int, int64_t> const& newTenantIds) {
		for (auto idx : lastCreatedTenants) {
			auto tid = newTenantIds.at(idx);
			tid2Idx[tid] = idx;
			idx2Tid[idx] = tid;
		}
	}

																#line 334 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
// This generated class is to be used only via checkAndApplyTenantChanges()
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
template <class CheckAndApplyTenantChangesActor>
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
class CheckAndApplyTenantChangesActorState {
															#line 340 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
public:
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	CheckAndApplyTenantChangesActorState(Database const& cx,RawTenantAccessWorkload* const& self,bool const& lastCommitted) 
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		 : cx(cx),
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		   self(self),
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		   lastCommitted(lastCommitted),
															#line 120 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		   newTenantIds(),
															#line 122 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(cx))
															#line 355 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this));

	}
	~CheckAndApplyTenantChangesActorState() 
	{
		fdb_probe_actor_destroy("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			;
															#line 370 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckAndApplyTenantChangesActorState();
		static_cast<CheckAndApplyTenantChangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 161 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		TraceEvent("RawTenantAccess_CheckTenantChanges") .detail("CurrentTenantCount", self->idx2Tid.size()) .detail("NewTenantIds", newTenantIds.size());
															#line 165 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (lastCommitted)
															#line 395 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		{
															#line 166 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			self->eraseDeletedTenants();
															#line 167 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			self->addCreatedTenants(newTenantIds);
															#line 168 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			TraceEvent("RawTenantAccess_ApplyTenantChanges").detail("CurrentTenantCount", self->idx2Tid.size());
															#line 403 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		}
															#line 171 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (!static_cast<CheckAndApplyTenantChangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckAndApplyTenantChangesActorState(); static_cast<CheckAndApplyTenantChangesActor*>(this)->destroy(); return 0; }
															#line 407 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		new (&static_cast<CheckAndApplyTenantChangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckAndApplyTenantChangesActorState();
		static_cast<CheckAndApplyTenantChangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 124 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		tr->reset();
															#line 125 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		newTenantIds.clear();
															#line 428 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		try {
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			it = self->lastDeletedTenants.cbegin();
															#line 129 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			;
															#line 434 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 157 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 157 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			if (static_cast<CheckAndApplyTenantChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 471 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckAndApplyTenantChangesActor*>(this)->actor_wait_state = 3;
															#line 157 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckAndApplyTenantChangesActor, 2, Void >*>(static_cast<CheckAndApplyTenantChangesActor*>(this)));
															#line 476 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 138 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		it = self->lastCreatedTenants.cbegin();
															#line 139 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		;
															#line 493 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 129 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (!(it != self->lastDeletedTenants.end()))
															#line 509 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 130 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		Key key = self->specialKeysTenantMapPrefix.withSuffix(self->indexToTenantName(*it));
															#line 131 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_0 = tr->get(key);
															#line 131 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (static_cast<CheckAndApplyTenantChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 519 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckAndApplyTenantChangesActor*>(this)->actor_wait_state = 1;
															#line 131 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckAndApplyTenantChangesActor, 0, Optional<Value> >*>(static_cast<CheckAndApplyTenantChangesActor*>(this)));
															#line 524 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Optional<Value> const& value,int loopDepth) 
	{
															#line 133 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		ASSERT_EQ(value.present(), !lastCommitted);
															#line 134 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		++it;
															#line 548 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Optional<Value> && value,int loopDepth) 
	{
															#line 133 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		ASSERT_EQ(value.present(), !lastCommitted);
															#line 134 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		++it;
															#line 559 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckAndApplyTenantChangesActor*>(this)->actor_wait_state > 0) static_cast<CheckAndApplyTenantChangesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAndApplyTenantChangesActor*>(this)->ActorCallback< CheckAndApplyTenantChangesActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAndApplyTenantChangesActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndApplyTenantChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckAndApplyTenantChangesActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndApplyTenantChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckAndApplyTenantChangesActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndApplyTenantChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 139 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (!(it != self->lastCreatedTenants.end()))
															#line 656 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 140 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		Key key = self->specialKeysTenantMapPrefix.withSuffix(self->indexToTenantName(*it));
															#line 141 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr->get(key);
															#line 141 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (static_cast<CheckAndApplyTenantChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 666 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckAndApplyTenantChangesActor*>(this)->actor_wait_state = 2;
															#line 141 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckAndApplyTenantChangesActor, 1, Optional<Value> >*>(static_cast<CheckAndApplyTenantChangesActor*>(this)));
															#line 671 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Optional<Value> const& value,int loopDepth) 
	{
															#line 143 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		ASSERT_EQ(value.present(), lastCommitted || (self->idx2Tid.contains(*it)));
															#line 145 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (value.present())
															#line 695 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		{
															#line 146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			auto id = self->extractTenantId(value.get());
															#line 147 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			newTenantIds[*it] = id;
															#line 148 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			if (!lastCommitted)
															#line 703 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			{
															#line 149 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
				ASSERT_EQ(id, self->idx2Tid.at(*it));
															#line 707 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			}
		}
															#line 153 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		++it;
															#line 712 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Optional<Value> && value,int loopDepth) 
	{
															#line 143 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		ASSERT_EQ(value.present(), lastCommitted || (self->idx2Tid.contains(*it)));
															#line 145 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (value.present())
															#line 723 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		{
															#line 146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			auto id = self->extractTenantId(value.get());
															#line 147 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			newTenantIds[*it] = id;
															#line 148 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			if (!lastCommitted)
															#line 731 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			{
															#line 149 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
				ASSERT_EQ(id, self->idx2Tid.at(*it));
															#line 735 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			}
		}
															#line 153 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		++it;
															#line 740 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckAndApplyTenantChangesActor*>(this)->actor_wait_state > 0) static_cast<CheckAndApplyTenantChangesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAndApplyTenantChangesActor*>(this)->ActorCallback< CheckAndApplyTenantChangesActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAndApplyTenantChangesActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndApplyTenantChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckAndApplyTenantChangesActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndApplyTenantChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckAndApplyTenantChangesActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndApplyTenantChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckAndApplyTenantChangesActor*>(this)->actor_wait_state > 0) static_cast<CheckAndApplyTenantChangesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAndApplyTenantChangesActor*>(this)->ActorCallback< CheckAndApplyTenantChangesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAndApplyTenantChangesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndApplyTenantChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckAndApplyTenantChangesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndApplyTenantChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckAndApplyTenantChangesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndApplyTenantChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	Database cx;
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	RawTenantAccessWorkload* self;
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	bool lastCommitted;
															#line 120 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	std::unordered_map<int, int64_t> newTenantIds;
															#line 122 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	std::set<int>::const_iterator it;
															#line 919 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
};
// This generated class is to be used only via checkAndApplyTenantChanges()
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
class CheckAndApplyTenantChangesActor final : public Actor<Void>, public ActorCallback< CheckAndApplyTenantChangesActor, 0, Optional<Value> >, public ActorCallback< CheckAndApplyTenantChangesActor, 1, Optional<Value> >, public ActorCallback< CheckAndApplyTenantChangesActor, 2, Void >, public FastAllocated<CheckAndApplyTenantChangesActor>, public CheckAndApplyTenantChangesActorState<CheckAndApplyTenantChangesActor> {
															#line 924 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
public:
	using FastAllocated<CheckAndApplyTenantChangesActor>::operator new;
	using FastAllocated<CheckAndApplyTenantChangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9846201300934243584UL, 8223249123038936064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckAndApplyTenantChangesActor, 0, Optional<Value> >;
friend struct ActorCallback< CheckAndApplyTenantChangesActor, 1, Optional<Value> >;
friend struct ActorCallback< CheckAndApplyTenantChangesActor, 2, Void >;
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	CheckAndApplyTenantChangesActor(Database const& cx,RawTenantAccessWorkload* const& self,bool const& lastCommitted) 
															#line 943 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   CheckAndApplyTenantChangesActorState<CheckAndApplyTenantChangesActor>(cx, self, lastCommitted),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(245478444692322560UL, 2792344717110309632UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndApplyTenantChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkAndApplyTenantChanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkAndApplyTenantChanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckAndApplyTenantChangesActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckAndApplyTenantChangesActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckAndApplyTenantChangesActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
[[nodiscard]] static Future<Void> checkAndApplyTenantChanges( Database const& cx, RawTenantAccessWorkload* const& self, bool const& lastCommitted ) {
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	return Future<Void>(new CheckAndApplyTenantChangesActor(cx, self, lastCommitted));
															#line 977 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
}

#line 173 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (clientId == 0) {
			return ready(timeout(_start(cx, this), testDuration));
		}
		return Void();
	}

	int64_t chooseNonexistentTenant() const {
		ASSERT(hasNonexistentTenant());
		int tenantIdx = deterministicRandom()->randomInt(0, tenantCount);
		// find the nearest nonexistent tenant
		while (idx2Tid.contains(tenantIdx) || lastCreatedTenants.contains(tenantIdx)) {
			tenantIdx++;
			if (tenantIdx == tenantCount) {
				tenantIdx = 0;
			}
		}
		return tenantIdx;
	}

	void createNewTenant(int64_t tenantIdx, Reference<ReadYourWritesTransaction> tr, UID traceId) const {
		tr->set(specialKeysTenantMapPrefix.withSuffix(indexToTenantName(tenantIdx)), ""_sr);
		TraceEvent("RawTenantAccess_CreateNewTenant", traceId).detail("TenantIndex", tenantIdx);
	}

	int64_t chooseExistingTenant() const {
		ASSERT(hasExistingTenant());
		int tenantIdx = deterministicRandom()->randomInt(0, tenantCount);
		// find the nearest existing tenant
		while (true) {
			if (idx2Tid.contains(tenantIdx) && !lastDeletedTenants.contains(tenantIdx)) {
				break;
			}
			tenantIdx++;
			if (tenantIdx == tenantCount) {
				tenantIdx = 0;
			}
		}
		return tenantIdx;
	}

	void deleteExistingTenant(int64_t tenantIdx, Reference<ReadYourWritesTransaction> tr, UID traceId) const {
		Key key = specialKeysTenantMapPrefix.withSuffix(indexToTenantName(tenantIdx));
		tr->clear(key);
		TraceEvent("RawTenantAccess_DeleteExistingTenant", traceId)
		    .detail("TenantIndex", tenantIdx)
		    .detail("TenantId", idx2Tid.at(tenantIdx));
	}

	void writeToExistingTenant(int64_t tenantIdx, Reference<ReadYourWritesTransaction> tr, UID traceId) const {
		// write the raw data
		int64_t tenantId = idx2Tid.at(tenantIdx);
		Key prefix = TenantAPI::idToPrefix(tenantId);
		tr->set(prefix.withSuffix(writeKey), writeValue);
		TraceEvent("RawTenantAccess_WriteToExistingTenant", traceId)
		    .detail("TenantIndex", tenantIdx)
		    .detail("TenantId", tenantId);
	}

	void writeToInvalidTenant(Reference<ReadYourWritesTransaction> tr, UID traceId) const {
		ASSERT(hasNonexistentTenant());
		// determine the invalid tenant id
		int64_t tenantId = TenantInfo::INVALID_TENANT;
		if (deterministicRandom()->coinflip() && lastDeletedTenants.size() > 0) {
			// choose the tenant deleted in the same transaction
			tenantId = idx2Tid.at(*lastDeletedTenants.begin());
		} else {
			// randomly generate a tenant id
			do {
				tenantId = deterministicRandom()->randomInt64(0, std::numeric_limits<int64_t>::max());
			} while (tid2Idx.contains(tenantId));
		}
		ASSERT_GE(tenantId, 0);

		// write to invalid tenant
		Key prefix = TenantAPI::idToPrefix(tenantId);
		tr->set(prefix.withSuffix(writeKey), writeValue);
		TraceEvent("RawTenantAccess_WriteToInvalidTenant", traceId).detail("TenantId", tenantId);
	}

	// return whether the transaction is committed
																#line 1063 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
// This generated class is to be used only via randomTenantTransaction()
															#line 255 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
template <class RandomTenantTransactionActor>
															#line 255 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
class RandomTenantTransactionActorState {
															#line 1069 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
public:
															#line 255 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	RandomTenantTransactionActorState(Database const& cx,RawTenantAccessWorkload* const& self) 
															#line 255 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
															#line 255 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		 : cx(cx),
															#line 255 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		   self(self),
															#line 256 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(cx)),
															#line 257 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		   traceId(deterministicRandom()->randomUniqueID()),
															#line 259 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		   tenantMapChangeOp(false),
															#line 260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		   invalidTenantWriteOp(false),
															#line 261 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		   normalKeyWriteOp(false),
															#line 263 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		   illegalAccessCaught(false),
															#line 264 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		   committed(false)
															#line 1092 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("randomTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	~RandomTenantTransactionActorState() 
	{
		fdb_probe_actor_destroy("randomTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 266 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			self->prepareTransactionOps();
															#line 268 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			;
															#line 1109 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RandomTenantTransactionActorState();
		static_cast<RandomTenantTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 312 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (invalidTenantWriteOp)
															#line 1132 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		{
															#line 313 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			ASSERT(!committed);
															#line 314 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			CODE_PROBE(illegalAccessCaught, "Caught invalid tenant write op.");
															#line 1138 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		}
		else
		{
															#line 315 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			if (tenantMapChangeOp && normalKeyWriteOp)
															#line 1144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			{
															#line 316 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
				ASSERT(!committed);
															#line 317 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
				CODE_PROBE(illegalAccessCaught, "Caught tenant map changing and normal key writing in the same transaction.");
															#line 1150 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			}
			else
			{
															#line 320 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
				ASSERT(!illegalAccessCaught);
															#line 1156 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			}
		}
															#line 322 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		TraceEvent("RawTenantAccess_TransactionResult", traceId).detail("Committed", committed);
															#line 323 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (!static_cast<RandomTenantTransactionActor*>(this)->SAV<bool>::futures) { (void)(committed); this->~RandomTenantTransactionActorState(); static_cast<RandomTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 1163 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		new (&static_cast<RandomTenantTransactionActor*>(this)->SAV< bool >::value()) bool(std::move(committed)); // state_var_RVO
		this->~RandomTenantTransactionActorState();
		static_cast<RandomTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 269 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		tr->reset();
															#line 1182 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		try {
															#line 272 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			tr->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 275 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			i = 0;
															#line 276 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			for(;i < self->txnOps.size();++i) {
															#line 277 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
				switch (self->txnOps[i].first) { case CREATE_TENANT: self->createNewTenant(self->txnOps[i].second, tr, traceId); tenantMapChangeOp = true; break; case DELETE_TENANT: self->deleteExistingTenant(self->txnOps[i].second, tr, traceId); tenantMapChangeOp = true; break; case VALID_WRITE: self->writeToExistingTenant(self->txnOps[i].second, tr, traceId); normalKeyWriteOp = true; break; case INVALID_WRITE: self->writeToInvalidTenant(tr, traceId); invalidTenantWriteOp = true; normalKeyWriteOp = true; break; };
															#line 1194 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			}
															#line 298 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 298 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			if (static_cast<RandomTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1200 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RandomTenantTransactionActor*>(this)->actor_wait_state = 1;
															#line 298 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RandomTenantTransactionActor, 0, Void >*>(static_cast<RandomTenantTransactionActor*>(this)));
															#line 1205 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 302 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			if (e.code() == error_code_illegal_tenant_access)
															#line 1240 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			{
															#line 303 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
				illegalAccessCaught = true;
															#line 1244 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 306 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			TraceEvent("RawTenantAccess_TransactionError", traceId).error(e);
															#line 307 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 307 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			if (static_cast<RandomTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1253 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RandomTenantTransactionActor*>(this)->actor_wait_state = 2;
															#line 307 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RandomTenantTransactionActor, 1, Void >*>(static_cast<RandomTenantTransactionActor*>(this)));
															#line 1258 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 299 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		committed = true;
															#line 1273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 299 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		committed = true;
															#line 1282 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RandomTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<RandomTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RandomTenantTransactionActor*>(this)->ActorCallback< RandomTenantTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomTenantTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RandomTenantTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RandomTenantTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RandomTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<RandomTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RandomTenantTransactionActor*>(this)->ActorCallback< RandomTenantTransactionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomTenantTransactionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RandomTenantTransactionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RandomTenantTransactionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 255 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	Database cx;
															#line 255 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	RawTenantAccessWorkload* self;
															#line 256 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 257 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	UID traceId;
															#line 259 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	bool tenantMapChangeOp;
															#line 260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	bool invalidTenantWriteOp;
															#line 261 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	bool normalKeyWriteOp;
															#line 263 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	bool illegalAccessCaught;
															#line 264 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	bool committed;
															#line 275 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	int i;
															#line 1469 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
};
// This generated class is to be used only via randomTenantTransaction()
															#line 255 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
class RandomTenantTransactionActor final : public Actor<bool>, public ActorCallback< RandomTenantTransactionActor, 0, Void >, public ActorCallback< RandomTenantTransactionActor, 1, Void >, public FastAllocated<RandomTenantTransactionActor>, public RandomTenantTransactionActorState<RandomTenantTransactionActor> {
															#line 1474 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
public:
	using FastAllocated<RandomTenantTransactionActor>::operator new;
	using FastAllocated<RandomTenantTransactionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5000930667673005824UL, 6993548638045722368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RandomTenantTransactionActor, 0, Void >;
friend struct ActorCallback< RandomTenantTransactionActor, 1, Void >;
															#line 255 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	RandomTenantTransactionActor(Database const& cx,RawTenantAccessWorkload* const& self) 
															#line 1492 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   RandomTenantTransactionActorState<RandomTenantTransactionActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("randomTenantTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16185192391333018880UL, 7555885806091399168UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("randomTenantTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("randomTenantTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RandomTenantTransactionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RandomTenantTransactionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 255 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
[[nodiscard]] static Future<bool> randomTenantTransaction( Database const& cx, RawTenantAccessWorkload* const& self ) {
															#line 255 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	return Future<bool>(new RandomTenantTransactionActor(cx, self));
															#line 1525 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
}

#line 325 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"

	// clear tenant data to make sure the random tenant deletions are success
																#line 1531 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
// This generated class is to be used only via clearAllTenantData()
															#line 327 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
template <class ClearAllTenantDataActor>
															#line 327 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
class ClearAllTenantDataActorState {
															#line 1537 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
public:
															#line 327 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	ClearAllTenantDataActorState(Database const& cx,RawTenantAccessWorkload* const& self) 
															#line 327 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
															#line 327 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		 : cx(cx),
															#line 327 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		   self(self)
															#line 1546 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("clearAllTenantData", reinterpret_cast<unsigned long>(this));

	}
	~ClearAllTenantDataActorState() 
	{
		fdb_probe_actor_destroy("clearAllTenantData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 328 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			RawTenantAccessWorkload* workload = self;
															#line 329 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runRYWTransaction(cx, [workload](Reference<ReadYourWritesTransaction> tr) { tr->setOption(FDBTransactionOptions::RAW_ACCESS); for (auto [tid, _] : workload->tid2Idx) { Key prefix = TenantAPI::idToPrefix(tid); tr->clear(prefix.withSuffix(workload->writeKey)); } return Future<Void>(Void()); });
															#line 329 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			if (static_cast<ClearAllTenantDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1565 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearAllTenantDataActor*>(this)->actor_wait_state = 1;
															#line 329 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearAllTenantDataActor, 0, Void >*>(static_cast<ClearAllTenantDataActor*>(this)));
															#line 1570 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearAllTenantDataActorState();
		static_cast<ClearAllTenantDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 337 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (!static_cast<ClearAllTenantDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearAllTenantDataActorState(); static_cast<ClearAllTenantDataActor*>(this)->destroy(); return 0; }
															#line 1593 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		new (&static_cast<ClearAllTenantDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearAllTenantDataActorState();
		static_cast<ClearAllTenantDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 337 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (!static_cast<ClearAllTenantDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearAllTenantDataActorState(); static_cast<ClearAllTenantDataActor*>(this)->destroy(); return 0; }
															#line 1605 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		new (&static_cast<ClearAllTenantDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearAllTenantDataActorState();
		static_cast<ClearAllTenantDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearAllTenantDataActor*>(this)->actor_wait_state > 0) static_cast<ClearAllTenantDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAllTenantDataActor*>(this)->ActorCallback< ClearAllTenantDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAllTenantDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAllTenantData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllTenantDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllTenantData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearAllTenantDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAllTenantData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllTenantDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllTenantData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearAllTenantDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAllTenantData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllTenantDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAllTenantData", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 327 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	Database cx;
															#line 327 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	RawTenantAccessWorkload* self;
															#line 1692 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
};
// This generated class is to be used only via clearAllTenantData()
															#line 327 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
class ClearAllTenantDataActor final : public Actor<Void>, public ActorCallback< ClearAllTenantDataActor, 0, Void >, public FastAllocated<ClearAllTenantDataActor>, public ClearAllTenantDataActorState<ClearAllTenantDataActor> {
															#line 1697 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
public:
	using FastAllocated<ClearAllTenantDataActor>::operator new;
	using FastAllocated<ClearAllTenantDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10948522529080333568UL, 1084375712337660928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearAllTenantDataActor, 0, Void >;
															#line 327 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	ClearAllTenantDataActor(Database const& cx,RawTenantAccessWorkload* const& self) 
															#line 1714 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ClearAllTenantDataActorState<ClearAllTenantDataActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearAllTenantData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4335027845540249600UL, 10109998068086845440UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAllTenantDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearAllTenantData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearAllTenantData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearAllTenantDataActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 327 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
[[nodiscard]] static Future<Void> clearAllTenantData( Database const& cx, RawTenantAccessWorkload* const& self ) {
															#line 327 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	return Future<Void>(new ClearAllTenantDataActor(cx, self));
															#line 1746 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
}

#line 339 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"

	void prepareTransactionOps() {
		// 1. create/delete tenant and write to a tenant is an illegal operation for now. (tenantMapChange &&
		// normalKeyWriteOp == true)
		// 2. write a nonexistent tenant is illegal. (invalidTenantWriteOp == true)
		bool legalTxnOnly = deterministicRandom()->coinflip(); // whether allow generating illegal transaction
		bool validTenantWriteOnly = deterministicRandom()->coinflip(); // whether only write to existing tenants
		bool noTenantChange = deterministicRandom()->coinflip();

		bool normalKeyWriteOp = false;
		bool tenantMapChangeOp = false;

		txnOps.clear();
		lastDeletedTenants.clear();
		lastCreatedTenants.clear();
		for (int i = 0; i < 10; ++i) {
			int op = deterministicRandom()->randomInt(0, 4);
			if (op == 0 && hasNonexistentTenant() && !(legalTxnOnly && normalKeyWriteOp) && !noTenantChange) {
				// whether to create a new Tenant
				txnOps.emplace_back(CREATE_TENANT, chooseNonexistentTenant());
				lastCreatedTenants.emplace(txnOps.back().second);
				tenantMapChangeOp = true;
			} else if (op == 1 && hasExistingTenant() && !(legalTxnOnly && normalKeyWriteOp) && !noTenantChange) {
				// whether to delete an existing tenant
				txnOps.emplace_back(DELETE_TENANT, chooseExistingTenant());
				lastDeletedTenants.emplace(txnOps.back().second);
				tenantMapChangeOp = true;
			} else if (op == 2 && hasNonexistentTenant() && !legalTxnOnly && !validTenantWriteOnly) {
				// whether to write to a nonexistent tenant
				txnOps.emplace_back(INVALID_WRITE, -1);
				normalKeyWriteOp = true;
			} else if (op == 3 && hasExistingTenant() && !(legalTxnOnly && tenantMapChangeOp)) {
				// whether to write to an existing tenant
				txnOps.emplace_back(VALID_WRITE, chooseExistingTenant());
				normalKeyWriteOp = true;
			}
		}
	}

																#line 1789 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 378 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
template <class _startActor>
															#line 378 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
class _startActorState {
															#line 1795 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
public:
															#line 378 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	_startActorState(Database const& cx,RawTenantAccessWorkload* const& self) 
															#line 378 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
															#line 378 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		 : cx(cx),
															#line 378 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		   self(self),
															#line 379 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		   lastCommitted(true)
															#line 1806 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 380 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
			;
															#line 1821 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 381 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_0 = checkAndApplyTenantChanges(cx, self, lastCommitted);
															#line 381 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1853 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 381 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1858 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 382 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = clearAllTenantData(cx, self);
															#line 382 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1869 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 382 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1874 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 382 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = clearAllTenantData(cx, self);
															#line 382 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1885 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 382 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1890 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 383 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = store(lastCommitted, randomTenantTransaction(cx, self));
															#line 383 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1976 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 383 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1981 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 383 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = store(lastCommitted, randomTenantTransaction(cx, self));
															#line 383 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1992 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 383 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1997 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 384 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(0.5);
															#line 384 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2083 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 384 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 2088 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 384 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(0.5);
															#line 384 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2099 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 384 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 2104 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 378 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	Database cx;
															#line 378 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	RawTenantAccessWorkload* self;
															#line 379 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	bool lastCommitted;
															#line 2277 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 378 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 2282 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(624606739155006464UL, 16309787852547633920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
															#line 378 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	_startActor(Database const& cx,RawTenantAccessWorkload* const& self) 
															#line 2302 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 378 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, RawTenantAccessWorkload* const& self ) {
															#line 378 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 2337 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RawTenantAccessWorkload.actor.g.cpp"
}

#line 387 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/RawTenantAccessWorkload.actor.cpp"

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<RawTenantAccessWorkload> RawTenantAccessWorkload;