#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
/*
 * EncryptKeyProxyTest.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BlobCipher.h"
#include "fdbclient/EncryptKeyProxyInterface.h"
#include "fdbclient/GetEncryptCipherKeys.h"

#include "fdbrpc/Locality.h"

#include "fdbserver/Knobs.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/Status.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"

#include "flow/Arena.h"
#include "flow/EncryptUtils.h"
#include "flow/Error.h"
#include "flow/FastRef.h"
#include "flow/Trace.h"
#include "flow/IRandom.h"
#include "flow/flow.h"
#include "flow/xxhash.h"

#include <atomic>
#include <boost/range/const_iterator.hpp>
#include <unordered_map>
#include <unordered_set>
#include <utility>

#include "flow/actorcompiler.h" // This must be the last #include.

struct EncryptKeyProxyTestWorkload : TestWorkload {
	static constexpr auto NAME = "EncryptKeyProxyTest";
	Reference<AsyncVar<struct ServerDBInfo> const> dbInfo;
	Arena arena;
	uint64_t minDomainId;
	uint64_t maxDomainId;
	using CacheKey = std::pair<int64_t, uint64_t>;
	std::unordered_map<CacheKey, StringRef, boost::hash<CacheKey>> cipherIdMap;
	std::vector<CacheKey> cipherIds;
	int numDomains;
	static std::atomic<int> seed;
	bool enableTest;

	EncryptKeyProxyTestWorkload(WorkloadContext const& wcx) : TestWorkload(wcx), dbInfo(wcx.dbInfo), enableTest(false) {
		if (wcx.clientId == 0) {
			enableTest = true;
			minDomainId = 1000 + (++seed * 30) + 1;
			maxDomainId = deterministicRandom()->randomInt(minDomainId, minDomainId + 50) + 5;
			TraceEvent("EKPTestInit").detail("MinDomainId", minDomainId).detail("MaxDomainId", maxDomainId);
		}
	}

	Future<Void> setup(Database const& ctx) override { return Void(); }

																#line 76 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
// This generated class is to be used only via simEmptyDomainIdCache()
															#line 74 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
template <class SimEmptyDomainIdCacheActor>
															#line 74 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
class SimEmptyDomainIdCacheActorState {
															#line 82 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
public:
															#line 74 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	SimEmptyDomainIdCacheActorState(EncryptKeyProxyTestWorkload* const& self) 
															#line 74 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
															#line 74 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		 : self(self)
															#line 89 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
	{
		fdb_probe_actor_create("simEmptyDomainIdCache", reinterpret_cast<unsigned long>(this));

	}
	~SimEmptyDomainIdCacheActorState() 
	{
		fdb_probe_actor_destroy("simEmptyDomainIdCache", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 75 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			TraceEvent("SimEmptyDomainIdCacheStart").log();
															#line 77 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			domainIds = std::unordered_set<EncryptCipherDomainId>();
															#line 78 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			for(int i = 0;i < self->numDomains / 2;i++) {
															#line 79 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				const EncryptCipherDomainId domainId = self->minDomainId + i;
															#line 80 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				domainIds.emplace(domainId);
															#line 112 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
			}
															#line 82 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			StrictFuture<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> __when_expr_0 = GetEncryptCipherKeys<ServerDBInfo>::getLatestEncryptCipherKeys( self->dbInfo, domainIds, BlobCipherMetrics::UsageType::TEST);
															#line 82 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			if (static_cast<SimEmptyDomainIdCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 118 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SimEmptyDomainIdCacheActor*>(this)->actor_wait_state = 1;
															#line 82 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SimEmptyDomainIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*>(static_cast<SimEmptyDomainIdCacheActor*>(this)));
															#line 123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SimEmptyDomainIdCacheActorState();
		static_cast<SimEmptyDomainIdCacheActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& latestCiphers,int loopDepth) 
	{
															#line 86 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		ASSERT_EQ(latestCiphers.size(), domainIds.size());
															#line 88 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		TraceEvent("SimEmptyDomainIdCacheDone").log();
															#line 89 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (!static_cast<SimEmptyDomainIdCacheActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SimEmptyDomainIdCacheActorState(); static_cast<SimEmptyDomainIdCacheActor*>(this)->destroy(); return 0; }
															#line 150 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		new (&static_cast<SimEmptyDomainIdCacheActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SimEmptyDomainIdCacheActorState();
		static_cast<SimEmptyDomainIdCacheActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && latestCiphers,int loopDepth) 
	{
															#line 86 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		ASSERT_EQ(latestCiphers.size(), domainIds.size());
															#line 88 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		TraceEvent("SimEmptyDomainIdCacheDone").log();
															#line 89 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (!static_cast<SimEmptyDomainIdCacheActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SimEmptyDomainIdCacheActorState(); static_cast<SimEmptyDomainIdCacheActor*>(this)->destroy(); return 0; }
															#line 166 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		new (&static_cast<SimEmptyDomainIdCacheActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SimEmptyDomainIdCacheActorState();
		static_cast<SimEmptyDomainIdCacheActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& latestCiphers,int loopDepth) 
	{
		loopDepth = a_body1cont1(latestCiphers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && latestCiphers,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(latestCiphers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SimEmptyDomainIdCacheActor*>(this)->actor_wait_state > 0) static_cast<SimEmptyDomainIdCacheActor*>(this)->actor_wait_state = 0;
		static_cast<SimEmptyDomainIdCacheActor*>(this)->ActorCallback< SimEmptyDomainIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >::remove();

	}
	void a_callback_fire(ActorCallback< SimEmptyDomainIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& value) 
	{
		fdb_probe_actor_enter("simEmptyDomainIdCache", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimEmptyDomainIdCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simEmptyDomainIdCache", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SimEmptyDomainIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && value) 
	{
		fdb_probe_actor_enter("simEmptyDomainIdCache", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimEmptyDomainIdCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simEmptyDomainIdCache", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SimEmptyDomainIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,Error err) 
	{
		fdb_probe_actor_enter("simEmptyDomainIdCache", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimEmptyDomainIdCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simEmptyDomainIdCache", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 74 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	EncryptKeyProxyTestWorkload* self;
															#line 77 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	std::unordered_set<EncryptCipherDomainId> domainIds;
															#line 253 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
};
// This generated class is to be used only via simEmptyDomainIdCache()
															#line 74 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
class SimEmptyDomainIdCacheActor final : public Actor<Void>, public ActorCallback< SimEmptyDomainIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >, public FastAllocated<SimEmptyDomainIdCacheActor>, public SimEmptyDomainIdCacheActorState<SimEmptyDomainIdCacheActor> {
															#line 258 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
public:
	using FastAllocated<SimEmptyDomainIdCacheActor>::operator new;
	using FastAllocated<SimEmptyDomainIdCacheActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14162570009067528192UL, 3380432238942584576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SimEmptyDomainIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >;
															#line 74 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	SimEmptyDomainIdCacheActor(EncryptKeyProxyTestWorkload* const& self) 
															#line 275 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		 : Actor<Void>(),
		   SimEmptyDomainIdCacheActorState<SimEmptyDomainIdCacheActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("simEmptyDomainIdCache", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9203405215018085888UL, 1693021132213512448UL);
		ActorExecutionContextHelper __helper(static_cast<SimEmptyDomainIdCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("simEmptyDomainIdCache");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("simEmptyDomainIdCache", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SimEmptyDomainIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 74 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
[[nodiscard]] Future<Void> simEmptyDomainIdCache( EncryptKeyProxyTestWorkload* const& self ) {
															#line 74 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	return Future<Void>(new SimEmptyDomainIdCacheActor(self));
															#line 307 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
}

#line 91 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"

																#line 312 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
// This generated class is to be used only via simPartialDomainIdCache()
															#line 92 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
template <class SimPartialDomainIdCacheActor>
															#line 92 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
class SimPartialDomainIdCacheActorState {
															#line 318 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
public:
															#line 92 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	SimPartialDomainIdCacheActorState(EncryptKeyProxyTestWorkload* const& self) 
															#line 92 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
															#line 92 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		 : self(self)
															#line 325 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
	{
		fdb_probe_actor_create("simPartialDomainIdCache", reinterpret_cast<unsigned long>(this));

	}
	~SimPartialDomainIdCacheActorState() 
	{
		fdb_probe_actor_destroy("simPartialDomainIdCache", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 93 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			TraceEvent("SimPartialDomainIdCacheStart");
															#line 97 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			expectedHits = deterministicRandom()->randomInt(1, self->numDomains / 2);
															#line 98 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			std::unordered_set<EncryptCipherDomainId> domainIds;
															#line 99 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			for(int i = 0;i < expectedHits;i++) {
															#line 100 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				const EncryptCipherDomainId domainId = self->minDomainId + i;
															#line 101 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				domainIds.emplace(domainId);
															#line 350 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
			}
															#line 104 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			expectedMisses = deterministicRandom()->randomInt(1, self->numDomains / 2);
															#line 105 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			for(int i = 0;i < expectedMisses;i++) {
															#line 106 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				const EncryptCipherDomainId domainId = self->minDomainId + i + self->numDomains / 2 + 1;
															#line 107 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				domainIds.emplace(domainId);
															#line 360 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
			}
															#line 109 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			StrictFuture<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> __when_expr_0 = GetEncryptCipherKeys<ServerDBInfo>::getLatestEncryptCipherKeys( self->dbInfo, domainIds, BlobCipherMetrics::UsageType::TEST);
															#line 109 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			if (static_cast<SimPartialDomainIdCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 366 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SimPartialDomainIdCacheActor*>(this)->actor_wait_state = 1;
															#line 109 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SimPartialDomainIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*>(static_cast<SimPartialDomainIdCacheActor*>(this)));
															#line 371 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SimPartialDomainIdCacheActorState();
		static_cast<SimPartialDomainIdCacheActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& latestCiphers,int loopDepth) 
	{
															#line 113 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		TraceEvent("SimPartialDomainIdCacheEnd");
															#line 114 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (!static_cast<SimPartialDomainIdCacheActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SimPartialDomainIdCacheActorState(); static_cast<SimPartialDomainIdCacheActor*>(this)->destroy(); return 0; }
															#line 396 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		new (&static_cast<SimPartialDomainIdCacheActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SimPartialDomainIdCacheActorState();
		static_cast<SimPartialDomainIdCacheActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && latestCiphers,int loopDepth) 
	{
															#line 113 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		TraceEvent("SimPartialDomainIdCacheEnd");
															#line 114 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (!static_cast<SimPartialDomainIdCacheActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SimPartialDomainIdCacheActorState(); static_cast<SimPartialDomainIdCacheActor*>(this)->destroy(); return 0; }
															#line 410 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		new (&static_cast<SimPartialDomainIdCacheActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SimPartialDomainIdCacheActorState();
		static_cast<SimPartialDomainIdCacheActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& latestCiphers,int loopDepth) 
	{
		loopDepth = a_body1cont1(latestCiphers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && latestCiphers,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(latestCiphers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SimPartialDomainIdCacheActor*>(this)->actor_wait_state > 0) static_cast<SimPartialDomainIdCacheActor*>(this)->actor_wait_state = 0;
		static_cast<SimPartialDomainIdCacheActor*>(this)->ActorCallback< SimPartialDomainIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >::remove();

	}
	void a_callback_fire(ActorCallback< SimPartialDomainIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& value) 
	{
		fdb_probe_actor_enter("simPartialDomainIdCache", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimPartialDomainIdCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simPartialDomainIdCache", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SimPartialDomainIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && value) 
	{
		fdb_probe_actor_enter("simPartialDomainIdCache", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimPartialDomainIdCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simPartialDomainIdCache", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SimPartialDomainIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,Error err) 
	{
		fdb_probe_actor_enter("simPartialDomainIdCache", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimPartialDomainIdCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simPartialDomainIdCache", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 92 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	EncryptKeyProxyTestWorkload* self;
															#line 97 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	int expectedHits;
															#line 104 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	int expectedMisses;
															#line 499 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
};
// This generated class is to be used only via simPartialDomainIdCache()
															#line 92 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
class SimPartialDomainIdCacheActor final : public Actor<Void>, public ActorCallback< SimPartialDomainIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >, public FastAllocated<SimPartialDomainIdCacheActor>, public SimPartialDomainIdCacheActorState<SimPartialDomainIdCacheActor> {
															#line 504 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
public:
	using FastAllocated<SimPartialDomainIdCacheActor>::operator new;
	using FastAllocated<SimPartialDomainIdCacheActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9544677815948403968UL, 8783096550195129344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SimPartialDomainIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >;
															#line 92 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	SimPartialDomainIdCacheActor(EncryptKeyProxyTestWorkload* const& self) 
															#line 521 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		 : Actor<Void>(),
		   SimPartialDomainIdCacheActorState<SimPartialDomainIdCacheActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("simPartialDomainIdCache", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2126677883596197376UL, 15400851003400194048UL);
		ActorExecutionContextHelper __helper(static_cast<SimPartialDomainIdCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("simPartialDomainIdCache");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("simPartialDomainIdCache", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SimPartialDomainIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 92 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
[[nodiscard]] Future<Void> simPartialDomainIdCache( EncryptKeyProxyTestWorkload* const& self ) {
															#line 92 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	return Future<Void>(new SimPartialDomainIdCacheActor(self));
															#line 553 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
}

#line 116 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"

																#line 558 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
// This generated class is to be used only via simRandomBaseCipherIdCache()
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
template <class SimRandomBaseCipherIdCacheActor>
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
class SimRandomBaseCipherIdCacheActorState {
															#line 564 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
public:
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	SimRandomBaseCipherIdCacheActorState(EncryptKeyProxyTestWorkload* const& self) 
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		 : self(self)
															#line 571 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
	{
		fdb_probe_actor_create("simRandomBaseCipherIdCache", reinterpret_cast<unsigned long>(this));

	}
	~SimRandomBaseCipherIdCacheActorState() 
	{
		fdb_probe_actor_destroy("simRandomBaseCipherIdCache", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 118 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			TraceEvent("SimRandomDomainIdCacheStart");
															#line 121 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			std::unordered_set<EncryptCipherDomainId> domainIds;
															#line 122 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			for(int i = 0;i < self->numDomains;i++) {
															#line 123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				const EncryptCipherDomainId domainId = self->minDomainId + i;
															#line 124 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				domainIds.emplace(domainId);
															#line 594 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
			}
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			StrictFuture<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> __when_expr_0 = GetEncryptCipherKeys<ServerDBInfo>::getLatestEncryptCipherKeys( self->dbInfo, domainIds, BlobCipherMetrics::UsageType::TEST);
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			if (static_cast<SimRandomBaseCipherIdCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 600 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SimRandomBaseCipherIdCacheActor*>(this)->actor_wait_state = 1;
															#line 127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SimRandomBaseCipherIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*>(static_cast<SimRandomBaseCipherIdCacheActor*>(this)));
															#line 605 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SimRandomBaseCipherIdCacheActorState();
		static_cast<SimRandomBaseCipherIdCacheActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& latestCiphers,int loopDepth) 
	{
															#line 130 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		cipherKeysVec = std::vector<Reference<BlobCipherKey>>();
															#line 131 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		for( auto item : latestCiphers ) {
															#line 132 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			cipherKeysVec.push_back(item.second);
															#line 632 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		}
															#line 135 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		numIterations = deterministicRandom()->randomInt(512, 786);
															#line 136 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		;
															#line 638 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && latestCiphers,int loopDepth) 
	{
															#line 130 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		cipherKeysVec = std::vector<Reference<BlobCipherKey>>();
															#line 131 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		for( auto item : latestCiphers ) {
															#line 132 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			cipherKeysVec.push_back(item.second);
															#line 651 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		}
															#line 135 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		numIterations = deterministicRandom()->randomInt(512, 786);
															#line 136 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		;
															#line 657 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& latestCiphers,int loopDepth) 
	{
		loopDepth = a_body1cont1(latestCiphers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && latestCiphers,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(latestCiphers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SimRandomBaseCipherIdCacheActor*>(this)->actor_wait_state > 0) static_cast<SimRandomBaseCipherIdCacheActor*>(this)->actor_wait_state = 0;
		static_cast<SimRandomBaseCipherIdCacheActor*>(this)->ActorCallback< SimRandomBaseCipherIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >::remove();

	}
	void a_callback_fire(ActorCallback< SimRandomBaseCipherIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& value) 
	{
		fdb_probe_actor_enter("simRandomBaseCipherIdCache", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimRandomBaseCipherIdCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simRandomBaseCipherIdCache", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SimRandomBaseCipherIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && value) 
	{
		fdb_probe_actor_enter("simRandomBaseCipherIdCache", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimRandomBaseCipherIdCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simRandomBaseCipherIdCache", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SimRandomBaseCipherIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,Error err) 
	{
		fdb_probe_actor_enter("simRandomBaseCipherIdCache", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimRandomBaseCipherIdCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simRandomBaseCipherIdCache", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 171 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		TraceEvent("SimRandomDomainIdCacheDone");
															#line 172 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (!static_cast<SimRandomBaseCipherIdCacheActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SimRandomBaseCipherIdCacheActorState(); static_cast<SimRandomBaseCipherIdCacheActor*>(this)->destroy(); return 0; }
															#line 743 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		new (&static_cast<SimRandomBaseCipherIdCacheActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SimRandomBaseCipherIdCacheActorState();
		static_cast<SimRandomBaseCipherIdCacheActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 136 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (!(numIterations > 0))
															#line 762 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 138 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		int idx = deterministicRandom()->randomInt(1, cipherKeysVec.size());
															#line 139 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		int nIds = deterministicRandom()->randomInt(1, cipherKeysVec.size());
															#line 140 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		std::unordered_set<BlobCipherDetails> cipherDetails;
															#line 141 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		for(int count = 0;count < nIds && idx < cipherKeysVec.size();count++, idx++) {
															#line 142 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			cipherDetails.emplace(cipherKeysVec[idx]->getDomainId(), cipherKeysVec[idx]->getBaseCipherId(), cipherKeysVec[idx]->getSalt());
															#line 776 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		}
															#line 146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		ASSERT_LE(cipherDetails.size(), cipherKeysVec.size());
															#line 147 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		TraceEvent("SimRandomDomainIdCacheStart").detail("Count", cipherDetails.size());
															#line 148 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (cipherDetails.empty())
															#line 784 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		{
			return a_body1cont1loopHead1(loopDepth); // continue
		}
		else
		{
															#line 152 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			numIterations--;
															#line 792 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		}
															#line 155 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		StrictFuture<std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>>> __when_expr_1 = GetEncryptCipherKeys<ServerDBInfo>::getEncryptCipherKeys( self->dbInfo, cipherDetails, BlobCipherMetrics::UsageType::TEST);
															#line 155 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (static_cast<SimRandomBaseCipherIdCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 798 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SimRandomBaseCipherIdCacheActor*>(this)->actor_wait_state = 2;
															#line 155 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SimRandomBaseCipherIdCacheActor, 1, std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >*>(static_cast<SimRandomBaseCipherIdCacheActor*>(this)));
															#line 803 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> const& cipherKeys,int loopDepth) 
	{
															#line 159 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		for( auto item : cipherKeys ) {
															#line 160 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			bool found = false;
															#line 161 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			for( auto key : cipherKeysVec ) {
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				if (key->isEqual(item.second))
															#line 831 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
				{
															#line 163 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
					found = true;
															#line 835 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
					break;
				}
			}
															#line 167 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			ASSERT(found);
															#line 841 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> && cipherKeys,int loopDepth) 
	{
															#line 159 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		for( auto item : cipherKeys ) {
															#line 160 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			bool found = false;
															#line 161 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			for( auto key : cipherKeysVec ) {
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				if (key->isEqual(item.second))
															#line 857 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
				{
															#line 163 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
					found = true;
															#line 861 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
					break;
				}
			}
															#line 167 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			ASSERT(found);
															#line 867 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> const& cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(cipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> && cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(cipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SimRandomBaseCipherIdCacheActor*>(this)->actor_wait_state > 0) static_cast<SimRandomBaseCipherIdCacheActor*>(this)->actor_wait_state = 0;
		static_cast<SimRandomBaseCipherIdCacheActor*>(this)->ActorCallback< SimRandomBaseCipherIdCacheActor, 1, std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >::remove();

	}
	void a_callback_fire(ActorCallback< SimRandomBaseCipherIdCacheActor, 1, std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >*,std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> const& value) 
	{
		fdb_probe_actor_enter("simRandomBaseCipherIdCache", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimRandomBaseCipherIdCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simRandomBaseCipherIdCache", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SimRandomBaseCipherIdCacheActor, 1, std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >*,std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> && value) 
	{
		fdb_probe_actor_enter("simRandomBaseCipherIdCache", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimRandomBaseCipherIdCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simRandomBaseCipherIdCache", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SimRandomBaseCipherIdCacheActor, 1, std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >*,Error err) 
	{
		fdb_probe_actor_enter("simRandomBaseCipherIdCache", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimRandomBaseCipherIdCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simRandomBaseCipherIdCache", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	EncryptKeyProxyTestWorkload* self;
															#line 130 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	std::vector<Reference<BlobCipherKey>> cipherKeysVec;
															#line 135 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	int numIterations;
															#line 954 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
};
// This generated class is to be used only via simRandomBaseCipherIdCache()
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
class SimRandomBaseCipherIdCacheActor final : public Actor<Void>, public ActorCallback< SimRandomBaseCipherIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >, public ActorCallback< SimRandomBaseCipherIdCacheActor, 1, std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >, public FastAllocated<SimRandomBaseCipherIdCacheActor>, public SimRandomBaseCipherIdCacheActorState<SimRandomBaseCipherIdCacheActor> {
															#line 959 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
public:
	using FastAllocated<SimRandomBaseCipherIdCacheActor>::operator new;
	using FastAllocated<SimRandomBaseCipherIdCacheActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18210855440445701888UL, 15235279366091100672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SimRandomBaseCipherIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >;
friend struct ActorCallback< SimRandomBaseCipherIdCacheActor, 1, std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >;
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	SimRandomBaseCipherIdCacheActor(EncryptKeyProxyTestWorkload* const& self) 
															#line 977 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		 : Actor<Void>(),
		   SimRandomBaseCipherIdCacheActorState<SimRandomBaseCipherIdCacheActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("simRandomBaseCipherIdCache", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4156610593885253120UL, 2809067453361506816UL);
		ActorExecutionContextHelper __helper(static_cast<SimRandomBaseCipherIdCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("simRandomBaseCipherIdCache");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("simRandomBaseCipherIdCache", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SimRandomBaseCipherIdCacheActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SimRandomBaseCipherIdCacheActor, 1, std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
[[nodiscard]] Future<Void> simRandomBaseCipherIdCache( EncryptKeyProxyTestWorkload* const& self ) {
															#line 117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	return Future<Void>(new SimRandomBaseCipherIdCacheActor(self));
															#line 1010 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
}

#line 174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"

																#line 1015 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
// This generated class is to be used only via simLookupInvalidKeyId()
															#line 175 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
template <class SimLookupInvalidKeyIdActor>
															#line 175 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
class SimLookupInvalidKeyIdActorState {
															#line 1021 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
public:
															#line 175 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	SimLookupInvalidKeyIdActorState(EncryptKeyProxyTestWorkload* const& self) 
															#line 175 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
															#line 175 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		 : self(self)
															#line 1028 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
	{
		fdb_probe_actor_create("simLookupInvalidKeyId", reinterpret_cast<unsigned long>(this));

	}
	~SimLookupInvalidKeyIdActorState() 
	{
		fdb_probe_actor_destroy("simLookupInvalidKeyId", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 176 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			TraceEvent("SimLookupInvalidKeyIdStart").log();
															#line 178 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			Arena arena;
															#line 1045 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
			try {
															#line 180 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				Reference<BlobCipherKeyCache> cipherKeyCache = BlobCipherKeyCache::getInstance();
															#line 183 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				std::unordered_set<EncryptCipherDomainId> domainIds;
															#line 184 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				for( auto item : self->cipherIds ) {
															#line 185 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
					domainIds.emplace(item.second);
															#line 187 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
					cipherKeyCache->resetEncryptDomainId(item.second);
															#line 1057 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
				}
															#line 189 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				domainIds.emplace(FDB_DEFAULT_ENCRYPT_DOMAIN_ID - 1);
															#line 190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				StrictFuture<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> __when_expr_0 = GetEncryptCipherKeys<ServerDBInfo>::getLatestEncryptCipherKeys( self->dbInfo, domainIds, BlobCipherMetrics::UsageType::TEST);
															#line 190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				if (static_cast<SimLookupInvalidKeyIdActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1065 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SimLookupInvalidKeyIdActor*>(this)->actor_wait_state = 1;
															#line 190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SimLookupInvalidKeyIdActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*>(static_cast<SimLookupInvalidKeyIdActor*>(this)));
															#line 1070 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SimLookupInvalidKeyIdActorState();
		static_cast<SimLookupInvalidKeyIdActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 199 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		TraceEvent("SimLookupInvalidKeyIdDone");
															#line 200 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (!static_cast<SimLookupInvalidKeyIdActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SimLookupInvalidKeyIdActorState(); static_cast<SimLookupInvalidKeyIdActor*>(this)->destroy(); return 0; }
															#line 1101 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		new (&static_cast<SimLookupInvalidKeyIdActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SimLookupInvalidKeyIdActorState();
		static_cast<SimLookupInvalidKeyIdActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 196 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			ASSERT(e.code() == error_code_encrypt_key_not_found);
															#line 1114 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& res,int loopDepth) 
	{
															#line 194 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		ASSERT(false);
															#line 1129 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && res,int loopDepth) 
	{
															#line 194 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		ASSERT(false);
															#line 1138 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && res,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SimLookupInvalidKeyIdActor*>(this)->actor_wait_state > 0) static_cast<SimLookupInvalidKeyIdActor*>(this)->actor_wait_state = 0;
		static_cast<SimLookupInvalidKeyIdActor*>(this)->ActorCallback< SimLookupInvalidKeyIdActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >::remove();

	}
	void a_callback_fire(ActorCallback< SimLookupInvalidKeyIdActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& value) 
	{
		fdb_probe_actor_enter("simLookupInvalidKeyId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimLookupInvalidKeyIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simLookupInvalidKeyId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SimLookupInvalidKeyIdActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && value) 
	{
		fdb_probe_actor_enter("simLookupInvalidKeyId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimLookupInvalidKeyIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simLookupInvalidKeyId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SimLookupInvalidKeyIdActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,Error err) 
	{
		fdb_probe_actor_enter("simLookupInvalidKeyId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimLookupInvalidKeyIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simLookupInvalidKeyId", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 175 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	EncryptKeyProxyTestWorkload* self;
															#line 1233 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
};
// This generated class is to be used only via simLookupInvalidKeyId()
															#line 175 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
class SimLookupInvalidKeyIdActor final : public Actor<Void>, public ActorCallback< SimLookupInvalidKeyIdActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >, public FastAllocated<SimLookupInvalidKeyIdActor>, public SimLookupInvalidKeyIdActorState<SimLookupInvalidKeyIdActor> {
															#line 1238 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
public:
	using FastAllocated<SimLookupInvalidKeyIdActor>::operator new;
	using FastAllocated<SimLookupInvalidKeyIdActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17894724779379763456UL, 13048373816928586496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SimLookupInvalidKeyIdActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >;
															#line 175 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	SimLookupInvalidKeyIdActor(EncryptKeyProxyTestWorkload* const& self) 
															#line 1255 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		 : Actor<Void>(),
		   SimLookupInvalidKeyIdActorState<SimLookupInvalidKeyIdActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("simLookupInvalidKeyId", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12670959270712071168UL, 10846946806957634560UL);
		ActorExecutionContextHelper __helper(static_cast<SimLookupInvalidKeyIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("simLookupInvalidKeyId");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("simLookupInvalidKeyId", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SimLookupInvalidKeyIdActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 175 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
[[nodiscard]] Future<Void> simLookupInvalidKeyId( EncryptKeyProxyTestWorkload* const& self ) {
															#line 175 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	return Future<Void>(new SimLookupInvalidKeyIdActor(self));
															#line 1287 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
}

#line 202 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"

																#line 1292 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
// This generated class is to be used only via simHealthyKms()
															#line 203 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
template <class SimHealthyKmsActor>
															#line 203 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
class SimHealthyKmsActorState {
															#line 1298 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
public:
															#line 203 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	SimHealthyKmsActorState(EncryptKeyProxyTestWorkload* const& self) 
															#line 203 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
															#line 203 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		 : self(self)
															#line 1305 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
	{
		fdb_probe_actor_create("simHealthyKms", reinterpret_cast<unsigned long>(this));

	}
	~SimHealthyKmsActorState() 
	{
		fdb_probe_actor_destroy("simHealthyKms", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 204 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			TraceEvent("SimHealthyKmsStart").log();
															#line 205 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			;
															#line 1322 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SimHealthyKmsActorState();
		static_cast<SimHealthyKmsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 214 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (!static_cast<SimHealthyKmsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SimHealthyKmsActorState(); static_cast<SimHealthyKmsActor*>(this)->destroy(); return 0; }
															#line 1345 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		new (&static_cast<SimHealthyKmsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SimHealthyKmsActorState();
		static_cast<SimHealthyKmsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 206 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		StrictFuture<KMSHealthStatus> __when_expr_0 = getKMSHealthStatus(self->dbInfo);
															#line 206 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (static_cast<SimHealthyKmsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1366 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<SimHealthyKmsActor*>(this)->actor_wait_state = 1;
															#line 206 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SimHealthyKmsActor, 0, KMSHealthStatus >*>(static_cast<SimHealthyKmsActor*>(this)));
															#line 1371 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(KMSHealthStatus const& status,int loopDepth) 
	{
															#line 207 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (status.canConnectToKms && status.canConnectToEKP)
															#line 1393 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		{
															#line 208 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			ASSERT_GE(status.lastUpdatedTS, 0);
															#line 209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			ASSERT_GE(now(), status.lastUpdatedTS);
															#line 1399 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 212 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(20.0);
															#line 212 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (static_cast<SimHealthyKmsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1406 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SimHealthyKmsActor*>(this)->actor_wait_state = 2;
															#line 212 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SimHealthyKmsActor, 1, Void >*>(static_cast<SimHealthyKmsActor*>(this)));
															#line 1411 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(KMSHealthStatus && status,int loopDepth) 
	{
															#line 207 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (status.canConnectToKms && status.canConnectToEKP)
															#line 1420 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		{
															#line 208 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			ASSERT_GE(status.lastUpdatedTS, 0);
															#line 209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			ASSERT_GE(now(), status.lastUpdatedTS);
															#line 1426 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 212 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(20.0);
															#line 212 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (static_cast<SimHealthyKmsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1433 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SimHealthyKmsActor*>(this)->actor_wait_state = 2;
															#line 212 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SimHealthyKmsActor, 1, Void >*>(static_cast<SimHealthyKmsActor*>(this)));
															#line 1438 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(KMSHealthStatus const& status,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(status, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(KMSHealthStatus && status,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SimHealthyKmsActor*>(this)->actor_wait_state > 0) static_cast<SimHealthyKmsActor*>(this)->actor_wait_state = 0;
		static_cast<SimHealthyKmsActor*>(this)->ActorCallback< SimHealthyKmsActor, 0, KMSHealthStatus >::remove();

	}
	void a_callback_fire(ActorCallback< SimHealthyKmsActor, 0, KMSHealthStatus >*,KMSHealthStatus const& value) 
	{
		fdb_probe_actor_enter("simHealthyKms", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimHealthyKmsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simHealthyKms", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SimHealthyKmsActor, 0, KMSHealthStatus >*,KMSHealthStatus && value) 
	{
		fdb_probe_actor_enter("simHealthyKms", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimHealthyKmsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simHealthyKms", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SimHealthyKmsActor, 0, KMSHealthStatus >*,Error err) 
	{
		fdb_probe_actor_enter("simHealthyKms", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimHealthyKmsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simHealthyKms", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SimHealthyKmsActor*>(this)->actor_wait_state > 0) static_cast<SimHealthyKmsActor*>(this)->actor_wait_state = 0;
		static_cast<SimHealthyKmsActor*>(this)->ActorCallback< SimHealthyKmsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimHealthyKmsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simHealthyKms", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimHealthyKmsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simHealthyKms", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SimHealthyKmsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simHealthyKms", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimHealthyKmsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simHealthyKms", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SimHealthyKmsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simHealthyKms", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimHealthyKmsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simHealthyKms", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 203 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	EncryptKeyProxyTestWorkload* self;
															#line 1607 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
};
// This generated class is to be used only via simHealthyKms()
															#line 203 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
class SimHealthyKmsActor final : public Actor<Void>, public ActorCallback< SimHealthyKmsActor, 0, KMSHealthStatus >, public ActorCallback< SimHealthyKmsActor, 1, Void >, public FastAllocated<SimHealthyKmsActor>, public SimHealthyKmsActorState<SimHealthyKmsActor> {
															#line 1612 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
public:
	using FastAllocated<SimHealthyKmsActor>::operator new;
	using FastAllocated<SimHealthyKmsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12741578152947457280UL, 5518434594252516352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SimHealthyKmsActor, 0, KMSHealthStatus >;
friend struct ActorCallback< SimHealthyKmsActor, 1, Void >;
															#line 203 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	SimHealthyKmsActor(EncryptKeyProxyTestWorkload* const& self) 
															#line 1630 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		 : Actor<Void>(),
		   SimHealthyKmsActorState<SimHealthyKmsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("simHealthyKms", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6136018122974440960UL, 17411698486587977216UL);
		ActorExecutionContextHelper __helper(static_cast<SimHealthyKmsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("simHealthyKms");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("simHealthyKms", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SimHealthyKmsActor, 0, KMSHealthStatus >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SimHealthyKmsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 203 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
[[nodiscard]] Future<Void> simHealthyKms( EncryptKeyProxyTestWorkload* const& self ) {
															#line 203 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	return Future<Void>(new SimHealthyKmsActor(self));
															#line 1663 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
}

#line 216 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"

	// Following test cases are covered:
	// 1. Simulate an empty domainIdCache.
	// 2. Simulate an mixed lookup (partial cache-hit) for domainIdCache.
	// 3. Simulate a lookup on all domainIdCache keys and validate lookup by baseCipherKeyIds.
	// 4. Simulate lookup for an invalid baseCipherKeyId.

																#line 1674 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
// This generated class is to be used only via testWorkload()
															#line 223 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
template <class TestWorkloadActor>
															#line 223 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
class TestWorkloadActorState {
															#line 1680 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
public:
															#line 223 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	TestWorkloadActorState(Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,EncryptKeyProxyTestWorkload* const& self) 
															#line 223 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
															#line 223 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		 : dbInfo(dbInfo),
															#line 223 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		   self(self)
															#line 1689 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
	{
		fdb_probe_actor_create("testWorkload", reinterpret_cast<unsigned long>(this));

	}
	~TestWorkloadActorState() 
	{
		fdb_probe_actor_destroy("testWorkload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 225 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			self->numDomains = self->maxDomainId - self->minDomainId;
															#line 227 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
			;
															#line 1706 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestWorkloadActorState();
		static_cast<TestWorkloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 232 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->simEmptyDomainIdCache(self);
															#line 232 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (static_cast<TestWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1731 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestWorkloadActor*>(this)->actor_wait_state = 2;
															#line 232 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestWorkloadActor, 1, Void >*>(static_cast<TestWorkloadActor*>(this)));
															#line 1736 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 227 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (!(!self->dbInfo->get().client.encryptKeyProxy.present()))
															#line 1752 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 228 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->dbInfo->onChange();
															#line 228 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (static_cast<TestWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1760 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TestWorkloadActor*>(this)->actor_wait_state = 1;
															#line 228 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestWorkloadActor, 0, Void >*>(static_cast<TestWorkloadActor*>(this)));
															#line 1765 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TestWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TestWorkloadActor*>(this)->ActorCallback< TestWorkloadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestWorkloadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestWorkloadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestWorkloadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 235 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->simPartialDomainIdCache(self);
															#line 235 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (static_cast<TestWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1876 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestWorkloadActor*>(this)->actor_wait_state = 3;
															#line 235 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestWorkloadActor, 2, Void >*>(static_cast<TestWorkloadActor*>(this)));
															#line 1881 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 235 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->simPartialDomainIdCache(self);
															#line 235 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (static_cast<TestWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1892 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestWorkloadActor*>(this)->actor_wait_state = 3;
															#line 235 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestWorkloadActor, 2, Void >*>(static_cast<TestWorkloadActor*>(this)));
															#line 1897 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TestWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TestWorkloadActor*>(this)->ActorCallback< TestWorkloadActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestWorkloadActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestWorkloadActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestWorkloadActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 238 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->simRandomBaseCipherIdCache(self);
															#line 238 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (static_cast<TestWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1983 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestWorkloadActor*>(this)->actor_wait_state = 4;
															#line 238 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestWorkloadActor, 3, Void >*>(static_cast<TestWorkloadActor*>(this)));
															#line 1988 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 238 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->simRandomBaseCipherIdCache(self);
															#line 238 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (static_cast<TestWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1999 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestWorkloadActor*>(this)->actor_wait_state = 4;
															#line 238 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestWorkloadActor, 3, Void >*>(static_cast<TestWorkloadActor*>(this)));
															#line 2004 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TestWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TestWorkloadActor*>(this)->ActorCallback< TestWorkloadActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestWorkloadActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestWorkloadActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestWorkloadActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 241 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->simLookupInvalidKeyId(self);
															#line 241 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (static_cast<TestWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2090 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestWorkloadActor*>(this)->actor_wait_state = 5;
															#line 241 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestWorkloadActor, 4, Void >*>(static_cast<TestWorkloadActor*>(this)));
															#line 2095 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 241 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->simLookupInvalidKeyId(self);
															#line 241 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (static_cast<TestWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2106 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestWorkloadActor*>(this)->actor_wait_state = 5;
															#line 241 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestWorkloadActor, 4, Void >*>(static_cast<TestWorkloadActor*>(this)));
															#line 2111 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TestWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TestWorkloadActor*>(this)->ActorCallback< TestWorkloadActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestWorkloadActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestWorkloadActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestWorkloadActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 244 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->simHealthyKms(self);
															#line 244 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (static_cast<TestWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2197 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestWorkloadActor*>(this)->actor_wait_state = 6;
															#line 244 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestWorkloadActor, 5, Void >*>(static_cast<TestWorkloadActor*>(this)));
															#line 2202 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 244 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->simHealthyKms(self);
															#line 244 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (static_cast<TestWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2213 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestWorkloadActor*>(this)->actor_wait_state = 6;
															#line 244 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestWorkloadActor, 5, Void >*>(static_cast<TestWorkloadActor*>(this)));
															#line 2218 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TestWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TestWorkloadActor*>(this)->ActorCallback< TestWorkloadActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestWorkloadActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestWorkloadActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestWorkloadActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 248 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (!static_cast<TestWorkloadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestWorkloadActorState(); static_cast<TestWorkloadActor*>(this)->destroy(); return 0; }
															#line 2302 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		new (&static_cast<TestWorkloadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestWorkloadActorState();
		static_cast<TestWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 248 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
		if (!static_cast<TestWorkloadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestWorkloadActorState(); static_cast<TestWorkloadActor*>(this)->destroy(); return 0; }
															#line 2314 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		new (&static_cast<TestWorkloadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestWorkloadActorState();
		static_cast<TestWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TestWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TestWorkloadActor*>(this)->ActorCallback< TestWorkloadActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestWorkloadActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestWorkloadActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestWorkloadActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 223 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 223 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	EncryptKeyProxyTestWorkload* self;
															#line 2401 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
};
// This generated class is to be used only via testWorkload()
															#line 223 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
class TestWorkloadActor final : public Actor<Void>, public ActorCallback< TestWorkloadActor, 0, Void >, public ActorCallback< TestWorkloadActor, 1, Void >, public ActorCallback< TestWorkloadActor, 2, Void >, public ActorCallback< TestWorkloadActor, 3, Void >, public ActorCallback< TestWorkloadActor, 4, Void >, public ActorCallback< TestWorkloadActor, 5, Void >, public FastAllocated<TestWorkloadActor>, public TestWorkloadActorState<TestWorkloadActor> {
															#line 2406 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
public:
	using FastAllocated<TestWorkloadActor>::operator new;
	using FastAllocated<TestWorkloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1479845174647109376UL, 3765151204179210496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestWorkloadActor, 0, Void >;
friend struct ActorCallback< TestWorkloadActor, 1, Void >;
friend struct ActorCallback< TestWorkloadActor, 2, Void >;
friend struct ActorCallback< TestWorkloadActor, 3, Void >;
friend struct ActorCallback< TestWorkloadActor, 4, Void >;
friend struct ActorCallback< TestWorkloadActor, 5, Void >;
															#line 223 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	TestWorkloadActor(Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,EncryptKeyProxyTestWorkload* const& self) 
															#line 2428 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
		 : Actor<Void>(),
		   TestWorkloadActorState<TestWorkloadActor>(dbInfo, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testWorkload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(971086259083694848UL, 10938677086051258880UL);
		ActorExecutionContextHelper __helper(static_cast<TestWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testWorkload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testWorkload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestWorkloadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestWorkloadActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestWorkloadActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestWorkloadActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestWorkloadActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestWorkloadActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 223 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
[[nodiscard]] Future<Void> testWorkload( Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, EncryptKeyProxyTestWorkload* const& self ) {
															#line 223 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"
	return Future<Void>(new TestWorkloadActor(dbInfo, self));
															#line 2465 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/EncryptKeyProxyTest.actor.g.cpp"
}

#line 250 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/EncryptKeyProxyTest.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (!enableTest) {
			return Void();
		}
		return testWorkload(dbInfo, this);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

std::atomic<int> EncryptKeyProxyTestWorkload::seed = 0;

WorkloadFactory<EncryptKeyProxyTestWorkload> EncryptKeyProxyTestWorkloadFactory;
