#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
/*
 * ClearSingleRange.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct ClearSingleRange : TestWorkload {
	static constexpr auto NAME = "ClearSingleRange";
	Key begin;
	Key end;
	double startDelay;

	ClearSingleRange(WorkloadContext const& wcx) : TestWorkload(wcx) {
		begin = getOption(options, "begin"_sr, normalKeys.begin);
		end = getOption(options, "end"_sr, normalKeys.end);
		startDelay = getOption(options, "beginClearRange"_sr, 10.0);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override { return clientId != 0 ? Void() : fdbClientClearRange(cx, this); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 49 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClearSingleRange.actor.g.cpp"
// This generated class is to be used only via fdbClientClearRange()
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
template <class FdbClientClearRangeActor>
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
class FdbClientClearRangeActorState {
															#line 55 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClearSingleRange.actor.g.cpp"
public:
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
	FdbClientClearRangeActorState(Database const& db,ClearSingleRange* const& self) 
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
		 : db(db),
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
		   self(self),
															#line 48 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
		   tr(db)
															#line 66 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClearSingleRange.actor.g.cpp"
	{
		fdb_probe_actor_create("fdbClientClearRange", reinterpret_cast<unsigned long>(this));

	}
	~FdbClientClearRangeActorState() 
	{
		fdb_probe_actor_destroy("fdbClientClearRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 50 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
				TraceEvent("ClearSingleRange") .detail("Begin", printable(self->begin)) .detail("End", printable(self->end)) .detail("StartDelay", self->startDelay);
															#line 54 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
				tr.setOption(FDBTransactionOptions::NEXT_WRITE_NO_WRITE_CONFLICT_RANGE);
															#line 55 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(self->startDelay);
															#line 55 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
				if (static_cast<FdbClientClearRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 88 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClearSingleRange.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FdbClientClearRangeActor*>(this)->actor_wait_state = 1;
															#line 55 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FdbClientClearRangeActor, 0, Void >*>(static_cast<FdbClientClearRangeActor*>(this)));
															#line 93 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClearSingleRange.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FdbClientClearRangeActorState();
		static_cast<FdbClientClearRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 62 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
		if (!static_cast<FdbClientClearRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FdbClientClearRangeActorState(); static_cast<FdbClientClearRangeActor*>(this)->destroy(); return 0; }
															#line 122 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClearSingleRange.actor.g.cpp"
		new (&static_cast<FdbClientClearRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FdbClientClearRangeActorState();
		static_cast<FdbClientClearRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 59 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
			TraceEvent("ClearRangeError").error(e);
															#line 60 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 60 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
			if (static_cast<FdbClientClearRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 139 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClearSingleRange.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_2.get(), loopDepth); };
			static_cast<FdbClientClearRangeActor*>(this)->actor_wait_state = 3;
															#line 60 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FdbClientClearRangeActor, 2, Void >*>(static_cast<FdbClientClearRangeActor*>(this)));
															#line 144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClearSingleRange.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 56 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
		tr.clear(KeyRangeRef(self->begin, self->end));
															#line 57 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 57 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
		if (static_cast<FdbClientClearRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 163 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClearSingleRange.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<FdbClientClearRangeActor*>(this)->actor_wait_state = 2;
															#line 57 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FdbClientClearRangeActor, 1, Void >*>(static_cast<FdbClientClearRangeActor*>(this)));
															#line 168 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClearSingleRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 56 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
		tr.clear(KeyRangeRef(self->begin, self->end));
															#line 57 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 57 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
		if (static_cast<FdbClientClearRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 181 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClearSingleRange.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<FdbClientClearRangeActor*>(this)->actor_wait_state = 2;
															#line 57 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FdbClientClearRangeActor, 1, Void >*>(static_cast<FdbClientClearRangeActor*>(this)));
															#line 186 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClearSingleRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FdbClientClearRangeActor*>(this)->actor_wait_state > 0) static_cast<FdbClientClearRangeActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientClearRangeActor*>(this)->ActorCallback< FdbClientClearRangeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientClearRangeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FdbClientClearRangeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FdbClientClearRangeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FdbClientClearRangeActor*>(this)->actor_wait_state > 0) static_cast<FdbClientClearRangeActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientClearRangeActor*>(this)->ActorCallback< FdbClientClearRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientClearRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FdbClientClearRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FdbClientClearRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FdbClientClearRangeActor*>(this)->actor_wait_state > 0) static_cast<FdbClientClearRangeActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientClearRangeActor*>(this)->ActorCallback< FdbClientClearRangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientClearRangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FdbClientClearRangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FdbClientClearRangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientClearRange", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
	Database db;
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
	ClearSingleRange* self;
															#line 48 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
	Transaction tr;
															#line 459 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClearSingleRange.actor.g.cpp"
};
// This generated class is to be used only via fdbClientClearRange()
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
class FdbClientClearRangeActor final : public Actor<Void>, public ActorCallback< FdbClientClearRangeActor, 0, Void >, public ActorCallback< FdbClientClearRangeActor, 1, Void >, public ActorCallback< FdbClientClearRangeActor, 2, Void >, public FastAllocated<FdbClientClearRangeActor>, public FdbClientClearRangeActorState<FdbClientClearRangeActor> {
															#line 464 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClearSingleRange.actor.g.cpp"
public:
	using FastAllocated<FdbClientClearRangeActor>::operator new;
	using FastAllocated<FdbClientClearRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11683951469368755200UL, 15250568510740666368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FdbClientClearRangeActor, 0, Void >;
friend struct ActorCallback< FdbClientClearRangeActor, 1, Void >;
friend struct ActorCallback< FdbClientClearRangeActor, 2, Void >;
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
	FdbClientClearRangeActor(Database const& db,ClearSingleRange* const& self) 
															#line 483 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClearSingleRange.actor.g.cpp"
		 : Actor<Void>(),
		   FdbClientClearRangeActorState<FdbClientClearRangeActor>(db, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fdbClientClearRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2908795056639649536UL, 12465619438571751680UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientClearRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fdbClientClearRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fdbClientClearRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FdbClientClearRangeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FdbClientClearRangeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FdbClientClearRangeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
[[nodiscard]] static Future<Void> fdbClientClearRange( Database const& db, ClearSingleRange* const& self ) {
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
	return Future<Void>(new FdbClientClearRangeActor(db, self));
															#line 517 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClearSingleRange.actor.g.cpp"
}

#line 64 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbserver/workloads/ClearSingleRange.actor.cpp"
};

WorkloadFactory<ClearSingleRange> ClearSingleRangeWorkloadFactory;
