#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
/*
 * TaskBucket.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/TaskBucket.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/actorcompiler.h" // has to be last include

Reference<TaskFuture> Task::getDoneFuture(Reference<FutureBucket> fb) {
	return fb->unpack(params[reservedTaskParamKeyDone]);
}

struct UnblockFutureTaskFunc : TaskFuncBase {
	static StringRef name;

	StringRef getName() const override { return name; };
	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Void();
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};

																#line 49 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via _finish()
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class _finishActor>
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class _finishActorState {
															#line 55 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	_finishActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   futureBucket(futureBucket),
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   task(task),
															#line 51 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   future(futureBucket->unpack(task->params[Task::reservedTaskParamKeyFuture]))
															#line 70 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActorState() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 53 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			futureBucket->setOptions(tr);
															#line 55 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			tr->clear(future->blocks.pack(task->params[Task::reservedTaskParamKeyBlockID]));
															#line 57 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<bool> __when_expr_0 = future->isSet(tr);
															#line 57 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 91 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor*>(this)->actor_wait_state = 1;
															#line 57 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 0, bool >*>(static_cast<_finishActor*>(this)));
															#line 96 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& is_set,int loopDepth) 
	{
															#line 58 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (is_set)
															#line 119 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 59 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_1 = future->performAllActions(tr, taskBucket);
															#line 59 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 125 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_finishActor*>(this)->actor_wait_state = 2;
															#line 59 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 1, Void >*>(static_cast<_finishActor*>(this)));
															#line 130 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(bool && is_set,int loopDepth) 
	{
															#line 58 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (is_set)
															#line 144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 59 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_1 = future->performAllActions(tr, taskBucket);
															#line 59 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 150 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_finishActor*>(this)->actor_wait_state = 2;
															#line 59 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 1, Void >*>(static_cast<_finishActor*>(this)));
															#line 155 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(bool const& is_set,int loopDepth) 
	{
		loopDepth = a_body1cont1(is_set, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && is_set,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(is_set), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 62 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<_finishActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActorState(); static_cast<_finishActor*>(this)->destroy(); return 0; }
															#line 244 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<_finishActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<Task> task;
															#line 51 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskFuture> future;
															#line 349 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via _finish()
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class _finishActor final : public Actor<Void>, public ActorCallback< _finishActor, 0, bool >, public ActorCallback< _finishActor, 1, Void >, public FastAllocated<_finishActor>, public _finishActorState<_finishActor> {
															#line 354 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<_finishActor>::operator new;
	using FastAllocated<_finishActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6087814990340326144UL, 2212789477641850368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor, 0, bool >;
friend struct ActorCallback< _finishActor, 1, Void >;
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	_finishActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 372 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Void>(),
		   _finishActorState<_finishActor>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5805366160711900928UL, 534046083987129088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 47 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Void>(new _finishActor(tr, taskBucket, futureBucket, task));
															#line 405 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 64 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
};
StringRef UnblockFutureTaskFunc::name = "UnblockFuture"_sr;
REGISTER_TASKFUNC(UnblockFutureTaskFunc);

struct AddTaskFunc : TaskFuncBase {
	static StringRef name;

	StringRef getName() const override { return name; };
	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Void();
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		task->params[Task::reservedTaskParamKeyType] = task->params[Task::reservedTaskParamKeyAddTask];
		tb->addTask(tr, task);
		return Void();
	};
};
StringRef AddTaskFunc::name = "AddTask"_sr;
REGISTER_TASKFUNC(AddTaskFunc);

struct IdleTaskFunc : TaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

	StringRef getName() const override { return name; };
	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Void();
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return tb->finish(tr, task);
	};
};
StringRef IdleTaskFunc::name = "idle"_sr;
REGISTER_TASKFUNC(IdleTaskFunc);

Key Task::reservedTaskParamKeyType = "type"_sr;
Key Task::reservedTaskParamKeyAddTask = "_add_task"_sr;
Key Task::reservedTaskParamKeyDone = "done"_sr;
Key Task::reservedTaskParamKeyPriority = "priority"_sr;
Key Task::reservedTaskParamKeyFuture = "future"_sr;
Key Task::reservedTaskParamKeyBlockID = "blockid"_sr;
Key Task::reservedTaskParamKeyVersion = "version"_sr;
Key Task::reservedTaskParamValidKey = "_validkey"_sr;
Key Task::reservedTaskParamValidValue = "_validvalue"_sr;

// IMPORTANT:  Task() must result in an EMPTY parameter set, so params should only
// be set for non-default constructor arguments.  To change this behavior look at all
// Task() default constructions to see if they require params to be empty and call clear.
Task::Task(Value type, uint32_t version, Value done, unsigned int priority) : extendMutex(1) {
	if (type.size())
		params[Task::reservedTaskParamKeyType] = type;

	if (version > 0)
		params[Task::reservedTaskParamKeyVersion] = BinaryWriter::toValue(version, Unversioned());

	if (done.size())
		params[Task::reservedTaskParamKeyDone] = done;

	priority = std::min<int64_t>(priority, CLIENT_KNOBS->TASKBUCKET_MAX_PRIORITY);
	if (priority != 0)
		params[Task::reservedTaskParamKeyPriority] = BinaryWriter::toValue<int64_t>(priority, Unversioned());
}

uint32_t Task::getVersion() const {
	uint32_t version(0);
	auto itor = params.find(Task::reservedTaskParamKeyVersion);
	if (itor != params.end()) {
		version = BinaryReader::fromStringRef<uint32_t>(itor->value, Unversioned());
	} else {
		TraceEvent(SevWarn, "InvalidTaskVersion").detail("TaskHasNoVersion", version);
	}

	return version;
}

unsigned int Task::getPriority() const {
	unsigned int priority = 0;
	auto i = params.find(Task::reservedTaskParamKeyPriority);
	if (i != params.end())
		priority = std::min<int64_t>(BinaryReader::fromStringRef<int64_t>(i->value, Unversioned()),
		                             CLIENT_KNOBS->TASKBUCKET_MAX_PRIORITY);
	return priority;
}

class TaskBucketImpl {
public:
																#line 507 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via getTaskKey()
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class GetTaskKeyActor>
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class GetTaskKeyActorState {
															#line 513 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	GetTaskKeyActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,int const& priority = 0) 
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   priority(priority)
															#line 524 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("getTaskKey", reinterpret_cast<unsigned long>(this));

	}
	~GetTaskKeyActorState() 
	{
		fdb_probe_actor_destroy("getTaskKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 165 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Standalone<StringRef> uid = StringRef(deterministicRandom()->randomUniqueID().toString());
															#line 168 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			space = taskBucket->getAvailableSpace(priority);
															#line 541 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 171 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = tr->getRange(KeyRangeRef(space.key(), space.pack(uid)), 1, Snapshot::True, Reverse::True);
															#line 171 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				if (static_cast<GetTaskKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 547 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetTaskKeyActor*>(this)->actor_wait_state = 1;
															#line 171 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTaskKeyActor, 0, RangeResult >*>(static_cast<GetTaskKeyActor*>(this)));
															#line 552 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTaskKeyActorState();
		static_cast<GetTaskKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 180 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<RangeResult> __when_expr_1 = tr->getRange(KeyRangeRef(space.key(), space.pack(maxUIDKey)), 1, Snapshot::True, Reverse::True);
															#line 180 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<GetTaskKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 579 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetTaskKeyActor*>(this)->actor_wait_state = 2;
															#line 180 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTaskKeyActor, 1, RangeResult >*>(static_cast<GetTaskKeyActor*>(this)));
															#line 584 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2(RangeResult const& value,int loopDepth) 
	{
															#line 173 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!value.empty())
															#line 594 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<GetTaskKeyActor*>(this)->SAV<Optional<Key>>::futures) { (void)(Optional<Key>(value[0].key)); this->~GetTaskKeyActorState(); static_cast<GetTaskKeyActor*>(this)->destroy(); return 0; }
															#line 598 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<GetTaskKeyActor*>(this)->SAV< Optional<Key> >::value()) Optional<Key>(Optional<Key>(value[0].key));
			this->~GetTaskKeyActorState();
			static_cast<GetTaskKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(RangeResult && value,int loopDepth) 
	{
															#line 173 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!value.empty())
															#line 612 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<GetTaskKeyActor*>(this)->SAV<Optional<Key>>::futures) { (void)(Optional<Key>(value[0].key)); this->~GetTaskKeyActorState(); static_cast<GetTaskKeyActor*>(this)->destroy(); return 0; }
															#line 616 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<GetTaskKeyActor*>(this)->SAV< Optional<Key> >::value()) Optional<Key>(Optional<Key>(value[0].key));
			this->~GetTaskKeyActorState();
			static_cast<GetTaskKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult const& value,int loopDepth) 
	{
		loopDepth = a_body1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && value,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTaskKeyActor*>(this)->actor_wait_state > 0) static_cast<GetTaskKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetTaskKeyActor*>(this)->ActorCallback< GetTaskKeyActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetTaskKeyActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getTaskKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTaskKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTaskKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTaskKeyActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getTaskKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTaskKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTaskKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTaskKeyActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getTaskKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTaskKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTaskKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 187 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<GetTaskKeyActor*>(this)->SAV<Optional<Key>>::futures) { (void)(Optional<Key>()); this->~GetTaskKeyActorState(); static_cast<GetTaskKeyActor*>(this)->destroy(); return 0; }
															#line 705 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<GetTaskKeyActor*>(this)->SAV< Optional<Key> >::value()) Optional<Key>(Optional<Key>());
		this->~GetTaskKeyActorState();
		static_cast<GetTaskKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(RangeResult const& value,int loopDepth) 
	{
															#line 182 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!value.empty())
															#line 717 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 183 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<GetTaskKeyActor*>(this)->SAV<Optional<Key>>::futures) { (void)(Optional<Key>(value[0].key)); this->~GetTaskKeyActorState(); static_cast<GetTaskKeyActor*>(this)->destroy(); return 0; }
															#line 721 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<GetTaskKeyActor*>(this)->SAV< Optional<Key> >::value()) Optional<Key>(Optional<Key>(value[0].key));
			this->~GetTaskKeyActorState();
			static_cast<GetTaskKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(RangeResult && value,int loopDepth) 
	{
															#line 182 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!value.empty())
															#line 735 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 183 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<GetTaskKeyActor*>(this)->SAV<Optional<Key>>::futures) { (void)(Optional<Key>(value[0].key)); this->~GetTaskKeyActorState(); static_cast<GetTaskKeyActor*>(this)->destroy(); return 0; }
															#line 739 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<GetTaskKeyActor*>(this)->SAV< Optional<Key> >::value()) Optional<Key>(Optional<Key>(value[0].key));
			this->~GetTaskKeyActorState();
			static_cast<GetTaskKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult const& value,int loopDepth) 
	{
		loopDepth = a_body1cont6(value, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult && value,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetTaskKeyActor*>(this)->actor_wait_state > 0) static_cast<GetTaskKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetTaskKeyActor*>(this)->ActorCallback< GetTaskKeyActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetTaskKeyActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getTaskKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTaskKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTaskKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTaskKeyActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getTaskKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTaskKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTaskKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTaskKeyActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getTaskKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTaskKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTaskKey", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	int priority;
															#line 168 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Subspace space;
															#line 832 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via getTaskKey()
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class GetTaskKeyActor final : public Actor<Optional<Key>>, public ActorCallback< GetTaskKeyActor, 0, RangeResult >, public ActorCallback< GetTaskKeyActor, 1, RangeResult >, public FastAllocated<GetTaskKeyActor>, public GetTaskKeyActorState<GetTaskKeyActor> {
															#line 837 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<GetTaskKeyActor>::operator new;
	using FastAllocated<GetTaskKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7225526139529445376UL, 15636254141440407808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Key>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTaskKeyActor, 0, RangeResult >;
friend struct ActorCallback< GetTaskKeyActor, 1, RangeResult >;
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	GetTaskKeyActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,int const& priority = 0) 
															#line 855 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Optional<Key>>(),
		   GetTaskKeyActorState<GetTaskKeyActor>(tr, taskBucket, priority),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTaskKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6759289764805515776UL, 6158362721312754688UL);
		ActorExecutionContextHelper __helper(static_cast<GetTaskKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTaskKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTaskKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTaskKeyActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetTaskKeyActor, 1, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Optional<Key>> getTaskKey( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, int const& priority = 0 ) {
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Optional<Key>>(new GetTaskKeyActor(tr, taskBucket, priority));
															#line 888 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 189 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 893 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via getOne()
															#line 190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class GetOneActor>
															#line 190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class GetOneActorState {
															#line 899 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	GetOneActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket) 
															#line 190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket)
															#line 908 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("getOne", reinterpret_cast<unsigned long>(this));

	}
	~GetOneActorState() 
	{
		fdb_probe_actor_destroy("getOne", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 192 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (taskBucket->priority_batch)
															#line 923 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 193 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				tr->setOption(FDBTransactionOptions::PRIORITY_BATCH);
															#line 927 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
															#line 195 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskBucket->setOptions(tr);
															#line 199 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (deterministicRandom()->random01() < CLIENT_KNOBS->TASKBUCKET_CHECK_TIMEOUT_CHANCE)
															#line 933 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 200 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				StrictFuture<bool> __when_expr_0 = requeueTimedOutTasks(tr, taskBucket);
															#line 200 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				if (static_cast<GetOneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 939 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetOneActor*>(this)->actor_wait_state = 1;
															#line 200 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetOneActor, 0, bool >*>(static_cast<GetOneActor*>(this)));
															#line 944 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetOneActorState();
		static_cast<GetOneActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 204 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		taskKeyFutures = std::vector<Future<Optional<Key>>>(CLIENT_KNOBS->TASKBUCKET_MAX_PRIORITY + 1);
															#line 207 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		pri = int();
															#line 208 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		for(pri = CLIENT_KNOBS->TASKBUCKET_MAX_PRIORITY;pri >= 0;--pri) {
															#line 209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskKeyFutures[pri] = getTaskKey(tr, taskBucket, pri);
															#line 978 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 212 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		taskKey = Optional<Key>();
															#line 213 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		availableSpace = Subspace();
															#line 217 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		pri = CLIENT_KNOBS->TASKBUCKET_MAX_PRIORITY;
															#line 986 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(bool const& anyTimeouts,int loopDepth) 
	{
															#line 201 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		CODE_PROBE(anyTimeouts, "Found a task that timed out");
															#line 995 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(bool && anyTimeouts,int loopDepth) 
	{
															#line 201 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		CODE_PROBE(anyTimeouts, "Found a task that timed out");
															#line 1004 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool const& anyTimeouts,int loopDepth) 
	{
		loopDepth = a_body1cont3(anyTimeouts, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && anyTimeouts,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(anyTimeouts), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetOneActor*>(this)->actor_wait_state > 0) static_cast<GetOneActor*>(this)->actor_wait_state = 0;
		static_cast<GetOneActor*>(this)->ActorCallback< GetOneActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< GetOneActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetOneActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetOneActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 231 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!taskKey.present())
															#line 1088 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 232 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<bool> __when_expr_2 = requeueTimedOutTasks(tr, taskBucket);
															#line 232 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<GetOneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1094 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetOneActor*>(this)->actor_wait_state = 3;
															#line 232 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetOneActor, 2, bool >*>(static_cast<GetOneActor*>(this)));
															#line 1099 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 217 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!(pri >= 0))
															#line 1120 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 219 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (taskKey.present())
															#line 1126 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 220 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskKeyFutures[pri].cancel();
															#line 1130 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		else
		{
															#line 222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Optional<Key>> __when_expr_1 = taskKeyFutures[pri];
															#line 222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<GetOneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1139 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetOneActor*>(this)->actor_wait_state = 2;
															#line 222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetOneActor, 1, Optional<Key> >*>(static_cast<GetOneActor*>(this)));
															#line 1144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 217 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		--pri;
															#line 1167 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Optional<Key> const& key,int loopDepth) 
	{
															#line 223 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (key.present())
															#line 1176 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 224 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskKey = key;
															#line 225 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			availableSpace = taskBucket->getAvailableSpace(pri);
															#line 1182 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Optional<Key> && key,int loopDepth) 
	{
															#line 223 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (key.present())
															#line 1192 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 224 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskKey = key;
															#line 225 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			availableSpace = taskBucket->getAvailableSpace(pri);
															#line 1198 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Key> const& key,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(key, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Key> && key,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(key), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetOneActor*>(this)->actor_wait_state > 0) static_cast<GetOneActor*>(this)->actor_wait_state = 0;
		static_cast<GetOneActor*>(this)->ActorCallback< GetOneActor, 1, Optional<Key> >::remove();

	}
	void a_callback_fire(ActorCallback< GetOneActor, 1, Optional<Key> >*,Optional<Key> const& value) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetOneActor, 1, Optional<Key> >*,Optional<Key> && value) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetOneActor, 1, Optional<Key> >*,Error err) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 243 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		t = availableSpace.unpack(taskKey.get());
															#line 244 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		taskUID = t.getString(0);
															#line 245 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		taskAvailableSpace = availableSpace.get(taskUID);
															#line 247 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		task = Reference<Task>(new Task());
															#line 248 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		task->key = taskUID;
															#line 250 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = tr->getRange(taskAvailableSpace.range(), CLIENT_KNOBS->TOO_MANY);
															#line 250 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<GetOneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1295 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetOneActor*>(this)->actor_wait_state = 5;
															#line 250 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetOneActor, 4, RangeResult >*>(static_cast<GetOneActor*>(this)));
															#line 1300 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(bool const& anyTimeouts,int loopDepth) 
	{
															#line 234 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (anyTimeouts)
															#line 1309 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 235 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			CODE_PROBE(true, "Try to get one task from timeouts subspace");
															#line 236 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Reference<Task>> __when_expr_3 = getOne(tr, taskBucket);
															#line 236 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<GetOneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1317 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
			static_cast<GetOneActor*>(this)->actor_wait_state = 4;
															#line 236 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetOneActor, 3, Reference<Task> >*>(static_cast<GetOneActor*>(this)));
															#line 1322 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(bool && anyTimeouts,int loopDepth) 
	{
															#line 234 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (anyTimeouts)
															#line 1336 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 235 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			CODE_PROBE(true, "Try to get one task from timeouts subspace");
															#line 236 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Reference<Task>> __when_expr_3 = getOne(tr, taskBucket);
															#line 236 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<GetOneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1344 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
			static_cast<GetOneActor*>(this)->actor_wait_state = 4;
															#line 236 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetOneActor, 3, Reference<Task> >*>(static_cast<GetOneActor*>(this)));
															#line 1349 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5when1(bool const& anyTimeouts,int loopDepth) 
	{
		loopDepth = a_body1cont8(anyTimeouts, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(bool && anyTimeouts,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(anyTimeouts), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetOneActor*>(this)->actor_wait_state > 0) static_cast<GetOneActor*>(this)->actor_wait_state = 0;
		static_cast<GetOneActor*>(this)->ActorCallback< GetOneActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< GetOneActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetOneActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetOneActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 239 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<GetOneActor*>(this)->SAV<Reference<Task>>::futures) { (void)(Reference<Task>()); this->~GetOneActorState(); static_cast<GetOneActor*>(this)->destroy(); return 0; }
															#line 1438 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<GetOneActor*>(this)->SAV< Reference<Task> >::value()) Reference<Task>(Reference<Task>());
		this->~GetOneActorState();
		static_cast<GetOneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(Reference<Task> const& task,int loopDepth) 
	{
															#line 237 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<GetOneActor*>(this)->SAV<Reference<Task>>::futures) { (void)(task); this->~GetOneActorState(); static_cast<GetOneActor*>(this)->destroy(); return 0; }
															#line 1450 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<GetOneActor*>(this)->SAV< Reference<Task> >::value()) Reference<Task>(task);
		this->~GetOneActorState();
		static_cast<GetOneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(Reference<Task> && task,int loopDepth) 
	{
															#line 237 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<GetOneActor*>(this)->SAV<Reference<Task>>::futures) { (void)(task); this->~GetOneActorState(); static_cast<GetOneActor*>(this)->destroy(); return 0; }
															#line 1462 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<GetOneActor*>(this)->SAV< Reference<Task> >::value()) Reference<Task>(task);
		this->~GetOneActorState();
		static_cast<GetOneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8when1(Reference<Task> const& task,int loopDepth) 
	{
		loopDepth = a_body1cont10(task, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Reference<Task> && task,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(task), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetOneActor*>(this)->actor_wait_state > 0) static_cast<GetOneActor*>(this)->actor_wait_state = 0;
		static_cast<GetOneActor*>(this)->ActorCallback< GetOneActor, 3, Reference<Task> >::remove();

	}
	void a_callback_fire(ActorCallback< GetOneActor, 3, Reference<Task> >*,Reference<Task> const& value) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetOneActor, 3, Reference<Task> >*,Reference<Task> && value) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetOneActor, 3, Reference<Task> >*,Error err) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont12(int loopDepth) 
	{
															#line 251 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Version> __when_expr_5 = tr->getReadVersion();
															#line 251 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<GetOneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1551 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12when1(__when_expr_5.get(), loopDepth); };
		static_cast<GetOneActor*>(this)->actor_wait_state = 6;
															#line 251 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetOneActor, 5, Version >*>(static_cast<GetOneActor*>(this)));
															#line 1556 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(RangeResult const& __values,int loopDepth) 
	{
															#line 250 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		values = __values;
															#line 1565 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(RangeResult && __values,int loopDepth) 
	{
		values = std::move(__values);
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetOneActor*>(this)->actor_wait_state > 0) static_cast<GetOneActor*>(this)->actor_wait_state = 0;
		static_cast<GetOneActor*>(this)->ActorCallback< GetOneActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetOneActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetOneActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetOneActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12cont1(Version const& version,int loopDepth) 
	{
															#line 252 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		task->timeoutVersion = version + (uint64_t)(taskBucket->timeout * (CLIENT_KNOBS->TASKBUCKET_TIMEOUT_JITTER_OFFSET + CLIENT_KNOBS->TASKBUCKET_TIMEOUT_JITTER_RANGE * deterministicRandom()->random01()));
															#line 257 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		Subspace timeoutSpace = taskBucket->timeouts.get(task->timeoutVersion).get(taskUID);
															#line 259 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		for( auto& s : values ) {
															#line 260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Key param = taskAvailableSpace.unpack(s.key).getString(0);
															#line 261 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			task->params[param] = s.value;
															#line 262 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			tr->set(timeoutSpace.pack(param), s.value);
															#line 1654 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 266 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr->clear(taskAvailableSpace.range());
															#line 267 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr->set(taskBucket->active.key(), deterministicRandom()->randomUniqueID().toString());
															#line 269 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<GetOneActor*>(this)->SAV<Reference<Task>>::futures) { (void)(task); this->~GetOneActorState(); static_cast<GetOneActor*>(this)->destroy(); return 0; }
															#line 1662 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<GetOneActor*>(this)->SAV< Reference<Task> >::value()) Reference<Task>(std::move(task)); // state_var_RVO
		this->~GetOneActorState();
		static_cast<GetOneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont1(Version && version,int loopDepth) 
	{
															#line 252 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		task->timeoutVersion = version + (uint64_t)(taskBucket->timeout * (CLIENT_KNOBS->TASKBUCKET_TIMEOUT_JITTER_OFFSET + CLIENT_KNOBS->TASKBUCKET_TIMEOUT_JITTER_RANGE * deterministicRandom()->random01()));
															#line 257 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		Subspace timeoutSpace = taskBucket->timeouts.get(task->timeoutVersion).get(taskUID);
															#line 259 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		for( auto& s : values ) {
															#line 260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Key param = taskAvailableSpace.unpack(s.key).getString(0);
															#line 261 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			task->params[param] = s.value;
															#line 262 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			tr->set(timeoutSpace.pack(param), s.value);
															#line 1684 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 266 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr->clear(taskAvailableSpace.range());
															#line 267 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr->set(taskBucket->active.key(), deterministicRandom()->randomUniqueID().toString());
															#line 269 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<GetOneActor*>(this)->SAV<Reference<Task>>::futures) { (void)(task); this->~GetOneActorState(); static_cast<GetOneActor*>(this)->destroy(); return 0; }
															#line 1692 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<GetOneActor*>(this)->SAV< Reference<Task> >::value()) Reference<Task>(std::move(task)); // state_var_RVO
		this->~GetOneActorState();
		static_cast<GetOneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(version, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetOneActor*>(this)->actor_wait_state > 0) static_cast<GetOneActor*>(this)->actor_wait_state = 0;
		static_cast<GetOneActor*>(this)->ActorCallback< GetOneActor, 5, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetOneActor, 5, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GetOneActor, 5, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GetOneActor, 5, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 204 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	std::vector<Future<Optional<Key>>> taskKeyFutures;
															#line 207 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	int pri;
															#line 212 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Optional<Key> taskKey;
															#line 213 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Subspace availableSpace;
															#line 243 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Tuple t;
															#line 244 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Key taskUID;
															#line 245 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Subspace taskAvailableSpace;
															#line 247 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<Task> task;
															#line 250 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	RangeResult values;
															#line 1797 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via getOne()
															#line 190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class GetOneActor final : public Actor<Reference<Task>>, public ActorCallback< GetOneActor, 0, bool >, public ActorCallback< GetOneActor, 1, Optional<Key> >, public ActorCallback< GetOneActor, 2, bool >, public ActorCallback< GetOneActor, 3, Reference<Task> >, public ActorCallback< GetOneActor, 4, RangeResult >, public ActorCallback< GetOneActor, 5, Version >, public FastAllocated<GetOneActor>, public GetOneActorState<GetOneActor> {
															#line 1802 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<GetOneActor>::operator new;
	using FastAllocated<GetOneActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12246012662038659328UL, 9308703417008018176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<Task>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetOneActor, 0, bool >;
friend struct ActorCallback< GetOneActor, 1, Optional<Key> >;
friend struct ActorCallback< GetOneActor, 2, bool >;
friend struct ActorCallback< GetOneActor, 3, Reference<Task> >;
friend struct ActorCallback< GetOneActor, 4, RangeResult >;
friend struct ActorCallback< GetOneActor, 5, Version >;
															#line 190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	GetOneActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket) 
															#line 1824 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Reference<Task>>(),
		   GetOneActorState<GetOneActor>(tr, taskBucket),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getOne", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2562366333383424512UL, 4088145760867388416UL);
		ActorExecutionContextHelper __helper(static_cast<GetOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getOne");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getOne", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetOneActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetOneActor, 1, Optional<Key> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetOneActor, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetOneActor, 3, Reference<Task> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetOneActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetOneActor, 5, Version >*)0, actor_cancelled()); break;
		}

	}
};
															#line 190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Reference<Task>> getOne( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket ) {
															#line 190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Reference<Task>>(new GetOneActor(tr, taskBucket));
															#line 1861 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 271 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

	// Verify that the user configured task verification key still has the user specified value
																#line 1867 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via taskVerify()
															#line 273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class TaskVerifyActor>
															#line 273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class TaskVerifyActorState {
															#line 1873 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	TaskVerifyActorState(Reference<TaskBucket> const& tb,Reference<ReadYourWritesTransaction> const& tr,Reference<Task> const& task) 
															#line 273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tb(tb),
															#line 273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   tr(tr),
															#line 273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   task(task)
															#line 1884 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("taskVerify", reinterpret_cast<unsigned long>(this));

	}
	~TaskVerifyActorState() 
	{
		fdb_probe_actor_destroy("taskVerify", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 277 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (task->params.find(Task::reservedTaskParamValidKey) == task->params.end())
															#line 1899 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 278 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				TraceEvent("TaskBucketTaskVerifyInvalidTask") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("ReservedTaskParamValidKey", "missing");
															#line 281 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				if (!static_cast<TaskVerifyActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TaskVerifyActorState(); static_cast<TaskVerifyActor*>(this)->destroy(); return 0; }
															#line 1905 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				new (&static_cast<TaskVerifyActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TaskVerifyActorState();
				static_cast<TaskVerifyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 284 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (task->params.find(Task::reservedTaskParamValidValue) == task->params.end())
															#line 1913 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 285 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				TraceEvent("TaskBucketTaskVerifyInvalidTask") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("ReservedTaskParamValidKey", task->params[Task::reservedTaskParamValidKey]) .detail("ReservedTaskParamValidValue", "missing");
															#line 289 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				if (!static_cast<TaskVerifyActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TaskVerifyActorState(); static_cast<TaskVerifyActor*>(this)->destroy(); return 0; }
															#line 1919 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				new (&static_cast<TaskVerifyActor*>(this)->SAV< bool >::value()) bool(false);
				this->~TaskVerifyActorState();
				static_cast<TaskVerifyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 292 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			tb->setOptions(tr);
															#line 294 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(task->params[Task::reservedTaskParamValidKey]);
															#line 294 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<TaskVerifyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TaskVerifyActor*>(this)->actor_wait_state = 1;
															#line 294 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TaskVerifyActor, 0, Optional<Value> >*>(static_cast<TaskVerifyActor*>(this)));
															#line 1936 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TaskVerifyActorState();
		static_cast<TaskVerifyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& keyValue,int loopDepth) 
	{
															#line 296 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!keyValue.present())
															#line 1959 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 297 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			TraceEvent("TaskBucketTaskVerifyInvalidTask") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("ReservedTaskParamValidKey", task->params[Task::reservedTaskParamValidKey]) .detail("ReservedTaskParamValidValue", task->params[Task::reservedTaskParamValidValue]) .detail("KeyValue", "missing");
															#line 302 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<TaskVerifyActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TaskVerifyActorState(); static_cast<TaskVerifyActor*>(this)->destroy(); return 0; }
															#line 1965 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<TaskVerifyActor*>(this)->SAV< bool >::value()) bool(false);
			this->~TaskVerifyActorState();
			static_cast<TaskVerifyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 305 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (keyValue.get().compare(StringRef(task->params[Task::reservedTaskParamValidValue])))
															#line 1973 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 306 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			TraceEvent("TaskBucketTaskVerifyAbortedTask") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("ReservedTaskParamValidKey", task->params[Task::reservedTaskParamValidKey]) .detail("ReservedTaskParamValidValue", task->params[Task::reservedTaskParamValidValue]) .detail("KeyValue", keyValue.get());
															#line 311 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<TaskVerifyActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TaskVerifyActorState(); static_cast<TaskVerifyActor*>(this)->destroy(); return 0; }
															#line 1979 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<TaskVerifyActor*>(this)->SAV< bool >::value()) bool(false);
			this->~TaskVerifyActorState();
			static_cast<TaskVerifyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 314 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<TaskVerifyActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TaskVerifyActorState(); static_cast<TaskVerifyActor*>(this)->destroy(); return 0; }
															#line 1987 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<TaskVerifyActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TaskVerifyActorState();
		static_cast<TaskVerifyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && keyValue,int loopDepth) 
	{
															#line 296 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!keyValue.present())
															#line 1999 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 297 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			TraceEvent("TaskBucketTaskVerifyInvalidTask") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("ReservedTaskParamValidKey", task->params[Task::reservedTaskParamValidKey]) .detail("ReservedTaskParamValidValue", task->params[Task::reservedTaskParamValidValue]) .detail("KeyValue", "missing");
															#line 302 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<TaskVerifyActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TaskVerifyActorState(); static_cast<TaskVerifyActor*>(this)->destroy(); return 0; }
															#line 2005 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<TaskVerifyActor*>(this)->SAV< bool >::value()) bool(false);
			this->~TaskVerifyActorState();
			static_cast<TaskVerifyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 305 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (keyValue.get().compare(StringRef(task->params[Task::reservedTaskParamValidValue])))
															#line 2013 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 306 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			TraceEvent("TaskBucketTaskVerifyAbortedTask") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("ReservedTaskParamValidKey", task->params[Task::reservedTaskParamValidKey]) .detail("ReservedTaskParamValidValue", task->params[Task::reservedTaskParamValidValue]) .detail("KeyValue", keyValue.get());
															#line 311 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<TaskVerifyActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TaskVerifyActorState(); static_cast<TaskVerifyActor*>(this)->destroy(); return 0; }
															#line 2019 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<TaskVerifyActor*>(this)->SAV< bool >::value()) bool(false);
			this->~TaskVerifyActorState();
			static_cast<TaskVerifyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 314 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<TaskVerifyActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TaskVerifyActorState(); static_cast<TaskVerifyActor*>(this)->destroy(); return 0; }
															#line 2027 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<TaskVerifyActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TaskVerifyActorState();
		static_cast<TaskVerifyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& keyValue,int loopDepth) 
	{
		loopDepth = a_body1cont1(keyValue, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && keyValue,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(keyValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TaskVerifyActor*>(this)->actor_wait_state > 0) static_cast<TaskVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<TaskVerifyActor*>(this)->ActorCallback< TaskVerifyActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TaskVerifyActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("taskVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TaskVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("taskVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TaskVerifyActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("taskVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TaskVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("taskVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TaskVerifyActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("taskVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TaskVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("taskVerify", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> tb;
															#line 273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<Task> task;
															#line 2116 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via taskVerify()
															#line 273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class TaskVerifyActor final : public Actor<bool>, public ActorCallback< TaskVerifyActor, 0, Optional<Value> >, public FastAllocated<TaskVerifyActor>, public TaskVerifyActorState<TaskVerifyActor> {
															#line 2121 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<TaskVerifyActor>::operator new;
	using FastAllocated<TaskVerifyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7740175259773833728UL, 1879469766001764352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TaskVerifyActor, 0, Optional<Value> >;
															#line 273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	TaskVerifyActor(Reference<TaskBucket> const& tb,Reference<ReadYourWritesTransaction> const& tr,Reference<Task> const& task) 
															#line 2138 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<bool>(),
		   TaskVerifyActorState<TaskVerifyActor>(tb, tr, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("taskVerify", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3853782772144334336UL, 6535407456415670528UL);
		ActorExecutionContextHelper __helper(static_cast<TaskVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("taskVerify");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("taskVerify", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TaskVerifyActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<bool> taskVerify( Reference<TaskBucket> const& tb, Reference<ReadYourWritesTransaction> const& tr, Reference<Task> const& task ) {
															#line 273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<bool>(new TaskVerifyActor(tb, tr, task));
															#line 2170 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 316 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 2175 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via taskVerify()
															#line 317 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class TaskVerifyActor1>
															#line 317 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class TaskVerifyActor1State {
															#line 2181 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 317 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	TaskVerifyActor1State(Reference<TaskBucket> const& tb,Database const& cx,Reference<Task> const& task) 
															#line 317 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 317 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tb(tb),
															#line 317 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   cx(cx),
															#line 317 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   task(task)
															#line 2192 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("taskVerify", reinterpret_cast<unsigned long>(this));

	}
	~TaskVerifyActor1State() 
	{
		fdb_probe_actor_destroy("taskVerify", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 318 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			;
															#line 2207 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TaskVerifyActor1State();
		static_cast<TaskVerifyActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 319 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 2237 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		try {
															#line 322 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<bool> __when_expr_0 = taskVerify(tb, tr, task);
															#line 322 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<TaskVerifyActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2243 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TaskVerifyActor1*>(this)->actor_wait_state = 1;
															#line 322 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TaskVerifyActor1, 0, bool >*>(static_cast<TaskVerifyActor1*>(this)));
															#line 2248 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 325 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 325 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<TaskVerifyActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2272 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TaskVerifyActor1*>(this)->actor_wait_state = 2;
															#line 325 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TaskVerifyActor1, 1, Void >*>(static_cast<TaskVerifyActor1*>(this)));
															#line 2277 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool const& verified,int loopDepth) 
	{
															#line 323 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<TaskVerifyActor1*>(this)->SAV<bool>::futures) { (void)(verified); this->~TaskVerifyActor1State(); static_cast<TaskVerifyActor1*>(this)->destroy(); return 0; }
															#line 2292 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<TaskVerifyActor1*>(this)->SAV< bool >::value()) bool(verified);
		this->~TaskVerifyActor1State();
		static_cast<TaskVerifyActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool && verified,int loopDepth) 
	{
															#line 323 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<TaskVerifyActor1*>(this)->SAV<bool>::futures) { (void)(verified); this->~TaskVerifyActor1State(); static_cast<TaskVerifyActor1*>(this)->destroy(); return 0; }
															#line 2304 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<TaskVerifyActor1*>(this)->SAV< bool >::value()) bool(verified);
		this->~TaskVerifyActor1State();
		static_cast<TaskVerifyActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& verified,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(verified, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && verified,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(verified), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TaskVerifyActor1*>(this)->actor_wait_state > 0) static_cast<TaskVerifyActor1*>(this)->actor_wait_state = 0;
		static_cast<TaskVerifyActor1*>(this)->ActorCallback< TaskVerifyActor1, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< TaskVerifyActor1, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("taskVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TaskVerifyActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("taskVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TaskVerifyActor1, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("taskVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TaskVerifyActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("taskVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TaskVerifyActor1, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("taskVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TaskVerifyActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("taskVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TaskVerifyActor1*>(this)->actor_wait_state > 0) static_cast<TaskVerifyActor1*>(this)->actor_wait_state = 0;
		static_cast<TaskVerifyActor1*>(this)->ActorCallback< TaskVerifyActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TaskVerifyActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("taskVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TaskVerifyActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("taskVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TaskVerifyActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("taskVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TaskVerifyActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("taskVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TaskVerifyActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("taskVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TaskVerifyActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("taskVerify", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 317 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> tb;
															#line 317 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Database cx;
															#line 317 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<Task> task;
															#line 319 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2482 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via taskVerify()
															#line 317 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class TaskVerifyActor1 final : public Actor<bool>, public ActorCallback< TaskVerifyActor1, 0, bool >, public ActorCallback< TaskVerifyActor1, 1, Void >, public FastAllocated<TaskVerifyActor1>, public TaskVerifyActor1State<TaskVerifyActor1> {
															#line 2487 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<TaskVerifyActor1>::operator new;
	using FastAllocated<TaskVerifyActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7740175259773833728UL, 1879469766001764352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TaskVerifyActor1, 0, bool >;
friend struct ActorCallback< TaskVerifyActor1, 1, Void >;
															#line 317 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	TaskVerifyActor1(Reference<TaskBucket> const& tb,Database const& cx,Reference<Task> const& task) 
															#line 2505 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<bool>(),
		   TaskVerifyActor1State<TaskVerifyActor1>(tb, cx, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("taskVerify", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16197913422771020032UL, 8009562298678435328UL);
		ActorExecutionContextHelper __helper(static_cast<TaskVerifyActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("taskVerify");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("taskVerify", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TaskVerifyActor1, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TaskVerifyActor1, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 317 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<bool> taskVerify( Reference<TaskBucket> const& tb, Database const& cx, Reference<Task> const& task ) {
															#line 317 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<bool>(new TaskVerifyActor1(tb, cx, task));
															#line 2538 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 329 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 2543 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via finishTaskRun()
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class FinishTaskRunActor>
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class FinishTaskRunActorState {
															#line 2549 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	FinishTaskRunActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task,Reference<TaskFuncBase> const& taskFunc,VerifyTask const& verifyTask) 
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   futureBucket(futureBucket),
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   task(task),
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskFunc(taskFunc),
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   verifyTask(verifyTask)
															#line 2566 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("finishTaskRun", reinterpret_cast<unsigned long>(this));

	}
	~FinishTaskRunActorState() 
	{
		fdb_probe_actor_destroy("finishTaskRun", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 336 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<bool> __when_expr_0 = taskBucket->isFinished(tr, task);
															#line 336 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<FinishTaskRunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2583 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FinishTaskRunActor*>(this)->actor_wait_state = 1;
															#line 336 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FinishTaskRunActor, 0, bool >*>(static_cast<FinishTaskRunActor*>(this)));
															#line 2588 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FinishTaskRunActorState();
		static_cast<FinishTaskRunActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& isFinished,int loopDepth) 
	{
															#line 337 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (isFinished)
															#line 2611 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 338 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<FinishTaskRunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishTaskRunActorState(); static_cast<FinishTaskRunActor*>(this)->destroy(); return 0; }
															#line 2615 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<FinishTaskRunActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FinishTaskRunActorState();
			static_cast<FinishTaskRunActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 341 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		validTask = true;
															#line 342 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (verifyTask)
															#line 2625 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 343 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<bool> __when_expr_1 = taskVerify(taskBucket, tr, task);
															#line 343 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<FinishTaskRunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2631 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FinishTaskRunActor*>(this)->actor_wait_state = 2;
															#line 343 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishTaskRunActor, 1, bool >*>(static_cast<FinishTaskRunActor*>(this)));
															#line 2636 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(bool && isFinished,int loopDepth) 
	{
															#line 337 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (isFinished)
															#line 2650 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 338 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<FinishTaskRunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishTaskRunActorState(); static_cast<FinishTaskRunActor*>(this)->destroy(); return 0; }
															#line 2654 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<FinishTaskRunActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FinishTaskRunActorState();
			static_cast<FinishTaskRunActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 341 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		validTask = true;
															#line 342 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (verifyTask)
															#line 2664 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 343 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<bool> __when_expr_1 = taskVerify(taskBucket, tr, task);
															#line 343 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<FinishTaskRunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2670 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FinishTaskRunActor*>(this)->actor_wait_state = 2;
															#line 343 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishTaskRunActor, 1, bool >*>(static_cast<FinishTaskRunActor*>(this)));
															#line 2675 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(bool const& isFinished,int loopDepth) 
	{
		loopDepth = a_body1cont1(isFinished, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && isFinished,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(isFinished), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FinishTaskRunActor*>(this)->actor_wait_state > 0) static_cast<FinishTaskRunActor*>(this)->actor_wait_state = 0;
		static_cast<FinishTaskRunActor*>(this)->ActorCallback< FinishTaskRunActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< FinishTaskRunActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("finishTaskRun", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishTaskRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishTaskRun", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FinishTaskRunActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("finishTaskRun", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishTaskRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishTaskRun", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FinishTaskRunActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("finishTaskRun", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishTaskRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishTaskRun", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 346 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!validTask)
															#line 2764 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 347 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_2 = taskBucket->finish(tr, task);
															#line 347 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<FinishTaskRunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2770 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<FinishTaskRunActor*>(this)->actor_wait_state = 3;
															#line 347 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinishTaskRunActor, 2, Void >*>(static_cast<FinishTaskRunActor*>(this)));
															#line 2775 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 349 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_3 = taskFunc->finish(tr, taskBucket, futureBucket, task);
															#line 349 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<FinishTaskRunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2784 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when2(__when_expr_3.get(), loopDepth); };
			static_cast<FinishTaskRunActor*>(this)->actor_wait_state = 4;
															#line 349 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FinishTaskRunActor, 3, Void >*>(static_cast<FinishTaskRunActor*>(this)));
															#line 2789 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont4(bool const& _validTask,int loopDepth) 
	{
															#line 344 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		validTask = _validTask;
															#line 2799 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(bool && _validTask,int loopDepth) 
	{
															#line 344 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		validTask = _validTask;
															#line 2808 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool const& _validTask,int loopDepth) 
	{
		loopDepth = a_body1cont4(_validTask, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && _validTask,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_validTask), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FinishTaskRunActor*>(this)->actor_wait_state > 0) static_cast<FinishTaskRunActor*>(this)->actor_wait_state = 0;
		static_cast<FinishTaskRunActor*>(this)->ActorCallback< FinishTaskRunActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< FinishTaskRunActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("finishTaskRun", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishTaskRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishTaskRun", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FinishTaskRunActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("finishTaskRun", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishTaskRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishTaskRun", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FinishTaskRunActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("finishTaskRun", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishTaskRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishTaskRun", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 352 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<FinishTaskRunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishTaskRunActorState(); static_cast<FinishTaskRunActor*>(this)->destroy(); return 0; }
															#line 2892 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<FinishTaskRunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FinishTaskRunActorState();
		static_cast<FinishTaskRunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FinishTaskRunActor*>(this)->actor_wait_state > 0) static_cast<FinishTaskRunActor*>(this)->actor_wait_state = 0;
		static_cast<FinishTaskRunActor*>(this)->ActorCallback< FinishTaskRunActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishTaskRunActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishTaskRun", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishTaskRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishTaskRun", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FinishTaskRunActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishTaskRun", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishTaskRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishTaskRun", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FinishTaskRunActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishTaskRun", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishTaskRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishTaskRun", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FinishTaskRunActor*>(this)->actor_wait_state > 0) static_cast<FinishTaskRunActor*>(this)->actor_wait_state = 0;
		static_cast<FinishTaskRunActor*>(this)->ActorCallback< FinishTaskRunActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishTaskRunActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishTaskRun", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishTaskRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishTaskRun", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FinishTaskRunActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishTaskRun", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishTaskRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishTaskRun", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FinishTaskRunActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishTaskRun", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishTaskRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishTaskRun", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<Task> task;
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskFuncBase> taskFunc;
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	VerifyTask verifyTask;
															#line 341 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	bool validTask;
															#line 3088 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via finishTaskRun()
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class FinishTaskRunActor final : public Actor<Void>, public ActorCallback< FinishTaskRunActor, 0, bool >, public ActorCallback< FinishTaskRunActor, 1, bool >, public ActorCallback< FinishTaskRunActor, 2, Void >, public ActorCallback< FinishTaskRunActor, 3, Void >, public FastAllocated<FinishTaskRunActor>, public FinishTaskRunActorState<FinishTaskRunActor> {
															#line 3093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<FinishTaskRunActor>::operator new;
	using FastAllocated<FinishTaskRunActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11506211079866078464UL, 13714144193828991232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FinishTaskRunActor, 0, bool >;
friend struct ActorCallback< FinishTaskRunActor, 1, bool >;
friend struct ActorCallback< FinishTaskRunActor, 2, Void >;
friend struct ActorCallback< FinishTaskRunActor, 3, Void >;
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	FinishTaskRunActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task,Reference<TaskFuncBase> const& taskFunc,VerifyTask const& verifyTask) 
															#line 3113 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Void>(),
		   FinishTaskRunActorState<FinishTaskRunActor>(tr, taskBucket, futureBucket, task, taskFunc, verifyTask),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("finishTaskRun", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14902074659164128768UL, 5391218197310877184UL);
		ActorExecutionContextHelper __helper(static_cast<FinishTaskRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("finishTaskRun");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("finishTaskRun", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FinishTaskRunActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FinishTaskRunActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FinishTaskRunActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FinishTaskRunActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Void> finishTaskRun( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task, Reference<TaskFuncBase> const& taskFunc, VerifyTask const& verifyTask ) {
															#line 330 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Void>(new FinishTaskRunActor(tr, taskBucket, futureBucket, task, taskFunc, verifyTask));
															#line 3148 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 354 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 3153 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via doOne()
															#line 355 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class DoOneActor>
															#line 355 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class DoOneActorState {
															#line 3159 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 355 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	DoOneActorState(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket) 
															#line 355 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 355 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : cx(cx),
															#line 355 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 355 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   futureBucket(futureBucket)
															#line 3170 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("doOne", reinterpret_cast<unsigned long>(this));

	}
	~DoOneActorState() 
	{
		fdb_probe_actor_destroy("doOne", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 358 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Reference<Task>> __when_expr_0 = taskBucket->getOne(cx);
															#line 358 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<DoOneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3187 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoOneActor*>(this)->actor_wait_state = 1;
															#line 358 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoOneActor, 0, Reference<Task> >*>(static_cast<DoOneActor*>(this)));
															#line 3192 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoOneActorState();
		static_cast<DoOneActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 359 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<bool> __when_expr_1 = taskBucket->doTask(cx, futureBucket, task);
															#line 359 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<DoOneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3217 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoOneActor*>(this)->actor_wait_state = 2;
															#line 359 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoOneActor, 1, bool >*>(static_cast<DoOneActor*>(this)));
															#line 3222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<Task> const& __task,int loopDepth) 
	{
															#line 358 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		task = __task;
															#line 3231 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<Task> && __task,int loopDepth) 
	{
		task = std::move(__task);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoOneActor*>(this)->actor_wait_state > 0) static_cast<DoOneActor*>(this)->actor_wait_state = 0;
		static_cast<DoOneActor*>(this)->ActorCallback< DoOneActor, 0, Reference<Task> >::remove();

	}
	void a_callback_fire(ActorCallback< DoOneActor, 0, Reference<Task> >*,Reference<Task> const& value) 
	{
		fdb_probe_actor_enter("doOne", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doOne", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoOneActor, 0, Reference<Task> >*,Reference<Task> && value) 
	{
		fdb_probe_actor_enter("doOne", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doOne", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoOneActor, 0, Reference<Task> >*,Error err) 
	{
		fdb_probe_actor_enter("doOne", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doOne", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(bool const& result,int loopDepth) 
	{
															#line 360 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<DoOneActor*>(this)->SAV<bool>::futures) { (void)(result); this->~DoOneActorState(); static_cast<DoOneActor*>(this)->destroy(); return 0; }
															#line 3310 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<DoOneActor*>(this)->SAV< bool >::value()) bool(result);
		this->~DoOneActorState();
		static_cast<DoOneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(bool && result,int loopDepth) 
	{
															#line 360 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<DoOneActor*>(this)->SAV<bool>::futures) { (void)(result); this->~DoOneActorState(); static_cast<DoOneActor*>(this)->destroy(); return 0; }
															#line 3322 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<DoOneActor*>(this)->SAV< bool >::value()) bool(result);
		this->~DoOneActorState();
		static_cast<DoOneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && result,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoOneActor*>(this)->actor_wait_state > 0) static_cast<DoOneActor*>(this)->actor_wait_state = 0;
		static_cast<DoOneActor*>(this)->ActorCallback< DoOneActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< DoOneActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("doOne", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doOne", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoOneActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("doOne", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doOne", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoOneActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("doOne", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doOne", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 355 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Database cx;
															#line 355 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 355 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 358 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<Task> task;
															#line 3413 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via doOne()
															#line 355 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class DoOneActor final : public Actor<bool>, public ActorCallback< DoOneActor, 0, Reference<Task> >, public ActorCallback< DoOneActor, 1, bool >, public FastAllocated<DoOneActor>, public DoOneActorState<DoOneActor> {
															#line 3418 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<DoOneActor>::operator new;
	using FastAllocated<DoOneActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17739058473791525888UL, 972838578239939584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoOneActor, 0, Reference<Task> >;
friend struct ActorCallback< DoOneActor, 1, bool >;
															#line 355 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	DoOneActor(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket) 
															#line 3436 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<bool>(),
		   DoOneActorState<DoOneActor>(cx, taskBucket, futureBucket),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doOne", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10137581321708526848UL, 16515408872687201536UL);
		ActorExecutionContextHelper __helper(static_cast<DoOneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doOne");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doOne", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoOneActor, 0, Reference<Task> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoOneActor, 1, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 355 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<bool> doOne( Database const& cx, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket ) {
															#line 355 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<bool>(new DoOneActor(cx, taskBucket, futureBucket));
															#line 3469 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 362 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 3474 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via extendTimeoutRepeatedly()
															#line 363 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class ExtendTimeoutRepeatedlyActor>
															#line 363 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class ExtendTimeoutRepeatedlyActorState {
															#line 3480 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 363 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	ExtendTimeoutRepeatedlyActorState(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<Task> const& task) 
															#line 363 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 363 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : cx(cx),
															#line 363 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 363 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   task(task),
															#line 366 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   tr(new ReadYourWritesTransaction(cx)),
															#line 367 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   start(now())
															#line 3495 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this));

	}
	~ExtendTimeoutRepeatedlyActorState() 
	{
		fdb_probe_actor_destroy("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 368 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Version> __when_expr_0 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) { taskBucket->setOptions(tr); return map(tr->getReadVersion(), [=](Version v) { return v; }); });
															#line 368 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3512 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state = 1;
															#line 368 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExtendTimeoutRepeatedlyActor, 0, Version >*>(static_cast<ExtendTimeoutRepeatedlyActor*>(this)));
															#line 3517 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExtendTimeoutRepeatedlyActorState();
		static_cast<ExtendTimeoutRepeatedlyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 373 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		;
															#line 3540 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version const& __versionNow,int loopDepth) 
	{
															#line 368 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		versionNow = __versionNow;
															#line 3549 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __versionNow,int loopDepth) 
	{
		versionNow = std::move(__versionNow);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state > 0) static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state = 0;
		static_cast<ExtendTimeoutRepeatedlyActor*>(this)->ActorCallback< ExtendTimeoutRepeatedlyActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutRepeatedlyActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutRepeatedlyActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExtendTimeoutRepeatedlyActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 374 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		releaser = FlowLock::Releaser();
															#line 377 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.8 * (BUGGIFY ? (2 * deterministicRandom()->random01()) : 1.0) * (double)(task->timeoutVersion - (uint64_t)versionNow) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND);
															#line 377 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3639 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state = 2;
															#line 377 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExtendTimeoutRepeatedlyActor, 1, Void >*>(static_cast<ExtendTimeoutRepeatedlyActor*>(this)));
															#line 3644 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 380 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (now() - start > 300)
															#line 3653 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 381 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			TraceEvent(SevWarnAlways, "TaskBucketLongExtend") .detail("Duration", now() - start) .detail("TaskUID", task->key) .detail("TaskType", task->params[Task::reservedTaskParamKeyType]) .detail("Priority", task->getPriority());
															#line 3657 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 388 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_2 = task->extendMutex.take();
															#line 388 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3663 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state = 3;
															#line 388 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExtendTimeoutRepeatedlyActor, 2, Void >*>(static_cast<ExtendTimeoutRepeatedlyActor*>(this)));
															#line 3668 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 380 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (now() - start > 300)
															#line 3677 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 381 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			TraceEvent(SevWarnAlways, "TaskBucketLongExtend") .detail("Duration", now() - start) .detail("TaskUID", task->key) .detail("TaskType", task->params[Task::reservedTaskParamKeyType]) .detail("Priority", task->getPriority());
															#line 3681 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 388 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_2 = task->extendMutex.take();
															#line 388 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3687 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state = 3;
															#line 388 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExtendTimeoutRepeatedlyActor, 2, Void >*>(static_cast<ExtendTimeoutRepeatedlyActor*>(this)));
															#line 3692 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state > 0) static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state = 0;
		static_cast<ExtendTimeoutRepeatedlyActor*>(this)->ActorCallback< ExtendTimeoutRepeatedlyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutRepeatedlyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutRepeatedlyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExtendTimeoutRepeatedlyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 389 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		releaser = FlowLock::Releaser(task->extendMutex, 1);
															#line 391 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		;
															#line 3778 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 389 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		releaser = FlowLock::Releaser(task->extendMutex, 1);
															#line 391 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		;
															#line 3789 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state > 0) static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state = 0;
		static_cast<ExtendTimeoutRepeatedlyActor*>(this)->ActorCallback< ExtendTimeoutRepeatedlyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutRepeatedlyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutRepeatedlyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ExtendTimeoutRepeatedlyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 393 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			tr->reset();
															#line 394 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskBucket->setOptions(tr);
															#line 397 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Version> __when_expr_3 = taskBucket->extendTimeout(tr, task, UpdateParams::False);
															#line 397 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3893 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont2loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state = 4;
															#line 397 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ExtendTimeoutRepeatedlyActor, 3, Version >*>(static_cast<ExtendTimeoutRepeatedlyActor*>(this)));
															#line 3898 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 403 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr->onError(e);
															#line 403 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3935 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont2loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state = 6;
															#line 403 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ExtendTimeoutRepeatedlyActor, 5, Void >*>(static_cast<ExtendTimeoutRepeatedlyActor*>(this)));
															#line 3940 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont2(int loopDepth) 
	{
															#line 398 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr->commit();
															#line 398 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3957 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont2loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state = 5;
															#line 398 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ExtendTimeoutRepeatedlyActor, 4, Void >*>(static_cast<ExtendTimeoutRepeatedlyActor*>(this)));
															#line 3962 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1when1(Version const& __newTimeout,int loopDepth) 
	{
															#line 397 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		newTimeout = __newTimeout;
															#line 3971 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1when1(Version && __newTimeout,int loopDepth) 
	{
		newTimeout = std::move(__newTimeout);
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state > 0) static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state = 0;
		static_cast<ExtendTimeoutRepeatedlyActor*>(this)->ActorCallback< ExtendTimeoutRepeatedlyActor, 3, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutRepeatedlyActor, 3, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutRepeatedlyActor, 3, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ExtendTimeoutRepeatedlyActor, 3, Version >*,Error err) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 399 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		task->timeoutVersion = newTimeout;
															#line 400 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		versionNow = tr->getCommittedVersion();
															#line 4052 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		return a_body1cont1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 399 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		task->timeoutVersion = newTimeout;
															#line 400 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		versionNow = tr->getCommittedVersion();
															#line 4063 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		return a_body1cont1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state > 0) static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state = 0;
		static_cast<ExtendTimeoutRepeatedlyActor*>(this)->ActorCallback< ExtendTimeoutRepeatedlyActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutRepeatedlyActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutRepeatedlyActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ExtendTimeoutRepeatedlyActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state > 0) static_cast<ExtendTimeoutRepeatedlyActor*>(this)->actor_wait_state = 0;
		static_cast<ExtendTimeoutRepeatedlyActor*>(this)->ActorCallback< ExtendTimeoutRepeatedlyActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutRepeatedlyActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutRepeatedlyActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ExtendTimeoutRepeatedlyActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 363 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Database cx;
															#line 363 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 363 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<Task> task;
															#line 366 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 367 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	double start;
															#line 368 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Version versionNow;
															#line 374 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	FlowLock::Releaser releaser;
															#line 397 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Version newTimeout;
															#line 4246 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via extendTimeoutRepeatedly()
															#line 363 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class ExtendTimeoutRepeatedlyActor final : public Actor<Void>, public ActorCallback< ExtendTimeoutRepeatedlyActor, 0, Version >, public ActorCallback< ExtendTimeoutRepeatedlyActor, 1, Void >, public ActorCallback< ExtendTimeoutRepeatedlyActor, 2, Void >, public ActorCallback< ExtendTimeoutRepeatedlyActor, 3, Version >, public ActorCallback< ExtendTimeoutRepeatedlyActor, 4, Void >, public ActorCallback< ExtendTimeoutRepeatedlyActor, 5, Void >, public FastAllocated<ExtendTimeoutRepeatedlyActor>, public ExtendTimeoutRepeatedlyActorState<ExtendTimeoutRepeatedlyActor> {
															#line 4251 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<ExtendTimeoutRepeatedlyActor>::operator new;
	using FastAllocated<ExtendTimeoutRepeatedlyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1591167564675806208UL, 5645358154737314048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExtendTimeoutRepeatedlyActor, 0, Version >;
friend struct ActorCallback< ExtendTimeoutRepeatedlyActor, 1, Void >;
friend struct ActorCallback< ExtendTimeoutRepeatedlyActor, 2, Void >;
friend struct ActorCallback< ExtendTimeoutRepeatedlyActor, 3, Version >;
friend struct ActorCallback< ExtendTimeoutRepeatedlyActor, 4, Void >;
friend struct ActorCallback< ExtendTimeoutRepeatedlyActor, 5, Void >;
															#line 363 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	ExtendTimeoutRepeatedlyActor(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<Task> const& task) 
															#line 4273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Void>(),
		   ExtendTimeoutRepeatedlyActorState<ExtendTimeoutRepeatedlyActor>(cx, taskBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10175765047706467584UL, 2394619849712288512UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutRepeatedlyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("extendTimeoutRepeatedly");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("extendTimeoutRepeatedly", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExtendTimeoutRepeatedlyActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExtendTimeoutRepeatedlyActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ExtendTimeoutRepeatedlyActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ExtendTimeoutRepeatedlyActor, 3, Version >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ExtendTimeoutRepeatedlyActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ExtendTimeoutRepeatedlyActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 363 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Void> extendTimeoutRepeatedly( Database const& cx, Reference<TaskBucket> const& taskBucket, Reference<Task> const& task ) {
															#line 363 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Void>(new ExtendTimeoutRepeatedlyActor(cx, taskBucket, task));
															#line 4310 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 408 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 4315 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via doTask()
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class DoTaskActor>
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class DoTaskActorState {
															#line 4321 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	DoTaskActorState(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : cx(cx),
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   futureBucket(futureBucket),
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   task(task),
															#line 413 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskFunc(),
															#line 414 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   verifyTask(false)
															#line 4338 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("doTask", reinterpret_cast<unsigned long>(this));

	}
	~DoTaskActorState() 
	{
		fdb_probe_actor_destroy("doTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 416 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!task || !TaskFuncBase::isValidTask(task))
															#line 4353 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 417 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				if (!static_cast<DoTaskActor*>(this)->SAV<bool>::futures) { (void)(false); this->~DoTaskActorState(); static_cast<DoTaskActor*>(this)->destroy(); return 0; }
															#line 4357 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				new (&static_cast<DoTaskActor*>(this)->SAV< bool >::value()) bool(false);
				this->~DoTaskActorState();
				static_cast<DoTaskActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			try {
															#line 420 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				taskFunc = TaskFuncBase::create(task->params[Task::reservedTaskParamKeyType]);
															#line 421 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				if (taskFunc)
															#line 4368 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				{
															#line 422 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
					verifyTask.set(task->params.find(Task::reservedTaskParamValidKey) != task->params.end());
															#line 424 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
					if (verifyTask)
															#line 4374 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
					{
															#line 425 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
						;
															#line 4378 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
						loopDepth = a_body1loopHead1(loopDepth);
					}
					else
					{
						loopDepth = a_body1cont4(loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1cont3(loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoTaskActorState();
		static_cast<DoTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 474 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<DoTaskActor*>(this)->SAV<bool>::futures) { (void)(true); this->~DoTaskActorState(); static_cast<DoTaskActor*>(this)->destroy(); return 0; }
															#line 4417 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<DoTaskActor*>(this)->SAV< bool >::value()) bool(true);
		this->~DoTaskActorState();
		static_cast<DoTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 457 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			TraceEvent(SevWarn, "TaskBucketExecuteFailure") .error(e) .detail("TaskUID", task->key) .detail("TaskType", task->params[Task::reservedTaskParamKeyType].printable()) .detail("Priority", task->getPriority());
															#line 4430 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			try {
															#line 463 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				StrictFuture<Void> __when_expr_8 = taskFunc->handleError(cx, task, e);
															#line 463 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				if (static_cast<DoTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch2Catch1(actor_cancelled(), loopDepth);
															#line 4436 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch2Catch1(__when_expr_8.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_8.get(), loopDepth); };
				static_cast<DoTaskActor*>(this)->actor_wait_state = 9;
															#line 463 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< DoTaskActor, 8, Void >*>(static_cast<DoTaskActor*>(this)));
															#line 4441 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 447 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_5 = taskFunc->execute(cx, taskBucket, futureBucket, task) || extendTimeoutRepeatedly(cx, taskBucket, task);
															#line 447 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<DoTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4470 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont4when1(__when_expr_5.get(), loopDepth); };
		static_cast<DoTaskActor*>(this)->actor_wait_state = 6;
															#line 447 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DoTaskActor, 5, Void >*>(static_cast<DoTaskActor*>(this)));
															#line 4475 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 426 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 427 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		taskBucket->setOptions(tr);
															#line 4499 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		try {
															#line 430 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<bool> __when_expr_0 = taskVerify(taskBucket, tr, task);
															#line 430 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<DoTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4505 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoTaskActor*>(this)->actor_wait_state = 1;
															#line 430 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoTaskActor, 0, bool >*>(static_cast<DoTaskActor*>(this)));
															#line 4510 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 442 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr->onError(e);
															#line 442 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<DoTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4547 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<DoTaskActor*>(this)->actor_wait_state = 5;
															#line 442 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoTaskActor, 4, Void >*>(static_cast<DoTaskActor*>(this)));
															#line 4552 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool const& validTask,int loopDepth) 
	{
															#line 432 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!validTask)
															#line 4567 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 433 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<bool> __when_expr_1 = taskBucket->isFinished(tr, task);
															#line 433 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<DoTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4573 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoTaskActor*>(this)->actor_wait_state = 2;
															#line 433 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoTaskActor, 1, bool >*>(static_cast<DoTaskActor*>(this)));
															#line 4578 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool && validTask,int loopDepth) 
	{
															#line 432 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!validTask)
															#line 4592 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 433 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<bool> __when_expr_1 = taskBucket->isFinished(tr, task);
															#line 433 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<DoTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4598 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoTaskActor*>(this)->actor_wait_state = 2;
															#line 433 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoTaskActor, 1, bool >*>(static_cast<DoTaskActor*>(this)));
															#line 4603 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& validTask,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(validTask, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && validTask,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(validTask), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoTaskActor*>(this)->actor_wait_state > 0) static_cast<DoTaskActor*>(this)->actor_wait_state = 0;
		static_cast<DoTaskActor*>(this)->ActorCallback< DoTaskActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoTaskActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(bool const& isFinished,int loopDepth) 
	{
															#line 434 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!isFinished)
															#line 4698 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 435 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_2 = taskBucket->finish(tr, task);
															#line 435 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<DoTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4704 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoTaskActor*>(this)->actor_wait_state = 3;
															#line 435 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoTaskActor, 2, Void >*>(static_cast<DoTaskActor*>(this)));
															#line 4709 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(bool && isFinished,int loopDepth) 
	{
															#line 434 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!isFinished)
															#line 4723 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 435 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_2 = taskBucket->finish(tr, task);
															#line 435 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<DoTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4729 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoTaskActor*>(this)->actor_wait_state = 3;
															#line 435 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoTaskActor, 2, Void >*>(static_cast<DoTaskActor*>(this)));
															#line 4734 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(bool const& isFinished,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(isFinished, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(bool && isFinished,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(isFinished), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoTaskActor*>(this)->actor_wait_state > 0) static_cast<DoTaskActor*>(this)->actor_wait_state = 0;
		static_cast<DoTaskActor*>(this)->ActorCallback< DoTaskActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoTaskActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 437 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 437 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<DoTaskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4825 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<DoTaskActor*>(this)->actor_wait_state = 4;
															#line 437 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoTaskActor, 3, Void >*>(static_cast<DoTaskActor*>(this)));
															#line 4830 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoTaskActor*>(this)->actor_wait_state > 0) static_cast<DoTaskActor*>(this)->actor_wait_state = 0;
		static_cast<DoTaskActor*>(this)->ActorCallback< DoTaskActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoTaskActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 438 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<DoTaskActor*>(this)->SAV<bool>::futures) { (void)(true); this->~DoTaskActorState(); static_cast<DoTaskActor*>(this)->destroy(); return 0; }
															#line 4926 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<DoTaskActor*>(this)->SAV< bool >::value()) bool(true);
		this->~DoTaskActorState();
		static_cast<DoTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 438 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<DoTaskActor*>(this)->SAV<bool>::futures) { (void)(true); this->~DoTaskActorState(); static_cast<DoTaskActor*>(this)->destroy(); return 0; }
															#line 4938 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<DoTaskActor*>(this)->SAV< bool >::value()) bool(true);
		this->~DoTaskActorState();
		static_cast<DoTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoTaskActor*>(this)->actor_wait_state > 0) static_cast<DoTaskActor*>(this)->actor_wait_state = 0;
		static_cast<DoTaskActor*>(this)->ActorCallback< DoTaskActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoTaskActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DoTaskActor*>(this)->actor_wait_state > 0) static_cast<DoTaskActor*>(this)->actor_wait_state = 0;
		static_cast<DoTaskActor*>(this)->ActorCallback< DoTaskActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DoTaskActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 450 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (BUGGIFY)
															#line 5112 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 451 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_6 = delay(10.0);
															#line 451 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<DoTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5118 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
			static_cast<DoTaskActor*>(this)->actor_wait_state = 7;
															#line 451 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoTaskActor, 6, Void >*>(static_cast<DoTaskActor*>(this)));
															#line 5123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 450 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (BUGGIFY)
															#line 5137 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 451 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_6 = delay(10.0);
															#line 451 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<DoTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5143 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
			static_cast<DoTaskActor*>(this)->actor_wait_state = 7;
															#line 451 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoTaskActor, 6, Void >*>(static_cast<DoTaskActor*>(this)));
															#line 5148 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DoTaskActor*>(this)->actor_wait_state > 0) static_cast<DoTaskActor*>(this)->actor_wait_state = 0;
		static_cast<DoTaskActor*>(this)->ActorCallback< DoTaskActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DoTaskActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 452 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_7 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) { return finishTaskRun(tr, taskBucket, futureBucket, task, taskFunc, verifyTask); });
															#line 452 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<DoTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5239 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch2(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<DoTaskActor*>(this)->actor_wait_state = 8;
															#line 452 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< DoTaskActor, 7, Void >*>(static_cast<DoTaskActor*>(this)));
															#line 5244 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DoTaskActor*>(this)->actor_wait_state > 0) static_cast<DoTaskActor*>(this)->actor_wait_state = 0;
		static_cast<DoTaskActor*>(this)->ActorCallback< DoTaskActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DoTaskActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<DoTaskActor*>(this)->actor_wait_state > 0) static_cast<DoTaskActor*>(this)->actor_wait_state = 0;
		static_cast<DoTaskActor*>(this)->ActorCallback< DoTaskActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< DoTaskActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 465 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			TraceEvent(SevWarn, "TaskBucketExecuteFailureLogErrorFailed") .error(e) .detail("TaskUID", task->key.printable()) .detail("TaskType", task->params[Task::reservedTaskParamKeyType].printable()) .detail("Priority", task->getPriority());
															#line 5447 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = a_body1Catch2cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<DoTaskActor*>(this)->actor_wait_state > 0) static_cast<DoTaskActor*>(this)->actor_wait_state = 0;
		static_cast<DoTaskActor*>(this)->ActorCallback< DoTaskActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< DoTaskActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< DoTaskActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1Catch2cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1Catch2cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Database cx;
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<Task> task;
															#line 413 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskFuncBase> taskFunc;
															#line 414 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	VerifyTask verifyTask;
															#line 426 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 5572 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via doTask()
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class DoTaskActor final : public Actor<bool>, public ActorCallback< DoTaskActor, 0, bool >, public ActorCallback< DoTaskActor, 1, bool >, public ActorCallback< DoTaskActor, 2, Void >, public ActorCallback< DoTaskActor, 3, Void >, public ActorCallback< DoTaskActor, 4, Void >, public ActorCallback< DoTaskActor, 5, Void >, public ActorCallback< DoTaskActor, 6, Void >, public ActorCallback< DoTaskActor, 7, Void >, public ActorCallback< DoTaskActor, 8, Void >, public FastAllocated<DoTaskActor>, public DoTaskActorState<DoTaskActor> {
															#line 5577 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<DoTaskActor>::operator new;
	using FastAllocated<DoTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15000666553893356800UL, 1414301454569756928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoTaskActor, 0, bool >;
friend struct ActorCallback< DoTaskActor, 1, bool >;
friend struct ActorCallback< DoTaskActor, 2, Void >;
friend struct ActorCallback< DoTaskActor, 3, Void >;
friend struct ActorCallback< DoTaskActor, 4, Void >;
friend struct ActorCallback< DoTaskActor, 5, Void >;
friend struct ActorCallback< DoTaskActor, 6, Void >;
friend struct ActorCallback< DoTaskActor, 7, Void >;
friend struct ActorCallback< DoTaskActor, 8, Void >;
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	DoTaskActor(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 5602 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<bool>(),
		   DoTaskActorState<DoTaskActor>(cx, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12981170290613585152UL, 2679894573022875392UL);
		ActorExecutionContextHelper __helper(static_cast<DoTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoTaskActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoTaskActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoTaskActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoTaskActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DoTaskActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DoTaskActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DoTaskActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< DoTaskActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< DoTaskActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<bool> doTask( Database const& cx, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 409 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<bool>(new DoTaskActor(cx, taskBucket, futureBucket, task));
															#line 5642 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 476 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 5647 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via dispatch()
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class DispatchActor>
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class DispatchActorState {
															#line 5653 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	DispatchActorState(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,std::shared_ptr<double const> const& pollDelay,int const& maxConcurrentTasks) 
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : cx(cx),
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   futureBucket(futureBucket),
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   pollDelay(pollDelay),
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   maxConcurrentTasks(maxConcurrentTasks),
															#line 482 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   tasks(maxConcurrentTasks)
															#line 5670 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("dispatch", reinterpret_cast<unsigned long>(this));

	}
	~DispatchActorState() 
	{
		fdb_probe_actor_destroy("dispatch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 483 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			for( auto& f : tasks ) {
															#line 484 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				f = Never();
															#line 5687 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
															#line 488 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			availableSlots = std::vector<int>();
															#line 489 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			availableSlots.reserve(tasks.size());
															#line 490 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			for(int i = 0;i < tasks.size();++i) {
															#line 491 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				availableSlots.push_back(i);
															#line 5697 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
															#line 493 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			getTasks = std::vector<Future<Reference<Task>>>();
															#line 494 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			getBatchSize = 1;
															#line 496 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			;
															#line 5705 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DispatchActorState();
		static_cast<DispatchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 498 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		++taskBucket->dispatchSlotChecksStarted;
															#line 499 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		;
															#line 5737 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 531 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		++taskBucket->dispatchSlotChecksComplete;
															#line 535 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		Future<Void> w = ready(waitForAny(tasks));
															#line 536 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!availableSlots.empty())
															#line 5750 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 537 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (*pollDelay > 600)
															#line 5754 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 538 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				TraceEvent(SevWarnAlways, "TaskBucketLongPollDelay").suppressFor(1.0).detail("Delay", *pollDelay);
															#line 5758 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
															#line 540 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			w = w || delay(*pollDelay * (0.9 + deterministicRandom()->random01() / 5));
															#line 5762 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 543 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_1 = w;
															#line 543 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<DispatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5768 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DispatchActor*>(this)->actor_wait_state = 2;
															#line 543 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DispatchActor, 1, Void >*>(static_cast<DispatchActor*>(this)));
															#line 5773 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 499 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!(!availableSlots.empty()))
															#line 5789 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 500 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		getTasks.clear();
															#line 501 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		for(int i = 0, imax = std::min<unsigned int>(getBatchSize, availableSlots.size());i < imax;++i) {
															#line 502 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			getTasks.push_back(taskBucket->getOne(cx));
															#line 5799 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 503 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitForAllReady(getTasks);
															#line 503 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<DispatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5805 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DispatchActor*>(this)->actor_wait_state = 1;
															#line 503 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DispatchActor, 0, Void >*>(static_cast<DispatchActor*>(this)));
															#line 5810 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 505 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		bool done = false;
															#line 506 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		for(int i = 0;i < getTasks.size();++i) {
															#line 507 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (getTasks[i].isError())
															#line 5836 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 508 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				++taskBucket->dispatchErrors;
															#line 509 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				done = true;
															#line 5842 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				continue;
			}
															#line 512 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Reference<Task> task = getTasks[i].get();
															#line 513 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (task)
															#line 5849 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 515 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				++taskBucket->dispatchDoTasks;
															#line 516 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				int slot = availableSlots.back();
															#line 517 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				availableSlots.pop_back();
															#line 518 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				tasks[slot] = taskBucket->doTask(cx, futureBucket, task);
															#line 5859 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
			else
			{
															#line 520 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				++taskBucket->dispatchEmptyTasks;
															#line 521 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				done = true;
															#line 5867 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
		}
															#line 525 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (done)
															#line 5872 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 526 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			getBatchSize = 1;
															#line 5876 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 529 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			getBatchSize = std::min<unsigned int>(getBatchSize * 2, maxConcurrentTasks);
															#line 5883 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 505 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		bool done = false;
															#line 506 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		for(int i = 0;i < getTasks.size();++i) {
															#line 507 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (getTasks[i].isError())
															#line 5897 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 508 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				++taskBucket->dispatchErrors;
															#line 509 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				done = true;
															#line 5903 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				continue;
			}
															#line 512 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Reference<Task> task = getTasks[i].get();
															#line 513 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (task)
															#line 5910 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 515 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				++taskBucket->dispatchDoTasks;
															#line 516 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				int slot = availableSlots.back();
															#line 517 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				availableSlots.pop_back();
															#line 518 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				tasks[slot] = taskBucket->doTask(cx, futureBucket, task);
															#line 5920 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
			else
			{
															#line 520 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				++taskBucket->dispatchEmptyTasks;
															#line 521 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				done = true;
															#line 5928 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
		}
															#line 525 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (done)
															#line 5933 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 526 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			getBatchSize = 1;
															#line 5937 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 529 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			getBatchSize = std::min<unsigned int>(getBatchSize * 2, maxConcurrentTasks);
															#line 5944 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DispatchActor*>(this)->actor_wait_state > 0) static_cast<DispatchActor*>(this)->actor_wait_state = 0;
		static_cast<DispatchActor*>(this)->ActorCallback< DispatchActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DispatchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dispatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DispatchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dispatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DispatchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dispatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispatch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 547 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		for(int i = 0;i < tasks.size();++i) {
															#line 548 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (tasks[i].isReady())
															#line 6031 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 549 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				availableSlots.push_back(i);
															#line 550 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				tasks[i] = Never();
															#line 6037 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 547 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		for(int i = 0;i < tasks.size();++i) {
															#line 548 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (tasks[i].isReady())
															#line 6050 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 549 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				availableSlots.push_back(i);
															#line 550 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				tasks[i] = Never();
															#line 6056 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DispatchActor*>(this)->actor_wait_state > 0) static_cast<DispatchActor*>(this)->actor_wait_state = 0;
		static_cast<DispatchActor*>(this)->ActorCallback< DispatchActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DispatchActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dispatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DispatchActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dispatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DispatchActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dispatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispatch", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Database cx;
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	std::shared_ptr<double const> pollDelay;
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	int maxConcurrentTasks;
															#line 482 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	std::vector<Future<bool>> tasks;
															#line 488 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	std::vector<int> availableSlots;
															#line 493 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	std::vector<Future<Reference<Task>>> getTasks;
															#line 494 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	unsigned int getBatchSize;
															#line 6156 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via dispatch()
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class DispatchActor final : public Actor<Void>, public ActorCallback< DispatchActor, 0, Void >, public ActorCallback< DispatchActor, 1, Void >, public FastAllocated<DispatchActor>, public DispatchActorState<DispatchActor> {
															#line 6161 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<DispatchActor>::operator new;
	using FastAllocated<DispatchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(884176351617169408UL, 14643614626174445824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DispatchActor, 0, Void >;
friend struct ActorCallback< DispatchActor, 1, Void >;
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	DispatchActor(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,std::shared_ptr<double const> const& pollDelay,int const& maxConcurrentTasks) 
															#line 6179 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Void>(),
		   DispatchActorState<DispatchActor>(cx, taskBucket, futureBucket, pollDelay, maxConcurrentTasks),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dispatch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14253156495924647936UL, 13742860952431464960UL);
		ActorExecutionContextHelper __helper(static_cast<DispatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dispatch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dispatch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DispatchActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DispatchActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Void> dispatch( Database const& cx, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, std::shared_ptr<double const> const& pollDelay, int const& maxConcurrentTasks ) {
															#line 477 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Void>(new DispatchActor(cx, taskBucket, futureBucket, pollDelay, maxConcurrentTasks));
															#line 6212 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 555 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 6217 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via watchPaused()
															#line 556 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class WatchPausedActor>
															#line 556 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class WatchPausedActorState {
															#line 6223 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 556 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	WatchPausedActorState(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<AsyncVar<bool>> const& paused) 
															#line 556 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 556 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : cx(cx),
															#line 556 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 556 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   paused(paused)
															#line 6234 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("watchPaused", reinterpret_cast<unsigned long>(this));

	}
	~WatchPausedActorState() 
	{
		fdb_probe_actor_destroy("watchPaused", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 559 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			;
															#line 6249 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchPausedActorState();
		static_cast<WatchPausedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 560 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 6279 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		try {
															#line 562 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskBucket->setOptions(tr);
															#line 563 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(taskBucket->pauseKey);
															#line 563 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<WatchPausedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6287 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WatchPausedActor*>(this)->actor_wait_state = 1;
															#line 563 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchPausedActor, 0, Optional<Value> >*>(static_cast<WatchPausedActor*>(this)));
															#line 6292 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 569 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 569 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<WatchPausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6316 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<WatchPausedActor*>(this)->actor_wait_state = 4;
															#line 569 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WatchPausedActor, 3, Void >*>(static_cast<WatchPausedActor*>(this)));
															#line 6321 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& pausedVal,int loopDepth) 
	{
															#line 564 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		paused->set(pausedVal.present());
															#line 565 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		watchPausedFuture = tr->watch(taskBucket->pauseKey);
															#line 566 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 566 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<WatchPausedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6342 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WatchPausedActor*>(this)->actor_wait_state = 2;
															#line 566 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchPausedActor, 1, Void >*>(static_cast<WatchPausedActor*>(this)));
															#line 6347 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && pausedVal,int loopDepth) 
	{
															#line 564 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		paused->set(pausedVal.present());
															#line 565 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		watchPausedFuture = tr->watch(taskBucket->pauseKey);
															#line 566 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 566 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<WatchPausedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6362 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WatchPausedActor*>(this)->actor_wait_state = 2;
															#line 566 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchPausedActor, 1, Void >*>(static_cast<WatchPausedActor*>(this)));
															#line 6367 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& pausedVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(pausedVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && pausedVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(pausedVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchPausedActor*>(this)->actor_wait_state > 0) static_cast<WatchPausedActor*>(this)->actor_wait_state = 0;
		static_cast<WatchPausedActor*>(this)->ActorCallback< WatchPausedActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< WatchPausedActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("watchPaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchPausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchPaused", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchPausedActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("watchPaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchPausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchPaused", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchPausedActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("watchPaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchPausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchPaused", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 567 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchPausedFuture;
															#line 567 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<WatchPausedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6453 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WatchPausedActor*>(this)->actor_wait_state = 3;
															#line 567 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WatchPausedActor, 2, Void >*>(static_cast<WatchPausedActor*>(this)));
															#line 6458 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 567 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchPausedFuture;
															#line 567 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<WatchPausedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6469 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WatchPausedActor*>(this)->actor_wait_state = 3;
															#line 567 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WatchPausedActor, 2, Void >*>(static_cast<WatchPausedActor*>(this)));
															#line 6474 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WatchPausedActor*>(this)->actor_wait_state > 0) static_cast<WatchPausedActor*>(this)->actor_wait_state = 0;
		static_cast<WatchPausedActor*>(this)->ActorCallback< WatchPausedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchPausedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchPaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchPausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchPaused", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatchPausedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchPaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchPausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchPaused", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WatchPausedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchPaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchPausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchPaused", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WatchPausedActor*>(this)->actor_wait_state > 0) static_cast<WatchPausedActor*>(this)->actor_wait_state = 0;
		static_cast<WatchPausedActor*>(this)->ActorCallback< WatchPausedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchPausedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchPaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchPausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchPaused", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WatchPausedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchPaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchPausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchPaused", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WatchPausedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchPaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchPausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchPaused", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WatchPausedActor*>(this)->actor_wait_state > 0) static_cast<WatchPausedActor*>(this)->actor_wait_state = 0;
		static_cast<WatchPausedActor*>(this)->ActorCallback< WatchPausedActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchPausedActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchPaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchPausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchPaused", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WatchPausedActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchPaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchPausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchPaused", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WatchPausedActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchPaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchPausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchPaused", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 556 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Database cx;
															#line 556 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 556 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<AsyncVar<bool>> paused;
															#line 560 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 565 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Future<Void> watchPausedFuture;
															#line 6751 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via watchPaused()
															#line 556 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class WatchPausedActor final : public Actor<Void>, public ActorCallback< WatchPausedActor, 0, Optional<Value> >, public ActorCallback< WatchPausedActor, 1, Void >, public ActorCallback< WatchPausedActor, 2, Void >, public ActorCallback< WatchPausedActor, 3, Void >, public FastAllocated<WatchPausedActor>, public WatchPausedActorState<WatchPausedActor> {
															#line 6756 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<WatchPausedActor>::operator new;
	using FastAllocated<WatchPausedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13477080050724797696UL, 14338477407299033600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchPausedActor, 0, Optional<Value> >;
friend struct ActorCallback< WatchPausedActor, 1, Void >;
friend struct ActorCallback< WatchPausedActor, 2, Void >;
friend struct ActorCallback< WatchPausedActor, 3, Void >;
															#line 556 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	WatchPausedActor(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<AsyncVar<bool>> const& paused) 
															#line 6776 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Void>(),
		   WatchPausedActorState<WatchPausedActor>(cx, taskBucket, paused),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchPaused", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15464598422296287232UL, 5628187193091012352UL);
		ActorExecutionContextHelper __helper(static_cast<WatchPausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchPaused");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchPaused", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchPausedActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WatchPausedActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WatchPausedActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WatchPausedActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 556 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Void> watchPaused( Database const& cx, Reference<TaskBucket> const& taskBucket, Reference<AsyncVar<bool>> const& paused ) {
															#line 556 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Void>(new WatchPausedActor(cx, taskBucket, paused));
															#line 6811 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 573 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 6816 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via run()
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class RunActor>
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class RunActorState {
															#line 6822 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	RunActorState(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,std::shared_ptr<double const> const& pollDelay,int const& maxConcurrentTasks) 
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : cx(cx),
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   futureBucket(futureBucket),
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   pollDelay(pollDelay),
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   maxConcurrentTasks(maxConcurrentTasks),
															#line 579 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   paused(makeReference<AsyncVar<bool>>(true)),
															#line 580 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   watchPausedFuture(watchPaused(cx, taskBucket, paused))
															#line 6841 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("run", reinterpret_cast<unsigned long>(this));

	}
	~RunActorState() 
	{
		fdb_probe_actor_destroy("run", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 581 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskBucket->metricLogger = taskBucket->cc.traceCounters( "TaskBucketMetrics", taskBucket->dbgid, CLIENT_KNOBS->TASKBUCKET_LOGGING_DELAY);
															#line 583 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			;
															#line 6858 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunActorState();
		static_cast<RunActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 584 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		;
															#line 6888 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 588 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_1 = dispatch(cx, taskBucket, futureBucket, pollDelay, maxConcurrentTasks) || paused->onChange() || watchPausedFuture;
															#line 588 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6899 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 2;
															#line 588 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunActor, 1, Void >*>(static_cast<RunActor*>(this)));
															#line 6904 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 584 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!(paused->get()))
															#line 6920 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 585 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_0 = paused->onChange() || watchPausedFuture;
															#line 585 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6928 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 1;
															#line 585 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunActor, 0, Void >*>(static_cast<RunActor*>(this)));
															#line 6933 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Database cx;
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	std::shared_ptr<double const> pollDelay;
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	int maxConcurrentTasks;
															#line 579 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<AsyncVar<bool>> paused;
															#line 580 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Future<Void> watchPausedFuture;
															#line 7139 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via run()
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class RunActor final : public Actor<Void>, public ActorCallback< RunActor, 0, Void >, public ActorCallback< RunActor, 1, Void >, public FastAllocated<RunActor>, public RunActorState<RunActor> {
															#line 7144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<RunActor>::operator new;
	using FastAllocated<RunActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14978324497357284608UL, 1197336288991758080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunActor, 0, Void >;
friend struct ActorCallback< RunActor, 1, Void >;
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	RunActor(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,std::shared_ptr<double const> const& pollDelay,int const& maxConcurrentTasks) 
															#line 7162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Void>(),
		   RunActorState<RunActor>(cx, taskBucket, futureBucket, pollDelay, maxConcurrentTasks),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(633236942609902848UL, 16810589115111353856UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("run");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Void> run( Database const& cx, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, std::shared_ptr<double const> const& pollDelay, int const& maxConcurrentTasks ) {
															#line 574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Void>(new RunActor(cx, taskBucket, futureBucket, pollDelay, maxConcurrentTasks));
															#line 7195 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 592 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

	static Future<Standalone<StringRef>> addIdle(Reference<ReadYourWritesTransaction> tr,
	                                             Reference<TaskBucket> taskBucket) {
		taskBucket->setOptions(tr);

		auto newTask = makeReference<Task>(IdleTaskFunc::name, IdleTaskFunc::version);
		return taskBucket->addTask(tr, newTask);
	}

	static Future<Standalone<StringRef>> addIdle(Database cx, Reference<TaskBucket> taskBucket) {
		return runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) { return addIdle(tr, taskBucket); });
	}

																#line 7212 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via isEmpty()
															#line 605 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class IsEmptyActor>
															#line 605 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class IsEmptyActorState {
															#line 7218 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 605 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	IsEmptyActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket) 
															#line 605 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 605 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 605 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket)
															#line 7227 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("isEmpty", reinterpret_cast<unsigned long>(this));

	}
	~IsEmptyActorState() 
	{
		fdb_probe_actor_destroy("isEmpty", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 606 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskBucket->setOptions(tr);
															#line 609 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			resultFutures = std::vector<Future<RangeResult>>();
															#line 610 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			for(int pri = 0;pri <= CLIENT_KNOBS->TASKBUCKET_MAX_PRIORITY;++pri) {
															#line 611 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				resultFutures.push_back(tr->getRange(taskBucket->getAvailableSpace(pri).range(), 1));
															#line 7248 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
															#line 614 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			i = int();
															#line 615 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			i = 0;
															#line 7254 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IsEmptyActorState();
		static_cast<IsEmptyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 621 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr->getRange(taskBucket->timeouts.range(), 1);
															#line 621 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<IsEmptyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7279 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<IsEmptyActor*>(this)->actor_wait_state = 2;
															#line 621 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IsEmptyActor, 1, RangeResult >*>(static_cast<IsEmptyActor*>(this)));
															#line 7284 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 615 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!(i < resultFutures.size()))
															#line 7300 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 616 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = resultFutures[i];
															#line 616 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<IsEmptyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7308 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<IsEmptyActor*>(this)->actor_wait_state = 1;
															#line 616 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IsEmptyActor, 0, RangeResult >*>(static_cast<IsEmptyActor*>(this)));
															#line 7313 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult const& results,int loopDepth) 
	{
															#line 617 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (results.size() > 0)
															#line 7335 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 618 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<IsEmptyActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IsEmptyActorState(); static_cast<IsEmptyActor*>(this)->destroy(); return 0; }
															#line 7339 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<IsEmptyActor*>(this)->SAV< bool >::value()) bool(false);
			this->~IsEmptyActorState();
			static_cast<IsEmptyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 615 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		++i;
															#line 7347 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult && results,int loopDepth) 
	{
															#line 617 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (results.size() > 0)
															#line 7356 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 618 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<IsEmptyActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IsEmptyActorState(); static_cast<IsEmptyActor*>(this)->destroy(); return 0; }
															#line 7360 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<IsEmptyActor*>(this)->SAV< bool >::value()) bool(false);
			this->~IsEmptyActorState();
			static_cast<IsEmptyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 615 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		++i;
															#line 7368 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IsEmptyActor*>(this)->actor_wait_state > 0) static_cast<IsEmptyActor*>(this)->actor_wait_state = 0;
		static_cast<IsEmptyActor*>(this)->ActorCallback< IsEmptyActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< IsEmptyActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("isEmpty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isEmpty", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IsEmptyActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("isEmpty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isEmpty", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IsEmptyActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("isEmpty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IsEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isEmpty", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(RangeResult const& values,int loopDepth) 
	{
															#line 622 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (values.size() > 0)
															#line 7452 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 623 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<IsEmptyActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IsEmptyActorState(); static_cast<IsEmptyActor*>(this)->destroy(); return 0; }
															#line 7456 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<IsEmptyActor*>(this)->SAV< bool >::value()) bool(false);
			this->~IsEmptyActorState();
			static_cast<IsEmptyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 625 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<IsEmptyActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsEmptyActorState(); static_cast<IsEmptyActor*>(this)->destroy(); return 0; }
															#line 7464 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<IsEmptyActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IsEmptyActorState();
		static_cast<IsEmptyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(RangeResult && values,int loopDepth) 
	{
															#line 622 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (values.size() > 0)
															#line 7476 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 623 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<IsEmptyActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IsEmptyActorState(); static_cast<IsEmptyActor*>(this)->destroy(); return 0; }
															#line 7480 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<IsEmptyActor*>(this)->SAV< bool >::value()) bool(false);
			this->~IsEmptyActorState();
			static_cast<IsEmptyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 625 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<IsEmptyActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsEmptyActorState(); static_cast<IsEmptyActor*>(this)->destroy(); return 0; }
															#line 7488 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<IsEmptyActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IsEmptyActorState();
		static_cast<IsEmptyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult const& values,int loopDepth) 
	{
		loopDepth = a_body1cont3(values, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult && values,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(values), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IsEmptyActor*>(this)->actor_wait_state > 0) static_cast<IsEmptyActor*>(this)->actor_wait_state = 0;
		static_cast<IsEmptyActor*>(this)->ActorCallback< IsEmptyActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< IsEmptyActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("isEmpty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isEmpty", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IsEmptyActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("isEmpty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isEmpty", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IsEmptyActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("isEmpty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IsEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isEmpty", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 605 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 605 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 609 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	std::vector<Future<RangeResult>> resultFutures;
															#line 614 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	int i;
															#line 7579 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via isEmpty()
															#line 605 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class IsEmptyActor final : public Actor<bool>, public ActorCallback< IsEmptyActor, 0, RangeResult >, public ActorCallback< IsEmptyActor, 1, RangeResult >, public FastAllocated<IsEmptyActor>, public IsEmptyActorState<IsEmptyActor> {
															#line 7584 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<IsEmptyActor>::operator new;
	using FastAllocated<IsEmptyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17221961315865299456UL, 8512717764129686528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IsEmptyActor, 0, RangeResult >;
friend struct ActorCallback< IsEmptyActor, 1, RangeResult >;
															#line 605 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	IsEmptyActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket) 
															#line 7602 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<bool>(),
		   IsEmptyActorState<IsEmptyActor>(tr, taskBucket),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("isEmpty", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16451052055362535168UL, 14821399935413420800UL);
		ActorExecutionContextHelper __helper(static_cast<IsEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("isEmpty");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("isEmpty", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IsEmptyActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IsEmptyActor, 1, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 605 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<bool> isEmpty( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket ) {
															#line 605 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<bool>(new IsEmptyActor(tr, taskBucket));
															#line 7635 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 627 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 7640 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via isBusy()
															#line 628 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class IsBusyActor>
															#line 628 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class IsBusyActorState {
															#line 7646 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 628 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	IsBusyActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket) 
															#line 628 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 628 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 628 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket)
															#line 7655 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("isBusy", reinterpret_cast<unsigned long>(this));

	}
	~IsBusyActorState() 
	{
		fdb_probe_actor_destroy("isBusy", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 629 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskBucket->setOptions(tr);
															#line 632 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			resultFutures = std::vector<Future<RangeResult>>();
															#line 633 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			for(int pri = 0;pri <= CLIENT_KNOBS->TASKBUCKET_MAX_PRIORITY;++pri) {
															#line 634 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				resultFutures.push_back(tr->getRange(taskBucket->getAvailableSpace(pri).range(), 1));
															#line 7676 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
															#line 637 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			i = int();
															#line 638 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			i = 0;
															#line 7682 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IsBusyActorState();
		static_cast<IsBusyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 644 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<IsBusyActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IsBusyActorState(); static_cast<IsBusyActor*>(this)->destroy(); return 0; }
															#line 7705 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<IsBusyActor*>(this)->SAV< bool >::value()) bool(false);
		this->~IsBusyActorState();
		static_cast<IsBusyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 638 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!(i < resultFutures.size()))
															#line 7724 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 639 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = resultFutures[i];
															#line 639 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<IsBusyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7732 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<IsBusyActor*>(this)->actor_wait_state = 1;
															#line 639 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IsBusyActor, 0, RangeResult >*>(static_cast<IsBusyActor*>(this)));
															#line 7737 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult const& results,int loopDepth) 
	{
															#line 640 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (results.size() > 0)
															#line 7759 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 641 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<IsBusyActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsBusyActorState(); static_cast<IsBusyActor*>(this)->destroy(); return 0; }
															#line 7763 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<IsBusyActor*>(this)->SAV< bool >::value()) bool(true);
			this->~IsBusyActorState();
			static_cast<IsBusyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 638 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		++i;
															#line 7771 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult && results,int loopDepth) 
	{
															#line 640 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (results.size() > 0)
															#line 7780 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 641 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<IsBusyActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsBusyActorState(); static_cast<IsBusyActor*>(this)->destroy(); return 0; }
															#line 7784 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<IsBusyActor*>(this)->SAV< bool >::value()) bool(true);
			this->~IsBusyActorState();
			static_cast<IsBusyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 638 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		++i;
															#line 7792 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IsBusyActor*>(this)->actor_wait_state > 0) static_cast<IsBusyActor*>(this)->actor_wait_state = 0;
		static_cast<IsBusyActor*>(this)->ActorCallback< IsBusyActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< IsBusyActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("isBusy", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsBusyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isBusy", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IsBusyActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("isBusy", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsBusyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isBusy", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IsBusyActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("isBusy", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IsBusyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isBusy", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 628 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 628 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 632 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	std::vector<Future<RangeResult>> resultFutures;
															#line 637 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	int i;
															#line 7880 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via isBusy()
															#line 628 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class IsBusyActor final : public Actor<bool>, public ActorCallback< IsBusyActor, 0, RangeResult >, public FastAllocated<IsBusyActor>, public IsBusyActorState<IsBusyActor> {
															#line 7885 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<IsBusyActor>::operator new;
	using FastAllocated<IsBusyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8092897136392042496UL, 3773713634074326272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IsBusyActor, 0, RangeResult >;
															#line 628 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	IsBusyActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket) 
															#line 7902 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<bool>(),
		   IsBusyActorState<IsBusyActor>(tr, taskBucket),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("isBusy", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1346151463132016640UL, 3515692081062852608UL);
		ActorExecutionContextHelper __helper(static_cast<IsBusyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("isBusy");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("isBusy", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IsBusyActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 628 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<bool> isBusy( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket ) {
															#line 628 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<bool>(new IsBusyActor(tr, taskBucket));
															#line 7934 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 646 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

	// Verify that the task's keys are still in the timeout space at the expected timeout prefix
																#line 7940 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via isFinished()
															#line 648 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class IsFinishedActor>
															#line 648 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class IsFinishedActorState {
															#line 7946 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 648 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	IsFinishedActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& task) 
															#line 648 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 648 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 648 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 648 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   task(task)
															#line 7957 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("isFinished", reinterpret_cast<unsigned long>(this));

	}
	~IsFinishedActorState() 
	{
		fdb_probe_actor_destroy("isFinished", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 651 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskBucket->setOptions(tr);
															#line 653 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Tuple t = Tuple::makeTuple(task->timeoutVersion, task->key);
															#line 654 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(taskBucket->timeouts.range(t), 1);
															#line 654 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<IsFinishedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7978 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IsFinishedActor*>(this)->actor_wait_state = 1;
															#line 654 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IsFinishedActor, 0, RangeResult >*>(static_cast<IsFinishedActor*>(this)));
															#line 7983 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IsFinishedActorState();
		static_cast<IsFinishedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& values,int loopDepth) 
	{
															#line 655 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (values.size() > 0)
															#line 8006 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 656 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<IsFinishedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IsFinishedActorState(); static_cast<IsFinishedActor*>(this)->destroy(); return 0; }
															#line 8010 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<IsFinishedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~IsFinishedActorState();
			static_cast<IsFinishedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 658 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<IsFinishedActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsFinishedActorState(); static_cast<IsFinishedActor*>(this)->destroy(); return 0; }
															#line 8018 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<IsFinishedActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IsFinishedActorState();
		static_cast<IsFinishedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && values,int loopDepth) 
	{
															#line 655 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (values.size() > 0)
															#line 8030 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 656 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<IsFinishedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IsFinishedActorState(); static_cast<IsFinishedActor*>(this)->destroy(); return 0; }
															#line 8034 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<IsFinishedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~IsFinishedActorState();
			static_cast<IsFinishedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 658 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<IsFinishedActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsFinishedActorState(); static_cast<IsFinishedActor*>(this)->destroy(); return 0; }
															#line 8042 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<IsFinishedActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IsFinishedActorState();
		static_cast<IsFinishedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& values,int loopDepth) 
	{
		loopDepth = a_body1cont1(values, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && values,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(values), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IsFinishedActor*>(this)->actor_wait_state > 0) static_cast<IsFinishedActor*>(this)->actor_wait_state = 0;
		static_cast<IsFinishedActor*>(this)->ActorCallback< IsFinishedActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< IsFinishedActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("isFinished", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsFinishedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isFinished", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IsFinishedActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("isFinished", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsFinishedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isFinished", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IsFinishedActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("isFinished", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IsFinishedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isFinished", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 648 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 648 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 648 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<Task> task;
															#line 8131 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via isFinished()
															#line 648 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class IsFinishedActor final : public Actor<bool>, public ActorCallback< IsFinishedActor, 0, RangeResult >, public FastAllocated<IsFinishedActor>, public IsFinishedActorState<IsFinishedActor> {
															#line 8136 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<IsFinishedActor>::operator new;
	using FastAllocated<IsFinishedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12158675498455680256UL, 15117434060997011456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IsFinishedActor, 0, RangeResult >;
															#line 648 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	IsFinishedActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& task) 
															#line 8153 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<bool>(),
		   IsFinishedActorState<IsFinishedActor>(tr, taskBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("isFinished", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11245074961757062144UL, 14318190831776429568UL);
		ActorExecutionContextHelper __helper(static_cast<IsFinishedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("isFinished");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("isFinished", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IsFinishedActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 648 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<bool> isFinished( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<Task> const& task ) {
															#line 648 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<bool>(new IsFinishedActor(tr, taskBucket, task));
															#line 8185 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 660 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 8190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via getActiveKey()
															#line 661 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class GetActiveKeyActor>
															#line 661 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class GetActiveKeyActorState {
															#line 8196 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 661 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	GetActiveKeyActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Optional<Value> const& startingValue) 
															#line 661 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 661 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 661 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 661 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   startingValue(startingValue)
															#line 8207 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("getActiveKey", reinterpret_cast<unsigned long>(this));

	}
	~GetActiveKeyActorState() 
	{
		fdb_probe_actor_destroy("getActiveKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 664 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskBucket->setOptions(tr);
															#line 666 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(taskBucket->active.key());
															#line 666 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<GetActiveKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8226 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetActiveKeyActor*>(this)->actor_wait_state = 1;
															#line 666 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetActiveKeyActor, 0, Optional<Value> >*>(static_cast<GetActiveKeyActor*>(this)));
															#line 8231 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetActiveKeyActorState();
		static_cast<GetActiveKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& new_value,int loopDepth) 
	{
															#line 667 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (new_value != startingValue)
															#line 8254 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 668 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<GetActiveKeyActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetActiveKeyActorState(); static_cast<GetActiveKeyActor*>(this)->destroy(); return 0; }
															#line 8258 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<GetActiveKeyActor*>(this)->SAV< bool >::value()) bool(true);
			this->~GetActiveKeyActorState();
			static_cast<GetActiveKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 670 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<GetActiveKeyActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetActiveKeyActorState(); static_cast<GetActiveKeyActor*>(this)->destroy(); return 0; }
															#line 8266 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<GetActiveKeyActor*>(this)->SAV< bool >::value()) bool(false);
		this->~GetActiveKeyActorState();
		static_cast<GetActiveKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && new_value,int loopDepth) 
	{
															#line 667 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (new_value != startingValue)
															#line 8278 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 668 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<GetActiveKeyActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetActiveKeyActorState(); static_cast<GetActiveKeyActor*>(this)->destroy(); return 0; }
															#line 8282 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<GetActiveKeyActor*>(this)->SAV< bool >::value()) bool(true);
			this->~GetActiveKeyActorState();
			static_cast<GetActiveKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 670 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<GetActiveKeyActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetActiveKeyActorState(); static_cast<GetActiveKeyActor*>(this)->destroy(); return 0; }
															#line 8290 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<GetActiveKeyActor*>(this)->SAV< bool >::value()) bool(false);
		this->~GetActiveKeyActorState();
		static_cast<GetActiveKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& new_value,int loopDepth) 
	{
		loopDepth = a_body1cont1(new_value, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && new_value,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(new_value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetActiveKeyActor*>(this)->actor_wait_state > 0) static_cast<GetActiveKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetActiveKeyActor*>(this)->ActorCallback< GetActiveKeyActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetActiveKeyActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getActiveKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActiveKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActiveKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetActiveKeyActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getActiveKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActiveKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActiveKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetActiveKeyActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getActiveKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetActiveKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActiveKey", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 661 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 661 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 661 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Optional<Value> startingValue;
															#line 8379 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via getActiveKey()
															#line 661 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class GetActiveKeyActor final : public Actor<bool>, public ActorCallback< GetActiveKeyActor, 0, Optional<Value> >, public FastAllocated<GetActiveKeyActor>, public GetActiveKeyActorState<GetActiveKeyActor> {
															#line 8384 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<GetActiveKeyActor>::operator new;
	using FastAllocated<GetActiveKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(625333721857201408UL, 14850383665307183872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetActiveKeyActor, 0, Optional<Value> >;
															#line 661 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	GetActiveKeyActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Optional<Value> const& startingValue) 
															#line 8401 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<bool>(),
		   GetActiveKeyActorState<GetActiveKeyActor>(tr, taskBucket, startingValue),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getActiveKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10983012661391621376UL, 8700785107588888832UL);
		ActorExecutionContextHelper __helper(static_cast<GetActiveKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getActiveKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getActiveKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetActiveKeyActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 661 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<bool> getActiveKey( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Optional<Value> const& startingValue ) {
															#line 661 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<bool>(new GetActiveKeyActor(tr, taskBucket, startingValue));
															#line 8433 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 672 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 8438 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via checkActive()
															#line 673 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class CheckActiveActor>
															#line 673 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class CheckActiveActorState {
															#line 8444 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 673 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	CheckActiveActorState(Database const& cx,Reference<TaskBucket> const& taskBucket) 
															#line 673 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 673 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : cx(cx),
															#line 673 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 674 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   tr(new ReadYourWritesTransaction(cx)),
															#line 675 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   startingValue()
															#line 8457 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("checkActive", reinterpret_cast<unsigned long>(this));

	}
	~CheckActiveActorState() 
	{
		fdb_probe_actor_destroy("checkActive", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 677 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			;
															#line 8472 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckActiveActorState();
		static_cast<CheckActiveActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 696 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		idx = 0;
															#line 697 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		;
															#line 8497 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 679 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskBucket->setOptions(tr);
															#line 681 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<bool> __when_expr_0 = isBusy(tr, taskBucket);
															#line 681 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<CheckActiveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8518 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckActiveActor*>(this)->actor_wait_state = 1;
															#line 681 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckActiveActor, 0, bool >*>(static_cast<CheckActiveActor*>(this)));
															#line 8523 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 692 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr->onError(e);
															#line 692 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<CheckActiveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8560 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CheckActiveActor*>(this)->actor_wait_state = 5;
															#line 692 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckActiveActor, 4, Void >*>(static_cast<CheckActiveActor*>(this)));
															#line 8565 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool const& is_busy,int loopDepth) 
	{
															#line 682 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!is_busy)
															#line 8580 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 683 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(addIdle(tr, taskBucket));
															#line 683 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<CheckActiveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8586 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckActiveActor*>(this)->actor_wait_state = 2;
															#line 683 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckActiveActor, 1, Void >*>(static_cast<CheckActiveActor*>(this)));
															#line 8591 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool && is_busy,int loopDepth) 
	{
															#line 682 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!is_busy)
															#line 8605 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 683 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(addIdle(tr, taskBucket));
															#line 683 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<CheckActiveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8611 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckActiveActor*>(this)->actor_wait_state = 2;
															#line 683 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckActiveActor, 1, Void >*>(static_cast<CheckActiveActor*>(this)));
															#line 8616 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& is_busy,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(is_busy, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && is_busy,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(is_busy), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckActiveActor*>(this)->actor_wait_state > 0) static_cast<CheckActiveActor*>(this)->actor_wait_state = 0;
		static_cast<CheckActiveActor*>(this)->ActorCallback< CheckActiveActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CheckActiveActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckActiveActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckActiveActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 686 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr->get(taskBucket->active.key());
															#line 686 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<CheckActiveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8707 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckActiveActor*>(this)->actor_wait_state = 3;
															#line 686 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckActiveActor, 2, Optional<Value> >*>(static_cast<CheckActiveActor*>(this)));
															#line 8712 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckActiveActor*>(this)->actor_wait_state > 0) static_cast<CheckActiveActor*>(this)->actor_wait_state = 0;
		static_cast<CheckActiveActor*>(this)->ActorCallback< CheckActiveActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckActiveActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckActiveActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckActiveActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Optional<Value> const& val,int loopDepth) 
	{
															#line 687 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		startingValue = val;
															#line 689 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 689 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<CheckActiveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8812 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckActiveActor*>(this)->actor_wait_state = 4;
															#line 689 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckActiveActor, 3, Void >*>(static_cast<CheckActiveActor*>(this)));
															#line 8817 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Optional<Value> && val,int loopDepth) 
	{
															#line 687 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		startingValue = val;
															#line 689 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 689 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<CheckActiveActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8830 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckActiveActor*>(this)->actor_wait_state = 4;
															#line 689 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckActiveActor, 3, Void >*>(static_cast<CheckActiveActor*>(this)));
															#line 8835 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckActiveActor*>(this)->actor_wait_state > 0) static_cast<CheckActiveActor*>(this)->actor_wait_state = 0;
		static_cast<CheckActiveActor*>(this)->ActorCallback< CheckActiveActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckActiveActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckActiveActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckActiveActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckActiveActor*>(this)->actor_wait_state > 0) static_cast<CheckActiveActor*>(this)->actor_wait_state = 0;
		static_cast<CheckActiveActor*>(this)->ActorCallback< CheckActiveActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckActiveActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckActiveActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckActiveActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckActiveActor*>(this)->actor_wait_state > 0) static_cast<CheckActiveActor*>(this)->actor_wait_state = 0;
		static_cast<CheckActiveActor*>(this)->ActorCallback< CheckActiveActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckActiveActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckActiveActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckActiveActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 716 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		CODE_PROBE(true, "checkActive return false");
															#line 717 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<CheckActiveActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckActiveActorState(); static_cast<CheckActiveActor*>(this)->destroy(); return 0; }
															#line 9095 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<CheckActiveActor*>(this)->SAV< bool >::value()) bool(false);
		this->~CheckActiveActorState();
		static_cast<CheckActiveActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 697 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!(idx < CLIENT_KNOBS->TASKBUCKET_CHECK_ACTIVE_AMOUNT))
															#line 9114 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 698 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 699 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		;
															#line 9122 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 697 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		++idx;
															#line 9144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 701 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskBucket->setOptions(tr);
															#line 703 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_5 = delay(CLIENT_KNOBS->TASKBUCKET_CHECK_ACTIVE_DELAY);
															#line 703 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<CheckActiveActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9165 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_5.get(), loopDepth); };
			static_cast<CheckActiveActor*>(this)->actor_wait_state = 6;
															#line 703 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckActiveActor, 5, Void >*>(static_cast<CheckActiveActor*>(this)));
															#line 9170 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 711 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr->onError(e);
															#line 711 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<CheckActiveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 9207 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<CheckActiveActor*>(this)->actor_wait_state = 8;
															#line 711 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CheckActiveActor, 7, Void >*>(static_cast<CheckActiveActor*>(this)));
															#line 9212 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 704 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<bool> __when_expr_6 = getActiveKey(tr, taskBucket, startingValue);
															#line 704 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<CheckActiveActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9229 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<CheckActiveActor*>(this)->actor_wait_state = 7;
															#line 704 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CheckActiveActor, 6, bool >*>(static_cast<CheckActiveActor*>(this)));
															#line 9234 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 704 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<bool> __when_expr_6 = getActiveKey(tr, taskBucket, startingValue);
															#line 704 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<CheckActiveActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9245 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<CheckActiveActor*>(this)->actor_wait_state = 7;
															#line 704 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CheckActiveActor, 6, bool >*>(static_cast<CheckActiveActor*>(this)));
															#line 9250 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CheckActiveActor*>(this)->actor_wait_state > 0) static_cast<CheckActiveActor*>(this)->actor_wait_state = 0;
		static_cast<CheckActiveActor*>(this)->ActorCallback< CheckActiveActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckActiveActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CheckActiveActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CheckActiveActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1loopBody1cont3(bool const& isActiveKey,int loopDepth) 
	{
															#line 705 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (isActiveKey)
															#line 9334 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 706 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			CODE_PROBE(true, "checkActive return true");
															#line 707 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<CheckActiveActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckActiveActorState(); static_cast<CheckActiveActor*>(this)->destroy(); return 0; }
															#line 9340 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<CheckActiveActor*>(this)->SAV< bool >::value()) bool(true);
			this->~CheckActiveActorState();
			static_cast<CheckActiveActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3(bool && isActiveKey,int loopDepth) 
	{
															#line 705 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (isActiveKey)
															#line 9354 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 706 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			CODE_PROBE(true, "checkActive return true");
															#line 707 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<CheckActiveActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckActiveActorState(); static_cast<CheckActiveActor*>(this)->destroy(); return 0; }
															#line 9360 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<CheckActiveActor*>(this)->SAV< bool >::value()) bool(true);
			this->~CheckActiveActorState();
			static_cast<CheckActiveActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(bool const& isActiveKey,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(isActiveKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(bool && isActiveKey,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(std::move(isActiveKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CheckActiveActor*>(this)->actor_wait_state > 0) static_cast<CheckActiveActor*>(this)->actor_wait_state = 0;
		static_cast<CheckActiveActor*>(this)->ActorCallback< CheckActiveActor, 6, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CheckActiveActor, 6, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CheckActiveActor, 6, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CheckActiveActor, 6, bool >*,Error err) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CheckActiveActor*>(this)->actor_wait_state > 0) static_cast<CheckActiveActor*>(this)->actor_wait_state = 0;
		static_cast<CheckActiveActor*>(this)->ActorCallback< CheckActiveActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckActiveActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CheckActiveActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CheckActiveActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 673 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Database cx;
															#line 673 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 674 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 675 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Optional<Value> startingValue;
															#line 696 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	int idx;
															#line 9542 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via checkActive()
															#line 673 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class CheckActiveActor final : public Actor<bool>, public ActorCallback< CheckActiveActor, 0, bool >, public ActorCallback< CheckActiveActor, 1, Void >, public ActorCallback< CheckActiveActor, 2, Optional<Value> >, public ActorCallback< CheckActiveActor, 3, Void >, public ActorCallback< CheckActiveActor, 4, Void >, public ActorCallback< CheckActiveActor, 5, Void >, public ActorCallback< CheckActiveActor, 6, bool >, public ActorCallback< CheckActiveActor, 7, Void >, public FastAllocated<CheckActiveActor>, public CheckActiveActorState<CheckActiveActor> {
															#line 9547 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<CheckActiveActor>::operator new;
	using FastAllocated<CheckActiveActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4761310548732118784UL, 98224917035984384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckActiveActor, 0, bool >;
friend struct ActorCallback< CheckActiveActor, 1, Void >;
friend struct ActorCallback< CheckActiveActor, 2, Optional<Value> >;
friend struct ActorCallback< CheckActiveActor, 3, Void >;
friend struct ActorCallback< CheckActiveActor, 4, Void >;
friend struct ActorCallback< CheckActiveActor, 5, Void >;
friend struct ActorCallback< CheckActiveActor, 6, bool >;
friend struct ActorCallback< CheckActiveActor, 7, Void >;
															#line 673 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	CheckActiveActor(Database const& cx,Reference<TaskBucket> const& taskBucket) 
															#line 9571 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<bool>(),
		   CheckActiveActorState<CheckActiveActor>(cx, taskBucket),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkActive", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8594797435574322176UL, 2768639104587905024UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkActive");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkActive", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckActiveActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckActiveActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckActiveActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckActiveActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckActiveActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CheckActiveActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CheckActiveActor, 6, bool >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CheckActiveActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 673 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<bool> checkActive( Database const& cx, Reference<TaskBucket> const& taskBucket ) {
															#line 673 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<bool>(new CheckActiveActor(cx, taskBucket));
															#line 9610 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 719 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 9615 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via getTaskCount()
															#line 720 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class GetTaskCountActor>
															#line 720 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class GetTaskCountActorState {
															#line 9621 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 720 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	GetTaskCountActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket) 
															#line 720 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 720 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 720 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket)
															#line 9630 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("getTaskCount", reinterpret_cast<unsigned long>(this));

	}
	~GetTaskCountActorState() 
	{
		fdb_probe_actor_destroy("getTaskCount", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 722 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskBucket->setOptions(tr);
															#line 724 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(taskBucket->prefix.pack("task_count"_sr));
															#line 724 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<GetTaskCountActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9649 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTaskCountActor*>(this)->actor_wait_state = 1;
															#line 724 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTaskCountActor, 0, Optional<Value> >*>(static_cast<GetTaskCountActor*>(this)));
															#line 9654 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTaskCountActorState();
		static_cast<GetTaskCountActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 726 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!val.present())
															#line 9677 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 727 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<GetTaskCountActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~GetTaskCountActorState(); static_cast<GetTaskCountActor*>(this)->destroy(); return 0; }
															#line 9681 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<GetTaskCountActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~GetTaskCountActorState();
			static_cast<GetTaskCountActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 729 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		ASSERT(val.get().size() == sizeof(int64_t));
															#line 731 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		int64_t intValue = 0;
															#line 732 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		memcpy(&intValue, val.get().begin(), val.get().size());
															#line 734 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<GetTaskCountActor*>(this)->SAV<int64_t>::futures) { (void)(intValue); this->~GetTaskCountActorState(); static_cast<GetTaskCountActor*>(this)->destroy(); return 0; }
															#line 9695 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<GetTaskCountActor*>(this)->SAV< int64_t >::value()) int64_t(intValue);
		this->~GetTaskCountActorState();
		static_cast<GetTaskCountActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 726 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!val.present())
															#line 9707 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 727 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<GetTaskCountActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~GetTaskCountActorState(); static_cast<GetTaskCountActor*>(this)->destroy(); return 0; }
															#line 9711 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<GetTaskCountActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~GetTaskCountActorState();
			static_cast<GetTaskCountActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 729 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		ASSERT(val.get().size() == sizeof(int64_t));
															#line 731 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		int64_t intValue = 0;
															#line 732 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		memcpy(&intValue, val.get().begin(), val.get().size());
															#line 734 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<GetTaskCountActor*>(this)->SAV<int64_t>::futures) { (void)(intValue); this->~GetTaskCountActorState(); static_cast<GetTaskCountActor*>(this)->destroy(); return 0; }
															#line 9725 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<GetTaskCountActor*>(this)->SAV< int64_t >::value()) int64_t(intValue);
		this->~GetTaskCountActorState();
		static_cast<GetTaskCountActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTaskCountActor*>(this)->actor_wait_state > 0) static_cast<GetTaskCountActor*>(this)->actor_wait_state = 0;
		static_cast<GetTaskCountActor*>(this)->ActorCallback< GetTaskCountActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTaskCountActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getTaskCount", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTaskCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTaskCount", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTaskCountActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getTaskCount", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTaskCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTaskCount", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTaskCountActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getTaskCount", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTaskCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTaskCount", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 720 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 720 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 9812 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via getTaskCount()
															#line 720 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class GetTaskCountActor final : public Actor<int64_t>, public ActorCallback< GetTaskCountActor, 0, Optional<Value> >, public FastAllocated<GetTaskCountActor>, public GetTaskCountActorState<GetTaskCountActor> {
															#line 9817 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<GetTaskCountActor>::operator new;
	using FastAllocated<GetTaskCountActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5880513261320048128UL, 6009873792104998144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTaskCountActor, 0, Optional<Value> >;
															#line 720 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	GetTaskCountActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket) 
															#line 9834 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetTaskCountActorState<GetTaskCountActor>(tr, taskBucket),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTaskCount", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5704715396074115072UL, 16615744381911788544UL);
		ActorExecutionContextHelper __helper(static_cast<GetTaskCountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTaskCount");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTaskCount", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTaskCountActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 720 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<int64_t> getTaskCount( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket ) {
															#line 720 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<int64_t>(new GetTaskCountActor(tr, taskBucket));
															#line 9866 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 736 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

	// Looks for tasks that have timed out and returns them to be available tasks.
	// Returns True if any tasks were affected.
																#line 9873 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via requeueTimedOutTasks()
															#line 739 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class RequeueTimedOutTasksActor>
															#line 739 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class RequeueTimedOutTasksActorState {
															#line 9879 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 739 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	RequeueTimedOutTasksActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket) 
															#line 739 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 739 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 739 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket)
															#line 9888 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("requeueTimedOutTasks", reinterpret_cast<unsigned long>(this));

	}
	~RequeueTimedOutTasksActorState() 
	{
		fdb_probe_actor_destroy("requeueTimedOutTasks", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 741 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			CODE_PROBE(true, "Looks for tasks that have timed out and returns them to be available tasks.");
															#line 742 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr->getReadVersion();
															#line 742 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<RequeueTimedOutTasksActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9907 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RequeueTimedOutTasksActor*>(this)->actor_wait_state = 1;
															#line 742 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RequeueTimedOutTasksActor, 0, Version >*>(static_cast<RequeueTimedOutTasksActor*>(this)));
															#line 9912 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RequeueTimedOutTasksActorState();
		static_cast<RequeueTimedOutTasksActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Version const& end,int loopDepth) 
	{
															#line 743 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		range = KeyRange(KeyRangeRef(taskBucket->timeouts.get(0).range().begin, taskBucket->timeouts.get(end).range().end));
															#line 746 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr->getRange(range, CLIENT_KNOBS->TASKBUCKET_MAX_TASK_KEYS);
															#line 746 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<RequeueTimedOutTasksActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9939 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RequeueTimedOutTasksActor*>(this)->actor_wait_state = 2;
															#line 746 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RequeueTimedOutTasksActor, 1, RangeResult >*>(static_cast<RequeueTimedOutTasksActor*>(this)));
															#line 9944 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Version && end,int loopDepth) 
	{
															#line 743 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		range = KeyRange(KeyRangeRef(taskBucket->timeouts.get(0).range().begin, taskBucket->timeouts.get(end).range().end));
															#line 746 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr->getRange(range, CLIENT_KNOBS->TASKBUCKET_MAX_TASK_KEYS);
															#line 746 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<RequeueTimedOutTasksActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9957 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RequeueTimedOutTasksActor*>(this)->actor_wait_state = 2;
															#line 746 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RequeueTimedOutTasksActor, 1, RangeResult >*>(static_cast<RequeueTimedOutTasksActor*>(this)));
															#line 9962 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Version const& end,int loopDepth) 
	{
		loopDepth = a_body1cont1(end, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && end,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(end), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RequeueTimedOutTasksActor*>(this)->actor_wait_state > 0) static_cast<RequeueTimedOutTasksActor*>(this)->actor_wait_state = 0;
		static_cast<RequeueTimedOutTasksActor*>(this)->ActorCallback< RequeueTimedOutTasksActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< RequeueTimedOutTasksActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("requeueTimedOutTasks", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequeueTimedOutTasksActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requeueTimedOutTasks", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RequeueTimedOutTasksActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("requeueTimedOutTasks", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequeueTimedOutTasksActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requeueTimedOutTasks", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RequeueTimedOutTasksActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("requeueTimedOutTasks", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RequeueTimedOutTasksActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requeueTimedOutTasks", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(RangeResult const& values,int loopDepth) 
	{
															#line 753 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		Task task;
															#line 754 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		Key lastKey;
															#line 756 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		for( auto& iter : values ) {
															#line 757 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Tuple t = taskBucket->timeouts.unpack(iter.key);
															#line 758 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Key uid = t.getString(1);
															#line 759 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Key param = t.getString(2);
															#line 762 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (uid != task.key)
															#line 10058 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 764 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				Subspace space = taskBucket->getAvailableSpace(task.getPriority()).get(task.key);
															#line 765 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				for( auto& p : task.params ) {
															#line 766 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
					tr->set(space.pack(p.key), p.value);
															#line 10066 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				}
															#line 768 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				task.params.clear();
															#line 769 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				task.key = uid;
															#line 770 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				lastKey = iter.key;
															#line 10074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
															#line 773 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			task.params[param] = iter.value;
															#line 10078 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 777 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!values.more)
															#line 10082 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 778 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Subspace space = taskBucket->getAvailableSpace(task.getPriority()).get(task.key);
															#line 779 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			for( auto& p : task.params ) {
															#line 780 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				tr->set(space.pack(p.key), p.value);
															#line 10090 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
															#line 782 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (values.size() > 0)
															#line 10094 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 783 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				tr->clear(range);
															#line 784 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				if (!static_cast<RequeueTimedOutTasksActor*>(this)->SAV<bool>::futures) { (void)(true); this->~RequeueTimedOutTasksActorState(); static_cast<RequeueTimedOutTasksActor*>(this)->destroy(); return 0; }
															#line 10100 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				new (&static_cast<RequeueTimedOutTasksActor*>(this)->SAV< bool >::value()) bool(true);
				this->~RequeueTimedOutTasksActorState();
				static_cast<RequeueTimedOutTasksActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 786 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<RequeueTimedOutTasksActor*>(this)->SAV<bool>::futures) { (void)(false); this->~RequeueTimedOutTasksActorState(); static_cast<RequeueTimedOutTasksActor*>(this)->destroy(); return 0; }
															#line 10108 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<RequeueTimedOutTasksActor*>(this)->SAV< bool >::value()) bool(false);
			this->~RequeueTimedOutTasksActorState();
			static_cast<RequeueTimedOutTasksActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 789 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		ASSERT(lastKey != Key());
															#line 790 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr->clear(KeyRangeRef(range.begin, lastKey));
															#line 791 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<RequeueTimedOutTasksActor*>(this)->SAV<bool>::futures) { (void)(true); this->~RequeueTimedOutTasksActorState(); static_cast<RequeueTimedOutTasksActor*>(this)->destroy(); return 0; }
															#line 10120 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<RequeueTimedOutTasksActor*>(this)->SAV< bool >::value()) bool(true);
		this->~RequeueTimedOutTasksActorState();
		static_cast<RequeueTimedOutTasksActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(RangeResult && values,int loopDepth) 
	{
															#line 753 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		Task task;
															#line 754 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		Key lastKey;
															#line 756 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		for( auto& iter : values ) {
															#line 757 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Tuple t = taskBucket->timeouts.unpack(iter.key);
															#line 758 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Key uid = t.getString(1);
															#line 759 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Key param = t.getString(2);
															#line 762 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (uid != task.key)
															#line 10144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 764 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				Subspace space = taskBucket->getAvailableSpace(task.getPriority()).get(task.key);
															#line 765 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				for( auto& p : task.params ) {
															#line 766 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
					tr->set(space.pack(p.key), p.value);
															#line 10152 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				}
															#line 768 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				task.params.clear();
															#line 769 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				task.key = uid;
															#line 770 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				lastKey = iter.key;
															#line 10160 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
															#line 773 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			task.params[param] = iter.value;
															#line 10164 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 777 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!values.more)
															#line 10168 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 778 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Subspace space = taskBucket->getAvailableSpace(task.getPriority()).get(task.key);
															#line 779 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			for( auto& p : task.params ) {
															#line 780 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				tr->set(space.pack(p.key), p.value);
															#line 10176 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
															#line 782 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (values.size() > 0)
															#line 10180 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 783 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				tr->clear(range);
															#line 784 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				if (!static_cast<RequeueTimedOutTasksActor*>(this)->SAV<bool>::futures) { (void)(true); this->~RequeueTimedOutTasksActorState(); static_cast<RequeueTimedOutTasksActor*>(this)->destroy(); return 0; }
															#line 10186 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				new (&static_cast<RequeueTimedOutTasksActor*>(this)->SAV< bool >::value()) bool(true);
				this->~RequeueTimedOutTasksActorState();
				static_cast<RequeueTimedOutTasksActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 786 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<RequeueTimedOutTasksActor*>(this)->SAV<bool>::futures) { (void)(false); this->~RequeueTimedOutTasksActorState(); static_cast<RequeueTimedOutTasksActor*>(this)->destroy(); return 0; }
															#line 10194 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<RequeueTimedOutTasksActor*>(this)->SAV< bool >::value()) bool(false);
			this->~RequeueTimedOutTasksActorState();
			static_cast<RequeueTimedOutTasksActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 789 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		ASSERT(lastKey != Key());
															#line 790 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr->clear(KeyRangeRef(range.begin, lastKey));
															#line 791 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<RequeueTimedOutTasksActor*>(this)->SAV<bool>::futures) { (void)(true); this->~RequeueTimedOutTasksActorState(); static_cast<RequeueTimedOutTasksActor*>(this)->destroy(); return 0; }
															#line 10206 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<RequeueTimedOutTasksActor*>(this)->SAV< bool >::value()) bool(true);
		this->~RequeueTimedOutTasksActorState();
		static_cast<RequeueTimedOutTasksActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult const& values,int loopDepth) 
	{
		loopDepth = a_body1cont2(values, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult && values,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(values), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RequeueTimedOutTasksActor*>(this)->actor_wait_state > 0) static_cast<RequeueTimedOutTasksActor*>(this)->actor_wait_state = 0;
		static_cast<RequeueTimedOutTasksActor*>(this)->ActorCallback< RequeueTimedOutTasksActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< RequeueTimedOutTasksActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("requeueTimedOutTasks", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequeueTimedOutTasksActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requeueTimedOutTasks", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RequeueTimedOutTasksActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("requeueTimedOutTasks", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequeueTimedOutTasksActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requeueTimedOutTasks", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RequeueTimedOutTasksActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("requeueTimedOutTasks", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RequeueTimedOutTasksActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requeueTimedOutTasks", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 739 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 739 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 743 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	KeyRange range;
															#line 10295 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via requeueTimedOutTasks()
															#line 739 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class RequeueTimedOutTasksActor final : public Actor<bool>, public ActorCallback< RequeueTimedOutTasksActor, 0, Version >, public ActorCallback< RequeueTimedOutTasksActor, 1, RangeResult >, public FastAllocated<RequeueTimedOutTasksActor>, public RequeueTimedOutTasksActorState<RequeueTimedOutTasksActor> {
															#line 10300 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<RequeueTimedOutTasksActor>::operator new;
	using FastAllocated<RequeueTimedOutTasksActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2306042602070003456UL, 6393801108121161472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RequeueTimedOutTasksActor, 0, Version >;
friend struct ActorCallback< RequeueTimedOutTasksActor, 1, RangeResult >;
															#line 739 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	RequeueTimedOutTasksActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket) 
															#line 10318 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<bool>(),
		   RequeueTimedOutTasksActorState<RequeueTimedOutTasksActor>(tr, taskBucket),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("requeueTimedOutTasks", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1624542520032682496UL, 13005242540911148288UL);
		ActorExecutionContextHelper __helper(static_cast<RequeueTimedOutTasksActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("requeueTimedOutTasks");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("requeueTimedOutTasks", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RequeueTimedOutTasksActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RequeueTimedOutTasksActor, 1, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 739 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<bool> requeueTimedOutTasks( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket ) {
															#line 739 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<bool>(new RequeueTimedOutTasksActor(tr, taskBucket));
															#line 10351 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 793 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 10356 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via debugPrintRange()
															#line 794 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class DebugPrintRangeActor>
															#line 794 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class DebugPrintRangeActorState {
															#line 10362 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 794 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	DebugPrintRangeActorState(Reference<ReadYourWritesTransaction> const& tr,Subspace const& subspace,Key const& msg) 
															#line 794 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 794 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 794 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   subspace(subspace),
															#line 794 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   msg(msg)
															#line 10373 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("debugPrintRange", reinterpret_cast<unsigned long>(this));

	}
	~DebugPrintRangeActorState() 
	{
		fdb_probe_actor_destroy("debugPrintRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 795 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 796 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 797 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(subspace.range(), CLIENT_KNOBS->TOO_MANY);
															#line 797 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<DebugPrintRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10394 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DebugPrintRangeActor*>(this)->actor_wait_state = 1;
															#line 797 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DebugPrintRangeActor, 0, RangeResult >*>(static_cast<DebugPrintRangeActor*>(this)));
															#line 10399 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DebugPrintRangeActorState();
		static_cast<DebugPrintRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& values,int loopDepth) 
	{
															#line 798 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		TraceEvent("TaskBucketDebugPrintRange") .detail("Key", subspace.key()) .detail("Count", values.size()) .detail("Msg", msg);
															#line 811 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<DebugPrintRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DebugPrintRangeActorState(); static_cast<DebugPrintRangeActor*>(this)->destroy(); return 0; }
															#line 10424 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<DebugPrintRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DebugPrintRangeActorState();
		static_cast<DebugPrintRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && values,int loopDepth) 
	{
															#line 798 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		TraceEvent("TaskBucketDebugPrintRange") .detail("Key", subspace.key()) .detail("Count", values.size()) .detail("Msg", msg);
															#line 811 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<DebugPrintRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DebugPrintRangeActorState(); static_cast<DebugPrintRangeActor*>(this)->destroy(); return 0; }
															#line 10438 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<DebugPrintRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DebugPrintRangeActorState();
		static_cast<DebugPrintRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& values,int loopDepth) 
	{
		loopDepth = a_body1cont1(values, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && values,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(values), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DebugPrintRangeActor*>(this)->actor_wait_state > 0) static_cast<DebugPrintRangeActor*>(this)->actor_wait_state = 0;
		static_cast<DebugPrintRangeActor*>(this)->ActorCallback< DebugPrintRangeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< DebugPrintRangeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("debugPrintRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DebugPrintRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debugPrintRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DebugPrintRangeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("debugPrintRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DebugPrintRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debugPrintRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DebugPrintRangeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("debugPrintRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DebugPrintRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("debugPrintRange", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 794 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 794 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Subspace subspace;
															#line 794 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Key msg;
															#line 10527 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via debugPrintRange()
															#line 794 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class DebugPrintRangeActor final : public Actor<Void>, public ActorCallback< DebugPrintRangeActor, 0, RangeResult >, public FastAllocated<DebugPrintRangeActor>, public DebugPrintRangeActorState<DebugPrintRangeActor> {
															#line 10532 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<DebugPrintRangeActor>::operator new;
	using FastAllocated<DebugPrintRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17525764330418721280UL, 17613585306371301888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DebugPrintRangeActor, 0, RangeResult >;
															#line 794 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	DebugPrintRangeActor(Reference<ReadYourWritesTransaction> const& tr,Subspace const& subspace,Key const& msg) 
															#line 10549 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Void>(),
		   DebugPrintRangeActorState<DebugPrintRangeActor>(tr, subspace, msg),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("debugPrintRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11583729914699144448UL, 9037234331761320192UL);
		ActorExecutionContextHelper __helper(static_cast<DebugPrintRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("debugPrintRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("debugPrintRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DebugPrintRangeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 794 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Void> debugPrintRange( Reference<ReadYourWritesTransaction> const& tr, Subspace const& subspace, Key const& msg ) {
															#line 794 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Void>(new DebugPrintRangeActor(tr, subspace, msg));
															#line 10581 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 813 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 10586 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via extendTimeout()
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class ExtendTimeoutActor>
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class ExtendTimeoutActorState {
															#line 10592 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	ExtendTimeoutActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& task,UpdateParams const& updateParams,Version const& newTimeoutVersion) 
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   task(task),
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   updateParams(updateParams),
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   newTimeoutVersion(newTimeoutVersion)
															#line 10607 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("extendTimeout", reinterpret_cast<unsigned long>(this));

	}
	~ExtendTimeoutActorState() 
	{
		fdb_probe_actor_destroy("extendTimeout", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 819 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskBucket->setOptions(tr);
															#line 822 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_0 = taskBucket->keepRunning(tr, task);
															#line 822 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<ExtendTimeoutActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10626 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ExtendTimeoutActor*>(this)->actor_wait_state = 1;
															#line 822 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExtendTimeoutActor, 0, Void >*>(static_cast<ExtendTimeoutActor*>(this)));
															#line 10631 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExtendTimeoutActorState();
		static_cast<ExtendTimeoutActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 825 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		oldTimeoutSpace = taskBucket->timeouts.get(task->timeoutVersion).get(task->key);
															#line 827 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Version> __when_expr_1 = tr->getReadVersion();
															#line 827 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<ExtendTimeoutActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10658 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExtendTimeoutActor*>(this)->actor_wait_state = 2;
															#line 827 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExtendTimeoutActor, 1, Version >*>(static_cast<ExtendTimeoutActor*>(this)));
															#line 10663 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 825 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		oldTimeoutSpace = taskBucket->timeouts.get(task->timeoutVersion).get(task->key);
															#line 827 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Version> __when_expr_1 = tr->getReadVersion();
															#line 827 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<ExtendTimeoutActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10676 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExtendTimeoutActor*>(this)->actor_wait_state = 2;
															#line 827 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExtendTimeoutActor, 1, Version >*>(static_cast<ExtendTimeoutActor*>(this)));
															#line 10681 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExtendTimeoutActor*>(this)->actor_wait_state > 0) static_cast<ExtendTimeoutActor*>(this)->actor_wait_state = 0;
		static_cast<ExtendTimeoutActor*>(this)->ActorCallback< ExtendTimeoutActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("extendTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("extendTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExtendTimeoutActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("extendTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Version const& version,int loopDepth) 
	{
															#line 829 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (newTimeoutVersion == invalidVersion)
															#line 10765 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 830 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			newTimeoutVersion = version + taskBucket->timeout;
															#line 10769 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
		else
		{
															#line 831 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (newTimeoutVersion <= version)
															#line 10775 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 832 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				newTimeoutVersion = version + 1;
															#line 10779 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
		}
															#line 836 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (newTimeoutVersion <= task->timeoutVersion)
															#line 10784 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 837 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			newTimeoutVersion = task->timeoutVersion + 1;
															#line 10788 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 841 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		newTimeoutSpace = taskBucket->timeouts.get(newTimeoutVersion).get(task->key);
															#line 843 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr->addReadConflictRange(oldTimeoutSpace.range());
															#line 844 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr->addWriteConflictRange(newTimeoutSpace.range());
															#line 847 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (updateParams)
															#line 10798 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 848 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			CODE_PROBE(true, "Extended a task while updating parameters");
															#line 849 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			for( auto& p : task->params ) {
															#line 850 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				tr->set(newTimeoutSpace.pack(p.key), p.value);
															#line 10806 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		else
		{
															#line 853 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			CODE_PROBE(true, "Extended a task without updating parameters");
															#line 855 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<RangeResult> __when_expr_2 = tr->getRange(oldTimeoutSpace.range(), CLIENT_KNOBS->TOO_MANY);
															#line 855 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<ExtendTimeoutActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10818 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<ExtendTimeoutActor*>(this)->actor_wait_state = 3;
															#line 855 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExtendTimeoutActor, 2, RangeResult >*>(static_cast<ExtendTimeoutActor*>(this)));
															#line 10823 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2(Version && version,int loopDepth) 
	{
															#line 829 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (newTimeoutVersion == invalidVersion)
															#line 10833 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 830 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			newTimeoutVersion = version + taskBucket->timeout;
															#line 10837 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
		else
		{
															#line 831 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (newTimeoutVersion <= version)
															#line 10843 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 832 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				newTimeoutVersion = version + 1;
															#line 10847 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
		}
															#line 836 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (newTimeoutVersion <= task->timeoutVersion)
															#line 10852 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 837 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			newTimeoutVersion = task->timeoutVersion + 1;
															#line 10856 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 841 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		newTimeoutSpace = taskBucket->timeouts.get(newTimeoutVersion).get(task->key);
															#line 843 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr->addReadConflictRange(oldTimeoutSpace.range());
															#line 844 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr->addWriteConflictRange(newTimeoutSpace.range());
															#line 847 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (updateParams)
															#line 10866 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 848 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			CODE_PROBE(true, "Extended a task while updating parameters");
															#line 849 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			for( auto& p : task->params ) {
															#line 850 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				tr->set(newTimeoutSpace.pack(p.key), p.value);
															#line 10874 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		else
		{
															#line 853 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			CODE_PROBE(true, "Extended a task without updating parameters");
															#line 855 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<RangeResult> __when_expr_2 = tr->getRange(oldTimeoutSpace.range(), CLIENT_KNOBS->TOO_MANY);
															#line 855 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<ExtendTimeoutActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10886 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<ExtendTimeoutActor*>(this)->actor_wait_state = 3;
															#line 855 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExtendTimeoutActor, 2, RangeResult >*>(static_cast<ExtendTimeoutActor*>(this)));
															#line 10891 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1cont2(version, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExtendTimeoutActor*>(this)->actor_wait_state > 0) static_cast<ExtendTimeoutActor*>(this)->actor_wait_state = 0;
		static_cast<ExtendTimeoutActor*>(this)->ActorCallback< ExtendTimeoutActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("extendTimeout", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeout", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("extendTimeout", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeout", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExtendTimeoutActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("extendTimeout", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeout", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 862 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr->clear(oldTimeoutSpace.range());
															#line 864 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<ExtendTimeoutActor*>(this)->SAV<Version>::futures) { (void)(newTimeoutVersion); this->~ExtendTimeoutActorState(); static_cast<ExtendTimeoutActor*>(this)->destroy(); return 0; }
															#line 10978 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<ExtendTimeoutActor*>(this)->SAV< Version >::value()) Version(std::move(newTimeoutVersion)); // state_var_RVO
		this->~ExtendTimeoutActorState();
		static_cast<ExtendTimeoutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(RangeResult const& params,int loopDepth) 
	{
															#line 856 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		for( auto& kv : params ) {
															#line 857 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Tuple paramKey = oldTimeoutSpace.unpack(kv.key);
															#line 858 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			tr->set(newTimeoutSpace.pack(paramKey), kv.value);
															#line 10994 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(RangeResult && params,int loopDepth) 
	{
															#line 856 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		for( auto& kv : params ) {
															#line 857 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Tuple paramKey = oldTimeoutSpace.unpack(kv.key);
															#line 858 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			tr->set(newTimeoutSpace.pack(paramKey), kv.value);
															#line 11008 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(RangeResult const& params,int loopDepth) 
	{
		loopDepth = a_body1cont10(params, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(RangeResult && params,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(params), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ExtendTimeoutActor*>(this)->actor_wait_state > 0) static_cast<ExtendTimeoutActor*>(this)->actor_wait_state = 0;
		static_cast<ExtendTimeoutActor*>(this)->ActorCallback< ExtendTimeoutActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("extendTimeout", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeout", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ExtendTimeoutActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("extendTimeout", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeout", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ExtendTimeoutActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("extendTimeout", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extendTimeout", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<Task> task;
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	UpdateParams updateParams;
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Version newTimeoutVersion;
															#line 825 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Subspace oldTimeoutSpace;
															#line 841 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Subspace newTimeoutSpace;
															#line 11103 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via extendTimeout()
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class ExtendTimeoutActor final : public Actor<Version>, public ActorCallback< ExtendTimeoutActor, 0, Void >, public ActorCallback< ExtendTimeoutActor, 1, Version >, public ActorCallback< ExtendTimeoutActor, 2, RangeResult >, public FastAllocated<ExtendTimeoutActor>, public ExtendTimeoutActorState<ExtendTimeoutActor> {
															#line 11108 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<ExtendTimeoutActor>::operator new;
	using FastAllocated<ExtendTimeoutActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12261765362659464448UL, 11885828428627189248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExtendTimeoutActor, 0, Void >;
friend struct ActorCallback< ExtendTimeoutActor, 1, Version >;
friend struct ActorCallback< ExtendTimeoutActor, 2, RangeResult >;
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	ExtendTimeoutActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& task,UpdateParams const& updateParams,Version const& newTimeoutVersion) 
															#line 11127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Version>(),
		   ExtendTimeoutActorState<ExtendTimeoutActor>(tr, taskBucket, task, updateParams, newTimeoutVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("extendTimeout", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15842551433924005376UL, 6945048234063552768UL);
		ActorExecutionContextHelper __helper(static_cast<ExtendTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("extendTimeout");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("extendTimeout", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExtendTimeoutActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExtendTimeoutActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ExtendTimeoutActor, 2, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Version> extendTimeout( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<Task> const& task, UpdateParams const& updateParams, Version const& newTimeoutVersion ) {
															#line 814 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Version>(new ExtendTimeoutActor(tr, taskBucket, task, updateParams, newTimeoutVersion));
															#line 11161 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 866 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
};

TaskBucket::TaskBucket(const Subspace& subspace,
                       AccessSystemKeys sysAccess,
                       PriorityBatch priorityBatch,
                       LockAware lockAware)
  : dbgid(deterministicRandom()->randomUniqueID()), cc("TaskBucket", dbgid.toString()),
    dispatchSlotChecksStarted("DispatchSlotChecksStarted", cc), dispatchErrors("DispatchErrors", cc),
    dispatchDoTasks("DispatchDoTasks", cc), dispatchEmptyTasks("DispatchEmptyTasks", cc),
    dispatchSlotChecksComplete("DispatchSlotChecksComplete", cc), prefix(subspace), active(prefix.get("ac"_sr)),
    pauseKey(prefix.pack("pause"_sr)), available(prefix.get("av"_sr)), available_prioritized(prefix.get("avp"_sr)),
    timeouts(prefix.get("to"_sr)), timeout(CLIENT_KNOBS->TASKBUCKET_TIMEOUT_VERSIONS), system_access(sysAccess),
    priority_batch(priorityBatch), lockAware(lockAware) {}

TaskBucket::~TaskBucket() {}

Future<Void> TaskBucket::clear(Reference<ReadYourWritesTransaction> tr) {
	setOptions(tr);

	tr->clear(prefix.range());

	return Void();
}

Future<Void> TaskBucket::changePause(Reference<ReadYourWritesTransaction> tr, bool pause) {
	setOptions(tr);

	if (pause) {
		tr->set(pauseKey, StringRef());
	} else {
		tr->clear(pauseKey);
	}

	return Void();
}

Key TaskBucket::addTask(Reference<ReadYourWritesTransaction> tr, Reference<Task> task) {
	setOptions(tr);

	Key key(deterministicRandom()->randomUniqueID().toString());

	Subspace taskSpace;

	// If scheduledVersion is valid then place the task directly into the timeout
	// space for its scheduled time, otherwise place it in the available space by priority.
	Version scheduledVersion = ReservedTaskParams::scheduledVersion().getOrDefault(task, invalidVersion);
	if (scheduledVersion != invalidVersion) {
		taskSpace = timeouts.get(scheduledVersion).get(key);
	} else {
		taskSpace = getAvailableSpace(task->getPriority()).get(key);
	}

	for (auto& param : task->params)
		tr->set(taskSpace.pack(param.key), param.value);

	tr->atomicOp(prefix.pack("task_count"_sr), "\x01\x00\x00\x00\x00\x00\x00\x00"_sr, MutationRef::AddValue);

	return key;
}

void TaskBucket::setValidationCondition(Reference<Task> task, KeyRef vKey, KeyRef vValue) {
	task->params[Task::reservedTaskParamValidKey] = vKey;
	task->params[Task::reservedTaskParamValidValue] = vValue;
}

															#line 11230 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
namespace {
// This generated class is to be used only via actorAddTask()
															#line 931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class ActorAddTaskActor>
															#line 931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class ActorAddTaskActorState {
															#line 11237 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	ActorAddTaskActorState(TaskBucket* const& tb,Reference<ReadYourWritesTransaction> const& tr,Reference<Task> const& task,KeyRef const& validationKey) 
															#line 931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tb(tb),
															#line 931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   tr(tr),
															#line 931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   task(task),
															#line 931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   validationKey(validationKey)
															#line 11250 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("actorAddTask", reinterpret_cast<unsigned long>(this));

	}
	~ActorAddTaskActorState() 
	{
		fdb_probe_actor_destroy("actorAddTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 935 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			tb->setOptions(tr);
															#line 937 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(validationKey);
															#line 937 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<ActorAddTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11269 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ActorAddTaskActor*>(this)->actor_wait_state = 1;
															#line 937 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ActorAddTaskActor, 0, Optional<Value> >*>(static_cast<ActorAddTaskActor*>(this)));
															#line 11274 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ActorAddTaskActorState();
		static_cast<ActorAddTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& validationValue,int loopDepth) 
	{
															#line 939 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!validationValue.present())
															#line 11297 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 940 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			TraceEvent(SevError, "TaskBucketAddTaskInvalidKey") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("ValidationKey", validationKey);
															#line 943 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			return a_body1Catch1(invalid_option_value(), loopDepth);
															#line 11303 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 946 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		TaskBucket::setValidationCondition(task, validationKey, validationValue.get());
															#line 948 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<ActorAddTaskActor*>(this)->SAV<Key>::futures) { (void)(tb->addTask(tr, task)); this->~ActorAddTaskActorState(); static_cast<ActorAddTaskActor*>(this)->destroy(); return 0; }
															#line 11309 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<ActorAddTaskActor*>(this)->SAV< Key >::value()) Key(tb->addTask(tr, task));
		this->~ActorAddTaskActorState();
		static_cast<ActorAddTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && validationValue,int loopDepth) 
	{
															#line 939 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!validationValue.present())
															#line 11321 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 940 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			TraceEvent(SevError, "TaskBucketAddTaskInvalidKey") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("ValidationKey", validationKey);
															#line 943 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			return a_body1Catch1(invalid_option_value(), loopDepth);
															#line 11327 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 946 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		TaskBucket::setValidationCondition(task, validationKey, validationValue.get());
															#line 948 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<ActorAddTaskActor*>(this)->SAV<Key>::futures) { (void)(tb->addTask(tr, task)); this->~ActorAddTaskActorState(); static_cast<ActorAddTaskActor*>(this)->destroy(); return 0; }
															#line 11333 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<ActorAddTaskActor*>(this)->SAV< Key >::value()) Key(tb->addTask(tr, task));
		this->~ActorAddTaskActorState();
		static_cast<ActorAddTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& validationValue,int loopDepth) 
	{
		loopDepth = a_body1cont1(validationValue, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && validationValue,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(validationValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ActorAddTaskActor*>(this)->actor_wait_state > 0) static_cast<ActorAddTaskActor*>(this)->actor_wait_state = 0;
		static_cast<ActorAddTaskActor*>(this)->ActorCallback< ActorAddTaskActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ActorAddTaskActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("actorAddTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorAddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorAddTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ActorAddTaskActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("actorAddTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorAddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorAddTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ActorAddTaskActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("actorAddTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ActorAddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorAddTask", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	TaskBucket* tb;
															#line 931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<Task> task;
															#line 931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	KeyRef validationKey;
															#line 11424 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via actorAddTask()
															#line 931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class ActorAddTaskActor final : public Actor<Key>, public ActorCallback< ActorAddTaskActor, 0, Optional<Value> >, public FastAllocated<ActorAddTaskActor>, public ActorAddTaskActorState<ActorAddTaskActor> {
															#line 11429 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<ActorAddTaskActor>::operator new;
	using FastAllocated<ActorAddTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5855288368740166144UL, 3182386847312915200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ActorAddTaskActor, 0, Optional<Value> >;
															#line 931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	ActorAddTaskActor(TaskBucket* const& tb,Reference<ReadYourWritesTransaction> const& tr,Reference<Task> const& task,KeyRef const& validationKey) 
															#line 11446 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Key>(),
		   ActorAddTaskActorState<ActorAddTaskActor>(tb, tr, task, validationKey),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("actorAddTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12310168823437889024UL, 7195044841947420928UL);
		ActorExecutionContextHelper __helper(static_cast<ActorAddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("actorAddTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("actorAddTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ActorAddTaskActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Key> actorAddTask( TaskBucket* const& tb, Reference<ReadYourWritesTransaction> const& tr, Reference<Task> const& task, KeyRef const& validationKey ) {
															#line 931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Key>(new ActorAddTaskActor(tb, tr, task, validationKey));
															#line 11479 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 950 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

Future<Key> TaskBucket::addTask(Reference<ReadYourWritesTransaction> tr, Reference<Task> task, KeyRef validationKey) {
	return actorAddTask(this, tr, task, validationKey);
}

Key TaskBucket::addTask(Reference<ReadYourWritesTransaction> tr,
                        Reference<Task> task,
                        KeyRef validationKey,
                        KeyRef validationValue) {
	setValidationCondition(task, validationKey, validationValue);
	return addTask(tr, task);
}

Future<Reference<Task>> TaskBucket::getOne(Reference<ReadYourWritesTransaction> tr) {
	return TaskBucketImpl::getOne(tr, Reference<TaskBucket>::addRef(this));
}

Future<bool> TaskBucket::doOne(Database cx, Reference<FutureBucket> futureBucket) {
	return TaskBucketImpl::doOne(cx, Reference<TaskBucket>::addRef(this), futureBucket);
}

Future<bool> TaskBucket::doTask(Database cx, Reference<FutureBucket> futureBucket, Reference<Task> task) {
	return TaskBucketImpl::doTask(cx, Reference<TaskBucket>::addRef(this), futureBucket, task);
}

Future<Void> TaskBucket::run(Database cx,
                             Reference<FutureBucket> futureBucket,
                             std::shared_ptr<double const> pollDelay,
                             int maxConcurrentTasks) {
	return TaskBucketImpl::run(cx, Reference<TaskBucket>::addRef(this), futureBucket, pollDelay, maxConcurrentTasks);
}

Future<Void> TaskBucket::watchPaused(Database cx, Reference<AsyncVar<bool>> paused) {
	return TaskBucketImpl::watchPaused(cx, Reference<TaskBucket>::addRef(this), paused);
}

Future<bool> TaskBucket::isEmpty(Reference<ReadYourWritesTransaction> tr) {
	return TaskBucketImpl::isEmpty(tr, Reference<TaskBucket>::addRef(this));
}

Future<Void> TaskBucket::finish(Reference<ReadYourWritesTransaction> tr, Reference<Task> task) {
	setOptions(tr);

	Tuple t = Tuple::makeTuple(task->timeoutVersion, task->key);

	tr->atomicOp(prefix.pack("task_count"_sr), "\xff\xff\xff\xff\xff\xff\xff\xff"_sr, MutationRef::AddValue);
	tr->clear(timeouts.range(t));

	return Void();
}

Future<Version> TaskBucket::extendTimeout(Reference<ReadYourWritesTransaction> tr,
                                          Reference<Task> task,
                                          UpdateParams updateParams,
                                          Version newTimeoutVersion) {
	return TaskBucketImpl::extendTimeout(
	    tr, Reference<TaskBucket>::addRef(this), task, updateParams, newTimeoutVersion);
}

Future<bool> TaskBucket::isFinished(Reference<ReadYourWritesTransaction> tr, Reference<Task> task) {
	return TaskBucketImpl::isFinished(tr, Reference<TaskBucket>::addRef(this), task);
}

Future<bool> TaskBucket::isVerified(Reference<ReadYourWritesTransaction> tr, Reference<Task> task) {
	return TaskBucketImpl::taskVerify(Reference<TaskBucket>::addRef(this), tr, task);
}

Future<bool> TaskBucket::checkActive(Database cx) {
	return TaskBucketImpl::checkActive(cx, Reference<TaskBucket>::addRef(this));
}

Future<int64_t> TaskBucket::getTaskCount(Reference<ReadYourWritesTransaction> tr) {
	return TaskBucketImpl::getTaskCount(tr, Reference<TaskBucket>::addRef(this));
}

Future<Void> TaskBucket::watchTaskCount(Reference<ReadYourWritesTransaction> tr) {
	return tr->watch(prefix.pack("task_count"_sr));
}

Future<Void> TaskBucket::debugPrintRange(Reference<ReadYourWritesTransaction> tr, Subspace subspace, Key msg) {
	return TaskBucketImpl::debugPrintRange(tr, subspace, msg);
}

class FutureBucketImpl {
public:
																#line 11568 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via isEmpty()
															#line 1035 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class IsEmptyActor1>
															#line 1035 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class IsEmptyActor1State {
															#line 11574 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 1035 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	IsEmptyActor1State(Reference<ReadYourWritesTransaction> const& tr,Reference<FutureBucket> const& futureBucket) 
															#line 1035 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 1035 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 1035 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   futureBucket(futureBucket)
															#line 11583 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("isEmpty", reinterpret_cast<unsigned long>(this));

	}
	~IsEmptyActor1State() 
	{
		fdb_probe_actor_destroy("isEmpty", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1036 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			futureBucket->setOptions(tr);
															#line 1038 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Key> __when_expr_0 = tr->getKey(lastLessOrEqual(futureBucket->prefix.pack(maxUIDKey)));
															#line 1038 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<IsEmptyActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11602 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IsEmptyActor1*>(this)->actor_wait_state = 1;
															#line 1038 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IsEmptyActor1, 0, Key >*>(static_cast<IsEmptyActor1*>(this)));
															#line 11607 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IsEmptyActor1State();
		static_cast<IsEmptyActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& lastKey,int loopDepth) 
	{
															#line 1039 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<IsEmptyActor1*>(this)->SAV<bool>::futures) { (void)(!futureBucket->prefix.contains(lastKey)); this->~IsEmptyActor1State(); static_cast<IsEmptyActor1*>(this)->destroy(); return 0; }
															#line 11630 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<IsEmptyActor1*>(this)->SAV< bool >::value()) bool(!futureBucket->prefix.contains(lastKey));
		this->~IsEmptyActor1State();
		static_cast<IsEmptyActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Key && lastKey,int loopDepth) 
	{
															#line 1039 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<IsEmptyActor1*>(this)->SAV<bool>::futures) { (void)(!futureBucket->prefix.contains(lastKey)); this->~IsEmptyActor1State(); static_cast<IsEmptyActor1*>(this)->destroy(); return 0; }
															#line 11642 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<IsEmptyActor1*>(this)->SAV< bool >::value()) bool(!futureBucket->prefix.contains(lastKey));
		this->~IsEmptyActor1State();
		static_cast<IsEmptyActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Key const& lastKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(lastKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && lastKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(lastKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IsEmptyActor1*>(this)->actor_wait_state > 0) static_cast<IsEmptyActor1*>(this)->actor_wait_state = 0;
		static_cast<IsEmptyActor1*>(this)->ActorCallback< IsEmptyActor1, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< IsEmptyActor1, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("isEmpty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsEmptyActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isEmpty", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IsEmptyActor1, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("isEmpty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsEmptyActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isEmpty", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IsEmptyActor1, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("isEmpty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IsEmptyActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isEmpty", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1035 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1035 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 11729 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via isEmpty()
															#line 1035 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class IsEmptyActor1 final : public Actor<bool>, public ActorCallback< IsEmptyActor1, 0, Key >, public FastAllocated<IsEmptyActor1>, public IsEmptyActor1State<IsEmptyActor1> {
															#line 11734 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<IsEmptyActor1>::operator new;
	using FastAllocated<IsEmptyActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17221961315865299456UL, 8512717764129686528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IsEmptyActor1, 0, Key >;
															#line 1035 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	IsEmptyActor1(Reference<ReadYourWritesTransaction> const& tr,Reference<FutureBucket> const& futureBucket) 
															#line 11751 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<bool>(),
		   IsEmptyActor1State<IsEmptyActor1>(tr, futureBucket),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("isEmpty", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2914886213944108800UL, 15801221046479270400UL);
		ActorExecutionContextHelper __helper(static_cast<IsEmptyActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("isEmpty");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("isEmpty", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IsEmptyActor1, 0, Key >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1035 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<bool> isEmpty( Reference<ReadYourWritesTransaction> const& tr, Reference<FutureBucket> const& futureBucket ) {
															#line 1035 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<bool>(new IsEmptyActor1(tr, futureBucket));
															#line 11783 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 1041 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
};

FutureBucket::FutureBucket(const Subspace& subspace, AccessSystemKeys sysAccess, LockAware lockAware)
  : prefix(subspace), system_access(sysAccess), lockAware(lockAware) {}

FutureBucket::~FutureBucket() {}

Future<Void> FutureBucket::clear(Reference<ReadYourWritesTransaction> tr) {
	setOptions(tr);
	tr->clear(prefix.range());

	return Void();
}

Reference<TaskFuture> FutureBucket::future(Reference<ReadYourWritesTransaction> tr) {
	setOptions(tr);

	auto taskFuture = makeReference<TaskFuture>(Reference<FutureBucket>::addRef(this));
	taskFuture->addBlock(tr, StringRef());

	return taskFuture;
}

Future<bool> FutureBucket::isEmpty(Reference<ReadYourWritesTransaction> tr) {
	return FutureBucketImpl::isEmpty(tr, Reference<FutureBucket>::addRef(this));
}

Reference<TaskFuture> FutureBucket::unpack(Key key) {
	return makeReference<TaskFuture>(Reference<FutureBucket>::addRef(this), key);
}

class TaskFutureImpl {
public:
																#line 11820 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via join()
															#line 1074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class JoinActor>
															#line 1074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class JoinActorState {
															#line 11826 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 1074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	JoinActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture,std::vector<Reference<TaskFuture>> const& vectorFuture) 
															#line 1074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 1074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 1074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 1074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskFuture(taskFuture),
															#line 1074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   vectorFuture(vectorFuture)
															#line 11839 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("join", reinterpret_cast<unsigned long>(this));

	}
	~JoinActorState() 
	{
		fdb_probe_actor_destroy("join", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1078 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskFuture->futureBucket->setOptions(tr);
															#line 1080 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<bool> __when_expr_0 = isSet(tr, taskFuture);
															#line 1080 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<JoinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11858 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<JoinActor*>(this)->actor_wait_state = 1;
															#line 1080 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< JoinActor, 0, bool >*>(static_cast<JoinActor*>(this)));
															#line 11863 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~JoinActorState();
		static_cast<JoinActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& is_set,int loopDepth) 
	{
															#line 1082 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (is_set)
															#line 11886 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 1083 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<JoinActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~JoinActorState(); static_cast<JoinActor*>(this)->destroy(); return 0; }
															#line 11890 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<JoinActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~JoinActorState();
			static_cast<JoinActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1086 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr->clear(taskFuture->blocks.pack(StringRef()));
															#line 1088 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_1 = _join(tr, taskBucket, taskFuture, vectorFuture);
															#line 1088 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<JoinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11902 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<JoinActor*>(this)->actor_wait_state = 2;
															#line 1088 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< JoinActor, 1, Void >*>(static_cast<JoinActor*>(this)));
															#line 11907 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool && is_set,int loopDepth) 
	{
															#line 1082 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (is_set)
															#line 11916 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 1083 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<JoinActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~JoinActorState(); static_cast<JoinActor*>(this)->destroy(); return 0; }
															#line 11920 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<JoinActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~JoinActorState();
			static_cast<JoinActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1086 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr->clear(taskFuture->blocks.pack(StringRef()));
															#line 1088 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_1 = _join(tr, taskBucket, taskFuture, vectorFuture);
															#line 1088 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<JoinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11932 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<JoinActor*>(this)->actor_wait_state = 2;
															#line 1088 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< JoinActor, 1, Void >*>(static_cast<JoinActor*>(this)));
															#line 11937 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(bool const& is_set,int loopDepth) 
	{
		loopDepth = a_body1cont1(is_set, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && is_set,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(is_set), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<JoinActor*>(this)->actor_wait_state > 0) static_cast<JoinActor*>(this)->actor_wait_state = 0;
		static_cast<JoinActor*>(this)->ActorCallback< JoinActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< JoinActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("join", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<JoinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("join", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< JoinActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("join", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<JoinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("join", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< JoinActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("join", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<JoinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("join", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1090 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<JoinActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~JoinActorState(); static_cast<JoinActor*>(this)->destroy(); return 0; }
															#line 12021 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<JoinActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~JoinActorState();
		static_cast<JoinActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1090 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<JoinActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~JoinActorState(); static_cast<JoinActor*>(this)->destroy(); return 0; }
															#line 12033 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<JoinActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~JoinActorState();
		static_cast<JoinActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<JoinActor*>(this)->actor_wait_state > 0) static_cast<JoinActor*>(this)->actor_wait_state = 0;
		static_cast<JoinActor*>(this)->ActorCallback< JoinActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< JoinActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("join", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<JoinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("join", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< JoinActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("join", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<JoinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("join", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< JoinActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("join", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<JoinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("join", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskFuture> taskFuture;
															#line 1074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	std::vector<Reference<TaskFuture>> vectorFuture;
															#line 12124 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via join()
															#line 1074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class JoinActor final : public Actor<Void>, public ActorCallback< JoinActor, 0, bool >, public ActorCallback< JoinActor, 1, Void >, public FastAllocated<JoinActor>, public JoinActorState<JoinActor> {
															#line 12129 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<JoinActor>::operator new;
	using FastAllocated<JoinActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8430212365870594816UL, 14387505822626485248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< JoinActor, 0, bool >;
friend struct ActorCallback< JoinActor, 1, Void >;
															#line 1074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	JoinActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture,std::vector<Reference<TaskFuture>> const& vectorFuture) 
															#line 12147 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Void>(),
		   JoinActorState<JoinActor>(tr, taskBucket, taskFuture, vectorFuture),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("join", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10799056812640889600UL, 2174156346673693952UL);
		ActorExecutionContextHelper __helper(static_cast<JoinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("join");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("join", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< JoinActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< JoinActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Void> join( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<TaskFuture> const& taskFuture, std::vector<Reference<TaskFuture>> const& vectorFuture ) {
															#line 1074 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Void>(new JoinActor(tr, taskBucket, taskFuture, vectorFuture));
															#line 12180 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 1092 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 12185 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via _join()
															#line 1093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class _joinActor>
															#line 1093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class _joinActorState {
															#line 12191 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 1093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	_joinActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture,std::vector<Reference<TaskFuture>> const& vectorFuture) 
															#line 1093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 1093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 1093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 1093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskFuture(taskFuture),
															#line 1093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   vectorFuture(vectorFuture)
															#line 12204 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("_join", reinterpret_cast<unsigned long>(this));

	}
	~_joinActorState() 
	{
		fdb_probe_actor_destroy("_join", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1097 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			std::vector<Future<Void>> onSetFutures;
															#line 1098 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			for(int i = 0;i < vectorFuture.size();++i) {
															#line 1099 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				Key key = StringRef(deterministicRandom()->randomUniqueID().toString());
															#line 1100 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				taskFuture->addBlock(tr, key);
															#line 1101 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				auto task = makeReference<Task>();
															#line 1102 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				task->params[Task::reservedTaskParamKeyType] = "UnblockFuture"_sr;
															#line 1103 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				task->params[Task::reservedTaskParamKeyFuture] = taskFuture->key;
															#line 1104 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				task->params[Task::reservedTaskParamKeyBlockID] = key;
															#line 1105 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				onSetFutures.push_back(vectorFuture[i]->onSet(tr, taskBucket, task));
															#line 12235 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
															#line 1108 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(onSetFutures);
															#line 1108 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<_joinActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12241 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_joinActor*>(this)->actor_wait_state = 1;
															#line 1108 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _joinActor, 0, Void >*>(static_cast<_joinActor*>(this)));
															#line 12246 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_joinActorState();
		static_cast<_joinActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1110 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<_joinActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_joinActorState(); static_cast<_joinActor*>(this)->destroy(); return 0; }
															#line 12269 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<_joinActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_joinActorState();
		static_cast<_joinActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1110 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<_joinActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_joinActorState(); static_cast<_joinActor*>(this)->destroy(); return 0; }
															#line 12281 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<_joinActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_joinActorState();
		static_cast<_joinActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_joinActor*>(this)->actor_wait_state > 0) static_cast<_joinActor*>(this)->actor_wait_state = 0;
		static_cast<_joinActor*>(this)->ActorCallback< _joinActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _joinActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_join", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_joinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_join", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _joinActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_join", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_joinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_join", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _joinActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_join", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_joinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_join", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskFuture> taskFuture;
															#line 1093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	std::vector<Reference<TaskFuture>> vectorFuture;
															#line 12372 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via _join()
															#line 1093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class _joinActor final : public Actor<Void>, public ActorCallback< _joinActor, 0, Void >, public FastAllocated<_joinActor>, public _joinActorState<_joinActor> {
															#line 12377 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<_joinActor>::operator new;
	using FastAllocated<_joinActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16300575902680869376UL, 7656285133081998592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _joinActor, 0, Void >;
															#line 1093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	_joinActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture,std::vector<Reference<TaskFuture>> const& vectorFuture) 
															#line 12394 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Void>(),
		   _joinActorState<_joinActor>(tr, taskBucket, taskFuture, vectorFuture),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_join", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1599090461501033728UL, 11164404817420868608UL);
		ActorExecutionContextHelper __helper(static_cast<_joinActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_join");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_join", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _joinActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Void> _join( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<TaskFuture> const& taskFuture, std::vector<Reference<TaskFuture>> const& vectorFuture ) {
															#line 1093 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Void>(new _joinActor(tr, taskBucket, taskFuture, vectorFuture));
															#line 12426 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 1112 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 12431 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via isSet()
															#line 1113 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class IsSetActor>
															#line 1113 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class IsSetActorState {
															#line 12437 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 1113 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	IsSetActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskFuture> const& taskFuture) 
															#line 1113 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 1113 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 1113 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskFuture(taskFuture)
															#line 12446 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("isSet", reinterpret_cast<unsigned long>(this));

	}
	~IsSetActorState() 
	{
		fdb_probe_actor_destroy("isSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1114 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskFuture->futureBucket->setOptions(tr);
															#line 1116 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(taskFuture->blocks.range(), 1);
															#line 1116 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<IsSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12465 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IsSetActor*>(this)->actor_wait_state = 1;
															#line 1116 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IsSetActor, 0, RangeResult >*>(static_cast<IsSetActor*>(this)));
															#line 12470 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IsSetActorState();
		static_cast<IsSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& values,int loopDepth) 
	{
															#line 1117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (values.size() > 0)
															#line 12493 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 1118 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<IsSetActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IsSetActorState(); static_cast<IsSetActor*>(this)->destroy(); return 0; }
															#line 12497 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<IsSetActor*>(this)->SAV< bool >::value()) bool(false);
			this->~IsSetActorState();
			static_cast<IsSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1120 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<IsSetActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsSetActorState(); static_cast<IsSetActor*>(this)->destroy(); return 0; }
															#line 12505 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<IsSetActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IsSetActorState();
		static_cast<IsSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && values,int loopDepth) 
	{
															#line 1117 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (values.size() > 0)
															#line 12517 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 1118 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (!static_cast<IsSetActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IsSetActorState(); static_cast<IsSetActor*>(this)->destroy(); return 0; }
															#line 12521 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			new (&static_cast<IsSetActor*>(this)->SAV< bool >::value()) bool(false);
			this->~IsSetActorState();
			static_cast<IsSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1120 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<IsSetActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsSetActorState(); static_cast<IsSetActor*>(this)->destroy(); return 0; }
															#line 12529 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<IsSetActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IsSetActorState();
		static_cast<IsSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& values,int loopDepth) 
	{
		loopDepth = a_body1cont1(values, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && values,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(values), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IsSetActor*>(this)->actor_wait_state > 0) static_cast<IsSetActor*>(this)->actor_wait_state = 0;
		static_cast<IsSetActor*>(this)->ActorCallback< IsSetActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< IsSetActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("isSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IsSetActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("isSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IsSetActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("isSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IsSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isSet", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1113 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1113 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskFuture> taskFuture;
															#line 12616 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via isSet()
															#line 1113 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class IsSetActor final : public Actor<bool>, public ActorCallback< IsSetActor, 0, RangeResult >, public FastAllocated<IsSetActor>, public IsSetActorState<IsSetActor> {
															#line 12621 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<IsSetActor>::operator new;
	using FastAllocated<IsSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10849581701584669184UL, 4840633412275091200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IsSetActor, 0, RangeResult >;
															#line 1113 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	IsSetActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskFuture> const& taskFuture) 
															#line 12638 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<bool>(),
		   IsSetActorState<IsSetActor>(tr, taskFuture),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("isSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6802880988239226880UL, 3119662381830635520UL);
		ActorExecutionContextHelper __helper(static_cast<IsSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("isSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("isSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IsSetActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1113 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<bool> isSet( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskFuture> const& taskFuture ) {
															#line 1113 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<bool>(new IsSetActor(tr, taskFuture));
															#line 12670 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 1122 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 12675 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via onSet()
															#line 1123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class OnSetActor>
															#line 1123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class OnSetActorState {
															#line 12681 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 1123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	OnSetActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture,Reference<Task> const& task) 
															#line 1123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 1123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 1123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 1123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskFuture(taskFuture),
															#line 1123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   task(task)
															#line 12694 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("onSet", reinterpret_cast<unsigned long>(this));

	}
	~OnSetActorState() 
	{
		fdb_probe_actor_destroy("onSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskFuture->futureBucket->setOptions(tr);
															#line 1129 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<bool> __when_expr_0 = isSet(tr, taskFuture);
															#line 1129 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<OnSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12713 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<OnSetActor*>(this)->actor_wait_state = 1;
															#line 1129 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OnSetActor, 0, bool >*>(static_cast<OnSetActor*>(this)));
															#line 12718 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OnSetActorState();
		static_cast<OnSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& is_set,int loopDepth) 
	{
															#line 1131 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (is_set)
															#line 12741 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 1132 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			CODE_PROBE(true, "is_set == true");
															#line 1133 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_1 = performAction(tr, taskBucket, taskFuture, task);
															#line 1133 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<OnSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12749 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<OnSetActor*>(this)->actor_wait_state = 2;
															#line 1133 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OnSetActor, 1, Void >*>(static_cast<OnSetActor*>(this)));
															#line 12754 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1135 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			CODE_PROBE(true, "is_set == false");
															#line 1136 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Subspace callbackSpace = taskFuture->callbacks.get(StringRef(deterministicRandom()->randomUniqueID().toString()));
															#line 1138 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			for( auto& v : task->params ) {
															#line 1139 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				tr->set(callbackSpace.pack(v.key), v.value);
															#line 12767 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(bool && is_set,int loopDepth) 
	{
															#line 1131 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (is_set)
															#line 12778 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 1132 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			CODE_PROBE(true, "is_set == true");
															#line 1133 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_1 = performAction(tr, taskBucket, taskFuture, task);
															#line 1133 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<OnSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12786 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<OnSetActor*>(this)->actor_wait_state = 2;
															#line 1133 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OnSetActor, 1, Void >*>(static_cast<OnSetActor*>(this)));
															#line 12791 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1135 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			CODE_PROBE(true, "is_set == false");
															#line 1136 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Subspace callbackSpace = taskFuture->callbacks.get(StringRef(deterministicRandom()->randomUniqueID().toString()));
															#line 1138 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			for( auto& v : task->params ) {
															#line 1139 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				tr->set(callbackSpace.pack(v.key), v.value);
															#line 12804 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(bool const& is_set,int loopDepth) 
	{
		loopDepth = a_body1cont1(is_set, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && is_set,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(is_set), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OnSetActor*>(this)->actor_wait_state > 0) static_cast<OnSetActor*>(this)->actor_wait_state = 0;
		static_cast<OnSetActor*>(this)->ActorCallback< OnSetActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< OnSetActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("onSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OnSetActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("onSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OnSetActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("onSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1143 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<OnSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnSetActorState(); static_cast<OnSetActor*>(this)->destroy(); return 0; }
															#line 12890 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<OnSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OnSetActorState();
		static_cast<OnSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OnSetActor*>(this)->actor_wait_state > 0) static_cast<OnSetActor*>(this)->actor_wait_state = 0;
		static_cast<OnSetActor*>(this)->ActorCallback< OnSetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OnSetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("onSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OnSetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("onSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OnSetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("onSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onSet", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskFuture> taskFuture;
															#line 1123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<Task> task;
															#line 12993 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via onSet()
															#line 1123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class OnSetActor final : public Actor<Void>, public ActorCallback< OnSetActor, 0, bool >, public ActorCallback< OnSetActor, 1, Void >, public FastAllocated<OnSetActor>, public OnSetActorState<OnSetActor> {
															#line 12998 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<OnSetActor>::operator new;
	using FastAllocated<OnSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14922045802050116352UL, 1559551383721643264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OnSetActor, 0, bool >;
friend struct ActorCallback< OnSetActor, 1, Void >;
															#line 1123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	OnSetActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture,Reference<Task> const& task) 
															#line 13016 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Void>(),
		   OnSetActorState<OnSetActor>(tr, taskBucket, taskFuture, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("onSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17881788668793225216UL, 6850207283330329088UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("onSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("onSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OnSetActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OnSetActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Void> onSet( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<TaskFuture> const& taskFuture, Reference<Task> const& task ) {
															#line 1123 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Void>(new OnSetActor(tr, taskBucket, taskFuture, task));
															#line 13049 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 1145 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 13054 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via set()
															#line 1146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class SetActor>
															#line 1146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class SetActorState {
															#line 13060 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 1146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	SetActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture) 
															#line 1146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 1146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 1146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 1146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskFuture(taskFuture)
															#line 13071 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("set", reinterpret_cast<unsigned long>(this));

	}
	~SetActorState() 
	{
		fdb_probe_actor_destroy("set", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1149 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskFuture->futureBucket->setOptions(tr);
															#line 1151 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			tr->clear(taskFuture->blocks.range());
															#line 1153 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_0 = performAllActions(tr, taskBucket, taskFuture);
															#line 1153 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<SetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13092 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetActor*>(this)->actor_wait_state = 1;
															#line 1153 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetActor, 0, Void >*>(static_cast<SetActor*>(this)));
															#line 13097 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetActorState();
		static_cast<SetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1155 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<SetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetActorState(); static_cast<SetActor*>(this)->destroy(); return 0; }
															#line 13120 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<SetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetActorState();
		static_cast<SetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1155 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<SetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetActorState(); static_cast<SetActor*>(this)->destroy(); return 0; }
															#line 13132 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<SetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetActorState();
		static_cast<SetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetActor*>(this)->actor_wait_state > 0) static_cast<SetActor*>(this)->actor_wait_state = 0;
		static_cast<SetActor*>(this)->ActorCallback< SetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("set", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("set", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("set", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("set", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("set", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("set", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskFuture> taskFuture;
															#line 13221 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via set()
															#line 1146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class SetActor final : public Actor<Void>, public ActorCallback< SetActor, 0, Void >, public FastAllocated<SetActor>, public SetActorState<SetActor> {
															#line 13226 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<SetActor>::operator new;
	using FastAllocated<SetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16701868399197971712UL, 2016634857895651328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetActor, 0, Void >;
															#line 1146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	SetActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture) 
															#line 13243 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Void>(),
		   SetActorState<SetActor>(tr, taskBucket, taskFuture),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("set", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15524163840979486720UL, 4513504769136616192UL);
		ActorExecutionContextHelper __helper(static_cast<SetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("set");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("set", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Void> set( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<TaskFuture> const& taskFuture ) {
															#line 1146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Void>(new SetActor(tr, taskBucket, taskFuture));
															#line 13275 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 1157 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 13280 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via performAction()
															#line 1158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class PerformActionActor>
															#line 1158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class PerformActionActorState {
															#line 13286 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 1158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	PerformActionActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture,Reference<Task> const& task) 
															#line 1158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 1158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 1158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 1158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskFuture(taskFuture),
															#line 1158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   task(task)
															#line 13299 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("performAction", reinterpret_cast<unsigned long>(this));

	}
	~PerformActionActorState() 
	{
		fdb_probe_actor_destroy("performAction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskFuture->futureBucket->setOptions(tr);
															#line 1164 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (task && TaskFuncBase::isValidTask(task))
															#line 13316 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			{
															#line 1165 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				Reference<TaskFuncBase> taskFunc = TaskFuncBase::create(task->params[Task::reservedTaskParamKeyType]);
															#line 1166 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				if (taskFunc.getPtr())
															#line 13322 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				{
															#line 1167 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
					StrictFuture<Void> __when_expr_0 = taskFunc->finish(tr, taskBucket, taskFuture->futureBucket, task);
															#line 1167 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
					if (static_cast<PerformActionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13328 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<PerformActionActor*>(this)->actor_wait_state = 1;
															#line 1167 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PerformActionActor, 0, Void >*>(static_cast<PerformActionActor*>(this)));
															#line 13333 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PerformActionActorState();
		static_cast<PerformActionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1171 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<PerformActionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformActionActorState(); static_cast<PerformActionActor*>(this)->destroy(); return 0; }
															#line 13366 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<PerformActionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PerformActionActorState();
		static_cast<PerformActionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PerformActionActor*>(this)->actor_wait_state > 0) static_cast<PerformActionActor*>(this)->actor_wait_state = 0;
		static_cast<PerformActionActor*>(this)->ActorCallback< PerformActionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerformActionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("performAction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformActionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performAction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PerformActionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("performAction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformActionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performAction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PerformActionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("performAction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformActionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performAction", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskFuture> taskFuture;
															#line 1158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<Task> task;
															#line 13475 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via performAction()
															#line 1158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class PerformActionActor final : public Actor<Void>, public ActorCallback< PerformActionActor, 0, Void >, public FastAllocated<PerformActionActor>, public PerformActionActorState<PerformActionActor> {
															#line 13480 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<PerformActionActor>::operator new;
	using FastAllocated<PerformActionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14441316084999254784UL, 2065860010956232448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PerformActionActor, 0, Void >;
															#line 1158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	PerformActionActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture,Reference<Task> const& task) 
															#line 13497 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Void>(),
		   PerformActionActorState<PerformActionActor>(tr, taskBucket, taskFuture, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("performAction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16157570703722393856UL, 6928347023540587776UL);
		ActorExecutionContextHelper __helper(static_cast<PerformActionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("performAction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("performAction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PerformActionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Void> performAction( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<TaskFuture> const& taskFuture, Reference<Task> const& task ) {
															#line 1158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Void>(new PerformActionActor(tr, taskBucket, taskFuture, task));
															#line 13529 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 1173 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 13534 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via performAllActions()
															#line 1174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class PerformAllActionsActor>
															#line 1174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class PerformAllActionsActorState {
															#line 13540 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 1174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	PerformAllActionsActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture) 
															#line 1174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 1174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 1174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 1174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskFuture(taskFuture)
															#line 13551 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("performAllActions", reinterpret_cast<unsigned long>(this));

	}
	~PerformAllActionsActorState() 
	{
		fdb_probe_actor_destroy("performAllActions", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1177 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskFuture->futureBucket->setOptions(tr);
															#line 1179 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(taskFuture->callbacks.range(), CLIENT_KNOBS->TOO_MANY);
															#line 1179 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<PerformAllActionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13570 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PerformAllActionsActor*>(this)->actor_wait_state = 1;
															#line 1179 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PerformAllActionsActor, 0, RangeResult >*>(static_cast<PerformAllActionsActor*>(this)));
															#line 13575 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PerformAllActionsActorState();
		static_cast<PerformAllActionsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& values,int loopDepth) 
	{
															#line 1180 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr->clear(taskFuture->callbacks.range());
															#line 1182 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		std::vector<Future<Void>> actions;
															#line 1184 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (values.size() != 0)
															#line 13602 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 1185 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			task = Reference<Task>(new Task());
															#line 1186 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Key lastTaskID;
															#line 1187 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			for( auto& s : values ) {
															#line 1188 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				Tuple t = taskFuture->callbacks.unpack(s.key);
															#line 1189 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				Key taskID = t.getString(0);
															#line 1190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				Key key = t.getString(1);
															#line 1193 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				if (taskID.size() != 0 && taskID != lastTaskID)
															#line 13618 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				{
															#line 1194 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
					actions.push_back(performAction(tr, taskBucket, taskFuture, task));
															#line 1195 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
					task = makeReference<Task>();
															#line 13624 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				}
															#line 1197 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				task->params[key] = s.value;
															#line 1198 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				lastTaskID = taskID;
															#line 13630 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
															#line 1201 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			actions.push_back(performAction(tr, taskBucket, taskFuture, task));
															#line 13634 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 1204 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(actions);
															#line 1204 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<PerformAllActionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13640 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PerformAllActionsActor*>(this)->actor_wait_state = 2;
															#line 1204 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PerformAllActionsActor, 1, Void >*>(static_cast<PerformAllActionsActor*>(this)));
															#line 13645 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && values,int loopDepth) 
	{
															#line 1180 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		tr->clear(taskFuture->callbacks.range());
															#line 1182 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		std::vector<Future<Void>> actions;
															#line 1184 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (values.size() != 0)
															#line 13658 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 1185 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			task = Reference<Task>(new Task());
															#line 1186 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			Key lastTaskID;
															#line 1187 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			for( auto& s : values ) {
															#line 1188 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				Tuple t = taskFuture->callbacks.unpack(s.key);
															#line 1189 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				Key taskID = t.getString(0);
															#line 1190 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				Key key = t.getString(1);
															#line 1193 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				if (taskID.size() != 0 && taskID != lastTaskID)
															#line 13674 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				{
															#line 1194 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
					actions.push_back(performAction(tr, taskBucket, taskFuture, task));
															#line 1195 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
					task = makeReference<Task>();
															#line 13680 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
				}
															#line 1197 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				task->params[key] = s.value;
															#line 1198 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
				lastTaskID = taskID;
															#line 13686 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			}
															#line 1201 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			actions.push_back(performAction(tr, taskBucket, taskFuture, task));
															#line 13690 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 1204 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(actions);
															#line 1204 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<PerformAllActionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13696 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PerformAllActionsActor*>(this)->actor_wait_state = 2;
															#line 1204 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PerformAllActionsActor, 1, Void >*>(static_cast<PerformAllActionsActor*>(this)));
															#line 13701 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& values,int loopDepth) 
	{
		loopDepth = a_body1cont1(values, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && values,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(values), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PerformAllActionsActor*>(this)->actor_wait_state > 0) static_cast<PerformAllActionsActor*>(this)->actor_wait_state = 0;
		static_cast<PerformAllActionsActor*>(this)->ActorCallback< PerformAllActionsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< PerformAllActionsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("performAllActions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformAllActionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performAllActions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PerformAllActionsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("performAllActions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformAllActionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performAllActions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PerformAllActionsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("performAllActions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformAllActionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performAllActions", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1206 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<PerformAllActionsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformAllActionsActorState(); static_cast<PerformAllActionsActor*>(this)->destroy(); return 0; }
															#line 13785 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<PerformAllActionsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PerformAllActionsActorState();
		static_cast<PerformAllActionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1206 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<PerformAllActionsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerformAllActionsActorState(); static_cast<PerformAllActionsActor*>(this)->destroy(); return 0; }
															#line 13797 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<PerformAllActionsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PerformAllActionsActorState();
		static_cast<PerformAllActionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PerformAllActionsActor*>(this)->actor_wait_state > 0) static_cast<PerformAllActionsActor*>(this)->actor_wait_state = 0;
		static_cast<PerformAllActionsActor*>(this)->ActorCallback< PerformAllActionsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerformAllActionsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("performAllActions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformAllActionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performAllActions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PerformAllActionsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("performAllActions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerformAllActionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performAllActions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PerformAllActionsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("performAllActions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerformAllActionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("performAllActions", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskFuture> taskFuture;
															#line 1185 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<Task> task;
															#line 13888 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via performAllActions()
															#line 1174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class PerformAllActionsActor final : public Actor<Void>, public ActorCallback< PerformAllActionsActor, 0, RangeResult >, public ActorCallback< PerformAllActionsActor, 1, Void >, public FastAllocated<PerformAllActionsActor>, public PerformAllActionsActorState<PerformAllActionsActor> {
															#line 13893 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<PerformAllActionsActor>::operator new;
	using FastAllocated<PerformAllActionsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1985159879493020928UL, 17594834907379759104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PerformAllActionsActor, 0, RangeResult >;
friend struct ActorCallback< PerformAllActionsActor, 1, Void >;
															#line 1174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	PerformAllActionsActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture) 
															#line 13911 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Void>(),
		   PerformAllActionsActorState<PerformAllActionsActor>(tr, taskBucket, taskFuture),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("performAllActions", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12038994607149901568UL, 2700934096128541952UL);
		ActorExecutionContextHelper __helper(static_cast<PerformAllActionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("performAllActions");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("performAllActions", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PerformAllActionsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PerformAllActionsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Void> performAllActions( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<TaskFuture> const& taskFuture ) {
															#line 1174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Void>(new PerformAllActionsActor(tr, taskBucket, taskFuture));
															#line 13944 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 1208 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 13949 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via onSetAddTask()
															#line 1209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class OnSetAddTaskActor>
															#line 1209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class OnSetAddTaskActorState {
															#line 13955 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 1209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	OnSetAddTaskActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture,Reference<Task> const& task) 
															#line 1209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 1209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 1209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 1209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskFuture(taskFuture),
															#line 1209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   task(task)
															#line 13968 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("onSetAddTask", reinterpret_cast<unsigned long>(this));

	}
	~OnSetAddTaskActorState() 
	{
		fdb_probe_actor_destroy("onSetAddTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1213 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskFuture->futureBucket->setOptions(tr);
															#line 1215 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			task->params[Task::reservedTaskParamKeyAddTask] = task->params[Task::reservedTaskParamKeyType];
															#line 1216 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			task->params[Task::reservedTaskParamKeyType] = "AddTask"_sr;
															#line 1217 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_0 = onSet(tr, taskBucket, taskFuture, task);
															#line 1217 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<OnSetAddTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13991 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<OnSetAddTaskActor*>(this)->actor_wait_state = 1;
															#line 1217 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OnSetAddTaskActor, 0, Void >*>(static_cast<OnSetAddTaskActor*>(this)));
															#line 13996 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OnSetAddTaskActorState();
		static_cast<OnSetAddTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1219 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<OnSetAddTaskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnSetAddTaskActorState(); static_cast<OnSetAddTaskActor*>(this)->destroy(); return 0; }
															#line 14019 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<OnSetAddTaskActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OnSetAddTaskActorState();
		static_cast<OnSetAddTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1219 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<OnSetAddTaskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnSetAddTaskActorState(); static_cast<OnSetAddTaskActor*>(this)->destroy(); return 0; }
															#line 14031 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<OnSetAddTaskActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OnSetAddTaskActorState();
		static_cast<OnSetAddTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OnSetAddTaskActor*>(this)->actor_wait_state > 0) static_cast<OnSetAddTaskActor*>(this)->actor_wait_state = 0;
		static_cast<OnSetAddTaskActor*>(this)->ActorCallback< OnSetAddTaskActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OnSetAddTaskActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("onSetAddTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetAddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onSetAddTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OnSetAddTaskActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("onSetAddTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetAddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onSetAddTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OnSetAddTaskActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("onSetAddTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetAddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onSetAddTask", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskFuture> taskFuture;
															#line 1209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<Task> task;
															#line 14122 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via onSetAddTask()
															#line 1209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class OnSetAddTaskActor final : public Actor<Void>, public ActorCallback< OnSetAddTaskActor, 0, Void >, public FastAllocated<OnSetAddTaskActor>, public OnSetAddTaskActorState<OnSetAddTaskActor> {
															#line 14127 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<OnSetAddTaskActor>::operator new;
	using FastAllocated<OnSetAddTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12913502899165357312UL, 18200749982557482752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OnSetAddTaskActor, 0, Void >;
															#line 1209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	OnSetAddTaskActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture,Reference<Task> const& task) 
															#line 14144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Void>(),
		   OnSetAddTaskActorState<OnSetAddTaskActor>(tr, taskBucket, taskFuture, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("onSetAddTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7619827275012075776UL, 4849640377091596544UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetAddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("onSetAddTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("onSetAddTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OnSetAddTaskActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Void> onSetAddTask( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<TaskFuture> const& taskFuture, Reference<Task> const& task ) {
															#line 1209 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Void>(new OnSetAddTaskActor(tr, taskBucket, taskFuture, task));
															#line 14176 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 1221 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

																#line 14181 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via onSetAddTask()
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class OnSetAddTaskActor1>
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class OnSetAddTaskActor1State {
															#line 14187 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	OnSetAddTaskActor1State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture,Reference<Task> const& task,KeyRef const& validationKey) 
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskFuture(taskFuture),
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   task(task),
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   validationKey(validationKey)
															#line 14202 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("onSetAddTask", reinterpret_cast<unsigned long>(this));

	}
	~OnSetAddTaskActor1State() 
	{
		fdb_probe_actor_destroy("onSetAddTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1227 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskFuture->futureBucket->setOptions(tr);
															#line 1229 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(validationKey);
															#line 1229 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<OnSetAddTaskActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14221 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<OnSetAddTaskActor1*>(this)->actor_wait_state = 1;
															#line 1229 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OnSetAddTaskActor1, 0, Optional<Value> >*>(static_cast<OnSetAddTaskActor1*>(this)));
															#line 14226 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OnSetAddTaskActor1State();
		static_cast<OnSetAddTaskActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& validationValue,int loopDepth) 
	{
															#line 1231 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!validationValue.present())
															#line 14249 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 1232 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			TraceEvent(SevError, "TaskBucketOnSetAddTaskInvalidKey") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("ValidationKey", validationKey);
															#line 1235 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			return a_body1Catch1(invalid_option_value(), loopDepth);
															#line 14255 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 1238 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		task->params[Task::reservedTaskParamValidKey] = validationKey;
															#line 1239 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		task->params[Task::reservedTaskParamValidValue] = validationValue.get();
															#line 1241 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_1 = onSetAddTask(tr, taskBucket, taskFuture, task);
															#line 1241 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<OnSetAddTaskActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14265 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OnSetAddTaskActor1*>(this)->actor_wait_state = 2;
															#line 1241 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OnSetAddTaskActor1, 1, Void >*>(static_cast<OnSetAddTaskActor1*>(this)));
															#line 14270 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && validationValue,int loopDepth) 
	{
															#line 1231 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!validationValue.present())
															#line 14279 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		{
															#line 1232 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			TraceEvent(SevError, "TaskBucketOnSetAddTaskInvalidKey") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("ValidationKey", validationKey);
															#line 1235 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			return a_body1Catch1(invalid_option_value(), loopDepth);
															#line 14285 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		}
															#line 1238 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		task->params[Task::reservedTaskParamValidKey] = validationKey;
															#line 1239 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		task->params[Task::reservedTaskParamValidValue] = validationValue.get();
															#line 1241 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		StrictFuture<Void> __when_expr_1 = onSetAddTask(tr, taskBucket, taskFuture, task);
															#line 1241 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (static_cast<OnSetAddTaskActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14295 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OnSetAddTaskActor1*>(this)->actor_wait_state = 2;
															#line 1241 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OnSetAddTaskActor1, 1, Void >*>(static_cast<OnSetAddTaskActor1*>(this)));
															#line 14300 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& validationValue,int loopDepth) 
	{
		loopDepth = a_body1cont1(validationValue, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && validationValue,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(validationValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OnSetAddTaskActor1*>(this)->actor_wait_state > 0) static_cast<OnSetAddTaskActor1*>(this)->actor_wait_state = 0;
		static_cast<OnSetAddTaskActor1*>(this)->ActorCallback< OnSetAddTaskActor1, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< OnSetAddTaskActor1, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("onSetAddTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetAddTaskActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onSetAddTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OnSetAddTaskActor1, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("onSetAddTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetAddTaskActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onSetAddTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OnSetAddTaskActor1, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("onSetAddTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetAddTaskActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onSetAddTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1243 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<OnSetAddTaskActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnSetAddTaskActor1State(); static_cast<OnSetAddTaskActor1*>(this)->destroy(); return 0; }
															#line 14384 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<OnSetAddTaskActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~OnSetAddTaskActor1State();
		static_cast<OnSetAddTaskActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1243 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<OnSetAddTaskActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnSetAddTaskActor1State(); static_cast<OnSetAddTaskActor1*>(this)->destroy(); return 0; }
															#line 14396 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<OnSetAddTaskActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~OnSetAddTaskActor1State();
		static_cast<OnSetAddTaskActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OnSetAddTaskActor1*>(this)->actor_wait_state > 0) static_cast<OnSetAddTaskActor1*>(this)->actor_wait_state = 0;
		static_cast<OnSetAddTaskActor1*>(this)->ActorCallback< OnSetAddTaskActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OnSetAddTaskActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("onSetAddTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetAddTaskActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onSetAddTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OnSetAddTaskActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("onSetAddTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetAddTaskActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onSetAddTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OnSetAddTaskActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("onSetAddTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetAddTaskActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onSetAddTask", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskFuture> taskFuture;
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<Task> task;
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	KeyRef validationKey;
															#line 14489 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via onSetAddTask()
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class OnSetAddTaskActor1 final : public Actor<Void>, public ActorCallback< OnSetAddTaskActor1, 0, Optional<Value> >, public ActorCallback< OnSetAddTaskActor1, 1, Void >, public FastAllocated<OnSetAddTaskActor1>, public OnSetAddTaskActor1State<OnSetAddTaskActor1> {
															#line 14494 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<OnSetAddTaskActor1>::operator new;
	using FastAllocated<OnSetAddTaskActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12913502899165357312UL, 18200749982557482752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OnSetAddTaskActor1, 0, Optional<Value> >;
friend struct ActorCallback< OnSetAddTaskActor1, 1, Void >;
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	OnSetAddTaskActor1(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture,Reference<Task> const& task,KeyRef const& validationKey) 
															#line 14512 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Void>(),
		   OnSetAddTaskActor1State<OnSetAddTaskActor1>(tr, taskBucket, taskFuture, task, validationKey),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("onSetAddTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7108718095172596736UL, 14088274314153843968UL);
		ActorExecutionContextHelper __helper(static_cast<OnSetAddTaskActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("onSetAddTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("onSetAddTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OnSetAddTaskActor1, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OnSetAddTaskActor1, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Void> onSetAddTask( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<TaskFuture> const& taskFuture, Reference<Task> const& task, KeyRef const& validationKey ) {
															#line 1222 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Void>(new OnSetAddTaskActor1(tr, taskBucket, taskFuture, task, validationKey));
															#line 14545 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 1245 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

	static Future<Void> onSetAddTask(Reference<ReadYourWritesTransaction> tr,
	                                 Reference<TaskBucket> taskBucket,
	                                 Reference<TaskFuture> taskFuture,
	                                 Reference<Task> task,
	                                 KeyRef validationKey,
	                                 KeyRef validationValue) {
		taskFuture->futureBucket->setOptions(tr);

		task->params[Task::reservedTaskParamValidKey] = validationKey;
		task->params[Task::reservedTaskParamValidValue] = validationValue;

		return onSetAddTask(tr, taskBucket, taskFuture, task);
	}

																#line 14564 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
// This generated class is to be used only via joinedFuture()
															#line 1260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class JoinedFutureActor>
															#line 1260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class JoinedFutureActorState {
															#line 14570 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 1260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	JoinedFutureActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture) 
															#line 1260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 1260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : tr(tr),
															#line 1260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskBucket(taskBucket),
															#line 1260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   taskFuture(taskFuture)
															#line 14581 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("joinedFuture", reinterpret_cast<unsigned long>(this));

	}
	~JoinedFutureActorState() 
	{
		fdb_probe_actor_destroy("joinedFuture", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1263 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			taskFuture->futureBucket->setOptions(tr);
															#line 1265 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			std::vector<Reference<TaskFuture>> vectorFuture;
															#line 1268 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			future = taskFuture->futureBucket->future(tr);
															#line 1269 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			vectorFuture.push_back(future);
															#line 1270 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Void> __when_expr_0 = join(tr, taskBucket, taskFuture, vectorFuture);
															#line 1270 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<JoinedFutureActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14606 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<JoinedFutureActor*>(this)->actor_wait_state = 1;
															#line 1270 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< JoinedFutureActor, 0, Void >*>(static_cast<JoinedFutureActor*>(this)));
															#line 14611 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~JoinedFutureActorState();
		static_cast<JoinedFutureActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1271 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<JoinedFutureActor*>(this)->SAV<Reference<TaskFuture>>::futures) { (void)(future); this->~JoinedFutureActorState(); static_cast<JoinedFutureActor*>(this)->destroy(); return 0; }
															#line 14634 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<JoinedFutureActor*>(this)->SAV< Reference<TaskFuture> >::value()) Reference<TaskFuture>(std::move(future)); // state_var_RVO
		this->~JoinedFutureActorState();
		static_cast<JoinedFutureActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1271 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<JoinedFutureActor*>(this)->SAV<Reference<TaskFuture>>::futures) { (void)(future); this->~JoinedFutureActorState(); static_cast<JoinedFutureActor*>(this)->destroy(); return 0; }
															#line 14646 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<JoinedFutureActor*>(this)->SAV< Reference<TaskFuture> >::value()) Reference<TaskFuture>(std::move(future)); // state_var_RVO
		this->~JoinedFutureActorState();
		static_cast<JoinedFutureActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<JoinedFutureActor*>(this)->actor_wait_state > 0) static_cast<JoinedFutureActor*>(this)->actor_wait_state = 0;
		static_cast<JoinedFutureActor*>(this)->ActorCallback< JoinedFutureActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< JoinedFutureActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("joinedFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<JoinedFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinedFuture", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< JoinedFutureActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("joinedFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<JoinedFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinedFuture", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< JoinedFutureActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("joinedFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<JoinedFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinedFuture", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskFuture> taskFuture;
															#line 1268 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Reference<TaskFuture> future;
															#line 14737 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via joinedFuture()
															#line 1260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class JoinedFutureActor final : public Actor<Reference<TaskFuture>>, public ActorCallback< JoinedFutureActor, 0, Void >, public FastAllocated<JoinedFutureActor>, public JoinedFutureActorState<JoinedFutureActor> {
															#line 14742 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<JoinedFutureActor>::operator new;
	using FastAllocated<JoinedFutureActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11097964926089978880UL, 13906264036707535104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<TaskFuture>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< JoinedFutureActor, 0, Void >;
															#line 1260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	JoinedFutureActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<TaskFuture> const& taskFuture) 
															#line 14759 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Reference<TaskFuture>>(),
		   JoinedFutureActorState<JoinedFutureActor>(tr, taskBucket, taskFuture),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("joinedFuture", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1188135014063187200UL, 16369056345392732160UL);
		ActorExecutionContextHelper __helper(static_cast<JoinedFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("joinedFuture");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("joinedFuture", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< JoinedFutureActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] static Future<Reference<TaskFuture>> joinedFuture( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<TaskFuture> const& taskFuture ) {
															#line 1260 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Reference<TaskFuture>>(new JoinedFutureActor(tr, taskBucket, taskFuture));
															#line 14791 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 1273 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
};

TaskFuture::TaskFuture() {}

TaskFuture::TaskFuture(const Reference<FutureBucket> bucket, Key k) : futureBucket(bucket), key(k) {
	if (k.size() == 0) {
		key = deterministicRandom()->randomUniqueID().toString();
	}

	prefix = futureBucket->prefix.get(key); // this ::get actually append the key to the taskBucket prefix
	blocks = prefix.get("bl"_sr);
	callbacks = prefix.get("cb"_sr);
}

TaskFuture::~TaskFuture() {}

void TaskFuture::addBlock(Reference<ReadYourWritesTransaction> tr, StringRef block_id) {
	tr->set(blocks.pack(block_id), ""_sr);
}

Future<Void> TaskFuture::set(Reference<ReadYourWritesTransaction> tr, Reference<TaskBucket> taskBucket) {
	return TaskFutureImpl::set(tr, taskBucket, Reference<TaskFuture>::addRef(this));
}

Future<Void> TaskFuture::performAllActions(Reference<ReadYourWritesTransaction> tr, Reference<TaskBucket> taskBucket) {
	return TaskFutureImpl::performAllActions(tr, taskBucket, Reference<TaskFuture>::addRef(this));
}

Future<Void> TaskFuture::join(Reference<ReadYourWritesTransaction> tr,
                              Reference<TaskBucket> taskBucket,
                              std::vector<Reference<TaskFuture>> vectorFuture) {
	return TaskFutureImpl::join(tr, taskBucket, Reference<TaskFuture>::addRef(this), vectorFuture);
}

Future<bool> TaskFuture::isSet(Reference<ReadYourWritesTransaction> tr) {
	return TaskFutureImpl::isSet(tr, Reference<TaskFuture>::addRef(this));
}

Future<Void> TaskFuture::onSet(Reference<ReadYourWritesTransaction> tr,
                               Reference<TaskBucket> taskBucket,
                               Reference<Task> task) {
	return TaskFutureImpl::onSet(tr, taskBucket, Reference<TaskFuture>::addRef(this), task);
}

Future<Void> TaskFuture::onSetAddTask(Reference<ReadYourWritesTransaction> tr,
                                      Reference<TaskBucket> taskBucket,
                                      Reference<Task> task) {
	return TaskFutureImpl::onSetAddTask(tr, taskBucket, Reference<TaskFuture>::addRef(this), task);
}

Future<Void> TaskFuture::onSetAddTask(Reference<ReadYourWritesTransaction> tr,
                                      Reference<TaskBucket> taskBucket,
                                      Reference<Task> task,
                                      KeyRef validationKey) {
	return TaskFutureImpl::onSetAddTask(tr, taskBucket, Reference<TaskFuture>::addRef(this), task, validationKey);
}

Future<Void> TaskFuture::onSetAddTask(Reference<ReadYourWritesTransaction> tr,
                                      Reference<TaskBucket> taskBucket,
                                      Reference<Task> task,
                                      KeyRef validationKey,
                                      KeyRef validationValue) {
	return TaskFutureImpl::onSetAddTask(
	    tr, taskBucket, Reference<TaskFuture>::addRef(this), task, validationKey, validationValue);
}

Future<Reference<TaskFuture>> TaskFuture::joinedFuture(Reference<ReadYourWritesTransaction> tr,
                                                       Reference<TaskBucket> taskBucket) {
	return TaskFutureImpl::joinedFuture(tr, taskBucket, Reference<TaskFuture>::addRef(this));
}

															#line 14866 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
namespace {
// This generated class is to be used only via getCompletionKey()
															#line 1344 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
template <class GetCompletionKeyActor>
															#line 1344 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class GetCompletionKeyActorState {
															#line 14873 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
															#line 1344 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	GetCompletionKeyActorState(TaskCompletionKey* const& self,Future<Reference<TaskFuture>> const& f) 
															#line 1344 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
															#line 1344 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		 : self(self),
															#line 1344 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		   f(f)
															#line 14882 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
	{
		fdb_probe_actor_create("getCompletionKey", reinterpret_cast<unsigned long>(this));

	}
	~GetCompletionKeyActorState() 
	{
		fdb_probe_actor_destroy("getCompletionKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1345 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			StrictFuture<Reference<TaskFuture>> __when_expr_0 = f;
															#line 1345 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			if (static_cast<GetCompletionKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14899 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetCompletionKeyActor*>(this)->actor_wait_state = 1;
															#line 1345 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCompletionKeyActor, 0, Reference<TaskFuture> >*>(static_cast<GetCompletionKeyActor*>(this)));
															#line 14904 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCompletionKeyActorState();
		static_cast<GetCompletionKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<TaskFuture> const& taskFuture,int loopDepth) 
	{
															#line 1346 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		self->joinFuture.clear();
															#line 1347 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		self->key = taskFuture->key;
															#line 1348 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<GetCompletionKeyActor*>(this)->SAV<Key>::futures) { (void)(self->key.get()); this->~GetCompletionKeyActorState(); static_cast<GetCompletionKeyActor*>(this)->destroy(); return 0; }
															#line 14931 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<GetCompletionKeyActor*>(this)->SAV< Key >::value()) Key(self->key.get());
		this->~GetCompletionKeyActorState();
		static_cast<GetCompletionKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<TaskFuture> && taskFuture,int loopDepth) 
	{
															#line 1346 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		self->joinFuture.clear();
															#line 1347 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		self->key = taskFuture->key;
															#line 1348 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
		if (!static_cast<GetCompletionKeyActor*>(this)->SAV<Key>::futures) { (void)(self->key.get()); this->~GetCompletionKeyActorState(); static_cast<GetCompletionKeyActor*>(this)->destroy(); return 0; }
															#line 14947 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		new (&static_cast<GetCompletionKeyActor*>(this)->SAV< Key >::value()) Key(self->key.get());
		this->~GetCompletionKeyActorState();
		static_cast<GetCompletionKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Reference<TaskFuture> const& taskFuture,int loopDepth) 
	{
		loopDepth = a_body1cont1(taskFuture, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<TaskFuture> && taskFuture,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(taskFuture), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCompletionKeyActor*>(this)->actor_wait_state > 0) static_cast<GetCompletionKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetCompletionKeyActor*>(this)->ActorCallback< GetCompletionKeyActor, 0, Reference<TaskFuture> >::remove();

	}
	void a_callback_fire(ActorCallback< GetCompletionKeyActor, 0, Reference<TaskFuture> >*,Reference<TaskFuture> const& value) 
	{
		fdb_probe_actor_enter("getCompletionKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCompletionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCompletionKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCompletionKeyActor, 0, Reference<TaskFuture> >*,Reference<TaskFuture> && value) 
	{
		fdb_probe_actor_enter("getCompletionKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCompletionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCompletionKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCompletionKeyActor, 0, Reference<TaskFuture> >*,Error err) 
	{
		fdb_probe_actor_enter("getCompletionKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCompletionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCompletionKey", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1344 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	TaskCompletionKey* self;
															#line 1344 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	Future<Reference<TaskFuture>> f;
															#line 15034 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
};
// This generated class is to be used only via getCompletionKey()
															#line 1344 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
class GetCompletionKeyActor final : public Actor<Key>, public ActorCallback< GetCompletionKeyActor, 0, Reference<TaskFuture> >, public FastAllocated<GetCompletionKeyActor>, public GetCompletionKeyActorState<GetCompletionKeyActor> {
															#line 15039 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
public:
	using FastAllocated<GetCompletionKeyActor>::operator new;
	using FastAllocated<GetCompletionKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(424618892459389440UL, 11850213560988487424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCompletionKeyActor, 0, Reference<TaskFuture> >;
															#line 1344 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	GetCompletionKeyActor(TaskCompletionKey* const& self,Future<Reference<TaskFuture>> const& f) 
															#line 15056 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
		 : Actor<Key>(),
		   GetCompletionKeyActorState<GetCompletionKeyActor>(self, f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCompletionKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10775375017495295744UL, 14119464340389498624UL);
		ActorExecutionContextHelper __helper(static_cast<GetCompletionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCompletionKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCompletionKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCompletionKeyActor, 0, Reference<TaskFuture> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1344 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
[[nodiscard]] Future<Key> getCompletionKey( TaskCompletionKey* const& self, Future<Reference<TaskFuture>> const& f ) {
															#line 1344 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"
	return Future<Key>(new GetCompletionKeyActor(self, f));
															#line 15089 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/TaskBucket.actor.g.cpp"
}

#line 1350 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/TaskBucket.actor.cpp"

Future<Key> TaskCompletionKey::get(Reference<ReadYourWritesTransaction> tr, Reference<TaskBucket> taskBucket) {
	ASSERT(key.present() == (joinFuture.getPtr() == nullptr));
	// from the parent bucket, it generate a new taskfuture and returns the key of the new taskfuture
	return key.present() ? key.get() : getCompletionKey(this, joinFuture->joinedFuture(tr, taskBucket));
}
