#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
/*
 * MutationLogReader.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/MutationLogReader.actor.h"
#include "fdbrpc/simulator.h"
#include "flow/UnitTest.h"
#include "flow/flow.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

Key versionToKey(Version version, Key prefix) {
	uint64_t versionBigEndian = bigEndian64(version);
	return KeyRef((uint8_t*)&versionBigEndian, sizeof(uint64_t)).withPrefix(prefix);
}

Version keyRefToVersion(KeyRef key, int prefixLen) {
	return (Version)bigEndian64(*((uint64_t*)key.substr(prefixLen).begin()));
}

} // namespace

namespace mutation_log_reader {

Standalone<RangeResultRef> RangeResultBlock::consume() {
	Version stopVersion = std::min(lastVersion,
	                               (firstVersion + CLIENT_KNOBS->LOG_RANGE_BLOCK_SIZE - 1) /
	                                   CLIENT_KNOBS->LOG_RANGE_BLOCK_SIZE * CLIENT_KNOBS->LOG_RANGE_BLOCK_SIZE) +
	                      1; // firstVersion rounded up to the nearest 1M versions, then + 1
	int startIndex = indexToRead;
	while (indexToRead < result.size() && keyRefToVersion(result[indexToRead].key, prefixLen) < stopVersion) {
		++indexToRead;
	}
	if (indexToRead < result.size()) {
		firstVersion = keyRefToVersion(result[indexToRead].key, prefixLen); // the version of result[indexToRead]
	}
	return Standalone<RangeResultRef>(
	    RangeResultRef(result.slice(startIndex, indexToRead), result.more, result.readThrough), result.arena());
}

void PipelinedReader::startReading(Database cx) {
	reader = getNext(cx);
}

Future<Void> PipelinedReader::getNext(Database cx) {
	return getNext_impl(this, cx);
}

															#line 68 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
// This generated class is to be used only via getNext_impl()
															#line 66 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
template <class PipelinedReader_GetNext_implActor>
															#line 66 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
class PipelinedReader_GetNext_implActorState {
															#line 74 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
public:
															#line 66 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	PipelinedReader_GetNext_implActorState(PipelinedReader* const& self,Database const& cx) 
															#line 66 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
															#line 66 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		 : self(self),
															#line 66 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		   cx(cx),
															#line 67 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		   tr(cx),
															#line 69 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		   limits(GetRangeLimits::ROW_LIMIT_UNLIMITED, (g_network->isSimulated() && !g_simulator->speedUpSimulation) ? CLIENT_KNOBS->BACKUP_SIMULATED_LIMIT_BYTES : CLIENT_KNOBS->BACKUP_GET_RANGE_LIMIT_BYTES),
															#line 74 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		   begin(versionToKey(self->currentBeginVersion, self->prefix)),
															#line 75 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		   end(versionToKey(self->endVersion, self->prefix))
															#line 91 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
	{
		fdb_probe_actor_create("getNext_impl", reinterpret_cast<unsigned long>(this));

	}
	~PipelinedReader_GetNext_implActorState() 
	{
		fdb_probe_actor_destroy("getNext_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 77 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			;
															#line 106 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PipelinedReader_GetNext_implActorState();
		static_cast<PipelinedReader_GetNext_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 79 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->readerLimit.take();
															#line 79 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		if (static_cast<PipelinedReader_GetNext_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 138 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<PipelinedReader_GetNext_implActor*>(this)->actor_wait_state = 1;
															#line 79 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PipelinedReader_GetNext_implActor, 0, Void >*>(static_cast<PipelinedReader_GetNext_implActor*>(this)));
															#line 143 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 82 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		;
															#line 152 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 82 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		;
															#line 161 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PipelinedReader_GetNext_implActor*>(this)->actor_wait_state > 0) static_cast<PipelinedReader_GetNext_implActor*>(this)->actor_wait_state = 0;
		static_cast<PipelinedReader_GetNext_implActor*>(this)->ActorCallback< PipelinedReader_GetNext_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PipelinedReader_GetNext_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PipelinedReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PipelinedReader_GetNext_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PipelinedReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PipelinedReader_GetNext_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PipelinedReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 84 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 85 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 87 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			StrictFuture<RangeResult> __when_expr_1 = tr.getRange(KeyRangeRef(begin, end), limits);
															#line 87 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			if (static_cast<PipelinedReader_GetNext_implActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 265 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PipelinedReader_GetNext_implActor*>(this)->actor_wait_state = 2;
															#line 87 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PipelinedReader_GetNext_implActor, 1, RangeResult >*>(static_cast<PipelinedReader_GetNext_implActor*>(this)));
															#line 270 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 110 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			if (e.code() == error_code_transaction_too_old)
															#line 305 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			{
															#line 113 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
				tr.fullReset();
															#line 309 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
				loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(loopDepth);
			}
			else
			{
															#line 115 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
				StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 115 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
				if (static_cast<PipelinedReader_GetNext_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 318 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<PipelinedReader_GetNext_implActor*>(this)->actor_wait_state = 3;
															#line 115 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PipelinedReader_GetNext_implActor, 2, Void >*>(static_cast<PipelinedReader_GetNext_implActor*>(this)));
															#line 323 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(RangeResult const& kvs,int loopDepth) 
	{
															#line 90 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		if (!kvs.empty())
															#line 339 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		{
															#line 92 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			self->reads.send( RangeResultBlock{ .result = kvs, .firstVersion = keyRefToVersion(kvs.front().key, self->prefix.size()), .lastVersion = keyRefToVersion(kvs.back().key, self->prefix.size()), .hash = self->hash, .prefixLen = self->prefix.size(), .indexToRead = 0 });
															#line 343 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		}
															#line 101 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		if (!kvs.more)
															#line 347 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		{
															#line 102 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			self->reads.sendError(end_of_stream());
															#line 103 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			if (!static_cast<PipelinedReader_GetNext_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PipelinedReader_GetNext_implActorState(); static_cast<PipelinedReader_GetNext_implActor*>(this)->destroy(); return 0; }
															#line 353 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			new (&static_cast<PipelinedReader_GetNext_implActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~PipelinedReader_GetNext_implActorState();
			static_cast<PipelinedReader_GetNext_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 106 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		begin = kvs.getReadThrough();
															#line 361 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(RangeResult && kvs,int loopDepth) 
	{
															#line 90 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		if (!kvs.empty())
															#line 370 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		{
															#line 92 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			self->reads.send( RangeResultBlock{ .result = kvs, .firstVersion = keyRefToVersion(kvs.front().key, self->prefix.size()), .lastVersion = keyRefToVersion(kvs.back().key, self->prefix.size()), .hash = self->hash, .prefixLen = self->prefix.size(), .indexToRead = 0 });
															#line 374 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		}
															#line 101 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		if (!kvs.more)
															#line 378 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		{
															#line 102 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			self->reads.sendError(end_of_stream());
															#line 103 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			if (!static_cast<PipelinedReader_GetNext_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PipelinedReader_GetNext_implActorState(); static_cast<PipelinedReader_GetNext_implActor*>(this)->destroy(); return 0; }
															#line 384 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			new (&static_cast<PipelinedReader_GetNext_implActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~PipelinedReader_GetNext_implActorState();
			static_cast<PipelinedReader_GetNext_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 106 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		begin = kvs.getReadThrough();
															#line 392 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(RangeResult const& kvs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(kvs, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(RangeResult && kvs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(kvs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PipelinedReader_GetNext_implActor*>(this)->actor_wait_state > 0) static_cast<PipelinedReader_GetNext_implActor*>(this)->actor_wait_state = 0;
		static_cast<PipelinedReader_GetNext_implActor*>(this)->ActorCallback< PipelinedReader_GetNext_implActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< PipelinedReader_GetNext_implActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PipelinedReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PipelinedReader_GetNext_implActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PipelinedReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PipelinedReader_GetNext_implActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PipelinedReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PipelinedReader_GetNext_implActor*>(this)->actor_wait_state > 0) static_cast<PipelinedReader_GetNext_implActor*>(this)->actor_wait_state = 0;
		static_cast<PipelinedReader_GetNext_implActor*>(this)->ActorCallback< PipelinedReader_GetNext_implActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PipelinedReader_GetNext_implActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PipelinedReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PipelinedReader_GetNext_implActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PipelinedReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PipelinedReader_GetNext_implActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PipelinedReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 66 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	PipelinedReader* self;
															#line 66 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	Database cx;
															#line 67 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	Transaction tr;
															#line 69 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	GetRangeLimits limits;
															#line 74 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	Key begin;
															#line 75 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	Key end;
															#line 577 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
};
// This generated class is to be used only via getNext_impl()
															#line 66 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
class PipelinedReader_GetNext_implActor final : public Actor<Void>, public ActorCallback< PipelinedReader_GetNext_implActor, 0, Void >, public ActorCallback< PipelinedReader_GetNext_implActor, 1, RangeResult >, public ActorCallback< PipelinedReader_GetNext_implActor, 2, Void >, public FastAllocated<PipelinedReader_GetNext_implActor>, public PipelinedReader_GetNext_implActorState<PipelinedReader_GetNext_implActor> {
															#line 582 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
public:
	using FastAllocated<PipelinedReader_GetNext_implActor>::operator new;
	using FastAllocated<PipelinedReader_GetNext_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7982789697924186368UL, 3081553343312943872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PipelinedReader_GetNext_implActor, 0, Void >;
friend struct ActorCallback< PipelinedReader_GetNext_implActor, 1, RangeResult >;
friend struct ActorCallback< PipelinedReader_GetNext_implActor, 2, Void >;
															#line 66 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	PipelinedReader_GetNext_implActor(PipelinedReader* const& self,Database const& cx) 
															#line 601 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		 : Actor<Void>(),
		   PipelinedReader_GetNext_implActorState<PipelinedReader_GetNext_implActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11552556734654584576UL, 18375386782379832064UL);
		ActorExecutionContextHelper __helper(static_cast<PipelinedReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNext_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PipelinedReader_GetNext_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PipelinedReader_GetNext_implActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PipelinedReader_GetNext_implActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 66 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
[[nodiscard]] Future<Void> PipelinedReader::getNext_impl( PipelinedReader* const& self, Database const& cx ) {
															#line 66 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	return Future<Void>(new PipelinedReader_GetNext_implActor(self, cx));
															#line 635 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
}

#line 121 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"

} // namespace mutation_log_reader

															#line 642 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
// This generated class is to be used only via initializePQ()
															#line 124 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
template <class MutationLogReader_InitializePQActor>
															#line 124 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
class MutationLogReader_InitializePQActorState {
															#line 648 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
public:
															#line 124 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	MutationLogReader_InitializePQActorState(MutationLogReader* const& self) 
															#line 124 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
															#line 124 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		 : self(self),
															#line 125 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		   h()
															#line 657 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
	{
		fdb_probe_actor_create("initializePQ", reinterpret_cast<unsigned long>(this));

	}
	~MutationLogReader_InitializePQActorState() 
	{
		fdb_probe_actor_destroy("initializePQ", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 126 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			h = 0;
															#line 672 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MutationLogReader_InitializePQActorState();
		static_cast<MutationLogReader_InitializePQActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 137 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		if (!static_cast<MutationLogReader_InitializePQActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MutationLogReader_InitializePQActorState(); static_cast<MutationLogReader_InitializePQActor*>(this)->destroy(); return 0; }
															#line 695 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		new (&static_cast<MutationLogReader_InitializePQActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MutationLogReader_InitializePQActorState();
		static_cast<MutationLogReader_InitializePQActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 126 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		if (!(h < 256))
															#line 714 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 128 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			auto __when_expr_0 = self->pipelinedReaders[h]->reads.getFuture();
															#line 721 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<mutation_log_reader::RangeResultBlock>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<mutation_log_reader::RangeResultBlock>>::value, "invalid type");
															#line 128 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			if (static_cast<MutationLogReader_InitializePQActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 725 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<MutationLogReader_InitializePQActor*>(this)->actor_wait_state = 1;
															#line 128 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< MutationLogReader_InitializePQActor, 0, mutation_log_reader::RangeResultBlock >*>(static_cast<MutationLogReader_InitializePQActor*>(this)));
															#line 730 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 126 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		++h;
															#line 758 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 131 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			if (e.code() != error_code_end_of_stream)
															#line 768 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			{
															#line 132 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 772 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			}
															#line 134 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			++self->finished;
															#line 776 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(mutation_log_reader::RangeResultBlock const& front,int loopDepth) 
	{
															#line 129 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		self->priorityQueue.push(front);
															#line 791 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(mutation_log_reader::RangeResultBlock && front,int loopDepth) 
	{
															#line 129 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		self->priorityQueue.push(front);
															#line 800 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(mutation_log_reader::RangeResultBlock const& front,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(front, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(mutation_log_reader::RangeResultBlock && front,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(front), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MutationLogReader_InitializePQActor*>(this)->actor_wait_state > 0) static_cast<MutationLogReader_InitializePQActor*>(this)->actor_wait_state = 0;
		static_cast<MutationLogReader_InitializePQActor*>(this)->ActorSingleCallback< MutationLogReader_InitializePQActor, 0, mutation_log_reader::RangeResultBlock >::remove();

	}
	void a_callback_fire(ActorSingleCallback< MutationLogReader_InitializePQActor, 0, mutation_log_reader::RangeResultBlock >*,mutation_log_reader::RangeResultBlock const& value) 
	{
		fdb_probe_actor_enter("initializePQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutationLogReader_InitializePQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializePQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< MutationLogReader_InitializePQActor, 0, mutation_log_reader::RangeResultBlock >*,mutation_log_reader::RangeResultBlock && value) 
	{
		fdb_probe_actor_enter("initializePQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutationLogReader_InitializePQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializePQ", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< MutationLogReader_InitializePQActor, 0, mutation_log_reader::RangeResultBlock >*,Error err) 
	{
		fdb_probe_actor_enter("initializePQ", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutationLogReader_InitializePQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializePQ", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 124 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	MutationLogReader* self;
															#line 125 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	int h;
															#line 897 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
};
// This generated class is to be used only via initializePQ()
															#line 124 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
class MutationLogReader_InitializePQActor final : public Actor<Void>, public ActorSingleCallback< MutationLogReader_InitializePQActor, 0, mutation_log_reader::RangeResultBlock >, public FastAllocated<MutationLogReader_InitializePQActor>, public MutationLogReader_InitializePQActorState<MutationLogReader_InitializePQActor> {
															#line 902 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
public:
	using FastAllocated<MutationLogReader_InitializePQActor>::operator new;
	using FastAllocated<MutationLogReader_InitializePQActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18240974556054506752UL, 3236775528885463040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< MutationLogReader_InitializePQActor, 0, mutation_log_reader::RangeResultBlock >;
															#line 124 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	MutationLogReader_InitializePQActor(MutationLogReader* const& self) 
															#line 919 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		 : Actor<Void>(),
		   MutationLogReader_InitializePQActorState<MutationLogReader_InitializePQActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("initializePQ", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17584193426727655680UL, 11429537674770902272UL);
		ActorExecutionContextHelper __helper(static_cast<MutationLogReader_InitializePQActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("initializePQ");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("initializePQ", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< MutationLogReader_InitializePQActor, 0, mutation_log_reader::RangeResultBlock >*)0, actor_cancelled()); break;
		}

	}
};
															#line 124 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
[[nodiscard]] Future<Void> MutationLogReader::initializePQ( MutationLogReader* const& self ) {
															#line 124 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	return Future<Void>(new MutationLogReader_InitializePQActor(self));
															#line 951 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
}

#line 139 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"

Future<Standalone<RangeResultRef>> MutationLogReader::getNext() {
	return getNext_impl(this);
}

															#line 960 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
// This generated class is to be used only via getNext_impl()
															#line 144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
template <class MutationLogReader_GetNext_implActor>
															#line 144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
class MutationLogReader_GetNext_implActorState {
															#line 966 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
public:
															#line 144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	MutationLogReader_GetNext_implActorState(MutationLogReader* const& self) 
															#line 144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
															#line 144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		 : self(self)
															#line 973 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
	{
		fdb_probe_actor_create("getNext_impl", reinterpret_cast<unsigned long>(this));

	}
	~MutationLogReader_GetNext_implActorState() 
	{
		fdb_probe_actor_destroy("getNext_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 145 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			;
															#line 988 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MutationLogReader_GetNext_implActorState();
		static_cast<MutationLogReader_GetNext_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 146 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		if (self->finished == 256)
															#line 1018 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		{
															#line 147 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			i = int();
															#line 148 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			i = 0;
															#line 1024 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 153 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		mutation_log_reader::RangeResultBlock top = self->priorityQueue.top();
															#line 154 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		self->priorityQueue.pop();
															#line 155 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		uint8_t hash = top.hash;
															#line 156 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		ret = top.consume();
															#line 157 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		if (top.empty())
															#line 1046 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		{
															#line 158 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			self->pipelinedReaders[(int)hash]->release();
															#line 1050 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			try {
															#line 160 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
				auto __when_expr_1 = self->pipelinedReaders[(int)hash]->reads.getFuture();
															#line 1054 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
				static_assert(std::is_same<decltype(__when_expr_1), FutureStream<mutation_log_reader::RangeResultBlock>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<mutation_log_reader::RangeResultBlock>>::value, "invalid type");
															#line 160 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
				if (static_cast<MutationLogReader_GetNext_implActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1058 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.pop(), loopDepth); };
				static_cast<MutationLogReader_GetNext_implActor*>(this)->actor_wait_state = 2;
															#line 160 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< MutationLogReader_GetNext_implActor, 1, mutation_log_reader::RangeResultBlock >*>(static_cast<MutationLogReader_GetNext_implActor*>(this)));
															#line 1063 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
															#line 171 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			self->priorityQueue.push(top);
															#line 1076 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 151 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		return a_body1Catch1(end_of_stream(), std::max(0, loopDepth - 1));
															#line 1086 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 148 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		if (!(i < self->pipelinedReaders.size()))
															#line 1101 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 149 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->pipelinedReaders[i]->done();
															#line 149 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		if (static_cast<MutationLogReader_GetNext_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1109 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MutationLogReader_GetNext_implActor*>(this)->actor_wait_state = 1;
															#line 149 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MutationLogReader_GetNext_implActor, 0, Void >*>(static_cast<MutationLogReader_GetNext_implActor*>(this)));
															#line 1114 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 148 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		++i;
															#line 1136 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 148 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		++i;
															#line 1145 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MutationLogReader_GetNext_implActor*>(this)->actor_wait_state > 0) static_cast<MutationLogReader_GetNext_implActor*>(this)->actor_wait_state = 0;
		static_cast<MutationLogReader_GetNext_implActor*>(this)->ActorCallback< MutationLogReader_GetNext_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MutationLogReader_GetNext_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutationLogReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MutationLogReader_GetNext_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutationLogReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MutationLogReader_GetNext_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutationLogReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 173 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		if (ret.size() != 0)
															#line 1229 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		{
															#line 174 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			if (!static_cast<MutationLogReader_GetNext_implActor*>(this)->SAV<Standalone<RangeResultRef>>::futures) { (void)(ret); this->~MutationLogReader_GetNext_implActorState(); static_cast<MutationLogReader_GetNext_implActor*>(this)->destroy(); return 0; }
															#line 1233 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			new (&static_cast<MutationLogReader_GetNext_implActor*>(this)->SAV< Standalone<RangeResultRef> >::value()) Standalone<RangeResultRef>(std::move(ret)); // state_var_RVO
			this->~MutationLogReader_GetNext_implActorState();
			static_cast<MutationLogReader_GetNext_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 164 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 1254 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			{
															#line 165 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
				++self->finished;
															#line 1258 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			}
			else
			{
															#line 167 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1264 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(mutation_log_reader::RangeResultBlock const& next,int loopDepth) 
	{
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		self->priorityQueue.push(next);
															#line 1280 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(mutation_log_reader::RangeResultBlock && next,int loopDepth) 
	{
															#line 162 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		self->priorityQueue.push(next);
															#line 1289 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(mutation_log_reader::RangeResultBlock const& next,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(next, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(mutation_log_reader::RangeResultBlock && next,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(next), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MutationLogReader_GetNext_implActor*>(this)->actor_wait_state > 0) static_cast<MutationLogReader_GetNext_implActor*>(this)->actor_wait_state = 0;
		static_cast<MutationLogReader_GetNext_implActor*>(this)->ActorSingleCallback< MutationLogReader_GetNext_implActor, 1, mutation_log_reader::RangeResultBlock >::remove();

	}
	void a_callback_fire(ActorSingleCallback< MutationLogReader_GetNext_implActor, 1, mutation_log_reader::RangeResultBlock >*,mutation_log_reader::RangeResultBlock const& value) 
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutationLogReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< MutationLogReader_GetNext_implActor, 1, mutation_log_reader::RangeResultBlock >*,mutation_log_reader::RangeResultBlock && value) 
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutationLogReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< MutationLogReader_GetNext_implActor, 1, mutation_log_reader::RangeResultBlock >*,Error err) 
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutationLogReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	MutationLogReader* self;
															#line 147 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	int i;
															#line 156 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	Standalone<RangeResultRef> ret;
															#line 1388 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
};
// This generated class is to be used only via getNext_impl()
															#line 144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
class MutationLogReader_GetNext_implActor final : public Actor<Standalone<RangeResultRef>>, public ActorCallback< MutationLogReader_GetNext_implActor, 0, Void >, public ActorSingleCallback< MutationLogReader_GetNext_implActor, 1, mutation_log_reader::RangeResultBlock >, public FastAllocated<MutationLogReader_GetNext_implActor>, public MutationLogReader_GetNext_implActorState<MutationLogReader_GetNext_implActor> {
															#line 1393 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
public:
	using FastAllocated<MutationLogReader_GetNext_implActor>::operator new;
	using FastAllocated<MutationLogReader_GetNext_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7982789697924186368UL, 3081553343312943872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<RangeResultRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MutationLogReader_GetNext_implActor, 0, Void >;
friend struct ActorSingleCallback< MutationLogReader_GetNext_implActor, 1, mutation_log_reader::RangeResultBlock >;
															#line 144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	MutationLogReader_GetNext_implActor(MutationLogReader* const& self) 
															#line 1411 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		 : Actor<Standalone<RangeResultRef>>(),
		   MutationLogReader_GetNext_implActorState<MutationLogReader_GetNext_implActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNext_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9234657846684794368UL, 2585624484649319936UL);
		ActorExecutionContextHelper __helper(static_cast<MutationLogReader_GetNext_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNext_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNext_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MutationLogReader_GetNext_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< MutationLogReader_GetNext_implActor, 1, mutation_log_reader::RangeResultBlock >*)0, actor_cancelled()); break;
		}

	}
};
															#line 144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
[[nodiscard]] Future<Standalone<RangeResultRef>> MutationLogReader::getNext_impl( MutationLogReader* const& self ) {
															#line 144 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	return Future<Standalone<RangeResultRef>>(new MutationLogReader_GetNext_implActor(self));
															#line 1444 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
}

#line 178 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"

namespace {
// UNIT TESTS
															#line 1451 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
// This generated class is to be used only via flowTestCase181()
															#line 181 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
template <class FlowTestCase181Actor>
															#line 181 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
class FlowTestCase181ActorState {
															#line 1457 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
public:
															#line 181 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	FlowTestCase181ActorState(UnitTestParameters const& params) 
															#line 181 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
															#line 181 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
		 : params(params)
															#line 1464 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase181", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase181ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase181", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 182 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			Key prefix = "foos"_sr;
															#line 184 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			ASSERT(keyRefToVersion(versionToKey(0, prefix), prefix.size()) == 0);
															#line 185 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			ASSERT(keyRefToVersion(versionToKey(1, prefix), prefix.size()) == 1);
															#line 186 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			ASSERT(keyRefToVersion(versionToKey(-1, prefix), prefix.size()) == -1);
															#line 187 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			ASSERT(keyRefToVersion(versionToKey(std::numeric_limits<int64_t>::min(), prefix), prefix.size()) == std::numeric_limits<int64_t>::min());
															#line 189 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			ASSERT(keyRefToVersion(versionToKey(std::numeric_limits<int64_t>::max(), prefix), prefix.size()) == std::numeric_limits<int64_t>::max());
															#line 192 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
			if (!static_cast<FlowTestCase181Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase181ActorState(); static_cast<FlowTestCase181Actor*>(this)->destroy(); return 0; }
															#line 1491 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
			new (&static_cast<FlowTestCase181Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase181ActorState();
			static_cast<FlowTestCase181Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase181ActorState();
		static_cast<FlowTestCase181Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 181 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	UnitTestParameters params;
															#line 1515 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase181()
															#line 181 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
class FlowTestCase181Actor final : public Actor<Void>, public FastAllocated<FlowTestCase181Actor>, public FlowTestCase181ActorState<FlowTestCase181Actor> {
															#line 1520 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase181Actor>::operator new;
	using FastAllocated<FlowTestCase181Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10436398333190244864UL, 2544553578403716864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 181 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	FlowTestCase181Actor(UnitTestParameters const& params) 
															#line 1536 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase181ActorState<FlowTestCase181Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase181", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(989090039673791232UL, 13530194818726815232UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase181Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase181");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase181", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 181 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
static Future<Void> flowTestCase181( UnitTestParameters const& params ) {
															#line 181 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
	return Future<Void>(new FlowTestCase181Actor(params));
															#line 1567 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/build_output/fdbclient/MutationLogReader.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase181, "/fdbclient/mutationlogreader/VersionKeyRefConversion")

#line 194 "/codebuild/output/src332181838/src/github.com/apple/foundationdb/fdbclient/MutationLogReader.actor.cpp"
} // namespace

void forceLinkMutationLogReaderTests() {}
